/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx.skins;

import com.dlsc.pickerfx.Picker;
import com.dlsc.pickerfx.Segment;
import java.util.Collection;
import java.util.Collections;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class PickerSkinBase<T extends Picker<?>>
extends SkinBase<T> {
    private Pane container;
    private final Region indicator = new Region();
    private final Region topShadow = new Region();
    private final Region bottomShadow = new Region();

    public PickerSkinBase(T picker) {
        super(picker);
        this.indicator.getStyleClass().add((Object)"indicator");
        this.indicator.setManaged(false);
        this.indicator.setMouseTransparent(true);
        this.indicator.visibleProperty().bind((ObservableValue)((Picker)((Object)picker)).showIndicatorProperty());
        this.topShadow.setManaged(false);
        this.topShadow.getStyleClass().addAll((Object[])new String[]{"shadow", "top"});
        this.topShadow.setMouseTransparent(true);
        this.bottomShadow.setManaged(false);
        this.bottomShadow.getStyleClass().addAll((Object[])new String[]{"shadow", "bottom"});
        this.bottomShadow.setMouseTransparent(true);
        ((Picker)((Object)picker)).orientationProperty().addListener(it -> this.buildView());
        this.buildView();
    }

    private void buildView() {
        ObservableList children = Collections.emptyList();
        if (this.container != null) {
            children = this.container.getChildren();
        }
        if (((Picker)this.getSkinnable()).getOrientation().equals((Object)Orientation.VERTICAL)) {
            HBox hBox = new HBox();
            hBox.getStyleClass().add((Object)"container");
            hBox.setFillHeight(true);
            hBox.setAlignment(Pos.CENTER);
            this.container = hBox;
        } else {
            VBox vBox = new VBox();
            vBox.getStyleClass().add((Object)"container");
            vBox.setFillWidth(true);
            vBox.setAlignment(Pos.CENTER);
            this.container = vBox;
        }
        this.container.getChildren().setAll((Collection)children);
        this.getChildren().setAll((Object[])new Node[]{this.container, this.topShadow, this.bottomShadow, this.indicator});
    }

    protected Pane getContainer() {
        return this.container;
    }

    protected void add(Segment<?, ?> segment) {
        this.container.getChildren().add(segment);
    }

    protected void add(Node node) {
        this.container.getChildren().add((Object)node);
    }

    protected void clear() {
        this.container.getChildren().clear();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        if (((Picker)this.getSkinnable()).getOrientation().equals((Object)Orientation.VERTICAL)) {
            double middle = contentY + contentHeight / 2.0;
            double indicatorSize = ((Picker)this.getSkinnable()).getIndicatorSize();
            this.indicator.resizeRelocate(contentX, middle - indicatorSize / 2.0, contentWidth, indicatorSize);
            double ps = this.topShadow.prefHeight(-1.0);
            this.topShadow.resizeRelocate(contentX, contentY, contentWidth, ps);
            ps = this.bottomShadow.prefHeight(-1.0);
            this.bottomShadow.resizeRelocate(contentX, contentY + contentHeight - ps, contentWidth, ps);
        } else {
            double middle = contentX + contentWidth / 2.0;
            double indicatorSize = ((Picker)this.getSkinnable()).getIndicatorSize();
            this.indicator.resizeRelocate(middle - indicatorSize / 2.0, contentY, indicatorSize, contentHeight);
            double ps = this.topShadow.prefWidth(-1.0);
            this.topShadow.resizeRelocate(contentX, contentY, ps, contentHeight);
            ps = this.bottomShadow.prefWidth(-1.0);
            this.bottomShadow.resizeRelocate(contentX + contentWidth - ps, contentY, ps, contentHeight);
        }
    }

    public static class SegmentSeparator
    extends Region {
        public SegmentSeparator() {
            this.getStyleClass().add((Object)"segment-separator");
            this.setMaxHeight(Double.MAX_VALUE);
            HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        }
    }
}

