/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx.skins;

import com.dlsc.pickerfx.DigitsSegment;
import com.dlsc.pickerfx.IntegerPicker;
import com.dlsc.pickerfx.Picker;
import com.dlsc.pickerfx.skins.PickerSkinBase;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.Node;

public class IntegerPickerSkin
extends PickerSkinBase<IntegerPicker> {
    private List<DigitsSegment> digitsPickerList = new ArrayList<DigitsSegment>();
    private InvalidationListener updateValueListener = it -> this.updateValue();
    private WeakInvalidationListener weakUpdateValueListener = new WeakInvalidationListener(this.updateValueListener);
    private boolean updatingValue;

    public IntegerPickerSkin(IntegerPicker picker) {
        super(picker);
        InvalidationListener buildListener = it -> this.buildView();
        picker.numberOfDigitsProperty().addListener(buildListener);
        picker.valueProperty().addListener(it -> this.updateSegments());
        this.buildView();
        this.updateSegments();
    }

    private void buildView() {
        this.clear();
        this.digitsPickerList.clear();
        int numberOfDigits = ((IntegerPicker)this.getSkinnable()).getNumberOfDigits();
        for (int i = 0; i < numberOfDigits; ++i) {
            DigitsSegment digitsPicker = new DigitsSegment((Picker)this.getSkinnable());
            digitsPicker.cellFactoryProperty().bind(((IntegerPicker)this.getSkinnable()).cellFactoryProperty());
            digitsPicker.setValue(0);
            digitsPicker.valueProperty().addListener((InvalidationListener)this.weakUpdateValueListener);
            this.digitsPickerList.add(digitsPicker);
            this.add(digitsPicker);
            if (i >= numberOfDigits - 1) continue;
            this.add((Node)new PickerSkinBase.SegmentSeparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue() {
        try {
            this.updatingValue = true;
            long power = this.digitsPickerList.size() - 1;
            int value = 0;
            for (DigitsSegment segment : this.digitsPickerList) {
                Integer v = (Integer)segment.getValue();
                if (v == null) {
                    v = 0;
                }
                value += v * (int)Math.pow(10.0, power--);
            }
            ((IntegerPicker)this.getSkinnable()).setValue(value);
        }
        finally {
            this.updatingValue = false;
        }
    }

    private void updateSegments() {
        if (!this.updatingValue) {
            Integer value = (Integer)((IntegerPicker)this.getSkinnable()).getValue();
            if (value == null) {
                value = 0;
            }
            String valueStr = String.valueOf(value);
            char[] chars = valueStr.toCharArray();
            int i = chars.length - 1;
            for (int j = this.digitsPickerList.size() - 1; i >= 0 && j >= 0; --i, --j) {
                int val = Integer.valueOf(String.valueOf(chars[i]));
                DigitsSegment segment = this.digitsPickerList.get(j);
                segment.setValue(val);
            }
        }
    }
}

