// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Frontend Frontend with all it's children resources
//
// swagger:model Frontend
type Frontend struct {
	FrontendBase `json:",inline"`

	// Acl list
	ACLList Acls `json:"acl_list,omitempty"`

	// backend switching rule list
	BackendSwitchingRuleList BackendSwitchingRules `json:"backend_switching_rule_list,omitempty"`

	// capture list
	CaptureList Captures `json:"capture_list,omitempty"`

	// filter list
	FilterList Filters `json:"filter_list,omitempty"`

	// HTTP after response rule list
	HTTPAfterResponseRuleList HTTPAfterResponseRules `json:"http_after_response_rule_list,omitempty"`

	// HTTP error rule list
	HTTPErrorRuleList HTTPErrorRules `json:"http_error_rule_list,omitempty"`

	// HTTP request rule list
	HTTPRequestRuleList HTTPRequestRules `json:"http_request_rule_list,omitempty"`

	// HTTP response rule list
	HTTPResponseRuleList HTTPResponseRules `json:"http_response_rule_list,omitempty"`

	// log target list
	LogTargetList LogTargets `json:"log_target_list,omitempty"`

	// TCP request rule list
	TCPRequestRuleList TCPRequestRules `json:"tcp_request_rule_list,omitempty"`

	// binds
	Binds map[string]Bind `json:"binds,omitempty"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *Frontend) UnmarshalJSON(raw []byte) error {
	// AO0
	var aO0 FrontendBase
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.FrontendBase = aO0

	// AO1
	var dataAO1 struct {
		ACLList Acls `json:"acl_list,omitempty"`

		BackendSwitchingRuleList BackendSwitchingRules `json:"backend_switching_rule_list,omitempty"`

		CaptureList Captures `json:"capture_list,omitempty"`

		FilterList Filters `json:"filter_list,omitempty"`

		HTTPAfterResponseRuleList HTTPAfterResponseRules `json:"http_after_response_rule_list,omitempty"`

		HTTPErrorRuleList HTTPErrorRules `json:"http_error_rule_list,omitempty"`

		HTTPRequestRuleList HTTPRequestRules `json:"http_request_rule_list,omitempty"`

		HTTPResponseRuleList HTTPResponseRules `json:"http_response_rule_list,omitempty"`

		LogTargetList LogTargets `json:"log_target_list,omitempty"`

		TCPRequestRuleList TCPRequestRules `json:"tcp_request_rule_list,omitempty"`

		Binds map[string]Bind `json:"binds,omitempty"`
	}
	if err := swag.ReadJSON(raw, &dataAO1); err != nil {
		return err
	}

	m.ACLList = dataAO1.ACLList

	m.BackendSwitchingRuleList = dataAO1.BackendSwitchingRuleList

	m.CaptureList = dataAO1.CaptureList

	m.FilterList = dataAO1.FilterList

	m.HTTPAfterResponseRuleList = dataAO1.HTTPAfterResponseRuleList

	m.HTTPErrorRuleList = dataAO1.HTTPErrorRuleList

	m.HTTPRequestRuleList = dataAO1.HTTPRequestRuleList

	m.HTTPResponseRuleList = dataAO1.HTTPResponseRuleList

	m.LogTargetList = dataAO1.LogTargetList

	m.TCPRequestRuleList = dataAO1.TCPRequestRuleList

	m.Binds = dataAO1.Binds

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m Frontend) MarshalJSON() ([]byte, error) {
	_parts := make([][]byte, 0, 2)

	aO0, err := swag.WriteJSON(m.FrontendBase)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)
	var dataAO1 struct {
		ACLList Acls `json:"acl_list,omitempty"`

		BackendSwitchingRuleList BackendSwitchingRules `json:"backend_switching_rule_list,omitempty"`

		CaptureList Captures `json:"capture_list,omitempty"`

		FilterList Filters `json:"filter_list,omitempty"`

		HTTPAfterResponseRuleList HTTPAfterResponseRules `json:"http_after_response_rule_list,omitempty"`

		HTTPErrorRuleList HTTPErrorRules `json:"http_error_rule_list,omitempty"`

		HTTPRequestRuleList HTTPRequestRules `json:"http_request_rule_list,omitempty"`

		HTTPResponseRuleList HTTPResponseRules `json:"http_response_rule_list,omitempty"`

		LogTargetList LogTargets `json:"log_target_list,omitempty"`

		TCPRequestRuleList TCPRequestRules `json:"tcp_request_rule_list,omitempty"`

		Binds map[string]Bind `json:"binds,omitempty"`
	}

	dataAO1.ACLList = m.ACLList

	dataAO1.BackendSwitchingRuleList = m.BackendSwitchingRuleList

	dataAO1.CaptureList = m.CaptureList

	dataAO1.FilterList = m.FilterList

	dataAO1.HTTPAfterResponseRuleList = m.HTTPAfterResponseRuleList

	dataAO1.HTTPErrorRuleList = m.HTTPErrorRuleList

	dataAO1.HTTPRequestRuleList = m.HTTPRequestRuleList

	dataAO1.HTTPResponseRuleList = m.HTTPResponseRuleList

	dataAO1.LogTargetList = m.LogTargetList

	dataAO1.TCPRequestRuleList = m.TCPRequestRuleList

	dataAO1.Binds = m.Binds

	jsonDataAO1, errAO1 := swag.WriteJSON(dataAO1)
	if errAO1 != nil {
		return nil, errAO1
	}
	_parts = append(_parts, jsonDataAO1)
	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this frontend
func (m *Frontend) Validate(formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with FrontendBase
	if err := m.FrontendBase.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateACLList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackendSwitchingRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCaptureList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilterList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPAfterResponseRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPErrorRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPRequestRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPResponseRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogTargetList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPRequestRuleList(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBinds(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Frontend) validateACLList(formats strfmt.Registry) error {

	if swag.IsZero(m.ACLList) { // not required
		return nil
	}

	if err := m.ACLList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("acl_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("acl_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateBackendSwitchingRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.BackendSwitchingRuleList) { // not required
		return nil
	}

	if err := m.BackendSwitchingRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("backend_switching_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("backend_switching_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateCaptureList(formats strfmt.Registry) error {

	if swag.IsZero(m.CaptureList) { // not required
		return nil
	}

	if err := m.CaptureList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("capture_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("capture_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateFilterList(formats strfmt.Registry) error {

	if swag.IsZero(m.FilterList) { // not required
		return nil
	}

	if err := m.FilterList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("filter_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("filter_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateHTTPAfterResponseRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPAfterResponseRuleList) { // not required
		return nil
	}

	if err := m.HTTPAfterResponseRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_after_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_after_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateHTTPErrorRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPErrorRuleList) { // not required
		return nil
	}

	if err := m.HTTPErrorRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_error_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_error_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateHTTPRequestRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPRequestRuleList) { // not required
		return nil
	}

	if err := m.HTTPRequestRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_request_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_request_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateHTTPResponseRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.HTTPResponseRuleList) { // not required
		return nil
	}

	if err := m.HTTPResponseRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateLogTargetList(formats strfmt.Registry) error {

	if swag.IsZero(m.LogTargetList) { // not required
		return nil
	}

	if err := m.LogTargetList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("log_target_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("log_target_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateTCPRequestRuleList(formats strfmt.Registry) error {

	if swag.IsZero(m.TCPRequestRuleList) { // not required
		return nil
	}

	if err := m.TCPRequestRuleList.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("tcp_request_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("tcp_request_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) validateBinds(formats strfmt.Registry) error {

	if swag.IsZero(m.Binds) { // not required
		return nil
	}

	for k := range m.Binds {

		if err := validate.Required("binds"+"."+k, "body", m.Binds[k]); err != nil {
			return err
		}
		if val, ok := m.Binds[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("binds" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("binds" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this frontend based on the context it is used
func (m *Frontend) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with FrontendBase
	if err := m.FrontendBase.ContextValidate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateACLList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBackendSwitchingRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCaptureList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilterList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPAfterResponseRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPErrorRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPRequestRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPResponseRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogTargetList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTCPRequestRuleList(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBinds(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Frontend) contextValidateACLList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.ACLList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("acl_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("acl_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateBackendSwitchingRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.BackendSwitchingRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("backend_switching_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("backend_switching_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateCaptureList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.CaptureList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("capture_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("capture_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateFilterList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.FilterList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("filter_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("filter_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateHTTPAfterResponseRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPAfterResponseRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_after_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_after_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateHTTPErrorRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPErrorRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_error_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_error_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateHTTPRequestRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPRequestRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_request_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_request_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateHTTPResponseRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HTTPResponseRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("http_response_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("http_response_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateLogTargetList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.LogTargetList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("log_target_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("log_target_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateTCPRequestRuleList(ctx context.Context, formats strfmt.Registry) error {

	if err := m.TCPRequestRuleList.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("tcp_request_rule_list")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("tcp_request_rule_list")
		}
		return err
	}

	return nil
}

func (m *Frontend) contextValidateBinds(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Binds {

		if val, ok := m.Binds[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Frontend) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Frontend) UnmarshalBinary(b []byte) error {
	var res Frontend
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
