# Contributing to PlantUML



## I Have a Question

> If you want to ask a question, we assume that you have read the available [Documentation](https://plantuml.com).

Before you ask a question, it is best to search for
existing issues [on github](https://github.com/plantuml/plantuml/issues) 
or on [the online forum](https://forum.plantuml.net)
that might help you.

In case you have found a suitable issue and still need clarification, you can write your question in this issue.
It is also advisable to search the internet for answers first.

If you then still feel the need to ask a question and need clarification, we recommend the following:

- Open an issue [on github](https://github.com/plantuml/plantuml/issues/new) or on the
  [the online forum](https://forum.plantuml.net/ask).
- Provide as much context as you can about what you're running into.
- Provide a short example that shows the issue.
- Provide which version you are using and if you are using PlantUML through a plugin.

We will then take care of the issue as soon as possible.


## I Want To Contribute


### Reporting Bugs

#### Before Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you up for more information. Therefore, we ask you to investigate carefully, collect information and describe the issue in detail in your report. Please complete the following steps in advance to help us fix any potential bug as fast as possible.

- Make sure that you are using the latest version.
- Also make sure to search the internet (including Stack Overflow) to see if users outside of the GitHub community have discussed the issue.


#### How Do I Submit a Good Bug Report?

We use GitHub issues to track bugs and errors. If you run into an issue with the project:

Before you ask a question, it is best to search for
existing issues [on github](https://github.com/plantuml/plantuml/issues) 
or on [the online forum](https://forum.plantuml.net)


- Open an issue [on github](https://github.com/plantuml/plantuml/issues) 
or on [the online forum](https://forum.plantuml.net).
- Explain the behavior you would expect and the actual behavior.
- Please provide as much context as possible and describe the *reproduction steps* that someone else can follow to recreate the issue on their own. This usually includes your code.
- For good bug reports you should isolate the problem and create a reduced test case.


### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for
PlantUML, **including completely new features and minor improvements to existing functionality**. Following
these guidelines will help maintainers and the community to understand your suggestion and find related suggestions.

#### Before Submitting an Enhancement

- Make sure that you are using the latest version.
- Read the [documentation](https://plantuml.com) carefully and find out if the functionality is already covered, maybe by an individual configuration.
- Perform some search [on github issue](https://github.com/plantuml/plantuml/issues) or  [on the online forum](https://forum.plantuml.net) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of our users and not just a small subset. If you're just targeting a minority of users, consider writing an add-on/plugin library.

#### How Do I Submit a Good Enhancement Suggestion?

- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- You may want to **include some existing diagram examples** that would help to understand the suggestion.
- **Explain why this enhancement would be useful** to most PlantUML users. You may also want to point out the other projects that solved it better and which could serve as inspiration.


### Your First Code Contribution
<!-- TODO
include Setup of env, IDE and typical getting started instructions?

-->

### Improving The Documentation
<!-- TODO
Updating, improving and correcting the documentation

-->

### Improving non regression testing
<!-- TODO
-->

## Styleguides
### Commit Messages
<!-- TODO

-->
