/*========================== begin_copyright_notice ============================

Copyright (C) 2021-2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

//     File Name:  md_gfx_device_info.h
//
//     Abstract:   Device information for Linux.

#include "md_driver_ifc_linux_common.h"
#include <map>

using namespace MetricsDiscovery;

namespace MetricsDiscoveryInternal
{
    const std::map<int32_t, TPlatformIndexGt> platformIndexMap{
        { 0x0402, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0412, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0422, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0406, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0416, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0426, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x040A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x041A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x042A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x040B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x041B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x042B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x040E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x041E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x042E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0C02, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0C12, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0C22, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0C06, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0C16, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0C26, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0C0A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0C1A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0C2A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0C0B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0C1B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0C2B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0C0E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0C1E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0C2E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0A02, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0A12, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0A22, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0A06, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0A16, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0A26, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0A0A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0A1A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0A2A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0A0B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0A1B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0A2B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0A0E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0A1E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0A2E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0D02, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0D12, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0D22, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0D06, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0D16, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0D26, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0D0A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0D1A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0D2A, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0D0B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0D1B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0D2B, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },
        { 0x0D0E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT1 ) },
        { 0x0D1E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT2 ) },
        { 0x0D2E, TPlatformIndexGt( GENERATION_HSW, GFX_GTTYPE_GT3 ) },

        { 0x1602, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT1 ) },
        { 0x1606, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT1 ) },
        { 0x160A, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT1 ) },
        { 0x160B, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT1 ) },
        { 0x160D, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT1 ) },
        { 0x160E, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT1 ) },
        { 0x1612, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT2 ) },
        { 0x1616, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT2 ) },
        { 0x161A, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT2 ) },
        { 0x161B, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT2 ) },
        { 0x161D, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT2 ) },
        { 0x161E, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT2 ) },
        { 0x1622, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT3 ) },
        { 0x1626, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT3 ) },
        { 0x162A, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT3 ) },
        { 0x162B, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT3 ) },
        { 0x162D, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT3 ) },
        { 0x162E, TPlatformIndexGt( GENERATION_BDW, GFX_GTTYPE_GT3 ) },

        { 0x1902, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT1 ) },
        { 0x1906, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT1 ) },
        { 0x190A, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT1 ) },
        { 0x190B, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT1 ) },
        { 0x190E, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT1 ) },
        { 0x1912, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x1913, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x1915, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x1916, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x1917, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x191A, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x191B, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x191D, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x191E, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x1921, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT2 ) },
        { 0x1923, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT3 ) },
        { 0x1926, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT3 ) },
        { 0x1927, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT3 ) },
        { 0x192A, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT4 ) },
        { 0x192B, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT3 ) },
        { 0x192D, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT3 ) },
        { 0x1932, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT4 ) },
        { 0x193A, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT4 ) },
        { 0x193B, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT4 ) },
        { 0x193D, TPlatformIndexGt( GENERATION_SKL, GFX_GTTYPE_GT4 ) },

        { 0x0A84, TPlatformIndexGt( GENERATION_BXT, GFX_GTTYPE_UNDEFINED ) },
        { 0x1A84, TPlatformIndexGt( GENERATION_BXT, GFX_GTTYPE_UNDEFINED ) },
        { 0x1A85, TPlatformIndexGt( GENERATION_BXT, GFX_GTTYPE_UNDEFINED ) },
        { 0x5A84, TPlatformIndexGt( GENERATION_BXT, GFX_GTTYPE_UNDEFINED ) },
        { 0x5A85, TPlatformIndexGt( GENERATION_BXT, GFX_GTTYPE_UNDEFINED ) },

        { 0x3184, TPlatformIndexGt( GENERATION_GLK, GFX_GTTYPE_UNDEFINED ) },
        { 0x3185, TPlatformIndexGt( GENERATION_GLK, GFX_GTTYPE_UNDEFINED ) },

        { 0x5902, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT1 ) },
        { 0x5906, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT1 ) },
        { 0x590A, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT1 ) },
        { 0x5908, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT1 ) },
        { 0x590B, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT1 ) },
        { 0x590E, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT1 ) },
        { 0x5913, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x5915, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x5917, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x5912, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x5916, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x591A, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x591B, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x591D, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x591E, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x5921, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x5923, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT3 ) },
        { 0x5926, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT3 ) },
        { 0x5927, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT3 ) },
        { 0x593B, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT4 ) },
        { 0x591C, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },
        { 0x87C0, TPlatformIndexGt( GENERATION_KBL, GFX_GTTYPE_GT2 ) },

        { 0x87CA, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3E90, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x3E93, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x3E99, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x3E9C, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x3E91, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3E92, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3E96, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3E98, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3E9A, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3E9B, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3E94, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3EA9, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3EA5, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT3 ) },
        { 0x3EA6, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT3 ) },
        { 0x3EA7, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT3 ) },
        { 0x3EA8, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT3 ) },
        { 0x3EA1, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x3EA4, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x3EA0, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3EA3, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x3EA2, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT3 ) },
        { 0x9B21, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9BA0, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9BA2, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9BA4, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9BA5, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9BA8, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9BAA, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9BAB, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9BAC, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT1 ) },
        { 0x9B41, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BC0, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BC2, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BC4, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BC5, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BC6, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BC8, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BCA, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BCB, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BCC, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BE6, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },
        { 0x9BF6, TPlatformIndexGt( GENERATION_CFL, GFX_GTTYPE_GT2 ) },

        { 0x8A50, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT2 ) },
        { 0x8A51, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT2 ) },
        { 0x8A52, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT2 ) },
        { 0x8A53, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT2 ) },
        { 0x8A54, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A56, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A57, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A58, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A59, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A5A, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A5B, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A5C, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A5D, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0x8A71, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT1 ) },
        { 0xFF05, TPlatformIndexGt( GENERATION_ICL, GFX_GTTYPE_GT2 ) },

        { 0x4500, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4541, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4551, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4555, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4557, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4571, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4E51, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4E55, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4E57, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4E61, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },
        { 0x4E71, TPlatformIndexGt( GENERATION_EHL, GFX_GTTYPE_UNDEFINED ) },

        { 0x4C8A, TPlatformIndexGt( GENERATION_RKL, GFX_GTTYPE_GT1 ) },
        { 0x4C8B, TPlatformIndexGt( GENERATION_RKL, GFX_GTTYPE_GT1 ) },
        { 0x4C8C, TPlatformIndexGt( GENERATION_RKL, GFX_GTTYPE_GT1 ) },
        { 0x4C90, TPlatformIndexGt( GENERATION_RKL, GFX_GTTYPE_GT1 ) },
        { 0x4C9A, TPlatformIndexGt( GENERATION_RKL, GFX_GTTYPE_GT1 ) },

        { 0x4626, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x4628, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x462A, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46A0, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46A1, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46A2, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },

        { 0x46A3, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46A6, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46A8, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46AA, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },

        { 0x46B0, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46B1, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46B2, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46B3, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46C0, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46C1, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46C2, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0x46C3, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0xA7A0, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) }, // RPLP
        { 0xA720, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0xA7A8, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0xA7A1, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0xA721, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0xA7A9, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },

        { 0xA7AA, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) }, // RPLP refresh
        { 0xA7AB, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0xA7AC, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },
        { 0xA7AD, TPlatformIndexGt( GENERATION_ADLP, GFX_GTTYPE_GT2 ) },

        { 0x4680, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0x4682, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0x4688, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0x468A, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0x468B, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0x4690, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0x4692, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0x4693, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },

        { 0xA780, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) }, // RPLS
        { 0xA781, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0xA782, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0xA783, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0xA788, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0xA789, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0xA78A, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },
        { 0xA78B, TPlatformIndexGt( GENERATION_ADLS, GFX_GTTYPE_GT1 ) },

        { 0x46D0, TPlatformIndexGt( GENERATION_ADLN, GFX_GTTYPE_GT1 ) }, // ADLN
        { 0x46D1, TPlatformIndexGt( GENERATION_ADLN, GFX_GTTYPE_GT1 ) },
        { 0x46D2, TPlatformIndexGt( GENERATION_ADLN, GFX_GTTYPE_GT1 ) },
        { 0x46D3, TPlatformIndexGt( GENERATION_ADLN, GFX_GTTYPE_GT1 ) },
        { 0x46D4, TPlatformIndexGt( GENERATION_ADLN, GFX_GTTYPE_GT1 ) },

        { 0x9A40, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT2 ) },
        { 0x9A49, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT2 ) },
        { 0x9A59, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT2 ) },
        { 0x9A60, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT1 ) },
        { 0x9A68, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT1 ) },
        { 0x9A70, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT1 ) },
        { 0x9A78, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT2 ) },
        { 0x9AC0, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT2 ) },
        { 0x9AC9, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT2 ) },
        { 0x9AD9, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT2 ) },
        { 0x9AF8, TPlatformIndexGt( GENERATION_TGL, GFX_GTTYPE_GT2 ) },

        { 0x4905, TPlatformIndexGt( GENERATION_DG1, GFX_GTTYPE_UNDEFINED ) },
        { 0x4907, TPlatformIndexGt( GENERATION_DG1, GFX_GTTYPE_UNDEFINED ) },
        { 0x4908, TPlatformIndexGt( GENERATION_DG1, GFX_GTTYPE_UNDEFINED ) },
        { 0x4909, TPlatformIndexGt( GENERATION_DG1, GFX_GTTYPE_UNDEFINED ) },

        { 0x0BD0, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0BD4, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0BD5, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0BD6, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0BD7, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0BD8, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0BD9, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0BDA, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0BDB, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0B69, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },
        { 0x0B6E, TPlatformIndexGt( GENERATION_PVC, GFX_GTTYPE_UNDEFINED ) },

        { 0x4f80, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x4f81, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x4f82, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x4f83, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x4f84, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x4f85, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT2 ) },
        { 0x4f86, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT2 ) },
        { 0x4f87, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x4f88, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x5690, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x5691, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x5692, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x5693, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x5694, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x5695, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x5696, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT2 ) },
        { 0x5697, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT2 ) },
        { 0x56a0, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x56a1, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x56a2, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x56a3, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT2 ) },
        { 0x56a4, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT2 ) },
        { 0x56a5, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56a6, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56af, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x56b0, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56b1, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56b2, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT2 ) },
        { 0x56b3, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT2 ) },
        { 0x56ba, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56bb, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56bc, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56bd, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56be, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x56bf, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x56c0, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },
        { 0x56c1, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT1 ) },
        { 0x56c2, TPlatformIndexGt( GENERATION_ACM, GFX_GTTYPE_GT3 ) },

        { 0x7D40, TPlatformIndexGt( GENERATION_MTL, GFX_GTTYPE_GT2 ) },
        { 0x7D45, TPlatformIndexGt( GENERATION_MTL, GFX_GTTYPE_GT2 ) },
        { 0x7D55, TPlatformIndexGt( GENERATION_MTL, GFX_GTTYPE_GT3 ) },
        { 0x7D60, TPlatformIndexGt( GENERATION_MTL, GFX_GTTYPE_GT2 ) },
        { 0x7DD5, TPlatformIndexGt( GENERATION_MTL, GFX_GTTYPE_GT3 ) },

        { 0x7D41, TPlatformIndexGt( GENERATION_ARL, GFX_GTTYPE_GT1 ) },
        { 0x7D51, TPlatformIndexGt( GENERATION_ARL, GFX_GTTYPE_GT2 ) },
        { 0x7D67, TPlatformIndexGt( GENERATION_ARL, GFX_GTTYPE_GT1 ) },
        { 0x7DD1, TPlatformIndexGt( GENERATION_ARL, GFX_GTTYPE_GT2 ) },
        { 0xB640, TPlatformIndexGt( GENERATION_ARL, GFX_GTTYPE_GT1 ) },

        { 0xE202, TPlatformIndexGt( GENERATION_BMG, GFX_GTTYPE_UNDEFINED, 2 ) }, // G21
        { 0xE20B, TPlatformIndexGt( GENERATION_BMG, GFX_GTTYPE_UNDEFINED, 2 ) },
        { 0xE20C, TPlatformIndexGt( GENERATION_BMG, GFX_GTTYPE_UNDEFINED, 2 ) },
        { 0xE20D, TPlatformIndexGt( GENERATION_BMG, GFX_GTTYPE_UNDEFINED, 2 ) },
        { 0xE210, TPlatformIndexGt( GENERATION_BMG, GFX_GTTYPE_UNDEFINED, 2 ) },
        { 0xE212, TPlatformIndexGt( GENERATION_BMG, GFX_GTTYPE_UNDEFINED, 2 ) },
        { 0xE215, TPlatformIndexGt( GENERATION_BMG, GFX_GTTYPE_UNDEFINED, 2 ) },
        { 0xE216, TPlatformIndexGt( GENERATION_BMG, GFX_GTTYPE_UNDEFINED, 2 ) },

        { 0x64A0, TPlatformIndexGt( GENERATION_LNL, GFX_GTTYPE_UNDEFINED ) },
        { 0x6420, TPlatformIndexGt( GENERATION_LNL, GFX_GTTYPE_UNDEFINED ) },
        { 0x64B0, TPlatformIndexGt( GENERATION_LNL, GFX_GTTYPE_UNDEFINED ) },

        { 0xB080, TPlatformIndexGt( GENERATION_PTL, GFX_GTTYPE_UNDEFINED, 1 ) }, // H
        { 0xB081, TPlatformIndexGt( GENERATION_PTL, GFX_GTTYPE_UNDEFINED, 1 ) },
        { 0xB082, TPlatformIndexGt( GENERATION_PTL, GFX_GTTYPE_UNDEFINED, 1 ) },
        { 0xB083, TPlatformIndexGt( GENERATION_PTL, GFX_GTTYPE_UNDEFINED, 1 ) },
        { 0xB08F, TPlatformIndexGt( GENERATION_PTL, GFX_GTTYPE_UNDEFINED, 1 ) },

        { 0xB090, TPlatformIndexGt( GENERATION_PTL, GFX_GTTYPE_UNDEFINED, 2 ) }, // U

        { 0xB0A0, TPlatformIndexGt( GENERATION_PTL, GFX_GTTYPE_UNDEFINED, 2 ) }, // H
        { 0xB0B0, TPlatformIndexGt( GENERATION_PTL, GFX_GTTYPE_UNDEFINED, 1 ) },
    };

    const std::map<GTDI_PLATFORM_INDEX, uint32_t> threadsPerEuMap{
        { GENERATION_HSW, 7 },
        { GENERATION_BDW, 7 },
        { GENERATION_SKL, 7 },
        { GENERATION_BXT, 6 },
        { GENERATION_KBL, 7 },
        { GENERATION_GLK, 6 },
        { GENERATION_ICL, 7 },
        { GENERATION_TGL, 7 },
        { GENERATION_CFL, 7 },
        { GENERATION_EHL, 7 },
        { GENERATION_DG1, 7 },
        { GENERATION_RKL, 7 },
        { GENERATION_ADLP, 7 },
        { GENERATION_ADLS, 7 },
        { GENERATION_ADLN, 7 },
        { GENERATION_ACM, 8 },
        { GENERATION_PVC, 8 },
        { GENERATION_MTL, 8 },
        { GENERATION_ARL, 8 },
        { GENERATION_BMG, 8 },
        { GENERATION_LNL, 8 },
        { GENERATION_PTL, 10 },
    };

} // namespace MetricsDiscoveryInternal
