/*========================== begin_copyright_notice ============================

Copyright (C) 2024-2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

//     File Name:  md_external_events.cpp
//
//     Abstract:   C++ automated generated file defined architectural events

#include "md_external_events.h"

#if MD_INCLUDE_BMG_METRICS || MD_INCLUDE_LNL_METRICS || MD_INCLUDE_PTL_METRICS

const char ExternalEvents::archEvents[33031] = "Group Mask,Event Encoding,Architectural Event Name,Event Definition,OA Reporting,Disaggregation Mode,Project,Group Name,Instance,Filter,Metric Result Units,Metric Type,Hw Unit Type,Normalization\n"
                                               "1,1,SAMPLER_MEMORY_LATENCY_STALL,Number of cycles Sampler stalled due to latency hiding structure full,RG,1,BMG LNL PTL,Sampler,xecore,,cycles,1,2,3\n"
                                               "1,2,SAMPLER_2X2_READ,Number of 2x2 texel block requested from Sampler,RG,1,BMG LNL PTL,Sampler,xecore,,events,1,2,2\n"
                                               "1,3,SAMPLER_INPUT_AVAILABLE,Number of cycles when Sampler input is available,RG,1,BMG LNL PTL,Sampler,xecore,,cycles,1,2,3\n"
                                               "1,4,SAMPLER_OUTPUT_READY,Number of cycles when Sampler output is ready,RG,1,BMG LNL PTL,Sampler,xecore,,cycles,1,2,3\n"
                                               "1,5,SAMPLER_TEXTURE_CACHE_MISS,Number of Sampler L1 misses,RG,1,BMG LNL PTL,Sampler,xecore,,events,1,2,2\n"
                                               "1,6,SAMPLER_TEXTURE_CACHE_ACCESS,Number of Sampler L1 requests,RG,1,BMG LNL PTL,Sampler,xecore,,events,1,2,2\n"
                                               "1,7,SAMPLER_ACTIVE_CYCLES,Number of cycles Sampler pipeline active,RG,1,BMG LNL PTL,Sampler,xecore,,cycles,1,2,3\n"
                                               "1,1024,SHADER_PIX_KILL,Number of pixels that were lit from Rasterizer but killed by the Pixel Shader,RG,1,BMG LNL PTL,Color Pipe,xecore,,events,1,2,2\n"
                                               "1,1025,PS_OUTPUT_AVAILABLE,Number of cycles Pixel Shader data is available,RG,1,BMG LNL PTL,Color Pipe,xecore,,cycles,1,2,3\n"
                                               "1,1026,POSTPS_ALPHA_TEST_FAIL,Number of 2x2 that were lit from Rasterizer but failed the alpha test,RG,1,BMG LNL PTL,Color Pipe,xecore,,events,1,2,2\n"
                                               "1,1536,EU_SHARED_FUNCTION_ACCESS_HOLD,Number of cycles EU requests stalled by Shared Function units,RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "5,1537,EU_INST_EXECUTED_SEND_ALL,Number of instruction (GRF) dispatches executed on SEND Pipe,RCG,1,BMG LNL PTL,Vector Engine,eu,Flex:16191,events,1,4,2\n"
                                               "1,1538,EU_INST_EXECUTED_CONTROL_ALL,Number of instructions executed on JEU Pipe,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "5,1539,EU_INST_EXECUTED_ALU1_ALL,Number of execution slots taken by instructions executed on ALU1 pipe. Does not include extended math instructions.,RCG,1,BMG LNL PTL,Vector Engine,eu,Flex:16191,events,1,4,3\n"
                                               "5,1540,EU_THREADS_OCCUPANCY_ALL,Number of thread slots occupied,RCG,1,BMG LNL PTL,Vector Engine,thread,Flex:305,events,1,0,3\n"
                                               "5,1541,EU_ACTIVE_CYCLES,Number of cycles at least one pipe is active in EU,RCG,1,BMG LNL PTL,Vector Engine,eu,Flex:3903,cycles,1,4,3\n"
                                               "5,1542,EU_STALL_CYCLES,Number of cycles any thread loaded but not even a single pipe is active in EU,RCG,1,BMG LNL PTL,Vector Engine,eu,Flex:3903,cycles,1,4,3\n"
                                               "1,1543,EU_INST_EXECUTED_BITCONV,Number of execution slots taken by bit manipulation instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1544,EU_INST_EXECUTED_BARRIER,Number of sync.bar and sync.host instructions executed,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1545,EU_INST_EXECUTED_PREDICATION,Number of instructions (not execution slots) executed with predication mask enabled,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1546,EU_INST_EXECUTED_NONDIVERGENT,Number of non-divergent instructions (not execution slots) executed,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1547,EU_INST_ISSUED_ALL,Number of instructions issued (decoded) to any pipe,RCG,1,BMG LNL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1547,EU_INST_ISSUED_ALL,Number of instructions issued (decoded) to any pipe (does not include the Scalar pipe),RCG,1,PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1548,EU_INST_EXECUTED_INT16,Number of execution slots taken by INT16 ALU instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1549,EU_INST_EXECUTED_INT32,Number of execution slots taken by INT32 ALU instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1550,EU_INST_EXECUTED_MATH,Number of execution slots taken by extended math instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "5,1551,EU_INST_EXECUTED_ALU0_ALL,Number of execution slots taken by instructions executed on ALU0 pipe,RCG,1,BMG LNL PTL,Vector Engine,eu,Flex:16191,events,1,4,3\n"
                                               "1,1552,EU_INST_EXECUTED_FP32,Number of execution slots taken by FP32 ALU instructions. Does not include extended math instructions.,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1553,EU_INST_EXECUTED_FP16,Number of execution slots taken by FP16 ALU instructions. Does not include extended math instructions.,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1554,EU_INST_EXECUTED_FP64,Number of execution slots taken by FP64 ALU instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1555,EU_INST_EXECUTED_INT64,Number of execution slots taken by INT64 instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1556,EU_INST_EXECUTED_ALU2_ALL,Number of execution slots taken by instructions executed in ALU2 pipe,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,3\n"
                                               "1,1557,EU_INST_EXECUTED_SYSTOLIC_FP16,Number of execution slots taken by FP16 systolic instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1558,EU_INST_EXECUTED_SYSTOLIC_BF16,Number of execution slots taken by BF16 systolic instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1559,EU_INST_EXECUTED_SYSTOLIC_INT8,Number of execution slots taken by INT8 systolic instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1560,EU_INST_EXECUTED_SYSTOLIC_INT4,Number of execution slots taken by INT4 DPAS instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1561,EU_INST_EXECUTED_SYSTOLIC_INT2,Number of execution slots taken by INT2 DPAS instructions,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,1562,EU_STALL_INSTFETCH_CYCLES,\"Number of cycles EU stalled, with at least one thread waiting for Instruction Fetch. Multiple stall reasons can qualify during the same cycle\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1563,EU_STALL_BARRIER_CYCLES,\"Number of cycles EU stalled, with at least one thread waiting for Gateway to write Notify register. Multiple stall reasons can qualify during the same cycle\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1564,EU_STALL_SBID_CYCLES,\"Number of cycles EU stalled, with at least one thread waiting for Scoreboard token to be available. Multiple stall reasons can qualify during the same cycle\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1565,EU_STALL_ALUWR_CYCLES,\"Number of cycles EU stalled, with at least one thread waiting for ALU to write GRF/ACC register. Multiple stall reasons can qualify during the same cycle\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1566,EU_STALL_SENDWR_CYCLES,\"Number of cycles EU stalled, with at least one thread waiting for SEND message to be dispatched from EU. Multiple stall reasons can qualify during the same cycle\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1567,EU_STALL_PIPESTALL_CYCLES,\"Number of cycles EU stalled, with at least one thread ready to be scheduled (Grf conf/send holds etc). Multiple stall reasons can qualify during the same cycle\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1568,EU_STALL_CONTROL_CYCLES,\"Number of cycles EU stalled, with at least one thread waiting for JEU to complete branch instruction. Multiple stall reasons can qualify during the same cycle\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1569,EU_STALL_OTHER_CYCLES,\"Number of cycles EU stalled, with at least one thread waiting on any other dependency (Flag/EoT etc). Multiple stall reasons can qualify during the same cycle\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1570,ICACHE_HIT,Number of Instruction Cache hits,RCG,1,BMG LNL PTL,Vector Engine,xecore,,events,1,2,2\n"
                                               "1,1571,ICACHE_MISS,Number of Instruction Cache misses,RCG,1,BMG LNL PTL,Vector Engine,xecore,,events,1,2,2\n"
                                               "1,1572,EU_MULTIPLE_PIPE_ACTIVE_CYCLES,\"Number of cycles at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and ALU2 pipes\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1573,EU_PIPE_ALU0_AND_ALU1_ACTIVE_CYCLES,Number of cycles ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction,RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1574,EU_PIPE_ALU0_AND_ALU2_ACTIVE_CYCLES,Number of cycles ALU0 and ALU2 pipes are both actively executing a Gen ISA instruction,RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1576,EU_STALL_PS_DEPENDENCY_CYCLES,\"Number of cycles EU stalled, with at least one thread waiting on Pixel Shader dependency\",RCG,1,BMG LNL PTL,Vector Engine,eu,,cycles,1,4,3\n"
                                               "1,1577,EU_INST_EXECUTED_FP64_2ND,Number of execution slots taken by FP64 ALU instructions executed in the second pipe,RCG,1,BMG LNL PTL,Vector Engine,eu,,events,1,4,2\n"
                                               "1,2560,EU_LOAD_STORE_CACHE_READ_MESSAGE_COUNT,Number of read messages sent by EUs to the Load Store Cache,RCG,1,BMG LNL PTL,L1 Cache,xecore,,messages,1,2,2\n"
                                               "1,2561,EU_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT,Number of write messages sent by EUs to the Load Store Cache,RCG,1,BMG LNL PTL,L1 Cache,xecore,,messages,1,2,2\n"
                                               "1,2562,EU_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT,Number of atomic operations sent by EUs to the Load Store Cache,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2563,EU_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT,Number of fence messages sent by EUs to the Load Store Cache,RCG,1,BMG LNL PTL,L1 Cache,xecore,,messages,1,2,2\n"
                                               "1,2564,EU_SLM_READ_MESSAGE_COUNT,Number of SLM read messages sent by EUs,RCG,1,BMG LNL PTL,L1 Cache,xecore,,messages,1,2,2\n"
                                               "1,2565,EU_SLM_WRITE_MESSAGE_COUNT,Number of SLM write messages sent by EUs,RCG,1,BMG LNL PTL,L1 Cache,xecore,,messages,1,2,2\n"
                                               "1,2566,EU_SLM_ATOMIC_MESSAGE_COUNT,Number of SLM atomic operations sent by EUs,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2567,EU_SLM_FENCE_MESSAGE_COUNT,Number of SLM fence operations sent by EUs,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2568,RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT,Number of read messages sent from Ray Tracing unit to the Load Store Cache,RCG,1,BMG LNL PTL,L1 Cache,xecore,,messages,1,2,2\n"
                                               "1,2569,RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT,Number of write messages sent from Ray Tracing unit to the Load Store Cache,RCG,1,BMG LNL PTL,L1 Cache,xecore,,messages,1,2,2\n"
                                               "1,2570,LOAD_STORE_CACHE_HIT,Number of Load Store Cache hits,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2571,LOAD_STORE_CACHE_ACCESS,Number of Load Store Cache accesses,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2572,LOAD_STORE_CACHE_NUMBER_OF_BANK_ACCESS_COUNT,Number of Load Store Cache banks accessed in a clock,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2573,SLM_BANK_CONFLICT_COUNT,Number of SLM accesses resulting in a bank conflict,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2574,LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT,Number of writes to the Load Store Cache that don't fill a subsector,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2575,EU_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT,Number of message payload transactions sent by EUs to the Load Store Cache,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2576,EU_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT,Number of message payload transactions sent from the Load Store Cache back to EUs,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,2577,LOAD_STORE_CACHE_INPUT_AVAILABLE,Number of cycles the Load Store Cache has input available,RCG,1,BMG LNL PTL,L1 Cache,xecore,,cycles,1,2,3\n"
                                               "1,2578,LOAD_STORE_CACHE_OUTPUT_READY,Number of cycles the Load Store Cache has output ready,RCG,1,BMG LNL PTL,L1 Cache,xecore,,cycles,1,2,3\n"
                                               "1,2579,LOAD_STORE_CACHE_BYTE_READ,\"Number of bytes read out of the Load Store Cache, excluding SLM accesses\",RCG,1,BMG LNL PTL,L1 Cache,xecore,,bytes,1,2,6\n"
                                               "1,2580,LOAD_STORE_CACHE_BYTE_WRITE,\"Number of bytes written to the Load Store Cache, excluding SLM accesses\",RCG,1,BMG LNL PTL,L1 Cache,xecore,,bytes,1,2,6\n"
                                               "1,2581,SLM_BYTE_READ,Number of bytes read from SLM,RCG,1,BMG LNL PTL,L1 Cache,xecore,,bytes,1,2,6\n"
                                               "1,2582,SLM_BYTE_WRITE,Number of bytes written to SLM,RCG,1,BMG LNL PTL,L1 Cache,xecore,,bytes,1,2,6\n"
                                               "1,2583,SLM_ACCESS_COUNT,Number of SLM accesses,RCG,1,BMG LNL PTL,L1 Cache,xecore,,events,1,2,2\n"
                                               "1,3072,RT_CLOSEST_HIT_THREAD_RAY_DISPATCH,Number of closest hit threads dispatched,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3073,RT_MISS_THREAD_RAY_DISPATCH,Number of miss threads dispatched,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3074,RT_INTERSECTION_THREAD_RAY_DISPATCH,Number of intersection threads dispatched,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3075,RT_ANY_HIT_THREAD_RAY_DISPATCH,Number of any hit threads dispatched,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3076,RT_CALLABLE_THREAD_RAY_DISPATCH,Number of BTD shader spawn requests dispatched,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3088,RT_BVH_CACHE_MISS,Number of BVH cache misses,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3096,RT_INPUT_MESSAGE_RAY_COUNT,Number of valid SIMD lanes in the TraceRay message,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3097,RT_MESSAGE_STALL_COUNT,Number of cycles when Ray Tracing message input is stalled while accepting input,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,cycles,1,2,3\n"
                                               "1,3098,RT_INPUT_MESSAGE_SPAWN_COUNT,Number of valid SIMD lanes in the Spawn message,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3101,RT_TRAVERSAL_STALL_COUNT,Number of cycles when Ray Tracing Frontend is stalled by Traversal,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,cycles,1,2,3\n"
                                               "1,3104,RT_REQUEST_COLLISION,Number of cycles when Ray Tracing Leaf has two Traversal inputs valid,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,cycles,1,2,3\n"
                                               "1,3112,RT_TRAVERSAL_INPUT_RAY_COUNT,Number of Ray Tracing Traversal input rays,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3113,RT_TRAVERSAL_OUTPUT_RAY_COUNT,Number of Ray Tracing Traversal output rays,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3114,RT_TRAVERSAL_STEP_RAY_COUNT,Number of BVH nodes processed,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3115,RT_QUAD_TEST_RAY_COUNT,Number of nodes processed that use ray-quad intersection pipeline,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3116,RT_TRANSFORM_RAY_COUNT,Number of only HW transform accesses,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3117,RT_INTERNAL_NODE_RAY_COUNT,Number of internal BVH nodes processed by the traversal function,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3118,RT_PROCEDURAL_NODE_RAY_COUNT,Number of procedural BVH nodes processed by the traversal function,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3119,RT_INSTANCE_NODE_RAY_COUNT,Number of instance BVH nodes processed by the traversal function,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3120,RT_QUAD_LEAF_RAY_COUNT,Number of triangle BVH nodes processed by the traversal function,RCG,1,BMG LNL PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3132,RT_QUAD_LEAF_STOC_RAY_COUNT,Number of quad leaf nodes with STOC masks processed by the traversal function,RCG,1,PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3133,RT_STOC_HIT_OPAQUE,Number of hits on quads with STOC masks evaluated as opaque,RCG,1,PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,3134,RT_STOC_HIT_TRANSPARENT,Number of hits on quads with STOC masks evaluated as transparent (ignored),RCG,1,PTL,Ray Tracing,xecore,,events,1,2,2\n"
                                               "1,5632,GPGPU_DISPATCH_CYCLES,Number of cycles spent dispatching GPGPU threads to EUs,RCG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,5633,THREAD_DISPATCH_QUEUE0_ACTIVE_CYCLES,Number of cycles non-Pixel Shader threads are ready for dispatch in a particular subslice,RG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,5634,THREAD_DISPATCH_QUEUE1_ACTIVE_CYCLES,Number of cycles non-Pixel Shader threads are ready for dispatch in a particular subslice,CG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,5635,THREAD_DISPATCH_PS_ACTIVE_CYCLES,Number of cycles Pixel Shader threads are ready for dispatch,RG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,5636,THREAD_DISPATCH_QUEUE0_STALL_CYCLES,Number of cycles queue 0 is stalled waiting for threads to be available,RG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,5637,THREAD_DISPATCH_INPUT_AVAILABLE,Number of cycles Thread Dispatch input is available,RCG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,5638,THREAD_DISPATCH_QUEUE1_STALL_CYCLES,Number of cycles queue 1 is stalled waiting for threads to be available,CG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,6144,TASK_THREADGROUP_COUNT,Number of Task Shader threadgroups dispatched,RG,1,BMG LNL PTL,Thread Dispatcher,xecore,,events,1,2,2\n"
                                               "1,6145,GPGPU_THREADGROUP_COUNT,Number of GPGPU threadgroups dispatched,RG,1,BMG LNL PTL,Thread Dispatcher,xecore,,events,1,2,2\n"
                                               "1,6146,ASYNC_GPGPU_THREADGROUP_COUNT,Number of Async GPGPU threadgroups dispatched,CG,1,BMG LNL PTL,Thread Dispatcher,xecore,,events,1,2,2\n"
                                               "1,6147,TASK_THREAD_EXIT_COUNT,Number of Task Shader EOT messages received,RG,1,BMG LNL PTL,Thread Dispatcher,xecore,,messages,1,2,2\n"
                                               "1,6148,ASYNC_GPGPU_THREAD_EXIT_COUNT,Number of Async GPGPU EOT messages received,CG,1,BMG LNL PTL,Thread Dispatcher,xecore,,messages,1,2,2\n"
                                               "1,6151,THREADGROUP_DISPATCH_QUEUE0_RESOURCE_STALL_CYCLES,\"Number of cycles Thread Spawner queue 0 is stalled waiting for any resource to be available (for example, SLM, Barrier, BTD stack, etc.)\",RG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,6152,THREADGROUP_DISPATCH_QUEUE1_RESOURCE_STALL_CYCLES,\"Number of cycles Thread Spawner queue 1 is stalled waiting for any resource to be available (for example, SLM, Barrier, BTD stack, etc.)\",CG,1,BMG LNL PTL,Thread Dispatcher,xecore,,cycles,1,2,3\n"
                                               "1,15872,TEST_EVENT1,Number of GPU (gt) clock cycles at every clock period,RCG,1,BMG LNL PTL,Test,xecore,,cycles,1,2,3\n"
                                               "2,16384,PIXEL_WRITE,Number of pixels written to all render targets,RG,,BMG LNL PTL,Color Pipe,,,events,1,0,0\n"
                                               "2,16385,PIXEL_BLEND,Number of blended pixels written to all render targets,RG,,BMG LNL PTL,Color Pipe,,,events,1,0,0\n"
                                               "2,16386,COLOR_PIPE_CACHE_LATENCY2_STALL,Number of cycles Color Pipeline stalled due to Render Cache latency hiding structure full,RG,,BMG LNL PTL,Color Pipe,,,cycles,1,0,1\n"
                                               "2,16387,RENDER_CACHE_ALLOC,Number of Render Cache allocations,RG,,BMG LNL PTL,Color Pipe,l3node,,events,1,0,2\n"
                                               "2,16388,RENDER_CACHE_HIT,Number of Render Cache hits,RG,,BMG LNL PTL,Color Pipe,l3node,,events,1,0,2\n"
                                               "2,16389,RENDER_CACHE_READ,Number of Render Cache reads,RG,,BMG LNL PTL,Color Pipe,l3node,,events,1,0,2\n"
                                               "2,16390,RENDER_CACHE_WRITE,Number of Render Cache writes,RG,,BMG LNL PTL,Color Pipe,l3node,,events,1,0,2\n"
                                               "2,16391,RENDER_CACHE_INPUT_AVAILABLE,Number of cycles Render Cache input available,RG,5,BMG LNL PTL,Color Pipe,l3node,,cycles,1,0,3\n"
                                               "2,16392,RENDER_CACHE_OUTPUT_READY,Number of cycles Render Cache output ready,RG,5,BMG LNL PTL,Color Pipe,l3node,,cycles,1,0,3\n"
                                               "2,16896,PIXEL_POST_PROCESS_OUTPUT_READY,Number of cycles Color Pipeline pixel output ready,RG,3,BMG LNL PTL,Color Pipe,pixpipe,,cycles,1,0,3\n"
                                               "2,16897,COLOR_PIPE_CACHE_LATENCY1_STALL,Number of cycles Color Pipeline stalled due to MultiSampling Cache latency hiding structure full,RG,,BMG LNL PTL,Color Pipe,pixpipe,,cycles,1,0,3\n"
                                               "2,16898,PIXEL_POST_PROCESS_INPUT_AVAILABLE,Number of cycles Color Pipeline input ready,RG,3,BMG LNL PTL,Color Pipe,pixpipe,,cycles,1,0,3\n"
                                               "2,17408,STREAMOUT_PRIMITIVE_WRITE_COUNT,\"Number of objects data written to memory, read from pipe 0 only\",RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,17409,STREAMOUT_PRIMITIVE_STORAGE_NEED,\"Number of objects data that needed beyond the current allocated space, read from pipe 0 only\",RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,17410,STREAMOUT_OUTPUT_VERTEX_COUNT,Number of vertices written by SOL,RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,17411,VS_OUTPUT_READY,Number of cycles Vertex Shader output is ready,RG,,BMG LNL PTL,Geometry,slice,,cycles,1,1,3\n"
                                               "2,17412,IA_PRIMITIVE,Number of primitives in a draw,RG,,BMG LNL PTL,Geometry,,,events,1,0,0\n"
                                               "2,17413,IA_VERTEX,Number of vertices in a draw,RG,,BMG LNL PTL,Geometry,,,events,1,0,0\n"
                                               "2,17414,VERTEX_FETCH_OUTPUT_READY,Number of cycles Vertex Fetch output is ready,RG,3,BMG LNL PTL,Geometry,slice,,cycles,1,1,3\n"
                                               "2,17415,VERTEX_FETCH_INPUT_AVAILABLE,Number of cycles Vertex Fetch input is available,RG,3,BMG LNL PTL,Geometry,slice,,cycles,1,1,3\n"
                                               "2,17920,COMPRESSOR_INPUT,Number of 256B writes to compressible surfaces at the input of the compressor,G,,BMG LNL PTL,Memory,,,events,1,0,0\n"
                                               "2,17921,COMPRESSOR_OUTPUT,Number of 256B writes to compressible surfaces at the output of the compressor,G,,BMG LNL PTL,Memory,,,events,1,0,0\n"
                                               "2,18944,URB_READ,Number of URB reads,RG,,BMG LNL PTL,URB,slice,,events,1,1,2\n"
                                               "2,18945,URB_WRITE,Number of URB writes,RG,,BMG LNL PTL,URB,slice,,events,1,1,2\n"
                                               "2,18946,URB_CROSS_SLICE_READ,Number of URB reads occurred from cross slices,RG,,BMG LNL PTL,URB,slice,,events,1,1,2\n"
                                               "2,19456,HIZ_SUBSPAN_LATENCY_FIFOFULL,Number of cycles for which HiZ latency hiding structure full,RG,,BMG LNL PTL,Depth Pipe,zpipe,,cycles,1,0,3\n"
                                               "2,19457,HIZ_DEPTH_TEST_PASS_P,Number of promoted 2x2 passed by hierarchical depth test,RG,,BMG LNL PTL,Depth Pipe,zpipe,,events,1,0,2\n"
                                               "2,19458,HIZ_DEPTH_TEST_AMBIG_P,Number of promoted 2x2 that are ambiguous by hierarchical depth test,RG,,BMG LNL PTL,Depth Pipe,zpipe,,events,1,0,2\n"
                                               "2,19459,HIZ_DEPTH_TEST_FAIL_P,Number of promoted 2x2 that failed the hierarchical depth test,RG,,BMG LNL PTL,Depth Pipe,zpipe,,events,1,0,2\n"
                                               "2,19460,HIZ_DEPTH_TEST_AMBIG_NP,Number of non-promoted 2x2 that are ambiguous by hierarchical depth test,RG,,BMG LNL PTL,Depth Pipe,zpipe,,events,1,0,2\n"
                                               "2,19461,HIZ_DEPTH_TEST_FAIL_NP,Number of non-promoted 2x2 that failed the hierarchical depth test,RG,,BMG LNL PTL,Depth Pipe,zpipe,,events,1,0,2\n"
                                               "2,19488,IZ_SUBSPAN_LATENCY_FIFOFULL,Number of cycles for which IZ  latency hiding structure full,RG,,BMG LNL PTL,Depth Pipe,zpipe,,cycles,1,0,3\n"
                                               "2,19489,POSTPS_DEPTH_STENCIL_TEST_FAIL,Number of 2x2 that were lit from Rasterizer but failed the depth or stencil test post shader,RG,,BMG LNL PTL,Depth Pipe,zpipe,,events,1,0,2\n"
                                               "2,19490,EARLY_DEPTH_STENCIL_TEST_FAIL_P,Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ,RG,,BMG LNL PTL,Depth Pipe,zpipe,,events,1,0,2\n"
                                               "2,19491,EARLY_DEPTH_STENCIL_TEST_FAIL_NP,Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ,RG,,BMG LNL PTL,Depth Pipe,zpipe,,events,1,0,2\n"
                                               "2,19492,IZ_OUTPUT_READY,Number of cycles IZ has requests to different clients,RG,3,BMG LNL PTL,Depth Pipe,zpipe,,cycles,1,0,3\n"
                                               "2,19968,AMFS_4X4_SHADING_REQUEST,Number of Shading Request (evaluate) messages processed by AMFS,G,,BMG LNL PTL,AMFS,slice,,messages,1,1,2\n"
                                               "2,19969,AMFS_CACHE_HIT,Number of hits in the AMFS cache,G,,BMG LNL PTL,AMFS,slice,,events,1,1,2\n"
                                               "2,19970,AMFS_CACHE_MISS,Number of cache misses in AMFS,G,,BMG LNL PTL,AMFS,slice,,events,1,1,2\n"
                                               "2,19971,AMFS_STALL_ANY_INPUT,Number of cycles AMFS stalls at any of the color pipe inputs,G,3,BMG LNL PTL,AMFS,slice,,cycles,1,1,3\n"
                                               "2,19972,AMFS_STALL_ALL_INPUT,Number of cycles AMFS stalls at both of the color pipe inputs,G,,BMG LNL PTL,AMFS,slice,,cycles,1,1,3\n"
                                               "2,20480,COMMAND_PARSER_COPY_ENGINE_BUSY,Number of cycles there is a context loaded and active on the copy queue.,G,,BMG LNL PTL,Front End,,,cycles,1,0,1\n"
                                               "2,20488,COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT,Number of compute walker commands parsed on the compute engine,CG,,BMG LNL PTL,Front End,ccs,,events,1,0,2\n"
                                               "2,20489,COMMAND_PARSER_COMPUTE_ENGINE_BUSY,Number of cycles there is a context loaded and active on the compute queue,CG,,BMG LNL PTL,Front End,ccs,,cycles,1,0,3\n"
                                               "2,20496,COMMAND_PARSER_FLUSH_COUNT,Number of Stalling flushes at the top of the pipe,RCG,,BMG LNL PTL,Front End,,,events,1,0,0\n"
                                               "2,20497,COMMAND_PARSER_RENDER_ENGINE_DRAW_COUNT,Number of DRAW and MESH commands parsed on the 3D engine,RG,,BMG LNL PTL,Front End,,,events,1,0,0\n"
                                               "2,20498,COMMAND_PARSER_RENDER_ENGINE_DISPATCH_KERNEL_COUNT,Number of compute walker commands parsed on the 3D engine,RG,,BMG LNL PTL,Front End,,,events,1,0,0\n"
                                               "2,20499,COMMAND_PARSER_RENDER_ENGINE_BUSY,Number of cycles there is a context loaded and active on the 3D queue,RG,,BMG LNL PTL,Front End,,,cycles,1,0,1\n"
                                               "2,23040,GPU_BUSY,Number of cycles when GPU is not idle including all GPU engines,G,,BMG LNL PTL,Front End,,,cycles,1,0,1\n"
                                               "2,23552,TLB_MISS,Number of misses from all TLBs and all engines,G,,BMG LNL PTL,Memory,,,events,1,0,0\n"
                                               "2,24064,GPU_MEMORY_L3_READ,Number of GTI memory reads from Device Cache caused by Device Cache misses,G,,BMG LNL PTL,Memory,sqidi,,events,1,0,2\n"
                                               "2,24065,GPU_MEMORY_L3_WRITE,Number of GTI memory writes from Device Cache caused by Device Cache invalidations,G,,BMG LNL PTL,Memory,sqidi,,events,1,0,2\n"
                                               "2,24066,GPU_MEMORY_READ,Number of GTI memory reads,G,,BMG LNL PTL,Memory,sqidi,,events,1,0,2\n"
                                               "2,24067,GPU_MEMORY_WRITE,Number of GTI memory writes,G,,BMG LNL PTL,Memory,sqidi,,events,1,0,2\n"
                                               "2,24068,GPU_MEMORY_REQUEST_QUEUE_FULL,Number of cycles when SQ is filled above a threshold (usually 48 entries),G,4,BMG LNL PTL,Memory,sqidi,,cycles,1,0,3\n"
                                               "2,24069,GPU_MEMORY_CYCLES_ACTIVE,\"Number of cycles device local memory (HBM, GDDR, LPDDR, etc.) is active\",G,,BMG LNL PTL,Memory,sqidi,,cycles,1,0,3\n"
                                               "2,24070,GPU_MEMORY_64B_TRANSACTION_READ,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)\",G,,BMG LNL PTL,Memory,sqidi,,events,1,0,2\n"
                                               "2,24071,GPU_MEMORY_64B_TRANSACTION_WRITE,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)\",G,,BMG LNL PTL,Memory,sqidi,,events,1,0,2\n"
                                               "2,24072,GPU_MEMORY_32B_TRANSACTION_READ,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)\",G,,BMG LNL PTL,Memory,sqidi,,events,1,0,2\n"
                                               "2,24073,GPU_MEMORY_32B_TRANSACTION_WRITE,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)\",G,,BMG LNL PTL,Memory,sqidi,,events,1,0,2\n"
                                               "2,24074,GPU_MEMORY_BYTE_READ,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes\",G,4,BMG LNL PTL,Memory,sqidi,,bytes,1,0,6\n"
                                               "2,24075,GPU_MEMORY_BYTE_WRITE,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes\",G,4,BMG LNL PTL,Memory,sqidi,,bytes,1,0,6\n"
                                               "2,24576,L3_INPUT_AVAILABLE,Number of cycles Device Cache bank has input requests,G,2,BMG LNL PTL,Device Cache,l3bank,,cycles,1,3,3\n"
                                               "2,24577,L3_OUTPUT_READY,Number of cycles Device Cache bank has output ready,G,2,BMG LNL PTL,Device Cache,l3bank,,cycles,1,3,3\n"
                                               "2,24578,L3_ATOMIC_ACCESS,Number of atomic accesses to Device Cache bank,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24583,ICACHE_L3_READ,Number of Device Cache read requests coming from EU Instruction Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,10\n"
                                               "2,24584,ICACHE_L3_HIT,Number of EU instruction cache requests that hit the Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24585,SAMPLER_L3_READ,Number of Device Cache read requests resulting from sampler local cache miss,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,10\n"
                                               "2,24586,SAMPLER_L3_HIT,Number of Device Cache hit requests resulting from sampler local cache miss which hits in Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24587,COLOR_L3_ACCESS,Number of Device Cache requests resulting from color local cache misses,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24588,COLOR_L3_HIT,Number of Device Cache requests resulting from color local cache miss which hits in Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24589,Z_L3_ACCESS,Number of Device Cache requests resulting from Z local cache misses,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24590,Z_L3_HIT,Number of Device Cache requests resulting from Z local cache miss which hits in Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24591,L3_READ,Number of Device Cache 64B read requests,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,10\n"
                                               "2,24592,L3_WRITE,Number of Device Cache 64B write requests,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,10\n"
                                               "2,24593,L3_MISS,Number of Device Cache accesses which miss in the Device Cache cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24594,L3_HIT,Number of Device Cache accesses which hits in the Device Cache cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24595,L3_SUPERQ_FULL,Number of cycles all slots in Device Cache request queue are waiting for data return / response,G,2,BMG LNL PTL,Device Cache,l3bank,,cycles,1,3,3\n"
                                               "2,24596,L3_BUSY,Number of cycles Device Cache request queue has one or more requests pending,G,2,BMG LNL PTL,Device Cache,l3bank,,cycles,1,3,3\n"
                                               "2,24597,L3_STALL,Number of cycles Device Cache bank stalled,G,2,BMG LNL PTL,Device Cache,l3bank,,cycles,1,3,3\n"
                                               "2,24598,AMFS_L3_HIT,Number of AMFS hits in Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24599,AMFS_L3_ACCESS,Number of AMFS access to Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24600,AMFS_L3_WRITE,Number of AMFS writes to Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24601,AMFS_L3_ATOMIC,Number of AMFS atomics to Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,24602,LOAD_STORE_CACHE_L3_READ,Number of cacheline read requests from the Load Store Cache to Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,10\n"
                                               "2,24603,LOAD_STORE_CACHE_L3_WRITE,Number of cacheline write requests from the Load Store Cache to Device Cache,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,10\n"
                                               "2,24604,LOAD_STORE_CACHE_L3_HIT,Number of Load Store Cache requests to Device Cache that are hit,G,2,BMG LNL PTL,Device Cache,l3bank,,events,1,3,2\n"
                                               "2,25600,HOST_TO_GPUMEM_TRANSACTION_READ,\"Number of host 64B reads to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)\",G,,BMG,Memory,,,events,1,0,8\n"
                                               "2,25601,HOST_TO_GPUMEM_TRANSACTION_WRITE,\"Number of host 64B writes to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)\",G,,BMG,Memory,,,events,1,0,8\n"
                                               "2,25602,SYSMEM_TRANSACTION_READ,\"Number of system memory 64B reads (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)\",G,,BMG,Memory,,,events,1,0,8\n"
                                               "2,25603,SYSMEM_TRANSACTION_WRITE,\"Number of system memory 64B writes (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)\",G,,BMG,Memory,,,events,1,0,8\n"
                                               "2,26112,CLIPPER_INPUT_AVAILABLE,Number of cycles Clipper has input available (from Vertex Shader or SOL),RG,3,BMG LNL PTL,Geometry,slice,,cycles,1,1,3\n"
                                               "2,26113,CLIPPER_PRIMITIVE_CULL,Number of Clipper early cull primitives,RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,26114,CLIPPER_TRANSACTION_OUTPUT,Number of elements pushed by Clipper into Stripsfan stage,RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,26115,CLIPPER_INPUT_VERTEX,Number of Clipper input vertices,RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,26116,CLIPPER_OUTPUT_READY,Number of cycles Clipper output ready,RG,3,BMG LNL PTL,Geometry,slice,,cycles,1,1,3\n"
                                               "2,26117,CLIPPER_PRIMITIVE_OUTPUT,\"Number of primitives going out of Clipper, must clip plus the trivial accept. Must clip primitives are counted one time only.\",RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,26118,CLIPPER_PRIMITIVE_FAR_NEAR_CLIP,Number of primitives clipped by Clipper due to near/far planes,RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,26128,STRIPSFAN_OUTPUT_READY,Number of cycles in which geometry pipeline output is ready,RG,,BMG LNL PTL,Geometry,slice,,cycles,1,1,3\n"
                                               "2,26129,STRIPSFAN_OBJECT_COUNT,Number of objects exiting Stripsfan stage,RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,26130,STRIPSFAN_OBJECT_CULL,Number of simple and complex culled objects in Stripsfan stage,RG,,BMG LNL PTL,Geometry,slice,,events,1,1,2\n"
                                               "2,26624,RASTERIZER_INPUT_AVAILABLE,Number of cycles Rasterizer input is available,RG,3,BMG LNL PTL,Rasterizer,slice,,cycles,1,1,3\n"
                                               "2,26625,PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH,Number of promoted 2x2 that are lit from Rasterizer,RG,,BMG LNL PTL,Rasterizer,slice,,events,1,1,2\n"
                                               "2,26626,PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH,Number of non-promoted 2x2 that are lit from Rasterizer,RG,,BMG LNL PTL,Rasterizer,slice,,events,1,1,2\n"
                                               "2,26627,RASTERIZER_OUTPUT_READY,Number of cycles where rasterizer output is ready,RG,3,BMG LNL PTL,Rasterizer,slice,,cycles,1,1,3\n"
                                               "2,26628,RASTERIZER_TRANSACTION_OUTPUT,Number of transactions pushed from Rasterizer to the Z pipe,RG,,BMG LNL PTL,Rasterizer,slice,,events,1,1,2\n"
                                               "2,26629,RASTERIZER_SAMPLE_OUTPUT,Number of lit samples emitted by Rasterizer,RG,,BMG LNL PTL,Rasterizer,slice,,events,1,1,2\n"
                                               "2,28160,COPY_ENGINE_READ_REQUEST,Number of read requests sent by the Copy Engine,G,6,BMG LNL PTL,Copy Engine,copyengine,,events,1,0,2\n"
                                               "2,28161,COPY_ENGINE_WRITE_REQUEST,Number of write requests sent by the Copy Engine,G,6,BMG LNL PTL,Copy Engine,copyengine,,events,1,0,2\n"
                                               "2,28162,COPY_ENGINE_REQUEST_STALL,Number of cycles copy engine is stalled on the memory path due to stall on the read or write path when there are commands pending within copy engine,G,,BMG LNL PTL,Copy Engine,copyengine,,cycles,1,0,3\n"
                                               "2,32256,TEST_EVENT2,Number of GPU (gt) clock cycles at every other clock period,G,,BMG LNL PTL,Test,slice,,cycles,1,1,3\n"
                                               "";

const char ExternalEvents::hwEvents[46344] = "Architectural Event Name,Hw Event Name,Hw Event Short Name,Hw Event Description,Filter Value,Project\n"
                                             "SAMPLER_MEMORY_LATENCY_STALL,SAMPLER_MEMORY_LATENCY_STALL_CYCLES,Sampler Memory Latency Stall Cycles,Number of cycles Sampler stalled due to latency hiding structure full,0,BMG LNL PTL\n"
                                             "SAMPLER_2X2_READ,SAMPLER_2X2_READ,Sampler 2x2 Read,Number of 2x2 texel block requested from Sampler,0,BMG LNL PTL\n"
                                             "SAMPLER_INPUT_AVAILABLE,SAMPLER_INPUT_AVAILABLE_CYCLES,Sampler Input Available Cycles,Number of cycles when Sampler input is available,0,BMG LNL PTL\n"
                                             "SAMPLER_OUTPUT_READY,SAMPLER_OUTPUT_READY_CYCLES,Sampler Output Ready Cycles,Number of cycles when Sampler output is ready,0,BMG LNL PTL\n"
                                             "SAMPLER_TEXTURE_CACHE_MISS,SAMPLER_TEXTURE_CACHE_MISS,Sampler Texture Cache Miss,Number of Sampler L1 misses,0,BMG LNL PTL\n"
                                             "SAMPLER_TEXTURE_CACHE_ACCESS,SAMPLER_TEXTURE_CACHE_ACCESS,Sampler Texture Cache Access,Number of Sampler L1 requests,0,BMG LNL PTL\n"
                                             "SAMPLER_ACTIVE_CYCLES,SAMPLER_ACTIVE_CYCLES,Sampler Active Cycles,Number of cycles Sampler pipeline active,0,BMG LNL PTL\n"
                                             "SHADER_PIX_KILL,SHADER_PIX_KILL,Shader Pix Kill,Number of pixels that were lit from Rasterizer but killed by the Pixel Shader,0,BMG LNL PTL\n"
                                             "PS_OUTPUT_AVAILABLE,PS_OUTPUT_AVAILABLE_CYCLES,PS Output Available Cycles,Number of cycles Pixel Shader data is available,0,BMG LNL PTL\n"
                                             "POSTPS_ALPHA_TEST_FAIL,POSTPS_ALPHA_TEST_FAIL,PostPS Alpha Test Fail,Number of 2x2 that were lit from Rasterizer but failed the alpha test,0,BMG LNL PTL\n"
                                             "EU_SHARED_FUNCTION_ACCESS_HOLD,XVE_SHARED_FUNCTION_ACCESS_HOLD_CYCLES,XVE Shared Function Access Hold Cycles,Number of cycles XVE requests stalled by Shared Function units,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_ALL,XVE Inst Executed Send All,Number of instruction (GRF) dispatches executed by ALL threads on SEND Pipe,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_VS,XVE Inst Executed Send VS,Number of instruction (GRF) dispatches executed by VS threads on SEND Pipe,1,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_HS,XVE Inst Executed Send HS,Number of instruction (GRF) dispatches executed by HS threads on SEND Pipe,2,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_DS,XVE Inst Executed Send DS,Number of instruction (GRF) dispatches executed by DS threads on SEND Pipe,3,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_GS,XVE Inst Executed Send GS,Number of instruction (GRF) dispatches executed by GS threads on SEND Pipe,4,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_PS,XVE Inst Executed Send PS,Number of instruction (GRF) dispatches executed by PS threads on SEND Pipe,5,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_CS,XVE Inst Executed Send CS,Number of instruction (GRF) dispatches executed by CS threads on SEND Pipe,6,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_ASYNC_CS,XVE Inst Executed Send Async CS,Number of instruction (GRF) dispatches executed by ASYNC CS threads on SEND Pipe,9,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_TS,XVE Inst Executed Send TS,Number of instruction (GRF) dispatches executed by TS threads on SEND Pipe,10,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_MS,XVE Inst Executed Send MS,Number of instruction (GRF) dispatches executed by MS threads on SEND Pipe,11,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_RT_AHS,XVE Inst Executed Send RT AHS,Number of instruction (GRF) dispatches executed by RT AHS threads on SEND Pipe,12,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_RT_CHS,XVE Inst Executed Send RT CHS,Number of instruction (GRF) dispatches executed by RT CHS threads on SEND Pipe,13,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SEND_ALL,XVE_INST_EXECUTED_SEND_RT_MS,XVE Inst Executed Send RT MS,Number of instruction (GRF) dispatches executed by RT MS threads on SEND Pipe,14,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_CONTROL_ALL,XVE_INST_EXECUTED_CONTROL_ALL,XVE Inst Executed Control All,Number of instructions executed on JEU Pipe,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_ALL,XVE Inst Executed ALU1 All,Number of execution slots taken by instructions executed by ALL threads on ALU1 pipe. Does not include extended math instructions.,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_VS,XVE Inst Executed ALU1 VS,Number of execution slots taken by instructions executed by VS threads on ALU1 pipe. Does not include extended math instructions.,1,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_HS,XVE Inst Executed ALU1 HS,Number of execution slots taken by instructions executed by HS threads on ALU1 pipe. Does not include extended math instructions.,2,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_DS,XVE Inst Executed ALU1 DS,Number of execution slots taken by instructions executed by DS threads on ALU1 pipe. Does not include extended math instructions.,3,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_GS,XVE Inst Executed ALU1 GS,Number of execution slots taken by instructions executed by GS threads on ALU1 pipe. Does not include extended math instructions.,4,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_PS,XVE Inst Executed ALU1 PS,Number of execution slots taken by instructions executed by PS threads on ALU1 pipe. Does not include extended math instructions.,5,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_CS,XVE Inst Executed ALU1 CS,Number of execution slots taken by instructions executed by CS threads on ALU1 pipe. Does not include extended math instructions.,6,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_ASYNC_CS,XVE Inst Executed ALU1 Async CS,Number of execution slots taken by instructions executed by ASYNC CS threads on ALU1 pipe. Does not include extended math instructions.,9,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_TS,XVE Inst Executed ALU1 TS,Number of execution slots taken by instructions executed by TS threads on ALU1 pipe. Does not include extended math instructions.,10,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_MS,XVE Inst Executed ALU1 MS,Number of execution slots taken by instructions executed by MS threads on ALU1 pipe. Does not include extended math instructions.,11,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_RT_AHS,XVE Inst Executed ALU1 RT AHS,Number of execution slots taken by instructions executed by RT AHS threads on ALU1 pipe. Does not include extended math instructions.,12,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_RT_CHS,XVE Inst Executed ALU1 RT CHS,Number of execution slots taken by instructions executed by RT CHS threads on ALU1 pipe. Does not include extended math instructions.,13,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU1_ALL,XVE_INST_EXECUTED_ALU1_RT_MS,XVE Inst Executed ALU1 RT MS,Number of execution slots taken by instructions executed by RT MS threads on ALU1 pipe. Does not include extended math instructions.,14,BMG LNL PTL\n"
                                             "EU_THREADS_OCCUPANCY_ALL,XVE_THREADS_OCCUPANCY_ALL_CYCLES,XVE Threads Occupancy All Cycles,Number of thread slots occupied by ALL threads,0,BMG LNL PTL\n"
                                             "EU_THREADS_OCCUPANCY_ALL,XVE_THREADS_OCCUPANCY_VS_CYCLES,XVE Threads Occupancy VS Cycles,Number of thread slots occupied by VS threads,1,BMG LNL PTL\n"
                                             "EU_THREADS_OCCUPANCY_ALL,XVE_THREADS_OCCUPANCY_PS_CYCLES,XVE Threads Occupancy PS Cycles,Number of thread slots occupied by PS threads,5,BMG LNL PTL\n"
                                             "EU_THREADS_OCCUPANCY_ALL,XVE_THREADS_OCCUPANCY_CS_CYCLES,XVE Threads Occupancy CS Cycles,Number of thread slots occupied by CS threads,6,BMG LNL PTL\n"
                                             "EU_THREADS_OCCUPANCY_ALL,XVE_THREADS_OCCUPANCY_ASYNC_CS_CYCLES,XVE Threads Occupancy Async CS Cycles,Number of thread slots occupied by ASYNC CS threads,9,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_CYCLES,XVE Active Cycles,Number of cycles at least one pipe is active in XVE,0,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_VS_CYCLES,XVE Active VS Cycles,Number of cycles there are VS threads loaded and at least one pipe is active in XVE,1,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_HS_CYCLES,XVE Active HS Cycles,Number of cycles there are HS threads loaded and at least one pipe is active in XVE,2,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_DS_CYCLES,XVE Active DS Cycles,Number of cycles there are DS threads loaded and at least one pipe is active in XVE,3,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_GS_CYCLES,XVE Active GS Cycles,Number of cycles there are GS threads loaded and at least one pipe is active in XVE,4,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_PS_CYCLES,XVE Active PS Cycles,Number of cycles there are PS threads loaded and at least one pipe is active in XVE,5,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_CS_CYCLES,XVE Active CS Cycles,Number of cycles there are CS threads loaded and at least one pipe is active in XVE,6,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_ASYNC_CS_CYCLES,XVE Active Async CS Cycles,Number of cycles there are ASYNC CS threads loaded and at least one pipe is active in XVE,9,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_TS_CYCLES,XVE Active TS Cycles,Number of cycles there are TS threads loaded and at least one pipe is active in XVE,10,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_MS_CYCLES,XVE Active MS Cycles,Number of cycles there are MS threads loaded and at least one pipe is active in XVE,11,BMG LNL PTL\n"
                                             "EU_ACTIVE_CYCLES,XVE_ACTIVE_RT_CYCLES,XVE Active RT Cycles,Number of cycles there are RT threads loaded and at least one pipe is active in XVE,12,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_CYCLES,XVE Stall Cycles,Number of cycles any thread loaded but not even a single pipe is active in XVE,0,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_VS_CYCLES,XVE Stall VS Cycles,Number of cycles there are VS threads loaded but not even a single pipe is active in XVE,1,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_HS_CYCLES,XVE Stall HS Cycles,Number of cycles there are HS threads loaded but not even a single pipe is active in XVE,2,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_DS_CYCLES,XVE Stall DS Cycles,Number of cycles there are DS threads loaded but not even a single pipe is active in XVE,3,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_GS_CYCLES,XVE Stall GS Cycles,Number of cycles there are GS threads loaded but not even a single pipe is active in XVE,4,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_PS_CYCLES,XVE Stall PS Cycles,Number of cycles there are PS threads loaded but not even a single pipe is active in XVE,5,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_CS_CYCLES,XVE Stall CS Cycles,Number of cycles there are CS threads loaded but not even a single pipe is active in XVE,6,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_ASYNC_CS_CYCLES,XVE Stall Async CS Cycles,Number of cycles there are ASYNC CS threads loaded but not even a single pipe is active in XVE,9,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_TS_CYCLES,XVE Stall TS Cycles,Number of cycles there are TS threads loaded but not even a single pipe is active in XVE,10,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_MS_CYCLES,XVE Stall MS Cycles,Number of cycles there are MS threads loaded but not even a single pipe is active in XVE,11,BMG LNL PTL\n"
                                             "EU_STALL_CYCLES,XVE_STALL_RT_CYCLES,XVE Stall RT Cycles,Number of cycles there are RT threads loaded but not even a single pipe is active in XVE,12,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_BITCONV,XVE_INST_EXECUTED_BITCONV,XVE Inst Executed Bitconv,Number of execution slots taken by bit manipulation instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_BARRIER,XVE_INST_EXECUTED_BARRIER,XVE Inst Executed Barrier,Number of sync.bar and sync.host instructions executed,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_PREDICATION,XVE_INST_EXECUTED_PREDICATION,XVE Inst Executed Predication,Number of instructions (not execution slots) executed with predication mask enabled,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_NONDIVERGENT,XVE_INST_EXECUTED_NONDIVERGENT,XVE Inst Executed Nondivergent,Number of non-divergent instructions (not execution slots) executed,0,BMG LNL PTL\n"
                                             "EU_INST_ISSUED_ALL,XVE_INST_ISSUED_ALL,XVE Inst Issued All,Number of instructions issued (decoded) to any pipe,0,BMG LNL\n"
                                             "EU_INST_ISSUED_ALL,XVE_INST_ISSUED_ALL,XVE Inst Issued All,Number of instructions issued (decoded) to any pipe (does not include the Scalar pipe),0,PTL\n"
                                             "EU_INST_EXECUTED_INT16,XVE_INST_EXECUTED_INT16,XVE Inst Executed Int16,Number of execution slots taken by INT16 ALU instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_INT32,XVE_INST_EXECUTED_INT32,XVE Inst Executed Int32,Number of execution slots taken by INT32 ALU instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_MATH,XVE_INST_EXECUTED_MATH,XVE Inst Executed Math,Number of execution slots taken by extended math instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_ALL,XVE Inst Executed ALU0 All,Number of execution slots taken by instructions executed by ALL threads on ALU0 pipe,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_VS,XVE Inst Executed ALU0 VS,Number of execution slots taken by instructions executed by VS threads on ALU0 pipe,1,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_HS,XVE Inst Executed ALU0 HS,Number of execution slots taken by instructions executed by HS threads on ALU0 pipe,2,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_DS,XVE Inst Executed ALU0 DS,Number of execution slots taken by instructions executed by DS threads on ALU0 pipe,3,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_GS,XVE Inst Executed ALU0 GS,Number of execution slots taken by instructions executed by GS threads on ALU0 pipe,4,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_PS,XVE Inst Executed ALU0 PS,Number of execution slots taken by instructions executed by PS threads on ALU0 pipe,5,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_CS,XVE Inst Executed ALU0 CS,Number of execution slots taken by instructions executed by CS threads on ALU0 pipe,6,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_ASYNC_CS,XVE Inst Executed ALU0 Async CS,Number of execution slots taken by instructions executed by ASYNC CS threads on ALU0 pipe,9,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_TS,XVE Inst Executed ALU0 TS,Number of execution slots taken by instructions executed by TS threads on ALU0 pipe,10,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_MS,XVE Inst Executed ALU0 MS,Number of execution slots taken by instructions executed by MS threads on ALU0 pipe,11,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_RT_AHS,XVE Inst Executed ALU0 RT AHS,Number of execution slots taken by instructions executed by RT AHS threads on ALU0 pipe,12,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_RT_CHS,XVE Inst Executed ALU0 RT CHS,Number of execution slots taken by instructions executed by RT CHS threads on ALU0 pipe,13,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU0_ALL,XVE_INST_EXECUTED_ALU0_RT_MS,XVE Inst Executed ALU0 RT MS,Number of execution slots taken by instructions executed by RT MS threads on ALU0 pipe,14,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_FP32,XVE_INST_EXECUTED_FP32,XVE Inst Executed Fp32,Number of execution slots taken by FP32 ALU instructions. Does not include extended math instructions.,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_FP16,XVE_INST_EXECUTED_FP16,XVE Inst Executed Fp16,Number of execution slots taken by FP16 ALU instructions. Does not include extended math instructions.,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_FP64,XVE_INST_EXECUTED_FP64,XVE Inst Executed Fp64,Number of execution slots taken by FP64 ALU instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_INT64,XVE_INST_EXECUTED_INT64,XVE Inst Executed Int64,Number of execution slots taken by INT64 instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_ALU2_ALL,XVE_INST_EXECUTED_ALU2_ALL,XVE Inst Executed ALU2 All,Number of execution slots taken by instructions executed in ALU2 pipe,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SYSTOLIC_FP16,XVE_INST_EXECUTED_XMX_FP16,XVE Inst Executed XMX Fp16,Number of execution slots taken by FP16 XMX instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SYSTOLIC_BF16,XVE_INST_EXECUTED_XMX_BF16,XVE Inst Executed XMX Bf16,Number of execution slots taken by BF16 XMX instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SYSTOLIC_INT8,XVE_INST_EXECUTED_XMX_INT8,XVE Inst Executed XMX Int8,Number of execution slots taken by INT8 XMX instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SYSTOLIC_INT4,XVE_INST_EXECUTED_XMX_INT4,XVE Inst Executed XMX Int4,Number of execution slots taken by INT4 XMX instructions,0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_SYSTOLIC_INT2,XVE_INST_EXECUTED_XMX_INT2,XVE Inst Executed XMX Int2,Number of execution slots taken by INT2 XMX instructions,0,BMG LNL PTL\n"
                                             "EU_STALL_INSTFETCH_CYCLES,XVE_STALL_INSTFETCH_CYCLES,XVE Stall Instfetch Cycles,\"Number of cycles XVE stalled, with at least one thread waiting for Instruction Fetch. Multiple stall reasons can qualify during the same cycle\",0,BMG LNL PTL\n"
                                             "EU_STALL_BARRIER_CYCLES,XVE_STALL_BARRIER_CYCLES,XVE Stall Barrier Cycles,\"Number of cycles XVE stalled, with at least one thread waiting for Gateway to write Notify register. Multiple stall reasons can qualify during the same cycle\",0,BMG LNL PTL\n"
                                             "EU_STALL_SBID_CYCLES,XVE_STALL_SBID_CYCLES,XVE Stall Sbid Cycles,\"Number of cycles XVE stalled, with at least one thread waiting for Scoreboard token to be available. Multiple stall reasons can qualify during the same cycle\",0,BMG LNL PTL\n"
                                             "EU_STALL_ALUWR_CYCLES,XVE_STALL_ALUWR_CYCLES,XVE Stall Aluwr Cycles,\"Number of cycles XVE stalled, with at least one thread waiting for ALU to write GRF/ACC register. Multiple stall reasons can qualify during the same cycle\",0,BMG LNL PTL\n"
                                             "EU_STALL_SENDWR_CYCLES,XVE_STALL_SENDWR_CYCLES,XVE Stall Sendwr Cycles,\"Number of cycles XVE stalled, with at least one thread waiting for SEND message to be dispatched from XVE. Multiple stall reasons can qualify during the same cycle\",0,BMG LNL PTL\n"
                                             "EU_STALL_PIPESTALL_CYCLES,XVE_STALL_PIPESTALL_CYCLES,XVE Stall Pipestall Cycles,\"Number of cycles XVE stalled, with at least one thread ready to be scheduled (Grf conf/send holds etc). Multiple stall reasons can qualify during the same cycle\",0,BMG LNL PTL\n"
                                             "EU_STALL_CONTROL_CYCLES,XVE_STALL_CONTROL_CYCLES,XVE Stall Control Cycles,\"Number of cycles XVE stalled, with at least one thread waiting for JEU to complete branch instruction. Multiple stall reasons can qualify during the same cycle\",0,BMG LNL PTL\n"
                                             "EU_STALL_OTHER_CYCLES,XVE_STALL_OTHER_CYCLES,XVE Stall Other Cycles,\"Number of cycles XVE stalled, with at least one thread waiting on any other dependency (Flag/EoT etc). Multiple stall reasons can qualify during the same cycle\",0,BMG LNL PTL\n"
                                             "ICACHE_HIT,ICACHE_HIT,ICache Hit,Number of Instruction Cache hits,0,BMG LNL PTL\n"
                                             "ICACHE_MISS,ICACHE_MISS,ICache Miss,Number of Instruction Cache misses,0,BMG LNL PTL\n"
                                             "EU_MULTIPLE_PIPE_ACTIVE_CYCLES,XVE_MULTIPLE_PIPE_ACTIVE_CYCLES,XVE Multiple Pipe Active Cycles,\"Number of cycles at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and ALU2 pipes\",0,BMG LNL PTL\n"
                                             "EU_PIPE_ALU0_AND_ALU1_ACTIVE_CYCLES,XVE_PIPE_ALU0_AND_ALU1_ACTIVE_CYCLES,XVE Pipe ALU0 And ALU1 Active Cycles,Number of cycles ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction,0,BMG LNL PTL\n"
                                             "EU_PIPE_ALU0_AND_ALU2_ACTIVE_CYCLES,XVE_PIPE_ALU0_AND_ALU2_ACTIVE_CYCLES,XVE Pipe ALU0 And ALU2 Active Cycles,Number of cycles ALU0 and ALU2 pipes are both actively executing a Gen ISA instruction,0,BMG LNL PTL\n"
                                             "EU_STALL_PS_DEPENDENCY_CYCLES,XVE_STALL_PS_DEPENDENCY_CYCLES,XVE Stall PS Dependency Cycles,\"Number of cycles XVE stalled, with at least one thread waiting on Pixel Shader dependency\",0,BMG LNL PTL\n"
                                             "EU_INST_EXECUTED_FP64_2ND,XVE_INST_EXECUTED_FP64_2ND,XVE Inst Executed Fp64 2nd,Number of execution slots taken by FP64 ALU instructions executed in the second pipe,0,BMG LNL PTL\n"
                                             "EU_LOAD_STORE_CACHE_READ_MESSAGE_COUNT,XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT,XVE Load Store Cache Read Message Count,Number of read messages sent by XVEs to the Load Store Cache,0,BMG LNL PTL\n"
                                             "EU_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT,XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT,XVE Load Store Cache Write Message Count,Number of write messages sent by XVEs to the Load Store Cache,0,BMG LNL PTL\n"
                                             "EU_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT,XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT,XVE Load Store Cache Atomic Message Count,Number of atomic operations sent by XVEs to the Load Store Cache,0,BMG LNL PTL\n"
                                             "EU_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT,XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT,XVE Load Store Cache Fence Message Count,Number of fence messages sent by XVEs to the Load Store Cache,0,BMG LNL PTL\n"
                                             "EU_SLM_READ_MESSAGE_COUNT,XVE_SLM_READ_MESSAGE_COUNT,XVE SLM Read Message Count,Number of SLM read messages sent by XVEs,0,BMG LNL PTL\n"
                                             "EU_SLM_WRITE_MESSAGE_COUNT,XVE_SLM_WRITE_MESSAGE_COUNT,XVE SLM Write Message Count,Number of SLM write messages sent by XVEs,0,BMG LNL PTL\n"
                                             "EU_SLM_ATOMIC_MESSAGE_COUNT,XVE_SLM_ATOMIC_MESSAGE_COUNT,XVE SLM Atomic Message Count,Number of SLM atomic operations sent by XVEs,0,BMG LNL PTL\n"
                                             "EU_SLM_FENCE_MESSAGE_COUNT,XVE_SLM_FENCE_MESSAGE_COUNT,XVE SLM Fence Message Count,Number of SLM fence operations sent by XVEs,0,BMG LNL PTL\n"
                                             "RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT,RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT,RT Load Store Cache Read Message Count,Number of read messages sent from Ray Tracing unit to the Load Store Cache,0,BMG LNL PTL\n"
                                             "RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT,RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT,RT Load Store Cache Write From Message Count,Number of write messages sent from Ray Tracing unit to the Load Store Cache,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_HIT,LOAD_STORE_CACHE_HIT,Load Store Cache Hit,Number of Load Store Cache hits,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_ACCESS,LOAD_STORE_CACHE_ACCESS,Load Store Cache Access,Number of Load Store Cache accesses,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_NUMBER_OF_BANK_ACCESS_COUNT,LOAD_STORE_CACHE_NUMBER_OF_BANK_ACCESS_COUNT,Load Store Cache Number Of Bank Access Count,Number of Load Store Cache banks accessed in a clock,0,BMG LNL PTL\n"
                                             "SLM_BANK_CONFLICT_COUNT,SLM_BANK_CONFLICT_COUNT,SLM Bank Conflict Count,Number of SLM accesses resulting in a bank conflict,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT,LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT,Load Store Cache Partial Write Count,Number of writes to the Load Store Cache that don't fill a subsector,0,BMG LNL PTL\n"
                                             "EU_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT,XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT,XVE Load Store Cache Register Request Count,Number of message payload transactions sent by XVEs to the Load Store Cache,0,BMG LNL PTL\n"
                                             "EU_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT,XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT,XVE Load Store Cache Register Response Count,Number of message payload transactions sent from the Load Store Cache back to XVEs,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_INPUT_AVAILABLE,LOAD_STORE_CACHE_INPUT_AVAILABLE_CYCLES,Load Store Cache Input Available Cycles,Number of cycles the Load Store Cache has input available,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_OUTPUT_READY,LOAD_STORE_CACHE_OUTPUT_READY_CYCLES,Load Store Cache Output Ready Cycles,Number of cycles the Load Store Cache has output ready,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_BYTE_READ,LOAD_STORE_CACHE_BYTE_READ,Load Store Cache Byte Read,\"Number of bytes read out of the Load Store Cache, excluding SLM accesses\",0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_BYTE_WRITE,LOAD_STORE_CACHE_BYTE_WRITE,Load Store Cache Byte Write,\"Number of bytes written to the Load Store Cache, excluding SLM accesses\",0,BMG LNL PTL\n"
                                             "SLM_BYTE_READ,SLM_BYTE_READ,SLM Byte Read,Number of bytes read from SLM,0,BMG LNL PTL\n"
                                             "SLM_BYTE_WRITE,SLM_BYTE_WRITE,SLM Byte Write,Number of bytes written to SLM,0,BMG LNL PTL\n"
                                             "SLM_ACCESS_COUNT,SLM_ACCESS_COUNT,SLM Access Count,Number of SLM accesses,0,BMG LNL PTL\n"
                                             "RT_CLOSEST_HIT_THREAD_RAY_DISPATCH,RT_CLOSEST_HIT_THREAD_RAY_DISPATCH,RT Closest Hit Thread Ray Dispatch,Number of closest hit threads dispatched,0,BMG LNL PTL\n"
                                             "RT_MISS_THREAD_RAY_DISPATCH,RT_MISS_THREAD_RAY_DISPATCH,RT Miss Thread Ray Dispatch,Number of miss threads dispatched,0,BMG LNL PTL\n"
                                             "RT_INTERSECTION_THREAD_RAY_DISPATCH,RT_INTERSECTION_THREAD_RAY_DISPATCH,RT Intersection Thread Ray Dispatch,Number of intersection threads dispatched,0,BMG LNL PTL\n"
                                             "RT_ANY_HIT_THREAD_RAY_DISPATCH,RT_ANY_HIT_THREAD_RAY_DISPATCH,RT Any Hit Thread Ray Dispatch,Number of any hit threads dispatched,0,BMG LNL PTL\n"
                                             "RT_CALLABLE_THREAD_RAY_DISPATCH,RT_CALLABLE_THREAD_RAY_DISPATCH,RT Callable Thread Ray Dispatch,Number of BTD shader spawn requests dispatched,0,BMG LNL PTL\n"
                                             "RT_BVH_CACHE_MISS,RT_BVH_CACHE_MISS,RT BVH Cache Miss,Number of BVH cache misses,0,BMG LNL PTL\n"
                                             "RT_INPUT_MESSAGE_RAY_COUNT,RT_INPUT_MESSAGE_RAY_COUNT,RT Input Message Ray Count,Number of valid SIMD lanes in the TraceRay message,0,BMG LNL PTL\n"
                                             "RT_MESSAGE_STALL_COUNT,RT_MESSAGE_STALL_CYCLES,RT Message Stall Cycles,Number of cycles when Ray Tracing message input is stalled while accepting input,0,BMG LNL PTL\n"
                                             "RT_INPUT_MESSAGE_SPAWN_COUNT,RT_INPUT_MESSAGE_SPAWN_COUNT,RT Input Message Spawn Count,Number of valid SIMD lanes in the Spawn message,0,BMG LNL PTL\n"
                                             "RT_TRAVERSAL_STALL_COUNT,RT_TRAVERSAL_STALL_CYCLES,RT Traversal Stall Cycles,Number of cycles when Ray Tracing Frontend is stalled by Traversal,0,BMG LNL PTL\n"
                                             "RT_REQUEST_COLLISION,RT_REQUEST_COLLISION_CYCLES,RT Request Collision Cycles,Number of cycles when Ray Tracing Leaf has two Traversal inputs valid,0,BMG LNL PTL\n"
                                             "RT_TRAVERSAL_INPUT_RAY_COUNT,RT_TRAVERSAL_INPUT_RAY_COUNT,RT Traversal Input Ray Count,Number of Ray Tracing Traversal input rays,0,BMG LNL PTL\n"
                                             "RT_TRAVERSAL_OUTPUT_RAY_COUNT,RT_TRAVERSAL_OUTPUT_RAY_COUNT,RT Traversal Output Ray Count,Number of Ray Tracing Traversal output rays,0,BMG LNL PTL\n"
                                             "RT_TRAVERSAL_STEP_RAY_COUNT,RT_TRAVERSAL_STEP_RAY_COUNT,RT Traversal Step Ray Count,Number of BVH nodes processed,0,BMG LNL PTL\n"
                                             "RT_QUAD_TEST_RAY_COUNT,RT_QUAD_TEST_RAY_COUNT,RT Quad Test Ray Count,Number of nodes processed that use ray-quad intersection pipeline,0,BMG LNL PTL\n"
                                             "RT_TRANSFORM_RAY_COUNT,RT_TRANSFORM_RAY_COUNT,RT Transform Ray Count,Number of only HW transform accesses,0,BMG LNL PTL\n"
                                             "RT_INTERNAL_NODE_RAY_COUNT,RT_INTERNAL_NODE_RAY_COUNT,RT Internal Node Ray Count,Number of internal BVH nodes processed by the traversal function,0,BMG LNL PTL\n"
                                             "RT_PROCEDURAL_NODE_RAY_COUNT,RT_PROCEDURAL_NODE_RAY_COUNT,RT Procedural Node Ray Count,Number of procedural BVH nodes processed by the traversal function,0,BMG LNL PTL\n"
                                             "RT_INSTANCE_NODE_RAY_COUNT,RT_INSTANCE_NODE_RAY_COUNT,RT Instance Node Ray Count,Number of instance BVH nodes processed by the traversal function,0,BMG LNL PTL\n"
                                             "RT_QUAD_LEAF_RAY_COUNT,RT_QUAD_LEAF_RAY_COUNT,RT Quad Leaf Ray Count,Number of triangle BVH nodes processed by the traversal function,0,BMG LNL PTL\n"
                                             "RT_QUAD_LEAF_STOC_RAY_COUNT,RT_QUAD_LEAF_STOC_RAY_COUNT,RT Quad Leaf Stoc Ray Count,Number of quad leaf nodes with STOC masks processed by the traversal function,0,PTL\n"
                                             "RT_STOC_HIT_OPAQUE,RT_STOC_HIT_OPAQUE,RT Stoc Hit Opaque,Number of hits on quads with STOC masks evaluated as opaque,0,PTL\n"
                                             "RT_STOC_HIT_TRANSPARENT,RT_STOC_HIT_TRANSPARENT,RT Stoc Hit Transparent,Number of hits on quads with STOC masks evaluated as transparent (ignored),0,PTL\n"
                                             "GPGPU_DISPATCH_CYCLES,GPGPU_DISPATCH_CYCLES,GpGpu Dispatch Cycles,Number of cycles spent dispatching GPGPU threads to XVEs,0,BMG LNL PTL\n"
                                             "THREAD_DISPATCH_QUEUE0_ACTIVE_CYCLES,THREAD_DISPATCH_QUEUE0_ACTIVE_CYCLES,Thread Dispatch Queue0 Active Cycles,Number of cycles non-Pixel Shader threads are ready for dispatch in a particular Xe core,0,BMG LNL PTL\n"
                                             "THREAD_DISPATCH_QUEUE1_ACTIVE_CYCLES,THREAD_DISPATCH_QUEUE1_ACTIVE_CYCLES,Thread Dispatch Queue1 Active Cycles,Number of cycles non-Pixel Shader threads are ready for dispatch in a particular Xe core,0,BMG LNL PTL\n"
                                             "THREAD_DISPATCH_PS_ACTIVE_CYCLES,THREAD_DISPATCH_PS_ACTIVE_CYCLES,Thread Dispatch PS Active Cycles,Number of cycles Pixel Shader threads are ready for dispatch,0,BMG LNL PTL\n"
                                             "THREAD_DISPATCH_QUEUE0_STALL_CYCLES,THREAD_DISPATCH_QUEUE0_STALL_CYCLES,Thread Dispatch Queue0 Stall Cycles,Number of cycles queue 0 is stalled waiting for threads to be available,0,BMG LNL PTL\n"
                                             "THREAD_DISPATCH_INPUT_AVAILABLE,THREAD_DISPATCH_INPUT_AVAILABLE_CYCLES,Thread Dispatch Input Available Cycles,Number of cycles Thread Dispatch input is available,0,BMG LNL PTL\n"
                                             "THREAD_DISPATCH_QUEUE1_STALL_CYCLES,THREAD_DISPATCH_QUEUE1_STALL_CYCLES,Thread Dispatch Queue1 Stall Cycles,Number of cycles queue 1 is stalled waiting for threads to be available,0,BMG LNL PTL\n"
                                             "TASK_THREADGROUP_COUNT,TASK_THREADGROUP_COUNT,Task Threadgroup Count,Number of Task Shader threadgroups dispatched,0,BMG LNL PTL\n"
                                             "GPGPU_THREADGROUP_COUNT,GPGPU_THREADGROUP_COUNT,GpGpu Threadgroup Count,Number of GPGPU threadgroups dispatched,0,BMG LNL PTL\n"
                                             "ASYNC_GPGPU_THREADGROUP_COUNT,ASYNC_GPGPU_THREADGROUP_COUNT,Async GpGpu Threadgroup Count,Number of Async GPGPU threadgroups dispatched,0,BMG LNL PTL\n"
                                             "TASK_THREAD_EXIT_COUNT,TASK_THREAD_EXIT_COUNT,Task Thread Exit Count,Number of Task Shader EOT messages received,0,BMG LNL PTL\n"
                                             "ASYNC_GPGPU_THREAD_EXIT_COUNT,ASYNC_GPGPU_THREAD_EXIT_COUNT,Async GpGpu Thread Exit Count,Number of Async GPGPU EOT messages received,0,BMG LNL PTL\n"
                                             "THREADGROUP_DISPATCH_QUEUE0_RESOURCE_STALL_CYCLES,THREADGROUP_DISPATCH_QUEUE0_RESOURCE_STALL_CYCLES,Threadgroup Dispatch Queue0 Resource Stall Cycles,\"Number of cycles Thread Spawner queue 0 is stalled waiting for any resource to be available (for example, SLM, Barrier, BTD stack, etc.)\",0,BMG LNL PTL\n"
                                             "THREADGROUP_DISPATCH_QUEUE1_RESOURCE_STALL_CYCLES,THREADGROUP_DISPATCH_QUEUE1_RESOURCE_STALL_CYCLES,Threadgroup Dispatch Queue1 Resource Stall Cycles,\"Number of cycles Thread Spawner queue 1 is stalled waiting for any resource to be available (for example, SLM, Barrier, BTD stack, etc.)\",0,BMG LNL PTL\n"
                                             "TEST_EVENT1,TEST_EVENT1_CYCLES,Test Event1 Cycles,Number of GPU (gt) clock cycles at every clock period,0,BMG LNL PTL\n"
                                             "PIXEL_WRITE,PIXEL_WRITE,Pixel Write,Number of pixels written to all render targets,0,BMG LNL PTL\n"
                                             "PIXEL_BLEND,PIXEL_BLEND,Pixel Blend,Number of blended pixels written to all render targets,0,BMG LNL PTL\n"
                                             "COLOR_PIPE_CACHE_LATENCY2_STALL,COLOR_PIPE_CACHE_LATENCY2_STALL_CYCLES,Color Pipe Cache Latency2 Stall Cycles,Number of cycles Color Pipeline stalled due to Render Cache latency hiding structure full,0,BMG LNL PTL\n"
                                             "RENDER_CACHE_ALLOC,RENDER_CACHE_ALLOC,Render Cache Alloc,Number of Render Cache allocations,0,BMG LNL PTL\n"
                                             "RENDER_CACHE_HIT,RENDER_CACHE_HIT,Render Cache Hit,Number of Render Cache hits,0,BMG LNL PTL\n"
                                             "RENDER_CACHE_READ,RENDER_CACHE_READ,Render Cache Read,Number of Render Cache reads,0,BMG LNL PTL\n"
                                             "RENDER_CACHE_WRITE,RENDER_CACHE_WRITE,Render Cache Write,Number of Render Cache writes,0,BMG LNL PTL\n"
                                             "RENDER_CACHE_INPUT_AVAILABLE,RENDER_CACHE_INPUT_AVAILABLE_CYCLES,Render Cache Input Available Cycles,Number of cycles Render Cache input available,0,BMG LNL PTL\n"
                                             "RENDER_CACHE_OUTPUT_READY,RENDER_CACHE_OUTPUT_READY_CYCLES,Render Cache Output Ready Cycles,Number of cycles Render Cache output ready,0,BMG LNL PTL\n"
                                             "PIXEL_POST_PROCESS_OUTPUT_READY,PIXEL_POST_PROCESS_OUTPUT_READY_CYCLES,Pixel Post Process Output Ready Cycles,Number of cycles Color Pipeline pixel output ready,0,BMG LNL PTL\n"
                                             "COLOR_PIPE_CACHE_LATENCY1_STALL,COLOR_PIPE_CACHE_LATENCY1_STALL_CYCLES,Color Pipe Cache Latency1 Stall Cycles,Number of cycles Color Pipeline stalled due to MultiSampling Cache latency hiding structure full,0,BMG LNL PTL\n"
                                             "PIXEL_POST_PROCESS_INPUT_AVAILABLE,PIXEL_POST_PROCESS_INPUT_AVAILABLE_CYCLES,Pixel Post Process Input Available Cycles,Number of cycles Color Pipeline input ready,0,BMG LNL PTL\n"
                                             "STREAMOUT_PRIMITIVE_WRITE_COUNT,STREAMOUT_PRIMITIVE_WRITE_COUNT,Streamout Primitive Write Count,\"Number of objects data written to memory, read from pipe 0 only\",0,BMG LNL PTL\n"
                                             "STREAMOUT_PRIMITIVE_STORAGE_NEED,STREAMOUT_PRIMITIVE_STORAGE_NEED,Streamout Primitive Storage Need,\"Number of objects data that needed beyond the current allocated space, read from pipe 0 only\",0,BMG LNL PTL\n"
                                             "STREAMOUT_OUTPUT_VERTEX_COUNT,STREAMOUT_OUTPUT_VERTEX_COUNT,Streamout Output Vertex Count,Number of vertices written by SOL,0,BMG LNL PTL\n"
                                             "VS_OUTPUT_READY,VS_OUTPUT_READY_CYCLES,VS Output Ready Cycles,Number of cycles Vertex Shader output is ready,0,BMG LNL PTL\n"
                                             "IA_PRIMITIVE,IA_PRIMITIVE,IA Primitive,Number of primitives in a draw,0,BMG LNL PTL\n"
                                             "IA_VERTEX,IA_VERTEX,IA Vertex,Number of vertices in a draw,0,BMG LNL PTL\n"
                                             "VERTEX_FETCH_OUTPUT_READY,VERTEX_FETCH_OUTPUT_READY_CYCLES,Vertex Fetch Output Ready Cycles,Number of cycles Vertex Fetch output is ready,0,BMG LNL PTL\n"
                                             "VERTEX_FETCH_INPUT_AVAILABLE,VERTEX_FETCH_INPUT_AVAILABLE_CYCLES,Vertex Fetch Input Available Cycles,Number of cycles Vertex Fetch input is available,0,BMG LNL PTL\n"
                                             "COMPRESSOR_INPUT,COMPRESSOR_INPUT,Compressor Input,Number of 256B writes to compressible surfaces at the input of the compressor,0,BMG LNL PTL\n"
                                             "COMPRESSOR_OUTPUT,COMPRESSOR_OUTPUT,Compressor Output,Number of 256B writes to compressible surfaces at the output of the compressor,0,BMG LNL PTL\n"
                                             "URB_READ,URB_READ,URB Read,Number of URB reads,0,BMG LNL PTL\n"
                                             "URB_WRITE,URB_WRITE,URB Write,Number of URB writes,0,BMG LNL PTL\n"
                                             "URB_CROSS_SLICE_READ,URB_CROSS_SLICE_READ,URB Cross Slice Read,Number of URB reads occurred from cross slices,0,BMG LNL PTL\n"
                                             "HIZ_SUBSPAN_LATENCY_FIFOFULL,HIZ_SUBSPAN_LATENCY_FIFOFULL_CYCLES,HiZ Subspan Latency Fifofull Cycles,Number of cycles for which HiZ latency hiding structure full,0,BMG LNL PTL\n"
                                             "HIZ_DEPTH_TEST_PASS_P,HIZ_DEPTH_TEST_PASS_P,HiZ Depth Test Pass P,Number of promoted 2x2 passed by hierarchical depth test,0,BMG LNL PTL\n"
                                             "HIZ_DEPTH_TEST_AMBIG_P,HIZ_DEPTH_TEST_AMBIG_P,HiZ Depth Test Ambig P,Number of promoted 2x2 that are ambiguous by hierarchical depth test,0,BMG LNL PTL\n"
                                             "HIZ_DEPTH_TEST_FAIL_P,HIZ_DEPTH_TEST_FAIL_P,HiZ Depth Test Fail P,Number of promoted 2x2 that failed the hierarchical depth test,0,BMG LNL PTL\n"
                                             "HIZ_DEPTH_TEST_AMBIG_NP,HIZ_DEPTH_TEST_AMBIG_NP,HiZ Depth Test Ambig Np,Number of non-promoted 2x2 that are ambiguous by hierarchical depth test,0,BMG LNL PTL\n"
                                             "HIZ_DEPTH_TEST_FAIL_NP,HIZ_DEPTH_TEST_FAIL_NP,HiZ Depth Test Fail Np,Number of non-promoted 2x2 that failed the hierarchical depth test,0,BMG LNL PTL\n"
                                             "IZ_SUBSPAN_LATENCY_FIFOFULL,IZ_SUBSPAN_LATENCY_FIFOFULL_CYCLES,IZ Subspan Latency Fifofull Cycles,Number of cycles for which IZ latency hiding structure full,0,BMG LNL PTL\n"
                                             "POSTPS_DEPTH_STENCIL_TEST_FAIL,POSTPS_DEPTH_STENCIL_TEST_FAIL,PostPS Depth Stencil Test Fail,Number of 2x2 that were lit from Rasterizer but failed the depth or stencil test post shader,0,BMG LNL PTL\n"
                                             "EARLY_DEPTH_STENCIL_TEST_FAIL_P,EARLY_DEPTH_STENCIL_TEST_FAIL_P,Early Depth Stencil Test Fail P,Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ,0,BMG LNL PTL\n"
                                             "EARLY_DEPTH_STENCIL_TEST_FAIL_NP,EARLY_DEPTH_STENCIL_TEST_FAIL_NP,Early Depth Stencil Test Fail Np,Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ,0,BMG LNL PTL\n"
                                             "IZ_OUTPUT_READY,IZ_OUTPUT_READY_CYCLES,IZ Output Ready Cycles,Number of cycles IZ has requests to different clients,0,BMG LNL PTL\n"
                                             "AMFS_4X4_SHADING_REQUEST,AMFS_4X4_SHADING_REQUEST,AMFS 4x4 Shading Request,Number of Shading Request (evaluate) messages processed by AMFS,0,BMG LNL PTL\n"
                                             "AMFS_CACHE_HIT,AMFS_CACHE_HIT,AMFS Cache Hit,Number of hits in the AMFS cache,0,BMG LNL PTL\n"
                                             "AMFS_CACHE_MISS,AMFS_CACHE_MISS,AMFS Cache Miss,Number of cache misses in AMFS,0,BMG LNL PTL\n"
                                             "AMFS_STALL_ANY_INPUT,AMFS_STALL_ANY_INPUT_CYCLES,AMFS Stall Any Input Cycles,Number of cycles AMFS stalls at any of the color pipe inputs,0,BMG LNL PTL\n"
                                             "AMFS_STALL_ALL_INPUT,AMFS_STALL_ALL_INPUT_CYCLES,AMFS Stall All Input Cycles,Number of cycles AMFS stalls at both of the color pipe inputs,0,BMG LNL PTL\n"
                                             "COMMAND_PARSER_COPY_ENGINE_BUSY,COMMAND_PARSER_COPY_ENGINE_BUSY_CYCLES,Command Parser Copy Engine Busy Cycles,Number of cycles there is a context loaded and active on the copy queue.,0,BMG LNL PTL\n"
                                             "COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT,COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT,Command Parser Compute Engine Dispatch Kernel Count,Number of compute walker commands parsed on the compute engine,0,BMG LNL PTL\n"
                                             "COMMAND_PARSER_COMPUTE_ENGINE_BUSY,COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CYCLES,Command Parser Compute Engine Busy Cycles,Number of cycles there is a context loaded and active on the compute queue,0,BMG LNL PTL\n"
                                             "COMMAND_PARSER_FLUSH_COUNT,COMMAND_PARSER_FLUSH_COUNT,Command Parser Flush Count,Number of Stalling flushes at the top of the pipe,0,BMG LNL PTL\n"
                                             "COMMAND_PARSER_RENDER_ENGINE_DRAW_COUNT,COMMAND_PARSER_RENDER_ENGINE_DRAW_COUNT,Command Parser Render Engine Draw Count,Number of DRAW and MESH commands parsed on the 3D engine,0,BMG LNL PTL\n"
                                             "COMMAND_PARSER_RENDER_ENGINE_DISPATCH_KERNEL_COUNT,COMMAND_PARSER_RENDER_ENGINE_DISPATCH_KERNEL_COUNT,Command Parser Render Engine Dispatch Kernel Count,Number of compute walker commands parsed on the 3D engine,0,BMG LNL PTL\n"
                                             "COMMAND_PARSER_RENDER_ENGINE_BUSY,COMMAND_PARSER_RENDER_ENGINE_BUSY_CYCLES,Command Parser Render Engine Busy Cycles,Number of cycles there is a context loaded and active on the 3D queue,0,BMG LNL PTL\n"
                                             "GPU_BUSY,GPU_BUSY_CYCLES,GPU Busy Cycles,Number of cycles when GPU is not idle including all GPU engines,0,BMG LNL PTL\n"
                                             "TLB_MISS,TLB_MISS,TLB Miss,Number of misses from all TLBs and all engines,0,BMG LNL PTL\n"
                                             "GPU_MEMORY_L3_READ,GPU_MEMORY_L3_READ,GPU Memory L3 Read,Number of GTI memory reads from Device Cache caused by Device Cache misses,0,BMG LNL PTL\n"
                                             "GPU_MEMORY_L3_WRITE,GPU_MEMORY_L3_WRITE,GPU Memory L3 Write,Number of GTI memory writes from Device Cache caused by Device Cache invalidations,0,BMG LNL PTL\n"
                                             "GPU_MEMORY_READ,GPU_MEMORY_READ,GPU Memory Read,Number of GTI memory reads,0,BMG LNL PTL\n"
                                             "GPU_MEMORY_WRITE,GPU_MEMORY_WRITE,GPU Memory Write,Number of GTI memory writes,0,BMG LNL PTL\n"
                                             "GPU_MEMORY_REQUEST_QUEUE_FULL,GPU_MEMORY_REQUEST_QUEUE_FULL_CYCLES,GPU Memory Request Queue Full Cycles,Number of cycles when SQ is filled above a threshold (usually 48 entries),0,BMG LNL PTL\n"
                                             "GPU_MEMORY_CYCLES_ACTIVE,GPU_MEMORY_ACTIVE_CYCLES,GPU Memory Active Cycles,\"Number of cycles device local memory (HBM, GDDR, LPDDR, etc.) is active\",0,BMG LNL PTL\n"
                                             "GPU_MEMORY_64B_TRANSACTION_READ,GPU_MEMORY_64B_TRANSACTION_READ,GPU Memory 64b Transaction Read,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)\",0,BMG LNL PTL\n"
                                             "GPU_MEMORY_64B_TRANSACTION_WRITE,GPU_MEMORY_64B_TRANSACTION_WRITE,GPU Memory 64b Transaction Write,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)\",0,BMG LNL PTL\n"
                                             "GPU_MEMORY_32B_TRANSACTION_READ,GPU_MEMORY_32B_TRANSACTION_READ,GPU Memory 32b Transaction Read,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)\",0,BMG LNL PTL\n"
                                             "GPU_MEMORY_32B_TRANSACTION_WRITE,GPU_MEMORY_32B_TRANSACTION_WRITE,GPU Memory 32b Transaction Write,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)\",0,BMG LNL PTL\n"
                                             "GPU_MEMORY_BYTE_READ,GPU_MEMORY_BYTE_READ,GPU Memory Byte Read,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes\",0,BMG LNL PTL\n"
                                             "GPU_MEMORY_BYTE_WRITE,GPU_MEMORY_BYTE_WRITE,GPU Memory Byte Write,\"Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes\",0,BMG LNL PTL\n"
                                             "L3_INPUT_AVAILABLE,L3_INPUT_AVAILABLE_CYCLES,L3 Input Available Cycles,Number of cycles Device Cache bank has input requests,0,BMG LNL PTL\n"
                                             "L3_OUTPUT_READY,L3_OUTPUT_READY_CYCLES,L3 Output Ready Cycles,Number of cycles Device Cache bank has output ready,0,BMG LNL PTL\n"
                                             "L3_ATOMIC_ACCESS,L3_ATOMIC_ACCESS,L3 Atomic Access,Number of atomic accesses to Device Cache bank,0,BMG LNL PTL\n"
                                             "ICACHE_L3_READ,ICACHE_L3_READ,ICache L3 Read,Number of Device Cache read requests coming from XVE Instruction Cache,0,BMG LNL PTL\n"
                                             "ICACHE_L3_HIT,ICACHE_L3_HIT,ICache L3 Hit,Number of XVE instruction cache requests that hit the Device Cache,0,BMG LNL PTL\n"
                                             "SAMPLER_L3_READ,SAMPLER_L3_READ,Sampler L3 Read,Number of Device Cache read requests resulting from sampler local cache miss,0,BMG LNL PTL\n"
                                             "SAMPLER_L3_HIT,SAMPLER_L3_HIT,Sampler L3 Hit,Number of Device Cache hit requests resulting from sampler local cache miss which hits in Device Cache,0,BMG LNL PTL\n"
                                             "COLOR_L3_ACCESS,COLOR_L3_ACCESS,Color L3 Access,Number of Device Cache requests resulting from color local cache misses,0,BMG LNL PTL\n"
                                             "COLOR_L3_HIT,COLOR_L3_HIT,Color L3 Hit,Number of Device Cache requests resulting from color local cache miss which hits in Device Cache,0,BMG LNL PTL\n"
                                             "Z_L3_ACCESS,Z_L3_ACCESS,Z L3 Access,Number of Device Cache requests resulting from Z local cache misses,0,BMG LNL PTL\n"
                                             "Z_L3_HIT,Z_L3_HIT,Z L3 Hit,Number of Device Cache requests resulting from Z local cache miss which hits in Device Cache,0,BMG LNL PTL\n"
                                             "L3_READ,L3_READ,L3 Read,Number of Device Cache 64B read requests,0,BMG LNL PTL\n"
                                             "L3_WRITE,L3_WRITE,L3 Write,Number of Device Cache 64B write requests,0,BMG LNL PTL\n"
                                             "L3_MISS,L3_MISS,L3 Miss,Number of Device Cache accesses which miss in the Device Cache cache,0,BMG LNL PTL\n"
                                             "L3_HIT,L3_HIT,L3 Hit,Number of Device Cache accesses which hits in the Device Cache cache,0,BMG LNL PTL\n"
                                             "L3_SUPERQ_FULL,L3_SUPERQ_FULL_CYCLES,L3 Superq Full Cycles,Number of cycles all slots in Device Cache request queue are waiting for data return / response,0,BMG LNL PTL\n"
                                             "L3_BUSY,L3_BUSY_CYCLES,L3 Busy Cycles,Number of cycles Device Cache request queue has one or more requests pending,0,BMG LNL PTL\n"
                                             "L3_STALL,L3_STALL_CYCLES,L3 Stall Cycles,Number of cycles Device Cache bank stalled,0,BMG LNL PTL\n"
                                             "AMFS_L3_HIT,AMFS_L3_HIT,AMFS L3 Hit,Number of AMFS hits in Device Cache,0,BMG LNL PTL\n"
                                             "AMFS_L3_ACCESS,AMFS_L3_ACCESS,AMFS L3 Access,Number of AMFS access to Device Cache,0,BMG LNL PTL\n"
                                             "AMFS_L3_WRITE,AMFS_L3_WRITE,AMFS L3 Write,Number of AMFS writes to Device Cache,0,BMG LNL PTL\n"
                                             "AMFS_L3_ATOMIC,AMFS_L3_ATOMIC,AMFS L3 Atomic,Number of AMFS atomics to Device Cache,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_L3_READ,LOAD_STORE_CACHE_L3_READ,Load Store Cache L3 Read,Number of cacheline read requests from the Load Store Cache to Device Cache,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_L3_WRITE,LOAD_STORE_CACHE_L3_WRITE,Load Store Cache L3 Write,Number of cacheline write requests from the Load Store Cache to Device Cache,0,BMG LNL PTL\n"
                                             "LOAD_STORE_CACHE_L3_HIT,LOAD_STORE_CACHE_L3_HIT,Load Store Cache L3 Hit,Number of Load Store Cache requests to Device Cache that are hit,0,BMG LNL PTL\n"
                                             "HOST_TO_GPUMEM_TRANSACTION_READ,HOST_TO_GPUMEM_TRANSACTION_READ,Host To GpuMem Transaction Read,\"Number of host 64B reads to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)\",0,BMG\n"
                                             "HOST_TO_GPUMEM_TRANSACTION_WRITE,HOST_TO_GPUMEM_TRANSACTION_WRITE,Host To GpuMem Transaction Write,\"Number of host 64B writes to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)\",0,BMG\n"
                                             "SYSMEM_TRANSACTION_READ,SYSMEM_TRANSACTION_READ,SysMem Transaction Read,\"Number of system memory 64B reads (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)\",0,BMG\n"
                                             "SYSMEM_TRANSACTION_WRITE,SYSMEM_TRANSACTION_WRITE,SysMem Transaction Write,\"Number of system memory 64B writes (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)\",0,BMG\n"
                                             "CLIPPER_INPUT_AVAILABLE,CLIPPER_INPUT_AVAILABLE_CYCLES,Clipper Input Available Cycles,Number of cycles Clipper has input available (from Vertex Shader or SOL),0,BMG LNL PTL\n"
                                             "CLIPPER_PRIMITIVE_CULL,CLIPPER_PRIMITIVE_CULL,Clipper Primitive Cull,Number of Clipper early cull primitives,0,BMG LNL PTL\n"
                                             "CLIPPER_TRANSACTION_OUTPUT,CLIPPER_TRANSACTION_OUTPUT,Clipper Transaction Output,Number of elements pushed by Clipper into Stripsfan stage,0,BMG LNL PTL\n"
                                             "CLIPPER_INPUT_VERTEX,CLIPPER_INPUT_VERTEX,Clipper Input Vertex,Number of Clipper input vertices,0,BMG LNL PTL\n"
                                             "CLIPPER_OUTPUT_READY,CLIPPER_OUTPUT_READY_CYCLES,Clipper Output Ready Cycles,Number of cycles Clipper output ready,0,BMG LNL PTL\n"
                                             "CLIPPER_PRIMITIVE_OUTPUT,CLIPPER_PRIMITIVE_OUTPUT,Clipper Primitive Output,\"Number of primitives going out of Clipper, must clip plus the trivial accept. Must clip primitives are counted one time only.\",0,BMG LNL PTL\n"
                                             "CLIPPER_PRIMITIVE_FAR_NEAR_CLIP,CLIPPER_PRIMITIVE_FAR_NEAR_CLIP,Clipper Primitive Far Near Clip,Number of primitives clipped by Clipper due to near/far planes,0,BMG LNL PTL\n"
                                             "STRIPSFAN_OUTPUT_READY,STRIPSFAN_OUTPUT_READY_CYCLES,Stripsfan Output Ready Cycles,Number of cycles in which geometry pipeline output is ready,0,BMG LNL PTL\n"
                                             "STRIPSFAN_OBJECT_COUNT,STRIPSFAN_OBJECT_COUNT,Stripsfan Object Count,Number of objects exiting Stripsfan stage,0,BMG LNL PTL\n"
                                             "STRIPSFAN_OBJECT_CULL,STRIPSFAN_OBJECT_CULL,Stripsfan Object Cull,Number of simple and complex culled objects in Stripsfan stage,0,BMG LNL PTL\n"
                                             "RASTERIZER_INPUT_AVAILABLE,RASTERIZER_INPUT_AVAILABLE_CYCLES,Rasterizer Input Available Cycles,Number of cycles Rasterizer input is available,0,BMG LNL PTL\n"
                                             "PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH,PIXEL_2X2_LIT_POST_RASTERIZER_EARLY_DEPTH,Pixel 2x2 Lit Post Rasterizer Early Depth,Number of promoted 2x2 that are lit from Rasterizer,0,BMG LNL PTL\n"
                                             "PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH,PIXEL_2X2_LIT_POST_RASTERIZER_LATE_DEPTH,Pixel 2x2 Lit Post Rasterizer Late Depth,Number of non-promoted 2x2 that are lit from Rasterizer,0,BMG LNL PTL\n"
                                             "RASTERIZER_OUTPUT_READY,RASTERIZER_OUTPUT_READY_CYCLES,Rasterizer Output Ready Cycles,Number of cycles where rasterizer output is ready,0,BMG LNL PTL\n"
                                             "RASTERIZER_TRANSACTION_OUTPUT,RASTERIZER_TRANSACTION_OUTPUT,Rasterizer Transaction Output,Number of transactions pushed from Rasterizer to the Z pipe,0,BMG LNL PTL\n"
                                             "RASTERIZER_SAMPLE_OUTPUT,RASTERIZER_SAMPLE_OUTPUT,Rasterizer Sample Output,Number of lit samples emitted by Rasterizer,0,BMG LNL PTL\n"
                                             "COPY_ENGINE_READ_REQUEST,COPY_ENGINE_READ_REQUEST,Copy Engine Read Request,Number of read requests sent by the Copy Engine,0,BMG LNL PTL\n"
                                             "COPY_ENGINE_WRITE_REQUEST,COPY_ENGINE_WRITE_REQUEST,Copy Engine Write Request,Number of write requests sent by the Copy Engine,0,BMG LNL PTL\n"
                                             "COPY_ENGINE_REQUEST_STALL,COPY_ENGINE_REQUEST_STALL_CYCLES,Copy Engine Request Stall Cycles,Number of cycles copy engine is stalled on the memory path due to stall on the read or write path when there are commands pending within copy engine,0,BMG LNL PTL\n"
                                             "TEST_EVENT2,TEST_EVENT2_CYCLES,Test Event2 Cycles,Number of GPU (gt) clock cycles at every other clock period,0,BMG LNL PTL\n"
                                             "";

#endif

#if MD_INCLUDE_MTL_GT2_METRICS || MD_INCLUDE_MTL_GT3_METRICS || MD_INCLUDE_BMG_METRICS || MD_INCLUDE_LNL_METRICS || MD_INCLUDE_PTL_METRICS || MD_INCLUDE_ARL_GT1_METRICS || MD_INCLUDE_ARL_GT2_METRICS

const char ExternalEventsMedia::archEvents[1941] = "Group Mask,Event Encoding,Architectural Event Name,Event Definition,OA Reporting,OAM Unit,Project,Group Name,Metric Result Units,Metric Type,Hw Unit Type,Normalization\n"
                                                   "1,1,MEDIA_READ_REQUEST,Number of read requests from stand alone media,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,2,MEDIA_WRITE_REQUEST,Number of write requests from stand alone media,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,3,COMMAND_PARSER_GRAPHICS_SECURITY_CONTROLLER_BUSY,Number of GSCCS activities,M,SAG,MTL BMG LNL ARL,Media,cycles,1,0,1\n"
                                                   "1,512,COMMAND_PARSER_VIDEO_DECODE_ENGINE0_BUSY,Number of VCS0 (VDBOX0) activities,M,SCMI,MTL BMG LNL ARL,Media,cycles,1,0,1\n"
                                                   "1,513,VIDEO_DECODE_BOX0_READ_REQUEST,Number of VDBOX0 read requests,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,514,VIDEO_DECODE_BOX0_WRITE_REQUEST,Number of VDBOX0 write requests,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,1024,COMMAND_PARSER_VIDEO_DECODE_ENGINE1_BUSY,Number of VCS1 (VDBOX1) activities,M,SCMI,MTL BMG LNL ARL,Media,cycles,1,0,1\n"
                                                   "1,1025,VIDEO_DECODE_BOX1_READ_REQUEST,Number of VDBOX1 read requests,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,1026,VIDEO_DECODE_BOX1_WRITE_REQUEST,Number of VDBOX1 write requests,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,8704,COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE0_BUSY,Number of VECS0 (VEBOX0) activities,M,SCMI,MTL BMG LNL ARL,Media,cycles,1,0,1\n"
                                                   "1,8705,VIDEO_ENHANCEMENT_BOX0_READ_REQUEST,Number of VEBOX0 read requests,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,8706,VIDEO_ENHANCEMENT_BOX0_WRITE_REQUEST,Number of VEBOX0 write requests,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,9216,COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE1_BUSY,Number of VECS1 (VEBOX1) activities,M,SCMI,MTL BMG LNL ARL,Media,cycles,1,0,1\n"
                                                   "1,9217,VIDEO_ENHANCEMENT_BOX1_READ_REQUEST,Number of VEBOX1 read requests,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "1,9218,VIDEO_ENHANCEMENT_BOX1_WRITE_REQUEST,Number of VEBOX1 write requests,M,SCMI,MTL BMG LNL ARL,Media,events,1,0,0\n"
                                                   "";

const char ExternalEventsMedia::hwEvents[2517] = "Architectural Event Name,Hw Event Name,Hw Event Short Name,Hw Event Description,Project\n"
                                                 "MEDIA_READ_REQUEST,MEDIA_READ_REQUEST,Media Read Request,Number of read requests from stand alone media,MTL BMG LNL ARL\n"
                                                 "MEDIA_WRITE_REQUEST,MEDIA_WRITE_REQUEST,Media Write Request,Number of write requests from stand alone media,MTL BMG LNL ARL\n"
                                                 "COMMAND_PARSER_GRAPHICS_SECURITY_CONTROLLER_BUSY,COMMAND_PARSER_GRAPHICS_SECURITY_CONTROLLER_BUSY_CYCLES,Command Parser Graphics Security Controller Busy Cycles,Number of GSCCS activities,MTL BMG LNL ARL\n"
                                                 "COMMAND_PARSER_VIDEO_DECODE_ENGINE0_BUSY,COMMAND_PARSER_VIDEO_DECODE_ENGINE0_BUSY_CYCLES,Command Parser Video Decode Engine0 Busy Cycles,Number of VCS0 (VDBOX0) activities,MTL BMG LNL ARL\n"
                                                 "VIDEO_DECODE_BOX0_READ_REQUEST,VIDEO_DECODE_BOX0_READ_REQUEST,Video Decode Box0 Read Request,Number of VDBOX0 read requests,MTL BMG LNL ARL\n"
                                                 "VIDEO_DECODE_BOX0_WRITE_REQUEST,VIDEO_DECODE_BOX0_WRITE_REQUEST,Video Decode Box0 Write Request,Number of VDBOX0 write requests,MTL BMG LNL ARL\n"
                                                 "COMMAND_PARSER_VIDEO_DECODE_ENGINE1_BUSY,COMMAND_PARSER_VIDEO_DECODE_ENGINE1_BUSY_CYCLES,Command Parser Video Decode Engine1 Busy Cycles,Number of VCS1 (VDBOX1) activities,MTL BMG LNL ARL\n"
                                                 "VIDEO_DECODE_BOX1_READ_REQUEST,VIDEO_DECODE_BOX1_READ_REQUEST,Video Decode Box1 Read Request,Number of VDBOX1 read requests,MTL BMG LNL ARL\n"
                                                 "VIDEO_DECODE_BOX1_WRITE_REQUEST,VIDEO_DECODE_BOX1_WRITE_REQUEST,Video Decode Box1 Write Request,Number of VDBOX1 write requests,MTL BMG LNL ARL\n"
                                                 "COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE0_BUSY,COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE0_BUSY_CYCLES,Command Parser Video Enhancement Engine0 Busy Cycles,Number of VECS0 (VEBOX0) activities,MTL BMG LNL ARL\n"
                                                 "VIDEO_ENHANCEMENT_BOX0_READ_REQUEST,VIDEO_ENHANCEMENT_BOX0_READ_REQUEST,Video Enhancement Box0 Read Request,Number of VEBOX0 read requests,MTL BMG LNL ARL\n"
                                                 "VIDEO_ENHANCEMENT_BOX0_WRITE_REQUEST,VIDEO_ENHANCEMENT_BOX0_WRITE_REQUEST,Video Enhancement Box0 Write Request,Number of VEBOX0 write requests,MTL BMG LNL ARL\n"
                                                 "COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE1_BUSY,COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE1_BUSY_CYCLES,Command Parser Video Enhancement Engine1 Busy Cycles,Number of VECS1 (VEBOX1) activities,MTL BMG LNL ARL\n"
                                                 "VIDEO_ENHANCEMENT_BOX1_READ_REQUEST,VIDEO_ENHANCEMENT_BOX1_READ_REQUEST,Video Enhancement Box1 Read Request,Number of VEBOX1 read requests,MTL BMG LNL ARL\n"
                                                 "VIDEO_ENHANCEMENT_BOX1_WRITE_REQUEST,VIDEO_ENHANCEMENT_BOX1_WRITE_REQUEST,Video Enhancement Box1 Write Request,Number of VEBOX1 write requests,MTL BMG LNL ARL\n"
                                                 "";

#endif

#if MD_INCLUDE_BMG_METRICS || MD_INCLUDE_LNL_METRICS || MD_INCLUDE_PTL_METRICS

const char ExternalEventsWorkarounds::workarounds[409] = "Project,Type,Event,Equation\n"
                                                         "BMG LNL,1,Arch:GPU_MEMORY_BYTE_READ,2 UMUL\n"
                                                         "BMG LNL,1,Arch:GPU_MEMORY_BYTE_WRITE,2 UMUL\n"
                                                         "BMG LNL PTL,1,Arch:RENDER_CACHE_INPUT_AVAILABLE,2 UDIV\n"
                                                         "BMG LNL PTL,1,Arch:RENDER_CACHE_OUTPUT_READY,2 UDIV\n"
                                                         "BMG LNL,2,Arch:EU_THREADS_OCCUPANCY_ALL,8 UMUL\n"
                                                         "BMG LNL PTL,2,Arch:EU_INST_EXECUTED_SEND_ALL,1 UMUL\n"
                                                         "BMG LNL,3,Hw:GPU_MEMORY_BYTE_READ,256 UMUL\n"
                                                         "BMG LNL,3,Hw:GPU_MEMORY_BYTE_WRITE,256 UMUL\n"
                                                         "";

#endif
