/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.DelegatingFileSystem;
import com.intellij.platform.core.nio.fs.MultiRoutingFileSystemProvider;
import com.intellij.platform.core.nio.fs.MultiRoutingFsPath;
import com.intellij.platform.core.nio.fs.MultiRoutingWatchServiceDelegate;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.WatchService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiRoutingFileSystem
extends DelegatingFileSystem<MultiRoutingFileSystemProvider> {
    private final MultiRoutingFileSystemProvider myProvider;
    private final FileSystem myLocalFS;
    private final AtomicReference<@NotNull List<@NotNull Backend>> myBackends = new AtomicReference(Collections.emptyList());

    public MultiRoutingFileSystem(MultiRoutingFileSystemProvider provider, FileSystem localFS) {
        this.myProvider = provider;
        this.myLocalFS = localFS;
    }

    void computeBackend(@NotNull String root, boolean isPrefix, boolean caseSensitive, BiFunction<? super @NotNull FileSystemProvider, ? super @Nullable FileSystem, @Nullable FileSystem> compute) {
        if (root == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(0);
        }
        this.myBackends.updateAndGet(oldList -> {
            String sanitizedRoot = Backend.sanitizeRoot(root, caseSensitive);
            ArrayList newList = new ArrayList(oldList);
            ListIterator<Backend> iterator = newList.listIterator();
            FileSystem newFs = null;
            while (iterator.hasNext()) {
                Backend current = (Backend)iterator.next();
                if (!current.root.equals(sanitizedRoot)) continue;
                iterator.remove();
                newFs = (FileSystem)compute.apply(this.myProvider.myLocalProvider, current.fileSystem);
                if (newFs != null) break;
                return newList;
            }
            if (newFs == null && (newFs = (FileSystem)compute.apply(this.myProvider.myLocalProvider, null)) == null) {
                return newList;
            }
            iterator.add(new Backend(sanitizedRoot, isPrefix, caseSensitive, newFs));
            newList.sort((r1, r2) -> r2.root.length() - r1.root.length());
            return newList;
        });
    }

    @Override
    @NotNull
    public MultiRoutingFileSystemProvider provider() {
        MultiRoutingFileSystemProvider multiRoutingFileSystemProvider = this.myProvider;
        if (multiRoutingFileSystemProvider == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(1);
        }
        return multiRoutingFileSystemProvider;
    }

    @Override
    @NotNull
    protected FileSystem getDelegate() {
        FileSystem fileSystem = this.myLocalFS;
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(2);
        }
        return fileSystem;
    }

    @Override
    @NotNull
    protected FileSystem getDelegate(@NotNull String root) {
        if (root == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(3);
        }
        FileSystem fileSystem = MultiRoutingFileSystemProvider.ourForceDefaultFs ? this.myLocalFS : this.getBackend(root);
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(4);
        }
        return fileSystem;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        LinkedHashMap<String, MultiRoutingFsPath> rootDirectories = new LinkedHashMap<String, MultiRoutingFsPath>();
        for (Path root : this.myLocalFS.getRootDirectories()) {
            rootDirectories.put(root.toString(), new MultiRoutingFsPath(this, root));
        }
        block1: for (Backend backend : this.myBackends.get()) {
            for (Path candidate : backend.fileSystem.getRootDirectories()) {
                if (!backend.matchPath(candidate.toString())) continue;
                rootDirectories.put(candidate.toString(), new MultiRoutingFsPath(this, candidate));
                continue block1;
            }
        }
        return rootDirectories.values();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        LinkedHashSet<FileStore> result = new LinkedHashSet<FileStore>();
        for (FileStore fileStore : this.myLocalFS.getFileStores()) {
            result.add(fileStore);
        }
        for (Backend backend : this.myBackends.get()) {
            for (FileStore fileStore : backend.fileSystem.getFileStores()) {
                result.add(fileStore);
            }
        }
        return result;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.myLocalFS.supportedFileAttributeViews();
    }

    @NotNull
    FileSystem getBackend(@NotNull String path) {
        if (path == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(5);
        }
        for (Backend backend : this.myBackends.get()) {
            if (!backend.matchPath(path)) continue;
            FileSystem fileSystem = backend.fileSystem;
            if (fileSystem == null) {
                MultiRoutingFileSystem.$$$reportNull$$$0(6);
            }
            return fileSystem;
        }
        FileSystem fileSystem = this.myLocalFS;
        if (fileSystem == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(7);
        }
        return fileSystem;
    }

    public final boolean isRoutable(@NotNull Path path) {
        Path root;
        if (path == null) {
            MultiRoutingFileSystem.$$$reportNull$$$0(8);
        }
        if ((root = path.getRoot()) == null) {
            return false;
        }
        String rootRepresentation = root.toString();
        for (Backend backend : this.myBackends.get()) {
            if (!backend.matchPath(rootRepresentation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new MultiRoutingWatchServiceDelegate(super.newWatchService(), this.myProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "provider";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeBackend";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBackend";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRoutable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class Backend {
        @NotNull
        final String root;
        final boolean prefix;
        final boolean caseSensitive;
        @NotNull
        final FileSystem fileSystem;

        Backend(@NotNull String root, boolean prefix, boolean caseSensitive, @NotNull FileSystem fileSystem) {
            if (root == null) {
                Backend.$$$reportNull$$$0(0);
            }
            if (fileSystem == null) {
                Backend.$$$reportNull$$$0(1);
            }
            this.root = Backend.sanitizeRoot(root, caseSensitive);
            this.prefix = prefix;
            this.caseSensitive = caseSensitive;
            this.fileSystem = fileSystem;
        }

        @NotNull
        private static String sanitizeRoot(@NotNull String root, boolean caseSensitive) {
            if (root == null) {
                Backend.$$$reportNull$$$0(2);
            }
            root = root.replace(File.separatorChar, '/');
            root = root.substring(0, Backend.trimEndSlashes(root));
            if (!caseSensitive) {
                root = root.toLowerCase(Locale.ROOT);
            }
            String string = root;
            if (string == null) {
                Backend.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static int trimEndSlashes(@NotNull String root) {
            int i;
            if (root == null) {
                Backend.$$$reportNull$$$0(4);
            }
            for (i = root.length() - 1; i >= 0 && root.charAt(i) == '/'; --i) {
            }
            return i + 1;
        }

        boolean matchPath(@NotNull String candidate) {
            if (candidate == null) {
                Backend.$$$reportNull$$$0(5);
            }
            if (candidate.length() < this.root.length()) {
                return false;
            }
            for (int i = 0; i < this.root.length(); ++i) {
                char candidateChar = candidate.charAt(i);
                char rootChar = this.root.charAt(i);
                if (!this.caseSensitive && candidateChar >= 'A' && candidateChar <= 'Z') {
                    candidateChar = (char)(candidateChar - 65);
                    candidateChar = (char)(candidateChar + 97);
                } else if (candidateChar == '\\') {
                    candidateChar = '/';
                }
                if (candidateChar == rootChar) continue;
                return false;
            }
            return this.prefix || candidate.length() == this.root.length() || candidate.charAt(this.root.length()) == '/' || candidate.charAt(this.root.length()) == '\\';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileSystem";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem$Backend";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/core/nio/fs/MultiRoutingFileSystem$Backend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sanitizeRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "sanitizeRoot";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "trimEndSlashes";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "matchPath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

