/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 111695676981953L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-757453530 + -((char)-24997), 757453530 + (char)-31298, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-757453530 + -((char)-24996), -757453530 + -((char)-29954), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 123718360774749L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.m();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1827771150 + -30877, -1827771150 + -((char)-5030), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1827771150 + -30878, -1827771150 + -((char)-31416), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1827771150 + -30879, -1827771150 + -28867, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 120139715553961L;
                Object object = this.lock;
                int[] nArray = SshAgentIpcService.m();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-890358510 - -12692, 890358510 - 5119, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-890358510 - -12691, 890358510 + 446, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (nArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-890358510 - -12690, 890358510 + 6089, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-890358510 - -12697, 890358510 + 4053, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-890358510 - -12696, 890358510 - 6894, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-890358510 - -12690, 890358510 + 6089, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-890358510 - -12695, -890358510 + -12606, (int)l2));
            if (ActionTimestamp.v() != 0) {
                SshAgentIpcService.m(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 106101567914080L;
                    nArray = SshAgentIpcService.m();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 45228040121681L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                nArray = SshAgentIpcService.m();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray != null) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2034468540 + -22516, 2034468540 + 29711, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2034468540 + -22504, 2034468540 + 7827, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2034468540 + -22509, 2034468540 - 328, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2034468540 + -22504, 2034468540 + 7827, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2034468540 + -22510, 2034468540 + 25207, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2034468540 + -22516, 2034468540 + 29711, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2034468540 + -22504, 2034468540 + 7827, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2034468540 + -22511, 2034468540 - 1291, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2034468540 + -22516, 2034468540 + 29711, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2034468540 + -22504, 2034468540 + 7827, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2034468540 + -22512, -2034468540 + -26226, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-2034468540 + -22504, 2034468540 + 7827, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2034468540 + -22521, 2034468540 + 29663, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray != null) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-2034468540 + -22504, 2034468540 + 7827, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2034468540 + -22510, 2034468540 + 25207, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2034468540 + -22516, 2034468540 + 29711, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-2034468540 + -22504, 2034468540 + 7827, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2034468540 + -22522, -2034468540 - -82, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l2 = 82316748628616L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-594533520 + -19128, -594533520 + -10810, (int)l2));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l2 = 13357406278079L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(57932940 + (char)-20734, 57932940 + (char)-675, (int)l2));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "\u0013\u00ab\u00b7\u000b\u008c(\u0012jY\u00c2\u009eJ\u00d7\u00b8\u00faj]v\u00e4\u0014\u00b0\u009f\u00c3\u008b\u0019\u00fa\u00dd\u00b5\"?4!@,\u00c9s\u00d6\u0093\u0092\u00e9";
                    var4_3 = "\u0013\u00ab\u00b7\u000b\u008c(\u0012jY\u00c2\u009eJ\u00d7\u00b8\u00faj]v\u00e4\u0014\u00b0\u009f\u00c3\u008b\u0019\u00fa\u00dd\u00b5\"?4!@,\u00c9s\u00d6\u0093\u0092\u00e9".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 52;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 31;
                                    break;
                                }
                                case 1: {
                                    v11 = 9;
                                    break;
                                }
                                case 2: {
                                    v11 = 80;
                                    break;
                                }
                                case 3: {
                                    v11 = 109;
                                    break;
                                }
                                case 4: {
                                    v11 = 53;
                                    break;
                                }
                                case 5: {
                                    v11 = 70;
                                    break;
                                }
                                default: {
                                    v11 = 65;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0x7A30) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 179;
                        case 1 -> 139;
                        case 2 -> 253;
                        case 3 -> 114;
                        case 4 -> 0;
                        case 5 -> 148;
                        case 6 -> 165;
                        case 7 -> 83;
                        case 8 -> 240;
                        case 9 -> 64;
                        case 10 -> 252;
                        case 11 -> 226;
                        case 12 -> 122;
                        case 13 -> 109;
                        case 14 -> 92;
                        case 15 -> 42;
                        case 16 -> 134;
                        case 17 -> 102;
                        case 18 -> 47;
                        case 19 -> 27;
                        case 20 -> 3;
                        case 21 -> 72;
                        case 22 -> 232;
                        case 23 -> 168;
                        case 24 -> 71;
                        case 25 -> 99;
                        case 26 -> 18;
                        case 27 -> 157;
                        case 28 -> 213;
                        case 29 -> 169;
                        case 30 -> 251;
                        case 31 -> 85;
                        case 32 -> 70;
                        case 33 -> 231;
                        case 34 -> 152;
                        case 35 -> 57;
                        case 36 -> 115;
                        case 37 -> 144;
                        case 38 -> 136;
                        case 39 -> 178;
                        case 40 -> 22;
                        case 41 -> 145;
                        case 42 -> 105;
                        case 43 -> 209;
                        case 44 -> 224;
                        case 45 -> 211;
                        case 46 -> 79;
                        case 47 -> 66;
                        case 48 -> 158;
                        case 49 -> 53;
                        case 50 -> 111;
                        case 51 -> 197;
                        case 52 -> 130;
                        case 53 -> 38;
                        case 54 -> 7;
                        case 55 -> 133;
                        case 56 -> 104;
                        case 57 -> 212;
                        case 58 -> 243;
                        case 59 -> 48;
                        case 60 -> 176;
                        case 61 -> 10;
                        case 62 -> 214;
                        case 63 -> 98;
                        case 64 -> 59;
                        case 65 -> 73;
                        case 66 -> 68;
                        case 67 -> 181;
                        case 68 -> 194;
                        case 69 -> 182;
                        case 70 -> 132;
                        case 71 -> 170;
                        case 72 -> 127;
                        case 73 -> 121;
                        case 74 -> 206;
                        case 75 -> 188;
                        case 76 -> 219;
                        case 77 -> 103;
                        case 78 -> 124;
                        case 79 -> 30;
                        case 80 -> 242;
                        case 81 -> 4;
                        case 82 -> 90;
                        case 83 -> 88;
                        case 84 -> 25;
                        case 85 -> 141;
                        case 86 -> 248;
                        case 87 -> 162;
                        case 88 -> 31;
                        case 89 -> 202;
                        case 90 -> 55;
                        case 91 -> 87;
                        case 92 -> 167;
                        case 93 -> 28;
                        case 94 -> 93;
                        case 95 -> 58;
                        case 96 -> 126;
                        case 97 -> 191;
                        case 98 -> 153;
                        case 99 -> 138;
                        case 100 -> 61;
                        case 101 -> 113;
                        case 102 -> 189;
                        case 103 -> 19;
                        case 104 -> 65;
                        case 105 -> 205;
                        case 106 -> 150;
                        case 107 -> 56;
                        case 108 -> 101;
                        case 109 -> 198;
                        case 110 -> 119;
                        case 111 -> 215;
                        case 112 -> 201;
                        case 113 -> 45;
                        case 114 -> 241;
                        case 115 -> 74;
                        case 116 -> 84;
                        case 117 -> 29;
                        case 118 -> 175;
                        case 119 -> 11;
                        case 120 -> 174;
                        case 121 -> 94;
                        case 122 -> 86;
                        case 123 -> 23;
                        case 124 -> 100;
                        case 125 -> 75;
                        case 126 -> 82;
                        case 127 -> 106;
                        case 128 -> 245;
                        case 129 -> 155;
                        case 130 -> 78;
                        case 131 -> 254;
                        case 132 -> 80;
                        case 133 -> 62;
                        case 134 -> 177;
                        case 135 -> 227;
                        case 136 -> 14;
                        case 137 -> 8;
                        case 138 -> 223;
                        case 139 -> 143;
                        case 140 -> 17;
                        case 141 -> 69;
                        case 142 -> 37;
                        case 143 -> 50;
                        case 144 -> 196;
                        case 145 -> 166;
                        case 146 -> 192;
                        case 147 -> 233;
                        case 148 -> 44;
                        case 149 -> 247;
                        case 150 -> 36;
                        case 151 -> 246;
                        case 152 -> 128;
                        case 153 -> 218;
                        case 154 -> 9;
                        case 155 -> 97;
                        case 156 -> 52;
                        case 157 -> 228;
                        case 158 -> 195;
                        case 159 -> 2;
                        case 160 -> 12;
                        case 161 -> 172;
                        case 162 -> 151;
                        case 163 -> 140;
                        case 164 -> 123;
                        case 165 -> 46;
                        case 166 -> 116;
                        case 167 -> 159;
                        case 168 -> 108;
                        case 169 -> 193;
                        case 170 -> 137;
                        case 171 -> 21;
                        case 172 -> 15;
                        case 173 -> 142;
                        case 174 -> 249;
                        case 175 -> 217;
                        case 176 -> 187;
                        case 177 -> 163;
                        case 178 -> 147;
                        case 179 -> 238;
                        case 180 -> 239;
                        case 181 -> 24;
                        case 182 -> 180;
                        case 183 -> 32;
                        case 184 -> 207;
                        case 185 -> 185;
                        case 186 -> 221;
                        case 187 -> 60;
                        case 188 -> 229;
                        case 189 -> 43;
                        case 190 -> 161;
                        case 191 -> 35;
                        case 192 -> 255;
                        case 193 -> 34;
                        case 194 -> 230;
                        case 195 -> 95;
                        case 196 -> 54;
                        case 197 -> 117;
                        case 198 -> 1;
                        case 199 -> 16;
                        case 200 -> 6;
                        case 201 -> 237;
                        case 202 -> 67;
                        case 203 -> 208;
                        case 204 -> 204;
                        case 205 -> 183;
                        case 206 -> 81;
                        case 207 -> 203;
                        case 208 -> 220;
                        case 209 -> 235;
                        case 210 -> 107;
                        case 211 -> 33;
                        case 212 -> 77;
                        case 213 -> 63;
                        case 214 -> 236;
                        case 215 -> 154;
                        case 216 -> 20;
                        case 217 -> 164;
                        case 218 -> 125;
                        case 219 -> 118;
                        case 220 -> 173;
                        case 221 -> 41;
                        case 222 -> 200;
                        case 223 -> 39;
                        case 224 -> 26;
                        case 225 -> 49;
                        case 226 -> 112;
                        case 227 -> 216;
                        case 228 -> 234;
                        case 229 -> 135;
                        case 230 -> 129;
                        case 231 -> 91;
                        case 232 -> 160;
                        case 233 -> 244;
                        case 234 -> 110;
                        case 235 -> 96;
                        case 236 -> 222;
                        case 237 -> 190;
                        case 238 -> 184;
                        case 239 -> 146;
                        case 240 -> 171;
                        case 241 -> 76;
                        case 242 -> 13;
                        case 243 -> 250;
                        case 244 -> 89;
                        case 245 -> 156;
                        case 246 -> 186;
                        case 247 -> 5;
                        case 248 -> 199;
                        case 249 -> 120;
                        case 250 -> 210;
                        case 251 -> 131;
                        case 252 -> 149;
                        case 253 -> 225;
                        case 254 -> 40;
                        default -> 51;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (nArray != null) {
            int n3 = ActionTimestamp.m();
            ActionTimestamp.m(++n3);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 67264145404881L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.m();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-662558850 + -10158, 662558850 + 19401, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-662558850 + -10146, 662558850 + (char)-23731, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-662558850 + -10165, 662558850 + 24268, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-662558850 + -10158, 662558850 + 19401, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-662558850 + -10146, 662558850 + (char)-23731, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-662558850 + -10166, 662558850 + 11065, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 46200880497437L;
                        int[] nArray2 = SshAgentIpcService.m();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(82705170 - 11279, 82705170 - 166, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(82705170 - 11280, 82705170 - 23845, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 75457102523624L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    nArray = SshAgentIpcService.m();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1177926090 - 22753, -1177926090 - -30012, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1177926090 - 22757, -1177926090 - -((char)-24896), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1177926090 - 22742, -1177926090 - -((char)-32485), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1177926090 - 22757, -1177926090 - -((char)-24896), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1177926090 - 22747, -1177926090 - -25172, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1177926090 - 22753, -1177926090 - -30012, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1177926090 - 22757, -1177926090 - -((char)-24896), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1177926090 - 22741, 1177926090 - 31780, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1177926090 - 22753, -1177926090 - -30012, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1177926090 - 22757, -1177926090 - -((char)-24896), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1177926090 - 22736, 1177926090 - (char)-24263, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1177926090 - 22753, -1177926090 - -30012, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1177926090 - 22757, -1177926090 - -((char)-24896), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1177926090 - 22735, -1177926090 - -((char)-31303), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 81310393131810L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.m();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8715, -1927646490 + -((char)-466), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8727, -1927777560 - -((char)-18348), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8730, -1927777560 - -((char)-13057), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8731, -1927646490 + -((char)-2570), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8715, -1927646490 + -((char)-466), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8727, -1927777560 - -((char)-18348), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8732, -1927777560 - -((char)-13245), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8715, -1927646490 + -((char)-466), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8727, -1927777560 - -((char)-18348), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8733, -1927777560 - -((char)-25870), (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8715, -1927646490 + -((char)-466), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8727, -1927777560 - -((char)-18348), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8734, 1927777560 - (char)-11623, (int)l2));
                    if (nArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8715, -1927646490 + -((char)-466), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8727, -1927777560 - -((char)-18348), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1927777560 - (char)-8735, -1927777560 - -((char)-16484), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u0011\u00abb;\u00d8\u00d4\u0086\u00b2\u0014F,\u00b0,|\u00be\u00bd\u00e5\u009d\u0007\u00d3w\u00aa\u00d4\u00c2\u008f\u00e3N\u00faR\u0006\u00fb\u00f3?0\u0019\u00f4\u0018\u00f1,&\u001c,}\u00b5]Tm\u00e5J\n\u008c\u0084\u0006\u0082\u0016\u00f8\u00c4\u0011\u00ff\u0012E\tnRKb\u00ea-u\u001fp\u0005\u0005D\u00e0\u00c6\u00f8\b\u00b3*6z\u0000\u00da\u009b\u0091\u0005\u00f7\u00a6\u00be\u009a3\u001e\u00f6\u0094\u008b\u00b8\b-\u0093-5w\u0082\u008e\u00aa42u\u00b5\u00e9\u00cc\u00cf;\u00b1[A\\\u001a\u000f\u00a3\u00a2e\u0010M\u009e\u0018<-\u008f\u00c1\u0080\u0002p\u00e9\u0093\u00c1\u00c2\u00f04\t\u00a3\u0007$\u00d9T}\u0084\u008a\u00a0\u0010\u00ea\u000f\u00ec\u000e\u00b3\u00c9\u0012Hxi\u00a6\u00b0(\u00a6\u00cd\u00b8?hUP\u0080~#\u00d8\u0080-\u0013\u00c4\u00f9\u00dd,\u00e1O\n\u00cbFN\u00e4\u00d3\u00dbk\\\u00b7\u0002\u00a24\u0013O[\u00f1/\u00c5\u0088\u0084\u00b4\u008c\u000f\u0005\u00f9g\u00d4\u00c3\u00d6\u000e\u0016\u00d0T\u00f3\u00ea{\u0098\u00c9\u00f0\u00ee(\u00c3\u0016L\u00f1\u00fd\b\u00caT\u0019\u00b5\u00e5#'\u00ae\fP\u00b4Z\u00b2\u0090\u00a1g\u00f9\u00ff\u0017\u0004{F%\u00d9\u00f4\u001fE\u0014\u00ddO\u00a8\u00cd\u00e4\u00e4O\u0087\u00ac\u001c_\u00c6\u00ec@\u00a3@0+\u0017\u0094\u0098\u00cd\u00d8\u00d7\u00e8\u00ff9\r\u001e\u00ed%U\u0013\u00f7e\u00f3\u00e0n\u00ed\u0004\u009f1\u0005H/\u00c3\u000f+Q\u009db\u00f1\u00c4\u0091\u009fh\u00db\u00ea\u00fd\u00b7I\u00cd\u0018+\u001f\u008b>$\u00ed\u00fd\u0087-x\u00e2\u00ddx\u00db\u00f5\u0083\u00d22\u00d2\u00e9]\u0005\u00c2h\u00b3\u00d1 \u00d8\u00977\u00ac\u0006d\u000bC\u00068\u00e4\u00dck\u00ee\u00a0\u00ce0(\u0015!\u00bct\u00b0R\u0089\u00d3\u0081W\u00f4\u00d35>\u00f2\u00b6J\u00a5rn\u000f\u0092)\u00f6T\u008b\u00a0\b.\u0093M5{\u0082\u000f\u00ae\u0013'%3\u0083\u00ba\u00ef\u00ceM\u00f4m\u00a7\u0006\u00b0\u0094g\u0086\u009f\u00eb)*z\u0084\u00b7e\u00caX\u00fd\u0007\u00d19e\u0017\u00f1\u00857\u0007\u0090\u001c)\u00df\u009fs\u00ec(\u0013j{F\u00a6\u0098\u00b0\u00bc!\u0092*\u0004\u0098\u00f3\u00a3\u00ba\u00a4\u00dd\u00e6g$b\u00c6Cq\u007f\u00dc\u00c0\u00ddl\u0013\u00afC\u00c9\u00a9Uw\"AC\u000f*\u0097\u0012\u00d0c&\u00ad\u00a8\u00f7\u009dQ\u00b4W\u00b1\u00c4\"\u00cb\u00ec,\u00b7\u00fc\u00cc\r\u0011\u00e6\u00f0\u00f8~\u00e21\u00ca\u00afe\u00fb\u00fa\u00a2,\u00e4\b\b\u00ab\u00fe\u00fcU\u00ca\u008c\u0088\u00ad\u00e5\u0011\u000e\u0014\u00cc\u00d5\u00bb\u009bK\u00b2\u0005\u0014(-\u0002\u00d4m\u001b\u00f2#\u000eC\u001b\u00e17\f\u00f3\u008e\\\u00d7\u00aa\u00e1\u00e5\u00a3(\u00d0\u00ee[\u0095\u00efL\u00cfhk\u00d1\n>\u009fS\u00d3\u00a4\u0017\u0013\u00f8\u00dcr\u0018\u0017\u00c0\u00b22\u008ds\u00c4\u0000\u0093\u00c6\u0092A\u00ca`\u0015\u00b2A\u00f3\u0014F\u00b2\u0007\u00f3\u0081)\u0001\u00efu\u00d7\u00d7\u00c0h\u0090J\u00c0mxW\u00f4\u0087\u00a2Y\u0006(\u009a\u00a6\u00f3\u00b0\u00b6Z\u00ef\u0092Ep\u00e0\u00c6\u00b6'_n\u00be\u00eb\u0006A4\u008c";
                var4_3 = "\u0011\u00abb;\u00d8\u00d4\u0086\u00b2\u0014F,\u00b0,|\u00be\u00bd\u00e5\u009d\u0007\u00d3w\u00aa\u00d4\u00c2\u008f\u00e3N\u00faR\u0006\u00fb\u00f3?0\u0019\u00f4\u0018\u00f1,&\u001c,}\u00b5]Tm\u00e5J\n\u008c\u0084\u0006\u0082\u0016\u00f8\u00c4\u0011\u00ff\u0012E\tnRKb\u00ea-u\u001fp\u0005\u0005D\u00e0\u00c6\u00f8\b\u00b3*6z\u0000\u00da\u009b\u0091\u0005\u00f7\u00a6\u00be\u009a3\u001e\u00f6\u0094\u008b\u00b8\b-\u0093-5w\u0082\u008e\u00aa42u\u00b5\u00e9\u00cc\u00cf;\u00b1[A\\\u001a\u000f\u00a3\u00a2e\u0010M\u009e\u0018<-\u008f\u00c1\u0080\u0002p\u00e9\u0093\u00c1\u00c2\u00f04\t\u00a3\u0007$\u00d9T}\u0084\u008a\u00a0\u0010\u00ea\u000f\u00ec\u000e\u00b3\u00c9\u0012Hxi\u00a6\u00b0(\u00a6\u00cd\u00b8?hUP\u0080~#\u00d8\u0080-\u0013\u00c4\u00f9\u00dd,\u00e1O\n\u00cbFN\u00e4\u00d3\u00dbk\\\u00b7\u0002\u00a24\u0013O[\u00f1/\u00c5\u0088\u0084\u00b4\u008c\u000f\u0005\u00f9g\u00d4\u00c3\u00d6\u000e\u0016\u00d0T\u00f3\u00ea{\u0098\u00c9\u00f0\u00ee(\u00c3\u0016L\u00f1\u00fd\b\u00caT\u0019\u00b5\u00e5#'\u00ae\fP\u00b4Z\u00b2\u0090\u00a1g\u00f9\u00ff\u0017\u0004{F%\u00d9\u00f4\u001fE\u0014\u00ddO\u00a8\u00cd\u00e4\u00e4O\u0087\u00ac\u001c_\u00c6\u00ec@\u00a3@0+\u0017\u0094\u0098\u00cd\u00d8\u00d7\u00e8\u00ff9\r\u001e\u00ed%U\u0013\u00f7e\u00f3\u00e0n\u00ed\u0004\u009f1\u0005H/\u00c3\u000f+Q\u009db\u00f1\u00c4\u0091\u009fh\u00db\u00ea\u00fd\u00b7I\u00cd\u0018+\u001f\u008b>$\u00ed\u00fd\u0087-x\u00e2\u00ddx\u00db\u00f5\u0083\u00d22\u00d2\u00e9]\u0005\u00c2h\u00b3\u00d1 \u00d8\u00977\u00ac\u0006d\u000bC\u00068\u00e4\u00dck\u00ee\u00a0\u00ce0(\u0015!\u00bct\u00b0R\u0089\u00d3\u0081W\u00f4\u00d35>\u00f2\u00b6J\u00a5rn\u000f\u0092)\u00f6T\u008b\u00a0\b.\u0093M5{\u0082\u000f\u00ae\u0013'%3\u0083\u00ba\u00ef\u00ceM\u00f4m\u00a7\u0006\u00b0\u0094g\u0086\u009f\u00eb)*z\u0084\u00b7e\u00caX\u00fd\u0007\u00d19e\u0017\u00f1\u00857\u0007\u0090\u001c)\u00df\u009fs\u00ec(\u0013j{F\u00a6\u0098\u00b0\u00bc!\u0092*\u0004\u0098\u00f3\u00a3\u00ba\u00a4\u00dd\u00e6g$b\u00c6Cq\u007f\u00dc\u00c0\u00ddl\u0013\u00afC\u00c9\u00a9Uw\"AC\u000f*\u0097\u0012\u00d0c&\u00ad\u00a8\u00f7\u009dQ\u00b4W\u00b1\u00c4\"\u00cb\u00ec,\u00b7\u00fc\u00cc\r\u0011\u00e6\u00f0\u00f8~\u00e21\u00ca\u00afe\u00fb\u00fa\u00a2,\u00e4\b\b\u00ab\u00fe\u00fcU\u00ca\u008c\u0088\u00ad\u00e5\u0011\u000e\u0014\u00cc\u00d5\u00bb\u009bK\u00b2\u0005\u0014(-\u0002\u00d4m\u001b\u00f2#\u000eC\u001b\u00e17\f\u00f3\u008e\\\u00d7\u00aa\u00e1\u00e5\u00a3(\u00d0\u00ee[\u0095\u00efL\u00cfhk\u00d1\n>\u009fS\u00d3\u00a4\u0017\u0013\u00f8\u00dcr\u0018\u0017\u00c0\u00b22\u008ds\u00c4\u0000\u0093\u00c6\u0092A\u00ca`\u0015\u00b2A\u00f3\u0014F\u00b2\u0007\u00f3\u0081)\u0001\u00efu\u00d7\u00d7\u00c0h\u0090J\u00c0mxW\u00f4\u0087\u00a2Y\u0006(\u009a\u00a6\u00f3\u00b0\u00b6Z\u00ef\u0092Ep\u00e0\u00c6\u00b6'_n\u00be\u00eb\u0006A4\u008c".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 14;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0084p\u001e\u00f7\u00c7\u00a9~\u0095\u009c\u001d\u00a9z\u00be\u00bbp\u0093B$\u00d1\u0088\u00c0\u00af<\u00d04\u00f8\u00f1\u009f\u00b3\u00f3^?\u0082/i\u001e\u00bb\u00e0\u001b";
                    var4_3 = "\u0084p\u001e\u00f7\u00c7\u00a9~\u0095\u009c\u001d\u00a9z\u00be\u00bbp\u0093B$\u00d1\u0088\u00c0\u00af<\u00d04\u00f8\u00f1\u009f\u00b3\u00f3^?\u0082/i\u001e\u00bb\u00e0\u001b".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 90;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 77;
                            break;
                        }
                        case 1: {
                            v15 = 47;
                            break;
                        }
                        case 2: {
                            v15 = 40;
                            break;
                        }
                        case 3: {
                            v15 = 69;
                            break;
                        }
                        case 4: {
                            v15 = 112;
                            break;
                        }
                        case 5: {
                            v15 = 124;
                            break;
                        }
                        default: {
                            v15 = 114;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFCC0A) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 141;
                case 1 -> 203;
                case 2 -> 3;
                case 3 -> 96;
                case 4 -> 1;
                case 5 -> 157;
                case 6 -> 12;
                case 7 -> 127;
                case 8 -> 241;
                case 9 -> 138;
                case 10 -> 213;
                case 11 -> 56;
                case 12 -> 46;
                case 13 -> 29;
                case 14 -> 64;
                case 15 -> 249;
                case 16 -> 218;
                case 17 -> 248;
                case 18 -> 159;
                case 19 -> 183;
                case 20 -> 22;
                case 21 -> 35;
                case 22 -> 47;
                case 23 -> 227;
                case 24 -> 104;
                case 25 -> 135;
                case 26 -> 15;
                case 27 -> 45;
                case 28 -> 53;
                case 29 -> 232;
                case 30 -> 98;
                case 31 -> 92;
                case 32 -> 28;
                case 33 -> 166;
                case 34 -> 156;
                case 35 -> 70;
                case 36 -> 162;
                case 37 -> 21;
                case 38 -> 17;
                case 39 -> 221;
                case 40 -> 61;
                case 41 -> 25;
                case 42 -> 108;
                case 43 -> 20;
                case 44 -> 252;
                case 45 -> 113;
                case 46 -> 79;
                case 47 -> 62;
                case 48 -> 169;
                case 49 -> 8;
                case 50 -> 78;
                case 51 -> 68;
                case 52 -> 133;
                case 53 -> 239;
                case 54 -> 76;
                case 55 -> 142;
                case 56 -> 198;
                case 57 -> 238;
                case 58 -> 208;
                case 59 -> 32;
                case 60 -> 134;
                case 61 -> 224;
                case 62 -> 150;
                case 63 -> 207;
                case 64 -> 109;
                case 65 -> 212;
                case 66 -> 128;
                case 67 -> 115;
                case 68 -> 146;
                case 69 -> 215;
                case 70 -> 16;
                case 71 -> 81;
                case 72 -> 177;
                case 73 -> 201;
                case 74 -> 131;
                case 75 -> 250;
                case 76 -> 173;
                case 77 -> 122;
                case 78 -> 93;
                case 79 -> 140;
                case 80 -> 73;
                case 81 -> 181;
                case 82 -> 55;
                case 83 -> 149;
                case 84 -> 155;
                case 85 -> 126;
                case 86 -> 185;
                case 87 -> 154;
                case 88 -> 114;
                case 89 -> 118;
                case 90 -> 182;
                case 91 -> 100;
                case 92 -> 194;
                case 93 -> 82;
                case 94 -> 94;
                case 95 -> 192;
                case 96 -> 148;
                case 97 -> 67;
                case 98 -> 71;
                case 99 -> 24;
                case 100 -> 170;
                case 101 -> 63;
                case 102 -> 39;
                case 103 -> 151;
                case 104 -> 206;
                case 105 -> 251;
                case 106 -> 234;
                case 107 -> 102;
                case 108 -> 153;
                case 109 -> 9;
                case 110 -> 10;
                case 111 -> 214;
                case 112 -> 37;
                case 113 -> 85;
                case 114 -> 184;
                case 115 -> 176;
                case 116 -> 33;
                case 117 -> 43;
                case 118 -> 105;
                case 119 -> 147;
                case 120 -> 112;
                case 121 -> 139;
                case 122 -> 237;
                case 123 -> 171;
                case 124 -> 40;
                case 125 -> 129;
                case 126 -> 74;
                case 127 -> 89;
                case 128 -> 31;
                case 129 -> 243;
                case 130 -> 84;
                case 131 -> 188;
                case 132 -> 14;
                case 133 -> 38;
                case 134 -> 230;
                case 135 -> 195;
                case 136 -> 199;
                case 137 -> 175;
                case 138 -> 7;
                case 139 -> 106;
                case 140 -> 5;
                case 141 -> 246;
                case 142 -> 120;
                case 143 -> 164;
                case 144 -> 196;
                case 145 -> 190;
                case 146 -> 143;
                case 147 -> 180;
                case 148 -> 197;
                case 149 -> 97;
                case 150 -> 168;
                case 151 -> 222;
                case 152 -> 0;
                case 153 -> 236;
                case 154 -> 130;
                case 155 -> 60;
                case 156 -> 110;
                case 157 -> 187;
                case 158 -> 11;
                case 159 -> 95;
                case 160 -> 18;
                case 161 -> 247;
                case 162 -> 228;
                case 163 -> 30;
                case 164 -> 160;
                case 165 -> 205;
                case 166 -> 54;
                case 167 -> 240;
                case 168 -> 103;
                case 169 -> 204;
                case 170 -> 26;
                case 171 -> 167;
                case 172 -> 217;
                case 173 -> 72;
                case 174 -> 124;
                case 175 -> 193;
                case 176 -> 48;
                case 177 -> 58;
                case 178 -> 101;
                case 179 -> 52;
                case 180 -> 90;
                case 181 -> 219;
                case 182 -> 233;
                case 183 -> 87;
                case 184 -> 253;
                case 185 -> 220;
                case 186 -> 189;
                case 187 -> 144;
                case 188 -> 235;
                case 189 -> 65;
                case 190 -> 34;
                case 191 -> 186;
                case 192 -> 226;
                case 193 -> 111;
                case 194 -> 91;
                case 195 -> 66;
                case 196 -> 117;
                case 197 -> 178;
                case 198 -> 254;
                case 199 -> 88;
                case 200 -> 216;
                case 201 -> 132;
                case 202 -> 158;
                case 203 -> 50;
                case 204 -> 116;
                case 205 -> 137;
                case 206 -> 23;
                case 207 -> 107;
                case 208 -> 41;
                case 209 -> 223;
                case 210 -> 229;
                case 211 -> 80;
                case 212 -> 13;
                case 213 -> 42;
                case 214 -> 136;
                case 215 -> 119;
                case 216 -> 69;
                case 217 -> 242;
                case 218 -> 77;
                case 219 -> 172;
                case 220 -> 19;
                case 221 -> 44;
                case 222 -> 165;
                case 223 -> 75;
                case 224 -> 163;
                case 225 -> 161;
                case 226 -> 99;
                case 227 -> 200;
                case 228 -> 145;
                case 229 -> 36;
                case 230 -> 202;
                case 231 -> 174;
                case 232 -> 245;
                case 233 -> 57;
                case 234 -> 255;
                case 235 -> 2;
                case 236 -> 27;
                case 237 -> 152;
                case 238 -> 123;
                case 239 -> 83;
                case 240 -> 59;
                case 241 -> 121;
                case 242 -> 51;
                case 243 -> 244;
                case 244 -> 211;
                case 245 -> 49;
                case 246 -> 225;
                case 247 -> 86;
                case 248 -> 231;
                case 249 -> 209;
                case 250 -> 179;
                case 251 -> 4;
                case 252 -> 6;
                case 253 -> 191;
                case 254 -> 125;
                default -> 210;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 73344891722326L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(264761400 + (char)-30279, 264761400 + 12093, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 84943416630125L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.m();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1848349140 + -((char)-2719), 1848349140 + (char)-3317, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1848349140 + -((char)-2716), 1848480210 - (char)-17262, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1848349140 + -((char)-2717), -1848480210 - -((char)-10409), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00c0o\u00db_C7m\u00af\u0010\u0016\u00a9\u00f0&\u009c\u00a3odWo\u00bf\u00dcd\u00b3%\u009a";
                    var4_3 = "\u00c0o\u00db_C7m\u00af\u0010\u0016\u00a9\u00f0&\u009c\u00a3odWo\u00bf\u00dcd\u00b3%\u009a".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 113;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a1\u00b1^-*55\t\u00dbVH=D\u00b5\u00ecG\u00f3\u00b0\u00b3}s`l\u00b2\u00186\u0002\u0091\u0082]C\u00db84+\u00d8W0\u000b8\u00af\u00e3%\u00d9\u00a9\u00cc\u00d7\u009fb\u00d9\u001c\u00c9\u0002\u00a1\u00d4\u009cI\u00fc<";
                        var4_3 = "\u00a1\u00b1^-*55\t\u00dbVH=D\u00b5\u00ecG\u00f3\u00b0\u00b3}s`l\u00b2\u00186\u0002\u0091\u0082]C\u00db84+\u00d8W0\u000b8\u00af\u00e3%\u00d9\u00a9\u00cc\u00d7\u009fb\u00d9\u001c\u00c9\u0002\u00a1\u00d4\u009cI\u00fc<".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 93;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 94;
                                break;
                            }
                            case 1: {
                                v15 = 118;
                                break;
                            }
                            case 2: {
                                v15 = 89;
                                break;
                            }
                            case 3: {
                                v15 = 2;
                                break;
                            }
                            case 4: {
                                v15 = 98;
                                break;
                            }
                            case 5: {
                                v15 = 107;
                                break;
                            }
                            default: {
                                v15 = 56;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFE3A7) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 19;
                    case 1 -> 248;
                    case 2 -> 246;
                    case 3 -> 152;
                    case 4 -> 202;
                    case 5 -> 192;
                    case 6 -> 15;
                    case 7 -> 179;
                    case 8 -> 203;
                    case 9 -> 214;
                    case 10 -> 156;
                    case 11 -> 242;
                    case 12 -> 219;
                    case 13 -> 2;
                    case 14 -> 144;
                    case 15 -> 64;
                    case 16 -> 208;
                    case 17 -> 83;
                    case 18 -> 229;
                    case 19 -> 122;
                    case 20 -> 63;
                    case 21 -> 136;
                    case 22 -> 162;
                    case 23 -> 37;
                    case 24 -> 109;
                    case 25 -> 164;
                    case 26 -> 239;
                    case 27 -> 240;
                    case 28 -> 186;
                    case 29 -> 3;
                    case 30 -> 6;
                    case 31 -> 72;
                    case 32 -> 102;
                    case 33 -> 236;
                    case 34 -> 231;
                    case 35 -> 92;
                    case 36 -> 255;
                    case 37 -> 99;
                    case 38 -> 161;
                    case 39 -> 73;
                    case 40 -> 22;
                    case 41 -> 23;
                    case 42 -> 30;
                    case 43 -> 38;
                    case 44 -> 42;
                    case 45 -> 141;
                    case 46 -> 54;
                    case 47 -> 133;
                    case 48 -> 116;
                    case 49 -> 209;
                    case 50 -> 170;
                    case 51 -> 75;
                    case 52 -> 79;
                    case 53 -> 70;
                    case 54 -> 220;
                    case 55 -> 129;
                    case 56 -> 247;
                    case 57 -> 84;
                    case 58 -> 32;
                    case 59 -> 118;
                    case 60 -> 21;
                    case 61 -> 215;
                    case 62 -> 169;
                    case 63 -> 194;
                    case 64 -> 90;
                    case 65 -> 165;
                    case 66 -> 40;
                    case 67 -> 150;
                    case 68 -> 227;
                    case 69 -> 184;
                    case 70 -> 228;
                    case 71 -> 119;
                    case 72 -> 224;
                    case 73 -> 81;
                    case 74 -> 233;
                    case 75 -> 111;
                    case 76 -> 120;
                    case 77 -> 26;
                    case 78 -> 238;
                    case 79 -> 154;
                    case 80 -> 60;
                    case 81 -> 178;
                    case 82 -> 45;
                    case 83 -> 177;
                    case 84 -> 104;
                    case 85 -> 244;
                    case 86 -> 145;
                    case 87 -> 4;
                    case 88 -> 57;
                    case 89 -> 172;
                    case 90 -> 146;
                    case 91 -> 128;
                    case 92 -> 130;
                    case 93 -> 0;
                    case 94 -> 77;
                    case 95 -> 18;
                    case 96 -> 114;
                    case 97 -> 197;
                    case 98 -> 235;
                    case 99 -> 48;
                    case 100 -> 7;
                    case 101 -> 33;
                    case 102 -> 59;
                    case 103 -> 24;
                    case 104 -> 251;
                    case 105 -> 160;
                    case 106 -> 155;
                    case 107 -> 159;
                    case 108 -> 190;
                    case 109 -> 241;
                    case 110 -> 232;
                    case 111 -> 88;
                    case 112 -> 182;
                    case 113 -> 9;
                    case 114 -> 237;
                    case 115 -> 85;
                    case 116 -> 51;
                    case 117 -> 205;
                    case 118 -> 210;
                    case 119 -> 200;
                    case 120 -> 50;
                    case 121 -> 39;
                    case 122 -> 157;
                    case 123 -> 139;
                    case 124 -> 31;
                    case 125 -> 10;
                    case 126 -> 143;
                    case 127 -> 78;
                    case 128 -> 115;
                    case 129 -> 175;
                    case 130 -> 148;
                    case 131 -> 27;
                    case 132 -> 127;
                    case 133 -> 65;
                    case 134 -> 201;
                    case 135 -> 62;
                    case 136 -> 110;
                    case 137 -> 147;
                    case 138 -> 249;
                    case 139 -> 1;
                    case 140 -> 67;
                    case 141 -> 123;
                    case 142 -> 142;
                    case 143 -> 168;
                    case 144 -> 234;
                    case 145 -> 17;
                    case 146 -> 176;
                    case 147 -> 254;
                    case 148 -> 41;
                    case 149 -> 68;
                    case 150 -> 131;
                    case 151 -> 171;
                    case 152 -> 163;
                    case 153 -> 174;
                    case 154 -> 25;
                    case 155 -> 206;
                    case 156 -> 158;
                    case 157 -> 243;
                    case 158 -> 5;
                    case 159 -> 69;
                    case 160 -> 230;
                    case 161 -> 216;
                    case 162 -> 91;
                    case 163 -> 180;
                    case 164 -> 196;
                    case 165 -> 13;
                    case 166 -> 36;
                    case 167 -> 140;
                    case 168 -> 166;
                    case 169 -> 20;
                    case 170 -> 199;
                    case 171 -> 252;
                    case 172 -> 101;
                    case 173 -> 149;
                    case 174 -> 53;
                    case 175 -> 106;
                    case 176 -> 153;
                    case 177 -> 117;
                    case 178 -> 124;
                    case 179 -> 49;
                    case 180 -> 47;
                    case 181 -> 193;
                    case 182 -> 86;
                    case 183 -> 58;
                    case 184 -> 29;
                    case 185 -> 217;
                    case 186 -> 11;
                    case 187 -> 105;
                    case 188 -> 89;
                    case 189 -> 135;
                    case 190 -> 87;
                    case 191 -> 112;
                    case 192 -> 245;
                    case 193 -> 134;
                    case 194 -> 181;
                    case 195 -> 44;
                    case 196 -> 223;
                    case 197 -> 113;
                    case 198 -> 221;
                    case 199 -> 28;
                    case 200 -> 126;
                    case 201 -> 55;
                    case 202 -> 195;
                    case 203 -> 14;
                    case 204 -> 16;
                    case 205 -> 191;
                    case 206 -> 76;
                    case 207 -> 198;
                    case 208 -> 103;
                    case 209 -> 34;
                    case 210 -> 213;
                    case 211 -> 96;
                    case 212 -> 253;
                    case 213 -> 225;
                    case 214 -> 167;
                    case 215 -> 8;
                    case 216 -> 66;
                    case 217 -> 138;
                    case 218 -> 222;
                    case 219 -> 185;
                    case 220 -> 121;
                    case 221 -> 93;
                    case 222 -> 188;
                    case 223 -> 56;
                    case 224 -> 12;
                    case 225 -> 35;
                    case 226 -> 100;
                    case 227 -> 212;
                    case 228 -> 211;
                    case 229 -> 80;
                    case 230 -> 98;
                    case 231 -> 107;
                    case 232 -> 82;
                    case 233 -> 52;
                    case 234 -> 46;
                    case 235 -> 183;
                    case 236 -> 187;
                    case 237 -> 95;
                    case 238 -> 125;
                    case 239 -> 132;
                    case 240 -> 204;
                    case 241 -> 173;
                    case 242 -> 189;
                    case 243 -> 94;
                    case 244 -> 97;
                    case 245 -> 61;
                    case 246 -> 218;
                    case 247 -> 43;
                    case 248 -> 226;
                    case 249 -> 108;
                    case 250 -> 250;
                    case 251 -> 71;
                    case 252 -> 207;
                    case 253 -> 74;
                    case 254 -> 151;
                    default -> 137;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 129323457129484L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "a\t`FQlN8\tf\u0003sL\u001c.S$E";
                    var5_4 = "a\t`FQlN8\tf\u0003sL\u001c.S$E".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 102;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 108;
                                    break;
                                }
                                case 1: {
                                    v11 = 10;
                                    break;
                                }
                                case 2: {
                                    v11 = 116;
                                    break;
                                }
                                case 3: {
                                    v11 = 78;
                                    break;
                                }
                                case 4: {
                                    v11 = 82;
                                    break;
                                }
                                case 5: {
                                    v11 = 102;
                                    break;
                                }
                                default: {
                                    v11 = 27;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 102980891986970L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u001d?IG`w\u000e\u0004\u001b!E]\n\u0017>N]lu\u0016=?G\t\u0017>N]lu\u001615\r\u00108SPfx\f12TZgq";
                    var5_4 = "\u001d?IG`w\u000e\u0004\u001b!E]\n\u0017>N]lu\u0016=?G\t\u0017>N]lu\u001615\r\u00108SPfx\f12TZgq".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 34;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "3\u0019kdD\\!\u00063\u0019kdHV";
                        var5_4 = "3\u0019kdD\\!\u00063\u0019kdHV".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 6;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 118;
                                break;
                            }
                            case 1: {
                                v15 = 115;
                                break;
                            }
                            case 2: {
                                v15 = 2;
                                break;
                            }
                            case 3: {
                                v15 = 17;
                                break;
                            }
                            case 4: {
                                v15 = 43;
                                break;
                            }
                            case 5: {
                                v15 = 52;
                                break;
                            }
                            default: {
                                v15 = 64;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 97068333260147L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-2072347770 + -1216, 2072347770 + 29424, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 73654914781990L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00ec\u0081\u00c0\u0088S\u00034\u00e7o\u0005|u\u00f4\u00d26\rD8\u00c51\u00e5p\u00d3\u0097L-\u00f19\u00ef\u0010\u00fb\u00d0\u00f5\u00c7\u00dc;\u00df\u00c3\u0004#\u001b\u00b5T&\u0097m\u0005\u0082\u001e+\u00bf\u00cd3\u00dcL\u00f1\u0082\u0089\u00d7EJ*\u00efU\u0005[aZ\u009ah\u0091\u00a6_c\u00a7$\u0002;\u00e6\u00d3\u00d4\u00f5\u009c\u00a2\u0082=\u00c5\u0098*\u00d5\u00b3`\u00c2~\u0015[V[-\u00cd\u001a\u00b5\u00c6y";
                    var4_3 = "\u00ec\u0081\u00c0\u0088S\u00034\u00e7o\u0005|u\u00f4\u00d26\rD8\u00c51\u00e5p\u00d3\u0097L-\u00f19\u00ef\u0010\u00fb\u00d0\u00f5\u00c7\u00dc;\u00df\u00c3\u0004#\u001b\u00b5T&\u0097m\u0005\u0082\u001e+\u00bf\u00cd3\u00dcL\u00f1\u0082\u0089\u00d7EJ*\u00efU\u0005[aZ\u009ah\u0091\u00a6_c\u00a7$\u0002;\u00e6\u00d3\u00d4\u00f5\u009c\u00a2\u0082=\u00c5\u0098*\u00d5\u00b3`\u00c2~\u0015[V[-\u00cd\u001a\u00b5\u00c6y".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 33;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u007f[\u0005\u00d6\u00a2yp\u00eb\u0091F\u00c9yn\u00df\u00b02L\u008e\u00f5\u00cc\u00c9\u00b1R|\u00e0\u0099\u00b4d\u009e\u00d5\u00adT\u0005\u00cc\u00d3\u00ad\u0081\nxC;\u0094Jc\u00e7y\u00d3\u00bcd\u008e\u0097\u00ff\u001ck\u00cb\u00ed\u00cb\u0099\u00a9\b\u00dcD\u00c2\u0085\u00bf.&\u0082N(\u00f9\u00f7n\u0098\u008a\u0099)\u001f\u00c5\u007f\u009f\u00b9Bi>\u001eB{(\u00c6I\u00e1E";
                        var4_3 = "\u007f[\u0005\u00d6\u00a2yp\u00eb\u0091F\u00c9yn\u00df\u00b02L\u008e\u00f5\u00cc\u00c9\u00b1R|\u00e0\u0099\u00b4d\u009e\u00d5\u00adT\u0005\u00cc\u00d3\u00ad\u0081\nxC;\u0094Jc\u00e7y\u00d3\u00bcd\u008e\u0097\u00ff\u001ck\u00cb\u00ed\u00cb\u0099\u00a9\b\u00dcD\u00c2\u0085\u00bf.&\u0082N(\u00f9\u00f7n\u0098\u008a\u0099)\u001f\u00c5\u007f\u009f\u00b9Bi>\u001eB{(\u00c6I\u00e1E".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 104;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 50;
                                break;
                            }
                            case 1: {
                                v15 = 104;
                                break;
                            }
                            case 2: {
                                v15 = 54;
                                break;
                            }
                            case 3: {
                                v15 = 85;
                                break;
                            }
                            case 4: {
                                v15 = 53;
                                break;
                            }
                            case 5: {
                                v15 = 127;
                                break;
                            }
                            default: {
                                v15 = 48;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFABB5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 134;
                    case 1 -> 22;
                    case 2 -> 40;
                    case 3 -> 182;
                    case 4 -> 215;
                    case 5 -> 107;
                    case 6 -> 71;
                    case 7 -> 77;
                    case 8 -> 179;
                    case 9 -> 62;
                    case 10 -> 238;
                    case 11 -> 181;
                    case 12 -> 251;
                    case 13 -> 172;
                    case 14 -> 183;
                    case 15 -> 47;
                    case 16 -> 213;
                    case 17 -> 147;
                    case 18 -> 185;
                    case 19 -> 146;
                    case 20 -> 200;
                    case 21 -> 186;
                    case 22 -> 247;
                    case 23 -> 55;
                    case 24 -> 66;
                    case 25 -> 3;
                    case 26 -> 34;
                    case 27 -> 212;
                    case 28 -> 246;
                    case 29 -> 10;
                    case 30 -> 188;
                    case 31 -> 0;
                    case 32 -> 187;
                    case 33 -> 65;
                    case 34 -> 36;
                    case 35 -> 149;
                    case 36 -> 150;
                    case 37 -> 189;
                    case 38 -> 41;
                    case 39 -> 207;
                    case 40 -> 196;
                    case 41 -> 143;
                    case 42 -> 30;
                    case 43 -> 112;
                    case 44 -> 43;
                    case 45 -> 235;
                    case 46 -> 171;
                    case 47 -> 21;
                    case 48 -> 15;
                    case 49 -> 54;
                    case 50 -> 130;
                    case 51 -> 96;
                    case 52 -> 39;
                    case 53 -> 78;
                    case 54 -> 197;
                    case 55 -> 69;
                    case 56 -> 250;
                    case 57 -> 37;
                    case 58 -> 194;
                    case 59 -> 198;
                    case 60 -> 226;
                    case 61 -> 25;
                    case 62 -> 233;
                    case 63 -> 14;
                    case 64 -> 192;
                    case 65 -> 218;
                    case 66 -> 45;
                    case 67 -> 166;
                    case 68 -> 105;
                    case 69 -> 175;
                    case 70 -> 94;
                    case 71 -> 236;
                    case 72 -> 31;
                    case 73 -> 114;
                    case 74 -> 108;
                    case 75 -> 136;
                    case 76 -> 101;
                    case 77 -> 17;
                    case 78 -> 132;
                    case 79 -> 153;
                    case 80 -> 28;
                    case 81 -> 13;
                    case 82 -> 57;
                    case 83 -> 252;
                    case 84 -> 216;
                    case 85 -> 51;
                    case 86 -> 195;
                    case 87 -> 126;
                    case 88 -> 23;
                    case 89 -> 46;
                    case 90 -> 98;
                    case 91 -> 137;
                    case 92 -> 211;
                    case 93 -> 180;
                    case 94 -> 2;
                    case 95 -> 19;
                    case 96 -> 241;
                    case 97 -> 219;
                    case 98 -> 70;
                    case 99 -> 141;
                    case 100 -> 58;
                    case 101 -> 79;
                    case 102 -> 61;
                    case 103 -> 168;
                    case 104 -> 8;
                    case 105 -> 111;
                    case 106 -> 118;
                    case 107 -> 113;
                    case 108 -> 245;
                    case 109 -> 253;
                    case 110 -> 97;
                    case 111 -> 255;
                    case 112 -> 152;
                    case 113 -> 4;
                    case 114 -> 227;
                    case 115 -> 222;
                    case 116 -> 95;
                    case 117 -> 9;
                    case 118 -> 160;
                    case 119 -> 100;
                    case 120 -> 217;
                    case 121 -> 73;
                    case 122 -> 44;
                    case 123 -> 64;
                    case 124 -> 155;
                    case 125 -> 248;
                    case 126 -> 225;
                    case 127 -> 119;
                    case 128 -> 176;
                    case 129 -> 165;
                    case 130 -> 121;
                    case 131 -> 237;
                    case 132 -> 120;
                    case 133 -> 223;
                    case 134 -> 231;
                    case 135 -> 87;
                    case 136 -> 133;
                    case 137 -> 35;
                    case 138 -> 117;
                    case 139 -> 81;
                    case 140 -> 240;
                    case 141 -> 6;
                    case 142 -> 24;
                    case 143 -> 16;
                    case 144 -> 184;
                    case 145 -> 131;
                    case 146 -> 20;
                    case 147 -> 203;
                    case 148 -> 190;
                    case 149 -> 144;
                    case 150 -> 201;
                    case 151 -> 67;
                    case 152 -> 170;
                    case 153 -> 154;
                    case 154 -> 178;
                    case 155 -> 157;
                    case 156 -> 177;
                    case 157 -> 164;
                    case 158 -> 29;
                    case 159 -> 38;
                    case 160 -> 239;
                    case 161 -> 93;
                    case 162 -> 52;
                    case 163 -> 110;
                    case 164 -> 68;
                    case 165 -> 18;
                    case 166 -> 159;
                    case 167 -> 229;
                    case 168 -> 167;
                    case 169 -> 42;
                    case 170 -> 242;
                    case 171 -> 199;
                    case 172 -> 85;
                    case 173 -> 127;
                    case 174 -> 88;
                    case 175 -> 224;
                    case 176 -> 89;
                    case 177 -> 106;
                    case 178 -> 210;
                    case 179 -> 90;
                    case 180 -> 50;
                    case 181 -> 220;
                    case 182 -> 82;
                    case 183 -> 148;
                    case 184 -> 162;
                    case 185 -> 205;
                    case 186 -> 103;
                    case 187 -> 124;
                    case 188 -> 48;
                    case 189 -> 204;
                    case 190 -> 128;
                    case 191 -> 221;
                    case 192 -> 125;
                    case 193 -> 138;
                    case 194 -> 104;
                    case 195 -> 209;
                    case 196 -> 156;
                    case 197 -> 151;
                    case 198 -> 191;
                    case 199 -> 92;
                    case 200 -> 86;
                    case 201 -> 99;
                    case 202 -> 230;
                    case 203 -> 129;
                    case 204 -> 202;
                    case 205 -> 234;
                    case 206 -> 142;
                    case 207 -> 232;
                    case 208 -> 249;
                    case 209 -> 102;
                    case 210 -> 27;
                    case 211 -> 63;
                    case 212 -> 145;
                    case 213 -> 174;
                    case 214 -> 193;
                    case 215 -> 115;
                    case 216 -> 7;
                    case 217 -> 12;
                    case 218 -> 32;
                    case 219 -> 72;
                    case 220 -> 84;
                    case 221 -> 173;
                    case 222 -> 80;
                    case 223 -> 109;
                    case 224 -> 135;
                    case 225 -> 228;
                    case 226 -> 53;
                    case 227 -> 116;
                    case 228 -> 75;
                    case 229 -> 1;
                    case 230 -> 91;
                    case 231 -> 122;
                    case 232 -> 208;
                    case 233 -> 158;
                    case 234 -> 33;
                    case 235 -> 26;
                    case 236 -> 76;
                    case 237 -> 49;
                    case 238 -> 140;
                    case 239 -> 59;
                    case 240 -> 11;
                    case 241 -> 161;
                    case 242 -> 163;
                    case 243 -> 74;
                    case 244 -> 169;
                    case 245 -> 206;
                    case 246 -> 60;
                    case 247 -> 244;
                    case 248 -> 56;
                    case 249 -> 214;
                    case 250 -> 83;
                    case 251 -> 243;
                    case 252 -> 5;
                    case 253 -> 254;
                    case 254 -> 139;
                    default -> 123;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 45899446642410L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-868863030 + -10273, -868863030 + -13111, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 129461040939865L;
                    int[] nArray = SshAgentIpcService.m();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(2136703140 + 28023, -2136703140 + -17241, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 128053341300806L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00e5\u00caU\u00f0'\u0003B\u00a8\u00f7";
                var4_3 = "\u00e5\u00caU\u00f0'\u0003B\u00a8\u00f7".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 35;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 119;
                                break;
                            }
                            case 1: {
                                v11 = 51;
                                break;
                            }
                            case 2: {
                                v11 = 104;
                                break;
                            }
                            case 3: {
                                v11 = 109;
                                break;
                            }
                            case 4: {
                                v11 = 122;
                                break;
                            }
                            case 5: {
                                v11 = 23;
                                break;
                            }
                            default: {
                                v11 = 67;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6D43) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 103;
                    case 1 -> 76;
                    case 2 -> 122;
                    case 3 -> 233;
                    case 4 -> 170;
                    case 5 -> 33;
                    case 6 -> 51;
                    case 7 -> 88;
                    case 8 -> 224;
                    case 9 -> 142;
                    case 10 -> 130;
                    case 11 -> 247;
                    case 12 -> 94;
                    case 13 -> 150;
                    case 14 -> 212;
                    case 15 -> 182;
                    case 16 -> 216;
                    case 17 -> 57;
                    case 18 -> 148;
                    case 19 -> 3;
                    case 20 -> 19;
                    case 21 -> 18;
                    case 22 -> 245;
                    case 23 -> 95;
                    case 24 -> 42;
                    case 25 -> 145;
                    case 26 -> 85;
                    case 27 -> 197;
                    case 28 -> 97;
                    case 29 -> 235;
                    case 30 -> 45;
                    case 31 -> 167;
                    case 32 -> 198;
                    case 33 -> 49;
                    case 34 -> 226;
                    case 35 -> 111;
                    case 36 -> 234;
                    case 37 -> 181;
                    case 38 -> 209;
                    case 39 -> 121;
                    case 40 -> 175;
                    case 41 -> 79;
                    case 42 -> 14;
                    case 43 -> 35;
                    case 44 -> 87;
                    case 45 -> 67;
                    case 46 -> 214;
                    case 47 -> 225;
                    case 48 -> 82;
                    case 49 -> 123;
                    case 50 -> 59;
                    case 51 -> 135;
                    case 52 -> 116;
                    case 53 -> 7;
                    case 54 -> 199;
                    case 55 -> 77;
                    case 56 -> 166;
                    case 57 -> 252;
                    case 58 -> 56;
                    case 59 -> 161;
                    case 60 -> 153;
                    case 61 -> 244;
                    case 62 -> 189;
                    case 63 -> 48;
                    case 64 -> 229;
                    case 65 -> 52;
                    case 66 -> 84;
                    case 67 -> 184;
                    case 68 -> 53;
                    case 69 -> 139;
                    case 70 -> 211;
                    case 71 -> 75;
                    case 72 -> 240;
                    case 73 -> 164;
                    case 74 -> 98;
                    case 75 -> 17;
                    case 76 -> 237;
                    case 77 -> 68;
                    case 78 -> 196;
                    case 79 -> 25;
                    case 80 -> 157;
                    case 81 -> 163;
                    case 82 -> 58;
                    case 83 -> 55;
                    case 84 -> 177;
                    case 85 -> 210;
                    case 86 -> 218;
                    case 87 -> 106;
                    case 88 -> 61;
                    case 89 -> 208;
                    case 90 -> 118;
                    case 91 -> 124;
                    case 92 -> 92;
                    case 93 -> 206;
                    case 94 -> 65;
                    case 95 -> 173;
                    case 96 -> 86;
                    case 97 -> 16;
                    case 98 -> 109;
                    case 99 -> 190;
                    case 100 -> 174;
                    case 101 -> 63;
                    case 102 -> 2;
                    case 103 -> 6;
                    case 104 -> 62;
                    case 105 -> 50;
                    case 106 -> 242;
                    case 107 -> 1;
                    case 108 -> 188;
                    case 109 -> 96;
                    case 110 -> 250;
                    case 111 -> 126;
                    case 112 -> 186;
                    case 113 -> 160;
                    case 114 -> 99;
                    case 115 -> 146;
                    case 116 -> 143;
                    case 117 -> 255;
                    case 118 -> 47;
                    case 119 -> 185;
                    case 120 -> 140;
                    case 121 -> 40;
                    case 122 -> 5;
                    case 123 -> 12;
                    case 124 -> 248;
                    case 125 -> 81;
                    case 126 -> 222;
                    case 127 -> 149;
                    case 128 -> 141;
                    case 129 -> 191;
                    case 130 -> 232;
                    case 131 -> 117;
                    case 132 -> 101;
                    case 133 -> 221;
                    case 134 -> 60;
                    case 135 -> 36;
                    case 136 -> 26;
                    case 137 -> 193;
                    case 138 -> 28;
                    case 139 -> 236;
                    case 140 -> 115;
                    case 141 -> 251;
                    case 142 -> 30;
                    case 143 -> 34;
                    case 144 -> 104;
                    case 145 -> 15;
                    case 146 -> 72;
                    case 147 -> 194;
                    case 148 -> 41;
                    case 149 -> 155;
                    case 150 -> 136;
                    case 151 -> 154;
                    case 152 -> 43;
                    case 153 -> 178;
                    case 154 -> 144;
                    case 155 -> 4;
                    case 156 -> 180;
                    case 157 -> 66;
                    case 158 -> 10;
                    case 159 -> 131;
                    case 160 -> 112;
                    case 161 -> 202;
                    case 162 -> 249;
                    case 163 -> 110;
                    case 164 -> 107;
                    case 165 -> 132;
                    case 166 -> 120;
                    case 167 -> 201;
                    case 168 -> 152;
                    case 169 -> 205;
                    case 170 -> 176;
                    case 171 -> 100;
                    case 172 -> 64;
                    case 173 -> 183;
                    case 174 -> 138;
                    case 175 -> 69;
                    case 176 -> 125;
                    case 177 -> 169;
                    case 178 -> 151;
                    case 179 -> 133;
                    case 180 -> 54;
                    case 181 -> 91;
                    case 182 -> 203;
                    case 183 -> 147;
                    case 184 -> 24;
                    case 185 -> 187;
                    case 186 -> 27;
                    case 187 -> 137;
                    case 188 -> 11;
                    case 189 -> 8;
                    case 190 -> 243;
                    case 191 -> 23;
                    case 192 -> 89;
                    case 193 -> 105;
                    case 194 -> 44;
                    case 195 -> 230;
                    case 196 -> 20;
                    case 197 -> 192;
                    case 198 -> 204;
                    case 199 -> 254;
                    case 200 -> 38;
                    case 201 -> 80;
                    case 202 -> 171;
                    case 203 -> 90;
                    case 204 -> 128;
                    case 205 -> 165;
                    case 206 -> 129;
                    case 207 -> 156;
                    case 208 -> 32;
                    case 209 -> 239;
                    case 210 -> 108;
                    case 211 -> 37;
                    case 212 -> 162;
                    case 213 -> 74;
                    case 214 -> 31;
                    case 215 -> 78;
                    case 216 -> 227;
                    case 217 -> 73;
                    case 218 -> 223;
                    case 219 -> 127;
                    case 220 -> 158;
                    case 221 -> 113;
                    case 222 -> 39;
                    case 223 -> 22;
                    case 224 -> 46;
                    case 225 -> 119;
                    case 226 -> 172;
                    case 227 -> 241;
                    case 228 -> 200;
                    case 229 -> 228;
                    case 230 -> 179;
                    case 231 -> 168;
                    case 232 -> 215;
                    case 233 -> 207;
                    case 234 -> 238;
                    case 235 -> 71;
                    case 236 -> 195;
                    case 237 -> 134;
                    case 238 -> 83;
                    case 239 -> 21;
                    case 240 -> 213;
                    case 241 -> 246;
                    case 242 -> 217;
                    case 243 -> 219;
                    case 244 -> 13;
                    case 245 -> 231;
                    case 246 -> 220;
                    case 247 -> 93;
                    case 248 -> 253;
                    case 249 -> 102;
                    case 250 -> 9;
                    case 251 -> 114;
                    case 252 -> 0;
                    case 253 -> 159;
                    case 254 -> 29;
                    default -> 70;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

