/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleWithMaxFilter;
import org.languagetool.rules.patterns.AbstractPatternRulePerformer;
import org.languagetool.rules.patterns.AbstractTokenBasedRule;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternTokenMatcher;
import org.languagetool.rules.patterns.RuleFilterEvaluator;
import org.languagetool.rules.patterns.RuleMatcher;
import org.languagetool.tools.StringTools;

public final class PatternRuleMatcher
extends AbstractPatternRulePerformer
implements RuleMatcher {
    public static final String MISTAKE = "<mistake/>";
    private static final Map<String, Integer> currentlyActiveRules = new ConcurrentHashMap<String, Integer>();
    private static final String allowedChars = "[^<>()]*?";
    private static final Pattern SUGGESTION_PATTERN_SUPPRESS = Pattern.compile("<suggestion><pleasespellme/>[^<>()]*?(\\([^<>()]*?\\)|<mistake/>)[^<>()]*?</suggestion>");
    private static final Pattern WHITESPACE_OR_PUNCT = Pattern.compile("[\\s,:;.!?].*");
    private static final Pattern TAG_AND_PLEASE_SPELL_ME = Pattern.compile("<suggestion><pleasespellme/>");
    private final boolean useList;
    private static final boolean monitorRules = System.getProperty("monitorActiveRules") != null;

    @ApiStatus.Internal
    public PatternRuleMatcher(AbstractTokenBasedRule rule, boolean useList) {
        super(rule, rule.getLanguage().getUnifier());
        this.useList = useList;
    }

    public static Map<String, Integer> getCurrentRules() {
        return currentlyActiveRules;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        String key2;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        String string2 = key2 = monitorRules ? this.rule.getFullId() + ": " + sentence.getText() : null;
        if (key2 != null) {
            currentlyActiveRules.compute(key2, (k, v) -> v == null ? 1 : v + 1);
        }
        try {
            AnalyzedTokenReadings[] tokens = this.isInterpretPosTagsPreDisambiguation() ? sentence.getPreDisambigTokensWithoutWhitespace() : sentence.getTokensWithoutWhitespace();
            this.doMatch(sentence, tokens, (tokenPositions, firstMatchToken, lastMatchToken, firstMarkerMatchToken, lastMarkerMatchToken) -> {
                RuleMatch ruleMatch = this.createRuleMatch(tokenPositions, tokens, firstMatchToken, lastMatchToken, firstMarkerMatchToken, lastMarkerMatchToken, sentence);
                if (ruleMatch != null) {
                    ruleMatches.add(ruleMatch);
                }
            });
            RuleWithMaxFilter maxFilter = new RuleWithMaxFilter();
            List<RuleMatch> filteredMatches = maxFilter.filter(ruleMatches);
            RuleMatch[] ruleMatchArray = filteredMatches.toArray(RuleMatch.EMPTY_ARRAY);
            return ruleMatchArray;
        }
        catch (IOException e) {
            throw new IOException("Error analyzing sentence: '" + sentence + "'", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error analyzing sentence: '" + sentence + "' with rule " + this.rule.getFullId(), e);
        }
        finally {
            if (key2 != null) {
                currentlyActiveRules.computeIfPresent(key2, (k, v) -> v - 1 > 0 ? Integer.valueOf(v - 1) : null);
            }
        }
    }

    @Override
    protected boolean testAllReadings(AnalyzedTokenReadings[] tokens, PatternTokenMatcher matcher, PatternTokenMatcher prevElement, int tokenNo, int firstMatchToken, int prevSkipNext) throws IOException {
        if (tokens[tokenNo].isImmunized()) {
            return false;
        }
        return super.testAllReadings(tokens, matcher, prevElement, tokenNo, firstMatchToken, prevSkipNext);
    }

    @Nullable
    private RuleMatch createRuleMatch(int[] tokenPositions, AnalyzedTokenReadings[] tokens, int firstMatchToken, int lastMatchToken, int firstMarkerMatchToken, int lastMarkerMatchToken, AnalyzedSentence sentence) throws IOException {
        AnalyzedTokenReadings token;
        int toPos;
        boolean startsWithUppercase;
        int idx;
        String errMessage = this.formatMatches(tokens, tokenPositions, firstMatchToken, this.rule.getMessage(), this.rule.getSuggestionMatches());
        String shortErrMessage = this.formatMatches(tokens, tokenPositions, firstMatchToken, this.rule.getShortMessage(), this.rule.getSuggestionMatches());
        String suggestionsOutMsg = this.formatMatches(tokens, tokenPositions, firstMatchToken, this.rule.getSuggestionsOutMsg(), this.rule.getSuggestionMatchesOutMsg());
        int correctedStPos = 0;
        if (this.rule.startPositionCorrection > 0) {
            for (int l = 0; l <= Math.min(this.rule.startPositionCorrection, tokenPositions.length - 1); ++l) {
                correctedStPos += tokenPositions[l];
            }
            --correctedStPos;
        }
        if ((idx = firstMatchToken + correctedStPos) >= tokens.length) {
            idx = tokens.length - 1;
        }
        AnalyzedTokenReadings firstMatchTokenObj = tokens[idx];
        ArrayList<String> inputTokens = new ArrayList<String>();
        for (int i = idx; i <= lastMatchToken; ++i) {
            inputTokens.add(tokens[i].getToken());
        }
        boolean isInputAllUppercase = StringTools.isAllUppercase(inputTokens);
        boolean isAllUppercase = isInputAllUppercase && (firstMatchTokenObj.getToken().replace("'", "").length() > 1 || lastMatchToken > idx) && this.matchPreservesCase(this.rule.getSuggestionMatches(), this.rule.getMessage()) && this.matchPreservesCase(this.rule.getSuggestionMatchesOutMsg(), this.rule.getSuggestionsOutMsg());
        isAllUppercase = isAllUppercase && this.rule.isAdjustSuggestionCase();
        boolean bl = startsWithUppercase = StringTools.startsWithUppercase(firstMatchTokenObj.getToken()) && this.matchPreservesCase(this.rule.getSuggestionMatches(), this.rule.getMessage()) && this.matchPreservesCase(this.rule.getSuggestionMatchesOutMsg(), this.rule.getSuggestionsOutMsg());
        if (firstMatchTokenObj.isSentenceStart() && tokens.length > firstMatchToken + correctedStPos + 1) {
            firstMatchTokenObj = tokens[firstMatchToken + correctedStPos + 1];
            startsWithUppercase = StringTools.startsWithUppercase(firstMatchTokenObj.getToken());
        }
        boolean bl2 = startsWithUppercase = startsWithUppercase && this.rule.isAdjustSuggestionCase();
        if (firstMarkerMatchToken == -1) {
            firstMarkerMatchToken = firstMatchToken;
        }
        int fromPos = tokens[firstMarkerMatchToken].getStartPos();
        if (firstMarkerMatchToken >= 1 && (errMessage.contains("<suggestion>,") || suggestionsOutMsg.contains("<suggestion>,"))) {
            fromPos = tokens[firstMarkerMatchToken - 1].getStartPos() + tokens[firstMarkerMatchToken - 1].getToken().length();
        }
        if (lastMarkerMatchToken == -1) {
            lastMarkerMatchToken = lastMatchToken;
        }
        if (fromPos < (toPos = (token = tokens[Math.min(lastMarkerMatchToken, tokens.length - 1)]).getEndPos()) && (!errMessage.contains("<pleasespellme/>") || errMessage.contains("<suggestion>") || suggestionsOutMsg.contains("<suggestion>"))) {
            String clearMsg = errMessage.replace("<pleasespellme/>", "");
            clearMsg = clearMsg.replace(MISTAKE, "");
            RuleMatch ruleMatch = new RuleMatch(this.rule, sentence, fromPos, toPos, tokens[firstMatchToken].getStartPos(), tokens[lastMatchToken].getEndPos(), clearMsg, shortErrMessage, startsWithUppercase, isAllUppercase, suggestionsOutMsg, true);
            ruleMatch.setType(this.rule.getType());
            if (this.rule.getFilter() != null) {
                RuleFilterEvaluator evaluator = new RuleFilterEvaluator(this.rule.getFilter());
                AnalyzedTokenReadings[] patternTokens = Arrays.copyOfRange(tokens, firstMatchToken, lastMatchToken + 1);
                return evaluator.runFilter(this.rule.getFilterArguments(), ruleMatch, patternTokens, firstMatchToken, Ints.asList((int[])tokenPositions));
            }
            return ruleMatch;
        }
        return null;
    }

    private boolean matchPreservesCase(List<Match> suggestionMatches, String msg) {
        if (suggestionMatches != null && !suggestionMatches.isEmpty()) {
            int sugStart = msg.indexOf("<suggestion>") + "<suggestion>".length();
            if (msg.contains("<pleasespellme/>")) {
                sugStart += "<pleasespellme/>".length();
            }
            for (Match sMatch : suggestionMatches) {
                if (sMatch.isInMessageOnly() || !sMatch.convertsCase() || msg.charAt(sugStart) != '\\') continue;
                return false;
            }
        }
        return true;
    }

    @Override
    int translateElementNo(int i) {
        if (!this.useList || i < 0) {
            return i;
        }
        int j = 0;
        PatternRule rule = (PatternRule)this.rule;
        for (int k = 0; k < i; ++k) {
            j += rule.getElementNo().get(k).intValue();
        }
        return j;
    }

    private String formatMatches(AnalyzedTokenReadings[] tokenReadings, int[] positions, int firstMatchTok, String errorMsg, List<Match> suggestionMatches) throws IOException {
        String errorMessage = errorMsg;
        int matchCounter = 0;
        int[] numbersToMatches = new int[errorMsg.length()];
        boolean newWay = false;
        int errLen = errorMessage.length();
        int errorMessageProcessed = 0;
        int errMarker = errorMessage.indexOf(92, errorMessageProcessed);
        boolean numberFollows = false;
        if (errMarker >= 0 && errMarker < errLen - 1) {
            numberFollows = StringTools.isPositiveNumber(errorMessage.charAt(errMarker + 1));
        }
        while (errMarker >= 0 && numberFollows) {
            int backslashPos = errorMessage.indexOf(92, errorMessageProcessed);
            if (backslashPos >= 0 && StringTools.isPositiveNumber(errorMessage.charAt(backslashPos + 1))) {
                int numLen = 1;
                while (backslashPos + numLen < errorMessage.length() && Character.isDigit(errorMessage.charAt(backslashPos + numLen))) {
                    ++numLen;
                }
                int j = Integer.parseInt(errorMessage.substring(backslashPos + 1, backslashPos + numLen)) - 1;
                int repTokenPos = 0;
                int nextTokenPos = 0;
                for (int l = 0; l <= Math.min(j, positions.length - 1); ++l) {
                    repTokenPos += positions[l];
                }
                if (j + 1 < positions.length) {
                    nextTokenPos = firstMatchTok + repTokenPos + positions[j + 1];
                }
                if (suggestionMatches != null && suggestionMatches.size() > 0) {
                    if (matchCounter < suggestionMatches.size()) {
                        numbersToMatches[j] = matchCounter;
                        String[] matches = j >= positions.length ? this.concatMatches(matchCounter, j, firstMatchTok + repTokenPos, tokenReadings, nextTokenPos, suggestionMatches) : (positions[j] != 0 ? this.concatMatches(matchCounter, j, firstMatchTok + repTokenPos, tokenReadings, nextTokenPos, suggestionMatches) : new String[]{""});
                        String leftSide = errorMessage.substring(0, backslashPos);
                        String rightSide = errorMessage.substring(backslashPos + numLen);
                        if (matches.length == 1) {
                            if (matches[0].isEmpty()) {
                                errorMessage = PatternRuleMatcher.concatWithoutExtraSpace(leftSide, rightSide);
                                errorMessageProcessed = leftSide.length();
                            } else {
                                errorMessage = leftSide + matches[0] + rightSide;
                                errorMessageProcessed = leftSide.length() + matches[0].length();
                            }
                        } else {
                            errorMessage = PatternRuleMatcher.formatMultipleSynthesis(matches, leftSide, rightSide);
                        }
                        ++matchCounter;
                        newWay = true;
                    } else {
                        suggestionMatches.add(suggestionMatches.get(numbersToMatches[j]));
                    }
                }
                if (!newWay) {
                    int newErrorMessageProcessed = errorMessage.lastIndexOf("\\" + (j + 1)) + tokenReadings[firstMatchTok + repTokenPos - 1].getToken().length();
                    errorMessage = errorMessage.substring(0, errorMessageProcessed) + errorMessage.substring(errorMessageProcessed).replace("\\" + (j + 1), tokenReadings[firstMatchTok + repTokenPos - 1].getToken());
                    errorMessageProcessed = newErrorMessageProcessed;
                }
            }
            errMarker = errorMessage.indexOf(92, errorMessageProcessed);
            numberFollows = false;
            errLen = errorMessage.length();
            if (errMarker < 0 || errMarker >= errLen - 1) continue;
            numberFollows = StringTools.isPositiveNumber(errorMessage.charAt(errMarker + 1));
        }
        return PatternRuleMatcher.removeSuppressMisspelled(errorMessage);
    }

    private static String concatWithoutExtraSpace(String leftSide, String rightSide) {
        if (leftSide.endsWith(" ") && rightSide.startsWith("</suggestion>") || leftSide.endsWith(" ") && WHITESPACE_OR_PUNCT.matcher(rightSide).matches()) {
            return leftSide.substring(0, leftSide.length() - 1) + rightSide;
        }
        if (leftSide.endsWith("suggestion>") && rightSide.startsWith(" ")) {
            return leftSide + rightSide.substring(1);
        }
        return leftSide + rightSide;
    }

    private static String removeSuppressMisspelled(String s) {
        String result2 = s;
        Matcher matcher = SUGGESTION_PATTERN_SUPPRESS.matcher(result2);
        result2 = matcher.replaceAll("");
        result2 = TAG_AND_PLEASE_SPELL_ME.matcher(result2).replaceAll("<suggestion>");
        return result2;
    }

    static String formatMultipleSynthesis(String[] matches, String leftSide, String rightSide) {
        String suggestionLeft = "";
        String suggestionRight = "";
        String rightSideNew = rightSide;
        int sPos = leftSide.lastIndexOf("<suggestion>");
        if (sPos >= 0) {
            suggestionLeft = leftSide.substring(sPos + "<suggestion>".length());
        }
        String errorMessage = StringTools.isEmpty(suggestionLeft) ? leftSide : leftSide.substring(0, leftSide.lastIndexOf("<suggestion>")) + "<suggestion>";
        int rPos = rightSide.indexOf("</suggestion>");
        if (rPos >= 0) {
            suggestionRight = rightSide.substring(0, rPos);
        }
        if (!StringTools.isEmpty(suggestionRight)) {
            rightSideNew = rightSide.substring(rightSide.indexOf("</suggestion>"));
        }
        int lastLeftSugEnd = leftSide.indexOf("</suggestion>");
        int lastLeftSugStart = leftSide.lastIndexOf("<suggestion>");
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        for (int z = 0; z < matches.length; ++z) {
            sb.append(suggestionLeft);
            sb.append(matches[z]);
            sb.append(suggestionRight);
            if (z >= matches.length - 1 || lastLeftSugEnd >= lastLeftSugStart) continue;
            sb.append("</suggestion>");
            sb.append(", ");
            sb.append("<suggestion>");
        }
        sb.append(rightSideNew);
        return sb.toString();
    }

    private String[] concatMatches(int start, int index, int tokenIndex, AnalyzedTokenReadings[] tokens, int nextTokenPos, List<Match> suggestionMatches) throws IOException {
        int len = this.phraseLen(index);
        Language language = this.rule.language;
        if (len != 1) {
            ArrayList<String[]> matchList = new ArrayList<String[]>();
            for (int i = 0; i < len; ++i) {
                int skippedTokens = nextTokenPos - (tokenIndex + i);
                MatchState matchState = suggestionMatches.get(start).createState(language.getSynthesizer(), tokens, tokenIndex - 1 + i, skippedTokens);
                matchList.add(matchState.toFinalString(language));
            }
            return PatternRuleMatcher.combineLists((String[][])matchList.toArray((T[])new String[matchList.size()][]), new String[matchList.size()], 0, language);
        }
        int skippedTokens = nextTokenPos - tokenIndex;
        MatchState matchState = suggestionMatches.get(start).createState(language.getSynthesizer(), tokens, tokenIndex - 1, skippedTokens);
        String[] finalMatch = matchState.toFinalString(language);
        return finalMatch;
    }

    private int phraseLen(int i) {
        PatternRule rule = (PatternRule)this.rule;
        List<Integer> elementNo = rule.getElementNo();
        if (!this.useList || i > elementNo.size() - 1) {
            return 1;
        }
        return elementNo.get(i);
    }

    private static String[] combineLists(String[][] input, String[] output, int r, Language lang) {
        ArrayList<String> outputList = new ArrayList<String>();
        if (r == input.length) {
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < output.length; ++k) {
                sb.append(output[k]);
                if (k >= output.length - 1) continue;
                sb.append(StringTools.addSpace(output[k + 1], lang));
            }
            outputList.add(sb.toString());
        } else {
            for (int c = 0; c < input[r].length; ++c) {
                output[r] = input[r][c];
                String[] sList = PatternRuleMatcher.combineLists(input, output, r + 1, lang);
                outputList.addAll(Arrays.asList(sList));
            }
        }
        return outputList.toArray(new String[0]);
    }
}

