/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.changes.tree;

import com.intellij.platform.vcs.impl.frontend.changes.UtilKt;
import com.intellij.platform.vcs.impl.frontend.changes.tree.RepositoryTreeNodeKt;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ChangesBrowserNodeRenderer;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.EntityChangesBrowserNode;
import com.intellij.platform.vcs.impl.shared.rhizome.NodeEntity;
import com.intellij.platform.vcs.impl.shared.rhizome.RepositoryNodeEntity;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.CheckboxIcon;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u000f\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/changes/tree/RepositoryTreeNode;", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/EntityChangesBrowserNode;", "Lcom/intellij/platform/vcs/impl/shared/rhizome/RepositoryNodeEntity;", "entity", "<init>", "(Lcom/intellij/platform/vcs/impl/shared/rhizome/RepositoryNodeEntity;)V", "render", "", "renderer", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "appendCurrentBranch", "getBranchLabelAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "background", "Ljava/awt/Color;", "getRepositoryIcon", "Lcom/intellij/util/ui/ColorIcon;", "doGetTextPresentation", "", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public final class RepositoryTreeNode
extends EntityChangesBrowserNode<RepositoryNodeEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final JBColor TEXT_COLOR;

    public RepositoryTreeNode(@NotNull RepositoryNodeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super((NodeEntity)entity);
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        renderer.setIcon((Icon)this.getRepositoryIcon());
        renderer.append(" " + ((RepositoryNodeEntity)this.getUserObject()).getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount(renderer);
        if (renderer.isShowingLocalChanges()) {
            this.appendCurrentBranch(renderer);
        }
    }

    private final void appendCurrentBranch(ChangesBrowserNodeRenderer renderer) {
        RepositoryNodeEntity repository = (RepositoryNodeEntity)this.getUserObject();
        String branch = repository.getBranchName();
        if (branch != null) {
            renderer.append(FontUtil.spaceAndThinSpace());
            String string = " " + repository.getBranchName() + " ";
            Color color = renderer.getBackground();
            if (color == null) {
                Color color2 = UIUtil.getTreeBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getTreeBackground(...)");
            }
            renderer.append(string, this.getBranchLabelAttributes(color));
            renderer.setBackgroundInsets(RepositoryTreeNodeKt.access$getBRANCH_BACKGROUND_INSETS$p());
            renderer.setToolTipText(repository.getToolTip());
        }
    }

    private final SimpleTextAttributes getBranchLabelAttributes(Color background) {
        return new SimpleTextAttributes(UtilKt.getBranchPresentationBackground(background), (Color)TEXT_COLOR, null, 256);
    }

    @NotNull
    public final ColorIcon getRepositoryIcon() {
        RepositoryNodeEntity repositoryEntity = (RepositoryNodeEntity)this.getUserObject();
        Color color = new Color(repositoryEntity.getColorRed(), repositoryEntity.getColorGreen(), repositoryEntity.getColorBlue());
        return CheckboxIcon.createAndScale((Color)color);
    }

    @Override
    @Nullable
    public String doGetTextPresentation() {
        return ((RepositoryNodeEntity)this.getUserObject()).getName();
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"VersionControl.RefLabel.foreground", (Color)((Color)new JBColor(new Color(0x7A7A7A), new Color(0x909090))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        TEXT_COLOR = jBColor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/changes/tree/RepositoryTreeNode$Companion;", "", "<init>", "()V", "TEXT_COLOR", "Lcom/intellij/ui/JBColor;", "intellij.platform.vcs.impl.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

