/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.util.Key;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Dimension2D;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.ui.Dimension2DDouble;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002\u001a,\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a,\u0010\u000e\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0002H\u0000\u001a-\u0010\u0010\u001a\u0002H\u0011\"\u0006\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00122\u000e\b\u0004\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a)\u0010\u001e\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00110\bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u001a)\u0010!\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00110\bH\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u001a)\u0010\"\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00110\bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u001a\f\u0010#\u001a\u00020\u0006*\u00020\u0002H\u0001\u001a\u0010\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0000\u001a\f\u0010'\u001a\u00020(*\u00020)H\u0000\u001a\f\u0010*\u001a\u00020+*\u00020,H\u0007\u001a/\u0010-\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002H\u001100H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101\u001a\u001a\u00102\u001a\u00020\u0006*\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020+\"!\u0010\u0015\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00060\u00060\u0016\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\u001a\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\t8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00067"}, d2={"getCharSize", "Ljava/awt/geom/Dimension2D;", "Lcom/intellij/openapi/editor/Editor;", "calculateTerminalSize", "Lcom/jediterm/core/util/TermSize;", "invokeLater", "", "expired", "Lkotlin/Function0;", "", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "runnable", "Ljava/lang/Runnable;", "invokeLaterIfNeeded", "getDisposed", "executeInBulk", "T", "Lcom/intellij/openapi/editor/Document;", "block", "(Lcom/intellij/openapi/editor/Document;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "isTerminalOutputScrollChangingActionInProgress", "(Lcom/intellij/openapi/editor/Editor;)Z", "setTerminalOutputScrollChangingActionInProgress", "(Lcom/intellij/openapi/editor/Editor;Z)V", "doTerminalOutputScrollChangingAction", "action", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "doWithScrollingAware", "doWithoutScrollingAnimation", "scrollToBottom", "stickScrollBarToBottom", "verticalScrollBar", "Ljavax/swing/JScrollBar;", "normalize", "", "Lcom/jediterm/terminal/model/CharBuffer;", "getLengthWithoutDwc", "", "Lcom/jediterm/terminal/model/TerminalLine;", "withLock", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "callable", "Lkotlin/Function1;", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "addToLayer", "Lcom/intellij/ui/components/JBLayeredPane;", "component", "Ljavax/swing/JComponent;", "layer", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,488:1\n409#1,7:490\n1#2:489\n507#3,5:497\n1104#3,3:504\n1797#4,2:502\n1799#4:507\n*S KotlinDebug\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n*L\n421#1:490,7\n464#1:497,5\n470#1:504,3\n469#1:502,2\n469#1:507\n*E\n"})
public final class TerminalUiUtilsKt {
    @NotNull
    private static final Key<Unit> TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY;

    @NotNull
    public static final Dimension2D getCharSize(@NotNull Editor $this$getCharSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getCharSize, (String)"<this>");
        FontRenderContext baseContext = FontInfo.getFontRenderContext((Component)$this$getCharSize.getContentComponent());
        FontRenderContext context = new FontRenderContext(baseContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)true), UISettings.Companion.getEditorFractionalMetricsHint());
        FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)$this$getCharSize.getColorsScheme().getFont(EditorFontType.PLAIN), (FontRenderContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        FontMetrics fontMetrics2 = fontMetrics;
        float width = FontLayoutService.Companion.getInstance().charWidth2D(fontMetrics2, 37);
        return new Dimension2DDouble(width, $this$getCharSize.getLineHeight());
    }

    @Nullable
    public static final TermSize calculateTerminalSize(@NotNull Editor $this$calculateTerminalSize) {
        TermSize termSize;
        Intrinsics.checkNotNullParameter((Object)$this$calculateTerminalSize, (String)"<this>");
        Dimension contentSize = $this$calculateTerminalSize.getScrollingModel().getVisibleArea().getSize();
        Dimension2D charSize = TerminalUiUtilsKt.getCharSize($this$calculateTerminalSize);
        if (contentSize.width > 0 && contentSize.height > 0) {
            Intrinsics.checkNotNull((Object)contentSize);
            termSize = TerminalUiUtils.INSTANCE.calculateTerminalSize(contentSize, charSize);
        } else {
            termSize = null;
        }
        return termSize;
    }

    public static final void invokeLater(@Nullable Function0<Boolean> expired, @NotNull ModalityState modalityState, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (expired != null) {
            ApplicationManager.getApplication().invokeLater(runnable, modalityState, arg_0 -> TerminalUiUtilsKt.invokeLater$lambda$0(expired, arg_0));
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, modalityState);
        }
    }

    public static /* synthetic */ void invokeLater$default(Function0 function0, ModalityState modalityState, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        if ((n & 2) != 0) {
            modalityState = ModalityState.defaultModalityState();
        }
        TerminalUiUtilsKt.invokeLater((Function0<Boolean>)function0, modalityState, runnable);
    }

    public static final void invokeLaterIfNeeded(@Nullable Function0<Boolean> expired, @NotNull ModalityState modalityState, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            TerminalUiUtilsKt.invokeLater(expired, modalityState, runnable);
        }
    }

    public static /* synthetic */ void invokeLaterIfNeeded$default(Function0 function0, ModalityState modalityState, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        if ((n & 2) != 0) {
            modalityState = ModalityState.defaultModalityState();
        }
        TerminalUiUtilsKt.invokeLaterIfNeeded((Function0<Boolean>)function0, modalityState, runnable);
    }

    @NotNull
    public static final Function0<Boolean> getDisposed(@NotNull Editor $this$getDisposed) {
        Intrinsics.checkNotNullParameter((Object)$this$getDisposed, (String)"<this>");
        return () -> TerminalUiUtilsKt.getDisposed$lambda$1($this$getDisposed);
    }

    public static final /* synthetic */ <T> T executeInBulk(Document $this$executeInBulk, Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)$this$executeInBulk, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$executeInBulk = false;
        Ref.ObjectRef result = new Ref.ObjectRef();
        DocumentUtil.executeInBulk((Document)$this$executeInBulk, (Runnable)new Runnable(result, block){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function0<T> $block;
            {
                this.$result = $result;
                this.$block = $block;
            }

            public final void run() {
                this.$result.element = this.$block.invoke();
            }
        });
        Object object = result.element;
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    @ApiStatus.Internal
    public static final boolean isTerminalOutputScrollChangingActionInProgress(@NotNull Editor $this$isTerminalOutputScrollChangingActionInProgress) {
        Intrinsics.checkNotNullParameter((Object)$this$isTerminalOutputScrollChangingActionInProgress, (String)"<this>");
        return $this$isTerminalOutputScrollChangingActionInProgress.getUserData(TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY) != null;
    }

    @ApiStatus.Internal
    public static final void setTerminalOutputScrollChangingActionInProgress(@NotNull Editor $this$isTerminalOutputScrollChangingActionInProgress, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$isTerminalOutputScrollChangingActionInProgress, (String)"<this>");
        $this$isTerminalOutputScrollChangingActionInProgress.putUserData(TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY, value ? Unit.INSTANCE : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static final <T> T doTerminalOutputScrollChangingAction(@NotNull Editor $this$doTerminalOutputScrollChangingAction, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$doTerminalOutputScrollChangingAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$doTerminalOutputScrollChangingAction = false;
        TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress($this$doTerminalOutputScrollChangingAction, true);
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress($this$doTerminalOutputScrollChangingAction, false);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public static final <T> T doWithScrollingAware(@NotNull Editor $this$doWithScrollingAware, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$doWithScrollingAware, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$doWithScrollingAware = false;
        Rectangle it = $this$doWithScrollingAware.getScrollingModel().getVisibleArea();
        boolean bl = false;
        boolean wasAtBottom = it.y + it.height == $this$doWithScrollingAware.getContentComponent().getHeight();
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            if (wasAtBottom) {
                TerminalUiUtilsKt.scrollToBottom($this$doWithScrollingAware);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @RequiresEdt
    public static final <T> T doWithoutScrollingAnimation(@NotNull Editor $this$doWithoutScrollingAnimation, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$doWithoutScrollingAnimation, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$doWithoutScrollingAnimation = false;
        $this$doWithoutScrollingAnimation.getScrollingModel().disableAnimation();
        try {
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$doWithoutScrollingAnimation.getScrollingModel().enableAnimation();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public static final void scrollToBottom(@NotNull Editor $this$scrollToBottom) {
        Intrinsics.checkNotNullParameter((Object)$this$scrollToBottom, (String)"<this>");
        Editor $this$doWithoutScrollingAnimation$iv = $this$scrollToBottom;
        boolean $i$f$doWithoutScrollingAnimation = false;
        $this$doWithoutScrollingAnimation$iv.getScrollingModel().disableAnimation();
        try {
            boolean bl = false;
            Rectangle rectangle = $this$scrollToBottom.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            $this$scrollToBottom.getScrollingModel().scrollVertically($this$scrollToBottom.getContentComponent().getHeight() - visibleArea.height);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$doWithoutScrollingAnimation$iv.getScrollingModel().enableAnimation();
        }
    }

    public static final void stickScrollBarToBottom(@NotNull JScrollBar verticalScrollBar) {
        Intrinsics.checkNotNullParameter((Object)verticalScrollBar, (String)"verticalScrollBar");
        verticalScrollBar.getModel().addChangeListener(new ChangeListener(verticalScrollBar){
            private boolean preventRecursion;
            private int prevValue;
            private int prevMaximum;
            private int prevExtent;
            final /* synthetic */ JScrollBar $verticalScrollBar;
            {
                this.$verticalScrollBar = $verticalScrollBar;
            }

            public final boolean getPreventRecursion() {
                return this.preventRecursion;
            }

            public final void setPreventRecursion(boolean bl) {
                this.preventRecursion = bl;
            }

            public final int getPrevValue() {
                return this.prevValue;
            }

            public final void setPrevValue(int n) {
                this.prevValue = n;
            }

            public final int getPrevMaximum() {
                return this.prevMaximum;
            }

            public final void setPrevMaximum(int n) {
                this.prevMaximum = n;
            }

            public final int getPrevExtent() {
                return this.prevExtent;
            }

            public final void setPrevExtent(int n) {
                this.prevExtent = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (this.preventRecursion) {
                    return;
                }
                BoundedRangeModel model = this.$verticalScrollBar.getModel();
                int maximum = model.getMaximum();
                int extent = model.getExtent();
                if ((extent != this.prevExtent || maximum != this.prevMaximum) && this.prevValue == this.prevMaximum - this.prevExtent) {
                    this.preventRecursion = true;
                    try {
                        model.setValue(maximum - extent);
                    }
                    finally {
                        this.preventRecursion = false;
                    }
                }
                this.prevValue = model.getValue();
                this.prevMaximum = model.getMaximum();
                this.prevExtent = model.getExtent();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String normalize(@NotNull CharBuffer $this$normalize) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        String string2 = $this$normalize.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String s = string2;
        if (StringsKt.contains$default((CharSequence)s, (char)'\ue000', (boolean)false, (int)2, null)) {
            void var3_3;
            void $this$filterTo$iv;
            CharSequence charSequence = s;
            Appendable destination$iv = new StringBuilder(s.length() - 1);
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char element$iv;
                char it = element$iv = $this$filterTo$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != '\ue000')) continue;
                destination$iv.append(element$iv);
            }
            String string3 = ((StringBuilder)var3_3).toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        } else {
            string = s;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final int getLengthWithoutDwc(@NotNull TerminalLine $this$getLengthWithoutDwc) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getLengthWithoutDwc, (String)"<this>");
        List list = $this$getLengthWithoutDwc.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
        Iterable iterable = list;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            TerminalLine.TextEntry textEntry = (TerminalLine.TextEntry)element$iv;
            int curCount = accumulator$iv;
            boolean bl = false;
            CharBuffer charBuffer = entry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
            CharSequence $this$count$iv = (CharSequence)charBuffer;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv2;
                char it = element$iv2 = $this$count$iv.charAt(i);
                boolean bl2 = false;
                if (!(it == '\ue000')) continue;
                ++count$iv;
            }
            int dwcInEntryCount = count$iv;
            accumulator$iv = curCount + dwcInEntryCount;
        }
        int dwcCount = accumulator$iv;
        return $this$getLengthWithoutDwc.length() - dwcCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withLock(@NotNull TerminalTextBuffer $this$withLock, @NotNull Function1<? super TerminalTextBuffer, ? extends T> callable) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withLock, (String)"<this>");
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        boolean $i$f$withLock = false;
        $this$withLock.lock();
        try {
            object = callable.invoke((Object)$this$withLock);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$withLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    public static final void addToLayer(@NotNull JBLayeredPane $this$addToLayer, @NotNull JComponent component2, int layer) {
        Intrinsics.checkNotNullParameter((Object)$this$addToLayer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Component component3 = component2;
        Intrinsics.checkNotNull((Object)layer, (String)"null cannot be cast to non-null type kotlin.Any");
        $this$addToLayer.add(component3, (Object)layer);
    }

    private static final boolean invokeLater$lambda$0(Function0 $expired, Object it) {
        return (Boolean)$expired.invoke();
    }

    private static final boolean getDisposed$lambda$1(Editor $this_getDisposed) {
        return $this_getDisposed.isDisposed();
    }

    static {
        Key key = Key.create((String)"TERMINAL_EDITOR_SIZE_CHANGING_ACTION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY = key;
    }
}

