/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vswin.parsers;

import com.intellij.ide.startup.importSettings.db.KnownKeymaps;
import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSXmlParserException;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.FontsAndColorsParsedData;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.VSParsedData;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.VSParsedDataCreator;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHive;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.Version2;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers.data.KeyBindingsParsedData;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u000bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J,\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00172\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSXmlParser;", "", "settingsFile", "Ljava/io/File;", "hive", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "<init>", "(Ljava/io/File;Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;)V", "document", "Lorg/jdom/Document;", "allSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "getAllSettings", "()Lcom/intellij/ide/startup/importSettings/models/Settings;", "ver", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;", "getVer", "()Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;", "toSettings", "categoryDigger", "", "version", "rtElement", "Lorg/jdom/Element;", "parserDispatcher", "Lkotlin/Function0;", "Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/data/VSParsedData;", "el", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSXmlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSXmlParser.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSXmlParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,105:1\n1#2:106\n15#3:107\n*S KotlinDebug\n*F\n+ 1 VSXmlParser.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSXmlParser\n*L\n30#1:107\n*E\n"})
public final class VSXmlParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final VSHive hive;
    @NotNull
    private final Document document;
    @NotNull
    private final Settings allSettings;
    @NotNull
    private final Version2 ver;
    @NotNull
    public static final String applicationIdentity = "ApplicationIdentity";
    @NotNull
    public static final String toolsOptions = "ToolsOptions";
    @NotNull
    public static final String category = "Category";
    @NotNull
    public static final String envGroup = "Environment_Group";
    @NotNull
    public static final String nameAttr = "name";
    @NotNull
    public static final String versionAttr = "version";
    @NotNull
    private static final Logger logger;

    public VSXmlParser(@NotNull File settingsFile, @Nullable VSHive hive) {
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        this.hive = hive;
        this.allSettings = new Settings(null, null, null, KnownKeymaps.INSTANCE.getVisualStudio2022(), null, 23, null);
        if (!settingsFile.exists()) {
            boolean bl = false;
            String string = "Settings file was not found";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.hive != null) {
            logger.info("Parsing " + this.hive);
        }
        this.document = new SAXBuilder().build(settingsFile);
        logger.info("Parsing file " + settingsFile.getAbsolutePath());
        Object object = this.document.getRootElement().getChild(applicationIdentity);
        if (object == null || (object = object.getAttribute(versionAttr)) == null || (object = object.getValue()) == null) {
            throw new VSXmlParserException("Can't find version");
        }
        Object verStr = object;
        Version2 version2 = Version2.Companion.parse((String)verStr);
        if (version2 == null) {
            throw new VSXmlParserException("Can't parse version");
        }
        this.ver = version2;
        Element element = this.document.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        this.categoryDigger(this.ver, element);
    }

    public /* synthetic */ VSXmlParser(File file, VSHive vSHive, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vSHive = null;
        }
        this(file, vSHive);
    }

    @NotNull
    public final Settings getAllSettings() {
        return this.allSettings;
    }

    @NotNull
    public final Version2 getVer() {
        return this.ver;
    }

    @NotNull
    public final Settings toSettings() {
        return this.allSettings;
    }

    private final void categoryDigger(Version2 version, Element rtElement) {
        for (Element el : rtElement.getChildren()) {
            String name;
            VSParsedData disp;
            VSParsedData vSParsedData;
            block9: {
                block8: {
                    if (Intrinsics.areEqual((Object)el.getName(), (Object)applicationIdentity)) continue;
                    if (Intrinsics.areEqual((Object)el.getName(), (Object)toolsOptions)) break block8;
                    if (!Intrinsics.areEqual((Object)el.getName(), (Object)category)) break block9;
                    Attribute attribute = el.getAttribute(nameAttr);
                    if (!Intrinsics.areEqual((Object)(attribute != null ? attribute.getValue() : null), (Object)envGroup)) break block9;
                }
                Intrinsics.checkNotNull((Object)el);
                this.categoryDigger(version, el);
                continue;
            }
            Intrinsics.checkNotNull((Object)el);
            if (this.parserDispatcher(version, el, this.hive) != null) {
                Function0<VSParsedData> it;
                boolean bl = false;
                vSParsedData = (VSParsedData)it.invoke();
            } else {
                vSParsedData = null;
            }
            if ((disp = vSParsedData) == null) continue;
            Attribute attribute = el.getAttribute(nameAttr);
            String string = name = attribute != null ? attribute.getValue() : null;
            if (name == null) {
                logger.info("This should not happen. For some reason there is no name attribute");
                continue;
            }
            VSParsedData vSParsedData2 = disp;
            if (vSParsedData2 instanceof FontsAndColorsParsedData) {
                this.allSettings.setLaf(((FontsAndColorsParsedData)disp).getTheme().toRiderTheme());
                continue;
            }
            if (!(vSParsedData2 instanceof KeyBindingsParsedData)) continue;
            List<KeyBinding> format = ((KeyBindingsParsedData)disp).convertToSettingsFormat();
            Keymap oldKeymap = this.allSettings.getKeymap();
            if (!(!((Collection)format).isEmpty()) || oldKeymap == null) continue;
            this.allSettings.setKeymap(new PatchedKeymap(oldKeymap.getTransferableId(), oldKeymap, ((KeyBindingsParsedData)disp).convertToSettingsFormat(), CollectionsKt.emptyList()));
        }
    }

    private final Function0<VSParsedData> parserDispatcher(Version2 version, Element el, VSHive hive) {
        String string;
        Attribute attribute = el.getAttribute(nameAttr);
        String string2 = string = attribute != null ? attribute.getValue() : null;
        return Intrinsics.areEqual((Object)string, (Object)"Environment_FontsAndColors") ? () -> VSXmlParser.parserDispatcher$lambda$2(version, el) : (Intrinsics.areEqual((Object)string, (Object)"Environment_KeyBindings") ? () -> VSXmlParser.parserDispatcher$lambda$3(version, el, hive) : null);
    }

    private static final VSParsedData parserDispatcher$lambda$2(Version2 $version, Element $el) {
        return VSParsedDataCreator.INSTANCE.fontsAndColors($version, $el);
    }

    private static final VSParsedData parserDispatcher$lambda$3(Version2 $version, Element $el, VSHive $hive) {
        return VSParsedDataCreator.INSTANCE.keyBindings($version, $el, $hive);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VSXmlParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VSXmlParser.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSXmlParser$Companion;", "", "<init>", "()V", "applicationIdentity", "", "toolsOptions", "category", "envGroup", "nameAttr", "versionAttr", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

