/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.runtime;

import com.ochafik.lang.jnaerator.runtime.MangledFunctionMapper;
import com.ochafik.net.URLUtils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryExtractor {
    public static String getCurrentOSAndArchString() {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        if (os.equals("Mac OS X")) {
            os = "darwin";
            arch = "fat";
        } else {
            if (os.startsWith("Windows")) {
                return "win" + (Platform.is64Bit() ? "64" : "32");
            }
            if (os.matches("SunOS|Solaris")) {
                os = "solaris";
            }
        }
        return os + "-" + arch;
    }

    public static String getLibraryPath(String libraryName, boolean extractAllLibraries, Class<?> cl) {
        try {
            int lastSize;
            String name;
            String customPath = System.getProperty("library." + libraryName);
            if (customPath == null) {
                customPath = System.getenv(libraryName.toUpperCase() + "_LIBRARY");
            }
            if (customPath != null) {
                File f = new File(customPath);
                if (!f.exists()) {
                    System.err.println("Library file '" + customPath + "' does not exist !");
                } else {
                    return f.getAbsolutePath();
                }
            }
            String prefix = "(?i)" + (Platform.isWindows() || Platform.isWindowsCE() ? "" : "lib") + libraryName + "[^A-Za-z_].*";
            String libsuffix = "(?i).*\\.(so|dll|dylib|jnilib)";
            URL sourceURL = null;
            ArrayList<URL> otherURLs = new ArrayList<URL>();
            String arch = LibraryExtractor.getCurrentOSAndArchString();
            List<URL> list = URLUtils.listFiles(URLUtils.getResource(cl, "libraries/" + arch), null);
            List<URL> noArchList = URLUtils.listFiles(URLUtils.getResource(cl, "libraries/noarch"), null);
            HashSet<String> names = new HashSet<String>();
            for (URL url : list) {
                name = LibraryExtractor.getFileName(url);
                names.add(name);
            }
            for (URL url : noArchList) {
                name = LibraryExtractor.getFileName(url);
                if (!names.add(name)) continue;
                list.add(url);
            }
            for (File f : new File(".").listFiles()) {
                if (!f.isFile()) continue;
                list.add(f.toURI().toURL());
            }
            for (URL url : list) {
                String name2 = LibraryExtractor.getFileName(url);
                boolean pref = name2.matches(prefix);
                boolean suff = name2.matches(libsuffix);
                if (pref && suff) {
                    sourceURL = url;
                    continue;
                }
                otherURLs.add(url);
            }
            ArrayList<File> files = new ArrayList<File>();
            if (extractAllLibraries) {
                for (URL url : otherURLs) {
                    files.add(LibraryExtractor.extract(url));
                }
            }
            if (System.getProperty("javawebstart.version") != null) {
                File f;
                if (Platform.isWindows()) {
                    File f2 = new File("c:\\Windows\\System32\\" + libraryName + ".dll");
                    if (f2.exists()) {
                        return f2.toString();
                    }
                } else if (Platform.isMac() && (f = new File("/System/Library/Frameworks/" + libraryName + ".framework/" + libraryName)).exists()) {
                    return f.toString();
                }
            }
            if (sourceURL == null) {
                return libraryName;
            }
            File file = LibraryExtractor.extract(sourceURL);
            files.add(file);
            do {
                lastSize = files.size();
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    File f = (File)it.next();
                    if (!f.getName().matches(libsuffix)) continue;
                    try {
                        System.load(f.toString());
                        it.remove();
                    }
                    catch (Throwable ex) {
                        System.err.println("Loading " + f.getName() + " failed (" + ex + ")");
                    }
                }
            } while (files.size() < lastSize);
            return file.getCanonicalPath();
        }
        catch (Throwable ex) {
            System.err.println("ERROR: Failed to extract library " + libraryName);
            ex.printStackTrace();
            return libraryName;
        }
    }

    private static File extract(URL url) throws IOException {
        File localFile;
        if ("file".equals(url.getProtocol())) {
            localFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        } else {
            File f = new File(System.getProperty("user.home"));
            f = new File(f, ".jnaerator");
            if (!(f = new File(f, "extractedLibraries")).exists()) {
                f.mkdirs();
            }
            localFile = new File(f, new File(url.getFile()).getName());
            URLConnection c = url.openConnection();
            if (localFile.exists() && localFile.lastModified() > c.getLastModified()) {
                c.getInputStream().close();
            } else {
                int len;
                System.out.println("Extracting " + url);
                InputStream in = c.getInputStream();
                FileOutputStream out = new FileOutputStream(localFile);
                byte[] b = new byte[1024];
                while ((len = in.read(b)) > 0) {
                    ((OutputStream)out).write(b, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        return localFile;
    }

    public static void loadLibrary(String libraryName, boolean extractAllLibraries, Class<?> cl) {
        System.loadLibrary(LibraryExtractor.getLibraryPath(libraryName, extractAllLibraries, cl));
    }

    public static boolean shouldTraceCalls(String libraryName) {
        return "true".equals(System.getProperty("jna.traceCalls")) || "true".equals(System.getProperty(libraryName.toLowerCase() + ".traceCalls"));
    }

    public static final Object getTracingLibrary(final Object original, Class<?> libraryClass) {
        try {
            final String pref = "[" + libraryClass.getSimpleName() + "]";
            InvocationHandler handler = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    StringBuilder b = new StringBuilder(pref);
                    b.append(method.getDeclaringClass().getName() + "." + method.getName() + "(");
                    for (int i = 0; i < args.length; ++i) {
                        Object arg = args[i];
                        if (i != 0) {
                            b.append(", ");
                        }
                        b.append(this.toString(arg));
                    }
                    b.append(")");
                    System.err.print(b);
                    Object ret = method.invoke(original, args);
                    if (method.getReturnType().equals(Void.class)) {
                        return null;
                    }
                    System.err.println(" => " + this.toString(ret));
                    return ret;
                }

                String toString(Object arg) {
                    if (arg instanceof Object[]) {
                        return Arrays.toString((Object[])arg);
                    }
                    return String.valueOf(arg);
                }
            };
            Class<?> proxyClass = Proxy.getProxyClass(libraryClass.getClassLoader(), libraryClass);
            return proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create trace library");
        }
    }

    public static final Object getLibrary(String name, String path, Class<?> libraryClass) {
        Object original = Native.loadLibrary((String)path, libraryClass, MangledFunctionMapper.DEFAULT_OPTIONS);
        return LibraryExtractor.shouldTraceCalls(name) ? LibraryExtractor.getTracingLibrary(original, libraryClass) : original;
    }

    private static String getFileName(URL url) {
        return new File(url.getFile()).getName();
    }

    static {
        if (Platform.isWindows()) {
            String path = System.getProperty("java.library.path");
            String winPath = "c:\\Windows\\" + (Platform.is64Bit() ? "SysWOW64" : "System32");
            path = path == null ? winPath : path + ";" + winPath;
            System.setProperty("java.library.path", path);
        }
    }
}

