#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1148
#define LARGE_STATE_COUNT 732
#define SYMBOL_COUNT 124
#define ALIAS_COUNT 0
#define TOKEN_COUNT 77
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 14
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 15

enum {
  anon_sym_LF = 1,
  anon_sym_SEMI = 2,
  anon_sym_function = 3,
  anon_sym_BSLASH = 4,
  anon_sym_if = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_else = 8,
  anon_sym_while = 9,
  anon_sym_repeat = 10,
  anon_sym_for = 11,
  anon_sym_in = 12,
  anon_sym_switch = 13,
  anon_sym_COMMA = 14,
  anon_sym_EQ = 15,
  anon_sym_LBRACE = 16,
  anon_sym_RBRACE = 17,
  anon_sym_LT_DASH = 18,
  anon_sym_COLON_EQ = 19,
  anon_sym_LT_LT_DASH = 20,
  anon_sym_DASH_GT_GT = 21,
  anon_sym_DASH_GT = 22,
  anon_sym_LBRACK = 23,
  anon_sym_RBRACK = 24,
  anon_sym_LBRACK_LBRACK = 25,
  anon_sym_RBRACK_RBRACK = 26,
  anon_sym_DOLLAR = 27,
  anon_sym_AT = 28,
  anon_sym_COLON_COLON = 29,
  anon_sym_COLON_COLON_COLON = 30,
  sym_dots = 31,
  anon_sym_PIPE_GT = 32,
  anon_sym_DASH = 33,
  anon_sym_PLUS = 34,
  anon_sym_BANG = 35,
  anon_sym_TILDE = 36,
  anon_sym_STAR = 37,
  anon_sym_SLASH = 38,
  anon_sym_CARET = 39,
  anon_sym_LT = 40,
  anon_sym_GT = 41,
  anon_sym_LT_EQ = 42,
  anon_sym_GT_EQ = 43,
  anon_sym_EQ_EQ = 44,
  anon_sym_BANG_EQ = 45,
  anon_sym_PIPE_PIPE = 46,
  anon_sym_PIPE = 47,
  anon_sym_AMP_AMP = 48,
  anon_sym_AMP = 49,
  anon_sym_COLON = 50,
  sym_break = 51,
  sym_next = 52,
  sym_true = 53,
  sym_false = 54,
  sym_null = 55,
  sym_inf = 56,
  sym_nan = 57,
  anon_sym_NA = 58,
  anon_sym_NA_character_ = 59,
  anon_sym_NA_complex_ = 60,
  anon_sym_NA_integer_ = 61,
  anon_sym_NA_real_ = 62,
  aux_sym_identifier_token1 = 63,
  anon_sym_BQUOTE = 64,
  aux_sym_identifier_token2 = 65,
  sym_integer = 66,
  sym_float = 67,
  anon_sym_i = 68,
  sym_comment = 69,
  anon_sym_DQUOTE = 70,
  aux_sym_string_token1 = 71,
  anon_sym_SQUOTE = 72,
  aux_sym_string_token2 = 73,
  anon_sym_PERCENT = 74,
  aux_sym_special_token1 = 75,
  sym_escape_sequence = 76,
  sym_program = 77,
  sym_function_definition = 78,
  sym_lambda_function = 79,
  sym_if = 80,
  sym_while = 81,
  sym_repeat = 82,
  sym_for = 83,
  sym_switch = 84,
  sym_formal_parameters = 85,
  sym_default_parameter = 86,
  sym__formal_parameter = 87,
  sym_arguments = 88,
  sym_default_argument = 89,
  sym__argument = 90,
  sym_call = 91,
  sym__assignment = 92,
  sym_left_assignment = 93,
  sym_left_assignment2 = 94,
  sym_equals_assignment = 95,
  sym_super_assignment = 96,
  sym_super_right_assignment = 97,
  sym_right_assignment = 98,
  sym_brace_list = 99,
  sym_paren_list = 100,
  sym_subset = 101,
  sym_subset2 = 102,
  sym_dollar = 103,
  sym_slot = 104,
  sym_namespace_get = 105,
  sym_namespace_get_internal = 106,
  sym_pipe = 107,
  sym_unary = 108,
  sym_binary = 109,
  sym_na = 110,
  sym__expression = 111,
  sym_identifier = 112,
  sym_complex = 113,
  sym_string = 114,
  sym_special = 115,
  aux_sym_program_repeat1 = 116,
  aux_sym_formal_parameters_repeat1 = 117,
  aux_sym_block_repeat1 = 118,
  aux_sym_arguments_repeat1 = 119,
  aux_sym_identifier_repeat1 = 120,
  aux_sym_string_repeat1 = 121,
  aux_sym_string_repeat2 = 122,
  aux_sym_special_repeat1 = 123,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_function] = "function",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_if] = "if",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_switch] = "switch",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [sym_dots] = "dots",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_AMP] = "&",
  [anon_sym_COLON] = ":",
  [sym_break] = "break",
  [sym_next] = "next",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_character_] = "NA_character_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [aux_sym_identifier_token1] = "identifier_token1",
  [anon_sym_BQUOTE] = "`",
  [aux_sym_identifier_token2] = "identifier_token2",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_i] = "i",
  [sym_comment] = "comment",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [anon_sym_PERCENT] = "%",
  [aux_sym_special_token1] = "special_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_lambda_function] = "lambda_function",
  [sym_if] = "if",
  [sym_while] = "while",
  [sym_repeat] = "repeat",
  [sym_for] = "for",
  [sym_switch] = "switch",
  [sym_formal_parameters] = "formal_parameters",
  [sym_default_parameter] = "default_parameter",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_arguments] = "arguments",
  [sym_default_argument] = "default_argument",
  [sym__argument] = "_argument",
  [sym_call] = "call",
  [sym__assignment] = "_assignment",
  [sym_left_assignment] = "left_assignment",
  [sym_left_assignment2] = "left_assignment2",
  [sym_equals_assignment] = "equals_assignment",
  [sym_super_assignment] = "super_assignment",
  [sym_super_right_assignment] = "super_right_assignment",
  [sym_right_assignment] = "right_assignment",
  [sym_brace_list] = "brace_list",
  [sym_paren_list] = "paren_list",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_dollar] = "dollar",
  [sym_slot] = "slot",
  [sym_namespace_get] = "namespace_get",
  [sym_namespace_get_internal] = "namespace_get_internal",
  [sym_pipe] = "pipe",
  [sym_unary] = "unary",
  [sym_binary] = "binary",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym_identifier] = "identifier",
  [sym_complex] = "complex",
  [sym_string] = "string",
  [sym_special] = "special",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_special_repeat1] = "special_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [sym_dots] = sym_dots,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_break] = sym_break,
  [sym_next] = sym_next,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym_identifier_token2] = aux_sym_identifier_token2,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_i] = anon_sym_i,
  [sym_comment] = sym_comment,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [aux_sym_special_token1] = aux_sym_special_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_lambda_function] = sym_lambda_function,
  [sym_if] = sym_if,
  [sym_while] = sym_while,
  [sym_repeat] = sym_repeat,
  [sym_for] = sym_for,
  [sym_switch] = sym_switch,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_default_parameter] = sym_default_parameter,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_arguments] = sym_arguments,
  [sym_default_argument] = sym_default_argument,
  [sym__argument] = sym__argument,
  [sym_call] = sym_call,
  [sym__assignment] = sym__assignment,
  [sym_left_assignment] = sym_left_assignment,
  [sym_left_assignment2] = sym_left_assignment2,
  [sym_equals_assignment] = sym_equals_assignment,
  [sym_super_assignment] = sym_super_assignment,
  [sym_super_right_assignment] = sym_super_right_assignment,
  [sym_right_assignment] = sym_right_assignment,
  [sym_brace_list] = sym_brace_list,
  [sym_paren_list] = sym_paren_list,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_dollar] = sym_dollar,
  [sym_slot] = sym_slot,
  [sym_namespace_get] = sym_namespace_get,
  [sym_namespace_get_internal] = sym_namespace_get_internal,
  [sym_pipe] = sym_pipe,
  [sym_unary] = sym_unary,
  [sym_binary] = sym_binary,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym_identifier] = sym_identifier,
  [sym_complex] = sym_complex,
  [sym_string] = sym_string,
  [sym_special] = sym_special,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_special_repeat1] = aux_sym_special_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_special_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_default_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_left_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_left_assignment2] = {
    .visible = true,
    .named = true,
  },
  [sym_equals_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_super_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_super_right_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_right_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_list] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_list] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar] = {
    .visible = true,
    .named = true,
  },
  [sym_slot] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get_internal] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym_unary] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_special] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_special_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_function = 6,
  field_left = 7,
  field_name = 8,
  field_namespace = 9,
  field_operand = 10,
  field_operator = 11,
  field_right = 12,
  field_value = 13,
  field_vector = 14,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_value] = "value",
  [field_vector] = "vector",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 3},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 1},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 2},
  [12] = {.index = 20, .length = 2},
  [13] = {.index = 22, .length = 4},
  [14] = {.index = 26, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 1},
  [1] =
    {field_operand, 1},
    {field_operator, 0},
  [3] =
    {field_function, 0},
  [4] =
    {field_name, 0},
    {field_value, 2},
  [6] =
    {field_name, 2},
    {field_value, 0},
  [8] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [11] =
    {field_function, 2},
    {field_namespace, 0},
  [13] =
    {field_name, 0},
  [14] =
    {field_arguments, 2},
    {field_function, 0},
  [16] =
    {field_condition, 2},
    {field_consequence, 4},
  [18] =
    {field_body, 4},
    {field_condition, 2},
  [20] =
    {field_body, 4},
    {field_value, 2},
  [22] =
    {field_alternative, 5},
    {field_alternative, 6},
    {field_condition, 2},
    {field_consequence, 4},
  [26] =
    {field_body, 6},
    {field_name, 2},
    {field_vector, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(222);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(223);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(224);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(225);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(214);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '\r') ADVANCE(5);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(196);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(196);
      if (lookahead == '\r') ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(210);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '\r') ADVANCE(9);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(218);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '\r') ADVANCE(11);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0) ADVANCE(198);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0) ADVANCE(198);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0) ADVANCE(212);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0) ADVANCE(212);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      END_STATE();
    case 29:
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 30:
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(73);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 33:
      if (lookahead == ']') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == '}') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(221);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 47:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 48:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 49:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 50:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 51:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '0') ADVANCE(201);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_function);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH_GT_GT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(78);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(83);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_dots);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(75);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(85);
      if (lookahead == '|') ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(101);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_break);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_next);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_null);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_inf);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_nan);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(140);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(124);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(112);
      if (lookahead == 'U') ADVANCE(126);
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(107);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(108);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(129);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(109);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(125);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N') ADVANCE(111);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R') ADVANCE(130);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S') ADVANCE(123);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U') ADVANCE(122);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(116);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(115);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(113);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(164);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(182);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(166);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(185);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(143);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(160);
      if (lookahead == 'i') ADVANCE(173);
      if (lookahead == 'r') ADVANCE(153);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(158);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(189);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(191);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(177);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(135);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(157);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(192);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(138);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(57);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(110);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'g') ADVANCE(152);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(66);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(162);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(136);
      if (lookahead == 'o') ADVANCE(169);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(175);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'k') ADVANCE(105);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(183);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(131);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(150);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'm') ADVANCE(176);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(142);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(188);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(178);
      if (lookahead == 'u') ADVANCE(171);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(172);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(168);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(151);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(64);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(134);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(139);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(147);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(106);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(141);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(161);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(149);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(154);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'w') ADVANCE(163);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(184);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(132);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      if (lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '`') ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(203);
      if (lookahead == 'L') ADVANCE(199);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(203);
      if (lookahead == 'L') ADVANCE(199);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'L') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_i);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(57);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(212);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(216);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym_special_token1);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%') ADVANCE(220);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(220);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(214);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(196);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(210);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(218);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(221);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(226);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 51},
  [2] = {.lex_state = 51},
  [3] = {.lex_state = 22},
  [4] = {.lex_state = 51},
  [5] = {.lex_state = 22},
  [6] = {.lex_state = 51},
  [7] = {.lex_state = 51},
  [8] = {.lex_state = 51},
  [9] = {.lex_state = 22},
  [10] = {.lex_state = 22},
  [11] = {.lex_state = 22},
  [12] = {.lex_state = 51},
  [13] = {.lex_state = 22},
  [14] = {.lex_state = 51},
  [15] = {.lex_state = 22},
  [16] = {.lex_state = 51},
  [17] = {.lex_state = 51},
  [18] = {.lex_state = 51},
  [19] = {.lex_state = 51},
  [20] = {.lex_state = 22},
  [21] = {.lex_state = 51},
  [22] = {.lex_state = 22},
  [23] = {.lex_state = 51},
  [24] = {.lex_state = 51},
  [25] = {.lex_state = 51},
  [26] = {.lex_state = 22},
  [27] = {.lex_state = 51},
  [28] = {.lex_state = 22},
  [29] = {.lex_state = 51},
  [30] = {.lex_state = 51},
  [31] = {.lex_state = 51},
  [32] = {.lex_state = 51},
  [33] = {.lex_state = 51},
  [34] = {.lex_state = 51},
  [35] = {.lex_state = 51},
  [36] = {.lex_state = 51},
  [37] = {.lex_state = 51},
  [38] = {.lex_state = 51},
  [39] = {.lex_state = 51},
  [40] = {.lex_state = 51},
  [41] = {.lex_state = 51},
  [42] = {.lex_state = 22},
  [43] = {.lex_state = 51},
  [44] = {.lex_state = 51},
  [45] = {.lex_state = 51},
  [46] = {.lex_state = 51},
  [47] = {.lex_state = 51},
  [48] = {.lex_state = 51},
  [49] = {.lex_state = 51},
  [50] = {.lex_state = 51},
  [51] = {.lex_state = 51},
  [52] = {.lex_state = 51},
  [53] = {.lex_state = 51},
  [54] = {.lex_state = 51},
  [55] = {.lex_state = 51},
  [56] = {.lex_state = 51},
  [57] = {.lex_state = 51},
  [58] = {.lex_state = 51},
  [59] = {.lex_state = 51},
  [60] = {.lex_state = 51},
  [61] = {.lex_state = 51},
  [62] = {.lex_state = 51},
  [63] = {.lex_state = 51},
  [64] = {.lex_state = 51},
  [65] = {.lex_state = 51},
  [66] = {.lex_state = 51},
  [67] = {.lex_state = 51},
  [68] = {.lex_state = 51},
  [69] = {.lex_state = 51},
  [70] = {.lex_state = 51},
  [71] = {.lex_state = 51},
  [72] = {.lex_state = 51},
  [73] = {.lex_state = 51},
  [74] = {.lex_state = 51},
  [75] = {.lex_state = 51},
  [76] = {.lex_state = 51},
  [77] = {.lex_state = 51},
  [78] = {.lex_state = 51},
  [79] = {.lex_state = 51},
  [80] = {.lex_state = 51},
  [81] = {.lex_state = 51},
  [82] = {.lex_state = 51},
  [83] = {.lex_state = 51},
  [84] = {.lex_state = 21},
  [85] = {.lex_state = 21},
  [86] = {.lex_state = 21},
  [87] = {.lex_state = 21},
  [88] = {.lex_state = 51},
  [89] = {.lex_state = 51},
  [90] = {.lex_state = 51},
  [91] = {.lex_state = 51},
  [92] = {.lex_state = 24},
  [93] = {.lex_state = 51},
  [94] = {.lex_state = 24},
  [95] = {.lex_state = 22},
  [96] = {.lex_state = 24},
  [97] = {.lex_state = 24},
  [98] = {.lex_state = 51},
  [99] = {.lex_state = 51},
  [100] = {.lex_state = 51},
  [101] = {.lex_state = 51},
  [102] = {.lex_state = 51},
  [103] = {.lex_state = 51},
  [104] = {.lex_state = 51},
  [105] = {.lex_state = 51},
  [106] = {.lex_state = 51},
  [107] = {.lex_state = 51},
  [108] = {.lex_state = 51},
  [109] = {.lex_state = 51},
  [110] = {.lex_state = 51},
  [111] = {.lex_state = 51},
  [112] = {.lex_state = 51},
  [113] = {.lex_state = 51},
  [114] = {.lex_state = 51},
  [115] = {.lex_state = 51},
  [116] = {.lex_state = 21},
  [117] = {.lex_state = 51},
  [118] = {.lex_state = 51},
  [119] = {.lex_state = 51},
  [120] = {.lex_state = 51},
  [121] = {.lex_state = 51},
  [122] = {.lex_state = 51},
  [123] = {.lex_state = 51},
  [124] = {.lex_state = 51},
  [125] = {.lex_state = 51},
  [126] = {.lex_state = 51},
  [127] = {.lex_state = 51},
  [128] = {.lex_state = 51},
  [129] = {.lex_state = 51},
  [130] = {.lex_state = 51},
  [131] = {.lex_state = 51},
  [132] = {.lex_state = 51},
  [133] = {.lex_state = 51},
  [134] = {.lex_state = 51},
  [135] = {.lex_state = 51},
  [136] = {.lex_state = 51},
  [137] = {.lex_state = 51},
  [138] = {.lex_state = 51},
  [139] = {.lex_state = 51},
  [140] = {.lex_state = 51},
  [141] = {.lex_state = 51},
  [142] = {.lex_state = 51},
  [143] = {.lex_state = 51},
  [144] = {.lex_state = 51},
  [145] = {.lex_state = 51},
  [146] = {.lex_state = 51},
  [147] = {.lex_state = 51},
  [148] = {.lex_state = 51},
  [149] = {.lex_state = 51},
  [150] = {.lex_state = 51},
  [151] = {.lex_state = 51},
  [152] = {.lex_state = 51},
  [153] = {.lex_state = 51},
  [154] = {.lex_state = 51},
  [155] = {.lex_state = 51},
  [156] = {.lex_state = 51},
  [157] = {.lex_state = 51},
  [158] = {.lex_state = 51},
  [159] = {.lex_state = 22},
  [160] = {.lex_state = 51},
  [161] = {.lex_state = 51},
  [162] = {.lex_state = 22},
  [163] = {.lex_state = 51},
  [164] = {.lex_state = 51},
  [165] = {.lex_state = 51},
  [166] = {.lex_state = 51},
  [167] = {.lex_state = 51},
  [168] = {.lex_state = 51},
  [169] = {.lex_state = 51},
  [170] = {.lex_state = 51},
  [171] = {.lex_state = 22},
  [172] = {.lex_state = 51},
  [173] = {.lex_state = 51},
  [174] = {.lex_state = 51},
  [175] = {.lex_state = 51},
  [176] = {.lex_state = 51},
  [177] = {.lex_state = 51},
  [178] = {.lex_state = 51},
  [179] = {.lex_state = 51},
  [180] = {.lex_state = 51},
  [181] = {.lex_state = 51},
  [182] = {.lex_state = 51},
  [183] = {.lex_state = 51},
  [184] = {.lex_state = 51},
  [185] = {.lex_state = 51},
  [186] = {.lex_state = 51},
  [187] = {.lex_state = 51},
  [188] = {.lex_state = 51},
  [189] = {.lex_state = 51},
  [190] = {.lex_state = 51},
  [191] = {.lex_state = 51},
  [192] = {.lex_state = 51},
  [193] = {.lex_state = 51},
  [194] = {.lex_state = 51},
  [195] = {.lex_state = 51},
  [196] = {.lex_state = 51},
  [197] = {.lex_state = 51},
  [198] = {.lex_state = 51},
  [199] = {.lex_state = 22},
  [200] = {.lex_state = 51},
  [201] = {.lex_state = 51},
  [202] = {.lex_state = 51},
  [203] = {.lex_state = 51},
  [204] = {.lex_state = 51},
  [205] = {.lex_state = 51},
  [206] = {.lex_state = 21},
  [207] = {.lex_state = 21},
  [208] = {.lex_state = 51},
  [209] = {.lex_state = 51},
  [210] = {.lex_state = 51},
  [211] = {.lex_state = 21},
  [212] = {.lex_state = 51},
  [213] = {.lex_state = 51},
  [214] = {.lex_state = 51},
  [215] = {.lex_state = 51},
  [216] = {.lex_state = 51},
  [217] = {.lex_state = 51},
  [218] = {.lex_state = 21},
  [219] = {.lex_state = 21},
  [220] = {.lex_state = 21},
  [221] = {.lex_state = 21},
  [222] = {.lex_state = 21},
  [223] = {.lex_state = 21},
  [224] = {.lex_state = 21},
  [225] = {.lex_state = 21},
  [226] = {.lex_state = 21},
  [227] = {.lex_state = 51},
  [228] = {.lex_state = 51},
  [229] = {.lex_state = 51},
  [230] = {.lex_state = 51},
  [231] = {.lex_state = 51},
  [232] = {.lex_state = 51},
  [233] = {.lex_state = 51},
  [234] = {.lex_state = 21},
  [235] = {.lex_state = 21},
  [236] = {.lex_state = 21},
  [237] = {.lex_state = 51},
  [238] = {.lex_state = 51},
  [239] = {.lex_state = 21},
  [240] = {.lex_state = 21},
  [241] = {.lex_state = 21},
  [242] = {.lex_state = 51},
  [243] = {.lex_state = 51},
  [244] = {.lex_state = 51},
  [245] = {.lex_state = 51},
  [246] = {.lex_state = 21},
  [247] = {.lex_state = 51},
  [248] = {.lex_state = 51},
  [249] = {.lex_state = 47},
  [250] = {.lex_state = 51},
  [251] = {.lex_state = 51},
  [252] = {.lex_state = 51},
  [253] = {.lex_state = 51},
  [254] = {.lex_state = 51},
  [255] = {.lex_state = 21},
  [256] = {.lex_state = 21},
  [257] = {.lex_state = 51},
  [258] = {.lex_state = 51},
  [259] = {.lex_state = 51},
  [260] = {.lex_state = 51},
  [261] = {.lex_state = 51},
  [262] = {.lex_state = 51},
  [263] = {.lex_state = 51},
  [264] = {.lex_state = 51},
  [265] = {.lex_state = 51},
  [266] = {.lex_state = 51},
  [267] = {.lex_state = 51},
  [268] = {.lex_state = 51},
  [269] = {.lex_state = 51},
  [270] = {.lex_state = 51},
  [271] = {.lex_state = 51},
  [272] = {.lex_state = 51},
  [273] = {.lex_state = 51},
  [274] = {.lex_state = 51},
  [275] = {.lex_state = 51},
  [276] = {.lex_state = 51},
  [277] = {.lex_state = 51},
  [278] = {.lex_state = 51},
  [279] = {.lex_state = 51},
  [280] = {.lex_state = 51},
  [281] = {.lex_state = 51},
  [282] = {.lex_state = 51},
  [283] = {.lex_state = 51},
  [284] = {.lex_state = 51},
  [285] = {.lex_state = 51},
  [286] = {.lex_state = 51},
  [287] = {.lex_state = 51},
  [288] = {.lex_state = 51},
  [289] = {.lex_state = 51},
  [290] = {.lex_state = 51},
  [291] = {.lex_state = 51},
  [292] = {.lex_state = 51},
  [293] = {.lex_state = 51},
  [294] = {.lex_state = 51},
  [295] = {.lex_state = 51},
  [296] = {.lex_state = 51},
  [297] = {.lex_state = 51},
  [298] = {.lex_state = 51},
  [299] = {.lex_state = 51},
  [300] = {.lex_state = 47},
  [301] = {.lex_state = 51},
  [302] = {.lex_state = 51},
  [303] = {.lex_state = 51},
  [304] = {.lex_state = 51},
  [305] = {.lex_state = 51},
  [306] = {.lex_state = 51},
  [307] = {.lex_state = 51},
  [308] = {.lex_state = 51},
  [309] = {.lex_state = 51},
  [310] = {.lex_state = 51},
  [311] = {.lex_state = 51},
  [312] = {.lex_state = 51},
  [313] = {.lex_state = 47},
  [314] = {.lex_state = 51},
  [315] = {.lex_state = 51},
  [316] = {.lex_state = 51},
  [317] = {.lex_state = 51},
  [318] = {.lex_state = 51},
  [319] = {.lex_state = 51},
  [320] = {.lex_state = 51},
  [321] = {.lex_state = 51},
  [322] = {.lex_state = 51},
  [323] = {.lex_state = 51},
  [324] = {.lex_state = 51},
  [325] = {.lex_state = 51},
  [326] = {.lex_state = 51},
  [327] = {.lex_state = 47},
  [328] = {.lex_state = 51},
  [329] = {.lex_state = 51},
  [330] = {.lex_state = 51},
  [331] = {.lex_state = 51},
  [332] = {.lex_state = 51},
  [333] = {.lex_state = 51},
  [334] = {.lex_state = 51},
  [335] = {.lex_state = 51},
  [336] = {.lex_state = 51},
  [337] = {.lex_state = 51},
  [338] = {.lex_state = 51},
  [339] = {.lex_state = 51},
  [340] = {.lex_state = 51},
  [341] = {.lex_state = 51},
  [342] = {.lex_state = 51},
  [343] = {.lex_state = 51},
  [344] = {.lex_state = 51},
  [345] = {.lex_state = 51},
  [346] = {.lex_state = 51},
  [347] = {.lex_state = 51},
  [348] = {.lex_state = 51},
  [349] = {.lex_state = 51},
  [350] = {.lex_state = 51},
  [351] = {.lex_state = 51},
  [352] = {.lex_state = 51},
  [353] = {.lex_state = 51},
  [354] = {.lex_state = 51},
  [355] = {.lex_state = 51},
  [356] = {.lex_state = 51},
  [357] = {.lex_state = 51},
  [358] = {.lex_state = 51},
  [359] = {.lex_state = 51},
  [360] = {.lex_state = 51},
  [361] = {.lex_state = 51},
  [362] = {.lex_state = 51},
  [363] = {.lex_state = 51},
  [364] = {.lex_state = 51},
  [365] = {.lex_state = 51},
  [366] = {.lex_state = 51},
  [367] = {.lex_state = 51},
  [368] = {.lex_state = 51},
  [369] = {.lex_state = 51},
  [370] = {.lex_state = 51},
  [371] = {.lex_state = 51},
  [372] = {.lex_state = 51},
  [373] = {.lex_state = 51},
  [374] = {.lex_state = 51},
  [375] = {.lex_state = 51},
  [376] = {.lex_state = 51},
  [377] = {.lex_state = 51},
  [378] = {.lex_state = 51},
  [379] = {.lex_state = 51},
  [380] = {.lex_state = 51},
  [381] = {.lex_state = 51},
  [382] = {.lex_state = 51},
  [383] = {.lex_state = 51},
  [384] = {.lex_state = 51},
  [385] = {.lex_state = 51},
  [386] = {.lex_state = 51},
  [387] = {.lex_state = 51},
  [388] = {.lex_state = 47},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 51},
  [391] = {.lex_state = 51},
  [392] = {.lex_state = 51},
  [393] = {.lex_state = 51},
  [394] = {.lex_state = 51},
  [395] = {.lex_state = 51},
  [396] = {.lex_state = 51},
  [397] = {.lex_state = 51},
  [398] = {.lex_state = 51},
  [399] = {.lex_state = 51},
  [400] = {.lex_state = 51},
  [401] = {.lex_state = 51},
  [402] = {.lex_state = 51},
  [403] = {.lex_state = 47},
  [404] = {.lex_state = 51},
  [405] = {.lex_state = 51},
  [406] = {.lex_state = 51},
  [407] = {.lex_state = 51},
  [408] = {.lex_state = 51},
  [409] = {.lex_state = 21},
  [410] = {.lex_state = 51},
  [411] = {.lex_state = 21},
  [412] = {.lex_state = 21},
  [413] = {.lex_state = 21},
  [414] = {.lex_state = 47},
  [415] = {.lex_state = 51},
  [416] = {.lex_state = 47},
  [417] = {.lex_state = 51},
  [418] = {.lex_state = 51},
  [419] = {.lex_state = 51},
  [420] = {.lex_state = 51},
  [421] = {.lex_state = 51},
  [422] = {.lex_state = 51},
  [423] = {.lex_state = 51},
  [424] = {.lex_state = 51},
  [425] = {.lex_state = 51},
  [426] = {.lex_state = 51},
  [427] = {.lex_state = 51},
  [428] = {.lex_state = 51},
  [429] = {.lex_state = 51},
  [430] = {.lex_state = 51},
  [431] = {.lex_state = 48},
  [432] = {.lex_state = 51},
  [433] = {.lex_state = 21},
  [434] = {.lex_state = 21},
  [435] = {.lex_state = 21},
  [436] = {.lex_state = 21},
  [437] = {.lex_state = 24},
  [438] = {.lex_state = 24},
  [439] = {.lex_state = 21},
  [440] = {.lex_state = 21},
  [441] = {.lex_state = 21},
  [442] = {.lex_state = 21},
  [443] = {.lex_state = 24},
  [444] = {.lex_state = 24},
  [445] = {.lex_state = 24},
  [446] = {.lex_state = 24},
  [447] = {.lex_state = 24},
  [448] = {.lex_state = 24},
  [449] = {.lex_state = 21},
  [450] = {.lex_state = 21},
  [451] = {.lex_state = 21},
  [452] = {.lex_state = 21},
  [453] = {.lex_state = 21},
  [454] = {.lex_state = 24},
  [455] = {.lex_state = 24},
  [456] = {.lex_state = 24},
  [457] = {.lex_state = 24},
  [458] = {.lex_state = 24},
  [459] = {.lex_state = 24},
  [460] = {.lex_state = 24},
  [461] = {.lex_state = 24},
  [462] = {.lex_state = 24},
  [463] = {.lex_state = 21},
  [464] = {.lex_state = 21},
  [465] = {.lex_state = 22},
  [466] = {.lex_state = 21},
  [467] = {.lex_state = 21},
  [468] = {.lex_state = 21},
  [469] = {.lex_state = 24},
  [470] = {.lex_state = 24},
  [471] = {.lex_state = 21},
  [472] = {.lex_state = 24},
  [473] = {.lex_state = 21},
  [474] = {.lex_state = 24},
  [475] = {.lex_state = 24},
  [476] = {.lex_state = 24},
  [477] = {.lex_state = 24},
  [478] = {.lex_state = 25},
  [479] = {.lex_state = 47},
  [480] = {.lex_state = 47},
  [481] = {.lex_state = 47},
  [482] = {.lex_state = 47},
  [483] = {.lex_state = 47},
  [484] = {.lex_state = 47},
  [485] = {.lex_state = 47},
  [486] = {.lex_state = 47},
  [487] = {.lex_state = 47},
  [488] = {.lex_state = 47},
  [489] = {.lex_state = 47},
  [490] = {.lex_state = 47},
  [491] = {.lex_state = 47},
  [492] = {.lex_state = 47},
  [493] = {.lex_state = 47},
  [494] = {.lex_state = 47},
  [495] = {.lex_state = 47},
  [496] = {.lex_state = 47},
  [497] = {.lex_state = 47},
  [498] = {.lex_state = 47},
  [499] = {.lex_state = 47},
  [500] = {.lex_state = 47},
  [501] = {.lex_state = 47},
  [502] = {.lex_state = 47},
  [503] = {.lex_state = 47},
  [504] = {.lex_state = 47},
  [505] = {.lex_state = 47},
  [506] = {.lex_state = 47},
  [507] = {.lex_state = 47},
  [508] = {.lex_state = 47},
  [509] = {.lex_state = 51},
  [510] = {.lex_state = 47},
  [511] = {.lex_state = 22},
  [512] = {.lex_state = 47},
  [513] = {.lex_state = 47},
  [514] = {.lex_state = 47},
  [515] = {.lex_state = 47},
  [516] = {.lex_state = 47},
  [517] = {.lex_state = 47},
  [518] = {.lex_state = 47},
  [519] = {.lex_state = 47},
  [520] = {.lex_state = 23},
  [521] = {.lex_state = 22},
  [522] = {.lex_state = 22},
  [523] = {.lex_state = 22},
  [524] = {.lex_state = 47},
  [525] = {.lex_state = 47},
  [526] = {.lex_state = 47},
  [527] = {.lex_state = 47},
  [528] = {.lex_state = 47},
  [529] = {.lex_state = 47},
  [530] = {.lex_state = 47},
  [531] = {.lex_state = 47},
  [532] = {.lex_state = 47},
  [533] = {.lex_state = 22},
  [534] = {.lex_state = 24},
  [535] = {.lex_state = 22},
  [536] = {.lex_state = 22},
  [537] = {.lex_state = 51},
  [538] = {.lex_state = 51},
  [539] = {.lex_state = 47},
  [540] = {.lex_state = 48},
  [541] = {.lex_state = 51},
  [542] = {.lex_state = 22},
  [543] = {.lex_state = 47},
  [544] = {.lex_state = 47},
  [545] = {.lex_state = 22},
  [546] = {.lex_state = 22},
  [547] = {.lex_state = 49},
  [548] = {.lex_state = 47},
  [549] = {.lex_state = 48},
  [550] = {.lex_state = 22},
  [551] = {.lex_state = 22},
  [552] = {.lex_state = 22},
  [553] = {.lex_state = 22},
  [554] = {.lex_state = 22},
  [555] = {.lex_state = 22},
  [556] = {.lex_state = 22},
  [557] = {.lex_state = 22},
  [558] = {.lex_state = 22},
  [559] = {.lex_state = 22},
  [560] = {.lex_state = 22},
  [561] = {.lex_state = 48},
  [562] = {.lex_state = 22},
  [563] = {.lex_state = 22},
  [564] = {.lex_state = 22},
  [565] = {.lex_state = 49},
  [566] = {.lex_state = 48},
  [567] = {.lex_state = 24},
  [568] = {.lex_state = 48},
  [569] = {.lex_state = 48},
  [570] = {.lex_state = 22},
  [571] = {.lex_state = 48},
  [572] = {.lex_state = 48},
  [573] = {.lex_state = 48},
  [574] = {.lex_state = 48},
  [575] = {.lex_state = 48},
  [576] = {.lex_state = 48},
  [577] = {.lex_state = 48},
  [578] = {.lex_state = 48},
  [579] = {.lex_state = 50},
  [580] = {.lex_state = 48},
  [581] = {.lex_state = 50},
  [582] = {.lex_state = 48},
  [583] = {.lex_state = 48},
  [584] = {.lex_state = 48},
  [585] = {.lex_state = 48},
  [586] = {.lex_state = 22},
  [587] = {.lex_state = 51},
  [588] = {.lex_state = 48},
  [589] = {.lex_state = 22},
  [590] = {.lex_state = 22},
  [591] = {.lex_state = 48},
  [592] = {.lex_state = 22},
  [593] = {.lex_state = 22},
  [594] = {.lex_state = 22},
  [595] = {.lex_state = 48},
  [596] = {.lex_state = 48},
  [597] = {.lex_state = 48},
  [598] = {.lex_state = 48},
  [599] = {.lex_state = 48},
  [600] = {.lex_state = 22},
  [601] = {.lex_state = 48},
  [602] = {.lex_state = 48},
  [603] = {.lex_state = 48},
  [604] = {.lex_state = 22},
  [605] = {.lex_state = 22},
  [606] = {.lex_state = 22},
  [607] = {.lex_state = 22},
  [608] = {.lex_state = 22},
  [609] = {.lex_state = 48},
  [610] = {.lex_state = 48},
  [611] = {.lex_state = 48},
  [612] = {.lex_state = 48},
  [613] = {.lex_state = 48},
  [614] = {.lex_state = 47},
  [615] = {.lex_state = 48},
  [616] = {.lex_state = 47},
  [617] = {.lex_state = 47},
  [618] = {.lex_state = 51},
  [619] = {.lex_state = 22},
  [620] = {.lex_state = 22},
  [621] = {.lex_state = 51},
  [622] = {.lex_state = 22},
  [623] = {.lex_state = 51},
  [624] = {.lex_state = 51},
  [625] = {.lex_state = 51},
  [626] = {.lex_state = 47},
  [627] = {.lex_state = 22},
  [628] = {.lex_state = 47},
  [629] = {.lex_state = 47},
  [630] = {.lex_state = 47},
  [631] = {.lex_state = 22},
  [632] = {.lex_state = 22},
  [633] = {.lex_state = 47},
  [634] = {.lex_state = 47},
  [635] = {.lex_state = 47},
  [636] = {.lex_state = 22},
  [637] = {.lex_state = 47},
  [638] = {.lex_state = 22},
  [639] = {.lex_state = 48},
  [640] = {.lex_state = 47},
  [641] = {.lex_state = 22},
  [642] = {.lex_state = 48},
  [643] = {.lex_state = 48},
  [644] = {.lex_state = 47},
  [645] = {.lex_state = 47},
  [646] = {.lex_state = 47},
  [647] = {.lex_state = 48},
  [648] = {.lex_state = 47},
  [649] = {.lex_state = 47},
  [650] = {.lex_state = 48},
  [651] = {.lex_state = 47},
  [652] = {.lex_state = 47},
  [653] = {.lex_state = 47},
  [654] = {.lex_state = 48},
  [655] = {.lex_state = 47},
  [656] = {.lex_state = 47},
  [657] = {.lex_state = 47},
  [658] = {.lex_state = 48},
  [659] = {.lex_state = 48},
  [660] = {.lex_state = 48},
  [661] = {.lex_state = 48},
  [662] = {.lex_state = 47},
  [663] = {.lex_state = 47},
  [664] = {.lex_state = 47},
  [665] = {.lex_state = 47},
  [666] = {.lex_state = 47},
  [667] = {.lex_state = 47},
  [668] = {.lex_state = 47},
  [669] = {.lex_state = 47},
  [670] = {.lex_state = 47},
  [671] = {.lex_state = 48},
  [672] = {.lex_state = 47},
  [673] = {.lex_state = 48},
  [674] = {.lex_state = 48},
  [675] = {.lex_state = 48},
  [676] = {.lex_state = 48},
  [677] = {.lex_state = 47},
  [678] = {.lex_state = 48},
  [679] = {.lex_state = 48},
  [680] = {.lex_state = 48},
  [681] = {.lex_state = 47},
  [682] = {.lex_state = 47},
  [683] = {.lex_state = 24},
  [684] = {.lex_state = 48},
  [685] = {.lex_state = 47},
  [686] = {.lex_state = 48},
  [687] = {.lex_state = 24},
  [688] = {.lex_state = 48},
  [689] = {.lex_state = 24},
  [690] = {.lex_state = 47},
  [691] = {.lex_state = 51},
  [692] = {.lex_state = 51},
  [693] = {.lex_state = 48},
  [694] = {.lex_state = 24},
  [695] = {.lex_state = 24},
  [696] = {.lex_state = 47},
  [697] = {.lex_state = 51},
  [698] = {.lex_state = 24},
  [699] = {.lex_state = 24},
  [700] = {.lex_state = 47},
  [701] = {.lex_state = 24},
  [702] = {.lex_state = 24},
  [703] = {.lex_state = 51},
  [704] = {.lex_state = 51},
  [705] = {.lex_state = 51},
  [706] = {.lex_state = 51},
  [707] = {.lex_state = 51},
  [708] = {.lex_state = 51},
  [709] = {.lex_state = 24},
  [710] = {.lex_state = 24},
  [711] = {.lex_state = 24},
  [712] = {.lex_state = 24},
  [713] = {.lex_state = 24},
  [714] = {.lex_state = 51},
  [715] = {.lex_state = 51},
  [716] = {.lex_state = 51},
  [717] = {.lex_state = 51},
  [718] = {.lex_state = 51},
  [719] = {.lex_state = 51},
  [720] = {.lex_state = 51},
  [721] = {.lex_state = 51},
  [722] = {.lex_state = 51},
  [723] = {.lex_state = 24},
  [724] = {.lex_state = 24},
  [725] = {.lex_state = 24},
  [726] = {.lex_state = 24},
  [727] = {.lex_state = 24},
  [728] = {.lex_state = 51},
  [729] = {.lex_state = 24},
  [730] = {.lex_state = 26},
  [731] = {.lex_state = 51},
  [732] = {.lex_state = 48},
  [733] = {.lex_state = 51},
  [734] = {.lex_state = 48},
  [735] = {.lex_state = 48},
  [736] = {.lex_state = 48},
  [737] = {.lex_state = 48},
  [738] = {.lex_state = 48},
  [739] = {.lex_state = 51},
  [740] = {.lex_state = 48},
  [741] = {.lex_state = 48},
  [742] = {.lex_state = 48},
  [743] = {.lex_state = 48},
  [744] = {.lex_state = 48},
  [745] = {.lex_state = 48},
  [746] = {.lex_state = 48},
  [747] = {.lex_state = 48},
  [748] = {.lex_state = 51},
  [749] = {.lex_state = 48},
  [750] = {.lex_state = 48},
  [751] = {.lex_state = 51},
  [752] = {.lex_state = 51},
  [753] = {.lex_state = 48},
  [754] = {.lex_state = 48},
  [755] = {.lex_state = 51},
  [756] = {.lex_state = 51},
  [757] = {.lex_state = 48},
  [758] = {.lex_state = 48},
  [759] = {.lex_state = 48},
  [760] = {.lex_state = 48},
  [761] = {.lex_state = 48},
  [762] = {.lex_state = 48},
  [763] = {.lex_state = 48},
  [764] = {.lex_state = 48},
  [765] = {.lex_state = 48},
  [766] = {.lex_state = 48},
  [767] = {.lex_state = 48},
  [768] = {.lex_state = 51},
  [769] = {.lex_state = 48},
  [770] = {.lex_state = 48},
  [771] = {.lex_state = 51},
  [772] = {.lex_state = 48},
  [773] = {.lex_state = 51},
  [774] = {.lex_state = 51},
  [775] = {.lex_state = 51},
  [776] = {.lex_state = 48},
  [777] = {.lex_state = 48},
  [778] = {.lex_state = 51},
  [779] = {.lex_state = 51},
  [780] = {.lex_state = 51},
  [781] = {.lex_state = 51},
  [782] = {.lex_state = 48},
  [783] = {.lex_state = 48},
  [784] = {.lex_state = 48},
  [785] = {.lex_state = 51},
  [786] = {.lex_state = 51},
  [787] = {.lex_state = 51},
  [788] = {.lex_state = 51},
  [789] = {.lex_state = 51},
  [790] = {.lex_state = 51},
  [791] = {.lex_state = 48},
  [792] = {.lex_state = 48},
  [793] = {.lex_state = 48},
  [794] = {.lex_state = 27},
  [795] = {.lex_state = 27},
  [796] = {.lex_state = 27},
  [797] = {.lex_state = 27},
  [798] = {.lex_state = 27},
  [799] = {.lex_state = 27},
  [800] = {.lex_state = 27},
  [801] = {.lex_state = 27},
  [802] = {.lex_state = 27},
  [803] = {.lex_state = 27},
  [804] = {.lex_state = 27},
  [805] = {.lex_state = 27},
  [806] = {.lex_state = 27},
  [807] = {.lex_state = 27},
  [808] = {.lex_state = 27},
  [809] = {.lex_state = 51},
  [810] = {.lex_state = 28},
  [811] = {.lex_state = 27},
  [812] = {.lex_state = 27},
  [813] = {.lex_state = 27},
  [814] = {.lex_state = 27},
  [815] = {.lex_state = 27},
  [816] = {.lex_state = 27},
  [817] = {.lex_state = 27},
  [818] = {.lex_state = 27},
  [819] = {.lex_state = 51},
  [820] = {.lex_state = 27},
  [821] = {.lex_state = 27},
  [822] = {.lex_state = 27},
  [823] = {.lex_state = 27},
  [824] = {.lex_state = 27},
  [825] = {.lex_state = 27},
  [826] = {.lex_state = 27},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 51},
  [830] = {.lex_state = 51},
  [831] = {.lex_state = 27},
  [832] = {.lex_state = 27},
  [833] = {.lex_state = 27},
  [834] = {.lex_state = 27},
  [835] = {.lex_state = 51},
  [836] = {.lex_state = 28},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 51},
  [841] = {.lex_state = 27},
  [842] = {.lex_state = 27},
  [843] = {.lex_state = 27},
  [844] = {.lex_state = 27},
  [845] = {.lex_state = 27},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 51},
  [848] = {.lex_state = 27},
  [849] = {.lex_state = 27},
  [850] = {.lex_state = 27},
  [851] = {.lex_state = 27},
  [852] = {.lex_state = 27},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 51},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 27},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 27},
  [870] = {.lex_state = 27},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 27},
  [874] = {.lex_state = 27},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 27},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 30},
  [928] = {.lex_state = 30},
  [929] = {.lex_state = 30},
  [930] = {.lex_state = 29},
  [931] = {.lex_state = 29},
  [932] = {.lex_state = 29},
  [933] = {.lex_state = 29},
  [934] = {.lex_state = 29},
  [935] = {.lex_state = 29},
  [936] = {.lex_state = 30},
  [937] = {.lex_state = 29},
  [938] = {.lex_state = 29},
  [939] = {.lex_state = 29},
  [940] = {.lex_state = 13},
  [941] = {.lex_state = 16},
  [942] = {.lex_state = 16},
  [943] = {.lex_state = 18},
  [944] = {.lex_state = 13},
  [945] = {.lex_state = 16},
  [946] = {.lex_state = 18},
  [947] = {.lex_state = 13},
  [948] = {.lex_state = 16},
  [949] = {.lex_state = 16},
  [950] = {.lex_state = 18},
  [951] = {.lex_state = 13},
  [952] = {.lex_state = 13},
  [953] = {.lex_state = 18},
  [954] = {.lex_state = 18},
  [955] = {.lex_state = 13},
  [956] = {.lex_state = 20},
  [957] = {.lex_state = 18},
  [958] = {.lex_state = 16},
  [959] = {.lex_state = 16},
  [960] = {.lex_state = 16},
  [961] = {.lex_state = 20},
  [962] = {.lex_state = 16},
  [963] = {.lex_state = 16},
  [964] = {.lex_state = 18},
  [965] = {.lex_state = 18},
  [966] = {.lex_state = 16},
  [967] = {.lex_state = 18},
  [968] = {.lex_state = 13},
  [969] = {.lex_state = 13},
  [970] = {.lex_state = 16},
  [971] = {.lex_state = 20},
  [972] = {.lex_state = 18},
  [973] = {.lex_state = 13},
  [974] = {.lex_state = 16},
  [975] = {.lex_state = 16},
  [976] = {.lex_state = 18},
  [977] = {.lex_state = 13},
  [978] = {.lex_state = 18},
  [979] = {.lex_state = 16},
  [980] = {.lex_state = 18},
  [981] = {.lex_state = 13},
  [982] = {.lex_state = 18},
  [983] = {.lex_state = 18},
  [984] = {.lex_state = 13},
  [985] = {.lex_state = 13},
  [986] = {.lex_state = 16},
  [987] = {.lex_state = 13},
  [988] = {.lex_state = 13},
  [989] = {.lex_state = 16},
  [990] = {.lex_state = 18},
  [991] = {.lex_state = 13},
  [992] = {.lex_state = 18},
  [993] = {.lex_state = 16},
  [994] = {.lex_state = 18},
  [995] = {.lex_state = 13},
  [996] = {.lex_state = 16},
  [997] = {.lex_state = 18},
  [998] = {.lex_state = 13},
  [999] = {.lex_state = 13},
  [1000] = {.lex_state = 29},
  [1001] = {.lex_state = 29},
  [1002] = {.lex_state = 29},
  [1003] = {.lex_state = 29},
  [1004] = {.lex_state = 29},
  [1005] = {.lex_state = 29},
  [1006] = {.lex_state = 29},
  [1007] = {.lex_state = 29},
  [1008] = {.lex_state = 29},
  [1009] = {.lex_state = 29},
  [1010] = {.lex_state = 29},
  [1011] = {.lex_state = 29},
  [1012] = {.lex_state = 29},
  [1013] = {.lex_state = 29},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 29},
  [1016] = {.lex_state = 29},
  [1017] = {.lex_state = 29},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 29},
  [1020] = {.lex_state = 29},
  [1021] = {.lex_state = 29},
  [1022] = {.lex_state = 29},
  [1023] = {.lex_state = 29},
  [1024] = {.lex_state = 29},
  [1025] = {.lex_state = 29},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 29},
  [1028] = {.lex_state = 29},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 29},
  [1031] = {.lex_state = 29},
  [1032] = {.lex_state = 29},
  [1033] = {.lex_state = 29},
  [1034] = {.lex_state = 29},
  [1035] = {.lex_state = 29},
  [1036] = {.lex_state = 29},
  [1037] = {.lex_state = 29},
  [1038] = {.lex_state = 29},
  [1039] = {.lex_state = 29},
  [1040] = {.lex_state = 29},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 51},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 51},
  [1073] = {.lex_state = 27},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 27},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 27},
  [1081] = {.lex_state = 51},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 27},
  [1085] = {.lex_state = 51},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 27},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 27},
  [1093] = {.lex_state = 27},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 27},
  [1097] = {.lex_state = 51},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 27},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 27},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 51},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 51},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 51},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 51},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_DASH_GT_GT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [aux_sym_identifier_token1] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1116),
    [sym_function_definition] = STATE(654),
    [sym_lambda_function] = STATE(654),
    [sym_if] = STATE(654),
    [sym_while] = STATE(654),
    [sym_repeat] = STATE(654),
    [sym_for] = STATE(654),
    [sym_switch] = STATE(654),
    [sym_call] = STATE(654),
    [sym__assignment] = STATE(654),
    [sym_left_assignment] = STATE(654),
    [sym_left_assignment2] = STATE(654),
    [sym_equals_assignment] = STATE(654),
    [sym_super_assignment] = STATE(654),
    [sym_super_right_assignment] = STATE(654),
    [sym_right_assignment] = STATE(654),
    [sym_brace_list] = STATE(654),
    [sym_paren_list] = STATE(654),
    [sym_subset] = STATE(654),
    [sym_subset2] = STATE(654),
    [sym_dollar] = STATE(654),
    [sym_slot] = STATE(654),
    [sym_namespace_get] = STATE(654),
    [sym_namespace_get_internal] = STATE(654),
    [sym_pipe] = STATE(654),
    [sym_unary] = STATE(654),
    [sym_binary] = STATE(654),
    [sym_na] = STATE(654),
    [sym__expression] = STATE(654),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(654),
    [sym_string] = STATE(654),
    [aux_sym_program_repeat1] = STATE(70),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(27),
    [sym_next] = ACTIONS(27),
    [sym_true] = ACTIONS(27),
    [sym_false] = ACTIONS(27),
    [sym_null] = ACTIONS(27),
    [sym_inf] = ACTIONS(27),
    [sym_nan] = ACTIONS(27),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [2] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1118),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(69),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [3] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_default_argument] = STATE(15),
    [sym__argument] = STATE(15),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(15),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(113),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(103),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [4] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1101),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [5] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1099),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(143),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [6] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1125),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(145),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [7] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1081),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(147),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [8] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1068),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [9] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1087),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(151),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [10] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1067),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(153),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [11] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1079),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(155),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [12] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1072),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(157),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [13] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1074),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(159),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [14] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1076),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(161),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [15] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_default_argument] = STATE(15),
    [sym__argument] = STATE(15),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(15),
    [anon_sym_SEMI] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(166),
    [anon_sym_BSLASH] = ACTIONS(169),
    [anon_sym_if] = ACTIONS(172),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_RPAREN] = ACTIONS(178),
    [anon_sym_while] = ACTIONS(180),
    [anon_sym_repeat] = ACTIONS(183),
    [anon_sym_for] = ACTIONS(186),
    [anon_sym_switch] = ACTIONS(189),
    [anon_sym_COMMA] = ACTIONS(192),
    [anon_sym_LBRACE] = ACTIONS(195),
    [anon_sym_RBRACK] = ACTIONS(178),
    [sym_dots] = ACTIONS(198),
    [anon_sym_DASH] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_BANG] = ACTIONS(204),
    [anon_sym_TILDE] = ACTIONS(207),
    [sym_break] = ACTIONS(210),
    [sym_next] = ACTIONS(210),
    [sym_true] = ACTIONS(210),
    [sym_false] = ACTIONS(210),
    [sym_null] = ACTIONS(210),
    [sym_inf] = ACTIONS(210),
    [sym_nan] = ACTIONS(210),
    [anon_sym_NA] = ACTIONS(213),
    [anon_sym_NA_character_] = ACTIONS(213),
    [anon_sym_NA_complex_] = ACTIONS(213),
    [anon_sym_NA_integer_] = ACTIONS(213),
    [anon_sym_NA_real_] = ACTIONS(213),
    [aux_sym_identifier_token1] = ACTIONS(216),
    [anon_sym_BQUOTE] = ACTIONS(219),
    [sym_integer] = ACTIONS(163),
    [sym_float] = ACTIONS(222),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_SQUOTE] = ACTIONS(228),
  },
  [16] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1066),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(231),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [17] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1107),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(233),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [18] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1089),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [19] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1109),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(237),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [20] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1112),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(239),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [21] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1115),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(241),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [22] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1119),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(243),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [23] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1113),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(245),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [24] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1085),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(247),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [25] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1105),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(249),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [26] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1095),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(251),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [27] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1127),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(253),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [28] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1129),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(255),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [29] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1110),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(257),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [30] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_arguments] = STATE(1097),
    [sym_default_argument] = STATE(35),
    [sym__argument] = STATE(35),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(259),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [31] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1070),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [32] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1106),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [33] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1121),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [34] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_default_argument] = STATE(34),
    [sym__argument] = STATE(34),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_function] = ACTIONS(264),
    [anon_sym_BSLASH] = ACTIONS(267),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_while] = ACTIONS(276),
    [anon_sym_repeat] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(282),
    [anon_sym_switch] = ACTIONS(285),
    [anon_sym_COMMA] = ACTIONS(288),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(178),
    [sym_dots] = ACTIONS(294),
    [anon_sym_DASH] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(297),
    [anon_sym_BANG] = ACTIONS(300),
    [anon_sym_TILDE] = ACTIONS(303),
    [sym_break] = ACTIONS(306),
    [sym_next] = ACTIONS(306),
    [sym_true] = ACTIONS(306),
    [sym_false] = ACTIONS(306),
    [sym_null] = ACTIONS(306),
    [sym_inf] = ACTIONS(306),
    [sym_nan] = ACTIONS(306),
    [anon_sym_NA] = ACTIONS(309),
    [anon_sym_NA_character_] = ACTIONS(309),
    [anon_sym_NA_complex_] = ACTIONS(309),
    [anon_sym_NA_integer_] = ACTIONS(309),
    [anon_sym_NA_real_] = ACTIONS(309),
    [aux_sym_identifier_token1] = ACTIONS(312),
    [anon_sym_BQUOTE] = ACTIONS(315),
    [sym_integer] = ACTIONS(261),
    [sym_float] = ACTIONS(318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(324),
  },
  [35] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_default_argument] = STATE(34),
    [sym__argument] = STATE(34),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(538),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(739),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(327),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(103),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [36] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1083),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [37] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1062),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [38] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1091),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [39] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1064),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [40] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1128),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [41] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_arguments] = STATE(1124),
    [sym_default_argument] = STATE(3),
    [sym__argument] = STATE(3),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(95),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(600),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [42] = {
    [sym_function_definition] = STATE(511),
    [sym_lambda_function] = STATE(511),
    [sym_if] = STATE(511),
    [sym_while] = STATE(511),
    [sym_repeat] = STATE(511),
    [sym_for] = STATE(511),
    [sym_switch] = STATE(511),
    [sym_call] = STATE(511),
    [sym__assignment] = STATE(511),
    [sym_left_assignment] = STATE(511),
    [sym_left_assignment2] = STATE(511),
    [sym_equals_assignment] = STATE(511),
    [sym_super_assignment] = STATE(511),
    [sym_super_right_assignment] = STATE(511),
    [sym_right_assignment] = STATE(511),
    [sym_brace_list] = STATE(511),
    [sym_paren_list] = STATE(511),
    [sym_subset] = STATE(511),
    [sym_subset2] = STATE(511),
    [sym_dollar] = STATE(511),
    [sym_slot] = STATE(511),
    [sym_namespace_get] = STATE(511),
    [sym_namespace_get_internal] = STATE(511),
    [sym_pipe] = STATE(511),
    [sym_unary] = STATE(511),
    [sym_binary] = STATE(511),
    [sym_na] = STATE(511),
    [sym__expression] = STATE(511),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(511),
    [sym_string] = STATE(511),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(331),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(331),
    [sym_dots] = ACTIONS(333),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(333),
    [sym_next] = ACTIONS(333),
    [sym_true] = ACTIONS(333),
    [sym_false] = ACTIONS(333),
    [sym_null] = ACTIONS(333),
    [sym_inf] = ACTIONS(333),
    [sym_nan] = ACTIONS(333),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(329),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [43] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(355),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [44] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(64),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(377),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [45] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(51),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [46] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(385),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [47] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(62),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [48] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(389),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [49] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(46),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(391),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [50] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(48),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [51] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [52] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(397),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [53] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(399),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [54] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(60),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(401),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [55] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(61),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(403),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [56] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(405),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [57] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [58] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(56),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(409),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [59] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(57),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(411),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [60] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [61] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(415),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [62] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [63] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(69),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(419),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [64] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(421),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [65] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(423),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [66] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(52),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(425),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [67] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(65),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [68] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(43),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(429),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [69] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(431),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [70] = {
    [sym_function_definition] = STATE(654),
    [sym_lambda_function] = STATE(654),
    [sym_if] = STATE(654),
    [sym_while] = STATE(654),
    [sym_repeat] = STATE(654),
    [sym_for] = STATE(654),
    [sym_switch] = STATE(654),
    [sym_call] = STATE(654),
    [sym__assignment] = STATE(654),
    [sym_left_assignment] = STATE(654),
    [sym_left_assignment2] = STATE(654),
    [sym_equals_assignment] = STATE(654),
    [sym_super_assignment] = STATE(654),
    [sym_super_right_assignment] = STATE(654),
    [sym_right_assignment] = STATE(654),
    [sym_brace_list] = STATE(654),
    [sym_paren_list] = STATE(654),
    [sym_subset] = STATE(654),
    [sym_subset2] = STATE(654),
    [sym_dollar] = STATE(654),
    [sym_slot] = STATE(654),
    [sym_namespace_get] = STATE(654),
    [sym_namespace_get_internal] = STATE(654),
    [sym_pipe] = STATE(654),
    [sym_unary] = STATE(654),
    [sym_binary] = STATE(654),
    [sym_na] = STATE(654),
    [sym__expression] = STATE(654),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(654),
    [sym_string] = STATE(654),
    [aux_sym_program_repeat1] = STATE(71),
    [ts_builtin_sym_end] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(27),
    [sym_next] = ACTIONS(27),
    [sym_true] = ACTIONS(27),
    [sym_false] = ACTIONS(27),
    [sym_null] = ACTIONS(27),
    [sym_inf] = ACTIONS(27),
    [sym_nan] = ACTIONS(27),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [71] = {
    [sym_function_definition] = STATE(654),
    [sym_lambda_function] = STATE(654),
    [sym_if] = STATE(654),
    [sym_while] = STATE(654),
    [sym_repeat] = STATE(654),
    [sym_for] = STATE(654),
    [sym_switch] = STATE(654),
    [sym_call] = STATE(654),
    [sym__assignment] = STATE(654),
    [sym_left_assignment] = STATE(654),
    [sym_left_assignment2] = STATE(654),
    [sym_equals_assignment] = STATE(654),
    [sym_super_assignment] = STATE(654),
    [sym_super_right_assignment] = STATE(654),
    [sym_right_assignment] = STATE(654),
    [sym_brace_list] = STATE(654),
    [sym_paren_list] = STATE(654),
    [sym_subset] = STATE(654),
    [sym_subset2] = STATE(654),
    [sym_dollar] = STATE(654),
    [sym_slot] = STATE(654),
    [sym_namespace_get] = STATE(654),
    [sym_namespace_get_internal] = STATE(654),
    [sym_pipe] = STATE(654),
    [sym_unary] = STATE(654),
    [sym_binary] = STATE(654),
    [sym_na] = STATE(654),
    [sym__expression] = STATE(654),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(654),
    [sym_string] = STATE(654),
    [aux_sym_program_repeat1] = STATE(71),
    [ts_builtin_sym_end] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(437),
    [anon_sym_function] = ACTIONS(440),
    [anon_sym_BSLASH] = ACTIONS(443),
    [anon_sym_if] = ACTIONS(446),
    [anon_sym_LPAREN] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(452),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(458),
    [anon_sym_switch] = ACTIONS(461),
    [anon_sym_LBRACE] = ACTIONS(464),
    [sym_dots] = ACTIONS(467),
    [anon_sym_DASH] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(470),
    [anon_sym_BANG] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(476),
    [sym_break] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(479),
    [anon_sym_NA_character_] = ACTIONS(479),
    [anon_sym_NA_complex_] = ACTIONS(479),
    [anon_sym_NA_integer_] = ACTIONS(479),
    [anon_sym_NA_real_] = ACTIONS(479),
    [aux_sym_identifier_token1] = ACTIONS(482),
    [anon_sym_BQUOTE] = ACTIONS(485),
    [sym_integer] = ACTIONS(437),
    [sym_float] = ACTIONS(488),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [anon_sym_SQUOTE] = ACTIONS(494),
  },
  [72] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(497),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [73] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(499),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [74] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(72),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(501),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [75] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(73),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(503),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [76] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(53),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(505),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [77] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(507),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [78] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [79] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(511),
    [anon_sym_function] = ACTIONS(514),
    [anon_sym_BSLASH] = ACTIONS(517),
    [anon_sym_if] = ACTIONS(520),
    [anon_sym_LPAREN] = ACTIONS(523),
    [anon_sym_RPAREN] = ACTIONS(526),
    [anon_sym_while] = ACTIONS(528),
    [anon_sym_repeat] = ACTIONS(531),
    [anon_sym_for] = ACTIONS(534),
    [anon_sym_switch] = ACTIONS(537),
    [anon_sym_LBRACE] = ACTIONS(540),
    [sym_dots] = ACTIONS(543),
    [anon_sym_DASH] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(546),
    [anon_sym_BANG] = ACTIONS(549),
    [anon_sym_TILDE] = ACTIONS(552),
    [sym_break] = ACTIONS(543),
    [sym_next] = ACTIONS(543),
    [sym_true] = ACTIONS(543),
    [sym_false] = ACTIONS(543),
    [sym_null] = ACTIONS(543),
    [sym_inf] = ACTIONS(543),
    [sym_nan] = ACTIONS(543),
    [anon_sym_NA] = ACTIONS(555),
    [anon_sym_NA_character_] = ACTIONS(555),
    [anon_sym_NA_complex_] = ACTIONS(555),
    [anon_sym_NA_integer_] = ACTIONS(555),
    [anon_sym_NA_real_] = ACTIONS(555),
    [aux_sym_identifier_token1] = ACTIONS(558),
    [anon_sym_BQUOTE] = ACTIONS(561),
    [sym_integer] = ACTIONS(511),
    [sym_float] = ACTIONS(564),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(567),
    [anon_sym_SQUOTE] = ACTIONS(570),
  },
  [80] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(573),
    [anon_sym_function] = ACTIONS(576),
    [anon_sym_BSLASH] = ACTIONS(579),
    [anon_sym_if] = ACTIONS(582),
    [anon_sym_LPAREN] = ACTIONS(585),
    [anon_sym_while] = ACTIONS(588),
    [anon_sym_repeat] = ACTIONS(591),
    [anon_sym_for] = ACTIONS(594),
    [anon_sym_switch] = ACTIONS(597),
    [anon_sym_LBRACE] = ACTIONS(600),
    [anon_sym_RBRACE] = ACTIONS(435),
    [sym_dots] = ACTIONS(603),
    [anon_sym_DASH] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(606),
    [anon_sym_BANG] = ACTIONS(609),
    [anon_sym_TILDE] = ACTIONS(612),
    [sym_break] = ACTIONS(603),
    [sym_next] = ACTIONS(603),
    [sym_true] = ACTIONS(603),
    [sym_false] = ACTIONS(603),
    [sym_null] = ACTIONS(603),
    [sym_inf] = ACTIONS(603),
    [sym_nan] = ACTIONS(603),
    [anon_sym_NA] = ACTIONS(615),
    [anon_sym_NA_character_] = ACTIONS(615),
    [anon_sym_NA_complex_] = ACTIONS(615),
    [anon_sym_NA_integer_] = ACTIONS(615),
    [anon_sym_NA_real_] = ACTIONS(615),
    [aux_sym_identifier_token1] = ACTIONS(618),
    [anon_sym_BQUOTE] = ACTIONS(621),
    [sym_integer] = ACTIONS(573),
    [sym_float] = ACTIONS(624),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(627),
    [anon_sym_SQUOTE] = ACTIONS(630),
  },
  [81] = {
    [sym_function_definition] = STATE(785),
    [sym_lambda_function] = STATE(785),
    [sym_if] = STATE(785),
    [sym_while] = STATE(785),
    [sym_repeat] = STATE(785),
    [sym_for] = STATE(785),
    [sym_switch] = STATE(785),
    [sym_call] = STATE(785),
    [sym__assignment] = STATE(785),
    [sym_left_assignment] = STATE(785),
    [sym_left_assignment2] = STATE(785),
    [sym_equals_assignment] = STATE(785),
    [sym_super_assignment] = STATE(785),
    [sym_super_right_assignment] = STATE(785),
    [sym_right_assignment] = STATE(785),
    [sym_brace_list] = STATE(785),
    [sym_paren_list] = STATE(785),
    [sym_subset] = STATE(785),
    [sym_subset2] = STATE(785),
    [sym_dollar] = STATE(785),
    [sym_slot] = STATE(785),
    [sym_namespace_get] = STATE(785),
    [sym_namespace_get_internal] = STATE(785),
    [sym_pipe] = STATE(785),
    [sym_unary] = STATE(785),
    [sym_binary] = STATE(785),
    [sym_na] = STATE(785),
    [sym__expression] = STATE(785),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(785),
    [sym_string] = STATE(785),
    [aux_sym_block_repeat1] = STATE(78),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(633),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(383),
    [sym_next] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_inf] = ACTIONS(383),
    [sym_nan] = ACTIONS(383),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(379),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [82] = {
    [sym_function_definition] = STATE(587),
    [sym_lambda_function] = STATE(587),
    [sym_if] = STATE(587),
    [sym_while] = STATE(587),
    [sym_repeat] = STATE(587),
    [sym_for] = STATE(587),
    [sym_switch] = STATE(587),
    [sym_call] = STATE(587),
    [sym__assignment] = STATE(587),
    [sym_left_assignment] = STATE(587),
    [sym_left_assignment2] = STATE(587),
    [sym_equals_assignment] = STATE(587),
    [sym_super_assignment] = STATE(587),
    [sym_super_right_assignment] = STATE(587),
    [sym_right_assignment] = STATE(587),
    [sym_brace_list] = STATE(587),
    [sym_paren_list] = STATE(587),
    [sym_subset] = STATE(587),
    [sym_subset2] = STATE(587),
    [sym_dollar] = STATE(587),
    [sym_slot] = STATE(587),
    [sym_namespace_get] = STATE(587),
    [sym_namespace_get_internal] = STATE(587),
    [sym_pipe] = STATE(587),
    [sym_unary] = STATE(587),
    [sym_binary] = STATE(587),
    [sym_na] = STATE(587),
    [sym__expression] = STATE(587),
    [sym_identifier] = STATE(432),
    [sym_complex] = STATE(587),
    [sym_string] = STATE(587),
    [anon_sym_SEMI] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(331),
    [sym_dots] = ACTIONS(637),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(637),
    [sym_next] = ACTIONS(637),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_inf] = ACTIONS(637),
    [sym_nan] = ACTIONS(637),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(635),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [83] = {
    [sym_function_definition] = STATE(639),
    [sym_lambda_function] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_repeat] = STATE(639),
    [sym_for] = STATE(639),
    [sym_switch] = STATE(639),
    [sym_call] = STATE(639),
    [sym__assignment] = STATE(639),
    [sym_left_assignment] = STATE(639),
    [sym_left_assignment2] = STATE(639),
    [sym_equals_assignment] = STATE(639),
    [sym_super_assignment] = STATE(639),
    [sym_super_right_assignment] = STATE(639),
    [sym_right_assignment] = STATE(639),
    [sym_brace_list] = STATE(639),
    [sym_paren_list] = STATE(639),
    [sym_subset] = STATE(639),
    [sym_subset2] = STATE(639),
    [sym_dollar] = STATE(639),
    [sym_slot] = STATE(639),
    [sym_namespace_get] = STATE(639),
    [sym_namespace_get_internal] = STATE(639),
    [sym_pipe] = STATE(639),
    [sym_unary] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_na] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(639),
    [sym_string] = STATE(639),
    [aux_sym_program_repeat1] = STATE(77),
    [anon_sym_SEMI] = ACTIONS(335),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(639),
    [sym_dots] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(357),
    [sym_next] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_inf] = ACTIONS(357),
    [sym_nan] = ACTIONS(357),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(335),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [84] = {
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_function] = ACTIONS(643),
    [anon_sym_BSLASH] = ACTIONS(641),
    [anon_sym_if] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_RPAREN] = ACTIONS(641),
    [anon_sym_else] = ACTIONS(643),
    [anon_sym_while] = ACTIONS(643),
    [anon_sym_repeat] = ACTIONS(643),
    [anon_sym_for] = ACTIONS(643),
    [anon_sym_switch] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(641),
    [anon_sym_LT_DASH] = ACTIONS(641),
    [anon_sym_COLON_EQ] = ACTIONS(641),
    [anon_sym_LT_LT_DASH] = ACTIONS(641),
    [anon_sym_DASH_GT_GT] = ACTIONS(641),
    [anon_sym_DASH_GT] = ACTIONS(643),
    [anon_sym_LBRACK] = ACTIONS(643),
    [anon_sym_RBRACK] = ACTIONS(641),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(641),
    [anon_sym_DOLLAR] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(641),
    [anon_sym_COLON_COLON] = ACTIONS(645),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(647),
    [sym_dots] = ACTIONS(643),
    [anon_sym_PIPE_GT] = ACTIONS(641),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_PLUS] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(643),
    [anon_sym_TILDE] = ACTIONS(641),
    [anon_sym_STAR] = ACTIONS(641),
    [anon_sym_SLASH] = ACTIONS(641),
    [anon_sym_CARET] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(643),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(641),
    [anon_sym_PIPE_PIPE] = ACTIONS(641),
    [anon_sym_PIPE] = ACTIONS(643),
    [anon_sym_AMP_AMP] = ACTIONS(641),
    [anon_sym_AMP] = ACTIONS(643),
    [anon_sym_COLON] = ACTIONS(643),
    [sym_break] = ACTIONS(643),
    [sym_next] = ACTIONS(643),
    [sym_true] = ACTIONS(643),
    [sym_false] = ACTIONS(643),
    [sym_null] = ACTIONS(643),
    [sym_inf] = ACTIONS(643),
    [sym_nan] = ACTIONS(643),
    [anon_sym_NA] = ACTIONS(643),
    [anon_sym_NA_character_] = ACTIONS(643),
    [anon_sym_NA_complex_] = ACTIONS(643),
    [anon_sym_NA_integer_] = ACTIONS(643),
    [anon_sym_NA_real_] = ACTIONS(643),
    [aux_sym_identifier_token1] = ACTIONS(643),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_integer] = ACTIONS(641),
    [sym_float] = ACTIONS(643),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(641),
    [anon_sym_SQUOTE] = ACTIONS(641),
    [anon_sym_PERCENT] = ACTIONS(641),
  },
  [85] = {
    [anon_sym_SEMI] = ACTIONS(649),
    [anon_sym_function] = ACTIONS(651),
    [anon_sym_BSLASH] = ACTIONS(649),
    [anon_sym_if] = ACTIONS(651),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_RPAREN] = ACTIONS(649),
    [anon_sym_else] = ACTIONS(651),
    [anon_sym_while] = ACTIONS(651),
    [anon_sym_repeat] = ACTIONS(651),
    [anon_sym_for] = ACTIONS(651),
    [anon_sym_switch] = ACTIONS(651),
    [anon_sym_COMMA] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(651),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_LT_DASH] = ACTIONS(649),
    [anon_sym_COLON_EQ] = ACTIONS(649),
    [anon_sym_LT_LT_DASH] = ACTIONS(649),
    [anon_sym_DASH_GT_GT] = ACTIONS(649),
    [anon_sym_DASH_GT] = ACTIONS(651),
    [anon_sym_LBRACK] = ACTIONS(651),
    [anon_sym_RBRACK] = ACTIONS(649),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(649),
    [anon_sym_DOLLAR] = ACTIONS(649),
    [anon_sym_AT] = ACTIONS(649),
    [anon_sym_COLON_COLON] = ACTIONS(651),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(649),
    [sym_dots] = ACTIONS(651),
    [anon_sym_PIPE_GT] = ACTIONS(649),
    [anon_sym_DASH] = ACTIONS(651),
    [anon_sym_PLUS] = ACTIONS(649),
    [anon_sym_BANG] = ACTIONS(651),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_STAR] = ACTIONS(649),
    [anon_sym_SLASH] = ACTIONS(649),
    [anon_sym_CARET] = ACTIONS(649),
    [anon_sym_LT] = ACTIONS(651),
    [anon_sym_GT] = ACTIONS(651),
    [anon_sym_LT_EQ] = ACTIONS(649),
    [anon_sym_GT_EQ] = ACTIONS(649),
    [anon_sym_EQ_EQ] = ACTIONS(649),
    [anon_sym_BANG_EQ] = ACTIONS(649),
    [anon_sym_PIPE_PIPE] = ACTIONS(649),
    [anon_sym_PIPE] = ACTIONS(651),
    [anon_sym_AMP_AMP] = ACTIONS(649),
    [anon_sym_AMP] = ACTIONS(651),
    [anon_sym_COLON] = ACTIONS(651),
    [sym_break] = ACTIONS(651),
    [sym_next] = ACTIONS(651),
    [sym_true] = ACTIONS(651),
    [sym_false] = ACTIONS(651),
    [sym_null] = ACTIONS(651),
    [sym_inf] = ACTIONS(651),
    [sym_nan] = ACTIONS(651),
    [anon_sym_NA] = ACTIONS(651),
    [anon_sym_NA_character_] = ACTIONS(651),
    [anon_sym_NA_complex_] = ACTIONS(651),
    [anon_sym_NA_integer_] = ACTIONS(651),
    [anon_sym_NA_real_] = ACTIONS(651),
    [aux_sym_identifier_token1] = ACTIONS(651),
    [anon_sym_BQUOTE] = ACTIONS(649),
    [sym_integer] = ACTIONS(649),
    [sym_float] = ACTIONS(651),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(649),
    [anon_sym_PERCENT] = ACTIONS(649),
  },
  [86] = {
    [anon_sym_SEMI] = ACTIONS(653),
    [anon_sym_function] = ACTIONS(655),
    [anon_sym_BSLASH] = ACTIONS(653),
    [anon_sym_if] = ACTIONS(655),
    [anon_sym_LPAREN] = ACTIONS(653),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_else] = ACTIONS(655),
    [anon_sym_while] = ACTIONS(655),
    [anon_sym_repeat] = ACTIONS(655),
    [anon_sym_for] = ACTIONS(655),
    [anon_sym_switch] = ACTIONS(655),
    [anon_sym_COMMA] = ACTIONS(653),
    [anon_sym_EQ] = ACTIONS(655),
    [anon_sym_LBRACE] = ACTIONS(653),
    [anon_sym_LT_DASH] = ACTIONS(653),
    [anon_sym_COLON_EQ] = ACTIONS(653),
    [anon_sym_LT_LT_DASH] = ACTIONS(653),
    [anon_sym_DASH_GT_GT] = ACTIONS(653),
    [anon_sym_DASH_GT] = ACTIONS(655),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(653),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(653),
    [anon_sym_DOLLAR] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(653),
    [anon_sym_COLON_COLON] = ACTIONS(655),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(653),
    [sym_dots] = ACTIONS(655),
    [anon_sym_PIPE_GT] = ACTIONS(653),
    [anon_sym_DASH] = ACTIONS(655),
    [anon_sym_PLUS] = ACTIONS(653),
    [anon_sym_BANG] = ACTIONS(655),
    [anon_sym_TILDE] = ACTIONS(653),
    [anon_sym_STAR] = ACTIONS(653),
    [anon_sym_SLASH] = ACTIONS(653),
    [anon_sym_CARET] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(655),
    [anon_sym_GT] = ACTIONS(655),
    [anon_sym_LT_EQ] = ACTIONS(653),
    [anon_sym_GT_EQ] = ACTIONS(653),
    [anon_sym_EQ_EQ] = ACTIONS(653),
    [anon_sym_BANG_EQ] = ACTIONS(653),
    [anon_sym_PIPE_PIPE] = ACTIONS(653),
    [anon_sym_PIPE] = ACTIONS(655),
    [anon_sym_AMP_AMP] = ACTIONS(653),
    [anon_sym_AMP] = ACTIONS(655),
    [anon_sym_COLON] = ACTIONS(655),
    [sym_break] = ACTIONS(655),
    [sym_next] = ACTIONS(655),
    [sym_true] = ACTIONS(655),
    [sym_false] = ACTIONS(655),
    [sym_null] = ACTIONS(655),
    [sym_inf] = ACTIONS(655),
    [sym_nan] = ACTIONS(655),
    [anon_sym_NA] = ACTIONS(655),
    [anon_sym_NA_character_] = ACTIONS(655),
    [anon_sym_NA_complex_] = ACTIONS(655),
    [anon_sym_NA_integer_] = ACTIONS(655),
    [anon_sym_NA_real_] = ACTIONS(655),
    [aux_sym_identifier_token1] = ACTIONS(655),
    [anon_sym_BQUOTE] = ACTIONS(653),
    [sym_integer] = ACTIONS(653),
    [sym_float] = ACTIONS(655),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(653),
    [anon_sym_SQUOTE] = ACTIONS(653),
    [anon_sym_PERCENT] = ACTIONS(653),
  },
  [87] = {
    [anon_sym_SEMI] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(659),
    [anon_sym_BSLASH] = ACTIONS(657),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_LPAREN] = ACTIONS(657),
    [anon_sym_RPAREN] = ACTIONS(657),
    [anon_sym_else] = ACTIONS(659),
    [anon_sym_while] = ACTIONS(659),
    [anon_sym_repeat] = ACTIONS(659),
    [anon_sym_for] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(659),
    [anon_sym_COMMA] = ACTIONS(657),
    [anon_sym_EQ] = ACTIONS(659),
    [anon_sym_LBRACE] = ACTIONS(657),
    [anon_sym_LT_DASH] = ACTIONS(657),
    [anon_sym_COLON_EQ] = ACTIONS(657),
    [anon_sym_LT_LT_DASH] = ACTIONS(657),
    [anon_sym_DASH_GT_GT] = ACTIONS(657),
    [anon_sym_DASH_GT] = ACTIONS(659),
    [anon_sym_LBRACK] = ACTIONS(659),
    [anon_sym_RBRACK] = ACTIONS(657),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(657),
    [anon_sym_DOLLAR] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(657),
    [anon_sym_COLON_COLON] = ACTIONS(659),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(657),
    [sym_dots] = ACTIONS(659),
    [anon_sym_PIPE_GT] = ACTIONS(657),
    [anon_sym_DASH] = ACTIONS(659),
    [anon_sym_PLUS] = ACTIONS(657),
    [anon_sym_BANG] = ACTIONS(659),
    [anon_sym_TILDE] = ACTIONS(657),
    [anon_sym_STAR] = ACTIONS(657),
    [anon_sym_SLASH] = ACTIONS(657),
    [anon_sym_CARET] = ACTIONS(657),
    [anon_sym_LT] = ACTIONS(659),
    [anon_sym_GT] = ACTIONS(659),
    [anon_sym_LT_EQ] = ACTIONS(657),
    [anon_sym_GT_EQ] = ACTIONS(657),
    [anon_sym_EQ_EQ] = ACTIONS(657),
    [anon_sym_BANG_EQ] = ACTIONS(657),
    [anon_sym_PIPE_PIPE] = ACTIONS(657),
    [anon_sym_PIPE] = ACTIONS(659),
    [anon_sym_AMP_AMP] = ACTIONS(657),
    [anon_sym_AMP] = ACTIONS(659),
    [anon_sym_COLON] = ACTIONS(659),
    [sym_break] = ACTIONS(659),
    [sym_next] = ACTIONS(659),
    [sym_true] = ACTIONS(659),
    [sym_false] = ACTIONS(659),
    [sym_null] = ACTIONS(659),
    [sym_inf] = ACTIONS(659),
    [sym_nan] = ACTIONS(659),
    [anon_sym_NA] = ACTIONS(659),
    [anon_sym_NA_character_] = ACTIONS(659),
    [anon_sym_NA_complex_] = ACTIONS(659),
    [anon_sym_NA_integer_] = ACTIONS(659),
    [anon_sym_NA_real_] = ACTIONS(659),
    [aux_sym_identifier_token1] = ACTIONS(659),
    [anon_sym_BQUOTE] = ACTIONS(657),
    [sym_integer] = ACTIONS(657),
    [sym_float] = ACTIONS(659),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(657),
    [anon_sym_SQUOTE] = ACTIONS(657),
    [anon_sym_PERCENT] = ACTIONS(657),
  },
  [88] = {
    [sym_function_definition] = STATE(457),
    [sym_lambda_function] = STATE(457),
    [sym_if] = STATE(457),
    [sym_while] = STATE(457),
    [sym_repeat] = STATE(457),
    [sym_for] = STATE(457),
    [sym_switch] = STATE(457),
    [sym_call] = STATE(457),
    [sym__assignment] = STATE(457),
    [sym_left_assignment] = STATE(457),
    [sym_left_assignment2] = STATE(457),
    [sym_equals_assignment] = STATE(457),
    [sym_super_assignment] = STATE(457),
    [sym_super_right_assignment] = STATE(457),
    [sym_right_assignment] = STATE(457),
    [sym_brace_list] = STATE(457),
    [sym_paren_list] = STATE(457),
    [sym_subset] = STATE(457),
    [sym_subset2] = STATE(457),
    [sym_dollar] = STATE(457),
    [sym_slot] = STATE(457),
    [sym_namespace_get] = STATE(457),
    [sym_namespace_get_internal] = STATE(457),
    [sym_pipe] = STATE(457),
    [sym_unary] = STATE(457),
    [sym_binary] = STATE(457),
    [sym_na] = STATE(457),
    [sym__expression] = STATE(457),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(457),
    [sym_string] = STATE(457),
    [anon_sym_SEMI] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(681),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(681),
    [sym_next] = ACTIONS(681),
    [sym_true] = ACTIONS(681),
    [sym_false] = ACTIONS(681),
    [sym_null] = ACTIONS(681),
    [sym_inf] = ACTIONS(681),
    [sym_nan] = ACTIONS(681),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(661),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [89] = {
    [sym_function_definition] = STATE(922),
    [sym_lambda_function] = STATE(922),
    [sym_if] = STATE(922),
    [sym_while] = STATE(922),
    [sym_repeat] = STATE(922),
    [sym_for] = STATE(922),
    [sym_switch] = STATE(922),
    [sym_call] = STATE(869),
    [sym__assignment] = STATE(922),
    [sym_left_assignment] = STATE(922),
    [sym_left_assignment2] = STATE(922),
    [sym_equals_assignment] = STATE(922),
    [sym_super_assignment] = STATE(922),
    [sym_super_right_assignment] = STATE(922),
    [sym_right_assignment] = STATE(922),
    [sym_brace_list] = STATE(922),
    [sym_paren_list] = STATE(922),
    [sym_subset] = STATE(922),
    [sym_subset2] = STATE(922),
    [sym_dollar] = STATE(922),
    [sym_slot] = STATE(922),
    [sym_namespace_get] = STATE(922),
    [sym_namespace_get_internal] = STATE(922),
    [sym_pipe] = STATE(922),
    [sym_unary] = STATE(922),
    [sym_binary] = STATE(922),
    [sym_na] = STATE(922),
    [sym__expression] = STATE(922),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(922),
    [sym_string] = STATE(922),
    [anon_sym_SEMI] = ACTIONS(701),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(715),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(715),
    [sym_next] = ACTIONS(715),
    [sym_true] = ACTIONS(715),
    [sym_false] = ACTIONS(715),
    [sym_null] = ACTIONS(715),
    [sym_inf] = ACTIONS(715),
    [sym_nan] = ACTIONS(715),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(701),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [90] = {
    [sym_function_definition] = STATE(881),
    [sym_lambda_function] = STATE(881),
    [sym_if] = STATE(881),
    [sym_while] = STATE(881),
    [sym_repeat] = STATE(881),
    [sym_for] = STATE(881),
    [sym_switch] = STATE(881),
    [sym_call] = STATE(881),
    [sym__assignment] = STATE(881),
    [sym_left_assignment] = STATE(881),
    [sym_left_assignment2] = STATE(881),
    [sym_equals_assignment] = STATE(881),
    [sym_super_assignment] = STATE(881),
    [sym_super_right_assignment] = STATE(881),
    [sym_right_assignment] = STATE(881),
    [sym_brace_list] = STATE(881),
    [sym_paren_list] = STATE(881),
    [sym_subset] = STATE(881),
    [sym_subset2] = STATE(881),
    [sym_dollar] = STATE(881),
    [sym_slot] = STATE(881),
    [sym_namespace_get] = STATE(881),
    [sym_namespace_get_internal] = STATE(881),
    [sym_pipe] = STATE(881),
    [sym_unary] = STATE(881),
    [sym_binary] = STATE(881),
    [sym_na] = STATE(881),
    [sym__expression] = STATE(881),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(881),
    [sym_string] = STATE(881),
    [anon_sym_SEMI] = ACTIONS(725),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(727),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(727),
    [sym_next] = ACTIONS(727),
    [sym_true] = ACTIONS(727),
    [sym_false] = ACTIONS(727),
    [sym_null] = ACTIONS(727),
    [sym_inf] = ACTIONS(727),
    [sym_nan] = ACTIONS(727),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(725),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [91] = {
    [sym_function_definition] = STATE(888),
    [sym_lambda_function] = STATE(888),
    [sym_if] = STATE(888),
    [sym_while] = STATE(888),
    [sym_repeat] = STATE(888),
    [sym_for] = STATE(888),
    [sym_switch] = STATE(888),
    [sym_call] = STATE(888),
    [sym__assignment] = STATE(888),
    [sym_left_assignment] = STATE(888),
    [sym_left_assignment2] = STATE(888),
    [sym_equals_assignment] = STATE(888),
    [sym_super_assignment] = STATE(888),
    [sym_super_right_assignment] = STATE(888),
    [sym_right_assignment] = STATE(888),
    [sym_brace_list] = STATE(888),
    [sym_paren_list] = STATE(888),
    [sym_subset] = STATE(888),
    [sym_subset2] = STATE(888),
    [sym_dollar] = STATE(888),
    [sym_slot] = STATE(888),
    [sym_namespace_get] = STATE(888),
    [sym_namespace_get_internal] = STATE(888),
    [sym_pipe] = STATE(888),
    [sym_unary] = STATE(888),
    [sym_binary] = STATE(888),
    [sym_na] = STATE(888),
    [sym__expression] = STATE(888),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(888),
    [sym_string] = STATE(888),
    [anon_sym_SEMI] = ACTIONS(729),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(731),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(731),
    [sym_next] = ACTIONS(731),
    [sym_true] = ACTIONS(731),
    [sym_false] = ACTIONS(731),
    [sym_null] = ACTIONS(731),
    [sym_inf] = ACTIONS(731),
    [sym_nan] = ACTIONS(731),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(729),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [92] = {
    [anon_sym_SEMI] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(659),
    [anon_sym_BSLASH] = ACTIONS(657),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_LPAREN] = ACTIONS(657),
    [anon_sym_else] = ACTIONS(659),
    [anon_sym_while] = ACTIONS(659),
    [anon_sym_repeat] = ACTIONS(659),
    [anon_sym_for] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(659),
    [anon_sym_COMMA] = ACTIONS(657),
    [anon_sym_EQ] = ACTIONS(659),
    [anon_sym_LBRACE] = ACTIONS(657),
    [anon_sym_LT_DASH] = ACTIONS(657),
    [anon_sym_COLON_EQ] = ACTIONS(657),
    [anon_sym_LT_LT_DASH] = ACTIONS(657),
    [anon_sym_DASH_GT_GT] = ACTIONS(657),
    [anon_sym_DASH_GT] = ACTIONS(659),
    [anon_sym_LBRACK] = ACTIONS(659),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(657),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(657),
    [anon_sym_DOLLAR] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(657),
    [anon_sym_COLON_COLON] = ACTIONS(659),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(657),
    [sym_dots] = ACTIONS(659),
    [anon_sym_PIPE_GT] = ACTIONS(657),
    [anon_sym_DASH] = ACTIONS(659),
    [anon_sym_PLUS] = ACTIONS(657),
    [anon_sym_BANG] = ACTIONS(659),
    [anon_sym_TILDE] = ACTIONS(657),
    [anon_sym_STAR] = ACTIONS(657),
    [anon_sym_SLASH] = ACTIONS(657),
    [anon_sym_CARET] = ACTIONS(657),
    [anon_sym_LT] = ACTIONS(659),
    [anon_sym_GT] = ACTIONS(659),
    [anon_sym_LT_EQ] = ACTIONS(657),
    [anon_sym_GT_EQ] = ACTIONS(657),
    [anon_sym_EQ_EQ] = ACTIONS(657),
    [anon_sym_BANG_EQ] = ACTIONS(657),
    [anon_sym_PIPE_PIPE] = ACTIONS(657),
    [anon_sym_PIPE] = ACTIONS(659),
    [anon_sym_AMP_AMP] = ACTIONS(657),
    [anon_sym_AMP] = ACTIONS(659),
    [anon_sym_COLON] = ACTIONS(659),
    [sym_break] = ACTIONS(659),
    [sym_next] = ACTIONS(659),
    [sym_true] = ACTIONS(659),
    [sym_false] = ACTIONS(659),
    [sym_null] = ACTIONS(659),
    [sym_inf] = ACTIONS(659),
    [sym_nan] = ACTIONS(659),
    [anon_sym_NA] = ACTIONS(659),
    [anon_sym_NA_character_] = ACTIONS(659),
    [anon_sym_NA_complex_] = ACTIONS(659),
    [anon_sym_NA_integer_] = ACTIONS(659),
    [anon_sym_NA_real_] = ACTIONS(659),
    [aux_sym_identifier_token1] = ACTIONS(659),
    [anon_sym_BQUOTE] = ACTIONS(657),
    [sym_integer] = ACTIONS(657),
    [sym_float] = ACTIONS(659),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(657),
    [anon_sym_SQUOTE] = ACTIONS(657),
    [anon_sym_PERCENT] = ACTIONS(657),
  },
  [93] = {
    [sym_function_definition] = STATE(897),
    [sym_lambda_function] = STATE(897),
    [sym_if] = STATE(897),
    [sym_while] = STATE(897),
    [sym_repeat] = STATE(897),
    [sym_for] = STATE(897),
    [sym_switch] = STATE(897),
    [sym_call] = STATE(897),
    [sym__assignment] = STATE(897),
    [sym_left_assignment] = STATE(897),
    [sym_left_assignment2] = STATE(897),
    [sym_equals_assignment] = STATE(897),
    [sym_super_assignment] = STATE(897),
    [sym_super_right_assignment] = STATE(897),
    [sym_right_assignment] = STATE(897),
    [sym_brace_list] = STATE(897),
    [sym_paren_list] = STATE(897),
    [sym_subset] = STATE(897),
    [sym_subset2] = STATE(897),
    [sym_dollar] = STATE(897),
    [sym_slot] = STATE(897),
    [sym_namespace_get] = STATE(897),
    [sym_namespace_get_internal] = STATE(897),
    [sym_pipe] = STATE(897),
    [sym_unary] = STATE(897),
    [sym_binary] = STATE(897),
    [sym_na] = STATE(897),
    [sym__expression] = STATE(897),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(897),
    [sym_string] = STATE(897),
    [anon_sym_SEMI] = ACTIONS(733),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(735),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(735),
    [sym_next] = ACTIONS(735),
    [sym_true] = ACTIONS(735),
    [sym_false] = ACTIONS(735),
    [sym_null] = ACTIONS(735),
    [sym_inf] = ACTIONS(735),
    [sym_nan] = ACTIONS(735),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(733),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [94] = {
    [anon_sym_SEMI] = ACTIONS(653),
    [anon_sym_function] = ACTIONS(655),
    [anon_sym_BSLASH] = ACTIONS(653),
    [anon_sym_if] = ACTIONS(655),
    [anon_sym_LPAREN] = ACTIONS(653),
    [anon_sym_else] = ACTIONS(655),
    [anon_sym_while] = ACTIONS(655),
    [anon_sym_repeat] = ACTIONS(655),
    [anon_sym_for] = ACTIONS(655),
    [anon_sym_switch] = ACTIONS(655),
    [anon_sym_COMMA] = ACTIONS(653),
    [anon_sym_EQ] = ACTIONS(655),
    [anon_sym_LBRACE] = ACTIONS(653),
    [anon_sym_LT_DASH] = ACTIONS(653),
    [anon_sym_COLON_EQ] = ACTIONS(653),
    [anon_sym_LT_LT_DASH] = ACTIONS(653),
    [anon_sym_DASH_GT_GT] = ACTIONS(653),
    [anon_sym_DASH_GT] = ACTIONS(655),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(653),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(653),
    [anon_sym_DOLLAR] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(653),
    [anon_sym_COLON_COLON] = ACTIONS(655),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(653),
    [sym_dots] = ACTIONS(655),
    [anon_sym_PIPE_GT] = ACTIONS(653),
    [anon_sym_DASH] = ACTIONS(655),
    [anon_sym_PLUS] = ACTIONS(653),
    [anon_sym_BANG] = ACTIONS(655),
    [anon_sym_TILDE] = ACTIONS(653),
    [anon_sym_STAR] = ACTIONS(653),
    [anon_sym_SLASH] = ACTIONS(653),
    [anon_sym_CARET] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(655),
    [anon_sym_GT] = ACTIONS(655),
    [anon_sym_LT_EQ] = ACTIONS(653),
    [anon_sym_GT_EQ] = ACTIONS(653),
    [anon_sym_EQ_EQ] = ACTIONS(653),
    [anon_sym_BANG_EQ] = ACTIONS(653),
    [anon_sym_PIPE_PIPE] = ACTIONS(653),
    [anon_sym_PIPE] = ACTIONS(655),
    [anon_sym_AMP_AMP] = ACTIONS(653),
    [anon_sym_AMP] = ACTIONS(655),
    [anon_sym_COLON] = ACTIONS(655),
    [sym_break] = ACTIONS(655),
    [sym_next] = ACTIONS(655),
    [sym_true] = ACTIONS(655),
    [sym_false] = ACTIONS(655),
    [sym_null] = ACTIONS(655),
    [sym_inf] = ACTIONS(655),
    [sym_nan] = ACTIONS(655),
    [anon_sym_NA] = ACTIONS(655),
    [anon_sym_NA_character_] = ACTIONS(655),
    [anon_sym_NA_complex_] = ACTIONS(655),
    [anon_sym_NA_integer_] = ACTIONS(655),
    [anon_sym_NA_real_] = ACTIONS(655),
    [aux_sym_identifier_token1] = ACTIONS(655),
    [anon_sym_BQUOTE] = ACTIONS(653),
    [sym_integer] = ACTIONS(653),
    [sym_float] = ACTIONS(655),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(653),
    [anon_sym_SQUOTE] = ACTIONS(653),
    [anon_sym_PERCENT] = ACTIONS(653),
  },
  [95] = {
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_function] = ACTIONS(643),
    [anon_sym_BSLASH] = ACTIONS(641),
    [anon_sym_if] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_RPAREN] = ACTIONS(641),
    [anon_sym_while] = ACTIONS(643),
    [anon_sym_repeat] = ACTIONS(643),
    [anon_sym_for] = ACTIONS(643),
    [anon_sym_switch] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(737),
    [anon_sym_LBRACE] = ACTIONS(641),
    [anon_sym_LT_DASH] = ACTIONS(641),
    [anon_sym_COLON_EQ] = ACTIONS(641),
    [anon_sym_LT_LT_DASH] = ACTIONS(641),
    [anon_sym_DASH_GT_GT] = ACTIONS(641),
    [anon_sym_DASH_GT] = ACTIONS(643),
    [anon_sym_LBRACK] = ACTIONS(643),
    [anon_sym_RBRACK] = ACTIONS(641),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(641),
    [anon_sym_DOLLAR] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(641),
    [anon_sym_COLON_COLON] = ACTIONS(739),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(741),
    [sym_dots] = ACTIONS(643),
    [anon_sym_PIPE_GT] = ACTIONS(641),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_PLUS] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(643),
    [anon_sym_TILDE] = ACTIONS(641),
    [anon_sym_STAR] = ACTIONS(641),
    [anon_sym_SLASH] = ACTIONS(641),
    [anon_sym_CARET] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(643),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(641),
    [anon_sym_PIPE_PIPE] = ACTIONS(641),
    [anon_sym_PIPE] = ACTIONS(643),
    [anon_sym_AMP_AMP] = ACTIONS(641),
    [anon_sym_AMP] = ACTIONS(643),
    [anon_sym_COLON] = ACTIONS(643),
    [sym_break] = ACTIONS(643),
    [sym_next] = ACTIONS(643),
    [sym_true] = ACTIONS(643),
    [sym_false] = ACTIONS(643),
    [sym_null] = ACTIONS(643),
    [sym_inf] = ACTIONS(643),
    [sym_nan] = ACTIONS(643),
    [anon_sym_NA] = ACTIONS(643),
    [anon_sym_NA_character_] = ACTIONS(643),
    [anon_sym_NA_complex_] = ACTIONS(643),
    [anon_sym_NA_integer_] = ACTIONS(643),
    [anon_sym_NA_real_] = ACTIONS(643),
    [aux_sym_identifier_token1] = ACTIONS(643),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_integer] = ACTIONS(641),
    [sym_float] = ACTIONS(643),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(641),
    [anon_sym_SQUOTE] = ACTIONS(641),
    [anon_sym_PERCENT] = ACTIONS(641),
  },
  [96] = {
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_function] = ACTIONS(643),
    [anon_sym_BSLASH] = ACTIONS(641),
    [anon_sym_if] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_else] = ACTIONS(643),
    [anon_sym_while] = ACTIONS(643),
    [anon_sym_repeat] = ACTIONS(643),
    [anon_sym_for] = ACTIONS(643),
    [anon_sym_switch] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(641),
    [anon_sym_LT_DASH] = ACTIONS(641),
    [anon_sym_COLON_EQ] = ACTIONS(641),
    [anon_sym_LT_LT_DASH] = ACTIONS(641),
    [anon_sym_DASH_GT_GT] = ACTIONS(641),
    [anon_sym_DASH_GT] = ACTIONS(643),
    [anon_sym_LBRACK] = ACTIONS(643),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(641),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(641),
    [anon_sym_DOLLAR] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(641),
    [anon_sym_COLON_COLON] = ACTIONS(743),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(745),
    [sym_dots] = ACTIONS(643),
    [anon_sym_PIPE_GT] = ACTIONS(641),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_PLUS] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(643),
    [anon_sym_TILDE] = ACTIONS(641),
    [anon_sym_STAR] = ACTIONS(641),
    [anon_sym_SLASH] = ACTIONS(641),
    [anon_sym_CARET] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(643),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(641),
    [anon_sym_PIPE_PIPE] = ACTIONS(641),
    [anon_sym_PIPE] = ACTIONS(643),
    [anon_sym_AMP_AMP] = ACTIONS(641),
    [anon_sym_AMP] = ACTIONS(643),
    [anon_sym_COLON] = ACTIONS(643),
    [sym_break] = ACTIONS(643),
    [sym_next] = ACTIONS(643),
    [sym_true] = ACTIONS(643),
    [sym_false] = ACTIONS(643),
    [sym_null] = ACTIONS(643),
    [sym_inf] = ACTIONS(643),
    [sym_nan] = ACTIONS(643),
    [anon_sym_NA] = ACTIONS(643),
    [anon_sym_NA_character_] = ACTIONS(643),
    [anon_sym_NA_complex_] = ACTIONS(643),
    [anon_sym_NA_integer_] = ACTIONS(643),
    [anon_sym_NA_real_] = ACTIONS(643),
    [aux_sym_identifier_token1] = ACTIONS(643),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_integer] = ACTIONS(641),
    [sym_float] = ACTIONS(643),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(641),
    [anon_sym_SQUOTE] = ACTIONS(641),
    [anon_sym_PERCENT] = ACTIONS(641),
  },
  [97] = {
    [anon_sym_SEMI] = ACTIONS(649),
    [anon_sym_function] = ACTIONS(651),
    [anon_sym_BSLASH] = ACTIONS(649),
    [anon_sym_if] = ACTIONS(651),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_else] = ACTIONS(651),
    [anon_sym_while] = ACTIONS(651),
    [anon_sym_repeat] = ACTIONS(651),
    [anon_sym_for] = ACTIONS(651),
    [anon_sym_switch] = ACTIONS(651),
    [anon_sym_COMMA] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(651),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_LT_DASH] = ACTIONS(649),
    [anon_sym_COLON_EQ] = ACTIONS(649),
    [anon_sym_LT_LT_DASH] = ACTIONS(649),
    [anon_sym_DASH_GT_GT] = ACTIONS(649),
    [anon_sym_DASH_GT] = ACTIONS(651),
    [anon_sym_LBRACK] = ACTIONS(651),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(649),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(649),
    [anon_sym_DOLLAR] = ACTIONS(649),
    [anon_sym_AT] = ACTIONS(649),
    [anon_sym_COLON_COLON] = ACTIONS(651),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(649),
    [sym_dots] = ACTIONS(651),
    [anon_sym_PIPE_GT] = ACTIONS(649),
    [anon_sym_DASH] = ACTIONS(651),
    [anon_sym_PLUS] = ACTIONS(649),
    [anon_sym_BANG] = ACTIONS(651),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_STAR] = ACTIONS(649),
    [anon_sym_SLASH] = ACTIONS(649),
    [anon_sym_CARET] = ACTIONS(649),
    [anon_sym_LT] = ACTIONS(651),
    [anon_sym_GT] = ACTIONS(651),
    [anon_sym_LT_EQ] = ACTIONS(649),
    [anon_sym_GT_EQ] = ACTIONS(649),
    [anon_sym_EQ_EQ] = ACTIONS(649),
    [anon_sym_BANG_EQ] = ACTIONS(649),
    [anon_sym_PIPE_PIPE] = ACTIONS(649),
    [anon_sym_PIPE] = ACTIONS(651),
    [anon_sym_AMP_AMP] = ACTIONS(649),
    [anon_sym_AMP] = ACTIONS(651),
    [anon_sym_COLON] = ACTIONS(651),
    [sym_break] = ACTIONS(651),
    [sym_next] = ACTIONS(651),
    [sym_true] = ACTIONS(651),
    [sym_false] = ACTIONS(651),
    [sym_null] = ACTIONS(651),
    [sym_inf] = ACTIONS(651),
    [sym_nan] = ACTIONS(651),
    [anon_sym_NA] = ACTIONS(651),
    [anon_sym_NA_character_] = ACTIONS(651),
    [anon_sym_NA_complex_] = ACTIONS(651),
    [anon_sym_NA_integer_] = ACTIONS(651),
    [anon_sym_NA_real_] = ACTIONS(651),
    [aux_sym_identifier_token1] = ACTIONS(651),
    [anon_sym_BQUOTE] = ACTIONS(649),
    [sym_integer] = ACTIONS(649),
    [sym_float] = ACTIONS(651),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(649),
    [anon_sym_PERCENT] = ACTIONS(649),
  },
  [98] = {
    [sym_function_definition] = STATE(650),
    [sym_lambda_function] = STATE(650),
    [sym_if] = STATE(650),
    [sym_while] = STATE(650),
    [sym_repeat] = STATE(650),
    [sym_for] = STATE(650),
    [sym_switch] = STATE(650),
    [sym_call] = STATE(650),
    [sym__assignment] = STATE(650),
    [sym_left_assignment] = STATE(650),
    [sym_left_assignment2] = STATE(650),
    [sym_equals_assignment] = STATE(650),
    [sym_super_assignment] = STATE(650),
    [sym_super_right_assignment] = STATE(650),
    [sym_right_assignment] = STATE(650),
    [sym_brace_list] = STATE(650),
    [sym_paren_list] = STATE(650),
    [sym_subset] = STATE(650),
    [sym_subset2] = STATE(650),
    [sym_dollar] = STATE(650),
    [sym_slot] = STATE(650),
    [sym_namespace_get] = STATE(650),
    [sym_namespace_get_internal] = STATE(650),
    [sym_pipe] = STATE(650),
    [sym_unary] = STATE(650),
    [sym_binary] = STATE(650),
    [sym_na] = STATE(650),
    [sym__expression] = STATE(650),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(650),
    [sym_string] = STATE(650),
    [anon_sym_SEMI] = ACTIONS(747),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(749),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(749),
    [sym_next] = ACTIONS(749),
    [sym_true] = ACTIONS(749),
    [sym_false] = ACTIONS(749),
    [sym_null] = ACTIONS(749),
    [sym_inf] = ACTIONS(749),
    [sym_nan] = ACTIONS(749),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(747),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [99] = {
    [sym_function_definition] = STATE(808),
    [sym_lambda_function] = STATE(808),
    [sym_if] = STATE(808),
    [sym_while] = STATE(808),
    [sym_repeat] = STATE(808),
    [sym_for] = STATE(808),
    [sym_switch] = STATE(808),
    [sym_call] = STATE(808),
    [sym__assignment] = STATE(808),
    [sym_left_assignment] = STATE(808),
    [sym_left_assignment2] = STATE(808),
    [sym_equals_assignment] = STATE(808),
    [sym_super_assignment] = STATE(808),
    [sym_super_right_assignment] = STATE(808),
    [sym_right_assignment] = STATE(808),
    [sym_brace_list] = STATE(808),
    [sym_paren_list] = STATE(808),
    [sym_subset] = STATE(808),
    [sym_subset2] = STATE(808),
    [sym_dollar] = STATE(808),
    [sym_slot] = STATE(808),
    [sym_namespace_get] = STATE(808),
    [sym_namespace_get_internal] = STATE(808),
    [sym_pipe] = STATE(808),
    [sym_unary] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_na] = STATE(808),
    [sym__expression] = STATE(808),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(808),
    [sym_string] = STATE(808),
    [anon_sym_SEMI] = ACTIONS(751),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(771),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(771),
    [sym_next] = ACTIONS(771),
    [sym_true] = ACTIONS(771),
    [sym_false] = ACTIONS(771),
    [sym_null] = ACTIONS(771),
    [sym_inf] = ACTIONS(771),
    [sym_nan] = ACTIONS(771),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(751),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [100] = {
    [sym_function_definition] = STATE(822),
    [sym_lambda_function] = STATE(822),
    [sym_if] = STATE(822),
    [sym_while] = STATE(822),
    [sym_repeat] = STATE(822),
    [sym_for] = STATE(822),
    [sym_switch] = STATE(822),
    [sym_call] = STATE(822),
    [sym__assignment] = STATE(822),
    [sym_left_assignment] = STATE(822),
    [sym_left_assignment2] = STATE(822),
    [sym_equals_assignment] = STATE(822),
    [sym_super_assignment] = STATE(822),
    [sym_super_right_assignment] = STATE(822),
    [sym_right_assignment] = STATE(822),
    [sym_brace_list] = STATE(822),
    [sym_paren_list] = STATE(822),
    [sym_subset] = STATE(822),
    [sym_subset2] = STATE(822),
    [sym_dollar] = STATE(822),
    [sym_slot] = STATE(822),
    [sym_namespace_get] = STATE(822),
    [sym_namespace_get_internal] = STATE(822),
    [sym_pipe] = STATE(822),
    [sym_unary] = STATE(822),
    [sym_binary] = STATE(822),
    [sym_na] = STATE(822),
    [sym__expression] = STATE(822),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(822),
    [sym_string] = STATE(822),
    [anon_sym_SEMI] = ACTIONS(791),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(793),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(793),
    [sym_next] = ACTIONS(793),
    [sym_true] = ACTIONS(793),
    [sym_false] = ACTIONS(793),
    [sym_null] = ACTIONS(793),
    [sym_inf] = ACTIONS(793),
    [sym_nan] = ACTIONS(793),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(791),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [101] = {
    [sym_function_definition] = STATE(926),
    [sym_lambda_function] = STATE(926),
    [sym_if] = STATE(926),
    [sym_while] = STATE(926),
    [sym_repeat] = STATE(926),
    [sym_for] = STATE(926),
    [sym_switch] = STATE(926),
    [sym_call] = STATE(604),
    [sym__assignment] = STATE(926),
    [sym_left_assignment] = STATE(926),
    [sym_left_assignment2] = STATE(926),
    [sym_equals_assignment] = STATE(926),
    [sym_super_assignment] = STATE(926),
    [sym_super_right_assignment] = STATE(926),
    [sym_right_assignment] = STATE(926),
    [sym_brace_list] = STATE(926),
    [sym_paren_list] = STATE(926),
    [sym_subset] = STATE(926),
    [sym_subset2] = STATE(926),
    [sym_dollar] = STATE(926),
    [sym_slot] = STATE(926),
    [sym_namespace_get] = STATE(926),
    [sym_namespace_get_internal] = STATE(926),
    [sym_pipe] = STATE(926),
    [sym_unary] = STATE(926),
    [sym_binary] = STATE(926),
    [sym_na] = STATE(926),
    [sym__expression] = STATE(926),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(926),
    [sym_string] = STATE(926),
    [anon_sym_SEMI] = ACTIONS(795),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(797),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(797),
    [sym_next] = ACTIONS(797),
    [sym_true] = ACTIONS(797),
    [sym_false] = ACTIONS(797),
    [sym_null] = ACTIONS(797),
    [sym_inf] = ACTIONS(797),
    [sym_nan] = ACTIONS(797),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(795),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [102] = {
    [sym_function_definition] = STATE(899),
    [sym_lambda_function] = STATE(899),
    [sym_if] = STATE(899),
    [sym_while] = STATE(899),
    [sym_repeat] = STATE(899),
    [sym_for] = STATE(899),
    [sym_switch] = STATE(899),
    [sym_call] = STATE(899),
    [sym__assignment] = STATE(899),
    [sym_left_assignment] = STATE(899),
    [sym_left_assignment2] = STATE(899),
    [sym_equals_assignment] = STATE(899),
    [sym_super_assignment] = STATE(899),
    [sym_super_right_assignment] = STATE(899),
    [sym_right_assignment] = STATE(899),
    [sym_brace_list] = STATE(899),
    [sym_paren_list] = STATE(899),
    [sym_subset] = STATE(899),
    [sym_subset2] = STATE(899),
    [sym_dollar] = STATE(899),
    [sym_slot] = STATE(899),
    [sym_namespace_get] = STATE(899),
    [sym_namespace_get_internal] = STATE(899),
    [sym_pipe] = STATE(899),
    [sym_unary] = STATE(899),
    [sym_binary] = STATE(899),
    [sym_na] = STATE(899),
    [sym__expression] = STATE(899),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(899),
    [sym_string] = STATE(899),
    [anon_sym_SEMI] = ACTIONS(799),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(801),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(801),
    [sym_next] = ACTIONS(801),
    [sym_true] = ACTIONS(801),
    [sym_false] = ACTIONS(801),
    [sym_null] = ACTIONS(801),
    [sym_inf] = ACTIONS(801),
    [sym_nan] = ACTIONS(801),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(799),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [103] = {
    [sym_function_definition] = STATE(902),
    [sym_lambda_function] = STATE(902),
    [sym_if] = STATE(902),
    [sym_while] = STATE(902),
    [sym_repeat] = STATE(902),
    [sym_for] = STATE(902),
    [sym_switch] = STATE(902),
    [sym_call] = STATE(902),
    [sym__assignment] = STATE(902),
    [sym_left_assignment] = STATE(902),
    [sym_left_assignment2] = STATE(902),
    [sym_equals_assignment] = STATE(902),
    [sym_super_assignment] = STATE(902),
    [sym_super_right_assignment] = STATE(902),
    [sym_right_assignment] = STATE(902),
    [sym_brace_list] = STATE(902),
    [sym_paren_list] = STATE(902),
    [sym_subset] = STATE(902),
    [sym_subset2] = STATE(902),
    [sym_dollar] = STATE(902),
    [sym_slot] = STATE(902),
    [sym_namespace_get] = STATE(902),
    [sym_namespace_get_internal] = STATE(902),
    [sym_pipe] = STATE(902),
    [sym_unary] = STATE(902),
    [sym_binary] = STATE(902),
    [sym_na] = STATE(902),
    [sym__expression] = STATE(902),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(902),
    [sym_string] = STATE(902),
    [anon_sym_SEMI] = ACTIONS(803),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(805),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(805),
    [sym_next] = ACTIONS(805),
    [sym_true] = ACTIONS(805),
    [sym_false] = ACTIONS(805),
    [sym_null] = ACTIONS(805),
    [sym_inf] = ACTIONS(805),
    [sym_nan] = ACTIONS(805),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(803),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [104] = {
    [sym_function_definition] = STATE(914),
    [sym_lambda_function] = STATE(914),
    [sym_if] = STATE(914),
    [sym_while] = STATE(914),
    [sym_repeat] = STATE(914),
    [sym_for] = STATE(914),
    [sym_switch] = STATE(914),
    [sym_call] = STATE(914),
    [sym__assignment] = STATE(914),
    [sym_left_assignment] = STATE(914),
    [sym_left_assignment2] = STATE(914),
    [sym_equals_assignment] = STATE(914),
    [sym_super_assignment] = STATE(914),
    [sym_super_right_assignment] = STATE(914),
    [sym_right_assignment] = STATE(914),
    [sym_brace_list] = STATE(914),
    [sym_paren_list] = STATE(914),
    [sym_subset] = STATE(914),
    [sym_subset2] = STATE(914),
    [sym_dollar] = STATE(914),
    [sym_slot] = STATE(914),
    [sym_namespace_get] = STATE(914),
    [sym_namespace_get_internal] = STATE(914),
    [sym_pipe] = STATE(914),
    [sym_unary] = STATE(914),
    [sym_binary] = STATE(914),
    [sym_na] = STATE(914),
    [sym__expression] = STATE(914),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(914),
    [sym_string] = STATE(914),
    [anon_sym_SEMI] = ACTIONS(807),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(809),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(809),
    [sym_next] = ACTIONS(809),
    [sym_true] = ACTIONS(809),
    [sym_false] = ACTIONS(809),
    [sym_null] = ACTIONS(809),
    [sym_inf] = ACTIONS(809),
    [sym_nan] = ACTIONS(809),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(807),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [105] = {
    [sym_function_definition] = STATE(882),
    [sym_lambda_function] = STATE(882),
    [sym_if] = STATE(882),
    [sym_while] = STATE(882),
    [sym_repeat] = STATE(882),
    [sym_for] = STATE(882),
    [sym_switch] = STATE(882),
    [sym_call] = STATE(882),
    [sym__assignment] = STATE(882),
    [sym_left_assignment] = STATE(882),
    [sym_left_assignment2] = STATE(882),
    [sym_equals_assignment] = STATE(882),
    [sym_super_assignment] = STATE(882),
    [sym_super_right_assignment] = STATE(882),
    [sym_right_assignment] = STATE(882),
    [sym_brace_list] = STATE(882),
    [sym_paren_list] = STATE(882),
    [sym_subset] = STATE(882),
    [sym_subset2] = STATE(882),
    [sym_dollar] = STATE(882),
    [sym_slot] = STATE(882),
    [sym_namespace_get] = STATE(882),
    [sym_namespace_get_internal] = STATE(882),
    [sym_pipe] = STATE(882),
    [sym_unary] = STATE(882),
    [sym_binary] = STATE(882),
    [sym_na] = STATE(882),
    [sym__expression] = STATE(882),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(882),
    [sym_string] = STATE(882),
    [anon_sym_SEMI] = ACTIONS(811),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(813),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(813),
    [sym_next] = ACTIONS(813),
    [sym_true] = ACTIONS(813),
    [sym_false] = ACTIONS(813),
    [sym_null] = ACTIONS(813),
    [sym_inf] = ACTIONS(813),
    [sym_nan] = ACTIONS(813),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(811),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [106] = {
    [sym_function_definition] = STATE(907),
    [sym_lambda_function] = STATE(907),
    [sym_if] = STATE(907),
    [sym_while] = STATE(907),
    [sym_repeat] = STATE(907),
    [sym_for] = STATE(907),
    [sym_switch] = STATE(907),
    [sym_call] = STATE(907),
    [sym__assignment] = STATE(907),
    [sym_left_assignment] = STATE(907),
    [sym_left_assignment2] = STATE(907),
    [sym_equals_assignment] = STATE(907),
    [sym_super_assignment] = STATE(907),
    [sym_super_right_assignment] = STATE(907),
    [sym_right_assignment] = STATE(907),
    [sym_brace_list] = STATE(907),
    [sym_paren_list] = STATE(907),
    [sym_subset] = STATE(907),
    [sym_subset2] = STATE(907),
    [sym_dollar] = STATE(907),
    [sym_slot] = STATE(907),
    [sym_namespace_get] = STATE(907),
    [sym_namespace_get_internal] = STATE(907),
    [sym_pipe] = STATE(907),
    [sym_unary] = STATE(907),
    [sym_binary] = STATE(907),
    [sym_na] = STATE(907),
    [sym__expression] = STATE(907),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(907),
    [sym_string] = STATE(907),
    [anon_sym_SEMI] = ACTIONS(815),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(817),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(817),
    [sym_next] = ACTIONS(817),
    [sym_true] = ACTIONS(817),
    [sym_false] = ACTIONS(817),
    [sym_null] = ACTIONS(817),
    [sym_inf] = ACTIONS(817),
    [sym_nan] = ACTIONS(817),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(815),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [107] = {
    [sym_function_definition] = STATE(906),
    [sym_lambda_function] = STATE(906),
    [sym_if] = STATE(906),
    [sym_while] = STATE(906),
    [sym_repeat] = STATE(906),
    [sym_for] = STATE(906),
    [sym_switch] = STATE(906),
    [sym_call] = STATE(906),
    [sym__assignment] = STATE(906),
    [sym_left_assignment] = STATE(906),
    [sym_left_assignment2] = STATE(906),
    [sym_equals_assignment] = STATE(906),
    [sym_super_assignment] = STATE(906),
    [sym_super_right_assignment] = STATE(906),
    [sym_right_assignment] = STATE(906),
    [sym_brace_list] = STATE(906),
    [sym_paren_list] = STATE(906),
    [sym_subset] = STATE(906),
    [sym_subset2] = STATE(906),
    [sym_dollar] = STATE(906),
    [sym_slot] = STATE(906),
    [sym_namespace_get] = STATE(906),
    [sym_namespace_get_internal] = STATE(906),
    [sym_pipe] = STATE(906),
    [sym_unary] = STATE(906),
    [sym_binary] = STATE(906),
    [sym_na] = STATE(906),
    [sym__expression] = STATE(906),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(906),
    [sym_string] = STATE(906),
    [anon_sym_SEMI] = ACTIONS(819),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(821),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(821),
    [sym_next] = ACTIONS(821),
    [sym_true] = ACTIONS(821),
    [sym_false] = ACTIONS(821),
    [sym_null] = ACTIONS(821),
    [sym_inf] = ACTIONS(821),
    [sym_nan] = ACTIONS(821),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(819),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [108] = {
    [sym_function_definition] = STATE(890),
    [sym_lambda_function] = STATE(890),
    [sym_if] = STATE(890),
    [sym_while] = STATE(890),
    [sym_repeat] = STATE(890),
    [sym_for] = STATE(890),
    [sym_switch] = STATE(890),
    [sym_call] = STATE(890),
    [sym__assignment] = STATE(890),
    [sym_left_assignment] = STATE(890),
    [sym_left_assignment2] = STATE(890),
    [sym_equals_assignment] = STATE(890),
    [sym_super_assignment] = STATE(890),
    [sym_super_right_assignment] = STATE(890),
    [sym_right_assignment] = STATE(890),
    [sym_brace_list] = STATE(890),
    [sym_paren_list] = STATE(890),
    [sym_subset] = STATE(890),
    [sym_subset2] = STATE(890),
    [sym_dollar] = STATE(890),
    [sym_slot] = STATE(890),
    [sym_namespace_get] = STATE(890),
    [sym_namespace_get_internal] = STATE(890),
    [sym_pipe] = STATE(890),
    [sym_unary] = STATE(890),
    [sym_binary] = STATE(890),
    [sym_na] = STATE(890),
    [sym__expression] = STATE(890),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(890),
    [sym_string] = STATE(890),
    [anon_sym_SEMI] = ACTIONS(823),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(825),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(825),
    [sym_next] = ACTIONS(825),
    [sym_true] = ACTIONS(825),
    [sym_false] = ACTIONS(825),
    [sym_null] = ACTIONS(825),
    [sym_inf] = ACTIONS(825),
    [sym_nan] = ACTIONS(825),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(823),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [109] = {
    [sym_function_definition] = STATE(895),
    [sym_lambda_function] = STATE(895),
    [sym_if] = STATE(895),
    [sym_while] = STATE(895),
    [sym_repeat] = STATE(895),
    [sym_for] = STATE(895),
    [sym_switch] = STATE(895),
    [sym_call] = STATE(895),
    [sym__assignment] = STATE(895),
    [sym_left_assignment] = STATE(895),
    [sym_left_assignment2] = STATE(895),
    [sym_equals_assignment] = STATE(895),
    [sym_super_assignment] = STATE(895),
    [sym_super_right_assignment] = STATE(895),
    [sym_right_assignment] = STATE(895),
    [sym_brace_list] = STATE(895),
    [sym_paren_list] = STATE(895),
    [sym_subset] = STATE(895),
    [sym_subset2] = STATE(895),
    [sym_dollar] = STATE(895),
    [sym_slot] = STATE(895),
    [sym_namespace_get] = STATE(895),
    [sym_namespace_get_internal] = STATE(895),
    [sym_pipe] = STATE(895),
    [sym_unary] = STATE(895),
    [sym_binary] = STATE(895),
    [sym_na] = STATE(895),
    [sym__expression] = STATE(895),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(895),
    [sym_string] = STATE(895),
    [anon_sym_SEMI] = ACTIONS(827),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(829),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(829),
    [sym_next] = ACTIONS(829),
    [sym_true] = ACTIONS(829),
    [sym_false] = ACTIONS(829),
    [sym_null] = ACTIONS(829),
    [sym_inf] = ACTIONS(829),
    [sym_nan] = ACTIONS(829),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(827),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [110] = {
    [sym_function_definition] = STATE(234),
    [sym_lambda_function] = STATE(234),
    [sym_if] = STATE(234),
    [sym_while] = STATE(234),
    [sym_repeat] = STATE(234),
    [sym_for] = STATE(234),
    [sym_switch] = STATE(234),
    [sym_call] = STATE(234),
    [sym__assignment] = STATE(234),
    [sym_left_assignment] = STATE(234),
    [sym_left_assignment2] = STATE(234),
    [sym_equals_assignment] = STATE(234),
    [sym_super_assignment] = STATE(234),
    [sym_super_right_assignment] = STATE(234),
    [sym_right_assignment] = STATE(234),
    [sym_brace_list] = STATE(234),
    [sym_paren_list] = STATE(234),
    [sym_subset] = STATE(234),
    [sym_subset2] = STATE(234),
    [sym_dollar] = STATE(234),
    [sym_slot] = STATE(234),
    [sym_namespace_get] = STATE(234),
    [sym_namespace_get_internal] = STATE(234),
    [sym_pipe] = STATE(234),
    [sym_unary] = STATE(234),
    [sym_binary] = STATE(234),
    [sym_na] = STATE(234),
    [sym__expression] = STATE(234),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(234),
    [sym_string] = STATE(234),
    [anon_sym_SEMI] = ACTIONS(831),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(851),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(851),
    [sym_next] = ACTIONS(851),
    [sym_true] = ACTIONS(851),
    [sym_false] = ACTIONS(851),
    [sym_null] = ACTIONS(851),
    [sym_inf] = ACTIONS(851),
    [sym_nan] = ACTIONS(851),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(831),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [111] = {
    [sym_function_definition] = STATE(820),
    [sym_lambda_function] = STATE(820),
    [sym_if] = STATE(820),
    [sym_while] = STATE(820),
    [sym_repeat] = STATE(820),
    [sym_for] = STATE(820),
    [sym_switch] = STATE(820),
    [sym_call] = STATE(820),
    [sym__assignment] = STATE(820),
    [sym_left_assignment] = STATE(820),
    [sym_left_assignment2] = STATE(820),
    [sym_equals_assignment] = STATE(820),
    [sym_super_assignment] = STATE(820),
    [sym_super_right_assignment] = STATE(820),
    [sym_right_assignment] = STATE(820),
    [sym_brace_list] = STATE(820),
    [sym_paren_list] = STATE(820),
    [sym_subset] = STATE(820),
    [sym_subset2] = STATE(820),
    [sym_dollar] = STATE(820),
    [sym_slot] = STATE(820),
    [sym_namespace_get] = STATE(820),
    [sym_namespace_get_internal] = STATE(820),
    [sym_pipe] = STATE(820),
    [sym_unary] = STATE(820),
    [sym_binary] = STATE(820),
    [sym_na] = STATE(820),
    [sym__expression] = STATE(820),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(820),
    [sym_string] = STATE(820),
    [anon_sym_SEMI] = ACTIONS(871),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(873),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(873),
    [sym_next] = ACTIONS(873),
    [sym_true] = ACTIONS(873),
    [sym_false] = ACTIONS(873),
    [sym_null] = ACTIONS(873),
    [sym_inf] = ACTIONS(873),
    [sym_nan] = ACTIONS(873),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(871),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [112] = {
    [sym_function_definition] = STATE(838),
    [sym_lambda_function] = STATE(838),
    [sym_if] = STATE(838),
    [sym_while] = STATE(838),
    [sym_repeat] = STATE(838),
    [sym_for] = STATE(838),
    [sym_switch] = STATE(838),
    [sym_call] = STATE(838),
    [sym__assignment] = STATE(838),
    [sym_left_assignment] = STATE(838),
    [sym_left_assignment2] = STATE(838),
    [sym_equals_assignment] = STATE(838),
    [sym_super_assignment] = STATE(838),
    [sym_super_right_assignment] = STATE(838),
    [sym_right_assignment] = STATE(838),
    [sym_brace_list] = STATE(838),
    [sym_paren_list] = STATE(838),
    [sym_subset] = STATE(838),
    [sym_subset2] = STATE(838),
    [sym_dollar] = STATE(838),
    [sym_slot] = STATE(838),
    [sym_namespace_get] = STATE(838),
    [sym_namespace_get_internal] = STATE(838),
    [sym_pipe] = STATE(838),
    [sym_unary] = STATE(838),
    [sym_binary] = STATE(838),
    [sym_na] = STATE(838),
    [sym__expression] = STATE(838),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(838),
    [sym_string] = STATE(838),
    [anon_sym_SEMI] = ACTIONS(875),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(877),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(877),
    [sym_next] = ACTIONS(877),
    [sym_true] = ACTIONS(877),
    [sym_false] = ACTIONS(877),
    [sym_null] = ACTIONS(877),
    [sym_inf] = ACTIONS(877),
    [sym_nan] = ACTIONS(877),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(875),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [113] = {
    [sym_function_definition] = STATE(839),
    [sym_lambda_function] = STATE(839),
    [sym_if] = STATE(839),
    [sym_while] = STATE(839),
    [sym_repeat] = STATE(839),
    [sym_for] = STATE(839),
    [sym_switch] = STATE(839),
    [sym_call] = STATE(839),
    [sym__assignment] = STATE(839),
    [sym_left_assignment] = STATE(839),
    [sym_left_assignment2] = STATE(839),
    [sym_equals_assignment] = STATE(839),
    [sym_super_assignment] = STATE(839),
    [sym_super_right_assignment] = STATE(839),
    [sym_right_assignment] = STATE(839),
    [sym_brace_list] = STATE(839),
    [sym_paren_list] = STATE(839),
    [sym_subset] = STATE(839),
    [sym_subset2] = STATE(839),
    [sym_dollar] = STATE(839),
    [sym_slot] = STATE(839),
    [sym_namespace_get] = STATE(839),
    [sym_namespace_get_internal] = STATE(839),
    [sym_pipe] = STATE(839),
    [sym_unary] = STATE(839),
    [sym_binary] = STATE(839),
    [sym_na] = STATE(839),
    [sym__expression] = STATE(839),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(839),
    [sym_string] = STATE(839),
    [anon_sym_SEMI] = ACTIONS(879),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(881),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(881),
    [sym_next] = ACTIONS(881),
    [sym_true] = ACTIONS(881),
    [sym_false] = ACTIONS(881),
    [sym_null] = ACTIONS(881),
    [sym_inf] = ACTIONS(881),
    [sym_nan] = ACTIONS(881),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(879),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [114] = {
    [sym_function_definition] = STATE(827),
    [sym_lambda_function] = STATE(827),
    [sym_if] = STATE(827),
    [sym_while] = STATE(827),
    [sym_repeat] = STATE(827),
    [sym_for] = STATE(827),
    [sym_switch] = STATE(827),
    [sym_call] = STATE(827),
    [sym__assignment] = STATE(827),
    [sym_left_assignment] = STATE(827),
    [sym_left_assignment2] = STATE(827),
    [sym_equals_assignment] = STATE(827),
    [sym_super_assignment] = STATE(827),
    [sym_super_right_assignment] = STATE(827),
    [sym_right_assignment] = STATE(827),
    [sym_brace_list] = STATE(827),
    [sym_paren_list] = STATE(827),
    [sym_subset] = STATE(827),
    [sym_subset2] = STATE(827),
    [sym_dollar] = STATE(827),
    [sym_slot] = STATE(827),
    [sym_namespace_get] = STATE(827),
    [sym_namespace_get_internal] = STATE(827),
    [sym_pipe] = STATE(827),
    [sym_unary] = STATE(827),
    [sym_binary] = STATE(827),
    [sym_na] = STATE(827),
    [sym__expression] = STATE(827),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(827),
    [sym_string] = STATE(827),
    [anon_sym_SEMI] = ACTIONS(883),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(885),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(885),
    [sym_next] = ACTIONS(885),
    [sym_true] = ACTIONS(885),
    [sym_false] = ACTIONS(885),
    [sym_null] = ACTIONS(885),
    [sym_inf] = ACTIONS(885),
    [sym_nan] = ACTIONS(885),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(883),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [115] = {
    [sym_function_definition] = STATE(828),
    [sym_lambda_function] = STATE(828),
    [sym_if] = STATE(828),
    [sym_while] = STATE(828),
    [sym_repeat] = STATE(828),
    [sym_for] = STATE(828),
    [sym_switch] = STATE(828),
    [sym_call] = STATE(828),
    [sym__assignment] = STATE(828),
    [sym_left_assignment] = STATE(828),
    [sym_left_assignment2] = STATE(828),
    [sym_equals_assignment] = STATE(828),
    [sym_super_assignment] = STATE(828),
    [sym_super_right_assignment] = STATE(828),
    [sym_right_assignment] = STATE(828),
    [sym_brace_list] = STATE(828),
    [sym_paren_list] = STATE(828),
    [sym_subset] = STATE(828),
    [sym_subset2] = STATE(828),
    [sym_dollar] = STATE(828),
    [sym_slot] = STATE(828),
    [sym_namespace_get] = STATE(828),
    [sym_namespace_get_internal] = STATE(828),
    [sym_pipe] = STATE(828),
    [sym_unary] = STATE(828),
    [sym_binary] = STATE(828),
    [sym_na] = STATE(828),
    [sym__expression] = STATE(828),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(828),
    [sym_string] = STATE(828),
    [anon_sym_SEMI] = ACTIONS(887),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(889),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(889),
    [sym_next] = ACTIONS(889),
    [sym_true] = ACTIONS(889),
    [sym_false] = ACTIONS(889),
    [sym_null] = ACTIONS(889),
    [sym_inf] = ACTIONS(889),
    [sym_nan] = ACTIONS(889),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(887),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [116] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(891),
    [anon_sym_function] = ACTIONS(893),
    [anon_sym_BSLASH] = ACTIONS(891),
    [anon_sym_if] = ACTIONS(893),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(891),
    [anon_sym_else] = ACTIONS(897),
    [anon_sym_while] = ACTIONS(893),
    [anon_sym_repeat] = ACTIONS(893),
    [anon_sym_for] = ACTIONS(893),
    [anon_sym_switch] = ACTIONS(893),
    [anon_sym_COMMA] = ACTIONS(891),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(891),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(891),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(893),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(893),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(893),
    [sym_next] = ACTIONS(893),
    [sym_true] = ACTIONS(893),
    [sym_false] = ACTIONS(893),
    [sym_null] = ACTIONS(893),
    [sym_inf] = ACTIONS(893),
    [sym_nan] = ACTIONS(893),
    [anon_sym_NA] = ACTIONS(893),
    [anon_sym_NA_character_] = ACTIONS(893),
    [anon_sym_NA_complex_] = ACTIONS(893),
    [anon_sym_NA_integer_] = ACTIONS(893),
    [anon_sym_NA_real_] = ACTIONS(893),
    [aux_sym_identifier_token1] = ACTIONS(893),
    [anon_sym_BQUOTE] = ACTIONS(891),
    [sym_integer] = ACTIONS(891),
    [sym_float] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(891),
    [anon_sym_SQUOTE] = ACTIONS(891),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [117] = {
    [sym_function_definition] = STATE(409),
    [sym_lambda_function] = STATE(409),
    [sym_if] = STATE(409),
    [sym_while] = STATE(409),
    [sym_repeat] = STATE(409),
    [sym_for] = STATE(409),
    [sym_switch] = STATE(409),
    [sym_call] = STATE(409),
    [sym__assignment] = STATE(409),
    [sym_left_assignment] = STATE(409),
    [sym_left_assignment2] = STATE(409),
    [sym_equals_assignment] = STATE(409),
    [sym_super_assignment] = STATE(409),
    [sym_super_right_assignment] = STATE(409),
    [sym_right_assignment] = STATE(409),
    [sym_brace_list] = STATE(409),
    [sym_paren_list] = STATE(409),
    [sym_subset] = STATE(409),
    [sym_subset2] = STATE(409),
    [sym_dollar] = STATE(409),
    [sym_slot] = STATE(409),
    [sym_namespace_get] = STATE(409),
    [sym_namespace_get_internal] = STATE(409),
    [sym_pipe] = STATE(409),
    [sym_unary] = STATE(409),
    [sym_binary] = STATE(409),
    [sym_na] = STATE(409),
    [sym__expression] = STATE(409),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(409),
    [sym_string] = STATE(409),
    [anon_sym_SEMI] = ACTIONS(947),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(949),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(949),
    [sym_next] = ACTIONS(949),
    [sym_true] = ACTIONS(949),
    [sym_false] = ACTIONS(949),
    [sym_null] = ACTIONS(949),
    [sym_inf] = ACTIONS(949),
    [sym_nan] = ACTIONS(949),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(947),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [118] = {
    [sym_function_definition] = STATE(913),
    [sym_lambda_function] = STATE(913),
    [sym_if] = STATE(913),
    [sym_while] = STATE(913),
    [sym_repeat] = STATE(913),
    [sym_for] = STATE(913),
    [sym_switch] = STATE(913),
    [sym_call] = STATE(913),
    [sym__assignment] = STATE(913),
    [sym_left_assignment] = STATE(913),
    [sym_left_assignment2] = STATE(913),
    [sym_equals_assignment] = STATE(913),
    [sym_super_assignment] = STATE(913),
    [sym_super_right_assignment] = STATE(913),
    [sym_right_assignment] = STATE(913),
    [sym_brace_list] = STATE(913),
    [sym_paren_list] = STATE(913),
    [sym_subset] = STATE(913),
    [sym_subset2] = STATE(913),
    [sym_dollar] = STATE(913),
    [sym_slot] = STATE(913),
    [sym_namespace_get] = STATE(913),
    [sym_namespace_get_internal] = STATE(913),
    [sym_pipe] = STATE(913),
    [sym_unary] = STATE(913),
    [sym_binary] = STATE(913),
    [sym_na] = STATE(913),
    [sym__expression] = STATE(913),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(913),
    [sym_string] = STATE(913),
    [anon_sym_SEMI] = ACTIONS(951),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(953),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(953),
    [sym_next] = ACTIONS(953),
    [sym_true] = ACTIONS(953),
    [sym_false] = ACTIONS(953),
    [sym_null] = ACTIONS(953),
    [sym_inf] = ACTIONS(953),
    [sym_nan] = ACTIONS(953),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(951),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [119] = {
    [sym_function_definition] = STATE(904),
    [sym_lambda_function] = STATE(904),
    [sym_if] = STATE(904),
    [sym_while] = STATE(904),
    [sym_repeat] = STATE(904),
    [sym_for] = STATE(904),
    [sym_switch] = STATE(904),
    [sym_call] = STATE(904),
    [sym__assignment] = STATE(904),
    [sym_left_assignment] = STATE(904),
    [sym_left_assignment2] = STATE(904),
    [sym_equals_assignment] = STATE(904),
    [sym_super_assignment] = STATE(904),
    [sym_super_right_assignment] = STATE(904),
    [sym_right_assignment] = STATE(904),
    [sym_brace_list] = STATE(904),
    [sym_paren_list] = STATE(904),
    [sym_subset] = STATE(904),
    [sym_subset2] = STATE(904),
    [sym_dollar] = STATE(904),
    [sym_slot] = STATE(904),
    [sym_namespace_get] = STATE(904),
    [sym_namespace_get_internal] = STATE(904),
    [sym_pipe] = STATE(904),
    [sym_unary] = STATE(904),
    [sym_binary] = STATE(904),
    [sym_na] = STATE(904),
    [sym__expression] = STATE(904),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(904),
    [sym_string] = STATE(904),
    [anon_sym_SEMI] = ACTIONS(955),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(957),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(957),
    [sym_next] = ACTIONS(957),
    [sym_true] = ACTIONS(957),
    [sym_false] = ACTIONS(957),
    [sym_null] = ACTIONS(957),
    [sym_inf] = ACTIONS(957),
    [sym_nan] = ACTIONS(957),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(955),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [120] = {
    [sym_function_definition] = STATE(411),
    [sym_lambda_function] = STATE(411),
    [sym_if] = STATE(411),
    [sym_while] = STATE(411),
    [sym_repeat] = STATE(411),
    [sym_for] = STATE(411),
    [sym_switch] = STATE(411),
    [sym_call] = STATE(411),
    [sym__assignment] = STATE(411),
    [sym_left_assignment] = STATE(411),
    [sym_left_assignment2] = STATE(411),
    [sym_equals_assignment] = STATE(411),
    [sym_super_assignment] = STATE(411),
    [sym_super_right_assignment] = STATE(411),
    [sym_right_assignment] = STATE(411),
    [sym_brace_list] = STATE(411),
    [sym_paren_list] = STATE(411),
    [sym_subset] = STATE(411),
    [sym_subset2] = STATE(411),
    [sym_dollar] = STATE(411),
    [sym_slot] = STATE(411),
    [sym_namespace_get] = STATE(411),
    [sym_namespace_get_internal] = STATE(411),
    [sym_pipe] = STATE(411),
    [sym_unary] = STATE(411),
    [sym_binary] = STATE(411),
    [sym_na] = STATE(411),
    [sym__expression] = STATE(411),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(411),
    [sym_string] = STATE(411),
    [anon_sym_SEMI] = ACTIONS(959),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(961),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(961),
    [sym_next] = ACTIONS(961),
    [sym_true] = ACTIONS(961),
    [sym_false] = ACTIONS(961),
    [sym_null] = ACTIONS(961),
    [sym_inf] = ACTIONS(961),
    [sym_nan] = ACTIONS(961),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(959),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [121] = {
    [sym_function_definition] = STATE(916),
    [sym_lambda_function] = STATE(916),
    [sym_if] = STATE(916),
    [sym_while] = STATE(916),
    [sym_repeat] = STATE(916),
    [sym_for] = STATE(916),
    [sym_switch] = STATE(916),
    [sym_call] = STATE(916),
    [sym__assignment] = STATE(916),
    [sym_left_assignment] = STATE(916),
    [sym_left_assignment2] = STATE(916),
    [sym_equals_assignment] = STATE(916),
    [sym_super_assignment] = STATE(916),
    [sym_super_right_assignment] = STATE(916),
    [sym_right_assignment] = STATE(916),
    [sym_brace_list] = STATE(916),
    [sym_paren_list] = STATE(916),
    [sym_subset] = STATE(916),
    [sym_subset2] = STATE(916),
    [sym_dollar] = STATE(916),
    [sym_slot] = STATE(916),
    [sym_namespace_get] = STATE(916),
    [sym_namespace_get_internal] = STATE(916),
    [sym_pipe] = STATE(916),
    [sym_unary] = STATE(916),
    [sym_binary] = STATE(916),
    [sym_na] = STATE(916),
    [sym__expression] = STATE(916),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(916),
    [sym_string] = STATE(916),
    [anon_sym_SEMI] = ACTIONS(963),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(965),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(965),
    [sym_next] = ACTIONS(965),
    [sym_true] = ACTIONS(965),
    [sym_false] = ACTIONS(965),
    [sym_null] = ACTIONS(965),
    [sym_inf] = ACTIONS(965),
    [sym_nan] = ACTIONS(965),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(963),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [122] = {
    [sym_function_definition] = STATE(903),
    [sym_lambda_function] = STATE(903),
    [sym_if] = STATE(903),
    [sym_while] = STATE(903),
    [sym_repeat] = STATE(903),
    [sym_for] = STATE(903),
    [sym_switch] = STATE(903),
    [sym_call] = STATE(903),
    [sym__assignment] = STATE(903),
    [sym_left_assignment] = STATE(903),
    [sym_left_assignment2] = STATE(903),
    [sym_equals_assignment] = STATE(903),
    [sym_super_assignment] = STATE(903),
    [sym_super_right_assignment] = STATE(903),
    [sym_right_assignment] = STATE(903),
    [sym_brace_list] = STATE(903),
    [sym_paren_list] = STATE(903),
    [sym_subset] = STATE(903),
    [sym_subset2] = STATE(903),
    [sym_dollar] = STATE(903),
    [sym_slot] = STATE(903),
    [sym_namespace_get] = STATE(903),
    [sym_namespace_get_internal] = STATE(903),
    [sym_pipe] = STATE(903),
    [sym_unary] = STATE(903),
    [sym_binary] = STATE(903),
    [sym_na] = STATE(903),
    [sym__expression] = STATE(903),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(903),
    [sym_string] = STATE(903),
    [anon_sym_SEMI] = ACTIONS(967),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(969),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(969),
    [sym_next] = ACTIONS(969),
    [sym_true] = ACTIONS(969),
    [sym_false] = ACTIONS(969),
    [sym_null] = ACTIONS(969),
    [sym_inf] = ACTIONS(969),
    [sym_nan] = ACTIONS(969),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(967),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [123] = {
    [sym_function_definition] = STATE(910),
    [sym_lambda_function] = STATE(910),
    [sym_if] = STATE(910),
    [sym_while] = STATE(910),
    [sym_repeat] = STATE(910),
    [sym_for] = STATE(910),
    [sym_switch] = STATE(910),
    [sym_call] = STATE(910),
    [sym__assignment] = STATE(910),
    [sym_left_assignment] = STATE(910),
    [sym_left_assignment2] = STATE(910),
    [sym_equals_assignment] = STATE(910),
    [sym_super_assignment] = STATE(910),
    [sym_super_right_assignment] = STATE(910),
    [sym_right_assignment] = STATE(910),
    [sym_brace_list] = STATE(910),
    [sym_paren_list] = STATE(910),
    [sym_subset] = STATE(910),
    [sym_subset2] = STATE(910),
    [sym_dollar] = STATE(910),
    [sym_slot] = STATE(910),
    [sym_namespace_get] = STATE(910),
    [sym_namespace_get_internal] = STATE(910),
    [sym_pipe] = STATE(910),
    [sym_unary] = STATE(910),
    [sym_binary] = STATE(910),
    [sym_na] = STATE(910),
    [sym__expression] = STATE(910),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(910),
    [sym_string] = STATE(910),
    [anon_sym_SEMI] = ACTIONS(971),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(973),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(973),
    [sym_next] = ACTIONS(973),
    [sym_true] = ACTIONS(973),
    [sym_false] = ACTIONS(973),
    [sym_null] = ACTIONS(973),
    [sym_inf] = ACTIONS(973),
    [sym_nan] = ACTIONS(973),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(971),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [124] = {
    [sym_function_definition] = STATE(887),
    [sym_lambda_function] = STATE(887),
    [sym_if] = STATE(887),
    [sym_while] = STATE(887),
    [sym_repeat] = STATE(887),
    [sym_for] = STATE(887),
    [sym_switch] = STATE(887),
    [sym_call] = STATE(887),
    [sym__assignment] = STATE(887),
    [sym_left_assignment] = STATE(887),
    [sym_left_assignment2] = STATE(887),
    [sym_equals_assignment] = STATE(887),
    [sym_super_assignment] = STATE(887),
    [sym_super_right_assignment] = STATE(887),
    [sym_right_assignment] = STATE(887),
    [sym_brace_list] = STATE(887),
    [sym_paren_list] = STATE(887),
    [sym_subset] = STATE(887),
    [sym_subset2] = STATE(887),
    [sym_dollar] = STATE(887),
    [sym_slot] = STATE(887),
    [sym_namespace_get] = STATE(887),
    [sym_namespace_get_internal] = STATE(887),
    [sym_pipe] = STATE(887),
    [sym_unary] = STATE(887),
    [sym_binary] = STATE(887),
    [sym_na] = STATE(887),
    [sym__expression] = STATE(887),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(887),
    [sym_string] = STATE(887),
    [anon_sym_SEMI] = ACTIONS(975),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(977),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(977),
    [sym_next] = ACTIONS(977),
    [sym_true] = ACTIONS(977),
    [sym_false] = ACTIONS(977),
    [sym_null] = ACTIONS(977),
    [sym_inf] = ACTIONS(977),
    [sym_nan] = ACTIONS(977),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(975),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [125] = {
    [sym_function_definition] = STATE(886),
    [sym_lambda_function] = STATE(886),
    [sym_if] = STATE(886),
    [sym_while] = STATE(886),
    [sym_repeat] = STATE(886),
    [sym_for] = STATE(886),
    [sym_switch] = STATE(886),
    [sym_call] = STATE(886),
    [sym__assignment] = STATE(886),
    [sym_left_assignment] = STATE(886),
    [sym_left_assignment2] = STATE(886),
    [sym_equals_assignment] = STATE(886),
    [sym_super_assignment] = STATE(886),
    [sym_super_right_assignment] = STATE(886),
    [sym_right_assignment] = STATE(886),
    [sym_brace_list] = STATE(886),
    [sym_paren_list] = STATE(886),
    [sym_subset] = STATE(886),
    [sym_subset2] = STATE(886),
    [sym_dollar] = STATE(886),
    [sym_slot] = STATE(886),
    [sym_namespace_get] = STATE(886),
    [sym_namespace_get_internal] = STATE(886),
    [sym_pipe] = STATE(886),
    [sym_unary] = STATE(886),
    [sym_binary] = STATE(886),
    [sym_na] = STATE(886),
    [sym__expression] = STATE(886),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(886),
    [sym_string] = STATE(886),
    [anon_sym_SEMI] = ACTIONS(979),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(981),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(981),
    [sym_next] = ACTIONS(981),
    [sym_true] = ACTIONS(981),
    [sym_false] = ACTIONS(981),
    [sym_null] = ACTIONS(981),
    [sym_inf] = ACTIONS(981),
    [sym_nan] = ACTIONS(981),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(979),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [126] = {
    [sym_function_definition] = STATE(837),
    [sym_lambda_function] = STATE(837),
    [sym_if] = STATE(837),
    [sym_while] = STATE(837),
    [sym_repeat] = STATE(837),
    [sym_for] = STATE(837),
    [sym_switch] = STATE(837),
    [sym_call] = STATE(837),
    [sym__assignment] = STATE(837),
    [sym_left_assignment] = STATE(837),
    [sym_left_assignment2] = STATE(837),
    [sym_equals_assignment] = STATE(837),
    [sym_super_assignment] = STATE(837),
    [sym_super_right_assignment] = STATE(837),
    [sym_right_assignment] = STATE(837),
    [sym_brace_list] = STATE(837),
    [sym_paren_list] = STATE(837),
    [sym_subset] = STATE(837),
    [sym_subset2] = STATE(837),
    [sym_dollar] = STATE(837),
    [sym_slot] = STATE(837),
    [sym_namespace_get] = STATE(837),
    [sym_namespace_get_internal] = STATE(837),
    [sym_pipe] = STATE(837),
    [sym_unary] = STATE(837),
    [sym_binary] = STATE(837),
    [sym_na] = STATE(837),
    [sym__expression] = STATE(837),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(837),
    [sym_string] = STATE(837),
    [anon_sym_SEMI] = ACTIONS(983),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(985),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(985),
    [sym_next] = ACTIONS(985),
    [sym_true] = ACTIONS(985),
    [sym_false] = ACTIONS(985),
    [sym_null] = ACTIONS(985),
    [sym_inf] = ACTIONS(985),
    [sym_nan] = ACTIONS(985),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(983),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [127] = {
    [sym_function_definition] = STATE(508),
    [sym_lambda_function] = STATE(508),
    [sym_if] = STATE(508),
    [sym_while] = STATE(508),
    [sym_repeat] = STATE(508),
    [sym_for] = STATE(508),
    [sym_switch] = STATE(508),
    [sym_call] = STATE(508),
    [sym__assignment] = STATE(508),
    [sym_left_assignment] = STATE(508),
    [sym_left_assignment2] = STATE(508),
    [sym_equals_assignment] = STATE(508),
    [sym_super_assignment] = STATE(508),
    [sym_super_right_assignment] = STATE(508),
    [sym_right_assignment] = STATE(508),
    [sym_brace_list] = STATE(508),
    [sym_paren_list] = STATE(508),
    [sym_subset] = STATE(508),
    [sym_subset2] = STATE(508),
    [sym_dollar] = STATE(508),
    [sym_slot] = STATE(508),
    [sym_namespace_get] = STATE(508),
    [sym_namespace_get_internal] = STATE(508),
    [sym_pipe] = STATE(508),
    [sym_unary] = STATE(508),
    [sym_binary] = STATE(508),
    [sym_na] = STATE(508),
    [sym__expression] = STATE(508),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(508),
    [sym_string] = STATE(508),
    [anon_sym_SEMI] = ACTIONS(987),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1007),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1007),
    [sym_next] = ACTIONS(1007),
    [sym_true] = ACTIONS(1007),
    [sym_false] = ACTIONS(1007),
    [sym_null] = ACTIONS(1007),
    [sym_inf] = ACTIONS(1007),
    [sym_nan] = ACTIONS(1007),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(987),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [128] = {
    [sym_function_definition] = STATE(647),
    [sym_lambda_function] = STATE(647),
    [sym_if] = STATE(647),
    [sym_while] = STATE(647),
    [sym_repeat] = STATE(647),
    [sym_for] = STATE(647),
    [sym_switch] = STATE(647),
    [sym_call] = STATE(647),
    [sym__assignment] = STATE(647),
    [sym_left_assignment] = STATE(647),
    [sym_left_assignment2] = STATE(647),
    [sym_equals_assignment] = STATE(647),
    [sym_super_assignment] = STATE(647),
    [sym_super_right_assignment] = STATE(647),
    [sym_right_assignment] = STATE(647),
    [sym_brace_list] = STATE(647),
    [sym_paren_list] = STATE(647),
    [sym_subset] = STATE(647),
    [sym_subset2] = STATE(647),
    [sym_dollar] = STATE(647),
    [sym_slot] = STATE(647),
    [sym_namespace_get] = STATE(647),
    [sym_namespace_get_internal] = STATE(647),
    [sym_pipe] = STATE(647),
    [sym_unary] = STATE(647),
    [sym_binary] = STATE(647),
    [sym_na] = STATE(647),
    [sym__expression] = STATE(647),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(647),
    [sym_string] = STATE(647),
    [anon_sym_SEMI] = ACTIONS(1027),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1029),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1029),
    [sym_next] = ACTIONS(1029),
    [sym_true] = ACTIONS(1029),
    [sym_false] = ACTIONS(1029),
    [sym_null] = ACTIONS(1029),
    [sym_inf] = ACTIONS(1029),
    [sym_nan] = ACTIONS(1029),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1027),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [129] = {
    [sym_function_definition] = STATE(905),
    [sym_lambda_function] = STATE(905),
    [sym_if] = STATE(905),
    [sym_while] = STATE(905),
    [sym_repeat] = STATE(905),
    [sym_for] = STATE(905),
    [sym_switch] = STATE(905),
    [sym_call] = STATE(905),
    [sym__assignment] = STATE(905),
    [sym_left_assignment] = STATE(905),
    [sym_left_assignment2] = STATE(905),
    [sym_equals_assignment] = STATE(905),
    [sym_super_assignment] = STATE(905),
    [sym_super_right_assignment] = STATE(905),
    [sym_right_assignment] = STATE(905),
    [sym_brace_list] = STATE(905),
    [sym_paren_list] = STATE(905),
    [sym_subset] = STATE(905),
    [sym_subset2] = STATE(905),
    [sym_dollar] = STATE(905),
    [sym_slot] = STATE(905),
    [sym_namespace_get] = STATE(905),
    [sym_namespace_get_internal] = STATE(905),
    [sym_pipe] = STATE(905),
    [sym_unary] = STATE(905),
    [sym_binary] = STATE(905),
    [sym_na] = STATE(905),
    [sym__expression] = STATE(905),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(905),
    [sym_string] = STATE(905),
    [anon_sym_SEMI] = ACTIONS(1031),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1033),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1033),
    [sym_next] = ACTIONS(1033),
    [sym_true] = ACTIONS(1033),
    [sym_false] = ACTIONS(1033),
    [sym_null] = ACTIONS(1033),
    [sym_inf] = ACTIONS(1033),
    [sym_nan] = ACTIONS(1033),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1031),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [130] = {
    [sym_function_definition] = STATE(884),
    [sym_lambda_function] = STATE(884),
    [sym_if] = STATE(884),
    [sym_while] = STATE(884),
    [sym_repeat] = STATE(884),
    [sym_for] = STATE(884),
    [sym_switch] = STATE(884),
    [sym_call] = STATE(884),
    [sym__assignment] = STATE(884),
    [sym_left_assignment] = STATE(884),
    [sym_left_assignment2] = STATE(884),
    [sym_equals_assignment] = STATE(884),
    [sym_super_assignment] = STATE(884),
    [sym_super_right_assignment] = STATE(884),
    [sym_right_assignment] = STATE(884),
    [sym_brace_list] = STATE(884),
    [sym_paren_list] = STATE(884),
    [sym_subset] = STATE(884),
    [sym_subset2] = STATE(884),
    [sym_dollar] = STATE(884),
    [sym_slot] = STATE(884),
    [sym_namespace_get] = STATE(884),
    [sym_namespace_get_internal] = STATE(884),
    [sym_pipe] = STATE(884),
    [sym_unary] = STATE(884),
    [sym_binary] = STATE(884),
    [sym_na] = STATE(884),
    [sym__expression] = STATE(884),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(884),
    [sym_string] = STATE(884),
    [anon_sym_SEMI] = ACTIONS(1035),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1037),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1037),
    [sym_next] = ACTIONS(1037),
    [sym_true] = ACTIONS(1037),
    [sym_false] = ACTIONS(1037),
    [sym_null] = ACTIONS(1037),
    [sym_inf] = ACTIONS(1037),
    [sym_nan] = ACTIONS(1037),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1035),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [131] = {
    [sym_function_definition] = STATE(883),
    [sym_lambda_function] = STATE(883),
    [sym_if] = STATE(883),
    [sym_while] = STATE(883),
    [sym_repeat] = STATE(883),
    [sym_for] = STATE(883),
    [sym_switch] = STATE(883),
    [sym_call] = STATE(883),
    [sym__assignment] = STATE(883),
    [sym_left_assignment] = STATE(883),
    [sym_left_assignment2] = STATE(883),
    [sym_equals_assignment] = STATE(883),
    [sym_super_assignment] = STATE(883),
    [sym_super_right_assignment] = STATE(883),
    [sym_right_assignment] = STATE(883),
    [sym_brace_list] = STATE(883),
    [sym_paren_list] = STATE(883),
    [sym_subset] = STATE(883),
    [sym_subset2] = STATE(883),
    [sym_dollar] = STATE(883),
    [sym_slot] = STATE(883),
    [sym_namespace_get] = STATE(883),
    [sym_namespace_get_internal] = STATE(883),
    [sym_pipe] = STATE(883),
    [sym_unary] = STATE(883),
    [sym_binary] = STATE(883),
    [sym_na] = STATE(883),
    [sym__expression] = STATE(883),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(883),
    [sym_string] = STATE(883),
    [anon_sym_SEMI] = ACTIONS(1039),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1041),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1041),
    [sym_next] = ACTIONS(1041),
    [sym_true] = ACTIONS(1041),
    [sym_false] = ACTIONS(1041),
    [sym_null] = ACTIONS(1041),
    [sym_inf] = ACTIONS(1041),
    [sym_nan] = ACTIONS(1041),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1039),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [132] = {
    [sym_function_definition] = STATE(911),
    [sym_lambda_function] = STATE(911),
    [sym_if] = STATE(911),
    [sym_while] = STATE(911),
    [sym_repeat] = STATE(911),
    [sym_for] = STATE(911),
    [sym_switch] = STATE(911),
    [sym_call] = STATE(911),
    [sym__assignment] = STATE(911),
    [sym_left_assignment] = STATE(911),
    [sym_left_assignment2] = STATE(911),
    [sym_equals_assignment] = STATE(911),
    [sym_super_assignment] = STATE(911),
    [sym_super_right_assignment] = STATE(911),
    [sym_right_assignment] = STATE(911),
    [sym_brace_list] = STATE(911),
    [sym_paren_list] = STATE(911),
    [sym_subset] = STATE(911),
    [sym_subset2] = STATE(911),
    [sym_dollar] = STATE(911),
    [sym_slot] = STATE(911),
    [sym_namespace_get] = STATE(911),
    [sym_namespace_get_internal] = STATE(911),
    [sym_pipe] = STATE(911),
    [sym_unary] = STATE(911),
    [sym_binary] = STATE(911),
    [sym_na] = STATE(911),
    [sym__expression] = STATE(911),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(911),
    [sym_string] = STATE(911),
    [anon_sym_SEMI] = ACTIONS(1043),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1045),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1045),
    [sym_next] = ACTIONS(1045),
    [sym_true] = ACTIONS(1045),
    [sym_false] = ACTIONS(1045),
    [sym_null] = ACTIONS(1045),
    [sym_inf] = ACTIONS(1045),
    [sym_nan] = ACTIONS(1045),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1043),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [133] = {
    [sym_function_definition] = STATE(892),
    [sym_lambda_function] = STATE(892),
    [sym_if] = STATE(892),
    [sym_while] = STATE(892),
    [sym_repeat] = STATE(892),
    [sym_for] = STATE(892),
    [sym_switch] = STATE(892),
    [sym_call] = STATE(892),
    [sym__assignment] = STATE(892),
    [sym_left_assignment] = STATE(892),
    [sym_left_assignment2] = STATE(892),
    [sym_equals_assignment] = STATE(892),
    [sym_super_assignment] = STATE(892),
    [sym_super_right_assignment] = STATE(892),
    [sym_right_assignment] = STATE(892),
    [sym_brace_list] = STATE(892),
    [sym_paren_list] = STATE(892),
    [sym_subset] = STATE(892),
    [sym_subset2] = STATE(892),
    [sym_dollar] = STATE(892),
    [sym_slot] = STATE(892),
    [sym_namespace_get] = STATE(892),
    [sym_namespace_get_internal] = STATE(892),
    [sym_pipe] = STATE(892),
    [sym_unary] = STATE(892),
    [sym_binary] = STATE(892),
    [sym_na] = STATE(892),
    [sym__expression] = STATE(892),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(892),
    [sym_string] = STATE(892),
    [anon_sym_SEMI] = ACTIONS(1047),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1049),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1049),
    [sym_next] = ACTIONS(1049),
    [sym_true] = ACTIONS(1049),
    [sym_false] = ACTIONS(1049),
    [sym_null] = ACTIONS(1049),
    [sym_inf] = ACTIONS(1049),
    [sym_nan] = ACTIONS(1049),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1047),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [134] = {
    [sym_function_definition] = STATE(880),
    [sym_lambda_function] = STATE(880),
    [sym_if] = STATE(880),
    [sym_while] = STATE(880),
    [sym_repeat] = STATE(880),
    [sym_for] = STATE(880),
    [sym_switch] = STATE(880),
    [sym_call] = STATE(880),
    [sym__assignment] = STATE(880),
    [sym_left_assignment] = STATE(880),
    [sym_left_assignment2] = STATE(880),
    [sym_equals_assignment] = STATE(880),
    [sym_super_assignment] = STATE(880),
    [sym_super_right_assignment] = STATE(880),
    [sym_right_assignment] = STATE(880),
    [sym_brace_list] = STATE(880),
    [sym_paren_list] = STATE(880),
    [sym_subset] = STATE(880),
    [sym_subset2] = STATE(880),
    [sym_dollar] = STATE(880),
    [sym_slot] = STATE(880),
    [sym_namespace_get] = STATE(880),
    [sym_namespace_get_internal] = STATE(880),
    [sym_pipe] = STATE(880),
    [sym_unary] = STATE(880),
    [sym_binary] = STATE(880),
    [sym_na] = STATE(880),
    [sym__expression] = STATE(880),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(880),
    [sym_string] = STATE(880),
    [anon_sym_SEMI] = ACTIONS(1051),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1053),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1053),
    [sym_next] = ACTIONS(1053),
    [sym_true] = ACTIONS(1053),
    [sym_false] = ACTIONS(1053),
    [sym_null] = ACTIONS(1053),
    [sym_inf] = ACTIONS(1053),
    [sym_nan] = ACTIONS(1053),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1051),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [135] = {
    [sym_function_definition] = STATE(901),
    [sym_lambda_function] = STATE(901),
    [sym_if] = STATE(901),
    [sym_while] = STATE(901),
    [sym_repeat] = STATE(901),
    [sym_for] = STATE(901),
    [sym_switch] = STATE(901),
    [sym_call] = STATE(901),
    [sym__assignment] = STATE(901),
    [sym_left_assignment] = STATE(901),
    [sym_left_assignment2] = STATE(901),
    [sym_equals_assignment] = STATE(901),
    [sym_super_assignment] = STATE(901),
    [sym_super_right_assignment] = STATE(901),
    [sym_right_assignment] = STATE(901),
    [sym_brace_list] = STATE(901),
    [sym_paren_list] = STATE(901),
    [sym_subset] = STATE(901),
    [sym_subset2] = STATE(901),
    [sym_dollar] = STATE(901),
    [sym_slot] = STATE(901),
    [sym_namespace_get] = STATE(901),
    [sym_namespace_get_internal] = STATE(901),
    [sym_pipe] = STATE(901),
    [sym_unary] = STATE(901),
    [sym_binary] = STATE(901),
    [sym_na] = STATE(901),
    [sym__expression] = STATE(901),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(901),
    [sym_string] = STATE(901),
    [anon_sym_SEMI] = ACTIONS(1055),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1057),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1057),
    [sym_next] = ACTIONS(1057),
    [sym_true] = ACTIONS(1057),
    [sym_false] = ACTIONS(1057),
    [sym_null] = ACTIONS(1057),
    [sym_inf] = ACTIONS(1057),
    [sym_nan] = ACTIONS(1057),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1055),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [136] = {
    [sym_function_definition] = STATE(908),
    [sym_lambda_function] = STATE(908),
    [sym_if] = STATE(908),
    [sym_while] = STATE(908),
    [sym_repeat] = STATE(908),
    [sym_for] = STATE(908),
    [sym_switch] = STATE(908),
    [sym_call] = STATE(908),
    [sym__assignment] = STATE(908),
    [sym_left_assignment] = STATE(908),
    [sym_left_assignment2] = STATE(908),
    [sym_equals_assignment] = STATE(908),
    [sym_super_assignment] = STATE(908),
    [sym_super_right_assignment] = STATE(908),
    [sym_right_assignment] = STATE(908),
    [sym_brace_list] = STATE(908),
    [sym_paren_list] = STATE(908),
    [sym_subset] = STATE(908),
    [sym_subset2] = STATE(908),
    [sym_dollar] = STATE(908),
    [sym_slot] = STATE(908),
    [sym_namespace_get] = STATE(908),
    [sym_namespace_get_internal] = STATE(908),
    [sym_pipe] = STATE(908),
    [sym_unary] = STATE(908),
    [sym_binary] = STATE(908),
    [sym_na] = STATE(908),
    [sym__expression] = STATE(908),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(908),
    [sym_string] = STATE(908),
    [anon_sym_SEMI] = ACTIONS(1059),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1061),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1061),
    [sym_next] = ACTIONS(1061),
    [sym_true] = ACTIONS(1061),
    [sym_false] = ACTIONS(1061),
    [sym_null] = ACTIONS(1061),
    [sym_inf] = ACTIONS(1061),
    [sym_nan] = ACTIONS(1061),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1059),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [137] = {
    [sym_function_definition] = STATE(588),
    [sym_lambda_function] = STATE(588),
    [sym_if] = STATE(588),
    [sym_while] = STATE(588),
    [sym_repeat] = STATE(588),
    [sym_for] = STATE(588),
    [sym_switch] = STATE(588),
    [sym_call] = STATE(588),
    [sym__assignment] = STATE(588),
    [sym_left_assignment] = STATE(588),
    [sym_left_assignment2] = STATE(588),
    [sym_equals_assignment] = STATE(588),
    [sym_super_assignment] = STATE(588),
    [sym_super_right_assignment] = STATE(588),
    [sym_right_assignment] = STATE(588),
    [sym_brace_list] = STATE(588),
    [sym_paren_list] = STATE(588),
    [sym_subset] = STATE(588),
    [sym_subset2] = STATE(588),
    [sym_dollar] = STATE(588),
    [sym_slot] = STATE(588),
    [sym_namespace_get] = STATE(588),
    [sym_namespace_get_internal] = STATE(588),
    [sym_pipe] = STATE(588),
    [sym_unary] = STATE(588),
    [sym_binary] = STATE(588),
    [sym_na] = STATE(588),
    [sym__expression] = STATE(588),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(588),
    [sym_string] = STATE(588),
    [anon_sym_SEMI] = ACTIONS(1063),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1065),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1065),
    [sym_next] = ACTIONS(1065),
    [sym_true] = ACTIONS(1065),
    [sym_false] = ACTIONS(1065),
    [sym_null] = ACTIONS(1065),
    [sym_inf] = ACTIONS(1065),
    [sym_nan] = ACTIONS(1065),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1063),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [138] = {
    [sym_function_definition] = STATE(915),
    [sym_lambda_function] = STATE(915),
    [sym_if] = STATE(915),
    [sym_while] = STATE(915),
    [sym_repeat] = STATE(915),
    [sym_for] = STATE(915),
    [sym_switch] = STATE(915),
    [sym_call] = STATE(915),
    [sym__assignment] = STATE(915),
    [sym_left_assignment] = STATE(915),
    [sym_left_assignment2] = STATE(915),
    [sym_equals_assignment] = STATE(915),
    [sym_super_assignment] = STATE(915),
    [sym_super_right_assignment] = STATE(915),
    [sym_right_assignment] = STATE(915),
    [sym_brace_list] = STATE(915),
    [sym_paren_list] = STATE(915),
    [sym_subset] = STATE(915),
    [sym_subset2] = STATE(915),
    [sym_dollar] = STATE(915),
    [sym_slot] = STATE(915),
    [sym_namespace_get] = STATE(915),
    [sym_namespace_get_internal] = STATE(915),
    [sym_pipe] = STATE(915),
    [sym_unary] = STATE(915),
    [sym_binary] = STATE(915),
    [sym_na] = STATE(915),
    [sym__expression] = STATE(915),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(915),
    [sym_string] = STATE(915),
    [anon_sym_SEMI] = ACTIONS(1067),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1069),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1069),
    [sym_next] = ACTIONS(1069),
    [sym_true] = ACTIONS(1069),
    [sym_false] = ACTIONS(1069),
    [sym_null] = ACTIONS(1069),
    [sym_inf] = ACTIONS(1069),
    [sym_nan] = ACTIONS(1069),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1067),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [139] = {
    [sym_function_definition] = STATE(879),
    [sym_lambda_function] = STATE(879),
    [sym_if] = STATE(879),
    [sym_while] = STATE(879),
    [sym_repeat] = STATE(879),
    [sym_for] = STATE(879),
    [sym_switch] = STATE(879),
    [sym_call] = STATE(879),
    [sym__assignment] = STATE(879),
    [sym_left_assignment] = STATE(879),
    [sym_left_assignment2] = STATE(879),
    [sym_equals_assignment] = STATE(879),
    [sym_super_assignment] = STATE(879),
    [sym_super_right_assignment] = STATE(879),
    [sym_right_assignment] = STATE(879),
    [sym_brace_list] = STATE(879),
    [sym_paren_list] = STATE(879),
    [sym_subset] = STATE(879),
    [sym_subset2] = STATE(879),
    [sym_dollar] = STATE(879),
    [sym_slot] = STATE(879),
    [sym_namespace_get] = STATE(879),
    [sym_namespace_get_internal] = STATE(879),
    [sym_pipe] = STATE(879),
    [sym_unary] = STATE(879),
    [sym_binary] = STATE(879),
    [sym_na] = STATE(879),
    [sym__expression] = STATE(879),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(879),
    [sym_string] = STATE(879),
    [anon_sym_SEMI] = ACTIONS(1071),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1073),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1073),
    [sym_next] = ACTIONS(1073),
    [sym_true] = ACTIONS(1073),
    [sym_false] = ACTIONS(1073),
    [sym_null] = ACTIONS(1073),
    [sym_inf] = ACTIONS(1073),
    [sym_nan] = ACTIONS(1073),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1071),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [140] = {
    [sym_function_definition] = STATE(909),
    [sym_lambda_function] = STATE(909),
    [sym_if] = STATE(909),
    [sym_while] = STATE(909),
    [sym_repeat] = STATE(909),
    [sym_for] = STATE(909),
    [sym_switch] = STATE(909),
    [sym_call] = STATE(909),
    [sym__assignment] = STATE(909),
    [sym_left_assignment] = STATE(909),
    [sym_left_assignment2] = STATE(909),
    [sym_equals_assignment] = STATE(909),
    [sym_super_assignment] = STATE(909),
    [sym_super_right_assignment] = STATE(909),
    [sym_right_assignment] = STATE(909),
    [sym_brace_list] = STATE(909),
    [sym_paren_list] = STATE(909),
    [sym_subset] = STATE(909),
    [sym_subset2] = STATE(909),
    [sym_dollar] = STATE(909),
    [sym_slot] = STATE(909),
    [sym_namespace_get] = STATE(909),
    [sym_namespace_get_internal] = STATE(909),
    [sym_pipe] = STATE(909),
    [sym_unary] = STATE(909),
    [sym_binary] = STATE(909),
    [sym_na] = STATE(909),
    [sym__expression] = STATE(909),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(909),
    [sym_string] = STATE(909),
    [anon_sym_SEMI] = ACTIONS(1075),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1077),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1077),
    [sym_next] = ACTIONS(1077),
    [sym_true] = ACTIONS(1077),
    [sym_false] = ACTIONS(1077),
    [sym_null] = ACTIONS(1077),
    [sym_inf] = ACTIONS(1077),
    [sym_nan] = ACTIONS(1077),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1075),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [141] = {
    [sym_function_definition] = STATE(917),
    [sym_lambda_function] = STATE(917),
    [sym_if] = STATE(917),
    [sym_while] = STATE(917),
    [sym_repeat] = STATE(917),
    [sym_for] = STATE(917),
    [sym_switch] = STATE(917),
    [sym_call] = STATE(917),
    [sym__assignment] = STATE(917),
    [sym_left_assignment] = STATE(917),
    [sym_left_assignment2] = STATE(917),
    [sym_equals_assignment] = STATE(917),
    [sym_super_assignment] = STATE(917),
    [sym_super_right_assignment] = STATE(917),
    [sym_right_assignment] = STATE(917),
    [sym_brace_list] = STATE(917),
    [sym_paren_list] = STATE(917),
    [sym_subset] = STATE(917),
    [sym_subset2] = STATE(917),
    [sym_dollar] = STATE(917),
    [sym_slot] = STATE(917),
    [sym_namespace_get] = STATE(917),
    [sym_namespace_get_internal] = STATE(917),
    [sym_pipe] = STATE(917),
    [sym_unary] = STATE(917),
    [sym_binary] = STATE(917),
    [sym_na] = STATE(917),
    [sym__expression] = STATE(917),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(917),
    [sym_string] = STATE(917),
    [anon_sym_SEMI] = ACTIONS(1079),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1081),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1081),
    [sym_next] = ACTIONS(1081),
    [sym_true] = ACTIONS(1081),
    [sym_false] = ACTIONS(1081),
    [sym_null] = ACTIONS(1081),
    [sym_inf] = ACTIONS(1081),
    [sym_nan] = ACTIONS(1081),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1079),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [142] = {
    [sym_function_definition] = STATE(412),
    [sym_lambda_function] = STATE(412),
    [sym_if] = STATE(412),
    [sym_while] = STATE(412),
    [sym_repeat] = STATE(412),
    [sym_for] = STATE(412),
    [sym_switch] = STATE(412),
    [sym_call] = STATE(412),
    [sym__assignment] = STATE(412),
    [sym_left_assignment] = STATE(412),
    [sym_left_assignment2] = STATE(412),
    [sym_equals_assignment] = STATE(412),
    [sym_super_assignment] = STATE(412),
    [sym_super_right_assignment] = STATE(412),
    [sym_right_assignment] = STATE(412),
    [sym_brace_list] = STATE(412),
    [sym_paren_list] = STATE(412),
    [sym_subset] = STATE(412),
    [sym_subset2] = STATE(412),
    [sym_dollar] = STATE(412),
    [sym_slot] = STATE(412),
    [sym_namespace_get] = STATE(412),
    [sym_namespace_get_internal] = STATE(412),
    [sym_pipe] = STATE(412),
    [sym_unary] = STATE(412),
    [sym_binary] = STATE(412),
    [sym_na] = STATE(412),
    [sym__expression] = STATE(412),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(412),
    [sym_string] = STATE(412),
    [anon_sym_SEMI] = ACTIONS(1083),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1085),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1085),
    [sym_next] = ACTIONS(1085),
    [sym_true] = ACTIONS(1085),
    [sym_false] = ACTIONS(1085),
    [sym_null] = ACTIONS(1085),
    [sym_inf] = ACTIONS(1085),
    [sym_nan] = ACTIONS(1085),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1083),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [143] = {
    [sym_function_definition] = STATE(519),
    [sym_lambda_function] = STATE(519),
    [sym_if] = STATE(519),
    [sym_while] = STATE(519),
    [sym_repeat] = STATE(519),
    [sym_for] = STATE(519),
    [sym_switch] = STATE(519),
    [sym_call] = STATE(519),
    [sym__assignment] = STATE(519),
    [sym_left_assignment] = STATE(519),
    [sym_left_assignment2] = STATE(519),
    [sym_equals_assignment] = STATE(519),
    [sym_super_assignment] = STATE(519),
    [sym_super_right_assignment] = STATE(519),
    [sym_right_assignment] = STATE(519),
    [sym_brace_list] = STATE(519),
    [sym_paren_list] = STATE(519),
    [sym_subset] = STATE(519),
    [sym_subset2] = STATE(519),
    [sym_dollar] = STATE(519),
    [sym_slot] = STATE(519),
    [sym_namespace_get] = STATE(519),
    [sym_namespace_get_internal] = STATE(519),
    [sym_pipe] = STATE(519),
    [sym_unary] = STATE(519),
    [sym_binary] = STATE(519),
    [sym_na] = STATE(519),
    [sym__expression] = STATE(519),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(519),
    [sym_string] = STATE(519),
    [anon_sym_SEMI] = ACTIONS(1087),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1107),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1107),
    [sym_next] = ACTIONS(1107),
    [sym_true] = ACTIONS(1107),
    [sym_false] = ACTIONS(1107),
    [sym_null] = ACTIONS(1107),
    [sym_inf] = ACTIONS(1107),
    [sym_nan] = ACTIONS(1107),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1087),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [144] = {
    [sym_function_definition] = STATE(891),
    [sym_lambda_function] = STATE(891),
    [sym_if] = STATE(891),
    [sym_while] = STATE(891),
    [sym_repeat] = STATE(891),
    [sym_for] = STATE(891),
    [sym_switch] = STATE(891),
    [sym_call] = STATE(891),
    [sym__assignment] = STATE(891),
    [sym_left_assignment] = STATE(891),
    [sym_left_assignment2] = STATE(891),
    [sym_equals_assignment] = STATE(891),
    [sym_super_assignment] = STATE(891),
    [sym_super_right_assignment] = STATE(891),
    [sym_right_assignment] = STATE(891),
    [sym_brace_list] = STATE(891),
    [sym_paren_list] = STATE(891),
    [sym_subset] = STATE(891),
    [sym_subset2] = STATE(891),
    [sym_dollar] = STATE(891),
    [sym_slot] = STATE(891),
    [sym_namespace_get] = STATE(891),
    [sym_namespace_get_internal] = STATE(891),
    [sym_pipe] = STATE(891),
    [sym_unary] = STATE(891),
    [sym_binary] = STATE(891),
    [sym_na] = STATE(891),
    [sym__expression] = STATE(891),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(891),
    [sym_string] = STATE(891),
    [anon_sym_SEMI] = ACTIONS(1127),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1129),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1129),
    [sym_next] = ACTIONS(1129),
    [sym_true] = ACTIONS(1129),
    [sym_false] = ACTIONS(1129),
    [sym_null] = ACTIONS(1129),
    [sym_inf] = ACTIONS(1129),
    [sym_nan] = ACTIONS(1129),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1127),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [145] = {
    [sym_function_definition] = STATE(885),
    [sym_lambda_function] = STATE(885),
    [sym_if] = STATE(885),
    [sym_while] = STATE(885),
    [sym_repeat] = STATE(885),
    [sym_for] = STATE(885),
    [sym_switch] = STATE(885),
    [sym_call] = STATE(885),
    [sym__assignment] = STATE(885),
    [sym_left_assignment] = STATE(885),
    [sym_left_assignment2] = STATE(885),
    [sym_equals_assignment] = STATE(885),
    [sym_super_assignment] = STATE(885),
    [sym_super_right_assignment] = STATE(885),
    [sym_right_assignment] = STATE(885),
    [sym_brace_list] = STATE(885),
    [sym_paren_list] = STATE(885),
    [sym_subset] = STATE(885),
    [sym_subset2] = STATE(885),
    [sym_dollar] = STATE(885),
    [sym_slot] = STATE(885),
    [sym_namespace_get] = STATE(885),
    [sym_namespace_get_internal] = STATE(885),
    [sym_pipe] = STATE(885),
    [sym_unary] = STATE(885),
    [sym_binary] = STATE(885),
    [sym_na] = STATE(885),
    [sym__expression] = STATE(885),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(885),
    [sym_string] = STATE(885),
    [anon_sym_SEMI] = ACTIONS(1131),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1133),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1133),
    [sym_next] = ACTIONS(1133),
    [sym_true] = ACTIONS(1133),
    [sym_false] = ACTIONS(1133),
    [sym_null] = ACTIONS(1133),
    [sym_inf] = ACTIONS(1133),
    [sym_nan] = ACTIONS(1133),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1131),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [146] = {
    [sym_function_definition] = STATE(818),
    [sym_lambda_function] = STATE(818),
    [sym_if] = STATE(818),
    [sym_while] = STATE(818),
    [sym_repeat] = STATE(818),
    [sym_for] = STATE(818),
    [sym_switch] = STATE(818),
    [sym_call] = STATE(818),
    [sym__assignment] = STATE(818),
    [sym_left_assignment] = STATE(818),
    [sym_left_assignment2] = STATE(818),
    [sym_equals_assignment] = STATE(818),
    [sym_super_assignment] = STATE(818),
    [sym_super_right_assignment] = STATE(818),
    [sym_right_assignment] = STATE(818),
    [sym_brace_list] = STATE(818),
    [sym_paren_list] = STATE(818),
    [sym_subset] = STATE(818),
    [sym_subset2] = STATE(818),
    [sym_dollar] = STATE(818),
    [sym_slot] = STATE(818),
    [sym_namespace_get] = STATE(818),
    [sym_namespace_get_internal] = STATE(818),
    [sym_pipe] = STATE(818),
    [sym_unary] = STATE(818),
    [sym_binary] = STATE(818),
    [sym_na] = STATE(818),
    [sym__expression] = STATE(818),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(818),
    [sym_string] = STATE(818),
    [anon_sym_SEMI] = ACTIONS(1135),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1137),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1137),
    [sym_next] = ACTIONS(1137),
    [sym_true] = ACTIONS(1137),
    [sym_false] = ACTIONS(1137),
    [sym_null] = ACTIONS(1137),
    [sym_inf] = ACTIONS(1137),
    [sym_nan] = ACTIONS(1137),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1135),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [147] = {
    [sym_function_definition] = STATE(591),
    [sym_lambda_function] = STATE(591),
    [sym_if] = STATE(591),
    [sym_while] = STATE(591),
    [sym_repeat] = STATE(591),
    [sym_for] = STATE(591),
    [sym_switch] = STATE(591),
    [sym_call] = STATE(591),
    [sym__assignment] = STATE(591),
    [sym_left_assignment] = STATE(591),
    [sym_left_assignment2] = STATE(591),
    [sym_equals_assignment] = STATE(591),
    [sym_super_assignment] = STATE(591),
    [sym_super_right_assignment] = STATE(591),
    [sym_right_assignment] = STATE(591),
    [sym_brace_list] = STATE(591),
    [sym_paren_list] = STATE(591),
    [sym_subset] = STATE(591),
    [sym_subset2] = STATE(591),
    [sym_dollar] = STATE(591),
    [sym_slot] = STATE(591),
    [sym_namespace_get] = STATE(591),
    [sym_namespace_get_internal] = STATE(591),
    [sym_pipe] = STATE(591),
    [sym_unary] = STATE(591),
    [sym_binary] = STATE(591),
    [sym_na] = STATE(591),
    [sym__expression] = STATE(591),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(591),
    [sym_string] = STATE(591),
    [anon_sym_SEMI] = ACTIONS(1139),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1141),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1141),
    [sym_next] = ACTIONS(1141),
    [sym_true] = ACTIONS(1141),
    [sym_false] = ACTIONS(1141),
    [sym_null] = ACTIONS(1141),
    [sym_inf] = ACTIONS(1141),
    [sym_nan] = ACTIONS(1141),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1139),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [148] = {
    [sym_function_definition] = STATE(889),
    [sym_lambda_function] = STATE(889),
    [sym_if] = STATE(889),
    [sym_while] = STATE(889),
    [sym_repeat] = STATE(889),
    [sym_for] = STATE(889),
    [sym_switch] = STATE(889),
    [sym_call] = STATE(889),
    [sym__assignment] = STATE(889),
    [sym_left_assignment] = STATE(889),
    [sym_left_assignment2] = STATE(889),
    [sym_equals_assignment] = STATE(889),
    [sym_super_assignment] = STATE(889),
    [sym_super_right_assignment] = STATE(889),
    [sym_right_assignment] = STATE(889),
    [sym_brace_list] = STATE(889),
    [sym_paren_list] = STATE(889),
    [sym_subset] = STATE(889),
    [sym_subset2] = STATE(889),
    [sym_dollar] = STATE(889),
    [sym_slot] = STATE(889),
    [sym_namespace_get] = STATE(889),
    [sym_namespace_get_internal] = STATE(889),
    [sym_pipe] = STATE(889),
    [sym_unary] = STATE(889),
    [sym_binary] = STATE(889),
    [sym_na] = STATE(889),
    [sym__expression] = STATE(889),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(889),
    [sym_string] = STATE(889),
    [anon_sym_SEMI] = ACTIONS(1143),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1145),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1145),
    [sym_next] = ACTIONS(1145),
    [sym_true] = ACTIONS(1145),
    [sym_false] = ACTIONS(1145),
    [sym_null] = ACTIONS(1145),
    [sym_inf] = ACTIONS(1145),
    [sym_nan] = ACTIONS(1145),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1143),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [149] = {
    [sym_function_definition] = STATE(643),
    [sym_lambda_function] = STATE(643),
    [sym_if] = STATE(643),
    [sym_while] = STATE(643),
    [sym_repeat] = STATE(643),
    [sym_for] = STATE(643),
    [sym_switch] = STATE(643),
    [sym_call] = STATE(643),
    [sym__assignment] = STATE(643),
    [sym_left_assignment] = STATE(643),
    [sym_left_assignment2] = STATE(643),
    [sym_equals_assignment] = STATE(643),
    [sym_super_assignment] = STATE(643),
    [sym_super_right_assignment] = STATE(643),
    [sym_right_assignment] = STATE(643),
    [sym_brace_list] = STATE(643),
    [sym_paren_list] = STATE(643),
    [sym_subset] = STATE(643),
    [sym_subset2] = STATE(643),
    [sym_dollar] = STATE(643),
    [sym_slot] = STATE(643),
    [sym_namespace_get] = STATE(643),
    [sym_namespace_get_internal] = STATE(643),
    [sym_pipe] = STATE(643),
    [sym_unary] = STATE(643),
    [sym_binary] = STATE(643),
    [sym_na] = STATE(643),
    [sym__expression] = STATE(643),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(643),
    [sym_string] = STATE(643),
    [anon_sym_SEMI] = ACTIONS(1147),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1149),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1149),
    [sym_next] = ACTIONS(1149),
    [sym_true] = ACTIONS(1149),
    [sym_false] = ACTIONS(1149),
    [sym_null] = ACTIONS(1149),
    [sym_inf] = ACTIONS(1149),
    [sym_nan] = ACTIONS(1149),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1147),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [150] = {
    [sym_function_definition] = STATE(642),
    [sym_lambda_function] = STATE(642),
    [sym_if] = STATE(642),
    [sym_while] = STATE(642),
    [sym_repeat] = STATE(642),
    [sym_for] = STATE(642),
    [sym_switch] = STATE(642),
    [sym_call] = STATE(642),
    [sym__assignment] = STATE(642),
    [sym_left_assignment] = STATE(642),
    [sym_left_assignment2] = STATE(642),
    [sym_equals_assignment] = STATE(642),
    [sym_super_assignment] = STATE(642),
    [sym_super_right_assignment] = STATE(642),
    [sym_right_assignment] = STATE(642),
    [sym_brace_list] = STATE(642),
    [sym_paren_list] = STATE(642),
    [sym_subset] = STATE(642),
    [sym_subset2] = STATE(642),
    [sym_dollar] = STATE(642),
    [sym_slot] = STATE(642),
    [sym_namespace_get] = STATE(642),
    [sym_namespace_get_internal] = STATE(642),
    [sym_pipe] = STATE(642),
    [sym_unary] = STATE(642),
    [sym_binary] = STATE(642),
    [sym_na] = STATE(642),
    [sym__expression] = STATE(642),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(642),
    [sym_string] = STATE(642),
    [anon_sym_SEMI] = ACTIONS(1151),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1153),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1153),
    [sym_next] = ACTIONS(1153),
    [sym_true] = ACTIONS(1153),
    [sym_false] = ACTIONS(1153),
    [sym_null] = ACTIONS(1153),
    [sym_inf] = ACTIONS(1153),
    [sym_nan] = ACTIONS(1153),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1151),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [151] = {
    [sym_function_definition] = STATE(894),
    [sym_lambda_function] = STATE(894),
    [sym_if] = STATE(894),
    [sym_while] = STATE(894),
    [sym_repeat] = STATE(894),
    [sym_for] = STATE(894),
    [sym_switch] = STATE(894),
    [sym_call] = STATE(894),
    [sym__assignment] = STATE(894),
    [sym_left_assignment] = STATE(894),
    [sym_left_assignment2] = STATE(894),
    [sym_equals_assignment] = STATE(894),
    [sym_super_assignment] = STATE(894),
    [sym_super_right_assignment] = STATE(894),
    [sym_right_assignment] = STATE(894),
    [sym_brace_list] = STATE(894),
    [sym_paren_list] = STATE(894),
    [sym_subset] = STATE(894),
    [sym_subset2] = STATE(894),
    [sym_dollar] = STATE(894),
    [sym_slot] = STATE(894),
    [sym_namespace_get] = STATE(894),
    [sym_namespace_get_internal] = STATE(894),
    [sym_pipe] = STATE(894),
    [sym_unary] = STATE(894),
    [sym_binary] = STATE(894),
    [sym_na] = STATE(894),
    [sym__expression] = STATE(894),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(894),
    [sym_string] = STATE(894),
    [anon_sym_SEMI] = ACTIONS(1155),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1157),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1157),
    [sym_next] = ACTIONS(1157),
    [sym_true] = ACTIONS(1157),
    [sym_false] = ACTIONS(1157),
    [sym_null] = ACTIONS(1157),
    [sym_inf] = ACTIONS(1157),
    [sym_nan] = ACTIONS(1157),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1155),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [152] = {
    [sym_function_definition] = STATE(817),
    [sym_lambda_function] = STATE(817),
    [sym_if] = STATE(817),
    [sym_while] = STATE(817),
    [sym_repeat] = STATE(817),
    [sym_for] = STATE(817),
    [sym_switch] = STATE(817),
    [sym_call] = STATE(817),
    [sym__assignment] = STATE(817),
    [sym_left_assignment] = STATE(817),
    [sym_left_assignment2] = STATE(817),
    [sym_equals_assignment] = STATE(817),
    [sym_super_assignment] = STATE(817),
    [sym_super_right_assignment] = STATE(817),
    [sym_right_assignment] = STATE(817),
    [sym_brace_list] = STATE(817),
    [sym_paren_list] = STATE(817),
    [sym_subset] = STATE(817),
    [sym_subset2] = STATE(817),
    [sym_dollar] = STATE(817),
    [sym_slot] = STATE(817),
    [sym_namespace_get] = STATE(817),
    [sym_namespace_get_internal] = STATE(817),
    [sym_pipe] = STATE(817),
    [sym_unary] = STATE(817),
    [sym_binary] = STATE(817),
    [sym_na] = STATE(817),
    [sym__expression] = STATE(817),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(817),
    [sym_string] = STATE(817),
    [anon_sym_SEMI] = ACTIONS(1159),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1161),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1161),
    [sym_next] = ACTIONS(1161),
    [sym_true] = ACTIONS(1161),
    [sym_false] = ACTIONS(1161),
    [sym_null] = ACTIONS(1161),
    [sym_inf] = ACTIONS(1161),
    [sym_nan] = ACTIONS(1161),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1159),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [153] = {
    [sym_function_definition] = STATE(815),
    [sym_lambda_function] = STATE(815),
    [sym_if] = STATE(815),
    [sym_while] = STATE(815),
    [sym_repeat] = STATE(815),
    [sym_for] = STATE(815),
    [sym_switch] = STATE(815),
    [sym_call] = STATE(815),
    [sym__assignment] = STATE(815),
    [sym_left_assignment] = STATE(815),
    [sym_left_assignment2] = STATE(815),
    [sym_equals_assignment] = STATE(815),
    [sym_super_assignment] = STATE(815),
    [sym_super_right_assignment] = STATE(815),
    [sym_right_assignment] = STATE(815),
    [sym_brace_list] = STATE(815),
    [sym_paren_list] = STATE(815),
    [sym_subset] = STATE(815),
    [sym_subset2] = STATE(815),
    [sym_dollar] = STATE(815),
    [sym_slot] = STATE(815),
    [sym_namespace_get] = STATE(815),
    [sym_namespace_get_internal] = STATE(815),
    [sym_pipe] = STATE(815),
    [sym_unary] = STATE(815),
    [sym_binary] = STATE(815),
    [sym_na] = STATE(815),
    [sym__expression] = STATE(815),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(815),
    [sym_string] = STATE(815),
    [anon_sym_SEMI] = ACTIONS(1163),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1165),
    [sym_next] = ACTIONS(1165),
    [sym_true] = ACTIONS(1165),
    [sym_false] = ACTIONS(1165),
    [sym_null] = ACTIONS(1165),
    [sym_inf] = ACTIONS(1165),
    [sym_nan] = ACTIONS(1165),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1163),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [154] = {
    [sym_function_definition] = STATE(521),
    [sym_lambda_function] = STATE(521),
    [sym_if] = STATE(521),
    [sym_while] = STATE(521),
    [sym_repeat] = STATE(521),
    [sym_for] = STATE(521),
    [sym_switch] = STATE(521),
    [sym_call] = STATE(521),
    [sym__assignment] = STATE(521),
    [sym_left_assignment] = STATE(521),
    [sym_left_assignment2] = STATE(521),
    [sym_equals_assignment] = STATE(521),
    [sym_super_assignment] = STATE(521),
    [sym_super_right_assignment] = STATE(521),
    [sym_right_assignment] = STATE(521),
    [sym_brace_list] = STATE(521),
    [sym_paren_list] = STATE(521),
    [sym_subset] = STATE(521),
    [sym_subset2] = STATE(521),
    [sym_dollar] = STATE(521),
    [sym_slot] = STATE(521),
    [sym_namespace_get] = STATE(521),
    [sym_namespace_get_internal] = STATE(521),
    [sym_pipe] = STATE(521),
    [sym_unary] = STATE(521),
    [sym_binary] = STATE(521),
    [sym_na] = STATE(521),
    [sym__expression] = STATE(521),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(521),
    [sym_string] = STATE(521),
    [anon_sym_SEMI] = ACTIONS(1167),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1169),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1169),
    [sym_next] = ACTIONS(1169),
    [sym_true] = ACTIONS(1169),
    [sym_false] = ACTIONS(1169),
    [sym_null] = ACTIONS(1169),
    [sym_inf] = ACTIONS(1169),
    [sym_nan] = ACTIONS(1169),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1167),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [155] = {
    [sym_function_definition] = STATE(522),
    [sym_lambda_function] = STATE(522),
    [sym_if] = STATE(522),
    [sym_while] = STATE(522),
    [sym_repeat] = STATE(522),
    [sym_for] = STATE(522),
    [sym_switch] = STATE(522),
    [sym_call] = STATE(522),
    [sym__assignment] = STATE(522),
    [sym_left_assignment] = STATE(522),
    [sym_left_assignment2] = STATE(522),
    [sym_equals_assignment] = STATE(522),
    [sym_super_assignment] = STATE(522),
    [sym_super_right_assignment] = STATE(522),
    [sym_right_assignment] = STATE(522),
    [sym_brace_list] = STATE(522),
    [sym_paren_list] = STATE(522),
    [sym_subset] = STATE(522),
    [sym_subset2] = STATE(522),
    [sym_dollar] = STATE(522),
    [sym_slot] = STATE(522),
    [sym_namespace_get] = STATE(522),
    [sym_namespace_get_internal] = STATE(522),
    [sym_pipe] = STATE(522),
    [sym_unary] = STATE(522),
    [sym_binary] = STATE(522),
    [sym_na] = STATE(522),
    [sym__expression] = STATE(522),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(522),
    [sym_string] = STATE(522),
    [anon_sym_SEMI] = ACTIONS(1171),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1173),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1173),
    [sym_next] = ACTIONS(1173),
    [sym_true] = ACTIONS(1173),
    [sym_false] = ACTIONS(1173),
    [sym_null] = ACTIONS(1173),
    [sym_inf] = ACTIONS(1173),
    [sym_nan] = ACTIONS(1173),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1171),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [156] = {
    [sym_function_definition] = STATE(523),
    [sym_lambda_function] = STATE(523),
    [sym_if] = STATE(523),
    [sym_while] = STATE(523),
    [sym_repeat] = STATE(523),
    [sym_for] = STATE(523),
    [sym_switch] = STATE(523),
    [sym_call] = STATE(523),
    [sym__assignment] = STATE(523),
    [sym_left_assignment] = STATE(523),
    [sym_left_assignment2] = STATE(523),
    [sym_equals_assignment] = STATE(523),
    [sym_super_assignment] = STATE(523),
    [sym_super_right_assignment] = STATE(523),
    [sym_right_assignment] = STATE(523),
    [sym_brace_list] = STATE(523),
    [sym_paren_list] = STATE(523),
    [sym_subset] = STATE(523),
    [sym_subset2] = STATE(523),
    [sym_dollar] = STATE(523),
    [sym_slot] = STATE(523),
    [sym_namespace_get] = STATE(523),
    [sym_namespace_get_internal] = STATE(523),
    [sym_pipe] = STATE(523),
    [sym_unary] = STATE(523),
    [sym_binary] = STATE(523),
    [sym_na] = STATE(523),
    [sym__expression] = STATE(523),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(523),
    [sym_string] = STATE(523),
    [anon_sym_SEMI] = ACTIONS(1175),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1177),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1177),
    [sym_next] = ACTIONS(1177),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_inf] = ACTIONS(1177),
    [sym_nan] = ACTIONS(1177),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1175),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [157] = {
    [sym_function_definition] = STATE(533),
    [sym_lambda_function] = STATE(533),
    [sym_if] = STATE(533),
    [sym_while] = STATE(533),
    [sym_repeat] = STATE(533),
    [sym_for] = STATE(533),
    [sym_switch] = STATE(533),
    [sym_call] = STATE(533),
    [sym__assignment] = STATE(533),
    [sym_left_assignment] = STATE(533),
    [sym_left_assignment2] = STATE(533),
    [sym_equals_assignment] = STATE(533),
    [sym_super_assignment] = STATE(533),
    [sym_super_right_assignment] = STATE(533),
    [sym_right_assignment] = STATE(533),
    [sym_brace_list] = STATE(533),
    [sym_paren_list] = STATE(533),
    [sym_subset] = STATE(533),
    [sym_subset2] = STATE(533),
    [sym_dollar] = STATE(533),
    [sym_slot] = STATE(533),
    [sym_namespace_get] = STATE(533),
    [sym_namespace_get_internal] = STATE(533),
    [sym_pipe] = STATE(533),
    [sym_unary] = STATE(533),
    [sym_binary] = STATE(533),
    [sym_na] = STATE(533),
    [sym__expression] = STATE(533),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(533),
    [sym_string] = STATE(533),
    [anon_sym_SEMI] = ACTIONS(1179),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1181),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1181),
    [sym_next] = ACTIONS(1181),
    [sym_true] = ACTIONS(1181),
    [sym_false] = ACTIONS(1181),
    [sym_null] = ACTIONS(1181),
    [sym_inf] = ACTIONS(1181),
    [sym_nan] = ACTIONS(1181),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1179),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [158] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [anon_sym_SEMI] = ACTIONS(1183),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1185),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1185),
    [sym_next] = ACTIONS(1185),
    [sym_true] = ACTIONS(1185),
    [sym_false] = ACTIONS(1185),
    [sym_null] = ACTIONS(1185),
    [sym_inf] = ACTIONS(1185),
    [sym_nan] = ACTIONS(1185),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1183),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [159] = {
    [anon_sym_SEMI] = ACTIONS(649),
    [anon_sym_function] = ACTIONS(651),
    [anon_sym_BSLASH] = ACTIONS(649),
    [anon_sym_if] = ACTIONS(651),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_RPAREN] = ACTIONS(649),
    [anon_sym_while] = ACTIONS(651),
    [anon_sym_repeat] = ACTIONS(651),
    [anon_sym_for] = ACTIONS(651),
    [anon_sym_switch] = ACTIONS(651),
    [anon_sym_COMMA] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(651),
    [anon_sym_LBRACE] = ACTIONS(649),
    [anon_sym_LT_DASH] = ACTIONS(649),
    [anon_sym_COLON_EQ] = ACTIONS(649),
    [anon_sym_LT_LT_DASH] = ACTIONS(649),
    [anon_sym_DASH_GT_GT] = ACTIONS(649),
    [anon_sym_DASH_GT] = ACTIONS(651),
    [anon_sym_LBRACK] = ACTIONS(651),
    [anon_sym_RBRACK] = ACTIONS(649),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(649),
    [anon_sym_DOLLAR] = ACTIONS(649),
    [anon_sym_AT] = ACTIONS(649),
    [anon_sym_COLON_COLON] = ACTIONS(651),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(649),
    [sym_dots] = ACTIONS(651),
    [anon_sym_PIPE_GT] = ACTIONS(649),
    [anon_sym_DASH] = ACTIONS(651),
    [anon_sym_PLUS] = ACTIONS(649),
    [anon_sym_BANG] = ACTIONS(651),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_STAR] = ACTIONS(649),
    [anon_sym_SLASH] = ACTIONS(649),
    [anon_sym_CARET] = ACTIONS(649),
    [anon_sym_LT] = ACTIONS(651),
    [anon_sym_GT] = ACTIONS(651),
    [anon_sym_LT_EQ] = ACTIONS(649),
    [anon_sym_GT_EQ] = ACTIONS(649),
    [anon_sym_EQ_EQ] = ACTIONS(649),
    [anon_sym_BANG_EQ] = ACTIONS(649),
    [anon_sym_PIPE_PIPE] = ACTIONS(649),
    [anon_sym_PIPE] = ACTIONS(651),
    [anon_sym_AMP_AMP] = ACTIONS(649),
    [anon_sym_AMP] = ACTIONS(651),
    [anon_sym_COLON] = ACTIONS(651),
    [sym_break] = ACTIONS(651),
    [sym_next] = ACTIONS(651),
    [sym_true] = ACTIONS(651),
    [sym_false] = ACTIONS(651),
    [sym_null] = ACTIONS(651),
    [sym_inf] = ACTIONS(651),
    [sym_nan] = ACTIONS(651),
    [anon_sym_NA] = ACTIONS(651),
    [anon_sym_NA_character_] = ACTIONS(651),
    [anon_sym_NA_complex_] = ACTIONS(651),
    [anon_sym_NA_integer_] = ACTIONS(651),
    [anon_sym_NA_real_] = ACTIONS(651),
    [aux_sym_identifier_token1] = ACTIONS(651),
    [anon_sym_BQUOTE] = ACTIONS(649),
    [sym_integer] = ACTIONS(649),
    [sym_float] = ACTIONS(651),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(649),
    [anon_sym_PERCENT] = ACTIONS(649),
  },
  [160] = {
    [sym_function_definition] = STATE(799),
    [sym_lambda_function] = STATE(799),
    [sym_if] = STATE(799),
    [sym_while] = STATE(799),
    [sym_repeat] = STATE(799),
    [sym_for] = STATE(799),
    [sym_switch] = STATE(799),
    [sym_call] = STATE(799),
    [sym__assignment] = STATE(799),
    [sym_left_assignment] = STATE(799),
    [sym_left_assignment2] = STATE(799),
    [sym_equals_assignment] = STATE(799),
    [sym_super_assignment] = STATE(799),
    [sym_super_right_assignment] = STATE(799),
    [sym_right_assignment] = STATE(799),
    [sym_brace_list] = STATE(799),
    [sym_paren_list] = STATE(799),
    [sym_subset] = STATE(799),
    [sym_subset2] = STATE(799),
    [sym_dollar] = STATE(799),
    [sym_slot] = STATE(799),
    [sym_namespace_get] = STATE(799),
    [sym_namespace_get_internal] = STATE(799),
    [sym_pipe] = STATE(799),
    [sym_unary] = STATE(799),
    [sym_binary] = STATE(799),
    [sym_na] = STATE(799),
    [sym__expression] = STATE(799),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(799),
    [sym_string] = STATE(799),
    [anon_sym_SEMI] = ACTIONS(1187),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1189),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1189),
    [sym_next] = ACTIONS(1189),
    [sym_true] = ACTIONS(1189),
    [sym_false] = ACTIONS(1189),
    [sym_null] = ACTIONS(1189),
    [sym_inf] = ACTIONS(1189),
    [sym_nan] = ACTIONS(1189),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1187),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [161] = {
    [sym_function_definition] = STATE(812),
    [sym_lambda_function] = STATE(812),
    [sym_if] = STATE(812),
    [sym_while] = STATE(812),
    [sym_repeat] = STATE(812),
    [sym_for] = STATE(812),
    [sym_switch] = STATE(812),
    [sym_call] = STATE(812),
    [sym__assignment] = STATE(812),
    [sym_left_assignment] = STATE(812),
    [sym_left_assignment2] = STATE(812),
    [sym_equals_assignment] = STATE(812),
    [sym_super_assignment] = STATE(812),
    [sym_super_right_assignment] = STATE(812),
    [sym_right_assignment] = STATE(812),
    [sym_brace_list] = STATE(812),
    [sym_paren_list] = STATE(812),
    [sym_subset] = STATE(812),
    [sym_subset2] = STATE(812),
    [sym_dollar] = STATE(812),
    [sym_slot] = STATE(812),
    [sym_namespace_get] = STATE(812),
    [sym_namespace_get_internal] = STATE(812),
    [sym_pipe] = STATE(812),
    [sym_unary] = STATE(812),
    [sym_binary] = STATE(812),
    [sym_na] = STATE(812),
    [sym__expression] = STATE(812),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(812),
    [sym_string] = STATE(812),
    [anon_sym_SEMI] = ACTIONS(1191),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1193),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1193),
    [sym_next] = ACTIONS(1193),
    [sym_true] = ACTIONS(1193),
    [sym_false] = ACTIONS(1193),
    [sym_null] = ACTIONS(1193),
    [sym_inf] = ACTIONS(1193),
    [sym_nan] = ACTIONS(1193),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1191),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [162] = {
    [anon_sym_SEMI] = ACTIONS(641),
    [anon_sym_function] = ACTIONS(643),
    [anon_sym_BSLASH] = ACTIONS(641),
    [anon_sym_if] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_RPAREN] = ACTIONS(641),
    [anon_sym_while] = ACTIONS(643),
    [anon_sym_repeat] = ACTIONS(643),
    [anon_sym_for] = ACTIONS(643),
    [anon_sym_switch] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(641),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(641),
    [anon_sym_LT_DASH] = ACTIONS(641),
    [anon_sym_COLON_EQ] = ACTIONS(641),
    [anon_sym_LT_LT_DASH] = ACTIONS(641),
    [anon_sym_DASH_GT_GT] = ACTIONS(641),
    [anon_sym_DASH_GT] = ACTIONS(643),
    [anon_sym_LBRACK] = ACTIONS(643),
    [anon_sym_RBRACK] = ACTIONS(641),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(641),
    [anon_sym_DOLLAR] = ACTIONS(641),
    [anon_sym_AT] = ACTIONS(641),
    [anon_sym_COLON_COLON] = ACTIONS(739),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(741),
    [sym_dots] = ACTIONS(643),
    [anon_sym_PIPE_GT] = ACTIONS(641),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_PLUS] = ACTIONS(641),
    [anon_sym_BANG] = ACTIONS(643),
    [anon_sym_TILDE] = ACTIONS(641),
    [anon_sym_STAR] = ACTIONS(641),
    [anon_sym_SLASH] = ACTIONS(641),
    [anon_sym_CARET] = ACTIONS(641),
    [anon_sym_LT] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(643),
    [anon_sym_LT_EQ] = ACTIONS(641),
    [anon_sym_GT_EQ] = ACTIONS(641),
    [anon_sym_EQ_EQ] = ACTIONS(641),
    [anon_sym_BANG_EQ] = ACTIONS(641),
    [anon_sym_PIPE_PIPE] = ACTIONS(641),
    [anon_sym_PIPE] = ACTIONS(643),
    [anon_sym_AMP_AMP] = ACTIONS(641),
    [anon_sym_AMP] = ACTIONS(643),
    [anon_sym_COLON] = ACTIONS(643),
    [sym_break] = ACTIONS(643),
    [sym_next] = ACTIONS(643),
    [sym_true] = ACTIONS(643),
    [sym_false] = ACTIONS(643),
    [sym_null] = ACTIONS(643),
    [sym_inf] = ACTIONS(643),
    [sym_nan] = ACTIONS(643),
    [anon_sym_NA] = ACTIONS(643),
    [anon_sym_NA_character_] = ACTIONS(643),
    [anon_sym_NA_complex_] = ACTIONS(643),
    [anon_sym_NA_integer_] = ACTIONS(643),
    [anon_sym_NA_real_] = ACTIONS(643),
    [aux_sym_identifier_token1] = ACTIONS(643),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [sym_integer] = ACTIONS(641),
    [sym_float] = ACTIONS(643),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(641),
    [anon_sym_SQUOTE] = ACTIONS(641),
    [anon_sym_PERCENT] = ACTIONS(641),
  },
  [163] = {
    [sym_function_definition] = STATE(535),
    [sym_lambda_function] = STATE(535),
    [sym_if] = STATE(535),
    [sym_while] = STATE(535),
    [sym_repeat] = STATE(535),
    [sym_for] = STATE(535),
    [sym_switch] = STATE(535),
    [sym_call] = STATE(535),
    [sym__assignment] = STATE(535),
    [sym_left_assignment] = STATE(535),
    [sym_left_assignment2] = STATE(535),
    [sym_equals_assignment] = STATE(535),
    [sym_super_assignment] = STATE(535),
    [sym_super_right_assignment] = STATE(535),
    [sym_right_assignment] = STATE(535),
    [sym_brace_list] = STATE(535),
    [sym_paren_list] = STATE(535),
    [sym_subset] = STATE(535),
    [sym_subset2] = STATE(535),
    [sym_dollar] = STATE(535),
    [sym_slot] = STATE(535),
    [sym_namespace_get] = STATE(535),
    [sym_namespace_get_internal] = STATE(535),
    [sym_pipe] = STATE(535),
    [sym_unary] = STATE(535),
    [sym_binary] = STATE(535),
    [sym_na] = STATE(535),
    [sym__expression] = STATE(535),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(535),
    [sym_string] = STATE(535),
    [anon_sym_SEMI] = ACTIONS(1195),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1197),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1197),
    [sym_next] = ACTIONS(1197),
    [sym_true] = ACTIONS(1197),
    [sym_false] = ACTIONS(1197),
    [sym_null] = ACTIONS(1197),
    [sym_inf] = ACTIONS(1197),
    [sym_nan] = ACTIONS(1197),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1195),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [164] = {
    [sym_function_definition] = STATE(536),
    [sym_lambda_function] = STATE(536),
    [sym_if] = STATE(536),
    [sym_while] = STATE(536),
    [sym_repeat] = STATE(536),
    [sym_for] = STATE(536),
    [sym_switch] = STATE(536),
    [sym_call] = STATE(536),
    [sym__assignment] = STATE(536),
    [sym_left_assignment] = STATE(536),
    [sym_left_assignment2] = STATE(536),
    [sym_equals_assignment] = STATE(536),
    [sym_super_assignment] = STATE(536),
    [sym_super_right_assignment] = STATE(536),
    [sym_right_assignment] = STATE(536),
    [sym_brace_list] = STATE(536),
    [sym_paren_list] = STATE(536),
    [sym_subset] = STATE(536),
    [sym_subset2] = STATE(536),
    [sym_dollar] = STATE(536),
    [sym_slot] = STATE(536),
    [sym_namespace_get] = STATE(536),
    [sym_namespace_get_internal] = STATE(536),
    [sym_pipe] = STATE(536),
    [sym_unary] = STATE(536),
    [sym_binary] = STATE(536),
    [sym_na] = STATE(536),
    [sym__expression] = STATE(536),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(536),
    [sym_string] = STATE(536),
    [anon_sym_SEMI] = ACTIONS(1199),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1201),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1201),
    [sym_next] = ACTIONS(1201),
    [sym_true] = ACTIONS(1201),
    [sym_false] = ACTIONS(1201),
    [sym_null] = ACTIONS(1201),
    [sym_inf] = ACTIONS(1201),
    [sym_nan] = ACTIONS(1201),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1199),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [165] = {
    [sym_function_definition] = STATE(811),
    [sym_lambda_function] = STATE(811),
    [sym_if] = STATE(811),
    [sym_while] = STATE(811),
    [sym_repeat] = STATE(811),
    [sym_for] = STATE(811),
    [sym_switch] = STATE(811),
    [sym_call] = STATE(811),
    [sym__assignment] = STATE(811),
    [sym_left_assignment] = STATE(811),
    [sym_left_assignment2] = STATE(811),
    [sym_equals_assignment] = STATE(811),
    [sym_super_assignment] = STATE(811),
    [sym_super_right_assignment] = STATE(811),
    [sym_right_assignment] = STATE(811),
    [sym_brace_list] = STATE(811),
    [sym_paren_list] = STATE(811),
    [sym_subset] = STATE(811),
    [sym_subset2] = STATE(811),
    [sym_dollar] = STATE(811),
    [sym_slot] = STATE(811),
    [sym_namespace_get] = STATE(811),
    [sym_namespace_get_internal] = STATE(811),
    [sym_pipe] = STATE(811),
    [sym_unary] = STATE(811),
    [sym_binary] = STATE(811),
    [sym_na] = STATE(811),
    [sym__expression] = STATE(811),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(811),
    [sym_string] = STATE(811),
    [anon_sym_SEMI] = ACTIONS(1203),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1205),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1205),
    [sym_next] = ACTIONS(1205),
    [sym_true] = ACTIONS(1205),
    [sym_false] = ACTIONS(1205),
    [sym_null] = ACTIONS(1205),
    [sym_inf] = ACTIONS(1205),
    [sym_nan] = ACTIONS(1205),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1203),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [166] = {
    [sym_function_definition] = STATE(798),
    [sym_lambda_function] = STATE(798),
    [sym_if] = STATE(798),
    [sym_while] = STATE(798),
    [sym_repeat] = STATE(798),
    [sym_for] = STATE(798),
    [sym_switch] = STATE(798),
    [sym_call] = STATE(798),
    [sym__assignment] = STATE(798),
    [sym_left_assignment] = STATE(798),
    [sym_left_assignment2] = STATE(798),
    [sym_equals_assignment] = STATE(798),
    [sym_super_assignment] = STATE(798),
    [sym_super_right_assignment] = STATE(798),
    [sym_right_assignment] = STATE(798),
    [sym_brace_list] = STATE(798),
    [sym_paren_list] = STATE(798),
    [sym_subset] = STATE(798),
    [sym_subset2] = STATE(798),
    [sym_dollar] = STATE(798),
    [sym_slot] = STATE(798),
    [sym_namespace_get] = STATE(798),
    [sym_namespace_get_internal] = STATE(798),
    [sym_pipe] = STATE(798),
    [sym_unary] = STATE(798),
    [sym_binary] = STATE(798),
    [sym_na] = STATE(798),
    [sym__expression] = STATE(798),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(798),
    [sym_string] = STATE(798),
    [anon_sym_SEMI] = ACTIONS(1207),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1209),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1209),
    [sym_next] = ACTIONS(1209),
    [sym_true] = ACTIONS(1209),
    [sym_false] = ACTIONS(1209),
    [sym_null] = ACTIONS(1209),
    [sym_inf] = ACTIONS(1209),
    [sym_nan] = ACTIONS(1209),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1207),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [167] = {
    [sym_function_definition] = STATE(821),
    [sym_lambda_function] = STATE(821),
    [sym_if] = STATE(821),
    [sym_while] = STATE(821),
    [sym_repeat] = STATE(821),
    [sym_for] = STATE(821),
    [sym_switch] = STATE(821),
    [sym_call] = STATE(821),
    [sym__assignment] = STATE(821),
    [sym_left_assignment] = STATE(821),
    [sym_left_assignment2] = STATE(821),
    [sym_equals_assignment] = STATE(821),
    [sym_super_assignment] = STATE(821),
    [sym_super_right_assignment] = STATE(821),
    [sym_right_assignment] = STATE(821),
    [sym_brace_list] = STATE(821),
    [sym_paren_list] = STATE(821),
    [sym_subset] = STATE(821),
    [sym_subset2] = STATE(821),
    [sym_dollar] = STATE(821),
    [sym_slot] = STATE(821),
    [sym_namespace_get] = STATE(821),
    [sym_namespace_get_internal] = STATE(821),
    [sym_pipe] = STATE(821),
    [sym_unary] = STATE(821),
    [sym_binary] = STATE(821),
    [sym_na] = STATE(821),
    [sym__expression] = STATE(821),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(821),
    [sym_string] = STATE(821),
    [anon_sym_SEMI] = ACTIONS(1211),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1213),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1213),
    [sym_next] = ACTIONS(1213),
    [sym_true] = ACTIONS(1213),
    [sym_false] = ACTIONS(1213),
    [sym_null] = ACTIONS(1213),
    [sym_inf] = ACTIONS(1213),
    [sym_nan] = ACTIONS(1213),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1211),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [168] = {
    [sym_function_definition] = STATE(807),
    [sym_lambda_function] = STATE(807),
    [sym_if] = STATE(807),
    [sym_while] = STATE(807),
    [sym_repeat] = STATE(807),
    [sym_for] = STATE(807),
    [sym_switch] = STATE(807),
    [sym_call] = STATE(807),
    [sym__assignment] = STATE(807),
    [sym_left_assignment] = STATE(807),
    [sym_left_assignment2] = STATE(807),
    [sym_equals_assignment] = STATE(807),
    [sym_super_assignment] = STATE(807),
    [sym_super_right_assignment] = STATE(807),
    [sym_right_assignment] = STATE(807),
    [sym_brace_list] = STATE(807),
    [sym_paren_list] = STATE(807),
    [sym_subset] = STATE(807),
    [sym_subset2] = STATE(807),
    [sym_dollar] = STATE(807),
    [sym_slot] = STATE(807),
    [sym_namespace_get] = STATE(807),
    [sym_namespace_get_internal] = STATE(807),
    [sym_pipe] = STATE(807),
    [sym_unary] = STATE(807),
    [sym_binary] = STATE(807),
    [sym_na] = STATE(807),
    [sym__expression] = STATE(807),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(807),
    [sym_string] = STATE(807),
    [anon_sym_SEMI] = ACTIONS(1215),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1217),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1217),
    [sym_next] = ACTIONS(1217),
    [sym_true] = ACTIONS(1217),
    [sym_false] = ACTIONS(1217),
    [sym_null] = ACTIONS(1217),
    [sym_inf] = ACTIONS(1217),
    [sym_nan] = ACTIONS(1217),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1215),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [169] = {
    [sym_function_definition] = STATE(806),
    [sym_lambda_function] = STATE(806),
    [sym_if] = STATE(806),
    [sym_while] = STATE(806),
    [sym_repeat] = STATE(806),
    [sym_for] = STATE(806),
    [sym_switch] = STATE(806),
    [sym_call] = STATE(806),
    [sym__assignment] = STATE(806),
    [sym_left_assignment] = STATE(806),
    [sym_left_assignment2] = STATE(806),
    [sym_equals_assignment] = STATE(806),
    [sym_super_assignment] = STATE(806),
    [sym_super_right_assignment] = STATE(806),
    [sym_right_assignment] = STATE(806),
    [sym_brace_list] = STATE(806),
    [sym_paren_list] = STATE(806),
    [sym_subset] = STATE(806),
    [sym_subset2] = STATE(806),
    [sym_dollar] = STATE(806),
    [sym_slot] = STATE(806),
    [sym_namespace_get] = STATE(806),
    [sym_namespace_get_internal] = STATE(806),
    [sym_pipe] = STATE(806),
    [sym_unary] = STATE(806),
    [sym_binary] = STATE(806),
    [sym_na] = STATE(806),
    [sym__expression] = STATE(806),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(806),
    [sym_string] = STATE(806),
    [anon_sym_SEMI] = ACTIONS(1219),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1221),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1221),
    [sym_next] = ACTIONS(1221),
    [sym_true] = ACTIONS(1221),
    [sym_false] = ACTIONS(1221),
    [sym_null] = ACTIONS(1221),
    [sym_inf] = ACTIONS(1221),
    [sym_nan] = ACTIONS(1221),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1219),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [170] = {
    [sym_function_definition] = STATE(805),
    [sym_lambda_function] = STATE(805),
    [sym_if] = STATE(805),
    [sym_while] = STATE(805),
    [sym_repeat] = STATE(805),
    [sym_for] = STATE(805),
    [sym_switch] = STATE(805),
    [sym_call] = STATE(805),
    [sym__assignment] = STATE(805),
    [sym_left_assignment] = STATE(805),
    [sym_left_assignment2] = STATE(805),
    [sym_equals_assignment] = STATE(805),
    [sym_super_assignment] = STATE(805),
    [sym_super_right_assignment] = STATE(805),
    [sym_right_assignment] = STATE(805),
    [sym_brace_list] = STATE(805),
    [sym_paren_list] = STATE(805),
    [sym_subset] = STATE(805),
    [sym_subset2] = STATE(805),
    [sym_dollar] = STATE(805),
    [sym_slot] = STATE(805),
    [sym_namespace_get] = STATE(805),
    [sym_namespace_get_internal] = STATE(805),
    [sym_pipe] = STATE(805),
    [sym_unary] = STATE(805),
    [sym_binary] = STATE(805),
    [sym_na] = STATE(805),
    [sym__expression] = STATE(805),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(805),
    [sym_string] = STATE(805),
    [anon_sym_SEMI] = ACTIONS(1223),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1225),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1225),
    [sym_next] = ACTIONS(1225),
    [sym_true] = ACTIONS(1225),
    [sym_false] = ACTIONS(1225),
    [sym_null] = ACTIONS(1225),
    [sym_inf] = ACTIONS(1225),
    [sym_nan] = ACTIONS(1225),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1223),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [171] = {
    [anon_sym_SEMI] = ACTIONS(653),
    [anon_sym_function] = ACTIONS(655),
    [anon_sym_BSLASH] = ACTIONS(653),
    [anon_sym_if] = ACTIONS(655),
    [anon_sym_LPAREN] = ACTIONS(653),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(655),
    [anon_sym_repeat] = ACTIONS(655),
    [anon_sym_for] = ACTIONS(655),
    [anon_sym_switch] = ACTIONS(655),
    [anon_sym_COMMA] = ACTIONS(653),
    [anon_sym_EQ] = ACTIONS(655),
    [anon_sym_LBRACE] = ACTIONS(653),
    [anon_sym_LT_DASH] = ACTIONS(653),
    [anon_sym_COLON_EQ] = ACTIONS(653),
    [anon_sym_LT_LT_DASH] = ACTIONS(653),
    [anon_sym_DASH_GT_GT] = ACTIONS(653),
    [anon_sym_DASH_GT] = ACTIONS(655),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(653),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(653),
    [anon_sym_DOLLAR] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(653),
    [anon_sym_COLON_COLON] = ACTIONS(655),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(653),
    [sym_dots] = ACTIONS(655),
    [anon_sym_PIPE_GT] = ACTIONS(653),
    [anon_sym_DASH] = ACTIONS(655),
    [anon_sym_PLUS] = ACTIONS(653),
    [anon_sym_BANG] = ACTIONS(655),
    [anon_sym_TILDE] = ACTIONS(653),
    [anon_sym_STAR] = ACTIONS(653),
    [anon_sym_SLASH] = ACTIONS(653),
    [anon_sym_CARET] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(655),
    [anon_sym_GT] = ACTIONS(655),
    [anon_sym_LT_EQ] = ACTIONS(653),
    [anon_sym_GT_EQ] = ACTIONS(653),
    [anon_sym_EQ_EQ] = ACTIONS(653),
    [anon_sym_BANG_EQ] = ACTIONS(653),
    [anon_sym_PIPE_PIPE] = ACTIONS(653),
    [anon_sym_PIPE] = ACTIONS(655),
    [anon_sym_AMP_AMP] = ACTIONS(653),
    [anon_sym_AMP] = ACTIONS(655),
    [anon_sym_COLON] = ACTIONS(655),
    [sym_break] = ACTIONS(655),
    [sym_next] = ACTIONS(655),
    [sym_true] = ACTIONS(655),
    [sym_false] = ACTIONS(655),
    [sym_null] = ACTIONS(655),
    [sym_inf] = ACTIONS(655),
    [sym_nan] = ACTIONS(655),
    [anon_sym_NA] = ACTIONS(655),
    [anon_sym_NA_character_] = ACTIONS(655),
    [anon_sym_NA_complex_] = ACTIONS(655),
    [anon_sym_NA_integer_] = ACTIONS(655),
    [anon_sym_NA_real_] = ACTIONS(655),
    [aux_sym_identifier_token1] = ACTIONS(655),
    [anon_sym_BQUOTE] = ACTIONS(653),
    [sym_integer] = ACTIONS(653),
    [sym_float] = ACTIONS(655),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(653),
    [anon_sym_SQUOTE] = ACTIONS(653),
    [anon_sym_PERCENT] = ACTIONS(653),
  },
  [172] = {
    [sym_function_definition] = STATE(804),
    [sym_lambda_function] = STATE(804),
    [sym_if] = STATE(804),
    [sym_while] = STATE(804),
    [sym_repeat] = STATE(804),
    [sym_for] = STATE(804),
    [sym_switch] = STATE(804),
    [sym_call] = STATE(804),
    [sym__assignment] = STATE(804),
    [sym_left_assignment] = STATE(804),
    [sym_left_assignment2] = STATE(804),
    [sym_equals_assignment] = STATE(804),
    [sym_super_assignment] = STATE(804),
    [sym_super_right_assignment] = STATE(804),
    [sym_right_assignment] = STATE(804),
    [sym_brace_list] = STATE(804),
    [sym_paren_list] = STATE(804),
    [sym_subset] = STATE(804),
    [sym_subset2] = STATE(804),
    [sym_dollar] = STATE(804),
    [sym_slot] = STATE(804),
    [sym_namespace_get] = STATE(804),
    [sym_namespace_get_internal] = STATE(804),
    [sym_pipe] = STATE(804),
    [sym_unary] = STATE(804),
    [sym_binary] = STATE(804),
    [sym_na] = STATE(804),
    [sym__expression] = STATE(804),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(804),
    [sym_string] = STATE(804),
    [anon_sym_SEMI] = ACTIONS(1227),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1229),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1229),
    [sym_next] = ACTIONS(1229),
    [sym_true] = ACTIONS(1229),
    [sym_false] = ACTIONS(1229),
    [sym_null] = ACTIONS(1229),
    [sym_inf] = ACTIONS(1229),
    [sym_nan] = ACTIONS(1229),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1227),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [173] = {
    [sym_function_definition] = STATE(803),
    [sym_lambda_function] = STATE(803),
    [sym_if] = STATE(803),
    [sym_while] = STATE(803),
    [sym_repeat] = STATE(803),
    [sym_for] = STATE(803),
    [sym_switch] = STATE(803),
    [sym_call] = STATE(803),
    [sym__assignment] = STATE(803),
    [sym_left_assignment] = STATE(803),
    [sym_left_assignment2] = STATE(803),
    [sym_equals_assignment] = STATE(803),
    [sym_super_assignment] = STATE(803),
    [sym_super_right_assignment] = STATE(803),
    [sym_right_assignment] = STATE(803),
    [sym_brace_list] = STATE(803),
    [sym_paren_list] = STATE(803),
    [sym_subset] = STATE(803),
    [sym_subset2] = STATE(803),
    [sym_dollar] = STATE(803),
    [sym_slot] = STATE(803),
    [sym_namespace_get] = STATE(803),
    [sym_namespace_get_internal] = STATE(803),
    [sym_pipe] = STATE(803),
    [sym_unary] = STATE(803),
    [sym_binary] = STATE(803),
    [sym_na] = STATE(803),
    [sym__expression] = STATE(803),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(803),
    [sym_string] = STATE(803),
    [anon_sym_SEMI] = ACTIONS(1231),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1233),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1233),
    [sym_next] = ACTIONS(1233),
    [sym_true] = ACTIONS(1233),
    [sym_false] = ACTIONS(1233),
    [sym_null] = ACTIONS(1233),
    [sym_inf] = ACTIONS(1233),
    [sym_nan] = ACTIONS(1233),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1231),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [174] = {
    [sym_function_definition] = STATE(534),
    [sym_lambda_function] = STATE(534),
    [sym_if] = STATE(534),
    [sym_while] = STATE(534),
    [sym_repeat] = STATE(534),
    [sym_for] = STATE(534),
    [sym_switch] = STATE(534),
    [sym_call] = STATE(534),
    [sym__assignment] = STATE(534),
    [sym_left_assignment] = STATE(534),
    [sym_left_assignment2] = STATE(534),
    [sym_equals_assignment] = STATE(534),
    [sym_super_assignment] = STATE(534),
    [sym_super_right_assignment] = STATE(534),
    [sym_right_assignment] = STATE(534),
    [sym_brace_list] = STATE(534),
    [sym_paren_list] = STATE(534),
    [sym_subset] = STATE(534),
    [sym_subset2] = STATE(534),
    [sym_dollar] = STATE(534),
    [sym_slot] = STATE(534),
    [sym_namespace_get] = STATE(534),
    [sym_namespace_get_internal] = STATE(534),
    [sym_pipe] = STATE(534),
    [sym_unary] = STATE(534),
    [sym_binary] = STATE(534),
    [sym_na] = STATE(534),
    [sym__expression] = STATE(534),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(534),
    [sym_string] = STATE(534),
    [anon_sym_SEMI] = ACTIONS(1235),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1237),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1237),
    [sym_next] = ACTIONS(1237),
    [sym_true] = ACTIONS(1237),
    [sym_false] = ACTIONS(1237),
    [sym_null] = ACTIONS(1237),
    [sym_inf] = ACTIONS(1237),
    [sym_nan] = ACTIONS(1237),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1235),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [175] = {
    [sym_function_definition] = STATE(542),
    [sym_lambda_function] = STATE(542),
    [sym_if] = STATE(542),
    [sym_while] = STATE(542),
    [sym_repeat] = STATE(542),
    [sym_for] = STATE(542),
    [sym_switch] = STATE(542),
    [sym_call] = STATE(542),
    [sym__assignment] = STATE(542),
    [sym_left_assignment] = STATE(542),
    [sym_left_assignment2] = STATE(542),
    [sym_equals_assignment] = STATE(542),
    [sym_super_assignment] = STATE(542),
    [sym_super_right_assignment] = STATE(542),
    [sym_right_assignment] = STATE(542),
    [sym_brace_list] = STATE(542),
    [sym_paren_list] = STATE(542),
    [sym_subset] = STATE(542),
    [sym_subset2] = STATE(542),
    [sym_dollar] = STATE(542),
    [sym_slot] = STATE(542),
    [sym_namespace_get] = STATE(542),
    [sym_namespace_get_internal] = STATE(542),
    [sym_pipe] = STATE(542),
    [sym_unary] = STATE(542),
    [sym_binary] = STATE(542),
    [sym_na] = STATE(542),
    [sym__expression] = STATE(542),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(542),
    [sym_string] = STATE(542),
    [anon_sym_SEMI] = ACTIONS(1239),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1241),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1241),
    [sym_next] = ACTIONS(1241),
    [sym_true] = ACTIONS(1241),
    [sym_false] = ACTIONS(1241),
    [sym_null] = ACTIONS(1241),
    [sym_inf] = ACTIONS(1241),
    [sym_nan] = ACTIONS(1241),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1239),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [176] = {
    [sym_function_definition] = STATE(545),
    [sym_lambda_function] = STATE(545),
    [sym_if] = STATE(545),
    [sym_while] = STATE(545),
    [sym_repeat] = STATE(545),
    [sym_for] = STATE(545),
    [sym_switch] = STATE(545),
    [sym_call] = STATE(545),
    [sym__assignment] = STATE(545),
    [sym_left_assignment] = STATE(545),
    [sym_left_assignment2] = STATE(545),
    [sym_equals_assignment] = STATE(545),
    [sym_super_assignment] = STATE(545),
    [sym_super_right_assignment] = STATE(545),
    [sym_right_assignment] = STATE(545),
    [sym_brace_list] = STATE(545),
    [sym_paren_list] = STATE(545),
    [sym_subset] = STATE(545),
    [sym_subset2] = STATE(545),
    [sym_dollar] = STATE(545),
    [sym_slot] = STATE(545),
    [sym_namespace_get] = STATE(545),
    [sym_namespace_get_internal] = STATE(545),
    [sym_pipe] = STATE(545),
    [sym_unary] = STATE(545),
    [sym_binary] = STATE(545),
    [sym_na] = STATE(545),
    [sym__expression] = STATE(545),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(545),
    [sym_string] = STATE(545),
    [anon_sym_SEMI] = ACTIONS(1243),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1245),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1245),
    [sym_next] = ACTIONS(1245),
    [sym_true] = ACTIONS(1245),
    [sym_false] = ACTIONS(1245),
    [sym_null] = ACTIONS(1245),
    [sym_inf] = ACTIONS(1245),
    [sym_nan] = ACTIONS(1245),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1243),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [177] = {
    [sym_function_definition] = STATE(546),
    [sym_lambda_function] = STATE(546),
    [sym_if] = STATE(546),
    [sym_while] = STATE(546),
    [sym_repeat] = STATE(546),
    [sym_for] = STATE(546),
    [sym_switch] = STATE(546),
    [sym_call] = STATE(546),
    [sym__assignment] = STATE(546),
    [sym_left_assignment] = STATE(546),
    [sym_left_assignment2] = STATE(546),
    [sym_equals_assignment] = STATE(546),
    [sym_super_assignment] = STATE(546),
    [sym_super_right_assignment] = STATE(546),
    [sym_right_assignment] = STATE(546),
    [sym_brace_list] = STATE(546),
    [sym_paren_list] = STATE(546),
    [sym_subset] = STATE(546),
    [sym_subset2] = STATE(546),
    [sym_dollar] = STATE(546),
    [sym_slot] = STATE(546),
    [sym_namespace_get] = STATE(546),
    [sym_namespace_get_internal] = STATE(546),
    [sym_pipe] = STATE(546),
    [sym_unary] = STATE(546),
    [sym_binary] = STATE(546),
    [sym_na] = STATE(546),
    [sym__expression] = STATE(546),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(546),
    [sym_string] = STATE(546),
    [anon_sym_SEMI] = ACTIONS(1247),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1249),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1249),
    [sym_next] = ACTIONS(1249),
    [sym_true] = ACTIONS(1249),
    [sym_false] = ACTIONS(1249),
    [sym_null] = ACTIONS(1249),
    [sym_inf] = ACTIONS(1249),
    [sym_nan] = ACTIONS(1249),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1247),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [178] = {
    [sym_function_definition] = STATE(550),
    [sym_lambda_function] = STATE(550),
    [sym_if] = STATE(550),
    [sym_while] = STATE(550),
    [sym_repeat] = STATE(550),
    [sym_for] = STATE(550),
    [sym_switch] = STATE(550),
    [sym_call] = STATE(550),
    [sym__assignment] = STATE(550),
    [sym_left_assignment] = STATE(550),
    [sym_left_assignment2] = STATE(550),
    [sym_equals_assignment] = STATE(550),
    [sym_super_assignment] = STATE(550),
    [sym_super_right_assignment] = STATE(550),
    [sym_right_assignment] = STATE(550),
    [sym_brace_list] = STATE(550),
    [sym_paren_list] = STATE(550),
    [sym_subset] = STATE(550),
    [sym_subset2] = STATE(550),
    [sym_dollar] = STATE(550),
    [sym_slot] = STATE(550),
    [sym_namespace_get] = STATE(550),
    [sym_namespace_get_internal] = STATE(550),
    [sym_pipe] = STATE(550),
    [sym_unary] = STATE(550),
    [sym_binary] = STATE(550),
    [sym_na] = STATE(550),
    [sym__expression] = STATE(550),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(550),
    [sym_string] = STATE(550),
    [anon_sym_SEMI] = ACTIONS(1251),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1253),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1253),
    [sym_next] = ACTIONS(1253),
    [sym_true] = ACTIONS(1253),
    [sym_false] = ACTIONS(1253),
    [sym_null] = ACTIONS(1253),
    [sym_inf] = ACTIONS(1253),
    [sym_nan] = ACTIONS(1253),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1251),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [179] = {
    [sym_function_definition] = STATE(551),
    [sym_lambda_function] = STATE(551),
    [sym_if] = STATE(551),
    [sym_while] = STATE(551),
    [sym_repeat] = STATE(551),
    [sym_for] = STATE(551),
    [sym_switch] = STATE(551),
    [sym_call] = STATE(551),
    [sym__assignment] = STATE(551),
    [sym_left_assignment] = STATE(551),
    [sym_left_assignment2] = STATE(551),
    [sym_equals_assignment] = STATE(551),
    [sym_super_assignment] = STATE(551),
    [sym_super_right_assignment] = STATE(551),
    [sym_right_assignment] = STATE(551),
    [sym_brace_list] = STATE(551),
    [sym_paren_list] = STATE(551),
    [sym_subset] = STATE(551),
    [sym_subset2] = STATE(551),
    [sym_dollar] = STATE(551),
    [sym_slot] = STATE(551),
    [sym_namespace_get] = STATE(551),
    [sym_namespace_get_internal] = STATE(551),
    [sym_pipe] = STATE(551),
    [sym_unary] = STATE(551),
    [sym_binary] = STATE(551),
    [sym_na] = STATE(551),
    [sym__expression] = STATE(551),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(551),
    [sym_string] = STATE(551),
    [anon_sym_SEMI] = ACTIONS(1255),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1257),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1257),
    [sym_next] = ACTIONS(1257),
    [sym_true] = ACTIONS(1257),
    [sym_false] = ACTIONS(1257),
    [sym_null] = ACTIONS(1257),
    [sym_inf] = ACTIONS(1257),
    [sym_nan] = ACTIONS(1257),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1255),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [180] = {
    [sym_function_definition] = STATE(552),
    [sym_lambda_function] = STATE(552),
    [sym_if] = STATE(552),
    [sym_while] = STATE(552),
    [sym_repeat] = STATE(552),
    [sym_for] = STATE(552),
    [sym_switch] = STATE(552),
    [sym_call] = STATE(552),
    [sym__assignment] = STATE(552),
    [sym_left_assignment] = STATE(552),
    [sym_left_assignment2] = STATE(552),
    [sym_equals_assignment] = STATE(552),
    [sym_super_assignment] = STATE(552),
    [sym_super_right_assignment] = STATE(552),
    [sym_right_assignment] = STATE(552),
    [sym_brace_list] = STATE(552),
    [sym_paren_list] = STATE(552),
    [sym_subset] = STATE(552),
    [sym_subset2] = STATE(552),
    [sym_dollar] = STATE(552),
    [sym_slot] = STATE(552),
    [sym_namespace_get] = STATE(552),
    [sym_namespace_get_internal] = STATE(552),
    [sym_pipe] = STATE(552),
    [sym_unary] = STATE(552),
    [sym_binary] = STATE(552),
    [sym_na] = STATE(552),
    [sym__expression] = STATE(552),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(552),
    [sym_string] = STATE(552),
    [anon_sym_SEMI] = ACTIONS(1259),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1261),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1261),
    [sym_next] = ACTIONS(1261),
    [sym_true] = ACTIONS(1261),
    [sym_false] = ACTIONS(1261),
    [sym_null] = ACTIONS(1261),
    [sym_inf] = ACTIONS(1261),
    [sym_nan] = ACTIONS(1261),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1259),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [181] = {
    [sym_function_definition] = STATE(802),
    [sym_lambda_function] = STATE(802),
    [sym_if] = STATE(802),
    [sym_while] = STATE(802),
    [sym_repeat] = STATE(802),
    [sym_for] = STATE(802),
    [sym_switch] = STATE(802),
    [sym_call] = STATE(802),
    [sym__assignment] = STATE(802),
    [sym_left_assignment] = STATE(802),
    [sym_left_assignment2] = STATE(802),
    [sym_equals_assignment] = STATE(802),
    [sym_super_assignment] = STATE(802),
    [sym_super_right_assignment] = STATE(802),
    [sym_right_assignment] = STATE(802),
    [sym_brace_list] = STATE(802),
    [sym_paren_list] = STATE(802),
    [sym_subset] = STATE(802),
    [sym_subset2] = STATE(802),
    [sym_dollar] = STATE(802),
    [sym_slot] = STATE(802),
    [sym_namespace_get] = STATE(802),
    [sym_namespace_get_internal] = STATE(802),
    [sym_pipe] = STATE(802),
    [sym_unary] = STATE(802),
    [sym_binary] = STATE(802),
    [sym_na] = STATE(802),
    [sym__expression] = STATE(802),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(802),
    [sym_string] = STATE(802),
    [anon_sym_SEMI] = ACTIONS(1263),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1265),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1265),
    [sym_next] = ACTIONS(1265),
    [sym_true] = ACTIONS(1265),
    [sym_false] = ACTIONS(1265),
    [sym_null] = ACTIONS(1265),
    [sym_inf] = ACTIONS(1265),
    [sym_nan] = ACTIONS(1265),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1263),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [182] = {
    [sym_function_definition] = STATE(610),
    [sym_lambda_function] = STATE(610),
    [sym_if] = STATE(610),
    [sym_while] = STATE(610),
    [sym_repeat] = STATE(610),
    [sym_for] = STATE(610),
    [sym_switch] = STATE(610),
    [sym_call] = STATE(610),
    [sym__assignment] = STATE(610),
    [sym_left_assignment] = STATE(610),
    [sym_left_assignment2] = STATE(610),
    [sym_equals_assignment] = STATE(610),
    [sym_super_assignment] = STATE(610),
    [sym_super_right_assignment] = STATE(610),
    [sym_right_assignment] = STATE(610),
    [sym_brace_list] = STATE(610),
    [sym_paren_list] = STATE(610),
    [sym_subset] = STATE(610),
    [sym_subset2] = STATE(610),
    [sym_dollar] = STATE(610),
    [sym_slot] = STATE(610),
    [sym_namespace_get] = STATE(610),
    [sym_namespace_get_internal] = STATE(610),
    [sym_pipe] = STATE(610),
    [sym_unary] = STATE(610),
    [sym_binary] = STATE(610),
    [sym_na] = STATE(610),
    [sym__expression] = STATE(610),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(610),
    [sym_string] = STATE(610),
    [anon_sym_SEMI] = ACTIONS(1267),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1269),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1269),
    [sym_next] = ACTIONS(1269),
    [sym_true] = ACTIONS(1269),
    [sym_false] = ACTIONS(1269),
    [sym_null] = ACTIONS(1269),
    [sym_inf] = ACTIONS(1269),
    [sym_nan] = ACTIONS(1269),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1267),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [183] = {
    [sym_function_definition] = STATE(553),
    [sym_lambda_function] = STATE(553),
    [sym_if] = STATE(553),
    [sym_while] = STATE(553),
    [sym_repeat] = STATE(553),
    [sym_for] = STATE(553),
    [sym_switch] = STATE(553),
    [sym_call] = STATE(553),
    [sym__assignment] = STATE(553),
    [sym_left_assignment] = STATE(553),
    [sym_left_assignment2] = STATE(553),
    [sym_equals_assignment] = STATE(553),
    [sym_super_assignment] = STATE(553),
    [sym_super_right_assignment] = STATE(553),
    [sym_right_assignment] = STATE(553),
    [sym_brace_list] = STATE(553),
    [sym_paren_list] = STATE(553),
    [sym_subset] = STATE(553),
    [sym_subset2] = STATE(553),
    [sym_dollar] = STATE(553),
    [sym_slot] = STATE(553),
    [sym_namespace_get] = STATE(553),
    [sym_namespace_get_internal] = STATE(553),
    [sym_pipe] = STATE(553),
    [sym_unary] = STATE(553),
    [sym_binary] = STATE(553),
    [sym_na] = STATE(553),
    [sym__expression] = STATE(553),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(553),
    [sym_string] = STATE(553),
    [anon_sym_SEMI] = ACTIONS(1271),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1273),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1273),
    [sym_next] = ACTIONS(1273),
    [sym_true] = ACTIONS(1273),
    [sym_false] = ACTIONS(1273),
    [sym_null] = ACTIONS(1273),
    [sym_inf] = ACTIONS(1273),
    [sym_nan] = ACTIONS(1273),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1271),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [184] = {
    [sym_function_definition] = STATE(554),
    [sym_lambda_function] = STATE(554),
    [sym_if] = STATE(554),
    [sym_while] = STATE(554),
    [sym_repeat] = STATE(554),
    [sym_for] = STATE(554),
    [sym_switch] = STATE(554),
    [sym_call] = STATE(554),
    [sym__assignment] = STATE(554),
    [sym_left_assignment] = STATE(554),
    [sym_left_assignment2] = STATE(554),
    [sym_equals_assignment] = STATE(554),
    [sym_super_assignment] = STATE(554),
    [sym_super_right_assignment] = STATE(554),
    [sym_right_assignment] = STATE(554),
    [sym_brace_list] = STATE(554),
    [sym_paren_list] = STATE(554),
    [sym_subset] = STATE(554),
    [sym_subset2] = STATE(554),
    [sym_dollar] = STATE(554),
    [sym_slot] = STATE(554),
    [sym_namespace_get] = STATE(554),
    [sym_namespace_get_internal] = STATE(554),
    [sym_pipe] = STATE(554),
    [sym_unary] = STATE(554),
    [sym_binary] = STATE(554),
    [sym_na] = STATE(554),
    [sym__expression] = STATE(554),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(554),
    [sym_string] = STATE(554),
    [anon_sym_SEMI] = ACTIONS(1275),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1277),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1277),
    [sym_next] = ACTIONS(1277),
    [sym_true] = ACTIONS(1277),
    [sym_false] = ACTIONS(1277),
    [sym_null] = ACTIONS(1277),
    [sym_inf] = ACTIONS(1277),
    [sym_nan] = ACTIONS(1277),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1275),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [185] = {
    [sym_function_definition] = STATE(555),
    [sym_lambda_function] = STATE(555),
    [sym_if] = STATE(555),
    [sym_while] = STATE(555),
    [sym_repeat] = STATE(555),
    [sym_for] = STATE(555),
    [sym_switch] = STATE(555),
    [sym_call] = STATE(555),
    [sym__assignment] = STATE(555),
    [sym_left_assignment] = STATE(555),
    [sym_left_assignment2] = STATE(555),
    [sym_equals_assignment] = STATE(555),
    [sym_super_assignment] = STATE(555),
    [sym_super_right_assignment] = STATE(555),
    [sym_right_assignment] = STATE(555),
    [sym_brace_list] = STATE(555),
    [sym_paren_list] = STATE(555),
    [sym_subset] = STATE(555),
    [sym_subset2] = STATE(555),
    [sym_dollar] = STATE(555),
    [sym_slot] = STATE(555),
    [sym_namespace_get] = STATE(555),
    [sym_namespace_get_internal] = STATE(555),
    [sym_pipe] = STATE(555),
    [sym_unary] = STATE(555),
    [sym_binary] = STATE(555),
    [sym_na] = STATE(555),
    [sym__expression] = STATE(555),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(555),
    [sym_string] = STATE(555),
    [anon_sym_SEMI] = ACTIONS(1279),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1281),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1281),
    [sym_next] = ACTIONS(1281),
    [sym_true] = ACTIONS(1281),
    [sym_false] = ACTIONS(1281),
    [sym_null] = ACTIONS(1281),
    [sym_inf] = ACTIONS(1281),
    [sym_nan] = ACTIONS(1281),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1279),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [186] = {
    [sym_function_definition] = STATE(570),
    [sym_lambda_function] = STATE(570),
    [sym_if] = STATE(570),
    [sym_while] = STATE(570),
    [sym_repeat] = STATE(570),
    [sym_for] = STATE(570),
    [sym_switch] = STATE(570),
    [sym_call] = STATE(570),
    [sym__assignment] = STATE(570),
    [sym_left_assignment] = STATE(570),
    [sym_left_assignment2] = STATE(570),
    [sym_equals_assignment] = STATE(570),
    [sym_super_assignment] = STATE(570),
    [sym_super_right_assignment] = STATE(570),
    [sym_right_assignment] = STATE(570),
    [sym_brace_list] = STATE(570),
    [sym_paren_list] = STATE(570),
    [sym_subset] = STATE(570),
    [sym_subset2] = STATE(570),
    [sym_dollar] = STATE(570),
    [sym_slot] = STATE(570),
    [sym_namespace_get] = STATE(570),
    [sym_namespace_get_internal] = STATE(570),
    [sym_pipe] = STATE(570),
    [sym_unary] = STATE(570),
    [sym_binary] = STATE(570),
    [sym_na] = STATE(570),
    [sym__expression] = STATE(570),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(570),
    [sym_string] = STATE(570),
    [anon_sym_SEMI] = ACTIONS(1283),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1285),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1285),
    [sym_next] = ACTIONS(1285),
    [sym_true] = ACTIONS(1285),
    [sym_false] = ACTIONS(1285),
    [sym_null] = ACTIONS(1285),
    [sym_inf] = ACTIONS(1285),
    [sym_nan] = ACTIONS(1285),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1283),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [187] = {
    [sym_function_definition] = STATE(556),
    [sym_lambda_function] = STATE(556),
    [sym_if] = STATE(556),
    [sym_while] = STATE(556),
    [sym_repeat] = STATE(556),
    [sym_for] = STATE(556),
    [sym_switch] = STATE(556),
    [sym_call] = STATE(556),
    [sym__assignment] = STATE(556),
    [sym_left_assignment] = STATE(556),
    [sym_left_assignment2] = STATE(556),
    [sym_equals_assignment] = STATE(556),
    [sym_super_assignment] = STATE(556),
    [sym_super_right_assignment] = STATE(556),
    [sym_right_assignment] = STATE(556),
    [sym_brace_list] = STATE(556),
    [sym_paren_list] = STATE(556),
    [sym_subset] = STATE(556),
    [sym_subset2] = STATE(556),
    [sym_dollar] = STATE(556),
    [sym_slot] = STATE(556),
    [sym_namespace_get] = STATE(556),
    [sym_namespace_get_internal] = STATE(556),
    [sym_pipe] = STATE(556),
    [sym_unary] = STATE(556),
    [sym_binary] = STATE(556),
    [sym_na] = STATE(556),
    [sym__expression] = STATE(556),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(556),
    [sym_string] = STATE(556),
    [anon_sym_SEMI] = ACTIONS(1287),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1289),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1289),
    [sym_next] = ACTIONS(1289),
    [sym_true] = ACTIONS(1289),
    [sym_false] = ACTIONS(1289),
    [sym_null] = ACTIONS(1289),
    [sym_inf] = ACTIONS(1289),
    [sym_nan] = ACTIONS(1289),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1287),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [188] = {
    [sym_function_definition] = STATE(557),
    [sym_lambda_function] = STATE(557),
    [sym_if] = STATE(557),
    [sym_while] = STATE(557),
    [sym_repeat] = STATE(557),
    [sym_for] = STATE(557),
    [sym_switch] = STATE(557),
    [sym_call] = STATE(557),
    [sym__assignment] = STATE(557),
    [sym_left_assignment] = STATE(557),
    [sym_left_assignment2] = STATE(557),
    [sym_equals_assignment] = STATE(557),
    [sym_super_assignment] = STATE(557),
    [sym_super_right_assignment] = STATE(557),
    [sym_right_assignment] = STATE(557),
    [sym_brace_list] = STATE(557),
    [sym_paren_list] = STATE(557),
    [sym_subset] = STATE(557),
    [sym_subset2] = STATE(557),
    [sym_dollar] = STATE(557),
    [sym_slot] = STATE(557),
    [sym_namespace_get] = STATE(557),
    [sym_namespace_get_internal] = STATE(557),
    [sym_pipe] = STATE(557),
    [sym_unary] = STATE(557),
    [sym_binary] = STATE(557),
    [sym_na] = STATE(557),
    [sym__expression] = STATE(557),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(557),
    [sym_string] = STATE(557),
    [anon_sym_SEMI] = ACTIONS(1291),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1293),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1293),
    [sym_next] = ACTIONS(1293),
    [sym_true] = ACTIONS(1293),
    [sym_false] = ACTIONS(1293),
    [sym_null] = ACTIONS(1293),
    [sym_inf] = ACTIONS(1293),
    [sym_nan] = ACTIONS(1293),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1291),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [189] = {
    [sym_function_definition] = STATE(558),
    [sym_lambda_function] = STATE(558),
    [sym_if] = STATE(558),
    [sym_while] = STATE(558),
    [sym_repeat] = STATE(558),
    [sym_for] = STATE(558),
    [sym_switch] = STATE(558),
    [sym_call] = STATE(558),
    [sym__assignment] = STATE(558),
    [sym_left_assignment] = STATE(558),
    [sym_left_assignment2] = STATE(558),
    [sym_equals_assignment] = STATE(558),
    [sym_super_assignment] = STATE(558),
    [sym_super_right_assignment] = STATE(558),
    [sym_right_assignment] = STATE(558),
    [sym_brace_list] = STATE(558),
    [sym_paren_list] = STATE(558),
    [sym_subset] = STATE(558),
    [sym_subset2] = STATE(558),
    [sym_dollar] = STATE(558),
    [sym_slot] = STATE(558),
    [sym_namespace_get] = STATE(558),
    [sym_namespace_get_internal] = STATE(558),
    [sym_pipe] = STATE(558),
    [sym_unary] = STATE(558),
    [sym_binary] = STATE(558),
    [sym_na] = STATE(558),
    [sym__expression] = STATE(558),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(558),
    [sym_string] = STATE(558),
    [anon_sym_SEMI] = ACTIONS(1295),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1297),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1297),
    [sym_next] = ACTIONS(1297),
    [sym_true] = ACTIONS(1297),
    [sym_false] = ACTIONS(1297),
    [sym_null] = ACTIONS(1297),
    [sym_inf] = ACTIONS(1297),
    [sym_nan] = ACTIONS(1297),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1295),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [190] = {
    [sym_function_definition] = STATE(559),
    [sym_lambda_function] = STATE(559),
    [sym_if] = STATE(559),
    [sym_while] = STATE(559),
    [sym_repeat] = STATE(559),
    [sym_for] = STATE(559),
    [sym_switch] = STATE(559),
    [sym_call] = STATE(559),
    [sym__assignment] = STATE(559),
    [sym_left_assignment] = STATE(559),
    [sym_left_assignment2] = STATE(559),
    [sym_equals_assignment] = STATE(559),
    [sym_super_assignment] = STATE(559),
    [sym_super_right_assignment] = STATE(559),
    [sym_right_assignment] = STATE(559),
    [sym_brace_list] = STATE(559),
    [sym_paren_list] = STATE(559),
    [sym_subset] = STATE(559),
    [sym_subset2] = STATE(559),
    [sym_dollar] = STATE(559),
    [sym_slot] = STATE(559),
    [sym_namespace_get] = STATE(559),
    [sym_namespace_get_internal] = STATE(559),
    [sym_pipe] = STATE(559),
    [sym_unary] = STATE(559),
    [sym_binary] = STATE(559),
    [sym_na] = STATE(559),
    [sym__expression] = STATE(559),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(559),
    [sym_string] = STATE(559),
    [anon_sym_SEMI] = ACTIONS(1299),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1301),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1301),
    [sym_next] = ACTIONS(1301),
    [sym_true] = ACTIONS(1301),
    [sym_false] = ACTIONS(1301),
    [sym_null] = ACTIONS(1301),
    [sym_inf] = ACTIONS(1301),
    [sym_nan] = ACTIONS(1301),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1299),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [191] = {
    [sym_function_definition] = STATE(560),
    [sym_lambda_function] = STATE(560),
    [sym_if] = STATE(560),
    [sym_while] = STATE(560),
    [sym_repeat] = STATE(560),
    [sym_for] = STATE(560),
    [sym_switch] = STATE(560),
    [sym_call] = STATE(560),
    [sym__assignment] = STATE(560),
    [sym_left_assignment] = STATE(560),
    [sym_left_assignment2] = STATE(560),
    [sym_equals_assignment] = STATE(560),
    [sym_super_assignment] = STATE(560),
    [sym_super_right_assignment] = STATE(560),
    [sym_right_assignment] = STATE(560),
    [sym_brace_list] = STATE(560),
    [sym_paren_list] = STATE(560),
    [sym_subset] = STATE(560),
    [sym_subset2] = STATE(560),
    [sym_dollar] = STATE(560),
    [sym_slot] = STATE(560),
    [sym_namespace_get] = STATE(560),
    [sym_namespace_get_internal] = STATE(560),
    [sym_pipe] = STATE(560),
    [sym_unary] = STATE(560),
    [sym_binary] = STATE(560),
    [sym_na] = STATE(560),
    [sym__expression] = STATE(560),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(560),
    [sym_string] = STATE(560),
    [anon_sym_SEMI] = ACTIONS(1303),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1305),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1305),
    [sym_next] = ACTIONS(1305),
    [sym_true] = ACTIONS(1305),
    [sym_false] = ACTIONS(1305),
    [sym_null] = ACTIONS(1305),
    [sym_inf] = ACTIONS(1305),
    [sym_nan] = ACTIONS(1305),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1303),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [192] = {
    [sym_function_definition] = STATE(912),
    [sym_lambda_function] = STATE(912),
    [sym_if] = STATE(912),
    [sym_while] = STATE(912),
    [sym_repeat] = STATE(912),
    [sym_for] = STATE(912),
    [sym_switch] = STATE(912),
    [sym_call] = STATE(912),
    [sym__assignment] = STATE(912),
    [sym_left_assignment] = STATE(912),
    [sym_left_assignment2] = STATE(912),
    [sym_equals_assignment] = STATE(912),
    [sym_super_assignment] = STATE(912),
    [sym_super_right_assignment] = STATE(912),
    [sym_right_assignment] = STATE(912),
    [sym_brace_list] = STATE(912),
    [sym_paren_list] = STATE(912),
    [sym_subset] = STATE(912),
    [sym_subset2] = STATE(912),
    [sym_dollar] = STATE(912),
    [sym_slot] = STATE(912),
    [sym_namespace_get] = STATE(912),
    [sym_namespace_get_internal] = STATE(912),
    [sym_pipe] = STATE(912),
    [sym_unary] = STATE(912),
    [sym_binary] = STATE(912),
    [sym_na] = STATE(912),
    [sym__expression] = STATE(912),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(912),
    [sym_string] = STATE(912),
    [anon_sym_SEMI] = ACTIONS(1307),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1309),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1309),
    [sym_next] = ACTIONS(1309),
    [sym_true] = ACTIONS(1309),
    [sym_false] = ACTIONS(1309),
    [sym_null] = ACTIONS(1309),
    [sym_inf] = ACTIONS(1309),
    [sym_nan] = ACTIONS(1309),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1307),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [193] = {
    [sym_function_definition] = STATE(482),
    [sym_lambda_function] = STATE(482),
    [sym_if] = STATE(482),
    [sym_while] = STATE(482),
    [sym_repeat] = STATE(482),
    [sym_for] = STATE(482),
    [sym_switch] = STATE(482),
    [sym_call] = STATE(482),
    [sym__assignment] = STATE(482),
    [sym_left_assignment] = STATE(482),
    [sym_left_assignment2] = STATE(482),
    [sym_equals_assignment] = STATE(482),
    [sym_super_assignment] = STATE(482),
    [sym_super_right_assignment] = STATE(482),
    [sym_right_assignment] = STATE(482),
    [sym_brace_list] = STATE(482),
    [sym_paren_list] = STATE(482),
    [sym_subset] = STATE(482),
    [sym_subset2] = STATE(482),
    [sym_dollar] = STATE(482),
    [sym_slot] = STATE(482),
    [sym_namespace_get] = STATE(482),
    [sym_namespace_get_internal] = STATE(482),
    [sym_pipe] = STATE(482),
    [sym_unary] = STATE(482),
    [sym_binary] = STATE(482),
    [sym_na] = STATE(482),
    [sym__expression] = STATE(482),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(482),
    [sym_string] = STATE(482),
    [anon_sym_SEMI] = ACTIONS(1311),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1313),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1313),
    [sym_next] = ACTIONS(1313),
    [sym_true] = ACTIONS(1313),
    [sym_false] = ACTIONS(1313),
    [sym_null] = ACTIONS(1313),
    [sym_inf] = ACTIONS(1313),
    [sym_nan] = ACTIONS(1313),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1311),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [194] = {
    [sym_function_definition] = STATE(900),
    [sym_lambda_function] = STATE(900),
    [sym_if] = STATE(900),
    [sym_while] = STATE(900),
    [sym_repeat] = STATE(900),
    [sym_for] = STATE(900),
    [sym_switch] = STATE(900),
    [sym_call] = STATE(900),
    [sym__assignment] = STATE(900),
    [sym_left_assignment] = STATE(900),
    [sym_left_assignment2] = STATE(900),
    [sym_equals_assignment] = STATE(900),
    [sym_super_assignment] = STATE(900),
    [sym_super_right_assignment] = STATE(900),
    [sym_right_assignment] = STATE(900),
    [sym_brace_list] = STATE(900),
    [sym_paren_list] = STATE(900),
    [sym_subset] = STATE(900),
    [sym_subset2] = STATE(900),
    [sym_dollar] = STATE(900),
    [sym_slot] = STATE(900),
    [sym_namespace_get] = STATE(900),
    [sym_namespace_get_internal] = STATE(900),
    [sym_pipe] = STATE(900),
    [sym_unary] = STATE(900),
    [sym_binary] = STATE(900),
    [sym_na] = STATE(900),
    [sym__expression] = STATE(900),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(900),
    [sym_string] = STATE(900),
    [anon_sym_SEMI] = ACTIONS(1315),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1317),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1317),
    [sym_next] = ACTIONS(1317),
    [sym_true] = ACTIONS(1317),
    [sym_false] = ACTIONS(1317),
    [sym_null] = ACTIONS(1317),
    [sym_inf] = ACTIONS(1317),
    [sym_nan] = ACTIONS(1317),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1315),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [195] = {
    [sym_function_definition] = STATE(512),
    [sym_lambda_function] = STATE(512),
    [sym_if] = STATE(512),
    [sym_while] = STATE(512),
    [sym_repeat] = STATE(512),
    [sym_for] = STATE(512),
    [sym_switch] = STATE(512),
    [sym_call] = STATE(512),
    [sym__assignment] = STATE(512),
    [sym_left_assignment] = STATE(512),
    [sym_left_assignment2] = STATE(512),
    [sym_equals_assignment] = STATE(512),
    [sym_super_assignment] = STATE(512),
    [sym_super_right_assignment] = STATE(512),
    [sym_right_assignment] = STATE(512),
    [sym_brace_list] = STATE(512),
    [sym_paren_list] = STATE(512),
    [sym_subset] = STATE(512),
    [sym_subset2] = STATE(512),
    [sym_dollar] = STATE(512),
    [sym_slot] = STATE(512),
    [sym_namespace_get] = STATE(512),
    [sym_namespace_get_internal] = STATE(512),
    [sym_pipe] = STATE(512),
    [sym_unary] = STATE(512),
    [sym_binary] = STATE(512),
    [sym_na] = STATE(512),
    [sym__expression] = STATE(512),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(512),
    [sym_string] = STATE(512),
    [anon_sym_SEMI] = ACTIONS(1319),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1321),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1321),
    [sym_next] = ACTIONS(1321),
    [sym_true] = ACTIONS(1321),
    [sym_false] = ACTIONS(1321),
    [sym_null] = ACTIONS(1321),
    [sym_inf] = ACTIONS(1321),
    [sym_nan] = ACTIONS(1321),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1319),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [196] = {
    [sym_function_definition] = STATE(505),
    [sym_lambda_function] = STATE(505),
    [sym_if] = STATE(505),
    [sym_while] = STATE(505),
    [sym_repeat] = STATE(505),
    [sym_for] = STATE(505),
    [sym_switch] = STATE(505),
    [sym_call] = STATE(505),
    [sym__assignment] = STATE(505),
    [sym_left_assignment] = STATE(505),
    [sym_left_assignment2] = STATE(505),
    [sym_equals_assignment] = STATE(505),
    [sym_super_assignment] = STATE(505),
    [sym_super_right_assignment] = STATE(505),
    [sym_right_assignment] = STATE(505),
    [sym_brace_list] = STATE(505),
    [sym_paren_list] = STATE(505),
    [sym_subset] = STATE(505),
    [sym_subset2] = STATE(505),
    [sym_dollar] = STATE(505),
    [sym_slot] = STATE(505),
    [sym_namespace_get] = STATE(505),
    [sym_namespace_get_internal] = STATE(505),
    [sym_pipe] = STATE(505),
    [sym_unary] = STATE(505),
    [sym_binary] = STATE(505),
    [sym_na] = STATE(505),
    [sym__expression] = STATE(505),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(505),
    [sym_string] = STATE(505),
    [anon_sym_SEMI] = ACTIONS(1323),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1325),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1325),
    [sym_next] = ACTIONS(1325),
    [sym_true] = ACTIONS(1325),
    [sym_false] = ACTIONS(1325),
    [sym_null] = ACTIONS(1325),
    [sym_inf] = ACTIONS(1325),
    [sym_nan] = ACTIONS(1325),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1323),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [197] = {
    [sym_function_definition] = STATE(501),
    [sym_lambda_function] = STATE(501),
    [sym_if] = STATE(501),
    [sym_while] = STATE(501),
    [sym_repeat] = STATE(501),
    [sym_for] = STATE(501),
    [sym_switch] = STATE(501),
    [sym_call] = STATE(501),
    [sym__assignment] = STATE(501),
    [sym_left_assignment] = STATE(501),
    [sym_left_assignment2] = STATE(501),
    [sym_equals_assignment] = STATE(501),
    [sym_super_assignment] = STATE(501),
    [sym_super_right_assignment] = STATE(501),
    [sym_right_assignment] = STATE(501),
    [sym_brace_list] = STATE(501),
    [sym_paren_list] = STATE(501),
    [sym_subset] = STATE(501),
    [sym_subset2] = STATE(501),
    [sym_dollar] = STATE(501),
    [sym_slot] = STATE(501),
    [sym_namespace_get] = STATE(501),
    [sym_namespace_get_internal] = STATE(501),
    [sym_pipe] = STATE(501),
    [sym_unary] = STATE(501),
    [sym_binary] = STATE(501),
    [sym_na] = STATE(501),
    [sym__expression] = STATE(501),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(501),
    [sym_string] = STATE(501),
    [anon_sym_SEMI] = ACTIONS(1327),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1329),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1329),
    [sym_next] = ACTIONS(1329),
    [sym_true] = ACTIONS(1329),
    [sym_false] = ACTIONS(1329),
    [sym_null] = ACTIONS(1329),
    [sym_inf] = ACTIONS(1329),
    [sym_nan] = ACTIONS(1329),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1327),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [198] = {
    [sym_function_definition] = STATE(500),
    [sym_lambda_function] = STATE(500),
    [sym_if] = STATE(500),
    [sym_while] = STATE(500),
    [sym_repeat] = STATE(500),
    [sym_for] = STATE(500),
    [sym_switch] = STATE(500),
    [sym_call] = STATE(500),
    [sym__assignment] = STATE(500),
    [sym_left_assignment] = STATE(500),
    [sym_left_assignment2] = STATE(500),
    [sym_equals_assignment] = STATE(500),
    [sym_super_assignment] = STATE(500),
    [sym_super_right_assignment] = STATE(500),
    [sym_right_assignment] = STATE(500),
    [sym_brace_list] = STATE(500),
    [sym_paren_list] = STATE(500),
    [sym_subset] = STATE(500),
    [sym_subset2] = STATE(500),
    [sym_dollar] = STATE(500),
    [sym_slot] = STATE(500),
    [sym_namespace_get] = STATE(500),
    [sym_namespace_get_internal] = STATE(500),
    [sym_pipe] = STATE(500),
    [sym_unary] = STATE(500),
    [sym_binary] = STATE(500),
    [sym_na] = STATE(500),
    [sym__expression] = STATE(500),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(500),
    [sym_string] = STATE(500),
    [anon_sym_SEMI] = ACTIONS(1331),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1333),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1333),
    [sym_next] = ACTIONS(1333),
    [sym_true] = ACTIONS(1333),
    [sym_false] = ACTIONS(1333),
    [sym_null] = ACTIONS(1333),
    [sym_inf] = ACTIONS(1333),
    [sym_nan] = ACTIONS(1333),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1331),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [199] = {
    [anon_sym_SEMI] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(659),
    [anon_sym_BSLASH] = ACTIONS(657),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_LPAREN] = ACTIONS(657),
    [anon_sym_RPAREN] = ACTIONS(657),
    [anon_sym_while] = ACTIONS(659),
    [anon_sym_repeat] = ACTIONS(659),
    [anon_sym_for] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(659),
    [anon_sym_COMMA] = ACTIONS(657),
    [anon_sym_EQ] = ACTIONS(659),
    [anon_sym_LBRACE] = ACTIONS(657),
    [anon_sym_LT_DASH] = ACTIONS(657),
    [anon_sym_COLON_EQ] = ACTIONS(657),
    [anon_sym_LT_LT_DASH] = ACTIONS(657),
    [anon_sym_DASH_GT_GT] = ACTIONS(657),
    [anon_sym_DASH_GT] = ACTIONS(659),
    [anon_sym_LBRACK] = ACTIONS(659),
    [anon_sym_RBRACK] = ACTIONS(657),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(657),
    [anon_sym_DOLLAR] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(657),
    [anon_sym_COLON_COLON] = ACTIONS(659),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(657),
    [sym_dots] = ACTIONS(659),
    [anon_sym_PIPE_GT] = ACTIONS(657),
    [anon_sym_DASH] = ACTIONS(659),
    [anon_sym_PLUS] = ACTIONS(657),
    [anon_sym_BANG] = ACTIONS(659),
    [anon_sym_TILDE] = ACTIONS(657),
    [anon_sym_STAR] = ACTIONS(657),
    [anon_sym_SLASH] = ACTIONS(657),
    [anon_sym_CARET] = ACTIONS(657),
    [anon_sym_LT] = ACTIONS(659),
    [anon_sym_GT] = ACTIONS(659),
    [anon_sym_LT_EQ] = ACTIONS(657),
    [anon_sym_GT_EQ] = ACTIONS(657),
    [anon_sym_EQ_EQ] = ACTIONS(657),
    [anon_sym_BANG_EQ] = ACTIONS(657),
    [anon_sym_PIPE_PIPE] = ACTIONS(657),
    [anon_sym_PIPE] = ACTIONS(659),
    [anon_sym_AMP_AMP] = ACTIONS(657),
    [anon_sym_AMP] = ACTIONS(659),
    [anon_sym_COLON] = ACTIONS(659),
    [sym_break] = ACTIONS(659),
    [sym_next] = ACTIONS(659),
    [sym_true] = ACTIONS(659),
    [sym_false] = ACTIONS(659),
    [sym_null] = ACTIONS(659),
    [sym_inf] = ACTIONS(659),
    [sym_nan] = ACTIONS(659),
    [anon_sym_NA] = ACTIONS(659),
    [anon_sym_NA_character_] = ACTIONS(659),
    [anon_sym_NA_complex_] = ACTIONS(659),
    [anon_sym_NA_integer_] = ACTIONS(659),
    [anon_sym_NA_real_] = ACTIONS(659),
    [aux_sym_identifier_token1] = ACTIONS(659),
    [anon_sym_BQUOTE] = ACTIONS(657),
    [sym_integer] = ACTIONS(657),
    [sym_float] = ACTIONS(659),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(657),
    [anon_sym_SQUOTE] = ACTIONS(657),
    [anon_sym_PERCENT] = ACTIONS(657),
  },
  [200] = {
    [sym_function_definition] = STATE(801),
    [sym_lambda_function] = STATE(801),
    [sym_if] = STATE(801),
    [sym_while] = STATE(801),
    [sym_repeat] = STATE(801),
    [sym_for] = STATE(801),
    [sym_switch] = STATE(801),
    [sym_call] = STATE(801),
    [sym__assignment] = STATE(801),
    [sym_left_assignment] = STATE(801),
    [sym_left_assignment2] = STATE(801),
    [sym_equals_assignment] = STATE(801),
    [sym_super_assignment] = STATE(801),
    [sym_super_right_assignment] = STATE(801),
    [sym_right_assignment] = STATE(801),
    [sym_brace_list] = STATE(801),
    [sym_paren_list] = STATE(801),
    [sym_subset] = STATE(801),
    [sym_subset2] = STATE(801),
    [sym_dollar] = STATE(801),
    [sym_slot] = STATE(801),
    [sym_namespace_get] = STATE(801),
    [sym_namespace_get_internal] = STATE(801),
    [sym_pipe] = STATE(801),
    [sym_unary] = STATE(801),
    [sym_binary] = STATE(801),
    [sym_na] = STATE(801),
    [sym__expression] = STATE(801),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(801),
    [sym_string] = STATE(801),
    [anon_sym_SEMI] = ACTIONS(1335),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1337),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1337),
    [sym_next] = ACTIONS(1337),
    [sym_true] = ACTIONS(1337),
    [sym_false] = ACTIONS(1337),
    [sym_null] = ACTIONS(1337),
    [sym_inf] = ACTIONS(1337),
    [sym_nan] = ACTIONS(1337),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1335),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [201] = {
    [sym_function_definition] = STATE(499),
    [sym_lambda_function] = STATE(499),
    [sym_if] = STATE(499),
    [sym_while] = STATE(499),
    [sym_repeat] = STATE(499),
    [sym_for] = STATE(499),
    [sym_switch] = STATE(499),
    [sym_call] = STATE(499),
    [sym__assignment] = STATE(499),
    [sym_left_assignment] = STATE(499),
    [sym_left_assignment2] = STATE(499),
    [sym_equals_assignment] = STATE(499),
    [sym_super_assignment] = STATE(499),
    [sym_super_right_assignment] = STATE(499),
    [sym_right_assignment] = STATE(499),
    [sym_brace_list] = STATE(499),
    [sym_paren_list] = STATE(499),
    [sym_subset] = STATE(499),
    [sym_subset2] = STATE(499),
    [sym_dollar] = STATE(499),
    [sym_slot] = STATE(499),
    [sym_namespace_get] = STATE(499),
    [sym_namespace_get_internal] = STATE(499),
    [sym_pipe] = STATE(499),
    [sym_unary] = STATE(499),
    [sym_binary] = STATE(499),
    [sym_na] = STATE(499),
    [sym__expression] = STATE(499),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(499),
    [sym_string] = STATE(499),
    [anon_sym_SEMI] = ACTIONS(1339),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1341),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1341),
    [sym_next] = ACTIONS(1341),
    [sym_true] = ACTIONS(1341),
    [sym_false] = ACTIONS(1341),
    [sym_null] = ACTIONS(1341),
    [sym_inf] = ACTIONS(1341),
    [sym_nan] = ACTIONS(1341),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1339),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [202] = {
    [sym_function_definition] = STATE(920),
    [sym_lambda_function] = STATE(920),
    [sym_if] = STATE(920),
    [sym_while] = STATE(920),
    [sym_repeat] = STATE(920),
    [sym_for] = STATE(920),
    [sym_switch] = STATE(920),
    [sym_call] = STATE(713),
    [sym__assignment] = STATE(920),
    [sym_left_assignment] = STATE(920),
    [sym_left_assignment2] = STATE(920),
    [sym_equals_assignment] = STATE(920),
    [sym_super_assignment] = STATE(920),
    [sym_super_right_assignment] = STATE(920),
    [sym_right_assignment] = STATE(920),
    [sym_brace_list] = STATE(920),
    [sym_paren_list] = STATE(920),
    [sym_subset] = STATE(920),
    [sym_subset2] = STATE(920),
    [sym_dollar] = STATE(920),
    [sym_slot] = STATE(920),
    [sym_namespace_get] = STATE(920),
    [sym_namespace_get_internal] = STATE(920),
    [sym_pipe] = STATE(920),
    [sym_unary] = STATE(920),
    [sym_binary] = STATE(920),
    [sym_na] = STATE(920),
    [sym__expression] = STATE(920),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(920),
    [sym_string] = STATE(920),
    [anon_sym_SEMI] = ACTIONS(1343),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1345),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1345),
    [sym_next] = ACTIONS(1345),
    [sym_true] = ACTIONS(1345),
    [sym_false] = ACTIONS(1345),
    [sym_null] = ACTIONS(1345),
    [sym_inf] = ACTIONS(1345),
    [sym_nan] = ACTIONS(1345),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1343),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [203] = {
    [sym_function_definition] = STATE(498),
    [sym_lambda_function] = STATE(498),
    [sym_if] = STATE(498),
    [sym_while] = STATE(498),
    [sym_repeat] = STATE(498),
    [sym_for] = STATE(498),
    [sym_switch] = STATE(498),
    [sym_call] = STATE(498),
    [sym__assignment] = STATE(498),
    [sym_left_assignment] = STATE(498),
    [sym_left_assignment2] = STATE(498),
    [sym_equals_assignment] = STATE(498),
    [sym_super_assignment] = STATE(498),
    [sym_super_right_assignment] = STATE(498),
    [sym_right_assignment] = STATE(498),
    [sym_brace_list] = STATE(498),
    [sym_paren_list] = STATE(498),
    [sym_subset] = STATE(498),
    [sym_subset2] = STATE(498),
    [sym_dollar] = STATE(498),
    [sym_slot] = STATE(498),
    [sym_namespace_get] = STATE(498),
    [sym_namespace_get_internal] = STATE(498),
    [sym_pipe] = STATE(498),
    [sym_unary] = STATE(498),
    [sym_binary] = STATE(498),
    [sym_na] = STATE(498),
    [sym__expression] = STATE(498),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(498),
    [sym_string] = STATE(498),
    [anon_sym_SEMI] = ACTIONS(1347),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1349),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1349),
    [sym_next] = ACTIONS(1349),
    [sym_true] = ACTIONS(1349),
    [sym_false] = ACTIONS(1349),
    [sym_null] = ACTIONS(1349),
    [sym_inf] = ACTIONS(1349),
    [sym_nan] = ACTIONS(1349),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1347),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [204] = {
    [sym_function_definition] = STATE(413),
    [sym_lambda_function] = STATE(413),
    [sym_if] = STATE(413),
    [sym_while] = STATE(413),
    [sym_repeat] = STATE(413),
    [sym_for] = STATE(413),
    [sym_switch] = STATE(413),
    [sym_call] = STATE(413),
    [sym__assignment] = STATE(413),
    [sym_left_assignment] = STATE(413),
    [sym_left_assignment2] = STATE(413),
    [sym_equals_assignment] = STATE(413),
    [sym_super_assignment] = STATE(413),
    [sym_super_right_assignment] = STATE(413),
    [sym_right_assignment] = STATE(413),
    [sym_brace_list] = STATE(413),
    [sym_paren_list] = STATE(413),
    [sym_subset] = STATE(413),
    [sym_subset2] = STATE(413),
    [sym_dollar] = STATE(413),
    [sym_slot] = STATE(413),
    [sym_namespace_get] = STATE(413),
    [sym_namespace_get_internal] = STATE(413),
    [sym_pipe] = STATE(413),
    [sym_unary] = STATE(413),
    [sym_binary] = STATE(413),
    [sym_na] = STATE(413),
    [sym__expression] = STATE(413),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(413),
    [sym_string] = STATE(413),
    [anon_sym_SEMI] = ACTIONS(1351),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1353),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1353),
    [sym_next] = ACTIONS(1353),
    [sym_true] = ACTIONS(1353),
    [sym_false] = ACTIONS(1353),
    [sym_null] = ACTIONS(1353),
    [sym_inf] = ACTIONS(1353),
    [sym_nan] = ACTIONS(1353),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1351),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [205] = {
    [sym_function_definition] = STATE(497),
    [sym_lambda_function] = STATE(497),
    [sym_if] = STATE(497),
    [sym_while] = STATE(497),
    [sym_repeat] = STATE(497),
    [sym_for] = STATE(497),
    [sym_switch] = STATE(497),
    [sym_call] = STATE(497),
    [sym__assignment] = STATE(497),
    [sym_left_assignment] = STATE(497),
    [sym_left_assignment2] = STATE(497),
    [sym_equals_assignment] = STATE(497),
    [sym_super_assignment] = STATE(497),
    [sym_super_right_assignment] = STATE(497),
    [sym_right_assignment] = STATE(497),
    [sym_brace_list] = STATE(497),
    [sym_paren_list] = STATE(497),
    [sym_subset] = STATE(497),
    [sym_subset2] = STATE(497),
    [sym_dollar] = STATE(497),
    [sym_slot] = STATE(497),
    [sym_namespace_get] = STATE(497),
    [sym_namespace_get_internal] = STATE(497),
    [sym_pipe] = STATE(497),
    [sym_unary] = STATE(497),
    [sym_binary] = STATE(497),
    [sym_na] = STATE(497),
    [sym__expression] = STATE(497),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(497),
    [sym_string] = STATE(497),
    [anon_sym_SEMI] = ACTIONS(1355),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1357),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1357),
    [sym_next] = ACTIONS(1357),
    [sym_true] = ACTIONS(1357),
    [sym_false] = ACTIONS(1357),
    [sym_null] = ACTIONS(1357),
    [sym_inf] = ACTIONS(1357),
    [sym_nan] = ACTIONS(1357),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1355),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [206] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1359),
    [anon_sym_function] = ACTIONS(1361),
    [anon_sym_BSLASH] = ACTIONS(1359),
    [anon_sym_if] = ACTIONS(1361),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1359),
    [anon_sym_else] = ACTIONS(1361),
    [anon_sym_while] = ACTIONS(1361),
    [anon_sym_repeat] = ACTIONS(1361),
    [anon_sym_for] = ACTIONS(1361),
    [anon_sym_switch] = ACTIONS(1361),
    [anon_sym_COMMA] = ACTIONS(1359),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(1359),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1359),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1361),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1361),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1361),
    [sym_next] = ACTIONS(1361),
    [sym_true] = ACTIONS(1361),
    [sym_false] = ACTIONS(1361),
    [sym_null] = ACTIONS(1361),
    [sym_inf] = ACTIONS(1361),
    [sym_nan] = ACTIONS(1361),
    [anon_sym_NA] = ACTIONS(1361),
    [anon_sym_NA_character_] = ACTIONS(1361),
    [anon_sym_NA_complex_] = ACTIONS(1361),
    [anon_sym_NA_integer_] = ACTIONS(1361),
    [anon_sym_NA_real_] = ACTIONS(1361),
    [aux_sym_identifier_token1] = ACTIONS(1361),
    [anon_sym_BQUOTE] = ACTIONS(1359),
    [sym_integer] = ACTIONS(1359),
    [sym_float] = ACTIONS(1361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1359),
    [anon_sym_SQUOTE] = ACTIONS(1359),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [207] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1363),
    [anon_sym_function] = ACTIONS(1365),
    [anon_sym_BSLASH] = ACTIONS(1363),
    [anon_sym_if] = ACTIONS(1365),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1363),
    [anon_sym_else] = ACTIONS(1365),
    [anon_sym_while] = ACTIONS(1365),
    [anon_sym_repeat] = ACTIONS(1365),
    [anon_sym_for] = ACTIONS(1365),
    [anon_sym_switch] = ACTIONS(1365),
    [anon_sym_COMMA] = ACTIONS(1363),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(1363),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1363),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1365),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1365),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1365),
    [sym_next] = ACTIONS(1365),
    [sym_true] = ACTIONS(1365),
    [sym_false] = ACTIONS(1365),
    [sym_null] = ACTIONS(1365),
    [sym_inf] = ACTIONS(1365),
    [sym_nan] = ACTIONS(1365),
    [anon_sym_NA] = ACTIONS(1365),
    [anon_sym_NA_character_] = ACTIONS(1365),
    [anon_sym_NA_complex_] = ACTIONS(1365),
    [anon_sym_NA_integer_] = ACTIONS(1365),
    [anon_sym_NA_real_] = ACTIONS(1365),
    [aux_sym_identifier_token1] = ACTIONS(1365),
    [anon_sym_BQUOTE] = ACTIONS(1363),
    [sym_integer] = ACTIONS(1363),
    [sym_float] = ACTIONS(1365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1363),
    [anon_sym_SQUOTE] = ACTIONS(1363),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [208] = {
    [sym_function_definition] = STATE(495),
    [sym_lambda_function] = STATE(495),
    [sym_if] = STATE(495),
    [sym_while] = STATE(495),
    [sym_repeat] = STATE(495),
    [sym_for] = STATE(495),
    [sym_switch] = STATE(495),
    [sym_call] = STATE(495),
    [sym__assignment] = STATE(495),
    [sym_left_assignment] = STATE(495),
    [sym_left_assignment2] = STATE(495),
    [sym_equals_assignment] = STATE(495),
    [sym_super_assignment] = STATE(495),
    [sym_super_right_assignment] = STATE(495),
    [sym_right_assignment] = STATE(495),
    [sym_brace_list] = STATE(495),
    [sym_paren_list] = STATE(495),
    [sym_subset] = STATE(495),
    [sym_subset2] = STATE(495),
    [sym_dollar] = STATE(495),
    [sym_slot] = STATE(495),
    [sym_namespace_get] = STATE(495),
    [sym_namespace_get_internal] = STATE(495),
    [sym_pipe] = STATE(495),
    [sym_unary] = STATE(495),
    [sym_binary] = STATE(495),
    [sym_na] = STATE(495),
    [sym__expression] = STATE(495),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(495),
    [sym_string] = STATE(495),
    [anon_sym_SEMI] = ACTIONS(1367),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1369),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1369),
    [sym_next] = ACTIONS(1369),
    [sym_true] = ACTIONS(1369),
    [sym_false] = ACTIONS(1369),
    [sym_null] = ACTIONS(1369),
    [sym_inf] = ACTIONS(1369),
    [sym_nan] = ACTIONS(1369),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1367),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [209] = {
    [sym_function_definition] = STATE(206),
    [sym_lambda_function] = STATE(206),
    [sym_if] = STATE(206),
    [sym_while] = STATE(206),
    [sym_repeat] = STATE(206),
    [sym_for] = STATE(206),
    [sym_switch] = STATE(206),
    [sym_call] = STATE(206),
    [sym__assignment] = STATE(206),
    [sym_left_assignment] = STATE(206),
    [sym_left_assignment2] = STATE(206),
    [sym_equals_assignment] = STATE(206),
    [sym_super_assignment] = STATE(206),
    [sym_super_right_assignment] = STATE(206),
    [sym_right_assignment] = STATE(206),
    [sym_brace_list] = STATE(206),
    [sym_paren_list] = STATE(206),
    [sym_subset] = STATE(206),
    [sym_subset2] = STATE(206),
    [sym_dollar] = STATE(206),
    [sym_slot] = STATE(206),
    [sym_namespace_get] = STATE(206),
    [sym_namespace_get_internal] = STATE(206),
    [sym_pipe] = STATE(206),
    [sym_unary] = STATE(206),
    [sym_binary] = STATE(206),
    [sym_na] = STATE(206),
    [sym__expression] = STATE(206),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(206),
    [sym_string] = STATE(206),
    [anon_sym_SEMI] = ACTIONS(1371),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1373),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1373),
    [sym_next] = ACTIONS(1373),
    [sym_true] = ACTIONS(1373),
    [sym_false] = ACTIONS(1373),
    [sym_null] = ACTIONS(1373),
    [sym_inf] = ACTIONS(1373),
    [sym_nan] = ACTIONS(1373),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1371),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [210] = {
    [sym_function_definition] = STATE(207),
    [sym_lambda_function] = STATE(207),
    [sym_if] = STATE(207),
    [sym_while] = STATE(207),
    [sym_repeat] = STATE(207),
    [sym_for] = STATE(207),
    [sym_switch] = STATE(207),
    [sym_call] = STATE(207),
    [sym__assignment] = STATE(207),
    [sym_left_assignment] = STATE(207),
    [sym_left_assignment2] = STATE(207),
    [sym_equals_assignment] = STATE(207),
    [sym_super_assignment] = STATE(207),
    [sym_super_right_assignment] = STATE(207),
    [sym_right_assignment] = STATE(207),
    [sym_brace_list] = STATE(207),
    [sym_paren_list] = STATE(207),
    [sym_subset] = STATE(207),
    [sym_subset2] = STATE(207),
    [sym_dollar] = STATE(207),
    [sym_slot] = STATE(207),
    [sym_namespace_get] = STATE(207),
    [sym_namespace_get_internal] = STATE(207),
    [sym_pipe] = STATE(207),
    [sym_unary] = STATE(207),
    [sym_binary] = STATE(207),
    [sym_na] = STATE(207),
    [sym__expression] = STATE(207),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(207),
    [sym_string] = STATE(207),
    [anon_sym_SEMI] = ACTIONS(1375),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1377),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1377),
    [sym_next] = ACTIONS(1377),
    [sym_true] = ACTIONS(1377),
    [sym_false] = ACTIONS(1377),
    [sym_null] = ACTIONS(1377),
    [sym_inf] = ACTIONS(1377),
    [sym_nan] = ACTIONS(1377),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1375),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [211] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1379),
    [anon_sym_function] = ACTIONS(1381),
    [anon_sym_BSLASH] = ACTIONS(1379),
    [anon_sym_if] = ACTIONS(1381),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1379),
    [anon_sym_else] = ACTIONS(1381),
    [anon_sym_while] = ACTIONS(1381),
    [anon_sym_repeat] = ACTIONS(1381),
    [anon_sym_for] = ACTIONS(1381),
    [anon_sym_switch] = ACTIONS(1381),
    [anon_sym_COMMA] = ACTIONS(1379),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(1379),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1379),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1381),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1381),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1381),
    [sym_next] = ACTIONS(1381),
    [sym_true] = ACTIONS(1381),
    [sym_false] = ACTIONS(1381),
    [sym_null] = ACTIONS(1381),
    [sym_inf] = ACTIONS(1381),
    [sym_nan] = ACTIONS(1381),
    [anon_sym_NA] = ACTIONS(1381),
    [anon_sym_NA_character_] = ACTIONS(1381),
    [anon_sym_NA_complex_] = ACTIONS(1381),
    [anon_sym_NA_integer_] = ACTIONS(1381),
    [anon_sym_NA_real_] = ACTIONS(1381),
    [aux_sym_identifier_token1] = ACTIONS(1381),
    [anon_sym_BQUOTE] = ACTIONS(1379),
    [sym_integer] = ACTIONS(1379),
    [sym_float] = ACTIONS(1381),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1379),
    [anon_sym_SQUOTE] = ACTIONS(1379),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [212] = {
    [sym_function_definition] = STATE(494),
    [sym_lambda_function] = STATE(494),
    [sym_if] = STATE(494),
    [sym_while] = STATE(494),
    [sym_repeat] = STATE(494),
    [sym_for] = STATE(494),
    [sym_switch] = STATE(494),
    [sym_call] = STATE(494),
    [sym__assignment] = STATE(494),
    [sym_left_assignment] = STATE(494),
    [sym_left_assignment2] = STATE(494),
    [sym_equals_assignment] = STATE(494),
    [sym_super_assignment] = STATE(494),
    [sym_super_right_assignment] = STATE(494),
    [sym_right_assignment] = STATE(494),
    [sym_brace_list] = STATE(494),
    [sym_paren_list] = STATE(494),
    [sym_subset] = STATE(494),
    [sym_subset2] = STATE(494),
    [sym_dollar] = STATE(494),
    [sym_slot] = STATE(494),
    [sym_namespace_get] = STATE(494),
    [sym_namespace_get_internal] = STATE(494),
    [sym_pipe] = STATE(494),
    [sym_unary] = STATE(494),
    [sym_binary] = STATE(494),
    [sym_na] = STATE(494),
    [sym__expression] = STATE(494),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(494),
    [sym_string] = STATE(494),
    [anon_sym_SEMI] = ACTIONS(1383),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1385),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1385),
    [sym_next] = ACTIONS(1385),
    [sym_true] = ACTIONS(1385),
    [sym_false] = ACTIONS(1385),
    [sym_null] = ACTIONS(1385),
    [sym_inf] = ACTIONS(1385),
    [sym_nan] = ACTIONS(1385),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1383),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [213] = {
    [sym_function_definition] = STATE(493),
    [sym_lambda_function] = STATE(493),
    [sym_if] = STATE(493),
    [sym_while] = STATE(493),
    [sym_repeat] = STATE(493),
    [sym_for] = STATE(493),
    [sym_switch] = STATE(493),
    [sym_call] = STATE(493),
    [sym__assignment] = STATE(493),
    [sym_left_assignment] = STATE(493),
    [sym_left_assignment2] = STATE(493),
    [sym_equals_assignment] = STATE(493),
    [sym_super_assignment] = STATE(493),
    [sym_super_right_assignment] = STATE(493),
    [sym_right_assignment] = STATE(493),
    [sym_brace_list] = STATE(493),
    [sym_paren_list] = STATE(493),
    [sym_subset] = STATE(493),
    [sym_subset2] = STATE(493),
    [sym_dollar] = STATE(493),
    [sym_slot] = STATE(493),
    [sym_namespace_get] = STATE(493),
    [sym_namespace_get_internal] = STATE(493),
    [sym_pipe] = STATE(493),
    [sym_unary] = STATE(493),
    [sym_binary] = STATE(493),
    [sym_na] = STATE(493),
    [sym__expression] = STATE(493),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(493),
    [sym_string] = STATE(493),
    [anon_sym_SEMI] = ACTIONS(1387),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1389),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1389),
    [sym_next] = ACTIONS(1389),
    [sym_true] = ACTIONS(1389),
    [sym_false] = ACTIONS(1389),
    [sym_null] = ACTIONS(1389),
    [sym_inf] = ACTIONS(1389),
    [sym_nan] = ACTIONS(1389),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1387),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [214] = {
    [sym_function_definition] = STATE(492),
    [sym_lambda_function] = STATE(492),
    [sym_if] = STATE(492),
    [sym_while] = STATE(492),
    [sym_repeat] = STATE(492),
    [sym_for] = STATE(492),
    [sym_switch] = STATE(492),
    [sym_call] = STATE(492),
    [sym__assignment] = STATE(492),
    [sym_left_assignment] = STATE(492),
    [sym_left_assignment2] = STATE(492),
    [sym_equals_assignment] = STATE(492),
    [sym_super_assignment] = STATE(492),
    [sym_super_right_assignment] = STATE(492),
    [sym_right_assignment] = STATE(492),
    [sym_brace_list] = STATE(492),
    [sym_paren_list] = STATE(492),
    [sym_subset] = STATE(492),
    [sym_subset2] = STATE(492),
    [sym_dollar] = STATE(492),
    [sym_slot] = STATE(492),
    [sym_namespace_get] = STATE(492),
    [sym_namespace_get_internal] = STATE(492),
    [sym_pipe] = STATE(492),
    [sym_unary] = STATE(492),
    [sym_binary] = STATE(492),
    [sym_na] = STATE(492),
    [sym__expression] = STATE(492),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(492),
    [sym_string] = STATE(492),
    [anon_sym_SEMI] = ACTIONS(1391),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1393),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1393),
    [sym_next] = ACTIONS(1393),
    [sym_true] = ACTIONS(1393),
    [sym_false] = ACTIONS(1393),
    [sym_null] = ACTIONS(1393),
    [sym_inf] = ACTIONS(1393),
    [sym_nan] = ACTIONS(1393),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1391),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [215] = {
    [sym_function_definition] = STATE(211),
    [sym_lambda_function] = STATE(211),
    [sym_if] = STATE(211),
    [sym_while] = STATE(211),
    [sym_repeat] = STATE(211),
    [sym_for] = STATE(211),
    [sym_switch] = STATE(211),
    [sym_call] = STATE(211),
    [sym__assignment] = STATE(211),
    [sym_left_assignment] = STATE(211),
    [sym_left_assignment2] = STATE(211),
    [sym_equals_assignment] = STATE(211),
    [sym_super_assignment] = STATE(211),
    [sym_super_right_assignment] = STATE(211),
    [sym_right_assignment] = STATE(211),
    [sym_brace_list] = STATE(211),
    [sym_paren_list] = STATE(211),
    [sym_subset] = STATE(211),
    [sym_subset2] = STATE(211),
    [sym_dollar] = STATE(211),
    [sym_slot] = STATE(211),
    [sym_namespace_get] = STATE(211),
    [sym_namespace_get_internal] = STATE(211),
    [sym_pipe] = STATE(211),
    [sym_unary] = STATE(211),
    [sym_binary] = STATE(211),
    [sym_na] = STATE(211),
    [sym__expression] = STATE(211),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(211),
    [sym_string] = STATE(211),
    [anon_sym_SEMI] = ACTIONS(1395),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1397),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1397),
    [sym_next] = ACTIONS(1397),
    [sym_true] = ACTIONS(1397),
    [sym_false] = ACTIONS(1397),
    [sym_null] = ACTIONS(1397),
    [sym_inf] = ACTIONS(1397),
    [sym_nan] = ACTIONS(1397),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1395),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [216] = {
    [sym_function_definition] = STATE(491),
    [sym_lambda_function] = STATE(491),
    [sym_if] = STATE(491),
    [sym_while] = STATE(491),
    [sym_repeat] = STATE(491),
    [sym_for] = STATE(491),
    [sym_switch] = STATE(491),
    [sym_call] = STATE(491),
    [sym__assignment] = STATE(491),
    [sym_left_assignment] = STATE(491),
    [sym_left_assignment2] = STATE(491),
    [sym_equals_assignment] = STATE(491),
    [sym_super_assignment] = STATE(491),
    [sym_super_right_assignment] = STATE(491),
    [sym_right_assignment] = STATE(491),
    [sym_brace_list] = STATE(491),
    [sym_paren_list] = STATE(491),
    [sym_subset] = STATE(491),
    [sym_subset2] = STATE(491),
    [sym_dollar] = STATE(491),
    [sym_slot] = STATE(491),
    [sym_namespace_get] = STATE(491),
    [sym_namespace_get_internal] = STATE(491),
    [sym_pipe] = STATE(491),
    [sym_unary] = STATE(491),
    [sym_binary] = STATE(491),
    [sym_na] = STATE(491),
    [sym__expression] = STATE(491),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(491),
    [sym_string] = STATE(491),
    [anon_sym_SEMI] = ACTIONS(1399),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1401),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1401),
    [sym_next] = ACTIONS(1401),
    [sym_true] = ACTIONS(1401),
    [sym_false] = ACTIONS(1401),
    [sym_null] = ACTIONS(1401),
    [sym_inf] = ACTIONS(1401),
    [sym_nan] = ACTIONS(1401),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1399),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [217] = {
    [sym_function_definition] = STATE(490),
    [sym_lambda_function] = STATE(490),
    [sym_if] = STATE(490),
    [sym_while] = STATE(490),
    [sym_repeat] = STATE(490),
    [sym_for] = STATE(490),
    [sym_switch] = STATE(490),
    [sym_call] = STATE(490),
    [sym__assignment] = STATE(490),
    [sym_left_assignment] = STATE(490),
    [sym_left_assignment2] = STATE(490),
    [sym_equals_assignment] = STATE(490),
    [sym_super_assignment] = STATE(490),
    [sym_super_right_assignment] = STATE(490),
    [sym_right_assignment] = STATE(490),
    [sym_brace_list] = STATE(490),
    [sym_paren_list] = STATE(490),
    [sym_subset] = STATE(490),
    [sym_subset2] = STATE(490),
    [sym_dollar] = STATE(490),
    [sym_slot] = STATE(490),
    [sym_namespace_get] = STATE(490),
    [sym_namespace_get_internal] = STATE(490),
    [sym_pipe] = STATE(490),
    [sym_unary] = STATE(490),
    [sym_binary] = STATE(490),
    [sym_na] = STATE(490),
    [sym__expression] = STATE(490),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(490),
    [sym_string] = STATE(490),
    [anon_sym_SEMI] = ACTIONS(1403),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1405),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1405),
    [sym_next] = ACTIONS(1405),
    [sym_true] = ACTIONS(1405),
    [sym_false] = ACTIONS(1405),
    [sym_null] = ACTIONS(1405),
    [sym_inf] = ACTIONS(1405),
    [sym_nan] = ACTIONS(1405),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1403),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [218] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(1409),
    [anon_sym_PLUS] = ACTIONS(1407),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(1407),
    [anon_sym_SLASH] = ACTIONS(1407),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(1409),
    [anon_sym_GT] = ACTIONS(1409),
    [anon_sym_LT_EQ] = ACTIONS(1407),
    [anon_sym_GT_EQ] = ACTIONS(1407),
    [anon_sym_EQ_EQ] = ACTIONS(1407),
    [anon_sym_BANG_EQ] = ACTIONS(1407),
    [anon_sym_PIPE_PIPE] = ACTIONS(1407),
    [anon_sym_PIPE] = ACTIONS(1409),
    [anon_sym_AMP_AMP] = ACTIONS(1407),
    [anon_sym_AMP] = ACTIONS(1409),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(1407),
  },
  [219] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(1409),
    [anon_sym_PLUS] = ACTIONS(1407),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(1407),
    [anon_sym_SLASH] = ACTIONS(1407),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(1409),
    [anon_sym_GT] = ACTIONS(1409),
    [anon_sym_LT_EQ] = ACTIONS(1407),
    [anon_sym_GT_EQ] = ACTIONS(1407),
    [anon_sym_EQ_EQ] = ACTIONS(1407),
    [anon_sym_BANG_EQ] = ACTIONS(1407),
    [anon_sym_PIPE_PIPE] = ACTIONS(1407),
    [anon_sym_PIPE] = ACTIONS(1409),
    [anon_sym_AMP_AMP] = ACTIONS(1407),
    [anon_sym_AMP] = ACTIONS(1409),
    [anon_sym_COLON] = ACTIONS(1409),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(1407),
  },
  [220] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(1407),
    [anon_sym_PIPE] = ACTIONS(1409),
    [anon_sym_AMP_AMP] = ACTIONS(1407),
    [anon_sym_AMP] = ACTIONS(1409),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [221] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(1407),
    [anon_sym_PIPE] = ACTIONS(1409),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [222] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(1409),
    [anon_sym_GT] = ACTIONS(1409),
    [anon_sym_LT_EQ] = ACTIONS(1407),
    [anon_sym_GT_EQ] = ACTIONS(1407),
    [anon_sym_EQ_EQ] = ACTIONS(1407),
    [anon_sym_BANG_EQ] = ACTIONS(1407),
    [anon_sym_PIPE_PIPE] = ACTIONS(1407),
    [anon_sym_PIPE] = ACTIONS(1409),
    [anon_sym_AMP_AMP] = ACTIONS(1407),
    [anon_sym_AMP] = ACTIONS(1409),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [223] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(1409),
    [anon_sym_PLUS] = ACTIONS(1407),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(1407),
    [anon_sym_SLASH] = ACTIONS(1407),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(1409),
    [anon_sym_GT] = ACTIONS(1409),
    [anon_sym_LT_EQ] = ACTIONS(1407),
    [anon_sym_GT_EQ] = ACTIONS(1407),
    [anon_sym_EQ_EQ] = ACTIONS(1407),
    [anon_sym_BANG_EQ] = ACTIONS(1407),
    [anon_sym_PIPE_PIPE] = ACTIONS(1407),
    [anon_sym_PIPE] = ACTIONS(1409),
    [anon_sym_AMP_AMP] = ACTIONS(1407),
    [anon_sym_AMP] = ACTIONS(1409),
    [anon_sym_COLON] = ACTIONS(1409),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(1407),
  },
  [224] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(1409),
    [anon_sym_PLUS] = ACTIONS(1407),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(1407),
    [anon_sym_SLASH] = ACTIONS(1407),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(1409),
    [anon_sym_GT] = ACTIONS(1409),
    [anon_sym_LT_EQ] = ACTIONS(1407),
    [anon_sym_GT_EQ] = ACTIONS(1407),
    [anon_sym_EQ_EQ] = ACTIONS(1407),
    [anon_sym_BANG_EQ] = ACTIONS(1407),
    [anon_sym_PIPE_PIPE] = ACTIONS(1407),
    [anon_sym_PIPE] = ACTIONS(1409),
    [anon_sym_AMP_AMP] = ACTIONS(1407),
    [anon_sym_AMP] = ACTIONS(1409),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [225] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [226] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_function] = ACTIONS(1409),
    [anon_sym_BSLASH] = ACTIONS(1407),
    [anon_sym_if] = ACTIONS(1409),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_else] = ACTIONS(1409),
    [anon_sym_while] = ACTIONS(1409),
    [anon_sym_repeat] = ACTIONS(1409),
    [anon_sym_for] = ACTIONS(1409),
    [anon_sym_switch] = ACTIONS(1409),
    [anon_sym_COMMA] = ACTIONS(1407),
    [anon_sym_EQ] = ACTIONS(1409),
    [anon_sym_LBRACE] = ACTIONS(1407),
    [anon_sym_LT_DASH] = ACTIONS(1407),
    [anon_sym_COLON_EQ] = ACTIONS(1407),
    [anon_sym_LT_LT_DASH] = ACTIONS(1407),
    [anon_sym_DASH_GT_GT] = ACTIONS(1407),
    [anon_sym_DASH_GT] = ACTIONS(1409),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1407),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1409),
    [anon_sym_PIPE_GT] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(1409),
    [anon_sym_PLUS] = ACTIONS(1407),
    [anon_sym_BANG] = ACTIONS(1409),
    [anon_sym_TILDE] = ACTIONS(1407),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(1409),
    [anon_sym_GT] = ACTIONS(1409),
    [anon_sym_LT_EQ] = ACTIONS(1407),
    [anon_sym_GT_EQ] = ACTIONS(1407),
    [anon_sym_EQ_EQ] = ACTIONS(1407),
    [anon_sym_BANG_EQ] = ACTIONS(1407),
    [anon_sym_PIPE_PIPE] = ACTIONS(1407),
    [anon_sym_PIPE] = ACTIONS(1409),
    [anon_sym_AMP_AMP] = ACTIONS(1407),
    [anon_sym_AMP] = ACTIONS(1409),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1409),
    [sym_next] = ACTIONS(1409),
    [sym_true] = ACTIONS(1409),
    [sym_false] = ACTIONS(1409),
    [sym_null] = ACTIONS(1409),
    [sym_inf] = ACTIONS(1409),
    [sym_nan] = ACTIONS(1409),
    [anon_sym_NA] = ACTIONS(1409),
    [anon_sym_NA_character_] = ACTIONS(1409),
    [anon_sym_NA_complex_] = ACTIONS(1409),
    [anon_sym_NA_integer_] = ACTIONS(1409),
    [anon_sym_NA_real_] = ACTIONS(1409),
    [aux_sym_identifier_token1] = ACTIONS(1409),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [sym_integer] = ACTIONS(1407),
    [sym_float] = ACTIONS(1409),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1407),
    [anon_sym_SQUOTE] = ACTIONS(1407),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [227] = {
    [sym_function_definition] = STATE(489),
    [sym_lambda_function] = STATE(489),
    [sym_if] = STATE(489),
    [sym_while] = STATE(489),
    [sym_repeat] = STATE(489),
    [sym_for] = STATE(489),
    [sym_switch] = STATE(489),
    [sym_call] = STATE(489),
    [sym__assignment] = STATE(489),
    [sym_left_assignment] = STATE(489),
    [sym_left_assignment2] = STATE(489),
    [sym_equals_assignment] = STATE(489),
    [sym_super_assignment] = STATE(489),
    [sym_super_right_assignment] = STATE(489),
    [sym_right_assignment] = STATE(489),
    [sym_brace_list] = STATE(489),
    [sym_paren_list] = STATE(489),
    [sym_subset] = STATE(489),
    [sym_subset2] = STATE(489),
    [sym_dollar] = STATE(489),
    [sym_slot] = STATE(489),
    [sym_namespace_get] = STATE(489),
    [sym_namespace_get_internal] = STATE(489),
    [sym_pipe] = STATE(489),
    [sym_unary] = STATE(489),
    [sym_binary] = STATE(489),
    [sym_na] = STATE(489),
    [sym__expression] = STATE(489),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(489),
    [sym_string] = STATE(489),
    [anon_sym_SEMI] = ACTIONS(1411),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1413),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1413),
    [sym_next] = ACTIONS(1413),
    [sym_true] = ACTIONS(1413),
    [sym_false] = ACTIONS(1413),
    [sym_null] = ACTIONS(1413),
    [sym_inf] = ACTIONS(1413),
    [sym_nan] = ACTIONS(1413),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1411),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [228] = {
    [sym_function_definition] = STATE(562),
    [sym_lambda_function] = STATE(562),
    [sym_if] = STATE(562),
    [sym_while] = STATE(562),
    [sym_repeat] = STATE(562),
    [sym_for] = STATE(562),
    [sym_switch] = STATE(562),
    [sym_call] = STATE(562),
    [sym__assignment] = STATE(562),
    [sym_left_assignment] = STATE(562),
    [sym_left_assignment2] = STATE(562),
    [sym_equals_assignment] = STATE(562),
    [sym_super_assignment] = STATE(562),
    [sym_super_right_assignment] = STATE(562),
    [sym_right_assignment] = STATE(562),
    [sym_brace_list] = STATE(562),
    [sym_paren_list] = STATE(562),
    [sym_subset] = STATE(562),
    [sym_subset2] = STATE(562),
    [sym_dollar] = STATE(562),
    [sym_slot] = STATE(562),
    [sym_namespace_get] = STATE(562),
    [sym_namespace_get_internal] = STATE(562),
    [sym_pipe] = STATE(562),
    [sym_unary] = STATE(562),
    [sym_binary] = STATE(562),
    [sym_na] = STATE(562),
    [sym__expression] = STATE(562),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(562),
    [sym_string] = STATE(562),
    [anon_sym_SEMI] = ACTIONS(1415),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1417),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1417),
    [sym_next] = ACTIONS(1417),
    [sym_true] = ACTIONS(1417),
    [sym_false] = ACTIONS(1417),
    [sym_null] = ACTIONS(1417),
    [sym_inf] = ACTIONS(1417),
    [sym_nan] = ACTIONS(1417),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1415),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [229] = {
    [sym_function_definition] = STATE(611),
    [sym_lambda_function] = STATE(611),
    [sym_if] = STATE(611),
    [sym_while] = STATE(611),
    [sym_repeat] = STATE(611),
    [sym_for] = STATE(611),
    [sym_switch] = STATE(611),
    [sym_call] = STATE(611),
    [sym__assignment] = STATE(611),
    [sym_left_assignment] = STATE(611),
    [sym_left_assignment2] = STATE(611),
    [sym_equals_assignment] = STATE(611),
    [sym_super_assignment] = STATE(611),
    [sym_super_right_assignment] = STATE(611),
    [sym_right_assignment] = STATE(611),
    [sym_brace_list] = STATE(611),
    [sym_paren_list] = STATE(611),
    [sym_subset] = STATE(611),
    [sym_subset2] = STATE(611),
    [sym_dollar] = STATE(611),
    [sym_slot] = STATE(611),
    [sym_namespace_get] = STATE(611),
    [sym_namespace_get_internal] = STATE(611),
    [sym_pipe] = STATE(611),
    [sym_unary] = STATE(611),
    [sym_binary] = STATE(611),
    [sym_na] = STATE(611),
    [sym__expression] = STATE(611),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(611),
    [sym_string] = STATE(611),
    [anon_sym_SEMI] = ACTIONS(1419),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1421),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1421),
    [sym_next] = ACTIONS(1421),
    [sym_true] = ACTIONS(1421),
    [sym_false] = ACTIONS(1421),
    [sym_null] = ACTIONS(1421),
    [sym_inf] = ACTIONS(1421),
    [sym_nan] = ACTIONS(1421),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1419),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [230] = {
    [sym_function_definition] = STATE(488),
    [sym_lambda_function] = STATE(488),
    [sym_if] = STATE(488),
    [sym_while] = STATE(488),
    [sym_repeat] = STATE(488),
    [sym_for] = STATE(488),
    [sym_switch] = STATE(488),
    [sym_call] = STATE(488),
    [sym__assignment] = STATE(488),
    [sym_left_assignment] = STATE(488),
    [sym_left_assignment2] = STATE(488),
    [sym_equals_assignment] = STATE(488),
    [sym_super_assignment] = STATE(488),
    [sym_super_right_assignment] = STATE(488),
    [sym_right_assignment] = STATE(488),
    [sym_brace_list] = STATE(488),
    [sym_paren_list] = STATE(488),
    [sym_subset] = STATE(488),
    [sym_subset2] = STATE(488),
    [sym_dollar] = STATE(488),
    [sym_slot] = STATE(488),
    [sym_namespace_get] = STATE(488),
    [sym_namespace_get_internal] = STATE(488),
    [sym_pipe] = STATE(488),
    [sym_unary] = STATE(488),
    [sym_binary] = STATE(488),
    [sym_na] = STATE(488),
    [sym__expression] = STATE(488),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(488),
    [sym_string] = STATE(488),
    [anon_sym_SEMI] = ACTIONS(1423),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1425),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1425),
    [sym_next] = ACTIONS(1425),
    [sym_true] = ACTIONS(1425),
    [sym_false] = ACTIONS(1425),
    [sym_null] = ACTIONS(1425),
    [sym_inf] = ACTIONS(1425),
    [sym_nan] = ACTIONS(1425),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1423),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [231] = {
    [sym_function_definition] = STATE(484),
    [sym_lambda_function] = STATE(484),
    [sym_if] = STATE(484),
    [sym_while] = STATE(484),
    [sym_repeat] = STATE(484),
    [sym_for] = STATE(484),
    [sym_switch] = STATE(484),
    [sym_call] = STATE(484),
    [sym__assignment] = STATE(484),
    [sym_left_assignment] = STATE(484),
    [sym_left_assignment2] = STATE(484),
    [sym_equals_assignment] = STATE(484),
    [sym_super_assignment] = STATE(484),
    [sym_super_right_assignment] = STATE(484),
    [sym_right_assignment] = STATE(484),
    [sym_brace_list] = STATE(484),
    [sym_paren_list] = STATE(484),
    [sym_subset] = STATE(484),
    [sym_subset2] = STATE(484),
    [sym_dollar] = STATE(484),
    [sym_slot] = STATE(484),
    [sym_namespace_get] = STATE(484),
    [sym_namespace_get_internal] = STATE(484),
    [sym_pipe] = STATE(484),
    [sym_unary] = STATE(484),
    [sym_binary] = STATE(484),
    [sym_na] = STATE(484),
    [sym__expression] = STATE(484),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(484),
    [sym_string] = STATE(484),
    [anon_sym_SEMI] = ACTIONS(1427),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1429),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1429),
    [sym_next] = ACTIONS(1429),
    [sym_true] = ACTIONS(1429),
    [sym_false] = ACTIONS(1429),
    [sym_null] = ACTIONS(1429),
    [sym_inf] = ACTIONS(1429),
    [sym_nan] = ACTIONS(1429),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1427),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [232] = {
    [sym_function_definition] = STATE(481),
    [sym_lambda_function] = STATE(481),
    [sym_if] = STATE(481),
    [sym_while] = STATE(481),
    [sym_repeat] = STATE(481),
    [sym_for] = STATE(481),
    [sym_switch] = STATE(481),
    [sym_call] = STATE(481),
    [sym__assignment] = STATE(481),
    [sym_left_assignment] = STATE(481),
    [sym_left_assignment2] = STATE(481),
    [sym_equals_assignment] = STATE(481),
    [sym_super_assignment] = STATE(481),
    [sym_super_right_assignment] = STATE(481),
    [sym_right_assignment] = STATE(481),
    [sym_brace_list] = STATE(481),
    [sym_paren_list] = STATE(481),
    [sym_subset] = STATE(481),
    [sym_subset2] = STATE(481),
    [sym_dollar] = STATE(481),
    [sym_slot] = STATE(481),
    [sym_namespace_get] = STATE(481),
    [sym_namespace_get_internal] = STATE(481),
    [sym_pipe] = STATE(481),
    [sym_unary] = STATE(481),
    [sym_binary] = STATE(481),
    [sym_na] = STATE(481),
    [sym__expression] = STATE(481),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(481),
    [sym_string] = STATE(481),
    [anon_sym_SEMI] = ACTIONS(1431),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1433),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1433),
    [sym_next] = ACTIONS(1433),
    [sym_true] = ACTIONS(1433),
    [sym_false] = ACTIONS(1433),
    [sym_null] = ACTIONS(1433),
    [sym_inf] = ACTIONS(1433),
    [sym_nan] = ACTIONS(1433),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1431),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [233] = {
    [sym_function_definition] = STATE(480),
    [sym_lambda_function] = STATE(480),
    [sym_if] = STATE(480),
    [sym_while] = STATE(480),
    [sym_repeat] = STATE(480),
    [sym_for] = STATE(480),
    [sym_switch] = STATE(480),
    [sym_call] = STATE(480),
    [sym__assignment] = STATE(480),
    [sym_left_assignment] = STATE(480),
    [sym_left_assignment2] = STATE(480),
    [sym_equals_assignment] = STATE(480),
    [sym_super_assignment] = STATE(480),
    [sym_super_right_assignment] = STATE(480),
    [sym_right_assignment] = STATE(480),
    [sym_brace_list] = STATE(480),
    [sym_paren_list] = STATE(480),
    [sym_subset] = STATE(480),
    [sym_subset2] = STATE(480),
    [sym_dollar] = STATE(480),
    [sym_slot] = STATE(480),
    [sym_namespace_get] = STATE(480),
    [sym_namespace_get_internal] = STATE(480),
    [sym_pipe] = STATE(480),
    [sym_unary] = STATE(480),
    [sym_binary] = STATE(480),
    [sym_na] = STATE(480),
    [sym__expression] = STATE(480),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(480),
    [sym_string] = STATE(480),
    [anon_sym_SEMI] = ACTIONS(1435),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1437),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1437),
    [sym_next] = ACTIONS(1437),
    [sym_true] = ACTIONS(1437),
    [sym_false] = ACTIONS(1437),
    [sym_null] = ACTIONS(1437),
    [sym_inf] = ACTIONS(1437),
    [sym_nan] = ACTIONS(1437),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1435),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [234] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(891),
    [anon_sym_function] = ACTIONS(893),
    [anon_sym_BSLASH] = ACTIONS(891),
    [anon_sym_if] = ACTIONS(893),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(891),
    [anon_sym_else] = ACTIONS(1439),
    [anon_sym_while] = ACTIONS(893),
    [anon_sym_repeat] = ACTIONS(893),
    [anon_sym_for] = ACTIONS(893),
    [anon_sym_switch] = ACTIONS(893),
    [anon_sym_COMMA] = ACTIONS(891),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(891),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(891),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(893),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(893),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(893),
    [sym_next] = ACTIONS(893),
    [sym_true] = ACTIONS(893),
    [sym_false] = ACTIONS(893),
    [sym_null] = ACTIONS(893),
    [sym_inf] = ACTIONS(893),
    [sym_nan] = ACTIONS(893),
    [anon_sym_NA] = ACTIONS(893),
    [anon_sym_NA_character_] = ACTIONS(893),
    [anon_sym_NA_complex_] = ACTIONS(893),
    [anon_sym_NA_integer_] = ACTIONS(893),
    [anon_sym_NA_real_] = ACTIONS(893),
    [aux_sym_identifier_token1] = ACTIONS(893),
    [anon_sym_BQUOTE] = ACTIONS(891),
    [sym_integer] = ACTIONS(891),
    [sym_float] = ACTIONS(893),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(891),
    [anon_sym_SQUOTE] = ACTIONS(891),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [235] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1441),
    [anon_sym_function] = ACTIONS(1443),
    [anon_sym_BSLASH] = ACTIONS(1441),
    [anon_sym_if] = ACTIONS(1443),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1441),
    [anon_sym_else] = ACTIONS(1443),
    [anon_sym_while] = ACTIONS(1443),
    [anon_sym_repeat] = ACTIONS(1443),
    [anon_sym_for] = ACTIONS(1443),
    [anon_sym_switch] = ACTIONS(1443),
    [anon_sym_COMMA] = ACTIONS(1441),
    [anon_sym_EQ] = ACTIONS(1443),
    [anon_sym_LBRACE] = ACTIONS(1441),
    [anon_sym_LT_DASH] = ACTIONS(1441),
    [anon_sym_COLON_EQ] = ACTIONS(1441),
    [anon_sym_LT_LT_DASH] = ACTIONS(1441),
    [anon_sym_DASH_GT_GT] = ACTIONS(1441),
    [anon_sym_DASH_GT] = ACTIONS(1443),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1441),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1443),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1443),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1443),
    [sym_next] = ACTIONS(1443),
    [sym_true] = ACTIONS(1443),
    [sym_false] = ACTIONS(1443),
    [sym_null] = ACTIONS(1443),
    [sym_inf] = ACTIONS(1443),
    [sym_nan] = ACTIONS(1443),
    [anon_sym_NA] = ACTIONS(1443),
    [anon_sym_NA_character_] = ACTIONS(1443),
    [anon_sym_NA_complex_] = ACTIONS(1443),
    [anon_sym_NA_integer_] = ACTIONS(1443),
    [anon_sym_NA_real_] = ACTIONS(1443),
    [aux_sym_identifier_token1] = ACTIONS(1443),
    [anon_sym_BQUOTE] = ACTIONS(1441),
    [sym_integer] = ACTIONS(1441),
    [sym_float] = ACTIONS(1443),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1441),
    [anon_sym_SQUOTE] = ACTIONS(1441),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [236] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1445),
    [anon_sym_function] = ACTIONS(1447),
    [anon_sym_BSLASH] = ACTIONS(1445),
    [anon_sym_if] = ACTIONS(1447),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1445),
    [anon_sym_else] = ACTIONS(1447),
    [anon_sym_while] = ACTIONS(1447),
    [anon_sym_repeat] = ACTIONS(1447),
    [anon_sym_for] = ACTIONS(1447),
    [anon_sym_switch] = ACTIONS(1447),
    [anon_sym_COMMA] = ACTIONS(1445),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(1445),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1445),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1447),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1447),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1447),
    [sym_next] = ACTIONS(1447),
    [sym_true] = ACTIONS(1447),
    [sym_false] = ACTIONS(1447),
    [sym_null] = ACTIONS(1447),
    [sym_inf] = ACTIONS(1447),
    [sym_nan] = ACTIONS(1447),
    [anon_sym_NA] = ACTIONS(1447),
    [anon_sym_NA_character_] = ACTIONS(1447),
    [anon_sym_NA_complex_] = ACTIONS(1447),
    [anon_sym_NA_integer_] = ACTIONS(1447),
    [anon_sym_NA_real_] = ACTIONS(1447),
    [aux_sym_identifier_token1] = ACTIONS(1447),
    [anon_sym_BQUOTE] = ACTIONS(1445),
    [sym_integer] = ACTIONS(1445),
    [sym_float] = ACTIONS(1447),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1445),
    [anon_sym_SQUOTE] = ACTIONS(1445),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [237] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(563),
    [anon_sym_SEMI] = ACTIONS(1449),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1451),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1451),
    [sym_next] = ACTIONS(1451),
    [sym_true] = ACTIONS(1451),
    [sym_false] = ACTIONS(1451),
    [sym_null] = ACTIONS(1451),
    [sym_inf] = ACTIONS(1451),
    [sym_nan] = ACTIONS(1451),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1449),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [238] = {
    [sym_function_definition] = STATE(564),
    [sym_lambda_function] = STATE(564),
    [sym_if] = STATE(564),
    [sym_while] = STATE(564),
    [sym_repeat] = STATE(564),
    [sym_for] = STATE(564),
    [sym_switch] = STATE(564),
    [sym_call] = STATE(564),
    [sym__assignment] = STATE(564),
    [sym_left_assignment] = STATE(564),
    [sym_left_assignment2] = STATE(564),
    [sym_equals_assignment] = STATE(564),
    [sym_super_assignment] = STATE(564),
    [sym_super_right_assignment] = STATE(564),
    [sym_right_assignment] = STATE(564),
    [sym_brace_list] = STATE(564),
    [sym_paren_list] = STATE(564),
    [sym_subset] = STATE(564),
    [sym_subset2] = STATE(564),
    [sym_dollar] = STATE(564),
    [sym_slot] = STATE(564),
    [sym_namespace_get] = STATE(564),
    [sym_namespace_get_internal] = STATE(564),
    [sym_pipe] = STATE(564),
    [sym_unary] = STATE(564),
    [sym_binary] = STATE(564),
    [sym_na] = STATE(564),
    [sym__expression] = STATE(564),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(564),
    [sym_string] = STATE(564),
    [anon_sym_SEMI] = ACTIONS(1453),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1455),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1455),
    [sym_next] = ACTIONS(1455),
    [sym_true] = ACTIONS(1455),
    [sym_false] = ACTIONS(1455),
    [sym_null] = ACTIONS(1455),
    [sym_inf] = ACTIONS(1455),
    [sym_nan] = ACTIONS(1455),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1453),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [239] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1457),
    [anon_sym_function] = ACTIONS(1459),
    [anon_sym_BSLASH] = ACTIONS(1457),
    [anon_sym_if] = ACTIONS(1459),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1457),
    [anon_sym_else] = ACTIONS(1459),
    [anon_sym_while] = ACTIONS(1459),
    [anon_sym_repeat] = ACTIONS(1459),
    [anon_sym_for] = ACTIONS(1459),
    [anon_sym_switch] = ACTIONS(1459),
    [anon_sym_COMMA] = ACTIONS(1457),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(1457),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1457),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1459),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1459),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1459),
    [sym_next] = ACTIONS(1459),
    [sym_true] = ACTIONS(1459),
    [sym_false] = ACTIONS(1459),
    [sym_null] = ACTIONS(1459),
    [sym_inf] = ACTIONS(1459),
    [sym_nan] = ACTIONS(1459),
    [anon_sym_NA] = ACTIONS(1459),
    [anon_sym_NA_character_] = ACTIONS(1459),
    [anon_sym_NA_complex_] = ACTIONS(1459),
    [anon_sym_NA_integer_] = ACTIONS(1459),
    [anon_sym_NA_real_] = ACTIONS(1459),
    [aux_sym_identifier_token1] = ACTIONS(1459),
    [anon_sym_BQUOTE] = ACTIONS(1457),
    [sym_integer] = ACTIONS(1457),
    [sym_float] = ACTIONS(1459),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1457),
    [anon_sym_SQUOTE] = ACTIONS(1457),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [240] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1461),
    [anon_sym_function] = ACTIONS(1463),
    [anon_sym_BSLASH] = ACTIONS(1461),
    [anon_sym_if] = ACTIONS(1463),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1461),
    [anon_sym_else] = ACTIONS(1463),
    [anon_sym_while] = ACTIONS(1463),
    [anon_sym_repeat] = ACTIONS(1463),
    [anon_sym_for] = ACTIONS(1463),
    [anon_sym_switch] = ACTIONS(1463),
    [anon_sym_COMMA] = ACTIONS(1461),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(1461),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1461),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1463),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1463),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1463),
    [sym_next] = ACTIONS(1463),
    [sym_true] = ACTIONS(1463),
    [sym_false] = ACTIONS(1463),
    [sym_null] = ACTIONS(1463),
    [sym_inf] = ACTIONS(1463),
    [sym_nan] = ACTIONS(1463),
    [anon_sym_NA] = ACTIONS(1463),
    [anon_sym_NA_character_] = ACTIONS(1463),
    [anon_sym_NA_complex_] = ACTIONS(1463),
    [anon_sym_NA_integer_] = ACTIONS(1463),
    [anon_sym_NA_real_] = ACTIONS(1463),
    [aux_sym_identifier_token1] = ACTIONS(1463),
    [anon_sym_BQUOTE] = ACTIONS(1461),
    [sym_integer] = ACTIONS(1461),
    [sym_float] = ACTIONS(1463),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1461),
    [anon_sym_SQUOTE] = ACTIONS(1461),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [241] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1465),
    [anon_sym_function] = ACTIONS(1467),
    [anon_sym_BSLASH] = ACTIONS(1465),
    [anon_sym_if] = ACTIONS(1467),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1465),
    [anon_sym_else] = ACTIONS(1467),
    [anon_sym_while] = ACTIONS(1467),
    [anon_sym_repeat] = ACTIONS(1467),
    [anon_sym_for] = ACTIONS(1467),
    [anon_sym_switch] = ACTIONS(1467),
    [anon_sym_COMMA] = ACTIONS(1465),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(1465),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1465),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1467),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1467),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1467),
    [sym_next] = ACTIONS(1467),
    [sym_true] = ACTIONS(1467),
    [sym_false] = ACTIONS(1467),
    [sym_null] = ACTIONS(1467),
    [sym_inf] = ACTIONS(1467),
    [sym_nan] = ACTIONS(1467),
    [anon_sym_NA] = ACTIONS(1467),
    [anon_sym_NA_character_] = ACTIONS(1467),
    [anon_sym_NA_complex_] = ACTIONS(1467),
    [anon_sym_NA_integer_] = ACTIONS(1467),
    [anon_sym_NA_real_] = ACTIONS(1467),
    [aux_sym_identifier_token1] = ACTIONS(1467),
    [anon_sym_BQUOTE] = ACTIONS(1465),
    [sym_integer] = ACTIONS(1465),
    [sym_float] = ACTIONS(1467),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1465),
    [anon_sym_SQUOTE] = ACTIONS(1465),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [242] = {
    [sym_function_definition] = STATE(578),
    [sym_lambda_function] = STATE(578),
    [sym_if] = STATE(578),
    [sym_while] = STATE(578),
    [sym_repeat] = STATE(578),
    [sym_for] = STATE(578),
    [sym_switch] = STATE(578),
    [sym_call] = STATE(578),
    [sym__assignment] = STATE(578),
    [sym_left_assignment] = STATE(578),
    [sym_left_assignment2] = STATE(578),
    [sym_equals_assignment] = STATE(578),
    [sym_super_assignment] = STATE(578),
    [sym_super_right_assignment] = STATE(578),
    [sym_right_assignment] = STATE(578),
    [sym_brace_list] = STATE(578),
    [sym_paren_list] = STATE(578),
    [sym_subset] = STATE(578),
    [sym_subset2] = STATE(578),
    [sym_dollar] = STATE(578),
    [sym_slot] = STATE(578),
    [sym_namespace_get] = STATE(578),
    [sym_namespace_get_internal] = STATE(578),
    [sym_pipe] = STATE(578),
    [sym_unary] = STATE(578),
    [sym_binary] = STATE(578),
    [sym_na] = STATE(578),
    [sym__expression] = STATE(578),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(578),
    [sym_string] = STATE(578),
    [anon_sym_SEMI] = ACTIONS(1469),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1471),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1471),
    [sym_next] = ACTIONS(1471),
    [sym_true] = ACTIONS(1471),
    [sym_false] = ACTIONS(1471),
    [sym_null] = ACTIONS(1471),
    [sym_inf] = ACTIONS(1471),
    [sym_nan] = ACTIONS(1471),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1469),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [243] = {
    [sym_function_definition] = STATE(577),
    [sym_lambda_function] = STATE(577),
    [sym_if] = STATE(577),
    [sym_while] = STATE(577),
    [sym_repeat] = STATE(577),
    [sym_for] = STATE(577),
    [sym_switch] = STATE(577),
    [sym_call] = STATE(577),
    [sym__assignment] = STATE(577),
    [sym_left_assignment] = STATE(577),
    [sym_left_assignment2] = STATE(577),
    [sym_equals_assignment] = STATE(577),
    [sym_super_assignment] = STATE(577),
    [sym_super_right_assignment] = STATE(577),
    [sym_right_assignment] = STATE(577),
    [sym_brace_list] = STATE(577),
    [sym_paren_list] = STATE(577),
    [sym_subset] = STATE(577),
    [sym_subset2] = STATE(577),
    [sym_dollar] = STATE(577),
    [sym_slot] = STATE(577),
    [sym_namespace_get] = STATE(577),
    [sym_namespace_get_internal] = STATE(577),
    [sym_pipe] = STATE(577),
    [sym_unary] = STATE(577),
    [sym_binary] = STATE(577),
    [sym_na] = STATE(577),
    [sym__expression] = STATE(577),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(577),
    [sym_string] = STATE(577),
    [anon_sym_SEMI] = ACTIONS(1473),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1475),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1475),
    [sym_next] = ACTIONS(1475),
    [sym_true] = ACTIONS(1475),
    [sym_false] = ACTIONS(1475),
    [sym_null] = ACTIONS(1475),
    [sym_inf] = ACTIONS(1475),
    [sym_nan] = ACTIONS(1475),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1473),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [244] = {
    [sym_function_definition] = STATE(576),
    [sym_lambda_function] = STATE(576),
    [sym_if] = STATE(576),
    [sym_while] = STATE(576),
    [sym_repeat] = STATE(576),
    [sym_for] = STATE(576),
    [sym_switch] = STATE(576),
    [sym_call] = STATE(576),
    [sym__assignment] = STATE(576),
    [sym_left_assignment] = STATE(576),
    [sym_left_assignment2] = STATE(576),
    [sym_equals_assignment] = STATE(576),
    [sym_super_assignment] = STATE(576),
    [sym_super_right_assignment] = STATE(576),
    [sym_right_assignment] = STATE(576),
    [sym_brace_list] = STATE(576),
    [sym_paren_list] = STATE(576),
    [sym_subset] = STATE(576),
    [sym_subset2] = STATE(576),
    [sym_dollar] = STATE(576),
    [sym_slot] = STATE(576),
    [sym_namespace_get] = STATE(576),
    [sym_namespace_get_internal] = STATE(576),
    [sym_pipe] = STATE(576),
    [sym_unary] = STATE(576),
    [sym_binary] = STATE(576),
    [sym_na] = STATE(576),
    [sym__expression] = STATE(576),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(576),
    [sym_string] = STATE(576),
    [anon_sym_SEMI] = ACTIONS(1477),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1479),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1479),
    [sym_next] = ACTIONS(1479),
    [sym_true] = ACTIONS(1479),
    [sym_false] = ACTIONS(1479),
    [sym_null] = ACTIONS(1479),
    [sym_inf] = ACTIONS(1479),
    [sym_nan] = ACTIONS(1479),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1477),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [245] = {
    [sym_function_definition] = STATE(575),
    [sym_lambda_function] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_repeat] = STATE(575),
    [sym_for] = STATE(575),
    [sym_switch] = STATE(575),
    [sym_call] = STATE(575),
    [sym__assignment] = STATE(575),
    [sym_left_assignment] = STATE(575),
    [sym_left_assignment2] = STATE(575),
    [sym_equals_assignment] = STATE(575),
    [sym_super_assignment] = STATE(575),
    [sym_super_right_assignment] = STATE(575),
    [sym_right_assignment] = STATE(575),
    [sym_brace_list] = STATE(575),
    [sym_paren_list] = STATE(575),
    [sym_subset] = STATE(575),
    [sym_subset2] = STATE(575),
    [sym_dollar] = STATE(575),
    [sym_slot] = STATE(575),
    [sym_namespace_get] = STATE(575),
    [sym_namespace_get_internal] = STATE(575),
    [sym_pipe] = STATE(575),
    [sym_unary] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_na] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(575),
    [sym_string] = STATE(575),
    [anon_sym_SEMI] = ACTIONS(1481),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1483),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1483),
    [sym_next] = ACTIONS(1483),
    [sym_true] = ACTIONS(1483),
    [sym_false] = ACTIONS(1483),
    [sym_null] = ACTIONS(1483),
    [sym_inf] = ACTIONS(1483),
    [sym_nan] = ACTIONS(1483),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1481),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [246] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1485),
    [anon_sym_function] = ACTIONS(1487),
    [anon_sym_BSLASH] = ACTIONS(1485),
    [anon_sym_if] = ACTIONS(1487),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1485),
    [anon_sym_else] = ACTIONS(1487),
    [anon_sym_while] = ACTIONS(1487),
    [anon_sym_repeat] = ACTIONS(1487),
    [anon_sym_for] = ACTIONS(1487),
    [anon_sym_switch] = ACTIONS(1487),
    [anon_sym_COMMA] = ACTIONS(1485),
    [anon_sym_EQ] = ACTIONS(899),
    [anon_sym_LBRACE] = ACTIONS(1485),
    [anon_sym_LT_DASH] = ACTIONS(901),
    [anon_sym_COLON_EQ] = ACTIONS(903),
    [anon_sym_LT_LT_DASH] = ACTIONS(905),
    [anon_sym_DASH_GT_GT] = ACTIONS(907),
    [anon_sym_DASH_GT] = ACTIONS(909),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1485),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1487),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1487),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1487),
    [sym_next] = ACTIONS(1487),
    [sym_true] = ACTIONS(1487),
    [sym_false] = ACTIONS(1487),
    [sym_null] = ACTIONS(1487),
    [sym_inf] = ACTIONS(1487),
    [sym_nan] = ACTIONS(1487),
    [anon_sym_NA] = ACTIONS(1487),
    [anon_sym_NA_character_] = ACTIONS(1487),
    [anon_sym_NA_complex_] = ACTIONS(1487),
    [anon_sym_NA_integer_] = ACTIONS(1487),
    [anon_sym_NA_real_] = ACTIONS(1487),
    [aux_sym_identifier_token1] = ACTIONS(1487),
    [anon_sym_BQUOTE] = ACTIONS(1485),
    [sym_integer] = ACTIONS(1485),
    [sym_float] = ACTIONS(1487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1485),
    [anon_sym_SQUOTE] = ACTIONS(1485),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [247] = {
    [sym_function_definition] = STATE(479),
    [sym_lambda_function] = STATE(479),
    [sym_if] = STATE(479),
    [sym_while] = STATE(479),
    [sym_repeat] = STATE(479),
    [sym_for] = STATE(479),
    [sym_switch] = STATE(479),
    [sym_call] = STATE(479),
    [sym__assignment] = STATE(479),
    [sym_left_assignment] = STATE(479),
    [sym_left_assignment2] = STATE(479),
    [sym_equals_assignment] = STATE(479),
    [sym_super_assignment] = STATE(479),
    [sym_super_right_assignment] = STATE(479),
    [sym_right_assignment] = STATE(479),
    [sym_brace_list] = STATE(479),
    [sym_paren_list] = STATE(479),
    [sym_subset] = STATE(479),
    [sym_subset2] = STATE(479),
    [sym_dollar] = STATE(479),
    [sym_slot] = STATE(479),
    [sym_namespace_get] = STATE(479),
    [sym_namespace_get_internal] = STATE(479),
    [sym_pipe] = STATE(479),
    [sym_unary] = STATE(479),
    [sym_binary] = STATE(479),
    [sym_na] = STATE(479),
    [sym__expression] = STATE(479),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(479),
    [sym_string] = STATE(479),
    [anon_sym_SEMI] = ACTIONS(1489),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1491),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1491),
    [sym_next] = ACTIONS(1491),
    [sym_true] = ACTIONS(1491),
    [sym_false] = ACTIONS(1491),
    [sym_null] = ACTIONS(1491),
    [sym_inf] = ACTIONS(1491),
    [sym_nan] = ACTIONS(1491),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1489),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [248] = {
    [sym_function_definition] = STATE(658),
    [sym_lambda_function] = STATE(658),
    [sym_if] = STATE(658),
    [sym_while] = STATE(658),
    [sym_repeat] = STATE(658),
    [sym_for] = STATE(658),
    [sym_switch] = STATE(658),
    [sym_call] = STATE(658),
    [sym__assignment] = STATE(658),
    [sym_left_assignment] = STATE(658),
    [sym_left_assignment2] = STATE(658),
    [sym_equals_assignment] = STATE(658),
    [sym_super_assignment] = STATE(658),
    [sym_super_right_assignment] = STATE(658),
    [sym_right_assignment] = STATE(658),
    [sym_brace_list] = STATE(658),
    [sym_paren_list] = STATE(658),
    [sym_subset] = STATE(658),
    [sym_subset2] = STATE(658),
    [sym_dollar] = STATE(658),
    [sym_slot] = STATE(658),
    [sym_namespace_get] = STATE(658),
    [sym_namespace_get_internal] = STATE(658),
    [sym_pipe] = STATE(658),
    [sym_unary] = STATE(658),
    [sym_binary] = STATE(658),
    [sym_na] = STATE(658),
    [sym__expression] = STATE(658),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(658),
    [sym_string] = STATE(658),
    [anon_sym_SEMI] = ACTIONS(1493),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1495),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1495),
    [sym_next] = ACTIONS(1495),
    [sym_true] = ACTIONS(1495),
    [sym_false] = ACTIONS(1495),
    [sym_null] = ACTIONS(1495),
    [sym_inf] = ACTIONS(1495),
    [sym_nan] = ACTIONS(1495),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1493),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [249] = {
    [anon_sym_LF] = ACTIONS(659),
    [anon_sym_SEMI] = ACTIONS(659),
    [anon_sym_function] = ACTIONS(659),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_LPAREN] = ACTIONS(659),
    [anon_sym_else] = ACTIONS(659),
    [anon_sym_while] = ACTIONS(659),
    [anon_sym_repeat] = ACTIONS(659),
    [anon_sym_for] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(659),
    [anon_sym_EQ] = ACTIONS(659),
    [anon_sym_LBRACE] = ACTIONS(659),
    [anon_sym_RBRACE] = ACTIONS(659),
    [anon_sym_LT_DASH] = ACTIONS(659),
    [anon_sym_COLON_EQ] = ACTIONS(659),
    [anon_sym_LT_LT_DASH] = ACTIONS(659),
    [anon_sym_DASH_GT_GT] = ACTIONS(659),
    [anon_sym_DASH_GT] = ACTIONS(659),
    [anon_sym_LBRACK] = ACTIONS(659),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(659),
    [anon_sym_DOLLAR] = ACTIONS(659),
    [anon_sym_AT] = ACTIONS(659),
    [anon_sym_COLON_COLON] = ACTIONS(659),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(659),
    [sym_dots] = ACTIONS(659),
    [anon_sym_PIPE_GT] = ACTIONS(659),
    [anon_sym_DASH] = ACTIONS(659),
    [anon_sym_PLUS] = ACTIONS(659),
    [anon_sym_BANG] = ACTIONS(659),
    [anon_sym_TILDE] = ACTIONS(659),
    [anon_sym_STAR] = ACTIONS(659),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_CARET] = ACTIONS(659),
    [anon_sym_LT] = ACTIONS(659),
    [anon_sym_GT] = ACTIONS(659),
    [anon_sym_LT_EQ] = ACTIONS(659),
    [anon_sym_GT_EQ] = ACTIONS(659),
    [anon_sym_EQ_EQ] = ACTIONS(659),
    [anon_sym_BANG_EQ] = ACTIONS(659),
    [anon_sym_PIPE_PIPE] = ACTIONS(659),
    [anon_sym_PIPE] = ACTIONS(659),
    [anon_sym_AMP_AMP] = ACTIONS(659),
    [anon_sym_AMP] = ACTIONS(659),
    [anon_sym_COLON] = ACTIONS(659),
    [sym_break] = ACTIONS(659),
    [sym_next] = ACTIONS(659),
    [sym_true] = ACTIONS(659),
    [sym_false] = ACTIONS(659),
    [sym_null] = ACTIONS(659),
    [sym_inf] = ACTIONS(659),
    [sym_nan] = ACTIONS(659),
    [anon_sym_NA] = ACTIONS(659),
    [anon_sym_NA_character_] = ACTIONS(659),
    [anon_sym_NA_complex_] = ACTIONS(659),
    [anon_sym_NA_integer_] = ACTIONS(659),
    [anon_sym_NA_real_] = ACTIONS(659),
    [aux_sym_identifier_token1] = ACTIONS(659),
    [anon_sym_BQUOTE] = ACTIONS(659),
    [sym_integer] = ACTIONS(659),
    [sym_float] = ACTIONS(659),
    [sym_comment] = ACTIONS(1497),
    [anon_sym_DQUOTE] = ACTIONS(659),
    [anon_sym_SQUOTE] = ACTIONS(659),
    [anon_sym_PERCENT] = ACTIONS(659),
  },
  [250] = {
    [sym_function_definition] = STATE(572),
    [sym_lambda_function] = STATE(572),
    [sym_if] = STATE(572),
    [sym_while] = STATE(572),
    [sym_repeat] = STATE(572),
    [sym_for] = STATE(572),
    [sym_switch] = STATE(572),
    [sym_call] = STATE(572),
    [sym__assignment] = STATE(572),
    [sym_left_assignment] = STATE(572),
    [sym_left_assignment2] = STATE(572),
    [sym_equals_assignment] = STATE(572),
    [sym_super_assignment] = STATE(572),
    [sym_super_right_assignment] = STATE(572),
    [sym_right_assignment] = STATE(572),
    [sym_brace_list] = STATE(572),
    [sym_paren_list] = STATE(572),
    [sym_subset] = STATE(572),
    [sym_subset2] = STATE(572),
    [sym_dollar] = STATE(572),
    [sym_slot] = STATE(572),
    [sym_namespace_get] = STATE(572),
    [sym_namespace_get_internal] = STATE(572),
    [sym_pipe] = STATE(572),
    [sym_unary] = STATE(572),
    [sym_binary] = STATE(572),
    [sym_na] = STATE(572),
    [sym__expression] = STATE(572),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(572),
    [sym_string] = STATE(572),
    [anon_sym_SEMI] = ACTIONS(1499),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1501),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1501),
    [sym_next] = ACTIONS(1501),
    [sym_true] = ACTIONS(1501),
    [sym_false] = ACTIONS(1501),
    [sym_null] = ACTIONS(1501),
    [sym_inf] = ACTIONS(1501),
    [sym_nan] = ACTIONS(1501),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1499),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [251] = {
    [sym_function_definition] = STATE(573),
    [sym_lambda_function] = STATE(573),
    [sym_if] = STATE(573),
    [sym_while] = STATE(573),
    [sym_repeat] = STATE(573),
    [sym_for] = STATE(573),
    [sym_switch] = STATE(573),
    [sym_call] = STATE(573),
    [sym__assignment] = STATE(573),
    [sym_left_assignment] = STATE(573),
    [sym_left_assignment2] = STATE(573),
    [sym_equals_assignment] = STATE(573),
    [sym_super_assignment] = STATE(573),
    [sym_super_right_assignment] = STATE(573),
    [sym_right_assignment] = STATE(573),
    [sym_brace_list] = STATE(573),
    [sym_paren_list] = STATE(573),
    [sym_subset] = STATE(573),
    [sym_subset2] = STATE(573),
    [sym_dollar] = STATE(573),
    [sym_slot] = STATE(573),
    [sym_namespace_get] = STATE(573),
    [sym_namespace_get_internal] = STATE(573),
    [sym_pipe] = STATE(573),
    [sym_unary] = STATE(573),
    [sym_binary] = STATE(573),
    [sym_na] = STATE(573),
    [sym__expression] = STATE(573),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(573),
    [sym_string] = STATE(573),
    [anon_sym_SEMI] = ACTIONS(1503),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1505),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1505),
    [sym_next] = ACTIONS(1505),
    [sym_true] = ACTIONS(1505),
    [sym_false] = ACTIONS(1505),
    [sym_null] = ACTIONS(1505),
    [sym_inf] = ACTIONS(1505),
    [sym_nan] = ACTIONS(1505),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1503),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [252] = {
    [sym_function_definition] = STATE(659),
    [sym_lambda_function] = STATE(659),
    [sym_if] = STATE(659),
    [sym_while] = STATE(659),
    [sym_repeat] = STATE(659),
    [sym_for] = STATE(659),
    [sym_switch] = STATE(659),
    [sym_call] = STATE(659),
    [sym__assignment] = STATE(659),
    [sym_left_assignment] = STATE(659),
    [sym_left_assignment2] = STATE(659),
    [sym_equals_assignment] = STATE(659),
    [sym_super_assignment] = STATE(659),
    [sym_super_right_assignment] = STATE(659),
    [sym_right_assignment] = STATE(659),
    [sym_brace_list] = STATE(659),
    [sym_paren_list] = STATE(659),
    [sym_subset] = STATE(659),
    [sym_subset2] = STATE(659),
    [sym_dollar] = STATE(659),
    [sym_slot] = STATE(659),
    [sym_namespace_get] = STATE(659),
    [sym_namespace_get_internal] = STATE(659),
    [sym_pipe] = STATE(659),
    [sym_unary] = STATE(659),
    [sym_binary] = STATE(659),
    [sym_na] = STATE(659),
    [sym__expression] = STATE(659),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(659),
    [sym_string] = STATE(659),
    [anon_sym_SEMI] = ACTIONS(1507),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1509),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1509),
    [sym_next] = ACTIONS(1509),
    [sym_true] = ACTIONS(1509),
    [sym_false] = ACTIONS(1509),
    [sym_null] = ACTIONS(1509),
    [sym_inf] = ACTIONS(1509),
    [sym_nan] = ACTIONS(1509),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1507),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [253] = {
    [sym_function_definition] = STATE(660),
    [sym_lambda_function] = STATE(660),
    [sym_if] = STATE(660),
    [sym_while] = STATE(660),
    [sym_repeat] = STATE(660),
    [sym_for] = STATE(660),
    [sym_switch] = STATE(660),
    [sym_call] = STATE(660),
    [sym__assignment] = STATE(660),
    [sym_left_assignment] = STATE(660),
    [sym_left_assignment2] = STATE(660),
    [sym_equals_assignment] = STATE(660),
    [sym_super_assignment] = STATE(660),
    [sym_super_right_assignment] = STATE(660),
    [sym_right_assignment] = STATE(660),
    [sym_brace_list] = STATE(660),
    [sym_paren_list] = STATE(660),
    [sym_subset] = STATE(660),
    [sym_subset2] = STATE(660),
    [sym_dollar] = STATE(660),
    [sym_slot] = STATE(660),
    [sym_namespace_get] = STATE(660),
    [sym_namespace_get_internal] = STATE(660),
    [sym_pipe] = STATE(660),
    [sym_unary] = STATE(660),
    [sym_binary] = STATE(660),
    [sym_na] = STATE(660),
    [sym__expression] = STATE(660),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(660),
    [sym_string] = STATE(660),
    [anon_sym_SEMI] = ACTIONS(1511),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1513),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1513),
    [sym_next] = ACTIONS(1513),
    [sym_true] = ACTIONS(1513),
    [sym_false] = ACTIONS(1513),
    [sym_null] = ACTIONS(1513),
    [sym_inf] = ACTIONS(1513),
    [sym_nan] = ACTIONS(1513),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1511),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [254] = {
    [sym_function_definition] = STATE(823),
    [sym_lambda_function] = STATE(823),
    [sym_if] = STATE(823),
    [sym_while] = STATE(823),
    [sym_repeat] = STATE(823),
    [sym_for] = STATE(823),
    [sym_switch] = STATE(823),
    [sym_call] = STATE(823),
    [sym__assignment] = STATE(823),
    [sym_left_assignment] = STATE(823),
    [sym_left_assignment2] = STATE(823),
    [sym_equals_assignment] = STATE(823),
    [sym_super_assignment] = STATE(823),
    [sym_super_right_assignment] = STATE(823),
    [sym_right_assignment] = STATE(823),
    [sym_brace_list] = STATE(823),
    [sym_paren_list] = STATE(823),
    [sym_subset] = STATE(823),
    [sym_subset2] = STATE(823),
    [sym_dollar] = STATE(823),
    [sym_slot] = STATE(823),
    [sym_namespace_get] = STATE(823),
    [sym_namespace_get_internal] = STATE(823),
    [sym_pipe] = STATE(823),
    [sym_unary] = STATE(823),
    [sym_binary] = STATE(823),
    [sym_na] = STATE(823),
    [sym__expression] = STATE(823),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(823),
    [sym_string] = STATE(823),
    [anon_sym_SEMI] = ACTIONS(1515),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1517),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1517),
    [sym_next] = ACTIONS(1517),
    [sym_true] = ACTIONS(1517),
    [sym_false] = ACTIONS(1517),
    [sym_null] = ACTIONS(1517),
    [sym_inf] = ACTIONS(1517),
    [sym_nan] = ACTIONS(1517),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1515),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [255] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1519),
    [anon_sym_function] = ACTIONS(1521),
    [anon_sym_BSLASH] = ACTIONS(1519),
    [anon_sym_if] = ACTIONS(1521),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1519),
    [anon_sym_else] = ACTIONS(1521),
    [anon_sym_while] = ACTIONS(1521),
    [anon_sym_repeat] = ACTIONS(1521),
    [anon_sym_for] = ACTIONS(1521),
    [anon_sym_switch] = ACTIONS(1521),
    [anon_sym_COMMA] = ACTIONS(1519),
    [anon_sym_EQ] = ACTIONS(1521),
    [anon_sym_LBRACE] = ACTIONS(1519),
    [anon_sym_LT_DASH] = ACTIONS(1519),
    [anon_sym_COLON_EQ] = ACTIONS(1519),
    [anon_sym_LT_LT_DASH] = ACTIONS(1519),
    [anon_sym_DASH_GT_GT] = ACTIONS(1519),
    [anon_sym_DASH_GT] = ACTIONS(1521),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1519),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1521),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1521),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1521),
    [sym_next] = ACTIONS(1521),
    [sym_true] = ACTIONS(1521),
    [sym_false] = ACTIONS(1521),
    [sym_null] = ACTIONS(1521),
    [sym_inf] = ACTIONS(1521),
    [sym_nan] = ACTIONS(1521),
    [anon_sym_NA] = ACTIONS(1521),
    [anon_sym_NA_character_] = ACTIONS(1521),
    [anon_sym_NA_complex_] = ACTIONS(1521),
    [anon_sym_NA_integer_] = ACTIONS(1521),
    [anon_sym_NA_real_] = ACTIONS(1521),
    [aux_sym_identifier_token1] = ACTIONS(1521),
    [anon_sym_BQUOTE] = ACTIONS(1519),
    [sym_integer] = ACTIONS(1519),
    [sym_float] = ACTIONS(1521),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1519),
    [anon_sym_SQUOTE] = ACTIONS(1519),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [256] = {
    [sym_special] = STATE(257),
    [anon_sym_SEMI] = ACTIONS(1523),
    [anon_sym_function] = ACTIONS(1525),
    [anon_sym_BSLASH] = ACTIONS(1523),
    [anon_sym_if] = ACTIONS(1525),
    [anon_sym_LPAREN] = ACTIONS(895),
    [anon_sym_RPAREN] = ACTIONS(1523),
    [anon_sym_else] = ACTIONS(1525),
    [anon_sym_while] = ACTIONS(1525),
    [anon_sym_repeat] = ACTIONS(1525),
    [anon_sym_for] = ACTIONS(1525),
    [anon_sym_switch] = ACTIONS(1525),
    [anon_sym_COMMA] = ACTIONS(1523),
    [anon_sym_EQ] = ACTIONS(1525),
    [anon_sym_LBRACE] = ACTIONS(1523),
    [anon_sym_LT_DASH] = ACTIONS(1523),
    [anon_sym_COLON_EQ] = ACTIONS(1523),
    [anon_sym_LT_LT_DASH] = ACTIONS(1523),
    [anon_sym_DASH_GT_GT] = ACTIONS(1523),
    [anon_sym_DASH_GT] = ACTIONS(1525),
    [anon_sym_LBRACK] = ACTIONS(911),
    [anon_sym_RBRACK] = ACTIONS(1523),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(913),
    [anon_sym_DOLLAR] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(917),
    [sym_dots] = ACTIONS(1525),
    [anon_sym_PIPE_GT] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(921),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_BANG] = ACTIONS(1525),
    [anon_sym_TILDE] = ACTIONS(925),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_CARET] = ACTIONS(929),
    [anon_sym_LT] = ACTIONS(931),
    [anon_sym_GT] = ACTIONS(931),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_EQ_EQ] = ACTIONS(933),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(935),
    [anon_sym_PIPE] = ACTIONS(937),
    [anon_sym_AMP_AMP] = ACTIONS(939),
    [anon_sym_AMP] = ACTIONS(941),
    [anon_sym_COLON] = ACTIONS(943),
    [sym_break] = ACTIONS(1525),
    [sym_next] = ACTIONS(1525),
    [sym_true] = ACTIONS(1525),
    [sym_false] = ACTIONS(1525),
    [sym_null] = ACTIONS(1525),
    [sym_inf] = ACTIONS(1525),
    [sym_nan] = ACTIONS(1525),
    [anon_sym_NA] = ACTIONS(1525),
    [anon_sym_NA_character_] = ACTIONS(1525),
    [anon_sym_NA_complex_] = ACTIONS(1525),
    [anon_sym_NA_integer_] = ACTIONS(1525),
    [anon_sym_NA_real_] = ACTIONS(1525),
    [aux_sym_identifier_token1] = ACTIONS(1525),
    [anon_sym_BQUOTE] = ACTIONS(1523),
    [sym_integer] = ACTIONS(1523),
    [sym_float] = ACTIONS(1525),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1523),
    [anon_sym_SQUOTE] = ACTIONS(1523),
    [anon_sym_PERCENT] = ACTIONS(945),
  },
  [257] = {
    [sym_function_definition] = STATE(218),
    [sym_lambda_function] = STATE(218),
    [sym_if] = STATE(218),
    [sym_while] = STATE(218),
    [sym_repeat] = STATE(218),
    [sym_for] = STATE(218),
    [sym_switch] = STATE(218),
    [sym_call] = STATE(218),
    [sym__assignment] = STATE(218),
    [sym_left_assignment] = STATE(218),
    [sym_left_assignment2] = STATE(218),
    [sym_equals_assignment] = STATE(218),
    [sym_super_assignment] = STATE(218),
    [sym_super_right_assignment] = STATE(218),
    [sym_right_assignment] = STATE(218),
    [sym_brace_list] = STATE(218),
    [sym_paren_list] = STATE(218),
    [sym_subset] = STATE(218),
    [sym_subset2] = STATE(218),
    [sym_dollar] = STATE(218),
    [sym_slot] = STATE(218),
    [sym_namespace_get] = STATE(218),
    [sym_namespace_get_internal] = STATE(218),
    [sym_pipe] = STATE(218),
    [sym_unary] = STATE(218),
    [sym_binary] = STATE(218),
    [sym_na] = STATE(218),
    [sym__expression] = STATE(218),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(218),
    [sym_string] = STATE(218),
    [anon_sym_SEMI] = ACTIONS(1527),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1529),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1529),
    [sym_next] = ACTIONS(1529),
    [sym_true] = ACTIONS(1529),
    [sym_false] = ACTIONS(1529),
    [sym_null] = ACTIONS(1529),
    [sym_inf] = ACTIONS(1529),
    [sym_nan] = ACTIONS(1529),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1527),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [258] = {
    [sym_function_definition] = STATE(219),
    [sym_lambda_function] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_repeat] = STATE(219),
    [sym_for] = STATE(219),
    [sym_switch] = STATE(219),
    [sym_call] = STATE(219),
    [sym__assignment] = STATE(219),
    [sym_left_assignment] = STATE(219),
    [sym_left_assignment2] = STATE(219),
    [sym_equals_assignment] = STATE(219),
    [sym_super_assignment] = STATE(219),
    [sym_super_right_assignment] = STATE(219),
    [sym_right_assignment] = STATE(219),
    [sym_brace_list] = STATE(219),
    [sym_paren_list] = STATE(219),
    [sym_subset] = STATE(219),
    [sym_subset2] = STATE(219),
    [sym_dollar] = STATE(219),
    [sym_slot] = STATE(219),
    [sym_namespace_get] = STATE(219),
    [sym_namespace_get_internal] = STATE(219),
    [sym_pipe] = STATE(219),
    [sym_unary] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_na] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(219),
    [sym_string] = STATE(219),
    [anon_sym_SEMI] = ACTIONS(1531),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1533),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1533),
    [sym_next] = ACTIONS(1533),
    [sym_true] = ACTIONS(1533),
    [sym_false] = ACTIONS(1533),
    [sym_null] = ACTIONS(1533),
    [sym_inf] = ACTIONS(1533),
    [sym_nan] = ACTIONS(1533),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1531),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [259] = {
    [sym_function_definition] = STATE(705),
    [sym_lambda_function] = STATE(705),
    [sym_if] = STATE(705),
    [sym_while] = STATE(705),
    [sym_repeat] = STATE(705),
    [sym_for] = STATE(705),
    [sym_switch] = STATE(705),
    [sym_call] = STATE(705),
    [sym__assignment] = STATE(705),
    [sym_left_assignment] = STATE(705),
    [sym_left_assignment2] = STATE(705),
    [sym_equals_assignment] = STATE(705),
    [sym_super_assignment] = STATE(705),
    [sym_super_right_assignment] = STATE(705),
    [sym_right_assignment] = STATE(705),
    [sym_brace_list] = STATE(705),
    [sym_paren_list] = STATE(705),
    [sym_subset] = STATE(705),
    [sym_subset2] = STATE(705),
    [sym_dollar] = STATE(705),
    [sym_slot] = STATE(705),
    [sym_namespace_get] = STATE(705),
    [sym_namespace_get_internal] = STATE(705),
    [sym_pipe] = STATE(705),
    [sym_unary] = STATE(705),
    [sym_binary] = STATE(705),
    [sym_na] = STATE(705),
    [sym__expression] = STATE(705),
    [sym_identifier] = STATE(432),
    [sym_complex] = STATE(705),
    [sym_string] = STATE(705),
    [anon_sym_SEMI] = ACTIONS(1535),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1537),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1537),
    [sym_next] = ACTIONS(1537),
    [sym_true] = ACTIONS(1537),
    [sym_false] = ACTIONS(1537),
    [sym_null] = ACTIONS(1537),
    [sym_inf] = ACTIONS(1537),
    [sym_nan] = ACTIONS(1537),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1535),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [260] = {
    [sym_function_definition] = STATE(220),
    [sym_lambda_function] = STATE(220),
    [sym_if] = STATE(220),
    [sym_while] = STATE(220),
    [sym_repeat] = STATE(220),
    [sym_for] = STATE(220),
    [sym_switch] = STATE(220),
    [sym_call] = STATE(220),
    [sym__assignment] = STATE(220),
    [sym_left_assignment] = STATE(220),
    [sym_left_assignment2] = STATE(220),
    [sym_equals_assignment] = STATE(220),
    [sym_super_assignment] = STATE(220),
    [sym_super_right_assignment] = STATE(220),
    [sym_right_assignment] = STATE(220),
    [sym_brace_list] = STATE(220),
    [sym_paren_list] = STATE(220),
    [sym_subset] = STATE(220),
    [sym_subset2] = STATE(220),
    [sym_dollar] = STATE(220),
    [sym_slot] = STATE(220),
    [sym_namespace_get] = STATE(220),
    [sym_namespace_get_internal] = STATE(220),
    [sym_pipe] = STATE(220),
    [sym_unary] = STATE(220),
    [sym_binary] = STATE(220),
    [sym_na] = STATE(220),
    [sym__expression] = STATE(220),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(220),
    [sym_string] = STATE(220),
    [anon_sym_SEMI] = ACTIONS(1539),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1541),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1541),
    [sym_next] = ACTIONS(1541),
    [sym_true] = ACTIONS(1541),
    [sym_false] = ACTIONS(1541),
    [sym_null] = ACTIONS(1541),
    [sym_inf] = ACTIONS(1541),
    [sym_nan] = ACTIONS(1541),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1539),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [261] = {
    [sym_function_definition] = STATE(574),
    [sym_lambda_function] = STATE(574),
    [sym_if] = STATE(574),
    [sym_while] = STATE(574),
    [sym_repeat] = STATE(574),
    [sym_for] = STATE(574),
    [sym_switch] = STATE(574),
    [sym_call] = STATE(574),
    [sym__assignment] = STATE(574),
    [sym_left_assignment] = STATE(574),
    [sym_left_assignment2] = STATE(574),
    [sym_equals_assignment] = STATE(574),
    [sym_super_assignment] = STATE(574),
    [sym_super_right_assignment] = STATE(574),
    [sym_right_assignment] = STATE(574),
    [sym_brace_list] = STATE(574),
    [sym_paren_list] = STATE(574),
    [sym_subset] = STATE(574),
    [sym_subset2] = STATE(574),
    [sym_dollar] = STATE(574),
    [sym_slot] = STATE(574),
    [sym_namespace_get] = STATE(574),
    [sym_namespace_get_internal] = STATE(574),
    [sym_pipe] = STATE(574),
    [sym_unary] = STATE(574),
    [sym_binary] = STATE(574),
    [sym_na] = STATE(574),
    [sym__expression] = STATE(574),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(574),
    [sym_string] = STATE(574),
    [anon_sym_SEMI] = ACTIONS(1543),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1545),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1545),
    [sym_next] = ACTIONS(1545),
    [sym_true] = ACTIONS(1545),
    [sym_false] = ACTIONS(1545),
    [sym_null] = ACTIONS(1545),
    [sym_inf] = ACTIONS(1545),
    [sym_nan] = ACTIONS(1545),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1543),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [262] = {
    [sym_function_definition] = STATE(580),
    [sym_lambda_function] = STATE(580),
    [sym_if] = STATE(580),
    [sym_while] = STATE(580),
    [sym_repeat] = STATE(580),
    [sym_for] = STATE(580),
    [sym_switch] = STATE(580),
    [sym_call] = STATE(580),
    [sym__assignment] = STATE(580),
    [sym_left_assignment] = STATE(580),
    [sym_left_assignment2] = STATE(580),
    [sym_equals_assignment] = STATE(580),
    [sym_super_assignment] = STATE(580),
    [sym_super_right_assignment] = STATE(580),
    [sym_right_assignment] = STATE(580),
    [sym_brace_list] = STATE(580),
    [sym_paren_list] = STATE(580),
    [sym_subset] = STATE(580),
    [sym_subset2] = STATE(580),
    [sym_dollar] = STATE(580),
    [sym_slot] = STATE(580),
    [sym_namespace_get] = STATE(580),
    [sym_namespace_get_internal] = STATE(580),
    [sym_pipe] = STATE(580),
    [sym_unary] = STATE(580),
    [sym_binary] = STATE(580),
    [sym_na] = STATE(580),
    [sym__expression] = STATE(580),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(580),
    [sym_string] = STATE(580),
    [anon_sym_SEMI] = ACTIONS(1547),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1549),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1549),
    [sym_next] = ACTIONS(1549),
    [sym_true] = ACTIONS(1549),
    [sym_false] = ACTIONS(1549),
    [sym_null] = ACTIONS(1549),
    [sym_inf] = ACTIONS(1549),
    [sym_nan] = ACTIONS(1549),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1547),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [263] = {
    [sym_function_definition] = STATE(582),
    [sym_lambda_function] = STATE(582),
    [sym_if] = STATE(582),
    [sym_while] = STATE(582),
    [sym_repeat] = STATE(582),
    [sym_for] = STATE(582),
    [sym_switch] = STATE(582),
    [sym_call] = STATE(582),
    [sym__assignment] = STATE(582),
    [sym_left_assignment] = STATE(582),
    [sym_left_assignment2] = STATE(582),
    [sym_equals_assignment] = STATE(582),
    [sym_super_assignment] = STATE(582),
    [sym_super_right_assignment] = STATE(582),
    [sym_right_assignment] = STATE(582),
    [sym_brace_list] = STATE(582),
    [sym_paren_list] = STATE(582),
    [sym_subset] = STATE(582),
    [sym_subset2] = STATE(582),
    [sym_dollar] = STATE(582),
    [sym_slot] = STATE(582),
    [sym_namespace_get] = STATE(582),
    [sym_namespace_get_internal] = STATE(582),
    [sym_pipe] = STATE(582),
    [sym_unary] = STATE(582),
    [sym_binary] = STATE(582),
    [sym_na] = STATE(582),
    [sym__expression] = STATE(582),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(582),
    [sym_string] = STATE(582),
    [anon_sym_SEMI] = ACTIONS(1551),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1553),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1553),
    [sym_next] = ACTIONS(1553),
    [sym_true] = ACTIONS(1553),
    [sym_false] = ACTIONS(1553),
    [sym_null] = ACTIONS(1553),
    [sym_inf] = ACTIONS(1553),
    [sym_nan] = ACTIONS(1553),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1551),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [264] = {
    [sym_function_definition] = STATE(583),
    [sym_lambda_function] = STATE(583),
    [sym_if] = STATE(583),
    [sym_while] = STATE(583),
    [sym_repeat] = STATE(583),
    [sym_for] = STATE(583),
    [sym_switch] = STATE(583),
    [sym_call] = STATE(583),
    [sym__assignment] = STATE(583),
    [sym_left_assignment] = STATE(583),
    [sym_left_assignment2] = STATE(583),
    [sym_equals_assignment] = STATE(583),
    [sym_super_assignment] = STATE(583),
    [sym_super_right_assignment] = STATE(583),
    [sym_right_assignment] = STATE(583),
    [sym_brace_list] = STATE(583),
    [sym_paren_list] = STATE(583),
    [sym_subset] = STATE(583),
    [sym_subset2] = STATE(583),
    [sym_dollar] = STATE(583),
    [sym_slot] = STATE(583),
    [sym_namespace_get] = STATE(583),
    [sym_namespace_get_internal] = STATE(583),
    [sym_pipe] = STATE(583),
    [sym_unary] = STATE(583),
    [sym_binary] = STATE(583),
    [sym_na] = STATE(583),
    [sym__expression] = STATE(583),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(583),
    [sym_string] = STATE(583),
    [anon_sym_SEMI] = ACTIONS(1555),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1557),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1557),
    [sym_next] = ACTIONS(1557),
    [sym_true] = ACTIONS(1557),
    [sym_false] = ACTIONS(1557),
    [sym_null] = ACTIONS(1557),
    [sym_inf] = ACTIONS(1557),
    [sym_nan] = ACTIONS(1557),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1555),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [265] = {
    [sym_function_definition] = STATE(584),
    [sym_lambda_function] = STATE(584),
    [sym_if] = STATE(584),
    [sym_while] = STATE(584),
    [sym_repeat] = STATE(584),
    [sym_for] = STATE(584),
    [sym_switch] = STATE(584),
    [sym_call] = STATE(584),
    [sym__assignment] = STATE(584),
    [sym_left_assignment] = STATE(584),
    [sym_left_assignment2] = STATE(584),
    [sym_equals_assignment] = STATE(584),
    [sym_super_assignment] = STATE(584),
    [sym_super_right_assignment] = STATE(584),
    [sym_right_assignment] = STATE(584),
    [sym_brace_list] = STATE(584),
    [sym_paren_list] = STATE(584),
    [sym_subset] = STATE(584),
    [sym_subset2] = STATE(584),
    [sym_dollar] = STATE(584),
    [sym_slot] = STATE(584),
    [sym_namespace_get] = STATE(584),
    [sym_namespace_get_internal] = STATE(584),
    [sym_pipe] = STATE(584),
    [sym_unary] = STATE(584),
    [sym_binary] = STATE(584),
    [sym_na] = STATE(584),
    [sym__expression] = STATE(584),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(584),
    [sym_string] = STATE(584),
    [anon_sym_SEMI] = ACTIONS(1559),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1561),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1561),
    [sym_next] = ACTIONS(1561),
    [sym_true] = ACTIONS(1561),
    [sym_false] = ACTIONS(1561),
    [sym_null] = ACTIONS(1561),
    [sym_inf] = ACTIONS(1561),
    [sym_nan] = ACTIONS(1561),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1559),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [266] = {
    [sym_function_definition] = STATE(585),
    [sym_lambda_function] = STATE(585),
    [sym_if] = STATE(585),
    [sym_while] = STATE(585),
    [sym_repeat] = STATE(585),
    [sym_for] = STATE(585),
    [sym_switch] = STATE(585),
    [sym_call] = STATE(585),
    [sym__assignment] = STATE(585),
    [sym_left_assignment] = STATE(585),
    [sym_left_assignment2] = STATE(585),
    [sym_equals_assignment] = STATE(585),
    [sym_super_assignment] = STATE(585),
    [sym_super_right_assignment] = STATE(585),
    [sym_right_assignment] = STATE(585),
    [sym_brace_list] = STATE(585),
    [sym_paren_list] = STATE(585),
    [sym_subset] = STATE(585),
    [sym_subset2] = STATE(585),
    [sym_dollar] = STATE(585),
    [sym_slot] = STATE(585),
    [sym_namespace_get] = STATE(585),
    [sym_namespace_get_internal] = STATE(585),
    [sym_pipe] = STATE(585),
    [sym_unary] = STATE(585),
    [sym_binary] = STATE(585),
    [sym_na] = STATE(585),
    [sym__expression] = STATE(585),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(585),
    [sym_string] = STATE(585),
    [anon_sym_SEMI] = ACTIONS(1563),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1565),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1565),
    [sym_next] = ACTIONS(1565),
    [sym_true] = ACTIONS(1565),
    [sym_false] = ACTIONS(1565),
    [sym_null] = ACTIONS(1565),
    [sym_inf] = ACTIONS(1565),
    [sym_nan] = ACTIONS(1565),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1563),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [267] = {
    [sym_function_definition] = STATE(221),
    [sym_lambda_function] = STATE(221),
    [sym_if] = STATE(221),
    [sym_while] = STATE(221),
    [sym_repeat] = STATE(221),
    [sym_for] = STATE(221),
    [sym_switch] = STATE(221),
    [sym_call] = STATE(221),
    [sym__assignment] = STATE(221),
    [sym_left_assignment] = STATE(221),
    [sym_left_assignment2] = STATE(221),
    [sym_equals_assignment] = STATE(221),
    [sym_super_assignment] = STATE(221),
    [sym_super_right_assignment] = STATE(221),
    [sym_right_assignment] = STATE(221),
    [sym_brace_list] = STATE(221),
    [sym_paren_list] = STATE(221),
    [sym_subset] = STATE(221),
    [sym_subset2] = STATE(221),
    [sym_dollar] = STATE(221),
    [sym_slot] = STATE(221),
    [sym_namespace_get] = STATE(221),
    [sym_namespace_get_internal] = STATE(221),
    [sym_pipe] = STATE(221),
    [sym_unary] = STATE(221),
    [sym_binary] = STATE(221),
    [sym_na] = STATE(221),
    [sym__expression] = STATE(221),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(221),
    [sym_string] = STATE(221),
    [anon_sym_SEMI] = ACTIONS(1567),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1569),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1569),
    [sym_next] = ACTIONS(1569),
    [sym_true] = ACTIONS(1569),
    [sym_false] = ACTIONS(1569),
    [sym_null] = ACTIONS(1569),
    [sym_inf] = ACTIONS(1569),
    [sym_nan] = ACTIONS(1569),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1567),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [268] = {
    [sym_function_definition] = STATE(676),
    [sym_lambda_function] = STATE(676),
    [sym_if] = STATE(676),
    [sym_while] = STATE(676),
    [sym_repeat] = STATE(676),
    [sym_for] = STATE(676),
    [sym_switch] = STATE(676),
    [sym_call] = STATE(676),
    [sym__assignment] = STATE(676),
    [sym_left_assignment] = STATE(676),
    [sym_left_assignment2] = STATE(676),
    [sym_equals_assignment] = STATE(676),
    [sym_super_assignment] = STATE(676),
    [sym_super_right_assignment] = STATE(676),
    [sym_right_assignment] = STATE(676),
    [sym_brace_list] = STATE(676),
    [sym_paren_list] = STATE(676),
    [sym_subset] = STATE(676),
    [sym_subset2] = STATE(676),
    [sym_dollar] = STATE(676),
    [sym_slot] = STATE(676),
    [sym_namespace_get] = STATE(676),
    [sym_namespace_get_internal] = STATE(676),
    [sym_pipe] = STATE(676),
    [sym_unary] = STATE(676),
    [sym_binary] = STATE(676),
    [sym_na] = STATE(676),
    [sym__expression] = STATE(676),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(676),
    [sym_string] = STATE(676),
    [anon_sym_SEMI] = ACTIONS(1571),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1573),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1573),
    [sym_next] = ACTIONS(1573),
    [sym_true] = ACTIONS(1573),
    [sym_false] = ACTIONS(1573),
    [sym_null] = ACTIONS(1573),
    [sym_inf] = ACTIONS(1573),
    [sym_nan] = ACTIONS(1573),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1571),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [269] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(595),
    [anon_sym_SEMI] = ACTIONS(1575),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1577),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1577),
    [sym_next] = ACTIONS(1577),
    [sym_true] = ACTIONS(1577),
    [sym_false] = ACTIONS(1577),
    [sym_null] = ACTIONS(1577),
    [sym_inf] = ACTIONS(1577),
    [sym_nan] = ACTIONS(1577),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1575),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [270] = {
    [sym_function_definition] = STATE(596),
    [sym_lambda_function] = STATE(596),
    [sym_if] = STATE(596),
    [sym_while] = STATE(596),
    [sym_repeat] = STATE(596),
    [sym_for] = STATE(596),
    [sym_switch] = STATE(596),
    [sym_call] = STATE(596),
    [sym__assignment] = STATE(596),
    [sym_left_assignment] = STATE(596),
    [sym_left_assignment2] = STATE(596),
    [sym_equals_assignment] = STATE(596),
    [sym_super_assignment] = STATE(596),
    [sym_super_right_assignment] = STATE(596),
    [sym_right_assignment] = STATE(596),
    [sym_brace_list] = STATE(596),
    [sym_paren_list] = STATE(596),
    [sym_subset] = STATE(596),
    [sym_subset2] = STATE(596),
    [sym_dollar] = STATE(596),
    [sym_slot] = STATE(596),
    [sym_namespace_get] = STATE(596),
    [sym_namespace_get_internal] = STATE(596),
    [sym_pipe] = STATE(596),
    [sym_unary] = STATE(596),
    [sym_binary] = STATE(596),
    [sym_na] = STATE(596),
    [sym__expression] = STATE(596),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(596),
    [sym_string] = STATE(596),
    [anon_sym_SEMI] = ACTIONS(1579),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1581),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1581),
    [sym_next] = ACTIONS(1581),
    [sym_true] = ACTIONS(1581),
    [sym_false] = ACTIONS(1581),
    [sym_null] = ACTIONS(1581),
    [sym_inf] = ACTIONS(1581),
    [sym_nan] = ACTIONS(1581),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1579),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [271] = {
    [sym_function_definition] = STATE(597),
    [sym_lambda_function] = STATE(597),
    [sym_if] = STATE(597),
    [sym_while] = STATE(597),
    [sym_repeat] = STATE(597),
    [sym_for] = STATE(597),
    [sym_switch] = STATE(597),
    [sym_call] = STATE(597),
    [sym__assignment] = STATE(597),
    [sym_left_assignment] = STATE(597),
    [sym_left_assignment2] = STATE(597),
    [sym_equals_assignment] = STATE(597),
    [sym_super_assignment] = STATE(597),
    [sym_super_right_assignment] = STATE(597),
    [sym_right_assignment] = STATE(597),
    [sym_brace_list] = STATE(597),
    [sym_paren_list] = STATE(597),
    [sym_subset] = STATE(597),
    [sym_subset2] = STATE(597),
    [sym_dollar] = STATE(597),
    [sym_slot] = STATE(597),
    [sym_namespace_get] = STATE(597),
    [sym_namespace_get_internal] = STATE(597),
    [sym_pipe] = STATE(597),
    [sym_unary] = STATE(597),
    [sym_binary] = STATE(597),
    [sym_na] = STATE(597),
    [sym__expression] = STATE(597),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(597),
    [sym_string] = STATE(597),
    [anon_sym_SEMI] = ACTIONS(1583),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1585),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1585),
    [sym_next] = ACTIONS(1585),
    [sym_true] = ACTIONS(1585),
    [sym_false] = ACTIONS(1585),
    [sym_null] = ACTIONS(1585),
    [sym_inf] = ACTIONS(1585),
    [sym_nan] = ACTIONS(1585),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1583),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [272] = {
    [sym_function_definition] = STATE(598),
    [sym_lambda_function] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_repeat] = STATE(598),
    [sym_for] = STATE(598),
    [sym_switch] = STATE(598),
    [sym_call] = STATE(598),
    [sym__assignment] = STATE(598),
    [sym_left_assignment] = STATE(598),
    [sym_left_assignment2] = STATE(598),
    [sym_equals_assignment] = STATE(598),
    [sym_super_assignment] = STATE(598),
    [sym_super_right_assignment] = STATE(598),
    [sym_right_assignment] = STATE(598),
    [sym_brace_list] = STATE(598),
    [sym_paren_list] = STATE(598),
    [sym_subset] = STATE(598),
    [sym_subset2] = STATE(598),
    [sym_dollar] = STATE(598),
    [sym_slot] = STATE(598),
    [sym_namespace_get] = STATE(598),
    [sym_namespace_get_internal] = STATE(598),
    [sym_pipe] = STATE(598),
    [sym_unary] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_na] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(598),
    [sym_string] = STATE(598),
    [anon_sym_SEMI] = ACTIONS(1587),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1589),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1589),
    [sym_next] = ACTIONS(1589),
    [sym_true] = ACTIONS(1589),
    [sym_false] = ACTIONS(1589),
    [sym_null] = ACTIONS(1589),
    [sym_inf] = ACTIONS(1589),
    [sym_nan] = ACTIONS(1589),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1587),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [273] = {
    [sym_function_definition] = STATE(599),
    [sym_lambda_function] = STATE(599),
    [sym_if] = STATE(599),
    [sym_while] = STATE(599),
    [sym_repeat] = STATE(599),
    [sym_for] = STATE(599),
    [sym_switch] = STATE(599),
    [sym_call] = STATE(599),
    [sym__assignment] = STATE(599),
    [sym_left_assignment] = STATE(599),
    [sym_left_assignment2] = STATE(599),
    [sym_equals_assignment] = STATE(599),
    [sym_super_assignment] = STATE(599),
    [sym_super_right_assignment] = STATE(599),
    [sym_right_assignment] = STATE(599),
    [sym_brace_list] = STATE(599),
    [sym_paren_list] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_dollar] = STATE(599),
    [sym_slot] = STATE(599),
    [sym_namespace_get] = STATE(599),
    [sym_namespace_get_internal] = STATE(599),
    [sym_pipe] = STATE(599),
    [sym_unary] = STATE(599),
    [sym_binary] = STATE(599),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(599),
    [sym_string] = STATE(599),
    [anon_sym_SEMI] = ACTIONS(1591),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1593),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1593),
    [sym_next] = ACTIONS(1593),
    [sym_true] = ACTIONS(1593),
    [sym_false] = ACTIONS(1593),
    [sym_null] = ACTIONS(1593),
    [sym_inf] = ACTIONS(1593),
    [sym_nan] = ACTIONS(1593),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1591),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [274] = {
    [sym_function_definition] = STATE(601),
    [sym_lambda_function] = STATE(601),
    [sym_if] = STATE(601),
    [sym_while] = STATE(601),
    [sym_repeat] = STATE(601),
    [sym_for] = STATE(601),
    [sym_switch] = STATE(601),
    [sym_call] = STATE(601),
    [sym__assignment] = STATE(601),
    [sym_left_assignment] = STATE(601),
    [sym_left_assignment2] = STATE(601),
    [sym_equals_assignment] = STATE(601),
    [sym_super_assignment] = STATE(601),
    [sym_super_right_assignment] = STATE(601),
    [sym_right_assignment] = STATE(601),
    [sym_brace_list] = STATE(601),
    [sym_paren_list] = STATE(601),
    [sym_subset] = STATE(601),
    [sym_subset2] = STATE(601),
    [sym_dollar] = STATE(601),
    [sym_slot] = STATE(601),
    [sym_namespace_get] = STATE(601),
    [sym_namespace_get_internal] = STATE(601),
    [sym_pipe] = STATE(601),
    [sym_unary] = STATE(601),
    [sym_binary] = STATE(601),
    [sym_na] = STATE(601),
    [sym__expression] = STATE(601),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(601),
    [sym_string] = STATE(601),
    [anon_sym_SEMI] = ACTIONS(1595),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1597),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1597),
    [sym_next] = ACTIONS(1597),
    [sym_true] = ACTIONS(1597),
    [sym_false] = ACTIONS(1597),
    [sym_null] = ACTIONS(1597),
    [sym_inf] = ACTIONS(1597),
    [sym_nan] = ACTIONS(1597),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1595),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [275] = {
    [sym_function_definition] = STATE(602),
    [sym_lambda_function] = STATE(602),
    [sym_if] = STATE(602),
    [sym_while] = STATE(602),
    [sym_repeat] = STATE(602),
    [sym_for] = STATE(602),
    [sym_switch] = STATE(602),
    [sym_call] = STATE(602),
    [sym__assignment] = STATE(602),
    [sym_left_assignment] = STATE(602),
    [sym_left_assignment2] = STATE(602),
    [sym_equals_assignment] = STATE(602),
    [sym_super_assignment] = STATE(602),
    [sym_super_right_assignment] = STATE(602),
    [sym_right_assignment] = STATE(602),
    [sym_brace_list] = STATE(602),
    [sym_paren_list] = STATE(602),
    [sym_subset] = STATE(602),
    [sym_subset2] = STATE(602),
    [sym_dollar] = STATE(602),
    [sym_slot] = STATE(602),
    [sym_namespace_get] = STATE(602),
    [sym_namespace_get_internal] = STATE(602),
    [sym_pipe] = STATE(602),
    [sym_unary] = STATE(602),
    [sym_binary] = STATE(602),
    [sym_na] = STATE(602),
    [sym__expression] = STATE(602),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(602),
    [sym_string] = STATE(602),
    [anon_sym_SEMI] = ACTIONS(1599),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1601),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1601),
    [sym_next] = ACTIONS(1601),
    [sym_true] = ACTIONS(1601),
    [sym_false] = ACTIONS(1601),
    [sym_null] = ACTIONS(1601),
    [sym_inf] = ACTIONS(1601),
    [sym_nan] = ACTIONS(1601),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1599),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [276] = {
    [sym_function_definition] = STATE(603),
    [sym_lambda_function] = STATE(603),
    [sym_if] = STATE(603),
    [sym_while] = STATE(603),
    [sym_repeat] = STATE(603),
    [sym_for] = STATE(603),
    [sym_switch] = STATE(603),
    [sym_call] = STATE(603),
    [sym__assignment] = STATE(603),
    [sym_left_assignment] = STATE(603),
    [sym_left_assignment2] = STATE(603),
    [sym_equals_assignment] = STATE(603),
    [sym_super_assignment] = STATE(603),
    [sym_super_right_assignment] = STATE(603),
    [sym_right_assignment] = STATE(603),
    [sym_brace_list] = STATE(603),
    [sym_paren_list] = STATE(603),
    [sym_subset] = STATE(603),
    [sym_subset2] = STATE(603),
    [sym_dollar] = STATE(603),
    [sym_slot] = STATE(603),
    [sym_namespace_get] = STATE(603),
    [sym_namespace_get_internal] = STATE(603),
    [sym_pipe] = STATE(603),
    [sym_unary] = STATE(603),
    [sym_binary] = STATE(603),
    [sym_na] = STATE(603),
    [sym__expression] = STATE(603),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(603),
    [sym_string] = STATE(603),
    [anon_sym_SEMI] = ACTIONS(1603),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1605),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1605),
    [sym_next] = ACTIONS(1605),
    [sym_true] = ACTIONS(1605),
    [sym_false] = ACTIONS(1605),
    [sym_null] = ACTIONS(1605),
    [sym_inf] = ACTIONS(1605),
    [sym_nan] = ACTIONS(1605),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1603),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [277] = {
    [sym_function_definition] = STATE(609),
    [sym_lambda_function] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_repeat] = STATE(609),
    [sym_for] = STATE(609),
    [sym_switch] = STATE(609),
    [sym_call] = STATE(609),
    [sym__assignment] = STATE(609),
    [sym_left_assignment] = STATE(609),
    [sym_left_assignment2] = STATE(609),
    [sym_equals_assignment] = STATE(609),
    [sym_super_assignment] = STATE(609),
    [sym_super_right_assignment] = STATE(609),
    [sym_right_assignment] = STATE(609),
    [sym_brace_list] = STATE(609),
    [sym_paren_list] = STATE(609),
    [sym_subset] = STATE(609),
    [sym_subset2] = STATE(609),
    [sym_dollar] = STATE(609),
    [sym_slot] = STATE(609),
    [sym_namespace_get] = STATE(609),
    [sym_namespace_get_internal] = STATE(609),
    [sym_pipe] = STATE(609),
    [sym_unary] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_na] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(609),
    [sym_string] = STATE(609),
    [anon_sym_SEMI] = ACTIONS(1607),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1609),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1609),
    [sym_next] = ACTIONS(1609),
    [sym_true] = ACTIONS(1609),
    [sym_false] = ACTIONS(1609),
    [sym_null] = ACTIONS(1609),
    [sym_inf] = ACTIONS(1609),
    [sym_nan] = ACTIONS(1609),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1607),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [278] = {
    [sym_function_definition] = STATE(688),
    [sym_lambda_function] = STATE(688),
    [sym_if] = STATE(688),
    [sym_while] = STATE(688),
    [sym_repeat] = STATE(688),
    [sym_for] = STATE(688),
    [sym_switch] = STATE(688),
    [sym_call] = STATE(688),
    [sym__assignment] = STATE(688),
    [sym_left_assignment] = STATE(688),
    [sym_left_assignment2] = STATE(688),
    [sym_equals_assignment] = STATE(688),
    [sym_super_assignment] = STATE(688),
    [sym_super_right_assignment] = STATE(688),
    [sym_right_assignment] = STATE(688),
    [sym_brace_list] = STATE(688),
    [sym_paren_list] = STATE(688),
    [sym_subset] = STATE(688),
    [sym_subset2] = STATE(688),
    [sym_dollar] = STATE(688),
    [sym_slot] = STATE(688),
    [sym_namespace_get] = STATE(688),
    [sym_namespace_get_internal] = STATE(688),
    [sym_pipe] = STATE(688),
    [sym_unary] = STATE(688),
    [sym_binary] = STATE(688),
    [sym_na] = STATE(688),
    [sym__expression] = STATE(688),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(688),
    [sym_string] = STATE(688),
    [anon_sym_SEMI] = ACTIONS(1611),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1613),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1613),
    [sym_next] = ACTIONS(1613),
    [sym_true] = ACTIONS(1613),
    [sym_false] = ACTIONS(1613),
    [sym_null] = ACTIONS(1613),
    [sym_inf] = ACTIONS(1613),
    [sym_nan] = ACTIONS(1613),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1611),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [279] = {
    [sym_function_definition] = STATE(898),
    [sym_lambda_function] = STATE(898),
    [sym_if] = STATE(898),
    [sym_while] = STATE(898),
    [sym_repeat] = STATE(898),
    [sym_for] = STATE(898),
    [sym_switch] = STATE(898),
    [sym_call] = STATE(898),
    [sym__assignment] = STATE(898),
    [sym_left_assignment] = STATE(898),
    [sym_left_assignment2] = STATE(898),
    [sym_equals_assignment] = STATE(898),
    [sym_super_assignment] = STATE(898),
    [sym_super_right_assignment] = STATE(898),
    [sym_right_assignment] = STATE(898),
    [sym_brace_list] = STATE(898),
    [sym_paren_list] = STATE(898),
    [sym_subset] = STATE(898),
    [sym_subset2] = STATE(898),
    [sym_dollar] = STATE(898),
    [sym_slot] = STATE(898),
    [sym_namespace_get] = STATE(898),
    [sym_namespace_get_internal] = STATE(898),
    [sym_pipe] = STATE(898),
    [sym_unary] = STATE(898),
    [sym_binary] = STATE(898),
    [sym_na] = STATE(898),
    [sym__expression] = STATE(898),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(898),
    [sym_string] = STATE(898),
    [anon_sym_SEMI] = ACTIONS(1615),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1617),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1617),
    [sym_next] = ACTIONS(1617),
    [sym_true] = ACTIONS(1617),
    [sym_false] = ACTIONS(1617),
    [sym_null] = ACTIONS(1617),
    [sym_inf] = ACTIONS(1617),
    [sym_nan] = ACTIONS(1617),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1615),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [280] = {
    [sym_function_definition] = STATE(222),
    [sym_lambda_function] = STATE(222),
    [sym_if] = STATE(222),
    [sym_while] = STATE(222),
    [sym_repeat] = STATE(222),
    [sym_for] = STATE(222),
    [sym_switch] = STATE(222),
    [sym_call] = STATE(222),
    [sym__assignment] = STATE(222),
    [sym_left_assignment] = STATE(222),
    [sym_left_assignment2] = STATE(222),
    [sym_equals_assignment] = STATE(222),
    [sym_super_assignment] = STATE(222),
    [sym_super_right_assignment] = STATE(222),
    [sym_right_assignment] = STATE(222),
    [sym_brace_list] = STATE(222),
    [sym_paren_list] = STATE(222),
    [sym_subset] = STATE(222),
    [sym_subset2] = STATE(222),
    [sym_dollar] = STATE(222),
    [sym_slot] = STATE(222),
    [sym_namespace_get] = STATE(222),
    [sym_namespace_get_internal] = STATE(222),
    [sym_pipe] = STATE(222),
    [sym_unary] = STATE(222),
    [sym_binary] = STATE(222),
    [sym_na] = STATE(222),
    [sym__expression] = STATE(222),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(222),
    [sym_string] = STATE(222),
    [anon_sym_SEMI] = ACTIONS(1619),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1621),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1621),
    [sym_next] = ACTIONS(1621),
    [sym_true] = ACTIONS(1621),
    [sym_false] = ACTIONS(1621),
    [sym_null] = ACTIONS(1621),
    [sym_inf] = ACTIONS(1621),
    [sym_nan] = ACTIONS(1621),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1619),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [281] = {
    [sym_function_definition] = STATE(223),
    [sym_lambda_function] = STATE(223),
    [sym_if] = STATE(223),
    [sym_while] = STATE(223),
    [sym_repeat] = STATE(223),
    [sym_for] = STATE(223),
    [sym_switch] = STATE(223),
    [sym_call] = STATE(223),
    [sym__assignment] = STATE(223),
    [sym_left_assignment] = STATE(223),
    [sym_left_assignment2] = STATE(223),
    [sym_equals_assignment] = STATE(223),
    [sym_super_assignment] = STATE(223),
    [sym_super_right_assignment] = STATE(223),
    [sym_right_assignment] = STATE(223),
    [sym_brace_list] = STATE(223),
    [sym_paren_list] = STATE(223),
    [sym_subset] = STATE(223),
    [sym_subset2] = STATE(223),
    [sym_dollar] = STATE(223),
    [sym_slot] = STATE(223),
    [sym_namespace_get] = STATE(223),
    [sym_namespace_get_internal] = STATE(223),
    [sym_pipe] = STATE(223),
    [sym_unary] = STATE(223),
    [sym_binary] = STATE(223),
    [sym_na] = STATE(223),
    [sym__expression] = STATE(223),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(223),
    [sym_string] = STATE(223),
    [anon_sym_SEMI] = ACTIONS(1623),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1625),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1625),
    [sym_next] = ACTIONS(1625),
    [sym_true] = ACTIONS(1625),
    [sym_false] = ACTIONS(1625),
    [sym_null] = ACTIONS(1625),
    [sym_inf] = ACTIONS(1625),
    [sym_nan] = ACTIONS(1625),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1623),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [282] = {
    [sym_function_definition] = STATE(496),
    [sym_lambda_function] = STATE(496),
    [sym_if] = STATE(496),
    [sym_while] = STATE(496),
    [sym_repeat] = STATE(496),
    [sym_for] = STATE(496),
    [sym_switch] = STATE(496),
    [sym_call] = STATE(496),
    [sym__assignment] = STATE(496),
    [sym_left_assignment] = STATE(496),
    [sym_left_assignment2] = STATE(496),
    [sym_equals_assignment] = STATE(496),
    [sym_super_assignment] = STATE(496),
    [sym_super_right_assignment] = STATE(496),
    [sym_right_assignment] = STATE(496),
    [sym_brace_list] = STATE(496),
    [sym_paren_list] = STATE(496),
    [sym_subset] = STATE(496),
    [sym_subset2] = STATE(496),
    [sym_dollar] = STATE(496),
    [sym_slot] = STATE(496),
    [sym_namespace_get] = STATE(496),
    [sym_namespace_get_internal] = STATE(496),
    [sym_pipe] = STATE(496),
    [sym_unary] = STATE(496),
    [sym_binary] = STATE(496),
    [sym_na] = STATE(496),
    [sym__expression] = STATE(496),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(496),
    [sym_string] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(1627),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1629),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1629),
    [sym_next] = ACTIONS(1629),
    [sym_true] = ACTIONS(1629),
    [sym_false] = ACTIONS(1629),
    [sym_null] = ACTIONS(1629),
    [sym_inf] = ACTIONS(1629),
    [sym_nan] = ACTIONS(1629),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1627),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [283] = {
    [sym_function_definition] = STATE(925),
    [sym_lambda_function] = STATE(925),
    [sym_if] = STATE(925),
    [sym_while] = STATE(925),
    [sym_repeat] = STATE(925),
    [sym_for] = STATE(925),
    [sym_switch] = STATE(925),
    [sym_call] = STATE(634),
    [sym__assignment] = STATE(925),
    [sym_left_assignment] = STATE(925),
    [sym_left_assignment2] = STATE(925),
    [sym_equals_assignment] = STATE(925),
    [sym_super_assignment] = STATE(925),
    [sym_super_right_assignment] = STATE(925),
    [sym_right_assignment] = STATE(925),
    [sym_brace_list] = STATE(925),
    [sym_paren_list] = STATE(925),
    [sym_subset] = STATE(925),
    [sym_subset2] = STATE(925),
    [sym_dollar] = STATE(925),
    [sym_slot] = STATE(925),
    [sym_namespace_get] = STATE(925),
    [sym_namespace_get_internal] = STATE(925),
    [sym_pipe] = STATE(925),
    [sym_unary] = STATE(925),
    [sym_binary] = STATE(925),
    [sym_na] = STATE(925),
    [sym__expression] = STATE(925),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(925),
    [sym_string] = STATE(925),
    [anon_sym_SEMI] = ACTIONS(1631),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1633),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1633),
    [sym_next] = ACTIONS(1633),
    [sym_true] = ACTIONS(1633),
    [sym_false] = ACTIONS(1633),
    [sym_null] = ACTIONS(1633),
    [sym_inf] = ACTIONS(1633),
    [sym_nan] = ACTIONS(1633),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1631),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [284] = {
    [sym_function_definition] = STATE(224),
    [sym_lambda_function] = STATE(224),
    [sym_if] = STATE(224),
    [sym_while] = STATE(224),
    [sym_repeat] = STATE(224),
    [sym_for] = STATE(224),
    [sym_switch] = STATE(224),
    [sym_call] = STATE(224),
    [sym__assignment] = STATE(224),
    [sym_left_assignment] = STATE(224),
    [sym_left_assignment2] = STATE(224),
    [sym_equals_assignment] = STATE(224),
    [sym_super_assignment] = STATE(224),
    [sym_super_right_assignment] = STATE(224),
    [sym_right_assignment] = STATE(224),
    [sym_brace_list] = STATE(224),
    [sym_paren_list] = STATE(224),
    [sym_subset] = STATE(224),
    [sym_subset2] = STATE(224),
    [sym_dollar] = STATE(224),
    [sym_slot] = STATE(224),
    [sym_namespace_get] = STATE(224),
    [sym_namespace_get_internal] = STATE(224),
    [sym_pipe] = STATE(224),
    [sym_unary] = STATE(224),
    [sym_binary] = STATE(224),
    [sym_na] = STATE(224),
    [sym__expression] = STATE(224),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(224),
    [sym_string] = STATE(224),
    [anon_sym_SEMI] = ACTIONS(1635),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1637),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1637),
    [sym_next] = ACTIONS(1637),
    [sym_true] = ACTIONS(1637),
    [sym_false] = ACTIONS(1637),
    [sym_null] = ACTIONS(1637),
    [sym_inf] = ACTIONS(1637),
    [sym_nan] = ACTIONS(1637),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1635),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [285] = {
    [sym_function_definition] = STATE(800),
    [sym_lambda_function] = STATE(800),
    [sym_if] = STATE(800),
    [sym_while] = STATE(800),
    [sym_repeat] = STATE(800),
    [sym_for] = STATE(800),
    [sym_switch] = STATE(800),
    [sym_call] = STATE(800),
    [sym__assignment] = STATE(800),
    [sym_left_assignment] = STATE(800),
    [sym_left_assignment2] = STATE(800),
    [sym_equals_assignment] = STATE(800),
    [sym_super_assignment] = STATE(800),
    [sym_super_right_assignment] = STATE(800),
    [sym_right_assignment] = STATE(800),
    [sym_brace_list] = STATE(800),
    [sym_paren_list] = STATE(800),
    [sym_subset] = STATE(800),
    [sym_subset2] = STATE(800),
    [sym_dollar] = STATE(800),
    [sym_slot] = STATE(800),
    [sym_namespace_get] = STATE(800),
    [sym_namespace_get_internal] = STATE(800),
    [sym_pipe] = STATE(800),
    [sym_unary] = STATE(800),
    [sym_binary] = STATE(800),
    [sym_na] = STATE(800),
    [sym__expression] = STATE(800),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(800),
    [sym_string] = STATE(800),
    [anon_sym_SEMI] = ACTIONS(1639),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1641),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1641),
    [sym_next] = ACTIONS(1641),
    [sym_true] = ACTIONS(1641),
    [sym_false] = ACTIONS(1641),
    [sym_null] = ACTIONS(1641),
    [sym_inf] = ACTIONS(1641),
    [sym_nan] = ACTIONS(1641),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1639),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [286] = {
    [sym_function_definition] = STATE(893),
    [sym_lambda_function] = STATE(893),
    [sym_if] = STATE(893),
    [sym_while] = STATE(893),
    [sym_repeat] = STATE(893),
    [sym_for] = STATE(893),
    [sym_switch] = STATE(893),
    [sym_call] = STATE(893),
    [sym__assignment] = STATE(893),
    [sym_left_assignment] = STATE(893),
    [sym_left_assignment2] = STATE(893),
    [sym_equals_assignment] = STATE(893),
    [sym_super_assignment] = STATE(893),
    [sym_super_right_assignment] = STATE(893),
    [sym_right_assignment] = STATE(893),
    [sym_brace_list] = STATE(893),
    [sym_paren_list] = STATE(893),
    [sym_subset] = STATE(893),
    [sym_subset2] = STATE(893),
    [sym_dollar] = STATE(893),
    [sym_slot] = STATE(893),
    [sym_namespace_get] = STATE(893),
    [sym_namespace_get_internal] = STATE(893),
    [sym_pipe] = STATE(893),
    [sym_unary] = STATE(893),
    [sym_binary] = STATE(893),
    [sym_na] = STATE(893),
    [sym__expression] = STATE(893),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(893),
    [sym_string] = STATE(893),
    [anon_sym_SEMI] = ACTIONS(1643),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1645),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1645),
    [sym_next] = ACTIONS(1645),
    [sym_true] = ACTIONS(1645),
    [sym_false] = ACTIONS(1645),
    [sym_null] = ACTIONS(1645),
    [sym_inf] = ACTIONS(1645),
    [sym_nan] = ACTIONS(1645),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1643),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [287] = {
    [sym_function_definition] = STATE(225),
    [sym_lambda_function] = STATE(225),
    [sym_if] = STATE(225),
    [sym_while] = STATE(225),
    [sym_repeat] = STATE(225),
    [sym_for] = STATE(225),
    [sym_switch] = STATE(225),
    [sym_call] = STATE(225),
    [sym__assignment] = STATE(225),
    [sym_left_assignment] = STATE(225),
    [sym_left_assignment2] = STATE(225),
    [sym_equals_assignment] = STATE(225),
    [sym_super_assignment] = STATE(225),
    [sym_super_right_assignment] = STATE(225),
    [sym_right_assignment] = STATE(225),
    [sym_brace_list] = STATE(225),
    [sym_paren_list] = STATE(225),
    [sym_subset] = STATE(225),
    [sym_subset2] = STATE(225),
    [sym_dollar] = STATE(225),
    [sym_slot] = STATE(225),
    [sym_namespace_get] = STATE(225),
    [sym_namespace_get_internal] = STATE(225),
    [sym_pipe] = STATE(225),
    [sym_unary] = STATE(225),
    [sym_binary] = STATE(225),
    [sym_na] = STATE(225),
    [sym__expression] = STATE(225),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(225),
    [sym_string] = STATE(225),
    [anon_sym_SEMI] = ACTIONS(1647),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1649),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1649),
    [sym_next] = ACTIONS(1649),
    [sym_true] = ACTIONS(1649),
    [sym_false] = ACTIONS(1649),
    [sym_null] = ACTIONS(1649),
    [sym_inf] = ACTIONS(1649),
    [sym_nan] = ACTIONS(1649),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1647),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [288] = {
    [sym_function_definition] = STATE(226),
    [sym_lambda_function] = STATE(226),
    [sym_if] = STATE(226),
    [sym_while] = STATE(226),
    [sym_repeat] = STATE(226),
    [sym_for] = STATE(226),
    [sym_switch] = STATE(226),
    [sym_call] = STATE(226),
    [sym__assignment] = STATE(226),
    [sym_left_assignment] = STATE(226),
    [sym_left_assignment2] = STATE(226),
    [sym_equals_assignment] = STATE(226),
    [sym_super_assignment] = STATE(226),
    [sym_super_right_assignment] = STATE(226),
    [sym_right_assignment] = STATE(226),
    [sym_brace_list] = STATE(226),
    [sym_paren_list] = STATE(226),
    [sym_subset] = STATE(226),
    [sym_subset2] = STATE(226),
    [sym_dollar] = STATE(226),
    [sym_slot] = STATE(226),
    [sym_namespace_get] = STATE(226),
    [sym_namespace_get_internal] = STATE(226),
    [sym_pipe] = STATE(226),
    [sym_unary] = STATE(226),
    [sym_binary] = STATE(226),
    [sym_na] = STATE(226),
    [sym__expression] = STATE(226),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(226),
    [sym_string] = STATE(226),
    [anon_sym_SEMI] = ACTIONS(1651),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1653),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1653),
    [sym_next] = ACTIONS(1653),
    [sym_true] = ACTIONS(1653),
    [sym_false] = ACTIONS(1653),
    [sym_null] = ACTIONS(1653),
    [sym_inf] = ACTIONS(1653),
    [sym_nan] = ACTIONS(1653),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1651),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [289] = {
    [sym_function_definition] = STATE(235),
    [sym_lambda_function] = STATE(235),
    [sym_if] = STATE(235),
    [sym_while] = STATE(235),
    [sym_repeat] = STATE(235),
    [sym_for] = STATE(235),
    [sym_switch] = STATE(235),
    [sym_call] = STATE(235),
    [sym__assignment] = STATE(235),
    [sym_left_assignment] = STATE(235),
    [sym_left_assignment2] = STATE(235),
    [sym_equals_assignment] = STATE(235),
    [sym_super_assignment] = STATE(235),
    [sym_super_right_assignment] = STATE(235),
    [sym_right_assignment] = STATE(235),
    [sym_brace_list] = STATE(235),
    [sym_paren_list] = STATE(235),
    [sym_subset] = STATE(235),
    [sym_subset2] = STATE(235),
    [sym_dollar] = STATE(235),
    [sym_slot] = STATE(235),
    [sym_namespace_get] = STATE(235),
    [sym_namespace_get_internal] = STATE(235),
    [sym_pipe] = STATE(235),
    [sym_unary] = STATE(235),
    [sym_binary] = STATE(235),
    [sym_na] = STATE(235),
    [sym__expression] = STATE(235),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(235),
    [sym_string] = STATE(235),
    [anon_sym_SEMI] = ACTIONS(1655),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1657),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1657),
    [sym_next] = ACTIONS(1657),
    [sym_true] = ACTIONS(1657),
    [sym_false] = ACTIONS(1657),
    [sym_null] = ACTIONS(1657),
    [sym_inf] = ACTIONS(1657),
    [sym_nan] = ACTIONS(1657),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1655),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [290] = {
    [sym_function_definition] = STATE(236),
    [sym_lambda_function] = STATE(236),
    [sym_if] = STATE(236),
    [sym_while] = STATE(236),
    [sym_repeat] = STATE(236),
    [sym_for] = STATE(236),
    [sym_switch] = STATE(236),
    [sym_call] = STATE(236),
    [sym__assignment] = STATE(236),
    [sym_left_assignment] = STATE(236),
    [sym_left_assignment2] = STATE(236),
    [sym_equals_assignment] = STATE(236),
    [sym_super_assignment] = STATE(236),
    [sym_super_right_assignment] = STATE(236),
    [sym_right_assignment] = STATE(236),
    [sym_brace_list] = STATE(236),
    [sym_paren_list] = STATE(236),
    [sym_subset] = STATE(236),
    [sym_subset2] = STATE(236),
    [sym_dollar] = STATE(236),
    [sym_slot] = STATE(236),
    [sym_namespace_get] = STATE(236),
    [sym_namespace_get_internal] = STATE(236),
    [sym_pipe] = STATE(236),
    [sym_unary] = STATE(236),
    [sym_binary] = STATE(236),
    [sym_na] = STATE(236),
    [sym__expression] = STATE(236),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(236),
    [sym_string] = STATE(236),
    [anon_sym_SEMI] = ACTIONS(1659),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1661),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1661),
    [sym_next] = ACTIONS(1661),
    [sym_true] = ACTIONS(1661),
    [sym_false] = ACTIONS(1661),
    [sym_null] = ACTIONS(1661),
    [sym_inf] = ACTIONS(1661),
    [sym_nan] = ACTIONS(1661),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1659),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [291] = {
    [sym_function_definition] = STATE(239),
    [sym_lambda_function] = STATE(239),
    [sym_if] = STATE(239),
    [sym_while] = STATE(239),
    [sym_repeat] = STATE(239),
    [sym_for] = STATE(239),
    [sym_switch] = STATE(239),
    [sym_call] = STATE(239),
    [sym__assignment] = STATE(239),
    [sym_left_assignment] = STATE(239),
    [sym_left_assignment2] = STATE(239),
    [sym_equals_assignment] = STATE(239),
    [sym_super_assignment] = STATE(239),
    [sym_super_right_assignment] = STATE(239),
    [sym_right_assignment] = STATE(239),
    [sym_brace_list] = STATE(239),
    [sym_paren_list] = STATE(239),
    [sym_subset] = STATE(239),
    [sym_subset2] = STATE(239),
    [sym_dollar] = STATE(239),
    [sym_slot] = STATE(239),
    [sym_namespace_get] = STATE(239),
    [sym_namespace_get_internal] = STATE(239),
    [sym_pipe] = STATE(239),
    [sym_unary] = STATE(239),
    [sym_binary] = STATE(239),
    [sym_na] = STATE(239),
    [sym__expression] = STATE(239),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(239),
    [sym_string] = STATE(239),
    [anon_sym_SEMI] = ACTIONS(1663),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1665),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1665),
    [sym_next] = ACTIONS(1665),
    [sym_true] = ACTIONS(1665),
    [sym_false] = ACTIONS(1665),
    [sym_null] = ACTIONS(1665),
    [sym_inf] = ACTIONS(1665),
    [sym_nan] = ACTIONS(1665),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1663),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [292] = {
    [sym_function_definition] = STATE(240),
    [sym_lambda_function] = STATE(240),
    [sym_if] = STATE(240),
    [sym_while] = STATE(240),
    [sym_repeat] = STATE(240),
    [sym_for] = STATE(240),
    [sym_switch] = STATE(240),
    [sym_call] = STATE(240),
    [sym__assignment] = STATE(240),
    [sym_left_assignment] = STATE(240),
    [sym_left_assignment2] = STATE(240),
    [sym_equals_assignment] = STATE(240),
    [sym_super_assignment] = STATE(240),
    [sym_super_right_assignment] = STATE(240),
    [sym_right_assignment] = STATE(240),
    [sym_brace_list] = STATE(240),
    [sym_paren_list] = STATE(240),
    [sym_subset] = STATE(240),
    [sym_subset2] = STATE(240),
    [sym_dollar] = STATE(240),
    [sym_slot] = STATE(240),
    [sym_namespace_get] = STATE(240),
    [sym_namespace_get_internal] = STATE(240),
    [sym_pipe] = STATE(240),
    [sym_unary] = STATE(240),
    [sym_binary] = STATE(240),
    [sym_na] = STATE(240),
    [sym__expression] = STATE(240),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(240),
    [sym_string] = STATE(240),
    [anon_sym_SEMI] = ACTIONS(1667),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1669),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1669),
    [sym_next] = ACTIONS(1669),
    [sym_true] = ACTIONS(1669),
    [sym_false] = ACTIONS(1669),
    [sym_null] = ACTIONS(1669),
    [sym_inf] = ACTIONS(1669),
    [sym_nan] = ACTIONS(1669),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1667),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [293] = {
    [sym_function_definition] = STATE(241),
    [sym_lambda_function] = STATE(241),
    [sym_if] = STATE(241),
    [sym_while] = STATE(241),
    [sym_repeat] = STATE(241),
    [sym_for] = STATE(241),
    [sym_switch] = STATE(241),
    [sym_call] = STATE(241),
    [sym__assignment] = STATE(241),
    [sym_left_assignment] = STATE(241),
    [sym_left_assignment2] = STATE(241),
    [sym_equals_assignment] = STATE(241),
    [sym_super_assignment] = STATE(241),
    [sym_super_right_assignment] = STATE(241),
    [sym_right_assignment] = STATE(241),
    [sym_brace_list] = STATE(241),
    [sym_paren_list] = STATE(241),
    [sym_subset] = STATE(241),
    [sym_subset2] = STATE(241),
    [sym_dollar] = STATE(241),
    [sym_slot] = STATE(241),
    [sym_namespace_get] = STATE(241),
    [sym_namespace_get_internal] = STATE(241),
    [sym_pipe] = STATE(241),
    [sym_unary] = STATE(241),
    [sym_binary] = STATE(241),
    [sym_na] = STATE(241),
    [sym__expression] = STATE(241),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(241),
    [sym_string] = STATE(241),
    [anon_sym_SEMI] = ACTIONS(1671),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1673),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1673),
    [sym_next] = ACTIONS(1673),
    [sym_true] = ACTIONS(1673),
    [sym_false] = ACTIONS(1673),
    [sym_null] = ACTIONS(1673),
    [sym_inf] = ACTIONS(1673),
    [sym_nan] = ACTIONS(1673),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1671),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [294] = {
    [sym_function_definition] = STATE(896),
    [sym_lambda_function] = STATE(896),
    [sym_if] = STATE(896),
    [sym_while] = STATE(896),
    [sym_repeat] = STATE(896),
    [sym_for] = STATE(896),
    [sym_switch] = STATE(896),
    [sym_call] = STATE(896),
    [sym__assignment] = STATE(896),
    [sym_left_assignment] = STATE(896),
    [sym_left_assignment2] = STATE(896),
    [sym_equals_assignment] = STATE(896),
    [sym_super_assignment] = STATE(896),
    [sym_super_right_assignment] = STATE(896),
    [sym_right_assignment] = STATE(896),
    [sym_brace_list] = STATE(896),
    [sym_paren_list] = STATE(896),
    [sym_subset] = STATE(896),
    [sym_subset2] = STATE(896),
    [sym_dollar] = STATE(896),
    [sym_slot] = STATE(896),
    [sym_namespace_get] = STATE(896),
    [sym_namespace_get_internal] = STATE(896),
    [sym_pipe] = STATE(896),
    [sym_unary] = STATE(896),
    [sym_binary] = STATE(896),
    [sym_na] = STATE(896),
    [sym__expression] = STATE(896),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(896),
    [sym_string] = STATE(896),
    [anon_sym_SEMI] = ACTIONS(1675),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1677),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1677),
    [sym_next] = ACTIONS(1677),
    [sym_true] = ACTIONS(1677),
    [sym_false] = ACTIONS(1677),
    [sym_null] = ACTIONS(1677),
    [sym_inf] = ACTIONS(1677),
    [sym_nan] = ACTIONS(1677),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1675),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [295] = {
    [sym_function_definition] = STATE(116),
    [sym_lambda_function] = STATE(116),
    [sym_if] = STATE(116),
    [sym_while] = STATE(116),
    [sym_repeat] = STATE(116),
    [sym_for] = STATE(116),
    [sym_switch] = STATE(116),
    [sym_call] = STATE(116),
    [sym__assignment] = STATE(116),
    [sym_left_assignment] = STATE(116),
    [sym_left_assignment2] = STATE(116),
    [sym_equals_assignment] = STATE(116),
    [sym_super_assignment] = STATE(116),
    [sym_super_right_assignment] = STATE(116),
    [sym_right_assignment] = STATE(116),
    [sym_brace_list] = STATE(116),
    [sym_paren_list] = STATE(116),
    [sym_subset] = STATE(116),
    [sym_subset2] = STATE(116),
    [sym_dollar] = STATE(116),
    [sym_slot] = STATE(116),
    [sym_namespace_get] = STATE(116),
    [sym_namespace_get_internal] = STATE(116),
    [sym_pipe] = STATE(116),
    [sym_unary] = STATE(116),
    [sym_binary] = STATE(116),
    [sym_na] = STATE(116),
    [sym__expression] = STATE(116),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(116),
    [sym_string] = STATE(116),
    [anon_sym_SEMI] = ACTIONS(1679),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1681),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1681),
    [sym_next] = ACTIONS(1681),
    [sym_true] = ACTIONS(1681),
    [sym_false] = ACTIONS(1681),
    [sym_null] = ACTIONS(1681),
    [sym_inf] = ACTIONS(1681),
    [sym_nan] = ACTIONS(1681),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1679),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [296] = {
    [sym_function_definition] = STATE(924),
    [sym_lambda_function] = STATE(924),
    [sym_if] = STATE(924),
    [sym_while] = STATE(924),
    [sym_repeat] = STATE(924),
    [sym_for] = STATE(924),
    [sym_switch] = STATE(924),
    [sym_call] = STATE(453),
    [sym__assignment] = STATE(924),
    [sym_left_assignment] = STATE(924),
    [sym_left_assignment2] = STATE(924),
    [sym_equals_assignment] = STATE(924),
    [sym_super_assignment] = STATE(924),
    [sym_super_right_assignment] = STATE(924),
    [sym_right_assignment] = STATE(924),
    [sym_brace_list] = STATE(924),
    [sym_paren_list] = STATE(924),
    [sym_subset] = STATE(924),
    [sym_subset2] = STATE(924),
    [sym_dollar] = STATE(924),
    [sym_slot] = STATE(924),
    [sym_namespace_get] = STATE(924),
    [sym_namespace_get_internal] = STATE(924),
    [sym_pipe] = STATE(924),
    [sym_unary] = STATE(924),
    [sym_binary] = STATE(924),
    [sym_na] = STATE(924),
    [sym__expression] = STATE(924),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(924),
    [sym_string] = STATE(924),
    [anon_sym_SEMI] = ACTIONS(1683),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1685),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1685),
    [sym_next] = ACTIONS(1685),
    [sym_true] = ACTIONS(1685),
    [sym_false] = ACTIONS(1685),
    [sym_null] = ACTIONS(1685),
    [sym_inf] = ACTIONS(1685),
    [sym_nan] = ACTIONS(1685),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1683),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [297] = {
    [sym_function_definition] = STATE(246),
    [sym_lambda_function] = STATE(246),
    [sym_if] = STATE(246),
    [sym_while] = STATE(246),
    [sym_repeat] = STATE(246),
    [sym_for] = STATE(246),
    [sym_switch] = STATE(246),
    [sym_call] = STATE(246),
    [sym__assignment] = STATE(246),
    [sym_left_assignment] = STATE(246),
    [sym_left_assignment2] = STATE(246),
    [sym_equals_assignment] = STATE(246),
    [sym_super_assignment] = STATE(246),
    [sym_super_right_assignment] = STATE(246),
    [sym_right_assignment] = STATE(246),
    [sym_brace_list] = STATE(246),
    [sym_paren_list] = STATE(246),
    [sym_subset] = STATE(246),
    [sym_subset2] = STATE(246),
    [sym_dollar] = STATE(246),
    [sym_slot] = STATE(246),
    [sym_namespace_get] = STATE(246),
    [sym_namespace_get_internal] = STATE(246),
    [sym_pipe] = STATE(246),
    [sym_unary] = STATE(246),
    [sym_binary] = STATE(246),
    [sym_na] = STATE(246),
    [sym__expression] = STATE(246),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(246),
    [sym_string] = STATE(246),
    [anon_sym_SEMI] = ACTIONS(1687),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1689),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1689),
    [sym_next] = ACTIONS(1689),
    [sym_true] = ACTIONS(1689),
    [sym_false] = ACTIONS(1689),
    [sym_null] = ACTIONS(1689),
    [sym_inf] = ACTIONS(1689),
    [sym_nan] = ACTIONS(1689),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1687),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [298] = {
    [sym_function_definition] = STATE(661),
    [sym_lambda_function] = STATE(661),
    [sym_if] = STATE(661),
    [sym_while] = STATE(661),
    [sym_repeat] = STATE(661),
    [sym_for] = STATE(661),
    [sym_switch] = STATE(661),
    [sym_call] = STATE(661),
    [sym__assignment] = STATE(661),
    [sym_left_assignment] = STATE(661),
    [sym_left_assignment2] = STATE(661),
    [sym_equals_assignment] = STATE(661),
    [sym_super_assignment] = STATE(661),
    [sym_super_right_assignment] = STATE(661),
    [sym_right_assignment] = STATE(661),
    [sym_brace_list] = STATE(661),
    [sym_paren_list] = STATE(661),
    [sym_subset] = STATE(661),
    [sym_subset2] = STATE(661),
    [sym_dollar] = STATE(661),
    [sym_slot] = STATE(661),
    [sym_namespace_get] = STATE(661),
    [sym_namespace_get_internal] = STATE(661),
    [sym_pipe] = STATE(661),
    [sym_unary] = STATE(661),
    [sym_binary] = STATE(661),
    [sym_na] = STATE(661),
    [sym__expression] = STATE(661),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(661),
    [sym_string] = STATE(661),
    [anon_sym_SEMI] = ACTIONS(1691),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1693),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1693),
    [sym_next] = ACTIONS(1693),
    [sym_true] = ACTIONS(1693),
    [sym_false] = ACTIONS(1693),
    [sym_null] = ACTIONS(1693),
    [sym_inf] = ACTIONS(1693),
    [sym_nan] = ACTIONS(1693),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1691),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [299] = {
    [sym_function_definition] = STATE(671),
    [sym_lambda_function] = STATE(671),
    [sym_if] = STATE(671),
    [sym_while] = STATE(671),
    [sym_repeat] = STATE(671),
    [sym_for] = STATE(671),
    [sym_switch] = STATE(671),
    [sym_call] = STATE(671),
    [sym__assignment] = STATE(671),
    [sym_left_assignment] = STATE(671),
    [sym_left_assignment2] = STATE(671),
    [sym_equals_assignment] = STATE(671),
    [sym_super_assignment] = STATE(671),
    [sym_super_right_assignment] = STATE(671),
    [sym_right_assignment] = STATE(671),
    [sym_brace_list] = STATE(671),
    [sym_paren_list] = STATE(671),
    [sym_subset] = STATE(671),
    [sym_subset2] = STATE(671),
    [sym_dollar] = STATE(671),
    [sym_slot] = STATE(671),
    [sym_namespace_get] = STATE(671),
    [sym_namespace_get_internal] = STATE(671),
    [sym_pipe] = STATE(671),
    [sym_unary] = STATE(671),
    [sym_binary] = STATE(671),
    [sym_na] = STATE(671),
    [sym__expression] = STATE(671),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(671),
    [sym_string] = STATE(671),
    [anon_sym_SEMI] = ACTIONS(1695),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1697),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1697),
    [sym_next] = ACTIONS(1697),
    [sym_true] = ACTIONS(1697),
    [sym_false] = ACTIONS(1697),
    [sym_null] = ACTIONS(1697),
    [sym_inf] = ACTIONS(1697),
    [sym_nan] = ACTIONS(1697),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1695),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [300] = {
    [anon_sym_LF] = ACTIONS(655),
    [anon_sym_SEMI] = ACTIONS(655),
    [anon_sym_function] = ACTIONS(655),
    [anon_sym_BSLASH] = ACTIONS(655),
    [anon_sym_if] = ACTIONS(655),
    [anon_sym_LPAREN] = ACTIONS(655),
    [anon_sym_else] = ACTIONS(655),
    [anon_sym_while] = ACTIONS(655),
    [anon_sym_repeat] = ACTIONS(655),
    [anon_sym_for] = ACTIONS(655),
    [anon_sym_switch] = ACTIONS(655),
    [anon_sym_EQ] = ACTIONS(655),
    [anon_sym_LBRACE] = ACTIONS(655),
    [anon_sym_RBRACE] = ACTIONS(655),
    [anon_sym_LT_DASH] = ACTIONS(655),
    [anon_sym_COLON_EQ] = ACTIONS(655),
    [anon_sym_LT_LT_DASH] = ACTIONS(655),
    [anon_sym_DASH_GT_GT] = ACTIONS(655),
    [anon_sym_DASH_GT] = ACTIONS(655),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(655),
    [anon_sym_DOLLAR] = ACTIONS(655),
    [anon_sym_AT] = ACTIONS(655),
    [anon_sym_COLON_COLON] = ACTIONS(655),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(655),
    [sym_dots] = ACTIONS(655),
    [anon_sym_PIPE_GT] = ACTIONS(655),
    [anon_sym_DASH] = ACTIONS(655),
    [anon_sym_PLUS] = ACTIONS(655),
    [anon_sym_BANG] = ACTIONS(655),
    [anon_sym_TILDE] = ACTIONS(655),
    [anon_sym_STAR] = ACTIONS(655),
    [anon_sym_SLASH] = ACTIONS(655),
    [anon_sym_CARET] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(655),
    [anon_sym_GT] = ACTIONS(655),
    [anon_sym_LT_EQ] = ACTIONS(655),
    [anon_sym_GT_EQ] = ACTIONS(655),
    [anon_sym_EQ_EQ] = ACTIONS(655),
    [anon_sym_BANG_EQ] = ACTIONS(655),
    [anon_sym_PIPE_PIPE] = ACTIONS(655),
    [anon_sym_PIPE] = ACTIONS(655),
    [anon_sym_AMP_AMP] = ACTIONS(655),
    [anon_sym_AMP] = ACTIONS(655),
    [anon_sym_COLON] = ACTIONS(655),
    [sym_break] = ACTIONS(655),
    [sym_next] = ACTIONS(655),
    [sym_true] = ACTIONS(655),
    [sym_false] = ACTIONS(655),
    [sym_null] = ACTIONS(655),
    [sym_inf] = ACTIONS(655),
    [sym_nan] = ACTIONS(655),
    [anon_sym_NA] = ACTIONS(655),
    [anon_sym_NA_character_] = ACTIONS(655),
    [anon_sym_NA_complex_] = ACTIONS(655),
    [anon_sym_NA_integer_] = ACTIONS(655),
    [anon_sym_NA_real_] = ACTIONS(655),
    [aux_sym_identifier_token1] = ACTIONS(655),
    [anon_sym_BQUOTE] = ACTIONS(655),
    [sym_integer] = ACTIONS(655),
    [sym_float] = ACTIONS(655),
    [sym_comment] = ACTIONS(1497),
    [anon_sym_DQUOTE] = ACTIONS(655),
    [anon_sym_SQUOTE] = ACTIONS(655),
    [anon_sym_PERCENT] = ACTIONS(655),
  },
  [301] = {
    [sym_function_definition] = STATE(919),
    [sym_lambda_function] = STATE(919),
    [sym_if] = STATE(919),
    [sym_while] = STATE(919),
    [sym_repeat] = STATE(919),
    [sym_for] = STATE(919),
    [sym_switch] = STATE(919),
    [sym_call] = STATE(791),
    [sym__assignment] = STATE(919),
    [sym_left_assignment] = STATE(919),
    [sym_left_assignment2] = STATE(919),
    [sym_equals_assignment] = STATE(919),
    [sym_super_assignment] = STATE(919),
    [sym_super_right_assignment] = STATE(919),
    [sym_right_assignment] = STATE(919),
    [sym_brace_list] = STATE(919),
    [sym_paren_list] = STATE(919),
    [sym_subset] = STATE(919),
    [sym_subset2] = STATE(919),
    [sym_dollar] = STATE(919),
    [sym_slot] = STATE(919),
    [sym_namespace_get] = STATE(919),
    [sym_namespace_get_internal] = STATE(919),
    [sym_pipe] = STATE(919),
    [sym_unary] = STATE(919),
    [sym_binary] = STATE(919),
    [sym_na] = STATE(919),
    [sym__expression] = STATE(919),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(919),
    [sym_string] = STATE(919),
    [anon_sym_SEMI] = ACTIONS(1699),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1701),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1701),
    [sym_next] = ACTIONS(1701),
    [sym_true] = ACTIONS(1701),
    [sym_false] = ACTIONS(1701),
    [sym_null] = ACTIONS(1701),
    [sym_inf] = ACTIONS(1701),
    [sym_nan] = ACTIONS(1701),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1699),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [302] = {
    [sym_function_definition] = STATE(548),
    [sym_lambda_function] = STATE(548),
    [sym_if] = STATE(548),
    [sym_while] = STATE(548),
    [sym_repeat] = STATE(548),
    [sym_for] = STATE(548),
    [sym_switch] = STATE(548),
    [sym_call] = STATE(548),
    [sym__assignment] = STATE(548),
    [sym_left_assignment] = STATE(548),
    [sym_left_assignment2] = STATE(548),
    [sym_equals_assignment] = STATE(548),
    [sym_super_assignment] = STATE(548),
    [sym_super_right_assignment] = STATE(548),
    [sym_right_assignment] = STATE(548),
    [sym_brace_list] = STATE(548),
    [sym_paren_list] = STATE(548),
    [sym_subset] = STATE(548),
    [sym_subset2] = STATE(548),
    [sym_dollar] = STATE(548),
    [sym_slot] = STATE(548),
    [sym_namespace_get] = STATE(548),
    [sym_namespace_get_internal] = STATE(548),
    [sym_pipe] = STATE(548),
    [sym_unary] = STATE(548),
    [sym_binary] = STATE(548),
    [sym_na] = STATE(548),
    [sym__expression] = STATE(548),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(548),
    [sym_string] = STATE(548),
    [anon_sym_SEMI] = ACTIONS(1703),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1705),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1705),
    [sym_next] = ACTIONS(1705),
    [sym_true] = ACTIONS(1705),
    [sym_false] = ACTIONS(1705),
    [sym_null] = ACTIONS(1705),
    [sym_inf] = ACTIONS(1705),
    [sym_nan] = ACTIONS(1705),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1703),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [303] = {
    [sym_function_definition] = STATE(483),
    [sym_lambda_function] = STATE(483),
    [sym_if] = STATE(483),
    [sym_while] = STATE(483),
    [sym_repeat] = STATE(483),
    [sym_for] = STATE(483),
    [sym_switch] = STATE(483),
    [sym_call] = STATE(483),
    [sym__assignment] = STATE(483),
    [sym_left_assignment] = STATE(483),
    [sym_left_assignment2] = STATE(483),
    [sym_equals_assignment] = STATE(483),
    [sym_super_assignment] = STATE(483),
    [sym_super_right_assignment] = STATE(483),
    [sym_right_assignment] = STATE(483),
    [sym_brace_list] = STATE(483),
    [sym_paren_list] = STATE(483),
    [sym_subset] = STATE(483),
    [sym_subset2] = STATE(483),
    [sym_dollar] = STATE(483),
    [sym_slot] = STATE(483),
    [sym_namespace_get] = STATE(483),
    [sym_namespace_get_internal] = STATE(483),
    [sym_pipe] = STATE(483),
    [sym_unary] = STATE(483),
    [sym_binary] = STATE(483),
    [sym_na] = STATE(483),
    [sym__expression] = STATE(483),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(483),
    [sym_string] = STATE(483),
    [anon_sym_SEMI] = ACTIONS(1707),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1709),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1709),
    [sym_next] = ACTIONS(1709),
    [sym_true] = ACTIONS(1709),
    [sym_false] = ACTIONS(1709),
    [sym_null] = ACTIONS(1709),
    [sym_inf] = ACTIONS(1709),
    [sym_nan] = ACTIONS(1709),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1707),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [304] = {
    [sym_function_definition] = STATE(485),
    [sym_lambda_function] = STATE(485),
    [sym_if] = STATE(485),
    [sym_while] = STATE(485),
    [sym_repeat] = STATE(485),
    [sym_for] = STATE(485),
    [sym_switch] = STATE(485),
    [sym_call] = STATE(485),
    [sym__assignment] = STATE(485),
    [sym_left_assignment] = STATE(485),
    [sym_left_assignment2] = STATE(485),
    [sym_equals_assignment] = STATE(485),
    [sym_super_assignment] = STATE(485),
    [sym_super_right_assignment] = STATE(485),
    [sym_right_assignment] = STATE(485),
    [sym_brace_list] = STATE(485),
    [sym_paren_list] = STATE(485),
    [sym_subset] = STATE(485),
    [sym_subset2] = STATE(485),
    [sym_dollar] = STATE(485),
    [sym_slot] = STATE(485),
    [sym_namespace_get] = STATE(485),
    [sym_namespace_get_internal] = STATE(485),
    [sym_pipe] = STATE(485),
    [sym_unary] = STATE(485),
    [sym_binary] = STATE(485),
    [sym_na] = STATE(485),
    [sym__expression] = STATE(485),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(485),
    [sym_string] = STATE(485),
    [anon_sym_SEMI] = ACTIONS(1711),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1713),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1713),
    [sym_next] = ACTIONS(1713),
    [sym_true] = ACTIONS(1713),
    [sym_false] = ACTIONS(1713),
    [sym_null] = ACTIONS(1713),
    [sym_inf] = ACTIONS(1713),
    [sym_nan] = ACTIONS(1713),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1711),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [305] = {
    [sym_function_definition] = STATE(486),
    [sym_lambda_function] = STATE(486),
    [sym_if] = STATE(486),
    [sym_while] = STATE(486),
    [sym_repeat] = STATE(486),
    [sym_for] = STATE(486),
    [sym_switch] = STATE(486),
    [sym_call] = STATE(486),
    [sym__assignment] = STATE(486),
    [sym_left_assignment] = STATE(486),
    [sym_left_assignment2] = STATE(486),
    [sym_equals_assignment] = STATE(486),
    [sym_super_assignment] = STATE(486),
    [sym_super_right_assignment] = STATE(486),
    [sym_right_assignment] = STATE(486),
    [sym_brace_list] = STATE(486),
    [sym_paren_list] = STATE(486),
    [sym_subset] = STATE(486),
    [sym_subset2] = STATE(486),
    [sym_dollar] = STATE(486),
    [sym_slot] = STATE(486),
    [sym_namespace_get] = STATE(486),
    [sym_namespace_get_internal] = STATE(486),
    [sym_pipe] = STATE(486),
    [sym_unary] = STATE(486),
    [sym_binary] = STATE(486),
    [sym_na] = STATE(486),
    [sym__expression] = STATE(486),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(486),
    [sym_string] = STATE(486),
    [anon_sym_SEMI] = ACTIONS(1715),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1717),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1717),
    [sym_next] = ACTIONS(1717),
    [sym_true] = ACTIONS(1717),
    [sym_false] = ACTIONS(1717),
    [sym_null] = ACTIONS(1717),
    [sym_inf] = ACTIONS(1717),
    [sym_nan] = ACTIONS(1717),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1715),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [306] = {
    [sym_function_definition] = STATE(487),
    [sym_lambda_function] = STATE(487),
    [sym_if] = STATE(487),
    [sym_while] = STATE(487),
    [sym_repeat] = STATE(487),
    [sym_for] = STATE(487),
    [sym_switch] = STATE(487),
    [sym_call] = STATE(487),
    [sym__assignment] = STATE(487),
    [sym_left_assignment] = STATE(487),
    [sym_left_assignment2] = STATE(487),
    [sym_equals_assignment] = STATE(487),
    [sym_super_assignment] = STATE(487),
    [sym_super_right_assignment] = STATE(487),
    [sym_right_assignment] = STATE(487),
    [sym_brace_list] = STATE(487),
    [sym_paren_list] = STATE(487),
    [sym_subset] = STATE(487),
    [sym_subset2] = STATE(487),
    [sym_dollar] = STATE(487),
    [sym_slot] = STATE(487),
    [sym_namespace_get] = STATE(487),
    [sym_namespace_get_internal] = STATE(487),
    [sym_pipe] = STATE(487),
    [sym_unary] = STATE(487),
    [sym_binary] = STATE(487),
    [sym_na] = STATE(487),
    [sym__expression] = STATE(487),
    [sym_identifier] = STATE(388),
    [sym_complex] = STATE(487),
    [sym_string] = STATE(487),
    [anon_sym_SEMI] = ACTIONS(1719),
    [anon_sym_function] = ACTIONS(1089),
    [anon_sym_BSLASH] = ACTIONS(1091),
    [anon_sym_if] = ACTIONS(1093),
    [anon_sym_LPAREN] = ACTIONS(1095),
    [anon_sym_while] = ACTIONS(1097),
    [anon_sym_repeat] = ACTIONS(1099),
    [anon_sym_for] = ACTIONS(1101),
    [anon_sym_switch] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1105),
    [sym_dots] = ACTIONS(1721),
    [anon_sym_DASH] = ACTIONS(1109),
    [anon_sym_PLUS] = ACTIONS(1109),
    [anon_sym_BANG] = ACTIONS(1111),
    [anon_sym_TILDE] = ACTIONS(1113),
    [sym_break] = ACTIONS(1721),
    [sym_next] = ACTIONS(1721),
    [sym_true] = ACTIONS(1721),
    [sym_false] = ACTIONS(1721),
    [sym_null] = ACTIONS(1721),
    [sym_inf] = ACTIONS(1721),
    [sym_nan] = ACTIONS(1721),
    [anon_sym_NA] = ACTIONS(1115),
    [anon_sym_NA_character_] = ACTIONS(1115),
    [anon_sym_NA_complex_] = ACTIONS(1115),
    [anon_sym_NA_integer_] = ACTIONS(1115),
    [anon_sym_NA_real_] = ACTIONS(1115),
    [aux_sym_identifier_token1] = ACTIONS(1117),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [sym_integer] = ACTIONS(1719),
    [sym_float] = ACTIONS(1121),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1125),
  },
  [307] = {
    [sym_function_definition] = STATE(255),
    [sym_lambda_function] = STATE(255),
    [sym_if] = STATE(255),
    [sym_while] = STATE(255),
    [sym_repeat] = STATE(255),
    [sym_for] = STATE(255),
    [sym_switch] = STATE(255),
    [sym_call] = STATE(255),
    [sym__assignment] = STATE(255),
    [sym_left_assignment] = STATE(255),
    [sym_left_assignment2] = STATE(255),
    [sym_equals_assignment] = STATE(255),
    [sym_super_assignment] = STATE(255),
    [sym_super_right_assignment] = STATE(255),
    [sym_right_assignment] = STATE(255),
    [sym_brace_list] = STATE(255),
    [sym_paren_list] = STATE(255),
    [sym_subset] = STATE(255),
    [sym_subset2] = STATE(255),
    [sym_dollar] = STATE(255),
    [sym_slot] = STATE(255),
    [sym_namespace_get] = STATE(255),
    [sym_namespace_get_internal] = STATE(255),
    [sym_pipe] = STATE(255),
    [sym_unary] = STATE(255),
    [sym_binary] = STATE(255),
    [sym_na] = STATE(255),
    [sym__expression] = STATE(255),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(255),
    [sym_string] = STATE(255),
    [anon_sym_SEMI] = ACTIONS(1723),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1725),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1725),
    [sym_next] = ACTIONS(1725),
    [sym_true] = ACTIONS(1725),
    [sym_false] = ACTIONS(1725),
    [sym_null] = ACTIONS(1725),
    [sym_inf] = ACTIONS(1725),
    [sym_nan] = ACTIONS(1725),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1723),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [308] = {
    [sym_function_definition] = STATE(256),
    [sym_lambda_function] = STATE(256),
    [sym_if] = STATE(256),
    [sym_while] = STATE(256),
    [sym_repeat] = STATE(256),
    [sym_for] = STATE(256),
    [sym_switch] = STATE(256),
    [sym_call] = STATE(256),
    [sym__assignment] = STATE(256),
    [sym_left_assignment] = STATE(256),
    [sym_left_assignment2] = STATE(256),
    [sym_equals_assignment] = STATE(256),
    [sym_super_assignment] = STATE(256),
    [sym_super_right_assignment] = STATE(256),
    [sym_right_assignment] = STATE(256),
    [sym_brace_list] = STATE(256),
    [sym_paren_list] = STATE(256),
    [sym_subset] = STATE(256),
    [sym_subset2] = STATE(256),
    [sym_dollar] = STATE(256),
    [sym_slot] = STATE(256),
    [sym_namespace_get] = STATE(256),
    [sym_namespace_get_internal] = STATE(256),
    [sym_pipe] = STATE(256),
    [sym_unary] = STATE(256),
    [sym_binary] = STATE(256),
    [sym_na] = STATE(256),
    [sym__expression] = STATE(256),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(256),
    [sym_string] = STATE(256),
    [anon_sym_SEMI] = ACTIONS(1727),
    [anon_sym_function] = ACTIONS(833),
    [anon_sym_BSLASH] = ACTIONS(835),
    [anon_sym_if] = ACTIONS(837),
    [anon_sym_LPAREN] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(841),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_for] = ACTIONS(845),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LBRACE] = ACTIONS(849),
    [sym_dots] = ACTIONS(1729),
    [anon_sym_DASH] = ACTIONS(853),
    [anon_sym_PLUS] = ACTIONS(853),
    [anon_sym_BANG] = ACTIONS(855),
    [anon_sym_TILDE] = ACTIONS(857),
    [sym_break] = ACTIONS(1729),
    [sym_next] = ACTIONS(1729),
    [sym_true] = ACTIONS(1729),
    [sym_false] = ACTIONS(1729),
    [sym_null] = ACTIONS(1729),
    [sym_inf] = ACTIONS(1729),
    [sym_nan] = ACTIONS(1729),
    [anon_sym_NA] = ACTIONS(859),
    [anon_sym_NA_character_] = ACTIONS(859),
    [anon_sym_NA_complex_] = ACTIONS(859),
    [anon_sym_NA_integer_] = ACTIONS(859),
    [anon_sym_NA_real_] = ACTIONS(859),
    [aux_sym_identifier_token1] = ACTIONS(861),
    [anon_sym_BQUOTE] = ACTIONS(863),
    [sym_integer] = ACTIONS(1727),
    [sym_float] = ACTIONS(865),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(867),
    [anon_sym_SQUOTE] = ACTIONS(869),
  },
  [309] = {
    [sym_function_definition] = STATE(612),
    [sym_lambda_function] = STATE(612),
    [sym_if] = STATE(612),
    [sym_while] = STATE(612),
    [sym_repeat] = STATE(612),
    [sym_for] = STATE(612),
    [sym_switch] = STATE(612),
    [sym_call] = STATE(612),
    [sym__assignment] = STATE(612),
    [sym_left_assignment] = STATE(612),
    [sym_left_assignment2] = STATE(612),
    [sym_equals_assignment] = STATE(612),
    [sym_super_assignment] = STATE(612),
    [sym_super_right_assignment] = STATE(612),
    [sym_right_assignment] = STATE(612),
    [sym_brace_list] = STATE(612),
    [sym_paren_list] = STATE(612),
    [sym_subset] = STATE(612),
    [sym_subset2] = STATE(612),
    [sym_dollar] = STATE(612),
    [sym_slot] = STATE(612),
    [sym_namespace_get] = STATE(612),
    [sym_namespace_get_internal] = STATE(612),
    [sym_pipe] = STATE(612),
    [sym_unary] = STATE(612),
    [sym_binary] = STATE(612),
    [sym_na] = STATE(612),
    [sym__expression] = STATE(612),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(612),
    [sym_string] = STATE(612),
    [anon_sym_SEMI] = ACTIONS(1731),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1733),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1733),
    [sym_next] = ACTIONS(1733),
    [sym_true] = ACTIONS(1733),
    [sym_false] = ACTIONS(1733),
    [sym_null] = ACTIONS(1733),
    [sym_inf] = ACTIONS(1733),
    [sym_nan] = ACTIONS(1733),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1731),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [310] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(437),
    [anon_sym_SEMI] = ACTIONS(1735),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1737),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1737),
    [sym_next] = ACTIONS(1737),
    [sym_true] = ACTIONS(1737),
    [sym_false] = ACTIONS(1737),
    [sym_null] = ACTIONS(1737),
    [sym_inf] = ACTIONS(1737),
    [sym_nan] = ACTIONS(1737),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1735),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [311] = {
    [sym_function_definition] = STATE(474),
    [sym_lambda_function] = STATE(474),
    [sym_if] = STATE(474),
    [sym_while] = STATE(474),
    [sym_repeat] = STATE(474),
    [sym_for] = STATE(474),
    [sym_switch] = STATE(474),
    [sym_call] = STATE(474),
    [sym__assignment] = STATE(474),
    [sym_left_assignment] = STATE(474),
    [sym_left_assignment2] = STATE(474),
    [sym_equals_assignment] = STATE(474),
    [sym_super_assignment] = STATE(474),
    [sym_super_right_assignment] = STATE(474),
    [sym_right_assignment] = STATE(474),
    [sym_brace_list] = STATE(474),
    [sym_paren_list] = STATE(474),
    [sym_subset] = STATE(474),
    [sym_subset2] = STATE(474),
    [sym_dollar] = STATE(474),
    [sym_slot] = STATE(474),
    [sym_namespace_get] = STATE(474),
    [sym_namespace_get_internal] = STATE(474),
    [sym_pipe] = STATE(474),
    [sym_unary] = STATE(474),
    [sym_binary] = STATE(474),
    [sym_na] = STATE(474),
    [sym__expression] = STATE(474),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(474),
    [sym_string] = STATE(474),
    [anon_sym_SEMI] = ACTIONS(1739),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1741),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1741),
    [sym_next] = ACTIONS(1741),
    [sym_true] = ACTIONS(1741),
    [sym_false] = ACTIONS(1741),
    [sym_null] = ACTIONS(1741),
    [sym_inf] = ACTIONS(1741),
    [sym_nan] = ACTIONS(1741),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1739),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [312] = {
    [sym_function_definition] = STATE(475),
    [sym_lambda_function] = STATE(475),
    [sym_if] = STATE(475),
    [sym_while] = STATE(475),
    [sym_repeat] = STATE(475),
    [sym_for] = STATE(475),
    [sym_switch] = STATE(475),
    [sym_call] = STATE(475),
    [sym__assignment] = STATE(475),
    [sym_left_assignment] = STATE(475),
    [sym_left_assignment2] = STATE(475),
    [sym_equals_assignment] = STATE(475),
    [sym_super_assignment] = STATE(475),
    [sym_super_right_assignment] = STATE(475),
    [sym_right_assignment] = STATE(475),
    [sym_brace_list] = STATE(475),
    [sym_paren_list] = STATE(475),
    [sym_subset] = STATE(475),
    [sym_subset2] = STATE(475),
    [sym_dollar] = STATE(475),
    [sym_slot] = STATE(475),
    [sym_namespace_get] = STATE(475),
    [sym_namespace_get_internal] = STATE(475),
    [sym_pipe] = STATE(475),
    [sym_unary] = STATE(475),
    [sym_binary] = STATE(475),
    [sym_na] = STATE(475),
    [sym__expression] = STATE(475),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(475),
    [sym_string] = STATE(475),
    [anon_sym_SEMI] = ACTIONS(1743),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1745),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1745),
    [sym_next] = ACTIONS(1745),
    [sym_true] = ACTIONS(1745),
    [sym_false] = ACTIONS(1745),
    [sym_null] = ACTIONS(1745),
    [sym_inf] = ACTIONS(1745),
    [sym_nan] = ACTIONS(1745),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1743),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [313] = {
    [anon_sym_LF] = ACTIONS(651),
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(651),
    [anon_sym_BSLASH] = ACTIONS(651),
    [anon_sym_if] = ACTIONS(651),
    [anon_sym_LPAREN] = ACTIONS(651),
    [anon_sym_else] = ACTIONS(651),
    [anon_sym_while] = ACTIONS(651),
    [anon_sym_repeat] = ACTIONS(651),
    [anon_sym_for] = ACTIONS(651),
    [anon_sym_switch] = ACTIONS(651),
    [anon_sym_EQ] = ACTIONS(651),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_RBRACE] = ACTIONS(651),
    [anon_sym_LT_DASH] = ACTIONS(651),
    [anon_sym_COLON_EQ] = ACTIONS(651),
    [anon_sym_LT_LT_DASH] = ACTIONS(651),
    [anon_sym_DASH_GT_GT] = ACTIONS(651),
    [anon_sym_DASH_GT] = ACTIONS(651),
    [anon_sym_LBRACK] = ACTIONS(651),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(651),
    [anon_sym_DOLLAR] = ACTIONS(651),
    [anon_sym_AT] = ACTIONS(651),
    [anon_sym_COLON_COLON] = ACTIONS(651),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(651),
    [sym_dots] = ACTIONS(651),
    [anon_sym_PIPE_GT] = ACTIONS(651),
    [anon_sym_DASH] = ACTIONS(651),
    [anon_sym_PLUS] = ACTIONS(651),
    [anon_sym_BANG] = ACTIONS(651),
    [anon_sym_TILDE] = ACTIONS(651),
    [anon_sym_STAR] = ACTIONS(651),
    [anon_sym_SLASH] = ACTIONS(651),
    [anon_sym_CARET] = ACTIONS(651),
    [anon_sym_LT] = ACTIONS(651),
    [anon_sym_GT] = ACTIONS(651),
    [anon_sym_LT_EQ] = ACTIONS(651),
    [anon_sym_GT_EQ] = ACTIONS(651),
    [anon_sym_EQ_EQ] = ACTIONS(651),
    [anon_sym_BANG_EQ] = ACTIONS(651),
    [anon_sym_PIPE_PIPE] = ACTIONS(651),
    [anon_sym_PIPE] = ACTIONS(651),
    [anon_sym_AMP_AMP] = ACTIONS(651),
    [anon_sym_AMP] = ACTIONS(651),
    [anon_sym_COLON] = ACTIONS(651),
    [sym_break] = ACTIONS(651),
    [sym_next] = ACTIONS(651),
    [sym_true] = ACTIONS(651),
    [sym_false] = ACTIONS(651),
    [sym_null] = ACTIONS(651),
    [sym_inf] = ACTIONS(651),
    [sym_nan] = ACTIONS(651),
    [anon_sym_NA] = ACTIONS(651),
    [anon_sym_NA_character_] = ACTIONS(651),
    [anon_sym_NA_complex_] = ACTIONS(651),
    [anon_sym_NA_integer_] = ACTIONS(651),
    [anon_sym_NA_real_] = ACTIONS(651),
    [aux_sym_identifier_token1] = ACTIONS(651),
    [anon_sym_BQUOTE] = ACTIONS(651),
    [sym_integer] = ACTIONS(651),
    [sym_float] = ACTIONS(651),
    [sym_comment] = ACTIONS(1497),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [anon_sym_SQUOTE] = ACTIONS(651),
    [anon_sym_PERCENT] = ACTIONS(651),
  },
  [314] = {
    [sym_function_definition] = STATE(567),
    [sym_lambda_function] = STATE(567),
    [sym_if] = STATE(567),
    [sym_while] = STATE(567),
    [sym_repeat] = STATE(567),
    [sym_for] = STATE(567),
    [sym_switch] = STATE(567),
    [sym_call] = STATE(567),
    [sym__assignment] = STATE(567),
    [sym_left_assignment] = STATE(567),
    [sym_left_assignment2] = STATE(567),
    [sym_equals_assignment] = STATE(567),
    [sym_super_assignment] = STATE(567),
    [sym_super_right_assignment] = STATE(567),
    [sym_right_assignment] = STATE(567),
    [sym_brace_list] = STATE(567),
    [sym_paren_list] = STATE(567),
    [sym_subset] = STATE(567),
    [sym_subset2] = STATE(567),
    [sym_dollar] = STATE(567),
    [sym_slot] = STATE(567),
    [sym_namespace_get] = STATE(567),
    [sym_namespace_get_internal] = STATE(567),
    [sym_pipe] = STATE(567),
    [sym_unary] = STATE(567),
    [sym_binary] = STATE(567),
    [sym_na] = STATE(567),
    [sym__expression] = STATE(567),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(567),
    [sym_string] = STATE(567),
    [anon_sym_SEMI] = ACTIONS(1747),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1749),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1749),
    [sym_next] = ACTIONS(1749),
    [sym_true] = ACTIONS(1749),
    [sym_false] = ACTIONS(1749),
    [sym_null] = ACTIONS(1749),
    [sym_inf] = ACTIONS(1749),
    [sym_nan] = ACTIONS(1749),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1747),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [315] = {
    [sym_function_definition] = STATE(613),
    [sym_lambda_function] = STATE(613),
    [sym_if] = STATE(613),
    [sym_while] = STATE(613),
    [sym_repeat] = STATE(613),
    [sym_for] = STATE(613),
    [sym_switch] = STATE(613),
    [sym_call] = STATE(613),
    [sym__assignment] = STATE(613),
    [sym_left_assignment] = STATE(613),
    [sym_left_assignment2] = STATE(613),
    [sym_equals_assignment] = STATE(613),
    [sym_super_assignment] = STATE(613),
    [sym_super_right_assignment] = STATE(613),
    [sym_right_assignment] = STATE(613),
    [sym_brace_list] = STATE(613),
    [sym_paren_list] = STATE(613),
    [sym_subset] = STATE(613),
    [sym_subset2] = STATE(613),
    [sym_dollar] = STATE(613),
    [sym_slot] = STATE(613),
    [sym_namespace_get] = STATE(613),
    [sym_namespace_get_internal] = STATE(613),
    [sym_pipe] = STATE(613),
    [sym_unary] = STATE(613),
    [sym_binary] = STATE(613),
    [sym_na] = STATE(613),
    [sym__expression] = STATE(613),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(613),
    [sym_string] = STATE(613),
    [anon_sym_SEMI] = ACTIONS(1751),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1753),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1753),
    [sym_next] = ACTIONS(1753),
    [sym_true] = ACTIONS(1753),
    [sym_false] = ACTIONS(1753),
    [sym_null] = ACTIONS(1753),
    [sym_inf] = ACTIONS(1753),
    [sym_nan] = ACTIONS(1753),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1751),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [316] = {
    [sym_function_definition] = STATE(615),
    [sym_lambda_function] = STATE(615),
    [sym_if] = STATE(615),
    [sym_while] = STATE(615),
    [sym_repeat] = STATE(615),
    [sym_for] = STATE(615),
    [sym_switch] = STATE(615),
    [sym_call] = STATE(615),
    [sym__assignment] = STATE(615),
    [sym_left_assignment] = STATE(615),
    [sym_left_assignment2] = STATE(615),
    [sym_equals_assignment] = STATE(615),
    [sym_super_assignment] = STATE(615),
    [sym_super_right_assignment] = STATE(615),
    [sym_right_assignment] = STATE(615),
    [sym_brace_list] = STATE(615),
    [sym_paren_list] = STATE(615),
    [sym_subset] = STATE(615),
    [sym_subset2] = STATE(615),
    [sym_dollar] = STATE(615),
    [sym_slot] = STATE(615),
    [sym_namespace_get] = STATE(615),
    [sym_namespace_get_internal] = STATE(615),
    [sym_pipe] = STATE(615),
    [sym_unary] = STATE(615),
    [sym_binary] = STATE(615),
    [sym_na] = STATE(615),
    [sym__expression] = STATE(615),
    [sym_identifier] = STATE(431),
    [sym_complex] = STATE(615),
    [sym_string] = STATE(615),
    [anon_sym_SEMI] = ACTIONS(1755),
    [anon_sym_function] = ACTIONS(337),
    [anon_sym_BSLASH] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_while] = ACTIONS(345),
    [anon_sym_repeat] = ACTIONS(347),
    [anon_sym_for] = ACTIONS(349),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_LBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(1757),
    [anon_sym_DASH] = ACTIONS(359),
    [anon_sym_PLUS] = ACTIONS(359),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(363),
    [sym_break] = ACTIONS(1757),
    [sym_next] = ACTIONS(1757),
    [sym_true] = ACTIONS(1757),
    [sym_false] = ACTIONS(1757),
    [sym_null] = ACTIONS(1757),
    [sym_inf] = ACTIONS(1757),
    [sym_nan] = ACTIONS(1757),
    [anon_sym_NA] = ACTIONS(365),
    [anon_sym_NA_character_] = ACTIONS(365),
    [anon_sym_NA_complex_] = ACTIONS(365),
    [anon_sym_NA_integer_] = ACTIONS(365),
    [anon_sym_NA_real_] = ACTIONS(365),
    [aux_sym_identifier_token1] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [sym_integer] = ACTIONS(1755),
    [sym_float] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(375),
  },
  [317] = {
    [sym_function_definition] = STATE(476),
    [sym_lambda_function] = STATE(476),
    [sym_if] = STATE(476),
    [sym_while] = STATE(476),
    [sym_repeat] = STATE(476),
    [sym_for] = STATE(476),
    [sym_switch] = STATE(476),
    [sym_call] = STATE(476),
    [sym__assignment] = STATE(476),
    [sym_left_assignment] = STATE(476),
    [sym_left_assignment2] = STATE(476),
    [sym_equals_assignment] = STATE(476),
    [sym_super_assignment] = STATE(476),
    [sym_super_right_assignment] = STATE(476),
    [sym_right_assignment] = STATE(476),
    [sym_brace_list] = STATE(476),
    [sym_paren_list] = STATE(476),
    [sym_subset] = STATE(476),
    [sym_subset2] = STATE(476),
    [sym_dollar] = STATE(476),
    [sym_slot] = STATE(476),
    [sym_namespace_get] = STATE(476),
    [sym_namespace_get_internal] = STATE(476),
    [sym_pipe] = STATE(476),
    [sym_unary] = STATE(476),
    [sym_binary] = STATE(476),
    [sym_na] = STATE(476),
    [sym__expression] = STATE(476),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(476),
    [sym_string] = STATE(476),
    [anon_sym_SEMI] = ACTIONS(1759),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1761),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1761),
    [sym_next] = ACTIONS(1761),
    [sym_true] = ACTIONS(1761),
    [sym_false] = ACTIONS(1761),
    [sym_null] = ACTIONS(1761),
    [sym_inf] = ACTIONS(1761),
    [sym_nan] = ACTIONS(1761),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1759),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [318] = {
    [sym_function_definition] = STATE(544),
    [sym_lambda_function] = STATE(544),
    [sym_if] = STATE(544),
    [sym_while] = STATE(544),
    [sym_repeat] = STATE(544),
    [sym_for] = STATE(544),
    [sym_switch] = STATE(544),
    [sym_call] = STATE(544),
    [sym__assignment] = STATE(544),
    [sym_left_assignment] = STATE(544),
    [sym_left_assignment2] = STATE(544),
    [sym_equals_assignment] = STATE(544),
    [sym_super_assignment] = STATE(544),
    [sym_super_right_assignment] = STATE(544),
    [sym_right_assignment] = STATE(544),
    [sym_brace_list] = STATE(544),
    [sym_paren_list] = STATE(544),
    [sym_subset] = STATE(544),
    [sym_subset2] = STATE(544),
    [sym_dollar] = STATE(544),
    [sym_slot] = STATE(544),
    [sym_namespace_get] = STATE(544),
    [sym_namespace_get_internal] = STATE(544),
    [sym_pipe] = STATE(544),
    [sym_unary] = STATE(544),
    [sym_binary] = STATE(544),
    [sym_na] = STATE(544),
    [sym__expression] = STATE(544),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(544),
    [sym_string] = STATE(544),
    [anon_sym_SEMI] = ACTIONS(1763),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1765),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1765),
    [sym_next] = ACTIONS(1765),
    [sym_true] = ACTIONS(1765),
    [sym_false] = ACTIONS(1765),
    [sym_null] = ACTIONS(1765),
    [sym_inf] = ACTIONS(1765),
    [sym_nan] = ACTIONS(1765),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1763),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [319] = {
    [sym_function_definition] = STATE(543),
    [sym_lambda_function] = STATE(543),
    [sym_if] = STATE(543),
    [sym_while] = STATE(543),
    [sym_repeat] = STATE(543),
    [sym_for] = STATE(543),
    [sym_switch] = STATE(543),
    [sym_call] = STATE(543),
    [sym__assignment] = STATE(543),
    [sym_left_assignment] = STATE(543),
    [sym_left_assignment2] = STATE(543),
    [sym_equals_assignment] = STATE(543),
    [sym_super_assignment] = STATE(543),
    [sym_super_right_assignment] = STATE(543),
    [sym_right_assignment] = STATE(543),
    [sym_brace_list] = STATE(543),
    [sym_paren_list] = STATE(543),
    [sym_subset] = STATE(543),
    [sym_subset2] = STATE(543),
    [sym_dollar] = STATE(543),
    [sym_slot] = STATE(543),
    [sym_namespace_get] = STATE(543),
    [sym_namespace_get_internal] = STATE(543),
    [sym_pipe] = STATE(543),
    [sym_unary] = STATE(543),
    [sym_binary] = STATE(543),
    [sym_na] = STATE(543),
    [sym__expression] = STATE(543),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(543),
    [sym_string] = STATE(543),
    [anon_sym_SEMI] = ACTIONS(1767),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1769),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1769),
    [sym_next] = ACTIONS(1769),
    [sym_true] = ACTIONS(1769),
    [sym_false] = ACTIONS(1769),
    [sym_null] = ACTIONS(1769),
    [sym_inf] = ACTIONS(1769),
    [sym_nan] = ACTIONS(1769),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1767),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [320] = {
    [sym_function_definition] = STATE(621),
    [sym_lambda_function] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_repeat] = STATE(621),
    [sym_for] = STATE(621),
    [sym_switch] = STATE(621),
    [sym_call] = STATE(621),
    [sym__assignment] = STATE(621),
    [sym_left_assignment] = STATE(621),
    [sym_left_assignment2] = STATE(621),
    [sym_equals_assignment] = STATE(621),
    [sym_super_assignment] = STATE(621),
    [sym_super_right_assignment] = STATE(621),
    [sym_right_assignment] = STATE(621),
    [sym_brace_list] = STATE(621),
    [sym_paren_list] = STATE(621),
    [sym_subset] = STATE(621),
    [sym_subset2] = STATE(621),
    [sym_dollar] = STATE(621),
    [sym_slot] = STATE(621),
    [sym_namespace_get] = STATE(621),
    [sym_namespace_get_internal] = STATE(621),
    [sym_pipe] = STATE(621),
    [sym_unary] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_na] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_identifier] = STATE(432),
    [sym_complex] = STATE(621),
    [sym_string] = STATE(621),
    [anon_sym_SEMI] = ACTIONS(1771),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1773),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1773),
    [sym_next] = ACTIONS(1773),
    [sym_true] = ACTIONS(1773),
    [sym_false] = ACTIONS(1773),
    [sym_null] = ACTIONS(1773),
    [sym_inf] = ACTIONS(1773),
    [sym_nan] = ACTIONS(1773),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1771),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [321] = {
    [sym_function_definition] = STATE(623),
    [sym_lambda_function] = STATE(623),
    [sym_if] = STATE(623),
    [sym_while] = STATE(623),
    [sym_repeat] = STATE(623),
    [sym_for] = STATE(623),
    [sym_switch] = STATE(623),
    [sym_call] = STATE(623),
    [sym__assignment] = STATE(623),
    [sym_left_assignment] = STATE(623),
    [sym_left_assignment2] = STATE(623),
    [sym_equals_assignment] = STATE(623),
    [sym_super_assignment] = STATE(623),
    [sym_super_right_assignment] = STATE(623),
    [sym_right_assignment] = STATE(623),
    [sym_brace_list] = STATE(623),
    [sym_paren_list] = STATE(623),
    [sym_subset] = STATE(623),
    [sym_subset2] = STATE(623),
    [sym_dollar] = STATE(623),
    [sym_slot] = STATE(623),
    [sym_namespace_get] = STATE(623),
    [sym_namespace_get_internal] = STATE(623),
    [sym_pipe] = STATE(623),
    [sym_unary] = STATE(623),
    [sym_binary] = STATE(623),
    [sym_na] = STATE(623),
    [sym__expression] = STATE(623),
    [sym_identifier] = STATE(432),
    [sym_complex] = STATE(623),
    [sym_string] = STATE(623),
    [anon_sym_SEMI] = ACTIONS(1775),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1777),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1777),
    [sym_next] = ACTIONS(1777),
    [sym_true] = ACTIONS(1777),
    [sym_false] = ACTIONS(1777),
    [sym_null] = ACTIONS(1777),
    [sym_inf] = ACTIONS(1777),
    [sym_nan] = ACTIONS(1777),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1775),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [322] = {
    [sym_function_definition] = STATE(624),
    [sym_lambda_function] = STATE(624),
    [sym_if] = STATE(624),
    [sym_while] = STATE(624),
    [sym_repeat] = STATE(624),
    [sym_for] = STATE(624),
    [sym_switch] = STATE(624),
    [sym_call] = STATE(624),
    [sym__assignment] = STATE(624),
    [sym_left_assignment] = STATE(624),
    [sym_left_assignment2] = STATE(624),
    [sym_equals_assignment] = STATE(624),
    [sym_super_assignment] = STATE(624),
    [sym_super_right_assignment] = STATE(624),
    [sym_right_assignment] = STATE(624),
    [sym_brace_list] = STATE(624),
    [sym_paren_list] = STATE(624),
    [sym_subset] = STATE(624),
    [sym_subset2] = STATE(624),
    [sym_dollar] = STATE(624),
    [sym_slot] = STATE(624),
    [sym_namespace_get] = STATE(624),
    [sym_namespace_get_internal] = STATE(624),
    [sym_pipe] = STATE(624),
    [sym_unary] = STATE(624),
    [sym_binary] = STATE(624),
    [sym_na] = STATE(624),
    [sym__expression] = STATE(624),
    [sym_identifier] = STATE(432),
    [sym_complex] = STATE(624),
    [sym_string] = STATE(624),
    [anon_sym_SEMI] = ACTIONS(1779),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1781),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1781),
    [sym_next] = ACTIONS(1781),
    [sym_true] = ACTIONS(1781),
    [sym_false] = ACTIONS(1781),
    [sym_null] = ACTIONS(1781),
    [sym_inf] = ACTIONS(1781),
    [sym_nan] = ACTIONS(1781),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1779),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [323] = {
    [sym_function_definition] = STATE(625),
    [sym_lambda_function] = STATE(625),
    [sym_if] = STATE(625),
    [sym_while] = STATE(625),
    [sym_repeat] = STATE(625),
    [sym_for] = STATE(625),
    [sym_switch] = STATE(625),
    [sym_call] = STATE(625),
    [sym__assignment] = STATE(625),
    [sym_left_assignment] = STATE(625),
    [sym_left_assignment2] = STATE(625),
    [sym_equals_assignment] = STATE(625),
    [sym_super_assignment] = STATE(625),
    [sym_super_right_assignment] = STATE(625),
    [sym_right_assignment] = STATE(625),
    [sym_brace_list] = STATE(625),
    [sym_paren_list] = STATE(625),
    [sym_subset] = STATE(625),
    [sym_subset2] = STATE(625),
    [sym_dollar] = STATE(625),
    [sym_slot] = STATE(625),
    [sym_namespace_get] = STATE(625),
    [sym_namespace_get_internal] = STATE(625),
    [sym_pipe] = STATE(625),
    [sym_unary] = STATE(625),
    [sym_binary] = STATE(625),
    [sym_na] = STATE(625),
    [sym__expression] = STATE(625),
    [sym_identifier] = STATE(432),
    [sym_complex] = STATE(625),
    [sym_string] = STATE(625),
    [anon_sym_SEMI] = ACTIONS(1783),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1785),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1785),
    [sym_next] = ACTIONS(1785),
    [sym_true] = ACTIONS(1785),
    [sym_false] = ACTIONS(1785),
    [sym_null] = ACTIONS(1785),
    [sym_inf] = ACTIONS(1785),
    [sym_nan] = ACTIONS(1785),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1783),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [324] = {
    [sym_function_definition] = STATE(539),
    [sym_lambda_function] = STATE(539),
    [sym_if] = STATE(539),
    [sym_while] = STATE(539),
    [sym_repeat] = STATE(539),
    [sym_for] = STATE(539),
    [sym_switch] = STATE(539),
    [sym_call] = STATE(539),
    [sym__assignment] = STATE(539),
    [sym_left_assignment] = STATE(539),
    [sym_left_assignment2] = STATE(539),
    [sym_equals_assignment] = STATE(539),
    [sym_super_assignment] = STATE(539),
    [sym_super_right_assignment] = STATE(539),
    [sym_right_assignment] = STATE(539),
    [sym_brace_list] = STATE(539),
    [sym_paren_list] = STATE(539),
    [sym_subset] = STATE(539),
    [sym_subset2] = STATE(539),
    [sym_dollar] = STATE(539),
    [sym_slot] = STATE(539),
    [sym_namespace_get] = STATE(539),
    [sym_namespace_get_internal] = STATE(539),
    [sym_pipe] = STATE(539),
    [sym_unary] = STATE(539),
    [sym_binary] = STATE(539),
    [sym_na] = STATE(539),
    [sym__expression] = STATE(539),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(539),
    [sym_string] = STATE(539),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [325] = {
    [sym_function_definition] = STATE(477),
    [sym_lambda_function] = STATE(477),
    [sym_if] = STATE(477),
    [sym_while] = STATE(477),
    [sym_repeat] = STATE(477),
    [sym_for] = STATE(477),
    [sym_switch] = STATE(477),
    [sym_call] = STATE(477),
    [sym__assignment] = STATE(477),
    [sym_left_assignment] = STATE(477),
    [sym_left_assignment2] = STATE(477),
    [sym_equals_assignment] = STATE(477),
    [sym_super_assignment] = STATE(477),
    [sym_super_right_assignment] = STATE(477),
    [sym_right_assignment] = STATE(477),
    [sym_brace_list] = STATE(477),
    [sym_paren_list] = STATE(477),
    [sym_subset] = STATE(477),
    [sym_subset2] = STATE(477),
    [sym_dollar] = STATE(477),
    [sym_slot] = STATE(477),
    [sym_namespace_get] = STATE(477),
    [sym_namespace_get_internal] = STATE(477),
    [sym_pipe] = STATE(477),
    [sym_unary] = STATE(477),
    [sym_binary] = STATE(477),
    [sym_na] = STATE(477),
    [sym__expression] = STATE(477),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(477),
    [sym_string] = STATE(477),
    [anon_sym_SEMI] = ACTIONS(1791),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1793),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1793),
    [sym_next] = ACTIONS(1793),
    [sym_true] = ACTIONS(1793),
    [sym_false] = ACTIONS(1793),
    [sym_null] = ACTIONS(1793),
    [sym_inf] = ACTIONS(1793),
    [sym_nan] = ACTIONS(1793),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1791),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [326] = {
    [sym_function_definition] = STATE(469),
    [sym_lambda_function] = STATE(469),
    [sym_if] = STATE(469),
    [sym_while] = STATE(469),
    [sym_repeat] = STATE(469),
    [sym_for] = STATE(469),
    [sym_switch] = STATE(469),
    [sym_call] = STATE(469),
    [sym__assignment] = STATE(469),
    [sym_left_assignment] = STATE(469),
    [sym_left_assignment2] = STATE(469),
    [sym_equals_assignment] = STATE(469),
    [sym_super_assignment] = STATE(469),
    [sym_super_right_assignment] = STATE(469),
    [sym_right_assignment] = STATE(469),
    [sym_brace_list] = STATE(469),
    [sym_paren_list] = STATE(469),
    [sym_subset] = STATE(469),
    [sym_subset2] = STATE(469),
    [sym_dollar] = STATE(469),
    [sym_slot] = STATE(469),
    [sym_namespace_get] = STATE(469),
    [sym_namespace_get_internal] = STATE(469),
    [sym_pipe] = STATE(469),
    [sym_unary] = STATE(469),
    [sym_binary] = STATE(469),
    [sym_na] = STATE(469),
    [sym__expression] = STATE(469),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(469),
    [sym_string] = STATE(469),
    [anon_sym_SEMI] = ACTIONS(1795),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1797),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1797),
    [sym_next] = ACTIONS(1797),
    [sym_true] = ACTIONS(1797),
    [sym_false] = ACTIONS(1797),
    [sym_null] = ACTIONS(1797),
    [sym_inf] = ACTIONS(1797),
    [sym_nan] = ACTIONS(1797),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1795),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [327] = {
    [ts_builtin_sym_end] = ACTIONS(641),
    [anon_sym_LF] = ACTIONS(643),
    [anon_sym_SEMI] = ACTIONS(643),
    [anon_sym_function] = ACTIONS(643),
    [anon_sym_BSLASH] = ACTIONS(643),
    [anon_sym_if] = ACTIONS(643),
    [anon_sym_LPAREN] = ACTIONS(643),
    [anon_sym_else] = ACTIONS(643),
    [anon_sym_while] = ACTIONS(643),
    [anon_sym_repeat] = ACTIONS(643),
    [anon_sym_for] = ACTIONS(643),
    [anon_sym_switch] = ACTIONS(643),
    [anon_sym_EQ] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_LT_DASH] = ACTIONS(643),
    [anon_sym_COLON_EQ] = ACTIONS(643),
    [anon_sym_LT_LT_DASH] = ACTIONS(643),
    [anon_sym_DASH_GT_GT] = ACTIONS(643),
    [anon_sym_DASH_GT] = ACTIONS(643),
    [anon_sym_LBRACK] = ACTIONS(643),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(643),
    [anon_sym_AT] = ACTIONS(643),
    [anon_sym_COLON_COLON] = ACTIONS(1799),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1801),
    [sym_dots] = ACTIONS(643),
    [anon_sym_PIPE_GT] = ACTIONS(643),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_PLUS] = ACTIONS(643),
    [anon_sym_BANG] = ACTIONS(643),
    [anon_sym_TILDE] = ACTIONS(643),
    [anon_sym_STAR] = ACTIONS(643),
    [anon_sym_SLASH] = ACTIONS(643),
    [anon_sym_CARET] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(643),
    [anon_sym_GT] = ACTIONS(643),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_PIPE_PIPE] = ACTIONS(643),
    [anon_sym_PIPE] = ACTIONS(643),
    [anon_sym_AMP_AMP] = ACTIONS(643),
    [anon_sym_AMP] = ACTIONS(643),
    [anon_sym_COLON] = ACTIONS(643),
    [sym_break] = ACTIONS(643),
    [sym_next] = ACTIONS(643),
    [sym_true] = ACTIONS(643),
    [sym_false] = ACTIONS(643),
    [sym_null] = ACTIONS(643),
    [sym_inf] = ACTIONS(643),
    [sym_nan] = ACTIONS(643),
    [anon_sym_NA] = ACTIONS(643),
    [anon_sym_NA_character_] = ACTIONS(643),
    [anon_sym_NA_complex_] = ACTIONS(643),
    [anon_sym_NA_integer_] = ACTIONS(643),
    [anon_sym_NA_real_] = ACTIONS(643),
    [aux_sym_identifier_token1] = ACTIONS(643),
    [anon_sym_BQUOTE] = ACTIONS(643),
    [sym_integer] = ACTIONS(643),
    [sym_float] = ACTIONS(643),
    [sym_comment] = ACTIONS(1497),
    [anon_sym_DQUOTE] = ACTIONS(643),
    [anon_sym_SQUOTE] = ACTIONS(643),
    [anon_sym_PERCENT] = ACTIONS(643),
  },
  [328] = {
    [sym_function_definition] = STATE(846),
    [sym_lambda_function] = STATE(846),
    [sym_if] = STATE(846),
    [sym_while] = STATE(846),
    [sym_repeat] = STATE(846),
    [sym_for] = STATE(846),
    [sym_switch] = STATE(846),
    [sym_call] = STATE(846),
    [sym__assignment] = STATE(846),
    [sym_left_assignment] = STATE(846),
    [sym_left_assignment2] = STATE(846),
    [sym_equals_assignment] = STATE(846),
    [sym_super_assignment] = STATE(846),
    [sym_super_right_assignment] = STATE(846),
    [sym_right_assignment] = STATE(846),
    [sym_brace_list] = STATE(846),
    [sym_paren_list] = STATE(846),
    [sym_subset] = STATE(846),
    [sym_subset2] = STATE(846),
    [sym_dollar] = STATE(846),
    [sym_slot] = STATE(846),
    [sym_namespace_get] = STATE(846),
    [sym_namespace_get_internal] = STATE(846),
    [sym_pipe] = STATE(846),
    [sym_unary] = STATE(846),
    [sym_binary] = STATE(846),
    [sym_na] = STATE(846),
    [sym__expression] = STATE(846),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(846),
    [sym_string] = STATE(846),
    [anon_sym_SEMI] = ACTIONS(1803),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1805),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1805),
    [sym_next] = ACTIONS(1805),
    [sym_true] = ACTIONS(1805),
    [sym_false] = ACTIONS(1805),
    [sym_null] = ACTIONS(1805),
    [sym_inf] = ACTIONS(1805),
    [sym_nan] = ACTIONS(1805),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1803),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [329] = {
    [sym_function_definition] = STATE(855),
    [sym_lambda_function] = STATE(855),
    [sym_if] = STATE(855),
    [sym_while] = STATE(855),
    [sym_repeat] = STATE(855),
    [sym_for] = STATE(855),
    [sym_switch] = STATE(855),
    [sym_call] = STATE(855),
    [sym__assignment] = STATE(855),
    [sym_left_assignment] = STATE(855),
    [sym_left_assignment2] = STATE(855),
    [sym_equals_assignment] = STATE(855),
    [sym_super_assignment] = STATE(855),
    [sym_super_right_assignment] = STATE(855),
    [sym_right_assignment] = STATE(855),
    [sym_brace_list] = STATE(855),
    [sym_paren_list] = STATE(855),
    [sym_subset] = STATE(855),
    [sym_subset2] = STATE(855),
    [sym_dollar] = STATE(855),
    [sym_slot] = STATE(855),
    [sym_namespace_get] = STATE(855),
    [sym_namespace_get_internal] = STATE(855),
    [sym_pipe] = STATE(855),
    [sym_unary] = STATE(855),
    [sym_binary] = STATE(855),
    [sym_na] = STATE(855),
    [sym__expression] = STATE(855),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(855),
    [sym_string] = STATE(855),
    [anon_sym_SEMI] = ACTIONS(1807),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1809),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1809),
    [sym_next] = ACTIONS(1809),
    [sym_true] = ACTIONS(1809),
    [sym_false] = ACTIONS(1809),
    [sym_null] = ACTIONS(1809),
    [sym_inf] = ACTIONS(1809),
    [sym_nan] = ACTIONS(1809),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1807),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [330] = {
    [sym_function_definition] = STATE(438),
    [sym_lambda_function] = STATE(438),
    [sym_if] = STATE(438),
    [sym_while] = STATE(438),
    [sym_repeat] = STATE(438),
    [sym_for] = STATE(438),
    [sym_switch] = STATE(438),
    [sym_call] = STATE(438),
    [sym__assignment] = STATE(438),
    [sym_left_assignment] = STATE(438),
    [sym_left_assignment2] = STATE(438),
    [sym_equals_assignment] = STATE(438),
    [sym_super_assignment] = STATE(438),
    [sym_super_right_assignment] = STATE(438),
    [sym_right_assignment] = STATE(438),
    [sym_brace_list] = STATE(438),
    [sym_paren_list] = STATE(438),
    [sym_subset] = STATE(438),
    [sym_subset2] = STATE(438),
    [sym_dollar] = STATE(438),
    [sym_slot] = STATE(438),
    [sym_namespace_get] = STATE(438),
    [sym_namespace_get_internal] = STATE(438),
    [sym_pipe] = STATE(438),
    [sym_unary] = STATE(438),
    [sym_binary] = STATE(438),
    [sym_na] = STATE(438),
    [sym__expression] = STATE(438),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(438),
    [sym_string] = STATE(438),
    [anon_sym_SEMI] = ACTIONS(1811),
    [anon_sym_function] = ACTIONS(663),
    [anon_sym_BSLASH] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(667),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_while] = ACTIONS(671),
    [anon_sym_repeat] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(675),
    [anon_sym_switch] = ACTIONS(677),
    [anon_sym_LBRACE] = ACTIONS(679),
    [sym_dots] = ACTIONS(1813),
    [anon_sym_DASH] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(683),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(687),
    [sym_break] = ACTIONS(1813),
    [sym_next] = ACTIONS(1813),
    [sym_true] = ACTIONS(1813),
    [sym_false] = ACTIONS(1813),
    [sym_null] = ACTIONS(1813),
    [sym_inf] = ACTIONS(1813),
    [sym_nan] = ACTIONS(1813),
    [anon_sym_NA] = ACTIONS(689),
    [anon_sym_NA_character_] = ACTIONS(689),
    [anon_sym_NA_complex_] = ACTIONS(689),
    [anon_sym_NA_integer_] = ACTIONS(689),
    [anon_sym_NA_real_] = ACTIONS(689),
    [aux_sym_identifier_token1] = ACTIONS(691),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [sym_integer] = ACTIONS(1811),
    [sym_float] = ACTIONS(695),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_SQUOTE] = ACTIONS(699),
  },
  [331] = {
    [sym_function_definition] = STATE(532),
    [sym_lambda_function] = STATE(532),
    [sym_if] = STATE(532),
    [sym_while] = STATE(532),
    [sym_repeat] = STATE(532),
    [sym_for] = STATE(532),
    [sym_switch] = STATE(532),
    [sym_call] = STATE(532),
    [sym__assignment] = STATE(532),
    [sym_left_assignment] = STATE(532),
    [sym_left_assignment2] = STATE(532),
    [sym_equals_assignment] = STATE(532),
    [sym_super_assignment] = STATE(532),
    [sym_super_right_assignment] = STATE(532),
    [sym_right_assignment] = STATE(532),
    [sym_brace_list] = STATE(532),
    [sym_paren_list] = STATE(532),
    [sym_subset] = STATE(532),
    [sym_subset2] = STATE(532),
    [sym_dollar] = STATE(532),
    [sym_slot] = STATE(532),
    [sym_namespace_get] = STATE(532),
    [sym_namespace_get_internal] = STATE(532),
    [sym_pipe] = STATE(532),
    [sym_unary] = STATE(532),
    [sym_binary] = STATE(532),
    [sym_na] = STATE(532),
    [sym__expression] = STATE(532),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(532),
    [sym_string] = STATE(532),
    [anon_sym_SEMI] = ACTIONS(1815),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1817),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1817),
    [sym_next] = ACTIONS(1817),
    [sym_true] = ACTIONS(1817),
    [sym_false] = ACTIONS(1817),
    [sym_null] = ACTIONS(1817),
    [sym_inf] = ACTIONS(1817),
    [sym_nan] = ACTIONS(1817),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1815),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [332] = {
    [sym_function_definition] = STATE(531),
    [sym_lambda_function] = STATE(531),
    [sym_if] = STATE(531),
    [sym_while] = STATE(531),
    [sym_repeat] = STATE(531),
    [sym_for] = STATE(531),
    [sym_switch] = STATE(531),
    [sym_call] = STATE(531),
    [sym__assignment] = STATE(531),
    [sym_left_assignment] = STATE(531),
    [sym_left_assignment2] = STATE(531),
    [sym_equals_assignment] = STATE(531),
    [sym_super_assignment] = STATE(531),
    [sym_super_right_assignment] = STATE(531),
    [sym_right_assignment] = STATE(531),
    [sym_brace_list] = STATE(531),
    [sym_paren_list] = STATE(531),
    [sym_subset] = STATE(531),
    [sym_subset2] = STATE(531),
    [sym_dollar] = STATE(531),
    [sym_slot] = STATE(531),
    [sym_namespace_get] = STATE(531),
    [sym_namespace_get_internal] = STATE(531),
    [sym_pipe] = STATE(531),
    [sym_unary] = STATE(531),
    [sym_binary] = STATE(531),
    [sym_na] = STATE(531),
    [sym__expression] = STATE(531),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(531),
    [sym_string] = STATE(531),
    [anon_sym_SEMI] = ACTIONS(1819),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1821),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1821),
    [sym_next] = ACTIONS(1821),
    [sym_true] = ACTIONS(1821),
    [sym_false] = ACTIONS(1821),
    [sym_null] = ACTIONS(1821),
    [sym_inf] = ACTIONS(1821),
    [sym_nan] = ACTIONS(1821),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1819),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [333] = {
    [sym_function_definition] = STATE(530),
    [sym_lambda_function] = STATE(530),
    [sym_if] = STATE(530),
    [sym_while] = STATE(530),
    [sym_repeat] = STATE(530),
    [sym_for] = STATE(530),
    [sym_switch] = STATE(530),
    [sym_call] = STATE(530),
    [sym__assignment] = STATE(530),
    [sym_left_assignment] = STATE(530),
    [sym_left_assignment2] = STATE(530),
    [sym_equals_assignment] = STATE(530),
    [sym_super_assignment] = STATE(530),
    [sym_super_right_assignment] = STATE(530),
    [sym_right_assignment] = STATE(530),
    [sym_brace_list] = STATE(530),
    [sym_paren_list] = STATE(530),
    [sym_subset] = STATE(530),
    [sym_subset2] = STATE(530),
    [sym_dollar] = STATE(530),
    [sym_slot] = STATE(530),
    [sym_namespace_get] = STATE(530),
    [sym_namespace_get_internal] = STATE(530),
    [sym_pipe] = STATE(530),
    [sym_unary] = STATE(530),
    [sym_binary] = STATE(530),
    [sym_na] = STATE(530),
    [sym__expression] = STATE(530),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(530),
    [sym_string] = STATE(530),
    [anon_sym_SEMI] = ACTIONS(1823),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1825),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1825),
    [sym_next] = ACTIONS(1825),
    [sym_true] = ACTIONS(1825),
    [sym_false] = ACTIONS(1825),
    [sym_null] = ACTIONS(1825),
    [sym_inf] = ACTIONS(1825),
    [sym_nan] = ACTIONS(1825),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1823),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [334] = {
    [sym_function_definition] = STATE(529),
    [sym_lambda_function] = STATE(529),
    [sym_if] = STATE(529),
    [sym_while] = STATE(529),
    [sym_repeat] = STATE(529),
    [sym_for] = STATE(529),
    [sym_switch] = STATE(529),
    [sym_call] = STATE(529),
    [sym__assignment] = STATE(529),
    [sym_left_assignment] = STATE(529),
    [sym_left_assignment2] = STATE(529),
    [sym_equals_assignment] = STATE(529),
    [sym_super_assignment] = STATE(529),
    [sym_super_right_assignment] = STATE(529),
    [sym_right_assignment] = STATE(529),
    [sym_brace_list] = STATE(529),
    [sym_paren_list] = STATE(529),
    [sym_subset] = STATE(529),
    [sym_subset2] = STATE(529),
    [sym_dollar] = STATE(529),
    [sym_slot] = STATE(529),
    [sym_namespace_get] = STATE(529),
    [sym_namespace_get_internal] = STATE(529),
    [sym_pipe] = STATE(529),
    [sym_unary] = STATE(529),
    [sym_binary] = STATE(529),
    [sym_na] = STATE(529),
    [sym__expression] = STATE(529),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(529),
    [sym_string] = STATE(529),
    [anon_sym_SEMI] = ACTIONS(1827),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1829),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1829),
    [sym_next] = ACTIONS(1829),
    [sym_true] = ACTIONS(1829),
    [sym_false] = ACTIONS(1829),
    [sym_null] = ACTIONS(1829),
    [sym_inf] = ACTIONS(1829),
    [sym_nan] = ACTIONS(1829),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1827),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [335] = {
    [sym_function_definition] = STATE(528),
    [sym_lambda_function] = STATE(528),
    [sym_if] = STATE(528),
    [sym_while] = STATE(528),
    [sym_repeat] = STATE(528),
    [sym_for] = STATE(528),
    [sym_switch] = STATE(528),
    [sym_call] = STATE(528),
    [sym__assignment] = STATE(528),
    [sym_left_assignment] = STATE(528),
    [sym_left_assignment2] = STATE(528),
    [sym_equals_assignment] = STATE(528),
    [sym_super_assignment] = STATE(528),
    [sym_super_right_assignment] = STATE(528),
    [sym_right_assignment] = STATE(528),
    [sym_brace_list] = STATE(528),
    [sym_paren_list] = STATE(528),
    [sym_subset] = STATE(528),
    [sym_subset2] = STATE(528),
    [sym_dollar] = STATE(528),
    [sym_slot] = STATE(528),
    [sym_namespace_get] = STATE(528),
    [sym_namespace_get_internal] = STATE(528),
    [sym_pipe] = STATE(528),
    [sym_unary] = STATE(528),
    [sym_binary] = STATE(528),
    [sym_na] = STATE(528),
    [sym__expression] = STATE(528),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(528),
    [sym_string] = STATE(528),
    [anon_sym_SEMI] = ACTIONS(1831),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1833),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1833),
    [sym_next] = ACTIONS(1833),
    [sym_true] = ACTIONS(1833),
    [sym_false] = ACTIONS(1833),
    [sym_null] = ACTIONS(1833),
    [sym_inf] = ACTIONS(1833),
    [sym_nan] = ACTIONS(1833),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1831),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [336] = {
    [sym_function_definition] = STATE(921),
    [sym_lambda_function] = STATE(921),
    [sym_if] = STATE(921),
    [sym_while] = STATE(921),
    [sym_repeat] = STATE(921),
    [sym_for] = STATE(921),
    [sym_switch] = STATE(921),
    [sym_call] = STATE(666),
    [sym__assignment] = STATE(921),
    [sym_left_assignment] = STATE(921),
    [sym_left_assignment2] = STATE(921),
    [sym_equals_assignment] = STATE(921),
    [sym_super_assignment] = STATE(921),
    [sym_super_right_assignment] = STATE(921),
    [sym_right_assignment] = STATE(921),
    [sym_brace_list] = STATE(921),
    [sym_paren_list] = STATE(921),
    [sym_subset] = STATE(921),
    [sym_subset2] = STATE(921),
    [sym_dollar] = STATE(921),
    [sym_slot] = STATE(921),
    [sym_namespace_get] = STATE(921),
    [sym_namespace_get_internal] = STATE(921),
    [sym_pipe] = STATE(921),
    [sym_unary] = STATE(921),
    [sym_binary] = STATE(921),
    [sym_na] = STATE(921),
    [sym__expression] = STATE(921),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(921),
    [sym_string] = STATE(921),
    [anon_sym_SEMI] = ACTIONS(1835),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1837),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1837),
    [sym_next] = ACTIONS(1837),
    [sym_true] = ACTIONS(1837),
    [sym_false] = ACTIONS(1837),
    [sym_null] = ACTIONS(1837),
    [sym_inf] = ACTIONS(1837),
    [sym_nan] = ACTIONS(1837),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1835),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [337] = {
    [sym_function_definition] = STATE(527),
    [sym_lambda_function] = STATE(527),
    [sym_if] = STATE(527),
    [sym_while] = STATE(527),
    [sym_repeat] = STATE(527),
    [sym_for] = STATE(527),
    [sym_switch] = STATE(527),
    [sym_call] = STATE(527),
    [sym__assignment] = STATE(527),
    [sym_left_assignment] = STATE(527),
    [sym_left_assignment2] = STATE(527),
    [sym_equals_assignment] = STATE(527),
    [sym_super_assignment] = STATE(527),
    [sym_super_right_assignment] = STATE(527),
    [sym_right_assignment] = STATE(527),
    [sym_brace_list] = STATE(527),
    [sym_paren_list] = STATE(527),
    [sym_subset] = STATE(527),
    [sym_subset2] = STATE(527),
    [sym_dollar] = STATE(527),
    [sym_slot] = STATE(527),
    [sym_namespace_get] = STATE(527),
    [sym_namespace_get_internal] = STATE(527),
    [sym_pipe] = STATE(527),
    [sym_unary] = STATE(527),
    [sym_binary] = STATE(527),
    [sym_na] = STATE(527),
    [sym__expression] = STATE(527),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(527),
    [sym_string] = STATE(527),
    [anon_sym_SEMI] = ACTIONS(1839),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1841),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1841),
    [sym_next] = ACTIONS(1841),
    [sym_true] = ACTIONS(1841),
    [sym_false] = ACTIONS(1841),
    [sym_null] = ACTIONS(1841),
    [sym_inf] = ACTIONS(1841),
    [sym_nan] = ACTIONS(1841),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1839),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [338] = {
    [sym_function_definition] = STATE(526),
    [sym_lambda_function] = STATE(526),
    [sym_if] = STATE(526),
    [sym_while] = STATE(526),
    [sym_repeat] = STATE(526),
    [sym_for] = STATE(526),
    [sym_switch] = STATE(526),
    [sym_call] = STATE(526),
    [sym__assignment] = STATE(526),
    [sym_left_assignment] = STATE(526),
    [sym_left_assignment2] = STATE(526),
    [sym_equals_assignment] = STATE(526),
    [sym_super_assignment] = STATE(526),
    [sym_super_right_assignment] = STATE(526),
    [sym_right_assignment] = STATE(526),
    [sym_brace_list] = STATE(526),
    [sym_paren_list] = STATE(526),
    [sym_subset] = STATE(526),
    [sym_subset2] = STATE(526),
    [sym_dollar] = STATE(526),
    [sym_slot] = STATE(526),
    [sym_namespace_get] = STATE(526),
    [sym_namespace_get_internal] = STATE(526),
    [sym_pipe] = STATE(526),
    [sym_unary] = STATE(526),
    [sym_binary] = STATE(526),
    [sym_na] = STATE(526),
    [sym__expression] = STATE(526),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(526),
    [sym_string] = STATE(526),
    [anon_sym_SEMI] = ACTIONS(1843),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1845),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1845),
    [sym_next] = ACTIONS(1845),
    [sym_true] = ACTIONS(1845),
    [sym_false] = ACTIONS(1845),
    [sym_null] = ACTIONS(1845),
    [sym_inf] = ACTIONS(1845),
    [sym_nan] = ACTIONS(1845),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1843),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [339] = {
    [sym_function_definition] = STATE(857),
    [sym_lambda_function] = STATE(857),
    [sym_if] = STATE(857),
    [sym_while] = STATE(857),
    [sym_repeat] = STATE(857),
    [sym_for] = STATE(857),
    [sym_switch] = STATE(857),
    [sym_call] = STATE(857),
    [sym__assignment] = STATE(857),
    [sym_left_assignment] = STATE(857),
    [sym_left_assignment2] = STATE(857),
    [sym_equals_assignment] = STATE(857),
    [sym_super_assignment] = STATE(857),
    [sym_super_right_assignment] = STATE(857),
    [sym_right_assignment] = STATE(857),
    [sym_brace_list] = STATE(857),
    [sym_paren_list] = STATE(857),
    [sym_subset] = STATE(857),
    [sym_subset2] = STATE(857),
    [sym_dollar] = STATE(857),
    [sym_slot] = STATE(857),
    [sym_namespace_get] = STATE(857),
    [sym_namespace_get_internal] = STATE(857),
    [sym_pipe] = STATE(857),
    [sym_unary] = STATE(857),
    [sym_binary] = STATE(857),
    [sym_na] = STATE(857),
    [sym__expression] = STATE(857),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(857),
    [sym_string] = STATE(857),
    [anon_sym_SEMI] = ACTIONS(1847),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1849),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1849),
    [sym_next] = ACTIONS(1849),
    [sym_true] = ACTIONS(1849),
    [sym_false] = ACTIONS(1849),
    [sym_null] = ACTIONS(1849),
    [sym_inf] = ACTIONS(1849),
    [sym_nan] = ACTIONS(1849),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1847),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [340] = {
    [sym_function_definition] = STATE(858),
    [sym_lambda_function] = STATE(858),
    [sym_if] = STATE(858),
    [sym_while] = STATE(858),
    [sym_repeat] = STATE(858),
    [sym_for] = STATE(858),
    [sym_switch] = STATE(858),
    [sym_call] = STATE(858),
    [sym__assignment] = STATE(858),
    [sym_left_assignment] = STATE(858),
    [sym_left_assignment2] = STATE(858),
    [sym_equals_assignment] = STATE(858),
    [sym_super_assignment] = STATE(858),
    [sym_super_right_assignment] = STATE(858),
    [sym_right_assignment] = STATE(858),
    [sym_brace_list] = STATE(858),
    [sym_paren_list] = STATE(858),
    [sym_subset] = STATE(858),
    [sym_subset2] = STATE(858),
    [sym_dollar] = STATE(858),
    [sym_slot] = STATE(858),
    [sym_namespace_get] = STATE(858),
    [sym_namespace_get_internal] = STATE(858),
    [sym_pipe] = STATE(858),
    [sym_unary] = STATE(858),
    [sym_binary] = STATE(858),
    [sym_na] = STATE(858),
    [sym__expression] = STATE(858),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(858),
    [sym_string] = STATE(858),
    [anon_sym_SEMI] = ACTIONS(1851),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1853),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1853),
    [sym_next] = ACTIONS(1853),
    [sym_true] = ACTIONS(1853),
    [sym_false] = ACTIONS(1853),
    [sym_null] = ACTIONS(1853),
    [sym_inf] = ACTIONS(1853),
    [sym_nan] = ACTIONS(1853),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1851),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [341] = {
    [sym_function_definition] = STATE(862),
    [sym_lambda_function] = STATE(862),
    [sym_if] = STATE(862),
    [sym_while] = STATE(862),
    [sym_repeat] = STATE(862),
    [sym_for] = STATE(862),
    [sym_switch] = STATE(862),
    [sym_call] = STATE(862),
    [sym__assignment] = STATE(862),
    [sym_left_assignment] = STATE(862),
    [sym_left_assignment2] = STATE(862),
    [sym_equals_assignment] = STATE(862),
    [sym_super_assignment] = STATE(862),
    [sym_super_right_assignment] = STATE(862),
    [sym_right_assignment] = STATE(862),
    [sym_brace_list] = STATE(862),
    [sym_paren_list] = STATE(862),
    [sym_subset] = STATE(862),
    [sym_subset2] = STATE(862),
    [sym_dollar] = STATE(862),
    [sym_slot] = STATE(862),
    [sym_namespace_get] = STATE(862),
    [sym_namespace_get_internal] = STATE(862),
    [sym_pipe] = STATE(862),
    [sym_unary] = STATE(862),
    [sym_binary] = STATE(862),
    [sym_na] = STATE(862),
    [sym__expression] = STATE(862),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(862),
    [sym_string] = STATE(862),
    [anon_sym_SEMI] = ACTIONS(1855),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1857),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1857),
    [sym_next] = ACTIONS(1857),
    [sym_true] = ACTIONS(1857),
    [sym_false] = ACTIONS(1857),
    [sym_null] = ACTIONS(1857),
    [sym_inf] = ACTIONS(1857),
    [sym_nan] = ACTIONS(1857),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1855),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [342] = {
    [sym_function_definition] = STATE(875),
    [sym_lambda_function] = STATE(875),
    [sym_if] = STATE(875),
    [sym_while] = STATE(875),
    [sym_repeat] = STATE(875),
    [sym_for] = STATE(875),
    [sym_switch] = STATE(875),
    [sym_call] = STATE(875),
    [sym__assignment] = STATE(875),
    [sym_left_assignment] = STATE(875),
    [sym_left_assignment2] = STATE(875),
    [sym_equals_assignment] = STATE(875),
    [sym_super_assignment] = STATE(875),
    [sym_super_right_assignment] = STATE(875),
    [sym_right_assignment] = STATE(875),
    [sym_brace_list] = STATE(875),
    [sym_paren_list] = STATE(875),
    [sym_subset] = STATE(875),
    [sym_subset2] = STATE(875),
    [sym_dollar] = STATE(875),
    [sym_slot] = STATE(875),
    [sym_namespace_get] = STATE(875),
    [sym_namespace_get_internal] = STATE(875),
    [sym_pipe] = STATE(875),
    [sym_unary] = STATE(875),
    [sym_binary] = STATE(875),
    [sym_na] = STATE(875),
    [sym__expression] = STATE(875),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(875),
    [sym_string] = STATE(875),
    [anon_sym_SEMI] = ACTIONS(1859),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1861),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1861),
    [sym_next] = ACTIONS(1861),
    [sym_true] = ACTIONS(1861),
    [sym_false] = ACTIONS(1861),
    [sym_null] = ACTIONS(1861),
    [sym_inf] = ACTIONS(1861),
    [sym_nan] = ACTIONS(1861),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1859),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [343] = {
    [sym_function_definition] = STATE(876),
    [sym_lambda_function] = STATE(876),
    [sym_if] = STATE(876),
    [sym_while] = STATE(876),
    [sym_repeat] = STATE(876),
    [sym_for] = STATE(876),
    [sym_switch] = STATE(876),
    [sym_call] = STATE(876),
    [sym__assignment] = STATE(876),
    [sym_left_assignment] = STATE(876),
    [sym_left_assignment2] = STATE(876),
    [sym_equals_assignment] = STATE(876),
    [sym_super_assignment] = STATE(876),
    [sym_super_right_assignment] = STATE(876),
    [sym_right_assignment] = STATE(876),
    [sym_brace_list] = STATE(876),
    [sym_paren_list] = STATE(876),
    [sym_subset] = STATE(876),
    [sym_subset2] = STATE(876),
    [sym_dollar] = STATE(876),
    [sym_slot] = STATE(876),
    [sym_namespace_get] = STATE(876),
    [sym_namespace_get_internal] = STATE(876),
    [sym_pipe] = STATE(876),
    [sym_unary] = STATE(876),
    [sym_binary] = STATE(876),
    [sym_na] = STATE(876),
    [sym__expression] = STATE(876),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(876),
    [sym_string] = STATE(876),
    [anon_sym_SEMI] = ACTIONS(1863),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1865),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1865),
    [sym_next] = ACTIONS(1865),
    [sym_true] = ACTIONS(1865),
    [sym_false] = ACTIONS(1865),
    [sym_null] = ACTIONS(1865),
    [sym_inf] = ACTIONS(1865),
    [sym_nan] = ACTIONS(1865),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1863),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [344] = {
    [sym_function_definition] = STATE(877),
    [sym_lambda_function] = STATE(877),
    [sym_if] = STATE(877),
    [sym_while] = STATE(877),
    [sym_repeat] = STATE(877),
    [sym_for] = STATE(877),
    [sym_switch] = STATE(877),
    [sym_call] = STATE(877),
    [sym__assignment] = STATE(877),
    [sym_left_assignment] = STATE(877),
    [sym_left_assignment2] = STATE(877),
    [sym_equals_assignment] = STATE(877),
    [sym_super_assignment] = STATE(877),
    [sym_super_right_assignment] = STATE(877),
    [sym_right_assignment] = STATE(877),
    [sym_brace_list] = STATE(877),
    [sym_paren_list] = STATE(877),
    [sym_subset] = STATE(877),
    [sym_subset2] = STATE(877),
    [sym_dollar] = STATE(877),
    [sym_slot] = STATE(877),
    [sym_namespace_get] = STATE(877),
    [sym_namespace_get_internal] = STATE(877),
    [sym_pipe] = STATE(877),
    [sym_unary] = STATE(877),
    [sym_binary] = STATE(877),
    [sym_na] = STATE(877),
    [sym__expression] = STATE(877),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(877),
    [sym_string] = STATE(877),
    [anon_sym_SEMI] = ACTIONS(1867),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1869),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1869),
    [sym_next] = ACTIONS(1869),
    [sym_true] = ACTIONS(1869),
    [sym_false] = ACTIONS(1869),
    [sym_null] = ACTIONS(1869),
    [sym_inf] = ACTIONS(1869),
    [sym_nan] = ACTIONS(1869),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1867),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [345] = {
    [sym_function_definition] = STATE(693),
    [sym_lambda_function] = STATE(693),
    [sym_if] = STATE(693),
    [sym_while] = STATE(693),
    [sym_repeat] = STATE(693),
    [sym_for] = STATE(693),
    [sym_switch] = STATE(693),
    [sym_call] = STATE(693),
    [sym__assignment] = STATE(693),
    [sym_left_assignment] = STATE(693),
    [sym_left_assignment2] = STATE(693),
    [sym_equals_assignment] = STATE(693),
    [sym_super_assignment] = STATE(693),
    [sym_super_right_assignment] = STATE(693),
    [sym_right_assignment] = STATE(693),
    [sym_brace_list] = STATE(693),
    [sym_paren_list] = STATE(693),
    [sym_subset] = STATE(693),
    [sym_subset2] = STATE(693),
    [sym_dollar] = STATE(693),
    [sym_slot] = STATE(693),
    [sym_namespace_get] = STATE(693),
    [sym_namespace_get_internal] = STATE(693),
    [sym_pipe] = STATE(693),
    [sym_unary] = STATE(693),
    [sym_binary] = STATE(693),
    [sym_na] = STATE(693),
    [sym__expression] = STATE(693),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(693),
    [sym_string] = STATE(693),
    [anon_sym_SEMI] = ACTIONS(1871),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1873),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1873),
    [sym_next] = ACTIONS(1873),
    [sym_true] = ACTIONS(1873),
    [sym_false] = ACTIONS(1873),
    [sym_null] = ACTIONS(1873),
    [sym_inf] = ACTIONS(1873),
    [sym_nan] = ACTIONS(1873),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1871),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [346] = {
    [sym_function_definition] = STATE(686),
    [sym_lambda_function] = STATE(686),
    [sym_if] = STATE(686),
    [sym_while] = STATE(686),
    [sym_repeat] = STATE(686),
    [sym_for] = STATE(686),
    [sym_switch] = STATE(686),
    [sym_call] = STATE(686),
    [sym__assignment] = STATE(686),
    [sym_left_assignment] = STATE(686),
    [sym_left_assignment2] = STATE(686),
    [sym_equals_assignment] = STATE(686),
    [sym_super_assignment] = STATE(686),
    [sym_super_right_assignment] = STATE(686),
    [sym_right_assignment] = STATE(686),
    [sym_brace_list] = STATE(686),
    [sym_paren_list] = STATE(686),
    [sym_subset] = STATE(686),
    [sym_subset2] = STATE(686),
    [sym_dollar] = STATE(686),
    [sym_slot] = STATE(686),
    [sym_namespace_get] = STATE(686),
    [sym_namespace_get_internal] = STATE(686),
    [sym_pipe] = STATE(686),
    [sym_unary] = STATE(686),
    [sym_binary] = STATE(686),
    [sym_na] = STATE(686),
    [sym__expression] = STATE(686),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(686),
    [sym_string] = STATE(686),
    [anon_sym_SEMI] = ACTIONS(1875),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1877),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1877),
    [sym_next] = ACTIONS(1877),
    [sym_true] = ACTIONS(1877),
    [sym_false] = ACTIONS(1877),
    [sym_null] = ACTIONS(1877),
    [sym_inf] = ACTIONS(1877),
    [sym_nan] = ACTIONS(1877),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1875),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [347] = {
    [sym_function_definition] = STATE(853),
    [sym_lambda_function] = STATE(853),
    [sym_if] = STATE(853),
    [sym_while] = STATE(853),
    [sym_repeat] = STATE(853),
    [sym_for] = STATE(853),
    [sym_switch] = STATE(853),
    [sym_call] = STATE(853),
    [sym__assignment] = STATE(853),
    [sym_left_assignment] = STATE(853),
    [sym_left_assignment2] = STATE(853),
    [sym_equals_assignment] = STATE(853),
    [sym_super_assignment] = STATE(853),
    [sym_super_right_assignment] = STATE(853),
    [sym_right_assignment] = STATE(853),
    [sym_brace_list] = STATE(853),
    [sym_paren_list] = STATE(853),
    [sym_subset] = STATE(853),
    [sym_subset2] = STATE(853),
    [sym_dollar] = STATE(853),
    [sym_slot] = STATE(853),
    [sym_namespace_get] = STATE(853),
    [sym_namespace_get_internal] = STATE(853),
    [sym_pipe] = STATE(853),
    [sym_unary] = STATE(853),
    [sym_binary] = STATE(853),
    [sym_na] = STATE(853),
    [sym__expression] = STATE(853),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(853),
    [sym_string] = STATE(853),
    [anon_sym_SEMI] = ACTIONS(1879),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1881),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1881),
    [sym_next] = ACTIONS(1881),
    [sym_true] = ACTIONS(1881),
    [sym_false] = ACTIONS(1881),
    [sym_null] = ACTIONS(1881),
    [sym_inf] = ACTIONS(1881),
    [sym_nan] = ACTIONS(1881),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1879),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [348] = {
    [sym_function_definition] = STATE(872),
    [sym_lambda_function] = STATE(872),
    [sym_if] = STATE(872),
    [sym_while] = STATE(872),
    [sym_repeat] = STATE(872),
    [sym_for] = STATE(872),
    [sym_switch] = STATE(872),
    [sym_call] = STATE(872),
    [sym__assignment] = STATE(872),
    [sym_left_assignment] = STATE(872),
    [sym_left_assignment2] = STATE(872),
    [sym_equals_assignment] = STATE(872),
    [sym_super_assignment] = STATE(872),
    [sym_super_right_assignment] = STATE(872),
    [sym_right_assignment] = STATE(872),
    [sym_brace_list] = STATE(872),
    [sym_paren_list] = STATE(872),
    [sym_subset] = STATE(872),
    [sym_subset2] = STATE(872),
    [sym_dollar] = STATE(872),
    [sym_slot] = STATE(872),
    [sym_namespace_get] = STATE(872),
    [sym_namespace_get_internal] = STATE(872),
    [sym_pipe] = STATE(872),
    [sym_unary] = STATE(872),
    [sym_binary] = STATE(872),
    [sym_na] = STATE(872),
    [sym__expression] = STATE(872),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(872),
    [sym_string] = STATE(872),
    [anon_sym_SEMI] = ACTIONS(1883),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1885),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1885),
    [sym_next] = ACTIONS(1885),
    [sym_true] = ACTIONS(1885),
    [sym_false] = ACTIONS(1885),
    [sym_null] = ACTIONS(1885),
    [sym_inf] = ACTIONS(1885),
    [sym_nan] = ACTIONS(1885),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1883),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [349] = {
    [sym_function_definition] = STATE(871),
    [sym_lambda_function] = STATE(871),
    [sym_if] = STATE(871),
    [sym_while] = STATE(871),
    [sym_repeat] = STATE(871),
    [sym_for] = STATE(871),
    [sym_switch] = STATE(871),
    [sym_call] = STATE(871),
    [sym__assignment] = STATE(871),
    [sym_left_assignment] = STATE(871),
    [sym_left_assignment2] = STATE(871),
    [sym_equals_assignment] = STATE(871),
    [sym_super_assignment] = STATE(871),
    [sym_super_right_assignment] = STATE(871),
    [sym_right_assignment] = STATE(871),
    [sym_brace_list] = STATE(871),
    [sym_paren_list] = STATE(871),
    [sym_subset] = STATE(871),
    [sym_subset2] = STATE(871),
    [sym_dollar] = STATE(871),
    [sym_slot] = STATE(871),
    [sym_namespace_get] = STATE(871),
    [sym_namespace_get_internal] = STATE(871),
    [sym_pipe] = STATE(871),
    [sym_unary] = STATE(871),
    [sym_binary] = STATE(871),
    [sym_na] = STATE(871),
    [sym__expression] = STATE(871),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(871),
    [sym_string] = STATE(871),
    [anon_sym_SEMI] = ACTIONS(1887),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1889),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1889),
    [sym_next] = ACTIONS(1889),
    [sym_true] = ACTIONS(1889),
    [sym_false] = ACTIONS(1889),
    [sym_null] = ACTIONS(1889),
    [sym_inf] = ACTIONS(1889),
    [sym_nan] = ACTIONS(1889),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1887),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [350] = {
    [sym_function_definition] = STATE(868),
    [sym_lambda_function] = STATE(868),
    [sym_if] = STATE(868),
    [sym_while] = STATE(868),
    [sym_repeat] = STATE(868),
    [sym_for] = STATE(868),
    [sym_switch] = STATE(868),
    [sym_call] = STATE(868),
    [sym__assignment] = STATE(868),
    [sym_left_assignment] = STATE(868),
    [sym_left_assignment2] = STATE(868),
    [sym_equals_assignment] = STATE(868),
    [sym_super_assignment] = STATE(868),
    [sym_super_right_assignment] = STATE(868),
    [sym_right_assignment] = STATE(868),
    [sym_brace_list] = STATE(868),
    [sym_paren_list] = STATE(868),
    [sym_subset] = STATE(868),
    [sym_subset2] = STATE(868),
    [sym_dollar] = STATE(868),
    [sym_slot] = STATE(868),
    [sym_namespace_get] = STATE(868),
    [sym_namespace_get_internal] = STATE(868),
    [sym_pipe] = STATE(868),
    [sym_unary] = STATE(868),
    [sym_binary] = STATE(868),
    [sym_na] = STATE(868),
    [sym__expression] = STATE(868),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(868),
    [sym_string] = STATE(868),
    [anon_sym_SEMI] = ACTIONS(1891),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1893),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1893),
    [sym_next] = ACTIONS(1893),
    [sym_true] = ACTIONS(1893),
    [sym_false] = ACTIONS(1893),
    [sym_null] = ACTIONS(1893),
    [sym_inf] = ACTIONS(1893),
    [sym_nan] = ACTIONS(1893),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1891),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [351] = {
    [sym_function_definition] = STATE(867),
    [sym_lambda_function] = STATE(867),
    [sym_if] = STATE(867),
    [sym_while] = STATE(867),
    [sym_repeat] = STATE(867),
    [sym_for] = STATE(867),
    [sym_switch] = STATE(867),
    [sym_call] = STATE(867),
    [sym__assignment] = STATE(867),
    [sym_left_assignment] = STATE(867),
    [sym_left_assignment2] = STATE(867),
    [sym_equals_assignment] = STATE(867),
    [sym_super_assignment] = STATE(867),
    [sym_super_right_assignment] = STATE(867),
    [sym_right_assignment] = STATE(867),
    [sym_brace_list] = STATE(867),
    [sym_paren_list] = STATE(867),
    [sym_subset] = STATE(867),
    [sym_subset2] = STATE(867),
    [sym_dollar] = STATE(867),
    [sym_slot] = STATE(867),
    [sym_namespace_get] = STATE(867),
    [sym_namespace_get_internal] = STATE(867),
    [sym_pipe] = STATE(867),
    [sym_unary] = STATE(867),
    [sym_binary] = STATE(867),
    [sym_na] = STATE(867),
    [sym__expression] = STATE(867),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(867),
    [sym_string] = STATE(867),
    [anon_sym_SEMI] = ACTIONS(1895),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1897),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1897),
    [sym_next] = ACTIONS(1897),
    [sym_true] = ACTIONS(1897),
    [sym_false] = ACTIONS(1897),
    [sym_null] = ACTIONS(1897),
    [sym_inf] = ACTIONS(1897),
    [sym_nan] = ACTIONS(1897),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1895),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [352] = {
    [sym_function_definition] = STATE(866),
    [sym_lambda_function] = STATE(866),
    [sym_if] = STATE(866),
    [sym_while] = STATE(866),
    [sym_repeat] = STATE(866),
    [sym_for] = STATE(866),
    [sym_switch] = STATE(866),
    [sym_call] = STATE(866),
    [sym__assignment] = STATE(866),
    [sym_left_assignment] = STATE(866),
    [sym_left_assignment2] = STATE(866),
    [sym_equals_assignment] = STATE(866),
    [sym_super_assignment] = STATE(866),
    [sym_super_right_assignment] = STATE(866),
    [sym_right_assignment] = STATE(866),
    [sym_brace_list] = STATE(866),
    [sym_paren_list] = STATE(866),
    [sym_subset] = STATE(866),
    [sym_subset2] = STATE(866),
    [sym_dollar] = STATE(866),
    [sym_slot] = STATE(866),
    [sym_namespace_get] = STATE(866),
    [sym_namespace_get_internal] = STATE(866),
    [sym_pipe] = STATE(866),
    [sym_unary] = STATE(866),
    [sym_binary] = STATE(866),
    [sym_na] = STATE(866),
    [sym__expression] = STATE(866),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(866),
    [sym_string] = STATE(866),
    [anon_sym_SEMI] = ACTIONS(1899),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1901),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1901),
    [sym_next] = ACTIONS(1901),
    [sym_true] = ACTIONS(1901),
    [sym_false] = ACTIONS(1901),
    [sym_null] = ACTIONS(1901),
    [sym_inf] = ACTIONS(1901),
    [sym_nan] = ACTIONS(1901),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1899),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [353] = {
    [sym_function_definition] = STATE(865),
    [sym_lambda_function] = STATE(865),
    [sym_if] = STATE(865),
    [sym_while] = STATE(865),
    [sym_repeat] = STATE(865),
    [sym_for] = STATE(865),
    [sym_switch] = STATE(865),
    [sym_call] = STATE(865),
    [sym__assignment] = STATE(865),
    [sym_left_assignment] = STATE(865),
    [sym_left_assignment2] = STATE(865),
    [sym_equals_assignment] = STATE(865),
    [sym_super_assignment] = STATE(865),
    [sym_super_right_assignment] = STATE(865),
    [sym_right_assignment] = STATE(865),
    [sym_brace_list] = STATE(865),
    [sym_paren_list] = STATE(865),
    [sym_subset] = STATE(865),
    [sym_subset2] = STATE(865),
    [sym_dollar] = STATE(865),
    [sym_slot] = STATE(865),
    [sym_namespace_get] = STATE(865),
    [sym_namespace_get_internal] = STATE(865),
    [sym_pipe] = STATE(865),
    [sym_unary] = STATE(865),
    [sym_binary] = STATE(865),
    [sym_na] = STATE(865),
    [sym__expression] = STATE(865),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(865),
    [sym_string] = STATE(865),
    [anon_sym_SEMI] = ACTIONS(1903),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1905),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1905),
    [sym_next] = ACTIONS(1905),
    [sym_true] = ACTIONS(1905),
    [sym_false] = ACTIONS(1905),
    [sym_null] = ACTIONS(1905),
    [sym_inf] = ACTIONS(1905),
    [sym_nan] = ACTIONS(1905),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1903),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [354] = {
    [sym_function_definition] = STATE(864),
    [sym_lambda_function] = STATE(864),
    [sym_if] = STATE(864),
    [sym_while] = STATE(864),
    [sym_repeat] = STATE(864),
    [sym_for] = STATE(864),
    [sym_switch] = STATE(864),
    [sym_call] = STATE(864),
    [sym__assignment] = STATE(864),
    [sym_left_assignment] = STATE(864),
    [sym_left_assignment2] = STATE(864),
    [sym_equals_assignment] = STATE(864),
    [sym_super_assignment] = STATE(864),
    [sym_super_right_assignment] = STATE(864),
    [sym_right_assignment] = STATE(864),
    [sym_brace_list] = STATE(864),
    [sym_paren_list] = STATE(864),
    [sym_subset] = STATE(864),
    [sym_subset2] = STATE(864),
    [sym_dollar] = STATE(864),
    [sym_slot] = STATE(864),
    [sym_namespace_get] = STATE(864),
    [sym_namespace_get_internal] = STATE(864),
    [sym_pipe] = STATE(864),
    [sym_unary] = STATE(864),
    [sym_binary] = STATE(864),
    [sym_na] = STATE(864),
    [sym__expression] = STATE(864),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(864),
    [sym_string] = STATE(864),
    [anon_sym_SEMI] = ACTIONS(1907),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1909),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1909),
    [sym_next] = ACTIONS(1909),
    [sym_true] = ACTIONS(1909),
    [sym_false] = ACTIONS(1909),
    [sym_null] = ACTIONS(1909),
    [sym_inf] = ACTIONS(1909),
    [sym_nan] = ACTIONS(1909),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1907),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [355] = {
    [sym_function_definition] = STATE(863),
    [sym_lambda_function] = STATE(863),
    [sym_if] = STATE(863),
    [sym_while] = STATE(863),
    [sym_repeat] = STATE(863),
    [sym_for] = STATE(863),
    [sym_switch] = STATE(863),
    [sym_call] = STATE(863),
    [sym__assignment] = STATE(863),
    [sym_left_assignment] = STATE(863),
    [sym_left_assignment2] = STATE(863),
    [sym_equals_assignment] = STATE(863),
    [sym_super_assignment] = STATE(863),
    [sym_super_right_assignment] = STATE(863),
    [sym_right_assignment] = STATE(863),
    [sym_brace_list] = STATE(863),
    [sym_paren_list] = STATE(863),
    [sym_subset] = STATE(863),
    [sym_subset2] = STATE(863),
    [sym_dollar] = STATE(863),
    [sym_slot] = STATE(863),
    [sym_namespace_get] = STATE(863),
    [sym_namespace_get_internal] = STATE(863),
    [sym_pipe] = STATE(863),
    [sym_unary] = STATE(863),
    [sym_binary] = STATE(863),
    [sym_na] = STATE(863),
    [sym__expression] = STATE(863),
    [sym_identifier] = STATE(162),
    [sym_complex] = STATE(863),
    [sym_string] = STATE(863),
    [anon_sym_SEMI] = ACTIONS(1911),
    [anon_sym_function] = ACTIONS(703),
    [anon_sym_BSLASH] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(707),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(709),
    [anon_sym_repeat] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1913),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(719),
    [anon_sym_TILDE] = ACTIONS(721),
    [sym_break] = ACTIONS(1913),
    [sym_next] = ACTIONS(1913),
    [sym_true] = ACTIONS(1913),
    [sym_false] = ACTIONS(1913),
    [sym_null] = ACTIONS(1913),
    [sym_inf] = ACTIONS(1913),
    [sym_nan] = ACTIONS(1913),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1911),
    [sym_float] = ACTIONS(723),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [356] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [anon_sym_SEMI] = ACTIONS(1915),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1917),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1917),
    [sym_next] = ACTIONS(1917),
    [sym_true] = ACTIONS(1917),
    [sym_false] = ACTIONS(1917),
    [sym_null] = ACTIONS(1917),
    [sym_inf] = ACTIONS(1917),
    [sym_nan] = ACTIONS(1917),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1915),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [357] = {
    [sym_function_definition] = STATE(680),
    [sym_lambda_function] = STATE(680),
    [sym_if] = STATE(680),
    [sym_while] = STATE(680),
    [sym_repeat] = STATE(680),
    [sym_for] = STATE(680),
    [sym_switch] = STATE(680),
    [sym_call] = STATE(680),
    [sym__assignment] = STATE(680),
    [sym_left_assignment] = STATE(680),
    [sym_left_assignment2] = STATE(680),
    [sym_equals_assignment] = STATE(680),
    [sym_super_assignment] = STATE(680),
    [sym_super_right_assignment] = STATE(680),
    [sym_right_assignment] = STATE(680),
    [sym_brace_list] = STATE(680),
    [sym_paren_list] = STATE(680),
    [sym_subset] = STATE(680),
    [sym_subset2] = STATE(680),
    [sym_dollar] = STATE(680),
    [sym_slot] = STATE(680),
    [sym_namespace_get] = STATE(680),
    [sym_namespace_get_internal] = STATE(680),
    [sym_pipe] = STATE(680),
    [sym_unary] = STATE(680),
    [sym_binary] = STATE(680),
    [sym_na] = STATE(680),
    [sym__expression] = STATE(680),
    [sym_identifier] = STATE(571),
    [sym_complex] = STATE(680),
    [sym_string] = STATE(680),
    [anon_sym_SEMI] = ACTIONS(1919),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1921),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1921),
    [sym_next] = ACTIONS(1921),
    [sym_true] = ACTIONS(1921),
    [sym_false] = ACTIONS(1921),
    [sym_null] = ACTIONS(1921),
    [sym_inf] = ACTIONS(1921),
    [sym_nan] = ACTIONS(1921),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1919),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [358] = {
    [sym_function_definition] = STATE(826),
    [sym_lambda_function] = STATE(826),
    [sym_if] = STATE(826),
    [sym_while] = STATE(826),
    [sym_repeat] = STATE(826),
    [sym_for] = STATE(826),
    [sym_switch] = STATE(826),
    [sym_call] = STATE(826),
    [sym__assignment] = STATE(826),
    [sym_left_assignment] = STATE(826),
    [sym_left_assignment2] = STATE(826),
    [sym_equals_assignment] = STATE(826),
    [sym_super_assignment] = STATE(826),
    [sym_super_right_assignment] = STATE(826),
    [sym_right_assignment] = STATE(826),
    [sym_brace_list] = STATE(826),
    [sym_paren_list] = STATE(826),
    [sym_subset] = STATE(826),
    [sym_subset2] = STATE(826),
    [sym_dollar] = STATE(826),
    [sym_slot] = STATE(826),
    [sym_namespace_get] = STATE(826),
    [sym_namespace_get_internal] = STATE(826),
    [sym_pipe] = STATE(826),
    [sym_unary] = STATE(826),
    [sym_binary] = STATE(826),
    [sym_na] = STATE(826),
    [sym__expression] = STATE(826),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(826),
    [sym_string] = STATE(826),
    [anon_sym_SEMI] = ACTIONS(1923),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1925),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1925),
    [sym_next] = ACTIONS(1925),
    [sym_true] = ACTIONS(1925),
    [sym_false] = ACTIONS(1925),
    [sym_null] = ACTIONS(1925),
    [sym_inf] = ACTIONS(1925),
    [sym_nan] = ACTIONS(1925),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1923),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [359] = {
    [sym_function_definition] = STATE(813),
    [sym_lambda_function] = STATE(813),
    [sym_if] = STATE(813),
    [sym_while] = STATE(813),
    [sym_repeat] = STATE(813),
    [sym_for] = STATE(813),
    [sym_switch] = STATE(813),
    [sym_call] = STATE(813),
    [sym__assignment] = STATE(813),
    [sym_left_assignment] = STATE(813),
    [sym_left_assignment2] = STATE(813),
    [sym_equals_assignment] = STATE(813),
    [sym_super_assignment] = STATE(813),
    [sym_super_right_assignment] = STATE(813),
    [sym_right_assignment] = STATE(813),
    [sym_brace_list] = STATE(813),
    [sym_paren_list] = STATE(813),
    [sym_subset] = STATE(813),
    [sym_subset2] = STATE(813),
    [sym_dollar] = STATE(813),
    [sym_slot] = STATE(813),
    [sym_namespace_get] = STATE(813),
    [sym_namespace_get_internal] = STATE(813),
    [sym_pipe] = STATE(813),
    [sym_unary] = STATE(813),
    [sym_binary] = STATE(813),
    [sym_na] = STATE(813),
    [sym__expression] = STATE(813),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(813),
    [sym_string] = STATE(813),
    [anon_sym_SEMI] = ACTIONS(1927),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1929),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1929),
    [sym_next] = ACTIONS(1929),
    [sym_true] = ACTIONS(1929),
    [sym_false] = ACTIONS(1929),
    [sym_null] = ACTIONS(1929),
    [sym_inf] = ACTIONS(1929),
    [sym_nan] = ACTIONS(1929),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1927),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [360] = {
    [sym_function_definition] = STATE(525),
    [sym_lambda_function] = STATE(525),
    [sym_if] = STATE(525),
    [sym_while] = STATE(525),
    [sym_repeat] = STATE(525),
    [sym_for] = STATE(525),
    [sym_switch] = STATE(525),
    [sym_call] = STATE(525),
    [sym__assignment] = STATE(525),
    [sym_left_assignment] = STATE(525),
    [sym_left_assignment2] = STATE(525),
    [sym_equals_assignment] = STATE(525),
    [sym_super_assignment] = STATE(525),
    [sym_super_right_assignment] = STATE(525),
    [sym_right_assignment] = STATE(525),
    [sym_brace_list] = STATE(525),
    [sym_paren_list] = STATE(525),
    [sym_subset] = STATE(525),
    [sym_subset2] = STATE(525),
    [sym_dollar] = STATE(525),
    [sym_slot] = STATE(525),
    [sym_namespace_get] = STATE(525),
    [sym_namespace_get_internal] = STATE(525),
    [sym_pipe] = STATE(525),
    [sym_unary] = STATE(525),
    [sym_binary] = STATE(525),
    [sym_na] = STATE(525),
    [sym__expression] = STATE(525),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(525),
    [sym_string] = STATE(525),
    [anon_sym_SEMI] = ACTIONS(1931),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1933),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1933),
    [sym_next] = ACTIONS(1933),
    [sym_true] = ACTIONS(1933),
    [sym_false] = ACTIONS(1933),
    [sym_null] = ACTIONS(1933),
    [sym_inf] = ACTIONS(1933),
    [sym_nan] = ACTIONS(1933),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1931),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [361] = {
    [sym_function_definition] = STATE(524),
    [sym_lambda_function] = STATE(524),
    [sym_if] = STATE(524),
    [sym_while] = STATE(524),
    [sym_repeat] = STATE(524),
    [sym_for] = STATE(524),
    [sym_switch] = STATE(524),
    [sym_call] = STATE(524),
    [sym__assignment] = STATE(524),
    [sym_left_assignment] = STATE(524),
    [sym_left_assignment2] = STATE(524),
    [sym_equals_assignment] = STATE(524),
    [sym_super_assignment] = STATE(524),
    [sym_super_right_assignment] = STATE(524),
    [sym_right_assignment] = STATE(524),
    [sym_brace_list] = STATE(524),
    [sym_paren_list] = STATE(524),
    [sym_subset] = STATE(524),
    [sym_subset2] = STATE(524),
    [sym_dollar] = STATE(524),
    [sym_slot] = STATE(524),
    [sym_namespace_get] = STATE(524),
    [sym_namespace_get_internal] = STATE(524),
    [sym_pipe] = STATE(524),
    [sym_unary] = STATE(524),
    [sym_binary] = STATE(524),
    [sym_na] = STATE(524),
    [sym__expression] = STATE(524),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(524),
    [sym_string] = STATE(524),
    [anon_sym_SEMI] = ACTIONS(1935),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1937),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1937),
    [sym_next] = ACTIONS(1937),
    [sym_true] = ACTIONS(1937),
    [sym_false] = ACTIONS(1937),
    [sym_null] = ACTIONS(1937),
    [sym_inf] = ACTIONS(1937),
    [sym_nan] = ACTIONS(1937),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1935),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [362] = {
    [sym_function_definition] = STATE(825),
    [sym_lambda_function] = STATE(825),
    [sym_if] = STATE(825),
    [sym_while] = STATE(825),
    [sym_repeat] = STATE(825),
    [sym_for] = STATE(825),
    [sym_switch] = STATE(825),
    [sym_call] = STATE(825),
    [sym__assignment] = STATE(825),
    [sym_left_assignment] = STATE(825),
    [sym_left_assignment2] = STATE(825),
    [sym_equals_assignment] = STATE(825),
    [sym_super_assignment] = STATE(825),
    [sym_super_right_assignment] = STATE(825),
    [sym_right_assignment] = STATE(825),
    [sym_brace_list] = STATE(825),
    [sym_paren_list] = STATE(825),
    [sym_subset] = STATE(825),
    [sym_subset2] = STATE(825),
    [sym_dollar] = STATE(825),
    [sym_slot] = STATE(825),
    [sym_namespace_get] = STATE(825),
    [sym_namespace_get_internal] = STATE(825),
    [sym_pipe] = STATE(825),
    [sym_unary] = STATE(825),
    [sym_binary] = STATE(825),
    [sym_na] = STATE(825),
    [sym__expression] = STATE(825),
    [sym_identifier] = STATE(797),
    [sym_complex] = STATE(825),
    [sym_string] = STATE(825),
    [anon_sym_SEMI] = ACTIONS(1939),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_BSLASH] = ACTIONS(755),
    [anon_sym_if] = ACTIONS(757),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_while] = ACTIONS(761),
    [anon_sym_repeat] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(769),
    [sym_dots] = ACTIONS(1941),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PLUS] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_TILDE] = ACTIONS(777),
    [sym_break] = ACTIONS(1941),
    [sym_next] = ACTIONS(1941),
    [sym_true] = ACTIONS(1941),
    [sym_false] = ACTIONS(1941),
    [sym_null] = ACTIONS(1941),
    [sym_inf] = ACTIONS(1941),
    [sym_nan] = ACTIONS(1941),
    [anon_sym_NA] = ACTIONS(779),
    [anon_sym_NA_character_] = ACTIONS(779),
    [anon_sym_NA_complex_] = ACTIONS(779),
    [anon_sym_NA_integer_] = ACTIONS(779),
    [anon_sym_NA_real_] = ACTIONS(779),
    [aux_sym_identifier_token1] = ACTIONS(781),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_integer] = ACTIONS(1939),
    [sym_float] = ACTIONS(785),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_SQUOTE] = ACTIONS(789),
  },
  [363] = {
    [sym_function_definition] = STATE(518),
    [sym_lambda_function] = STATE(518),
    [sym_if] = STATE(518),
    [sym_while] = STATE(518),
    [sym_repeat] = STATE(518),
    [sym_for] = STATE(518),
    [sym_switch] = STATE(518),
    [sym_call] = STATE(518),
    [sym__assignment] = STATE(518),
    [sym_left_assignment] = STATE(518),
    [sym_left_assignment2] = STATE(518),
    [sym_equals_assignment] = STATE(518),
    [sym_super_assignment] = STATE(518),
    [sym_super_right_assignment] = STATE(518),
    [sym_right_assignment] = STATE(518),
    [sym_brace_list] = STATE(518),
    [sym_paren_list] = STATE(518),
    [sym_subset] = STATE(518),
    [sym_subset2] = STATE(518),
    [sym_dollar] = STATE(518),
    [sym_slot] = STATE(518),
    [sym_namespace_get] = STATE(518),
    [sym_namespace_get_internal] = STATE(518),
    [sym_pipe] = STATE(518),
    [sym_unary] = STATE(518),
    [sym_binary] = STATE(518),
    [sym_na] = STATE(518),
    [sym__expression] = STATE(518),
    [sym_identifier] = STATE(327),
    [sym_complex] = STATE(518),
    [sym_string] = STATE(518),
    [anon_sym_SEMI] = ACTIONS(1943),
    [anon_sym_function] = ACTIONS(989),
    [anon_sym_BSLASH] = ACTIONS(991),
    [anon_sym_if] = ACTIONS(993),
    [anon_sym_LPAREN] = ACTIONS(995),
    [anon_sym_while] = ACTIONS(997),
    [anon_sym_repeat] = ACTIONS(999),
    [anon_sym_for] = ACTIONS(1001),
    [anon_sym_switch] = ACTIONS(1003),
    [anon_sym_LBRACE] = ACTIONS(1005),
    [sym_dots] = ACTIONS(1945),
    [anon_sym_DASH] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(1009),
    [anon_sym_BANG] = ACTIONS(1011),
    [anon_sym_TILDE] = ACTIONS(1013),
    [sym_break] = ACTIONS(1945),
    [sym_next] = ACTIONS(1945),
    [sym_true] = ACTIONS(1945),
    [sym_false] = ACTIONS(1945),
    [sym_null] = ACTIONS(1945),
    [sym_inf] = ACTIONS(1945),
    [sym_nan] = ACTIONS(1945),
    [anon_sym_NA] = ACTIONS(1015),
    [anon_sym_NA_character_] = ACTIONS(1015),
    [anon_sym_NA_complex_] = ACTIONS(1015),
    [anon_sym_NA_integer_] = ACTIONS(1015),
    [anon_sym_NA_real_] = ACTIONS(1015),
    [aux_sym_identifier_token1] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1019),
    [sym_integer] = ACTIONS(1943),
    [sym_float] = ACTIONS(1021),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1023),
    [anon_sym_SQUOTE] = ACTIONS(1025),
  },
  [364] = {
    [sym_function_definition] = STATE(517),
    [sym_lambda_function] = STATE(517),
    [sym_if] = STATE(517),
    [sym_while] = STATE(517),
    [sym_repeat] = STATE(517),
    [sym_for] = STATE(517),
    [sym_switch] = STATE(517),
    [sym_call] = STATE(517),
    [sym__assignment] = STATE(517),
    [sym_left_assignment] = STATE(517),
    [sym_left_assignment2] = STATE(517),
    [sym_equals_assignment] = STATE(517),
    [sym_super_assignment] = STATE(517),
    [sym_super_right_assignment] = STATE(517