/*
*  qm_clickprogressbar.h
*  QUIMUP clickable progressbar class
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_CPROGRESSBAR_H
#define QM_CPROGRESSBAR_H

#include <QSlider>
#include <qevent.h> // note: <QEvent> equals qcoreevent.h

class qm_clickProgressbar : public QSlider
{
    Q_OBJECT

public:
    qm_clickProgressbar(QWidget *parent = nullptr);
    virtual ~qm_clickProgressbar();

protected:
    void keyPressEvent(QKeyEvent*);
    void keyReleaseEvent(QKeyEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    void mousePressEvent(QMouseEvent*);

signals:
    void clicked();
    void clicked(QMouseEvent*);
    void pressed();
    void pressed(QMouseEvent*);
    void scrolled(int);
};

#endif // QM_CPROGRESSBAR_H
