/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import javax.management.openmbean.CompositeData;
import sun.management.ManagementFactoryHelper;
import sun.management.ThreadInfoCompositeData;

public class ThreadInfo {
    private String threadName;
    private long threadId;
    private long blockedTime;
    private long blockedCount;
    private long waitedTime;
    private long waitedCount;
    private LockInfo lock;
    private String lockName;
    private long lockOwnerId;
    private String lockOwnerName;
    private boolean inNative;
    private boolean suspended;
    private Thread.State threadState;
    private StackTraceElement[] stackTrace;
    private MonitorInfo[] lockedMonitors;
    private LockInfo[] lockedSynchronizers;
    private static MonitorInfo[] EMPTY_MONITORS = new MonitorInfo[0];
    private static LockInfo[] EMPTY_SYNCS = new LockInfo[0];
    private static final int MAX_FRAMES = 8;
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];

    private ThreadInfo(Thread thread, int n, Object object, Thread thread2, long l, long l2, long l3, long l4, StackTraceElement[] stackTraceElementArray) {
        this.initialize(thread, n, object, thread2, l, l2, l3, l4, stackTraceElementArray, EMPTY_MONITORS, EMPTY_SYNCS);
    }

    private ThreadInfo(Thread thread, int n, Object object, Thread thread2, long l, long l2, long l3, long l4, StackTraceElement[] stackTraceElementArray, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object object2;
        int n2;
        MonitorInfo[] monitorInfoArray;
        int n3;
        int n4 = n3 = objectArray == null ? 0 : objectArray.length;
        if (n3 == 0) {
            monitorInfoArray = EMPTY_MONITORS;
        } else {
            monitorInfoArray = new MonitorInfo[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = objectArray[n2];
                String string = object2.getClass().getName();
                int n5 = System.identityHashCode(object2);
                int n6 = nArray[n2];
                StackTraceElement stackTraceElement = n6 >= 0 ? stackTraceElementArray[n6] : null;
                monitorInfoArray[n2] = new MonitorInfo(string, n5, n6, stackTraceElement);
            }
        }
        int n7 = n2 = objectArray2 == null ? 0 : objectArray2.length;
        if (n2 == 0) {
            object2 = EMPTY_SYNCS;
        } else {
            object2 = new LockInfo[n2];
            for (int i = 0; i < n2; ++i) {
                Object object3 = objectArray2[i];
                String string = object3.getClass().getName();
                int n8 = System.identityHashCode(object3);
                object2[i] = new LockInfo(string, n8);
            }
        }
        this.initialize(thread, n, object, thread2, l, l2, l3, l4, stackTraceElementArray, monitorInfoArray, (LockInfo[])object2);
    }

    private void initialize(Thread thread, int n, Object object, Thread thread2, long l, long l2, long l3, long l4, StackTraceElement[] stackTraceElementArray, MonitorInfo[] monitorInfoArray, LockInfo[] lockInfoArray) {
        this.threadId = thread.getId();
        this.threadName = thread.getName();
        this.threadState = ManagementFactoryHelper.toThreadState(n);
        this.suspended = ManagementFactoryHelper.isThreadSuspended(n);
        this.inNative = ManagementFactoryHelper.isThreadRunningNative(n);
        this.blockedCount = l;
        this.blockedTime = l2;
        this.waitedCount = l3;
        this.waitedTime = l4;
        if (object == null) {
            this.lock = null;
            this.lockName = null;
        } else {
            this.lock = new LockInfo(object);
            this.lockName = this.lock.getClassName() + '@' + Integer.toHexString(this.lock.getIdentityHashCode());
        }
        if (thread2 == null) {
            this.lockOwnerId = -1L;
            this.lockOwnerName = null;
        } else {
            this.lockOwnerId = thread2.getId();
            this.lockOwnerName = thread2.getName();
        }
        this.stackTrace = stackTraceElementArray == null ? NO_STACK_TRACE : stackTraceElementArray;
        this.lockedMonitors = monitorInfoArray;
        this.lockedSynchronizers = lockInfoArray;
    }

    private ThreadInfo(CompositeData compositeData) {
        ThreadInfoCompositeData threadInfoCompositeData = ThreadInfoCompositeData.getInstance(compositeData);
        this.threadId = threadInfoCompositeData.threadId();
        this.threadName = threadInfoCompositeData.threadName();
        this.blockedTime = threadInfoCompositeData.blockedTime();
        this.blockedCount = threadInfoCompositeData.blockedCount();
        this.waitedTime = threadInfoCompositeData.waitedTime();
        this.waitedCount = threadInfoCompositeData.waitedCount();
        this.lockName = threadInfoCompositeData.lockName();
        this.lockOwnerId = threadInfoCompositeData.lockOwnerId();
        this.lockOwnerName = threadInfoCompositeData.lockOwnerName();
        this.threadState = threadInfoCompositeData.threadState();
        this.suspended = threadInfoCompositeData.suspended();
        this.inNative = threadInfoCompositeData.inNative();
        this.stackTrace = threadInfoCompositeData.stackTrace();
        if (threadInfoCompositeData.isCurrentVersion()) {
            this.lock = threadInfoCompositeData.lockInfo();
            this.lockedMonitors = threadInfoCompositeData.lockedMonitors();
            this.lockedSynchronizers = threadInfoCompositeData.lockedSynchronizers();
        } else {
            if (this.lockName != null) {
                String[] stringArray = this.lockName.split("@");
                if (stringArray.length == 2) {
                    int n = Integer.parseInt(stringArray[1], 16);
                    this.lock = new LockInfo(stringArray[0], n);
                } else {
                    assert (stringArray.length == 2);
                    this.lock = null;
                }
            } else {
                this.lock = null;
            }
            this.lockedMonitors = EMPTY_MONITORS;
            this.lockedSynchronizers = EMPTY_SYNCS;
        }
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public LockInfo getLockInfo() {
        return this.lock;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public String toString() {
        LockInfo[] lockInfoArray;
        int n;
        StringBuilder stringBuilder = new StringBuilder("\"" + this.getThreadName() + "\" Id=" + this.getThreadId() + " " + (Object)((Object)this.getThreadState()));
        if (this.getLockName() != null) {
            stringBuilder.append(" on " + this.getLockName());
        }
        if (this.getLockOwnerName() != null) {
            stringBuilder.append(" owned by \"" + this.getLockOwnerName() + "\" Id=" + this.getLockOwnerId());
        }
        if (this.isSuspended()) {
            stringBuilder.append(" (suspended)");
        }
        if (this.isInNative()) {
            stringBuilder.append(" (in native)");
        }
        stringBuilder.append('\n');
        for (n = 0; n < this.stackTrace.length && n < 8; ++n) {
            lockInfoArray = this.stackTrace[n];
            stringBuilder.append("\tat " + lockInfoArray.toString());
            stringBuilder.append('\n');
            if (n == 0 && this.getLockInfo() != null) {
                Thread.State state = this.getThreadState();
                switch (state) {
                    case BLOCKED: {
                        stringBuilder.append("\t-  blocked on " + this.getLockInfo());
                        stringBuilder.append('\n');
                        break;
                    }
                    case WAITING: {
                        stringBuilder.append("\t-  waiting on " + this.getLockInfo());
                        stringBuilder.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        stringBuilder.append("\t-  waiting on " + this.getLockInfo());
                        stringBuilder.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo object : this.lockedMonitors) {
                if (object.getLockedStackDepth() != n) continue;
                stringBuilder.append("\t-  locked " + object);
                stringBuilder.append('\n');
            }
        }
        if (n < this.stackTrace.length) {
            stringBuilder.append("\t...");
            stringBuilder.append('\n');
        }
        if ((lockInfoArray = this.getLockedSynchronizers()).length > 0) {
            stringBuilder.append("\n\tNumber of locked synchronizers = " + lockInfoArray.length);
            stringBuilder.append('\n');
            for (LockInfo lockInfo : lockInfoArray) {
                stringBuilder.append("\t- " + lockInfo);
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    public static ThreadInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof ThreadInfoCompositeData) {
            return ((ThreadInfoCompositeData)compositeData).getThreadInfo();
        }
        return new ThreadInfo(compositeData);
    }

    public MonitorInfo[] getLockedMonitors() {
        return this.lockedMonitors;
    }

    public LockInfo[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }
}

