//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/coreaudiotypes_version?language=objc)
pub const COREAUDIOTYPES_VERSION: c_uint = 20211130;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudio_noerror?language=objc)
pub const kAudio_NoError: OSStatus = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudio_unimplementederror?language=objc)
pub const kAudio_UnimplementedError: OSStatus = -4;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudio_filenotfounderror?language=objc)
pub const kAudio_FileNotFoundError: OSStatus = -43;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudio_filepermissionerror?language=objc)
pub const kAudio_FilePermissionError: OSStatus = -54;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudio_toomanyfilesopenerror?language=objc)
pub const kAudio_TooManyFilesOpenError: OSStatus = -42;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudio_badfilepatherror?language=objc)
pub const kAudio_BadFilePathError: OSStatus = 0x21707468;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudio_paramerror?language=objc)
pub const kAudio_ParamError: OSStatus = -50;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudio_memfullerror?language=objc)
pub const kAudio_MemFullError: OSStatus = -108;

/// This structure holds a pair of numbers that represent a continuous range of
/// values.
///
/// The minimum value.
///
/// The maximum value.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiovaluerange?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioValueRange {
    pub mMinimum: f64,
    pub mMaximum: f64,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioValueRange {
    const ENCODING: Encoding =
        Encoding::Struct("AudioValueRange", &[<f64>::ENCODING, <f64>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioValueRange {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This stucture holds the buffers necessary for translation operations.
///
/// The buffer containing the data to be translated.
///
/// The number of bytes in the buffer pointed at by mInputData.
///
/// The buffer to hold the result of the translation.
///
/// The number of bytes in the buffer pointed at by mOutputData.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiovaluetranslation?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioValueTranslation {
    pub mInputData: NonNull<c_void>,
    pub mInputDataSize: u32,
    pub mOutputData: NonNull<c_void>,
    pub mOutputDataSize: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioValueTranslation {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioValueTranslation",
        &[
            <NonNull<c_void>>::ENCODING,
            <u32>::ENCODING,
            <NonNull<c_void>>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioValueTranslation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A structure to hold a buffer of audio data.
///
/// The number of interleaved channels in the buffer.
///
/// The number of bytes in the buffer pointed at by mData.
///
/// A pointer to the buffer of audio data.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiobuffer?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioBuffer {
    pub mNumberChannels: u32,
    pub mDataByteSize: u32,
    pub mData: *mut c_void,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioBuffer {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioBuffer",
        &[<u32>::ENCODING, <u32>::ENCODING, <*mut c_void>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioBuffer {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A variable length array of AudioBuffer structures.
///
/// The number of AudioBuffers in the mBuffers array.
///
/// A variable length array of AudioBuffers.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiobufferlist?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioBufferList {
    pub mNumberBuffers: u32,
    pub mBuffers: [AudioBuffer; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioBufferList {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioBufferList",
        &[<u32>::ENCODING, <[AudioBuffer; 1]>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioBufferList {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiosampletype?language=objc)
pub type AudioSampleType = f32;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiounitsampletype?language=objc)
pub type AudioUnitSampleType = f32;

/// A four char code indicating the general kind of data in the stream.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audioformatid?language=objc)
pub type AudioFormatID = u32;

/// Flags that are specific to each format.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audioformatflags?language=objc)
pub type AudioFormatFlags = u32;

/// This structure encapsulates all the information for describing the basic
/// format properties of a stream of audio data.
///
/// This structure is sufficient to describe any constant bit rate format that  has
/// channels that are the same size. Extensions are required for variable bit rate
/// data and for constant bit rate data where the channels have unequal sizes.
/// However, where applicable, the appropriate fields will be filled out correctly
/// for these kinds of formats (the extra data is provided via separate properties).
/// In all fields, a value of 0 indicates that the field is either unknown, not
/// applicable or otherwise is inapproprate for the format and should be ignored.
/// Note that 0 is still a valid value for most formats in the mFormatFlags field.
///
/// In audio data a frame is one sample across all channels. In non-interleaved
/// audio, the per frame fields identify one channel. In interleaved audio, the per
/// frame fields identify the set of n channels. In uncompressed audio, a Packet is
/// one frame, (mFramesPerPacket == 1). In compressed audio, a Packet is an
/// indivisible chunk of compressed data, for example an AAC packet will contain
/// 1024 sample frames.
///
///
/// The number of sample frames per second of the data in the stream.
///
/// The AudioFormatID indicating the general kind of data in the stream.
///
/// The AudioFormatFlags for the format indicated by mFormatID.
///
/// The number of bytes in a packet of data.
///
/// The number of sample frames in each packet of data.
///
/// The number of bytes in a single sample frame of data.
///
/// The number of channels in each frame of data.
///
/// The number of bits of sample data for each channel in a frame of data.
///
/// Pads the structure out to force an even 8 byte alignment.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiostreambasicdescription?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioStreamBasicDescription {
    pub mSampleRate: f64,
    pub mFormatID: AudioFormatID,
    pub mFormatFlags: AudioFormatFlags,
    pub mBytesPerPacket: u32,
    pub mFramesPerPacket: u32,
    pub mBytesPerFrame: u32,
    pub mChannelsPerFrame: u32,
    pub mBitsPerChannel: u32,
    pub mReserved: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioStreamBasicDescription {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioStreamBasicDescription",
        &[
            <f64>::ENCODING,
            <AudioFormatID>::ENCODING,
            <AudioFormatFlags>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioStreamBasicDescription {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The format can use any sample rate. Note that this constant can only appear
/// in listings of supported formats. It will never appear in a current format.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiostreamanyrate?language=objc)
pub static kAudioStreamAnyRate: f64 = 0.0 as _;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatlinearpcm?language=objc)
pub const kAudioFormatLinearPCM: AudioFormatID = 0x6c70636d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatac3?language=objc)
pub const kAudioFormatAC3: AudioFormatID = 0x61632d33;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformat60958ac3?language=objc)
pub const kAudioFormat60958AC3: AudioFormatID = 0x63616333;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatappleima4?language=objc)
pub const kAudioFormatAppleIMA4: AudioFormatID = 0x696d6134;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4aac?language=objc)
pub const kAudioFormatMPEG4AAC: AudioFormatID = 0x61616320;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4celp?language=objc)
pub const kAudioFormatMPEG4CELP: AudioFormatID = 0x63656c70;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4hvxc?language=objc)
pub const kAudioFormatMPEG4HVXC: AudioFormatID = 0x68767863;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4twinvq?language=objc)
pub const kAudioFormatMPEG4TwinVQ: AudioFormatID = 0x74777671;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmace3?language=objc)
pub const kAudioFormatMACE3: AudioFormatID = 0x4d414333;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmace6?language=objc)
pub const kAudioFormatMACE6: AudioFormatID = 0x4d414336;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatulaw?language=objc)
pub const kAudioFormatULaw: AudioFormatID = 0x756c6177;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatalaw?language=objc)
pub const kAudioFormatALaw: AudioFormatID = 0x616c6177;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatqdesign?language=objc)
pub const kAudioFormatQDesign: AudioFormatID = 0x51444d43;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatqdesign2?language=objc)
pub const kAudioFormatQDesign2: AudioFormatID = 0x51444d32;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatqualcomm?language=objc)
pub const kAudioFormatQUALCOMM: AudioFormatID = 0x51636c70;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeglayer1?language=objc)
pub const kAudioFormatMPEGLayer1: AudioFormatID = 0x2e6d7031;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeglayer2?language=objc)
pub const kAudioFormatMPEGLayer2: AudioFormatID = 0x2e6d7032;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeglayer3?language=objc)
pub const kAudioFormatMPEGLayer3: AudioFormatID = 0x2e6d7033;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformattimecode?language=objc)
pub const kAudioFormatTimeCode: AudioFormatID = 0x74696d65;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmidistream?language=objc)
pub const kAudioFormatMIDIStream: AudioFormatID = 0x6d696469;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatparametervaluestream?language=objc)
pub const kAudioFormatParameterValueStream: AudioFormatID = 0x61707673;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatapplelossless?language=objc)
pub const kAudioFormatAppleLossless: AudioFormatID = 0x616c6163;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4aac_he?language=objc)
pub const kAudioFormatMPEG4AAC_HE: AudioFormatID = 0x61616368;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4aac_ld?language=objc)
pub const kAudioFormatMPEG4AAC_LD: AudioFormatID = 0x6161636c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4aac_eld?language=objc)
pub const kAudioFormatMPEG4AAC_ELD: AudioFormatID = 0x61616365;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4aac_eld_sbr?language=objc)
pub const kAudioFormatMPEG4AAC_ELD_SBR: AudioFormatID = 0x61616366;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4aac_eld_v2?language=objc)
pub const kAudioFormatMPEG4AAC_ELD_V2: AudioFormatID = 0x61616367;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4aac_he_v2?language=objc)
pub const kAudioFormatMPEG4AAC_HE_V2: AudioFormatID = 0x61616370;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpeg4aac_spatial?language=objc)
pub const kAudioFormatMPEG4AAC_Spatial: AudioFormatID = 0x61616373;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmpegd_usac?language=objc)
pub const kAudioFormatMPEGD_USAC: AudioFormatID = 0x75736163;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatamr?language=objc)
pub const kAudioFormatAMR: AudioFormatID = 0x73616d72;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatamr_wb?language=objc)
pub const kAudioFormatAMR_WB: AudioFormatID = 0x73617762;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformataudible?language=objc)
pub const kAudioFormatAudible: AudioFormatID = 0x41554442;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatilbc?language=objc)
pub const kAudioFormatiLBC: AudioFormatID = 0x696c6263;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatdviintelima?language=objc)
pub const kAudioFormatDVIIntelIMA: AudioFormatID = 0x6D730011;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatmicrosoftgsm?language=objc)
pub const kAudioFormatMicrosoftGSM: AudioFormatID = 0x6D730031;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformataes3?language=objc)
pub const kAudioFormatAES3: AudioFormatID = 0x61657333;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatenhancedac3?language=objc)
pub const kAudioFormatEnhancedAC3: AudioFormatID = 0x65632d33;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflac?language=objc)
pub const kAudioFormatFLAC: AudioFormatID = 0x666c6163;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatopus?language=objc)
pub const kAudioFormatOpus: AudioFormatID = 0x6f707573;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatapac?language=objc)
pub const kAudioFormatAPAC: AudioFormatID = 0x61706163;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagisfloat?language=objc)
pub const kAudioFormatFlagIsFloat: AudioFormatFlags = 1 << 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagisbigendian?language=objc)
pub const kAudioFormatFlagIsBigEndian: AudioFormatFlags = 1 << 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagissignedinteger?language=objc)
pub const kAudioFormatFlagIsSignedInteger: AudioFormatFlags = 1 << 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagispacked?language=objc)
pub const kAudioFormatFlagIsPacked: AudioFormatFlags = 1 << 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagisalignedhigh?language=objc)
pub const kAudioFormatFlagIsAlignedHigh: AudioFormatFlags = 1 << 4;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagisnoninterleaved?language=objc)
pub const kAudioFormatFlagIsNonInterleaved: AudioFormatFlags = 1 << 5;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagisnonmixable?language=objc)
pub const kAudioFormatFlagIsNonMixable: AudioFormatFlags = 1 << 6;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagsareallclear?language=objc)
pub const kAudioFormatFlagsAreAllClear: AudioFormatFlags = 0x80000000;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagisfloat?language=objc)
pub const kLinearPCMFormatFlagIsFloat: AudioFormatFlags = kAudioFormatFlagIsFloat;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagisbigendian?language=objc)
pub const kLinearPCMFormatFlagIsBigEndian: AudioFormatFlags = kAudioFormatFlagIsBigEndian;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagissignedinteger?language=objc)
pub const kLinearPCMFormatFlagIsSignedInteger: AudioFormatFlags = kAudioFormatFlagIsSignedInteger;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagispacked?language=objc)
pub const kLinearPCMFormatFlagIsPacked: AudioFormatFlags = kAudioFormatFlagIsPacked;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagisalignedhigh?language=objc)
pub const kLinearPCMFormatFlagIsAlignedHigh: AudioFormatFlags = kAudioFormatFlagIsAlignedHigh;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagisnoninterleaved?language=objc)
pub const kLinearPCMFormatFlagIsNonInterleaved: AudioFormatFlags = kAudioFormatFlagIsNonInterleaved;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagisnonmixable?language=objc)
pub const kLinearPCMFormatFlagIsNonMixable: AudioFormatFlags = kAudioFormatFlagIsNonMixable;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagssamplefractionshift?language=objc)
pub const kLinearPCMFormatFlagsSampleFractionShift: AudioFormatFlags = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagssamplefractionmask?language=objc)
pub const kLinearPCMFormatFlagsSampleFractionMask: AudioFormatFlags =
    0x3F << kLinearPCMFormatFlagsSampleFractionShift;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/klinearpcmformatflagsareallclear?language=objc)
pub const kLinearPCMFormatFlagsAreAllClear: AudioFormatFlags = kAudioFormatFlagsAreAllClear;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kapplelosslessformatflag_16bitsourcedata?language=objc)
pub const kAppleLosslessFormatFlag_16BitSourceData: AudioFormatFlags = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kapplelosslessformatflag_20bitsourcedata?language=objc)
pub const kAppleLosslessFormatFlag_20BitSourceData: AudioFormatFlags = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kapplelosslessformatflag_24bitsourcedata?language=objc)
pub const kAppleLosslessFormatFlag_24BitSourceData: AudioFormatFlags = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kapplelosslessformatflag_32bitsourcedata?language=objc)
pub const kAppleLosslessFormatFlag_32BitSourceData: AudioFormatFlags = 4;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagsnativeendian?language=objc)
pub const kAudioFormatFlagsNativeEndian: AudioFormatFlags = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagscanonical?language=objc)
pub const kAudioFormatFlagsCanonical: AudioFormatFlags =
    kAudioFormatFlagIsFloat | kAudioFormatFlagsNativeEndian | kAudioFormatFlagIsPacked;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagsaudiounitcanonical?language=objc)
pub const kAudioFormatFlagsAudioUnitCanonical: AudioFormatFlags = kAudioFormatFlagIsFloat
    | kAudioFormatFlagsNativeEndian
    | kAudioFormatFlagIsPacked
    | kAudioFormatFlagIsNonInterleaved;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudioformatflagsnativefloatpacked?language=objc)
pub const kAudioFormatFlagsNativeFloatPacked: AudioFormatFlags =
    kAudioFormatFlagIsFloat | kAudioFormatFlagsNativeEndian | kAudioFormatFlagIsPacked;

/// This structure describes the packet layout of a buffer of data where the size of
/// each packet may not be the same or where there is extraneous data between
/// packets.
///
/// The number of bytes from the start of the buffer to the beginning of the
/// packet.
///
/// The number of sample frames of data in the packet. For formats with a
/// constant number of frames per packet, this field is set to 0.
///
/// The number of bytes in the packet.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiostreampacketdescription?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioStreamPacketDescription {
    pub mStartOffset: i64,
    pub mVariableFramesInPacket: u32,
    pub mDataByteSize: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioStreamPacketDescription {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioStreamPacketDescription",
        &[<i64>::ENCODING, <u32>::ENCODING, <u32>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioStreamPacketDescription {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Constants that describe the type of SMPTE time.
///
/// 24 Frame
///
/// 25 Frame
///
/// 30 Drop Frame
///
/// 30 Frame
///
/// 29.97 Frame
///
/// 29.97 Drop Frame
///
/// 60 Frame
///
/// 59.94 Frame
///
/// 60 Drop Frame
///
/// 59.94 Drop Frame
///
/// 50 Frame
///
/// 23.98 Frame
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/smptetimetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct SMPTETimeType(pub u32);
impl SMPTETimeType {
    #[doc(alias = "kSMPTETimeType24")]
    pub const Type24: Self = Self(0);
    #[doc(alias = "kSMPTETimeType25")]
    pub const Type25: Self = Self(1);
    #[doc(alias = "kSMPTETimeType30Drop")]
    pub const Type30Drop: Self = Self(2);
    #[doc(alias = "kSMPTETimeType30")]
    pub const Type30: Self = Self(3);
    #[doc(alias = "kSMPTETimeType2997")]
    pub const Type2997: Self = Self(4);
    #[doc(alias = "kSMPTETimeType2997Drop")]
    pub const Type2997Drop: Self = Self(5);
    #[doc(alias = "kSMPTETimeType60")]
    pub const Type60: Self = Self(6);
    #[doc(alias = "kSMPTETimeType5994")]
    pub const Type5994: Self = Self(7);
    #[doc(alias = "kSMPTETimeType60Drop")]
    pub const Type60Drop: Self = Self(8);
    #[doc(alias = "kSMPTETimeType5994Drop")]
    pub const Type5994Drop: Self = Self(9);
    #[doc(alias = "kSMPTETimeType50")]
    pub const Type50: Self = Self(10);
    #[doc(alias = "kSMPTETimeType2398")]
    pub const Type2398: Self = Self(11);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SMPTETimeType {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SMPTETimeType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Flags that describe the SMPTE time state.
///
/// The full time is valid.
///
/// Time is running.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/smptetimeflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct SMPTETimeFlags(pub u32);
bitflags::bitflags! {
    impl SMPTETimeFlags: u32 {
        #[doc(alias = "kSMPTETimeUnknown")]
        const Unknown = 0;
        #[doc(alias = "kSMPTETimeValid")]
        const Valid = 1<<0;
        #[doc(alias = "kSMPTETimeRunning")]
        const Running = 1<<1;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SMPTETimeFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SMPTETimeFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A structure for holding a SMPTE time.
///
/// The number of subframes in the full message.
///
/// The number of subframes per frame (typically 80).
///
/// The total number of messages received.
///
/// The kind of SMPTE time using the SMPTE time type constants.
///
/// A set of flags that indicate the SMPTE state.
///
/// The number of hours in the full message.
///
/// The number of minutes in the full message.
///
/// The number of seconds in the full message.
///
/// The number of frames in the full message.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/smptetime?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct SMPTETime {
    pub mSubframes: i16,
    pub mSubframeDivisor: i16,
    pub mCounter: u32,
    pub mType: SMPTETimeType,
    pub mFlags: SMPTETimeFlags,
    pub mHours: i16,
    pub mMinutes: i16,
    pub mSeconds: i16,
    pub mFrames: i16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for SMPTETime {
    const ENCODING: Encoding = Encoding::Struct(
        "SMPTETime",
        &[
            <i16>::ENCODING,
            <i16>::ENCODING,
            <u32>::ENCODING,
            <SMPTETimeType>::ENCODING,
            <SMPTETimeFlags>::ENCODING,
            <i16>::ENCODING,
            <i16>::ENCODING,
            <i16>::ENCODING,
            <i16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for SMPTETime {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The flags that indicate which fields in an AudioTimeStamp structure are valid.
///
/// The sample frame time is valid.
///
/// The host time is valid.
///
/// The rate scalar is valid.
///
/// The word clock time is valid.
///
/// The SMPTE time is valid.
///
/// The sample frame time and the host time are valid.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiotimestampflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioTimeStampFlags(pub u32);
bitflags::bitflags! {
    impl AudioTimeStampFlags: u32 {
        #[doc(alias = "kAudioTimeStampNothingValid")]
        const NothingValid = 0;
        #[doc(alias = "kAudioTimeStampSampleTimeValid")]
        const SampleTimeValid = 1<<0;
        #[doc(alias = "kAudioTimeStampHostTimeValid")]
        const HostTimeValid = 1<<1;
        #[doc(alias = "kAudioTimeStampRateScalarValid")]
        const RateScalarValid = 1<<2;
        #[doc(alias = "kAudioTimeStampWordClockTimeValid")]
        const WordClockTimeValid = 1<<3;
        #[doc(alias = "kAudioTimeStampSMPTETimeValid")]
        const SMPTETimeValid = 1<<4;
        #[doc(alias = "kAudioTimeStampSampleHostTimeValid")]
        const SampleHostTimeValid = AudioTimeStampFlags::SampleTimeValid.0|AudioTimeStampFlags::HostTimeValid.0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioTimeStampFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioTimeStampFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A structure that holds different representations of the same point in time.
///
/// The absolute sample frame time.
///
/// The host machine's time base, mach_absolute_time.
///
/// The ratio of actual host ticks per sample frame to the nominal host ticks
/// per sample frame.
///
/// The word clock time.
///
/// The SMPTE time.
///
/// A set of flags indicating which representations of the time are valid.
///
/// Pads the structure out to force an even 8 byte alignment.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiotimestamp?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioTimeStamp {
    pub mSampleTime: f64,
    pub mHostTime: u64,
    pub mRateScalar: f64,
    pub mWordClockTime: u64,
    pub mSMPTETime: SMPTETime,
    pub mFlags: AudioTimeStampFlags,
    pub mReserved: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioTimeStamp {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioTimeStamp",
        &[
            <f64>::ENCODING,
            <u64>::ENCODING,
            <f64>::ENCODING,
            <u64>::ENCODING,
            <SMPTETime>::ENCODING,
            <AudioTimeStampFlags>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioTimeStamp {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This structure is used to describe codecs installed on the system.
///
/// The four char code codec type.
///
/// The four char code codec subtype.
///
/// The four char code codec manufacturer.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audioclassdescription?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioClassDescription {
    pub mType: OSType,
    pub mSubType: OSType,
    pub mManufacturer: OSType,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioClassDescription {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioClassDescription",
        &[<OSType>::ENCODING, <OSType>::ENCODING, <OSType>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioClassDescription {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A tag identifying how the channel is to be used.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiochannellabel?language=objc)
pub type AudioChannelLabel = u32;

/// A tag identifying a particular pre-defined channel layout.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiochannellayouttag?language=objc)
pub type AudioChannelLayoutTag = u32;

/// unknown or unspecified other use
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_unknown?language=objc)
pub const kAudioChannelLabel_Unknown: AudioChannelLabel = 0xFFFFFFFF;
/// channel is present, but has no intended use or destination
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_unused?language=objc)
pub const kAudioChannelLabel_Unused: AudioChannelLabel = 0;
/// channel is described by the mCoordinates fields.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_usecoordinates?language=objc)
pub const kAudioChannelLabel_UseCoordinates: AudioChannelLabel = 100;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_left?language=objc)
pub const kAudioChannelLabel_Left: AudioChannelLabel = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_right?language=objc)
pub const kAudioChannelLabel_Right: AudioChannelLabel = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_center?language=objc)
pub const kAudioChannelLabel_Center: AudioChannelLabel = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_lfescreen?language=objc)
pub const kAudioChannelLabel_LFEScreen: AudioChannelLabel = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_leftsurround?language=objc)
pub const kAudioChannelLabel_LeftSurround: AudioChannelLabel = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rightsurround?language=objc)
pub const kAudioChannelLabel_RightSurround: AudioChannelLabel = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_leftcenter?language=objc)
pub const kAudioChannelLabel_LeftCenter: AudioChannelLabel = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rightcenter?language=objc)
pub const kAudioChannelLabel_RightCenter: AudioChannelLabel = 8;
/// WAVE: "Back Center" or plain "Rear Surround"
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_centersurround?language=objc)
pub const kAudioChannelLabel_CenterSurround: AudioChannelLabel = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_leftsurrounddirect?language=objc)
pub const kAudioChannelLabel_LeftSurroundDirect: AudioChannelLabel = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rightsurrounddirect?language=objc)
pub const kAudioChannelLabel_RightSurroundDirect: AudioChannelLabel = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_topcentersurround?language=objc)
pub const kAudioChannelLabel_TopCenterSurround: AudioChannelLabel = 12;
/// WAVE: "Top Front Left"
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_verticalheightleft?language=objc)
pub const kAudioChannelLabel_VerticalHeightLeft: AudioChannelLabel = 13;
/// WAVE: "Top Front Center"
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_verticalheightcenter?language=objc)
pub const kAudioChannelLabel_VerticalHeightCenter: AudioChannelLabel = 14;
/// WAVE: "Top Front Right"
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_verticalheightright?language=objc)
pub const kAudioChannelLabel_VerticalHeightRight: AudioChannelLabel = 15;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_topbackleft?language=objc)
pub const kAudioChannelLabel_TopBackLeft: AudioChannelLabel = 16;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_topbackcenter?language=objc)
pub const kAudioChannelLabel_TopBackCenter: AudioChannelLabel = 17;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_topbackright?language=objc)
pub const kAudioChannelLabel_TopBackRight: AudioChannelLabel = 18;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rearsurroundleft?language=objc)
pub const kAudioChannelLabel_RearSurroundLeft: AudioChannelLabel = 33;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rearsurroundright?language=objc)
pub const kAudioChannelLabel_RearSurroundRight: AudioChannelLabel = 34;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_leftwide?language=objc)
pub const kAudioChannelLabel_LeftWide: AudioChannelLabel = 35;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rightwide?language=objc)
pub const kAudioChannelLabel_RightWide: AudioChannelLabel = 36;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_lfe2?language=objc)
pub const kAudioChannelLabel_LFE2: AudioChannelLabel = 37;
/// matrix encoded 4 channels
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_lefttotal?language=objc)
pub const kAudioChannelLabel_LeftTotal: AudioChannelLabel = 38;
/// matrix encoded 4 channels
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_righttotal?language=objc)
pub const kAudioChannelLabel_RightTotal: AudioChannelLabel = 39;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hearingimpaired?language=objc)
pub const kAudioChannelLabel_HearingImpaired: AudioChannelLabel = 40;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_narration?language=objc)
pub const kAudioChannelLabel_Narration: AudioChannelLabel = 41;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_mono?language=objc)
pub const kAudioChannelLabel_Mono: AudioChannelLabel = 42;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_dialogcentricmix?language=objc)
pub const kAudioChannelLabel_DialogCentricMix: AudioChannelLabel = 43;
/// back center, non diffuse
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_centersurrounddirect?language=objc)
pub const kAudioChannelLabel_CenterSurroundDirect: AudioChannelLabel = 44;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_haptic?language=objc)
pub const kAudioChannelLabel_Haptic: AudioChannelLabel = 45;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_lefttopfront?language=objc)
pub const kAudioChannelLabel_LeftTopFront: AudioChannelLabel =
    kAudioChannelLabel_VerticalHeightLeft;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_centertopfront?language=objc)
pub const kAudioChannelLabel_CenterTopFront: AudioChannelLabel =
    kAudioChannelLabel_VerticalHeightCenter;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_righttopfront?language=objc)
pub const kAudioChannelLabel_RightTopFront: AudioChannelLabel =
    kAudioChannelLabel_VerticalHeightRight;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_lefttopmiddle?language=objc)
pub const kAudioChannelLabel_LeftTopMiddle: AudioChannelLabel = 49;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_centertopmiddle?language=objc)
pub const kAudioChannelLabel_CenterTopMiddle: AudioChannelLabel =
    kAudioChannelLabel_TopCenterSurround;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_righttopmiddle?language=objc)
pub const kAudioChannelLabel_RightTopMiddle: AudioChannelLabel = 51;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_lefttoprear?language=objc)
pub const kAudioChannelLabel_LeftTopRear: AudioChannelLabel = 52;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_centertoprear?language=objc)
pub const kAudioChannelLabel_CenterTopRear: AudioChannelLabel = 53;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_righttoprear?language=objc)
pub const kAudioChannelLabel_RightTopRear: AudioChannelLabel = 54;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_leftsidesurround?language=objc)
pub const kAudioChannelLabel_LeftSideSurround: AudioChannelLabel = 55;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rightsidesurround?language=objc)
pub const kAudioChannelLabel_RightSideSurround: AudioChannelLabel = 56;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_leftbottom?language=objc)
pub const kAudioChannelLabel_LeftBottom: AudioChannelLabel = 57;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rightbottom?language=objc)
pub const kAudioChannelLabel_RightBottom: AudioChannelLabel = 58;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_centerbottom?language=objc)
pub const kAudioChannelLabel_CenterBottom: AudioChannelLabel = 59;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_lefttopsurround?language=objc)
pub const kAudioChannelLabel_LeftTopSurround: AudioChannelLabel = 60;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_righttopsurround?language=objc)
pub const kAudioChannelLabel_RightTopSurround: AudioChannelLabel = 61;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_lfe3?language=objc)
pub const kAudioChannelLabel_LFE3: AudioChannelLabel = 62;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_leftbacksurround?language=objc)
pub const kAudioChannelLabel_LeftBackSurround: AudioChannelLabel = 63;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rightbacksurround?language=objc)
pub const kAudioChannelLabel_RightBackSurround: AudioChannelLabel = 64;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_leftedgeofscreen?language=objc)
pub const kAudioChannelLabel_LeftEdgeOfScreen: AudioChannelLabel = 65;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_rightedgeofscreen?language=objc)
pub const kAudioChannelLabel_RightEdgeOfScreen: AudioChannelLabel = 66;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_ambisonic_w?language=objc)
pub const kAudioChannelLabel_Ambisonic_W: AudioChannelLabel = 200;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_ambisonic_x?language=objc)
pub const kAudioChannelLabel_Ambisonic_X: AudioChannelLabel = 201;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_ambisonic_y?language=objc)
pub const kAudioChannelLabel_Ambisonic_Y: AudioChannelLabel = 202;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_ambisonic_z?language=objc)
pub const kAudioChannelLabel_Ambisonic_Z: AudioChannelLabel = 203;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_ms_mid?language=objc)
pub const kAudioChannelLabel_MS_Mid: AudioChannelLabel = 204;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_ms_side?language=objc)
pub const kAudioChannelLabel_MS_Side: AudioChannelLabel = 205;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_xy_x?language=objc)
pub const kAudioChannelLabel_XY_X: AudioChannelLabel = 206;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_xy_y?language=objc)
pub const kAudioChannelLabel_XY_Y: AudioChannelLabel = 207;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_binauralleft?language=objc)
pub const kAudioChannelLabel_BinauralLeft: AudioChannelLabel = 208;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_binauralright?language=objc)
pub const kAudioChannelLabel_BinauralRight: AudioChannelLabel = 209;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_headphonesleft?language=objc)
pub const kAudioChannelLabel_HeadphonesLeft: AudioChannelLabel = 301;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_headphonesright?language=objc)
pub const kAudioChannelLabel_HeadphonesRight: AudioChannelLabel = 302;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_clicktrack?language=objc)
pub const kAudioChannelLabel_ClickTrack: AudioChannelLabel = 304;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_foreignlanguage?language=objc)
pub const kAudioChannelLabel_ForeignLanguage: AudioChannelLabel = 305;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete?language=objc)
pub const kAudioChannelLabel_Discrete: AudioChannelLabel = 400;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_0?language=objc)
pub const kAudioChannelLabel_Discrete_0: AudioChannelLabel = (1 << 16) | 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_1?language=objc)
pub const kAudioChannelLabel_Discrete_1: AudioChannelLabel = (1 << 16) | 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_2?language=objc)
pub const kAudioChannelLabel_Discrete_2: AudioChannelLabel = (1 << 16) | 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_3?language=objc)
pub const kAudioChannelLabel_Discrete_3: AudioChannelLabel = (1 << 16) | 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_4?language=objc)
pub const kAudioChannelLabel_Discrete_4: AudioChannelLabel = (1 << 16) | 4;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_5?language=objc)
pub const kAudioChannelLabel_Discrete_5: AudioChannelLabel = (1 << 16) | 5;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_6?language=objc)
pub const kAudioChannelLabel_Discrete_6: AudioChannelLabel = (1 << 16) | 6;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_7?language=objc)
pub const kAudioChannelLabel_Discrete_7: AudioChannelLabel = (1 << 16) | 7;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_8?language=objc)
pub const kAudioChannelLabel_Discrete_8: AudioChannelLabel = (1 << 16) | 8;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_9?language=objc)
pub const kAudioChannelLabel_Discrete_9: AudioChannelLabel = (1 << 16) | 9;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_10?language=objc)
pub const kAudioChannelLabel_Discrete_10: AudioChannelLabel = (1 << 16) | 10;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_11?language=objc)
pub const kAudioChannelLabel_Discrete_11: AudioChannelLabel = (1 << 16) | 11;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_12?language=objc)
pub const kAudioChannelLabel_Discrete_12: AudioChannelLabel = (1 << 16) | 12;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_13?language=objc)
pub const kAudioChannelLabel_Discrete_13: AudioChannelLabel = (1 << 16) | 13;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_14?language=objc)
pub const kAudioChannelLabel_Discrete_14: AudioChannelLabel = (1 << 16) | 14;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_15?language=objc)
pub const kAudioChannelLabel_Discrete_15: AudioChannelLabel = (1 << 16) | 15;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_discrete_65535?language=objc)
pub const kAudioChannelLabel_Discrete_65535: AudioChannelLabel = (1 << 16) | 65535;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn?language=objc)
pub const kAudioChannelLabel_HOA_ACN: AudioChannelLabel = 500;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_0?language=objc)
pub const kAudioChannelLabel_HOA_ACN_0: AudioChannelLabel = (2 << 16) | 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_1?language=objc)
pub const kAudioChannelLabel_HOA_ACN_1: AudioChannelLabel = (2 << 16) | 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_2?language=objc)
pub const kAudioChannelLabel_HOA_ACN_2: AudioChannelLabel = (2 << 16) | 2;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_3?language=objc)
pub const kAudioChannelLabel_HOA_ACN_3: AudioChannelLabel = (2 << 16) | 3;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_4?language=objc)
pub const kAudioChannelLabel_HOA_ACN_4: AudioChannelLabel = (2 << 16) | 4;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_5?language=objc)
pub const kAudioChannelLabel_HOA_ACN_5: AudioChannelLabel = (2 << 16) | 5;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_6?language=objc)
pub const kAudioChannelLabel_HOA_ACN_6: AudioChannelLabel = (2 << 16) | 6;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_7?language=objc)
pub const kAudioChannelLabel_HOA_ACN_7: AudioChannelLabel = (2 << 16) | 7;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_8?language=objc)
pub const kAudioChannelLabel_HOA_ACN_8: AudioChannelLabel = (2 << 16) | 8;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_9?language=objc)
pub const kAudioChannelLabel_HOA_ACN_9: AudioChannelLabel = (2 << 16) | 9;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_10?language=objc)
pub const kAudioChannelLabel_HOA_ACN_10: AudioChannelLabel = (2 << 16) | 10;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_11?language=objc)
pub const kAudioChannelLabel_HOA_ACN_11: AudioChannelLabel = (2 << 16) | 11;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_12?language=objc)
pub const kAudioChannelLabel_HOA_ACN_12: AudioChannelLabel = (2 << 16) | 12;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_13?language=objc)
pub const kAudioChannelLabel_HOA_ACN_13: AudioChannelLabel = (2 << 16) | 13;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_14?language=objc)
pub const kAudioChannelLabel_HOA_ACN_14: AudioChannelLabel = (2 << 16) | 14;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_15?language=objc)
pub const kAudioChannelLabel_HOA_ACN_15: AudioChannelLabel = (2 << 16) | 15;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_acn_65024?language=objc)
pub const kAudioChannelLabel_HOA_ACN_65024: AudioChannelLabel = (2 << 16) | 65024;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_sn3d?language=objc)
pub const kAudioChannelLabel_HOA_SN3D: AudioChannelLabel = kAudioChannelLabel_HOA_ACN_0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_hoa_n3d?language=objc)
pub const kAudioChannelLabel_HOA_N3D: AudioChannelLabel = 3 << 16;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_object?language=objc)
pub const kAudioChannelLabel_Object: AudioChannelLabel = 4 << 16;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_beginreserved?language=objc)
pub const kAudioChannelLabel_BeginReserved: AudioChannelLabel = 0xF0000000;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellabel_endreserved?language=objc)
pub const kAudioChannelLabel_EndReserved: AudioChannelLabel = 0xFFFFFFFE;

/// These constants are for use in the mChannelBitmap field of an
/// AudioChannelLayout structure.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiochannelbitmap?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioChannelBitmap(pub u32);
bitflags::bitflags! {
    impl AudioChannelBitmap: u32 {
        #[doc(alias = "kAudioChannelBit_Left")]
        const Bit_Left = 1<<0;
        #[doc(alias = "kAudioChannelBit_Right")]
        const Bit_Right = 1<<1;
        #[doc(alias = "kAudioChannelBit_Center")]
        const Bit_Center = 1<<2;
        #[doc(alias = "kAudioChannelBit_LFEScreen")]
        const Bit_LFEScreen = 1<<3;
        #[doc(alias = "kAudioChannelBit_LeftSurround")]
        const Bit_LeftSurround = 1<<4;
        #[doc(alias = "kAudioChannelBit_RightSurround")]
        const Bit_RightSurround = 1<<5;
        #[doc(alias = "kAudioChannelBit_LeftCenter")]
        const Bit_LeftCenter = 1<<6;
        #[doc(alias = "kAudioChannelBit_RightCenter")]
        const Bit_RightCenter = 1<<7;
        #[doc(alias = "kAudioChannelBit_CenterSurround")]
        const Bit_CenterSurround = 1<<8;
        #[doc(alias = "kAudioChannelBit_LeftSurroundDirect")]
        const Bit_LeftSurroundDirect = 1<<9;
        #[doc(alias = "kAudioChannelBit_RightSurroundDirect")]
        const Bit_RightSurroundDirect = 1<<10;
        #[doc(alias = "kAudioChannelBit_TopCenterSurround")]
        const Bit_TopCenterSurround = 1<<11;
        #[doc(alias = "kAudioChannelBit_VerticalHeightLeft")]
        const Bit_VerticalHeightLeft = 1<<12;
        #[doc(alias = "kAudioChannelBit_VerticalHeightCenter")]
        const Bit_VerticalHeightCenter = 1<<13;
        #[doc(alias = "kAudioChannelBit_VerticalHeightRight")]
        const Bit_VerticalHeightRight = 1<<14;
        #[doc(alias = "kAudioChannelBit_TopBackLeft")]
        const Bit_TopBackLeft = 1<<15;
        #[doc(alias = "kAudioChannelBit_TopBackCenter")]
        const Bit_TopBackCenter = 1<<16;
        #[doc(alias = "kAudioChannelBit_TopBackRight")]
        const Bit_TopBackRight = 1<<17;
        #[doc(alias = "kAudioChannelBit_LeftTopFront")]
        const Bit_LeftTopFront = AudioChannelBitmap::Bit_VerticalHeightLeft.0;
        #[doc(alias = "kAudioChannelBit_CenterTopFront")]
        const Bit_CenterTopFront = AudioChannelBitmap::Bit_VerticalHeightCenter.0;
        #[doc(alias = "kAudioChannelBit_RightTopFront")]
        const Bit_RightTopFront = AudioChannelBitmap::Bit_VerticalHeightRight.0;
        #[doc(alias = "kAudioChannelBit_LeftTopMiddle")]
        const Bit_LeftTopMiddle = 1<<21;
        #[doc(alias = "kAudioChannelBit_CenterTopMiddle")]
        const Bit_CenterTopMiddle = AudioChannelBitmap::Bit_TopCenterSurround.0;
        #[doc(alias = "kAudioChannelBit_RightTopMiddle")]
        const Bit_RightTopMiddle = 1<<23;
        #[doc(alias = "kAudioChannelBit_LeftTopRear")]
        const Bit_LeftTopRear = 1<<24;
        #[doc(alias = "kAudioChannelBit_CenterTopRear")]
        const Bit_CenterTopRear = 1<<25;
        #[doc(alias = "kAudioChannelBit_RightTopRear")]
        const Bit_RightTopRear = 1<<26;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioChannelBitmap {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioChannelBitmap {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// These constants are used in the mChannelFlags field of an
/// AudioChannelDescription structure.
///
/// The channel is specified by the cartesian coordinates of the speaker
/// position. This flag is mutally exclusive with
/// kAudioChannelFlags_SphericalCoordinates.
///
/// The channel is specified by the spherical coordinates of the speaker
/// position. This flag is mutally exclusive with
/// kAudioChannelFlags_RectangularCoordinates.
///
/// Set to indicate the units are in meters, clear to indicate the units are
/// relative to the unit cube or unit sphere.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiochannelflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioChannelFlags(pub u32);
bitflags::bitflags! {
    impl AudioChannelFlags: u32 {
        #[doc(alias = "kAudioChannelFlags_AllOff")]
        const AllOff = 0;
        #[doc(alias = "kAudioChannelFlags_RectangularCoordinates")]
        const RectangularCoordinates = 1<<0;
        #[doc(alias = "kAudioChannelFlags_SphericalCoordinates")]
        const SphericalCoordinates = 1<<1;
        #[doc(alias = "kAudioChannelFlags_Meters")]
        const Meters = 1<<2;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioChannelFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioChannelFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Constants for indexing the mCoordinates array in an AudioChannelDescription
/// structure.
///
/// For rectangular coordinates, negative is left and positive is right.
///
/// For rectangular coordinates, negative is back and positive is front.
///
/// For rectangular coordinates, negative is below ground level, 0 is ground
/// level, and positive is above ground level.
///
/// For spherical coordinates, 0 is front center, positive is right, negative is
/// left. This is measured in degrees.
///
/// For spherical coordinates, +90 is zenith, 0 is horizontal, -90 is nadir.
/// This is measured in degrees.
///
/// For spherical coordinates, the units are described by flags.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiochannelcoordinateindex?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioChannelCoordinateIndex(pub u32);
impl AudioChannelCoordinateIndex {
    #[doc(alias = "kAudioChannelCoordinates_LeftRight")]
    pub const Coordinates_LeftRight: Self = Self(0);
    #[doc(alias = "kAudioChannelCoordinates_BackFront")]
    pub const Coordinates_BackFront: Self = Self(1);
    #[doc(alias = "kAudioChannelCoordinates_DownUp")]
    pub const Coordinates_DownUp: Self = Self(2);
    #[doc(alias = "kAudioChannelCoordinates_Azimuth")]
    pub const Coordinates_Azimuth: Self = Self(0);
    #[doc(alias = "kAudioChannelCoordinates_Elevation")]
    pub const Coordinates_Elevation: Self = Self(1);
    #[doc(alias = "kAudioChannelCoordinates_Distance")]
    pub const Coordinates_Distance: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioChannelCoordinateIndex {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioChannelCoordinateIndex {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// use the array of AudioChannelDescriptions to define the mapping.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_usechanneldescriptions?language=objc)
pub const kAudioChannelLayoutTag_UseChannelDescriptions: AudioChannelLayoutTag = (0 << 16) | 0;
/// use the bitmap to define the mapping.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_usechannelbitmap?language=objc)
pub const kAudioChannelLayoutTag_UseChannelBitmap: AudioChannelLayoutTag = (1 << 16) | 0;
/// a standard mono stream
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mono?language=objc)
pub const kAudioChannelLayoutTag_Mono: AudioChannelLayoutTag = (100 << 16) | 1;
/// a standard stereo stream (L R) - implied playback
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_stereo?language=objc)
pub const kAudioChannelLayoutTag_Stereo: AudioChannelLayoutTag = (101 << 16) | 2;
/// a standard stereo stream (L R) - implied headphone playback
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_stereoheadphones?language=objc)
pub const kAudioChannelLayoutTag_StereoHeadphones: AudioChannelLayoutTag = (102 << 16) | 2;
/// a matrix encoded stereo stream (Lt, Rt)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_matrixstereo?language=objc)
pub const kAudioChannelLayoutTag_MatrixStereo: AudioChannelLayoutTag = (103 << 16) | 2;
/// mid/side recording
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_midside?language=objc)
pub const kAudioChannelLayoutTag_MidSide: AudioChannelLayoutTag = (104 << 16) | 2;
/// coincident mic pair (often 2 figure 8's)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_xy?language=objc)
pub const kAudioChannelLayoutTag_XY: AudioChannelLayoutTag = (105 << 16) | 2;
/// binaural stereo (left, right)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_binaural?language=objc)
pub const kAudioChannelLayoutTag_Binaural: AudioChannelLayoutTag = (106 << 16) | 2;
/// W, X, Y, Z
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ambisonic_b_format?language=objc)
pub const kAudioChannelLayoutTag_Ambisonic_B_Format: AudioChannelLayoutTag = (107 << 16) | 4;
/// L R Ls Rs  -- 90 degree speaker separation
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_quadraphonic?language=objc)
pub const kAudioChannelLayoutTag_Quadraphonic: AudioChannelLayoutTag = (108 << 16) | 4;
/// L R Ls Rs C  -- 72 degree speaker separation
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_pentagonal?language=objc)
pub const kAudioChannelLayoutTag_Pentagonal: AudioChannelLayoutTag = (109 << 16) | 5;
/// L R Ls Rs C Cs  -- 60 degree speaker separation
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_hexagonal?language=objc)
pub const kAudioChannelLayoutTag_Hexagonal: AudioChannelLayoutTag = (110 << 16) | 6;
/// L R Ls Rs C Cs Lw Rw  -- 45 degree speaker separation
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_octagonal?language=objc)
pub const kAudioChannelLayoutTag_Octagonal: AudioChannelLayoutTag = (111 << 16) | 8;
/// left, right, rear left, rear right
/// top left, top right, top rear left, top rear right
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cube?language=objc)
pub const kAudioChannelLayoutTag_Cube: AudioChannelLayoutTag = (112 << 16) | 8;
/// C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_1_0?language=objc)
pub const kAudioChannelLayoutTag_MPEG_1_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_Mono;
/// L R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_2_0?language=objc)
pub const kAudioChannelLayoutTag_MPEG_2_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_Stereo;
/// L R C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_3_0_a?language=objc)
pub const kAudioChannelLayoutTag_MPEG_3_0_A: AudioChannelLayoutTag = (113 << 16) | 3;
/// C L R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_3_0_b?language=objc)
pub const kAudioChannelLayoutTag_MPEG_3_0_B: AudioChannelLayoutTag = (114 << 16) | 3;
/// L R C Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_4_0_a?language=objc)
pub const kAudioChannelLayoutTag_MPEG_4_0_A: AudioChannelLayoutTag = (115 << 16) | 4;
/// C L R Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_4_0_b?language=objc)
pub const kAudioChannelLayoutTag_MPEG_4_0_B: AudioChannelLayoutTag = (116 << 16) | 4;
/// L R C Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_0_a?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_0_A: AudioChannelLayoutTag = (117 << 16) | 5;
/// L R Ls Rs C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_0_b?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_0_B: AudioChannelLayoutTag = (118 << 16) | 5;
/// L C R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_0_c?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_0_C: AudioChannelLayoutTag = (119 << 16) | 5;
/// C L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_0_d?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_0_D: AudioChannelLayoutTag = (120 << 16) | 5;
/// L R C LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_1_a?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_1_A: AudioChannelLayoutTag = (121 << 16) | 6;
/// L R Ls Rs C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_1_b?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_1_B: AudioChannelLayoutTag = (122 << 16) | 6;
/// L C R Ls Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_1_c?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_1_C: AudioChannelLayoutTag = (123 << 16) | 6;
/// C L R Ls Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_1_d?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_1_D: AudioChannelLayoutTag = (124 << 16) | 6;
/// L R C LFE Ls Rs Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_6_1_a?language=objc)
pub const kAudioChannelLayoutTag_MPEG_6_1_A: AudioChannelLayoutTag = (125 << 16) | 7;
/// L R C LFE Ls Rs Lc Rc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_7_1_a?language=objc)
pub const kAudioChannelLayoutTag_MPEG_7_1_A: AudioChannelLayoutTag = (126 << 16) | 8;
/// C Lc Rc L R Ls Rs LFE    (doc: IS-13818-7 MPEG2-AAC Table 3.1)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_7_1_b?language=objc)
pub const kAudioChannelLayoutTag_MPEG_7_1_B: AudioChannelLayoutTag = (127 << 16) | 8;
/// L R C LFE Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_7_1_c?language=objc)
pub const kAudioChannelLayoutTag_MPEG_7_1_C: AudioChannelLayoutTag = (128 << 16) | 8;
/// L R Ls Rs C LFE Lc Rc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_emagic_default_7_1?language=objc)
pub const kAudioChannelLayoutTag_Emagic_Default_7_1: AudioChannelLayoutTag = (129 << 16) | 8;
/// L R C LFE Ls Rs Lt Rt
/// (kAudioChannelLayoutTag_ITU_5_1 plus a matrix encoded stereo mix)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_smpte_dtv?language=objc)
pub const kAudioChannelLayoutTag_SMPTE_DTV: AudioChannelLayoutTag = (130 << 16) | 8;
/// C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_1_0?language=objc)
pub const kAudioChannelLayoutTag_ITU_1_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_Mono;
/// L R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_2_0?language=objc)
pub const kAudioChannelLayoutTag_ITU_2_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_Stereo;
/// L R Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_2_1?language=objc)
pub const kAudioChannelLayoutTag_ITU_2_1: AudioChannelLayoutTag = (131 << 16) | 3;
/// L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_2_2?language=objc)
pub const kAudioChannelLayoutTag_ITU_2_2: AudioChannelLayoutTag = (132 << 16) | 4;
/// L R C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_3_0?language=objc)
pub const kAudioChannelLayoutTag_ITU_3_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_3_0_A;
/// L R C Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_3_1?language=objc)
pub const kAudioChannelLayoutTag_ITU_3_1: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_4_0_A;
/// L R C Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_3_2?language=objc)
pub const kAudioChannelLayoutTag_ITU_3_2: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_0_A;
/// L R C LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_3_2_1?language=objc)
pub const kAudioChannelLayoutTag_ITU_3_2_1: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_1_A;
/// L R C LFE Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_itu_3_4_1?language=objc)
pub const kAudioChannelLayoutTag_ITU_3_4_1: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_7_1_C;
/// C (mono)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_0?language=objc)
pub const kAudioChannelLayoutTag_DVD_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_Mono;
/// L R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_1?language=objc)
pub const kAudioChannelLayoutTag_DVD_1: AudioChannelLayoutTag = kAudioChannelLayoutTag_Stereo;
/// L R Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_2?language=objc)
pub const kAudioChannelLayoutTag_DVD_2: AudioChannelLayoutTag = kAudioChannelLayoutTag_ITU_2_1;
/// L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_3?language=objc)
pub const kAudioChannelLayoutTag_DVD_3: AudioChannelLayoutTag = kAudioChannelLayoutTag_ITU_2_2;
/// L R LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_4?language=objc)
pub const kAudioChannelLayoutTag_DVD_4: AudioChannelLayoutTag = (133 << 16) | 3;
/// L R LFE Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_5?language=objc)
pub const kAudioChannelLayoutTag_DVD_5: AudioChannelLayoutTag = (134 << 16) | 4;
/// L R LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_6?language=objc)
pub const kAudioChannelLayoutTag_DVD_6: AudioChannelLayoutTag = (135 << 16) | 5;
/// L R C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_7?language=objc)
pub const kAudioChannelLayoutTag_DVD_7: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_3_0_A;
/// L R C Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_8?language=objc)
pub const kAudioChannelLayoutTag_DVD_8: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_4_0_A;
/// L R C Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_9?language=objc)
pub const kAudioChannelLayoutTag_DVD_9: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_0_A;
/// L R C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_10?language=objc)
pub const kAudioChannelLayoutTag_DVD_10: AudioChannelLayoutTag = (136 << 16) | 4;
/// L R C LFE Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_11?language=objc)
pub const kAudioChannelLayoutTag_DVD_11: AudioChannelLayoutTag = (137 << 16) | 5;
/// L R C LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_12?language=objc)
pub const kAudioChannelLayoutTag_DVD_12: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_1_A;
/// L R C Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_13?language=objc)
pub const kAudioChannelLayoutTag_DVD_13: AudioChannelLayoutTag = kAudioChannelLayoutTag_DVD_8;
/// L R C Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_14?language=objc)
pub const kAudioChannelLayoutTag_DVD_14: AudioChannelLayoutTag = kAudioChannelLayoutTag_DVD_9;
/// L R C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_15?language=objc)
pub const kAudioChannelLayoutTag_DVD_15: AudioChannelLayoutTag = kAudioChannelLayoutTag_DVD_10;
/// L R C LFE Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_16?language=objc)
pub const kAudioChannelLayoutTag_DVD_16: AudioChannelLayoutTag = kAudioChannelLayoutTag_DVD_11;
/// L R C LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_17?language=objc)
pub const kAudioChannelLayoutTag_DVD_17: AudioChannelLayoutTag = kAudioChannelLayoutTag_DVD_12;
/// L R Ls Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_18?language=objc)
pub const kAudioChannelLayoutTag_DVD_18: AudioChannelLayoutTag = (138 << 16) | 5;
/// L R Ls Rs C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_19?language=objc)
pub const kAudioChannelLayoutTag_DVD_19: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_0_B;
/// L R Ls Rs C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dvd_20?language=objc)
pub const kAudioChannelLayoutTag_DVD_20: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_1_B;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_4?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_4: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Quadraphonic;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_5?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_5: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Pentagonal;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_6?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_6: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Hexagonal;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_8?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_8: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Octagonal;
/// L R Ls Rs C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_5_0?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_5_0: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_0_B;
/// L R Ls Rs C Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_6_0?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_6_0: AudioChannelLayoutTag = (139 << 16) | 6;
/// L R Ls Rs C Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_7_0?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_7_0: AudioChannelLayoutTag = (140 << 16) | 7;
/// L R Ls Rs C Lc Rc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_7_0_front?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_7_0_Front: AudioChannelLayoutTag = (148 << 16) | 7;
/// L R C LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_5_1?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_5_1: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_1_A;
/// L R C LFE Ls Rs Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_6_1?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_6_1: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_6_1_A;
/// L R C LFE Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_7_1?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_7_1: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_7_1_C;
/// L R C LFE Ls Rs Lc Rc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_audiounit_7_1_front?language=objc)
pub const kAudioChannelLayoutTag_AudioUnit_7_1_Front: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_7_1_A;
/// C L R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_3_0?language=objc)
pub const kAudioChannelLayoutTag_AAC_3_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_3_0_B;
/// L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_quadraphonic?language=objc)
pub const kAudioChannelLayoutTag_AAC_Quadraphonic: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Quadraphonic;
/// C L R Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_4_0?language=objc)
pub const kAudioChannelLayoutTag_AAC_4_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_4_0_B;
/// C L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_5_0?language=objc)
pub const kAudioChannelLayoutTag_AAC_5_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_0_D;
/// C L R Ls Rs Lfe
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_5_1?language=objc)
pub const kAudioChannelLayoutTag_AAC_5_1: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_1_D;
/// C L R Ls Rs Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_6_0?language=objc)
pub const kAudioChannelLayoutTag_AAC_6_0: AudioChannelLayoutTag = (141 << 16) | 6;
/// C L R Ls Rs Cs Lfe
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_6_1?language=objc)
pub const kAudioChannelLayoutTag_AAC_6_1: AudioChannelLayoutTag = (142 << 16) | 7;
/// C L R Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_7_0?language=objc)
pub const kAudioChannelLayoutTag_AAC_7_0: AudioChannelLayoutTag = (143 << 16) | 7;
/// C Lc Rc L R Ls Rs Lfe
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_7_1?language=objc)
pub const kAudioChannelLayoutTag_AAC_7_1: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_7_1_B;
/// C L R Ls Rs Rls Rrs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_7_1_b?language=objc)
pub const kAudioChannelLayoutTag_AAC_7_1_B: AudioChannelLayoutTag = (183 << 16) | 8;
/// C L R Ls Rs LFE Vhl Vhr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_7_1_c?language=objc)
pub const kAudioChannelLayoutTag_AAC_7_1_C: AudioChannelLayoutTag = (184 << 16) | 8;
/// C L R Ls Rs Rls Rrs Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_aac_octagonal?language=objc)
pub const kAudioChannelLayoutTag_AAC_Octagonal: AudioChannelLayoutTag = (144 << 16) | 8;
/// L R C Vhc Lsd Rsd Ls Rs Vhl Vhr Lw Rw Csd Cs LFE1 LFE2
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_tmh_10_2_std?language=objc)
pub const kAudioChannelLayoutTag_TMH_10_2_std: AudioChannelLayoutTag = (145 << 16) | 16;
/// TMH_10_2_std plus: Lc Rc HI VI Haptic
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_tmh_10_2_full?language=objc)
pub const kAudioChannelLayoutTag_TMH_10_2_full: AudioChannelLayoutTag = (146 << 16) | 21;
/// C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ac3_1_0_1?language=objc)
pub const kAudioChannelLayoutTag_AC3_1_0_1: AudioChannelLayoutTag = (149 << 16) | 2;
/// L C R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ac3_3_0?language=objc)
pub const kAudioChannelLayoutTag_AC3_3_0: AudioChannelLayoutTag = (150 << 16) | 3;
/// L C R Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ac3_3_1?language=objc)
pub const kAudioChannelLayoutTag_AC3_3_1: AudioChannelLayoutTag = (151 << 16) | 4;
/// L C R LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ac3_3_0_1?language=objc)
pub const kAudioChannelLayoutTag_AC3_3_0_1: AudioChannelLayoutTag = (152 << 16) | 4;
/// L R Cs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ac3_2_1_1?language=objc)
pub const kAudioChannelLayoutTag_AC3_2_1_1: AudioChannelLayoutTag = (153 << 16) | 4;
/// L C R Cs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ac3_3_1_1?language=objc)
pub const kAudioChannelLayoutTag_AC3_3_1_1: AudioChannelLayoutTag = (154 << 16) | 5;
/// L C R Ls Rs Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac_6_0_a?language=objc)
pub const kAudioChannelLayoutTag_EAC_6_0_A: AudioChannelLayoutTag = (155 << 16) | 6;
/// L C R Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac_7_0_a?language=objc)
pub const kAudioChannelLayoutTag_EAC_7_0_A: AudioChannelLayoutTag = (156 << 16) | 7;
/// L C R Ls Rs LFE Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_6_1_a?language=objc)
pub const kAudioChannelLayoutTag_EAC3_6_1_A: AudioChannelLayoutTag = (157 << 16) | 7;
/// L C R Ls Rs LFE Ts
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_6_1_b?language=objc)
pub const kAudioChannelLayoutTag_EAC3_6_1_B: AudioChannelLayoutTag = (158 << 16) | 7;
/// L C R Ls Rs LFE Vhc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_6_1_c?language=objc)
pub const kAudioChannelLayoutTag_EAC3_6_1_C: AudioChannelLayoutTag = (159 << 16) | 7;
/// L C R Ls Rs LFE Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_7_1_a?language=objc)
pub const kAudioChannelLayoutTag_EAC3_7_1_A: AudioChannelLayoutTag = (160 << 16) | 8;
/// L C R Ls Rs LFE Lc Rc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_7_1_b?language=objc)
pub const kAudioChannelLayoutTag_EAC3_7_1_B: AudioChannelLayoutTag = (161 << 16) | 8;
/// L C R Ls Rs LFE Lsd Rsd
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_7_1_c?language=objc)
pub const kAudioChannelLayoutTag_EAC3_7_1_C: AudioChannelLayoutTag = (162 << 16) | 8;
/// L C R Ls Rs LFE Lw Rw
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_7_1_d?language=objc)
pub const kAudioChannelLayoutTag_EAC3_7_1_D: AudioChannelLayoutTag = (163 << 16) | 8;
/// L C R Ls Rs LFE Vhl Vhr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_7_1_e?language=objc)
pub const kAudioChannelLayoutTag_EAC3_7_1_E: AudioChannelLayoutTag = (164 << 16) | 8;
/// L C R Ls Rs LFE Cs Ts
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_7_1_f?language=objc)
pub const kAudioChannelLayoutTag_EAC3_7_1_F: AudioChannelLayoutTag = (165 << 16) | 8;
/// L C R Ls Rs LFE Cs Vhc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_7_1_g?language=objc)
pub const kAudioChannelLayoutTag_EAC3_7_1_G: AudioChannelLayoutTag = (166 << 16) | 8;
/// L C R Ls Rs LFE Ts Vhc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_eac3_7_1_h?language=objc)
pub const kAudioChannelLayoutTag_EAC3_7_1_H: AudioChannelLayoutTag = (167 << 16) | 8;
/// C L R LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_3_1?language=objc)
pub const kAudioChannelLayoutTag_DTS_3_1: AudioChannelLayoutTag = (168 << 16) | 4;
/// C L R Cs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_4_1?language=objc)
pub const kAudioChannelLayoutTag_DTS_4_1: AudioChannelLayoutTag = (169 << 16) | 5;
/// Lc Rc L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_6_0_a?language=objc)
pub const kAudioChannelLayoutTag_DTS_6_0_A: AudioChannelLayoutTag = (170 << 16) | 6;
/// C L R Rls Rrs Ts
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_6_0_b?language=objc)
pub const kAudioChannelLayoutTag_DTS_6_0_B: AudioChannelLayoutTag = (171 << 16) | 6;
/// C Cs L R Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_6_0_c?language=objc)
pub const kAudioChannelLayoutTag_DTS_6_0_C: AudioChannelLayoutTag = (172 << 16) | 6;
/// Lc Rc L R Ls Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_6_1_a?language=objc)
pub const kAudioChannelLayoutTag_DTS_6_1_A: AudioChannelLayoutTag = (173 << 16) | 7;
/// C L R Rls Rrs Ts LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_6_1_b?language=objc)
pub const kAudioChannelLayoutTag_DTS_6_1_B: AudioChannelLayoutTag = (174 << 16) | 7;
/// C Cs L R Rls Rrs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_6_1_c?language=objc)
pub const kAudioChannelLayoutTag_DTS_6_1_C: AudioChannelLayoutTag = (175 << 16) | 7;
/// Lc C Rc L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_7_0?language=objc)
pub const kAudioChannelLayoutTag_DTS_7_0: AudioChannelLayoutTag = (176 << 16) | 7;
/// Lc C Rc L R Ls Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_7_1?language=objc)
pub const kAudioChannelLayoutTag_DTS_7_1: AudioChannelLayoutTag = (177 << 16) | 8;
/// Lc Rc L R Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_8_0_a?language=objc)
pub const kAudioChannelLayoutTag_DTS_8_0_A: AudioChannelLayoutTag = (178 << 16) | 8;
/// Lc C Rc L R Ls Cs Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_8_0_b?language=objc)
pub const kAudioChannelLayoutTag_DTS_8_0_B: AudioChannelLayoutTag = (179 << 16) | 8;
/// Lc Rc L R Ls Rs Rls Rrs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_8_1_a?language=objc)
pub const kAudioChannelLayoutTag_DTS_8_1_A: AudioChannelLayoutTag = (180 << 16) | 9;
/// Lc C Rc L R Ls Cs Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_8_1_b?language=objc)
pub const kAudioChannelLayoutTag_DTS_8_1_B: AudioChannelLayoutTag = (181 << 16) | 9;
/// C L R Ls Rs LFE Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_dts_6_1_d?language=objc)
pub const kAudioChannelLayoutTag_DTS_6_1_D: AudioChannelLayoutTag = (182 << 16) | 7;
/// 3 channels, L R LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_2_1?language=objc)
pub const kAudioChannelLayoutTag_WAVE_2_1: AudioChannelLayoutTag = kAudioChannelLayoutTag_DVD_4;
/// 3 channels, L R C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_3_0?language=objc)
pub const kAudioChannelLayoutTag_WAVE_3_0: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_3_0_A;
/// 4 channels, L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_4_0_a?language=objc)
pub const kAudioChannelLayoutTag_WAVE_4_0_A: AudioChannelLayoutTag = kAudioChannelLayoutTag_ITU_2_2;
/// 4 channels, L R Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_4_0_b?language=objc)
pub const kAudioChannelLayoutTag_WAVE_4_0_B: AudioChannelLayoutTag = (185 << 16) | 4;
/// 5 channels, L R C Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_5_0_a?language=objc)
pub const kAudioChannelLayoutTag_WAVE_5_0_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_0_A;
/// 5 channels, L R C Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_5_0_b?language=objc)
pub const kAudioChannelLayoutTag_WAVE_5_0_B: AudioChannelLayoutTag = (186 << 16) | 5;
/// 6 channels, L R C LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_5_1_a?language=objc)
pub const kAudioChannelLayoutTag_WAVE_5_1_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_1_A;
/// 6 channels, L R C LFE Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_5_1_b?language=objc)
pub const kAudioChannelLayoutTag_WAVE_5_1_B: AudioChannelLayoutTag = (187 << 16) | 6;
/// 7 channels, L R C LFE Cs Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_6_1?language=objc)
pub const kAudioChannelLayoutTag_WAVE_6_1: AudioChannelLayoutTag = (188 << 16) | 7;
/// 8 channels, L R C LFE Rls Rrs Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_wave_7_1?language=objc)
pub const kAudioChannelLayoutTag_WAVE_7_1: AudioChannelLayoutTag = (189 << 16) | 8;
/// Higher Order Ambisonics, Ambisonics Channel Number, SN3D normalization
/// needs to be ORed with the actual number of channels (not the HOA order)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_hoa_acn_sn3d?language=objc)
pub const kAudioChannelLayoutTag_HOA_ACN_SN3D: AudioChannelLayoutTag = (190 << 16) | 0;
/// Higher Order Ambisonics, Ambisonics Channel Number, N3D normalization
/// needs to be ORed with the actual number of channels (not the HOA order)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_hoa_acn_n3d?language=objc)
pub const kAudioChannelLayoutTag_HOA_ACN_N3D: AudioChannelLayoutTag = (191 << 16) | 0;
/// L R C LFE Ls Rs Ltm Rtm
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_atmos_5_1_2?language=objc)
pub const kAudioChannelLayoutTag_Atmos_5_1_2: AudioChannelLayoutTag = (194 << 16) | 8;
/// L R C LFE Ls Rs Vhl Vhr Ltr Rtr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_atmos_5_1_4?language=objc)
pub const kAudioChannelLayoutTag_Atmos_5_1_4: AudioChannelLayoutTag = (195 << 16) | 10;
/// L R C LFE Ls Rs Rls Rrs Ltm Rtm
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_atmos_7_1_2?language=objc)
pub const kAudioChannelLayoutTag_Atmos_7_1_2: AudioChannelLayoutTag = (196 << 16) | 10;
/// L R C LFE Ls Rs Rls Rrs Vhl Vhr Ltr Rtr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_atmos_7_1_4?language=objc)
pub const kAudioChannelLayoutTag_Atmos_7_1_4: AudioChannelLayoutTag = (192 << 16) | 12;
/// L R C LFE Ls Rs Rls Rrs Lw Rw Vhl Vhr Ltm Rtm Ltr Rtr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_atmos_9_1_6?language=objc)
pub const kAudioChannelLayoutTag_Atmos_9_1_6: AudioChannelLayoutTag = (193 << 16) | 16;
/// C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_mono?language=objc)
pub const kAudioChannelLayoutTag_Logic_Mono: AudioChannelLayoutTag = kAudioChannelLayoutTag_Mono;
/// L R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_stereo?language=objc)
pub const kAudioChannelLayoutTag_Logic_Stereo: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Stereo;
/// L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_quadraphonic?language=objc)
pub const kAudioChannelLayoutTag_Logic_Quadraphonic: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Quadraphonic;
/// L R C Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_4_0_a?language=objc)
pub const kAudioChannelLayoutTag_Logic_4_0_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_4_0_A;
/// C L R Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_4_0_b?language=objc)
pub const kAudioChannelLayoutTag_Logic_4_0_B: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_4_0_B;
/// L R Cs C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_4_0_c?language=objc)
pub const kAudioChannelLayoutTag_Logic_4_0_C: AudioChannelLayoutTag = (197 << 16) | 4;
/// L R C Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_5_0_a?language=objc)
pub const kAudioChannelLayoutTag_Logic_5_0_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_0_A;
/// L R Ls Rs C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_5_0_b?language=objc)
pub const kAudioChannelLayoutTag_Logic_5_0_B: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_0_B;
/// L C R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_5_0_c?language=objc)
pub const kAudioChannelLayoutTag_Logic_5_0_C: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_0_C;
/// C L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_5_0_d?language=objc)
pub const kAudioChannelLayoutTag_Logic_5_0_D: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_0_D;
/// L R C LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_5_1_a?language=objc)
pub const kAudioChannelLayoutTag_Logic_5_1_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_1_A;
/// L R Ls Rs C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_5_1_b?language=objc)
pub const kAudioChannelLayoutTag_Logic_5_1_B: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_1_B;
/// L C R Ls Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_5_1_c?language=objc)
pub const kAudioChannelLayoutTag_Logic_5_1_C: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_1_C;
/// C L R Ls Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_5_1_d?language=objc)
pub const kAudioChannelLayoutTag_Logic_5_1_D: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_5_1_D;
/// C L R Ls Rs Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_6_0_a?language=objc)
pub const kAudioChannelLayoutTag_Logic_6_0_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_AAC_6_0;
/// L R Ls Rs Cs C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_6_0_b?language=objc)
pub const kAudioChannelLayoutTag_Logic_6_0_B: AudioChannelLayoutTag = (198 << 16) | 6;
/// L R Ls Rs C Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_6_0_c?language=objc)
pub const kAudioChannelLayoutTag_Logic_6_0_C: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_AudioUnit_6_0;
/// C L R Ls Rs Cs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_6_1_a?language=objc)
pub const kAudioChannelLayoutTag_Logic_6_1_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_AAC_6_1;
/// L R Ls Rs Cs C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_6_1_b?language=objc)
pub const kAudioChannelLayoutTag_Logic_6_1_B: AudioChannelLayoutTag = (199 << 16) | 7;
/// L R C LFE Ls Rs Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_6_1_c?language=objc)
pub const kAudioChannelLayoutTag_Logic_6_1_C: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_6_1_A;
/// L C R Ls Cs Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_6_1_d?language=objc)
pub const kAudioChannelLayoutTag_Logic_6_1_D: AudioChannelLayoutTag = (200 << 16) | 7;
/// L R C LFE Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_7_1_a?language=objc)
pub const kAudioChannelLayoutTag_Logic_7_1_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_AudioUnit_7_1;
/// L R Ls Rs Rls Rrs C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_7_1_b?language=objc)
pub const kAudioChannelLayoutTag_Logic_7_1_B: AudioChannelLayoutTag = (201 << 16) | 8;
/// L R C LFE Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_7_1_c?language=objc)
pub const kAudioChannelLayoutTag_Logic_7_1_C: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_7_1_C;
/// L R C LFE Ls Rs Lc Rc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_7_1_sdds_a?language=objc)
pub const kAudioChannelLayoutTag_Logic_7_1_SDDS_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_7_1_A;
/// C Lc Rc L R Ls Rs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_7_1_sdds_b?language=objc)
pub const kAudioChannelLayoutTag_Logic_7_1_SDDS_B: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_MPEG_7_1_B;
/// L R Ls Rs C LFE Lc Rc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_7_1_sdds_c?language=objc)
pub const kAudioChannelLayoutTag_Logic_7_1_SDDS_C: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Emagic_Default_7_1;
/// L R C LFE Ls Rs Ltm Rtm
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_atmos_5_1_2?language=objc)
pub const kAudioChannelLayoutTag_Logic_Atmos_5_1_2: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Atmos_5_1_2;
/// L R C LFE Ls Rs Vhl Vhr Ltr Rtr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_atmos_5_1_4?language=objc)
pub const kAudioChannelLayoutTag_Logic_Atmos_5_1_4: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Atmos_5_1_4;
/// L R C LFE Ls Rs Rls Rrs Ltm Rtm
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_atmos_7_1_2?language=objc)
pub const kAudioChannelLayoutTag_Logic_Atmos_7_1_2: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Atmos_7_1_2;
/// L R C LFE Ls Rs Rls Rrs Vhl Vhr Ltr Rtr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_atmos_7_1_4_a?language=objc)
pub const kAudioChannelLayoutTag_Logic_Atmos_7_1_4_A: AudioChannelLayoutTag =
    kAudioChannelLayoutTag_Atmos_7_1_4;
/// L R Rls Rrs Ls Rs C LFE Vhl Vhr Ltr Rtr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_atmos_7_1_4_b?language=objc)
pub const kAudioChannelLayoutTag_Logic_Atmos_7_1_4_B: AudioChannelLayoutTag = (202 << 16) | 12;
/// L R Rls Rrs Ls Rs C LFE Vhl Vhr Ltm Rtm Ltr Rtr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_logic_atmos_7_1_6?language=objc)
pub const kAudioChannelLayoutTag_Logic_Atmos_7_1_6: AudioChannelLayoutTag = (203 << 16) | 14;
/// needs to be ORed with the actual number of channels
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_discreteinorder?language=objc)
pub const kAudioChannelLayoutTag_DiscreteInOrder: AudioChannelLayoutTag = (147 << 16) | 0;
/// C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_1?language=objc)
pub const kAudioChannelLayoutTag_CICP_1: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_1_0;
/// L R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_2?language=objc)
pub const kAudioChannelLayoutTag_CICP_2: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_2_0;
/// L R C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_3?language=objc)
pub const kAudioChannelLayoutTag_CICP_3: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_3_0_A;
/// L R C Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_4?language=objc)
pub const kAudioChannelLayoutTag_CICP_4: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_4_0_A;
/// L R C Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_5?language=objc)
pub const kAudioChannelLayoutTag_CICP_5: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_0_A;
/// L R C LFE Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_6?language=objc)
pub const kAudioChannelLayoutTag_CICP_6: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_5_1_A;
/// L R C LFE Ls Rs Lc Rc
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_7?language=objc)
pub const kAudioChannelLayoutTag_CICP_7: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_7_1_B;
/// L R Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_9?language=objc)
pub const kAudioChannelLayoutTag_CICP_9: AudioChannelLayoutTag = kAudioChannelLayoutTag_ITU_2_1;
/// L R Ls Rs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_10?language=objc)
pub const kAudioChannelLayoutTag_CICP_10: AudioChannelLayoutTag = kAudioChannelLayoutTag_ITU_2_2;
/// L R C LFE Ls Rs Cs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_11?language=objc)
pub const kAudioChannelLayoutTag_CICP_11: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_6_1_A;
/// L R C LFE Ls Rs Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_12?language=objc)
pub const kAudioChannelLayoutTag_CICP_12: AudioChannelLayoutTag = kAudioChannelLayoutTag_MPEG_7_1_C;
/// Lc Rc C LFE2 Rls Rrs L R Cs LFE3 Lss Rss Vhl Vhr Vhc Ts Ltr Rtr Ltm Rtm Ctr Cb Lb Rb
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_13?language=objc)
pub const kAudioChannelLayoutTag_CICP_13: AudioChannelLayoutTag = (204 << 16) | 24;
/// L R C LFE Ls Rs Vhl Vhr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_14?language=objc)
pub const kAudioChannelLayoutTag_CICP_14: AudioChannelLayoutTag = (205 << 16) | 8;
/// L R C LFE2 Rls Rrs LFE3 Lss Rss Vhl Vhr Ctr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_15?language=objc)
pub const kAudioChannelLayoutTag_CICP_15: AudioChannelLayoutTag = (206 << 16) | 12;
/// L R C LFE Ls Rs Vhl Vhr Lts Rts
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_16?language=objc)
pub const kAudioChannelLayoutTag_CICP_16: AudioChannelLayoutTag = (207 << 16) | 10;
/// L R C LFE Ls Rs Vhl Vhr Vhc Lts Rts Ts
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_17?language=objc)
pub const kAudioChannelLayoutTag_CICP_17: AudioChannelLayoutTag = (208 << 16) | 12;
/// L R C LFE Ls Rs Lbs Rbs Vhl Vhr Vhc Lts Rts Ts
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_18?language=objc)
pub const kAudioChannelLayoutTag_CICP_18: AudioChannelLayoutTag = (209 << 16) | 14;
/// L R C LFE Rls Rrs Lss Rss Vhl Vhr Ltr Rtr
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_19?language=objc)
pub const kAudioChannelLayoutTag_CICP_19: AudioChannelLayoutTag = (210 << 16) | 12;
/// L R C LFE Rls Rrs Lss Rss Vhl Vhr Ltr Rtr Leos Reos
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_cicp_20?language=objc)
pub const kAudioChannelLayoutTag_CICP_20: AudioChannelLayoutTag = (211 << 16) | 14;
/// 3 channels, L C R
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ogg_3_0?language=objc)
pub const kAudioChannelLayoutTag_Ogg_3_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_AC3_3_0;
/// 4 channels, L R Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ogg_4_0?language=objc)
pub const kAudioChannelLayoutTag_Ogg_4_0: AudioChannelLayoutTag = kAudioChannelLayoutTag_WAVE_4_0_B;
/// 5 channels, L C R Rls Rrs
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ogg_5_0?language=objc)
pub const kAudioChannelLayoutTag_Ogg_5_0: AudioChannelLayoutTag = (212 << 16) | 5;
/// 6 channels, L C R Rls Rrs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ogg_5_1?language=objc)
pub const kAudioChannelLayoutTag_Ogg_5_1: AudioChannelLayoutTag = (213 << 16) | 6;
/// 7 channels, L C R Ls Rs Cs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ogg_6_1?language=objc)
pub const kAudioChannelLayoutTag_Ogg_6_1: AudioChannelLayoutTag = (214 << 16) | 7;
/// 8 channels, L C R Ls Rs Rls Rrs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_ogg_7_1?language=objc)
pub const kAudioChannelLayoutTag_Ogg_7_1: AudioChannelLayoutTag = (215 << 16) | 8;
/// 5 channels, L R Rls Rrs C
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_0_e?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_0_E: AudioChannelLayoutTag = (216 << 16) | 5;
/// 6 channels, L R Rls Rrs C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_5_1_e?language=objc)
pub const kAudioChannelLayoutTag_MPEG_5_1_E: AudioChannelLayoutTag = (217 << 16) | 6;
/// 7 channels, L R Ls Rs C Cs LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_6_1_b?language=objc)
pub const kAudioChannelLayoutTag_MPEG_6_1_B: AudioChannelLayoutTag = (218 << 16) | 7;
/// 8 channels, L R Rls Rrs Ls Rs C LFE
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_mpeg_7_1_d?language=objc)
pub const kAudioChannelLayoutTag_MPEG_7_1_D: AudioChannelLayoutTag = (219 << 16) | 8;
/// Channel layout tag values in this range are reserved for internal use
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_beginreserved?language=objc)
pub const kAudioChannelLayoutTag_BeginReserved: AudioChannelLayoutTag = 0xF0000000;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_endreserved?language=objc)
pub const kAudioChannelLayoutTag_EndReserved: AudioChannelLayoutTag = 0xFFFEFFFF;
/// needs to be ORed with the actual number of channels
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/kaudiochannellayouttag_unknown?language=objc)
pub const kAudioChannelLayoutTag_Unknown: AudioChannelLayoutTag = 0xFFFF0000;

/// This structure describes a single channel.
///
/// The AudioChannelLabel that describes the channel.
///
/// Flags that control the interpretation of mCoordinates.
///
/// An ordered triple that specifies a precise speaker location.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiochanneldescription?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioChannelDescription {
    pub mChannelLabel: AudioChannelLabel,
    pub mChannelFlags: AudioChannelFlags,
    pub mCoordinates: [f32; 3],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioChannelDescription {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioChannelDescription",
        &[
            <AudioChannelLabel>::ENCODING,
            <AudioChannelFlags>::ENCODING,
            <[f32; 3]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioChannelDescription {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This structure is used to specify channel layouts in files and hardware.
///
/// The AudioChannelLayoutTag that indicates the layout.
///
/// If mChannelLayoutTag is set to kAudioChannelLayoutTag_UseChannelBitmap, this
/// field is the channel usage bitmap.
///
/// The number of items in the mChannelDescriptions array.
///
/// A variable length array of AudioChannelDescriptions that describe the
/// layout.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audiochannellayout?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioChannelLayout {
    pub mChannelLayoutTag: AudioChannelLayoutTag,
    pub mChannelBitmap: AudioChannelBitmap,
    pub mNumberChannelDescriptions: u32,
    pub mChannelDescriptions: [AudioChannelDescription; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioChannelLayout {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioChannelLayout",
        &[
            <AudioChannelLayoutTag>::ENCODING,
            <AudioChannelBitmap>::ENCODING,
            <u32>::ENCODING,
            <[AudioChannelDescription; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioChannelLayout {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl AudioChannelLayout {
    // TODO: pub fn AudioChannelLayoutTag_GetNumberOfChannels(in_layout_tag: AudioChannelLayoutTag,) -> u32;
}

/// this struct is used as output from the kAudioFormatProperty_FormatList property
///
/// an AudioStreamBasicDescription
///
/// an AudioChannelLayoutTag
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/audioformatlistitem?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFormatListItem {
    pub mASBD: AudioStreamBasicDescription,
    pub mChannelLayoutTag: AudioChannelLayoutTag,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioFormatListItem {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFormatListItem",
        &[
            <AudioStreamBasicDescription>::ENCODING,
            <AudioChannelLayoutTag>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioFormatListItem {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// @
/// deprecated    in version 10.5
///
///
/// Constants that describe the various kinds of MPEG-4 audio data.
///
/// These constants are used in the flags field of an AudioStreamBasicDescription
/// that describes an MPEG-4 audio stream.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudiotypes/mpeg4objectid?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MPEG4ObjectID(pub c_long);
impl MPEG4ObjectID {
    #[doc(alias = "kMPEG4Object_AAC_Main")]
    pub const AAC_Main: Self = Self(1);
    #[doc(alias = "kMPEG4Object_AAC_LC")]
    pub const AAC_LC: Self = Self(2);
    #[doc(alias = "kMPEG4Object_AAC_SSR")]
    pub const AAC_SSR: Self = Self(3);
    #[doc(alias = "kMPEG4Object_AAC_LTP")]
    pub const AAC_LTP: Self = Self(4);
    #[doc(alias = "kMPEG4Object_AAC_SBR")]
    pub const AAC_SBR: Self = Self(5);
    #[doc(alias = "kMPEG4Object_AAC_Scalable")]
    pub const AAC_Scalable: Self = Self(6);
    #[doc(alias = "kMPEG4Object_TwinVQ")]
    pub const TwinVQ: Self = Self(7);
    #[doc(alias = "kMPEG4Object_CELP")]
    pub const CELP: Self = Self(8);
    #[doc(alias = "kMPEG4Object_HVXC")]
    pub const HVXC: Self = Self(9);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for MPEG4ObjectID {
    const ENCODING: Encoding = Encoding::C_LONG;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for MPEG4ObjectID {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
