// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package entityresolution

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddPolicyStatement = "AddPolicyStatement"

// AddPolicyStatementRequest generates a "aws/request.Request" representing the
// client's request for the AddPolicyStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddPolicyStatement for more information on using the AddPolicyStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddPolicyStatementRequest method.
//	req, resp := client.AddPolicyStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/AddPolicyStatement
func (c *EntityResolution) AddPolicyStatementRequest(input *AddPolicyStatementInput) (req *request.Request, output *AddPolicyStatementOutput) {
	op := &request.Operation{
		Name:       opAddPolicyStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{arn}/{statementId}",
	}

	if input == nil {
		input = &AddPolicyStatementInput{}
	}

	output = &AddPolicyStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddPolicyStatement API operation for AWS EntityResolution.
//
// Adds a policy statement object. To retrieve a list of existing policy statements,
// use the GetPolicy API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation AddPolicyStatement for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/AddPolicyStatement
func (c *EntityResolution) AddPolicyStatement(input *AddPolicyStatementInput) (*AddPolicyStatementOutput, error) {
	req, out := c.AddPolicyStatementRequest(input)
	return out, req.Send()
}

// AddPolicyStatementWithContext is the same as AddPolicyStatement with the addition of
// the ability to pass a context and additional request options.
//
// See AddPolicyStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) AddPolicyStatementWithContext(ctx aws.Context, input *AddPolicyStatementInput, opts ...request.Option) (*AddPolicyStatementOutput, error) {
	req, out := c.AddPolicyStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteUniqueId = "BatchDeleteUniqueId"

// BatchDeleteUniqueIdRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteUniqueId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteUniqueId for more information on using the BatchDeleteUniqueId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteUniqueIdRequest method.
//	req, resp := client.BatchDeleteUniqueIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/BatchDeleteUniqueId
func (c *EntityResolution) BatchDeleteUniqueIdRequest(input *BatchDeleteUniqueIdInput) (req *request.Request, output *BatchDeleteUniqueIdOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteUniqueId,
		HTTPMethod: "DELETE",
		HTTPPath:   "/matchingworkflows/{workflowName}/uniqueids",
	}

	if input == nil {
		input = &BatchDeleteUniqueIdInput{}
	}

	output = &BatchDeleteUniqueIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteUniqueId API operation for AWS EntityResolution.
//
// Deletes multiple unique IDs in a matching workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation BatchDeleteUniqueId for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/BatchDeleteUniqueId
func (c *EntityResolution) BatchDeleteUniqueId(input *BatchDeleteUniqueIdInput) (*BatchDeleteUniqueIdOutput, error) {
	req, out := c.BatchDeleteUniqueIdRequest(input)
	return out, req.Send()
}

// BatchDeleteUniqueIdWithContext is the same as BatchDeleteUniqueId with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteUniqueId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) BatchDeleteUniqueIdWithContext(ctx aws.Context, input *BatchDeleteUniqueIdInput, opts ...request.Option) (*BatchDeleteUniqueIdOutput, error) {
	req, out := c.BatchDeleteUniqueIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIdMappingWorkflow = "CreateIdMappingWorkflow"

// CreateIdMappingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the CreateIdMappingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIdMappingWorkflow for more information on using the CreateIdMappingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIdMappingWorkflowRequest method.
//	req, resp := client.CreateIdMappingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdMappingWorkflow
func (c *EntityResolution) CreateIdMappingWorkflowRequest(input *CreateIdMappingWorkflowInput) (req *request.Request, output *CreateIdMappingWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateIdMappingWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/idmappingworkflows",
	}

	if input == nil {
		input = &CreateIdMappingWorkflowInput{}
	}

	output = &CreateIdMappingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIdMappingWorkflow API operation for AWS EntityResolution.
//
// Creates an IdMappingWorkflow object which stores the configuration of the
// data processing job to be run. Each IdMappingWorkflow must have a unique
// workflow name. To modify an existing workflow, use the UpdateIdMappingWorkflow
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation CreateIdMappingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdMappingWorkflow
func (c *EntityResolution) CreateIdMappingWorkflow(input *CreateIdMappingWorkflowInput) (*CreateIdMappingWorkflowOutput, error) {
	req, out := c.CreateIdMappingWorkflowRequest(input)
	return out, req.Send()
}

// CreateIdMappingWorkflowWithContext is the same as CreateIdMappingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIdMappingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) CreateIdMappingWorkflowWithContext(ctx aws.Context, input *CreateIdMappingWorkflowInput, opts ...request.Option) (*CreateIdMappingWorkflowOutput, error) {
	req, out := c.CreateIdMappingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIdNamespace = "CreateIdNamespace"

// CreateIdNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateIdNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIdNamespace for more information on using the CreateIdNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIdNamespaceRequest method.
//	req, resp := client.CreateIdNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdNamespace
func (c *EntityResolution) CreateIdNamespaceRequest(input *CreateIdNamespaceInput) (req *request.Request, output *CreateIdNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreateIdNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/idnamespaces",
	}

	if input == nil {
		input = &CreateIdNamespaceInput{}
	}

	output = &CreateIdNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIdNamespace API operation for AWS EntityResolution.
//
// Creates an ID namespace object which will help customers provide metadata
// explaining their dataset and how to use it. Each ID namespace must have a
// unique name. To modify an existing ID namespace, use the UpdateIdNamespace
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation CreateIdNamespace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateIdNamespace
func (c *EntityResolution) CreateIdNamespace(input *CreateIdNamespaceInput) (*CreateIdNamespaceOutput, error) {
	req, out := c.CreateIdNamespaceRequest(input)
	return out, req.Send()
}

// CreateIdNamespaceWithContext is the same as CreateIdNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIdNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) CreateIdNamespaceWithContext(ctx aws.Context, input *CreateIdNamespaceInput, opts ...request.Option) (*CreateIdNamespaceOutput, error) {
	req, out := c.CreateIdNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMatchingWorkflow = "CreateMatchingWorkflow"

// CreateMatchingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the CreateMatchingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMatchingWorkflow for more information on using the CreateMatchingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMatchingWorkflowRequest method.
//	req, resp := client.CreateMatchingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow
func (c *EntityResolution) CreateMatchingWorkflowRequest(input *CreateMatchingWorkflowInput) (req *request.Request, output *CreateMatchingWorkflowOutput) {
	op := &request.Operation{
		Name:       opCreateMatchingWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/matchingworkflows",
	}

	if input == nil {
		input = &CreateMatchingWorkflowInput{}
	}

	output = &CreateMatchingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMatchingWorkflow API operation for AWS EntityResolution.
//
// Creates a MatchingWorkflow object which stores the configuration of the data
// processing job to be run. It is important to note that there should not be
// a pre-existing MatchingWorkflow with the same name. To modify an existing
// workflow, utilize the UpdateMatchingWorkflow API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation CreateMatchingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateMatchingWorkflow
func (c *EntityResolution) CreateMatchingWorkflow(input *CreateMatchingWorkflowInput) (*CreateMatchingWorkflowOutput, error) {
	req, out := c.CreateMatchingWorkflowRequest(input)
	return out, req.Send()
}

// CreateMatchingWorkflowWithContext is the same as CreateMatchingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMatchingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) CreateMatchingWorkflowWithContext(ctx aws.Context, input *CreateMatchingWorkflowInput, opts ...request.Option) (*CreateMatchingWorkflowOutput, error) {
	req, out := c.CreateMatchingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSchemaMapping = "CreateSchemaMapping"

// CreateSchemaMappingRequest generates a "aws/request.Request" representing the
// client's request for the CreateSchemaMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSchemaMapping for more information on using the CreateSchemaMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSchemaMappingRequest method.
//	req, resp := client.CreateSchemaMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping
func (c *EntityResolution) CreateSchemaMappingRequest(input *CreateSchemaMappingInput) (req *request.Request, output *CreateSchemaMappingOutput) {
	op := &request.Operation{
		Name:       opCreateSchemaMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/schemas",
	}

	if input == nil {
		input = &CreateSchemaMappingInput{}
	}

	output = &CreateSchemaMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSchemaMapping API operation for AWS EntityResolution.
//
// Creates a schema mapping, which defines the schema of the input customer
// records table. The SchemaMapping also provides Entity Resolution with some
// metadata about the table, such as the attribute types of the columns and
// which columns to match on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation CreateSchemaMapping for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/CreateSchemaMapping
func (c *EntityResolution) CreateSchemaMapping(input *CreateSchemaMappingInput) (*CreateSchemaMappingOutput, error) {
	req, out := c.CreateSchemaMappingRequest(input)
	return out, req.Send()
}

// CreateSchemaMappingWithContext is the same as CreateSchemaMapping with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSchemaMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) CreateSchemaMappingWithContext(ctx aws.Context, input *CreateSchemaMappingInput, opts ...request.Option) (*CreateSchemaMappingOutput, error) {
	req, out := c.CreateSchemaMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdMappingWorkflow = "DeleteIdMappingWorkflow"

// DeleteIdMappingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdMappingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdMappingWorkflow for more information on using the DeleteIdMappingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdMappingWorkflowRequest method.
//	req, resp := client.DeleteIdMappingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdMappingWorkflow
func (c *EntityResolution) DeleteIdMappingWorkflowRequest(input *DeleteIdMappingWorkflowInput) (req *request.Request, output *DeleteIdMappingWorkflowOutput) {
	op := &request.Operation{
		Name:       opDeleteIdMappingWorkflow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/idmappingworkflows/{workflowName}",
	}

	if input == nil {
		input = &DeleteIdMappingWorkflowInput{}
	}

	output = &DeleteIdMappingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIdMappingWorkflow API operation for AWS EntityResolution.
//
// Deletes the IdMappingWorkflow with a given name. This operation will succeed
// even if a workflow with the given name does not exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation DeleteIdMappingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdMappingWorkflow
func (c *EntityResolution) DeleteIdMappingWorkflow(input *DeleteIdMappingWorkflowInput) (*DeleteIdMappingWorkflowOutput, error) {
	req, out := c.DeleteIdMappingWorkflowRequest(input)
	return out, req.Send()
}

// DeleteIdMappingWorkflowWithContext is the same as DeleteIdMappingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdMappingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) DeleteIdMappingWorkflowWithContext(ctx aws.Context, input *DeleteIdMappingWorkflowInput, opts ...request.Option) (*DeleteIdMappingWorkflowOutput, error) {
	req, out := c.DeleteIdMappingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdNamespace = "DeleteIdNamespace"

// DeleteIdNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIdNamespace for more information on using the DeleteIdNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIdNamespaceRequest method.
//	req, resp := client.DeleteIdNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdNamespace
func (c *EntityResolution) DeleteIdNamespaceRequest(input *DeleteIdNamespaceInput) (req *request.Request, output *DeleteIdNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteIdNamespace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/idnamespaces/{idNamespaceName}",
	}

	if input == nil {
		input = &DeleteIdNamespaceInput{}
	}

	output = &DeleteIdNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIdNamespace API operation for AWS EntityResolution.
//
// Deletes the IdNamespace with a given name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation DeleteIdNamespace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteIdNamespace
func (c *EntityResolution) DeleteIdNamespace(input *DeleteIdNamespaceInput) (*DeleteIdNamespaceOutput, error) {
	req, out := c.DeleteIdNamespaceRequest(input)
	return out, req.Send()
}

// DeleteIdNamespaceWithContext is the same as DeleteIdNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) DeleteIdNamespaceWithContext(ctx aws.Context, input *DeleteIdNamespaceInput, opts ...request.Option) (*DeleteIdNamespaceOutput, error) {
	req, out := c.DeleteIdNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMatchingWorkflow = "DeleteMatchingWorkflow"

// DeleteMatchingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMatchingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMatchingWorkflow for more information on using the DeleteMatchingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMatchingWorkflowRequest method.
//	req, resp := client.DeleteMatchingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow
func (c *EntityResolution) DeleteMatchingWorkflowRequest(input *DeleteMatchingWorkflowInput) (req *request.Request, output *DeleteMatchingWorkflowOutput) {
	op := &request.Operation{
		Name:       opDeleteMatchingWorkflow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/matchingworkflows/{workflowName}",
	}

	if input == nil {
		input = &DeleteMatchingWorkflowInput{}
	}

	output = &DeleteMatchingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMatchingWorkflow API operation for AWS EntityResolution.
//
// Deletes the MatchingWorkflow with a given name. This operation will succeed
// even if a workflow with the given name does not exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation DeleteMatchingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteMatchingWorkflow
func (c *EntityResolution) DeleteMatchingWorkflow(input *DeleteMatchingWorkflowInput) (*DeleteMatchingWorkflowOutput, error) {
	req, out := c.DeleteMatchingWorkflowRequest(input)
	return out, req.Send()
}

// DeleteMatchingWorkflowWithContext is the same as DeleteMatchingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMatchingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) DeleteMatchingWorkflowWithContext(ctx aws.Context, input *DeleteMatchingWorkflowInput, opts ...request.Option) (*DeleteMatchingWorkflowOutput, error) {
	req, out := c.DeleteMatchingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicyStatement = "DeletePolicyStatement"

// DeletePolicyStatementRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicyStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicyStatement for more information on using the DeletePolicyStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePolicyStatementRequest method.
//	req, resp := client.DeletePolicyStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeletePolicyStatement
func (c *EntityResolution) DeletePolicyStatementRequest(input *DeletePolicyStatementInput) (req *request.Request, output *DeletePolicyStatementOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyStatement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{arn}/{statementId}",
	}

	if input == nil {
		input = &DeletePolicyStatementInput{}
	}

	output = &DeletePolicyStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePolicyStatement API operation for AWS EntityResolution.
//
// Deletes the policy statement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation DeletePolicyStatement for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeletePolicyStatement
func (c *EntityResolution) DeletePolicyStatement(input *DeletePolicyStatementInput) (*DeletePolicyStatementOutput, error) {
	req, out := c.DeletePolicyStatementRequest(input)
	return out, req.Send()
}

// DeletePolicyStatementWithContext is the same as DeletePolicyStatement with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicyStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) DeletePolicyStatementWithContext(ctx aws.Context, input *DeletePolicyStatementInput, opts ...request.Option) (*DeletePolicyStatementOutput, error) {
	req, out := c.DeletePolicyStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchemaMapping = "DeleteSchemaMapping"

// DeleteSchemaMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchemaMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchemaMapping for more information on using the DeleteSchemaMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSchemaMappingRequest method.
//	req, resp := client.DeleteSchemaMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping
func (c *EntityResolution) DeleteSchemaMappingRequest(input *DeleteSchemaMappingInput) (req *request.Request, output *DeleteSchemaMappingOutput) {
	op := &request.Operation{
		Name:       opDeleteSchemaMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/schemas/{schemaName}",
	}

	if input == nil {
		input = &DeleteSchemaMappingInput{}
	}

	output = &DeleteSchemaMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSchemaMapping API operation for AWS EntityResolution.
//
// Deletes the SchemaMapping with a given name. This operation will succeed
// even if a schema with the given name does not exist. This operation will
// fail if there is a MatchingWorkflow object that references the SchemaMapping
// in the workflow's InputSourceConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation DeleteSchemaMapping for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/DeleteSchemaMapping
func (c *EntityResolution) DeleteSchemaMapping(input *DeleteSchemaMappingInput) (*DeleteSchemaMappingOutput, error) {
	req, out := c.DeleteSchemaMappingRequest(input)
	return out, req.Send()
}

// DeleteSchemaMappingWithContext is the same as DeleteSchemaMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchemaMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) DeleteSchemaMappingWithContext(ctx aws.Context, input *DeleteSchemaMappingInput, opts ...request.Option) (*DeleteSchemaMappingOutput, error) {
	req, out := c.DeleteSchemaMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdMappingJob = "GetIdMappingJob"

// GetIdMappingJobRequest generates a "aws/request.Request" representing the
// client's request for the GetIdMappingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdMappingJob for more information on using the GetIdMappingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdMappingJobRequest method.
//	req, resp := client.GetIdMappingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingJob
func (c *EntityResolution) GetIdMappingJobRequest(input *GetIdMappingJobInput) (req *request.Request, output *GetIdMappingJobOutput) {
	op := &request.Operation{
		Name:       opGetIdMappingJob,
		HTTPMethod: "GET",
		HTTPPath:   "/idmappingworkflows/{workflowName}/jobs/{jobId}",
	}

	if input == nil {
		input = &GetIdMappingJobInput{}
	}

	output = &GetIdMappingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdMappingJob API operation for AWS EntityResolution.
//
// Gets the status, metrics, and errors (if there are any) that are associated
// with a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetIdMappingJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingJob
func (c *EntityResolution) GetIdMappingJob(input *GetIdMappingJobInput) (*GetIdMappingJobOutput, error) {
	req, out := c.GetIdMappingJobRequest(input)
	return out, req.Send()
}

// GetIdMappingJobWithContext is the same as GetIdMappingJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdMappingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetIdMappingJobWithContext(ctx aws.Context, input *GetIdMappingJobInput, opts ...request.Option) (*GetIdMappingJobOutput, error) {
	req, out := c.GetIdMappingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdMappingWorkflow = "GetIdMappingWorkflow"

// GetIdMappingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the GetIdMappingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdMappingWorkflow for more information on using the GetIdMappingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdMappingWorkflowRequest method.
//	req, resp := client.GetIdMappingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingWorkflow
func (c *EntityResolution) GetIdMappingWorkflowRequest(input *GetIdMappingWorkflowInput) (req *request.Request, output *GetIdMappingWorkflowOutput) {
	op := &request.Operation{
		Name:       opGetIdMappingWorkflow,
		HTTPMethod: "GET",
		HTTPPath:   "/idmappingworkflows/{workflowName}",
	}

	if input == nil {
		input = &GetIdMappingWorkflowInput{}
	}

	output = &GetIdMappingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdMappingWorkflow API operation for AWS EntityResolution.
//
// Returns the IdMappingWorkflow with a given name, if it exists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetIdMappingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdMappingWorkflow
func (c *EntityResolution) GetIdMappingWorkflow(input *GetIdMappingWorkflowInput) (*GetIdMappingWorkflowOutput, error) {
	req, out := c.GetIdMappingWorkflowRequest(input)
	return out, req.Send()
}

// GetIdMappingWorkflowWithContext is the same as GetIdMappingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdMappingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetIdMappingWorkflowWithContext(ctx aws.Context, input *GetIdMappingWorkflowInput, opts ...request.Option) (*GetIdMappingWorkflowOutput, error) {
	req, out := c.GetIdMappingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdNamespace = "GetIdNamespace"

// GetIdNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the GetIdNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIdNamespace for more information on using the GetIdNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIdNamespaceRequest method.
//	req, resp := client.GetIdNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdNamespace
func (c *EntityResolution) GetIdNamespaceRequest(input *GetIdNamespaceInput) (req *request.Request, output *GetIdNamespaceOutput) {
	op := &request.Operation{
		Name:       opGetIdNamespace,
		HTTPMethod: "GET",
		HTTPPath:   "/idnamespaces/{idNamespaceName}",
	}

	if input == nil {
		input = &GetIdNamespaceInput{}
	}

	output = &GetIdNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdNamespace API operation for AWS EntityResolution.
//
// Returns the IdNamespace with a given name, if it exists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetIdNamespace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetIdNamespace
func (c *EntityResolution) GetIdNamespace(input *GetIdNamespaceInput) (*GetIdNamespaceOutput, error) {
	req, out := c.GetIdNamespaceRequest(input)
	return out, req.Send()
}

// GetIdNamespaceWithContext is the same as GetIdNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetIdNamespaceWithContext(ctx aws.Context, input *GetIdNamespaceInput, opts ...request.Option) (*GetIdNamespaceOutput, error) {
	req, out := c.GetIdNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMatchId = "GetMatchId"

// GetMatchIdRequest generates a "aws/request.Request" representing the
// client's request for the GetMatchId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMatchId for more information on using the GetMatchId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMatchIdRequest method.
//	req, resp := client.GetMatchIdRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId
func (c *EntityResolution) GetMatchIdRequest(input *GetMatchIdInput) (req *request.Request, output *GetMatchIdOutput) {
	op := &request.Operation{
		Name:       opGetMatchId,
		HTTPMethod: "POST",
		HTTPPath:   "/matchingworkflows/{workflowName}/matches",
	}

	if input == nil {
		input = &GetMatchIdInput{}
	}

	output = &GetMatchIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMatchId API operation for AWS EntityResolution.
//
// Returns the corresponding Match ID of a customer record if the record has
// been processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetMatchId for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchId
func (c *EntityResolution) GetMatchId(input *GetMatchIdInput) (*GetMatchIdOutput, error) {
	req, out := c.GetMatchIdRequest(input)
	return out, req.Send()
}

// GetMatchIdWithContext is the same as GetMatchId with the addition of
// the ability to pass a context and additional request options.
//
// See GetMatchId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetMatchIdWithContext(ctx aws.Context, input *GetMatchIdInput, opts ...request.Option) (*GetMatchIdOutput, error) {
	req, out := c.GetMatchIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMatchingJob = "GetMatchingJob"

// GetMatchingJobRequest generates a "aws/request.Request" representing the
// client's request for the GetMatchingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMatchingJob for more information on using the GetMatchingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMatchingJobRequest method.
//	req, resp := client.GetMatchingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob
func (c *EntityResolution) GetMatchingJobRequest(input *GetMatchingJobInput) (req *request.Request, output *GetMatchingJobOutput) {
	op := &request.Operation{
		Name:       opGetMatchingJob,
		HTTPMethod: "GET",
		HTTPPath:   "/matchingworkflows/{workflowName}/jobs/{jobId}",
	}

	if input == nil {
		input = &GetMatchingJobInput{}
	}

	output = &GetMatchingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMatchingJob API operation for AWS EntityResolution.
//
// Gets the status, metrics, and errors (if there are any) that are associated
// with a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetMatchingJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingJob
func (c *EntityResolution) GetMatchingJob(input *GetMatchingJobInput) (*GetMatchingJobOutput, error) {
	req, out := c.GetMatchingJobRequest(input)
	return out, req.Send()
}

// GetMatchingJobWithContext is the same as GetMatchingJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetMatchingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetMatchingJobWithContext(ctx aws.Context, input *GetMatchingJobInput, opts ...request.Option) (*GetMatchingJobOutput, error) {
	req, out := c.GetMatchingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMatchingWorkflow = "GetMatchingWorkflow"

// GetMatchingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the GetMatchingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMatchingWorkflow for more information on using the GetMatchingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMatchingWorkflowRequest method.
//	req, resp := client.GetMatchingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow
func (c *EntityResolution) GetMatchingWorkflowRequest(input *GetMatchingWorkflowInput) (req *request.Request, output *GetMatchingWorkflowOutput) {
	op := &request.Operation{
		Name:       opGetMatchingWorkflow,
		HTTPMethod: "GET",
		HTTPPath:   "/matchingworkflows/{workflowName}",
	}

	if input == nil {
		input = &GetMatchingWorkflowInput{}
	}

	output = &GetMatchingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMatchingWorkflow API operation for AWS EntityResolution.
//
// Returns the MatchingWorkflow with a given name, if it exists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetMatchingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetMatchingWorkflow
func (c *EntityResolution) GetMatchingWorkflow(input *GetMatchingWorkflowInput) (*GetMatchingWorkflowOutput, error) {
	req, out := c.GetMatchingWorkflowRequest(input)
	return out, req.Send()
}

// GetMatchingWorkflowWithContext is the same as GetMatchingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See GetMatchingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetMatchingWorkflowWithContext(ctx aws.Context, input *GetMatchingWorkflowInput, opts ...request.Option) (*GetMatchingWorkflowOutput, error) {
	req, out := c.GetMatchingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPolicyRequest method.
//	req, resp := client.GetPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetPolicy
func (c *EntityResolution) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{arn}",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS EntityResolution.
//
// Returns the resource-based policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetPolicy
func (c *EntityResolution) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSchemaMapping = "GetSchemaMapping"

// GetSchemaMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetSchemaMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSchemaMapping for more information on using the GetSchemaMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSchemaMappingRequest method.
//	req, resp := client.GetSchemaMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping
func (c *EntityResolution) GetSchemaMappingRequest(input *GetSchemaMappingInput) (req *request.Request, output *GetSchemaMappingOutput) {
	op := &request.Operation{
		Name:       opGetSchemaMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/schemas/{schemaName}",
	}

	if input == nil {
		input = &GetSchemaMappingInput{}
	}

	output = &GetSchemaMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSchemaMapping API operation for AWS EntityResolution.
//
// Returns the SchemaMapping of a given name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation GetSchemaMapping for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/GetSchemaMapping
func (c *EntityResolution) GetSchemaMapping(input *GetSchemaMappingInput) (*GetSchemaMappingOutput, error) {
	req, out := c.GetSchemaMappingRequest(input)
	return out, req.Send()
}

// GetSchemaMappingWithContext is the same as GetSchemaMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetSchemaMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) GetSchemaMappingWithContext(ctx aws.Context, input *GetSchemaMappingInput, opts ...request.Option) (*GetSchemaMappingOutput, error) {
	req, out := c.GetSchemaMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIdMappingJobs = "ListIdMappingJobs"

// ListIdMappingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListIdMappingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdMappingJobs for more information on using the ListIdMappingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdMappingJobsRequest method.
//	req, resp := client.ListIdMappingJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingJobs
func (c *EntityResolution) ListIdMappingJobsRequest(input *ListIdMappingJobsInput) (req *request.Request, output *ListIdMappingJobsOutput) {
	op := &request.Operation{
		Name:       opListIdMappingJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/idmappingworkflows/{workflowName}/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdMappingJobsInput{}
	}

	output = &ListIdMappingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdMappingJobs API operation for AWS EntityResolution.
//
// Lists all ID mapping jobs for a given workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListIdMappingJobs for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingJobs
func (c *EntityResolution) ListIdMappingJobs(input *ListIdMappingJobsInput) (*ListIdMappingJobsOutput, error) {
	req, out := c.ListIdMappingJobsRequest(input)
	return out, req.Send()
}

// ListIdMappingJobsWithContext is the same as ListIdMappingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdMappingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListIdMappingJobsWithContext(ctx aws.Context, input *ListIdMappingJobsInput, opts ...request.Option) (*ListIdMappingJobsOutput, error) {
	req, out := c.ListIdMappingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdMappingJobsPages iterates over the pages of a ListIdMappingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdMappingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdMappingJobs operation.
//	pageNum := 0
//	err := client.ListIdMappingJobsPages(params,
//	    func(page *entityresolution.ListIdMappingJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListIdMappingJobsPages(input *ListIdMappingJobsInput, fn func(*ListIdMappingJobsOutput, bool) bool) error {
	return c.ListIdMappingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdMappingJobsPagesWithContext same as ListIdMappingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListIdMappingJobsPagesWithContext(ctx aws.Context, input *ListIdMappingJobsInput, fn func(*ListIdMappingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdMappingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdMappingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdMappingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdMappingWorkflows = "ListIdMappingWorkflows"

// ListIdMappingWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the ListIdMappingWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdMappingWorkflows for more information on using the ListIdMappingWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdMappingWorkflowsRequest method.
//	req, resp := client.ListIdMappingWorkflowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingWorkflows
func (c *EntityResolution) ListIdMappingWorkflowsRequest(input *ListIdMappingWorkflowsInput) (req *request.Request, output *ListIdMappingWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListIdMappingWorkflows,
		HTTPMethod: "GET",
		HTTPPath:   "/idmappingworkflows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdMappingWorkflowsInput{}
	}

	output = &ListIdMappingWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdMappingWorkflows API operation for AWS EntityResolution.
//
// Returns a list of all the IdMappingWorkflows that have been created for an
// Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListIdMappingWorkflows for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdMappingWorkflows
func (c *EntityResolution) ListIdMappingWorkflows(input *ListIdMappingWorkflowsInput) (*ListIdMappingWorkflowsOutput, error) {
	req, out := c.ListIdMappingWorkflowsRequest(input)
	return out, req.Send()
}

// ListIdMappingWorkflowsWithContext is the same as ListIdMappingWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdMappingWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListIdMappingWorkflowsWithContext(ctx aws.Context, input *ListIdMappingWorkflowsInput, opts ...request.Option) (*ListIdMappingWorkflowsOutput, error) {
	req, out := c.ListIdMappingWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdMappingWorkflowsPages iterates over the pages of a ListIdMappingWorkflows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdMappingWorkflows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdMappingWorkflows operation.
//	pageNum := 0
//	err := client.ListIdMappingWorkflowsPages(params,
//	    func(page *entityresolution.ListIdMappingWorkflowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListIdMappingWorkflowsPages(input *ListIdMappingWorkflowsInput, fn func(*ListIdMappingWorkflowsOutput, bool) bool) error {
	return c.ListIdMappingWorkflowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdMappingWorkflowsPagesWithContext same as ListIdMappingWorkflowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListIdMappingWorkflowsPagesWithContext(ctx aws.Context, input *ListIdMappingWorkflowsInput, fn func(*ListIdMappingWorkflowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdMappingWorkflowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdMappingWorkflowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdMappingWorkflowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdNamespaces = "ListIdNamespaces"

// ListIdNamespacesRequest generates a "aws/request.Request" representing the
// client's request for the ListIdNamespaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdNamespaces for more information on using the ListIdNamespaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdNamespacesRequest method.
//	req, resp := client.ListIdNamespacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdNamespaces
func (c *EntityResolution) ListIdNamespacesRequest(input *ListIdNamespacesInput) (req *request.Request, output *ListIdNamespacesOutput) {
	op := &request.Operation{
		Name:       opListIdNamespaces,
		HTTPMethod: "GET",
		HTTPPath:   "/idnamespaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdNamespacesInput{}
	}

	output = &ListIdNamespacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdNamespaces API operation for AWS EntityResolution.
//
// Returns a list of all ID namespaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListIdNamespaces for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListIdNamespaces
func (c *EntityResolution) ListIdNamespaces(input *ListIdNamespacesInput) (*ListIdNamespacesOutput, error) {
	req, out := c.ListIdNamespacesRequest(input)
	return out, req.Send()
}

// ListIdNamespacesWithContext is the same as ListIdNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListIdNamespacesWithContext(ctx aws.Context, input *ListIdNamespacesInput, opts ...request.Option) (*ListIdNamespacesOutput, error) {
	req, out := c.ListIdNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdNamespacesPages iterates over the pages of a ListIdNamespaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdNamespaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdNamespaces operation.
//	pageNum := 0
//	err := client.ListIdNamespacesPages(params,
//	    func(page *entityresolution.ListIdNamespacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListIdNamespacesPages(input *ListIdNamespacesInput, fn func(*ListIdNamespacesOutput, bool) bool) error {
	return c.ListIdNamespacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdNamespacesPagesWithContext same as ListIdNamespacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListIdNamespacesPagesWithContext(ctx aws.Context, input *ListIdNamespacesInput, fn func(*ListIdNamespacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdNamespacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdNamespacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdNamespacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMatchingJobs = "ListMatchingJobs"

// ListMatchingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMatchingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMatchingJobs for more information on using the ListMatchingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMatchingJobsRequest method.
//	req, resp := client.ListMatchingJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs
func (c *EntityResolution) ListMatchingJobsRequest(input *ListMatchingJobsInput) (req *request.Request, output *ListMatchingJobsOutput) {
	op := &request.Operation{
		Name:       opListMatchingJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/matchingworkflows/{workflowName}/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMatchingJobsInput{}
	}

	output = &ListMatchingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMatchingJobs API operation for AWS EntityResolution.
//
// Lists all jobs for a given workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListMatchingJobs for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingJobs
func (c *EntityResolution) ListMatchingJobs(input *ListMatchingJobsInput) (*ListMatchingJobsOutput, error) {
	req, out := c.ListMatchingJobsRequest(input)
	return out, req.Send()
}

// ListMatchingJobsWithContext is the same as ListMatchingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMatchingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListMatchingJobsWithContext(ctx aws.Context, input *ListMatchingJobsInput, opts ...request.Option) (*ListMatchingJobsOutput, error) {
	req, out := c.ListMatchingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMatchingJobsPages iterates over the pages of a ListMatchingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMatchingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMatchingJobs operation.
//	pageNum := 0
//	err := client.ListMatchingJobsPages(params,
//	    func(page *entityresolution.ListMatchingJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListMatchingJobsPages(input *ListMatchingJobsInput, fn func(*ListMatchingJobsOutput, bool) bool) error {
	return c.ListMatchingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMatchingJobsPagesWithContext same as ListMatchingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListMatchingJobsPagesWithContext(ctx aws.Context, input *ListMatchingJobsInput, fn func(*ListMatchingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMatchingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMatchingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMatchingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMatchingWorkflows = "ListMatchingWorkflows"

// ListMatchingWorkflowsRequest generates a "aws/request.Request" representing the
// client's request for the ListMatchingWorkflows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMatchingWorkflows for more information on using the ListMatchingWorkflows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMatchingWorkflowsRequest method.
//	req, resp := client.ListMatchingWorkflowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows
func (c *EntityResolution) ListMatchingWorkflowsRequest(input *ListMatchingWorkflowsInput) (req *request.Request, output *ListMatchingWorkflowsOutput) {
	op := &request.Operation{
		Name:       opListMatchingWorkflows,
		HTTPMethod: "GET",
		HTTPPath:   "/matchingworkflows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMatchingWorkflowsInput{}
	}

	output = &ListMatchingWorkflowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMatchingWorkflows API operation for AWS EntityResolution.
//
// Returns a list of all the MatchingWorkflows that have been created for an
// Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListMatchingWorkflows for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListMatchingWorkflows
func (c *EntityResolution) ListMatchingWorkflows(input *ListMatchingWorkflowsInput) (*ListMatchingWorkflowsOutput, error) {
	req, out := c.ListMatchingWorkflowsRequest(input)
	return out, req.Send()
}

// ListMatchingWorkflowsWithContext is the same as ListMatchingWorkflows with the addition of
// the ability to pass a context and additional request options.
//
// See ListMatchingWorkflows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListMatchingWorkflowsWithContext(ctx aws.Context, input *ListMatchingWorkflowsInput, opts ...request.Option) (*ListMatchingWorkflowsOutput, error) {
	req, out := c.ListMatchingWorkflowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMatchingWorkflowsPages iterates over the pages of a ListMatchingWorkflows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMatchingWorkflows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMatchingWorkflows operation.
//	pageNum := 0
//	err := client.ListMatchingWorkflowsPages(params,
//	    func(page *entityresolution.ListMatchingWorkflowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListMatchingWorkflowsPages(input *ListMatchingWorkflowsInput, fn func(*ListMatchingWorkflowsOutput, bool) bool) error {
	return c.ListMatchingWorkflowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMatchingWorkflowsPagesWithContext same as ListMatchingWorkflowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListMatchingWorkflowsPagesWithContext(ctx aws.Context, input *ListMatchingWorkflowsInput, fn func(*ListMatchingWorkflowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMatchingWorkflowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMatchingWorkflowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMatchingWorkflowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProviderServices = "ListProviderServices"

// ListProviderServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListProviderServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProviderServices for more information on using the ListProviderServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProviderServicesRequest method.
//	req, resp := client.ListProviderServicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListProviderServices
func (c *EntityResolution) ListProviderServicesRequest(input *ListProviderServicesInput) (req *request.Request, output *ListProviderServicesOutput) {
	op := &request.Operation{
		Name:       opListProviderServices,
		HTTPMethod: "GET",
		HTTPPath:   "/providerservices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProviderServicesInput{}
	}

	output = &ListProviderServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProviderServices API operation for AWS EntityResolution.
//
// Returns a list of all the ProviderServices that are available in this Amazon
// Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListProviderServices for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListProviderServices
func (c *EntityResolution) ListProviderServices(input *ListProviderServicesInput) (*ListProviderServicesOutput, error) {
	req, out := c.ListProviderServicesRequest(input)
	return out, req.Send()
}

// ListProviderServicesWithContext is the same as ListProviderServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListProviderServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListProviderServicesWithContext(ctx aws.Context, input *ListProviderServicesInput, opts ...request.Option) (*ListProviderServicesOutput, error) {
	req, out := c.ListProviderServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProviderServicesPages iterates over the pages of a ListProviderServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProviderServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProviderServices operation.
//	pageNum := 0
//	err := client.ListProviderServicesPages(params,
//	    func(page *entityresolution.ListProviderServicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListProviderServicesPages(input *ListProviderServicesInput, fn func(*ListProviderServicesOutput, bool) bool) error {
	return c.ListProviderServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProviderServicesPagesWithContext same as ListProviderServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListProviderServicesPagesWithContext(ctx aws.Context, input *ListProviderServicesInput, fn func(*ListProviderServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProviderServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProviderServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProviderServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemaMappings = "ListSchemaMappings"

// ListSchemaMappingsRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemaMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemaMappings for more information on using the ListSchemaMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSchemaMappingsRequest method.
//	req, resp := client.ListSchemaMappingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings
func (c *EntityResolution) ListSchemaMappingsRequest(input *ListSchemaMappingsInput) (req *request.Request, output *ListSchemaMappingsOutput) {
	op := &request.Operation{
		Name:       opListSchemaMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/schemas",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemaMappingsInput{}
	}

	output = &ListSchemaMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemaMappings API operation for AWS EntityResolution.
//
// Returns a list of all the SchemaMappings that have been created for an Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListSchemaMappings for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListSchemaMappings
func (c *EntityResolution) ListSchemaMappings(input *ListSchemaMappingsInput) (*ListSchemaMappingsOutput, error) {
	req, out := c.ListSchemaMappingsRequest(input)
	return out, req.Send()
}

// ListSchemaMappingsWithContext is the same as ListSchemaMappings with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemaMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListSchemaMappingsWithContext(ctx aws.Context, input *ListSchemaMappingsInput, opts ...request.Option) (*ListSchemaMappingsOutput, error) {
	req, out := c.ListSchemaMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemaMappingsPages iterates over the pages of a ListSchemaMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemaMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSchemaMappings operation.
//	pageNum := 0
//	err := client.ListSchemaMappingsPages(params,
//	    func(page *entityresolution.ListSchemaMappingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EntityResolution) ListSchemaMappingsPages(input *ListSchemaMappingsInput, fn func(*ListSchemaMappingsOutput, bool) bool) error {
	return c.ListSchemaMappingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemaMappingsPagesWithContext same as ListSchemaMappingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListSchemaMappingsPagesWithContext(ctx aws.Context, input *ListSchemaMappingsInput, fn func(*ListSchemaMappingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemaMappingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemaMappingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemaMappingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource
func (c *EntityResolution) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS EntityResolution.
//
// Displays the tags associated with an Entity Resolution resource. In Entity
// Resolution, SchemaMapping, and MatchingWorkflow can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ListTagsForResource
func (c *EntityResolution) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPolicy = "PutPolicy"

// PutPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPolicy for more information on using the PutPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPolicyRequest method.
//	req, resp := client.PutPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/PutPolicy
func (c *EntityResolution) PutPolicyRequest(input *PutPolicyInput) (req *request.Request, output *PutPolicyOutput) {
	op := &request.Operation{
		Name:       opPutPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/policies/{arn}",
	}

	if input == nil {
		input = &PutPolicyInput{}
	}

	output = &PutPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutPolicy API operation for AWS EntityResolution.
//
// Updates the resource-based policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation PutPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/PutPolicy
func (c *EntityResolution) PutPolicy(input *PutPolicyInput) (*PutPolicyOutput, error) {
	req, out := c.PutPolicyRequest(input)
	return out, req.Send()
}

// PutPolicyWithContext is the same as PutPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) PutPolicyWithContext(ctx aws.Context, input *PutPolicyInput, opts ...request.Option) (*PutPolicyOutput, error) {
	req, out := c.PutPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartIdMappingJob = "StartIdMappingJob"

// StartIdMappingJobRequest generates a "aws/request.Request" representing the
// client's request for the StartIdMappingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartIdMappingJob for more information on using the StartIdMappingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartIdMappingJobRequest method.
//	req, resp := client.StartIdMappingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartIdMappingJob
func (c *EntityResolution) StartIdMappingJobRequest(input *StartIdMappingJobInput) (req *request.Request, output *StartIdMappingJobOutput) {
	op := &request.Operation{
		Name:       opStartIdMappingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/idmappingworkflows/{workflowName}/jobs",
	}

	if input == nil {
		input = &StartIdMappingJobInput{}
	}

	output = &StartIdMappingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartIdMappingJob API operation for AWS EntityResolution.
//
// Starts the IdMappingJob of a workflow. The workflow must have previously
// been created using the CreateIdMappingWorkflow endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation StartIdMappingJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartIdMappingJob
func (c *EntityResolution) StartIdMappingJob(input *StartIdMappingJobInput) (*StartIdMappingJobOutput, error) {
	req, out := c.StartIdMappingJobRequest(input)
	return out, req.Send()
}

// StartIdMappingJobWithContext is the same as StartIdMappingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartIdMappingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) StartIdMappingJobWithContext(ctx aws.Context, input *StartIdMappingJobInput, opts ...request.Option) (*StartIdMappingJobOutput, error) {
	req, out := c.StartIdMappingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMatchingJob = "StartMatchingJob"

// StartMatchingJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMatchingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMatchingJob for more information on using the StartMatchingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMatchingJobRequest method.
//	req, resp := client.StartMatchingJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob
func (c *EntityResolution) StartMatchingJobRequest(input *StartMatchingJobInput) (req *request.Request, output *StartMatchingJobOutput) {
	op := &request.Operation{
		Name:       opStartMatchingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/matchingworkflows/{workflowName}/jobs",
	}

	if input == nil {
		input = &StartMatchingJobInput{}
	}

	output = &StartMatchingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMatchingJob API operation for AWS EntityResolution.
//
// Starts the MatchingJob of a workflow. The workflow must have previously been
// created using the CreateMatchingWorkflow endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation StartMatchingJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ExceedsLimitException
//     The request was rejected because it attempted to create resources beyond
//     the current Entity Resolution account limits. The error message describes
//     the limit exceeded. HTTP Status Code: 402
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/StartMatchingJob
func (c *EntityResolution) StartMatchingJob(input *StartMatchingJobInput) (*StartMatchingJobOutput, error) {
	req, out := c.StartMatchingJobRequest(input)
	return out, req.Send()
}

// StartMatchingJobWithContext is the same as StartMatchingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMatchingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) StartMatchingJobWithContext(ctx aws.Context, input *StartMatchingJobInput, opts ...request.Option) (*StartMatchingJobOutput, error) {
	req, out := c.StartMatchingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource
func (c *EntityResolution) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS EntityResolution.
//
// Assigns one or more tags (key-value pairs) to the specified Entity Resolution
// resource. Tags can help you organize and categorize your resources. You can
// also use them to scope user permissions by granting a user permission to
// access or change only resources with certain tag values. In Entity Resolution,
// SchemaMapping and MatchingWorkflow can be tagged. Tags don't have any semantic
// meaning to Amazon Web Services and are interpreted strictly as strings of
// characters. You can use the TagResource action with a resource that already
// has tags. If you specify a new tag key, this tag is appended to the list
// of tags associated with the resource. If you specify a tag key that is already
// associated with the resource, the new tag value that you specify replaces
// the previous value for that tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/TagResource
func (c *EntityResolution) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource
func (c *EntityResolution) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS EntityResolution.
//
// Removes one or more tags from the specified Entity Resolution resource. In
// Entity Resolution, SchemaMapping, and MatchingWorkflow can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UntagResource
func (c *EntityResolution) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdMappingWorkflow = "UpdateIdMappingWorkflow"

// UpdateIdMappingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdMappingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdMappingWorkflow for more information on using the UpdateIdMappingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIdMappingWorkflowRequest method.
//	req, resp := client.UpdateIdMappingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdMappingWorkflow
func (c *EntityResolution) UpdateIdMappingWorkflowRequest(input *UpdateIdMappingWorkflowInput) (req *request.Request, output *UpdateIdMappingWorkflowOutput) {
	op := &request.Operation{
		Name:       opUpdateIdMappingWorkflow,
		HTTPMethod: "PUT",
		HTTPPath:   "/idmappingworkflows/{workflowName}",
	}

	if input == nil {
		input = &UpdateIdMappingWorkflowInput{}
	}

	output = &UpdateIdMappingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdMappingWorkflow API operation for AWS EntityResolution.
//
// Updates an existing IdMappingWorkflow. This method is identical to CreateIdMappingWorkflow,
// except it uses an HTTP PUT request instead of a POST request, and the IdMappingWorkflow
// must already exist for the method to succeed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation UpdateIdMappingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdMappingWorkflow
func (c *EntityResolution) UpdateIdMappingWorkflow(input *UpdateIdMappingWorkflowInput) (*UpdateIdMappingWorkflowOutput, error) {
	req, out := c.UpdateIdMappingWorkflowRequest(input)
	return out, req.Send()
}

// UpdateIdMappingWorkflowWithContext is the same as UpdateIdMappingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdMappingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) UpdateIdMappingWorkflowWithContext(ctx aws.Context, input *UpdateIdMappingWorkflowInput, opts ...request.Option) (*UpdateIdMappingWorkflowOutput, error) {
	req, out := c.UpdateIdMappingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdNamespace = "UpdateIdNamespace"

// UpdateIdNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdNamespace for more information on using the UpdateIdNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIdNamespaceRequest method.
//	req, resp := client.UpdateIdNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdNamespace
func (c *EntityResolution) UpdateIdNamespaceRequest(input *UpdateIdNamespaceInput) (req *request.Request, output *UpdateIdNamespaceOutput) {
	op := &request.Operation{
		Name:       opUpdateIdNamespace,
		HTTPMethod: "PUT",
		HTTPPath:   "/idnamespaces/{idNamespaceName}",
	}

	if input == nil {
		input = &UpdateIdNamespaceInput{}
	}

	output = &UpdateIdNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIdNamespace API operation for AWS EntityResolution.
//
// Updates an existing ID namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation UpdateIdNamespace for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateIdNamespace
func (c *EntityResolution) UpdateIdNamespace(input *UpdateIdNamespaceInput) (*UpdateIdNamespaceOutput, error) {
	req, out := c.UpdateIdNamespaceRequest(input)
	return out, req.Send()
}

// UpdateIdNamespaceWithContext is the same as UpdateIdNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) UpdateIdNamespaceWithContext(ctx aws.Context, input *UpdateIdNamespaceInput, opts ...request.Option) (*UpdateIdNamespaceOutput, error) {
	req, out := c.UpdateIdNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMatchingWorkflow = "UpdateMatchingWorkflow"

// UpdateMatchingWorkflowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMatchingWorkflow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMatchingWorkflow for more information on using the UpdateMatchingWorkflow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMatchingWorkflowRequest method.
//	req, resp := client.UpdateMatchingWorkflowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow
func (c *EntityResolution) UpdateMatchingWorkflowRequest(input *UpdateMatchingWorkflowInput) (req *request.Request, output *UpdateMatchingWorkflowOutput) {
	op := &request.Operation{
		Name:       opUpdateMatchingWorkflow,
		HTTPMethod: "PUT",
		HTTPPath:   "/matchingworkflows/{workflowName}",
	}

	if input == nil {
		input = &UpdateMatchingWorkflowInput{}
	}

	output = &UpdateMatchingWorkflowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMatchingWorkflow API operation for AWS EntityResolution.
//
// Updates an existing MatchingWorkflow. This method is identical to CreateMatchingWorkflow,
// except it uses an HTTP PUT request instead of a POST request, and the MatchingWorkflow
// must already exist for the method to succeed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation UpdateMatchingWorkflow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow
func (c *EntityResolution) UpdateMatchingWorkflow(input *UpdateMatchingWorkflowInput) (*UpdateMatchingWorkflowOutput, error) {
	req, out := c.UpdateMatchingWorkflowRequest(input)
	return out, req.Send()
}

// UpdateMatchingWorkflowWithContext is the same as UpdateMatchingWorkflow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMatchingWorkflow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) UpdateMatchingWorkflowWithContext(ctx aws.Context, input *UpdateMatchingWorkflowInput, opts ...request.Option) (*UpdateMatchingWorkflowOutput, error) {
	req, out := c.UpdateMatchingWorkflowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSchemaMapping = "UpdateSchemaMapping"

// UpdateSchemaMappingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSchemaMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSchemaMapping for more information on using the UpdateSchemaMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSchemaMappingRequest method.
//	req, resp := client.UpdateSchemaMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateSchemaMapping
func (c *EntityResolution) UpdateSchemaMappingRequest(input *UpdateSchemaMappingInput) (req *request.Request, output *UpdateSchemaMappingOutput) {
	op := &request.Operation{
		Name:       opUpdateSchemaMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/schemas/{schemaName}",
	}

	if input == nil {
		input = &UpdateSchemaMappingInput{}
	}

	output = &UpdateSchemaMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSchemaMapping API operation for AWS EntityResolution.
//
// Updates a schema mapping.
//
// A schema is immutable if it is being used by a workflow. Therefore, you can't
// update a schema mapping if it's associated with a workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS EntityResolution's
// API operation UpdateSchemaMapping for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling. HTTP Status Code: 429
//
//   - InternalServerException
//     This exception occurs when there is an internal failure in the Entity Resolution
//     service. HTTP Status Code: 500
//
//   - ResourceNotFoundException
//     The resource could not be found. HTTP Status Code: 404
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action. HTTP Status Code:
//     403
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource. Example: Workflow already exists, Schema already exists,
//     Workflow is currently running, etc. HTTP Status Code: 400
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Entity Resolution.
//     HTTP Status Code: 400
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateSchemaMapping
func (c *EntityResolution) UpdateSchemaMapping(input *UpdateSchemaMappingInput) (*UpdateSchemaMappingOutput, error) {
	req, out := c.UpdateSchemaMappingRequest(input)
	return out, req.Send()
}

// UpdateSchemaMappingWithContext is the same as UpdateSchemaMapping with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSchemaMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EntityResolution) UpdateSchemaMappingWithContext(ctx aws.Context, input *UpdateSchemaMappingInput, opts ...request.Option) (*UpdateSchemaMappingOutput, error) {
	req, out := c.UpdateSchemaMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action. HTTP Status Code:
// 403
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddPolicyStatementInput struct {
	_ struct{} `type:"structure"`

	// The action that the principal can use on the resource.
	//
	// For example, entityresolution:GetIdMappingJob, entityresolution:GetMatchingJob.
	//
	// Action is a required field
	Action []*string `locationName:"action" min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the resource that will be accessed by the
	// principal.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// A set of condition keys that you can use in key policies.
	Condition *string `locationName:"condition" min:"1" type:"string"`

	// Determines whether the permissions specified in the policy are to be allowed
	// (Allow) or denied (Deny).
	//
	// Effect is a required field
	Effect *string `locationName:"effect" type:"string" required:"true" enum:"StatementEffect"`

	// The Amazon Web Services service or Amazon Web Services account that can access
	// the resource defined as ARN.
	//
	// Principal is a required field
	Principal []*string `locationName:"principal" min:"1" type:"list" required:"true"`

	// A statement identifier that differentiates the statement from others in the
	// same policy.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"statementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddPolicyStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddPolicyStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddPolicyStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddPolicyStatementInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Action != nil && len(s.Action) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Action", 1))
	}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Condition != nil && len(*s.Condition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Condition", 1))
	}
	if s.Effect == nil {
		invalidParams.Add(request.NewErrParamRequired("Effect"))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Principal != nil && len(s.Principal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Principal", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AddPolicyStatementInput) SetAction(v []*string) *AddPolicyStatementInput {
	s.Action = v
	return s
}

// SetArn sets the Arn field's value.
func (s *AddPolicyStatementInput) SetArn(v string) *AddPolicyStatementInput {
	s.Arn = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *AddPolicyStatementInput) SetCondition(v string) *AddPolicyStatementInput {
	s.Condition = &v
	return s
}

// SetEffect sets the Effect field's value.
func (s *AddPolicyStatementInput) SetEffect(v string) *AddPolicyStatementInput {
	s.Effect = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AddPolicyStatementInput) SetPrincipal(v []*string) *AddPolicyStatementInput {
	s.Principal = v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *AddPolicyStatementInput) SetStatementId(v string) *AddPolicyStatementInput {
	s.StatementId = &v
	return s
}

type AddPolicyStatementOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that will be accessed by the
	// principal.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The resource-based policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// A unique identifier for the current revision of the policy.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddPolicyStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddPolicyStatementOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AddPolicyStatementOutput) SetArn(v string) *AddPolicyStatementOutput {
	s.Arn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *AddPolicyStatementOutput) SetPolicy(v string) *AddPolicyStatementOutput {
	s.Policy = &v
	return s
}

// SetToken sets the Token field's value.
func (s *AddPolicyStatementOutput) SetToken(v string) *AddPolicyStatementOutput {
	s.Token = &v
	return s
}

type BatchDeleteUniqueIdInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The input source for the batch delete unique ID operation.
	InputSource *string `location:"header" locationName:"inputSource" type:"string"`

	// The unique IDs to delete.
	//
	// UniqueIds is a required field
	UniqueIds []*string `location:"header" locationName:"uniqueIds" type:"list" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteUniqueIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteUniqueIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteUniqueIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteUniqueIdInput"}
	if s.UniqueIds == nil {
		invalidParams.Add(request.NewErrParamRequired("UniqueIds"))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSource sets the InputSource field's value.
func (s *BatchDeleteUniqueIdInput) SetInputSource(v string) *BatchDeleteUniqueIdInput {
	s.InputSource = &v
	return s
}

// SetUniqueIds sets the UniqueIds field's value.
func (s *BatchDeleteUniqueIdInput) SetUniqueIds(v []*string) *BatchDeleteUniqueIdInput {
	s.UniqueIds = v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *BatchDeleteUniqueIdInput) SetWorkflowName(v string) *BatchDeleteUniqueIdInput {
	s.WorkflowName = &v
	return s
}

type BatchDeleteUniqueIdOutput struct {
	_ struct{} `type:"structure"`

	// The unique IDs that were deleted.
	//
	// Deleted is a required field
	Deleted []*DeletedUniqueId `locationName:"deleted" type:"list" required:"true"`

	// The unique IDs that were disconnected.
	//
	// DisconnectedUniqueIds is a required field
	DisconnectedUniqueIds []*string `locationName:"disconnectedUniqueIds" type:"list" required:"true"`

	// The errors from deleting multiple unique IDs.
	//
	// Errors is a required field
	Errors []*DeleteUniqueIdError `locationName:"errors" type:"list" required:"true"`

	// The status of the batch delete unique ID operation.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DeleteUniqueIdStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteUniqueIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteUniqueIdOutput) GoString() string {
	return s.String()
}

// SetDeleted sets the Deleted field's value.
func (s *BatchDeleteUniqueIdOutput) SetDeleted(v []*DeletedUniqueId) *BatchDeleteUniqueIdOutput {
	s.Deleted = v
	return s
}

// SetDisconnectedUniqueIds sets the DisconnectedUniqueIds field's value.
func (s *BatchDeleteUniqueIdOutput) SetDisconnectedUniqueIds(v []*string) *BatchDeleteUniqueIdOutput {
	s.DisconnectedUniqueIds = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteUniqueIdOutput) SetErrors(v []*DeleteUniqueIdError) *BatchDeleteUniqueIdOutput {
	s.Errors = v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchDeleteUniqueIdOutput) SetStatus(v string) *BatchDeleteUniqueIdOutput {
	s.Status = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource. Example: Workflow already exists, Schema already exists,
// Workflow is currently running, etc. HTTP Status Code: 400
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateIdMappingWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines the idMappingType and the providerProperties.
	//
	// IdMappingTechniques is a required field
	IdMappingTechniques *IdMappingTechniques `locationName:"idMappingTechniques" type:"structure" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*IdMappingWorkflowInputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of IdMappingWorkflowOutputSource objects, each of which contains fields
	// OutputS3Path and Output.
	OutputSourceConfig []*IdMappingWorkflowOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name of the workflow. There can't be multiple IdMappingWorkflows with
	// the same name.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdMappingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdMappingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIdMappingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIdMappingWorkflowInput"}
	if s.IdMappingTechniques == nil {
		invalidParams.Add(request.NewErrParamRequired("IdMappingTechniques"))
	}
	if s.InputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceConfig"))
	}
	if s.InputSourceConfig != nil && len(s.InputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSourceConfig", 1))
	}
	if s.OutputSourceConfig != nil && len(s.OutputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputSourceConfig", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}
	if s.IdMappingTechniques != nil {
		if err := s.IdMappingTechniques.Validate(); err != nil {
			invalidParams.AddNested("IdMappingTechniques", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSourceConfig != nil {
		for i, v := range s.InputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputSourceConfig != nil {
		for i, v := range s.OutputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateIdMappingWorkflowInput) SetDescription(v string) *CreateIdMappingWorkflowInput {
	s.Description = &v
	return s
}

// SetIdMappingTechniques sets the IdMappingTechniques field's value.
func (s *CreateIdMappingWorkflowInput) SetIdMappingTechniques(v *IdMappingTechniques) *CreateIdMappingWorkflowInput {
	s.IdMappingTechniques = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *CreateIdMappingWorkflowInput) SetInputSourceConfig(v []*IdMappingWorkflowInputSource) *CreateIdMappingWorkflowInput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *CreateIdMappingWorkflowInput) SetOutputSourceConfig(v []*IdMappingWorkflowOutputSource) *CreateIdMappingWorkflowInput {
	s.OutputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateIdMappingWorkflowInput) SetRoleArn(v string) *CreateIdMappingWorkflowInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIdMappingWorkflowInput) SetTags(v map[string]*string) *CreateIdMappingWorkflowInput {
	s.Tags = v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *CreateIdMappingWorkflowInput) SetWorkflowName(v string) *CreateIdMappingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type CreateIdMappingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines the idMappingType and the providerProperties.
	//
	// IdMappingTechniques is a required field
	IdMappingTechniques *IdMappingTechniques `locationName:"idMappingTechniques" type:"structure" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*IdMappingWorkflowInputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of IdMappingWorkflowOutputSource objects, each of which contains fields
	// OutputS3Path and Output.
	OutputSourceConfig []*IdMappingWorkflowOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the IDMappingWorkflow.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdMappingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdMappingWorkflowOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateIdMappingWorkflowOutput) SetDescription(v string) *CreateIdMappingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIdMappingTechniques sets the IdMappingTechniques field's value.
func (s *CreateIdMappingWorkflowOutput) SetIdMappingTechniques(v *IdMappingTechniques) *CreateIdMappingWorkflowOutput {
	s.IdMappingTechniques = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *CreateIdMappingWorkflowOutput) SetInputSourceConfig(v []*IdMappingWorkflowInputSource) *CreateIdMappingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *CreateIdMappingWorkflowOutput) SetOutputSourceConfig(v []*IdMappingWorkflowOutputSource) *CreateIdMappingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateIdMappingWorkflowOutput) SetRoleArn(v string) *CreateIdMappingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *CreateIdMappingWorkflowOutput) SetWorkflowArn(v string) *CreateIdMappingWorkflowOutput {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *CreateIdMappingWorkflowOutput) SetWorkflowName(v string) *CreateIdMappingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

type CreateIdNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The description of the ID namespace.
	Description *string `locationName:"description" type:"string"`

	// Determines the properties of IdMappingWorflow where this IdNamespace can
	// be used as a Source or a Target.
	IdMappingWorkflowProperties []*IdNamespaceIdMappingWorkflowProperties `locationName:"idMappingWorkflowProperties" min:"1" type:"list"`

	// The name of the ID namespace.
	//
	// IdNamespaceName is a required field
	IdNamespaceName *string `locationName:"idNamespaceName" min:"1" type:"string" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	InputSourceConfig []*IdNamespaceInputSource `locationName:"inputSourceConfig" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access the resources defined in this IdNamespace on your behalf
	// as part of the workflow run.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of ID namespace. There are two types: SOURCE and TARGET.
	//
	// The SOURCE contains configurations for sourceId data that will be processed
	// in an ID mapping workflow.
	//
	// The TARGET contains a configuration of targetId to which all sourceIds will
	// resolve to.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"IdNamespaceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIdNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIdNamespaceInput"}
	if s.IdMappingWorkflowProperties != nil && len(s.IdMappingWorkflowProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdMappingWorkflowProperties", 1))
	}
	if s.IdNamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdNamespaceName"))
	}
	if s.IdNamespaceName != nil && len(*s.IdNamespaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdNamespaceName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.IdMappingWorkflowProperties != nil {
		for i, v := range s.IdMappingWorkflowProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IdMappingWorkflowProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InputSourceConfig != nil {
		for i, v := range s.InputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateIdNamespaceInput) SetDescription(v string) *CreateIdNamespaceInput {
	s.Description = &v
	return s
}

// SetIdMappingWorkflowProperties sets the IdMappingWorkflowProperties field's value.
func (s *CreateIdNamespaceInput) SetIdMappingWorkflowProperties(v []*IdNamespaceIdMappingWorkflowProperties) *CreateIdNamespaceInput {
	s.IdMappingWorkflowProperties = v
	return s
}

// SetIdNamespaceName sets the IdNamespaceName field's value.
func (s *CreateIdNamespaceInput) SetIdNamespaceName(v string) *CreateIdNamespaceInput {
	s.IdNamespaceName = &v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *CreateIdNamespaceInput) SetInputSourceConfig(v []*IdNamespaceInputSource) *CreateIdNamespaceInput {
	s.InputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateIdNamespaceInput) SetRoleArn(v string) *CreateIdNamespaceInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIdNamespaceInput) SetTags(v map[string]*string) *CreateIdNamespaceInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateIdNamespaceInput) SetType(v string) *CreateIdNamespaceInput {
	s.Type = &v
	return s
}

type CreateIdNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the ID namespace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The description of the ID namespace.
	Description *string `locationName:"description" type:"string"`

	// Determines the properties of IdMappingWorkflow where this IdNamespace can
	// be used as a Source or a Target.
	IdMappingWorkflowProperties []*IdNamespaceIdMappingWorkflowProperties `locationName:"idMappingWorkflowProperties" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the ID namespace.
	//
	// IdNamespaceArn is a required field
	IdNamespaceArn *string `locationName:"idNamespaceArn" type:"string" required:"true"`

	// The name of the ID namespace.
	//
	// IdNamespaceName is a required field
	IdNamespaceName *string `locationName:"idNamespaceName" min:"1" type:"string" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	InputSourceConfig []*IdNamespaceInputSource `locationName:"inputSourceConfig" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access the resources defined in inputSourceConfig on your behalf
	// as part of the workflow run.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of ID namespace. There are two types: SOURCE and TARGET.
	//
	// The SOURCE contains configurations for sourceId data that will be processed
	// in an ID mapping workflow.
	//
	// The TARGET contains a configuration of targetId to which all sourceIds will
	// resolve to.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"IdNamespaceType"`

	// The timestamp of when the ID namespace was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIdNamespaceOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateIdNamespaceOutput) SetCreatedAt(v time.Time) *CreateIdNamespaceOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIdNamespaceOutput) SetDescription(v string) *CreateIdNamespaceOutput {
	s.Description = &v
	return s
}

// SetIdMappingWorkflowProperties sets the IdMappingWorkflowProperties field's value.
func (s *CreateIdNamespaceOutput) SetIdMappingWorkflowProperties(v []*IdNamespaceIdMappingWorkflowProperties) *CreateIdNamespaceOutput {
	s.IdMappingWorkflowProperties = v
	return s
}

// SetIdNamespaceArn sets the IdNamespaceArn field's value.
func (s *CreateIdNamespaceOutput) SetIdNamespaceArn(v string) *CreateIdNamespaceOutput {
	s.IdNamespaceArn = &v
	return s
}

// SetIdNamespaceName sets the IdNamespaceName field's value.
func (s *CreateIdNamespaceOutput) SetIdNamespaceName(v string) *CreateIdNamespaceOutput {
	s.IdNamespaceName = &v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *CreateIdNamespaceOutput) SetInputSourceConfig(v []*IdNamespaceInputSource) *CreateIdNamespaceOutput {
	s.InputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateIdNamespaceOutput) SetRoleArn(v string) *CreateIdNamespaceOutput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIdNamespaceOutput) SetTags(v map[string]*string) *CreateIdNamespaceOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateIdNamespaceOutput) SetType(v string) *CreateIdNamespaceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateIdNamespaceOutput) SetUpdatedAt(v time.Time) *CreateIdNamespaceOutput {
	s.UpdatedAt = &v
	return s
}

type CreateMatchingWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties.
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The name of the workflow. There can't be multiple MatchingWorkflows with
	// the same name.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMatchingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMatchingWorkflowInput"}
	if s.InputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceConfig"))
	}
	if s.InputSourceConfig != nil && len(s.InputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSourceConfig", 1))
	}
	if s.OutputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSourceConfig"))
	}
	if s.OutputSourceConfig != nil && len(s.OutputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputSourceConfig", 1))
	}
	if s.ResolutionTechniques == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolutionTechniques"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}
	if s.InputSourceConfig != nil {
		for i, v := range s.InputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputSourceConfig != nil {
		for i, v := range s.OutputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResolutionTechniques != nil {
		if err := s.ResolutionTechniques.Validate(); err != nil {
			invalidParams.AddNested("ResolutionTechniques", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateMatchingWorkflowInput) SetDescription(v string) *CreateMatchingWorkflowInput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *CreateMatchingWorkflowInput) SetIncrementalRunConfig(v *IncrementalRunConfig) *CreateMatchingWorkflowInput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *CreateMatchingWorkflowInput) SetInputSourceConfig(v []*InputSource) *CreateMatchingWorkflowInput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *CreateMatchingWorkflowInput) SetOutputSourceConfig(v []*OutputSource) *CreateMatchingWorkflowInput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *CreateMatchingWorkflowInput) SetResolutionTechniques(v *ResolutionTechniques) *CreateMatchingWorkflowInput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateMatchingWorkflowInput) SetRoleArn(v string) *CreateMatchingWorkflowInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMatchingWorkflowInput) SetTags(v map[string]*string) *CreateMatchingWorkflowInput {
	s.Tags = v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *CreateMatchingWorkflowInput) SetWorkflowName(v string) *CreateMatchingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type CreateMatchingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties.
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the MatchingWorkflow.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchingWorkflowOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateMatchingWorkflowOutput) SetDescription(v string) *CreateMatchingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *CreateMatchingWorkflowOutput) SetIncrementalRunConfig(v *IncrementalRunConfig) *CreateMatchingWorkflowOutput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *CreateMatchingWorkflowOutput) SetInputSourceConfig(v []*InputSource) *CreateMatchingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *CreateMatchingWorkflowOutput) SetOutputSourceConfig(v []*OutputSource) *CreateMatchingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *CreateMatchingWorkflowOutput) SetResolutionTechniques(v *ResolutionTechniques) *CreateMatchingWorkflowOutput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateMatchingWorkflowOutput) SetRoleArn(v string) *CreateMatchingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *CreateMatchingWorkflowOutput) SetWorkflowArn(v string) *CreateMatchingWorkflowOutput {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *CreateMatchingWorkflowOutput) SetWorkflowName(v string) *CreateMatchingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

type CreateSchemaMappingInput struct {
	_ struct{} `type:"structure"`

	// A description of the schema.
	Description *string `locationName:"description" type:"string"`

	// A list of MappedInputFields. Each MappedInputField corresponds to a column
	// the source data table, and contains column name plus additional information
	// that Entity Resolution uses for matching.
	//
	// MappedInputFields is a required field
	MappedInputFields []*SchemaInputAttribute `locationName:"mappedInputFields" min:"2" type:"list" required:"true"`

	// The name of the schema. There can't be multiple SchemaMappings with the same
	// name.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchemaMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSchemaMappingInput"}
	if s.MappedInputFields == nil {
		invalidParams.Add(request.NewErrParamRequired("MappedInputFields"))
	}
	if s.MappedInputFields != nil && len(s.MappedInputFields) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MappedInputFields", 2))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}
	if s.MappedInputFields != nil {
		for i, v := range s.MappedInputFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MappedInputFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSchemaMappingInput) SetDescription(v string) *CreateSchemaMappingInput {
	s.Description = &v
	return s
}

// SetMappedInputFields sets the MappedInputFields field's value.
func (s *CreateSchemaMappingInput) SetMappedInputFields(v []*SchemaInputAttribute) *CreateSchemaMappingInput {
	s.MappedInputFields = v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *CreateSchemaMappingInput) SetSchemaName(v string) *CreateSchemaMappingInput {
	s.SchemaName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSchemaMappingInput) SetTags(v map[string]*string) *CreateSchemaMappingInput {
	s.Tags = v
	return s
}

type CreateSchemaMappingOutput struct {
	_ struct{} `type:"structure"`

	// A description of the schema.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// A list of MappedInputFields. Each MappedInputField corresponds to a column
	// the source data table, and contains column name plus additional information
	// that Entity Resolution uses for matching.
	//
	// MappedInputFields is a required field
	MappedInputFields []*SchemaInputAttribute `locationName:"mappedInputFields" min:"2" type:"list" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the SchemaMapping.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`

	// The name of the schema.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSchemaMappingOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateSchemaMappingOutput) SetDescription(v string) *CreateSchemaMappingOutput {
	s.Description = &v
	return s
}

// SetMappedInputFields sets the MappedInputFields field's value.
func (s *CreateSchemaMappingOutput) SetMappedInputFields(v []*SchemaInputAttribute) *CreateSchemaMappingOutput {
	s.MappedInputFields = v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *CreateSchemaMappingOutput) SetSchemaArn(v string) *CreateSchemaMappingOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *CreateSchemaMappingOutput) SetSchemaName(v string) *CreateSchemaMappingOutput {
	s.SchemaName = &v
	return s
}

type DeleteIdMappingWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the workflow to be deleted.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdMappingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdMappingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdMappingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdMappingWorkflowInput"}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *DeleteIdMappingWorkflowInput) SetWorkflowName(v string) *DeleteIdMappingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type DeleteIdMappingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A successful operation message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdMappingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdMappingWorkflowOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteIdMappingWorkflowOutput) SetMessage(v string) *DeleteIdMappingWorkflowOutput {
	s.Message = &v
	return s
}

type DeleteIdNamespaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ID namespace.
	//
	// IdNamespaceName is a required field
	IdNamespaceName *string `location:"uri" locationName:"idNamespaceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdNamespaceInput"}
	if s.IdNamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdNamespaceName"))
	}
	if s.IdNamespaceName != nil && len(*s.IdNamespaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdNamespaceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdNamespaceName sets the IdNamespaceName field's value.
func (s *DeleteIdNamespaceInput) SetIdNamespaceName(v string) *DeleteIdNamespaceInput {
	s.IdNamespaceName = &v
	return s
}

type DeleteIdNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A successful operation message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIdNamespaceOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteIdNamespaceOutput) SetMessage(v string) *DeleteIdNamespaceOutput {
	s.Message = &v
	return s
}

type DeleteMatchingWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the workflow to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMatchingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMatchingWorkflowInput"}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *DeleteMatchingWorkflowInput) SetWorkflowName(v string) *DeleteMatchingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type DeleteMatchingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A successful operation message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchingWorkflowOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteMatchingWorkflowOutput) SetMessage(v string) *DeleteMatchingWorkflowOutput {
	s.Message = &v
	return s
}

type DeletePolicyStatementInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource for which the policy need to be deleted.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// A statement identifier that differentiates the statement from others in the
	// same policy.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"statementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyStatementInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeletePolicyStatementInput) SetArn(v string) *DeletePolicyStatementInput {
	s.Arn = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *DeletePolicyStatementInput) SetStatementId(v string) *DeletePolicyStatementInput {
	s.StatementId = &v
	return s
}

type DeletePolicyStatementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource for which the policy need to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The resource-based policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// A unique identifier for the deleted policy.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyStatementOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeletePolicyStatementOutput) SetArn(v string) *DeletePolicyStatementOutput {
	s.Arn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *DeletePolicyStatementOutput) SetPolicy(v string) *DeletePolicyStatementOutput {
	s.Policy = &v
	return s
}

// SetToken sets the Token field's value.
func (s *DeletePolicyStatementOutput) SetToken(v string) *DeletePolicyStatementOutput {
	s.Token = &v
	return s
}

type DeleteSchemaMappingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the schema to delete.
	//
	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchemaMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSchemaMappingInput"}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaName sets the SchemaName field's value.
func (s *DeleteSchemaMappingInput) SetSchemaName(v string) *DeleteSchemaMappingInput {
	s.SchemaName = &v
	return s
}

type DeleteSchemaMappingOutput struct {
	_ struct{} `type:"structure"`

	// A successful operation message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSchemaMappingOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteSchemaMappingOutput) SetMessage(v string) *DeleteSchemaMappingOutput {
	s.Message = &v
	return s
}

// The Delete Unique Id error.
type DeleteUniqueIdError struct {
	_ struct{} `type:"structure"`

	// The error type for the batch delete unique ID operation.
	//
	// ErrorType is a required field
	ErrorType *string `locationName:"errorType" type:"string" required:"true" enum:"DeleteUniqueIdErrorType"`

	// The unique ID that could not be deleted.
	//
	// UniqueId is a required field
	UniqueId *string `locationName:"uniqueId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUniqueIdError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUniqueIdError) GoString() string {
	return s.String()
}

// SetErrorType sets the ErrorType field's value.
func (s *DeleteUniqueIdError) SetErrorType(v string) *DeleteUniqueIdError {
	s.ErrorType = &v
	return s
}

// SetUniqueId sets the UniqueId field's value.
func (s *DeleteUniqueIdError) SetUniqueId(v string) *DeleteUniqueIdError {
	s.UniqueId = &v
	return s
}

// The deleted unique ID.
type DeletedUniqueId struct {
	_ struct{} `type:"structure"`

	// The unique ID of the deleted item.
	//
	// UniqueId is a required field
	UniqueId *string `locationName:"uniqueId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletedUniqueId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletedUniqueId) GoString() string {
	return s.String()
}

// SetUniqueId sets the UniqueId field's value.
func (s *DeletedUniqueId) SetUniqueId(v string) *DeletedUniqueId {
	s.UniqueId = &v
	return s
}

// An object containing an error message, if there was an error.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error message from the job, if there is one.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetails) SetErrorMessage(v string) *ErrorDetails {
	s.ErrorMessage = &v
	return s
}

// The request was rejected because it attempted to create resources beyond
// the current Entity Resolution account limits. The error message describes
// the limit exceeded. HTTP Status Code: 402
type ExceedsLimitException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The name of the quota that has been breached.
	QuotaName *string `locationName:"quotaName" type:"string"`

	// The current quota value for the customers.
	QuotaValue *int64 `locationName:"quotaValue" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExceedsLimitException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExceedsLimitException) GoString() string {
	return s.String()
}

func newErrorExceedsLimitException(v protocol.ResponseMetadata) error {
	return &ExceedsLimitException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExceedsLimitException) Code() string {
	return "ExceedsLimitException"
}

// Message returns the exception's message.
func (s *ExceedsLimitException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExceedsLimitException) OrigErr() error {
	return nil
}

func (s *ExceedsLimitException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExceedsLimitException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExceedsLimitException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetIdMappingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdMappingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdMappingJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetIdMappingJobInput) SetJobId(v string) *GetIdMappingJobInput {
	s.JobId = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetIdMappingJobInput) SetWorkflowName(v string) *GetIdMappingJobInput {
	s.WorkflowName = &v
	return s
}

type GetIdMappingJobOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the job has finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// An object containing an error message, if there was an error.
	ErrorDetails *ErrorDetails `locationName:"errorDetails" type:"structure"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// Metrics associated with the execution, specifically total records processed,
	// unique IDs generated, and records the execution skipped.
	Metrics *IdMappingJobMetrics `locationName:"metrics" type:"structure"`

	// A list of OutputSource objects.
	OutputSourceConfig []*IdMappingJobOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`

	// The time at which the job was started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The current status of the job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingJobOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetIdMappingJobOutput) SetEndTime(v time.Time) *GetIdMappingJobOutput {
	s.EndTime = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *GetIdMappingJobOutput) SetErrorDetails(v *ErrorDetails) *GetIdMappingJobOutput {
	s.ErrorDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetIdMappingJobOutput) SetJobId(v string) *GetIdMappingJobOutput {
	s.JobId = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetIdMappingJobOutput) SetMetrics(v *IdMappingJobMetrics) *GetIdMappingJobOutput {
	s.Metrics = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *GetIdMappingJobOutput) SetOutputSourceConfig(v []*IdMappingJobOutputSource) *GetIdMappingJobOutput {
	s.OutputSourceConfig = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetIdMappingJobOutput) SetStartTime(v time.Time) *GetIdMappingJobOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetIdMappingJobOutput) SetStatus(v string) *GetIdMappingJobOutput {
	s.Status = &v
	return s
}

type GetIdMappingWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdMappingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdMappingWorkflowInput"}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetIdMappingWorkflowInput) SetWorkflowName(v string) *GetIdMappingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type GetIdMappingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the workflow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines the idMappingType and the providerProperties.
	//
	// IdMappingTechniques is a required field
	IdMappingTechniques *IdMappingTechniques `locationName:"idMappingTechniques" type:"structure" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*IdMappingWorkflowInputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path
	// and KMSArn.
	OutputSourceConfig []*IdMappingWorkflowOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access Amazon Web Services resources on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The timestamp of when the workflow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the IdMappingWorkflow .
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdMappingWorkflowOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetIdMappingWorkflowOutput) SetCreatedAt(v time.Time) *GetIdMappingWorkflowOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetIdMappingWorkflowOutput) SetDescription(v string) *GetIdMappingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIdMappingTechniques sets the IdMappingTechniques field's value.
func (s *GetIdMappingWorkflowOutput) SetIdMappingTechniques(v *IdMappingTechniques) *GetIdMappingWorkflowOutput {
	s.IdMappingTechniques = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *GetIdMappingWorkflowOutput) SetInputSourceConfig(v []*IdMappingWorkflowInputSource) *GetIdMappingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *GetIdMappingWorkflowOutput) SetOutputSourceConfig(v []*IdMappingWorkflowOutputSource) *GetIdMappingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetIdMappingWorkflowOutput) SetRoleArn(v string) *GetIdMappingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetIdMappingWorkflowOutput) SetTags(v map[string]*string) *GetIdMappingWorkflowOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetIdMappingWorkflowOutput) SetUpdatedAt(v time.Time) *GetIdMappingWorkflowOutput {
	s.UpdatedAt = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *GetIdMappingWorkflowOutput) SetWorkflowArn(v string) *GetIdMappingWorkflowOutput {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetIdMappingWorkflowOutput) SetWorkflowName(v string) *GetIdMappingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

type GetIdNamespaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the ID namespace.
	//
	// IdNamespaceName is a required field
	IdNamespaceName *string `location:"uri" locationName:"idNamespaceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdNamespaceInput"}
	if s.IdNamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdNamespaceName"))
	}
	if s.IdNamespaceName != nil && len(*s.IdNamespaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdNamespaceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdNamespaceName sets the IdNamespaceName field's value.
func (s *GetIdNamespaceInput) SetIdNamespaceName(v string) *GetIdNamespaceInput {
	s.IdNamespaceName = &v
	return s
}

type GetIdNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the ID namespace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The description of the ID namespace.
	Description *string `locationName:"description" type:"string"`

	// Determines the properties of IdMappingWorkflow where this IdNamespace can
	// be used as a Source or a Target.
	IdMappingWorkflowProperties []*IdNamespaceIdMappingWorkflowProperties `locationName:"idMappingWorkflowProperties" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the ID namespace.
	//
	// IdNamespaceArn is a required field
	IdNamespaceArn *string `locationName:"idNamespaceArn" type:"string" required:"true"`

	// The name of the ID namespace.
	//
	// IdNamespaceName is a required field
	IdNamespaceName *string `locationName:"idNamespaceName" min:"1" type:"string" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	InputSourceConfig []*IdNamespaceInputSource `locationName:"inputSourceConfig" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access the resources defined in this IdNamespace on your behalf
	// as part of a workflow run.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of ID namespace. There are two types: SOURCE and TARGET.
	//
	// The SOURCE contains configurations for sourceId data that will be processed
	// in an ID mapping workflow.
	//
	// The TARGET contains a configuration of targetId to which all sourceIds will
	// resolve to.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"IdNamespaceType"`

	// The timestamp of when the ID namespace was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIdNamespaceOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetIdNamespaceOutput) SetCreatedAt(v time.Time) *GetIdNamespaceOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetIdNamespaceOutput) SetDescription(v string) *GetIdNamespaceOutput {
	s.Description = &v
	return s
}

// SetIdMappingWorkflowProperties sets the IdMappingWorkflowProperties field's value.
func (s *GetIdNamespaceOutput) SetIdMappingWorkflowProperties(v []*IdNamespaceIdMappingWorkflowProperties) *GetIdNamespaceOutput {
	s.IdMappingWorkflowProperties = v
	return s
}

// SetIdNamespaceArn sets the IdNamespaceArn field's value.
func (s *GetIdNamespaceOutput) SetIdNamespaceArn(v string) *GetIdNamespaceOutput {
	s.IdNamespaceArn = &v
	return s
}

// SetIdNamespaceName sets the IdNamespaceName field's value.
func (s *GetIdNamespaceOutput) SetIdNamespaceName(v string) *GetIdNamespaceOutput {
	s.IdNamespaceName = &v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *GetIdNamespaceOutput) SetInputSourceConfig(v []*IdNamespaceInputSource) *GetIdNamespaceOutput {
	s.InputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetIdNamespaceOutput) SetRoleArn(v string) *GetIdNamespaceOutput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetIdNamespaceOutput) SetTags(v map[string]*string) *GetIdNamespaceOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *GetIdNamespaceOutput) SetType(v string) *GetIdNamespaceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetIdNamespaceOutput) SetUpdatedAt(v time.Time) *GetIdNamespaceOutput {
	s.UpdatedAt = &v
	return s
}

type GetMatchIdInput struct {
	_ struct{} `type:"structure"`

	// Normalizes the attributes defined in the schema in the input data. For example,
	// if an attribute has an AttributeType of PHONE_NUMBER, and the data in the
	// input table is in a format of 1234567890, Entity Resolution will normalize
	// this field in the output to (123)-456-7890.
	ApplyNormalization *bool `locationName:"applyNormalization" type:"boolean"`

	// The record to fetch the Match ID for.
	//
	// Record is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetMatchIdInput's
	// String and GoString methods.
	//
	// Record is a required field
	Record map[string]*string `locationName:"record" type:"map" required:"true" sensitive:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMatchIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMatchIdInput"}
	if s.Record == nil {
		invalidParams.Add(request.NewErrParamRequired("Record"))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyNormalization sets the ApplyNormalization field's value.
func (s *GetMatchIdInput) SetApplyNormalization(v bool) *GetMatchIdInput {
	s.ApplyNormalization = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *GetMatchIdInput) SetRecord(v map[string]*string) *GetMatchIdInput {
	s.Record = v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetMatchIdInput) SetWorkflowName(v string) *GetMatchIdInput {
	s.WorkflowName = &v
	return s
}

type GetMatchIdOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifiers for this group of match records.
	MatchId *string `locationName:"matchId" type:"string"`

	// The rule the record matched on.
	MatchRule *string `locationName:"matchRule" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchIdOutput) GoString() string {
	return s.String()
}

// SetMatchId sets the MatchId field's value.
func (s *GetMatchIdOutput) SetMatchId(v string) *GetMatchIdOutput {
	s.MatchId = &v
	return s
}

// SetMatchRule sets the MatchRule field's value.
func (s *GetMatchIdOutput) SetMatchRule(v string) *GetMatchIdOutput {
	s.MatchRule = &v
	return s
}

type GetMatchingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMatchingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMatchingJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetMatchingJobInput) SetJobId(v string) *GetMatchingJobInput {
	s.JobId = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetMatchingJobInput) SetWorkflowName(v string) *GetMatchingJobInput {
	s.WorkflowName = &v
	return s
}

type GetMatchingJobOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the job has finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// An object containing an error message, if there was an error.
	ErrorDetails *ErrorDetails `locationName:"errorDetails" type:"structure"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// Metrics associated with the execution, specifically total records processed,
	// unique IDs generated, and records the execution skipped.
	Metrics *JobMetrics `locationName:"metrics" type:"structure"`

	// A list of OutputSource objects.
	OutputSourceConfig []*JobOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`

	// The time at which the job was started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The current status of the job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingJobOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetMatchingJobOutput) SetEndTime(v time.Time) *GetMatchingJobOutput {
	s.EndTime = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *GetMatchingJobOutput) SetErrorDetails(v *ErrorDetails) *GetMatchingJobOutput {
	s.ErrorDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetMatchingJobOutput) SetJobId(v string) *GetMatchingJobOutput {
	s.JobId = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetMatchingJobOutput) SetMetrics(v *JobMetrics) *GetMatchingJobOutput {
	s.Metrics = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *GetMatchingJobOutput) SetOutputSourceConfig(v []*JobOutputSource) *GetMatchingJobOutput {
	s.OutputSourceConfig = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMatchingJobOutput) SetStartTime(v time.Time) *GetMatchingJobOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMatchingJobOutput) SetStatus(v string) *GetMatchingJobOutput {
	s.Status = &v
	return s
}

type GetMatchingWorkflowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMatchingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMatchingWorkflowInput"}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetMatchingWorkflowInput) SetWorkflowName(v string) *GetMatchingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type GetMatchingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the workflow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties.
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access Amazon Web Services resources on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The timestamp of when the workflow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the MatchingWorkflow.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMatchingWorkflowOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetMatchingWorkflowOutput) SetCreatedAt(v time.Time) *GetMatchingWorkflowOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetMatchingWorkflowOutput) SetDescription(v string) *GetMatchingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *GetMatchingWorkflowOutput) SetIncrementalRunConfig(v *IncrementalRunConfig) *GetMatchingWorkflowOutput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *GetMatchingWorkflowOutput) SetInputSourceConfig(v []*InputSource) *GetMatchingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *GetMatchingWorkflowOutput) SetOutputSourceConfig(v []*OutputSource) *GetMatchingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *GetMatchingWorkflowOutput) SetResolutionTechniques(v *ResolutionTechniques) *GetMatchingWorkflowOutput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetMatchingWorkflowOutput) SetRoleArn(v string) *GetMatchingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetMatchingWorkflowOutput) SetTags(v map[string]*string) *GetMatchingWorkflowOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetMatchingWorkflowOutput) SetUpdatedAt(v time.Time) *GetMatchingWorkflowOutput {
	s.UpdatedAt = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *GetMatchingWorkflowOutput) SetWorkflowArn(v string) *GetMatchingWorkflowOutput {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *GetMatchingWorkflowOutput) SetWorkflowName(v string) *GetMatchingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

type GetPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource for which the policy need
	// to be returned.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetPolicyInput) SetArn(v string) *GetPolicyInput {
	s.Arn = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Entity Resolution resource ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The resource-based policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// A unique identifier for the current revision of the policy.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetPolicyOutput) SetArn(v string) *GetPolicyOutput {
	s.Arn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetPolicyOutput) SetPolicy(v string) *GetPolicyOutput {
	s.Policy = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetPolicyOutput) SetToken(v string) *GetPolicyOutput {
	s.Token = &v
	return s
}

type GetSchemaMappingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the schema to be retrieved.
	//
	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSchemaMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSchemaMappingInput"}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaName sets the SchemaName field's value.
func (s *GetSchemaMappingInput) SetSchemaName(v string) *GetSchemaMappingInput {
	s.SchemaName = &v
	return s
}

type GetSchemaMappingOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the SchemaMapping was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the schema.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the schema mapping has been applied to a workflow.
	//
	// HasWorkflows is a required field
	HasWorkflows *bool `locationName:"hasWorkflows" type:"boolean" required:"true"`

	// A list of MappedInputFields. Each MappedInputField corresponds to a column
	// the source data table, and contains column name plus additional information
	// Venice uses for matching.
	//
	// MappedInputFields is a required field
	MappedInputFields []*SchemaInputAttribute `locationName:"mappedInputFields" min:"2" type:"list" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the SchemaMapping.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`

	// The name of the schema.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The timestamp of when the SchemaMapping was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSchemaMappingOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSchemaMappingOutput) SetCreatedAt(v time.Time) *GetSchemaMappingOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSchemaMappingOutput) SetDescription(v string) *GetSchemaMappingOutput {
	s.Description = &v
	return s
}

// SetHasWorkflows sets the HasWorkflows field's value.
func (s *GetSchemaMappingOutput) SetHasWorkflows(v bool) *GetSchemaMappingOutput {
	s.HasWorkflows = &v
	return s
}

// SetMappedInputFields sets the MappedInputFields field's value.
func (s *GetSchemaMappingOutput) SetMappedInputFields(v []*SchemaInputAttribute) *GetSchemaMappingOutput {
	s.MappedInputFields = v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *GetSchemaMappingOutput) SetSchemaArn(v string) *GetSchemaMappingOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *GetSchemaMappingOutput) SetSchemaName(v string) *GetSchemaMappingOutput {
	s.SchemaName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSchemaMappingOutput) SetTags(v map[string]*string) *GetSchemaMappingOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetSchemaMappingOutput) SetUpdatedAt(v time.Time) *GetSchemaMappingOutput {
	s.UpdatedAt = &v
	return s
}

// An object containing InputRecords, TotalRecordsProcessed, MatchIDs, and RecordsNotProcessed.
type IdMappingJobMetrics struct {
	_ struct{} `type:"structure"`

	// The total number of input records.
	InputRecords *int64 `locationName:"inputRecords" type:"integer"`

	// The total number of records that did not get processed.
	RecordsNotProcessed *int64 `locationName:"recordsNotProcessed" type:"integer"`

	// The total number of records processed.
	TotalRecordsProcessed *int64 `locationName:"totalRecordsProcessed" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingJobMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingJobMetrics) GoString() string {
	return s.String()
}

// SetInputRecords sets the InputRecords field's value.
func (s *IdMappingJobMetrics) SetInputRecords(v int64) *IdMappingJobMetrics {
	s.InputRecords = &v
	return s
}

// SetRecordsNotProcessed sets the RecordsNotProcessed field's value.
func (s *IdMappingJobMetrics) SetRecordsNotProcessed(v int64) *IdMappingJobMetrics {
	s.RecordsNotProcessed = &v
	return s
}

// SetTotalRecordsProcessed sets the TotalRecordsProcessed field's value.
func (s *IdMappingJobMetrics) SetTotalRecordsProcessed(v int64) *IdMappingJobMetrics {
	s.TotalRecordsProcessed = &v
	return s
}

// An object containing KMSArn, OutputS3Path, and RoleARN.
type IdMappingJobOutputSource struct {
	_ struct{} `type:"structure"`

	// Customer KMS ARN for encryption at rest. If not provided, system will use
	// an Entity Resolution managed KMS key.
	KMSArn *string `type:"string"`

	// The S3 path to which Entity Resolution will write the output table.
	//
	// OutputS3Path is a required field
	OutputS3Path *string `locationName:"outputS3Path" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access Amazon Web Services resources on your behalf as part
	// of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingJobOutputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingJobOutputSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdMappingJobOutputSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdMappingJobOutputSource"}
	if s.OutputS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3Path"))
	}
	if s.OutputS3Path != nil && len(*s.OutputS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputS3Path", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKMSArn sets the KMSArn field's value.
func (s *IdMappingJobOutputSource) SetKMSArn(v string) *IdMappingJobOutputSource {
	s.KMSArn = &v
	return s
}

// SetOutputS3Path sets the OutputS3Path field's value.
func (s *IdMappingJobOutputSource) SetOutputS3Path(v string) *IdMappingJobOutputSource {
	s.OutputS3Path = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *IdMappingJobOutputSource) SetRoleArn(v string) *IdMappingJobOutputSource {
	s.RoleArn = &v
	return s
}

// An object which defines the ID mapping techniques and provider configurations.
type IdMappingTechniques struct {
	_ struct{} `type:"structure"`

	// The type of ID mapping.
	//
	// IdMappingType is a required field
	IdMappingType *string `locationName:"idMappingType" type:"string" required:"true" enum:"IdMappingType"`

	// An object which defines any additional configurations required by the provider
	// service.
	ProviderProperties *ProviderProperties `locationName:"providerProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTechniques) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingTechniques) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdMappingTechniques) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdMappingTechniques"}
	if s.IdMappingType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdMappingType"))
	}
	if s.ProviderProperties != nil {
		if err := s.ProviderProperties.Validate(); err != nil {
			invalidParams.AddNested("ProviderProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdMappingType sets the IdMappingType field's value.
func (s *IdMappingTechniques) SetIdMappingType(v string) *IdMappingTechniques {
	s.IdMappingType = &v
	return s
}

// SetProviderProperties sets the ProviderProperties field's value.
func (s *IdMappingTechniques) SetProviderProperties(v *ProviderProperties) *IdMappingTechniques {
	s.ProviderProperties = v
	return s
}

// An object containing InputSourceARN, SchemaName, and Type.
type IdMappingWorkflowInputSource struct {
	_ struct{} `type:"structure"`

	// An Glue table ARN for the input source table.
	//
	// InputSourceARN is a required field
	InputSourceARN *string `locationName:"inputSourceARN" type:"string" required:"true"`

	// The name of the schema to be retrieved.
	SchemaName *string `locationName:"schemaName" min:"1" type:"string"`

	// The type of ID namespace. There are two types: SOURCE and TARGET.
	//
	// The SOURCE contains configurations for sourceId data that will be processed
	// in an ID mapping workflow.
	//
	// The TARGET contains a configuration of targetId to which all sourceIds will
	// resolve to.
	Type *string `locationName:"type" type:"string" enum:"IdNamespaceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingWorkflowInputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingWorkflowInputSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdMappingWorkflowInputSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdMappingWorkflowInputSource"}
	if s.InputSourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceARN"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSourceARN sets the InputSourceARN field's value.
func (s *IdMappingWorkflowInputSource) SetInputSourceARN(v string) *IdMappingWorkflowInputSource {
	s.InputSourceARN = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *IdMappingWorkflowInputSource) SetSchemaName(v string) *IdMappingWorkflowInputSource {
	s.SchemaName = &v
	return s
}

// SetType sets the Type field's value.
func (s *IdMappingWorkflowInputSource) SetType(v string) *IdMappingWorkflowInputSource {
	s.Type = &v
	return s
}

// The output source for the ID mapping workflow.
type IdMappingWorkflowOutputSource struct {
	_ struct{} `type:"structure"`

	// Customer KMS ARN for encryption at rest. If not provided, system will use
	// an Entity Resolution managed KMS key.
	KMSArn *string `type:"string"`

	// The S3 path to which Entity Resolution will write the output table.
	//
	// OutputS3Path is a required field
	OutputS3Path *string `locationName:"outputS3Path" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingWorkflowOutputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingWorkflowOutputSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdMappingWorkflowOutputSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdMappingWorkflowOutputSource"}
	if s.OutputS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3Path"))
	}
	if s.OutputS3Path != nil && len(*s.OutputS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputS3Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKMSArn sets the KMSArn field's value.
func (s *IdMappingWorkflowOutputSource) SetKMSArn(v string) *IdMappingWorkflowOutputSource {
	s.KMSArn = &v
	return s
}

// SetOutputS3Path sets the OutputS3Path field's value.
func (s *IdMappingWorkflowOutputSource) SetOutputS3Path(v string) *IdMappingWorkflowOutputSource {
	s.OutputS3Path = &v
	return s
}

// A list of IdMappingWorkflowSummary objects, each of which contain the fields
// WorkflowName, WorkflowArn, CreatedAt, and UpdatedAt.
type IdMappingWorkflowSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the workflow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The timestamp of when the workflow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the IdMappingWorkflow.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingWorkflowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdMappingWorkflowSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *IdMappingWorkflowSummary) SetCreatedAt(v time.Time) *IdMappingWorkflowSummary {
	s.CreatedAt = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IdMappingWorkflowSummary) SetUpdatedAt(v time.Time) *IdMappingWorkflowSummary {
	s.UpdatedAt = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *IdMappingWorkflowSummary) SetWorkflowArn(v string) *IdMappingWorkflowSummary {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *IdMappingWorkflowSummary) SetWorkflowName(v string) *IdMappingWorkflowSummary {
	s.WorkflowName = &v
	return s
}

// An object containing IdMappingType and ProviderProperties.
type IdNamespaceIdMappingWorkflowProperties struct {
	_ struct{} `type:"structure"`

	// The type of ID mapping.
	//
	// IdMappingType is a required field
	IdMappingType *string `locationName:"idMappingType" type:"string" required:"true" enum:"IdMappingType"`

	// An object which defines any additional configurations required by the provider
	// service.
	ProviderProperties *NamespaceProviderProperties `locationName:"providerProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceIdMappingWorkflowProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceIdMappingWorkflowProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdNamespaceIdMappingWorkflowProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdNamespaceIdMappingWorkflowProperties"}
	if s.IdMappingType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdMappingType"))
	}
	if s.ProviderProperties != nil {
		if err := s.ProviderProperties.Validate(); err != nil {
			invalidParams.AddNested("ProviderProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdMappingType sets the IdMappingType field's value.
func (s *IdNamespaceIdMappingWorkflowProperties) SetIdMappingType(v string) *IdNamespaceIdMappingWorkflowProperties {
	s.IdMappingType = &v
	return s
}

// SetProviderProperties sets the ProviderProperties field's value.
func (s *IdNamespaceIdMappingWorkflowProperties) SetProviderProperties(v *NamespaceProviderProperties) *IdNamespaceIdMappingWorkflowProperties {
	s.ProviderProperties = v
	return s
}

// An object containing InputSourceARN and SchemaName.
type IdNamespaceInputSource struct {
	_ struct{} `type:"structure"`

	// An Glue table ARN for the input source table.
	//
	// InputSourceARN is a required field
	InputSourceARN *string `locationName:"inputSourceARN" type:"string" required:"true"`

	// The name of the schema.
	SchemaName *string `locationName:"schemaName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceInputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceInputSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdNamespaceInputSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdNamespaceInputSource"}
	if s.InputSourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceARN"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSourceARN sets the InputSourceARN field's value.
func (s *IdNamespaceInputSource) SetInputSourceARN(v string) *IdNamespaceInputSource {
	s.InputSourceARN = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *IdNamespaceInputSource) SetSchemaName(v string) *IdNamespaceInputSource {
	s.SchemaName = &v
	return s
}

// A summary of ID namespaces.
type IdNamespaceSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the ID namespace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The description of the ID namespace.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of the ID namespace.
	//
	// IdNamespaceArn is a required field
	IdNamespaceArn *string `locationName:"idNamespaceArn" type:"string" required:"true"`

	// The name of the ID namespace.
	//
	// IdNamespaceName is a required field
	IdNamespaceName *string `locationName:"idNamespaceName" min:"1" type:"string" required:"true"`

	// The type of ID namespace. There are two types: SOURCE and TARGET.
	//
	// The SOURCE contains configurations for sourceId data that will be processed
	// in an ID mapping workflow.
	//
	// The TARGET contains a configuration of targetId to which all sourceIds will
	// resolve to.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"IdNamespaceType"`

	// The timestamp of when the ID namespace was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdNamespaceSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *IdNamespaceSummary) SetCreatedAt(v time.Time) *IdNamespaceSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IdNamespaceSummary) SetDescription(v string) *IdNamespaceSummary {
	s.Description = &v
	return s
}

// SetIdNamespaceArn sets the IdNamespaceArn field's value.
func (s *IdNamespaceSummary) SetIdNamespaceArn(v string) *IdNamespaceSummary {
	s.IdNamespaceArn = &v
	return s
}

// SetIdNamespaceName sets the IdNamespaceName field's value.
func (s *IdNamespaceSummary) SetIdNamespaceName(v string) *IdNamespaceSummary {
	s.IdNamespaceName = &v
	return s
}

// SetType sets the Type field's value.
func (s *IdNamespaceSummary) SetType(v string) *IdNamespaceSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IdNamespaceSummary) SetUpdatedAt(v time.Time) *IdNamespaceSummary {
	s.UpdatedAt = &v
	return s
}

// An object which defines an incremental run type and has only incrementalRunType
// as a field.
type IncrementalRunConfig struct {
	_ struct{} `type:"structure"`

	// The type of incremental run. It takes only one value: IMMEDIATE.
	IncrementalRunType *string `locationName:"incrementalRunType" type:"string" enum:"IncrementalRunType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncrementalRunConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncrementalRunConfig) GoString() string {
	return s.String()
}

// SetIncrementalRunType sets the IncrementalRunType field's value.
func (s *IncrementalRunConfig) SetIncrementalRunType(v string) *IncrementalRunConfig {
	s.IncrementalRunType = &v
	return s
}

// An object containing InputSourceARN, SchemaName, and ApplyNormalization.
type InputSource struct {
	_ struct{} `type:"structure"`

	// Normalizes the attributes defined in the schema in the input data. For example,
	// if an attribute has an AttributeType of PHONE_NUMBER, and the data in the
	// input table is in a format of 1234567890, Entity Resolution will normalize
	// this field in the output to (123)-456-7890.
	ApplyNormalization *bool `locationName:"applyNormalization" type:"boolean"`

	// An Glue table ARN for the input source table.
	//
	// InputSourceARN is a required field
	InputSourceARN *string `locationName:"inputSourceARN" type:"string" required:"true"`

	// The name of the schema to be retrieved.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSource"}
	if s.InputSourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceARN"))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyNormalization sets the ApplyNormalization field's value.
func (s *InputSource) SetApplyNormalization(v bool) *InputSource {
	s.ApplyNormalization = &v
	return s
}

// SetInputSourceARN sets the InputSourceARN field's value.
func (s *InputSource) SetInputSourceARN(v string) *InputSource {
	s.InputSourceARN = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *InputSource) SetSchemaName(v string) *InputSource {
	s.SchemaName = &v
	return s
}

// The Amazon S3 location that temporarily stores your data while it processes.
// Your information won't be saved permanently.
type IntermediateSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location (bucket and prefix). For example: s3://provider_bucket/DOC-EXAMPLE-BUCKET
	//
	// IntermediateS3Path is a required field
	IntermediateS3Path *string `locationName:"intermediateS3Path" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntermediateSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntermediateSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntermediateSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntermediateSourceConfiguration"}
	if s.IntermediateS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("IntermediateS3Path"))
	}
	if s.IntermediateS3Path != nil && len(*s.IntermediateS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntermediateS3Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntermediateS3Path sets the IntermediateS3Path field's value.
func (s *IntermediateSourceConfiguration) SetIntermediateS3Path(v string) *IntermediateSourceConfiguration {
	s.IntermediateS3Path = &v
	return s
}

// This exception occurs when there is an internal failure in the Entity Resolution
// service. HTTP Status Code: 500
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object containing InputRecords, TotalRecordsProcessed, MatchIDs, and RecordsNotProcessed.
type JobMetrics struct {
	_ struct{} `type:"structure"`

	// The total number of input records.
	InputRecords *int64 `locationName:"inputRecords" type:"integer"`

	// The total number of matchIDs generated.
	MatchIDs *int64 `locationName:"matchIDs" type:"integer"`

	// The total number of records that did not get processed.
	RecordsNotProcessed *int64 `locationName:"recordsNotProcessed" type:"integer"`

	// The total number of records processed.
	TotalRecordsProcessed *int64 `locationName:"totalRecordsProcessed" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobMetrics) GoString() string {
	return s.String()
}

// SetInputRecords sets the InputRecords field's value.
func (s *JobMetrics) SetInputRecords(v int64) *JobMetrics {
	s.InputRecords = &v
	return s
}

// SetMatchIDs sets the MatchIDs field's value.
func (s *JobMetrics) SetMatchIDs(v int64) *JobMetrics {
	s.MatchIDs = &v
	return s
}

// SetRecordsNotProcessed sets the RecordsNotProcessed field's value.
func (s *JobMetrics) SetRecordsNotProcessed(v int64) *JobMetrics {
	s.RecordsNotProcessed = &v
	return s
}

// SetTotalRecordsProcessed sets the TotalRecordsProcessed field's value.
func (s *JobMetrics) SetTotalRecordsProcessed(v int64) *JobMetrics {
	s.TotalRecordsProcessed = &v
	return s
}

// An object containing KMSArn, OutputS3Path, and RoleArn.
type JobOutputSource struct {
	_ struct{} `type:"structure"`

	// Customer KMS ARN for encryption at rest. If not provided, system will use
	// an Entity Resolution managed KMS key.
	KMSArn *string `type:"string"`

	// The S3 path to which Entity Resolution will write the output table.
	//
	// OutputS3Path is a required field
	OutputS3Path *string `locationName:"outputS3Path" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access Amazon Web Services resources on your behalf as part
	// of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobOutputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobOutputSource) GoString() string {
	return s.String()
}

// SetKMSArn sets the KMSArn field's value.
func (s *JobOutputSource) SetKMSArn(v string) *JobOutputSource {
	s.KMSArn = &v
	return s
}

// SetOutputS3Path sets the OutputS3Path field's value.
func (s *JobOutputSource) SetOutputS3Path(v string) *JobOutputSource {
	s.OutputS3Path = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *JobOutputSource) SetRoleArn(v string) *JobOutputSource {
	s.RoleArn = &v
	return s
}

// An object containing the JobId, Status, StartTime, and EndTime of a job.
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the job has finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The time at which the job was started.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The current status of the job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSummary) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *JobSummary) SetEndTime(v time.Time) *JobSummary {
	s.EndTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobSummary) SetJobId(v string) *JobSummary {
	s.JobId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *JobSummary) SetStartTime(v time.Time) *JobSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobSummary) SetStatus(v string) *JobSummary {
	s.Status = &v
	return s
}

type ListIdMappingJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from the previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name of the workflow to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdMappingJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdMappingJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdMappingJobsInput) SetMaxResults(v int64) *ListIdMappingJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdMappingJobsInput) SetNextToken(v string) *ListIdMappingJobsInput {
	s.NextToken = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *ListIdMappingJobsInput) SetWorkflowName(v string) *ListIdMappingJobsInput {
	s.WorkflowName = &v
	return s
}

type ListIdMappingJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of JobSummary objects.
	Jobs []*JobSummary `locationName:"jobs" type:"list"`

	// The pagination token from the previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListIdMappingJobsOutput) SetJobs(v []*JobSummary) *ListIdMappingJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdMappingJobsOutput) SetNextToken(v string) *ListIdMappingJobsOutput {
	s.NextToken = &v
	return s
}

type ListIdMappingWorkflowsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token from the previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdMappingWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdMappingWorkflowsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdMappingWorkflowsInput) SetMaxResults(v int64) *ListIdMappingWorkflowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdMappingWorkflowsInput) SetNextToken(v string) *ListIdMappingWorkflowsInput {
	s.NextToken = &v
	return s
}

type ListIdMappingWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from the previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of IdMappingWorkflowSummary objects.
	WorkflowSummaries []*IdMappingWorkflowSummary `locationName:"workflowSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdMappingWorkflowsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdMappingWorkflowsOutput) SetNextToken(v string) *ListIdMappingWorkflowsOutput {
	s.NextToken = &v
	return s
}

// SetWorkflowSummaries sets the WorkflowSummaries field's value.
func (s *ListIdMappingWorkflowsOutput) SetWorkflowSummaries(v []*IdMappingWorkflowSummary) *ListIdMappingWorkflowsOutput {
	s.WorkflowSummaries = v
	return s
}

type ListIdNamespacesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of IdNamespace objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token from the previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdNamespacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdNamespacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdNamespacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdNamespacesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdNamespacesInput) SetMaxResults(v int64) *ListIdNamespacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdNamespacesInput) SetNextToken(v string) *ListIdNamespacesInput {
	s.NextToken = &v
	return s
}

type ListIdNamespacesOutput struct {
	_ struct{} `type:"structure"`

	// A list of IdNamespaceSummaries objects.
	IdNamespaceSummaries []*IdNamespaceSummary `locationName:"idNamespaceSummaries" type:"list"`

	// The pagination token from the previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdNamespacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdNamespacesOutput) GoString() string {
	return s.String()
}

// SetIdNamespaceSummaries sets the IdNamespaceSummaries field's value.
func (s *ListIdNamespacesOutput) SetIdNamespaceSummaries(v []*IdNamespaceSummary) *ListIdNamespacesOutput {
	s.IdNamespaceSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdNamespacesOutput) SetNextToken(v string) *ListIdNamespacesOutput {
	s.NextToken = &v
	return s
}

type ListMatchingJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from the previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name of the workflow to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMatchingJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMatchingJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMatchingJobsInput) SetMaxResults(v int64) *ListMatchingJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMatchingJobsInput) SetNextToken(v string) *ListMatchingJobsInput {
	s.NextToken = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *ListMatchingJobsInput) SetWorkflowName(v string) *ListMatchingJobsInput {
	s.WorkflowName = &v
	return s
}

type ListMatchingJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of JobSummary objects, each of which contain the ID, status, start
	// time, and end time of a job.
	Jobs []*JobSummary `locationName:"jobs" type:"list"`

	// The pagination token from the previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListMatchingJobsOutput) SetJobs(v []*JobSummary) *ListMatchingJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMatchingJobsOutput) SetNextToken(v string) *ListMatchingJobsOutput {
	s.NextToken = &v
	return s
}

type ListMatchingWorkflowsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token from the previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingWorkflowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingWorkflowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMatchingWorkflowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMatchingWorkflowsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMatchingWorkflowsInput) SetMaxResults(v int64) *ListMatchingWorkflowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMatchingWorkflowsInput) SetNextToken(v string) *ListMatchingWorkflowsInput {
	s.NextToken = &v
	return s
}

type ListMatchingWorkflowsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from the previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of MatchingWorkflowSummary objects, each of which contain the fields
	// WorkflowName, WorkflowArn, CreatedAt, and UpdatedAt.
	WorkflowSummaries []*MatchingWorkflowSummary `locationName:"workflowSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingWorkflowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMatchingWorkflowsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMatchingWorkflowsOutput) SetNextToken(v string) *ListMatchingWorkflowsOutput {
	s.NextToken = &v
	return s
}

// SetWorkflowSummaries sets the WorkflowSummaries field's value.
func (s *ListMatchingWorkflowsOutput) SetWorkflowSummaries(v []*MatchingWorkflowSummary) *ListMatchingWorkflowsOutput {
	s.WorkflowSummaries = v
	return s
}

type ListProviderServicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"15" type:"integer"`

	// The pagination token from the previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name of the provider. This name is typically the company name.
	ProviderName *string `location:"querystring" locationName:"providerName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProviderServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProviderServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProviderServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProviderServicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 15 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 15))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProviderServicesInput) SetMaxResults(v int64) *ListProviderServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProviderServicesInput) SetNextToken(v string) *ListProviderServicesInput {
	s.NextToken = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *ListProviderServicesInput) SetProviderName(v string) *ListProviderServicesInput {
	s.ProviderName = &v
	return s
}

type ListProviderServicesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from the previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of ProviderServices objects.
	ProviderServiceSummaries []*ProviderServiceSummary `locationName:"providerServiceSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProviderServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProviderServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProviderServicesOutput) SetNextToken(v string) *ListProviderServicesOutput {
	s.NextToken = &v
	return s
}

// SetProviderServiceSummaries sets the ProviderServiceSummaries field's value.
func (s *ListProviderServicesOutput) SetProviderServiceSummaries(v []*ProviderServiceSummary) *ListProviderServicesOutput {
	s.ProviderServiceSummaries = v
	return s
}

type ListSchemaMappingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// The pagination token from the previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemaMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemaMappingsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchemaMappingsInput) SetMaxResults(v int64) *ListSchemaMappingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemaMappingsInput) SetNextToken(v string) *ListSchemaMappingsInput {
	s.NextToken = &v
	return s
}

type ListSchemaMappingsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token from the previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of SchemaMappingSummary objects, each of which contain the fields
	// SchemaName, SchemaArn, CreatedAt, UpdatedAt.
	SchemaList []*SchemaMappingSummary `locationName:"schemaList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemaMappingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemaMappingsOutput) SetNextToken(v string) *ListSchemaMappingsOutput {
	s.NextToken = &v
	return s
}

// SetSchemaList sets the SchemaList field's value.
func (s *ListSchemaMappingsOutput) SetSchemaList(v []*SchemaMappingSummary) *ListSchemaMappingsOutput {
	s.SchemaList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource for which you want to view tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A list of MatchingWorkflowSummary objects, each of which contain the fields
// WorkflowName, WorkflowArn, CreatedAt, UpdatedAt.
type MatchingWorkflowSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the workflow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The method that has been specified for data matching, either using matching
	// provided by Entity Resolution or through a provider service.
	//
	// ResolutionType is a required field
	ResolutionType *string `locationName:"resolutionType" type:"string" required:"true" enum:"ResolutionType"`

	// The timestamp of when the workflow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the MatchingWorkflow.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchingWorkflowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchingWorkflowSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *MatchingWorkflowSummary) SetCreatedAt(v time.Time) *MatchingWorkflowSummary {
	s.CreatedAt = &v
	return s
}

// SetResolutionType sets the ResolutionType field's value.
func (s *MatchingWorkflowSummary) SetResolutionType(v string) *MatchingWorkflowSummary {
	s.ResolutionType = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *MatchingWorkflowSummary) SetUpdatedAt(v time.Time) *MatchingWorkflowSummary {
	s.UpdatedAt = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *MatchingWorkflowSummary) SetWorkflowArn(v string) *MatchingWorkflowSummary {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *MatchingWorkflowSummary) SetWorkflowName(v string) *MatchingWorkflowSummary {
	s.WorkflowName = &v
	return s
}

// An object containing ProviderConfiguration and ProviderServiceArn.
type NamespaceProviderProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the provider service.
	//
	// ProviderServiceArn is a required field
	ProviderServiceArn *string `locationName:"providerServiceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NamespaceProviderProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NamespaceProviderProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NamespaceProviderProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NamespaceProviderProperties"}
	if s.ProviderServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderServiceArn"))
	}
	if s.ProviderServiceArn != nil && len(*s.ProviderServiceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderServiceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderServiceArn sets the ProviderServiceArn field's value.
func (s *NamespaceProviderProperties) SetProviderServiceArn(v string) *NamespaceProviderProperties {
	s.ProviderServiceArn = &v
	return s
}

// A list of OutputAttribute objects, each of which have the fields Name and
// Hashed. Each of these objects selects a column to be included in the output
// table, and whether the values of the column should be hashed.
type OutputAttribute struct {
	_ struct{} `type:"structure"`

	// Enables the ability to hash the column values in the output.
	Hashed *bool `locationName:"hashed" type:"boolean"`

	// A name of a column to be written to the output. This must be an InputField
	// name in the schema mapping.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputAttribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHashed sets the Hashed field's value.
func (s *OutputAttribute) SetHashed(v bool) *OutputAttribute {
	s.Hashed = &v
	return s
}

// SetName sets the Name field's value.
func (s *OutputAttribute) SetName(v string) *OutputAttribute {
	s.Name = &v
	return s
}

// A list of OutputAttribute objects, each of which have the fields Name and
// Hashed. Each of these objects selects a column to be included in the output
// table, and whether the values of the column should be hashed.
type OutputSource struct {
	_ struct{} `type:"structure"`

	// Normalizes the attributes defined in the schema in the input data. For example,
	// if an attribute has an AttributeType of PHONE_NUMBER, and the data in the
	// input table is in a format of 1234567890, Entity Resolution will normalize
	// this field in the output to (123)-456-7890.
	ApplyNormalization *bool `locationName:"applyNormalization" type:"boolean"`

	// Customer KMS ARN for encryption at rest. If not provided, system will use
	// an Entity Resolution managed KMS key.
	KMSArn *string `type:"string"`

	// A list of OutputAttribute objects, each of which have the fields Name and
	// Hashed. Each of these objects selects a column to be included in the output
	// table, and whether the values of the column should be hashed.
	//
	// Output is a required field
	Output []*OutputAttribute `locationName:"output" type:"list" required:"true"`

	// The S3 path to which Entity Resolution will write the output table.
	//
	// OutputS3Path is a required field
	OutputS3Path *string `locationName:"outputS3Path" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputSource"}
	if s.Output == nil {
		invalidParams.Add(request.NewErrParamRequired("Output"))
	}
	if s.OutputS3Path == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3Path"))
	}
	if s.OutputS3Path != nil && len(*s.OutputS3Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputS3Path", 1))
	}
	if s.Output != nil {
		for i, v := range s.Output {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Output", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyNormalization sets the ApplyNormalization field's value.
func (s *OutputSource) SetApplyNormalization(v bool) *OutputSource {
	s.ApplyNormalization = &v
	return s
}

// SetKMSArn sets the KMSArn field's value.
func (s *OutputSource) SetKMSArn(v string) *OutputSource {
	s.KMSArn = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *OutputSource) SetOutput(v []*OutputAttribute) *OutputSource {
	s.Output = v
	return s
}

// SetOutputS3Path sets the OutputS3Path field's value.
func (s *OutputSource) SetOutputS3Path(v string) *OutputSource {
	s.OutputS3Path = &v
	return s
}

// An object containing the providerServiceARN, intermediateSourceConfiguration,
// and providerConfiguration.
type ProviderProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location that temporarily stores your data while it processes.
	// Your information won't be saved permanently.
	IntermediateSourceConfiguration *IntermediateSourceConfiguration `locationName:"intermediateSourceConfiguration" type:"structure"`

	// The ARN of the provider service.
	//
	// ProviderServiceArn is a required field
	ProviderServiceArn *string `locationName:"providerServiceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProviderProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProviderProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProviderProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProviderProperties"}
	if s.ProviderServiceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderServiceArn"))
	}
	if s.ProviderServiceArn != nil && len(*s.ProviderServiceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderServiceArn", 20))
	}
	if s.IntermediateSourceConfiguration != nil {
		if err := s.IntermediateSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("IntermediateSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntermediateSourceConfiguration sets the IntermediateSourceConfiguration field's value.
func (s *ProviderProperties) SetIntermediateSourceConfiguration(v *IntermediateSourceConfiguration) *ProviderProperties {
	s.IntermediateSourceConfiguration = v
	return s
}

// SetProviderServiceArn sets the ProviderServiceArn field's value.
func (s *ProviderProperties) SetProviderServiceArn(v string) *ProviderProperties {
	s.ProviderServiceArn = &v
	return s
}

// A list of ProviderService objects, each of which contain the fields providerName,
// providerServiceArn, providerServiceName, and providerServiceType.
type ProviderServiceSummary struct {
	_ struct{} `type:"structure"`

	// The name of the provider. This name is typically the company name.
	//
	// ProviderName is a required field
	ProviderName *string `locationName:"providerName" min:"1" type:"string" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the providerService.
	//
	// ProviderServiceArn is a required field
	ProviderServiceArn *string `locationName:"providerServiceArn" min:"20" type:"string" required:"true"`

	// The display name of the provider service.
	//
	// ProviderServiceDisplayName is a required field
	ProviderServiceDisplayName *string `locationName:"providerServiceDisplayName" type:"string" required:"true"`

	// The name of the product that the provider service provides.
	//
	// ProviderServiceName is a required field
	ProviderServiceName *string `locationName:"providerServiceName" min:"1" type:"string" required:"true"`

	// The type of provider service.
	//
	// ProviderServiceType is a required field
	ProviderServiceType *string `locationName:"providerServiceType" type:"string" required:"true" enum:"ServiceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProviderServiceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProviderServiceSummary) GoString() string {
	return s.String()
}

// SetProviderName sets the ProviderName field's value.
func (s *ProviderServiceSummary) SetProviderName(v string) *ProviderServiceSummary {
	s.ProviderName = &v
	return s
}

// SetProviderServiceArn sets the ProviderServiceArn field's value.
func (s *ProviderServiceSummary) SetProviderServiceArn(v string) *ProviderServiceSummary {
	s.ProviderServiceArn = &v
	return s
}

// SetProviderServiceDisplayName sets the ProviderServiceDisplayName field's value.
func (s *ProviderServiceSummary) SetProviderServiceDisplayName(v string) *ProviderServiceSummary {
	s.ProviderServiceDisplayName = &v
	return s
}

// SetProviderServiceName sets the ProviderServiceName field's value.
func (s *ProviderServiceSummary) SetProviderServiceName(v string) *ProviderServiceSummary {
	s.ProviderServiceName = &v
	return s
}

// SetProviderServiceType sets the ProviderServiceType field's value.
func (s *ProviderServiceSummary) SetProviderServiceType(v string) *ProviderServiceSummary {
	s.ProviderServiceType = &v
	return s
}

type PutPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource for which the policy needs
	// to be updated.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`

	// The resource-based policy.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`

	// A unique identifier for the current revision of the policy.
	Token *string `locationName:"token" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.Token != nil && len(*s.Token) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Token", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *PutPolicyInput) SetArn(v string) *PutPolicyInput {
	s.Arn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutPolicyInput) SetPolicy(v string) *PutPolicyInput {
	s.Policy = &v
	return s
}

// SetToken sets the Token field's value.
func (s *PutPolicyInput) SetToken(v string) *PutPolicyInput {
	s.Token = &v
	return s
}

type PutPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Entity Resolution resource ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The resource-based policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// A unique identifier for the current revision of the policy.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PutPolicyOutput) SetArn(v string) *PutPolicyOutput {
	s.Arn = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutPolicyOutput) SetPolicy(v string) *PutPolicyOutput {
	s.Policy = &v
	return s
}

// SetToken sets the Token field's value.
func (s *PutPolicyOutput) SetToken(v string) *PutPolicyOutput {
	s.Token = &v
	return s
}

// An object which defines the resolutionType and the ruleBasedProperties.
type ResolutionTechniques struct {
	_ struct{} `type:"structure"`

	// The properties of the provider service.
	ProviderProperties *ProviderProperties `locationName:"providerProperties" type:"structure"`

	// The type of matching. There are three types of matching: RULE_MATCHING, ML_MATCHING,
	// and PROVIDER.
	//
	// ResolutionType is a required field
	ResolutionType *string `locationName:"resolutionType" type:"string" required:"true" enum:"ResolutionType"`

	// An object which defines the list of matching rules to run and has a field
	// Rules, which is a list of rule objects.
	RuleBasedProperties *RuleBasedProperties `locationName:"ruleBasedProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolutionTechniques) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolutionTechniques) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolutionTechniques) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolutionTechniques"}
	if s.ResolutionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolutionType"))
	}
	if s.ProviderProperties != nil {
		if err := s.ProviderProperties.Validate(); err != nil {
			invalidParams.AddNested("ProviderProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.RuleBasedProperties != nil {
		if err := s.RuleBasedProperties.Validate(); err != nil {
			invalidParams.AddNested("RuleBasedProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProviderProperties sets the ProviderProperties field's value.
func (s *ResolutionTechniques) SetProviderProperties(v *ProviderProperties) *ResolutionTechniques {
	s.ProviderProperties = v
	return s
}

// SetResolutionType sets the ResolutionType field's value.
func (s *ResolutionTechniques) SetResolutionType(v string) *ResolutionTechniques {
	s.ResolutionType = &v
	return s
}

// SetRuleBasedProperties sets the RuleBasedProperties field's value.
func (s *ResolutionTechniques) SetRuleBasedProperties(v *RuleBasedProperties) *ResolutionTechniques {
	s.RuleBasedProperties = v
	return s
}

// The resource could not be found. HTTP Status Code: 404
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object containing RuleName, and MatchingKeys.
type Rule struct {
	_ struct{} `type:"structure"`

	// A list of MatchingKeys. The MatchingKeys must have been defined in the SchemaMapping.
	// Two records are considered to match according to this rule if all of the
	// MatchingKeys match.
	//
	// MatchingKeys is a required field
	MatchingKeys []*string `locationName:"matchingKeys" min:"1" type:"list" required:"true"`

	// A name for the matching rule.
	//
	// RuleName is a required field
	RuleName *string `locationName:"ruleName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.MatchingKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchingKeys"))
	}
	if s.MatchingKeys != nil && len(s.MatchingKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MatchingKeys", 1))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMatchingKeys sets the MatchingKeys field's value.
func (s *Rule) SetMatchingKeys(v []*string) *Rule {
	s.MatchingKeys = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *Rule) SetRuleName(v string) *Rule {
	s.RuleName = &v
	return s
}

// An object which defines the list of matching rules to run and has a field
// Rules, which is a list of rule objects.
type RuleBasedProperties struct {
	_ struct{} `type:"structure"`

	// The comparison type. You can either choose ONE_TO_ONE or MANY_TO_MANY as
	// the AttributeMatchingModel. When choosing MANY_TO_MANY, the system can match
	// attributes across the sub-types of an attribute type. For example, if the
	// value of the Email field of Profile A and the value of BusinessEmail field
	// of Profile B matches, the two profiles are matched on the Email type. When
	// choosing ONE_TO_ONE ,the system can only match if the sub-types are exact
	// matches. For example, only when the value of the Email field of Profile A
	// and the value of the Email field of Profile B matches, the two profiles are
	// matched on the Email type.
	//
	// AttributeMatchingModel is a required field
	AttributeMatchingModel *string `locationName:"attributeMatchingModel" type:"string" required:"true" enum:"AttributeMatchingModel"`

	// A list of Rule objects, each of which have fields RuleName and MatchingKeys.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleBasedProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleBasedProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleBasedProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleBasedProperties"}
	if s.AttributeMatchingModel == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeMatchingModel"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeMatchingModel sets the AttributeMatchingModel field's value.
func (s *RuleBasedProperties) SetAttributeMatchingModel(v string) *RuleBasedProperties {
	s.AttributeMatchingModel = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *RuleBasedProperties) SetRules(v []*Rule) *RuleBasedProperties {
	s.Rules = v
	return s
}

// An object containing FieldName, Type, GroupName, MatchKey, and SubType.
type SchemaInputAttribute struct {
	_ struct{} `type:"structure"`

	// A string containing the field name.
	//
	// FieldName is a required field
	FieldName *string `locationName:"fieldName" type:"string" required:"true"`

	// A string that instructs Entity Resolution to combine several columns into
	// a unified column with the identical attribute type.
	//
	// For example, when working with columns such as first_name, middle_name, and
	// last_name, assigning them a common groupName will prompt Entity Resolution
	// to concatenate them into a single value.
	GroupName *string `locationName:"groupName" type:"string"`

	// A key that allows grouping of multiple input attributes into a unified matching
	// group. For example, consider a scenario where the source table contains various
	// addresses, such as business_address and shipping_address. By assigning a
	// matchKey called address to both attributes, Entity Resolution will match
	// records across these fields to create a consolidated matching group. If no
	// matchKey is specified for a column, it won't be utilized for matching purposes
	// but will still be included in the output table.
	MatchKey *string `locationName:"matchKey" type:"string"`

	// The subtype of the attribute, selected from a list of values.
	SubType *string `locationName:"subType" type:"string"`

	// The type of the attribute, selected from a list of values.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SchemaAttributeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaInputAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaInputAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaInputAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaInputAttribute"}
	if s.FieldName == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldName"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldName sets the FieldName field's value.
func (s *SchemaInputAttribute) SetFieldName(v string) *SchemaInputAttribute {
	s.FieldName = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *SchemaInputAttribute) SetGroupName(v string) *SchemaInputAttribute {
	s.GroupName = &v
	return s
}

// SetMatchKey sets the MatchKey field's value.
func (s *SchemaInputAttribute) SetMatchKey(v string) *SchemaInputAttribute {
	s.MatchKey = &v
	return s
}

// SetSubType sets the SubType field's value.
func (s *SchemaInputAttribute) SetSubType(v string) *SchemaInputAttribute {
	s.SubType = &v
	return s
}

// SetType sets the Type field's value.
func (s *SchemaInputAttribute) SetType(v string) *SchemaInputAttribute {
	s.Type = &v
	return s
}

// An object containing SchemaName, SchemaArn, CreatedAt, andUpdatedAt.
type SchemaMappingSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the SchemaMapping was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Specifies whether the schema mapping has been applied to a workflow.
	//
	// HasWorkflows is a required field
	HasWorkflows *bool `locationName:"hasWorkflows" type:"boolean" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the SchemaMapping.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`

	// The name of the schema.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" min:"1" type:"string" required:"true"`

	// The timestamp of when the SchemaMapping was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaMappingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaMappingSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SchemaMappingSummary) SetCreatedAt(v time.Time) *SchemaMappingSummary {
	s.CreatedAt = &v
	return s
}

// SetHasWorkflows sets the HasWorkflows field's value.
func (s *SchemaMappingSummary) SetHasWorkflows(v bool) *SchemaMappingSummary {
	s.HasWorkflows = &v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *SchemaMappingSummary) SetSchemaArn(v string) *SchemaMappingSummary {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *SchemaMappingSummary) SetSchemaName(v string) *SchemaMappingSummary {
	s.SchemaName = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SchemaMappingSummary) SetUpdatedAt(v time.Time) *SchemaMappingSummary {
	s.UpdatedAt = &v
	return s
}

type StartIdMappingJobInput struct {
	_ struct{} `type:"structure"`

	// A list of OutputSource objects.
	OutputSourceConfig []*IdMappingJobOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`

	// The name of the ID mapping job to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIdMappingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIdMappingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartIdMappingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartIdMappingJobInput"}
	if s.OutputSourceConfig != nil && len(s.OutputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputSourceConfig", 1))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}
	if s.OutputSourceConfig != nil {
		for i, v := range s.OutputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *StartIdMappingJobInput) SetOutputSourceConfig(v []*IdMappingJobOutputSource) *StartIdMappingJobInput {
	s.OutputSourceConfig = v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *StartIdMappingJobInput) SetWorkflowName(v string) *StartIdMappingJobInput {
	s.WorkflowName = &v
	return s
}

type StartIdMappingJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A list of OutputSource objects.
	OutputSourceConfig []*IdMappingJobOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIdMappingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIdMappingJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartIdMappingJobOutput) SetJobId(v string) *StartIdMappingJobOutput {
	s.JobId = &v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *StartIdMappingJobOutput) SetOutputSourceConfig(v []*IdMappingJobOutputSource) *StartIdMappingJobOutput {
	s.OutputSourceConfig = v
	return s
}

type StartMatchingJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the matching job to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMatchingJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMatchingJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMatchingJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMatchingJobInput"}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *StartMatchingJobInput) SetWorkflowName(v string) *StartMatchingJobInput {
	s.WorkflowName = &v
	return s
}

type StartMatchingJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMatchingJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMatchingJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartMatchingJobOutput) SetJobId(v string) *StartMatchingJobOutput {
	s.JobId = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource for which you want to view tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling. HTTP Status Code: 429
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource for which you want to untag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateIdMappingWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines the idMappingType and the providerProperties.
	//
	// IdMappingTechniques is a required field
	IdMappingTechniques *IdMappingTechniques `locationName:"idMappingTechniques" type:"structure" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*IdMappingWorkflowInputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path
	// and KMSArn.
	OutputSourceConfig []*IdMappingWorkflowOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access Amazon Web Services resources on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdMappingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdMappingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdMappingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIdMappingWorkflowInput"}
	if s.IdMappingTechniques == nil {
		invalidParams.Add(request.NewErrParamRequired("IdMappingTechniques"))
	}
	if s.InputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceConfig"))
	}
	if s.InputSourceConfig != nil && len(s.InputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSourceConfig", 1))
	}
	if s.OutputSourceConfig != nil && len(s.OutputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputSourceConfig", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}
	if s.IdMappingTechniques != nil {
		if err := s.IdMappingTechniques.Validate(); err != nil {
			invalidParams.AddNested("IdMappingTechniques", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSourceConfig != nil {
		for i, v := range s.InputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputSourceConfig != nil {
		for i, v := range s.OutputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateIdMappingWorkflowInput) SetDescription(v string) *UpdateIdMappingWorkflowInput {
	s.Description = &v
	return s
}

// SetIdMappingTechniques sets the IdMappingTechniques field's value.
func (s *UpdateIdMappingWorkflowInput) SetIdMappingTechniques(v *IdMappingTechniques) *UpdateIdMappingWorkflowInput {
	s.IdMappingTechniques = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *UpdateIdMappingWorkflowInput) SetInputSourceConfig(v []*IdMappingWorkflowInputSource) *UpdateIdMappingWorkflowInput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *UpdateIdMappingWorkflowInput) SetOutputSourceConfig(v []*IdMappingWorkflowOutputSource) *UpdateIdMappingWorkflowInput {
	s.OutputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateIdMappingWorkflowInput) SetRoleArn(v string) *UpdateIdMappingWorkflowInput {
	s.RoleArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *UpdateIdMappingWorkflowInput) SetWorkflowName(v string) *UpdateIdMappingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type UpdateIdMappingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines the idMappingType and the providerProperties.
	//
	// IdMappingTechniques is a required field
	IdMappingTechniques *IdMappingTechniques `locationName:"idMappingTechniques" type:"structure" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*IdMappingWorkflowInputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path
	// and KMSArn.
	OutputSourceConfig []*IdMappingWorkflowOutputSource `locationName:"outputSourceConfig" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access Amazon Web Services resources on your behalf.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the workflow role. Entity Resolution assumes
	// this role to access Amazon Web Services resources on your behalf.
	//
	// WorkflowArn is a required field
	WorkflowArn *string `locationName:"workflowArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdMappingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdMappingWorkflowOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateIdMappingWorkflowOutput) SetDescription(v string) *UpdateIdMappingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIdMappingTechniques sets the IdMappingTechniques field's value.
func (s *UpdateIdMappingWorkflowOutput) SetIdMappingTechniques(v *IdMappingTechniques) *UpdateIdMappingWorkflowOutput {
	s.IdMappingTechniques = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *UpdateIdMappingWorkflowOutput) SetInputSourceConfig(v []*IdMappingWorkflowInputSource) *UpdateIdMappingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *UpdateIdMappingWorkflowOutput) SetOutputSourceConfig(v []*IdMappingWorkflowOutputSource) *UpdateIdMappingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateIdMappingWorkflowOutput) SetRoleArn(v string) *UpdateIdMappingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetWorkflowArn sets the WorkflowArn field's value.
func (s *UpdateIdMappingWorkflowOutput) SetWorkflowArn(v string) *UpdateIdMappingWorkflowOutput {
	s.WorkflowArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *UpdateIdMappingWorkflowOutput) SetWorkflowName(v string) *UpdateIdMappingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

type UpdateIdNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The description of the ID namespace.
	Description *string `locationName:"description" type:"string"`

	// Determines the properties of IdMappingWorkflow where this IdNamespace can
	// be used as a Source or a Target.
	IdMappingWorkflowProperties []*IdNamespaceIdMappingWorkflowProperties `locationName:"idMappingWorkflowProperties" min:"1" type:"list"`

	// The name of the ID namespace.
	//
	// IdNamespaceName is a required field
	IdNamespaceName *string `location:"uri" locationName:"idNamespaceName" min:"1" type:"string" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	InputSourceConfig []*IdNamespaceInputSource `locationName:"inputSourceConfig" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access the resources defined in this IdNamespace on your behalf
	// as part of a workflow run.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIdNamespaceInput"}
	if s.IdMappingWorkflowProperties != nil && len(s.IdMappingWorkflowProperties) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdMappingWorkflowProperties", 1))
	}
	if s.IdNamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdNamespaceName"))
	}
	if s.IdNamespaceName != nil && len(*s.IdNamespaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdNamespaceName", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.IdMappingWorkflowProperties != nil {
		for i, v := range s.IdMappingWorkflowProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IdMappingWorkflowProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InputSourceConfig != nil {
		for i, v := range s.InputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateIdNamespaceInput) SetDescription(v string) *UpdateIdNamespaceInput {
	s.Description = &v
	return s
}

// SetIdMappingWorkflowProperties sets the IdMappingWorkflowProperties field's value.
func (s *UpdateIdNamespaceInput) SetIdMappingWorkflowProperties(v []*IdNamespaceIdMappingWorkflowProperties) *UpdateIdNamespaceInput {
	s.IdMappingWorkflowProperties = v
	return s
}

// SetIdNamespaceName sets the IdNamespaceName field's value.
func (s *UpdateIdNamespaceInput) SetIdNamespaceName(v string) *UpdateIdNamespaceInput {
	s.IdNamespaceName = &v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *UpdateIdNamespaceInput) SetInputSourceConfig(v []*IdNamespaceInputSource) *UpdateIdNamespaceInput {
	s.InputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateIdNamespaceInput) SetRoleArn(v string) *UpdateIdNamespaceInput {
	s.RoleArn = &v
	return s
}

type UpdateIdNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the ID namespace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The description of the ID namespace.
	Description *string `locationName:"description" type:"string"`

	// Determines the properties of IdMappingWorkflow where this IdNamespace can
	// be used as a Source or a Target.
	IdMappingWorkflowProperties []*IdNamespaceIdMappingWorkflowProperties `locationName:"idMappingWorkflowProperties" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the ID namespace.
	//
	// IdNamespaceArn is a required field
	IdNamespaceArn *string `locationName:"idNamespaceArn" type:"string" required:"true"`

	// The name of the ID namespace.
	//
	// IdNamespaceName is a required field
	IdNamespaceName *string `locationName:"idNamespaceName" min:"1" type:"string" required:"true"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	InputSourceConfig []*IdNamespaceInputSource `locationName:"inputSourceConfig" type:"list"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to access the resources defined in this IdNamespace on your behalf
	// as part of a workflow run.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`

	// The type of ID namespace. There are two types: SOURCE and TARGET.
	//
	// The SOURCE contains configurations for sourceId data that will be processed
	// in an ID mapping workflow.
	//
	// The TARGET contains a configuration of targetId to which all sourceIds will
	// resolve to.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"IdNamespaceType"`

	// The timestamp of when the ID namespace was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIdNamespaceOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateIdNamespaceOutput) SetCreatedAt(v time.Time) *UpdateIdNamespaceOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateIdNamespaceOutput) SetDescription(v string) *UpdateIdNamespaceOutput {
	s.Description = &v
	return s
}

// SetIdMappingWorkflowProperties sets the IdMappingWorkflowProperties field's value.
func (s *UpdateIdNamespaceOutput) SetIdMappingWorkflowProperties(v []*IdNamespaceIdMappingWorkflowProperties) *UpdateIdNamespaceOutput {
	s.IdMappingWorkflowProperties = v
	return s
}

// SetIdNamespaceArn sets the IdNamespaceArn field's value.
func (s *UpdateIdNamespaceOutput) SetIdNamespaceArn(v string) *UpdateIdNamespaceOutput {
	s.IdNamespaceArn = &v
	return s
}

// SetIdNamespaceName sets the IdNamespaceName field's value.
func (s *UpdateIdNamespaceOutput) SetIdNamespaceName(v string) *UpdateIdNamespaceOutput {
	s.IdNamespaceName = &v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *UpdateIdNamespaceOutput) SetInputSourceConfig(v []*IdNamespaceInputSource) *UpdateIdNamespaceOutput {
	s.InputSourceConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateIdNamespaceOutput) SetRoleArn(v string) *UpdateIdNamespaceOutput {
	s.RoleArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateIdNamespaceOutput) SetType(v string) *UpdateIdNamespaceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateIdNamespaceOutput) SetUpdatedAt(v time.Time) *UpdateIdNamespaceOutput {
	s.UpdatedAt = &v
	return s
}

type UpdateMatchingWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties.
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the workflow to be retrieved.
	//
	// WorkflowName is a required field
	WorkflowName *string `location:"uri" locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMatchingWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMatchingWorkflowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMatchingWorkflowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMatchingWorkflowInput"}
	if s.InputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSourceConfig"))
	}
	if s.InputSourceConfig != nil && len(s.InputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSourceConfig", 1))
	}
	if s.OutputSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSourceConfig"))
	}
	if s.OutputSourceConfig != nil && len(s.OutputSourceConfig) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputSourceConfig", 1))
	}
	if s.ResolutionTechniques == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolutionTechniques"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.WorkflowName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowName"))
	}
	if s.WorkflowName != nil && len(*s.WorkflowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowName", 1))
	}
	if s.InputSourceConfig != nil {
		for i, v := range s.InputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputSourceConfig != nil {
		for i, v := range s.OutputSourceConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputSourceConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResolutionTechniques != nil {
		if err := s.ResolutionTechniques.Validate(); err != nil {
			invalidParams.AddNested("ResolutionTechniques", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateMatchingWorkflowInput) SetDescription(v string) *UpdateMatchingWorkflowInput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *UpdateMatchingWorkflowInput) SetIncrementalRunConfig(v *IncrementalRunConfig) *UpdateMatchingWorkflowInput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *UpdateMatchingWorkflowInput) SetInputSourceConfig(v []*InputSource) *UpdateMatchingWorkflowInput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *UpdateMatchingWorkflowInput) SetOutputSourceConfig(v []*OutputSource) *UpdateMatchingWorkflowInput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *UpdateMatchingWorkflowInput) SetResolutionTechniques(v *ResolutionTechniques) *UpdateMatchingWorkflowInput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateMatchingWorkflowInput) SetRoleArn(v string) *UpdateMatchingWorkflowInput {
	s.RoleArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *UpdateMatchingWorkflowInput) SetWorkflowName(v string) *UpdateMatchingWorkflowInput {
	s.WorkflowName = &v
	return s
}

type UpdateMatchingWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// A description of the workflow.
	Description *string `locationName:"description" type:"string"`

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *IncrementalRunConfig `locationName:"incrementalRunConfig" type:"structure"`

	// A list of InputSource objects, which have the fields InputSourceARN and SchemaName.
	//
	// InputSourceConfig is a required field
	InputSourceConfig []*InputSource `locationName:"inputSourceConfig" min:"1" type:"list" required:"true"`

	// A list of OutputSource objects, each of which contains fields OutputS3Path,
	// ApplyNormalization, and Output.
	//
	// OutputSourceConfig is a required field
	OutputSourceConfig []*OutputSource `locationName:"outputSourceConfig" min:"1" type:"list" required:"true"`

	// An object which defines the resolutionType and the ruleBasedProperties
	//
	// ResolutionTechniques is a required field
	ResolutionTechniques *ResolutionTechniques `locationName:"resolutionTechniques" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes
	// this role to create resources on your behalf as part of workflow execution.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the workflow.
	//
	// WorkflowName is a required field
	WorkflowName *string `locationName:"workflowName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMatchingWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMatchingWorkflowOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateMatchingWorkflowOutput) SetDescription(v string) *UpdateMatchingWorkflowOutput {
	s.Description = &v
	return s
}

// SetIncrementalRunConfig sets the IncrementalRunConfig field's value.
func (s *UpdateMatchingWorkflowOutput) SetIncrementalRunConfig(v *IncrementalRunConfig) *UpdateMatchingWorkflowOutput {
	s.IncrementalRunConfig = v
	return s
}

// SetInputSourceConfig sets the InputSourceConfig field's value.
func (s *UpdateMatchingWorkflowOutput) SetInputSourceConfig(v []*InputSource) *UpdateMatchingWorkflowOutput {
	s.InputSourceConfig = v
	return s
}

// SetOutputSourceConfig sets the OutputSourceConfig field's value.
func (s *UpdateMatchingWorkflowOutput) SetOutputSourceConfig(v []*OutputSource) *UpdateMatchingWorkflowOutput {
	s.OutputSourceConfig = v
	return s
}

// SetResolutionTechniques sets the ResolutionTechniques field's value.
func (s *UpdateMatchingWorkflowOutput) SetResolutionTechniques(v *ResolutionTechniques) *UpdateMatchingWorkflowOutput {
	s.ResolutionTechniques = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateMatchingWorkflowOutput) SetRoleArn(v string) *UpdateMatchingWorkflowOutput {
	s.RoleArn = &v
	return s
}

// SetWorkflowName sets the WorkflowName field's value.
func (s *UpdateMatchingWorkflowOutput) SetWorkflowName(v string) *UpdateMatchingWorkflowOutput {
	s.WorkflowName = &v
	return s
}

type UpdateSchemaMappingInput struct {
	_ struct{} `type:"structure"`

	// A description of the schema.
	Description *string `locationName:"description" type:"string"`

	// A list of MappedInputFields. Each MappedInputField corresponds to a column
	// the source data table, and contains column name plus additional information
	// that Entity Resolution uses for matching.
	//
	// MappedInputFields is a required field
	MappedInputFields []*SchemaInputAttribute `locationName:"mappedInputFields" min:"2" type:"list" required:"true"`

	// The name of the schema. There can't be multiple SchemaMappings with the same
	// name.
	//
	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchemaMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchemaMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSchemaMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSchemaMappingInput"}
	if s.MappedInputFields == nil {
		invalidParams.Add(request.NewErrParamRequired("MappedInputFields"))
	}
	if s.MappedInputFields != nil && len(s.MappedInputFields) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MappedInputFields", 2))
	}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.SchemaName != nil && len(*s.SchemaName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SchemaName", 1))
	}
	if s.MappedInputFields != nil {
		for i, v := range s.MappedInputFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MappedInputFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSchemaMappingInput) SetDescription(v string) *UpdateSchemaMappingInput {
	s.Description = &v
	return s
}

// SetMappedInputFields sets the MappedInputFields field's value.
func (s *UpdateSchemaMappingInput) SetMappedInputFields(v []*SchemaInputAttribute) *UpdateSchemaMappingInput {
	s.MappedInputFields = v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *UpdateSchemaMappingInput) SetSchemaName(v string) *UpdateSchemaMappingInput {
	s.SchemaName = &v
	return s
}

type UpdateSchemaMappingOutput struct {
	_ struct{} `type:"structure"`

	// A description of the schema.
	Description *string `locationName:"description" type:"string"`

	// A list of MappedInputFields. Each MappedInputField corresponds to a column
	// the source data table, and contains column name plus additional information
	// that Entity Resolution uses for matching.
	//
	// MappedInputFields is a required field
	MappedInputFields []*SchemaInputAttribute `locationName:"mappedInputFields" min:"2" type:"list" required:"true"`

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the SchemaMapping.
	//
	// SchemaArn is a required field
	SchemaArn *string `locationName:"schemaArn" type:"string" required:"true"`

	// The name of the schema.
	//
	// SchemaName is a required field
	SchemaName *string `locationName:"schemaName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchemaMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSchemaMappingOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateSchemaMappingOutput) SetDescription(v string) *UpdateSchemaMappingOutput {
	s.Description = &v
	return s
}

// SetMappedInputFields sets the MappedInputFields field's value.
func (s *UpdateSchemaMappingOutput) SetMappedInputFields(v []*SchemaInputAttribute) *UpdateSchemaMappingOutput {
	s.MappedInputFields = v
	return s
}

// SetSchemaArn sets the SchemaArn field's value.
func (s *UpdateSchemaMappingOutput) SetSchemaArn(v string) *UpdateSchemaMappingOutput {
	s.SchemaArn = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *UpdateSchemaMappingOutput) SetSchemaName(v string) *UpdateSchemaMappingOutput {
	s.SchemaName = &v
	return s
}

// The input fails to satisfy the constraints specified by Entity Resolution.
// HTTP Status Code: 400
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AttributeMatchingModelOneToOne is a AttributeMatchingModel enum value
	AttributeMatchingModelOneToOne = "ONE_TO_ONE"

	// AttributeMatchingModelManyToMany is a AttributeMatchingModel enum value
	AttributeMatchingModelManyToMany = "MANY_TO_MANY"
)

// AttributeMatchingModel_Values returns all elements of the AttributeMatchingModel enum
func AttributeMatchingModel_Values() []string {
	return []string{
		AttributeMatchingModelOneToOne,
		AttributeMatchingModelManyToMany,
	}
}

const (
	// DeleteUniqueIdErrorTypeServiceError is a DeleteUniqueIdErrorType enum value
	DeleteUniqueIdErrorTypeServiceError = "SERVICE_ERROR"

	// DeleteUniqueIdErrorTypeValidationError is a DeleteUniqueIdErrorType enum value
	DeleteUniqueIdErrorTypeValidationError = "VALIDATION_ERROR"
)

// DeleteUniqueIdErrorType_Values returns all elements of the DeleteUniqueIdErrorType enum
func DeleteUniqueIdErrorType_Values() []string {
	return []string{
		DeleteUniqueIdErrorTypeServiceError,
		DeleteUniqueIdErrorTypeValidationError,
	}
}

const (
	// DeleteUniqueIdStatusCompleted is a DeleteUniqueIdStatus enum value
	DeleteUniqueIdStatusCompleted = "COMPLETED"

	// DeleteUniqueIdStatusAccepted is a DeleteUniqueIdStatus enum value
	DeleteUniqueIdStatusAccepted = "ACCEPTED"
)

// DeleteUniqueIdStatus_Values returns all elements of the DeleteUniqueIdStatus enum
func DeleteUniqueIdStatus_Values() []string {
	return []string{
		DeleteUniqueIdStatusCompleted,
		DeleteUniqueIdStatusAccepted,
	}
}

const (
	// IdMappingTypeProvider is a IdMappingType enum value
	IdMappingTypeProvider = "PROVIDER"
)

// IdMappingType_Values returns all elements of the IdMappingType enum
func IdMappingType_Values() []string {
	return []string{
		IdMappingTypeProvider,
	}
}

const (
	// IdNamespaceTypeSource is a IdNamespaceType enum value
	IdNamespaceTypeSource = "SOURCE"

	// IdNamespaceTypeTarget is a IdNamespaceType enum value
	IdNamespaceTypeTarget = "TARGET"
)

// IdNamespaceType_Values returns all elements of the IdNamespaceType enum
func IdNamespaceType_Values() []string {
	return []string{
		IdNamespaceTypeSource,
		IdNamespaceTypeTarget,
	}
}

const (
	// IncrementalRunTypeImmediate is a IncrementalRunType enum value
	IncrementalRunTypeImmediate = "IMMEDIATE"
)

// IncrementalRunType_Values returns all elements of the IncrementalRunType enum
func IncrementalRunType_Values() []string {
	return []string{
		IncrementalRunTypeImmediate,
	}
}

const (
	// JobStatusRunning is a JobStatus enum value
	JobStatusRunning = "RUNNING"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "SUCCEEDED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusQueued is a JobStatus enum value
	JobStatusQueued = "QUEUED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusRunning,
		JobStatusSucceeded,
		JobStatusFailed,
		JobStatusQueued,
	}
}

const (
	// ResolutionTypeRuleMatching is a ResolutionType enum value
	ResolutionTypeRuleMatching = "RULE_MATCHING"

	// ResolutionTypeMlMatching is a ResolutionType enum value
	ResolutionTypeMlMatching = "ML_MATCHING"

	// ResolutionTypeProvider is a ResolutionType enum value
	ResolutionTypeProvider = "PROVIDER"
)

// ResolutionType_Values returns all elements of the ResolutionType enum
func ResolutionType_Values() []string {
	return []string{
		ResolutionTypeRuleMatching,
		ResolutionTypeMlMatching,
		ResolutionTypeProvider,
	}
}

const (
	// SchemaAttributeTypeName is a SchemaAttributeType enum value
	SchemaAttributeTypeName = "NAME"

	// SchemaAttributeTypeNameFirst is a SchemaAttributeType enum value
	SchemaAttributeTypeNameFirst = "NAME_FIRST"

	// SchemaAttributeTypeNameMiddle is a SchemaAttributeType enum value
	SchemaAttributeTypeNameMiddle = "NAME_MIDDLE"

	// SchemaAttributeTypeNameLast is a SchemaAttributeType enum value
	SchemaAttributeTypeNameLast = "NAME_LAST"

	// SchemaAttributeTypeAddress is a SchemaAttributeType enum value
	SchemaAttributeTypeAddress = "ADDRESS"

	// SchemaAttributeTypeAddressStreet1 is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressStreet1 = "ADDRESS_STREET1"

	// SchemaAttributeTypeAddressStreet2 is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressStreet2 = "ADDRESS_STREET2"

	// SchemaAttributeTypeAddressStreet3 is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressStreet3 = "ADDRESS_STREET3"

	// SchemaAttributeTypeAddressCity is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressCity = "ADDRESS_CITY"

	// SchemaAttributeTypeAddressState is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressState = "ADDRESS_STATE"

	// SchemaAttributeTypeAddressCountry is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressCountry = "ADDRESS_COUNTRY"

	// SchemaAttributeTypeAddressPostalcode is a SchemaAttributeType enum value
	SchemaAttributeTypeAddressPostalcode = "ADDRESS_POSTALCODE"

	// SchemaAttributeTypePhone is a SchemaAttributeType enum value
	SchemaAttributeTypePhone = "PHONE"

	// SchemaAttributeTypePhoneNumber is a SchemaAttributeType enum value
	SchemaAttributeTypePhoneNumber = "PHONE_NUMBER"

	// SchemaAttributeTypePhoneCountrycode is a SchemaAttributeType enum value
	SchemaAttributeTypePhoneCountrycode = "PHONE_COUNTRYCODE"

	// SchemaAttributeTypeEmailAddress is a SchemaAttributeType enum value
	SchemaAttributeTypeEmailAddress = "EMAIL_ADDRESS"

	// SchemaAttributeTypeUniqueId is a SchemaAttributeType enum value
	SchemaAttributeTypeUniqueId = "UNIQUE_ID"

	// SchemaAttributeTypeDate is a SchemaAttributeType enum value
	SchemaAttributeTypeDate = "DATE"

	// SchemaAttributeTypeString is a SchemaAttributeType enum value
	SchemaAttributeTypeString = "STRING"

	// SchemaAttributeTypeProviderId is a SchemaAttributeType enum value
	SchemaAttributeTypeProviderId = "PROVIDER_ID"
)

// SchemaAttributeType_Values returns all elements of the SchemaAttributeType enum
func SchemaAttributeType_Values() []string {
	return []string{
		SchemaAttributeTypeName,
		SchemaAttributeTypeNameFirst,
		SchemaAttributeTypeNameMiddle,
		SchemaAttributeTypeNameLast,
		SchemaAttributeTypeAddress,
		SchemaAttributeTypeAddressStreet1,
		SchemaAttributeTypeAddressStreet2,
		SchemaAttributeTypeAddressStreet3,
		SchemaAttributeTypeAddressCity,
		SchemaAttributeTypeAddressState,
		SchemaAttributeTypeAddressCountry,
		SchemaAttributeTypeAddressPostalcode,
		SchemaAttributeTypePhone,
		SchemaAttributeTypePhoneNumber,
		SchemaAttributeTypePhoneCountrycode,
		SchemaAttributeTypeEmailAddress,
		SchemaAttributeTypeUniqueId,
		SchemaAttributeTypeDate,
		SchemaAttributeTypeString,
		SchemaAttributeTypeProviderId,
	}
}

const (
	// ServiceTypeAssignment is a ServiceType enum value
	ServiceTypeAssignment = "ASSIGNMENT"

	// ServiceTypeIdMapping is a ServiceType enum value
	ServiceTypeIdMapping = "ID_MAPPING"
)

// ServiceType_Values returns all elements of the ServiceType enum
func ServiceType_Values() []string {
	return []string{
		ServiceTypeAssignment,
		ServiceTypeIdMapping,
	}
}

const (
	// StatementEffectAllow is a StatementEffect enum value
	StatementEffectAllow = "Allow"

	// StatementEffectDeny is a StatementEffect enum value
	StatementEffectDeny = "Deny"
)

// StatementEffect_Values returns all elements of the StatementEffect enum
func StatementEffect_Values() []string {
	return []string{
		StatementEffectAllow,
		StatementEffectDeny,
	}
}
