package web

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// StaticSitesClient is the webSite Management Client
type StaticSitesClient struct {
	BaseClient
}

// NewStaticSitesClient creates an instance of the StaticSitesClient client.
func NewStaticSitesClient(subscriptionID string) StaticSitesClient {
	return NewStaticSitesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewStaticSitesClientWithBaseURI creates an instance of the StaticSitesClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewStaticSitesClientWithBaseURI(baseURI string, subscriptionID string) StaticSitesClient {
	return StaticSitesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ApproveOrRejectPrivateEndpointConnection description for Approves or rejects a private endpoint connection
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// privateEndpointConnectionName - name of the private endpoint connection.
// privateEndpointWrapper - request body.
func (client StaticSitesClient) ApproveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource) (result StaticSitesApproveOrRejectPrivateEndpointConnectionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ApproveOrRejectPrivateEndpointConnection")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ApproveOrRejectPrivateEndpointConnection", err.Error())
	}

	req, err := client.ApproveOrRejectPrivateEndpointConnectionPreparer(ctx, resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ApproveOrRejectPrivateEndpointConnection", nil, "Failure preparing request")
		return
	}

	result, err = client.ApproveOrRejectPrivateEndpointConnectionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ApproveOrRejectPrivateEndpointConnection", result.Response(), "Failure sending request")
		return
	}

	return
}

// ApproveOrRejectPrivateEndpointConnectionPreparer prepares the ApproveOrRejectPrivateEndpointConnection request.
func (client StaticSitesClient) ApproveOrRejectPrivateEndpointConnectionPreparer(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper PrivateLinkConnectionApprovalRequestResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                          autorest.Encode("path", name),
		"privateEndpointConnectionName": autorest.Encode("path", privateEndpointConnectionName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}", pathParameters),
		autorest.WithJSON(privateEndpointWrapper),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ApproveOrRejectPrivateEndpointConnectionSender sends the ApproveOrRejectPrivateEndpointConnection request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ApproveOrRejectPrivateEndpointConnectionSender(req *http.Request) (future StaticSitesApproveOrRejectPrivateEndpointConnectionFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ApproveOrRejectPrivateEndpointConnectionResponder handles the response to the ApproveOrRejectPrivateEndpointConnection request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ApproveOrRejectPrivateEndpointConnectionResponder(resp *http.Response) (result RemotePrivateEndpointConnectionARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSite description for Creates a new static site in an existing resource group, or updates an
// existing static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site to create or update.
// staticSiteEnvelope - a JSON representation of the staticsite properties. See example.
func (client StaticSitesClient) CreateOrUpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSiteARMResource) (result StaticSitesCreateOrUpdateStaticSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSite", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSitePreparer(ctx, resourceGroupName, name, staticSiteEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSite", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSite", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateStaticSitePreparer prepares the CreateOrUpdateStaticSite request.
func (client StaticSitesClient) CreateOrUpdateStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSiteARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}", pathParameters),
		autorest.WithJSON(staticSiteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteSender sends the CreateOrUpdateStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteSender(req *http.Request) (future StaticSitesCreateOrUpdateStaticSiteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateStaticSiteResponder handles the response to the CreateOrUpdateStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteResponder(resp *http.Response) (result StaticSiteARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSiteAppSettings description for Creates or updates the app settings of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// appSettings - the dictionary containing the static site app settings to update.
func (client StaticSitesClient) CreateOrUpdateStaticSiteAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSiteAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSiteAppSettings", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSiteAppSettingsPreparer(ctx, resourceGroupName, name, appSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateStaticSiteAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateStaticSiteAppSettingsPreparer prepares the CreateOrUpdateStaticSiteAppSettings request.
func (client StaticSitesClient) CreateOrUpdateStaticSiteAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/appsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteAppSettingsSender sends the CreateOrUpdateStaticSiteAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateStaticSiteAppSettingsResponder handles the response to the CreateOrUpdateStaticSiteAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSiteBuildAppSettings description for Creates or updates the app settings of a static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
// appSettings - the dictionary containing the static site app settings to update.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings StringDictionary) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSiteBuildAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildAppSettings", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSiteBuildAppSettingsPreparer(ctx, resourceGroupName, name, environmentName, appSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateStaticSiteBuildAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteBuildAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateStaticSiteBuildAppSettingsPreparer prepares the CreateOrUpdateStaticSiteBuildAppSettings request.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/config/appsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteBuildAppSettingsSender sends the CreateOrUpdateStaticSiteBuildAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateStaticSiteBuildAppSettingsResponder handles the response to the CreateOrUpdateStaticSiteBuildAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettings description for Creates or updates the function app settings of a
// static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
// appSettings - the dictionary containing the static site function app settings to update.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings StringDictionary) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSiteBuildFunctionAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildFunctionAppSettings", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSiteBuildFunctionAppSettingsPreparer(ctx, resourceGroupName, name, environmentName, appSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildFunctionAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateStaticSiteBuildFunctionAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildFunctionAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteBuildFunctionAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildFunctionAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettingsPreparer prepares the CreateOrUpdateStaticSiteBuildFunctionAppSettings request.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/config/functionappsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettingsSender sends the CreateOrUpdateStaticSiteBuildFunctionAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettingsResponder handles the response to the CreateOrUpdateStaticSiteBuildFunctionAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSiteCustomDomain description for Creates a new static site custom domain in an existing resource
// group and static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// domainName - the custom domain to create.
// staticSiteCustomDomainRequestPropertiesEnvelope - a JSON representation of the static site custom domain
// request properties. See example.
func (client StaticSitesClient) CreateOrUpdateStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource) (result StaticSitesCreateOrUpdateStaticSiteCustomDomainFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSiteCustomDomain")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSiteCustomDomain", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSiteCustomDomainPreparer(ctx, resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteCustomDomain", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteCustomDomainSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteCustomDomain", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateStaticSiteCustomDomainPreparer prepares the CreateOrUpdateStaticSiteCustomDomain request.
func (client StaticSitesClient) CreateOrUpdateStaticSiteCustomDomainPreparer(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}", pathParameters),
		autorest.WithJSON(staticSiteCustomDomainRequestPropertiesEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteCustomDomainSender sends the CreateOrUpdateStaticSiteCustomDomain request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteCustomDomainSender(req *http.Request) (future StaticSitesCreateOrUpdateStaticSiteCustomDomainFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateStaticSiteCustomDomainResponder handles the response to the CreateOrUpdateStaticSiteCustomDomain request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteCustomDomainResponder(resp *http.Response) (result StaticSiteCustomDomainOverviewARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSiteFunctionAppSettings description for Creates or updates the function app settings of a static
// site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// appSettings - the dictionary containing the static site function app settings to update.
func (client StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSiteFunctionAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSiteFunctionAppSettings", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSiteFunctionAppSettingsPreparer(ctx, resourceGroupName, name, appSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteFunctionAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateStaticSiteFunctionAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteFunctionAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteFunctionAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteFunctionAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateStaticSiteFunctionAppSettingsPreparer prepares the CreateOrUpdateStaticSiteFunctionAppSettings request.
func (client StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/functionappsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteFunctionAppSettingsSender sends the CreateOrUpdateStaticSiteFunctionAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateStaticSiteFunctionAppSettingsResponder handles the response to the CreateOrUpdateStaticSiteFunctionAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUserRolesInvitationLink description for Creates an invitation link for a user with the role
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) CreateUserRolesInvitationLink(ctx context.Context, resourceGroupName string, name string, staticSiteUserRolesInvitationEnvelope StaticSiteUserInvitationRequestResource) (result StaticSiteUserInvitationResponseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateUserRolesInvitationLink")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateUserRolesInvitationLink", err.Error())
	}

	req, err := client.CreateUserRolesInvitationLinkPreparer(ctx, resourceGroupName, name, staticSiteUserRolesInvitationEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateUserRolesInvitationLink", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateUserRolesInvitationLinkSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateUserRolesInvitationLink", resp, "Failure sending request")
		return
	}

	result, err = client.CreateUserRolesInvitationLinkResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateUserRolesInvitationLink", resp, "Failure responding to request")
		return
	}

	return
}

// CreateUserRolesInvitationLinkPreparer prepares the CreateUserRolesInvitationLink request.
func (client StaticSitesClient) CreateUserRolesInvitationLinkPreparer(ctx context.Context, resourceGroupName string, name string, staticSiteUserRolesInvitationEnvelope StaticSiteUserInvitationRequestResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/createUserInvitation", pathParameters),
		autorest.WithJSON(staticSiteUserRolesInvitationEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUserRolesInvitationLinkSender sends the CreateUserRolesInvitationLink request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateUserRolesInvitationLinkSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateUserRolesInvitationLinkResponder handles the response to the CreateUserRolesInvitationLink request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateUserRolesInvitationLinkResponder(resp *http.Response) (result StaticSiteUserInvitationResponseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateZipDeploymentForStaticSite description for Deploys zipped content to a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// staticSiteZipDeploymentEnvelope - a JSON representation of the StaticSiteZipDeployment properties. See
// example.
func (client StaticSitesClient) CreateZipDeploymentForStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource) (result StaticSitesCreateZipDeploymentForStaticSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateZipDeploymentForStaticSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateZipDeploymentForStaticSite", err.Error())
	}

	req, err := client.CreateZipDeploymentForStaticSitePreparer(ctx, resourceGroupName, name, staticSiteZipDeploymentEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateZipDeploymentForStaticSite", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateZipDeploymentForStaticSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateZipDeploymentForStaticSite", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateZipDeploymentForStaticSitePreparer prepares the CreateZipDeploymentForStaticSite request.
func (client StaticSitesClient) CreateZipDeploymentForStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/zipdeploy", pathParameters),
		autorest.WithJSON(staticSiteZipDeploymentEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateZipDeploymentForStaticSiteSender sends the CreateZipDeploymentForStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateZipDeploymentForStaticSiteSender(req *http.Request) (future StaticSitesCreateZipDeploymentForStaticSiteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateZipDeploymentForStaticSiteResponder handles the response to the CreateZipDeploymentForStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateZipDeploymentForStaticSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateZipDeploymentForStaticSiteBuild description for Deploys zipped content to a specific environment of a static
// site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - name of the environment.
// staticSiteZipDeploymentEnvelope - a JSON representation of the StaticSiteZipDeployment properties. See
// example.
func (client StaticSitesClient) CreateZipDeploymentForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource) (result StaticSitesCreateZipDeploymentForStaticSiteBuildFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateZipDeploymentForStaticSiteBuild")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateZipDeploymentForStaticSiteBuild", err.Error())
	}

	req, err := client.CreateZipDeploymentForStaticSiteBuildPreparer(ctx, resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateZipDeploymentForStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateZipDeploymentForStaticSiteBuildSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateZipDeploymentForStaticSiteBuild", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateZipDeploymentForStaticSiteBuildPreparer prepares the CreateZipDeploymentForStaticSiteBuild request.
func (client StaticSitesClient) CreateZipDeploymentForStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string, staticSiteZipDeploymentEnvelope StaticSiteZipDeploymentARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/zipdeploy", pathParameters),
		autorest.WithJSON(staticSiteZipDeploymentEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateZipDeploymentForStaticSiteBuildSender sends the CreateZipDeploymentForStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateZipDeploymentForStaticSiteBuildSender(req *http.Request) (future StaticSitesCreateZipDeploymentForStaticSiteBuildFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateZipDeploymentForStaticSiteBuildResponder handles the response to the CreateZipDeploymentForStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateZipDeploymentForStaticSiteBuildResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePrivateEndpointConnection description for Deletes a private endpoint connection
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// privateEndpointConnectionName - name of the private endpoint connection.
func (client StaticSitesClient) DeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result StaticSitesDeletePrivateEndpointConnectionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeletePrivateEndpointConnection")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeletePrivateEndpointConnection", err.Error())
	}

	req, err := client.DeletePrivateEndpointConnectionPreparer(ctx, resourceGroupName, name, privateEndpointConnectionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeletePrivateEndpointConnection", nil, "Failure preparing request")
		return
	}

	result, err = client.DeletePrivateEndpointConnectionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeletePrivateEndpointConnection", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePrivateEndpointConnectionPreparer prepares the DeletePrivateEndpointConnection request.
func (client StaticSitesClient) DeletePrivateEndpointConnectionPreparer(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                          autorest.Encode("path", name),
		"privateEndpointConnectionName": autorest.Encode("path", privateEndpointConnectionName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePrivateEndpointConnectionSender sends the DeletePrivateEndpointConnection request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeletePrivateEndpointConnectionSender(req *http.Request) (future StaticSitesDeletePrivateEndpointConnectionFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeletePrivateEndpointConnectionResponder handles the response to the DeletePrivateEndpointConnection request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeletePrivateEndpointConnectionResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteStaticSite description for Deletes a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site to delete.
func (client StaticSitesClient) DeleteStaticSite(ctx context.Context, resourceGroupName string, name string) (result StaticSitesDeleteStaticSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeleteStaticSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeleteStaticSite", err.Error())
	}

	req, err := client.DeleteStaticSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSite", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteStaticSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSite", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteStaticSitePreparer prepares the DeleteStaticSite request.
func (client StaticSitesClient) DeleteStaticSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStaticSiteSender sends the DeleteStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeleteStaticSiteSender(req *http.Request) (future StaticSitesDeleteStaticSiteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteStaticSiteResponder handles the response to the DeleteStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeleteStaticSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteStaticSiteBuild description for Deletes a static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
func (client StaticSitesClient) DeleteStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string) (result StaticSitesDeleteStaticSiteBuildFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeleteStaticSiteBuild")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeleteStaticSiteBuild", err.Error())
	}

	req, err := client.DeleteStaticSiteBuildPreparer(ctx, resourceGroupName, name, environmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteStaticSiteBuildSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteBuild", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteStaticSiteBuildPreparer prepares the DeleteStaticSiteBuild request.
func (client StaticSitesClient) DeleteStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStaticSiteBuildSender sends the DeleteStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeleteStaticSiteBuildSender(req *http.Request) (future StaticSitesDeleteStaticSiteBuildFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteStaticSiteBuildResponder handles the response to the DeleteStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeleteStaticSiteBuildResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteStaticSiteCustomDomain description for Deletes a custom domain.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// domainName - the custom domain to delete.
func (client StaticSitesClient) DeleteStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string) (result StaticSitesDeleteStaticSiteCustomDomainFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeleteStaticSiteCustomDomain")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeleteStaticSiteCustomDomain", err.Error())
	}

	req, err := client.DeleteStaticSiteCustomDomainPreparer(ctx, resourceGroupName, name, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteCustomDomain", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteStaticSiteCustomDomainSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteCustomDomain", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteStaticSiteCustomDomainPreparer prepares the DeleteStaticSiteCustomDomain request.
func (client StaticSitesClient) DeleteStaticSiteCustomDomainPreparer(ctx context.Context, resourceGroupName string, name string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStaticSiteCustomDomainSender sends the DeleteStaticSiteCustomDomain request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeleteStaticSiteCustomDomainSender(req *http.Request) (future StaticSitesDeleteStaticSiteCustomDomainFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteStaticSiteCustomDomainResponder handles the response to the DeleteStaticSiteCustomDomain request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeleteStaticSiteCustomDomainResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteStaticSiteUser description for Deletes the user entry from the static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the staticsite.
// authprovider - the auth provider for this user.
// userid - the user id of the user.
func (client StaticSitesClient) DeleteStaticSiteUser(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeleteStaticSiteUser")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeleteStaticSiteUser", err.Error())
	}

	req, err := client.DeleteStaticSiteUserPreparer(ctx, resourceGroupName, name, authprovider, userid)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteUser", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteStaticSiteUserSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteUser", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteStaticSiteUserResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteUser", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteStaticSiteUserPreparer prepares the DeleteStaticSiteUser request.
func (client StaticSitesClient) DeleteStaticSiteUserPreparer(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authprovider":      autorest.Encode("path", authprovider),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"userid":            autorest.Encode("path", userid),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStaticSiteUserSender sends the DeleteStaticSiteUser request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeleteStaticSiteUserSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteStaticSiteUserResponder handles the response to the DeleteStaticSiteUser request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeleteStaticSiteUserResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DetachStaticSite description for Detaches a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site to detach.
func (client StaticSitesClient) DetachStaticSite(ctx context.Context, resourceGroupName string, name string) (result StaticSitesDetachStaticSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DetachStaticSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DetachStaticSite", err.Error())
	}

	req, err := client.DetachStaticSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachStaticSite", nil, "Failure preparing request")
		return
	}

	result, err = client.DetachStaticSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachStaticSite", result.Response(), "Failure sending request")
		return
	}

	return
}

// DetachStaticSitePreparer prepares the DetachStaticSite request.
func (client StaticSitesClient) DetachStaticSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/detach", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DetachStaticSiteSender sends the DetachStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DetachStaticSiteSender(req *http.Request) (future StaticSitesDetachStaticSiteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DetachStaticSiteResponder handles the response to the DetachStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DetachStaticSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DetachUserProvidedFunctionAppFromStaticSite description for Detach the user provided function app from the static
// site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// functionAppName - name of the function app registered with the static site.
func (client StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSite")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DetachUserProvidedFunctionAppFromStaticSite", err.Error())
	}

	req, err := client.DetachUserProvidedFunctionAppFromStaticSitePreparer(ctx, resourceGroupName, name, functionAppName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachUserProvidedFunctionAppFromStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.DetachUserProvidedFunctionAppFromStaticSiteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachUserProvidedFunctionAppFromStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.DetachUserProvidedFunctionAppFromStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachUserProvidedFunctionAppFromStaticSite", resp, "Failure responding to request")
		return
	}

	return
}

// DetachUserProvidedFunctionAppFromStaticSitePreparer prepares the DetachUserProvidedFunctionAppFromStaticSite request.
func (client StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, functionAppName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionAppName":   autorest.Encode("path", functionAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DetachUserProvidedFunctionAppFromStaticSiteSender sends the DetachUserProvidedFunctionAppFromStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DetachUserProvidedFunctionAppFromStaticSiteResponder handles the response to the DetachUserProvidedFunctionAppFromStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DetachUserProvidedFunctionAppFromStaticSiteBuild description for Detach the user provided function app from the
// static site build
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
// functionAppName - name of the function app registered with the static site build.
func (client StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSiteBuild")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DetachUserProvidedFunctionAppFromStaticSiteBuild", err.Error())
	}

	req, err := client.DetachUserProvidedFunctionAppFromStaticSiteBuildPreparer(ctx, resourceGroupName, name, environmentName, functionAppName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachUserProvidedFunctionAppFromStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	resp, err := client.DetachUserProvidedFunctionAppFromStaticSiteBuildSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachUserProvidedFunctionAppFromStaticSiteBuild", resp, "Failure sending request")
		return
	}

	result, err = client.DetachUserProvidedFunctionAppFromStaticSiteBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachUserProvidedFunctionAppFromStaticSiteBuild", resp, "Failure responding to request")
		return
	}

	return
}

// DetachUserProvidedFunctionAppFromStaticSiteBuildPreparer prepares the DetachUserProvidedFunctionAppFromStaticSiteBuild request.
func (client StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"functionAppName":   autorest.Encode("path", functionAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DetachUserProvidedFunctionAppFromStaticSiteBuildSender sends the DetachUserProvidedFunctionAppFromStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSiteBuildSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DetachUserProvidedFunctionAppFromStaticSiteBuildResponder handles the response to the DetachUserProvidedFunctionAppFromStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DetachUserProvidedFunctionAppFromStaticSiteBuildResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetPrivateEndpointConnection description for Gets a private endpoint connection
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// privateEndpointConnectionName - name of the private endpoint connection.
func (client StaticSitesClient) GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result RemotePrivateEndpointConnectionARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetPrivateEndpointConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetPrivateEndpointConnection", err.Error())
	}

	req, err := client.GetPrivateEndpointConnectionPreparer(ctx, resourceGroupName, name, privateEndpointConnectionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateEndpointConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrivateEndpointConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateEndpointConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrivateEndpointConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateEndpointConnection", resp, "Failure responding to request")
		return
	}

	return
}

// GetPrivateEndpointConnectionPreparer prepares the GetPrivateEndpointConnection request.
func (client StaticSitesClient) GetPrivateEndpointConnectionPreparer(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                          autorest.Encode("path", name),
		"privateEndpointConnectionName": autorest.Encode("path", privateEndpointConnectionName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrivateEndpointConnectionSender sends the GetPrivateEndpointConnection request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetPrivateEndpointConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPrivateEndpointConnectionResponder handles the response to the GetPrivateEndpointConnection request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetPrivateEndpointConnectionResponder(resp *http.Response) (result RemotePrivateEndpointConnectionARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrivateEndpointConnectionList description for Gets the list of private endpoint connections associated with a
// static site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) GetPrivateEndpointConnectionList(ctx context.Context, resourceGroupName string, name string) (result PrivateEndpointConnectionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetPrivateEndpointConnectionList")
		defer func() {
			sc := -1
			if result.pecc.Response.Response != nil {
				sc = result.pecc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetPrivateEndpointConnectionList", err.Error())
	}

	result.fn = client.getPrivateEndpointConnectionListNextResults
	req, err := client.GetPrivateEndpointConnectionListPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateEndpointConnectionList", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrivateEndpointConnectionListSender(req)
	if err != nil {
		result.pecc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateEndpointConnectionList", resp, "Failure sending request")
		return
	}

	result.pecc, err = client.GetPrivateEndpointConnectionListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateEndpointConnectionList", resp, "Failure responding to request")
		return
	}
	if result.pecc.hasNextLink() && result.pecc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetPrivateEndpointConnectionListPreparer prepares the GetPrivateEndpointConnectionList request.
func (client StaticSitesClient) GetPrivateEndpointConnectionListPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrivateEndpointConnectionListSender sends the GetPrivateEndpointConnectionList request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetPrivateEndpointConnectionListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPrivateEndpointConnectionListResponder handles the response to the GetPrivateEndpointConnectionList request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetPrivateEndpointConnectionListResponder(resp *http.Response) (result PrivateEndpointConnectionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getPrivateEndpointConnectionListNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) getPrivateEndpointConnectionListNextResults(ctx context.Context, lastResults PrivateEndpointConnectionCollection) (result PrivateEndpointConnectionCollection, err error) {
	req, err := lastResults.privateEndpointConnectionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getPrivateEndpointConnectionListNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetPrivateEndpointConnectionListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getPrivateEndpointConnectionListNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetPrivateEndpointConnectionListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "getPrivateEndpointConnectionListNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetPrivateEndpointConnectionListComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) GetPrivateEndpointConnectionListComplete(ctx context.Context, resourceGroupName string, name string) (result PrivateEndpointConnectionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetPrivateEndpointConnectionList")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetPrivateEndpointConnectionList(ctx, resourceGroupName, name)
	return
}

// GetPrivateLinkResources description for Gets the private link resources
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the site.
func (client StaticSitesClient) GetPrivateLinkResources(ctx context.Context, resourceGroupName string, name string) (result PrivateLinkResourcesWrapper, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetPrivateLinkResources")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetPrivateLinkResources", err.Error())
	}

	req, err := client.GetPrivateLinkResourcesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateLinkResources", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrivateLinkResourcesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateLinkResources", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrivateLinkResourcesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetPrivateLinkResources", resp, "Failure responding to request")
		return
	}

	return
}

// GetPrivateLinkResourcesPreparer prepares the GetPrivateLinkResources request.
func (client StaticSitesClient) GetPrivateLinkResourcesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateLinkResources", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrivateLinkResourcesSender sends the GetPrivateLinkResources request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetPrivateLinkResourcesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetPrivateLinkResourcesResponder handles the response to the GetPrivateLinkResources request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetPrivateLinkResourcesResponder(resp *http.Response) (result PrivateLinkResourcesWrapper, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStaticSite description for Gets the details of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) GetStaticSite(ctx context.Context, resourceGroupName string, name string) (result StaticSiteARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSite", err.Error())
	}

	req, err := client.GetStaticSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.GetStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSite", resp, "Failure responding to request")
		return
	}

	return
}

// GetStaticSitePreparer prepares the GetStaticSite request.
func (client StaticSitesClient) GetStaticSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSiteSender sends the GetStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSiteResponder handles the response to the GetStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSiteResponder(resp *http.Response) (result StaticSiteARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStaticSiteBuild description for Gets the details of a static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
func (client StaticSitesClient) GetStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string) (result StaticSiteBuildARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSiteBuild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSiteBuild", err.Error())
	}

	req, err := client.GetStaticSiteBuildPreparer(ctx, resourceGroupName, name, environmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSiteBuildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuild", resp, "Failure sending request")
		return
	}

	result, err = client.GetStaticSiteBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuild", resp, "Failure responding to request")
		return
	}

	return
}

// GetStaticSiteBuildPreparer prepares the GetStaticSiteBuild request.
func (client StaticSitesClient) GetStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSiteBuildSender sends the GetStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSiteBuildSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSiteBuildResponder handles the response to the GetStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSiteBuildResponder(resp *http.Response) (result StaticSiteBuildARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStaticSiteBuilds description for Gets all static site builds for a particular static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) GetStaticSiteBuilds(ctx context.Context, resourceGroupName string, name string) (result StaticSiteBuildCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSiteBuilds")
		defer func() {
			sc := -1
			if result.ssbc.Response.Response != nil {
				sc = result.ssbc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSiteBuilds", err.Error())
	}

	result.fn = client.getStaticSiteBuildsNextResults
	req, err := client.GetStaticSiteBuildsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuilds", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSiteBuildsSender(req)
	if err != nil {
		result.ssbc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuilds", resp, "Failure sending request")
		return
	}

	result.ssbc, err = client.GetStaticSiteBuildsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuilds", resp, "Failure responding to request")
		return
	}
	if result.ssbc.hasNextLink() && result.ssbc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetStaticSiteBuildsPreparer prepares the GetStaticSiteBuilds request.
func (client StaticSitesClient) GetStaticSiteBuildsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSiteBuildsSender sends the GetStaticSiteBuilds request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSiteBuildsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSiteBuildsResponder handles the response to the GetStaticSiteBuilds request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSiteBuildsResponder(resp *http.Response) (result StaticSiteBuildCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getStaticSiteBuildsNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) getStaticSiteBuildsNextResults(ctx context.Context, lastResults StaticSiteBuildCollection) (result StaticSiteBuildCollection, err error) {
	req, err := lastResults.staticSiteBuildCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSiteBuildsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetStaticSiteBuildsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSiteBuildsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetStaticSiteBuildsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSiteBuildsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetStaticSiteBuildsComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) GetStaticSiteBuildsComplete(ctx context.Context, resourceGroupName string, name string) (result StaticSiteBuildCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSiteBuilds")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetStaticSiteBuilds(ctx, resourceGroupName, name)
	return
}

// GetStaticSiteCustomDomain description for Gets an existing custom domain for a particular static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site resource to search in.
// domainName - the custom domain name.
func (client StaticSitesClient) GetStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string) (result StaticSiteCustomDomainOverviewARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSiteCustomDomain")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSiteCustomDomain", err.Error())
	}

	req, err := client.GetStaticSiteCustomDomainPreparer(ctx, resourceGroupName, name, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteCustomDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSiteCustomDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteCustomDomain", resp, "Failure sending request")
		return
	}

	result, err = client.GetStaticSiteCustomDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteCustomDomain", resp, "Failure responding to request")
		return
	}

	return
}

// GetStaticSiteCustomDomainPreparer prepares the GetStaticSiteCustomDomain request.
func (client StaticSitesClient) GetStaticSiteCustomDomainPreparer(ctx context.Context, resourceGroupName string, name string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSiteCustomDomainSender sends the GetStaticSiteCustomDomain request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSiteCustomDomainSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSiteCustomDomainResponder handles the response to the GetStaticSiteCustomDomain request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSiteCustomDomainResponder(resp *http.Response) (result StaticSiteCustomDomainOverviewARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStaticSitesByResourceGroup description for Gets all static sites in the specified resource group.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
func (client StaticSitesClient) GetStaticSitesByResourceGroup(ctx context.Context, resourceGroupName string) (result StaticSiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSitesByResourceGroup")
		defer func() {
			sc := -1
			if result.ssc.Response.Response != nil {
				sc = result.ssc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSitesByResourceGroup", err.Error())
	}

	result.fn = client.getStaticSitesByResourceGroupNextResults
	req, err := client.GetStaticSitesByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSitesByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSitesByResourceGroupSender(req)
	if err != nil {
		result.ssc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSitesByResourceGroup", resp, "Failure sending request")
		return
	}

	result.ssc, err = client.GetStaticSitesByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSitesByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.ssc.hasNextLink() && result.ssc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetStaticSitesByResourceGroupPreparer prepares the GetStaticSitesByResourceGroup request.
func (client StaticSitesClient) GetStaticSitesByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSitesByResourceGroupSender sends the GetStaticSitesByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSitesByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSitesByResourceGroupResponder handles the response to the GetStaticSitesByResourceGroup request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSitesByResourceGroupResponder(resp *http.Response) (result StaticSiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getStaticSitesByResourceGroupNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) getStaticSitesByResourceGroupNextResults(ctx context.Context, lastResults StaticSiteCollection) (result StaticSiteCollection, err error) {
	req, err := lastResults.staticSiteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSitesByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetStaticSitesByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSitesByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetStaticSitesByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSitesByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetStaticSitesByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) GetStaticSitesByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result StaticSiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSitesByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetStaticSitesByResourceGroup(ctx, resourceGroupName)
	return
}

// GetUserProvidedFunctionAppForStaticSite description for Gets the details of the user provided function app
// registered with a static site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// functionAppName - name of the function app registered with the static site.
func (client StaticSitesClient) GetUserProvidedFunctionAppForStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string) (result StaticSiteUserProvidedFunctionAppARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetUserProvidedFunctionAppForStaticSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetUserProvidedFunctionAppForStaticSite", err.Error())
	}

	req, err := client.GetUserProvidedFunctionAppForStaticSitePreparer(ctx, resourceGroupName, name, functionAppName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppForStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetUserProvidedFunctionAppForStaticSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppForStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.GetUserProvidedFunctionAppForStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppForStaticSite", resp, "Failure responding to request")
		return
	}

	return
}

// GetUserProvidedFunctionAppForStaticSitePreparer prepares the GetUserProvidedFunctionAppForStaticSite request.
func (client StaticSitesClient) GetUserProvidedFunctionAppForStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, functionAppName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionAppName":   autorest.Encode("path", functionAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetUserProvidedFunctionAppForStaticSiteSender sends the GetUserProvidedFunctionAppForStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetUserProvidedFunctionAppForStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetUserProvidedFunctionAppForStaticSiteResponder handles the response to the GetUserProvidedFunctionAppForStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetUserProvidedFunctionAppForStaticSiteResponder(resp *http.Response) (result StaticSiteUserProvidedFunctionAppARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetUserProvidedFunctionAppForStaticSiteBuild description for Gets the details of the user provided function app
// registered with a static site build
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
// functionAppName - name of the function app registered with the static site build.
func (client StaticSitesClient) GetUserProvidedFunctionAppForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string) (result StaticSiteUserProvidedFunctionAppARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetUserProvidedFunctionAppForStaticSiteBuild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetUserProvidedFunctionAppForStaticSiteBuild", err.Error())
	}

	req, err := client.GetUserProvidedFunctionAppForStaticSiteBuildPreparer(ctx, resourceGroupName, name, environmentName, functionAppName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppForStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetUserProvidedFunctionAppForStaticSiteBuildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppForStaticSiteBuild", resp, "Failure sending request")
		return
	}

	result, err = client.GetUserProvidedFunctionAppForStaticSiteBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppForStaticSiteBuild", resp, "Failure responding to request")
		return
	}

	return
}

// GetUserProvidedFunctionAppForStaticSiteBuildPreparer prepares the GetUserProvidedFunctionAppForStaticSiteBuild request.
func (client StaticSitesClient) GetUserProvidedFunctionAppForStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"functionAppName":   autorest.Encode("path", functionAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetUserProvidedFunctionAppForStaticSiteBuildSender sends the GetUserProvidedFunctionAppForStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetUserProvidedFunctionAppForStaticSiteBuildSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetUserProvidedFunctionAppForStaticSiteBuildResponder handles the response to the GetUserProvidedFunctionAppForStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetUserProvidedFunctionAppForStaticSiteBuildResponder(resp *http.Response) (result StaticSiteUserProvidedFunctionAppARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetUserProvidedFunctionAppsForStaticSite description for Gets the details of the user provided function apps
// registered with a static site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSite(ctx context.Context, resourceGroupName string, name string) (result StaticSiteUserProvidedFunctionAppsCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetUserProvidedFunctionAppsForStaticSite")
		defer func() {
			sc := -1
			if result.ssupfac.Response.Response != nil {
				sc = result.ssupfac.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetUserProvidedFunctionAppsForStaticSite", err.Error())
	}

	result.fn = client.getUserProvidedFunctionAppsForStaticSiteNextResults
	req, err := client.GetUserProvidedFunctionAppsForStaticSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppsForStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetUserProvidedFunctionAppsForStaticSiteSender(req)
	if err != nil {
		result.ssupfac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppsForStaticSite", resp, "Failure sending request")
		return
	}

	result.ssupfac, err = client.GetUserProvidedFunctionAppsForStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppsForStaticSite", resp, "Failure responding to request")
		return
	}
	if result.ssupfac.hasNextLink() && result.ssupfac.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetUserProvidedFunctionAppsForStaticSitePreparer prepares the GetUserProvidedFunctionAppsForStaticSite request.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetUserProvidedFunctionAppsForStaticSiteSender sends the GetUserProvidedFunctionAppsForStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetUserProvidedFunctionAppsForStaticSiteResponder handles the response to the GetUserProvidedFunctionAppsForStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSiteResponder(resp *http.Response) (result StaticSiteUserProvidedFunctionAppsCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getUserProvidedFunctionAppsForStaticSiteNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) getUserProvidedFunctionAppsForStaticSiteNextResults(ctx context.Context, lastResults StaticSiteUserProvidedFunctionAppsCollection) (result StaticSiteUserProvidedFunctionAppsCollection, err error) {
	req, err := lastResults.staticSiteUserProvidedFunctionAppsCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getUserProvidedFunctionAppsForStaticSiteNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetUserProvidedFunctionAppsForStaticSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getUserProvidedFunctionAppsForStaticSiteNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetUserProvidedFunctionAppsForStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "getUserProvidedFunctionAppsForStaticSiteNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetUserProvidedFunctionAppsForStaticSiteComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSiteComplete(ctx context.Context, resourceGroupName string, name string) (result StaticSiteUserProvidedFunctionAppsCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetUserProvidedFunctionAppsForStaticSite")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetUserProvidedFunctionAppsForStaticSite(ctx, resourceGroupName, name)
	return
}

// GetUserProvidedFunctionAppsForStaticSiteBuild description for Gets the details of the user provided function apps
// registered with a static site build
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string) (result StaticSiteUserProvidedFunctionAppsCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetUserProvidedFunctionAppsForStaticSiteBuild")
		defer func() {
			sc := -1
			if result.ssupfac.Response.Response != nil {
				sc = result.ssupfac.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetUserProvidedFunctionAppsForStaticSiteBuild", err.Error())
	}

	result.fn = client.getUserProvidedFunctionAppsForStaticSiteBuildNextResults
	req, err := client.GetUserProvidedFunctionAppsForStaticSiteBuildPreparer(ctx, resourceGroupName, name, environmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppsForStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetUserProvidedFunctionAppsForStaticSiteBuildSender(req)
	if err != nil {
		result.ssupfac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppsForStaticSiteBuild", resp, "Failure sending request")
		return
	}

	result.ssupfac, err = client.GetUserProvidedFunctionAppsForStaticSiteBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetUserProvidedFunctionAppsForStaticSiteBuild", resp, "Failure responding to request")
		return
	}
	if result.ssupfac.hasNextLink() && result.ssupfac.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetUserProvidedFunctionAppsForStaticSiteBuildPreparer prepares the GetUserProvidedFunctionAppsForStaticSiteBuild request.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetUserProvidedFunctionAppsForStaticSiteBuildSender sends the GetUserProvidedFunctionAppsForStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSiteBuildSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetUserProvidedFunctionAppsForStaticSiteBuildResponder handles the response to the GetUserProvidedFunctionAppsForStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSiteBuildResponder(resp *http.Response) (result StaticSiteUserProvidedFunctionAppsCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getUserProvidedFunctionAppsForStaticSiteBuildNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) getUserProvidedFunctionAppsForStaticSiteBuildNextResults(ctx context.Context, lastResults StaticSiteUserProvidedFunctionAppsCollection) (result StaticSiteUserProvidedFunctionAppsCollection, err error) {
	req, err := lastResults.staticSiteUserProvidedFunctionAppsCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getUserProvidedFunctionAppsForStaticSiteBuildNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetUserProvidedFunctionAppsForStaticSiteBuildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getUserProvidedFunctionAppsForStaticSiteBuildNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetUserProvidedFunctionAppsForStaticSiteBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "getUserProvidedFunctionAppsForStaticSiteBuildNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetUserProvidedFunctionAppsForStaticSiteBuildComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) GetUserProvidedFunctionAppsForStaticSiteBuildComplete(ctx context.Context, resourceGroupName string, name string, environmentName string) (result StaticSiteUserProvidedFunctionAppsCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetUserProvidedFunctionAppsForStaticSiteBuild")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetUserProvidedFunctionAppsForStaticSiteBuild(ctx, resourceGroupName, name, environmentName)
	return
}

// List description for Get all Static Sites for a subscription.
func (client StaticSitesClient) List(ctx context.Context) (result StaticSiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.List")
		defer func() {
			sc := -1
			if result.ssc.Response.Response != nil {
				sc = result.ssc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.ssc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "List", resp, "Failure sending request")
		return
	}

	result.ssc, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "List", resp, "Failure responding to request")
		return
	}
	if result.ssc.hasNextLink() && result.ssc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client StaticSitesClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/staticSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListResponder(resp *http.Response) (result StaticSiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listNextResults(ctx context.Context, lastResults StaticSiteCollection) (result StaticSiteCollection, err error) {
	req, err := lastResults.staticSiteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListComplete(ctx context.Context) (result StaticSiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListStaticSiteAppSettings description for Gets the application settings of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ListStaticSiteAppSettings(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteAppSettings", err.Error())
	}

	req, err := client.ListStaticSiteAppSettingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// ListStaticSiteAppSettingsPreparer prepares the ListStaticSiteAppSettings request.
func (client StaticSitesClient) ListStaticSiteAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listAppSettings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteAppSettingsSender sends the ListStaticSiteAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteAppSettingsResponder handles the response to the ListStaticSiteAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteBuildAppSettings description for Gets the application settings of a static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
func (client StaticSitesClient) ListStaticSiteBuildAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteBuildAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteBuildAppSettings", err.Error())
	}

	req, err := client.ListStaticSiteBuildAppSettingsPreparer(ctx, resourceGroupName, name, environmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteBuildAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteBuildAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// ListStaticSiteBuildAppSettingsPreparer prepares the ListStaticSiteBuildAppSettings request.
func (client StaticSitesClient) ListStaticSiteBuildAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/listAppSettings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteBuildAppSettingsSender sends the ListStaticSiteBuildAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteBuildAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteBuildAppSettingsResponder handles the response to the ListStaticSiteBuildAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteBuildAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteBuildFunctionAppSettings description for Gets the application settings of a static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
func (client StaticSitesClient) ListStaticSiteBuildFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteBuildFunctionAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteBuildFunctionAppSettings", err.Error())
	}

	req, err := client.ListStaticSiteBuildFunctionAppSettingsPreparer(ctx, resourceGroupName, name, environmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctionAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteBuildFunctionAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctionAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteBuildFunctionAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctionAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// ListStaticSiteBuildFunctionAppSettingsPreparer prepares the ListStaticSiteBuildFunctionAppSettings request.
func (client StaticSitesClient) ListStaticSiteBuildFunctionAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/listFunctionAppSettings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteBuildFunctionAppSettingsSender sends the ListStaticSiteBuildFunctionAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteBuildFunctionAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteBuildFunctionAppSettingsResponder handles the response to the ListStaticSiteBuildFunctionAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteBuildFunctionAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteBuildFunctions description for Gets the functions of a particular static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
func (client StaticSitesClient) ListStaticSiteBuildFunctions(ctx context.Context, resourceGroupName string, name string, environmentName string) (result StaticSiteFunctionOverviewCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteBuildFunctions")
		defer func() {
			sc := -1
			if result.ssfoc.Response.Response != nil {
				sc = result.ssfoc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteBuildFunctions", err.Error())
	}

	result.fn = client.listStaticSiteBuildFunctionsNextResults
	req, err := client.ListStaticSiteBuildFunctionsPreparer(ctx, resourceGroupName, name, environmentName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteBuildFunctionsSender(req)
	if err != nil {
		result.ssfoc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctions", resp, "Failure sending request")
		return
	}

	result.ssfoc, err = client.ListStaticSiteBuildFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctions", resp, "Failure responding to request")
		return
	}
	if result.ssfoc.hasNextLink() && result.ssfoc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListStaticSiteBuildFunctionsPreparer prepares the ListStaticSiteBuildFunctions request.
func (client StaticSitesClient) ListStaticSiteBuildFunctionsPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/functions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteBuildFunctionsSender sends the ListStaticSiteBuildFunctions request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteBuildFunctionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteBuildFunctionsResponder handles the response to the ListStaticSiteBuildFunctions request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteBuildFunctionsResponder(resp *http.Response) (result StaticSiteFunctionOverviewCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStaticSiteBuildFunctionsNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listStaticSiteBuildFunctionsNextResults(ctx context.Context, lastResults StaticSiteFunctionOverviewCollection) (result StaticSiteFunctionOverviewCollection, err error) {
	req, err := lastResults.staticSiteFunctionOverviewCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteBuildFunctionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStaticSiteBuildFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteBuildFunctionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStaticSiteBuildFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteBuildFunctionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStaticSiteBuildFunctionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListStaticSiteBuildFunctionsComplete(ctx context.Context, resourceGroupName string, name string, environmentName string) (result StaticSiteFunctionOverviewCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteBuildFunctions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStaticSiteBuildFunctions(ctx, resourceGroupName, name, environmentName)
	return
}

// ListStaticSiteConfiguredRoles description for Lists the roles configured for the static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ListStaticSiteConfiguredRoles(ctx context.Context, resourceGroupName string, name string) (result StringList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteConfiguredRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteConfiguredRoles", err.Error())
	}

	req, err := client.ListStaticSiteConfiguredRolesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteConfiguredRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteConfiguredRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteConfiguredRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteConfiguredRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteConfiguredRoles", resp, "Failure responding to request")
		return
	}

	return
}

// ListStaticSiteConfiguredRolesPreparer prepares the ListStaticSiteConfiguredRoles request.
func (client StaticSitesClient) ListStaticSiteConfiguredRolesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listConfiguredRoles", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteConfiguredRolesSender sends the ListStaticSiteConfiguredRoles request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteConfiguredRolesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteConfiguredRolesResponder handles the response to the ListStaticSiteConfiguredRoles request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteConfiguredRolesResponder(resp *http.Response) (result StringList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteCustomDomains description for Gets all static site custom domains for a particular static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site resource to search in.
func (client StaticSitesClient) ListStaticSiteCustomDomains(ctx context.Context, resourceGroupName string, name string) (result StaticSiteCustomDomainOverviewCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteCustomDomains")
		defer func() {
			sc := -1
			if result.sscdoc.Response.Response != nil {
				sc = result.sscdoc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteCustomDomains", err.Error())
	}

	result.fn = client.listStaticSiteCustomDomainsNextResults
	req, err := client.ListStaticSiteCustomDomainsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteCustomDomains", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteCustomDomainsSender(req)
	if err != nil {
		result.sscdoc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteCustomDomains", resp, "Failure sending request")
		return
	}

	result.sscdoc, err = client.ListStaticSiteCustomDomainsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteCustomDomains", resp, "Failure responding to request")
		return
	}
	if result.sscdoc.hasNextLink() && result.sscdoc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListStaticSiteCustomDomainsPreparer prepares the ListStaticSiteCustomDomains request.
func (client StaticSitesClient) ListStaticSiteCustomDomainsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteCustomDomainsSender sends the ListStaticSiteCustomDomains request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteCustomDomainsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteCustomDomainsResponder handles the response to the ListStaticSiteCustomDomains request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteCustomDomainsResponder(resp *http.Response) (result StaticSiteCustomDomainOverviewCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStaticSiteCustomDomainsNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listStaticSiteCustomDomainsNextResults(ctx context.Context, lastResults StaticSiteCustomDomainOverviewCollection) (result StaticSiteCustomDomainOverviewCollection, err error) {
	req, err := lastResults.staticSiteCustomDomainOverviewCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteCustomDomainsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStaticSiteCustomDomainsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteCustomDomainsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStaticSiteCustomDomainsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteCustomDomainsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStaticSiteCustomDomainsComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListStaticSiteCustomDomainsComplete(ctx context.Context, resourceGroupName string, name string) (result StaticSiteCustomDomainOverviewCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteCustomDomains")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStaticSiteCustomDomains(ctx, resourceGroupName, name)
	return
}

// ListStaticSiteFunctionAppSettings description for Gets the application settings of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ListStaticSiteFunctionAppSettings(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteFunctionAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteFunctionAppSettings", err.Error())
	}

	req, err := client.ListStaticSiteFunctionAppSettingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctionAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteFunctionAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctionAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteFunctionAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctionAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// ListStaticSiteFunctionAppSettingsPreparer prepares the ListStaticSiteFunctionAppSettings request.
func (client StaticSitesClient) ListStaticSiteFunctionAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listFunctionAppSettings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteFunctionAppSettingsSender sends the ListStaticSiteFunctionAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteFunctionAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteFunctionAppSettingsResponder handles the response to the ListStaticSiteFunctionAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteFunctionAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteFunctions description for Gets the functions of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ListStaticSiteFunctions(ctx context.Context, resourceGroupName string, name string) (result StaticSiteFunctionOverviewCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteFunctions")
		defer func() {
			sc := -1
			if result.ssfoc.Response.Response != nil {
				sc = result.ssfoc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteFunctions", err.Error())
	}

	result.fn = client.listStaticSiteFunctionsNextResults
	req, err := client.ListStaticSiteFunctionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteFunctionsSender(req)
	if err != nil {
		result.ssfoc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctions", resp, "Failure sending request")
		return
	}

	result.ssfoc, err = client.ListStaticSiteFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctions", resp, "Failure responding to request")
		return
	}
	if result.ssfoc.hasNextLink() && result.ssfoc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListStaticSiteFunctionsPreparer prepares the ListStaticSiteFunctions request.
func (client StaticSitesClient) ListStaticSiteFunctionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/functions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteFunctionsSender sends the ListStaticSiteFunctions request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteFunctionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteFunctionsResponder handles the response to the ListStaticSiteFunctions request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteFunctionsResponder(resp *http.Response) (result StaticSiteFunctionOverviewCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStaticSiteFunctionsNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listStaticSiteFunctionsNextResults(ctx context.Context, lastResults StaticSiteFunctionOverviewCollection) (result StaticSiteFunctionOverviewCollection, err error) {
	req, err := lastResults.staticSiteFunctionOverviewCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteFunctionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStaticSiteFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteFunctionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStaticSiteFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteFunctionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStaticSiteFunctionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListStaticSiteFunctionsComplete(ctx context.Context, resourceGroupName string, name string) (result StaticSiteFunctionOverviewCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteFunctions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStaticSiteFunctions(ctx, resourceGroupName, name)
	return
}

// ListStaticSiteSecrets description for Lists the secrets for an existing static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ListStaticSiteSecrets(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteSecrets")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteSecrets", err.Error())
	}

	req, err := client.ListStaticSiteSecretsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteSecrets", resp, "Failure responding to request")
		return
	}

	return
}

// ListStaticSiteSecretsPreparer prepares the ListStaticSiteSecrets request.
func (client StaticSitesClient) ListStaticSiteSecretsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listSecrets", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteSecretsSender sends the ListStaticSiteSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteSecretsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteSecretsResponder handles the response to the ListStaticSiteSecrets request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteSecretsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteUsers description for Gets the list of users of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// authprovider - the auth provider for the users.
func (client StaticSitesClient) ListStaticSiteUsers(ctx context.Context, resourceGroupName string, name string, authprovider string) (result StaticSiteUserCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteUsers")
		defer func() {
			sc := -1
			if result.ssuc.Response.Response != nil {
				sc = result.ssuc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteUsers", err.Error())
	}

	result.fn = client.listStaticSiteUsersNextResults
	req, err := client.ListStaticSiteUsersPreparer(ctx, resourceGroupName, name, authprovider)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteUsers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteUsersSender(req)
	if err != nil {
		result.ssuc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteUsers", resp, "Failure sending request")
		return
	}

	result.ssuc, err = client.ListStaticSiteUsersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteUsers", resp, "Failure responding to request")
		return
	}
	if result.ssuc.hasNextLink() && result.ssuc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListStaticSiteUsersPreparer prepares the ListStaticSiteUsers request.
func (client StaticSitesClient) ListStaticSiteUsersPreparer(ctx context.Context, resourceGroupName string, name string, authprovider string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authprovider":      autorest.Encode("path", authprovider),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/listUsers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteUsersSender sends the ListStaticSiteUsers request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteUsersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteUsersResponder handles the response to the ListStaticSiteUsers request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteUsersResponder(resp *http.Response) (result StaticSiteUserCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStaticSiteUsersNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listStaticSiteUsersNextResults(ctx context.Context, lastResults StaticSiteUserCollection) (result StaticSiteUserCollection, err error) {
	req, err := lastResults.staticSiteUserCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteUsersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStaticSiteUsersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteUsersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStaticSiteUsersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteUsersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStaticSiteUsersComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListStaticSiteUsersComplete(ctx context.Context, resourceGroupName string, name string, authprovider string) (result StaticSiteUserCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteUsers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStaticSiteUsers(ctx, resourceGroupName, name, authprovider)
	return
}

// PreviewWorkflow description for Generates a preview workflow file for the static site
// Parameters:
// location - location where you plan to create the static site.
// staticSitesWorkflowPreviewRequest - a JSON representation of the StaticSitesWorkflowPreviewRequest
// properties. See example.
func (client StaticSitesClient) PreviewWorkflow(ctx context.Context, location string, staticSitesWorkflowPreviewRequest StaticSitesWorkflowPreviewRequest) (result StaticSitesWorkflowPreview, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.PreviewWorkflow")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PreviewWorkflowPreparer(ctx, location, staticSitesWorkflowPreviewRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "PreviewWorkflow", nil, "Failure preparing request")
		return
	}

	resp, err := client.PreviewWorkflowSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "PreviewWorkflow", resp, "Failure sending request")
		return
	}

	result, err = client.PreviewWorkflowResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "PreviewWorkflow", resp, "Failure responding to request")
		return
	}

	return
}

// PreviewWorkflowPreparer prepares the PreviewWorkflow request.
func (client StaticSitesClient) PreviewWorkflowPreparer(ctx context.Context, location string, staticSitesWorkflowPreviewRequest StaticSitesWorkflowPreviewRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/previewStaticSiteWorkflowFile", pathParameters),
		autorest.WithJSON(staticSitesWorkflowPreviewRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PreviewWorkflowSender sends the PreviewWorkflow request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) PreviewWorkflowSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// PreviewWorkflowResponder handles the response to the PreviewWorkflow request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) PreviewWorkflowResponder(resp *http.Response) (result StaticSitesWorkflowPreview, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RegisterUserProvidedFunctionAppWithStaticSite description for Register a user provided function app with a static
// site
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// functionAppName - name of the function app to register with the static site.
// staticSiteUserProvidedFunctionEnvelope - a JSON representation of the user provided function app properties.
// See example.
// isForced - specify <code>true</code> to force the update of the auth configuration on the function app even
// if an AzureStaticWebApps provider is already configured on the function app. The default is
// <code>false</code>.
func (client StaticSitesClient) RegisterUserProvidedFunctionAppWithStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, isForced *bool) (result StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.RegisterUserProvidedFunctionAppWithStaticSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "RegisterUserProvidedFunctionAppWithStaticSite", err.Error())
	}

	req, err := client.RegisterUserProvidedFunctionAppWithStaticSitePreparer(ctx, resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "RegisterUserProvidedFunctionAppWithStaticSite", nil, "Failure preparing request")
		return
	}

	result, err = client.RegisterUserProvidedFunctionAppWithStaticSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "RegisterUserProvidedFunctionAppWithStaticSite", result.Response(), "Failure sending request")
		return
	}

	return
}

// RegisterUserProvidedFunctionAppWithStaticSitePreparer prepares the RegisterUserProvidedFunctionAppWithStaticSite request.
func (client StaticSitesClient) RegisterUserProvidedFunctionAppWithStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, isForced *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionAppName":   autorest.Encode("path", functionAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if isForced != nil {
		queryParameters["isForced"] = autorest.Encode("query", *isForced)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}", pathParameters),
		autorest.WithJSON(staticSiteUserProvidedFunctionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RegisterUserProvidedFunctionAppWithStaticSiteSender sends the RegisterUserProvidedFunctionAppWithStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) RegisterUserProvidedFunctionAppWithStaticSiteSender(req *http.Request) (future StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// RegisterUserProvidedFunctionAppWithStaticSiteResponder handles the response to the RegisterUserProvidedFunctionAppWithStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) RegisterUserProvidedFunctionAppWithStaticSiteResponder(resp *http.Response) (result StaticSiteUserProvidedFunctionAppARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RegisterUserProvidedFunctionAppWithStaticSiteBuild description for Register a user provided function app with a
// static site build
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// environmentName - the stage site identifier.
// functionAppName - name of the function app to register with the static site build.
// staticSiteUserProvidedFunctionEnvelope - a JSON representation of the user provided function app properties.
// See example.
// isForced - specify <code>true</code> to force the update of the auth configuration on the function app even
// if an AzureStaticWebApps provider is already configured on the function app. The default is
// <code>false</code>.
func (client StaticSitesClient) RegisterUserProvidedFunctionAppWithStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, isForced *bool) (result StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteBuildFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.RegisterUserProvidedFunctionAppWithStaticSiteBuild")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "RegisterUserProvidedFunctionAppWithStaticSiteBuild", err.Error())
	}

	req, err := client.RegisterUserProvidedFunctionAppWithStaticSiteBuildPreparer(ctx, resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "RegisterUserProvidedFunctionAppWithStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	result, err = client.RegisterUserProvidedFunctionAppWithStaticSiteBuildSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "RegisterUserProvidedFunctionAppWithStaticSiteBuild", result.Response(), "Failure sending request")
		return
	}

	return
}

// RegisterUserProvidedFunctionAppWithStaticSiteBuildPreparer prepares the RegisterUserProvidedFunctionAppWithStaticSiteBuild request.
func (client StaticSitesClient) RegisterUserProvidedFunctionAppWithStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, staticSiteUserProvidedFunctionEnvelope StaticSiteUserProvidedFunctionAppARMResource, isForced *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"environmentName":   autorest.Encode("path", environmentName),
		"functionAppName":   autorest.Encode("path", functionAppName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if isForced != nil {
		queryParameters["isForced"] = autorest.Encode("query", *isForced)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}", pathParameters),
		autorest.WithJSON(staticSiteUserProvidedFunctionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RegisterUserProvidedFunctionAppWithStaticSiteBuildSender sends the RegisterUserProvidedFunctionAppWithStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) RegisterUserProvidedFunctionAppWithStaticSiteBuildSender(req *http.Request) (future StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteBuildFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// RegisterUserProvidedFunctionAppWithStaticSiteBuildResponder handles the response to the RegisterUserProvidedFunctionAppWithStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) RegisterUserProvidedFunctionAppWithStaticSiteBuildResponder(resp *http.Response) (result StaticSiteUserProvidedFunctionAppARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResetStaticSiteAPIKey description for Resets the api key for an existing static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ResetStaticSiteAPIKey(ctx context.Context, resourceGroupName string, name string, resetPropertiesEnvelope StaticSiteResetPropertiesARMResource) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ResetStaticSiteAPIKey")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ResetStaticSiteAPIKey", err.Error())
	}

	req, err := client.ResetStaticSiteAPIKeyPreparer(ctx, resourceGroupName, name, resetPropertiesEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ResetStaticSiteAPIKey", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResetStaticSiteAPIKeySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ResetStaticSiteAPIKey", resp, "Failure sending request")
		return
	}

	result, err = client.ResetStaticSiteAPIKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ResetStaticSiteAPIKey", resp, "Failure responding to request")
		return
	}

	return
}

// ResetStaticSiteAPIKeyPreparer prepares the ResetStaticSiteAPIKey request.
func (client StaticSitesClient) ResetStaticSiteAPIKeyPreparer(ctx context.Context, resourceGroupName string, name string, resetPropertiesEnvelope StaticSiteResetPropertiesARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/resetapikey", pathParameters),
		autorest.WithJSON(resetPropertiesEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResetStaticSiteAPIKeySender sends the ResetStaticSiteAPIKey request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ResetStaticSiteAPIKeySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ResetStaticSiteAPIKeyResponder handles the response to the ResetStaticSiteAPIKey request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ResetStaticSiteAPIKeyResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateStaticSite description for Creates a new static site in an existing resource group, or updates an existing
// static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site to create or update.
// staticSiteEnvelope - a JSON representation of the staticsite properties. See example.
func (client StaticSitesClient) UpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSitePatchResource) (result StaticSiteARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.UpdateStaticSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "UpdateStaticSite", err.Error())
	}

	req, err := client.UpdateStaticSitePreparer(ctx, resourceGroupName, name, staticSiteEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateStaticSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSite", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateStaticSitePreparer prepares the UpdateStaticSite request.
func (client StaticSitesClient) UpdateStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSitePatchResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}", pathParameters),
		autorest.WithJSON(staticSiteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateStaticSiteSender sends the UpdateStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) UpdateStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateStaticSiteResponder handles the response to the UpdateStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) UpdateStaticSiteResponder(resp *http.Response) (result StaticSiteARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateStaticSiteUser description for Updates a user entry with the listed roles
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// authprovider - the auth provider for this user.
// userid - the user id of the user.
// staticSiteUserEnvelope - a JSON representation of the StaticSiteUser properties. See example.
func (client StaticSitesClient) UpdateStaticSiteUser(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, staticSiteUserEnvelope StaticSiteUserARMResource) (result StaticSiteUserARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.UpdateStaticSiteUser")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "UpdateStaticSiteUser", err.Error())
	}

	req, err := client.UpdateStaticSiteUserPreparer(ctx, resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSiteUser", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateStaticSiteUserSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSiteUser", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateStaticSiteUserResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSiteUser", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateStaticSiteUserPreparer prepares the UpdateStaticSiteUser request.
func (client StaticSitesClient) UpdateStaticSiteUserPreparer(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, staticSiteUserEnvelope StaticSiteUserARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authprovider":      autorest.Encode("path", authprovider),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"userid":            autorest.Encode("path", userid),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}", pathParameters),
		autorest.WithJSON(staticSiteUserEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateStaticSiteUserSender sends the UpdateStaticSiteUser request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) UpdateStaticSiteUserSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateStaticSiteUserResponder handles the response to the UpdateStaticSiteUser request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) UpdateStaticSiteUserResponder(resp *http.Response) (result StaticSiteUserARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ValidateCustomDomainCanBeAddedToStaticSite description for Validates a particular custom domain can be added to a
// static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// domainName - the custom domain to validate.
// staticSiteCustomDomainRequestPropertiesEnvelope - a JSON representation of the static site custom domain
// request properties. See example.
func (client StaticSitesClient) ValidateCustomDomainCanBeAddedToStaticSite(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource) (result StaticSitesValidateCustomDomainCanBeAddedToStaticSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ValidateCustomDomainCanBeAddedToStaticSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ValidateCustomDomainCanBeAddedToStaticSite", err.Error())
	}

	req, err := client.ValidateCustomDomainCanBeAddedToStaticSitePreparer(ctx, resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ValidateCustomDomainCanBeAddedToStaticSite", nil, "Failure preparing request")
		return
	}

	result, err = client.ValidateCustomDomainCanBeAddedToStaticSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ValidateCustomDomainCanBeAddedToStaticSite", result.Response(), "Failure sending request")
		return
	}

	return
}

// ValidateCustomDomainCanBeAddedToStaticSitePreparer prepares the ValidateCustomDomainCanBeAddedToStaticSite request.
func (client StaticSitesClient) ValidateCustomDomainCanBeAddedToStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope StaticSiteCustomDomainRequestPropertiesARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}/validate", pathParameters),
		autorest.WithJSON(staticSiteCustomDomainRequestPropertiesEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateCustomDomainCanBeAddedToStaticSiteSender sends the ValidateCustomDomainCanBeAddedToStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ValidateCustomDomainCanBeAddedToStaticSiteSender(req *http.Request) (future StaticSitesValidateCustomDomainCanBeAddedToStaticSiteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ValidateCustomDomainCanBeAddedToStaticSiteResponder handles the response to the ValidateCustomDomainCanBeAddedToStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ValidateCustomDomainCanBeAddedToStaticSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
