/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.EnumMap;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.url.Url;

abstract class Arrow
extends GraphicalElement
implements InGroupable {
    private final Rose skin;
    private final ArrowComponent arrowComponent;
    private double paddingArrowHead;
    private double maxX;
    private final Url url;

    public void setMaxX(double m) {
        if (this.maxX != 0.0) {
            throw new IllegalStateException();
        }
        this.maxX = m;
    }

    protected final double getMaxX() {
        if (this.maxX == 0.0) {
            // empty if block
        }
        return this.maxX;
    }

    public abstract double getActualWidth(StringBounder var1);

    Arrow(double startingY, Rose skin, ArrowComponent arrowComponent, Url url) {
        super(startingY);
        this.skin = skin;
        this.arrowComponent = arrowComponent;
        this.url = url;
    }

    protected Url getUrl() {
        return this.url;
    }

    protected final void startGroup(UGraphic ug) {
        EnumMap<UGroupType, String> typeIdents = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIdents.put(UGroupType.CLASS, "message");
        typeIdents.put(UGroupType.DATA_PARTICIPANT_1, this.getParticipant1Code());
        typeIdents.put(UGroupType.DATA_PARTICIPANT_2, this.getParticipant2Code());
        ug.startGroup(typeIdents);
    }

    protected final void endGroup(UGraphic ug) {
        ug.closeGroup();
    }

    protected final void startUrl(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
    }

    protected final void endUrl(UGraphic ug) {
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    public abstract int getDirection(StringBounder var1);

    protected Rose getSkin() {
        return this.skin;
    }

    protected final ArrowComponent getArrowComponent() {
        return this.arrowComponent;
    }

    public double getArrowOnlyWidth(StringBounder stringBounder) {
        return this.getPreferredWidth(stringBounder);
    }

    public abstract double getArrowYStartLevel(StringBounder var1);

    public abstract double getArrowYEndLevel(StringBounder var1);

    public abstract LivingParticipantBox getParticipantAt(StringBounder var1, NotePosition var2);

    protected abstract String getParticipant1Code();

    protected abstract String getParticipant2Code();

    protected final double getPaddingArrowHead() {
        return this.paddingArrowHead;
    }

    protected final void setPaddingArrowHead(double paddingArrowHead) {
        this.paddingArrowHead = paddingArrowHead;
    }

    public final double getMargin() {
        return 5.0;
    }
}

