/*
 * Decompiled with CFR 0.152.
 */
package org.atpfivt.jsyntrax;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.atpfivt.jsyntrax.Main;

public class InputArguments {
    private static final Options OPTIONS = new Options();
    private static final Map<Option, BiConsumer<InputArguments, String>> OPTIONS_MAP = new LinkedHashMap<Option, BiConsumer<InputArguments, String>>();
    private boolean help;
    private Path input;
    private Path output;
    private Path style;
    private String title;
    private String version;
    private boolean transparent;
    private double scale = 1.0;
    private boolean getDefaultStyle = false;

    public InputArguments(String ... args) throws ParseException {
        for (Option o : OPTIONS_MAP.keySet()) {
            OPTIONS.addOption(o);
        }
        CommandLine commandLine = new DefaultParser().parse(OPTIONS, args);
        for (Option o : commandLine.getOptions()) {
            OPTIONS_MAP.getOrDefault(o, (x, s) -> {}).accept(this, o.getValue());
        }
        if (commandLine.getArgList().size() > 0) {
            this.input = Paths.get((String)commandLine.getArgList().get(0), new String[0]);
        }
    }

    public static void writeHelp(PrintWriter writer) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(writer, 80, "syntrax", "Railroad diagram generator.\n\nOptions", OPTIONS, 3, 5, null, true);
        writer.flush();
    }

    public boolean isHelp() {
        return this.help;
    }

    public Path getInput() {
        return this.input;
    }

    static Path changeExtension(Path p, String ext) {
        String path = p.toString();
        int i = path.lastIndexOf(46);
        if (i >= 0) {
            return Paths.get(path.substring(0, i) + "." + ext, new String[0]);
        }
        return Paths.get(path + "." + ext, new String[0]);
    }

    public Path getOutput() {
        if (this.output == null) {
            this.output = InputArguments.changeExtension(this.input, "png");
        } else if ("png".equalsIgnoreCase(this.output.toString()) || "svg".equalsIgnoreCase(this.output.toString())) {
            this.output = InputArguments.changeExtension(this.input, this.output.toString());
        }
        return this.output;
    }

    public Path getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public double getScale() {
        return this.scale;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean getDefaultStyleProperty() {
        return this.getDefaultStyle;
    }

    static {
        OPTIONS_MAP.put(new Option("h", "help", false, "Show this help message and exit"), (o, s) -> {
            o.help = true;
        });
        OPTIONS_MAP.put(new Option("i", "input", true, "Diagram spec file"), (o, s) -> {
            o.input = Paths.get(s, new String[0]);
        });
        OPTIONS_MAP.put(new Option("o", "output", true, "Output file"), (o, s) -> {
            o.output = Paths.get(s, new String[0]);
        });
        OPTIONS_MAP.put(new Option("s", "style", true, "Style config .ini file"), (o, s) -> {
            o.style = Paths.get(s, new String[0]);
        });
        OPTIONS_MAP.put(new Option(null, "title", true, "Diagram title"), (o, s) -> {
            o.title = s;
        });
        OPTIONS_MAP.put(new Option("t", "transparent", false, "Transparent background"), (o, s) -> {
            o.transparent = true;
        });
        OPTIONS_MAP.put(new Option(null, "scale", true, "Scale image"), (o, s) -> {
            o.scale = Double.parseDouble(s);
        });
        OPTIONS_MAP.put(new Option("v", "version", false, "Release version"), (o, s) -> {
            o.version = "JSyntrax " + Main.class.getPackage().getImplementationVersion();
        });
        OPTIONS_MAP.put(new Option(null, "get-style", false, "Create default style .ini"), (o, s) -> {
            o.getDefaultStyle = true;
        });
    }
}

