/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.stathissideris.ditaa.core.RenderingOptions;
import org.stathissideris.ditaa.core.Shape3DOrderingComparator;
import org.stathissideris.ditaa.core.ShapeAreaComparator;
import org.stathissideris.ditaa.graphics.Diagram;
import org.stathissideris.ditaa.graphics.DiagramShape;
import org.stathissideris.ditaa.graphics.DiagramText;

public class SVGRenderer {
    public String renderToImage(Diagram diagram, RenderingOptions options) {
        SVGBuilder builder = new SVGBuilder(diagram, options);
        try {
            return builder.build();
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class SVGPath {
        final String svgPath;
        final boolean isClosed;

        SVGPath(GeneralPath path) {
            boolean closed = false;
            float[] coords = new float[6];
            StringBuilder builder = new StringBuilder();
            PathIterator pathIterator = path.getPathIterator(null);
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(coords)) {
                    case 0: {
                        builder.append("M" + coords[0] + " " + coords[1] + " ");
                        break;
                    }
                    case 1: {
                        builder.append("L" + coords[0] + " " + coords[1] + " ");
                        break;
                    }
                    case 2: {
                        builder.append("Q" + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3] + " ");
                        break;
                    }
                    case 3: {
                        builder.append("C" + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3] + " " + coords[4] + " " + coords[5] + " ");
                        break;
                    }
                    case 4: {
                        builder.append("z");
                        closed = true;
                    }
                }
                pathIterator.next();
            }
            this.isClosed = closed;
            this.svgPath = builder.toString();
        }
    }

    private static class SVGBuilder {
        private final Diagram diagram;
        private final RenderingOptions options;
        private final float dashInterval;
        private final float strokeWeight;

        public SVGBuilder(Diagram diagram, RenderingOptions options) {
            this.diagram = diagram;
            this.options = options;
            this.dashInterval = (float)Math.min(diagram.getCellWidth(), diagram.getCellHeight()) / 2.0f;
            this.strokeWeight = diagram.getMinimumOfCellDimension() / 10.0f;
        }

        public String build() throws XMLStreamException, IOException {
            StringWriter stringWriter = new StringWriter();
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            XMLStreamWriter writer = factory.createXMLStreamWriter(stringWriter);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("svg");
            writer.writeDefaultNamespace("http://www.w3.org/2000/svg");
            writer.writeAttribute("width", Integer.toString(this.diagram.getWidth()));
            writer.writeAttribute("height", Integer.toString(this.diagram.getHeight()));
            writer.writeAttribute("version", "1.0");
            writer.writeAttribute("shape-rendering", this.options.performAntialias() ? "geometricPrecision" : "optimizeSpeed");
            this.writeDefinitions(writer);
            writer.writeStartElement("g");
            writer.writeAttribute("stroke-width", "1");
            writer.writeAttribute("stroke-linecap", "square");
            writer.writeAttribute("stroke-linejoin", "round");
            this.writeBackgroundLayer(writer);
            this.writeShapes(writer);
            this.writeTexts(writer);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
            stringWriter.close();
            return stringWriter.toString();
        }

        private void writeDefinitions(XMLStreamWriter writer) throws XMLStreamException {
            float offset = this.diagram.getMinimumOfCellDimension() / 3.333f;
            writer.writeStartElement("defs");
            String fontURL = this.options.getFontURL();
            if (fontURL != null) {
                writer.writeStartElement("style");
                writer.writeAttribute("type", "text/css");
                writer.writeCharacters("@font-face {\n  font-family: " + this.options.getFontFamily() + ";\n  src: url('" + fontURL + "');\n}");
                writer.writeEndElement();
            }
            writer.writeStartElement("filter");
            writer.writeAttribute("id", "shadowBlur");
            writer.writeAttribute("x", "0");
            writer.writeAttribute("y", "0");
            writer.writeAttribute("width", "200%");
            writer.writeAttribute("height", "200%");
            writer.writeStartElement("feOffset");
            writer.writeAttribute("in", "SourceGraphic");
            writer.writeAttribute("dx", Float.toString(offset));
            writer.writeAttribute("dy", Float.toString(offset));
            writer.writeAttribute("result", "offOut");
            writer.writeEndElement();
            writer.writeStartElement("feGaussianBlur");
            writer.writeAttribute("in", "offOut");
            writer.writeAttribute("stdDeviation", "3");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }

        private void writeShapes(XMLStreamWriter writer) throws XMLStreamException {
            ArrayList<DiagramShape> shapes = this.diagram.getAllDiagramShapes();
            ArrayList<DiagramShape> storageShapes = new ArrayList<DiagramShape>();
            ArrayList<DiagramShape> otherShapes = new ArrayList<DiagramShape>();
            ArrayList<DiagramShape> pointMarkers = new ArrayList<DiagramShape>();
            for (DiagramShape shape : shapes) {
                if (shape.getType() == 4) {
                    storageShapes.add(shape);
                    continue;
                }
                if (shape.getType() == 2) {
                    pointMarkers.add(shape);
                    continue;
                }
                if (shape.getType() == 9999) {
                    throw new RuntimeException("Not yet implemented");
                }
                if (shape.getPoints().isEmpty()) continue;
                otherShapes.add(shape);
            }
            Collections.sort(storageShapes, new Shape3DOrderingComparator());
            Collections.sort(otherShapes, new ShapeAreaComparator());
            if (this.options.dropShadows()) {
                SVGPath path;
                for (DiagramShape storageShape : storageShapes) {
                    if (storageShape.isStrokeDashed()) continue;
                    path = new SVGPath(storageShape.makeIntoRenderPath(this.diagram, this.options));
                    if (!path.isClosed) continue;
                    this.writeShadowPath(writer, path);
                }
                for (DiagramShape otherShape : otherShapes) {
                    if (otherShape.isStrokeDashed() || otherShape.getType() == 1) continue;
                    path = new SVGPath(otherShape.makeIntoRenderPath(this.diagram, this.options));
                    if (!path.isClosed) continue;
                    this.writeShadowPath(writer, path);
                }
            }
            for (DiagramShape shape : storageShapes) {
                SVGPath commands = new SVGPath(shape.makeIntoRenderPath(this.diagram, this.options));
                String fill = "none";
                String color = "white";
                if (!shape.isStrokeDashed()) {
                    fill = shape.getFillColor() != null ? SVGBuilder.colorToHex(shape.getFillColor()) : SVGBuilder.colorToHex(Color.white);
                }
                this.writePath(writer, shape, commands, color, fill);
                this.writePath(writer, shape, commands, SVGBuilder.colorToHex(shape.getStrokeColor()), "none");
            }
            for (DiagramShape shape : otherShapes) {
                this.writePath(writer, shape, new SVGPath(shape.makeIntoRenderPath(this.diagram, this.options)));
            }
            this.writePointMarkers(writer, pointMarkers);
        }

        private void writePath(XMLStreamWriter writer, DiagramShape shape, SVGPath commands) throws XMLStreamException {
            String fill = "none";
            if (shape.isClosed() && !shape.isStrokeDashed()) {
                fill = shape.getFillColor() != null ? SVGBuilder.colorToHex(shape.getFillColor()) : "white";
                if (shape.getType() == 1) {
                    this.writePath(writer, shape, commands, "none", fill);
                }
            }
            if (shape.getType() != 1) {
                this.writePath(writer, shape, commands, SVGBuilder.colorToHex(shape.getStrokeColor()), fill);
            }
        }

        private void writeShadowPath(XMLStreamWriter writer, SVGPath path) throws XMLStreamException {
            writer.writeStartElement("path");
            writer.writeAttribute("stroke", SVGBuilder.colorToHex(new Color(150, 150, 150)));
            writer.writeAttribute("fill", SVGBuilder.colorToHex(new Color(150, 150, 150)));
            writer.writeAttribute("filter", "url(#shadowBlur)");
            writer.writeAttribute("d", path.svgPath);
            writer.writeEndElement();
        }

        private void writePointMarkers(XMLStreamWriter writer, ArrayList<DiagramShape> pointMarkers) throws XMLStreamException {
            for (DiagramShape shape : pointMarkers) {
                GeneralPath path = shape.makeIntoRenderPath(this.diagram, this.options);
                String fill = shape.getFillColor() != null ? SVGBuilder.colorToHex(shape.getFillColor()) : "white";
                this.writePath(writer, shape, new SVGPath(path), SVGBuilder.colorToHex(shape.getStrokeColor()), fill);
            }
        }

        private void writePath(XMLStreamWriter writer, DiagramShape shape, SVGPath path, String stroke, String fill) throws XMLStreamException {
            writer.writeStartElement("path");
            writer.writeAttribute("stroke", stroke);
            if (shape.isStrokeDashed()) {
                writer.writeAttribute("stroke-width", Float.toString(this.strokeWeight));
                writer.writeAttribute("stroke-dasharray", this.dashInterval + "," + this.dashInterval);
                writer.writeAttribute("stroke-miterlimit", "0");
                writer.writeAttribute("stroke-linecap", "butt");
                writer.writeAttribute("stroke-linejoin", "round");
            } else {
                writer.writeAttribute("stroke-width", Float.toString(this.strokeWeight));
                writer.writeAttribute("stroke-linecap", "round");
                writer.writeAttribute("stroke-linejoin", "round");
            }
            writer.writeAttribute("fill", fill);
            writer.writeAttribute("d", path.svgPath);
            writer.writeEndElement();
        }

        private void writeBackgroundLayer(XMLStreamWriter writer) throws XMLStreamException {
            Color color = this.options.getBackgroundColor();
            if (color.getAlpha() == 0) {
                return;
            }
            writer.writeStartElement("rect");
            writer.writeAttribute("x", "0");
            writer.writeAttribute("y", "0");
            writer.writeAttribute("width", Integer.toString(this.diagram.getWidth()));
            writer.writeAttribute("height", Integer.toString(this.diagram.getHeight()));
            writer.writeAttribute("style", "fill: " + SVGBuilder.colorToHex(color));
            writer.writeEndElement();
        }

        private void writeTexts(XMLStreamWriter writer) throws XMLStreamException {
            for (DiagramText diagramText : this.diagram.getTextObjects()) {
                Font font = diagramText.getFont();
                String text = diagramText.getText();
                int xPos = diagramText.getXPos();
                int yPos = diagramText.getYPos();
                this.writeText(writer, text, xPos, yPos, font, diagramText.getColor());
                if (!diagramText.hasOutline()) continue;
                Color outlineColor = diagramText.getOutlineColor();
                this.writeText(writer, text, xPos + 1, yPos, font, outlineColor);
                this.writeText(writer, text, xPos - 1, yPos, font, outlineColor);
                this.writeText(writer, text, xPos, yPos + 1, font, outlineColor);
                this.writeText(writer, text, xPos, yPos - 1, font, outlineColor);
            }
        }

        private void writeText(XMLStreamWriter writer, String text, int xPos, int yPos, Font font, Color color) throws XMLStreamException {
            writer.writeStartElement("text");
            writer.writeAttribute("x", Integer.toString(xPos));
            writer.writeAttribute("y", Integer.toString(yPos));
            writer.writeAttribute("font-family", this.options.getFontFamily());
            writer.writeAttribute("font-size", Integer.toString(font.getSize()));
            writer.writeAttribute("stroke", "none");
            writer.writeAttribute("fill", SVGBuilder.colorToHex(color));
            writer.writeCData(text);
            writer.writeEndElement();
        }

        private static String colorToHex(Color color) {
            return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        }
    }
}

