/*
 * Autogenerated by $Id: IEMAllInstrA64Impl.h $
 * from the open source v9Ap6-A specs, build 406 (5e0a212688c6bd7aee92394b6f5e491b4d0fee1d)
 * dated Sun Dec 15 22:18:44 2024 UTC.
 *
 * Do not edit!
 */

/*
 * Copyright (C) 2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */


#include "IEMInlineMem-armv8.h"


/*
 *
 * Instruction Set & Groups: addsub_carry / dpreg / A64
 *
 */

/* ADC  <Wd>, <Wn>, <Wm> (ffe0fc00/1a000000) */
//#define IEM_INSTR_IMPL_A64__ADC_32_addsub_carry(Rd, Rn, Rm)


/* ADCS  <Wd>, <Wn>, <Wm> (ffe0fc00/3a000000) */
//#define IEM_INSTR_IMPL_A64__ADCS_32_addsub_carry(Rd, Rn, Rm)


/* SBC  <Wd>, <Wn>, <Wm> (ffe0fc00/5a000000) */
//#define IEM_INSTR_IMPL_A64__SBC_32_addsub_carry(Rd, Rn, Rm)


/* SBCS  <Wd>, <Wn>, <Wm> (ffe0fc00/7a000000) */
//#define IEM_INSTR_IMPL_A64__SBCS_32_addsub_carry(Rd, Rn, Rm)


/* ADC  <Xd>, <Xn>, <Xm> (ffe0fc00/9a000000) */
//#define IEM_INSTR_IMPL_A64__ADC_64_addsub_carry(Rd, Rn, Rm)


/* ADCS  <Xd>, <Xn>, <Xm> (ffe0fc00/ba000000) */
//#define IEM_INSTR_IMPL_A64__ADCS_64_addsub_carry(Rd, Rn, Rm)


/* SBC  <Xd>, <Xn>, <Xm> (ffe0fc00/da000000) */
//#define IEM_INSTR_IMPL_A64__SBC_64_addsub_carry(Rd, Rn, Rm)


/* SBCS  <Xd>, <Xn>, <Xm> (ffe0fc00/fa000000) */
//#define IEM_INSTR_IMPL_A64__SBCS_64_addsub_carry(Rd, Rn, Rm)



/*
 *
 * Instruction Set & Groups: addsub_ext / dpreg / A64
 *
 */

/* ADD  <Wd|WSP>, <Wn|WSP>, <Wm>{, <extend>{ #<amount>}} (ffe00000/0b200000) */
//#define IEM_INSTR_IMPL_A64__ADD_32_addsub_ext(Rd, Rn, imm3, option, Rm)


/* ADDS  <Wd>, <Wn|WSP>, <Wm>{, <extend>{ #<amount>}} (ffe00000/2b200000) */
//#define IEM_INSTR_IMPL_A64__ADDS_32S_addsub_ext(Rd, Rn, imm3, option, Rm)


/* SUB  <Wd|WSP>, <Wn|WSP>, <Wm>{, <extend>{ #<amount>}} (ffe00000/4b200000) */
//#define IEM_INSTR_IMPL_A64__SUB_32_addsub_ext(Rd, Rn, imm3, option, Rm)


/* SUBS  <Wd>, <Wn|WSP>, <Wm>{, <extend>{ #<amount>}} (ffe00000/6b200000) */
//#define IEM_INSTR_IMPL_A64__SUBS_32S_addsub_ext(Rd, Rn, imm3, option, Rm)


/* ADD  <Xd|SP>, <Xn|SP>, <R><m>{, <extend>{ #<amount>}} (ffe00000/8b200000) */
//#define IEM_INSTR_IMPL_A64__ADD_64_addsub_ext(Rd, Rn, imm3, option, Rm)


/* ADDS  <Xd>, <Xn|SP>, <R><m>{, <extend>{ #<amount>}} (ffe00000/ab200000) */
//#define IEM_INSTR_IMPL_A64__ADDS_64S_addsub_ext(Rd, Rn, imm3, option, Rm)


/* SUB  <Xd|SP>, <Xn|SP>, <R><m>{, <extend>{ #<amount>}} (ffe00000/cb200000) */
//#define IEM_INSTR_IMPL_A64__SUB_64_addsub_ext(Rd, Rn, imm3, option, Rm)


/* SUBS  <Xd>, <Xn|SP>, <R><m>{, <extend>{ #<amount>}} (ffe00000/eb200000) */
#define IEM_INSTR_IMPL_A64__SUBS_64S_addsub_ext(Rd, Rn, imm3, option, Rm) \
    RT_BREAKPOINT();  /** @todo untested */ \
    if (imm3 > 4) return iemDecodeA64_Invalid(pVCpu, uOpcode); \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_STATUS_FLAGS); \
    IEM_MC_LOCAL(uint64_t, uMinuend); \
    IEM_MC_FETCH_GREG_SP_U64(uMinuend, Rn); \
    IEM_MC_LOCAL(uint64_t, uSubtrahend); \
    IEM_MC_FETCH_AND_EXTEND_GREG_U64(uSubtrahend, Rm, option, imm3); \
    IEM_MC_LOCAL(uint64_t, uDifference); \
    IEM_MC_A64_SUBS_U64(uDifference, uMinuend, uSubtrahend); \
    IEM_MC_STORE_GREG_U64(Rd, uDifference); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()



/*
 *
 * Instruction Set & Groups: addsub_imm / dpimm / A64
 *
 */

/* ADD  <Wd|WSP>, <Wn|WSP>, #<imm>{, <shift>} (ff800000/11000000) */
#define IEM_INSTR_IMPL_A64__ADD_32_addsub_imm(Rd, Rn, imm12, sh) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_SP_U32(uTmp, Rn); \
    IEM_MC_ADD_LOCAL_U32(uTmp, !sh ? imm12 : imm12 << 12); \
    IEM_MC_STORE_GREG_SP_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* ADDS  <Wd>, <Wn|WSP>, #<imm>{, <shift>} (ff800000/31000000) */
//#define IEM_INSTR_IMPL_A64__ADDS_32S_addsub_imm(Rd, Rn, imm12, sh)


/* SUB  <Wd|WSP>, <Wn|WSP>, #<imm>{, <shift>} (ff800000/51000000) */
#define IEM_INSTR_IMPL_A64__SUB_32_addsub_imm(Rd, Rn, imm12, sh) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_SP_U32(uTmp, Rn); \
    IEM_MC_SUB_LOCAL_U32(uTmp, !sh ? imm12 : imm12 << 12); \
    IEM_MC_STORE_GREG_SP_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* SUBS  <Wd>, <Wn|WSP>, #<imm>{, <shift>} (ff800000/71000000) */
//#define IEM_INSTR_IMPL_A64__SUBS_32S_addsub_imm(Rd, Rn, imm12, sh)


/* ADD  <Xd|SP>, <Xn|SP>, #<imm>{, <shift>} (ff800000/91000000) */
#define IEM_INSTR_IMPL_A64__ADD_64_addsub_imm(Rd, Rn, imm12, sh) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_SP_U64(uTmp, Rn); \
    IEM_MC_ADD_LOCAL_U64(uTmp, !sh ? imm12 : imm12 << 12); \
    IEM_MC_STORE_GREG_SP_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* ADDS  <Xd>, <Xn|SP>, #<imm>{, <shift>} (ff800000/b1000000) */
//#define IEM_INSTR_IMPL_A64__ADDS_64S_addsub_imm(Rd, Rn, imm12, sh)


/* SUB  <Xd|SP>, <Xn|SP>, #<imm>{, <shift>} (ff800000/d1000000) */
#define IEM_INSTR_IMPL_A64__SUB_64_addsub_imm(Rd, Rn, imm12, sh) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_SP_U64(uTmp, Rn); \
    IEM_MC_SUB_LOCAL_U64(uTmp, !sh ? imm12 : imm12 << 12); \
    IEM_MC_STORE_GREG_SP_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* SUBS  <Xd>, <Xn|SP>, #<imm>{, <shift>} (ff800000/f1000000) */
#define IEM_INSTR_IMPL_A64__SUBS_64S_addsub_imm(Rd, Rn, imm12, sh) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_STATUS_FLAGS); \
    IEM_MC_LOCAL(uint64_t, uMinuend); \
    IEM_MC_FETCH_GREG_SP_U64(uMinuend, Rn); \
    IEM_MC_LOCAL_CONST(uint64_t, uSubtrahend, !sh ? imm12 : imm12 << 12); \
    IEM_MC_LOCAL(uint64_t, uDifference); \
    IEM_MC_A64_SUBS_U64(uDifference, uMinuend, uSubtrahend); \
    IEM_MC_STORE_GREG_U64(Rd, uDifference); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()



/*
 *
 * Instruction Set & Groups: addsub_immtags / dpimm / A64
 *
 */

/* ADDG  <Xd|SP>, <Xn|SP>, #<uimm6>, #<uimm4> (ffc0c000/91800000) */
//#define IEM_INSTR_IMPL_A64__ADDG_64_addsub_immtags(Rd, Rn, imm4, imm6)


/* SUBG  <Xd|SP>, <Xn|SP>, #<uimm6>, #<uimm4> (ffc0c000/d1800000) */
//#define IEM_INSTR_IMPL_A64__SUBG_64_addsub_immtags(Rd, Rn, imm4, imm6)



/*
 *
 * Instruction Set & Groups: addsub_pt / dpreg / A64
 *
 */

/* ADDPT  <Xd|SP>, <Xn|SP>, <Xm>{, LSL #<amount>} (ffe0e000/9a002000) */
//#define IEM_INSTR_IMPL_A64__ADDPT_64_addsub_pt(Rd, Rn, imm3, Rm)


/* SUBPT  <Xd|SP>, <Xn|SP>, <Xm>{, LSL #<amount>} (ffe0e000/da002000) */
//#define IEM_INSTR_IMPL_A64__SUBPT_64_addsub_pt(Rd, Rn, imm3, Rm)



/*
 *
 * Instruction Set & Groups: addsub_shift / dpreg / A64
 *
 */

/* ADD  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/0b000000) */
#define IEM_INSTR_IMPL_A64__ADD_32_addsub_shift(Rd, Rn, imm6, Rm, shift) \
    if (shift == 3 /*ROR*/ || imm6 >= 32) return iemDecodeA64_Invalid(pVCpu, uOpcode); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_SP_U32(uTmp, Rn); \
    IEM_MC_LOCAL(uint32_t, uSubtrahend); \
    IEM_MC_FETCH_AND_SHIFT_GREG_U32(uSubtrahend, Rm, shift, imm6); \
    IEM_MC_ADD_2LOCS_U32(uTmp, uSubtrahend); \
    IEM_MC_STORE_GREG_SP_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* ADDS  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/2b000000) */
//#define IEM_INSTR_IMPL_A64__ADDS_32_addsub_shift(Rd, Rn, imm6, Rm, shift)


/* SUB  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/4b000000) */
#define IEM_INSTR_IMPL_A64__SUB_32_addsub_shift(Rd, Rn, imm6, Rm, shift) \
    if (shift == 3 /*ROR*/ || imm6 >= 32) return iemDecodeA64_Invalid(pVCpu, uOpcode); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_SP_U32(uTmp, Rn); \
    IEM_MC_LOCAL(uint32_t, uSubtrahend); \
    IEM_MC_FETCH_AND_SHIFT_GREG_U32(uSubtrahend, Rm, shift, imm6); \
    IEM_MC_SUB_2LOCS_U32(uTmp, uSubtrahend); \
    IEM_MC_STORE_GREG_SP_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* SUBS  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/6b000000) */
//#define IEM_INSTR_IMPL_A64__SUBS_32_addsub_shift(Rd, Rn, imm6, Rm, shift)


/* ADD  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/8b000000) */
#define IEM_INSTR_IMPL_A64__ADD_64_addsub_shift(Rd, Rn, imm6, Rm, shift) \
    if (shift == 3 /*ROR*/) return iemDecodeA64_Invalid(pVCpu, uOpcode); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_SP_U64(uTmp, Rn); \
    IEM_MC_LOCAL(uint64_t, uSubtrahend); \
    IEM_MC_FETCH_AND_SHIFT_GREG_U64(uSubtrahend, Rm, shift, imm6); \
    IEM_MC_ADD_2LOCS_U64(uTmp, uSubtrahend); \
    IEM_MC_STORE_GREG_SP_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* ADDS  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/ab000000) */
//#define IEM_INSTR_IMPL_A64__ADDS_64_addsub_shift(Rd, Rn, imm6, Rm, shift)


/* SUB  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/cb000000) */
#define IEM_INSTR_IMPL_A64__SUB_64_addsub_shift(Rd, Rn, imm6, Rm, shift) \
    if (shift == 3 /*ROR*/) return iemDecodeA64_Invalid(pVCpu, uOpcode); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_SP_U64(uTmp, Rn); \
    IEM_MC_LOCAL(uint64_t, uSubtrahend); \
    IEM_MC_FETCH_AND_SHIFT_GREG_U64(uSubtrahend, Rm, shift, imm6); \
    IEM_MC_SUB_2LOCS_U64(uTmp, uSubtrahend); \
    IEM_MC_STORE_GREG_SP_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* SUBS  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/eb000000) */
#define IEM_INSTR_IMPL_A64__SUBS_64_addsub_shift(Rd, Rn, imm6, Rm, shift) \
    if (shift == 3 /*ROR*/) return iemDecodeA64_Invalid(pVCpu, uOpcode); \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_STATUS_FLAGS); \
    IEM_MC_LOCAL(uint64_t, uMinuend); \
    IEM_MC_FETCH_GREG_SP_U64(uMinuend, Rn); \
    IEM_MC_LOCAL(uint64_t, uSubtrahend); \
    IEM_MC_FETCH_AND_SHIFT_GREG_U64(uSubtrahend, Rm, shift, imm6); \
    IEM_MC_LOCAL(uint64_t, uDifference); \
    IEM_MC_A64_SUBS_U64(uDifference, uMinuend, uSubtrahend); \
    IEM_MC_STORE_GREG_U64(Rd, uDifference); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()



/*
 *
 * Instruction Set & Groups: asimdall / simd_dp / A64
 *
 */

/* SADDLV  <V><d>, <Vn>.<T> (bf3ffc00/0e303800) */
//#define IEM_INSTR_IMPL_A64__SADDLV_asimdall_only(Rd, Rn, size, Q)


/* SMAXV  <V><d>, <Vn>.<T> (bf3ffc00/0e30a800) */
//#define IEM_INSTR_IMPL_A64__SMAXV_asimdall_only(Rd, Rn, size, Q)


/* SMINV  <V><d>, <Vn>.<T> (bf3ffc00/0e31a800) */
//#define IEM_INSTR_IMPL_A64__SMINV_asimdall_only(Rd, Rn, size, Q)


/* ADDV  <V><d>, <Vn>.<T> (bf3ffc00/0e31b800) */
//#define IEM_INSTR_IMPL_A64__ADDV_asimdall_only(Rd, Rn, size, Q)


/* FMAXNMV  <V><d>, <Vn>.<T> (bffffc00/0e30c800) */
//#define IEM_INSTR_IMPL_A64__FMAXNMV_asimdall_only_H(Rd, Rn, Q)


/* FMAXV  <V><d>, <Vn>.<T> (bffffc00/0e30f800) */
//#define IEM_INSTR_IMPL_A64__FMAXV_asimdall_only_H(Rd, Rn, Q)


/* FMINNMV  <V><d>, <Vn>.<T> (bffffc00/0eb0c800) */
//#define IEM_INSTR_IMPL_A64__FMINNMV_asimdall_only_H(Rd, Rn, Q)


/* FMINV  <V><d>, <Vn>.<T> (bffffc00/0eb0f800) */
//#define IEM_INSTR_IMPL_A64__FMINV_asimdall_only_H(Rd, Rn, Q)


/* UADDLV  <V><d>, <Vn>.<T> (bf3ffc00/2e303800) */
//#define IEM_INSTR_IMPL_A64__UADDLV_asimdall_only(Rd, Rn, size, Q)


/* UMAXV  <V><d>, <Vn>.<T> (bf3ffc00/2e30a800) */
//#define IEM_INSTR_IMPL_A64__UMAXV_asimdall_only(Rd, Rn, size, Q)


/* UMINV  <V><d>, <Vn>.<T> (bf3ffc00/2e31a800) */
//#define IEM_INSTR_IMPL_A64__UMINV_asimdall_only(Rd, Rn, size, Q)


/* FMAXNMV  S<d>, <Vn>.4S (fffffc00/6e30c800) */
//#define IEM_INSTR_IMPL_A64__FMAXNMV_asimdall_only_SD(Rd, Rn)


/* FMAXV  S<d>, <Vn>.4S (fffffc00/6e30f800) */
//#define IEM_INSTR_IMPL_A64__FMAXV_asimdall_only_SD(Rd, Rn)


/* FMINNMV  S<d>, <Vn>.4S (fffffc00/6eb0c800) */
//#define IEM_INSTR_IMPL_A64__FMINNMV_asimdall_only_SD(Rd, Rn)


/* FMINV  S<d>, <Vn>.4S (fffffc00/6eb0f800) */
//#define IEM_INSTR_IMPL_A64__FMINV_asimdall_only_SD(Rd, Rn)



/*
 *
 * Instruction Set & Groups: asimddiff / simd_dp / A64
 *
 */

/* SADDL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e200000) */
//#define IEM_INSTR_IMPL_A64__SADDL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SADDW2  <Vd>.<Ta>, <Vn>.<Ta>, <Vm>.<Tb> (bf20fc00/0e201000) */
//#define IEM_INSTR_IMPL_A64__SADDW_asimddiff_W(Rd, Rn, Rm, size, Q)


/* SSUBL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e202000) */
//#define IEM_INSTR_IMPL_A64__SSUBL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SSUBW2  <Vd>.<Ta>, <Vn>.<Ta>, <Vm>.<Tb> (bf20fc00/0e203000) */
//#define IEM_INSTR_IMPL_A64__SSUBW_asimddiff_W(Rd, Rn, Rm, size, Q)


/* ADDHN2  <Vd>.<Tb>, <Vn>.<Ta>, <Vm>.<Ta> (bf20fc00/0e204000) */
//#define IEM_INSTR_IMPL_A64__ADDHN_asimddiff_N(Rd, Rn, Rm, size, Q)


/* SABAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e205000) */
//#define IEM_INSTR_IMPL_A64__SABAL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SUBHN2  <Vd>.<Tb>, <Vn>.<Ta>, <Vm>.<Ta> (bf20fc00/0e206000) */
//#define IEM_INSTR_IMPL_A64__SUBHN_asimddiff_N(Rd, Rn, Rm, size, Q)


/* SABDL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e207000) */
//#define IEM_INSTR_IMPL_A64__SABDL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e208000) */
//#define IEM_INSTR_IMPL_A64__SMLAL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SQDMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e209000) */
//#define IEM_INSTR_IMPL_A64__SQDMLAL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e20a000) */
//#define IEM_INSTR_IMPL_A64__SMLSL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SQDMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e20b000) */
//#define IEM_INSTR_IMPL_A64__SQDMLSL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SMULL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e20c000) */
//#define IEM_INSTR_IMPL_A64__SMULL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* SQDMULL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e20d000) */
//#define IEM_INSTR_IMPL_A64__SQDMULL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* PMULL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e20e000) */
//#define IEM_INSTR_IMPL_A64__PMULL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* UADDL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/2e200000) */
//#define IEM_INSTR_IMPL_A64__UADDL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* UADDW2  <Vd>.<Ta>, <Vn>.<Ta>, <Vm>.<Tb> (bf20fc00/2e201000) */
//#define IEM_INSTR_IMPL_A64__UADDW_asimddiff_W(Rd, Rn, Rm, size, Q)


/* USUBL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/2e202000) */
//#define IEM_INSTR_IMPL_A64__USUBL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* USUBW2  <Vd>.<Ta>, <Vn>.<Ta>, <Vm>.<Tb> (bf20fc00/2e203000) */
//#define IEM_INSTR_IMPL_A64__USUBW_asimddiff_W(Rd, Rn, Rm, size, Q)


/* RADDHN2  <Vd>.<Tb>, <Vn>.<Ta>, <Vm>.<Ta> (bf20fc00/2e204000) */
//#define IEM_INSTR_IMPL_A64__RADDHN_asimddiff_N(Rd, Rn, Rm, size, Q)


/* UABAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/2e205000) */
//#define IEM_INSTR_IMPL_A64__UABAL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* RSUBHN2  <Vd>.<Tb>, <Vn>.<Ta>, <Vm>.<Ta> (bf20fc00/2e206000) */
//#define IEM_INSTR_IMPL_A64__RSUBHN_asimddiff_N(Rd, Rn, Rm, size, Q)


/* UABDL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/2e207000) */
//#define IEM_INSTR_IMPL_A64__UABDL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* UMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/2e208000) */
//#define IEM_INSTR_IMPL_A64__UMLAL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* UMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/2e20a000) */
//#define IEM_INSTR_IMPL_A64__UMLSL_asimddiff_L(Rd, Rn, Rm, size, Q)


/* UMULL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/2e20c000) */
//#define IEM_INSTR_IMPL_A64__UMULL_asimddiff_L(Rd, Rn, Rm, size, Q)



/*
 *
 * Instruction Set & Groups: asimdelem / simd_dp / A64
 *
 */

/* SMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/0f002000) */
//#define IEM_INSTR_IMPL_A64__SMLAL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* SQDMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/0f003000) */
//#define IEM_INSTR_IMPL_A64__SQDMLAL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* SMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/0f006000) */
//#define IEM_INSTR_IMPL_A64__SMLSL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* SQDMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/0f007000) */
//#define IEM_INSTR_IMPL_A64__SQDMLSL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* MUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf00f400/0f008000) */
//#define IEM_INSTR_IMPL_A64__MUL_asimdelem_R(Rd, Rn, H, Rm, M, L, size, Q)


/* SMULL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/0f00a000) */
//#define IEM_INSTR_IMPL_A64__SMULL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* SQDMULL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/0f00b000) */
//#define IEM_INSTR_IMPL_A64__SQDMULL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* SQDMULH  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf00f400/0f00c000) */
//#define IEM_INSTR_IMPL_A64__SQDMULH_asimdelem_R(Rd, Rn, H, Rm, M, L, size, Q)


/* SQRDMULH  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf00f400/0f00d000) */
//#define IEM_INSTR_IMPL_A64__SQRDMULH_asimdelem_R(Rd, Rn, H, Rm, M, L, size, Q)


/* SDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.4B[<index>] (bf00f400/0f00e000) */
//#define IEM_INSTR_IMPL_A64__SDOT_asimdelem_D(Rd, Rn, H, Rm, M, L, size, Q)


/* FDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.4B[<index>] (bfc0f400/0f000000) */
//#define IEM_INSTR_IMPL_A64__FDOT_asimdelem_D(Rd, Rn, H, Rm, M, L, Q)


/* FMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.H[<index>] (bfc0f400/0f001000) */
//#define IEM_INSTR_IMPL_A64__FMLA_asimdelem_RH_H(Rd, Rn, H, Rm, M, L, Q)


/* FMLS  <Vd>.<T>, <Vn>.<T>, <Vm>.H[<index>] (bfc0f400/0f005000) */
//#define IEM_INSTR_IMPL_A64__FMLS_asimdelem_RH_H(Rd, Rn, H, Rm, M, L, Q)


/* FMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.H[<index>] (bfc0f400/0f009000) */
//#define IEM_INSTR_IMPL_A64__FMUL_asimdelem_RH_H(Rd, Rn, H, Rm, M, L, Q)


/* SUDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.4B[<index>] (bfc0f400/0f00f000) */
//#define IEM_INSTR_IMPL_A64__SUDOT_asimdelem_D(Rd, Rn, H, Rm, M, L, Q)


/* FDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.2B[<index>] (bfc0f400/0f400000) */
//#define IEM_INSTR_IMPL_A64__FDOT_asimdelem_G(Rd, Rn, H, Rm, M, L, Q)


/* BFDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.2H[<index>] (bfc0f400/0f40f000) */
//#define IEM_INSTR_IMPL_A64__BFDOT_asimdelem_E(Rd, Rn, H, Rm, M, L, Q)


/* FMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf80f400/0f801000) */
//#define IEM_INSTR_IMPL_A64__FMLA_asimdelem_R_SD(Rd, Rn, H, Rm, M, L, sz, Q)


/* FMLS  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf80f400/0f805000) */
//#define IEM_INSTR_IMPL_A64__FMLS_asimdelem_R_SD(Rd, Rn, H, Rm, M, L, sz, Q)


/* FMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf80f400/0f809000) */
//#define IEM_INSTR_IMPL_A64__FMUL_asimdelem_R_SD(Rd, Rn, H, Rm, M, L, sz, Q)


/* FMLAL  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.H[<index>] (bfc0f400/0f800000) */
//#define IEM_INSTR_IMPL_A64__FMLAL_asimdelem_LH(Rd, Rn, H, Rm, M, L, Q)


/* FMLSL  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.H[<index>] (bfc0f400/0f804000) */
//#define IEM_INSTR_IMPL_A64__FMLSL_asimdelem_LH(Rd, Rn, H, Rm, M, L, Q)


/* USDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.4B[<index>] (bfc0f400/0f80f000) */
//#define IEM_INSTR_IMPL_A64__USDOT_asimdelem_D(Rd, Rn, H, Rm, M, L, Q)


/* BFMLAL<bt>  <Vd>.4S, <Vn>.8H, <Vm>.H[<index>] (bfc0f400/0fc0f000) */
//#define IEM_INSTR_IMPL_A64__BFMLAL_asimdelem_F(Rd, Rn, H, Rm, M, L, Q)


/* MLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf00f400/2f000000) */
//#define IEM_INSTR_IMPL_A64__MLA_asimdelem_R(Rd, Rn, H, Rm, M, L, size, Q)


/* UMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/2f002000) */
//#define IEM_INSTR_IMPL_A64__UMLAL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* MLS  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf00f400/2f004000) */
//#define IEM_INSTR_IMPL_A64__MLS_asimdelem_R(Rd, Rn, H, Rm, M, L, size, Q)


/* UMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/2f006000) */
//#define IEM_INSTR_IMPL_A64__UMLSL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* UMULL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>] (bf00f400/2f00a000) */
//#define IEM_INSTR_IMPL_A64__UMULL_asimdelem_L(Rd, Rn, H, Rm, M, L, size, Q)


/* SQRDMLAH  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf00f400/2f00d000) */
//#define IEM_INSTR_IMPL_A64__SQRDMLAH_asimdelem_R(Rd, Rn, H, Rm, M, L, size, Q)


/* UDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.4B[<index>] (bf00f400/2f00e000) */
//#define IEM_INSTR_IMPL_A64__UDOT_asimdelem_D(Rd, Rn, H, Rm, M, L, size, Q)


/* SQRDMLSH  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf00f400/2f00f000) */
//#define IEM_INSTR_IMPL_A64__SQRDMLSH_asimdelem_R(Rd, Rn, H, Rm, M, L, size, Q)


/* FMULX  <Vd>.<T>, <Vn>.<T>, <Vm>.H[<index>] (bfc0f400/2f009000) */
//#define IEM_INSTR_IMPL_A64__FMULX_asimdelem_RH_H(Rd, Rn, H, Rm, M, L, Q)


/* FCMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>], #<rotate> (bf009400/2f001000) */
//#define IEM_INSTR_IMPL_A64__FCMLA_advsimd_elt(Rd, Rn, H, rot, Rm, M, L, size, Q)


/* FMULX  <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>] (bf80f400/2f809000) */
//#define IEM_INSTR_IMPL_A64__FMULX_asimdelem_R_SD(Rd, Rn, H, Rm, M, L, sz, Q)


/* FMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.H[<index>] (bfc0f400/2f808000) */
//#define IEM_INSTR_IMPL_A64__FMLAL2_asimdelem_LH(Rd, Rn, H, Rm, M, L, Q)


/* FMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.H[<index>] (bfc0f400/2f80c000) */
//#define IEM_INSTR_IMPL_A64__FMLSL2_asimdelem_LH(Rd, Rn, H, Rm, M, L, Q)


/* FMLALB  <Vd>.8H, <Vn>.16B, <Vm>.B[<index>] (ffc0f400/0fc00000) */
//#define IEM_INSTR_IMPL_A64__FMLALB_asimdelem_H(Rd, Rn, H, Rm, M, L)


/* FMLALLBB  <Vd>.4S, <Vn>.16B, <Vm>.B[<index>] (ffc0f400/2f008000) */
//#define IEM_INSTR_IMPL_A64__FMLALLBB_asimdelem_J(Rd, Rn, H, Rm, M, L)


/* FMLALLBT  <Vd>.4S, <Vn>.16B, <Vm>.B[<index>] (ffc0f400/2f408000) */
//#define IEM_INSTR_IMPL_A64__FMLALLBT_asimdelem_J(Rd, Rn, H, Rm, M, L)


/* FMLALT  <Vd>.8H, <Vn>.16B, <Vm>.B[<index>] (ffc0f400/4fc00000) */
//#define IEM_INSTR_IMPL_A64__FMLALT_asimdelem_H(Rd, Rn, H, Rm, M, L)


/* FMLALLTB  <Vd>.4S, <Vn>.16B, <Vm>.B[<index>] (ffc0f400/6f008000) */
//#define IEM_INSTR_IMPL_A64__FMLALLTB_asimdelem_J(Rd, Rn, H, Rm, M, L)


/* FMLALLTT  <Vd>.4S, <Vn>.16B, <Vm>.B[<index>] (ffc0f400/6f408000) */
//#define IEM_INSTR_IMPL_A64__FMLALLTT_asimdelem_J(Rd, Rn, H, Rm, M, L)



/*
 *
 * Instruction Set & Groups: asimdext / simd_dp / A64
 *
 */

/* EXT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>, #<index> (bfe08400/2e000000) */
//#define IEM_INSTR_IMPL_A64__EXT_asimdext_only(Rd, Rn, imm4, Rm, Q)



/*
 *
 * Instruction Set & Groups: asimdimm / simd_dp / A64
 *
 */

/* MOVI  <Vd>.<T>, #<imm8>{, LSL #<amount>} (bff89c00/0f000400) */
//#define IEM_INSTR_IMPL_A64__MOVI_asimdimm_L_sl(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* ORR  <Vd>.<T>, #<imm8>{, LSL #<amount>} (bff89c00/0f001400) */
//#define IEM_INSTR_IMPL_A64__ORR_asimdimm_L_sl(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* MOVI  <Vd>.<T>, #<imm8>{, LSL #<amount>} (bff8dc00/0f008400) */
//#define IEM_INSTR_IMPL_A64__MOVI_asimdimm_L_hl(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* ORR  <Vd>.<T>, #<imm8>{, LSL #<amount>} (bff8dc00/0f009400) */
//#define IEM_INSTR_IMPL_A64__ORR_asimdimm_L_hl(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* MOVI  <Vd>.<T>, #<imm8>, MSL #<amount> (bff8ec00/0f00c400) */
//#define IEM_INSTR_IMPL_A64__MOVI_asimdimm_M_sm(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* MOVI  <Vd>.<T>, #<imm8>{, LSL #0} (bff8fc00/0f00e400) */
//#define IEM_INSTR_IMPL_A64__MOVI_asimdimm_N_b(Rd, h, g, f, e, d, c, b, a, Q)


/* FMOV  <Vd>.<T>, #<imm> (bff8fc00/0f00f400) */
//#define IEM_INSTR_IMPL_A64__FMOV_asimdimm_S_s(Rd, h, g, f, e, d, c, b, a, Q)


/* FMOV  <Vd>.<T>, #<imm> (bff8fc00/0f00fc00) */
//#define IEM_INSTR_IMPL_A64__FMOV_asimdimm_H_h(Rd, h, g, f, e, d, c, b, a, Q)


/* MVNI  <Vd>.<T>, #<imm8>{, LSL #<amount>} (bff89c00/2f000400) */
//#define IEM_INSTR_IMPL_A64__MVNI_asimdimm_L_sl(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* BIC  <Vd>.<T>, #<imm8>{, LSL #<amount>} (bff89c00/2f001400) */
//#define IEM_INSTR_IMPL_A64__BIC_asimdimm_L_sl(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* MVNI  <Vd>.<T>, #<imm8>{, LSL #<amount>} (bff8dc00/2f008400) */
//#define IEM_INSTR_IMPL_A64__MVNI_asimdimm_L_hl(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* BIC  <Vd>.<T>, #<imm8>{, LSL #<amount>} (bff8dc00/2f009400) */
//#define IEM_INSTR_IMPL_A64__BIC_asimdimm_L_hl(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* MVNI  <Vd>.<T>, #<imm8>, MSL #<amount> (bff8ec00/2f00c400) */
//#define IEM_INSTR_IMPL_A64__MVNI_asimdimm_M_sm(Rd, h, g, f, e, d, cmode, c, b, a, Q)


/* MOVI  <Dd>, #<imm> (fff8fc00/2f00e400) */
//#define IEM_INSTR_IMPL_A64__MOVI_asimdimm_D_ds(Rd, h, g, f, e, d, c, b, a)


/* MOVI  <Vd>.2D, #<imm> (fff8fc00/6f00e400) */
//#define IEM_INSTR_IMPL_A64__MOVI_asimdimm_D2_d(Rd, h, g, f, e, d, c, b, a)


/* FMOV  <Vd>.2D, #<imm> (fff8fc00/6f00f400) */
//#define IEM_INSTR_IMPL_A64__FMOV_asimdimm_D2_d(Rd, h, g, f, e, d, c, b, a)



/*
 *
 * Instruction Set & Groups: asimdins / simd_dp / A64
 *
 */

/* DUP  <Vd>.<T>, <Vn>.<Ts>[<index>] (bfe0fc00/0e000400) */
//#define IEM_INSTR_IMPL_A64__DUP_asimdins_DV_v(Rd, Rn, imm5, Q)


/* DUP  <Vd>.<T>, <R><n> (bfe0fc00/0e000c00) */
//#define IEM_INSTR_IMPL_A64__DUP_asimdins_DR_r(Rd, Rn, imm5, Q)


/* SMOV  <Wd>, <Vn>.<Ts>[<index>] (ffe0fc00/0e002c00) */
//#define IEM_INSTR_IMPL_A64__SMOV_asimdins_W_w(Rd, Rn, imm5)


/* UMOV  <Wd>, <Vn>.<Ts>[<index>] (ffe0fc00/0e003c00) */
//#define IEM_INSTR_IMPL_A64__UMOV_asimdins_W_w(Rd, Rn, imm5)


/* INS  <Vd>.<Ts>[<index>], <R><n> (ffe0fc00/4e001c00) */
//#define IEM_INSTR_IMPL_A64__INS_asimdins_IR_r(Rd, Rn, imm5)


/* SMOV  <Xd>, <Vn>.<Ts>[<index>] (ffe0fc00/4e002c00) */
//#define IEM_INSTR_IMPL_A64__SMOV_asimdins_X_x(Rd, Rn, imm5)


/* UMOV  <Xd>, <Vn>.D[<index>] (ffeffc00/4e083c00) */
//#define IEM_INSTR_IMPL_A64__UMOV_asimdins_X_x(Rd, Rn, imm5)


/* INS  <Vd>.<Ts>[<index1>], <Vn>.<Ts>[<index2>] (ffe08400/6e000400) */
//#define IEM_INSTR_IMPL_A64__INS_asimdins_IV_v(Rd, Rn, imm4, imm5)



/*
 *
 * Instruction Set & Groups: asimdmisc / simd_dp / A64
 *
 */

/* REV64  <Vd>.<T>, <Vn>.<T> (bf3ffc00/0e200800) */
//#define IEM_INSTR_IMPL_A64__REV64_asimdmisc_R(Rd, Rn, size, Q)


/* REV16  <Vd>.<T>, <Vn>.<T> (bf3ffc00/0e201800) */
//#define IEM_INSTR_IMPL_A64__REV16_asimdmisc_R(Rd, Rn, size, Q)


/* SADDLP  <Vd>.<Ta>, <Vn>.<Tb> (bf3ffc00/0e202800) */
//#define IEM_INSTR_IMPL_A64__SADDLP_asimdmisc_P(Rd, Rn, size, Q)


/* SUQADD  <Vd>.<T>, <Vn>.<T> (bf3ffc00/0e203800) */
//#define IEM_INSTR_IMPL_A64__SUQADD_asimdmisc_R(Rd, Rn, size, Q)


/* CLS  <Vd>.<T>, <Vn>.<T> (bf3ffc00/0e204800) */
//#define IEM_INSTR_IMPL_A64__CLS_asimdmisc_R(Rd, Rn, size, Q)


/* CNT  <Vd>.<T>, <Vn>.<T> (bf3ffc00/0e205800) */
//#define IEM_INSTR_IMPL_A64__CNT_asimdmisc_R(Rd, Rn, size, Q)


/* SADALP  <Vd>.<Ta>, <Vn>.<Tb> (bf3ffc00/0e206800) */
//#define IEM_INSTR_IMPL_A64__SADALP_asimdmisc_P(Rd, Rn, size, Q)


/* SQABS  <Vd>.<T>, <Vn>.<T> (bf3ffc00/0e207800) */
//#define IEM_INSTR_IMPL_A64__SQABS_asimdmisc_R(Rd, Rn, size, Q)


/* CMGT  <Vd>.<T>, <Vn>.<T>, #0 (bf3ffc00/0e208800) */
//#define IEM_INSTR_IMPL_A64__CMGT_asimdmisc_Z(Rd, Rn, size, Q)


/* CMEQ  <Vd>.<T>, <Vn>.<T>, #0 (bf3ffc00/0e209800) */
//#define IEM_INSTR_IMPL_A64__CMEQ_asimdmisc_Z(Rd, Rn, size, Q)


/* CMLT  <Vd>.<T>, <Vn>.<T>, #0 (bf3ffc00/0e20a800) */
//#define IEM_INSTR_IMPL_A64__CMLT_asimdmisc_Z(Rd, Rn, size, Q)


/* ABS  <Vd>.<T>, <Vn>.<T> (bf3ffc00/0e20b800) */
//#define IEM_INSTR_IMPL_A64__ABS_asimdmisc_R(Rd, Rn, size, Q)


/* XTN2  <Vd>.<Tb>, <Vn>.<Ta> (bf3ffc00/0e212800) */
//#define IEM_INSTR_IMPL_A64__XTN_asimdmisc_N(Rd, Rn, size, Q)


/* SQXTN2  <Vd>.<Tb>, <Vn>.<Ta> (bf3ffc00/0e214800) */
//#define IEM_INSTR_IMPL_A64__SQXTN_asimdmisc_N(Rd, Rn, size, Q)


/* FCVTN2  <Vd>.<Tb>, <Vn>.<Ta> (bfbffc00/0e216800) */
//#define IEM_INSTR_IMPL_A64__FCVTN_asimdmisc_N(Rd, Rn, sz, Q)


/* FCVTL2  <Vd>.<Ta>, <Vn>.<Tb> (bfbffc00/0e217800) */
//#define IEM_INSTR_IMPL_A64__FCVTL_asimdmisc_L(Rd, Rn, sz, Q)


/* FRINTN  <Vd>.<T>, <Vn>.<T> (bfbffc00/0e218800) */
//#define IEM_INSTR_IMPL_A64__FRINTN_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINTM  <Vd>.<T>, <Vn>.<T> (bfbffc00/0e219800) */
//#define IEM_INSTR_IMPL_A64__FRINTM_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTNS  <Vd>.<T>, <Vn>.<T> (bfbffc00/0e21a800) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTMS  <Vd>.<T>, <Vn>.<T> (bfbffc00/0e21b800) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTAS  <Vd>.<T>, <Vn>.<T> (bfbffc00/0e21c800) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_asimdmisc_R(Rd, Rn, sz, Q)


/* SCVTF  <Vd>.<T>, <Vn>.<T> (bfbffc00/0e21d800) */
//#define IEM_INSTR_IMPL_A64__SCVTF_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINT32Z  <Vd>.<T>, <Vn>.<T> (bfbffc00/0e21e800) */
//#define IEM_INSTR_IMPL_A64__FRINT32Z_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINT64Z  <Vd>.<T>, <Vn>.<T> (bfbffc00/0e21f800) */
//#define IEM_INSTR_IMPL_A64__FRINT64Z_asimdmisc_R(Rd, Rn, sz, Q)


/* FCMGT  <Vd>.<T>, <Vn>.<T>, #0.0 (bfbffc00/0ea0c800) */
//#define IEM_INSTR_IMPL_A64__FCMGT_asimdmisc_FZ(Rd, Rn, sz, Q)


/* FCMEQ  <Vd>.<T>, <Vn>.<T>, #0.0 (bfbffc00/0ea0d800) */
//#define IEM_INSTR_IMPL_A64__FCMEQ_asimdmisc_FZ(Rd, Rn, sz, Q)


/* FCMLT  <Vd>.<T>, <Vn>.<T>, #0.0 (bfbffc00/0ea0e800) */
//#define IEM_INSTR_IMPL_A64__FCMLT_asimdmisc_FZ(Rd, Rn, sz, Q)


/* FABS  <Vd>.<T>, <Vn>.<T> (bfbffc00/0ea0f800) */
//#define IEM_INSTR_IMPL_A64__FABS_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINTP  <Vd>.<T>, <Vn>.<T> (bfbffc00/0ea18800) */
//#define IEM_INSTR_IMPL_A64__FRINTP_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINTZ  <Vd>.<T>, <Vn>.<T> (bfbffc00/0ea19800) */
//#define IEM_INSTR_IMPL_A64__FRINTZ_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTPS  <Vd>.<T>, <Vn>.<T> (bfbffc00/0ea1a800) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTZS  <Vd>.<T>, <Vn>.<T> (bfbffc00/0ea1b800) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_asimdmisc_R(Rd, Rn, sz, Q)


/* URECPE  <Vd>.<T>, <Vn>.<T> (bfbffc00/0ea1c800) */
//#define IEM_INSTR_IMPL_A64__URECPE_asimdmisc_R(Rd, Rn, sz, Q)


/* FRECPE  <Vd>.<T>, <Vn>.<T> (bfbffc00/0ea1d800) */
//#define IEM_INSTR_IMPL_A64__FRECPE_asimdmisc_R(Rd, Rn, sz, Q)


/* BFCVTN2  <Vd>.<Ta>, <Vn>.4S (bffffc00/0ea16800) */
//#define IEM_INSTR_IMPL_A64__BFCVTN_asimdmisc_4S(Rd, Rn, Q)


/* REV32  <Vd>.<T>, <Vn>.<T> (bf3ffc00/2e200800) */
//#define IEM_INSTR_IMPL_A64__REV32_asimdmisc_R(Rd, Rn, size, Q)


/* UADDLP  <Vd>.<Ta>, <Vn>.<Tb> (bf3ffc00/2e202800) */
//#define IEM_INSTR_IMPL_A64__UADDLP_asimdmisc_P(Rd, Rn, size, Q)


/* USQADD  <Vd>.<T>, <Vn>.<T> (bf3ffc00/2e203800) */
//#define IEM_INSTR_IMPL_A64__USQADD_asimdmisc_R(Rd, Rn, size, Q)


/* CLZ  <Vd>.<T>, <Vn>.<T> (bf3ffc00/2e204800) */
//#define IEM_INSTR_IMPL_A64__CLZ_asimdmisc_R(Rd, Rn, size, Q)


/* UADALP  <Vd>.<Ta>, <Vn>.<Tb> (bf3ffc00/2e206800) */
//#define IEM_INSTR_IMPL_A64__UADALP_asimdmisc_P(Rd, Rn, size, Q)


/* SQNEG  <Vd>.<T>, <Vn>.<T> (bf3ffc00/2e207800) */
//#define IEM_INSTR_IMPL_A64__SQNEG_asimdmisc_R(Rd, Rn, size, Q)


/* CMGE  <Vd>.<T>, <Vn>.<T>, #0 (bf3ffc00/2e208800) */
//#define IEM_INSTR_IMPL_A64__CMGE_asimdmisc_Z(Rd, Rn, size, Q)


/* CMLE  <Vd>.<T>, <Vn>.<T>, #0 (bf3ffc00/2e209800) */
//#define IEM_INSTR_IMPL_A64__CMLE_asimdmisc_Z(Rd, Rn, size, Q)


/* NEG  <Vd>.<T>, <Vn>.<T> (bf3ffc00/2e20b800) */
//#define IEM_INSTR_IMPL_A64__NEG_asimdmisc_R(Rd, Rn, size, Q)


/* SQXTUN2  <Vd>.<Tb>, <Vn>.<Ta> (bf3ffc00/2e212800) */
//#define IEM_INSTR_IMPL_A64__SQXTUN_asimdmisc_N(Rd, Rn, size, Q)


/* SHLL2  <Vd>.<Ta>, <Vn>.<Tb>, #<shift> (bf3ffc00/2e213800) */
//#define IEM_INSTR_IMPL_A64__SHLL_asimdmisc_S(Rd, Rn, size, Q)


/* UQXTN2  <Vd>.<Tb>, <Vn>.<Ta> (bf3ffc00/2e214800) */
//#define IEM_INSTR_IMPL_A64__UQXTN_asimdmisc_N(Rd, Rn, size, Q)


/* FCVTXN2  <Vd>.<Tb>, <Vn>.2D (bffffc00/2e616800) */
//#define IEM_INSTR_IMPL_A64__FCVTXN_asimdmisc_N(Rd, Rn, Q)


/* FRINTA  <Vd>.<T>, <Vn>.<T> (bfbffc00/2e218800) */
//#define IEM_INSTR_IMPL_A64__FRINTA_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINTX  <Vd>.<T>, <Vn>.<T> (bfbffc00/2e219800) */
//#define IEM_INSTR_IMPL_A64__FRINTX_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTNU  <Vd>.<T>, <Vn>.<T> (bfbffc00/2e21a800) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTMU  <Vd>.<T>, <Vn>.<T> (bfbffc00/2e21b800) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTAU  <Vd>.<T>, <Vn>.<T> (bfbffc00/2e21c800) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_asimdmisc_R(Rd, Rn, sz, Q)


/* UCVTF  <Vd>.<T>, <Vn>.<T> (bfbffc00/2e21d800) */
//#define IEM_INSTR_IMPL_A64__UCVTF_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINT32X  <Vd>.<T>, <Vn>.<T> (bfbffc00/2e21e800) */
//#define IEM_INSTR_IMPL_A64__FRINT32X_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINT64X  <Vd>.<T>, <Vn>.<T> (bfbffc00/2e21f800) */
//#define IEM_INSTR_IMPL_A64__FRINT64X_asimdmisc_R(Rd, Rn, sz, Q)


/* NOT  <Vd>.<T>, <Vn>.<T> (bffffc00/2e205800) */
//#define IEM_INSTR_IMPL_A64__NOT_asimdmisc_R(Rd, Rn, Q)


/* F1CVTL2  <Vd>.8H, <Vn>.<Ta> (bffffc00/2e217800) */
//#define IEM_INSTR_IMPL_A64__F1CVTL_asimdmisc_V(Rd, Rn, Q)


/* RBIT  <Vd>.<T>, <Vn>.<T> (bffffc00/2e605800) */
//#define IEM_INSTR_IMPL_A64__RBIT_asimdmisc_R(Rd, Rn, Q)


/* F2CVTL2  <Vd>.8H, <Vn>.<Ta> (bffffc00/2e617800) */
//#define IEM_INSTR_IMPL_A64__F2CVTL_asimdmisc_V(Rd, Rn, Q)


/* FCMGE  <Vd>.<T>, <Vn>.<T>, #0.0 (bfbffc00/2ea0c800) */
//#define IEM_INSTR_IMPL_A64__FCMGE_asimdmisc_FZ(Rd, Rn, sz, Q)


/* FCMLE  <Vd>.<T>, <Vn>.<T>, #0.0 (bfbffc00/2ea0d800) */
//#define IEM_INSTR_IMPL_A64__FCMLE_asimdmisc_FZ(Rd, Rn, sz, Q)


/* FNEG  <Vd>.<T>, <Vn>.<T> (bfbffc00/2ea0f800) */
//#define IEM_INSTR_IMPL_A64__FNEG_asimdmisc_R(Rd, Rn, sz, Q)


/* FRINTI  <Vd>.<T>, <Vn>.<T> (bfbffc00/2ea19800) */
//#define IEM_INSTR_IMPL_A64__FRINTI_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTPU  <Vd>.<T>, <Vn>.<T> (bfbffc00/2ea1a800) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_asimdmisc_R(Rd, Rn, sz, Q)


/* FCVTZU  <Vd>.<T>, <Vn>.<T> (bfbffc00/2ea1b800) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_asimdmisc_R(Rd, Rn, sz, Q)


/* URSQRTE  <Vd>.<T>, <Vn>.<T> (bfbffc00/2ea1c800) */
//#define IEM_INSTR_IMPL_A64__URSQRTE_asimdmisc_R(Rd, Rn, sz, Q)


/* FRSQRTE  <Vd>.<T>, <Vn>.<T> (bfbffc00/2ea1d800) */
//#define IEM_INSTR_IMPL_A64__FRSQRTE_asimdmisc_R(Rd, Rn, sz, Q)


/* FSQRT  <Vd>.<T>, <Vn>.<T> (bfbffc00/2ea1f800) */
//#define IEM_INSTR_IMPL_A64__FSQRT_asimdmisc_R(Rd, Rn, sz, Q)


/* BF1CVTL2  <Vd>.8H, <Vn>.<Ta> (bffffc00/2ea17800) */
//#define IEM_INSTR_IMPL_A64__BF1CVTL_asimdmisc_V(Rd, Rn, Q)


/* BF2CVTL2  <Vd>.8H, <Vn>.<Ta> (bffffc00/2ee17800) */
//#define IEM_INSTR_IMPL_A64__BF2CVTL_asimdmisc_V(Rd, Rn, Q)



/*
 *
 * Instruction Set & Groups: asimdmiscfp16 / simd_dp / A64
 *
 */

/* FRINTN  <Vd>.<T>, <Vn>.<T> (bffffc00/0e798800) */
//#define IEM_INSTR_IMPL_A64__FRINTN_asimdmiscfp16_R(Rd, Rn, Q)


/* FRINTM  <Vd>.<T>, <Vn>.<T> (bffffc00/0e799800) */
//#define IEM_INSTR_IMPL_A64__FRINTM_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTNS  <Vd>.<T>, <Vn>.<T> (bffffc00/0e79a800) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTMS  <Vd>.<T>, <Vn>.<T> (bffffc00/0e79b800) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTAS  <Vd>.<T>, <Vn>.<T> (bffffc00/0e79c800) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_asimdmiscfp16_R(Rd, Rn, Q)


/* SCVTF  <Vd>.<T>, <Vn>.<T> (bffffc00/0e79d800) */
//#define IEM_INSTR_IMPL_A64__SCVTF_asimdmiscfp16_R(Rd, Rn, Q)


/* FCMGT  <Vd>.<T>, <Vn>.<T>, #0.0 (bffffc00/0ef8c800) */
//#define IEM_INSTR_IMPL_A64__FCMGT_asimdmiscfp16_FZ(Rd, Rn, Q)


/* FCMEQ  <Vd>.<T>, <Vn>.<T>, #0.0 (bffffc00/0ef8d800) */
//#define IEM_INSTR_IMPL_A64__FCMEQ_asimdmiscfp16_FZ(Rd, Rn, Q)


/* FCMLT  <Vd>.<T>, <Vn>.<T>, #0.0 (bffffc00/0ef8e800) */
//#define IEM_INSTR_IMPL_A64__FCMLT_asimdmiscfp16_FZ(Rd, Rn, Q)


/* FABS  <Vd>.<T>, <Vn>.<T> (bffffc00/0ef8f800) */
//#define IEM_INSTR_IMPL_A64__FABS_asimdmiscfp16_R(Rd, Rn, Q)


/* FRINTP  <Vd>.<T>, <Vn>.<T> (bffffc00/0ef98800) */
//#define IEM_INSTR_IMPL_A64__FRINTP_asimdmiscfp16_R(Rd, Rn, Q)


/* FRINTZ  <Vd>.<T>, <Vn>.<T> (bffffc00/0ef99800) */
//#define IEM_INSTR_IMPL_A64__FRINTZ_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTPS  <Vd>.<T>, <Vn>.<T> (bffffc00/0ef9a800) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTZS  <Vd>.<T>, <Vn>.<T> (bffffc00/0ef9b800) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_asimdmiscfp16_R(Rd, Rn, Q)


/* FRECPE  <Vd>.<T>, <Vn>.<T> (bffffc00/0ef9d800) */
//#define IEM_INSTR_IMPL_A64__FRECPE_asimdmiscfp16_R(Rd, Rn, Q)


/* FRINTA  <Vd>.<T>, <Vn>.<T> (bffffc00/2e798800) */
//#define IEM_INSTR_IMPL_A64__FRINTA_asimdmiscfp16_R(Rd, Rn, Q)


/* FRINTX  <Vd>.<T>, <Vn>.<T> (bffffc00/2e799800) */
//#define IEM_INSTR_IMPL_A64__FRINTX_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTNU  <Vd>.<T>, <Vn>.<T> (bffffc00/2e79a800) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTMU  <Vd>.<T>, <Vn>.<T> (bffffc00/2e79b800) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTAU  <Vd>.<T>, <Vn>.<T> (bffffc00/2e79c800) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_asimdmiscfp16_R(Rd, Rn, Q)


/* UCVTF  <Vd>.<T>, <Vn>.<T> (bffffc00/2e79d800) */
//#define IEM_INSTR_IMPL_A64__UCVTF_asimdmiscfp16_R(Rd, Rn, Q)


/* FCMGE  <Vd>.<T>, <Vn>.<T>, #0.0 (bffffc00/2ef8c800) */
//#define IEM_INSTR_IMPL_A64__FCMGE_asimdmiscfp16_FZ(Rd, Rn, Q)


/* FCMLE  <Vd>.<T>, <Vn>.<T>, #0.0 (bffffc00/2ef8d800) */
//#define IEM_INSTR_IMPL_A64__FCMLE_asimdmiscfp16_FZ(Rd, Rn, Q)


/* FNEG  <Vd>.<T>, <Vn>.<T> (bffffc00/2ef8f800) */
//#define IEM_INSTR_IMPL_A64__FNEG_asimdmiscfp16_R(Rd, Rn, Q)


/* FRINTI  <Vd>.<T>, <Vn>.<T> (bffffc00/2ef99800) */
//#define IEM_INSTR_IMPL_A64__FRINTI_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTPU  <Vd>.<T>, <Vn>.<T> (bffffc00/2ef9a800) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_asimdmiscfp16_R(Rd, Rn, Q)


/* FCVTZU  <Vd>.<T>, <Vn>.<T> (bffffc00/2ef9b800) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_asimdmiscfp16_R(Rd, Rn, Q)


/* FRSQRTE  <Vd>.<T>, <Vn>.<T> (bffffc00/2ef9d800) */
//#define IEM_INSTR_IMPL_A64__FRSQRTE_asimdmiscfp16_R(Rd, Rn, Q)


/* FSQRT  <Vd>.<T>, <Vn>.<T> (bffffc00/2ef9f800) */
//#define IEM_INSTR_IMPL_A64__FSQRT_asimdmiscfp16_R(Rd, Rn, Q)



/*
 *
 * Instruction Set & Groups: asimdperm / simd_dp / A64
 *
 */

/* UZP1  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e001800) */
//#define IEM_INSTR_IMPL_A64__UZP1_asimdperm_only(Rd, Rn, Rm, size, Q)


/* TRN1  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e002800) */
//#define IEM_INSTR_IMPL_A64__TRN1_asimdperm_only(Rd, Rn, Rm, size, Q)


/* ZIP1  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e003800) */
//#define IEM_INSTR_IMPL_A64__ZIP1_asimdperm_only(Rd, Rn, Rm, size, Q)


/* UZP2  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e005800) */
//#define IEM_INSTR_IMPL_A64__UZP2_asimdperm_only(Rd, Rn, Rm, size, Q)


/* TRN2  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e006800) */
//#define IEM_INSTR_IMPL_A64__TRN2_asimdperm_only(Rd, Rn, Rm, size, Q)


/* ZIP2  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e007800) */
//#define IEM_INSTR_IMPL_A64__ZIP2_asimdperm_only(Rd, Rn, Rm, size, Q)



/*
 *
 * Instruction Set & Groups: asimdsame / simd_dp / A64
 *
 */

/* SHADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e200400) */
//#define IEM_INSTR_IMPL_A64__SHADD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SQADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e200c00) */
//#define IEM_INSTR_IMPL_A64__SQADD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SRHADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e201400) */
//#define IEM_INSTR_IMPL_A64__SRHADD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SHSUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e202400) */
//#define IEM_INSTR_IMPL_A64__SHSUB_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SQSUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e202c00) */
//#define IEM_INSTR_IMPL_A64__SQSUB_asimdsame_only(Rd, Rn, Rm, size, Q)


/* CMGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e203400) */
//#define IEM_INSTR_IMPL_A64__CMGT_asimdsame_only(Rd, Rn, Rm, size, Q)


/* CMGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e203c00) */
//#define IEM_INSTR_IMPL_A64__CMGE_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SSHL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e204400) */
//#define IEM_INSTR_IMPL_A64__SSHL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SQSHL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e204c00) */
//#define IEM_INSTR_IMPL_A64__SQSHL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SRSHL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e205400) */
//#define IEM_INSTR_IMPL_A64__SRSHL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SQRSHL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e205c00) */
//#define IEM_INSTR_IMPL_A64__SQRSHL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e206400) */
//#define IEM_INSTR_IMPL_A64__SMAX_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e206c00) */
//#define IEM_INSTR_IMPL_A64__SMIN_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SABD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e207400) */
//#define IEM_INSTR_IMPL_A64__SABD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SABA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e207c00) */
//#define IEM_INSTR_IMPL_A64__SABA_asimdsame_only(Rd, Rn, Rm, size, Q)


/* ADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e208400) */
//#define IEM_INSTR_IMPL_A64__ADD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* CMTST  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e208c00) */
//#define IEM_INSTR_IMPL_A64__CMTST_asimdsame_only(Rd, Rn, Rm, size, Q)


/* MLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e209400) */
//#define IEM_INSTR_IMPL_A64__MLA_asimdsame_only(Rd, Rn, Rm, size, Q)


/* MUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e209c00) */
//#define IEM_INSTR_IMPL_A64__MUL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SMAXP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e20a400) */
//#define IEM_INSTR_IMPL_A64__SMAXP_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SMINP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e20ac00) */
//#define IEM_INSTR_IMPL_A64__SMINP_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SQDMULH  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e20b400) */
//#define IEM_INSTR_IMPL_A64__SQDMULH_asimdsame_only(Rd, Rn, Rm, size, Q)


/* ADDP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e20bc00) */
//#define IEM_INSTR_IMPL_A64__ADDP_asimdsame_only(Rd, Rn, Rm, size, Q)


/* FMAXNM  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0e20c400) */
//#define IEM_INSTR_IMPL_A64__FMAXNM_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0e20cc00) */
//#define IEM_INSTR_IMPL_A64__FMLA_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0e20d400) */
//#define IEM_INSTR_IMPL_A64__FADD_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FMULX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0e20dc00) */
//#define IEM_INSTR_IMPL_A64__FMULX_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FCMEQ  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0e20e400) */
//#define IEM_INSTR_IMPL_A64__FCMEQ_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0e20f400) */
//#define IEM_INSTR_IMPL_A64__FMAX_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FRECPS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0e20fc00) */
//#define IEM_INSTR_IMPL_A64__FRECPS_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* AND  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e201c00) */
//#define IEM_INSTR_IMPL_A64__AND_asimdsame_only(Rd, Rn, Rm, Q)


/* FMLAL  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/0e20ec00) */
//#define IEM_INSTR_IMPL_A64__FMLAL_asimdsame_F(Rd, Rn, Rm, Q)


/* BIC  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e601c00) */
//#define IEM_INSTR_IMPL_A64__BIC_asimdsame_only(Rd, Rn, Rm, Q)


/* FMINNM  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0ea0c400) */
//#define IEM_INSTR_IMPL_A64__FMINNM_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FMLS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0ea0cc00) */
//#define IEM_INSTR_IMPL_A64__FMLS_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FSUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0ea0d400) */
//#define IEM_INSTR_IMPL_A64__FSUB_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FAMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/0e20dc00) */
//#define IEM_INSTR_IMPL_A64__FAMAX_asimdsame_only(Rd, Rn, Rm, size, Q)


/* FMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0ea0f400) */
//#define IEM_INSTR_IMPL_A64__FMIN_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FRSQRTS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/0ea0fc00) */
//#define IEM_INSTR_IMPL_A64__FRSQRTS_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* ORR  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0ea01c00) */
//#define IEM_INSTR_IMPL_A64__ORR_asimdsame_only(Rd, Rn, Rm, Q)


/* FMLSL  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/0ea0ec00) */
//#define IEM_INSTR_IMPL_A64__FMLSL_asimdsame_F(Rd, Rn, Rm, Q)


/* ORN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0ee01c00) */
//#define IEM_INSTR_IMPL_A64__ORN_asimdsame_only(Rd, Rn, Rm, Q)


/* UHADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e200400) */
//#define IEM_INSTR_IMPL_A64__UHADD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UQADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e200c00) */
//#define IEM_INSTR_IMPL_A64__UQADD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* URHADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e201400) */
//#define IEM_INSTR_IMPL_A64__URHADD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UHSUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e202400) */
//#define IEM_INSTR_IMPL_A64__UHSUB_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UQSUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e202c00) */
//#define IEM_INSTR_IMPL_A64__UQSUB_asimdsame_only(Rd, Rn, Rm, size, Q)


/* CMHI  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e203400) */
//#define IEM_INSTR_IMPL_A64__CMHI_asimdsame_only(Rd, Rn, Rm, size, Q)


/* CMHS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e203c00) */
//#define IEM_INSTR_IMPL_A64__CMHS_asimdsame_only(Rd, Rn, Rm, size, Q)


/* USHL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e204400) */
//#define IEM_INSTR_IMPL_A64__USHL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UQSHL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e204c00) */
//#define IEM_INSTR_IMPL_A64__UQSHL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* URSHL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e205400) */
//#define IEM_INSTR_IMPL_A64__URSHL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UQRSHL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e205c00) */
//#define IEM_INSTR_IMPL_A64__UQRSHL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e206400) */
//#define IEM_INSTR_IMPL_A64__UMAX_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e206c00) */
//#define IEM_INSTR_IMPL_A64__UMIN_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UABD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e207400) */
//#define IEM_INSTR_IMPL_A64__UABD_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UABA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e207c00) */
//#define IEM_INSTR_IMPL_A64__UABA_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e208400) */
//#define IEM_INSTR_IMPL_A64__SUB_asimdsame_only(Rd, Rn, Rm, size, Q)


/* CMEQ  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e208c00) */
//#define IEM_INSTR_IMPL_A64__CMEQ_asimdsame_only(Rd, Rn, Rm, size, Q)


/* MLS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e209400) */
//#define IEM_INSTR_IMPL_A64__MLS_asimdsame_only(Rd, Rn, Rm, size, Q)


/* PMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e209c00) */
//#define IEM_INSTR_IMPL_A64__PMUL_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UMAXP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e20a400) */
//#define IEM_INSTR_IMPL_A64__UMAXP_asimdsame_only(Rd, Rn, Rm, size, Q)


/* UMINP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e20ac00) */
//#define IEM_INSTR_IMPL_A64__UMINP_asimdsame_only(Rd, Rn, Rm, size, Q)


/* SQRDMULH  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e20b400) */
//#define IEM_INSTR_IMPL_A64__SQRDMULH_asimdsame_only(Rd, Rn, Rm, size, Q)


/* FMAXNMP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2e20c400) */
//#define IEM_INSTR_IMPL_A64__FMAXNMP_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FADDP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2e20d400) */
//#define IEM_INSTR_IMPL_A64__FADDP_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2e20dc00) */
//#define IEM_INSTR_IMPL_A64__FMUL_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FCMGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2e20e400) */
//#define IEM_INSTR_IMPL_A64__FCMGE_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FACGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2e20ec00) */
//#define IEM_INSTR_IMPL_A64__FACGE_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FMAXP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2e20f400) */
//#define IEM_INSTR_IMPL_A64__FMAXP_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FDIV  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2e20fc00) */
//#define IEM_INSTR_IMPL_A64__FDIV_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* EOR  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e201c00) */
//#define IEM_INSTR_IMPL_A64__EOR_asimdsame_only(Rd, Rn, Rm, Q)


/* FMLAL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/2e20cc00) */
//#define IEM_INSTR_IMPL_A64__FMLAL2_asimdsame_F(Rd, Rn, Rm, Q)


/* BSL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e601c00) */
//#define IEM_INSTR_IMPL_A64__BSL_asimdsame_only(Rd, Rn, Rm, Q)


/* FMINNMP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2ea0c400) */
//#define IEM_INSTR_IMPL_A64__FMINNMP_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FABD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2ea0d400) */
//#define IEM_INSTR_IMPL_A64__FABD_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FAMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e20dc00) */
//#define IEM_INSTR_IMPL_A64__FAMIN_asimdsame_only(Rd, Rn, Rm, size, Q)


/* FCMGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2ea0e400) */
//#define IEM_INSTR_IMPL_A64__FCMGT_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FACGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2ea0ec00) */
//#define IEM_INSTR_IMPL_A64__FACGT_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FMINP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfa0fc00/2ea0f400) */
//#define IEM_INSTR_IMPL_A64__FMINP_asimdsame_only(Rd, Rn, Rm, sz, Q)


/* FSCALE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e20fc00) */
//#define IEM_INSTR_IMPL_A64__FSCALE_asimdsame_only(Rd, Rn, Rm, size, Q)


/* BIT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ea01c00) */
//#define IEM_INSTR_IMPL_A64__BIT_asimdsame_only(Rd, Rn, Rm, Q)


/* FMLSL2  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/2ea0cc00) */
//#define IEM_INSTR_IMPL_A64__FMLSL2_asimdsame_F(Rd, Rn, Rm, Q)


/* BIF  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ee01c00) */
//#define IEM_INSTR_IMPL_A64__BIF_asimdsame_only(Rd, Rn, Rm, Q)



/*
 *
 * Instruction Set & Groups: asimdsame2 / simd_dp / A64
 *
 */

/* SDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/0e009400) */
//#define IEM_INSTR_IMPL_A64__SDOT_asimdsame2_D(Rd, Rn, Rm, size, Q)


/* FCVTN2  <Vd>.<Ta>, <Vn>.4S, <Vm>.4S (bfe0fc00/0e00f400) */
//#define IEM_INSTR_IMPL_A64__FCVTN_asimdsame2_H(Rd, Rn, Rm, Q)


/* FDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/0e00fc00) */
//#define IEM_INSTR_IMPL_A64__FDOT_asimdsame2_DD(Rd, Rn, Rm, Q)


/* FCVTN  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/0e40f400) */
//#define IEM_INSTR_IMPL_A64__FCVTN_asimdsame2_D(Rd, Rn, Rm, Q)


/* FDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/0e40fc00) */
//#define IEM_INSTR_IMPL_A64__FDOT_asimdsame2_D(Rd, Rn, Rm, Q)


/* USDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/0e809c00) */
//#define IEM_INSTR_IMPL_A64__USDOT_asimdsame2_D(Rd, Rn, Rm, Q)


/* SQRDMLAH  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e008400) */
//#define IEM_INSTR_IMPL_A64__SQRDMLAH_asimdsame2_only(Rd, Rn, Rm, size, Q)


/* SQRDMLSH  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bf20fc00/2e008c00) */
//#define IEM_INSTR_IMPL_A64__SQRDMLSH_asimdsame2_only(Rd, Rn, Rm, size, Q)


/* UDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bf20fc00/2e009400) */
//#define IEM_INSTR_IMPL_A64__UDOT_asimdsame2_D(Rd, Rn, Rm, size, Q)


/* FCMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>, #<rotate> (bf20e400/2e00c400) */
//#define IEM_INSTR_IMPL_A64__FCMLA_asimdsame2_C(Rd, Rn, rot, Rm, size, Q)


/* FCADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T>, #<rotate> (bf20ec00/2e00e400) */
//#define IEM_INSTR_IMPL_A64__FCADD_asimdsame2_C(Rd, Rn, rot, Rm, size, Q)


/* BFDOT  <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb> (bfe0fc00/2e40fc00) */
//#define IEM_INSTR_IMPL_A64__BFDOT_asimdsame2_D(Rd, Rn, Rm, Q)


/* BFMLAL<bt>  <Vd>.4S, <Vn>.8H, <Vm>.8H (bfe0fc00/2ec0fc00) */
//#define IEM_INSTR_IMPL_A64__BFMLAL_asimdsame2_F(Rd, Rn, Rm, Q)


/* FMLALLBB  <Vd>.4S, <Vn>.16B, <Vm>.16B (ffe0fc00/0e00c400) */
//#define IEM_INSTR_IMPL_A64__FMLALLBB_asimdsame2_G(Rd, Rn, Rm)


/* FMLALLBT  <Vd>.4S, <Vn>.16B, <Vm>.16B (ffe0fc00/0e40c400) */
//#define IEM_INSTR_IMPL_A64__FMLALLBT_asimdsame2_G(Rd, Rn, Rm)


/* FMLALB  <Vd>.8H, <Vn>.16B, <Vm>.16B (ffe0fc00/0ec0fc00) */
//#define IEM_INSTR_IMPL_A64__FMLALB_asimdsame2_J(Rd, Rn, Rm)


/* FMLALLTB  <Vd>.4S, <Vn>.16B, <Vm>.16B (ffe0fc00/4e00c400) */
//#define IEM_INSTR_IMPL_A64__FMLALLTB_asimdsame2_G(Rd, Rn, Rm)


/* FMLALLTT  <Vd>.4S, <Vn>.16B, <Vm>.16B (ffe0fc00/4e40c400) */
//#define IEM_INSTR_IMPL_A64__FMLALLTT_asimdsame2_G(Rd, Rn, Rm)


/* SMMLA  <Vd>.4S, <Vn>.16B, <Vm>.16B (ffe0fc00/4e80a400) */
//#define IEM_INSTR_IMPL_A64__SMMLA_asimdsame2_G(Rd, Rn, Rm)


/* USMMLA  <Vd>.4S, <Vn>.16B, <Vm>.16B (ffe0fc00/4e80ac00) */
//#define IEM_INSTR_IMPL_A64__USMMLA_asimdsame2_G(Rd, Rn, Rm)


/* FMLALT  <Vd>.8H, <Vn>.16B, <Vm>.16B (ffe0fc00/4ec0fc00) */
//#define IEM_INSTR_IMPL_A64__FMLALT_asimdsame2_J(Rd, Rn, Rm)


/* FMMLA  <Vd>.8H, <Vn>.16B, <Vm>.16B (ffe0fc00/6e00ec00) */
//#define IEM_INSTR_IMPL_A64__FMMLA_asimd_FP8FP16(Rd, Rn, Rm)


/* BFMMLA  <Vd>.4S, <Vn>.8H, <Vm>.8H (ffe0fc00/6e40ec00) */
//#define IEM_INSTR_IMPL_A64__BFMMLA_asimdsame2_E(Rd, Rn, Rm)


/* FMMLA  <Vd>.4S, <Vn>.16B, <Vm>.16B (ffe0fc00/6e80ec00) */
//#define IEM_INSTR_IMPL_A64__FMMLA_asimd_FP8FP32(Rd, Rn, Rm)


/* UMMLA  <Vd>.4S, <Vn>.16B, <Vm>.16B (ffe0fc00/6e80a400) */
//#define IEM_INSTR_IMPL_A64__UMMLA_asimdsame2_G(Rd, Rn, Rm)



/*
 *
 * Instruction Set & Groups: asimdsamefp16 / simd_dp / A64
 *
 */

/* FMAXNM  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e400400) */
//#define IEM_INSTR_IMPL_A64__FMAXNM_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMLA  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e400c00) */
//#define IEM_INSTR_IMPL_A64__FMLA_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FADD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e401400) */
//#define IEM_INSTR_IMPL_A64__FADD_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMULX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e401c00) */
//#define IEM_INSTR_IMPL_A64__FMULX_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FCMEQ  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e402400) */
//#define IEM_INSTR_IMPL_A64__FCMEQ_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e403400) */
//#define IEM_INSTR_IMPL_A64__FMAX_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FRECPS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0e403c00) */
//#define IEM_INSTR_IMPL_A64__FRECPS_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMINNM  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0ec00400) */
//#define IEM_INSTR_IMPL_A64__FMINNM_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMLS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0ec00c00) */
//#define IEM_INSTR_IMPL_A64__FMLS_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FSUB  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0ec01400) */
//#define IEM_INSTR_IMPL_A64__FSUB_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FAMAX  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0ec01c00) */
//#define IEM_INSTR_IMPL_A64__FAMAX_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0ec03400) */
//#define IEM_INSTR_IMPL_A64__FMIN_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FRSQRTS  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/0ec03c00) */
//#define IEM_INSTR_IMPL_A64__FRSQRTS_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMAXNMP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e400400) */
//#define IEM_INSTR_IMPL_A64__FMAXNMP_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FADDP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e401400) */
//#define IEM_INSTR_IMPL_A64__FADDP_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMUL  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e401c00) */
//#define IEM_INSTR_IMPL_A64__FMUL_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FCMGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e402400) */
//#define IEM_INSTR_IMPL_A64__FCMGE_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FACGE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e402c00) */
//#define IEM_INSTR_IMPL_A64__FACGE_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMAXP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e403400) */
//#define IEM_INSTR_IMPL_A64__FMAXP_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FDIV  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2e403c00) */
//#define IEM_INSTR_IMPL_A64__FDIV_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMINNMP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ec00400) */
//#define IEM_INSTR_IMPL_A64__FMINNMP_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FABD  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ec01400) */
//#define IEM_INSTR_IMPL_A64__FABD_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FAMIN  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ec01c00) */
//#define IEM_INSTR_IMPL_A64__FAMIN_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FCMGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ec02400) */
//#define IEM_INSTR_IMPL_A64__FCMGT_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FACGT  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ec02c00) */
//#define IEM_INSTR_IMPL_A64__FACGT_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FMINP  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ec03400) */
//#define IEM_INSTR_IMPL_A64__FMINP_asimdsamefp16_only(Rd, Rn, Rm, Q)


/* FSCALE  <Vd>.<T>, <Vn>.<T>, <Vm>.<T> (bfe0fc00/2ec03c00) */
//#define IEM_INSTR_IMPL_A64__FSCALE_asimdsamefp16_only(Rd, Rn, Rm, Q)



/*
 *
 * Instruction Set & Groups: asimdshf / simd_dp / A64
 *
 */

/* SSHR  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/0f000400) */
//#define IEM_INSTR_IMPL_A64__SSHR_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SSRA  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/0f001400) */
//#define IEM_INSTR_IMPL_A64__SSRA_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SRSHR  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/0f002400) */
//#define IEM_INSTR_IMPL_A64__SRSHR_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SRSRA  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/0f003400) */
//#define IEM_INSTR_IMPL_A64__SRSRA_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SHL  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/0f005400) */
//#define IEM_INSTR_IMPL_A64__SHL_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SQSHL  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/0f007400) */
//#define IEM_INSTR_IMPL_A64__SQSHL_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SHRN2  <Vd>.<Tb>, <Vn>.<Ta>, #<shift> (bf80fc00/0f008400) */
//#define IEM_INSTR_IMPL_A64__SHRN_asimdshf_N(Rd, Rn, immb, immh, Q)


/* RSHRN2  <Vd>.<Tb>, <Vn>.<Ta>, #<shift> (bf80fc00/0f008c00) */
//#define IEM_INSTR_IMPL_A64__RSHRN_asimdshf_N(Rd, Rn, immb, immh, Q)


/* SQSHRN2  <Vd>.<Tb>, <Vn>.<Ta>, #<shift> (bf80fc00/0f009400) */
//#define IEM_INSTR_IMPL_A64__SQSHRN_asimdshf_N(Rd, Rn, immb, immh, Q)


/* SQRSHRN2  <Vd>.<Tb>, <Vn>.<Ta>, #<shift> (bf80fc00/0f009c00) */
//#define IEM_INSTR_IMPL_A64__SQRSHRN_asimdshf_N(Rd, Rn, immb, immh, Q)


/* SSHLL2  <Vd>.<Ta>, <Vn>.<Tb>, #<shift> (bf80fc00/0f00a400) */
//#define IEM_INSTR_IMPL_A64__SSHLL_asimdshf_L(Rd, Rn, immb, immh, Q)


/* SCVTF  <Vd>.<T>, <Vn>.<T>, #<fbits> (bf80fc00/0f00e400) */
//#define IEM_INSTR_IMPL_A64__SCVTF_asimdshf_C(Rd, Rn, immb, immh, Q)


/* FCVTZS  <Vd>.<T>, <Vn>.<T>, #<fbits> (bf80fc00/0f00fc00) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_asimdshf_C(Rd, Rn, immb, immh, Q)


/* USHR  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/2f000400) */
//#define IEM_INSTR_IMPL_A64__USHR_asimdshf_R(Rd, Rn, immb, immh, Q)


/* USRA  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/2f001400) */
//#define IEM_INSTR_IMPL_A64__USRA_asimdshf_R(Rd, Rn, immb, immh, Q)


/* URSHR  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/2f002400) */
//#define IEM_INSTR_IMPL_A64__URSHR_asimdshf_R(Rd, Rn, immb, immh, Q)


/* URSRA  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/2f003400) */
//#define IEM_INSTR_IMPL_A64__URSRA_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SRI  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/2f004400) */
//#define IEM_INSTR_IMPL_A64__SRI_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SLI  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/2f005400) */
//#define IEM_INSTR_IMPL_A64__SLI_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SQSHLU  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/2f006400) */
//#define IEM_INSTR_IMPL_A64__SQSHLU_asimdshf_R(Rd, Rn, immb, immh, Q)


/* UQSHL  <Vd>.<T>, <Vn>.<T>, #<shift> (bf80fc00/2f007400) */
//#define IEM_INSTR_IMPL_A64__UQSHL_asimdshf_R(Rd, Rn, immb, immh, Q)


/* SQSHRUN2  <Vd>.<Tb>, <Vn>.<Ta>, #<shift> (bf80fc00/2f008400) */
//#define IEM_INSTR_IMPL_A64__SQSHRUN_asimdshf_N(Rd, Rn, immb, immh, Q)


/* SQRSHRUN2  <Vd>.<Tb>, <Vn>.<Ta>, #<shift> (bf80fc00/2f008c00) */
//#define IEM_INSTR_IMPL_A64__SQRSHRUN_asimdshf_N(Rd, Rn, immb, immh, Q)


/* UQSHRN2  <Vd>.<Tb>, <Vn>.<Ta>, #<shift> (bf80fc00/2f009400) */
//#define IEM_INSTR_IMPL_A64__UQSHRN_asimdshf_N(Rd, Rn, immb, immh, Q)


/* UQRSHRN2  <Vd>.<Tb>, <Vn>.<Ta>, #<shift> (bf80fc00/2f009c00) */
//#define IEM_INSTR_IMPL_A64__UQRSHRN_asimdshf_N(Rd, Rn, immb, immh, Q)


/* USHLL2  <Vd>.<Ta>, <Vn>.<Tb>, #<shift> (bf80fc00/2f00a400) */
//#define IEM_INSTR_IMPL_A64__USHLL_asimdshf_L(Rd, Rn, immb, immh, Q)


/* UCVTF  <Vd>.<T>, <Vn>.<T>, #<fbits> (bf80fc00/2f00e400) */
//#define IEM_INSTR_IMPL_A64__UCVTF_asimdshf_C(Rd, Rn, immb, immh, Q)


/* FCVTZU  <Vd>.<T>, <Vn>.<T>, #<fbits> (bf80fc00/2f00fc00) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_asimdshf_C(Rd, Rn, immb, immh, Q)



/*
 *
 * Instruction Set & Groups: asimdtbl / simd_dp / A64
 *
 */

/* TBL  <Vd>.<Ta>, { <Vn>.16B }, <Vm>.<Ta> (bfe0fc00/0e000000) */
//#define IEM_INSTR_IMPL_A64__TBL_asimdtbl_L1_1(Rd, Rn, Rm, Q)


/* TBX  <Vd>.<Ta>, { <Vn>.16B }, <Vm>.<Ta> (bfe0fc00/0e001000) */
//#define IEM_INSTR_IMPL_A64__TBX_asimdtbl_L1_1(Rd, Rn, Rm, Q)


/* TBL  <Vd>.<Ta>, { <Vn>.16B, <Vn+1>.16B }, <Vm>.<Ta> (bfe0fc00/0e002000) */
//#define IEM_INSTR_IMPL_A64__TBL_asimdtbl_L2_2(Rd, Rn, Rm, Q)


/* TBX  <Vd>.<Ta>, { <Vn>.16B, <Vn+1>.16B }, <Vm>.<Ta> (bfe0fc00/0e003000) */
//#define IEM_INSTR_IMPL_A64__TBX_asimdtbl_L2_2(Rd, Rn, Rm, Q)


/* TBL  <Vd>.<Ta>, { <Vn>.16B, <Vn+1>.16B, <Vn+2>.16B }, <Vm>.<Ta> (bfe0fc00/0e004000) */
//#define IEM_INSTR_IMPL_A64__TBL_asimdtbl_L3_3(Rd, Rn, Rm, Q)


/* TBX  <Vd>.<Ta>, { <Vn>.16B, <Vn+1>.16B, <Vn+2>.16B }, <Vm>.<Ta> (bfe0fc00/0e005000) */
//#define IEM_INSTR_IMPL_A64__TBX_asimdtbl_L3_3(Rd, Rn, Rm, Q)


/* TBL  <Vd>.<Ta>, { <Vn>.16B, <Vn+1>.16B, <Vn+2>.16B, <Vn+3>.16B }, <Vm>.<Ta> (bfe0fc00/0e006000) */
//#define IEM_INSTR_IMPL_A64__TBL_asimdtbl_L4_4(Rd, Rn, Rm, Q)


/* TBX  <Vd>.<Ta>, { <Vn>.16B, <Vn+1>.16B, <Vn+2>.16B, <Vn+3>.16B }, <Vm>.<Ta> (bfe0fc00/0e007000) */
//#define IEM_INSTR_IMPL_A64__TBX_asimdtbl_L4_4(Rd, Rn, Rm, Q)


/* LUTI4  <Vd>.8H, { <Vn1>.8H, <Vn2>.8H }, <Vm>[<index>] (ffe09c00/4e401000) */
//#define IEM_INSTR_IMPL_A64__LUTI4_asimdtbl_L7(Rd, Rn, len, Rm)


/* LUTI4  <Vd>.16B, { <Vn>.16B }, <Vm>[<index>] (ffe0bc00/4e402000) */
//#define IEM_INSTR_IMPL_A64__LUTI4_asimdtbl_L5(Rd, Rn, len, Rm)


/* LUTI2  <Vd>.16B, { <Vn>.16B }, <Vm>[<index>] (ffe09c00/4e801000) */
//#define IEM_INSTR_IMPL_A64__LUTI2_asimdtbl_L5(Rd, Rn, len, Rm)


/* LUTI2  <Vd>.8H, { <Vn>.8H }, <Vm>[<index>] (ffe08c00/4ec00000) */
//#define IEM_INSTR_IMPL_A64__LUTI2_asimdtbl_L6(Rd, Rn, op, len, Rm)



/*
 *
 * Instruction Set & Groups: asisddiff / simd_dp / A64
 *
 */

/* SQDMLAL  <Va><d>, <Vb><n>, <Vb><m> (ff20fc00/5e209000) */
//#define IEM_INSTR_IMPL_A64__SQDMLAL_asisddiff_only(Rd, Rn, Rm, size)


/* SQDMLSL  <Va><d>, <Vb><n>, <Vb><m> (ff20fc00/5e20b000) */
//#define IEM_INSTR_IMPL_A64__SQDMLSL_asisddiff_only(Rd, Rn, Rm, size)


/* SQDMULL  <Va><d>, <Vb><n>, <Vb><m> (ff20fc00/5e20d000) */
//#define IEM_INSTR_IMPL_A64__SQDMULL_asisddiff_only(Rd, Rn, Rm, size)



/*
 *
 * Instruction Set & Groups: asisdelem / simd_dp / A64
 *
 */

/* SQDMLAL  <Va><d>, <Vb><n>, <Vm>.<Ts>[<index>] (ff00f400/5f003000) */
//#define IEM_INSTR_IMPL_A64__SQDMLAL_asisdelem_L(Rd, Rn, H, Rm, M, L, size)


/* SQDMLSL  <Va><d>, <Vb><n>, <Vm>.<Ts>[<index>] (ff00f400/5f007000) */
//#define IEM_INSTR_IMPL_A64__SQDMLSL_asisdelem_L(Rd, Rn, H, Rm, M, L, size)


/* SQDMULL  <Va><d>, <Vb><n>, <Vm>.<Ts>[<index>] (ff00f400/5f00b000) */
//#define IEM_INSTR_IMPL_A64__SQDMULL_asisdelem_L(Rd, Rn, H, Rm, M, L, size)


/* SQDMULH  <V><d>, <V><n>, <Vm>.<Ts>[<index>] (ff00f400/5f00c000) */
//#define IEM_INSTR_IMPL_A64__SQDMULH_asisdelem_R(Rd, Rn, H, Rm, M, L, size)


/* SQRDMULH  <V><d>, <V><n>, <Vm>.<Ts>[<index>] (ff00f400/5f00d000) */
//#define IEM_INSTR_IMPL_A64__SQRDMULH_asisdelem_R(Rd, Rn, H, Rm, M, L, size)


/* FMLA  <Hd>, <Hn>, <Vm>.H[<index>] (ffc0f400/5f001000) */
//#define IEM_INSTR_IMPL_A64__FMLA_asisdelem_RH_H(Rd, Rn, H, Rm, M, L)


/* FMLS  <Hd>, <Hn>, <Vm>.H[<index>] (ffc0f400/5f005000) */
//#define IEM_INSTR_IMPL_A64__FMLS_asisdelem_RH_H(Rd, Rn, H, Rm, M, L)


/* FMUL  <Hd>, <Hn>, <Vm>.H[<index>] (ffc0f400/5f009000) */
//#define IEM_INSTR_IMPL_A64__FMUL_asisdelem_RH_H(Rd, Rn, H, Rm, M, L)


/* FMLA  <V><d>, <V><n>, <Vm>.<Ts>[<index>] (ff80f400/5f801000) */
//#define IEM_INSTR_IMPL_A64__FMLA_asisdelem_R_SD(Rd, Rn, H, Rm, M, L, sz)


/* FMLS  <V><d>, <V><n>, <Vm>.<Ts>[<index>] (ff80f400/5f805000) */
//#define IEM_INSTR_IMPL_A64__FMLS_asisdelem_R_SD(Rd, Rn, H, Rm, M, L, sz)


/* FMUL  <V><d>, <V><n>, <Vm>.<Ts>[<index>] (ff80f400/5f809000) */
//#define IEM_INSTR_IMPL_A64__FMUL_asisdelem_R_SD(Rd, Rn, H, Rm, M, L, sz)


/* SQRDMLAH  <V><d>, <V><n>, <Vm>.<Ts>[<index>] (ff00f400/7f00d000) */
//#define IEM_INSTR_IMPL_A64__SQRDMLAH_asisdelem_R(Rd, Rn, H, Rm, M, L, size)


/* SQRDMLSH  <V><d>, <V><n>, <Vm>.<Ts>[<index>] (ff00f400/7f00f000) */
//#define IEM_INSTR_IMPL_A64__SQRDMLSH_asisdelem_R(Rd, Rn, H, Rm, M, L, size)


/* FMULX  <Hd>, <Hn>, <Vm>.H[<index>] (ffc0f400/7f009000) */
//#define IEM_INSTR_IMPL_A64__FMULX_asisdelem_RH_H(Rd, Rn, H, Rm, M, L)


/* FMULX  <V><d>, <V><n>, <Vm>.<Ts>[<index>] (ff80f400/7f809000) */
//#define IEM_INSTR_IMPL_A64__FMULX_asisdelem_R_SD(Rd, Rn, H, Rm, M, L, sz)



/*
 *
 * Instruction Set & Groups: asisdlse / ldst / A64
 *
 */

/* ST4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>] (bffff000/0c000000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlse_R4(Rt, Rn, size, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>] (bffff000/0c002000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlse_R4_4v(Rt, Rn, size, Q)


/* ST3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>] (bffff000/0c004000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlse_R3(Rt, Rn, size, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>] (bffff000/0c006000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlse_R3_3v(Rt, Rn, size, Q)


/* ST1  { <Vt>.<T> }, [<Xn|SP>] (bffff000/0c007000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlse_R1_1v(Rt, Rn, size, Q)


/* ST2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>] (bffff000/0c008000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlse_R2(Rt, Rn, size, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>] (bffff000/0c00a000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlse_R2_2v(Rt, Rn, size, Q)


/* LD4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>] (bffff000/0c400000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlse_R4(Rt, Rn, size, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>] (bffff000/0c402000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlse_R4_4v(Rt, Rn, size, Q)


/* LD3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>] (bffff000/0c404000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlse_R3(Rt, Rn, size, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>] (bffff000/0c406000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlse_R3_3v(Rt, Rn, size, Q)


/* LD1  { <Vt>.<T> }, [<Xn|SP>] (bffff000/0c407000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlse_R1_1v(Rt, Rn, size, Q)


/* LD2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>] (bffff000/0c408000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlse_R2(Rt, Rn, size, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>] (bffff000/0c40a000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlse_R2_2v(Rt, Rn, size, Q)



/*
 *
 * Instruction Set & Groups: asisdlsep / ldst / A64
 *
 */

/* ST4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0c800000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsep_R4_r(Rt, Rn, size, Rm, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0c802000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsep_R4_r4(Rt, Rn, size, Rm, Q)


/* ST3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0c804000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsep_R3_r(Rt, Rn, size, Rm, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0c806000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsep_R3_r3(Rt, Rn, size, Rm, Q)


/* ST1  { <Vt>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0c807000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsep_R1_r1(Rt, Rn, size, Rm, Q)


/* ST2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0c808000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsep_R2_r(Rt, Rn, size, Rm, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0c80a000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsep_R2_r2(Rt, Rn, size, Rm, Q)


/* ST4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm> (bffff000/0c9f0000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsep_I4_i(Rt, Rn, size, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm> (bffff000/0c9f2000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsep_I4_i4(Rt, Rn, size, Q)


/* ST3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm> (bffff000/0c9f4000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsep_I3_i(Rt, Rn, size, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm> (bffff000/0c9f6000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsep_I3_i3(Rt, Rn, size, Q)


/* ST1  { <Vt>.<T> }, [<Xn|SP>], <imm> (bffff000/0c9f7000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsep_I1_i1(Rt, Rn, size, Q)


/* ST2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm> (bffff000/0c9f8000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsep_I2_i(Rt, Rn, size, Q)


/* ST1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm> (bffff000/0c9fa000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsep_I2_i2(Rt, Rn, size, Q)


/* LD4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0cc00000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsep_R4_r(Rt, Rn, size, Rm, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0cc02000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsep_R4_r4(Rt, Rn, size, Rm, Q)


/* LD3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0cc04000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsep_R3_r(Rt, Rn, size, Rm, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0cc06000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsep_R3_r3(Rt, Rn, size, Rm, Q)


/* LD1  { <Vt>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0cc07000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsep_R1_r1(Rt, Rn, size, Rm, Q)


/* LD2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0cc08000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsep_R2_r(Rt, Rn, size, Rm, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0cc0a000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsep_R2_r2(Rt, Rn, size, Rm, Q)


/* LD4  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm> (bffff000/0cdf0000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsep_I4_i(Rt, Rn, size, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm> (bffff000/0cdf2000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsep_I4_i4(Rt, Rn, size, Q)


/* LD3  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm> (bffff000/0cdf4000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsep_I3_i(Rt, Rn, size, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm> (bffff000/0cdf6000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsep_I3_i3(Rt, Rn, size, Q)


/* LD1  { <Vt>.<T> }, [<Xn|SP>], <imm> (bffff000/0cdf7000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsep_I1_i1(Rt, Rn, size, Q)


/* LD2  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm> (bffff000/0cdf8000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsep_I2_i(Rt, Rn, size, Q)


/* LD1  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm> (bffff000/0cdfa000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsep_I2_i2(Rt, Rn, size, Q)



/*
 *
 * Instruction Set & Groups: asisdlso / ldst / A64
 *
 */

/* ST1  { <Vt>.B }[<index>], [<Xn|SP>] (bfffe000/0d000000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlso_B1_1b(Rt, Rn, size, S, Q)


/* ST3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>] (bfffe000/0d002000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlso_B3_3b(Rt, Rn, size, S, Q)


/* ST1  { <Vt>.H }[<index>], [<Xn|SP>] (bfffe400/0d004000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlso_H1_1h(Rt, Rn, size, S, Q)


/* ST3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>] (bfffe400/0d006000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlso_H3_3h(Rt, Rn, size, S, Q)


/* ST1  { <Vt>.S }[<index>], [<Xn|SP>] (bfffec00/0d008000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlso_S1_1s(Rt, Rn, S, Q)


/* ST1  { <Vt>.D }[<index>], [<Xn|SP>] (bffffc00/0d008400) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlso_D1_1d(Rt, Rn, Q)


/* ST3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>] (bfffec00/0d00a000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlso_S3_3s(Rt, Rn, S, Q)


/* ST3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>] (bffffc00/0d00a400) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlso_D3_3d(Rt, Rn, Q)


/* STL1  { <Vt>.D }[<index>], [<Xn|SP>] (bffffc00/0d018400) */
//#define IEM_INSTR_IMPL_A64__STL1_asisdlso_D1(Rt, Rn, Q)


/* ST2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>] (bfffe000/0d200000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlso_B2_2b(Rt, Rn, size, S, Q)


/* ST4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>] (bfffe000/0d202000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlso_B4_4b(Rt, Rn, size, S, Q)


/* ST2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>] (bfffe400/0d204000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlso_H2_2h(Rt, Rn, size, S, Q)


/* ST4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>] (bfffe400/0d206000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlso_H4_4h(Rt, Rn, size, S, Q)


/* ST2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>] (bfffec00/0d208000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlso_S2_2s(Rt, Rn, S, Q)


/* ST2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>] (bffffc00/0d208400) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlso_D2_2d(Rt, Rn, Q)


/* ST4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>] (bfffec00/0d20a000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlso_S4_4s(Rt, Rn, S, Q)


/* ST4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>] (bffffc00/0d20a400) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlso_D4_4d(Rt, Rn, Q)


/* LD1  { <Vt>.B }[<index>], [<Xn|SP>] (bfffe000/0d400000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlso_B1_1b(Rt, Rn, size, S, Q)


/* LD3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>] (bfffe000/0d402000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlso_B3_3b(Rt, Rn, size, S, Q)


/* LD1  { <Vt>.H }[<index>], [<Xn|SP>] (bfffe400/0d404000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlso_H1_1h(Rt, Rn, size, S, Q)


/* LD3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>] (bfffe400/0d406000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlso_H3_3h(Rt, Rn, size, S, Q)


/* LD1  { <Vt>.S }[<index>], [<Xn|SP>] (bfffec00/0d408000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlso_S1_1s(Rt, Rn, S, Q)


/* LD1  { <Vt>.D }[<index>], [<Xn|SP>] (bffffc00/0d408400) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlso_D1_1d(Rt, Rn, Q)


/* LD3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>] (bfffec00/0d40a000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlso_S3_3s(Rt, Rn, S, Q)


/* LD3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>] (bffffc00/0d40a400) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlso_D3_3d(Rt, Rn, Q)


/* LD1R  { <Vt>.<T> }, [<Xn|SP>] (bffff000/0d40c000) */
//#define IEM_INSTR_IMPL_A64__LD1R_asisdlso_R1(Rt, Rn, size, Q)


/* LD3R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>] (bffff000/0d40e000) */
//#define IEM_INSTR_IMPL_A64__LD3R_asisdlso_R3(Rt, Rn, size, Q)


/* LDAP1  { <Vt>.D }[<index>], [<Xn|SP>] (bffffc00/0d418400) */
//#define IEM_INSTR_IMPL_A64__LDAP1_asisdlso_D1(Rt, Rn, Q)


/* LD2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>] (bfffe000/0d600000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlso_B2_2b(Rt, Rn, size, S, Q)


/* LD4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>] (bfffe000/0d602000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlso_B4_4b(Rt, Rn, size, S, Q)


/* LD2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>] (bfffe400/0d604000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlso_H2_2h(Rt, Rn, size, S, Q)


/* LD4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>] (bfffe400/0d606000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlso_H4_4h(Rt, Rn, size, S, Q)


/* LD2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>] (bfffec00/0d608000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlso_S2_2s(Rt, Rn, S, Q)


/* LD2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>] (bffffc00/0d608400) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlso_D2_2d(Rt, Rn, Q)


/* LD4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>] (bfffec00/0d60a000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlso_S4_4s(Rt, Rn, S, Q)


/* LD4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>] (bffffc00/0d60a400) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlso_D4_4d(Rt, Rn, Q)


/* LD2R  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>] (bffff000/0d60c000) */
//#define IEM_INSTR_IMPL_A64__LD2R_asisdlso_R2(Rt, Rn, size, Q)


/* LD4R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>] (bffff000/0d60e000) */
//#define IEM_INSTR_IMPL_A64__LD4R_asisdlso_R4(Rt, Rn, size, Q)



/*
 *
 * Instruction Set & Groups: asisdlsop / ldst / A64
 *
 */

/* ST1  { <Vt>.B }[<index>], [<Xn|SP>], <Xm> (bfe0e000/0d800000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsop_BX1_r1b(Rt, Rn, size, S, Rm, Q)


/* ST3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>], <Xm> (bfe0e000/0d802000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsop_BX3_r3b(Rt, Rn, size, S, Rm, Q)


/* ST1  { <Vt>.H }[<index>], [<Xn|SP>], <Xm> (bfe0e400/0d804000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsop_HX1_r1h(Rt, Rn, size, S, Rm, Q)


/* ST3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>], <Xm> (bfe0e400/0d806000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsop_HX3_r3h(Rt, Rn, size, S, Rm, Q)


/* ST1  { <Vt>.S }[<index>], [<Xn|SP>], <Xm> (bfe0ec00/0d808000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsop_SX1_r1s(Rt, Rn, S, Rm, Q)


/* ST1  { <Vt>.D }[<index>], [<Xn|SP>], <Xm> (bfe0fc00/0d808400) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsop_DX1_r1d(Rt, Rn, Rm, Q)


/* ST3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>], <Xm> (bfe0ec00/0d80a000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsop_SX3_r3s(Rt, Rn, S, Rm, Q)


/* ST3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>], <Xm> (bfe0fc00/0d80a400) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsop_DX3_r3d(Rt, Rn, Rm, Q)


/* ST1  { <Vt>.B }[<index>], [<Xn|SP>], #1 (bfffe000/0d9f0000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsop_B1_i1b(Rt, Rn, size, S, Q)


/* ST3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>], #3 (bfffe000/0d9f2000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsop_B3_i3b(Rt, Rn, size, S, Q)


/* ST1  { <Vt>.H }[<index>], [<Xn|SP>], #2 (bfffe400/0d9f4000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsop_H1_i1h(Rt, Rn, size, S, Q)


/* ST3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>], #6 (bfffe400/0d9f6000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsop_H3_i3h(Rt, Rn, size, S, Q)


/* ST1  { <Vt>.S }[<index>], [<Xn|SP>], #4 (bfffec00/0d9f8000) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsop_S1_i1s(Rt, Rn, S, Q)


/* ST1  { <Vt>.D }[<index>], [<Xn|SP>], #8 (bffffc00/0d9f8400) */
//#define IEM_INSTR_IMPL_A64__ST1_asisdlsop_D1_i1d(Rt, Rn, Q)


/* ST3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>], #12 (bfffec00/0d9fa000) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsop_S3_i3s(Rt, Rn, S, Q)


/* ST3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>], #24 (bffffc00/0d9fa400) */
//#define IEM_INSTR_IMPL_A64__ST3_asisdlsop_D3_i3d(Rt, Rn, Q)


/* ST2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>], <Xm> (bfe0e000/0da00000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsop_BX2_r2b(Rt, Rn, size, S, Rm, Q)


/* ST4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>], <Xm> (bfe0e000/0da02000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsop_BX4_r4b(Rt, Rn, size, S, Rm, Q)


/* ST2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>], <Xm> (bfe0e400/0da04000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsop_HX2_r2h(Rt, Rn, size, S, Rm, Q)


/* ST4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>], <Xm> (bfe0e400/0da06000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsop_HX4_r4h(Rt, Rn, size, S, Rm, Q)


/* ST2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>], <Xm> (bfe0ec00/0da08000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsop_SX2_r2s(Rt, Rn, S, Rm, Q)


/* ST2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>], <Xm> (bfe0fc00/0da08400) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsop_DX2_r2d(Rt, Rn, Rm, Q)


/* ST4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>], <Xm> (bfe0ec00/0da0a000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsop_SX4_r4s(Rt, Rn, S, Rm, Q)


/* ST4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>], <Xm> (bfe0fc00/0da0a400) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsop_DX4_r4d(Rt, Rn, Rm, Q)


/* ST2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>], #2 (bfffe000/0dbf0000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsop_B2_i2b(Rt, Rn, size, S, Q)


/* ST4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>], #4 (bfffe000/0dbf2000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsop_B4_i4b(Rt, Rn, size, S, Q)


/* ST2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>], #4 (bfffe400/0dbf4000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsop_H2_i2h(Rt, Rn, size, S, Q)


/* ST4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>], #8 (bfffe400/0dbf6000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsop_H4_i4h(Rt, Rn, size, S, Q)


/* ST2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>], #8 (bfffec00/0dbf8000) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsop_S2_i2s(Rt, Rn, S, Q)


/* ST2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>], #16 (bffffc00/0dbf8400) */
//#define IEM_INSTR_IMPL_A64__ST2_asisdlsop_D2_i2d(Rt, Rn, Q)


/* ST4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>], #16 (bfffec00/0dbfa000) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsop_S4_i4s(Rt, Rn, S, Q)


/* ST4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>], #32 (bffffc00/0dbfa400) */
//#define IEM_INSTR_IMPL_A64__ST4_asisdlsop_D4_i4d(Rt, Rn, Q)


/* LD1  { <Vt>.B }[<index>], [<Xn|SP>], <Xm> (bfe0e000/0dc00000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsop_BX1_r1b(Rt, Rn, size, S, Rm, Q)


/* LD3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>], <Xm> (bfe0e000/0dc02000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsop_BX3_r3b(Rt, Rn, size, S, Rm, Q)


/* LD1  { <Vt>.H }[<index>], [<Xn|SP>], <Xm> (bfe0e400/0dc04000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsop_HX1_r1h(Rt, Rn, size, S, Rm, Q)


/* LD3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>], <Xm> (bfe0e400/0dc06000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsop_HX3_r3h(Rt, Rn, size, S, Rm, Q)


/* LD1  { <Vt>.S }[<index>], [<Xn|SP>], <Xm> (bfe0ec00/0dc08000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsop_SX1_r1s(Rt, Rn, S, Rm, Q)


/* LD1  { <Vt>.D }[<index>], [<Xn|SP>], <Xm> (bfe0fc00/0dc08400) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsop_DX1_r1d(Rt, Rn, Rm, Q)


/* LD3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>], <Xm> (bfe0ec00/0dc0a000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsop_SX3_r3s(Rt, Rn, S, Rm, Q)


/* LD3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>], <Xm> (bfe0fc00/0dc0a400) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsop_DX3_r3d(Rt, Rn, Rm, Q)


/* LD1R  { <Vt>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0dc0c000) */
//#define IEM_INSTR_IMPL_A64__LD1R_asisdlsop_RX1_r(Rt, Rn, size, Rm, Q)


/* LD3R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0dc0e000) */
//#define IEM_INSTR_IMPL_A64__LD3R_asisdlsop_RX3_r(Rt, Rn, size, Rm, Q)


/* LD1  { <Vt>.B }[<index>], [<Xn|SP>], #1 (bfffe000/0ddf0000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsop_B1_i1b(Rt, Rn, size, S, Q)


/* LD3  { <Vt>.B, <Vt2>.B, <Vt3>.B }[<index>], [<Xn|SP>], #3 (bfffe000/0ddf2000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsop_B3_i3b(Rt, Rn, size, S, Q)


/* LD1  { <Vt>.H }[<index>], [<Xn|SP>], #2 (bfffe400/0ddf4000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsop_H1_i1h(Rt, Rn, size, S, Q)


/* LD3  { <Vt>.H, <Vt2>.H, <Vt3>.H }[<index>], [<Xn|SP>], #6 (bfffe400/0ddf6000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsop_H3_i3h(Rt, Rn, size, S, Q)


/* LD1  { <Vt>.S }[<index>], [<Xn|SP>], #4 (bfffec00/0ddf8000) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsop_S1_i1s(Rt, Rn, S, Q)


/* LD1  { <Vt>.D }[<index>], [<Xn|SP>], #8 (bffffc00/0ddf8400) */
//#define IEM_INSTR_IMPL_A64__LD1_asisdlsop_D1_i1d(Rt, Rn, Q)


/* LD3  { <Vt>.S, <Vt2>.S, <Vt3>.S }[<index>], [<Xn|SP>], #12 (bfffec00/0ddfa000) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsop_S3_i3s(Rt, Rn, S, Q)


/* LD3  { <Vt>.D, <Vt2>.D, <Vt3>.D }[<index>], [<Xn|SP>], #24 (bffffc00/0ddfa400) */
//#define IEM_INSTR_IMPL_A64__LD3_asisdlsop_D3_i3d(Rt, Rn, Q)


/* LD1R  { <Vt>.<T> }, [<Xn|SP>], <imm> (bffff000/0ddfc000) */
//#define IEM_INSTR_IMPL_A64__LD1R_asisdlsop_R1_i(Rt, Rn, size, Q)


/* LD3R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm> (bffff000/0ddfe000) */
//#define IEM_INSTR_IMPL_A64__LD3R_asisdlsop_R3_i(Rt, Rn, size, Q)


/* LD2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>], <Xm> (bfe0e000/0de00000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsop_BX2_r2b(Rt, Rn, size, S, Rm, Q)


/* LD4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>], <Xm> (bfe0e000/0de02000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsop_BX4_r4b(Rt, Rn, size, S, Rm, Q)


/* LD2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>], <Xm> (bfe0e400/0de04000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsop_HX2_r2h(Rt, Rn, size, S, Rm, Q)


/* LD4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>], <Xm> (bfe0e400/0de06000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsop_HX4_r4h(Rt, Rn, size, S, Rm, Q)


/* LD2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>], <Xm> (bfe0ec00/0de08000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsop_SX2_r2s(Rt, Rn, S, Rm, Q)


/* LD2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>], <Xm> (bfe0fc00/0de08400) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsop_DX2_r2d(Rt, Rn, Rm, Q)


/* LD4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>], <Xm> (bfe0ec00/0de0a000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsop_SX4_r4s(Rt, Rn, S, Rm, Q)


/* LD4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>], <Xm> (bfe0fc00/0de0a400) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsop_DX4_r4d(Rt, Rn, Rm, Q)


/* LD2R  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0de0c000) */
//#define IEM_INSTR_IMPL_A64__LD2R_asisdlsop_RX2_r(Rt, Rn, size, Rm, Q)


/* LD4R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm> (bfe0f000/0de0e000) */
//#define IEM_INSTR_IMPL_A64__LD4R_asisdlsop_RX4_r(Rt, Rn, size, Rm, Q)


/* LD2  { <Vt>.B, <Vt2>.B }[<index>], [<Xn|SP>], #2 (bfffe000/0dff0000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsop_B2_i2b(Rt, Rn, size, S, Q)


/* LD4  { <Vt>.B, <Vt2>.B, <Vt3>.B, <Vt4>.B }[<index>], [<Xn|SP>], #4 (bfffe000/0dff2000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsop_B4_i4b(Rt, Rn, size, S, Q)


/* LD2  { <Vt>.H, <Vt2>.H }[<index>], [<Xn|SP>], #4 (bfffe400/0dff4000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsop_H2_i2h(Rt, Rn, size, S, Q)


/* LD4  { <Vt>.H, <Vt2>.H, <Vt3>.H, <Vt4>.H }[<index>], [<Xn|SP>], #8 (bfffe400/0dff6000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsop_H4_i4h(Rt, Rn, size, S, Q)


/* LD2  { <Vt>.S, <Vt2>.S }[<index>], [<Xn|SP>], #8 (bfffec00/0dff8000) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsop_S2_i2s(Rt, Rn, S, Q)


/* LD2  { <Vt>.D, <Vt2>.D }[<index>], [<Xn|SP>], #16 (bffffc00/0dff8400) */
//#define IEM_INSTR_IMPL_A64__LD2_asisdlsop_D2_i2d(Rt, Rn, Q)


/* LD4  { <Vt>.S, <Vt2>.S, <Vt3>.S, <Vt4>.S }[<index>], [<Xn|SP>], #16 (bfffec00/0dffa000) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsop_S4_i4s(Rt, Rn, S, Q)


/* LD4  { <Vt>.D, <Vt2>.D, <Vt3>.D, <Vt4>.D }[<index>], [<Xn|SP>], #32 (bffffc00/0dffa400) */
//#define IEM_INSTR_IMPL_A64__LD4_asisdlsop_D4_i4d(Rt, Rn, Q)


/* LD2R  { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm> (bffff000/0dffc000) */
//#define IEM_INSTR_IMPL_A64__LD2R_asisdlsop_R2_i(Rt, Rn, size, Q)


/* LD4R  { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm> (bffff000/0dffe000) */
//#define IEM_INSTR_IMPL_A64__LD4R_asisdlsop_R4_i(Rt, Rn, size, Q)



/*
 *
 * Instruction Set & Groups: asisdmisc / simd_dp / A64
 *
 */

/* SUQADD  <V><d>, <V><n> (ff3ffc00/5e203800) */
//#define IEM_INSTR_IMPL_A64__SUQADD_asisdmisc_R(Rd, Rn, size)


/* SQABS  <V><d>, <V><n> (ff3ffc00/5e207800) */
//#define IEM_INSTR_IMPL_A64__SQABS_asisdmisc_R(Rd, Rn, size)


/* CMGT  D<d>, D<n>, #0 (fffffc00/5ee08800) */
//#define IEM_INSTR_IMPL_A64__CMGT_asisdmisc_Z(Rd, Rn)


/* CMEQ  D<d>, D<n>, #0 (fffffc00/5ee09800) */
//#define IEM_INSTR_IMPL_A64__CMEQ_asisdmisc_Z(Rd, Rn)


/* CMLT  D<d>, D<n>, #0 (fffffc00/5ee0a800) */
//#define IEM_INSTR_IMPL_A64__CMLT_asisdmisc_Z(Rd, Rn)


/* ABS  D<d>, D<n> (fffffc00/5ee0b800) */
//#define IEM_INSTR_IMPL_A64__ABS_asisdmisc_R(Rd, Rn)


/* SQXTN  <Vb><d>, <Va><n> (ff3ffc00/5e214800) */
//#define IEM_INSTR_IMPL_A64__SQXTN_asisdmisc_N(Rd, Rn, size)


/* FCVTNS  <V><d>, <V><n> (ffbffc00/5e21a800) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_asisdmisc_R(Rd, Rn, sz)


/* FCVTMS  <V><d>, <V><n> (ffbffc00/5e21b800) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_asisdmisc_R(Rd, Rn, sz)


/* FCVTAS  <V><d>, <V><n> (ffbffc00/5e21c800) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_asisdmisc_R(Rd, Rn, sz)


/* SCVTF  <V><d>, <V><n> (ffbffc00/5e21d800) */
//#define IEM_INSTR_IMPL_A64__SCVTF_asisdmisc_R(Rd, Rn, sz)


/* FCMGT  <V><d>, <V><n>, #0.0 (ffbffc00/5ea0c800) */
//#define IEM_INSTR_IMPL_A64__FCMGT_asisdmisc_FZ(Rd, Rn, sz)


/* FCMEQ  <V><d>, <V><n>, #0.0 (ffbffc00/5ea0d800) */
//#define IEM_INSTR_IMPL_A64__FCMEQ_asisdmisc_FZ(Rd, Rn, sz)


/* FCMLT  <V><d>, <V><n>, #0.0 (ffbffc00/5ea0e800) */
//#define IEM_INSTR_IMPL_A64__FCMLT_asisdmisc_FZ(Rd, Rn, sz)


/* FCVTPS  <V><d>, <V><n> (ffbffc00/5ea1a800) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_asisdmisc_R(Rd, Rn, sz)


/* FCVTZS  <V><d>, <V><n> (ffbffc00/5ea1b800) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_asisdmisc_R(Rd, Rn, sz)


/* FRECPE  <V><d>, <V><n> (ffbffc00/5ea1d800) */
//#define IEM_INSTR_IMPL_A64__FRECPE_asisdmisc_R(Rd, Rn, sz)


/* FRECPX  <V><d>, <V><n> (ffbffc00/5ea1f800) */
//#define IEM_INSTR_IMPL_A64__FRECPX_asisdmisc_R(Rd, Rn, sz)


/* USQADD  <V><d>, <V><n> (ff3ffc00/7e203800) */
//#define IEM_INSTR_IMPL_A64__USQADD_asisdmisc_R(Rd, Rn, size)


/* SQNEG  <V><d>, <V><n> (ff3ffc00/7e207800) */
//#define IEM_INSTR_IMPL_A64__SQNEG_asisdmisc_R(Rd, Rn, size)


/* CMGE  D<d>, D<n>, #0 (fffffc00/7ee08800) */
//#define IEM_INSTR_IMPL_A64__CMGE_asisdmisc_Z(Rd, Rn)


/* CMLE  D<d>, D<n>, #0 (fffffc00/7ee09800) */
//#define IEM_INSTR_IMPL_A64__CMLE_asisdmisc_Z(Rd, Rn)


/* NEG  D<d>, D<n> (fffffc00/7ee0b800) */
//#define IEM_INSTR_IMPL_A64__NEG_asisdmisc_R(Rd, Rn)


/* SQXTUN  <Vb><d>, <Va><n> (ff3ffc00/7e212800) */
//#define IEM_INSTR_IMPL_A64__SQXTUN_asisdmisc_N(Rd, Rn, size)


/* UQXTN  <Vb><d>, <Va><n> (ff3ffc00/7e214800) */
//#define IEM_INSTR_IMPL_A64__UQXTN_asisdmisc_N(Rd, Rn, size)


/* FCVTXN  S<d>, D<n> (fffffc00/7e616800) */
//#define IEM_INSTR_IMPL_A64__FCVTXN_asisdmisc_N(Rd, Rn)


/* FCVTNU  <V><d>, <V><n> (ffbffc00/7e21a800) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_asisdmisc_R(Rd, Rn, sz)


/* FCVTMU  <V><d>, <V><n> (ffbffc00/7e21b800) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_asisdmisc_R(Rd, Rn, sz)


/* FCVTAU  <V><d>, <V><n> (ffbffc00/7e21c800) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_asisdmisc_R(Rd, Rn, sz)


/* UCVTF  <V><d>, <V><n> (ffbffc00/7e21d800) */
//#define IEM_INSTR_IMPL_A64__UCVTF_asisdmisc_R(Rd, Rn, sz)


/* FCMGE  <V><d>, <V><n>, #0.0 (ffbffc00/7ea0c800) */
//#define IEM_INSTR_IMPL_A64__FCMGE_asisdmisc_FZ(Rd, Rn, sz)


/* FCMLE  <V><d>, <V><n>, #0.0 (ffbffc00/7ea0d800) */
//#define IEM_INSTR_IMPL_A64__FCMLE_asisdmisc_FZ(Rd, Rn, sz)


/* FCVTPU  <V><d>, <V><n> (ffbffc00/7ea1a800) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_asisdmisc_R(Rd, Rn, sz)


/* FCVTZU  <V><d>, <V><n> (ffbffc00/7ea1b800) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_asisdmisc_R(Rd, Rn, sz)


/* FRSQRTE  <V><d>, <V><n> (ffbffc00/7ea1d800) */
//#define IEM_INSTR_IMPL_A64__FRSQRTE_asisdmisc_R(Rd, Rn, sz)



/*
 *
 * Instruction Set & Groups: asisdmiscfp16 / simd_dp / A64
 *
 */

/* FCVTNS  <Hd>, <Hn> (fffffc00/5e79a800) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_asisdmiscfp16_R(Rd, Rn)


/* FCVTMS  <Hd>, <Hn> (fffffc00/5e79b800) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_asisdmiscfp16_R(Rd, Rn)


/* FCVTAS  <Hd>, <Hn> (fffffc00/5e79c800) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_asisdmiscfp16_R(Rd, Rn)


/* SCVTF  <Hd>, <Hn> (fffffc00/5e79d800) */
//#define IEM_INSTR_IMPL_A64__SCVTF_asisdmiscfp16_R(Rd, Rn)


/* FCMGT  <Hd>, <Hn>, #0.0 (fffffc00/5ef8c800) */
//#define IEM_INSTR_IMPL_A64__FCMGT_asisdmiscfp16_FZ(Rd, Rn)


/* FCMEQ  <Hd>, <Hn>, #0.0 (fffffc00/5ef8d800) */
//#define IEM_INSTR_IMPL_A64__FCMEQ_asisdmiscfp16_FZ(Rd, Rn)


/* FCMLT  <Hd>, <Hn>, #0.0 (fffffc00/5ef8e800) */
//#define IEM_INSTR_IMPL_A64__FCMLT_asisdmiscfp16_FZ(Rd, Rn)


/* FCVTPS  <Hd>, <Hn> (fffffc00/5ef9a800) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_asisdmiscfp16_R(Rd, Rn)


/* FCVTZS  <Hd>, <Hn> (fffffc00/5ef9b800) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_asisdmiscfp16_R(Rd, Rn)


/* FRECPE  <Hd>, <Hn> (fffffc00/5ef9d800) */
//#define IEM_INSTR_IMPL_A64__FRECPE_asisdmiscfp16_R(Rd, Rn)


/* FRECPX  <Hd>, <Hn> (fffffc00/5ef9f800) */
//#define IEM_INSTR_IMPL_A64__FRECPX_asisdmiscfp16_R(Rd, Rn)


/* FCVTNU  <Hd>, <Hn> (fffffc00/7e79a800) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_asisdmiscfp16_R(Rd, Rn)


/* FCVTMU  <Hd>, <Hn> (fffffc00/7e79b800) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_asisdmiscfp16_R(Rd, Rn)


/* FCVTAU  <Hd>, <Hn> (fffffc00/7e79c800) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_asisdmiscfp16_R(Rd, Rn)


/* UCVTF  <Hd>, <Hn> (fffffc00/7e79d800) */
//#define IEM_INSTR_IMPL_A64__UCVTF_asisdmiscfp16_R(Rd, Rn)


/* FCMGE  <Hd>, <Hn>, #0.0 (fffffc00/7ef8c800) */
//#define IEM_INSTR_IMPL_A64__FCMGE_asisdmiscfp16_FZ(Rd, Rn)


/* FCMLE  <Hd>, <Hn>, #0.0 (fffffc00/7ef8d800) */
//#define IEM_INSTR_IMPL_A64__FCMLE_asisdmiscfp16_FZ(Rd, Rn)


/* FCVTPU  <Hd>, <Hn> (fffffc00/7ef9a800) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_asisdmiscfp16_R(Rd, Rn)


/* FCVTZU  <Hd>, <Hn> (fffffc00/7ef9b800) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_asisdmiscfp16_R(Rd, Rn)


/* FRSQRTE  <Hd>, <Hn> (fffffc00/7ef9d800) */
//#define IEM_INSTR_IMPL_A64__FRSQRTE_asisdmiscfp16_R(Rd, Rn)



/*
 *
 * Instruction Set & Groups: asisdone / simd_dp / A64
 *
 */

/* DUP  <V><d>, <Vn>.<T>[<index>] (ffe0fc00/5e000400) */
//#define IEM_INSTR_IMPL_A64__DUP_asisdone_only(Rd, Rn, imm5)



/*
 *
 * Instruction Set & Groups: asisdpair / simd_dp / A64
 *
 */

/* ADDP  D<d>, <Vn>.2D (fffffc00/5ef1b800) */
//#define IEM_INSTR_IMPL_A64__ADDP_asisdpair_only(Rd, Rn)


/* FMAXNMP  H<d>, <Vn>.2H (fffffc00/5e30c800) */
//#define IEM_INSTR_IMPL_A64__FMAXNMP_asisdpair_only_H(Rd, Rn)


/* FADDP  H<d>, <Vn>.2H (fffffc00/5e30d800) */
//#define IEM_INSTR_IMPL_A64__FADDP_asisdpair_only_H(Rd, Rn)


/* FMAXP  H<d>, <Vn>.2H (fffffc00/5e30f800) */
//#define IEM_INSTR_IMPL_A64__FMAXP_asisdpair_only_H(Rd, Rn)


/* FMINNMP  H<d>, <Vn>.2H (fffffc00/5eb0c800) */
//#define IEM_INSTR_IMPL_A64__FMINNMP_asisdpair_only_H(Rd, Rn)


/* FMINP  H<d>, <Vn>.2H (fffffc00/5eb0f800) */
//#define IEM_INSTR_IMPL_A64__FMINP_asisdpair_only_H(Rd, Rn)


/* FMAXNMP  <V><d>, <Vn>.<T> (ffbffc00/7e30c800) */
//#define IEM_INSTR_IMPL_A64__FMAXNMP_asisdpair_only_SD(Rd, Rn, sz)


/* FADDP  <V><d>, <Vn>.<T> (ffbffc00/7e30d800) */
//#define IEM_INSTR_IMPL_A64__FADDP_asisdpair_only_SD(Rd, Rn, sz)


/* FMAXP  <V><d>, <Vn>.<T> (ffbffc00/7e30f800) */
//#define IEM_INSTR_IMPL_A64__FMAXP_asisdpair_only_SD(Rd, Rn, sz)


/* FMINNMP  <V><d>, <Vn>.<T> (ffbffc00/7eb0c800) */
//#define IEM_INSTR_IMPL_A64__FMINNMP_asisdpair_only_SD(Rd, Rn, sz)


/* FMINP  <V><d>, <Vn>.<T> (ffbffc00/7eb0f800) */
//#define IEM_INSTR_IMPL_A64__FMINP_asisdpair_only_SD(Rd, Rn, sz)



/*
 *
 * Instruction Set & Groups: asisdsame / simd_dp / A64
 *
 */

/* SQADD  <V><d>, <V><n>, <V><m> (ff20fc00/5e200c00) */
//#define IEM_INSTR_IMPL_A64__SQADD_asisdsame_only(Rd, Rn, Rm, size)


/* SQSUB  <V><d>, <V><n>, <V><m> (ff20fc00/5e202c00) */
//#define IEM_INSTR_IMPL_A64__SQSUB_asisdsame_only(Rd, Rn, Rm, size)


/* CMGT  D<d>, D<n>, D<m> (ffe0fc00/5ee03400) */
//#define IEM_INSTR_IMPL_A64__CMGT_asisdsame_only(Rd, Rn, Rm)


/* CMGE  D<d>, D<n>, D<m> (ffe0fc00/5ee03c00) */
//#define IEM_INSTR_IMPL_A64__CMGE_asisdsame_only(Rd, Rn, Rm)


/* SSHL  D<d>, D<n>, D<m> (ffe0fc00/5ee04400) */
//#define IEM_INSTR_IMPL_A64__SSHL_asisdsame_only(Rd, Rn, Rm)


/* SQSHL  <V><d>, <V><n>, <V><m> (ff20fc00/5e204c00) */
//#define IEM_INSTR_IMPL_A64__SQSHL_asisdsame_only(Rd, Rn, Rm, size)


/* SRSHL  D<d>, D<n>, D<m> (ffe0fc00/5ee05400) */
//#define IEM_INSTR_IMPL_A64__SRSHL_asisdsame_only(Rd, Rn, Rm)


/* SQRSHL  <V><d>, <V><n>, <V><m> (ff20fc00/5e205c00) */
//#define IEM_INSTR_IMPL_A64__SQRSHL_asisdsame_only(Rd, Rn, Rm, size)


/* ADD  D<d>, D<n>, D<m> (ffe0fc00/5ee08400) */
//#define IEM_INSTR_IMPL_A64__ADD_asisdsame_only(Rd, Rn, Rm)


/* CMTST  D<d>, D<n>, D<m> (ffe0fc00/5ee08c00) */
//#define IEM_INSTR_IMPL_A64__CMTST_asisdsame_only(Rd, Rn, Rm)


/* SQDMULH  <V><d>, <V><n>, <V><m> (ff20fc00/5e20b400) */
//#define IEM_INSTR_IMPL_A64__SQDMULH_asisdsame_only(Rd, Rn, Rm, size)


/* FMULX  <V><d>, <V><n>, <V><m> (ffa0fc00/5e20dc00) */
//#define IEM_INSTR_IMPL_A64__FMULX_asisdsame_only(Rd, Rn, Rm, sz)


/* FCMEQ  <V><d>, <V><n>, <V><m> (ffa0fc00/5e20e400) */
//#define IEM_INSTR_IMPL_A64__FCMEQ_asisdsame_only(Rd, Rn, Rm, sz)


/* FRECPS  <V><d>, <V><n>, <V><m> (ffa0fc00/5e20fc00) */
//#define IEM_INSTR_IMPL_A64__FRECPS_asisdsame_only(Rd, Rn, Rm, sz)


/* FRSQRTS  <V><d>, <V><n>, <V><m> (ffa0fc00/5ea0fc00) */
//#define IEM_INSTR_IMPL_A64__FRSQRTS_asisdsame_only(Rd, Rn, Rm, sz)


/* UQADD  <V><d>, <V><n>, <V><m> (ff20fc00/7e200c00) */
//#define IEM_INSTR_IMPL_A64__UQADD_asisdsame_only(Rd, Rn, Rm, size)


/* UQSUB  <V><d>, <V><n>, <V><m> (ff20fc00/7e202c00) */
//#define IEM_INSTR_IMPL_A64__UQSUB_asisdsame_only(Rd, Rn, Rm, size)


/* CMHI  D<d>, D<n>, D<m> (ffe0fc00/7ee03400) */
//#define IEM_INSTR_IMPL_A64__CMHI_asisdsame_only(Rd, Rn, Rm)


/* CMHS  D<d>, D<n>, D<m> (ffe0fc00/7ee03c00) */
//#define IEM_INSTR_IMPL_A64__CMHS_asisdsame_only(Rd, Rn, Rm)


/* USHL  D<d>, D<n>, D<m> (ffe0fc00/7ee04400) */
//#define IEM_INSTR_IMPL_A64__USHL_asisdsame_only(Rd, Rn, Rm)


/* UQSHL  <V><d>, <V><n>, <V><m> (ff20fc00/7e204c00) */
//#define IEM_INSTR_IMPL_A64__UQSHL_asisdsame_only(Rd, Rn, Rm, size)


/* URSHL  D<d>, D<n>, D<m> (ffe0fc00/7ee05400) */
//#define IEM_INSTR_IMPL_A64__URSHL_asisdsame_only(Rd, Rn, Rm)


/* UQRSHL  <V><d>, <V><n>, <V><m> (ff20fc00/7e205c00) */
//#define IEM_INSTR_IMPL_A64__UQRSHL_asisdsame_only(Rd, Rn, Rm, size)


/* SUB  D<d>, D<n>, D<m> (ffe0fc00/7ee08400) */
//#define IEM_INSTR_IMPL_A64__SUB_asisdsame_only(Rd, Rn, Rm)


/* CMEQ  D<d>, D<n>, D<m> (ffe0fc00/7ee08c00) */
//#define IEM_INSTR_IMPL_A64__CMEQ_asisdsame_only(Rd, Rn, Rm)


/* SQRDMULH  <V><d>, <V><n>, <V><m> (ff20fc00/7e20b400) */
//#define IEM_INSTR_IMPL_A64__SQRDMULH_asisdsame_only(Rd, Rn, Rm, size)


/* FCMGE  <V><d>, <V><n>, <V><m> (ffa0fc00/7e20e400) */
//#define IEM_INSTR_IMPL_A64__FCMGE_asisdsame_only(Rd, Rn, Rm, sz)


/* FACGE  <V><d>, <V><n>, <V><m> (ffa0fc00/7e20ec00) */
//#define IEM_INSTR_IMPL_A64__FACGE_asisdsame_only(Rd, Rn, Rm, sz)


/* FABD  <V><d>, <V><n>, <V><m> (ffa0fc00/7ea0d400) */
//#define IEM_INSTR_IMPL_A64__FABD_asisdsame_only(Rd, Rn, Rm, sz)


/* FCMGT  <V><d>, <V><n>, <V><m> (ffa0fc00/7ea0e400) */
//#define IEM_INSTR_IMPL_A64__FCMGT_asisdsame_only(Rd, Rn, Rm, sz)


/* FACGT  <V><d>, <V><n>, <V><m> (ffa0fc00/7ea0ec00) */
//#define IEM_INSTR_IMPL_A64__FACGT_asisdsame_only(Rd, Rn, Rm, sz)



/*
 *
 * Instruction Set & Groups: asisdsame2 / simd_dp / A64
 *
 */

/* SQRDMLAH  <V><d>, <V><n>, <V><m> (ff20fc00/7e008400) */
//#define IEM_INSTR_IMPL_A64__SQRDMLAH_asisdsame2_only(Rd, Rn, Rm, size)


/* SQRDMLSH  <V><d>, <V><n>, <V><m> (ff20fc00/7e008c00) */
//#define IEM_INSTR_IMPL_A64__SQRDMLSH_asisdsame2_only(Rd, Rn, Rm, size)



/*
 *
 * Instruction Set & Groups: asisdsamefp16 / simd_dp / A64
 *
 */

/* FMULX  <Hd>, <Hn>, <Hm> (ffe0fc00/5e401c00) */
//#define IEM_INSTR_IMPL_A64__FMULX_asisdsamefp16_only(Rd, Rn, Rm)


/* FCMEQ  <Hd>, <Hn>, <Hm> (ffe0fc00/5e402400) */
//#define IEM_INSTR_IMPL_A64__FCMEQ_asisdsamefp16_only(Rd, Rn, Rm)


/* FRECPS  <Hd>, <Hn>, <Hm> (ffe0fc00/5e403c00) */
//#define IEM_INSTR_IMPL_A64__FRECPS_asisdsamefp16_only(Rd, Rn, Rm)


/* FRSQRTS  <Hd>, <Hn>, <Hm> (ffe0fc00/5ec03c00) */
//#define IEM_INSTR_IMPL_A64__FRSQRTS_asisdsamefp16_only(Rd, Rn, Rm)


/* FCMGE  <Hd>, <Hn>, <Hm> (ffe0fc00/7e402400) */
//#define IEM_INSTR_IMPL_A64__FCMGE_asisdsamefp16_only(Rd, Rn, Rm)


/* FACGE  <Hd>, <Hn>, <Hm> (ffe0fc00/7e402c00) */
//#define IEM_INSTR_IMPL_A64__FACGE_asisdsamefp16_only(Rd, Rn, Rm)


/* FABD  <Hd>, <Hn>, <Hm> (ffe0fc00/7ec01400) */
//#define IEM_INSTR_IMPL_A64__FABD_asisdsamefp16_only(Rd, Rn, Rm)


/* FCMGT  <Hd>, <Hn>, <Hm> (ffe0fc00/7ec02400) */
//#define IEM_INSTR_IMPL_A64__FCMGT_asisdsamefp16_only(Rd, Rn, Rm)


/* FACGT  <Hd>, <Hn>, <Hm> (ffe0fc00/7ec02c00) */
//#define IEM_INSTR_IMPL_A64__FACGT_asisdsamefp16_only(Rd, Rn, Rm)



/*
 *
 * Instruction Set & Groups: asisdshf / simd_dp / A64
 *
 */

/* SSHR  D<d>, D<n>, #<shift> (ff80fc00/5f000400) */
//#define IEM_INSTR_IMPL_A64__SSHR_asisdshf_R(Rd, Rn, immb, immh)


/* SSRA  D<d>, D<n>, #<shift> (ff80fc00/5f001400) */
//#define IEM_INSTR_IMPL_A64__SSRA_asisdshf_R(Rd, Rn, immb, immh)


/* SRSHR  D<d>, D<n>, #<shift> (ff80fc00/5f002400) */
//#define IEM_INSTR_IMPL_A64__SRSHR_asisdshf_R(Rd, Rn, immb, immh)


/* SRSRA  D<d>, D<n>, #<shift> (ff80fc00/5f003400) */
//#define IEM_INSTR_IMPL_A64__SRSRA_asisdshf_R(Rd, Rn, immb, immh)


/* SHL  D<d>, D<n>, #<shift> (ff80fc00/5f005400) */
//#define IEM_INSTR_IMPL_A64__SHL_asisdshf_R(Rd, Rn, immb, immh)


/* SQSHL  <V><d>, <V><n>, #<shift> (ff80fc00/5f007400) */
//#define IEM_INSTR_IMPL_A64__SQSHL_asisdshf_R(Rd, Rn, immb, immh)


/* SQSHRN  <Vb><d>, <Va><n>, #<shift> (ff80fc00/5f009400) */
//#define IEM_INSTR_IMPL_A64__SQSHRN_asisdshf_N(Rd, Rn, immb, immh)


/* SQRSHRN  <Vb><d>, <Va><n>, #<shift> (ff80fc00/5f009c00) */
//#define IEM_INSTR_IMPL_A64__SQRSHRN_asisdshf_N(Rd, Rn, immb, immh)


/* SCVTF  <V><d>, <V><n>, #<fbits> (ff80fc00/5f00e400) */
//#define IEM_INSTR_IMPL_A64__SCVTF_asisdshf_C(Rd, Rn, immb, immh)


/* FCVTZS  <V><d>, <V><n>, #<fbits> (ff80fc00/5f00fc00) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_asisdshf_C(Rd, Rn, immb, immh)


/* USHR  D<d>, D<n>, #<shift> (ff80fc00/7f000400) */
//#define IEM_INSTR_IMPL_A64__USHR_asisdshf_R(Rd, Rn, immb, immh)


/* USRA  D<d>, D<n>, #<shift> (ff80fc00/7f001400) */
//#define IEM_INSTR_IMPL_A64__USRA_asisdshf_R(Rd, Rn, immb, immh)


/* URSHR  D<d>, D<n>, #<shift> (ff80fc00/7f002400) */
//#define IEM_INSTR_IMPL_A64__URSHR_asisdshf_R(Rd, Rn, immb, immh)


/* URSRA  D<d>, D<n>, #<shift> (ff80fc00/7f003400) */
//#define IEM_INSTR_IMPL_A64__URSRA_asisdshf_R(Rd, Rn, immb, immh)


/* SRI  D<d>, D<n>, #<shift> (ff80fc00/7f004400) */
//#define IEM_INSTR_IMPL_A64__SRI_asisdshf_R(Rd, Rn, immb, immh)


/* SLI  D<d>, D<n>, #<shift> (ff80fc00/7f005400) */
//#define IEM_INSTR_IMPL_A64__SLI_asisdshf_R(Rd, Rn, immb, immh)


/* SQSHLU  <V><d>, <V><n>, #<shift> (ff80fc00/7f006400) */
//#define IEM_INSTR_IMPL_A64__SQSHLU_asisdshf_R(Rd, Rn, immb, immh)


/* UQSHL  <V><d>, <V><n>, #<shift> (ff80fc00/7f007400) */
//#define IEM_INSTR_IMPL_A64__UQSHL_asisdshf_R(Rd, Rn, immb, immh)


/* SQSHRUN  <Vb><d>, <Va><n>, #<shift> (ff80fc00/7f008400) */
//#define IEM_INSTR_IMPL_A64__SQSHRUN_asisdshf_N(Rd, Rn, immb, immh)


/* SQRSHRUN  <Vb><d>, <Va><n>, #<shift> (ff80fc00/7f008c00) */
//#define IEM_INSTR_IMPL_A64__SQRSHRUN_asisdshf_N(Rd, Rn, immb, immh)


/* UQSHRN  <Vb><d>, <Va><n>, #<shift> (ff80fc00/7f009400) */
//#define IEM_INSTR_IMPL_A64__UQSHRN_asisdshf_N(Rd, Rn, immb, immh)


/* UQRSHRN  <Vb><d>, <Va><n>, #<shift> (ff80fc00/7f009c00) */
//#define IEM_INSTR_IMPL_A64__UQRSHRN_asisdshf_N(Rd, Rn, immb, immh)


/* UCVTF  <V><d>, <V><n>, #<fbits> (ff80fc00/7f00e400) */
//#define IEM_INSTR_IMPL_A64__UCVTF_asisdshf_C(Rd, Rn, immb, immh)


/* FCVTZU  <V><d>, <V><n>, #<fbits> (ff80fc00/7f00fc00) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_asisdshf_C(Rd, Rn, immb, immh)



/*
 *
 * Instruction Set & Groups: barriers / control / A64
 *
 */

/* CLREX{  #<imm>} (fffff0ff/d503305f) */
//#define IEM_INSTR_IMPL_A64__CLREX_BN_barriers(CRm)


/* DSB  {<option> | #<imm>} (fffff0ff/d503309f) */
#define IEM_INSTR_IMPL_A64__DSB_BO_barriers(CRm) \
    /* Simplification: effective domain = outer sharable. */ \
    switch (CRm & 3) \
    { \
        case 1: /* reads */ \
            IEM_MC_BEGIN(0, 0); \
            IEM_MC_A64_DSB_READS(); \
            IEM_MC_ADVANCE_PC_AND_FINISH(); \
            IEM_MC_END(); \
            break; \
        case 2: /* writes */ \
            IEM_MC_BEGIN(0, 0); \
            IEM_MC_A64_DSB_WRITES(); \
            IEM_MC_ADVANCE_PC_AND_FINISH(); \
            IEM_MC_END(); \
            break; \
        default: /* all */ \
            IEM_MC_BEGIN(0, 0); \
            IEM_MC_A64_DSB_ALL(); \
            IEM_MC_ADVANCE_PC_AND_FINISH(); \
            IEM_MC_END(); \
            break; \
    } ((void)0)

/* DMB  {<option> | #<imm>} (fffff0ff/d50330bf) */
#define IEM_INSTR_IMPL_A64__DMB_BO_barriers(CRm) \
    /* Simplification: effective domain = outer sharable. */ \
    switch (CRm & 3) \
    { \
        case 1: /* reads */ \
            IEM_MC_BEGIN(0, 0); \
            IEM_MC_A64_DMB_READS(); \
            IEM_MC_ADVANCE_PC_AND_FINISH(); \
            IEM_MC_END(); \
            break; \
        case 2: /* writes */ \
            IEM_MC_BEGIN(0, 0); \
            IEM_MC_A64_DMB_WRITES(); \
            IEM_MC_ADVANCE_PC_AND_FINISH(); \
            IEM_MC_END(); \
            break; \
        default: /* all */ \
            IEM_MC_BEGIN(0, 0); \
            IEM_MC_A64_DMB_ALL(); \
            IEM_MC_ADVANCE_PC_AND_FINISH(); \
            IEM_MC_END(); \
            break; \
    } ((void)0)


/* ISB{  <option> |   #<imm>} (fffff0ff/d50330df) */
#define IEM_INSTR_IMPL_A64__ISB_BI_barriers(CRm) \
    RT_NOREF(CRm); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_A64_ISB(); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* SB (ffffffff/d50330ff) */
//#define IEM_INSTR_IMPL_A64__SB_only_barriers()


/* DSB  <option>nXS (fffff3ff/d503323f) */
//#define IEM_INSTR_IMPL_A64__DSB_BOn_barriers(imm2)


/* TCOMMIT (ffffffff/d503307f) */
//#define IEM_INSTR_IMPL_A64__TCOMMIT_only_barriers()



/*
 *
 * Instruction Set & Groups: bitfield / dpimm / A64
 *
 */

/* SBFM  <Wd>, <Wn>, #<immr>, #<imms> (ffc00000/13000000) */
//#define IEM_INSTR_IMPL_A64__SBFM_32M_bitfield(Rd, Rn, imms, immr)


/* BFM  <Wd>, <Wn>, #<immr>, #<imms> (ffc00000/33000000) */
//#define IEM_INSTR_IMPL_A64__BFM_32M_bitfield(Rd, Rn, imms, immr)


/* UBFM  <Wd>, <Wn>, #<immr>, #<imms> (ffc00000/53000000) */
//#define IEM_INSTR_IMPL_A64__UBFM_32M_bitfield(Rd, Rn, imms, immr)


/* SBFM  <Xd>, <Xn>, #<immr>, #<imms> (ffc00000/93400000) */
//#define IEM_INSTR_IMPL_A64__SBFM_64M_bitfield(Rd, Rn, imms, immr)


/* BFM  <Xd>, <Xn>, #<immr>, #<imms> (ffc00000/b3400000) */
//#define IEM_INSTR_IMPL_A64__BFM_64M_bitfield(Rd, Rn, imms, immr)


/* UBFM  <Xd>, <Xn>, #<immr>, #<imms> (ffc00000/d3400000) */
//#define IEM_INSTR_IMPL_A64__UBFM_64M_bitfield(Rd, Rn, imms, immr)



/*
 *
 * Instruction Set & Groups: branch_imm / control / A64
 *
 */

/* B  <label> (fc000000/14000000) */
#define IEM_INSTR_IMPL_A64__B_only_branch_imm(imm26) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_DIRECT); \
    IEM_MC_REL_JMP_S32_AND_FINISH((int32_t)((uint32_t)(imm26) << 6) >> 4); \
    IEM_MC_END()


/* BL  <label> (fc000000/94000000) */
#define IEM_INSTR_IMPL_A64__BL_only_branch_imm(imm26) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_DIRECT); \
    IEM_MC_REL_CALL_S32_AND_FINISH((int32_t)((uint32_t)(imm26) << 6) >> 4); \
    IEM_MC_END()



/*
 *
 * Instruction Set & Groups: branch_reg / control / A64
 *
 */

/* BR  <Xn> (fffffc1f/d61f0000) */
//#define IEM_INSTR_IMPL_A64__BR_64_branch_reg(Rn)


/* BRAAZ  <Xn> (fffffc1f/d61f081f) */
//#define IEM_INSTR_IMPL_A64__BRAAZ_64_branch_reg(Rn)


/* BRABZ  <Xn> (fffffc1f/d61f0c1f) */
//#define IEM_INSTR_IMPL_A64__BRABZ_64_branch_reg(Rn)


/* BLR  <Xn> (fffffc1f/d63f0000) */
#define IEM_INSTR_IMPL_A64__BLR_64_branch_reg(Rn) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_INDIRECT); \
    IEM_MC_LOCAL(uint64_t, uCallAddr); /* In case Rn == LR, get target first. */ \
    IEM_MC_FETCH_GREG_U64(uCallAddr, Rn); \
    IEM_MC_LOCAL(uint64_t, uRetAddr); /* LR = PC + 4 */ \
    IEM_MC_FETCH_PC_U64(uRetAddr); \
    IEM_MC_ADD_LOCAL_U64(uRetAddr, 4); \
    IEM_MC_STORE_GREG_U64(30, uRetAddr); \
    IEM_MC_BRANCH_TO_WITH_BTYPE_AND_FINISH(uCallAddr, 2 /*BType*/); \
    IEM_MC_END()


/* BLRAAZ  <Xn> (fffffc1f/d63f081f) */
//#define IEM_INSTR_IMPL_A64__BLRAAZ_64_branch_reg(Rn)


/* BLRABZ  <Xn> (fffffc1f/d63f0c1f) */
//#define IEM_INSTR_IMPL_A64__BLRABZ_64_branch_reg(Rn)


/* RET{  <Xn>} (fffffc1f/d65f0000) */
#define IEM_INSTR_IMPL_A64__RET_64R_branch_reg(Rn) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_INDIRECT); \
    IEM_MC_LOCAL(uint64_t, uRetAddr); \
    IEM_MC_FETCH_GREG_U64(uRetAddr, Rn); \
    IEM_MC_BRANCH_TO_WITH_BTYPE_AND_FINISH(uRetAddr, 0 /*BType*/); \
    IEM_MC_END()


/* RETAASPPCR  <Xm> (ffffffe0/d65f0be0) */
//#define IEM_INSTR_IMPL_A64__RETAASPPCR_64M_branch_reg(Rm)


/* RETAA (ffffffff/d65f0bff) */
//#define IEM_INSTR_IMPL_A64__RETAA_64E_branch_reg()


/* RETABSPPCR  <Xm> (ffffffe0/d65f0fe0) */
//#define IEM_INSTR_IMPL_A64__RETABSPPCR_64M_branch_reg(Rm)


/* RETAB (ffffffff/d65f0fff) */
//#define IEM_INSTR_IMPL_A64__RETAB_64E_branch_reg()


/* ERET (ffffffff/d69f03e0) */
//#define IEM_INSTR_IMPL_A64__ERET_64E_branch_reg()


/* ERETAA (ffffffff/d69f0bff) */
//#define IEM_INSTR_IMPL_A64__ERETAA_64E_branch_reg()


/* ERETAB (ffffffff/d69f0fff) */
//#define IEM_INSTR_IMPL_A64__ERETAB_64E_branch_reg()


/* DRPS (ffffffff/d6bf03e0) */
//#define IEM_INSTR_IMPL_A64__DRPS_64E_branch_reg()


/* BRAA  <Xn>, <Xm|SP> (fffffc00/d71f0800) */
//#define IEM_INSTR_IMPL_A64__BRAA_64P_branch_reg(Rm, Rn)


/* BRAB  <Xn>, <Xm|SP> (fffffc00/d71f0c00) */
//#define IEM_INSTR_IMPL_A64__BRAB_64P_branch_reg(Rm, Rn)


/* BLRAA  <Xn>, <Xm|SP> (fffffc00/d73f0800) */
//#define IEM_INSTR_IMPL_A64__BLRAA_64P_branch_reg(Rm, Rn)


/* BLRAB  <Xn>, <Xm|SP> (fffffc00/d73f0c00) */
//#define IEM_INSTR_IMPL_A64__BLRAB_64P_branch_reg(Rm, Rn)



/*
 *
 * Instruction Set & Groups: compbranch / control / A64
 *
 */

/* CBZ  <Wt>, <label> (ff000000/34000000) */
#define IEM_INSTR_IMPL_A64__CBZ_32_compbranch(Rt, imm19) \
    int32_t const offRel = (int32_t)(imm19 << (32 - 19)) >> (32 - 19 - 2); \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_U32(uTmp, Rt); \
    IEM_MC_IF_LOCAL_IS_Z(uTmp) { \
        IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
    } IEM_MC_ELSE() { \
        IEM_MC_ADVANCE_PC_AND_FINISH(); \
    } IEM_MC_ENDIF(); \
    IEM_MC_END()

/* CBNZ  <Wt>, <label> (ff000000/35000000) */
#define IEM_INSTR_IMPL_A64__CBNZ_32_compbranch(Rt, imm19) \
    int32_t const offRel = (int32_t)(imm19 << (32 - 19)) >> (32 - 19 - 2); \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_U32(uTmp, Rt); \
    IEM_MC_IF_LOCAL_IS_Z(uTmp) { \
        IEM_MC_ADVANCE_PC_AND_FINISH(); \
    } IEM_MC_ELSE() { \
        IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
    } IEM_MC_ENDIF(); \
    IEM_MC_END()


/* CBZ  <Xt>, <label> (ff000000/b4000000) */
#define IEM_INSTR_IMPL_A64__CBZ_64_compbranch(Rt, imm19) \
    int32_t const offRel = (int32_t)(imm19 << (32 - 19)) >> (32 - 19 - 2); \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_U64(uTmp, Rt); \
    IEM_MC_IF_LOCAL_IS_Z(uTmp) { \
        IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
    } IEM_MC_ELSE() { \
        IEM_MC_ADVANCE_PC_AND_FINISH(); \
    } IEM_MC_ENDIF(); \
    IEM_MC_END()


/* CBNZ  <Xt>, <label> (ff000000/b5000000) */
#define IEM_INSTR_IMPL_A64__CBNZ_64_compbranch(Rt, imm19) \
    int32_t const offRel = (int32_t)(imm19 << (32 - 19)) >> (32 - 19 - 2); \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_U64(uTmp, Rt); \
    IEM_MC_IF_LOCAL_IS_Z(uTmp) { \
        IEM_MC_ADVANCE_PC_AND_FINISH(); \
    } IEM_MC_ELSE() { \
        IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
    } IEM_MC_ENDIF(); \
    IEM_MC_END()



/*
 *
 * Instruction Set & Groups: compbranch_imm / control / A64
 *
 */

/* CBGT  <Wt>, #<imm>, <label> (ffe04000/75000000) */
//#define IEM_INSTR_IMPL_A64__CBGT_32_imm(Rt, imm9, imm6)


/* CBLT  <Wt>, #<imm>, <label> (ffe04000/75200000) */
//#define IEM_INSTR_IMPL_A64__CBLT_32_imm(Rt, imm9, imm6)


/* CBHI  <Wt>, #<imm>, <label> (ffe04000/75400000) */
//#define IEM_INSTR_IMPL_A64__CBHI_32_imm(Rt, imm9, imm6)


/* CBLO  <Wt>, #<imm>, <label> (ffe04000/75600000) */
//#define IEM_INSTR_IMPL_A64__CBLO_32_imm(Rt, imm9, imm6)


/* CBEQ  <Wt>, #<imm>, <label> (ffe04000/75c00000) */
//#define IEM_INSTR_IMPL_A64__CBEQ_32_imm(Rt, imm9, imm6)


/* CBNE  <Wt>, #<imm>, <label> (ffe04000/75e00000) */
//#define IEM_INSTR_IMPL_A64__CBNE_32_imm(Rt, imm9, imm6)


/* CBGT  <Xt>, #<imm>, <label> (ffe04000/f5000000) */
//#define IEM_INSTR_IMPL_A64__CBGT_64_imm(Rt, imm9, imm6)


/* CBLT  <Xt>, #<imm>, <label> (ffe04000/f5200000) */
//#define IEM_INSTR_IMPL_A64__CBLT_64_imm(Rt, imm9, imm6)


/* CBHI  <Xt>, #<imm>, <label> (ffe04000/f5400000) */
//#define IEM_INSTR_IMPL_A64__CBHI_64_imm(Rt, imm9, imm6)


/* CBLO  <Xt>, #<imm>, <label> (ffe04000/f5600000) */
//#define IEM_INSTR_IMPL_A64__CBLO_64_imm(Rt, imm9, imm6)


/* CBEQ  <Xt>, #<imm>, <label> (ffe04000/f5c00000) */
//#define IEM_INSTR_IMPL_A64__CBEQ_64_imm(Rt, imm9, imm6)


/* CBNE  <Xt>, #<imm>, <label> (ffe04000/f5e00000) */
//#define IEM_INSTR_IMPL_A64__CBNE_64_imm(Rt, imm9, imm6)



/*
 *
 * Instruction Set & Groups: compbranch_regs / control / A64
 *
 */

/* CBGT  <Wt>, <Wm>, <label> (ffe0c000/74000000) */
//#define IEM_INSTR_IMPL_A64__CBGT_32_regs(Rt, imm9, Rm)


/* CBGE  <Wt>, <Wm>, <label> (ffe0c000/74200000) */
//#define IEM_INSTR_IMPL_A64__CBGE_32_regs(Rt, imm9, Rm)


/* CBHI  <Wt>, <Wm>, <label> (ffe0c000/74400000) */
//#define IEM_INSTR_IMPL_A64__CBHI_32_regs(Rt, imm9, Rm)


/* CBHS  <Wt>, <Wm>, <label> (ffe0c000/74600000) */
//#define IEM_INSTR_IMPL_A64__CBHS_32_regs(Rt, imm9, Rm)


/* CBEQ  <Wt>, <Wm>, <label> (ffe0c000/74c00000) */
//#define IEM_INSTR_IMPL_A64__CBEQ_32_regs(Rt, imm9, Rm)


/* CBNE  <Wt>, <Wm>, <label> (ffe0c000/74e00000) */
//#define IEM_INSTR_IMPL_A64__CBNE_32_regs(Rt, imm9, Rm)


/* CBGT  <Xt>, <Xm>, <label> (ffe0c000/f4000000) */
//#define IEM_INSTR_IMPL_A64__CBGT_64_regs(Rt, imm9, Rm)


/* CBGE  <Xt>, <Xm>, <label> (ffe0c000/f4200000) */
//#define IEM_INSTR_IMPL_A64__CBGE_64_regs(Rt, imm9, Rm)


/* CBHI  <Xt>, <Xm>, <label> (ffe0c000/f4400000) */
//#define IEM_INSTR_IMPL_A64__CBHI_64_regs(Rt, imm9, Rm)


/* CBHS  <Xt>, <Xm>, <label> (ffe0c000/f4600000) */
//#define IEM_INSTR_IMPL_A64__CBHS_64_regs(Rt, imm9, Rm)


/* CBEQ  <Xt>, <Xm>, <label> (ffe0c000/f4c00000) */
//#define IEM_INSTR_IMPL_A64__CBEQ_64_regs(Rt, imm9, Rm)


/* CBNE  <Xt>, <Xm>, <label> (ffe0c000/f4e00000) */
//#define IEM_INSTR_IMPL_A64__CBNE_64_regs(Rt, imm9, Rm)



/*
 *
 * Instruction Set & Groups: compbranch_regs2 / control / A64
 *
 */

/* CBBGT  <Wt>, <Wm>, <label> (ffe0c000/74008000) */
//#define IEM_INSTR_IMPL_A64__CBBGT_8_regs(Rt, imm9, Rm)


/* CBBGE  <Wt>, <Wm>, <label> (ffe0c000/74208000) */
//#define IEM_INSTR_IMPL_A64__CBBGE_8_regs(Rt, imm9, Rm)


/* CBBHI  <Wt>, <Wm>, <label> (ffe0c000/74408000) */
//#define IEM_INSTR_IMPL_A64__CBBHI_8_regs(Rt, imm9, Rm)


/* CBBHS  <Wt>, <Wm>, <label> (ffe0c000/74608000) */
//#define IEM_INSTR_IMPL_A64__CBBHS_8_regs(Rt, imm9, Rm)


/* CBBEQ  <Wt>, <Wm>, <label> (ffe0c000/74c08000) */
//#define IEM_INSTR_IMPL_A64__CBBEQ_8_regs(Rt, imm9, Rm)


/* CBBNE  <Wt>, <Wm>, <label> (ffe0c000/74e08000) */
//#define IEM_INSTR_IMPL_A64__CBBNE_8_regs(Rt, imm9, Rm)


/* CBHGT  <Wt>, <Wm>, <label> (ffe0c000/7400c000) */
//#define IEM_INSTR_IMPL_A64__CBHGT_16_regs(Rt, imm9, Rm)


/* CBHGE  <Wt>, <Wm>, <label> (ffe0c000/7420c000) */
//#define IEM_INSTR_IMPL_A64__CBHGE_16_regs(Rt, imm9, Rm)


/* CBHHI  <Wt>, <Wm>, <label> (ffe0c000/7440c000) */
//#define IEM_INSTR_IMPL_A64__CBHHI_16_regs(Rt, imm9, Rm)


/* CBHHS  <Wt>, <Wm>, <label> (ffe0c000/7460c000) */
//#define IEM_INSTR_IMPL_A64__CBHHS_16_regs(Rt, imm9, Rm)


/* CBHEQ  <Wt>, <Wm>, <label> (ffe0c000/74c0c000) */
//#define IEM_INSTR_IMPL_A64__CBHEQ_16_regs(Rt, imm9, Rm)


/* CBHNE  <Wt>, <Wm>, <label> (ffe0c000/74e0c000) */
//#define IEM_INSTR_IMPL_A64__CBHNE_16_regs(Rt, imm9, Rm)



/*
 *
 * Instruction Set & Groups: comswap / ldst / A64
 *
 */

/* CASB  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/08a07c00) */
//#define IEM_INSTR_IMPL_A64__CASB_C32_comswap(Rt, Rn, Rs)


/* CASLB  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/08a0fc00) */
//#define IEM_INSTR_IMPL_A64__CASLB_C32_comswap(Rt, Rn, Rs)


/* CASAB  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/08e07c00) */
//#define IEM_INSTR_IMPL_A64__CASAB_C32_comswap(Rt, Rn, Rs)


/* CASALB  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/08e0fc00) */
//#define IEM_INSTR_IMPL_A64__CASALB_C32_comswap(Rt, Rn, Rs)


/* CASH  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/48a07c00) */
//#define IEM_INSTR_IMPL_A64__CASH_C32_comswap(Rt, Rn, Rs)


/* CASLH  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/48a0fc00) */
//#define IEM_INSTR_IMPL_A64__CASLH_C32_comswap(Rt, Rn, Rs)


/* CASAH  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/48e07c00) */
//#define IEM_INSTR_IMPL_A64__CASAH_C32_comswap(Rt, Rn, Rs)


/* CASALH  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/48e0fc00) */
//#define IEM_INSTR_IMPL_A64__CASALH_C32_comswap(Rt, Rn, Rs)


/* CAS  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/88a07c00) */
//#define IEM_INSTR_IMPL_A64__CAS_C32_comswap(Rt, Rn, Rs)


/* CASL  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/88a0fc00) */
//#define IEM_INSTR_IMPL_A64__CASL_C32_comswap(Rt, Rn, Rs)


/* CASA  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/88e07c00) */
//#define IEM_INSTR_IMPL_A64__CASA_C32_comswap(Rt, Rn, Rs)


/* CASAL  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/88e0fc00) */
//#define IEM_INSTR_IMPL_A64__CASAL_C32_comswap(Rt, Rn, Rs)


/* CAS  <Xs>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c8a07c00) */
//#define IEM_INSTR_IMPL_A64__CAS_C64_comswap(Rt, Rn, Rs)


/* CASL  <Xs>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c8a0fc00) */
//#define IEM_INSTR_IMPL_A64__CASL_C64_comswap(Rt, Rn, Rs)


/* CASA  <Xs>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c8e07c00) */
//#define IEM_INSTR_IMPL_A64__CASA_C64_comswap(Rt, Rn, Rs)


/* CASAL  <Xs>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c8e0fc00) */
//#define IEM_INSTR_IMPL_A64__CASAL_C64_comswap(Rt, Rn, Rs)



/*
 *
 * Instruction Set & Groups: comswap_unpriv / ldst / A64
 *
 */

/* CAST  <Xs>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c9807c00) */
//#define IEM_INSTR_IMPL_A64__CAST_C64_comswap_unpriv(Rt, Rn, Rs)


/* CASLT  <Xs>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c980fc00) */
//#define IEM_INSTR_IMPL_A64__CASLT_C64_comswap_unpriv(Rt, Rn, Rs)


/* CASAT  <Xs>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c9c07c00) */
//#define IEM_INSTR_IMPL_A64__CASAT_C64_comswap_unpriv(Rt, Rn, Rs)


/* CASALT  <Xs>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c9c0fc00) */
//#define IEM_INSTR_IMPL_A64__CASALT_C64_comswap_unpriv(Rt, Rn, Rs)



/*
 *
 * Instruction Set & Groups: comswappr / ldst / A64
 *
 */

/* CASP  <Ws>, <W(s+1)>, <Wt>, <W(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/08207c00) */
//#define IEM_INSTR_IMPL_A64__CASP_CP32_comswappr(Rt, Rn, Rs)


/* CASPL  <Ws>, <W(s+1)>, <Wt>, <W(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/0820fc00) */
//#define IEM_INSTR_IMPL_A64__CASPL_CP32_comswappr(Rt, Rn, Rs)


/* CASPA  <Ws>, <W(s+1)>, <Wt>, <W(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/08607c00) */
//#define IEM_INSTR_IMPL_A64__CASPA_CP32_comswappr(Rt, Rn, Rs)


/* CASPAL  <Ws>, <W(s+1)>, <Wt>, <W(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/0860fc00) */
//#define IEM_INSTR_IMPL_A64__CASPAL_CP32_comswappr(Rt, Rn, Rs)


/* CASP  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/48207c00) */
//#define IEM_INSTR_IMPL_A64__CASP_CP64_comswappr(Rt, Rn, Rs)


/* CASPL  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/4820fc00) */
//#define IEM_INSTR_IMPL_A64__CASPL_CP64_comswappr(Rt, Rn, Rs)


/* CASPA  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/48607c00) */
//#define IEM_INSTR_IMPL_A64__CASPA_CP64_comswappr(Rt, Rn, Rs)


/* CASPAL  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/4860fc00) */
//#define IEM_INSTR_IMPL_A64__CASPAL_CP64_comswappr(Rt, Rn, Rs)



/*
 *
 * Instruction Set & Groups: comswappr_unpriv / ldst / A64
 *
 */

/* CASPT  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/49807c00) */
//#define IEM_INSTR_IMPL_A64__CASPT_CP64_comswappr_unpriv(Rt, Rn, Rs)


/* CASPLT  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/4980fc00) */
//#define IEM_INSTR_IMPL_A64__CASPLT_CP64_comswappr_unpriv(Rt, Rn, Rs)


/* CASPAT  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/49c07c00) */
//#define IEM_INSTR_IMPL_A64__CASPAT_CP64_comswappr_unpriv(Rt, Rn, Rs)


/* CASPALT  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>{, #0}] (ffe0fc00/49c0fc00) */
//#define IEM_INSTR_IMPL_A64__CASPALT_CP64_comswappr_unpriv(Rt, Rn, Rs)



/*
 *
 * Instruction Set & Groups: condbranch / control / A64
 *
 */

/* B.<cond>  <label> (ff000010/54000000) */
#define IEM_INSTR_IMPL_A64__B_only_condbranch(cond, imm19) \
    int32_t const offRel = (int32_t)(imm19 << (32 - 19)) >> (32 - 19 - 2); \
    switch (cond) \
    { \
        case  0: /* Z=1: EQ - equal. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_SET(ARMV8_SPSR_EL2_AARCH64_Z) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  1: /* Z=0: NE - not equal. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_NOT_SET(ARMV8_SPSR_EL2_AARCH64_Z) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  2: /* C=1: CS - carry set   / HS - unsigned higher or same. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_SET(ARMV8_SPSR_EL2_AARCH64_C) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  3: /* C=0: CC - carry clear / LS - unsigned less than. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_NOT_SET(ARMV8_SPSR_EL2_AARCH64_C) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  4: /* N=1: MI - minus. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_SET(ARMV8_SPSR_EL2_AARCH64_N) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  5: /* N=0: PL - plus (positive or zero). */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_NOT_SET(ARMV8_SPSR_EL2_AARCH64_N) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  6: /* V=1: VS - overflow set. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_SET(ARMV8_SPSR_EL2_AARCH64_V) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  7: /* V=0: VC - overflow clear. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_NOT_SET(ARMV8_SPSR_EL2_AARCH64_V) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  8: /* C=1 && Z=0:  HI - unsigned higher than */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_SET_AND_BIT_NOT_SET(ARMV8_SPSR_EL2_AARCH64_C, ARMV8_SPSR_EL2_AARCH64_Z) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case  9: /* C=0 || Z=1:  LS - unsigned less or equal than. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_SET_OR_BIT_NOT_SET(ARMV8_SPSR_EL2_AARCH64_Z, ARMV8_SPSR_EL2_AARCH64_C) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case 10: /* N=V:         GE - signed greater or equal than. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BITS_EQ(ARMV8_SPSR_EL2_AARCH64_N, ARMV8_SPSR_EL2_AARCH64_V) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case 11: /* N!=V:        LT - signed less than. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BITS_NE(ARMV8_SPSR_EL2_AARCH64_N, ARMV8_SPSR_EL2_AARCH64_V) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case 12: /* Z=0 && N=V:  GT - sigend greater than. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_NOT_SET_AND_BITS_EQ(ARMV8_SPSR_EL2_AARCH64_Z, \
                                                    ARMV8_SPSR_EL2_AARCH64_N, ARMV8_SPSR_EL2_AARCH64_V) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        case 13: /* Z=1 || N!=V: LE - signed less or equal than. */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_CONDITIONAL | IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_IF_FLAGS_BIT_SET_OR_BITS_NE(ARMV8_SPSR_EL2_AARCH64_Z, \
                                               ARMV8_SPSR_EL2_AARCH64_N, ARMV8_SPSR_EL2_AARCH64_V) { \
                IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            } IEM_MC_ELSE() { \
                IEM_MC_ADVANCE_PC_AND_FINISH(); \
            } IEM_MC_ENDIF(); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
        default: RT_FALL_THRU(); \
        case 14: /* AL - always. */ RT_FALL_THRU(); \
        case 15: /* NV - never == always (https://devblogs.microsoft.com/oldnewthing/20220815-00/?p=106975) */ \
            IEM_MC_BEGIN(0, IEM_CIMPL_F_BRANCH_RELATIVE); \
            IEM_MC_REL_JMP_S32_AND_FINISH(offRel); \
            IEM_MC_END(); \
            break; /* for VS2022 */ \
    } ((void)0)

/* BC.<cond>  <label> (ff000010/54000010) */
#define IEM_INSTR_IMPL_A64__BC_only_condbranch(cond, imm19) \
    IEM_INSTR_IMPL_A64__B_only_condbranch(cond, imm19)



/*
 *
 * Instruction Set & Groups: condcmp_imm / dpreg / A64
 *
 */

/* CCMN  <Wn>, #<imm>, #<nzcv>, <cond> (ffe00c10/3a400800) */
//#define IEM_INSTR_IMPL_A64__CCMN_32_condcmp_imm(nzcv, Rn, cond, imm5)


/* CCMP  <Wn>, #<imm>, #<nzcv>, <cond> (ffe00c10/7a400800) */
//#define IEM_INSTR_IMPL_A64__CCMP_32_condcmp_imm(nzcv, Rn, cond, imm5)


/* CCMN  <Xn>, #<imm>, #<nzcv>, <cond> (ffe00c10/ba400800) */
//#define IEM_INSTR_IMPL_A64__CCMN_64_condcmp_imm(nzcv, Rn, cond, imm5)


/* CCMP  <Xn>, #<imm>, #<nzcv>, <cond> (ffe00c10/fa400800) */
//#define IEM_INSTR_IMPL_A64__CCMP_64_condcmp_imm(nzcv, Rn, cond, imm5)



/*
 *
 * Instruction Set & Groups: condcmp_reg / dpreg / A64
 *
 */

/* CCMN  <Wn>, <Wm>, #<nzcv>, <cond> (ffe00c10/3a400000) */
//#define IEM_INSTR_IMPL_A64__CCMN_32_condcmp_reg(nzcv, Rn, cond, Rm)


/* CCMP  <Wn>, <Wm>, #<nzcv>, <cond> (ffe00c10/7a400000) */
//#define IEM_INSTR_IMPL_A64__CCMP_32_condcmp_reg(nzcv, Rn, cond, Rm)


/* CCMN  <Xn>, <Xm>, #<nzcv>, <cond> (ffe00c10/ba400000) */
//#define IEM_INSTR_IMPL_A64__CCMN_64_condcmp_reg(nzcv, Rn, cond, Rm)


/* CCMP  <Xn>, <Xm>, #<nzcv>, <cond> (ffe00c10/fa400000) */
//#define IEM_INSTR_IMPL_A64__CCMP_64_condcmp_reg(nzcv, Rn, cond, Rm)



/*
 *
 * Instruction Set & Groups: condsel / dpreg / A64
 *
 */

/* CSEL  <Wd>, <Wn>, <Wm>, <cond> (ffe00c00/1a800000) */
//#define IEM_INSTR_IMPL_A64__CSEL_32_condsel(Rd, Rn, cond, Rm)


/* CSINC  <Wd>, <Wn>, <Wm>, <cond> (ffe00c00/1a800400) */
//#define IEM_INSTR_IMPL_A64__CSINC_32_condsel(Rd, Rn, cond, Rm)


/* CSINV  <Wd>, <Wn>, <Wm>, <cond> (ffe00c00/5a800000) */
//#define IEM_INSTR_IMPL_A64__CSINV_32_condsel(Rd, Rn, cond, Rm)


/* CSNEG  <Wd>, <Wn>, <Wm>, <cond> (ffe00c00/5a800400) */
//#define IEM_INSTR_IMPL_A64__CSNEG_32_condsel(Rd, Rn, cond, Rm)


/* CSEL  <Xd>, <Xn>, <Xm>, <cond> (ffe00c00/9a800000) */
//#define IEM_INSTR_IMPL_A64__CSEL_64_condsel(Rd, Rn, cond, Rm)


/* CSINC  <Xd>, <Xn>, <Xm>, <cond> (ffe00c00/9a800400) */
//#define IEM_INSTR_IMPL_A64__CSINC_64_condsel(Rd, Rn, cond, Rm)


/* CSINV  <Xd>, <Xn>, <Xm>, <cond> (ffe00c00/da800000) */
//#define IEM_INSTR_IMPL_A64__CSINV_64_condsel(Rd, Rn, cond, Rm)


/* CSNEG  <Xd>, <Xn>, <Xm>, <cond> (ffe00c00/da800400) */
//#define IEM_INSTR_IMPL_A64__CSNEG_64_condsel(Rd, Rn, cond, Rm)



/*
 *
 * Instruction Set & Groups: crypto3_imm2 / simd_dp / A64
 *
 */

/* SM3TT1A  <Vd>.4S, <Vn>.4S, <Vm>.S[<imm2>] (ffe0cc00/ce408000) */
//#define IEM_INSTR_IMPL_A64__SM3TT1A_VVV4_crypto3_imm2(Rd, Rn, imm2, Rm)


/* SM3TT1B  <Vd>.4S, <Vn>.4S, <Vm>.S[<imm2>] (ffe0cc00/ce408400) */
//#define IEM_INSTR_IMPL_A64__SM3TT1B_VVV4_crypto3_imm2(Rd, Rn, imm2, Rm)


/* SM3TT2A  <Vd>.4S, <Vn>.4S, <Vm>.S[<imm2>] (ffe0cc00/ce408800) */
//#define IEM_INSTR_IMPL_A64__SM3TT2A_VVV4_crypto3_imm2(Rd, Rn, imm2, Rm)


/* SM3TT2B  <Vd>.4S, <Vn>.4S, <Vm>.S[<imm2>] (ffe0cc00/ce408c00) */
//#define IEM_INSTR_IMPL_A64__SM3TT2B_VVV_crypto3_imm2(Rd, Rn, imm2, Rm)



/*
 *
 * Instruction Set & Groups: crypto3_imm6 / simd_dp / A64
 *
 */

/* XAR  <Vd>.2D, <Vn>.2D, <Vm>.2D, #<imm6> (ffe00000/ce800000) */
//#define IEM_INSTR_IMPL_A64__XAR_VVV2_crypto3_imm6(Rd, Rn, imm6, Rm)



/*
 *
 * Instruction Set & Groups: crypto4 / simd_dp / A64
 *
 */

/* EOR3  <Vd>.16B, <Vn>.16B, <Vm>.16B, <Va>.16B (ffe08000/ce000000) */
//#define IEM_INSTR_IMPL_A64__EOR3_VVV16_crypto4(Rd, Rn, Ra, Rm)


/* BCAX  <Vd>.16B, <Vn>.16B, <Vm>.16B, <Va>.16B (ffe08000/ce200000) */
//#define IEM_INSTR_IMPL_A64__BCAX_VVV16_crypto4(Rd, Rn, Ra, Rm)


/* SM3SS1  <Vd>.4S, <Vn>.4S, <Vm>.4S, <Va>.4S (ffe08000/ce400000) */
//#define IEM_INSTR_IMPL_A64__SM3SS1_VVV4_crypto4(Rd, Rn, Ra, Rm)



/*
 *
 * Instruction Set & Groups: cryptoaes / simd_dp / A64
 *
 */

/* AESE  <Vd>.16B, <Vn>.16B (fffffc00/4e284800) */
//#define IEM_INSTR_IMPL_A64__AESE_B_cryptoaes(Rd, Rn)


/* AESD  <Vd>.16B, <Vn>.16B (fffffc00/4e285800) */
//#define IEM_INSTR_IMPL_A64__AESD_B_cryptoaes(Rd, Rn)


/* AESMC  <Vd>.16B, <Vn>.16B (fffffc00/4e286800) */
//#define IEM_INSTR_IMPL_A64__AESMC_B_cryptoaes(Rd, Rn)


/* AESIMC  <Vd>.16B, <Vn>.16B (fffffc00/4e287800) */
//#define IEM_INSTR_IMPL_A64__AESIMC_B_cryptoaes(Rd, Rn)



/*
 *
 * Instruction Set & Groups: cryptosha2 / simd_dp / A64
 *
 */

/* SHA1H  <Sd>, <Sn> (fffffc00/5e280800) */
//#define IEM_INSTR_IMPL_A64__SHA1H_SS_cryptosha2(Rd, Rn)


/* SHA1SU1  <Vd>.4S, <Vn>.4S (fffffc00/5e281800) */
//#define IEM_INSTR_IMPL_A64__SHA1SU1_VV_cryptosha2(Rd, Rn)


/* SHA256SU0  <Vd>.4S, <Vn>.4S (fffffc00/5e282800) */
//#define IEM_INSTR_IMPL_A64__SHA256SU0_VV_cryptosha2(Rd, Rn)



/*
 *
 * Instruction Set & Groups: cryptosha3 / simd_dp / A64
 *
 */

/* SHA1C  <Qd>, <Sn>, <Vm>.4S (ffe0fc00/5e000000) */
//#define IEM_INSTR_IMPL_A64__SHA1C_QSV_cryptosha3(Rd, Rn, Rm)


/* SHA1P  <Qd>, <Sn>, <Vm>.4S (ffe0fc00/5e001000) */
//#define IEM_INSTR_IMPL_A64__SHA1P_QSV_cryptosha3(Rd, Rn, Rm)


/* SHA1M  <Qd>, <Sn>, <Vm>.4S (ffe0fc00/5e002000) */
//#define IEM_INSTR_IMPL_A64__SHA1M_QSV_cryptosha3(Rd, Rn, Rm)


/* SHA1SU0  <Vd>.4S, <Vn>.4S, <Vm>.4S (ffe0fc00/5e003000) */
//#define IEM_INSTR_IMPL_A64__SHA1SU0_VVV_cryptosha3(Rd, Rn, Rm)


/* SHA256H  <Qd>, <Qn>, <Vm>.4S (ffe0fc00/5e004000) */
//#define IEM_INSTR_IMPL_A64__SHA256H_QQV_cryptosha3(Rd, Rn, Rm)


/* SHA256H2  <Qd>, <Qn>, <Vm>.4S (ffe0fc00/5e005000) */
//#define IEM_INSTR_IMPL_A64__SHA256H2_QQV_cryptosha3(Rd, Rn, Rm)


/* SHA256SU1  <Vd>.4S, <Vn>.4S, <Vm>.4S (ffe0fc00/5e006000) */
//#define IEM_INSTR_IMPL_A64__SHA256SU1_VVV_cryptosha3(Rd, Rn, Rm)



/*
 *
 * Instruction Set & Groups: cryptosha512_2 / simd_dp / A64
 *
 */

/* SHA512SU0  <Vd>.2D, <Vn>.2D (fffffc00/cec08000) */
//#define IEM_INSTR_IMPL_A64__SHA512SU0_VV2_cryptosha512_2(Rd, Rn)


/* SM4E  <Vd>.4S, <Vn>.4S (fffffc00/cec08400) */
//#define IEM_INSTR_IMPL_A64__SM4E_VV4_cryptosha512_2(Rd, Rn)



/*
 *
 * Instruction Set & Groups: cryptosha512_3 / simd_dp / A64
 *
 */

/* SHA512H  <Qd>, <Qn>, <Vm>.2D (ffe0fc00/ce608000) */
//#define IEM_INSTR_IMPL_A64__SHA512H_QQV_cryptosha512_3(Rd, Rn, Rm)


/* SHA512H2  <Qd>, <Qn>, <Vm>.2D (ffe0fc00/ce608400) */
//#define IEM_INSTR_IMPL_A64__SHA512H2_QQV_cryptosha512_3(Rd, Rn, Rm)


/* SHA512SU1  <Vd>.2D, <Vn>.2D, <Vm>.2D (ffe0fc00/ce608800) */
//#define IEM_INSTR_IMPL_A64__SHA512SU1_VVV2_cryptosha512_3(Rd, Rn, Rm)


/* RAX1  <Vd>.2D, <Vn>.2D, <Vm>.2D (ffe0fc00/ce608c00) */
//#define IEM_INSTR_IMPL_A64__RAX1_VVV2_cryptosha512_3(Rd, Rn, Rm)


/* SM3PARTW1  <Vd>.4S, <Vn>.4S, <Vm>.4S (ffe0fc00/ce60c000) */
//#define IEM_INSTR_IMPL_A64__SM3PARTW1_VVV4_cryptosha512_3(Rd, Rn, Rm)


/* SM3PARTW2  <Vd>.4S, <Vn>.4S, <Vm>.4S (ffe0fc00/ce60c400) */
//#define IEM_INSTR_IMPL_A64__SM3PARTW2_VVV4_cryptosha512_3(Rd, Rn, Rm)


/* SM4EKEY  <Vd>.4S, <Vn>.4S, <Vm>.4S (ffe0fc00/ce60c800) */
//#define IEM_INSTR_IMPL_A64__SM4EKEY_VVV4_cryptosha512_3(Rd, Rn, Rm)



/*
 *
 * Instruction Set & Groups: dp_1src / dpreg / A64
 *
 */

/* RBIT  <Wd>, <Wn> (fffffc00/5ac00000) */
//#define IEM_INSTR_IMPL_A64__RBIT_32_dp_1src(Rd, Rn)


/* REV16  <Wd>, <Wn> (fffffc00/5ac00400) */
//#define IEM_INSTR_IMPL_A64__REV16_32_dp_1src(Rd, Rn)


/* REV  <Wd>, <Wn> (fffffc00/5ac00800) */
//#define IEM_INSTR_IMPL_A64__REV_32_dp_1src(Rd, Rn)


/* CLZ  <Wd>, <Wn> (fffffc00/5ac01000) */
//#define IEM_INSTR_IMPL_A64__CLZ_32_dp_1src(Rd, Rn)


/* CLS  <Wd>, <Wn> (fffffc00/5ac01400) */
//#define IEM_INSTR_IMPL_A64__CLS_32_dp_1src(Rd, Rn)


/* CTZ  <Wd>, <Wn> (fffffc00/5ac01800) */
//#define IEM_INSTR_IMPL_A64__CTZ_32_dp_1src(Rd, Rn)


/* CNT  <Wd>, <Wn> (fffffc00/5ac01c00) */
//#define IEM_INSTR_IMPL_A64__CNT_32_dp_1src(Rd, Rn)


/* ABS  <Wd>, <Wn> (fffffc00/5ac02000) */
//#define IEM_INSTR_IMPL_A64__ABS_32_dp_1src(Rd, Rn)


/* RBIT  <Xd>, <Xn> (fffffc00/dac00000) */
//#define IEM_INSTR_IMPL_A64__RBIT_64_dp_1src(Rd, Rn)


/* REV16  <Xd>, <Xn> (fffffc00/dac00400) */
//#define IEM_INSTR_IMPL_A64__REV16_64_dp_1src(Rd, Rn)


/* REV32  <Xd>, <Xn> (fffffc00/dac00800) */
//#define IEM_INSTR_IMPL_A64__REV32_64_dp_1src(Rd, Rn)


/* REV  <Xd>, <Xn> (fffffc00/dac00c00) */
//#define IEM_INSTR_IMPL_A64__REV_64_dp_1src(Rd, Rn)


/* CLZ  <Xd>, <Xn> (fffffc00/dac01000) */
//#define IEM_INSTR_IMPL_A64__CLZ_64_dp_1src(Rd, Rn)


/* CLS  <Xd>, <Xn> (fffffc00/dac01400) */
//#define IEM_INSTR_IMPL_A64__CLS_64_dp_1src(Rd, Rn)


/* CTZ  <Xd>, <Xn> (fffffc00/dac01800) */
//#define IEM_INSTR_IMPL_A64__CTZ_64_dp_1src(Rd, Rn)


/* CNT  <Xd>, <Xn> (fffffc00/dac01c00) */
//#define IEM_INSTR_IMPL_A64__CNT_64_dp_1src(Rd, Rn)


/* ABS  <Xd>, <Xn> (fffffc00/dac02000) */
//#define IEM_INSTR_IMPL_A64__ABS_64_dp_1src(Rd, Rn)


/* PACIA  <Xd>, <Xn|SP> (fffffc00/dac10000) */
//#define IEM_INSTR_IMPL_A64__PACIA_64P_dp_1src(Rd, Rn)


/* PACIB  <Xd>, <Xn|SP> (fffffc00/dac10400) */
//#define IEM_INSTR_IMPL_A64__PACIB_64P_dp_1src(Rd, Rn)


/* PACDA  <Xd>, <Xn|SP> (fffffc00/dac10800) */
//#define IEM_INSTR_IMPL_A64__PACDA_64P_dp_1src(Rd, Rn)


/* PACDB  <Xd>, <Xn|SP> (fffffc00/dac10c00) */
//#define IEM_INSTR_IMPL_A64__PACDB_64P_dp_1src(Rd, Rn)


/* AUTIA  <Xd>, <Xn|SP> (fffffc00/dac11000) */
//#define IEM_INSTR_IMPL_A64__AUTIA_64P_dp_1src(Rd, Rn)


/* AUTIB  <Xd>, <Xn|SP> (fffffc00/dac11400) */
//#define IEM_INSTR_IMPL_A64__AUTIB_64P_dp_1src(Rd, Rn)


/* AUTDA  <Xd>, <Xn|SP> (fffffc00/dac11800) */
//#define IEM_INSTR_IMPL_A64__AUTDA_64P_dp_1src(Rd, Rn)


/* AUTDB  <Xd>, <Xn|SP> (fffffc00/dac11c00) */
//#define IEM_INSTR_IMPL_A64__AUTDB_64P_dp_1src(Rd, Rn)


/* PACIZA  <Xd> (ffffffe0/dac123e0) */
//#define IEM_INSTR_IMPL_A64__PACIZA_64Z_dp_1src(Rd)


/* PACIZB  <Xd> (ffffffe0/dac127e0) */
//#define IEM_INSTR_IMPL_A64__PACIZB_64Z_dp_1src(Rd)


/* PACDZA  <Xd> (ffffffe0/dac12be0) */
//#define IEM_INSTR_IMPL_A64__PACDZA_64Z_dp_1src(Rd)


/* PACDZB  <Xd> (ffffffe0/dac12fe0) */
//#define IEM_INSTR_IMPL_A64__PACDZB_64Z_dp_1src(Rd)


/* AUTIZA  <Xd> (ffffffe0/dac133e0) */
//#define IEM_INSTR_IMPL_A64__AUTIZA_64Z_dp_1src(Rd)


/* AUTIZB  <Xd> (ffffffe0/dac137e0) */
//#define IEM_INSTR_IMPL_A64__AUTIZB_64Z_dp_1src(Rd)


/* AUTDZA  <Xd> (ffffffe0/dac13be0) */
//#define IEM_INSTR_IMPL_A64__AUTDZA_64Z_dp_1src(Rd)


/* AUTDZB  <Xd> (ffffffe0/dac13fe0) */
//#define IEM_INSTR_IMPL_A64__AUTDZB_64Z_dp_1src(Rd)


/* XPACI  <Xd> (ffffffe0/dac143e0) */
//#define IEM_INSTR_IMPL_A64__XPACI_64Z_dp_1src(Rd)


/* XPACD  <Xd> (ffffffe0/dac147e0) */
//#define IEM_INSTR_IMPL_A64__XPACD_64Z_dp_1src(Rd)


/* PACNBIASPPC (ffffffff/dac183fe) */
//#define IEM_INSTR_IMPL_A64__PACNBIASPPC_64LR_dp_1src()


/* PACNBIBSPPC (ffffffff/dac187fe) */
//#define IEM_INSTR_IMPL_A64__PACNBIBSPPC_64LR_dp_1src()


/* PACIA171615 (ffffffff/dac18bfe) */
//#define IEM_INSTR_IMPL_A64__PACIA171615_64LR_dp_1src()


/* PACIB171615 (ffffffff/dac18ffe) */
//#define IEM_INSTR_IMPL_A64__PACIB171615_64LR_dp_1src()


/* AUTIASPPCR  <Xn> (fffffc1f/dac1901e) */
//#define IEM_INSTR_IMPL_A64__AUTIASPPCR_64LRR_dp_1src(Rn)


/* AUTIBSPPCR  <Xn> (fffffc1f/dac1941e) */
//#define IEM_INSTR_IMPL_A64__AUTIBSPPCR_64LRR_dp_1src(Rn)


/* PACIASPPC (ffffffff/dac1a3fe) */
//#define IEM_INSTR_IMPL_A64__PACIASPPC_64LR_dp_1src()


/* PACIBSPPC (ffffffff/dac1a7fe) */
//#define IEM_INSTR_IMPL_A64__PACIBSPPC_64LR_dp_1src()


/* AUTIA171615 (ffffffff/dac1bbfe) */
//#define IEM_INSTR_IMPL_A64__AUTIA171615_64LR_dp_1src()


/* AUTIB171615 (ffffffff/dac1bffe) */
//#define IEM_INSTR_IMPL_A64__AUTIB171615_64LR_dp_1src()



/*
 *
 * Instruction Set & Groups: dp_1src_imm / dpimm / A64
 *
 */

/* AUTIASPPC  <label> (ffe0001f/f380001f) */
//#define IEM_INSTR_IMPL_A64__AUTIASPPC_only_dp_1src_imm(imm16)


/* AUTIBSPPC  <label> (ffe0001f/f3a0001f) */
//#define IEM_INSTR_IMPL_A64__AUTIBSPPC_only_dp_1src_imm(imm16)



/*
 *
 * Instruction Set & Groups: dp_2src / dpreg / A64
 *
 */

/* UDIV  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac00800) */
//#define IEM_INSTR_IMPL_A64__UDIV_32_dp_2src(Rd, Rn, Rm)


/* SDIV  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac00c00) */
//#define IEM_INSTR_IMPL_A64__SDIV_32_dp_2src(Rd, Rn, Rm)


/* LSLV  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac02000) */
//#define IEM_INSTR_IMPL_A64__LSLV_32_dp_2src(Rd, Rn, Rm)


/* LSRV  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac02400) */
//#define IEM_INSTR_IMPL_A64__LSRV_32_dp_2src(Rd, Rn, Rm)


/* ASRV  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac02800) */
//#define IEM_INSTR_IMPL_A64__ASRV_32_dp_2src(Rd, Rn, Rm)


/* RORV  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac02c00) */
//#define IEM_INSTR_IMPL_A64__RORV_32_dp_2src(Rd, Rn, Rm)


/* CRC32B  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac04000) */
//#define IEM_INSTR_IMPL_A64__CRC32B_32C_dp_2src(Rd, Rn, Rm)


/* CRC32H  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac04400) */
//#define IEM_INSTR_IMPL_A64__CRC32H_32C_dp_2src(Rd, Rn, Rm)


/* CRC32W  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac04800) */
//#define IEM_INSTR_IMPL_A64__CRC32W_32C_dp_2src(Rd, Rn, Rm)


/* CRC32CB  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac05000) */
//#define IEM_INSTR_IMPL_A64__CRC32CB_32C_dp_2src(Rd, Rn, Rm)


/* CRC32CH  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac05400) */
//#define IEM_INSTR_IMPL_A64__CRC32CH_32C_dp_2src(Rd, Rn, Rm)


/* CRC32CW  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac05800) */
//#define IEM_INSTR_IMPL_A64__CRC32CW_32C_dp_2src(Rd, Rn, Rm)


/* SMAX  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac06000) */
//#define IEM_INSTR_IMPL_A64__SMAX_32_dp_2src(Rd, Rn, Rm)


/* UMAX  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac06400) */
//#define IEM_INSTR_IMPL_A64__UMAX_32_dp_2src(Rd, Rn, Rm)


/* SMIN  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac06800) */
//#define IEM_INSTR_IMPL_A64__SMIN_32_dp_2src(Rd, Rn, Rm)


/* UMIN  <Wd>, <Wn>, <Wm> (ffe0fc00/1ac06c00) */
//#define IEM_INSTR_IMPL_A64__UMIN_32_dp_2src(Rd, Rn, Rm)


/* SUBP  <Xd>, <Xn|SP>, <Xm|SP> (ffe0fc00/9ac00000) */
//#define IEM_INSTR_IMPL_A64__SUBP_64S_dp_2src(Rd, Rn, Rm)


/* UDIV  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac00800) */
//#define IEM_INSTR_IMPL_A64__UDIV_64_dp_2src(Rd, Rn, Rm)


/* SDIV  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac00c00) */
//#define IEM_INSTR_IMPL_A64__SDIV_64_dp_2src(Rd, Rn, Rm)


/* IRG  <Xd|SP>, <Xn|SP>{, <Xm>} (ffe0fc00/9ac01000) */
//#define IEM_INSTR_IMPL_A64__IRG_64I_dp_2src(Rd, Rn, Rm)


/* GMI  <Xd>, <Xn|SP>, <Xm> (ffe0fc00/9ac01400) */
//#define IEM_INSTR_IMPL_A64__GMI_64G_dp_2src(Rd, Rn, Rm)


/* LSLV  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac02000) */
//#define IEM_INSTR_IMPL_A64__LSLV_64_dp_2src(Rd, Rn, Rm)


/* LSRV  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac02400) */
//#define IEM_INSTR_IMPL_A64__LSRV_64_dp_2src(Rd, Rn, Rm)


/* ASRV  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac02800) */
//#define IEM_INSTR_IMPL_A64__ASRV_64_dp_2src(Rd, Rn, Rm)


/* RORV  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac02c00) */
//#define IEM_INSTR_IMPL_A64__RORV_64_dp_2src(Rd, Rn, Rm)


/* PACGA  <Xd>, <Xn>, <Xm|SP> (ffe0fc00/9ac03000) */
//#define IEM_INSTR_IMPL_A64__PACGA_64P_dp_2src(Rd, Rn, Rm)


/* CRC32X  <Wd>, <Wn>, <Xm> (ffe0fc00/9ac04c00) */
//#define IEM_INSTR_IMPL_A64__CRC32X_64C_dp_2src(Rd, Rn, Rm)


/* CRC32CX  <Wd>, <Wn>, <Xm> (ffe0fc00/9ac05c00) */
//#define IEM_INSTR_IMPL_A64__CRC32CX_64C_dp_2src(Rd, Rn, Rm)


/* SMAX  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac06000) */
//#define IEM_INSTR_IMPL_A64__SMAX_64_dp_2src(Rd, Rn, Rm)


/* UMAX  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac06400) */
//#define IEM_INSTR_IMPL_A64__UMAX_64_dp_2src(Rd, Rn, Rm)


/* SMIN  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac06800) */
//#define IEM_INSTR_IMPL_A64__SMIN_64_dp_2src(Rd, Rn, Rm)


/* UMIN  <Xd>, <Xn>, <Xm> (ffe0fc00/9ac06c00) */
//#define IEM_INSTR_IMPL_A64__UMIN_64_dp_2src(Rd, Rn, Rm)


/* SUBPS  <Xd>, <Xn|SP>, <Xm|SP> (ffe0fc00/bac00000) */
//#define IEM_INSTR_IMPL_A64__SUBPS_64S_dp_2src(Rd, Rn, Rm)



/*
 *
 * Instruction Set & Groups: dp_3src / dpreg / A64
 *
 */

/* MADD  <Wd>, <Wn>, <Wm>, <Wa> (ffe08000/1b000000) */
//#define IEM_INSTR_IMPL_A64__MADD_32A_dp_3src(Rd, Rn, Ra, Rm)


/* MSUB  <Wd>, <Wn>, <Wm>, <Wa> (ffe08000/1b008000) */
//#define IEM_INSTR_IMPL_A64__MSUB_32A_dp_3src(Rd, Rn, Ra, Rm)


/* MADD  <Xd>, <Xn>, <Xm>, <Xa> (ffe08000/9b000000) */
//#define IEM_INSTR_IMPL_A64__MADD_64A_dp_3src(Rd, Rn, Ra, Rm)


/* MSUB  <Xd>, <Xn>, <Xm>, <Xa> (ffe08000/9b008000) */
//#define IEM_INSTR_IMPL_A64__MSUB_64A_dp_3src(Rd, Rn, Ra, Rm)


/* SMADDL  <Xd>, <Wn>, <Wm>, <Xa> (ffe08000/9b200000) */
//#define IEM_INSTR_IMPL_A64__SMADDL_64WA_dp_3src(Rd, Rn, Ra, Rm)


/* SMSUBL  <Xd>, <Wn>, <Wm>, <Xa> (ffe08000/9b208000) */
//#define IEM_INSTR_IMPL_A64__SMSUBL_64WA_dp_3src(Rd, Rn, Ra, Rm)


/* SMULH  <Xd>, <Xn>, <Xm> (ffe0fc00/9b407c00) */
//#define IEM_INSTR_IMPL_A64__SMULH_64_dp_3src(Rd, Rn, Rm)


/* MADDPT  <Xd>, <Xn>, <Xm>, <Xa> (ffe08000/9b600000) */
//#define IEM_INSTR_IMPL_A64__MADDPT_64A_dp_3src(Rd, Rn, Ra, Rm)


/* MSUBPT  <Xd>, <Xn>, <Xm>, <Xa> (ffe08000/9b608000) */
//#define IEM_INSTR_IMPL_A64__MSUBPT_64A_dp_3src(Rd, Rn, Ra, Rm)


/* UMADDL  <Xd>, <Wn>, <Wm>, <Xa> (ffe08000/9ba00000) */
//#define IEM_INSTR_IMPL_A64__UMADDL_64WA_dp_3src(Rd, Rn, Ra, Rm)


/* UMSUBL  <Xd>, <Wn>, <Wm>, <Xa> (ffe08000/9ba08000) */
//#define IEM_INSTR_IMPL_A64__UMSUBL_64WA_dp_3src(Rd, Rn, Ra, Rm)


/* UMULH  <Xd>, <Xn>, <Xm> (ffe0fc00/9bc07c00) */
//#define IEM_INSTR_IMPL_A64__UMULH_64_dp_3src(Rd, Rn, Rm)



/*
 *
 * Instruction Set & Groups: exception / control / A64
 *
 */

/* SVC  #<imm> (ffe0001f/d4000001) */
//#define IEM_INSTR_IMPL_A64__SVC_EX_exception(imm16)


/* HVC  #<imm> (ffe0001f/d4000002) */
//#define IEM_INSTR_IMPL_A64__HVC_EX_exception(imm16)


/* SMC  #<imm> (ffe0001f/d4000003) */
//#define IEM_INSTR_IMPL_A64__SMC_EX_exception(imm16)


/* BRK  #<imm> (ffe0001f/d4200000) */
//#define IEM_INSTR_IMPL_A64__BRK_EX_exception(imm16)


/* HLT  #<imm> (ffe0001f/d4400000) */
//#define IEM_INSTR_IMPL_A64__HLT_EX_exception(imm16)


/* TCANCEL  #<imm> (ffe0001f/d4600000) */
//#define IEM_INSTR_IMPL_A64__TCANCEL_EX_exception(imm16)


/* DCPS1{  #<imm>} (ffe0001f/d4a00001) */
//#define IEM_INSTR_IMPL_A64__DCPS1_DC_exception(imm16)


/* DCPS2{  #<imm>} (ffe0001f/d4a00002) */
//#define IEM_INSTR_IMPL_A64__DCPS2_DC_exception(imm16)


/* DCPS3{  #<imm>} (ffe0001f/d4a00003) */
//#define IEM_INSTR_IMPL_A64__DCPS3_DC_exception(imm16)



/*
 *
 * Instruction Set & Groups: extract / dpimm / A64
 *
 */

/* EXTR  <Wd>, <Wn>, <Wm>, #<lsb> (ffe08000/13800000) */
//#define IEM_INSTR_IMPL_A64__EXTR_32_extract(Rd, Rn, imms, Rm)


/* EXTR  <Xd>, <Xn>, <Xm>, #<lsb> (ffe00000/93c00000) */
//#define IEM_INSTR_IMPL_A64__EXTR_64_extract(Rd, Rn, imms, Rm)



/*
 *
 * Instruction Set & Groups: float2fix / simd_dp / A64
 *
 */

/* SCVTF  <Sd>, <Wn>, #<fbits> (ffff0000/1e020000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_S32_float2fix(Rd, Rn, scale)


/* UCVTF  <Sd>, <Wn>, #<fbits> (ffff0000/1e030000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_S32_float2fix(Rd, Rn, scale)


/* FCVTZS  <Wd>, <Sn>, #<fbits> (ffff0000/1e180000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_32S_float2fix(Rd, Rn, scale)


/* FCVTZU  <Wd>, <Sn>, #<fbits> (ffff0000/1e190000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_32S_float2fix(Rd, Rn, scale)


/* SCVTF  <Dd>, <Wn>, #<fbits> (ffff0000/1e420000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_D32_float2fix(Rd, Rn, scale)


/* UCVTF  <Dd>, <Wn>, #<fbits> (ffff0000/1e430000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_D32_float2fix(Rd, Rn, scale)


/* FCVTZS  <Wd>, <Dn>, #<fbits> (ffff0000/1e580000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_32D_float2fix(Rd, Rn, scale)


/* FCVTZU  <Wd>, <Dn>, #<fbits> (ffff0000/1e590000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_32D_float2fix(Rd, Rn, scale)


/* SCVTF  <Hd>, <Wn>, #<fbits> (ffff0000/1ec20000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_H32_float2fix(Rd, Rn, scale)


/* UCVTF  <Hd>, <Wn>, #<fbits> (ffff0000/1ec30000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_H32_float2fix(Rd, Rn, scale)


/* FCVTZS  <Wd>, <Hn>, #<fbits> (ffff0000/1ed80000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_32H_float2fix(Rd, Rn, scale)


/* FCVTZU  <Wd>, <Hn>, #<fbits> (ffff0000/1ed90000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_32H_float2fix(Rd, Rn, scale)


/* SCVTF  <Sd>, <Xn>, #<fbits> (ffff0000/9e020000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_S64_float2fix(Rd, Rn, scale)


/* UCVTF  <Sd>, <Xn>, #<fbits> (ffff0000/9e030000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_S64_float2fix(Rd, Rn, scale)


/* FCVTZS  <Xd>, <Sn>, #<fbits> (ffff0000/9e180000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_64S_float2fix(Rd, Rn, scale)


/* FCVTZU  <Xd>, <Sn>, #<fbits> (ffff0000/9e190000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_64S_float2fix(Rd, Rn, scale)


/* SCVTF  <Dd>, <Xn>, #<fbits> (ffff0000/9e420000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_D64_float2fix(Rd, Rn, scale)


/* UCVTF  <Dd>, <Xn>, #<fbits> (ffff0000/9e430000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_D64_float2fix(Rd, Rn, scale)


/* FCVTZS  <Xd>, <Dn>, #<fbits> (ffff0000/9e580000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_64D_float2fix(Rd, Rn, scale)


/* FCVTZU  <Xd>, <Dn>, #<fbits> (ffff0000/9e590000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_64D_float2fix(Rd, Rn, scale)


/* SCVTF  <Hd>, <Xn>, #<fbits> (ffff0000/9ec20000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_H64_float2fix(Rd, Rn, scale)


/* UCVTF  <Hd>, <Xn>, #<fbits> (ffff0000/9ec30000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_H64_float2fix(Rd, Rn, scale)


/* FCVTZS  <Xd>, <Hn>, #<fbits> (ffff0000/9ed80000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_64H_float2fix(Rd, Rn, scale)


/* FCVTZU  <Xd>, <Hn>, #<fbits> (ffff0000/9ed90000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_64H_float2fix(Rd, Rn, scale)



/*
 *
 * Instruction Set & Groups: float2int / simd_dp / A64
 *
 */

/* FCVTNS  <Wd>, <Sn> (fffffc00/1e200000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_32S_float2int(Rd, Rn)


/* FCVTNU  <Wd>, <Sn> (fffffc00/1e210000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_32S_float2int(Rd, Rn)


/* SCVTF  <Sd>, <Wn> (fffffc00/1e220000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_S32_float2int(Rd, Rn)


/* UCVTF  <Sd>, <Wn> (fffffc00/1e230000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_S32_float2int(Rd, Rn)


/* FCVTAS  <Wd>, <Sn> (fffffc00/1e240000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_32S_float2int(Rd, Rn)


/* FCVTAU  <Wd>, <Sn> (fffffc00/1e250000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_32S_float2int(Rd, Rn)


/* FMOV  <Wd>, <Sn> (fffffc00/1e260000) */
//#define IEM_INSTR_IMPL_A64__FMOV_32S_float2int(Rd, Rn)


/* FMOV  <Sd>, <Wn> (fffffc00/1e270000) */
//#define IEM_INSTR_IMPL_A64__FMOV_S32_float2int(Rd, Rn)


/* FCVTPS  <Wd>, <Sn> (fffffc00/1e280000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_32S_float2int(Rd, Rn)


/* FCVTPU  <Wd>, <Sn> (fffffc00/1e290000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_32S_float2int(Rd, Rn)


/* FCVTMS  <Wd>, <Sn> (fffffc00/1e300000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_32S_float2int(Rd, Rn)


/* FCVTMU  <Wd>, <Sn> (fffffc00/1e310000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_32S_float2int(Rd, Rn)


/* FCVTZS  <Wd>, <Sn> (fffffc00/1e380000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_32S_float2int(Rd, Rn)


/* FCVTZU  <Wd>, <Sn> (fffffc00/1e390000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_32S_float2int(Rd, Rn)


/* FCVTNS  <Wd>, <Dn> (fffffc00/1e600000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_32D_float2int(Rd, Rn)


/* FCVTNU  <Wd>, <Dn> (fffffc00/1e610000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_32D_float2int(Rd, Rn)


/* SCVTF  <Dd>, <Wn> (fffffc00/1e620000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_D32_float2int(Rd, Rn)


/* UCVTF  <Dd>, <Wn> (fffffc00/1e630000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_D32_float2int(Rd, Rn)


/* FCVTAS  <Wd>, <Dn> (fffffc00/1e640000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_32D_float2int(Rd, Rn)


/* FCVTAU  <Wd>, <Dn> (fffffc00/1e650000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_32D_float2int(Rd, Rn)


/* FCVTPS  <Wd>, <Dn> (fffffc00/1e680000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_32D_float2int(Rd, Rn)


/* FCVTPU  <Wd>, <Dn> (fffffc00/1e690000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_32D_float2int(Rd, Rn)


/* FCVTMS  <Wd>, <Dn> (fffffc00/1e700000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_32D_float2int(Rd, Rn)


/* FCVTMU  <Wd>, <Dn> (fffffc00/1e710000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_32D_float2int(Rd, Rn)


/* FCVTZS  <Wd>, <Dn> (fffffc00/1e780000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_32D_float2int(Rd, Rn)


/* FCVTZU  <Wd>, <Dn> (fffffc00/1e790000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_32D_float2int(Rd, Rn)


/* FJCVTZS  <Wd>, <Dn> (fffffc00/1e7e0000) */
//#define IEM_INSTR_IMPL_A64__FJCVTZS_32D_float2int(Rd, Rn)


/* FCVTNS  <Wd>, <Hn> (fffffc00/1ee00000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_32H_float2int(Rd, Rn)


/* FCVTNU  <Wd>, <Hn> (fffffc00/1ee10000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_32H_float2int(Rd, Rn)


/* SCVTF  <Hd>, <Wn> (fffffc00/1ee20000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_H32_float2int(Rd, Rn)


/* UCVTF  <Hd>, <Wn> (fffffc00/1ee30000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_H32_float2int(Rd, Rn)


/* FCVTAS  <Wd>, <Hn> (fffffc00/1ee40000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_32H_float2int(Rd, Rn)


/* FCVTAU  <Wd>, <Hn> (fffffc00/1ee50000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_32H_float2int(Rd, Rn)


/* FMOV  <Wd>, <Hn> (fffffc00/1ee60000) */
//#define IEM_INSTR_IMPL_A64__FMOV_32H_float2int(Rd, Rn)


/* FMOV  <Hd>, <Wn> (fffffc00/1ee70000) */
//#define IEM_INSTR_IMPL_A64__FMOV_H32_float2int(Rd, Rn)


/* FCVTPS  <Wd>, <Hn> (fffffc00/1ee80000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_32H_float2int(Rd, Rn)


/* FCVTPU  <Wd>, <Hn> (fffffc00/1ee90000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_32H_float2int(Rd, Rn)


/* FCVTMS  <Wd>, <Hn> (fffffc00/1ef00000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_32H_float2int(Rd, Rn)


/* FCVTMU  <Wd>, <Hn> (fffffc00/1ef10000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_32H_float2int(Rd, Rn)


/* FCVTZS  <Wd>, <Hn> (fffffc00/1ef80000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_32H_float2int(Rd, Rn)


/* FCVTZU  <Wd>, <Hn> (fffffc00/1ef90000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_32H_float2int(Rd, Rn)


/* FCVTNS  <Xd>, <Sn> (fffffc00/9e200000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_64S_float2int(Rd, Rn)


/* FCVTNU  <Xd>, <Sn> (fffffc00/9e210000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_64S_float2int(Rd, Rn)


/* SCVTF  <Sd>, <Xn> (fffffc00/9e220000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_S64_float2int(Rd, Rn)


/* UCVTF  <Sd>, <Xn> (fffffc00/9e230000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_S64_float2int(Rd, Rn)


/* FCVTAS  <Xd>, <Sn> (fffffc00/9e240000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_64S_float2int(Rd, Rn)


/* FCVTAU  <Xd>, <Sn> (fffffc00/9e250000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_64S_float2int(Rd, Rn)


/* FCVTPS  <Xd>, <Sn> (fffffc00/9e280000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_64S_float2int(Rd, Rn)


/* FCVTPU  <Xd>, <Sn> (fffffc00/9e290000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_64S_float2int(Rd, Rn)


/* FCVTMS  <Xd>, <Sn> (fffffc00/9e300000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_64S_float2int(Rd, Rn)


/* FCVTMU  <Xd>, <Sn> (fffffc00/9e310000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_64S_float2int(Rd, Rn)


/* FCVTZS  <Xd>, <Sn> (fffffc00/9e380000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_64S_float2int(Rd, Rn)


/* FCVTZU  <Xd>, <Sn> (fffffc00/9e390000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_64S_float2int(Rd, Rn)


/* FCVTNS  <Xd>, <Dn> (fffffc00/9e600000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_64D_float2int(Rd, Rn)


/* FCVTNU  <Xd>, <Dn> (fffffc00/9e610000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_64D_float2int(Rd, Rn)


/* SCVTF  <Dd>, <Xn> (fffffc00/9e620000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_D64_float2int(Rd, Rn)


/* UCVTF  <Dd>, <Xn> (fffffc00/9e630000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_D64_float2int(Rd, Rn)


/* FCVTAS  <Xd>, <Dn> (fffffc00/9e640000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_64D_float2int(Rd, Rn)


/* FCVTAU  <Xd>, <Dn> (fffffc00/9e650000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_64D_float2int(Rd, Rn)


/* FMOV  <Xd>, <Dn> (fffffc00/9e660000) */
//#define IEM_INSTR_IMPL_A64__FMOV_64D_float2int(Rd, Rn)


/* FMOV  <Dd>, <Xn> (fffffc00/9e670000) */
//#define IEM_INSTR_IMPL_A64__FMOV_D64_float2int(Rd, Rn)


/* FCVTPS  <Xd>, <Dn> (fffffc00/9e680000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_64D_float2int(Rd, Rn)


/* FCVTPU  <Xd>, <Dn> (fffffc00/9e690000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_64D_float2int(Rd, Rn)


/* FCVTMS  <Xd>, <Dn> (fffffc00/9e700000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_64D_float2int(Rd, Rn)


/* FCVTMU  <Xd>, <Dn> (fffffc00/9e710000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_64D_float2int(Rd, Rn)


/* FCVTZS  <Xd>, <Dn> (fffffc00/9e780000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_64D_float2int(Rd, Rn)


/* FCVTZU  <Xd>, <Dn> (fffffc00/9e790000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_64D_float2int(Rd, Rn)


/* FMOV  <Xd>, <Vn>.D[1] (fffffc00/9eae0000) */
//#define IEM_INSTR_IMPL_A64__FMOV_64VX_float2int(Rd, Rn)


/* FMOV  <Vd>.D[1], <Xn> (fffffc00/9eaf0000) */
//#define IEM_INSTR_IMPL_A64__FMOV_V64I_float2int(Rd, Rn)


/* FCVTNS  <Xd>, <Hn> (fffffc00/9ee00000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_64H_float2int(Rd, Rn)


/* FCVTNU  <Xd>, <Hn> (fffffc00/9ee10000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_64H_float2int(Rd, Rn)


/* SCVTF  <Hd>, <Xn> (fffffc00/9ee20000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_H64_float2int(Rd, Rn)


/* UCVTF  <Hd>, <Xn> (fffffc00/9ee30000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_H64_float2int(Rd, Rn)


/* FCVTAS  <Xd>, <Hn> (fffffc00/9ee40000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_64H_float2int(Rd, Rn)


/* FCVTAU  <Xd>, <Hn> (fffffc00/9ee50000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_64H_float2int(Rd, Rn)


/* FMOV  <Xd>, <Hn> (fffffc00/9ee60000) */
//#define IEM_INSTR_IMPL_A64__FMOV_64H_float2int(Rd, Rn)


/* FMOV  <Hd>, <Xn> (fffffc00/9ee70000) */
//#define IEM_INSTR_IMPL_A64__FMOV_H64_float2int(Rd, Rn)


/* FCVTPS  <Xd>, <Hn> (fffffc00/9ee80000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_64H_float2int(Rd, Rn)


/* FCVTPU  <Xd>, <Hn> (fffffc00/9ee90000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_64H_float2int(Rd, Rn)


/* FCVTMS  <Xd>, <Hn> (fffffc00/9ef00000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_64H_float2int(Rd, Rn)


/* FCVTMU  <Xd>, <Hn> (fffffc00/9ef10000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_64H_float2int(Rd, Rn)


/* FCVTZS  <Xd>, <Hn> (fffffc00/9ef80000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_64H_float2int(Rd, Rn)


/* FCVTZU  <Xd>, <Hn> (fffffc00/9ef90000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_64H_float2int(Rd, Rn)


/* FCVTNS  <Sd>, <Dn> (fffffc00/1e6a0000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_sisd_32D(Rd, Rn)


/* FCVTAS  <Sd>, <Dn> (fffffc00/1e7a0000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_sisd_32D(Rd, Rn)


/* FCVTPS  <Sd>, <Dn> (fffffc00/1e720000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_sisd_32D(Rd, Rn)


/* FCVTMS  <Sd>, <Dn> (fffffc00/1e740000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_sisd_32D(Rd, Rn)


/* FCVTZS  <Sd>, <Dn> (fffffc00/1e760000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_sisd_32D(Rd, Rn)


/* SCVTF  <Dd>, <Sn> (fffffc00/1e7c0000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_sisd_32D(Rd, Rn)


/* FCVTNU  <Sd>, <Dn> (fffffc00/1e6b0000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_sisd_32D(Rd, Rn)


/* FCVTAU  <Sd>, <Dn> (fffffc00/1e7b0000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_sisd_32D(Rd, Rn)


/* FCVTPU  <Sd>, <Dn> (fffffc00/1e730000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_sisd_32D(Rd, Rn)


/* FCVTMU  <Sd>, <Dn> (fffffc00/1e750000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_sisd_32D(Rd, Rn)


/* FCVTZU  <Sd>, <Dn> (fffffc00/1e770000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_sisd_32D(Rd, Rn)


/* UCVTF  <Dd>, <Sn> (fffffc00/1e7d0000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_sisd_32D(Rd, Rn)


/* FCVTNS  <Sd>, <Hn> (fffffc00/1eea0000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_sisd_32H(Rd, Rn)


/* FCVTAS  <Sd>, <Hn> (fffffc00/1efa0000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_sisd_32H(Rd, Rn)


/* FCVTPS  <Sd>, <Hn> (fffffc00/1ef20000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_sisd_32H(Rd, Rn)


/* FCVTMS  <Sd>, <Hn> (fffffc00/1ef40000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_sisd_32H(Rd, Rn)


/* FCVTZS  <Sd>, <Hn> (fffffc00/1ef60000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_sisd_32H(Rd, Rn)


/* SCVTF  <Hd>, <Sn> (fffffc00/1efc0000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_sisd_32H(Rd, Rn)


/* FCVTNU  <Sd>, <Hn> (fffffc00/1eeb0000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_sisd_32H(Rd, Rn)


/* FCVTAU  <Sd>, <Hn> (fffffc00/1efb0000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_sisd_32H(Rd, Rn)


/* FCVTPU  <Sd>, <Hn> (fffffc00/1ef30000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_sisd_32H(Rd, Rn)


/* FCVTMU  <Sd>, <Hn> (fffffc00/1ef50000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_sisd_32H(Rd, Rn)


/* FCVTZU  <Sd>, <Hn> (fffffc00/1ef70000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_sisd_32H(Rd, Rn)


/* UCVTF  <Hd>, <Sn> (fffffc00/1efd0000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_sisd_32H(Rd, Rn)


/* FCVTNS  <Dd>, <Hn> (fffffc00/9eea0000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_sisd_64H(Rd, Rn)


/* FCVTAS  <Dd>, <Hn> (fffffc00/9efa0000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_sisd_64H(Rd, Rn)


/* FCVTPS  <Dd>, <Hn> (fffffc00/9ef20000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_sisd_64H(Rd, Rn)


/* FCVTMS  <Dd>, <Hn> (fffffc00/9ef40000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_sisd_64H(Rd, Rn)


/* FCVTZS  <Dd>, <Hn> (fffffc00/9ef60000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_sisd_64H(Rd, Rn)


/* SCVTF  <Hd>, <Dn> (fffffc00/9efc0000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_sisd_64H(Rd, Rn)


/* FCVTNU  <Dd>, <Hn> (fffffc00/9eeb0000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_sisd_64H(Rd, Rn)


/* FCVTAU  <Dd>, <Hn> (fffffc00/9efb0000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_sisd_64H(Rd, Rn)


/* FCVTPU  <Dd>, <Hn> (fffffc00/9ef30000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_sisd_64H(Rd, Rn)


/* FCVTMU  <Dd>, <Hn> (fffffc00/9ef50000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_sisd_64H(Rd, Rn)


/* FCVTZU  <Dd>, <Hn> (fffffc00/9ef70000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_sisd_64H(Rd, Rn)


/* UCVTF  <Hd>, <Dn> (fffffc00/9efd0000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_sisd_64H(Rd, Rn)


/* FCVTNS  <Dd>, <Sn> (fffffc00/9e2a0000) */
//#define IEM_INSTR_IMPL_A64__FCVTNS_sisd_64S(Rd, Rn)


/* FCVTAS  <Dd>, <Sn> (fffffc00/9e3a0000) */
//#define IEM_INSTR_IMPL_A64__FCVTAS_sisd_64S(Rd, Rn)


/* FCVTPS  <Dd>, <Sn> (fffffc00/9e320000) */
//#define IEM_INSTR_IMPL_A64__FCVTPS_sisd_64S(Rd, Rn)


/* FCVTMS  <Dd>, <Sn> (fffffc00/9e340000) */
//#define IEM_INSTR_IMPL_A64__FCVTMS_sisd_64S(Rd, Rn)


/* FCVTZS  <Dd>, <Sn> (fffffc00/9e360000) */
//#define IEM_INSTR_IMPL_A64__FCVTZS_sisd_64S(Rd, Rn)


/* SCVTF  <Sd>, <Dn> (fffffc00/9e3c0000) */
//#define IEM_INSTR_IMPL_A64__SCVTF_sisd_64S(Rd, Rn)


/* FCVTNU  <Dd>, <Sn> (fffffc00/9e2b0000) */
//#define IEM_INSTR_IMPL_A64__FCVTNU_sisd_64S(Rd, Rn)


/* FCVTAU  <Dd>, <Sn> (fffffc00/9e3b0000) */
//#define IEM_INSTR_IMPL_A64__FCVTAU_sisd_64S(Rd, Rn)


/* FCVTPU  <Dd>, <Sn> (fffffc00/9e330000) */
//#define IEM_INSTR_IMPL_A64__FCVTPU_sisd_64S(Rd, Rn)


/* FCVTMU  <Dd>, <Sn> (fffffc00/9e350000) */
//#define IEM_INSTR_IMPL_A64__FCVTMU_sisd_64S(Rd, Rn)


/* FCVTZU  <Dd>, <Sn> (fffffc00/9e370000) */
//#define IEM_INSTR_IMPL_A64__FCVTZU_sisd_64S(Rd, Rn)


/* UCVTF  <Sd>, <Dn> (fffffc00/9e3d0000) */
//#define IEM_INSTR_IMPL_A64__UCVTF_sisd_64S(Rd, Rn)



/*
 *
 * Instruction Set & Groups: floatccmp / simd_dp / A64
 *
 */

/* FCCMP  <Sn>, <Sm>, #<nzcv>, <cond> (ffe00c10/1e200400) */
//#define IEM_INSTR_IMPL_A64__FCCMP_S_floatccmp(nzcv, Rn, cond, Rm)


/* FCCMPE  <Sn>, <Sm>, #<nzcv>, <cond> (ffe00c10/1e200410) */
//#define IEM_INSTR_IMPL_A64__FCCMPE_S_floatccmp(nzcv, Rn, cond, Rm)


/* FCCMP  <Dn>, <Dm>, #<nzcv>, <cond> (ffe00c10/1e600400) */
//#define IEM_INSTR_IMPL_A64__FCCMP_D_floatccmp(nzcv, Rn, cond, Rm)


/* FCCMPE  <Dn>, <Dm>, #<nzcv>, <cond> (ffe00c10/1e600410) */
//#define IEM_INSTR_IMPL_A64__FCCMPE_D_floatccmp(nzcv, Rn, cond, Rm)


/* FCCMP  <Hn>, <Hm>, #<nzcv>, <cond> (ffe00c10/1ee00400) */
//#define IEM_INSTR_IMPL_A64__FCCMP_H_floatccmp(nzcv, Rn, cond, Rm)


/* FCCMPE  <Hn>, <Hm>, #<nzcv>, <cond> (ffe00c10/1ee00410) */
//#define IEM_INSTR_IMPL_A64__FCCMPE_H_floatccmp(nzcv, Rn, cond, Rm)



/*
 *
 * Instruction Set & Groups: floatcmp / simd_dp / A64
 *
 */

/* FCMP  <Sn>, <Sm> (ffe0fc1f/1e202000) */
//#define IEM_INSTR_IMPL_A64__FCMP_S_floatcmp(Rn, Rm)


/* FCMP  <Sn>, #0.0 (fffffc1f/1e202008) */
//#define IEM_INSTR_IMPL_A64__FCMP_SZ_floatcmp(Rn)


/* FCMPE  <Sn>, <Sm> (ffe0fc1f/1e202010) */
//#define IEM_INSTR_IMPL_A64__FCMPE_S_floatcmp(Rn, Rm)


/* FCMPE  <Sn>, #0.0 (fffffc1f/1e202018) */
//#define IEM_INSTR_IMPL_A64__FCMPE_SZ_floatcmp(Rn)


/* FCMP  <Dn>, <Dm> (ffe0fc1f/1e602000) */
//#define IEM_INSTR_IMPL_A64__FCMP_D_floatcmp(Rn, Rm)


/* FCMP  <Dn>, #0.0 (fffffc1f/1e602008) */
//#define IEM_INSTR_IMPL_A64__FCMP_DZ_floatcmp(Rn)


/* FCMPE  <Dn>, <Dm> (ffe0fc1f/1e602010) */
//#define IEM_INSTR_IMPL_A64__FCMPE_D_floatcmp(Rn, Rm)


/* FCMPE  <Dn>, #0.0 (fffffc1f/1e602018) */
//#define IEM_INSTR_IMPL_A64__FCMPE_DZ_floatcmp(Rn)


/* FCMP  <Hn>, <Hm> (ffe0fc1f/1ee02000) */
//#define IEM_INSTR_IMPL_A64__FCMP_H_floatcmp(Rn, Rm)


/* FCMP  <Hn>, #0.0 (fffffc1f/1ee02008) */
//#define IEM_INSTR_IMPL_A64__FCMP_HZ_floatcmp(Rn)


/* FCMPE  <Hn>, <Hm> (ffe0fc1f/1ee02010) */
//#define IEM_INSTR_IMPL_A64__FCMPE_H_floatcmp(Rn, Rm)


/* FCMPE  <Hn>, #0.0 (fffffc1f/1ee02018) */
//#define IEM_INSTR_IMPL_A64__FCMPE_HZ_floatcmp(Rn)



/*
 *
 * Instruction Set & Groups: floatdp1 / simd_dp / A64
 *
 */

/* FMOV  <Sd>, <Sn> (fffffc00/1e204000) */
//#define IEM_INSTR_IMPL_A64__FMOV_S_floatdp1(Rd, Rn)


/* FABS  <Sd>, <Sn> (fffffc00/1e20c000) */
//#define IEM_INSTR_IMPL_A64__FABS_S_floatdp1(Rd, Rn)


/* FNEG  <Sd>, <Sn> (fffffc00/1e214000) */
//#define IEM_INSTR_IMPL_A64__FNEG_S_floatdp1(Rd, Rn)


/* FSQRT  <Sd>, <Sn> (fffffc00/1e21c000) */
//#define IEM_INSTR_IMPL_A64__FSQRT_S_floatdp1(Rd, Rn)


/* FCVT  <Dd>, <Sn> (fffffc00/1e22c000) */
//#define IEM_INSTR_IMPL_A64__FCVT_DS_floatdp1(Rd, Rn)


/* FCVT  <Hd>, <Sn> (fffffc00/1e23c000) */
//#define IEM_INSTR_IMPL_A64__FCVT_HS_floatdp1(Rd, Rn)


/* FRINTN  <Sd>, <Sn> (fffffc00/1e244000) */
//#define IEM_INSTR_IMPL_A64__FRINTN_S_floatdp1(Rd, Rn)


/* FRINTP  <Sd>, <Sn> (fffffc00/1e24c000) */
//#define IEM_INSTR_IMPL_A64__FRINTP_S_floatdp1(Rd, Rn)


/* FRINTM  <Sd>, <Sn> (fffffc00/1e254000) */
//#define IEM_INSTR_IMPL_A64__FRINTM_S_floatdp1(Rd, Rn)


/* FRINTZ  <Sd>, <Sn> (fffffc00/1e25c000) */
//#define IEM_INSTR_IMPL_A64__FRINTZ_S_floatdp1(Rd, Rn)


/* FRINTA  <Sd>, <Sn> (fffffc00/1e264000) */
//#define IEM_INSTR_IMPL_A64__FRINTA_S_floatdp1(Rd, Rn)


/* FRINTX  <Sd>, <Sn> (fffffc00/1e274000) */
//#define IEM_INSTR_IMPL_A64__FRINTX_S_floatdp1(Rd, Rn)


/* FRINTI  <Sd>, <Sn> (fffffc00/1e27c000) */
//#define IEM_INSTR_IMPL_A64__FRINTI_S_floatdp1(Rd, Rn)


/* FRINT32Z  <Sd>, <Sn> (fffffc00/1e284000) */
//#define IEM_INSTR_IMPL_A64__FRINT32Z_S_floatdp1(Rd, Rn)


/* FRINT32X  <Sd>, <Sn> (fffffc00/1e28c000) */
//#define IEM_INSTR_IMPL_A64__FRINT32X_S_floatdp1(Rd, Rn)


/* FRINT64Z  <Sd>, <Sn> (fffffc00/1e294000) */
//#define IEM_INSTR_IMPL_A64__FRINT64Z_S_floatdp1(Rd, Rn)


/* FRINT64X  <Sd>, <Sn> (fffffc00/1e29c000) */
//#define IEM_INSTR_IMPL_A64__FRINT64X_S_floatdp1(Rd, Rn)


/* FMOV  <Dd>, <Dn> (fffffc00/1e604000) */
//#define IEM_INSTR_IMPL_A64__FMOV_D_floatdp1(Rd, Rn)


/* FABS  <Dd>, <Dn> (fffffc00/1e60c000) */
//#define IEM_INSTR_IMPL_A64__FABS_D_floatdp1(Rd, Rn)


/* FNEG  <Dd>, <Dn> (fffffc00/1e614000) */
//#define IEM_INSTR_IMPL_A64__FNEG_D_floatdp1(Rd, Rn)


/* FSQRT  <Dd>, <Dn> (fffffc00/1e61c000) */
//#define IEM_INSTR_IMPL_A64__FSQRT_D_floatdp1(Rd, Rn)


/* FCVT  <Sd>, <Dn> (fffffc00/1e624000) */
//#define IEM_INSTR_IMPL_A64__FCVT_SD_floatdp1(Rd, Rn)


/* BFCVT  <Hd>, <Sn> (fffffc00/1e634000) */
//#define IEM_INSTR_IMPL_A64__BFCVT_BS_floatdp1(Rd, Rn)


/* FCVT  <Hd>, <Dn> (fffffc00/1e63c000) */
//#define IEM_INSTR_IMPL_A64__FCVT_HD_floatdp1(Rd, Rn)


/* FRINTN  <Dd>, <Dn> (fffffc00/1e644000) */
//#define IEM_INSTR_IMPL_A64__FRINTN_D_floatdp1(Rd, Rn)


/* FRINTP  <Dd>, <Dn> (fffffc00/1e64c000) */
//#define IEM_INSTR_IMPL_A64__FRINTP_D_floatdp1(Rd, Rn)


/* FRINTM  <Dd>, <Dn> (fffffc00/1e654000) */
//#define IEM_INSTR_IMPL_A64__FRINTM_D_floatdp1(Rd, Rn)


/* FRINTZ  <Dd>, <Dn> (fffffc00/1e65c000) */
//#define IEM_INSTR_IMPL_A64__FRINTZ_D_floatdp1(Rd, Rn)


/* FRINTA  <Dd>, <Dn> (fffffc00/1e664000) */
//#define IEM_INSTR_IMPL_A64__FRINTA_D_floatdp1(Rd, Rn)


/* FRINTX  <Dd>, <Dn> (fffffc00/1e674000) */
//#define IEM_INSTR_IMPL_A64__FRINTX_D_floatdp1(Rd, Rn)


/* FRINTI  <Dd>, <Dn> (fffffc00/1e67c000) */
//#define IEM_INSTR_IMPL_A64__FRINTI_D_floatdp1(Rd, Rn)


/* FRINT32Z  <Dd>, <Dn> (fffffc00/1e684000) */
//#define IEM_INSTR_IMPL_A64__FRINT32Z_D_floatdp1(Rd, Rn)


/* FRINT32X  <Dd>, <Dn> (fffffc00/1e68c000) */
//#define IEM_INSTR_IMPL_A64__FRINT32X_D_floatdp1(Rd, Rn)


/* FRINT64Z  <Dd>, <Dn> (fffffc00/1e694000) */
//#define IEM_INSTR_IMPL_A64__FRINT64Z_D_floatdp1(Rd, Rn)


/* FRINT64X  <Dd>, <Dn> (fffffc00/1e69c000) */
//#define IEM_INSTR_IMPL_A64__FRINT64X_D_floatdp1(Rd, Rn)


/* FMOV  <Hd>, <Hn> (fffffc00/1ee04000) */
//#define IEM_INSTR_IMPL_A64__FMOV_H_floatdp1(Rd, Rn)


/* FABS  <Hd>, <Hn> (fffffc00/1ee0c000) */
//#define IEM_INSTR_IMPL_A64__FABS_H_floatdp1(Rd, Rn)


/* FNEG  <Hd>, <Hn> (fffffc00/1ee14000) */
//#define IEM_INSTR_IMPL_A64__FNEG_H_floatdp1(Rd, Rn)


/* FSQRT  <Hd>, <Hn> (fffffc00/1ee1c000) */
//#define IEM_INSTR_IMPL_A64__FSQRT_H_floatdp1(Rd, Rn)


/* FCVT  <Sd>, <Hn> (fffffc00/1ee24000) */
//#define IEM_INSTR_IMPL_A64__FCVT_SH_floatdp1(Rd, Rn)


/* FCVT  <Dd>, <Hn> (fffffc00/1ee2c000) */
//#define IEM_INSTR_IMPL_A64__FCVT_DH_floatdp1(Rd, Rn)


/* FRINTN  <Hd>, <Hn> (fffffc00/1ee44000) */
//#define IEM_INSTR_IMPL_A64__FRINTN_H_floatdp1(Rd, Rn)


/* FRINTP  <Hd>, <Hn> (fffffc00/1ee4c000) */
//#define IEM_INSTR_IMPL_A64__FRINTP_H_floatdp1(Rd, Rn)


/* FRINTM  <Hd>, <Hn> (fffffc00/1ee54000) */
//#define IEM_INSTR_IMPL_A64__FRINTM_H_floatdp1(Rd, Rn)


/* FRINTZ  <Hd>, <Hn> (fffffc00/1ee5c000) */
//#define IEM_INSTR_IMPL_A64__FRINTZ_H_floatdp1(Rd, Rn)


/* FRINTA  <Hd>, <Hn> (fffffc00/1ee64000) */
//#define IEM_INSTR_IMPL_A64__FRINTA_H_floatdp1(Rd, Rn)


/* FRINTX  <Hd>, <Hn> (fffffc00/1ee74000) */
//#define IEM_INSTR_IMPL_A64__FRINTX_H_floatdp1(Rd, Rn)


/* FRINTI  <Hd>, <Hn> (fffffc00/1ee7c000) */
//#define IEM_INSTR_IMPL_A64__FRINTI_H_floatdp1(Rd, Rn)



/*
 *
 * Instruction Set & Groups: floatdp2 / simd_dp / A64
 *
 */

/* FMUL  <Sd>, <Sn>, <Sm> (ffe0fc00/1e200800) */
//#define IEM_INSTR_IMPL_A64__FMUL_S_floatdp2(Rd, Rn, Rm)


/* FDIV  <Sd>, <Sn>, <Sm> (ffe0fc00/1e201800) */
//#define IEM_INSTR_IMPL_A64__FDIV_S_floatdp2(Rd, Rn, Rm)


/* FADD  <Sd>, <Sn>, <Sm> (ffe0fc00/1e202800) */
//#define IEM_INSTR_IMPL_A64__FADD_S_floatdp2(Rd, Rn, Rm)


/* FSUB  <Sd>, <Sn>, <Sm> (ffe0fc00/1e203800) */
//#define IEM_INSTR_IMPL_A64__FSUB_S_floatdp2(Rd, Rn, Rm)


/* FMAX  <Sd>, <Sn>, <Sm> (ffe0fc00/1e204800) */
//#define IEM_INSTR_IMPL_A64__FMAX_S_floatdp2(Rd, Rn, Rm)


/* FMIN  <Sd>, <Sn>, <Sm> (ffe0fc00/1e205800) */
//#define IEM_INSTR_IMPL_A64__FMIN_S_floatdp2(Rd, Rn, Rm)


/* FMAXNM  <Sd>, <Sn>, <Sm> (ffe0fc00/1e206800) */
//#define IEM_INSTR_IMPL_A64__FMAXNM_S_floatdp2(Rd, Rn, Rm)


/* FMINNM  <Sd>, <Sn>, <Sm> (ffe0fc00/1e207800) */
//#define IEM_INSTR_IMPL_A64__FMINNM_S_floatdp2(Rd, Rn, Rm)


/* FNMUL  <Sd>, <Sn>, <Sm> (ffe0fc00/1e208800) */
//#define IEM_INSTR_IMPL_A64__FNMUL_S_floatdp2(Rd, Rn, Rm)


/* FMUL  <Dd>, <Dn>, <Dm> (ffe0fc00/1e600800) */
//#define IEM_INSTR_IMPL_A64__FMUL_D_floatdp2(Rd, Rn, Rm)


/* FDIV  <Dd>, <Dn>, <Dm> (ffe0fc00/1e601800) */
//#define IEM_INSTR_IMPL_A64__FDIV_D_floatdp2(Rd, Rn, Rm)


/* FADD  <Dd>, <Dn>, <Dm> (ffe0fc00/1e602800) */
//#define IEM_INSTR_IMPL_A64__FADD_D_floatdp2(Rd, Rn, Rm)


/* FSUB  <Dd>, <Dn>, <Dm> (ffe0fc00/1e603800) */
//#define IEM_INSTR_IMPL_A64__FSUB_D_floatdp2(Rd, Rn, Rm)


/* FMAX  <Dd>, <Dn>, <Dm> (ffe0fc00/1e604800) */
//#define IEM_INSTR_IMPL_A64__FMAX_D_floatdp2(Rd, Rn, Rm)


/* FMIN  <Dd>, <Dn>, <Dm> (ffe0fc00/1e605800) */
//#define IEM_INSTR_IMPL_A64__FMIN_D_floatdp2(Rd, Rn, Rm)


/* FMAXNM  <Dd>, <Dn>, <Dm> (ffe0fc00/1e606800) */
//#define IEM_INSTR_IMPL_A64__FMAXNM_D_floatdp2(Rd, Rn, Rm)


/* FMINNM  <Dd>, <Dn>, <Dm> (ffe0fc00/1e607800) */
//#define IEM_INSTR_IMPL_A64__FMINNM_D_floatdp2(Rd, Rn, Rm)


/* FNMUL  <Dd>, <Dn>, <Dm> (ffe0fc00/1e608800) */
//#define IEM_INSTR_IMPL_A64__FNMUL_D_floatdp2(Rd, Rn, Rm)


/* FMUL  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee00800) */
//#define IEM_INSTR_IMPL_A64__FMUL_H_floatdp2(Rd, Rn, Rm)


/* FDIV  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee01800) */
//#define IEM_INSTR_IMPL_A64__FDIV_H_floatdp2(Rd, Rn, Rm)


/* FADD  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee02800) */
//#define IEM_INSTR_IMPL_A64__FADD_H_floatdp2(Rd, Rn, Rm)


/* FSUB  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee03800) */
//#define IEM_INSTR_IMPL_A64__FSUB_H_floatdp2(Rd, Rn, Rm)


/* FMAX  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee04800) */
//#define IEM_INSTR_IMPL_A64__FMAX_H_floatdp2(Rd, Rn, Rm)


/* FMIN  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee05800) */
//#define IEM_INSTR_IMPL_A64__FMIN_H_floatdp2(Rd, Rn, Rm)


/* FMAXNM  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee06800) */
//#define IEM_INSTR_IMPL_A64__FMAXNM_H_floatdp2(Rd, Rn, Rm)


/* FMINNM  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee07800) */
//#define IEM_INSTR_IMPL_A64__FMINNM_H_floatdp2(Rd, Rn, Rm)


/* FNMUL  <Hd>, <Hn>, <Hm> (ffe0fc00/1ee08800) */
//#define IEM_INSTR_IMPL_A64__FNMUL_H_floatdp2(Rd, Rn, Rm)



/*
 *
 * Instruction Set & Groups: floatdp3 / simd_dp / A64
 *
 */

/* FMADD  <Sd>, <Sn>, <Sm>, <Sa> (ffe08000/1f000000) */
//#define IEM_INSTR_IMPL_A64__FMADD_S_floatdp3(Rd, Rn, Ra, Rm)


/* FMSUB  <Sd>, <Sn>, <Sm>, <Sa> (ffe08000/1f008000) */
//#define IEM_INSTR_IMPL_A64__FMSUB_S_floatdp3(Rd, Rn, Ra, Rm)


/* FNMADD  <Sd>, <Sn>, <Sm>, <Sa> (ffe08000/1f200000) */
//#define IEM_INSTR_IMPL_A64__FNMADD_S_floatdp3(Rd, Rn, Ra, Rm)


/* FNMSUB  <Sd>, <Sn>, <Sm>, <Sa> (ffe08000/1f208000) */
//#define IEM_INSTR_IMPL_A64__FNMSUB_S_floatdp3(Rd, Rn, Ra, Rm)


/* FMADD  <Dd>, <Dn>, <Dm>, <Da> (ffe08000/1f400000) */
//#define IEM_INSTR_IMPL_A64__FMADD_D_floatdp3(Rd, Rn, Ra, Rm)


/* FMSUB  <Dd>, <Dn>, <Dm>, <Da> (ffe08000/1f408000) */
//#define IEM_INSTR_IMPL_A64__FMSUB_D_floatdp3(Rd, Rn, Ra, Rm)


/* FNMADD  <Dd>, <Dn>, <Dm>, <Da> (ffe08000/1f600000) */
//#define IEM_INSTR_IMPL_A64__FNMADD_D_floatdp3(Rd, Rn, Ra, Rm)


/* FNMSUB  <Dd>, <Dn>, <Dm>, <Da> (ffe08000/1f608000) */
//#define IEM_INSTR_IMPL_A64__FNMSUB_D_floatdp3(Rd, Rn, Ra, Rm)


/* FMADD  <Hd>, <Hn>, <Hm>, <Ha> (ffe08000/1fc00000) */
//#define IEM_INSTR_IMPL_A64__FMADD_H_floatdp3(Rd, Rn, Ra, Rm)


/* FMSUB  <Hd>, <Hn>, <Hm>, <Ha> (ffe08000/1fc08000) */
//#define IEM_INSTR_IMPL_A64__FMSUB_H_floatdp3(Rd, Rn, Ra, Rm)


/* FNMADD  <Hd>, <Hn>, <Hm>, <Ha> (ffe08000/1fe00000) */
//#define IEM_INSTR_IMPL_A64__FNMADD_H_floatdp3(Rd, Rn, Ra, Rm)


/* FNMSUB  <Hd>, <Hn>, <Hm>, <Ha> (ffe08000/1fe08000) */
//#define IEM_INSTR_IMPL_A64__FNMSUB_H_floatdp3(Rd, Rn, Ra, Rm)



/*
 *
 * Instruction Set & Groups: floatimm / simd_dp / A64
 *
 */

/* FMOV  <Sd>, #<imm> (ffe01fe0/1e201000) */
//#define IEM_INSTR_IMPL_A64__FMOV_S_floatimm(Rd, imm8)


/* FMOV  <Dd>, #<imm> (ffe01fe0/1e601000) */
//#define IEM_INSTR_IMPL_A64__FMOV_D_floatimm(Rd, imm8)


/* FMOV  <Hd>, #<imm> (ffe01fe0/1ee01000) */
//#define IEM_INSTR_IMPL_A64__FMOV_H_floatimm(Rd, imm8)



/*
 *
 * Instruction Set & Groups: floatsel / simd_dp / A64
 *
 */

/* FCSEL  <Sd>, <Sn>, <Sm>, <cond> (ffe00c00/1e200c00) */
//#define IEM_INSTR_IMPL_A64__FCSEL_S_floatsel(Rd, Rn, cond, Rm)


/* FCSEL  <Dd>, <Dn>, <Dm>, <cond> (ffe00c00/1e600c00) */
//#define IEM_INSTR_IMPL_A64__FCSEL_D_floatsel(Rd, Rn, cond, Rm)


/* FCSEL  <Hd>, <Hn>, <Hm>, <cond> (ffe00c00/1ee00c00) */
//#define IEM_INSTR_IMPL_A64__FCSEL_H_floatsel(Rd, Rn, cond, Rm)



/*
 *
 * Instruction Set & Groups: hints / control / A64
 *
 */

/* HINT  #<imm> (fffff01f/d503201f) */
//#define IEM_INSTR_IMPL_A64__HINT_HM_hints(op2, CRm)


/* NOP (ffffffff/d503201f) */
//#define IEM_INSTR_IMPL_A64__NOP_HI_hints()


/* YIELD (ffffffff/d503203f) */
//#define IEM_INSTR_IMPL_A64__YIELD_HI_hints()


/* WFE (ffffffff/d503205f) */
//#define IEM_INSTR_IMPL_A64__WFE_HI_hints()


/* WFI (ffffffff/d503207f) */
//#define IEM_INSTR_IMPL_A64__WFI_HI_hints()


/* SEV (ffffffff/d503209f) */
//#define IEM_INSTR_IMPL_A64__SEV_HI_hints()


/* SEVL (ffffffff/d50320bf) */
//#define IEM_INSTR_IMPL_A64__SEVL_HI_hints()


/* DGH (ffffffff/d50320df) */
//#define IEM_INSTR_IMPL_A64__DGH_HI_hints()


/* XPACLRI (ffffffff/d50320ff) */
//#define IEM_INSTR_IMPL_A64__XPACLRI_HI_hints()


/* PACIA1716 (ffffffff/d503211f) */
//#define IEM_INSTR_IMPL_A64__PACIA1716_HI_hints()


/* PACIB1716 (ffffffff/d503215f) */
//#define IEM_INSTR_IMPL_A64__PACIB1716_HI_hints()


/* AUTIA1716 (ffffffff/d503219f) */
//#define IEM_INSTR_IMPL_A64__AUTIA1716_HI_hints()


/* AUTIB1716 (ffffffff/d50321df) */
//#define IEM_INSTR_IMPL_A64__AUTIB1716_HI_hints()


/* ESB (ffffffff/d503221f) */
//#define IEM_INSTR_IMPL_A64__ESB_HI_hints()


/* PSB  CSYNC (ffffffff/d503223f) */
//#define IEM_INSTR_IMPL_A64__PSB_HC_hints()


/* TSB  CSYNC (ffffffff/d503225f) */
//#define IEM_INSTR_IMPL_A64__TSB_HC_hints()


/* GCSB  DSYNC (ffffffff/d503227f) */
//#define IEM_INSTR_IMPL_A64__GCSB_HD_hints()


/* CSDB (ffffffff/d503229f) */
//#define IEM_INSTR_IMPL_A64__CSDB_HI_hints()


/* CLRBHB (ffffffff/d50322df) */
//#define IEM_INSTR_IMPL_A64__CLRBHB_HI_hints()


/* PACIAZ (ffffffff/d503231f) */
//#define IEM_INSTR_IMPL_A64__PACIAZ_HI_hints()


/* PACIASP (ffffffff/d503233f) */
//#define IEM_INSTR_IMPL_A64__PACIASP_HI_hints()


/* PACIBZ (ffffffff/d503235f) */
//#define IEM_INSTR_IMPL_A64__PACIBZ_HI_hints()


/* PACIBSP (ffffffff/d503237f) */
//#define IEM_INSTR_IMPL_A64__PACIBSP_HI_hints()


/* AUTIAZ (ffffffff/d503239f) */
//#define IEM_INSTR_IMPL_A64__AUTIAZ_HI_hints()


/* AUTIASP (ffffffff/d50323bf) */
//#define IEM_INSTR_IMPL_A64__AUTIASP_HI_hints()


/* AUTIBZ (ffffffff/d50323df) */
//#define IEM_INSTR_IMPL_A64__AUTIBZ_HI_hints()


/* AUTIBSP (ffffffff/d50323ff) */
//#define IEM_INSTR_IMPL_A64__AUTIBSP_HI_hints()


/* BTI{  <targets>} (ffffff1f/d503241f) */
//#define IEM_INSTR_IMPL_A64__BTI_HB_hints(op2)


/* PACM (ffffffff/d50324ff) */
//#define IEM_INSTR_IMPL_A64__PACM_HI_hints()


/* CHKFEAT  X16 (ffffffff/d503251f) */
//#define IEM_INSTR_IMPL_A64__CHKFEAT_HF_hints()


/* STSHH  <policy> (ffffff1f/d503261f) */
//#define IEM_INSTR_IMPL_A64__STSHH_HI_hints(op2)



/*
 *
 * Instruction Set & Groups: ldapstl_simd / ldst / A64
 *
 */

/* STLUR  <Bt>, [<Xn|SP>{, #<simm>}] (ffe00c00/1d000800) */
//#define IEM_INSTR_IMPL_A64__STLUR_B_ldapstl_simd(Rt, Rn, imm9)


/* LDAPUR  <Bt>, [<Xn|SP>{, #<simm>}] (ffe00c00/1d400800) */
//#define IEM_INSTR_IMPL_A64__LDAPUR_B_ldapstl_simd(Rt, Rn, imm9)


/* STLUR  <Qt>, [<Xn|SP>{, #<simm>}] (ffe00c00/1d800800) */
//#define IEM_INSTR_IMPL_A64__STLUR_Q_ldapstl_simd(Rt, Rn, imm9)


/* LDAPUR  <Qt>, [<Xn|SP>{, #<simm>}] (ffe00c00/1dc00800) */
//#define IEM_INSTR_IMPL_A64__LDAPUR_Q_ldapstl_simd(Rt, Rn, imm9)


/* STLUR  <Ht>, [<Xn|SP>{, #<simm>}] (ffe00c00/5d000800) */
//#define IEM_INSTR_IMPL_A64__STLUR_H_ldapstl_simd(Rt, Rn, imm9)


/* LDAPUR  <Ht>, [<Xn|SP>{, #<simm>}] (ffe00c00/5d400800) */
//#define IEM_INSTR_IMPL_A64__LDAPUR_H_ldapstl_simd(Rt, Rn, imm9)


/* STLUR  <St>, [<Xn|SP>{, #<simm>}] (ffe00c00/9d000800) */
//#define IEM_INSTR_IMPL_A64__STLUR_S_ldapstl_simd(Rt, Rn, imm9)


/* LDAPUR  <St>, [<Xn|SP>{, #<simm>}] (ffe00c00/9d400800) */
//#define IEM_INSTR_IMPL_A64__LDAPUR_S_ldapstl_simd(Rt, Rn, imm9)


/* STLUR  <Dt>, [<Xn|SP>{, #<simm>}] (ffe00c00/dd000800) */
//#define IEM_INSTR_IMPL_A64__STLUR_D_ldapstl_simd(Rt, Rn, imm9)


/* LDAPUR  <Dt>, [<Xn|SP>{, #<simm>}] (ffe00c00/dd400800) */
//#define IEM_INSTR_IMPL_A64__LDAPUR_D_ldapstl_simd(Rt, Rn, imm9)



/*
 *
 * Instruction Set & Groups: ldapstl_unscaled / ldst / A64
 *
 */

/* STLURB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/19000000) */
//#define IEM_INSTR_IMPL_A64__STLURB_32_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPURB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/19400000) */
//#define IEM_INSTR_IMPL_A64__LDAPURB_32_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPURSB  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/19800000) */
//#define IEM_INSTR_IMPL_A64__LDAPURSB_64_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPURSB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/19c00000) */
//#define IEM_INSTR_IMPL_A64__LDAPURSB_32_ldapstl_unscaled(Rt, Rn, imm9)


/* STLURH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/59000000) */
//#define IEM_INSTR_IMPL_A64__STLURH_32_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPURH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/59400000) */
//#define IEM_INSTR_IMPL_A64__LDAPURH_32_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPURSH  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/59800000) */
//#define IEM_INSTR_IMPL_A64__LDAPURSH_64_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPURSH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/59c00000) */
//#define IEM_INSTR_IMPL_A64__LDAPURSH_32_ldapstl_unscaled(Rt, Rn, imm9)


/* STLUR  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/99000000) */
//#define IEM_INSTR_IMPL_A64__STLUR_32_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPUR  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/99400000) */
//#define IEM_INSTR_IMPL_A64__LDAPUR_32_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPURSW  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/99800000) */
//#define IEM_INSTR_IMPL_A64__LDAPURSW_64_ldapstl_unscaled(Rt, Rn, imm9)


/* STLUR  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/d9000000) */
//#define IEM_INSTR_IMPL_A64__STLUR_64_ldapstl_unscaled(Rt, Rn, imm9)


/* LDAPUR  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/d9400000) */
//#define IEM_INSTR_IMPL_A64__LDAPUR_64_ldapstl_unscaled(Rt, Rn, imm9)



/*
 *
 * Instruction Set & Groups: ldapstl_writeback / ldst / A64
 *
 */

/* STLR  <Wt>, [<Xn|SP>, #-4]! (fffffc00/99800800) */
//#define IEM_INSTR_IMPL_A64__STLR_32S_ldapstl_writeback(Rt, Rn)


/* LDAPR  <Wt>, [<Xn|SP>], #4 (fffffc00/99c00800) */
//#define IEM_INSTR_IMPL_A64__LDAPR_32L_ldapstl_writeback(Rt, Rn)


/* STLR  <Xt>, [<Xn|SP>, #-8]! (fffffc00/d9800800) */
//#define IEM_INSTR_IMPL_A64__STLR_64S_ldapstl_writeback(Rt, Rn)


/* LDAPR  <Xt>, [<Xn|SP>], #8 (fffffc00/d9c00800) */
//#define IEM_INSTR_IMPL_A64__LDAPR_64L_ldapstl_writeback(Rt, Rn)



/*
 *
 * Instruction Set & Groups: ldiappstilp / ldst / A64
 *
 */

/* STILP  <Wt1>, <Wt2>, [<Xn|SP>, #-8]! (ffe0fc00/99000800) */
//#define IEM_INSTR_IMPL_A64__STILP_32SE_ldiappstilp(Rt, Rn, Rt2)


/* STILP  <Wt1>, <Wt2>, [<Xn|SP>] (ffe0fc00/99001800) */
//#define IEM_INSTR_IMPL_A64__STILP_32S_ldiappstilp(Rt, Rn, Rt2)


/* LDIAPP  <Wt1>, <Wt2>, [<Xn|SP>], #8 (ffe0fc00/99400800) */
//#define IEM_INSTR_IMPL_A64__LDIAPP_32LE_ldiappstilp(Rt, Rn, Rt2)


/* LDIAPP  <Wt1>, <Wt2>, [<Xn|SP>] (ffe0fc00/99401800) */
//#define IEM_INSTR_IMPL_A64__LDIAPP_32L_ldiappstilp(Rt, Rn, Rt2)


/* STILP  <Xt1>, <Xt2>, [<Xn|SP>, #-16]! (ffe0fc00/d9000800) */
//#define IEM_INSTR_IMPL_A64__STILP_64SS_ldiappstilp(Rt, Rn, Rt2)


/* STILP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/d9001800) */
//#define IEM_INSTR_IMPL_A64__STILP_64S_ldiappstilp(Rt, Rn, Rt2)


/* LDIAPP  <Xt1>, <Xt2>, [<Xn|SP>], #16 (ffe0fc00/d9400800) */
//#define IEM_INSTR_IMPL_A64__LDIAPP_64LS_ldiappstilp(Rt, Rn, Rt2)


/* LDIAPP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/d9401800) */
//#define IEM_INSTR_IMPL_A64__LDIAPP_64L_ldiappstilp(Rt, Rn, Rt2)



/*
 *
 * Instruction Set & Groups: ldst_gcs / ldst / A64
 *
 */

/* GCSSTR  <Xt>, [<Xn|SP>] (fffffc00/d91f0c00) */
//#define IEM_INSTR_IMPL_A64__GCSSTR_64_ldst_gcs(Rt, Rn)


/* GCSSTTR  <Xt>, [<Xn|SP>] (fffffc00/d91f1c00) */
//#define IEM_INSTR_IMPL_A64__GCSSTTR_64_ldst_gcs(Rt, Rn)



/*
 *
 * Instruction Set & Groups: ldst_immpost / ldst / A64
 *
 */

/* STRB  <Wt>, [<Xn|SP>], #<simm> (ffe00c00/38000400) */
//#define IEM_INSTR_IMPL_A64__STRB_32_ldst_immpost(Rt, Rn, imm9)


/* LDRB  <Wt>, [<Xn|SP>], #<simm> (ffe00c00/38400400) */
//#define IEM_INSTR_IMPL_A64__LDRB_32_ldst_immpost(Rt, Rn, imm9)


/* LDRSB  <Xt>, [<Xn|SP>], #<simm> (ffe00c00/38800400) */
//#define IEM_INSTR_IMPL_A64__LDRSB_64_ldst_immpost(Rt, Rn, imm9)


/* LDRSB  <Wt>, [<Xn|SP>], #<simm> (ffe00c00/38c00400) */
//#define IEM_INSTR_IMPL_A64__LDRSB_32_ldst_immpost(Rt, Rn, imm9)


/* STR  <Bt>, [<Xn|SP>], #<simm> (ffe00c00/3c000400) */
//#define IEM_INSTR_IMPL_A64__STR_B_ldst_immpost(Rt, Rn, imm9)


/* LDR  <Bt>, [<Xn|SP>], #<simm> (ffe00c00/3c400400) */
//#define IEM_INSTR_IMPL_A64__LDR_B_ldst_immpost(Rt, Rn, imm9)


/* STR  <Qt>, [<Xn|SP>], #<simm> (ffe00c00/3c800400) */
//#define IEM_INSTR_IMPL_A64__STR_Q_ldst_immpost(Rt, Rn, imm9)


/* LDR  <Qt>, [<Xn|SP>], #<simm> (ffe00c00/3cc00400) */
//#define IEM_INSTR_IMPL_A64__LDR_Q_ldst_immpost(Rt, Rn, imm9)


/* STRH  <Wt>, [<Xn|SP>], #<simm> (ffe00c00/78000400) */
//#define IEM_INSTR_IMPL_A64__STRH_32_ldst_immpost(Rt, Rn, imm9)


/* LDRH  <Wt>, [<Xn|SP>], #<simm> (ffe00c00/78400400) */
//#define IEM_INSTR_IMPL_A64__LDRH_32_ldst_immpost(Rt, Rn, imm9)


/* LDRSH  <Xt>, [<Xn|SP>], #<simm> (ffe00c00/78800400) */
//#define IEM_INSTR_IMPL_A64__LDRSH_64_ldst_immpost(Rt, Rn, imm9)


/* LDRSH  <Wt>, [<Xn|SP>], #<simm> (ffe00c00/78c00400) */
//#define IEM_INSTR_IMPL_A64__LDRSH_32_ldst_immpost(Rt, Rn, imm9)


/* STR  <Ht>, [<Xn|SP>], #<simm> (ffe00c00/7c000400) */
//#define IEM_INSTR_IMPL_A64__STR_H_ldst_immpost(Rt, Rn, imm9)


/* LDR  <Ht>, [<Xn|SP>], #<simm> (ffe00c00/7c400400) */
//#define IEM_INSTR_IMPL_A64__LDR_H_ldst_immpost(Rt, Rn, imm9)


/* STR  <Wt>, [<Xn|SP>], #<simm> (ffe00c00/b8000400) */
//#define IEM_INSTR_IMPL_A64__STR_32_ldst_immpost(Rt, Rn, imm9)


/* LDR  <Wt>, [<Xn|SP>], #<simm> (ffe00c00/b8400400) */
//#define IEM_INSTR_IMPL_A64__LDR_32_ldst_immpost(Rt, Rn, imm9)


/* LDRSW  <Xt>, [<Xn|SP>], #<simm> (ffe00c00/b8800400) */
//#define IEM_INSTR_IMPL_A64__LDRSW_64_ldst_immpost(Rt, Rn, imm9)


/* STR  <St>, [<Xn|SP>], #<simm> (ffe00c00/bc000400) */
//#define IEM_INSTR_IMPL_A64__STR_S_ldst_immpost(Rt, Rn, imm9)


/* LDR  <St>, [<Xn|SP>], #<simm> (ffe00c00/bc400400) */
//#define IEM_INSTR_IMPL_A64__LDR_S_ldst_immpost(Rt, Rn, imm9)


/* STR  <Xt>, [<Xn|SP>], #<simm> (ffe00c00/f8000400) */
//#define IEM_INSTR_IMPL_A64__STR_64_ldst_immpost(Rt, Rn, imm9)


/* LDR  <Xt>, [<Xn|SP>], #<simm> (ffe00c00/f8400400) */
//#define IEM_INSTR_IMPL_A64__LDR_64_ldst_immpost(Rt, Rn, imm9)


/* STR  <Dt>, [<Xn|SP>], #<simm> (ffe00c00/fc000400) */
//#define IEM_INSTR_IMPL_A64__STR_D_ldst_immpost(Rt, Rn, imm9)


/* LDR  <Dt>, [<Xn|SP>], #<simm> (ffe00c00/fc400400) */
//#define IEM_INSTR_IMPL_A64__LDR_D_ldst_immpost(Rt, Rn, imm9)



/*
 *
 * Instruction Set & Groups: ldst_immpre / ldst / A64
 *
 */

/* STRB  <Wt>, [<Xn|SP>, #<simm>]! (ffe00c00/38000c00) */
//#define IEM_INSTR_IMPL_A64__STRB_32_ldst_immpre(Rt, Rn, imm9)


/* LDRB  <Wt>, [<Xn|SP>, #<simm>]! (ffe00c00/38400c00) */
//#define IEM_INSTR_IMPL_A64__LDRB_32_ldst_immpre(Rt, Rn, imm9)


/* LDRSB  <Xt>, [<Xn|SP>, #<simm>]! (ffe00c00/38800c00) */
//#define IEM_INSTR_IMPL_A64__LDRSB_64_ldst_immpre(Rt, Rn, imm9)


/* LDRSB  <Wt>, [<Xn|SP>, #<simm>]! (ffe00c00/38c00c00) */
//#define IEM_INSTR_IMPL_A64__LDRSB_32_ldst_immpre(Rt, Rn, imm9)


/* STR  <Bt>, [<Xn|SP>, #<simm>]! (ffe00c00/3c000c00) */
//#define IEM_INSTR_IMPL_A64__STR_B_ldst_immpre(Rt, Rn, imm9)


/* LDR  <Bt>, [<Xn|SP>, #<simm>]! (ffe00c00/3c400c00) */
//#define IEM_INSTR_IMPL_A64__LDR_B_ldst_immpre(Rt, Rn, imm9)


/* STR  <Qt>, [<Xn|SP>, #<simm>]! (ffe00c00/3c800c00) */
//#define IEM_INSTR_IMPL_A64__STR_Q_ldst_immpre(Rt, Rn, imm9)


/* LDR  <Qt>, [<Xn|SP>, #<simm>]! (ffe00c00/3cc00c00) */
//#define IEM_INSTR_IMPL_A64__LDR_Q_ldst_immpre(Rt, Rn, imm9)


/* STRH  <Wt>, [<Xn|SP>, #<simm>]! (ffe00c00/78000c00) */
//#define IEM_INSTR_IMPL_A64__STRH_32_ldst_immpre(Rt, Rn, imm9)


/* LDRH  <Wt>, [<Xn|SP>, #<simm>]! (ffe00c00/78400c00) */
//#define IEM_INSTR_IMPL_A64__LDRH_32_ldst_immpre(Rt, Rn, imm9)


/* LDRSH  <Xt>, [<Xn|SP>, #<simm>]! (ffe00c00/78800c00) */
//#define IEM_INSTR_IMPL_A64__LDRSH_64_ldst_immpre(Rt, Rn, imm9)


/* LDRSH  <Wt>, [<Xn|SP>, #<simm>]! (ffe00c00/78c00c00) */
//#define IEM_INSTR_IMPL_A64__LDRSH_32_ldst_immpre(Rt, Rn, imm9)


/* STR  <Ht>, [<Xn|SP>, #<simm>]! (ffe00c00/7c000c00) */
//#define IEM_INSTR_IMPL_A64__STR_H_ldst_immpre(Rt, Rn, imm9)


/* LDR  <Ht>, [<Xn|SP>, #<simm>]! (ffe00c00/7c400c00) */
//#define IEM_INSTR_IMPL_A64__LDR_H_ldst_immpre(Rt, Rn, imm9)


/* STR  <Wt>, [<Xn|SP>, #<simm>]! (ffe00c00/b8000c00) */
//#define IEM_INSTR_IMPL_A64__STR_32_ldst_immpre(Rt, Rn, imm9)


/* LDR  <Wt>, [<Xn|SP>, #<simm>]! (ffe00c00/b8400c00) */
//#define IEM_INSTR_IMPL_A64__LDR_32_ldst_immpre(Rt, Rn, imm9)


/* LDRSW  <Xt>, [<Xn|SP>, #<simm>]! (ffe00c00/b8800c00) */
//#define IEM_INSTR_IMPL_A64__LDRSW_64_ldst_immpre(Rt, Rn, imm9)


/* STR  <St>, [<Xn|SP>, #<simm>]! (ffe00c00/bc000c00) */
//#define IEM_INSTR_IMPL_A64__STR_S_ldst_immpre(Rt, Rn, imm9)


/* LDR  <St>, [<Xn|SP>, #<simm>]! (ffe00c00/bc400c00) */
//#define IEM_INSTR_IMPL_A64__LDR_S_ldst_immpre(Rt, Rn, imm9)


/* STR  <Xt>, [<Xn|SP>, #<simm>]! (ffe00c00/f8000c00) */
//#define IEM_INSTR_IMPL_A64__STR_64_ldst_immpre(Rt, Rn, imm9)


/* LDR  <Xt>, [<Xn|SP>, #<simm>]! (ffe00c00/f8400c00) */
//#define IEM_INSTR_IMPL_A64__LDR_64_ldst_immpre(Rt, Rn, imm9)


/* STR  <Dt>, [<Xn|SP>, #<simm>]! (ffe00c00/fc000c00) */
//#define IEM_INSTR_IMPL_A64__STR_D_ldst_immpre(Rt, Rn, imm9)


/* LDR  <Dt>, [<Xn|SP>, #<simm>]! (ffe00c00/fc400c00) */
//#define IEM_INSTR_IMPL_A64__LDR_D_ldst_immpre(Rt, Rn, imm9)



/*
 *
 * Instruction Set & Groups: ldst_pac / ldst / A64
 *
 */

/* LDRAA  <Xt>, [<Xn|SP>{, #<simm>}] (ffa00c00/f8200400) */
//#define IEM_INSTR_IMPL_A64__LDRAA_64_ldst_pac(Rt, Rn, imm9, S)


/* LDRAA  <Xt>, [<Xn|SP>{, #<simm>}]! (ffa00c00/f8200c00) */
//#define IEM_INSTR_IMPL_A64__LDRAA_64W_ldst_pac(Rt, Rn, imm9, S)


/* LDRAB  <Xt>, [<Xn|SP>{, #<simm>}] (ffa00c00/f8a00400) */
//#define IEM_INSTR_IMPL_A64__LDRAB_64_ldst_pac(Rt, Rn, imm9, S)


/* LDRAB  <Xt>, [<Xn|SP>{, #<simm>}]! (ffa00c00/f8a00c00) */
//#define IEM_INSTR_IMPL_A64__LDRAB_64W_ldst_pac(Rt, Rn, imm9, S)



/*
 *
 * Instruction Set & Groups: ldst_pos / ldst / A64
 *
 */

/* STRB  <Wt>, [<Xn|SP>{, #<pimm>}] (ffc00000/39000000) */
//#define IEM_INSTR_IMPL_A64__STRB_32_ldst_pos(Rt, Rn, imm12)


/* LDRB  <Wt>, [<Xn|SP>{, #<pimm>}] (ffc00000/39400000) */
//#define IEM_INSTR_IMPL_A64__LDRB_32_ldst_pos(Rt, Rn, imm12)


/* LDRSB  <Xt>, [<Xn|SP>{, #<pimm>}] (ffc00000/39800000) */
//#define IEM_INSTR_IMPL_A64__LDRSB_64_ldst_pos(Rt, Rn, imm12)


/* LDRSB  <Wt>, [<Xn|SP>{, #<pimm>}] (ffc00000/39c00000) */
//#define IEM_INSTR_IMPL_A64__LDRSB_32_ldst_pos(Rt, Rn, imm12)


/* STR  <Bt>, [<Xn|SP>{, #<pimm>}] (ffc00000/3d000000) */
//#define IEM_INSTR_IMPL_A64__STR_B_ldst_pos(Rt, Rn, imm12)


/* LDR  <Bt>, [<Xn|SP>{, #<pimm>}] (ffc00000/3d400000) */
//#define IEM_INSTR_IMPL_A64__LDR_B_ldst_pos(Rt, Rn, imm12)


/* STR  <Qt>, [<Xn|SP>{, #<pimm>}] (ffc00000/3d800000) */
//#define IEM_INSTR_IMPL_A64__STR_Q_ldst_pos(Rt, Rn, imm12)


/* LDR  <Qt>, [<Xn|SP>{, #<pimm>}] (ffc00000/3dc00000) */
//#define IEM_INSTR_IMPL_A64__LDR_Q_ldst_pos(Rt, Rn, imm12)


/* STRH  <Wt>, [<Xn|SP>{, #<pimm>}] (ffc00000/79000000) */
//#define IEM_INSTR_IMPL_A64__STRH_32_ldst_pos(Rt, Rn, imm12)


/* LDRH  <Wt>, [<Xn|SP>{, #<pimm>}] (ffc00000/79400000) */
//#define IEM_INSTR_IMPL_A64__LDRH_32_ldst_pos(Rt, Rn, imm12)


/* LDRSH  <Xt>, [<Xn|SP>{, #<pimm>}] (ffc00000/79800000) */
//#define IEM_INSTR_IMPL_A64__LDRSH_64_ldst_pos(Rt, Rn, imm12)


/* LDRSH  <Wt>, [<Xn|SP>{, #<pimm>}] (ffc00000/79c00000) */
//#define IEM_INSTR_IMPL_A64__LDRSH_32_ldst_pos(Rt, Rn, imm12)


/* STR  <Ht>, [<Xn|SP>{, #<pimm>}] (ffc00000/7d000000) */
//#define IEM_INSTR_IMPL_A64__STR_H_ldst_pos(Rt, Rn, imm12)


/* LDR  <Ht>, [<Xn|SP>{, #<pimm>}] (ffc00000/7d400000) */
//#define IEM_INSTR_IMPL_A64__LDR_H_ldst_pos(Rt, Rn, imm12)


/* STR  <Wt>, [<Xn|SP>{, #<pimm>}] (ffc00000/b9000000) */
//#define IEM_INSTR_IMPL_A64__STR_32_ldst_pos(Rt, Rn, imm12)


/* LDR  <Wt>, [<Xn|SP>{, #<pimm>}] (ffc00000/b9400000) */
//#define IEM_INSTR_IMPL_A64__LDR_32_ldst_pos(Rt, Rn, imm12)


/* LDRSW  <Xt>, [<Xn|SP>{, #<pimm>}] (ffc00000/b9800000) */
//#define IEM_INSTR_IMPL_A64__LDRSW_64_ldst_pos(Rt, Rn, imm12)


/* STR  <St>, [<Xn|SP>{, #<pimm>}] (ffc00000/bd000000) */
//#define IEM_INSTR_IMPL_A64__STR_S_ldst_pos(Rt, Rn, imm12)


/* LDR  <St>, [<Xn|SP>{, #<pimm>}] (ffc00000/bd400000) */
//#define IEM_INSTR_IMPL_A64__LDR_S_ldst_pos(Rt, Rn, imm12)


/* STR  <Xt>, [<Xn|SP>{, #<pimm>}] (ffc00000/f9000000) */
#define IEM_INSTR_IMPL_A64__STR_64_ldst_pos(Rt, Rn, imm12) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_MEM); \
    IEM_MC_LOCAL(uint64_t, uAddr); \
    IEM_MC_FETCH_GREG_SP_CHECK_ALIGN_U64(uAddr, Rn); \
    IEM_MC_ADD_CONST_U64_TO_ADDR(uAddr, (uint64_t)imm12 << 3); \
    IEM_MC_LOCAL(uint64_t, uValue); \
    IEM_MC_FETCH_GREG_U64(uValue, Rt); \
    IEM_MC_STORE_MEM_FLAT_U64(uAddr, uValue);  /** @todo tagchecked=true */ \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* LDR  <Xt>, [<Xn|SP>{, #<pimm>}] (ffc00000/f9400000) */
#define IEM_INSTR_IMPL_A64__LDR_64_ldst_pos(Rt, Rn, imm12) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_MEM); \
    IEM_MC_LOCAL(uint64_t, uAddr); \
    IEM_MC_FETCH_GREG_SP_CHECK_ALIGN_U64(uAddr, Rn); \
    IEM_MC_ADD_CONST_U64_TO_ADDR(uAddr, (uint64_t)imm12 << 3); \
    IEM_MC_LOCAL(uint64_t, uValue); \
    IEM_MC_FETCH_MEM_FLAT_U64(uValue, uAddr);  /** @todo tagchecked=true */ \
    IEM_MC_STORE_GREG_SP_U64(Rt, uValue); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* PRFM  {<prfop> | #<imm5>}, [<Xn|SP>{, #<pimm>}] (ffc00000/f9800000) */
#define IEM_INSTR_IMPL_A64__PRFM_P_ldst_pos(Rt, Rn, imm12) \
    RT_NOREF(Rt, Rn, imm12); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* STR  <Dt>, [<Xn|SP>{, #<pimm>}] (ffc00000/fd000000) */
//#define IEM_INSTR_IMPL_A64__STR_D_ldst_pos(Rt, Rn, imm12)


/* LDR  <Dt>, [<Xn|SP>{, #<pimm>}] (ffc00000/fd400000) */
//#define IEM_INSTR_IMPL_A64__LDR_D_ldst_pos(Rt, Rn, imm12)



/*
 *
 * Instruction Set & Groups: ldst_regoff / ldst / A64
 *
 */

/* STRB  <Wt>, [<Xn|SP>, {<Wm> | <Xm>}, <extend>{ <amount>}] (ffe00c00/38200800) */
//#define IEM_INSTR_IMPL_A64__STRB_32B_ldst_regoff(Rt, Rn, S, option, Rm)


/* STRB  <Wt>, [<Xn|SP>, <Xm>{, LSL <amount>}] (ffe0ec00/38206800) */
//#define IEM_INSTR_IMPL_A64__STRB_32BL_ldst_regoff(Rt, Rn, S, Rm)


/* LDRB  <Wt>, [<Xn|SP>, {<Wm> | <Xm>}, <extend>{ <amount>}] (ffe00c00/38600800) */
//#define IEM_INSTR_IMPL_A64__LDRB_32B_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDRB  <Wt>, [<Xn|SP>, <Xm>{, LSL <amount>}] (ffe0ec00/38606800) */
//#define IEM_INSTR_IMPL_A64__LDRB_32BL_ldst_regoff(Rt, Rn, S, Rm)


/* LDRSB  <Xt>, [<Xn|SP>, {<Wm> | <Xm>}, <extend>{ <amount>}] (ffe00c00/38a00800) */
//#define IEM_INSTR_IMPL_A64__LDRSB_64B_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDRSB  <Xt>, [<Xn|SP>, <Xm>{, LSL <amount>}] (ffe0ec00/38a06800) */
//#define IEM_INSTR_IMPL_A64__LDRSB_64BL_ldst_regoff(Rt, Rn, S, Rm)


/* LDRSB  <Wt>, [<Xn|SP>, {<Wm> | <Xm>}, <extend>{ <amount>}] (ffe00c00/38e00800) */
//#define IEM_INSTR_IMPL_A64__LDRSB_32B_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDRSB  <Wt>, [<Xn|SP>, <Xm>{, LSL <amount>}] (ffe0ec00/38e06800) */
//#define IEM_INSTR_IMPL_A64__LDRSB_32BL_ldst_regoff(Rt, Rn, S, Rm)


/* STR  <Bt>, [<Xn|SP>, {<Wm> | <Xm>}, <extend>{ <amount>}] (ffe00c00/3c200800) */
//#define IEM_INSTR_IMPL_A64__STR_B_ldst_regoff(Rt, Rn, S, option, Rm)


/* STR  <Bt>, [<Xn|SP>, <Xm>{, LSL <amount>}] (ffe0ec00/3c206800) */
//#define IEM_INSTR_IMPL_A64__STR_BL_ldst_regoff(Rt, Rn, S, Rm)


/* LDR  <Bt>, [<Xn|SP>, {<Wm> | <Xm>}, <extend>{ <amount>}] (ffe00c00/3c600800) */
//#define IEM_INSTR_IMPL_A64__LDR_B_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDR  <Bt>, [<Xn|SP>, <Xm>{, LSL <amount>}] (ffe0ec00/3c606800) */
//#define IEM_INSTR_IMPL_A64__LDR_BL_ldst_regoff(Rt, Rn, S, Rm)


/* STR  <Qt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/3ca00800) */
//#define IEM_INSTR_IMPL_A64__STR_Q_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDR  <Qt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/3ce00800) */
//#define IEM_INSTR_IMPL_A64__LDR_Q_ldst_regoff(Rt, Rn, S, option, Rm)


/* STRH  <Wt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/78200800) */
//#define IEM_INSTR_IMPL_A64__STRH_32_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDRH  <Wt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/78600800) */
//#define IEM_INSTR_IMPL_A64__LDRH_32_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDRSH  <Xt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/78a00800) */
//#define IEM_INSTR_IMPL_A64__LDRSH_64_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDRSH  <Wt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/78e00800) */
//#define IEM_INSTR_IMPL_A64__LDRSH_32_ldst_regoff(Rt, Rn, S, option, Rm)


/* STR  <Ht>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/7c200800) */
//#define IEM_INSTR_IMPL_A64__STR_H_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDR  <Ht>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/7c600800) */
//#define IEM_INSTR_IMPL_A64__LDR_H_ldst_regoff(Rt, Rn, S, option, Rm)


/* STR  <Wt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/b8200800) */
//#define IEM_INSTR_IMPL_A64__STR_32_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDR  <Wt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/b8600800) */
//#define IEM_INSTR_IMPL_A64__LDR_32_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDRSW  <Xt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/b8a00800) */
//#define IEM_INSTR_IMPL_A64__LDRSW_64_ldst_regoff(Rt, Rn, S, option, Rm)


/* STR  <St>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/bc200800) */
//#define IEM_INSTR_IMPL_A64__STR_S_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDR  <St>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/bc600800) */
//#define IEM_INSTR_IMPL_A64__LDR_S_ldst_regoff(Rt, Rn, S, option, Rm)


/* STR  <Xt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/f8200800) */
//#define IEM_INSTR_IMPL_A64__STR_64_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDR  <Xt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/f8600800) */
//#define IEM_INSTR_IMPL_A64__LDR_64_ldst_regoff(Rt, Rn, S, option, Rm)


/* PRFM  {<prfop> | #<imm5>}, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/f8a00800) */
#define IEM_INSTR_IMPL_A64__PRFM_P_ldst_regoff(Rt, Rn, S, option, Rm) \
    RT_NOREF(Rt, Rn, S, option, Rm); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* RPRFM  {<rprfop> | #<imm6>}, <Xm>, [<Xn|SP>] (ffe00c00/f8a00800) */
#define IEM_INSTR_IMPL_A64__RPRFM_R_ldst_regoff(Rt, Rn, S, option, Rm) \
    RT_NOREF(Rt, Rn, S, option, Rm); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* STR  <Dt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/fc200800) */
//#define IEM_INSTR_IMPL_A64__STR_D_ldst_regoff(Rt, Rn, S, option, Rm)


/* LDR  <Dt>, [<Xn|SP>, {<Wm> | <Xm>}{, <extend>{ <amount>}}] (ffe00c00/fc600800) */
//#define IEM_INSTR_IMPL_A64__LDR_D_ldst_regoff(Rt, Rn, S, option, Rm)



/*
 *
 * Instruction Set & Groups: ldst_unpriv / ldst / A64
 *
 */

/* STTRB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/38000800) */
//#define IEM_INSTR_IMPL_A64__STTRB_32_ldst_unpriv(Rt, Rn, imm9)


/* LDTRB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/38400800) */
//#define IEM_INSTR_IMPL_A64__LDTRB_32_ldst_unpriv(Rt, Rn, imm9)


/* LDTRSB  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/38800800) */
//#define IEM_INSTR_IMPL_A64__LDTRSB_64_ldst_unpriv(Rt, Rn, imm9)


/* LDTRSB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/38c00800) */
//#define IEM_INSTR_IMPL_A64__LDTRSB_32_ldst_unpriv(Rt, Rn, imm9)


/* STTRH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/78000800) */
//#define IEM_INSTR_IMPL_A64__STTRH_32_ldst_unpriv(Rt, Rn, imm9)


/* LDTRH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/78400800) */
//#define IEM_INSTR_IMPL_A64__LDTRH_32_ldst_unpriv(Rt, Rn, imm9)


/* LDTRSH  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/78800800) */
//#define IEM_INSTR_IMPL_A64__LDTRSH_64_ldst_unpriv(Rt, Rn, imm9)


/* LDTRSH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/78c00800) */
//#define IEM_INSTR_IMPL_A64__LDTRSH_32_ldst_unpriv(Rt, Rn, imm9)


/* STTR  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/b8000800) */
//#define IEM_INSTR_IMPL_A64__STTR_32_ldst_unpriv(Rt, Rn, imm9)


/* LDTR  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/b8400800) */
//#define IEM_INSTR_IMPL_A64__LDTR_32_ldst_unpriv(Rt, Rn, imm9)


/* LDTRSW  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/b8800800) */
//#define IEM_INSTR_IMPL_A64__LDTRSW_64_ldst_unpriv(Rt, Rn, imm9)


/* STTR  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/f8000800) */
//#define IEM_INSTR_IMPL_A64__STTR_64_ldst_unpriv(Rt, Rn, imm9)


/* LDTR  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/f8400800) */
//#define IEM_INSTR_IMPL_A64__LDTR_64_ldst_unpriv(Rt, Rn, imm9)



/*
 *
 * Instruction Set & Groups: ldst_unscaled / ldst / A64
 *
 */

/* STURB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/38000000) */
//#define IEM_INSTR_IMPL_A64__STURB_32_ldst_unscaled(Rt, Rn, imm9)


/* LDURB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/38400000) */
//#define IEM_INSTR_IMPL_A64__LDURB_32_ldst_unscaled(Rt, Rn, imm9)


/* LDURSB  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/38800000) */
//#define IEM_INSTR_IMPL_A64__LDURSB_64_ldst_unscaled(Rt, Rn, imm9)


/* LDURSB  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/38c00000) */
//#define IEM_INSTR_IMPL_A64__LDURSB_32_ldst_unscaled(Rt, Rn, imm9)


/* STUR  <Bt>, [<Xn|SP>{, #<simm>}] (ffe00c00/3c000000) */
//#define IEM_INSTR_IMPL_A64__STUR_B_ldst_unscaled(Rt, Rn, imm9)


/* LDUR  <Bt>, [<Xn|SP>{, #<simm>}] (ffe00c00/3c400000) */
//#define IEM_INSTR_IMPL_A64__LDUR_B_ldst_unscaled(Rt, Rn, imm9)


/* STUR  <Qt>, [<Xn|SP>{, #<simm>}] (ffe00c00/3c800000) */
//#define IEM_INSTR_IMPL_A64__STUR_Q_ldst_unscaled(Rt, Rn, imm9)


/* LDUR  <Qt>, [<Xn|SP>{, #<simm>}] (ffe00c00/3cc00000) */
//#define IEM_INSTR_IMPL_A64__LDUR_Q_ldst_unscaled(Rt, Rn, imm9)


/* STURH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/78000000) */
//#define IEM_INSTR_IMPL_A64__STURH_32_ldst_unscaled(Rt, Rn, imm9)


/* LDURH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/78400000) */
//#define IEM_INSTR_IMPL_A64__LDURH_32_ldst_unscaled(Rt, Rn, imm9)


/* LDURSH  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/78800000) */
//#define IEM_INSTR_IMPL_A64__LDURSH_64_ldst_unscaled(Rt, Rn, imm9)


/* LDURSH  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/78c00000) */
//#define IEM_INSTR_IMPL_A64__LDURSH_32_ldst_unscaled(Rt, Rn, imm9)


/* STUR  <Ht>, [<Xn|SP>{, #<simm>}] (ffe00c00/7c000000) */
//#define IEM_INSTR_IMPL_A64__STUR_H_ldst_unscaled(Rt, Rn, imm9)


/* LDUR  <Ht>, [<Xn|SP>{, #<simm>}] (ffe00c00/7c400000) */
//#define IEM_INSTR_IMPL_A64__LDUR_H_ldst_unscaled(Rt, Rn, imm9)


/* STUR  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/b8000000) */
//#define IEM_INSTR_IMPL_A64__STUR_32_ldst_unscaled(Rt, Rn, imm9)


/* LDUR  <Wt>, [<Xn|SP>{, #<simm>}] (ffe00c00/b8400000) */
//#define IEM_INSTR_IMPL_A64__LDUR_32_ldst_unscaled(Rt, Rn, imm9)


/* LDURSW  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/b8800000) */
//#define IEM_INSTR_IMPL_A64__LDURSW_64_ldst_unscaled(Rt, Rn, imm9)


/* STUR  <St>, [<Xn|SP>{, #<simm>}] (ffe00c00/bc000000) */
//#define IEM_INSTR_IMPL_A64__STUR_S_ldst_unscaled(Rt, Rn, imm9)


/* LDUR  <St>, [<Xn|SP>{, #<simm>}] (ffe00c00/bc400000) */
//#define IEM_INSTR_IMPL_A64__LDUR_S_ldst_unscaled(Rt, Rn, imm9)


/* STUR  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/f8000000) */
//#define IEM_INSTR_IMPL_A64__STUR_64_ldst_unscaled(Rt, Rn, imm9)


/* LDUR  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/f8400000) */
//#define IEM_INSTR_IMPL_A64__LDUR_64_ldst_unscaled(Rt, Rn, imm9)


/* PRFUM  {<prfop> | #<imm5>}, [<Xn|SP>{, #<simm>}] (ffe00c00/f8800000) */
#define IEM_INSTR_IMPL_A64__PRFUM_P_ldst_unscaled(Rt, Rn, imm9) \
    RT_NOREF(Rt, Rn, imm9); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* STUR  <Dt>, [<Xn|SP>{, #<simm>}] (ffe00c00/fc000000) */
//#define IEM_INSTR_IMPL_A64__STUR_D_ldst_unscaled(Rt, Rn, imm9)


/* LDUR  <Dt>, [<Xn|SP>{, #<simm>}] (ffe00c00/fc400000) */
//#define IEM_INSTR_IMPL_A64__LDUR_D_ldst_unscaled(Rt, Rn, imm9)



/*
 *
 * Instruction Set & Groups: ldstexclp / ldst / A64
 *
 */

/* STXP  <Ws>, <Wt1>, <Wt2>, [<Xn|SP>{, #0}] (ffe08000/88200000) */
//#define IEM_INSTR_IMPL_A64__STXP_SP32_ldstexclp(Rt, Rn, Rt2, Rs)


/* STLXP  <Ws>, <Wt1>, <Wt2>, [<Xn|SP>{, #0}] (ffe08000/88208000) */
//#define IEM_INSTR_IMPL_A64__STLXP_SP32_ldstexclp(Rt, Rn, Rt2, Rs)


/* LDXP  <Wt1>, <Wt2>, [<Xn|SP>{, #0}] (ffff8000/887f0000) */
//#define IEM_INSTR_IMPL_A64__LDXP_LP32_ldstexclp(Rt, Rn, Rt2)


/* LDAXP  <Wt1>, <Wt2>, [<Xn|SP>{, #0}] (ffff8000/887f8000) */
//#define IEM_INSTR_IMPL_A64__LDAXP_LP32_ldstexclp(Rt, Rn, Rt2)


/* STXP  <Ws>, <Xt1>, <Xt2>, [<Xn|SP>{, #0}] (ffe08000/c8200000) */
//#define IEM_INSTR_IMPL_A64__STXP_SP64_ldstexclp(Rt, Rn, Rt2, Rs)


/* STLXP  <Ws>, <Xt1>, <Xt2>, [<Xn|SP>{, #0}] (ffe08000/c8208000) */
//#define IEM_INSTR_IMPL_A64__STLXP_SP64_ldstexclp(Rt, Rn, Rt2, Rs)


/* LDXP  <Xt1>, <Xt2>, [<Xn|SP>{, #0}] (ffff8000/c87f0000) */
//#define IEM_INSTR_IMPL_A64__LDXP_LP64_ldstexclp(Rt, Rn, Rt2)


/* LDAXP  <Xt1>, <Xt2>, [<Xn|SP>{, #0}] (ffff8000/c87f8000) */
//#define IEM_INSTR_IMPL_A64__LDAXP_LP64_ldstexclp(Rt, Rn, Rt2)



/*
 *
 * Instruction Set & Groups: ldstexclr / ldst / A64
 *
 */

/* STXRB  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/08007c00) */
//#define IEM_INSTR_IMPL_A64__STXRB_SR32_ldstexclr(Rt, Rn, Rs)


/* STLXRB  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/0800fc00) */
//#define IEM_INSTR_IMPL_A64__STLXRB_SR32_ldstexclr(Rt, Rn, Rs)


/* LDXRB  <Wt>, [<Xn|SP>{, #0}] (fffffc00/085f7c00) */
//#define IEM_INSTR_IMPL_A64__LDXRB_LR32_ldstexclr(Rt, Rn)


/* LDAXRB  <Wt>, [<Xn|SP>{, #0}] (fffffc00/085ffc00) */
//#define IEM_INSTR_IMPL_A64__LDAXRB_LR32_ldstexclr(Rt, Rn)


/* STXRH  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/48007c00) */
//#define IEM_INSTR_IMPL_A64__STXRH_SR32_ldstexclr(Rt, Rn, Rs)


/* STLXRH  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/4800fc00) */
//#define IEM_INSTR_IMPL_A64__STLXRH_SR32_ldstexclr(Rt, Rn, Rs)


/* LDXRH  <Wt>, [<Xn|SP>{, #0}] (fffffc00/485f7c00) */
//#define IEM_INSTR_IMPL_A64__LDXRH_LR32_ldstexclr(Rt, Rn)


/* LDAXRH  <Wt>, [<Xn|SP>{, #0}] (fffffc00/485ffc00) */
//#define IEM_INSTR_IMPL_A64__LDAXRH_LR32_ldstexclr(Rt, Rn)


/* STXR  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/88007c00) */
//#define IEM_INSTR_IMPL_A64__STXR_SR32_ldstexclr(Rt, Rn, Rs)


/* STLXR  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/8800fc00) */
//#define IEM_INSTR_IMPL_A64__STLXR_SR32_ldstexclr(Rt, Rn, Rs)


/* LDXR  <Wt>, [<Xn|SP>{, #0}] (fffffc00/885f7c00) */
//#define IEM_INSTR_IMPL_A64__LDXR_LR32_ldstexclr(Rt, Rn)


/* LDAXR  <Wt>, [<Xn|SP>{, #0}] (fffffc00/885ffc00) */
//#define IEM_INSTR_IMPL_A64__LDAXR_LR32_ldstexclr(Rt, Rn)


/* STXR  <Ws>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c8007c00) */
//#define IEM_INSTR_IMPL_A64__STXR_SR64_ldstexclr(Rt, Rn, Rs)


/* STLXR  <Ws>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c800fc00) */
//#define IEM_INSTR_IMPL_A64__STLXR_SR64_ldstexclr(Rt, Rn, Rs)


/* LDXR  <Xt>, [<Xn|SP>{, #0}] (fffffc00/c85f7c00) */
//#define IEM_INSTR_IMPL_A64__LDXR_LR64_ldstexclr(Rt, Rn)


/* LDAXR  <Xt>, [<Xn|SP>{, #0}] (fffffc00/c85ffc00) */
//#define IEM_INSTR_IMPL_A64__LDAXR_LR64_ldstexclr(Rt, Rn)



/*
 *
 * Instruction Set & Groups: ldstexclr_unpriv / ldst / A64
 *
 */

/* STTXR  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/89007c00) */
//#define IEM_INSTR_IMPL_A64__STTXR_SR32_ldstexclr_unpriv(Rt, Rn, Rs)


/* STLTXR  <Ws>, <Wt>, [<Xn|SP>{, #0}] (ffe0fc00/8900fc00) */
//#define IEM_INSTR_IMPL_A64__STLTXR_SR32_ldstexclr_unpriv(Rt, Rn, Rs)


/* LDTXR  <Wt>, [<Xn|SP>{, #0}] (fffffc00/895f7c00) */
//#define IEM_INSTR_IMPL_A64__LDTXR_LR32_ldstexclr_unpriv(Rt, Rn)


/* LDATXR  <Wt>, [<Xn|SP>{, #0}] (fffffc00/895ffc00) */
//#define IEM_INSTR_IMPL_A64__LDATXR_LR32_ldstexclr_unpriv(Rt, Rn)


/* STTXR  <Ws>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c9007c00) */
//#define IEM_INSTR_IMPL_A64__STTXR_SR64_ldstexclr_unpriv(Rt, Rn, Rs)


/* STLTXR  <Ws>, <Xt>, [<Xn|SP>{, #0}] (ffe0fc00/c900fc00) */
//#define IEM_INSTR_IMPL_A64__STLTXR_SR64_ldstexclr_unpriv(Rt, Rn, Rs)


/* LDTXR  <Xt>, [<Xn|SP>{, #0}] (fffffc00/c95f7c00) */
//#define IEM_INSTR_IMPL_A64__LDTXR_LR64_ldstexclr_unpriv(Rt, Rn)


/* LDATXR  <Xt>, [<Xn|SP>{, #0}] (fffffc00/c95ffc00) */
//#define IEM_INSTR_IMPL_A64__LDATXR_LR64_ldstexclr_unpriv(Rt, Rn)



/*
 *
 * Instruction Set & Groups: ldstnapair_offs / ldst / A64
 *
 */

/* STNP  <Wt1>, <Wt2>, [<Xn|SP>{, #<imm>}] (ffc00000/28000000) */
//#define IEM_INSTR_IMPL_A64__STNP_32_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* LDNP  <Wt1>, <Wt2>, [<Xn|SP>{, #<imm>}] (ffc00000/28400000) */
//#define IEM_INSTR_IMPL_A64__LDNP_32_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* STNP  <St1>, <St2>, [<Xn|SP>{, #<imm>}] (ffc00000/2c000000) */
//#define IEM_INSTR_IMPL_A64__STNP_S_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* LDNP  <St1>, <St2>, [<Xn|SP>{, #<imm>}] (ffc00000/2c400000) */
//#define IEM_INSTR_IMPL_A64__LDNP_S_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* STNP  <Dt1>, <Dt2>, [<Xn|SP>{, #<imm>}] (ffc00000/6c000000) */
//#define IEM_INSTR_IMPL_A64__STNP_D_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* LDNP  <Dt1>, <Dt2>, [<Xn|SP>{, #<imm>}] (ffc00000/6c400000) */
//#define IEM_INSTR_IMPL_A64__LDNP_D_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* STNP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/a8000000) */
//#define IEM_INSTR_IMPL_A64__STNP_64_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* LDNP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/a8400000) */
//#define IEM_INSTR_IMPL_A64__LDNP_64_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* STNP  <Qt1>, <Qt2>, [<Xn|SP>{, #<imm>}] (ffc00000/ac000000) */
//#define IEM_INSTR_IMPL_A64__STNP_Q_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* LDNP  <Qt1>, <Qt2>, [<Xn|SP>{, #<imm>}] (ffc00000/ac400000) */
//#define IEM_INSTR_IMPL_A64__LDNP_Q_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* STTNP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/e8000000) */
//#define IEM_INSTR_IMPL_A64__STTNP_64_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* LDTNP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/e8400000) */
//#define IEM_INSTR_IMPL_A64__LDTNP_64_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* STTNP  <Qt1>, <Qt2>, [<Xn|SP>{, #<imm>}] (ffc00000/ec000000) */
//#define IEM_INSTR_IMPL_A64__STTNP_Q_ldstnapair_offs(Rt, Rn, Rt2, imm7)


/* LDTNP  <Qt1>, <Qt2>, [<Xn|SP>{, #<imm>}] (ffc00000/ec400000) */
//#define IEM_INSTR_IMPL_A64__LDTNP_Q_ldstnapair_offs(Rt, Rn, Rt2, imm7)



/*
 *
 * Instruction Set & Groups: ldstord / ldst / A64
 *
 */

/* STLLRB  <Wt>, [<Xn|SP>{, #0}] (fffffc00/089f7c00) */
//#define IEM_INSTR_IMPL_A64__STLLRB_SL32_ldstord(Rt, Rn)


/* STLRB  <Wt>, [<Xn|SP>{, #0}] (fffffc00/089ffc00) */
//#define IEM_INSTR_IMPL_A64__STLRB_SL32_ldstord(Rt, Rn)


/* LDLARB  <Wt>, [<Xn|SP>{, #0}] (fffffc00/08df7c00) */
//#define IEM_INSTR_IMPL_A64__LDLARB_LR32_ldstord(Rt, Rn)


/* LDARB  <Wt>, [<Xn|SP>{, #0}] (fffffc00/08dffc00) */
//#define IEM_INSTR_IMPL_A64__LDARB_LR32_ldstord(Rt, Rn)


/* STLLRH  <Wt>, [<Xn|SP>{, #0}] (fffffc00/489f7c00) */
//#define IEM_INSTR_IMPL_A64__STLLRH_SL32_ldstord(Rt, Rn)


/* STLRH  <Wt>, [<Xn|SP>{, #0}] (fffffc00/489ffc00) */
//#define IEM_INSTR_IMPL_A64__STLRH_SL32_ldstord(Rt, Rn)


/* LDLARH  <Wt>, [<Xn|SP>{, #0}] (fffffc00/48df7c00) */
//#define IEM_INSTR_IMPL_A64__LDLARH_LR32_ldstord(Rt, Rn)


/* LDARH  <Wt>, [<Xn|SP>{, #0}] (fffffc00/48dffc00) */
//#define IEM_INSTR_IMPL_A64__LDARH_LR32_ldstord(Rt, Rn)


/* STLLR  <Wt>, [<Xn|SP>{, #0}] (fffffc00/889f7c00) */
//#define IEM_INSTR_IMPL_A64__STLLR_SL32_ldstord(Rt, Rn)


/* STLR  <Wt>, [<Xn|SP>{, #0}] (fffffc00/889ffc00) */
//#define IEM_INSTR_IMPL_A64__STLR_SL32_ldstord(Rt, Rn)


/* LDLAR  <Wt>, [<Xn|SP>{, #0}] (fffffc00/88df7c00) */
//#define IEM_INSTR_IMPL_A64__LDLAR_LR32_ldstord(Rt, Rn)


/* LDAR  <Wt>, [<Xn|SP>{, #0}] (fffffc00/88dffc00) */
//#define IEM_INSTR_IMPL_A64__LDAR_LR32_ldstord(Rt, Rn)


/* STLLR  <Xt>, [<Xn|SP>{, #0}] (fffffc00/c89f7c00) */
//#define IEM_INSTR_IMPL_A64__STLLR_SL64_ldstord(Rt, Rn)


/* STLR  <Xt>, [<Xn|SP>{, #0}] (fffffc00/c89ffc00) */
//#define IEM_INSTR_IMPL_A64__STLR_SL64_ldstord(Rt, Rn)


/* LDLAR  <Xt>, [<Xn|SP>{, #0}] (fffffc00/c8df7c00) */
//#define IEM_INSTR_IMPL_A64__LDLAR_LR64_ldstord(Rt, Rn)


/* LDAR  <Xt>, [<Xn|SP>{, #0}] (fffffc00/c8dffc00) */
//#define IEM_INSTR_IMPL_A64__LDAR_LR64_ldstord(Rt, Rn)



/*
 *
 * Instruction Set & Groups: ldstpair_off / ldst / A64
 *
 */

/* STP  <Wt1>, <Wt2>, [<Xn|SP>{, #<imm>}] (ffc00000/29000000) */
#define IEM_INSTR_IMPL_A64__STP_32_ldstpair_off(Rt, Rn, Rt2, imm7) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_MEM); \
    IEM_MC_LOCAL(uint32_t, uVal1); \
    IEM_MC_FETCH_GREG_U32( uVal1, Rt); \
    IEM_MC_LOCAL(uint32_t, uVal2); \
    IEM_MC_FETCH_GREG_U32( uVal2, Rt2); \
    IEM_MC_LOCAL(uint64_t, uAddr); \
    IEM_MC_FETCH_GREG_SP_CHECK_ALIGN_U64(uAddr, Rn); \
    IEM_MC_ADD_CONST_U64_TO_ADDR(uAddr, (int64_t)imm7 << (64 - 7) >> (64 - 7 - 2)); \
    IEM_MC_STORE_MEM_FLAT_U32_PAIR(uAddr, uVal1, uVal2);  /** @todo tagchecked=true */ \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* LDP  <Wt1>, <Wt2>, [<Xn|SP>{, #<imm>}] (ffc00000/29400000) */
//#define IEM_INSTR_IMPL_A64__LDP_32_ldstpair_off(Rt, Rn, Rt2, imm7)


/* STP  <St1>, <St2>, [<Xn|SP>{, #<imm>}] (ffc00000/2d000000) */
//#define IEM_INSTR_IMPL_A64__STP_S_ldstpair_off(Rt, Rn, Rt2, imm7)


/* LDP  <St1>, <St2>, [<Xn|SP>{, #<imm>}] (ffc00000/2d400000) */
//#define IEM_INSTR_IMPL_A64__LDP_S_ldstpair_off(Rt, Rn, Rt2, imm7)


/* STGP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/69000000) */
//#define IEM_INSTR_IMPL_A64__STGP_64_ldstpair_off(Rt, Rn, Rt2, simm7)


/* LDPSW  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/69400000) */
//#define IEM_INSTR_IMPL_A64__LDPSW_64_ldstpair_off(Rt, Rn, Rt2, imm7)


/* STP  <Dt1>, <Dt2>, [<Xn|SP>{, #<imm>}] (ffc00000/6d000000) */
//#define IEM_INSTR_IMPL_A64__STP_D_ldstpair_off(Rt, Rn, Rt2, imm7)


/* LDP  <Dt1>, <Dt2>, [<Xn|SP>{, #<imm>}] (ffc00000/6d400000) */
//#define IEM_INSTR_IMPL_A64__LDP_D_ldstpair_off(Rt, Rn, Rt2, imm7)


/* STP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/a9000000) */
#define IEM_INSTR_IMPL_A64__STP_64_ldstpair_off(Rt, Rn, Rt2, imm7) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_MEM); \
    IEM_MC_LOCAL(uint64_t, uVal1); \
    IEM_MC_FETCH_GREG_U64( uVal1, Rt); \
    IEM_MC_LOCAL(uint64_t, uVal2); \
    IEM_MC_FETCH_GREG_U64( uVal2, Rt2); \
    IEM_MC_LOCAL(uint64_t, uAddr); \
    IEM_MC_FETCH_GREG_SP_CHECK_ALIGN_U64(uAddr, Rn); \
    IEM_MC_ADD_CONST_U64_TO_ADDR(uAddr, (int64_t)imm7 << (64 - 7) >> (64 - 7 - 3)); \
    IEM_MC_STORE_MEM_FLAT_U64_PAIR(uAddr, uVal1, uVal2);  /** @todo tagchecked=true */ \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* LDP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/a9400000) */
//#define IEM_INSTR_IMPL_A64__LDP_64_ldstpair_off(Rt, Rn, Rt2, imm7)


/* STP  <Qt1>, <Qt2>, [<Xn|SP>{, #<imm>}] (ffc00000/ad000000) */
//#define IEM_INSTR_IMPL_A64__STP_Q_ldstpair_off(Rt, Rn, Rt2, imm7)


/* LDP  <Qt1>, <Qt2>, [<Xn|SP>{, #<imm>}] (ffc00000/ad400000) */
//#define IEM_INSTR_IMPL_A64__LDP_Q_ldstpair_off(Rt, Rn, Rt2, imm7)


/* STTP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/e9000000) */
//#define IEM_INSTR_IMPL_A64__STTP_64_ldstpair_off(Rt, Rn, Rt2, imm7)


/* LDTP  <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}] (ffc00000/e9400000) */
//#define IEM_INSTR_IMPL_A64__LDTP_64_ldstpair_off(Rt, Rn, Rt2, imm7)


/* STTP  <Qt1>, <Qt2>, [<Xn|SP>{, #<imm>}] (ffc00000/ed000000) */
//#define IEM_INSTR_IMPL_A64__STTP_Q_ldstpair_off(Rt, Rn, Rt2, imm7)


/* LDTP  <Qt1>, <Qt2>, [<Xn|SP>{, #<imm>}] (ffc00000/ed400000) */
//#define IEM_INSTR_IMPL_A64__LDTP_Q_ldstpair_off(Rt, Rn, Rt2, imm7)



/*
 *
 * Instruction Set & Groups: ldstpair_post / ldst / A64
 *
 */

/* STP  <Wt1>, <Wt2>, [<Xn|SP>], #<imm> (ffc00000/28800000) */
//#define IEM_INSTR_IMPL_A64__STP_32_ldstpair_post(Rt, Rn, Rt2, imm7)


/* LDP  <Wt1>, <Wt2>, [<Xn|SP>], #<imm> (ffc00000/28c00000) */
//#define IEM_INSTR_IMPL_A64__LDP_32_ldstpair_post(Rt, Rn, Rt2, imm7)


/* STP  <St1>, <St2>, [<Xn|SP>], #<imm> (ffc00000/2c800000) */
//#define IEM_INSTR_IMPL_A64__STP_S_ldstpair_post(Rt, Rn, Rt2, imm7)


/* LDP  <St1>, <St2>, [<Xn|SP>], #<imm> (ffc00000/2cc00000) */
//#define IEM_INSTR_IMPL_A64__LDP_S_ldstpair_post(Rt, Rn, Rt2, imm7)


/* STGP  <Xt1>, <Xt2>, [<Xn|SP>], #<imm> (ffc00000/68800000) */
//#define IEM_INSTR_IMPL_A64__STGP_64_ldstpair_post(Rt, Rn, Rt2, simm7)


/* LDPSW  <Xt1>, <Xt2>, [<Xn|SP>], #<imm> (ffc00000/68c00000) */
//#define IEM_INSTR_IMPL_A64__LDPSW_64_ldstpair_post(Rt, Rn, Rt2, imm7)


/* STP  <Dt1>, <Dt2>, [<Xn|SP>], #<imm> (ffc00000/6c800000) */
//#define IEM_INSTR_IMPL_A64__STP_D_ldstpair_post(Rt, Rn, Rt2, imm7)


/* LDP  <Dt1>, <Dt2>, [<Xn|SP>], #<imm> (ffc00000/6cc00000) */
//#define IEM_INSTR_IMPL_A64__LDP_D_ldstpair_post(Rt, Rn, Rt2, imm7)


/* STP  <Xt1>, <Xt2>, [<Xn|SP>], #<imm> (ffc00000/a8800000) */
#define IEM_INSTR_IMPL_A64__STP_64_ldstpair_post(Rt, Rn, Rt2, imm7) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_MEM); \
    IEM_MC_LOCAL(uint64_t, uVal1); \
    IEM_MC_FETCH_GREG_U64( uVal1, Rt); \
    IEM_MC_LOCAL(uint64_t, uVal2); \
    IEM_MC_FETCH_GREG_U64( uVal2, Rt2); \
    IEM_MC_LOCAL(uint64_t, uAddr); \
    IEM_MC_FETCH_GREG_SP_CHECK_ALIGN_U64(uAddr, Rn); \
    IEM_MC_STORE_MEM_FLAT_U64_PAIR(uAddr, uVal1, uVal2);  /** @todo tagchecked=true */ \
    IEM_MC_ADD_CONST_U64_TO_ADDR(uAddr, (uint64_t)imm7 * 8U); \
    IEM_MC_STORE_GREG_SP_U64(Rn, uAddr); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* LDP  <Xt1>, <Xt2>, [<Xn|SP>], #<imm> (ffc00000/a8c00000) */
//#define IEM_INSTR_IMPL_A64__LDP_64_ldstpair_post(Rt, Rn, Rt2, imm7)


/* STP  <Qt1>, <Qt2>, [<Xn|SP>], #<imm> (ffc00000/ac800000) */
//#define IEM_INSTR_IMPL_A64__STP_Q_ldstpair_post(Rt, Rn, Rt2, imm7)


/* LDP  <Qt1>, <Qt2>, [<Xn|SP>], #<imm> (ffc00000/acc00000) */
//#define IEM_INSTR_IMPL_A64__LDP_Q_ldstpair_post(Rt, Rn, Rt2, imm7)


/* STTP  <Xt1>, <Xt2>, [<Xn|SP>], #<imm> (ffc00000/e8800000) */
//#define IEM_INSTR_IMPL_A64__STTP_64_ldstpair_post(Rt, Rn, Rt2, imm7)


/* LDTP  <Xt1>, <Xt2>, [<Xn|SP>], #<imm> (ffc00000/e8c00000) */
//#define IEM_INSTR_IMPL_A64__LDTP_64_ldstpair_post(Rt, Rn, Rt2, imm7)


/* STTP  <Qt1>, <Qt2>, [<Xn|SP>], #<imm> (ffc00000/ec800000) */
//#define IEM_INSTR_IMPL_A64__STTP_Q_ldstpair_post(Rt, Rn, Rt2, imm7)


/* LDTP  <Qt1>, <Qt2>, [<Xn|SP>], #<imm> (ffc00000/ecc00000) */
//#define IEM_INSTR_IMPL_A64__LDTP_Q_ldstpair_post(Rt, Rn, Rt2, imm7)



/*
 *
 * Instruction Set & Groups: ldstpair_pre / ldst / A64
 *
 */

/* STP  <Wt1>, <Wt2>, [<Xn|SP>, #<imm>]! (ffc00000/29800000) */
//#define IEM_INSTR_IMPL_A64__STP_32_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* LDP  <Wt1>, <Wt2>, [<Xn|SP>, #<imm>]! (ffc00000/29c00000) */
//#define IEM_INSTR_IMPL_A64__LDP_32_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* STP  <St1>, <St2>, [<Xn|SP>, #<imm>]! (ffc00000/2d800000) */
//#define IEM_INSTR_IMPL_A64__STP_S_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* LDP  <St1>, <St2>, [<Xn|SP>, #<imm>]! (ffc00000/2dc00000) */
//#define IEM_INSTR_IMPL_A64__LDP_S_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* STGP  <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]! (ffc00000/69800000) */
//#define IEM_INSTR_IMPL_A64__STGP_64_ldstpair_pre(Rt, Rn, Rt2, simm7)


/* LDPSW  <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]! (ffc00000/69c00000) */
//#define IEM_INSTR_IMPL_A64__LDPSW_64_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* STP  <Dt1>, <Dt2>, [<Xn|SP>, #<imm>]! (ffc00000/6d800000) */
//#define IEM_INSTR_IMPL_A64__STP_D_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* LDP  <Dt1>, <Dt2>, [<Xn|SP>, #<imm>]! (ffc00000/6dc00000) */
//#define IEM_INSTR_IMPL_A64__LDP_D_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* STP  <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]! (ffc00000/a9800000) */
//#define IEM_INSTR_IMPL_A64__STP_64_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* LDP  <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]! (ffc00000/a9c00000) */
//#define IEM_INSTR_IMPL_A64__LDP_64_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* STP  <Qt1>, <Qt2>, [<Xn|SP>, #<imm>]! (ffc00000/ad800000) */
//#define IEM_INSTR_IMPL_A64__STP_Q_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* LDP  <Qt1>, <Qt2>, [<Xn|SP>, #<imm>]! (ffc00000/adc00000) */
//#define IEM_INSTR_IMPL_A64__LDP_Q_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* STTP  <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]! (ffc00000/e9800000) */
//#define IEM_INSTR_IMPL_A64__STTP_64_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* LDTP  <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]! (ffc00000/e9c00000) */
//#define IEM_INSTR_IMPL_A64__LDTP_64_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* STTP  <Qt1>, <Qt2>, [<Xn|SP>, #<imm>]! (ffc00000/ed800000) */
//#define IEM_INSTR_IMPL_A64__STTP_Q_ldstpair_pre(Rt, Rn, Rt2, imm7)


/* LDTP  <Qt1>, <Qt2>, [<Xn|SP>, #<imm>]! (ffc00000/edc00000) */
//#define IEM_INSTR_IMPL_A64__LDTP_Q_ldstpair_pre(Rt, Rn, Rt2, imm7)



/*
 *
 * Instruction Set & Groups: ldsttags / ldst / A64
 *
 */

/* STG  <Xt|SP>, [<Xn|SP>], #<simm> (ffe00c00/d9200400) */
//#define IEM_INSTR_IMPL_A64__STG_64Spost_ldsttags(Rt, Rn, imm9)


/* STG  <Xt|SP>, [<Xn|SP>{, #<simm>}] (ffe00c00/d9200800) */
//#define IEM_INSTR_IMPL_A64__STG_64Soffset_ldsttags(Rt, Rn, imm9)


/* STG  <Xt|SP>, [<Xn|SP>, #<simm>]! (ffe00c00/d9200c00) */
//#define IEM_INSTR_IMPL_A64__STG_64Spre_ldsttags(Rt, Rn, imm9)


/* STZGM  <Xt>, [<Xn|SP>] (fffffc00/d9200000) */
//#define IEM_INSTR_IMPL_A64__STZGM_64bulk_ldsttags(Rt, Rn)


/* LDG  <Xt>, [<Xn|SP>{, #<simm>}] (ffe00c00/d9600000) */
//#define IEM_INSTR_IMPL_A64__LDG_64Loffset_ldsttags(Rt, Rn, imm9)


/* STZG  <Xt|SP>, [<Xn|SP>], #<simm> (ffe00c00/d9600400) */
//#define IEM_INSTR_IMPL_A64__STZG_64Spost_ldsttags(Rt, Rn, imm9)


/* STZG  <Xt|SP>, [<Xn|SP>{, #<simm>}] (ffe00c00/d9600800) */
//#define IEM_INSTR_IMPL_A64__STZG_64Soffset_ldsttags(Rt, Rn, imm9)


/* STZG  <Xt|SP>, [<Xn|SP>, #<simm>]! (ffe00c00/d9600c00) */
//#define IEM_INSTR_IMPL_A64__STZG_64Spre_ldsttags(Rt, Rn, imm9)


/* ST2G  <Xt|SP>, [<Xn|SP>], #<simm> (ffe00c00/d9a00400) */
//#define IEM_INSTR_IMPL_A64__ST2G_64Spost_ldsttags(Rt, Rn, imm9)


/* ST2G  <Xt|SP>, [<Xn|SP>{, #<simm>}] (ffe00c00/d9a00800) */
//#define IEM_INSTR_IMPL_A64__ST2G_64Soffset_ldsttags(Rt, Rn, imm9)


/* ST2G  <Xt|SP>, [<Xn|SP>, #<simm>]! (ffe00c00/d9a00c00) */
//#define IEM_INSTR_IMPL_A64__ST2G_64Spre_ldsttags(Rt, Rn, imm9)


/* STGM  <Xt>, [<Xn|SP>] (fffffc00/d9a00000) */
//#define IEM_INSTR_IMPL_A64__STGM_64bulk_ldsttags(Rt, Rn)


/* STZ2G  <Xt|SP>, [<Xn|SP>], #<simm> (ffe00c00/d9e00400) */
//#define IEM_INSTR_IMPL_A64__STZ2G_64Spost_ldsttags(Rt, Rn, imm9)


/* STZ2G  <Xt|SP>, [<Xn|SP>{, #<simm>}] (ffe00c00/d9e00800) */
//#define IEM_INSTR_IMPL_A64__STZ2G_64Soffset_ldsttags(Rt, Rn, imm9)


/* STZ2G  <Xt|SP>, [<Xn|SP>, #<simm>]! (ffe00c00/d9e00c00) */
//#define IEM_INSTR_IMPL_A64__STZ2G_64Spre_ldsttags(Rt, Rn, imm9)


/* LDGM  <Xt>, [<Xn|SP>] (fffffc00/d9e00000) */
//#define IEM_INSTR_IMPL_A64__LDGM_64bulk_ldsttags(Rt, Rn)



/*
 *
 * Instruction Set & Groups: loadlit / ldst / A64
 *
 */

/* LDR  <Wt>, <label> (ff000000/18000000) */
#define IEM_INSTR_IMPL_A64__LDR_32_loadlit(Rt, imm19) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_MEM); \
    IEM_MC_LOCAL(uint64_t, uAddr); \
    IEM_MC_FETCH_PC_U64(uAddr); \
    IEM_MC_ADD_CONST_U64_TO_ADDR(uAddr, (int64_t)imm19 << (64 - 19) >> (64 - 19 - 2)); \
    IEM_MC_LOCAL(uint32_t, uValue); \
    IEM_MC_FETCH_MEM_FLAT_U32(uValue, uAddr);  /** @todo tagchecked=true */ \
    IEM_MC_STORE_GREG_U32(Rt, uValue); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* LDR  <St>, <label> (ff000000/1c000000) */
//#define IEM_INSTR_IMPL_A64__LDR_S_loadlit(Rt, imm19)


/* LDR  <Xt>, <label> (ff000000/58000000) */
#define IEM_INSTR_IMPL_A64__LDR_64_loadlit(Rt, imm19) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_MEM); \
    IEM_MC_LOCAL(uint64_t, uAddr); \
    IEM_MC_FETCH_PC_U64(uAddr); \
    IEM_MC_ADD_CONST_U64_TO_ADDR(uAddr, (int64_t)imm19 << (64 - 19) >> (64 - 19 - 2)); \
    IEM_MC_LOCAL(uint64_t, uValue); \
    IEM_MC_FETCH_MEM_FLAT_U64(uValue, uAddr);  /** @todo tagchecked=true */ \
    IEM_MC_STORE_GREG_U64(Rt, uValue); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* LDR  <Dt>, <label> (ff000000/5c000000) */
//#define IEM_INSTR_IMPL_A64__LDR_D_loadlit(Rt, imm19)


/* LDRSW  <Xt>, <label> (ff000000/98000000) */
#define IEM_INSTR_IMPL_A64__LDRSW_64_loadlit(Rt, imm19) \
    IEM_MC_BEGIN(0, IEM_CIMPL_F_MEM); \
    IEM_MC_LOCAL(uint64_t, uAddr); \
    IEM_MC_FETCH_PC_U64(uAddr); \
    IEM_MC_ADD_CONST_U64_TO_ADDR(uAddr, (int64_t)imm19 << (64 - 19) >> (64 - 19 - 2)); \
    IEM_MC_LOCAL(uint64_t, uValue); \
    IEM_MC_FETCH_MEM_FLAT_U32_SX_U64(uValue, uAddr);  /** @todo tagchecked=true */ \
    IEM_MC_STORE_GREG_U64(Rt, uValue); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* LDR  <Qt>, <label> (ff000000/9c000000) */
//#define IEM_INSTR_IMPL_A64__LDR_Q_loadlit(Rt, imm19)


/* PRFM  {<prfop> | #<imm5>}, <label> (ff000000/d8000000) */
#define IEM_INSTR_IMPL_A64__PRFM_P_loadlit(Rt, imm19) \
    RT_NOREF(Rt, imm19); \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()



/*
 *
 * Instruction Set & Groups: log_imm / dpimm / A64
 *
 */

/* AND  <Wd|WSP>, <Wn>, #<imm> (ffc00000/12000000) */
#define IEM_INSTR_IMPL_A64__AND_32_log_imm(Rd, Rn, imms, immr) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL_CONST(uint32_t, fMask, Armv8A64ConvertImmRImmS2Mask32(imms, immr)); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_U32(uTmp, Rn); \
    IEM_MC_AND_2LOCS_U32(uTmp, fMask); \
    IEM_MC_STORE_GREG_SP_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* ORR  <Wd|WSP>, <Wn>, #<imm> (ffc00000/32000000) */
#define IEM_INSTR_IMPL_A64__ORR_32_log_imm(Rd, Rn, imms, immr) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL_CONST(uint32_t, fMask, Armv8A64ConvertImmRImmS2Mask32(imms, immr)); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_U32(uTmp, Rn); \
    IEM_MC_OR_2LOCS_U32(uTmp, fMask); \
    IEM_MC_STORE_GREG_SP_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()

/* EOR  <Wd|WSP>, <Wn>, #<imm> (ffc00000/52000000) */
#define IEM_INSTR_IMPL_A64__EOR_32_log_imm(Rd, Rn, imms, immr) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL_CONST(uint32_t, fMask, Armv8A64ConvertImmRImmS2Mask32(imms, immr)); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_U32(uTmp, Rn); \
    IEM_MC_XOR_2LOCS_U32(uTmp, fMask); \
    IEM_MC_STORE_GREG_SP_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* ANDS  <Wd>, <Wn>, #<imm> (ffc00000/72000000) */
#define IEM_INSTR_IMPL_A64__ANDS_32S_log_imm(Rd, Rn, imms, immr) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL_CONST(uint32_t, fMask, Armv8A64ConvertImmRImmS2Mask32(imms, immr)); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_U32(uTmp, Rn); \
    IEM_MC_A64_ANDS_U32(uTmp, fMask); \
    IEM_MC_STORE_GREG_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* AND  <Xd|SP>, <Xn>, #<imm> (ff800000/92000000) */
#define IEM_INSTR_IMPL_A64__AND_64_log_imm(Rd, Rn, imms, immr, N) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL_CONST(uint64_t, fMask, Armv8A64ConvertImmRImmS2Mask64(N, imms, immr)); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_U64(uTmp, Rn); \
    IEM_MC_AND_2LOCS_U64(uTmp, fMask); \
    IEM_MC_STORE_GREG_SP_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* ORR  <Xd|SP>, <Xn>, #<imm> (ff800000/b2000000) */
#define IEM_INSTR_IMPL_A64__ORR_64_log_imm(Rd, Rn, imms, immr, N) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL_CONST(uint64_t, fMask, Armv8A64ConvertImmRImmS2Mask64(N, imms, immr)); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_U64(uTmp, Rn); \
    IEM_MC_OR_2LOCS_U64(uTmp, fMask); \
    IEM_MC_STORE_GREG_SP_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* EOR  <Xd|SP>, <Xn>, #<imm> (ff800000/d2000000) */
#define IEM_INSTR_IMPL_A64__EOR_64_log_imm(Rd, Rn, imms, immr, N) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL_CONST(uint64_t, fMask, Armv8A64ConvertImmRImmS2Mask64(N, imms, immr)); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_U64(uTmp, Rn); \
    IEM_MC_XOR_2LOCS_U64(uTmp, fMask); \
    IEM_MC_STORE_GREG_SP_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* ANDS  <Xd>, <Xn>, #<imm> (ff800000/f2000000) */
#define IEM_INSTR_IMPL_A64__ANDS_64S_log_imm(Rd, Rn, imms, immr, N) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL_CONST(uint64_t, fMask, Armv8A64ConvertImmRImmS2Mask64(N, imms, immr)); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_U64(uTmp, Rn); \
    IEM_MC_A64_ANDS_U64(uTmp, fMask); \
    IEM_MC_STORE_GREG_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()



/*
 *
 * Instruction Set & Groups: log_shift / dpreg / A64
 *
 */

/* AND  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/0a000000) */
//#define IEM_INSTR_IMPL_A64__AND_32_log_shift(Rd, Rn, imm6, Rm, shift)


/* BIC  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/0a200000) */
//#define IEM_INSTR_IMPL_A64__BIC_32_log_shift(Rd, Rn, imm6, Rm, shift)


/* ORR  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/2a000000) */
//#define IEM_INSTR_IMPL_A64__ORR_32_log_shift(Rd, Rn, imm6, Rm, shift)


/* ORN  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/2a200000) */
//#define IEM_INSTR_IMPL_A64__ORN_32_log_shift(Rd, Rn, imm6, Rm, shift)


/* EOR  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/4a000000) */
//#define IEM_INSTR_IMPL_A64__EOR_32_log_shift(Rd, Rn, imm6, Rm, shift)


/* EON  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/4a200000) */
//#define IEM_INSTR_IMPL_A64__EON_32_log_shift(Rd, Rn, imm6, Rm, shift)


/* ANDS  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/6a000000) */
//#define IEM_INSTR_IMPL_A64__ANDS_32_log_shift(Rd, Rn, imm6, Rm, shift)


/* BICS  <Wd>, <Wn>, <Wm>{, <shift> #<amount>} (ff200000/6a200000) */
//#define IEM_INSTR_IMPL_A64__BICS_32_log_shift(Rd, Rn, imm6, Rm, shift)


/* AND  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/8a000000) */
//#define IEM_INSTR_IMPL_A64__AND_64_log_shift(Rd, Rn, imm6, Rm, shift)


/* BIC  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/8a200000) */
//#define IEM_INSTR_IMPL_A64__BIC_64_log_shift(Rd, Rn, imm6, Rm, shift)


/* ORR  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/aa000000) */
#define IEM_INSTR_IMPL_A64__ORR_64_log_shift(Rd, Rn, imm6, Rm, shift) \
    if (Rn == 31 /*XZR*/ && imm6 == 0 && shift == 0) \
    { \
        IEM_MC_BEGIN(0, 0); \
        IEM_MC_LOCAL(uint64_t, uTmp); \
        IEM_MC_FETCH_GREG_U64(uTmp, Rm); \
        IEM_MC_STORE_GREG_U64(Rd, uTmp); \
        IEM_MC_ADVANCE_PC_AND_FINISH(); \
        IEM_MC_END(); \
    } \
    else if (shift == 0) \
    { \
        IEM_MC_BEGIN(0, 0); \
        IEM_MC_LOCAL(uint64_t, uTmp1); \
        IEM_MC_FETCH_GREG_U64(uTmp1, Rm); \
        IEM_MC_LOCAL(uint64_t, uTmp2); \
        IEM_MC_FETCH_GREG_U64(uTmp2, Rn); \
        IEM_MC_OR_2LOCS_U64(uTmp1, uTmp2); \
        IEM_MC_STORE_GREG_U64(Rd, uTmp1); \
        IEM_MC_ADVANCE_PC_AND_FINISH(); \
        IEM_MC_END(); \
    } \
    else AssertFailedReturn(VERR_IEM_INSTR_NOT_IMPLEMENTED)


/* ORN  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/aa200000) */
//#define IEM_INSTR_IMPL_A64__ORN_64_log_shift(Rd, Rn, imm6, Rm, shift)


/* EOR  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/ca000000) */
//#define IEM_INSTR_IMPL_A64__EOR_64_log_shift(Rd, Rn, imm6, Rm, shift)


/* EON  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/ca200000) */
//#define IEM_INSTR_IMPL_A64__EON_64_log_shift(Rd, Rn, imm6, Rm, shift)


/* ANDS  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/ea000000) */
//#define IEM_INSTR_IMPL_A64__ANDS_64_log_shift(Rd, Rn, imm6, Rm, shift)


/* BICS  <Xd>, <Xn>, <Xm>{, <shift> #<amount>} (ff200000/ea200000) */
//#define IEM_INSTR_IMPL_A64__BICS_64_log_shift(Rd, Rn, imm6, Rm, shift)



/*
 *
 * Instruction Set & Groups: memcms / ldst / A64
 *
 */

/* CPYFP  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19000400) */
//#define IEM_INSTR_IMPL_A64__CPYFP_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPWT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19001400) */
//#define IEM_INSTR_IMPL_A64__CPYFPWT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPRT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19002400) */
//#define IEM_INSTR_IMPL_A64__CPYFPRT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19003400) */
//#define IEM_INSTR_IMPL_A64__CPYFPT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19004400) */
//#define IEM_INSTR_IMPL_A64__CPYFPWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPWTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19005400) */
//#define IEM_INSTR_IMPL_A64__CPYFPWTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPRTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19006400) */
//#define IEM_INSTR_IMPL_A64__CPYFPRTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19007400) */
//#define IEM_INSTR_IMPL_A64__CPYFPTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19008400) */
//#define IEM_INSTR_IMPL_A64__CPYFPRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPWTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19009400) */
//#define IEM_INSTR_IMPL_A64__CPYFPWTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPRTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1900a400) */
//#define IEM_INSTR_IMPL_A64__CPYFPRTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1900b400) */
//#define IEM_INSTR_IMPL_A64__CPYFPTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1900c400) */
//#define IEM_INSTR_IMPL_A64__CPYFPN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPWTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1900d400) */
//#define IEM_INSTR_IMPL_A64__CPYFPWTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPRTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1900e400) */
//#define IEM_INSTR_IMPL_A64__CPYFPRTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFPTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1900f400) */
//#define IEM_INSTR_IMPL_A64__CPYFPTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFM  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19400400) */
//#define IEM_INSTR_IMPL_A64__CPYFM_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMWT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19401400) */
//#define IEM_INSTR_IMPL_A64__CPYFMWT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMRT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19402400) */
//#define IEM_INSTR_IMPL_A64__CPYFMRT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19403400) */
//#define IEM_INSTR_IMPL_A64__CPYFMT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19404400) */
//#define IEM_INSTR_IMPL_A64__CPYFMWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMWTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19405400) */
//#define IEM_INSTR_IMPL_A64__CPYFMWTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMRTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19406400) */
//#define IEM_INSTR_IMPL_A64__CPYFMRTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19407400) */
//#define IEM_INSTR_IMPL_A64__CPYFMTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19408400) */
//#define IEM_INSTR_IMPL_A64__CPYFMRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMWTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19409400) */
//#define IEM_INSTR_IMPL_A64__CPYFMWTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMRTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1940a400) */
//#define IEM_INSTR_IMPL_A64__CPYFMRTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1940b400) */
//#define IEM_INSTR_IMPL_A64__CPYFMTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1940c400) */
//#define IEM_INSTR_IMPL_A64__CPYFMN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMWTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1940d400) */
//#define IEM_INSTR_IMPL_A64__CPYFMWTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMRTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1940e400) */
//#define IEM_INSTR_IMPL_A64__CPYFMRTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFMTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1940f400) */
//#define IEM_INSTR_IMPL_A64__CPYFMTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFE  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19800400) */
//#define IEM_INSTR_IMPL_A64__CPYFE_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFEWT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19801400) */
//#define IEM_INSTR_IMPL_A64__CPYFEWT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFERT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19802400) */
//#define IEM_INSTR_IMPL_A64__CPYFERT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFET  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19803400) */
//#define IEM_INSTR_IMPL_A64__CPYFET_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFEWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19804400) */
//#define IEM_INSTR_IMPL_A64__CPYFEWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFEWTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19805400) */
//#define IEM_INSTR_IMPL_A64__CPYFEWTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFERTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19806400) */
//#define IEM_INSTR_IMPL_A64__CPYFERTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFETWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19807400) */
//#define IEM_INSTR_IMPL_A64__CPYFETWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFERN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19808400) */
//#define IEM_INSTR_IMPL_A64__CPYFERN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFEWTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/19809400) */
//#define IEM_INSTR_IMPL_A64__CPYFEWTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFERTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1980a400) */
//#define IEM_INSTR_IMPL_A64__CPYFERTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFETRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1980b400) */
//#define IEM_INSTR_IMPL_A64__CPYFETRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFEN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1980c400) */
//#define IEM_INSTR_IMPL_A64__CPYFEN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFEWTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1980d400) */
//#define IEM_INSTR_IMPL_A64__CPYFEWTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFERTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1980e400) */
//#define IEM_INSTR_IMPL_A64__CPYFERTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYFETN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1980f400) */
//#define IEM_INSTR_IMPL_A64__CPYFETN_CPY_memcms(Rd, Rn, Rs, sz)


/* SETP  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c00400) */
//#define IEM_INSTR_IMPL_A64__SETP_SET_memcms(Rd, Rn, Rs, sz)


/* SETPT  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c01400) */
//#define IEM_INSTR_IMPL_A64__SETPT_SET_memcms(Rd, Rn, Rs, sz)


/* SETPN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c02400) */
//#define IEM_INSTR_IMPL_A64__SETPN_SET_memcms(Rd, Rn, Rs, sz)


/* SETPTN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c03400) */
//#define IEM_INSTR_IMPL_A64__SETPTN_SET_memcms(Rd, Rn, Rs, sz)


/* SETM  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c04400) */
//#define IEM_INSTR_IMPL_A64__SETM_SET_memcms(Rd, Rn, Rs, sz)


/* SETMT  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c05400) */
//#define IEM_INSTR_IMPL_A64__SETMT_SET_memcms(Rd, Rn, Rs, sz)


/* SETMN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c06400) */
//#define IEM_INSTR_IMPL_A64__SETMN_SET_memcms(Rd, Rn, Rs, sz)


/* SETMTN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c07400) */
//#define IEM_INSTR_IMPL_A64__SETMTN_SET_memcms(Rd, Rn, Rs, sz)


/* SETE  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c08400) */
//#define IEM_INSTR_IMPL_A64__SETE_SET_memcms(Rd, Rn, Rs, sz)


/* SETET  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c09400) */
//#define IEM_INSTR_IMPL_A64__SETET_SET_memcms(Rd, Rn, Rs, sz)


/* SETEN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c0a400) */
//#define IEM_INSTR_IMPL_A64__SETEN_SET_memcms(Rd, Rn, Rs, sz)


/* SETETN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/19c0b400) */
//#define IEM_INSTR_IMPL_A64__SETETN_SET_memcms(Rd, Rn, Rs, sz)


/* CPYP  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d000400) */
//#define IEM_INSTR_IMPL_A64__CPYP_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPWT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d001400) */
//#define IEM_INSTR_IMPL_A64__CPYPWT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPRT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d002400) */
//#define IEM_INSTR_IMPL_A64__CPYPRT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d003400) */
//#define IEM_INSTR_IMPL_A64__CPYPT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d004400) */
//#define IEM_INSTR_IMPL_A64__CPYPWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPWTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d005400) */
//#define IEM_INSTR_IMPL_A64__CPYPWTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPRTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d006400) */
//#define IEM_INSTR_IMPL_A64__CPYPRTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d007400) */
//#define IEM_INSTR_IMPL_A64__CPYPTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d008400) */
//#define IEM_INSTR_IMPL_A64__CPYPRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPWTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d009400) */
//#define IEM_INSTR_IMPL_A64__CPYPWTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPRTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d00a400) */
//#define IEM_INSTR_IMPL_A64__CPYPRTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d00b400) */
//#define IEM_INSTR_IMPL_A64__CPYPTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d00c400) */
//#define IEM_INSTR_IMPL_A64__CPYPN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPWTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d00d400) */
//#define IEM_INSTR_IMPL_A64__CPYPWTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPRTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d00e400) */
//#define IEM_INSTR_IMPL_A64__CPYPRTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYPTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d00f400) */
//#define IEM_INSTR_IMPL_A64__CPYPTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYM  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d400400) */
//#define IEM_INSTR_IMPL_A64__CPYM_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMWT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d401400) */
//#define IEM_INSTR_IMPL_A64__CPYMWT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMRT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d402400) */
//#define IEM_INSTR_IMPL_A64__CPYMRT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d403400) */
//#define IEM_INSTR_IMPL_A64__CPYMT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d404400) */
//#define IEM_INSTR_IMPL_A64__CPYMWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMWTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d405400) */
//#define IEM_INSTR_IMPL_A64__CPYMWTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMRTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d406400) */
//#define IEM_INSTR_IMPL_A64__CPYMRTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d407400) */
//#define IEM_INSTR_IMPL_A64__CPYMTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d408400) */
//#define IEM_INSTR_IMPL_A64__CPYMRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMWTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d409400) */
//#define IEM_INSTR_IMPL_A64__CPYMWTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMRTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d40a400) */
//#define IEM_INSTR_IMPL_A64__CPYMRTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d40b400) */
//#define IEM_INSTR_IMPL_A64__CPYMTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d40c400) */
//#define IEM_INSTR_IMPL_A64__CPYMN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMWTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d40d400) */
//#define IEM_INSTR_IMPL_A64__CPYMWTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMRTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d40e400) */
//#define IEM_INSTR_IMPL_A64__CPYMRTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYMTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d40f400) */
//#define IEM_INSTR_IMPL_A64__CPYMTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYE  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d800400) */
//#define IEM_INSTR_IMPL_A64__CPYE_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYEWT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d801400) */
//#define IEM_INSTR_IMPL_A64__CPYEWT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYERT  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d802400) */
//#define IEM_INSTR_IMPL_A64__CPYERT_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYET  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d803400) */
//#define IEM_INSTR_IMPL_A64__CPYET_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYEWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d804400) */
//#define IEM_INSTR_IMPL_A64__CPYEWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYEWTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d805400) */
//#define IEM_INSTR_IMPL_A64__CPYEWTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYERTWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d806400) */
//#define IEM_INSTR_IMPL_A64__CPYERTWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYETWN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d807400) */
//#define IEM_INSTR_IMPL_A64__CPYETWN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYERN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d808400) */
//#define IEM_INSTR_IMPL_A64__CPYERN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYEWTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d809400) */
//#define IEM_INSTR_IMPL_A64__CPYEWTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYERTRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d80a400) */
//#define IEM_INSTR_IMPL_A64__CPYERTRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYETRN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d80b400) */
//#define IEM_INSTR_IMPL_A64__CPYETRN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYEN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d80c400) */
//#define IEM_INSTR_IMPL_A64__CPYEN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYEWTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d80d400) */
//#define IEM_INSTR_IMPL_A64__CPYEWTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYERTN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d80e400) */
//#define IEM_INSTR_IMPL_A64__CPYERTN_CPY_memcms(Rd, Rn, Rs, sz)


/* CPYETN  [<Xd>]!, [<Xs>]!, <Xn>! (3fe0fc00/1d80f400) */
//#define IEM_INSTR_IMPL_A64__CPYETN_CPY_memcms(Rd, Rn, Rs, sz)


/* SETGP  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc00400) */
//#define IEM_INSTR_IMPL_A64__SETGP_SET_memcms(Rd, Rn, Rs, sz)


/* SETGPT  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc01400) */
//#define IEM_INSTR_IMPL_A64__SETGPT_SET_memcms(Rd, Rn, Rs, sz)


/* SETGPN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc02400) */
//#define IEM_INSTR_IMPL_A64__SETGPN_SET_memcms(Rd, Rn, Rs, sz)


/* SETGPTN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc03400) */
//#define IEM_INSTR_IMPL_A64__SETGPTN_SET_memcms(Rd, Rn, Rs, sz)


/* SETGM  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc04400) */
//#define IEM_INSTR_IMPL_A64__SETGM_SET_memcms(Rd, Rn, Rs, sz)


/* SETGMT  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc05400) */
//#define IEM_INSTR_IMPL_A64__SETGMT_SET_memcms(Rd, Rn, Rs, sz)


/* SETGMN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc06400) */
//#define IEM_INSTR_IMPL_A64__SETGMN_SET_memcms(Rd, Rn, Rs, sz)


/* SETGMTN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc07400) */
//#define IEM_INSTR_IMPL_A64__SETGMTN_SET_memcms(Rd, Rn, Rs, sz)


/* SETGE  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc08400) */
//#define IEM_INSTR_IMPL_A64__SETGE_SET_memcms(Rd, Rn, Rs, sz)


/* SETGET  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc09400) */
//#define IEM_INSTR_IMPL_A64__SETGET_SET_memcms(Rd, Rn, Rs, sz)


/* SETGEN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc0a400) */
//#define IEM_INSTR_IMPL_A64__SETGEN_SET_memcms(Rd, Rn, Rs, sz)


/* SETGETN  [<Xd>]!, <Xn>!, <Xs> (3fe0fc00/1dc0b400) */
//#define IEM_INSTR_IMPL_A64__SETGETN_SET_memcms(Rd, Rn, Rs, sz)



/*
 *
 * Instruction Set & Groups: memop / ldst / A64
 *
 */

/* LDADDB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38200000) */
//#define IEM_INSTR_IMPL_A64__LDADDB_32_memop(Rt, Rn, Rs)


/* LDCLRB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38201000) */
//#define IEM_INSTR_IMPL_A64__LDCLRB_32_memop(Rt, Rn, Rs)


/* LDEORB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38202000) */
//#define IEM_INSTR_IMPL_A64__LDEORB_32_memop(Rt, Rn, Rs)


/* LDSETB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38203000) */
//#define IEM_INSTR_IMPL_A64__LDSETB_32_memop(Rt, Rn, Rs)


/* LDSMAXB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38204000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXB_32_memop(Rt, Rn, Rs)


/* LDSMINB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38205000) */
//#define IEM_INSTR_IMPL_A64__LDSMINB_32_memop(Rt, Rn, Rs)


/* LDUMAXB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38206000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXB_32_memop(Rt, Rn, Rs)


/* LDUMINB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38207000) */
//#define IEM_INSTR_IMPL_A64__LDUMINB_32_memop(Rt, Rn, Rs)


/* SWPB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38208000) */
//#define IEM_INSTR_IMPL_A64__SWPB_32_memop(Rt, Rn, Rs)


/* RCWCLR  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/38209000) */
//#define IEM_INSTR_IMPL_A64__RCWCLR_64_memop(Rt, Rn, Rs)


/* RCWSWP  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/3820a000) */
//#define IEM_INSTR_IMPL_A64__RCWSWP_64_memop(Rt, Rn, Rs)


/* RCWSET  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/3820b000) */
//#define IEM_INSTR_IMPL_A64__RCWSET_64_memop(Rt, Rn, Rs)


/* LDADDLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38600000) */
//#define IEM_INSTR_IMPL_A64__LDADDLB_32_memop(Rt, Rn, Rs)


/* LDCLRLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38601000) */
//#define IEM_INSTR_IMPL_A64__LDCLRLB_32_memop(Rt, Rn, Rs)


/* LDEORLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38602000) */
//#define IEM_INSTR_IMPL_A64__LDEORLB_32_memop(Rt, Rn, Rs)


/* LDSETLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38603000) */
//#define IEM_INSTR_IMPL_A64__LDSETLB_32_memop(Rt, Rn, Rs)


/* LDSMAXLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38604000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXLB_32_memop(Rt, Rn, Rs)


/* LDSMINLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38605000) */
//#define IEM_INSTR_IMPL_A64__LDSMINLB_32_memop(Rt, Rn, Rs)


/* LDUMAXLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38606000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXLB_32_memop(Rt, Rn, Rs)


/* LDUMINLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38607000) */
//#define IEM_INSTR_IMPL_A64__LDUMINLB_32_memop(Rt, Rn, Rs)


/* SWPLB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38608000) */
//#define IEM_INSTR_IMPL_A64__SWPLB_32_memop(Rt, Rn, Rs)


/* RCWCLRL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/38609000) */
//#define IEM_INSTR_IMPL_A64__RCWCLRL_64_memop(Rt, Rn, Rs)


/* RCWSWPL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/3860a000) */
//#define IEM_INSTR_IMPL_A64__RCWSWPL_64_memop(Rt, Rn, Rs)


/* RCWSETL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/3860b000) */
//#define IEM_INSTR_IMPL_A64__RCWSETL_64_memop(Rt, Rn, Rs)


/* LDADDAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a00000) */
//#define IEM_INSTR_IMPL_A64__LDADDAB_32_memop(Rt, Rn, Rs)


/* LDCLRAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRAB_32_memop(Rt, Rn, Rs)


/* LDEORAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a02000) */
//#define IEM_INSTR_IMPL_A64__LDEORAB_32_memop(Rt, Rn, Rs)


/* LDSETAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a03000) */
//#define IEM_INSTR_IMPL_A64__LDSETAB_32_memop(Rt, Rn, Rs)


/* LDSMAXAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a04000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXAB_32_memop(Rt, Rn, Rs)


/* LDSMINAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a05000) */
//#define IEM_INSTR_IMPL_A64__LDSMINAB_32_memop(Rt, Rn, Rs)


/* LDUMAXAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a06000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXAB_32_memop(Rt, Rn, Rs)


/* LDUMINAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a07000) */
//#define IEM_INSTR_IMPL_A64__LDUMINAB_32_memop(Rt, Rn, Rs)


/* SWPAB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38a08000) */
//#define IEM_INSTR_IMPL_A64__SWPAB_32_memop(Rt, Rn, Rs)


/* RCWCLRA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/38a09000) */
//#define IEM_INSTR_IMPL_A64__RCWCLRA_64_memop(Rt, Rn, Rs)


/* RCWSWPA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/38a0a000) */
//#define IEM_INSTR_IMPL_A64__RCWSWPA_64_memop(Rt, Rn, Rs)


/* RCWSETA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/38a0b000) */
//#define IEM_INSTR_IMPL_A64__RCWSETA_64_memop(Rt, Rn, Rs)


/* LDAPRB  <Wt>, [<Xn|SP>{ , #0}] (fffffc00/38bfc000) */
//#define IEM_INSTR_IMPL_A64__LDAPRB_32L_memop(Rt, Rn)


/* LDADDALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e00000) */
//#define IEM_INSTR_IMPL_A64__LDADDALB_32_memop(Rt, Rn, Rs)


/* LDCLRALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRALB_32_memop(Rt, Rn, Rs)


/* LDEORALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e02000) */
//#define IEM_INSTR_IMPL_A64__LDEORALB_32_memop(Rt, Rn, Rs)


/* LDSETALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e03000) */
//#define IEM_INSTR_IMPL_A64__LDSETALB_32_memop(Rt, Rn, Rs)


/* LDSMAXALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e04000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXALB_32_memop(Rt, Rn, Rs)


/* LDSMINALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e05000) */
//#define IEM_INSTR_IMPL_A64__LDSMINALB_32_memop(Rt, Rn, Rs)


/* LDUMAXALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e06000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXALB_32_memop(Rt, Rn, Rs)


/* LDUMINALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e07000) */
//#define IEM_INSTR_IMPL_A64__LDUMINALB_32_memop(Rt, Rn, Rs)


/* SWPALB  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/38e08000) */
//#define IEM_INSTR_IMPL_A64__SWPALB_32_memop(Rt, Rn, Rs)


/* RCWCLRAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/38e09000) */
//#define IEM_INSTR_IMPL_A64__RCWCLRAL_64_memop(Rt, Rn, Rs)


/* RCWSWPAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/38e0a000) */
//#define IEM_INSTR_IMPL_A64__RCWSWPAL_64_memop(Rt, Rn, Rs)


/* RCWSETAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/38e0b000) */
//#define IEM_INSTR_IMPL_A64__RCWSETAL_64_memop(Rt, Rn, Rs)


/* LDADDH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78200000) */
//#define IEM_INSTR_IMPL_A64__LDADDH_32_memop(Rt, Rn, Rs)


/* LDCLRH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78201000) */
//#define IEM_INSTR_IMPL_A64__LDCLRH_32_memop(Rt, Rn, Rs)


/* LDEORH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78202000) */
//#define IEM_INSTR_IMPL_A64__LDEORH_32_memop(Rt, Rn, Rs)


/* LDSETH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78203000) */
//#define IEM_INSTR_IMPL_A64__LDSETH_32_memop(Rt, Rn, Rs)


/* LDSMAXH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78204000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXH_32_memop(Rt, Rn, Rs)


/* LDSMINH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78205000) */
//#define IEM_INSTR_IMPL_A64__LDSMINH_32_memop(Rt, Rn, Rs)


/* LDUMAXH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78206000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXH_32_memop(Rt, Rn, Rs)


/* LDUMINH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78207000) */
//#define IEM_INSTR_IMPL_A64__LDUMINH_32_memop(Rt, Rn, Rs)


/* SWPH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78208000) */
//#define IEM_INSTR_IMPL_A64__SWPH_32_memop(Rt, Rn, Rs)


/* RCWSCLR  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/78209000) */
//#define IEM_INSTR_IMPL_A64__RCWSCLR_64_memop(Rt, Rn, Rs)


/* RCWSSWP  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/7820a000) */
//#define IEM_INSTR_IMPL_A64__RCWSSWP_64_memop(Rt, Rn, Rs)


/* RCWSSET  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/7820b000) */
//#define IEM_INSTR_IMPL_A64__RCWSSET_64_memop(Rt, Rn, Rs)


/* LDADDLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78600000) */
//#define IEM_INSTR_IMPL_A64__LDADDLH_32_memop(Rt, Rn, Rs)


/* LDCLRLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78601000) */
//#define IEM_INSTR_IMPL_A64__LDCLRLH_32_memop(Rt, Rn, Rs)


/* LDEORLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78602000) */
//#define IEM_INSTR_IMPL_A64__LDEORLH_32_memop(Rt, Rn, Rs)


/* LDSETLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78603000) */
//#define IEM_INSTR_IMPL_A64__LDSETLH_32_memop(Rt, Rn, Rs)


/* LDSMAXLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78604000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXLH_32_memop(Rt, Rn, Rs)


/* LDSMINLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78605000) */
//#define IEM_INSTR_IMPL_A64__LDSMINLH_32_memop(Rt, Rn, Rs)


/* LDUMAXLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78606000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXLH_32_memop(Rt, Rn, Rs)


/* LDUMINLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78607000) */
//#define IEM_INSTR_IMPL_A64__LDUMINLH_32_memop(Rt, Rn, Rs)


/* SWPLH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78608000) */
//#define IEM_INSTR_IMPL_A64__SWPLH_32_memop(Rt, Rn, Rs)


/* RCWSCLRL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/78609000) */
//#define IEM_INSTR_IMPL_A64__RCWSCLRL_64_memop(Rt, Rn, Rs)


/* RCWSSWPL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/7860a000) */
//#define IEM_INSTR_IMPL_A64__RCWSSWPL_64_memop(Rt, Rn, Rs)


/* RCWSSETL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/7860b000) */
//#define IEM_INSTR_IMPL_A64__RCWSSETL_64_memop(Rt, Rn, Rs)


/* LDADDAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a00000) */
//#define IEM_INSTR_IMPL_A64__LDADDAH_32_memop(Rt, Rn, Rs)


/* LDCLRAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRAH_32_memop(Rt, Rn, Rs)


/* LDEORAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a02000) */
//#define IEM_INSTR_IMPL_A64__LDEORAH_32_memop(Rt, Rn, Rs)


/* LDSETAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a03000) */
//#define IEM_INSTR_IMPL_A64__LDSETAH_32_memop(Rt, Rn, Rs)


/* LDSMAXAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a04000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXAH_32_memop(Rt, Rn, Rs)


/* LDSMINAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a05000) */
//#define IEM_INSTR_IMPL_A64__LDSMINAH_32_memop(Rt, Rn, Rs)


/* LDUMAXAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a06000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXAH_32_memop(Rt, Rn, Rs)


/* LDUMINAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a07000) */
//#define IEM_INSTR_IMPL_A64__LDUMINAH_32_memop(Rt, Rn, Rs)


/* SWPAH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78a08000) */
//#define IEM_INSTR_IMPL_A64__SWPAH_32_memop(Rt, Rn, Rs)


/* RCWSCLRA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/78a09000) */
//#define IEM_INSTR_IMPL_A64__RCWSCLRA_64_memop(Rt, Rn, Rs)


/* RCWSSWPA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/78a0a000) */
//#define IEM_INSTR_IMPL_A64__RCWSSWPA_64_memop(Rt, Rn, Rs)


/* RCWSSETA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/78a0b000) */
//#define IEM_INSTR_IMPL_A64__RCWSSETA_64_memop(Rt, Rn, Rs)


/* LDAPRH  <Wt>, [<Xn|SP>{ , #0}] (fffffc00/78bfc000) */
//#define IEM_INSTR_IMPL_A64__LDAPRH_32L_memop(Rt, Rn)


/* LDADDALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e00000) */
//#define IEM_INSTR_IMPL_A64__LDADDALH_32_memop(Rt, Rn, Rs)


/* LDCLRALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRALH_32_memop(Rt, Rn, Rs)


/* LDEORALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e02000) */
//#define IEM_INSTR_IMPL_A64__LDEORALH_32_memop(Rt, Rn, Rs)


/* LDSETALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e03000) */
//#define IEM_INSTR_IMPL_A64__LDSETALH_32_memop(Rt, Rn, Rs)


/* LDSMAXALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e04000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXALH_32_memop(Rt, Rn, Rs)


/* LDSMINALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e05000) */
//#define IEM_INSTR_IMPL_A64__LDSMINALH_32_memop(Rt, Rn, Rs)


/* LDUMAXALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e06000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXALH_32_memop(Rt, Rn, Rs)


/* LDUMINALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e07000) */
//#define IEM_INSTR_IMPL_A64__LDUMINALH_32_memop(Rt, Rn, Rs)


/* SWPALH  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/78e08000) */
//#define IEM_INSTR_IMPL_A64__SWPALH_32_memop(Rt, Rn, Rs)


/* RCWSCLRAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/78e09000) */
//#define IEM_INSTR_IMPL_A64__RCWSCLRAL_64_memop(Rt, Rn, Rs)


/* RCWSSWPAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/78e0a000) */
//#define IEM_INSTR_IMPL_A64__RCWSSWPAL_64_memop(Rt, Rn, Rs)


/* RCWSSETAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/78e0b000) */
//#define IEM_INSTR_IMPL_A64__RCWSSETAL_64_memop(Rt, Rn, Rs)


/* LDADD  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8200000) */
//#define IEM_INSTR_IMPL_A64__LDADD_32_memop(Rt, Rn, Rs)


/* LDCLR  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8201000) */
//#define IEM_INSTR_IMPL_A64__LDCLR_32_memop(Rt, Rn, Rs)


/* LDEOR  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8202000) */
//#define IEM_INSTR_IMPL_A64__LDEOR_32_memop(Rt, Rn, Rs)


/* LDSET  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8203000) */
//#define IEM_INSTR_IMPL_A64__LDSET_32_memop(Rt, Rn, Rs)


/* LDSMAX  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8204000) */
//#define IEM_INSTR_IMPL_A64__LDSMAX_32_memop(Rt, Rn, Rs)


/* LDSMIN  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8205000) */
//#define IEM_INSTR_IMPL_A64__LDSMIN_32_memop(Rt, Rn, Rs)


/* LDUMAX  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8206000) */
//#define IEM_INSTR_IMPL_A64__LDUMAX_32_memop(Rt, Rn, Rs)


/* LDUMIN  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8207000) */
//#define IEM_INSTR_IMPL_A64__LDUMIN_32_memop(Rt, Rn, Rs)


/* SWP  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8208000) */
//#define IEM_INSTR_IMPL_A64__SWP_32_memop(Rt, Rn, Rs)


/* LDADDL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8600000) */
//#define IEM_INSTR_IMPL_A64__LDADDL_32_memop(Rt, Rn, Rs)


/* LDCLRL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8601000) */
//#define IEM_INSTR_IMPL_A64__LDCLRL_32_memop(Rt, Rn, Rs)


/* LDEORL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8602000) */
//#define IEM_INSTR_IMPL_A64__LDEORL_32_memop(Rt, Rn, Rs)


/* LDSETL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8603000) */
//#define IEM_INSTR_IMPL_A64__LDSETL_32_memop(Rt, Rn, Rs)


/* LDSMAXL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8604000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXL_32_memop(Rt, Rn, Rs)


/* LDSMINL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8605000) */
//#define IEM_INSTR_IMPL_A64__LDSMINL_32_memop(Rt, Rn, Rs)


/* LDUMAXL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8606000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXL_32_memop(Rt, Rn, Rs)


/* LDUMINL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8607000) */
//#define IEM_INSTR_IMPL_A64__LDUMINL_32_memop(Rt, Rn, Rs)


/* SWPL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8608000) */
//#define IEM_INSTR_IMPL_A64__SWPL_32_memop(Rt, Rn, Rs)


/* LDADDA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a00000) */
//#define IEM_INSTR_IMPL_A64__LDADDA_32_memop(Rt, Rn, Rs)


/* LDCLRA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRA_32_memop(Rt, Rn, Rs)


/* LDEORA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a02000) */
//#define IEM_INSTR_IMPL_A64__LDEORA_32_memop(Rt, Rn, Rs)


/* LDSETA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a03000) */
//#define IEM_INSTR_IMPL_A64__LDSETA_32_memop(Rt, Rn, Rs)


/* LDSMAXA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a04000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXA_32_memop(Rt, Rn, Rs)


/* LDSMINA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a05000) */
//#define IEM_INSTR_IMPL_A64__LDSMINA_32_memop(Rt, Rn, Rs)


/* LDUMAXA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a06000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXA_32_memop(Rt, Rn, Rs)


/* LDUMINA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a07000) */
//#define IEM_INSTR_IMPL_A64__LDUMINA_32_memop(Rt, Rn, Rs)


/* SWPA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8a08000) */
//#define IEM_INSTR_IMPL_A64__SWPA_32_memop(Rt, Rn, Rs)


/* LDAPR  <Wt>, [<Xn|SP>{ , #0}] (fffffc00/b8bfc000) */
//#define IEM_INSTR_IMPL_A64__LDAPR_32L_memop(Rt, Rn)


/* LDADDAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e00000) */
//#define IEM_INSTR_IMPL_A64__LDADDAL_32_memop(Rt, Rn, Rs)


/* LDCLRAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRAL_32_memop(Rt, Rn, Rs)


/* LDEORAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e02000) */
//#define IEM_INSTR_IMPL_A64__LDEORAL_32_memop(Rt, Rn, Rs)


/* LDSETAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e03000) */
//#define IEM_INSTR_IMPL_A64__LDSETAL_32_memop(Rt, Rn, Rs)


/* LDSMAXAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e04000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXAL_32_memop(Rt, Rn, Rs)


/* LDSMINAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e05000) */
//#define IEM_INSTR_IMPL_A64__LDSMINAL_32_memop(Rt, Rn, Rs)


/* LDUMAXAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e06000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXAL_32_memop(Rt, Rn, Rs)


/* LDUMINAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e07000) */
//#define IEM_INSTR_IMPL_A64__LDUMINAL_32_memop(Rt, Rn, Rs)


/* SWPAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/b8e08000) */
//#define IEM_INSTR_IMPL_A64__SWPAL_32_memop(Rt, Rn, Rs)


/* LDADD  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8200000) */
//#define IEM_INSTR_IMPL_A64__LDADD_64_memop(Rt, Rn, Rs)


/* LDCLR  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8201000) */
//#define IEM_INSTR_IMPL_A64__LDCLR_64_memop(Rt, Rn, Rs)


/* LDEOR  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8202000) */
//#define IEM_INSTR_IMPL_A64__LDEOR_64_memop(Rt, Rn, Rs)


/* LDSET  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8203000) */
//#define IEM_INSTR_IMPL_A64__LDSET_64_memop(Rt, Rn, Rs)


/* LDSMAX  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8204000) */
//#define IEM_INSTR_IMPL_A64__LDSMAX_64_memop(Rt, Rn, Rs)


/* LDSMIN  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8205000) */
//#define IEM_INSTR_IMPL_A64__LDSMIN_64_memop(Rt, Rn, Rs)


/* LDUMAX  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8206000) */
//#define IEM_INSTR_IMPL_A64__LDUMAX_64_memop(Rt, Rn, Rs)


/* LDUMIN  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8207000) */
//#define IEM_INSTR_IMPL_A64__LDUMIN_64_memop(Rt, Rn, Rs)


/* SWP  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8208000) */
//#define IEM_INSTR_IMPL_A64__SWP_64_memop(Rt, Rn, Rs)


/* ST64BV0  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f820a000) */
//#define IEM_INSTR_IMPL_A64__ST64BV0_64_memop(Rt, Rn, Rs)


/* ST64BV  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f820b000) */
//#define IEM_INSTR_IMPL_A64__ST64BV_64_memop(Rt, Rn, Rs)


/* ST64B  <Xt>, [<Xn|SP>{ , #0}] (fffffc00/f83f9000) */
//#define IEM_INSTR_IMPL_A64__ST64B_64L_memop(Rt, Rn)


/* LD64B  <Xt>, [<Xn|SP>{ , #0}] (fffffc00/f83fd000) */
//#define IEM_INSTR_IMPL_A64__LD64B_64L_memop(Rt, Rn)


/* LDADDL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8600000) */
//#define IEM_INSTR_IMPL_A64__LDADDL_64_memop(Rt, Rn, Rs)


/* LDCLRL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8601000) */
//#define IEM_INSTR_IMPL_A64__LDCLRL_64_memop(Rt, Rn, Rs)


/* LDEORL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8602000) */
//#define IEM_INSTR_IMPL_A64__LDEORL_64_memop(Rt, Rn, Rs)


/* LDSETL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8603000) */
//#define IEM_INSTR_IMPL_A64__LDSETL_64_memop(Rt, Rn, Rs)


/* LDSMAXL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8604000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXL_64_memop(Rt, Rn, Rs)


/* LDSMINL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8605000) */
//#define IEM_INSTR_IMPL_A64__LDSMINL_64_memop(Rt, Rn, Rs)


/* LDUMAXL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8606000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXL_64_memop(Rt, Rn, Rs)


/* LDUMINL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8607000) */
//#define IEM_INSTR_IMPL_A64__LDUMINL_64_memop(Rt, Rn, Rs)


/* SWPL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8608000) */
//#define IEM_INSTR_IMPL_A64__SWPL_64_memop(Rt, Rn, Rs)


/* LDADDA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a00000) */
//#define IEM_INSTR_IMPL_A64__LDADDA_64_memop(Rt, Rn, Rs)


/* LDCLRA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRA_64_memop(Rt, Rn, Rs)


/* LDEORA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a02000) */
//#define IEM_INSTR_IMPL_A64__LDEORA_64_memop(Rt, Rn, Rs)


/* LDSETA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a03000) */
//#define IEM_INSTR_IMPL_A64__LDSETA_64_memop(Rt, Rn, Rs)


/* LDSMAXA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a04000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXA_64_memop(Rt, Rn, Rs)


/* LDSMINA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a05000) */
//#define IEM_INSTR_IMPL_A64__LDSMINA_64_memop(Rt, Rn, Rs)


/* LDUMAXA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a06000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXA_64_memop(Rt, Rn, Rs)


/* LDUMINA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a07000) */
//#define IEM_INSTR_IMPL_A64__LDUMINA_64_memop(Rt, Rn, Rs)


/* SWPA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8a08000) */
//#define IEM_INSTR_IMPL_A64__SWPA_64_memop(Rt, Rn, Rs)


/* LDAPR  <Xt>, [<Xn|SP>{ , #0}] (fffffc00/f8bfc000) */
//#define IEM_INSTR_IMPL_A64__LDAPR_64L_memop(Rt, Rn)


/* LDADDAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e00000) */
//#define IEM_INSTR_IMPL_A64__LDADDAL_64_memop(Rt, Rn, Rs)


/* LDCLRAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRAL_64_memop(Rt, Rn, Rs)


/* LDEORAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e02000) */
//#define IEM_INSTR_IMPL_A64__LDEORAL_64_memop(Rt, Rn, Rs)


/* LDSETAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e03000) */
//#define IEM_INSTR_IMPL_A64__LDSETAL_64_memop(Rt, Rn, Rs)


/* LDSMAXAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e04000) */
//#define IEM_INSTR_IMPL_A64__LDSMAXAL_64_memop(Rt, Rn, Rs)


/* LDSMINAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e05000) */
//#define IEM_INSTR_IMPL_A64__LDSMINAL_64_memop(Rt, Rn, Rs)


/* LDUMAXAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e06000) */
//#define IEM_INSTR_IMPL_A64__LDUMAXAL_64_memop(Rt, Rn, Rs)


/* LDUMINAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e07000) */
//#define IEM_INSTR_IMPL_A64__LDUMINAL_64_memop(Rt, Rn, Rs)


/* SWPAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/f8e08000) */
//#define IEM_INSTR_IMPL_A64__SWPAL_64_memop(Rt, Rn, Rs)


/* LDBFADD  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c200000) */
//#define IEM_INSTR_IMPL_A64__LDBFADD_16(Rt, Rn, Rs)


/* LDBFMAX  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c204000) */
//#define IEM_INSTR_IMPL_A64__LDBFMAX_16(Rt, Rn, Rs)


/* LDBFMIN  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c205000) */
//#define IEM_INSTR_IMPL_A64__LDBFMIN_16(Rt, Rn, Rs)


/* LDBFMAXNM  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c206000) */
//#define IEM_INSTR_IMPL_A64__LDBFMAXNM_16(Rt, Rn, Rs)


/* LDBFMINNM  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c207000) */
//#define IEM_INSTR_IMPL_A64__LDBFMINNM_16(Rt, Rn, Rs)


/* STBFADD  <Hs>, [<Xn|SP>] (ffe0fc1f/3c20801f) */
//#define IEM_INSTR_IMPL_A64__STBFADD_16(Rn, Rs)


/* STBFMAX  <Hs>, [<Xn|SP>] (ffe0fc1f/3c20c01f) */
//#define IEM_INSTR_IMPL_A64__STBFMAX_16(Rn, Rs)


/* STBFMIN  <Hs>, [<Xn|SP>] (ffe0fc1f/3c20d01f) */
//#define IEM_INSTR_IMPL_A64__STBFMIN_16(Rn, Rs)


/* STBFMAXNM  <Hs>, [<Xn|SP>] (ffe0fc1f/3c20e01f) */
//#define IEM_INSTR_IMPL_A64__STBFMAXNM_16(Rn, Rs)


/* STBFMINNM  <Hs>, [<Xn|SP>] (ffe0fc1f/3c20f01f) */
//#define IEM_INSTR_IMPL_A64__STBFMINNM_16(Rn, Rs)


/* STBFADDL  <Hs>, [<Xn|SP>] (ffe0fc1f/3c60801f) */
//#define IEM_INSTR_IMPL_A64__STBFADDL_16(Rn, Rs)


/* STBFMAXL  <Hs>, [<Xn|SP>] (ffe0fc1f/3c60c01f) */
//#define IEM_INSTR_IMPL_A64__STBFMAXL_16(Rn, Rs)


/* STBFMINL  <Hs>, [<Xn|SP>] (ffe0fc1f/3c60d01f) */
//#define IEM_INSTR_IMPL_A64__STBFMINL_16(Rn, Rs)


/* STBFMAXNML  <Hs>, [<Xn|SP>] (ffe0fc1f/3c60e01f) */
//#define IEM_INSTR_IMPL_A64__STBFMAXNML_16(Rn, Rs)


/* STBFMINNML  <Hs>, [<Xn|SP>] (ffe0fc1f/3c60f01f) */
//#define IEM_INSTR_IMPL_A64__STBFMINNML_16(Rn, Rs)


/* LDBFADDL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c600000) */
//#define IEM_INSTR_IMPL_A64__LDBFADDL_16(Rt, Rn, Rs)


/* LDBFMAXL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c604000) */
//#define IEM_INSTR_IMPL_A64__LDBFMAXL_16(Rt, Rn, Rs)


/* LDBFMINL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c605000) */
//#define IEM_INSTR_IMPL_A64__LDBFMINL_16(Rt, Rn, Rs)


/* LDBFMAXNML  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c606000) */
//#define IEM_INSTR_IMPL_A64__LDBFMAXNML_16(Rt, Rn, Rs)


/* LDBFMINNML  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3c607000) */
//#define IEM_INSTR_IMPL_A64__LDBFMINNML_16(Rt, Rn, Rs)


/* LDBFADDA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ca00000) */
//#define IEM_INSTR_IMPL_A64__LDBFADDA_16(Rt, Rn, Rs)


/* LDBFMAXA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ca04000) */
//#define IEM_INSTR_IMPL_A64__LDBFMAXA_16(Rt, Rn, Rs)


/* LDBFMINA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ca05000) */
//#define IEM_INSTR_IMPL_A64__LDBFMINA_16(Rt, Rn, Rs)


/* LDBFMAXNMA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ca06000) */
//#define IEM_INSTR_IMPL_A64__LDBFMAXNMA_16(Rt, Rn, Rs)


/* LDBFMINNMA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ca07000) */
//#define IEM_INSTR_IMPL_A64__LDBFMINNMA_16(Rt, Rn, Rs)


/* LDBFADDAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ce00000) */
//#define IEM_INSTR_IMPL_A64__LDBFADDAL_16(Rt, Rn, Rs)


/* LDBFMAXAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ce04000) */
//#define IEM_INSTR_IMPL_A64__LDBFMAXAL_16(Rt, Rn, Rs)


/* LDBFMINAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ce05000) */
//#define IEM_INSTR_IMPL_A64__LDBFMINAL_16(Rt, Rn, Rs)


/* LDBFMAXNMAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ce06000) */
//#define IEM_INSTR_IMPL_A64__LDBFMAXNMAL_16(Rt, Rn, Rs)


/* LDBFMINNMAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/3ce07000) */
//#define IEM_INSTR_IMPL_A64__LDBFMINNMAL_16(Rt, Rn, Rs)


/* LDFADD  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c200000) */
//#define IEM_INSTR_IMPL_A64__LDFADD_16(Rt, Rn, Rs)


/* LDFMAX  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c204000) */
//#define IEM_INSTR_IMPL_A64__LDFMAX_16(Rt, Rn, Rs)


/* LDFMIN  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c205000) */
//#define IEM_INSTR_IMPL_A64__LDFMIN_16(Rt, Rn, Rs)


/* LDFMAXNM  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c206000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNM_16(Rt, Rn, Rs)


/* LDFMINNM  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c207000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNM_16(Rt, Rn, Rs)


/* STFADD  <Hs>, [<Xn|SP>] (ffe0fc1f/7c20801f) */
//#define IEM_INSTR_IMPL_A64__STFADD_16(Rn, Rs)


/* STFMAX  <Hs>, [<Xn|SP>] (ffe0fc1f/7c20c01f) */
//#define IEM_INSTR_IMPL_A64__STFMAX_16(Rn, Rs)


/* STFMIN  <Hs>, [<Xn|SP>] (ffe0fc1f/7c20d01f) */
//#define IEM_INSTR_IMPL_A64__STFMIN_16(Rn, Rs)


/* STFMAXNM  <Hs>, [<Xn|SP>] (ffe0fc1f/7c20e01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXNM_16(Rn, Rs)


/* STFMINNM  <Hs>, [<Xn|SP>] (ffe0fc1f/7c20f01f) */
//#define IEM_INSTR_IMPL_A64__STFMINNM_16(Rn, Rs)


/* STFADDL  <Hs>, [<Xn|SP>] (ffe0fc1f/7c60801f) */
//#define IEM_INSTR_IMPL_A64__STFADDL_16(Rn, Rs)


/* STFMAXL  <Hs>, [<Xn|SP>] (ffe0fc1f/7c60c01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXL_16(Rn, Rs)


/* STFMINL  <Hs>, [<Xn|SP>] (ffe0fc1f/7c60d01f) */
//#define IEM_INSTR_IMPL_A64__STFMINL_16(Rn, Rs)


/* STFMAXNML  <Hs>, [<Xn|SP>] (ffe0fc1f/7c60e01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXNML_16(Rn, Rs)


/* STFMINNML  <Hs>, [<Xn|SP>] (ffe0fc1f/7c60f01f) */
//#define IEM_INSTR_IMPL_A64__STFMINNML_16(Rn, Rs)


/* LDFADDL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c600000) */
//#define IEM_INSTR_IMPL_A64__LDFADDL_16(Rt, Rn, Rs)


/* LDFMAXL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c604000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXL_16(Rt, Rn, Rs)


/* LDFMINL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c605000) */
//#define IEM_INSTR_IMPL_A64__LDFMINL_16(Rt, Rn, Rs)


/* LDFMAXNML  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c606000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNML_16(Rt, Rn, Rs)


/* LDFMINNML  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7c607000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNML_16(Rt, Rn, Rs)


/* LDFADDA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ca00000) */
//#define IEM_INSTR_IMPL_A64__LDFADDA_16(Rt, Rn, Rs)


/* LDFMAXA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ca04000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXA_16(Rt, Rn, Rs)


/* LDFMINA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ca05000) */
//#define IEM_INSTR_IMPL_A64__LDFMINA_16(Rt, Rn, Rs)


/* LDFMAXNMA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ca06000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNMA_16(Rt, Rn, Rs)


/* LDFMINNMA  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ca07000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNMA_16(Rt, Rn, Rs)


/* LDFADDAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ce00000) */
//#define IEM_INSTR_IMPL_A64__LDFADDAL_16(Rt, Rn, Rs)


/* LDFMAXAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ce04000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXAL_16(Rt, Rn, Rs)


/* LDFMINAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ce05000) */
//#define IEM_INSTR_IMPL_A64__LDFMINAL_16(Rt, Rn, Rs)


/* LDFMAXNMAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ce06000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNMAL_16(Rt, Rn, Rs)


/* LDFMINNMAL  <Hs>, <Ht>, [<Xn|SP>] (ffe0fc00/7ce07000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNMAL_16(Rt, Rn, Rs)


/* LDFADD  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc200000) */
//#define IEM_INSTR_IMPL_A64__LDFADD_32(Rt, Rn, Rs)


/* LDFMAX  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc204000) */
//#define IEM_INSTR_IMPL_A64__LDFMAX_32(Rt, Rn, Rs)


/* LDFMIN  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc205000) */
//#define IEM_INSTR_IMPL_A64__LDFMIN_32(Rt, Rn, Rs)


/* LDFMAXNM  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc206000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNM_32(Rt, Rn, Rs)


/* LDFMINNM  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc207000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNM_32(Rt, Rn, Rs)


/* STFADD  <Ss>, [<Xn|SP>] (ffe0fc1f/bc20801f) */
//#define IEM_INSTR_IMPL_A64__STFADD_32(Rn, Rs)


/* STFMAX  <Ss>, [<Xn|SP>] (ffe0fc1f/bc20c01f) */
//#define IEM_INSTR_IMPL_A64__STFMAX_32(Rn, Rs)


/* STFMIN  <Ss>, [<Xn|SP>] (ffe0fc1f/bc20d01f) */
//#define IEM_INSTR_IMPL_A64__STFMIN_32(Rn, Rs)


/* STFMAXNM  <Ss>, [<Xn|SP>] (ffe0fc1f/bc20e01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXNM_32(Rn, Rs)


/* STFMINNM  <Ss>, [<Xn|SP>] (ffe0fc1f/bc20f01f) */
//#define IEM_INSTR_IMPL_A64__STFMINNM_32(Rn, Rs)


/* STFADDL  <Ss>, [<Xn|SP>] (ffe0fc1f/bc60801f) */
//#define IEM_INSTR_IMPL_A64__STFADDL_32(Rn, Rs)


/* STFMAXL  <Ss>, [<Xn|SP>] (ffe0fc1f/bc60c01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXL_32(Rn, Rs)


/* STFMINL  <Ss>, [<Xn|SP>] (ffe0fc1f/bc60d01f) */
//#define IEM_INSTR_IMPL_A64__STFMINL_32(Rn, Rs)


/* STFMAXNML  <Ss>, [<Xn|SP>] (ffe0fc1f/bc60e01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXNML_32(Rn, Rs)


/* STFMINNML  <Ss>, [<Xn|SP>] (ffe0fc1f/bc60f01f) */
//#define IEM_INSTR_IMPL_A64__STFMINNML_32(Rn, Rs)


/* LDFADDL  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc600000) */
//#define IEM_INSTR_IMPL_A64__LDFADDL_32(Rt, Rn, Rs)


/* LDFMAXL  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc604000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXL_32(Rt, Rn, Rs)


/* LDFMINL  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc605000) */
//#define IEM_INSTR_IMPL_A64__LDFMINL_32(Rt, Rn, Rs)


/* LDFMAXNML  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc606000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNML_32(Rt, Rn, Rs)


/* LDFMINNML  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bc607000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNML_32(Rt, Rn, Rs)


/* LDFADDA  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bca00000) */
//#define IEM_INSTR_IMPL_A64__LDFADDA_32(Rt, Rn, Rs)


/* LDFMAXA  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bca04000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXA_32(Rt, Rn, Rs)


/* LDFMINA  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bca05000) */
//#define IEM_INSTR_IMPL_A64__LDFMINA_32(Rt, Rn, Rs)


/* LDFMAXNMA  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bca06000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNMA_32(Rt, Rn, Rs)


/* LDFMINNMA  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bca07000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNMA_32(Rt, Rn, Rs)


/* LDFADDAL  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bce00000) */
//#define IEM_INSTR_IMPL_A64__LDFADDAL_32(Rt, Rn, Rs)


/* LDFMAXAL  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bce04000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXAL_32(Rt, Rn, Rs)


/* LDFMINAL  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bce05000) */
//#define IEM_INSTR_IMPL_A64__LDFMINAL_32(Rt, Rn, Rs)


/* LDFMAXNMAL  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bce06000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNMAL_32(Rt, Rn, Rs)


/* LDFMINNMAL  <Ss>, <St>, [<Xn|SP>] (ffe0fc00/bce07000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNMAL_32(Rt, Rn, Rs)


/* LDFADD  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc200000) */
//#define IEM_INSTR_IMPL_A64__LDFADD_64(Rt, Rn, Rs)


/* LDFMAX  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc204000) */
//#define IEM_INSTR_IMPL_A64__LDFMAX_64(Rt, Rn, Rs)


/* LDFMIN  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc205000) */
//#define IEM_INSTR_IMPL_A64__LDFMIN_64(Rt, Rn, Rs)


/* LDFMAXNM  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc206000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNM_64(Rt, Rn, Rs)


/* LDFMINNM  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc207000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNM_64(Rt, Rn, Rs)


/* STFADD  <Ds>, [<Xn|SP>] (ffe0fc1f/fc20801f) */
//#define IEM_INSTR_IMPL_A64__STFADD_64(Rn, Rs)


/* STFMAX  <Ds>, [<Xn|SP>] (ffe0fc1f/fc20c01f) */
//#define IEM_INSTR_IMPL_A64__STFMAX_64(Rn, Rs)


/* STFMIN  <Ds>, [<Xn|SP>] (ffe0fc1f/fc20d01f) */
//#define IEM_INSTR_IMPL_A64__STFMIN_64(Rn, Rs)


/* STFMAXNM  <Ds>, [<Xn|SP>] (ffe0fc1f/fc20e01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXNM_64(Rn, Rs)


/* STFMINNM  <Ds>, [<Xn|SP>] (ffe0fc1f/fc20f01f) */
//#define IEM_INSTR_IMPL_A64__STFMINNM_64(Rn, Rs)


/* STFADDL  <Ds>, [<Xn|SP>] (ffe0fc1f/fc60801f) */
//#define IEM_INSTR_IMPL_A64__STFADDL_64(Rn, Rs)


/* STFMAXL  <Ds>, [<Xn|SP>] (ffe0fc1f/fc60c01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXL_64(Rn, Rs)


/* STFMINL  <Ds>, [<Xn|SP>] (ffe0fc1f/fc60d01f) */
//#define IEM_INSTR_IMPL_A64__STFMINL_64(Rn, Rs)


/* STFMAXNML  <Ds>, [<Xn|SP>] (ffe0fc1f/fc60e01f) */
//#define IEM_INSTR_IMPL_A64__STFMAXNML_64(Rn, Rs)


/* STFMINNML  <Ds>, [<Xn|SP>] (ffe0fc1f/fc60f01f) */
//#define IEM_INSTR_IMPL_A64__STFMINNML_64(Rn, Rs)


/* LDFADDL  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc600000) */
//#define IEM_INSTR_IMPL_A64__LDFADDL_64(Rt, Rn, Rs)


/* LDFMAXL  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc604000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXL_64(Rt, Rn, Rs)


/* LDFMINL  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc605000) */
//#define IEM_INSTR_IMPL_A64__LDFMINL_64(Rt, Rn, Rs)


/* LDFMAXNML  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc606000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNML_64(Rt, Rn, Rs)


/* LDFMINNML  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fc607000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNML_64(Rt, Rn, Rs)


/* LDFADDA  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fca00000) */
//#define IEM_INSTR_IMPL_A64__LDFADDA_64(Rt, Rn, Rs)


/* LDFMAXA  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fca04000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXA_64(Rt, Rn, Rs)


/* LDFMINA  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fca05000) */
//#define IEM_INSTR_IMPL_A64__LDFMINA_64(Rt, Rn, Rs)


/* LDFMAXNMA  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fca06000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNMA_64(Rt, Rn, Rs)


/* LDFMINNMA  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fca07000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNMA_64(Rt, Rn, Rs)


/* LDFADDAL  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fce00000) */
//#define IEM_INSTR_IMPL_A64__LDFADDAL_64(Rt, Rn, Rs)


/* LDFMAXAL  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fce04000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXAL_64(Rt, Rn, Rs)


/* LDFMINAL  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fce05000) */
//#define IEM_INSTR_IMPL_A64__LDFMINAL_64(Rt, Rn, Rs)


/* LDFMAXNMAL  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fce06000) */
//#define IEM_INSTR_IMPL_A64__LDFMAXNMAL_64(Rt, Rn, Rs)


/* LDFMINNMAL  <Ds>, <Dt>, [<Xn|SP>] (ffe0fc00/fce07000) */
//#define IEM_INSTR_IMPL_A64__LDFMINNMAL_64(Rt, Rn, Rs)



/*
 *
 * Instruction Set & Groups: memop_128 / ldst / A64
 *
 */

/* LDCLRP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19201000) */
//#define IEM_INSTR_IMPL_A64__LDCLRP_128_memop_128(Rt, Rn, Rt2)


/* LDSETP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19203000) */
//#define IEM_INSTR_IMPL_A64__LDSETP_128_memop_128(Rt, Rn, Rt2)


/* SWPP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19208000) */
//#define IEM_INSTR_IMPL_A64__SWPP_128_memop_128(Rt, Rn, Rt2)


/* RCWCLRP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19209000) */
//#define IEM_INSTR_IMPL_A64__RCWCLRP_128_memop_128(Rt, Rn, Rt2)


/* RCWSWPP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/1920a000) */
//#define IEM_INSTR_IMPL_A64__RCWSWPP_128_memop_128(Rt, Rn, Rt2)


/* RCWSETP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/1920b000) */
//#define IEM_INSTR_IMPL_A64__RCWSETP_128_memop_128(Rt, Rn, Rt2)


/* LDCLRPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19601000) */
//#define IEM_INSTR_IMPL_A64__LDCLRPL_128_memop_128(Rt, Rn, Rt2)


/* LDSETPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19603000) */
//#define IEM_INSTR_IMPL_A64__LDSETPL_128_memop_128(Rt, Rn, Rt2)


/* SWPPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19608000) */
//#define IEM_INSTR_IMPL_A64__SWPPL_128_memop_128(Rt, Rn, Rt2)


/* RCWCLRPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19609000) */
//#define IEM_INSTR_IMPL_A64__RCWCLRPL_128_memop_128(Rt, Rn, Rt2)


/* RCWSWPPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/1960a000) */
//#define IEM_INSTR_IMPL_A64__RCWSWPPL_128_memop_128(Rt, Rn, Rt2)


/* RCWSETPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/1960b000) */
//#define IEM_INSTR_IMPL_A64__RCWSETPL_128_memop_128(Rt, Rn, Rt2)


/* LDCLRPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19a01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRPA_128_memop_128(Rt, Rn, Rt2)


/* LDSETPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19a03000) */
//#define IEM_INSTR_IMPL_A64__LDSETPA_128_memop_128(Rt, Rn, Rt2)


/* SWPPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19a08000) */
//#define IEM_INSTR_IMPL_A64__SWPPA_128_memop_128(Rt, Rn, Rt2)


/* RCWCLRPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19a09000) */
//#define IEM_INSTR_IMPL_A64__RCWCLRPA_128_memop_128(Rt, Rn, Rt2)


/* RCWSWPPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19a0a000) */
//#define IEM_INSTR_IMPL_A64__RCWSWPPA_128_memop_128(Rt, Rn, Rt2)


/* RCWSETPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19a0b000) */
//#define IEM_INSTR_IMPL_A64__RCWSETPA_128_memop_128(Rt, Rn, Rt2)


/* LDCLRPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19e01000) */
//#define IEM_INSTR_IMPL_A64__LDCLRPAL_128_memop_128(Rt, Rn, Rt2)


/* LDSETPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19e03000) */
//#define IEM_INSTR_IMPL_A64__LDSETPAL_128_memop_128(Rt, Rn, Rt2)


/* SWPPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19e08000) */
//#define IEM_INSTR_IMPL_A64__SWPPAL_128_memop_128(Rt, Rn, Rt2)


/* RCWCLRPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19e09000) */
//#define IEM_INSTR_IMPL_A64__RCWCLRPAL_128_memop_128(Rt, Rn, Rt2)


/* RCWSWPPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19e0a000) */
//#define IEM_INSTR_IMPL_A64__RCWSWPPAL_128_memop_128(Rt, Rn, Rt2)


/* RCWSETPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/19e0b000) */
//#define IEM_INSTR_IMPL_A64__RCWSETPAL_128_memop_128(Rt, Rn, Rt2)


/* RCWSCLRP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/59209000) */
//#define IEM_INSTR_IMPL_A64__RCWSCLRP_128_memop_128(Rt, Rn, Rt2)


/* RCWSSWPP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/5920a000) */
//#define IEM_INSTR_IMPL_A64__RCWSSWPP_128_memop_128(Rt, Rn, Rt2)


/* RCWSSETP  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/5920b000) */
//#define IEM_INSTR_IMPL_A64__RCWSSETP_128_memop_128(Rt, Rn, Rt2)


/* RCWSCLRPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/59609000) */
//#define IEM_INSTR_IMPL_A64__RCWSCLRPL_128_memop_128(Rt, Rn, Rt2)


/* RCWSSWPPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/5960a000) */
//#define IEM_INSTR_IMPL_A64__RCWSSWPPL_128_memop_128(Rt, Rn, Rt2)


/* RCWSSETPL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/5960b000) */
//#define IEM_INSTR_IMPL_A64__RCWSSETPL_128_memop_128(Rt, Rn, Rt2)


/* RCWSCLRPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/59a09000) */
//#define IEM_INSTR_IMPL_A64__RCWSCLRPA_128_memop_128(Rt, Rn, Rt2)


/* RCWSSWPPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/59a0a000) */
//#define IEM_INSTR_IMPL_A64__RCWSSWPPA_128_memop_128(Rt, Rn, Rt2)


/* RCWSSETPA  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/59a0b000) */
//#define IEM_INSTR_IMPL_A64__RCWSSETPA_128_memop_128(Rt, Rn, Rt2)


/* RCWSCLRPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/59e09000) */
//#define IEM_INSTR_IMPL_A64__RCWSCLRPAL_128_memop_128(Rt, Rn, Rt2)


/* RCWSSWPPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/59e0a000) */
//#define IEM_INSTR_IMPL_A64__RCWSSWPPAL_128_memop_128(Rt, Rn, Rt2)


/* RCWSSETPAL  <Xt1>, <Xt2>, [<Xn|SP>] (ffe0fc00/59e0b000) */
//#define IEM_INSTR_IMPL_A64__RCWSSETPAL_128_memop_128(Rt, Rn, Rt2)



/*
 *
 * Instruction Set & Groups: memop_unpriv / ldst / A64
 *
 */

/* LDTADD  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19200400) */
//#define IEM_INSTR_IMPL_A64__LDTADD_32_memop_unpriv(Rt, Rn, Rs)


/* LDTCLR  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19201400) */
//#define IEM_INSTR_IMPL_A64__LDTCLR_32_memop_unpriv(Rt, Rn, Rs)


/* LDTSET  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19203400) */
//#define IEM_INSTR_IMPL_A64__LDTSET_32_memop_unpriv(Rt, Rn, Rs)


/* SWPT  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19208400) */
//#define IEM_INSTR_IMPL_A64__SWPT_32_memop_unpriv(Rt, Rn, Rs)


/* LDTADDL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19600400) */
//#define IEM_INSTR_IMPL_A64__LDTADDL_32_memop_unpriv(Rt, Rn, Rs)


/* LDTCLRL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19601400) */
//#define IEM_INSTR_IMPL_A64__LDTCLRL_32_memop_unpriv(Rt, Rn, Rs)


/* LDTSETL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19603400) */
//#define IEM_INSTR_IMPL_A64__LDTSETL_32_memop_unpriv(Rt, Rn, Rs)


/* SWPTL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19608400) */
//#define IEM_INSTR_IMPL_A64__SWPTL_32_memop_unpriv(Rt, Rn, Rs)


/* LDTADDA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19a00400) */
//#define IEM_INSTR_IMPL_A64__LDTADDA_32_memop_unpriv(Rt, Rn, Rs)


/* LDTCLRA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19a01400) */
//#define IEM_INSTR_IMPL_A64__LDTCLRA_32_memop_unpriv(Rt, Rn, Rs)


/* LDTSETA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19a03400) */
//#define IEM_INSTR_IMPL_A64__LDTSETA_32_memop_unpriv(Rt, Rn, Rs)


/* SWPTA  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19a08400) */
//#define IEM_INSTR_IMPL_A64__SWPTA_32_memop_unpriv(Rt, Rn, Rs)


/* LDTADDAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19e00400) */
//#define IEM_INSTR_IMPL_A64__LDTADDAL_32_memop_unpriv(Rt, Rn, Rs)


/* LDTCLRAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19e01400) */
//#define IEM_INSTR_IMPL_A64__LDTCLRAL_32_memop_unpriv(Rt, Rn, Rs)


/* LDTSETAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19e03400) */
//#define IEM_INSTR_IMPL_A64__LDTSETAL_32_memop_unpriv(Rt, Rn, Rs)


/* SWPTAL  <Ws>, <Wt>, [<Xn|SP>] (ffe0fc00/19e08400) */
//#define IEM_INSTR_IMPL_A64__SWPTAL_32_memop_unpriv(Rt, Rn, Rs)


/* LDTADD  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59200400) */
//#define IEM_INSTR_IMPL_A64__LDTADD_64_memop_unpriv(Rt, Rn, Rs)


/* LDTCLR  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59201400) */
//#define IEM_INSTR_IMPL_A64__LDTCLR_64_memop_unpriv(Rt, Rn, Rs)


/* LDTSET  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59203400) */
//#define IEM_INSTR_IMPL_A64__LDTSET_64_memop_unpriv(Rt, Rn, Rs)


/* SWPT  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59208400) */
//#define IEM_INSTR_IMPL_A64__SWPT_64_memop_unpriv(Rt, Rn, Rs)


/* LDTADDL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59600400) */
//#define IEM_INSTR_IMPL_A64__LDTADDL_64_memop_unpriv(Rt, Rn, Rs)


/* LDTCLRL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59601400) */
//#define IEM_INSTR_IMPL_A64__LDTCLRL_64_memop_unpriv(Rt, Rn, Rs)


/* LDTSETL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59603400) */
//#define IEM_INSTR_IMPL_A64__LDTSETL_64_memop_unpriv(Rt, Rn, Rs)


/* SWPTL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59608400) */
//#define IEM_INSTR_IMPL_A64__SWPTL_64_memop_unpriv(Rt, Rn, Rs)


/* LDTADDA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59a00400) */
//#define IEM_INSTR_IMPL_A64__LDTADDA_64_memop_unpriv(Rt, Rn, Rs)


/* LDTCLRA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59a01400) */
//#define IEM_INSTR_IMPL_A64__LDTCLRA_64_memop_unpriv(Rt, Rn, Rs)


/* LDTSETA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59a03400) */
//#define IEM_INSTR_IMPL_A64__LDTSETA_64_memop_unpriv(Rt, Rn, Rs)


/* SWPTA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59a08400) */
//#define IEM_INSTR_IMPL_A64__SWPTA_64_memop_unpriv(Rt, Rn, Rs)


/* LDTADDAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59e00400) */
//#define IEM_INSTR_IMPL_A64__LDTADDAL_64_memop_unpriv(Rt, Rn, Rs)


/* LDTCLRAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59e01400) */
//#define IEM_INSTR_IMPL_A64__LDTCLRAL_64_memop_unpriv(Rt, Rn, Rs)


/* LDTSETAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59e03400) */
//#define IEM_INSTR_IMPL_A64__LDTSETAL_64_memop_unpriv(Rt, Rn, Rs)


/* SWPTAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59e08400) */
//#define IEM_INSTR_IMPL_A64__SWPTAL_64_memop_unpriv(Rt, Rn, Rs)



/*
 *
 * Instruction Set & Groups: minmax_imm / dpimm / A64
 *
 */

/* SMAX  <Wd>, <Wn>, #<simm> (fffc0000/11c00000) */
//#define IEM_INSTR_IMPL_A64__SMAX_32_minmax_imm(Rd, Rn, imm8)


/* UMAX  <Wd>, <Wn>, #<uimm> (fffc0000/11c40000) */
//#define IEM_INSTR_IMPL_A64__UMAX_32U_minmax_imm(Rd, Rn, imm8)


/* SMIN  <Wd>, <Wn>, #<simm> (fffc0000/11c80000) */
//#define IEM_INSTR_IMPL_A64__SMIN_32_minmax_imm(Rd, Rn, imm8)


/* UMIN  <Wd>, <Wn>, #<uimm> (fffc0000/11cc0000) */
//#define IEM_INSTR_IMPL_A64__UMIN_32U_minmax_imm(Rd, Rn, imm8)


/* SMAX  <Xd>, <Xn>, #<simm> (fffc0000/91c00000) */
//#define IEM_INSTR_IMPL_A64__SMAX_64_minmax_imm(Rd, Rn, imm8)


/* UMAX  <Xd>, <Xn>, #<uimm> (fffc0000/91c40000) */
//#define IEM_INSTR_IMPL_A64__UMAX_64U_minmax_imm(Rd, Rn, imm8)


/* SMIN  <Xd>, <Xn>, #<simm> (fffc0000/91c80000) */
//#define IEM_INSTR_IMPL_A64__SMIN_64_minmax_imm(Rd, Rn, imm8)


/* UMIN  <Xd>, <Xn>, #<uimm> (fffc0000/91cc0000) */
//#define IEM_INSTR_IMPL_A64__UMIN_64U_minmax_imm(Rd, Rn, imm8)



/*
 *
 * Instruction Set & Groups: miscbranch / control / A64
 *
 */

/* RETAASPPC  <label> (ffe0001f/5500001f) */
//#define IEM_INSTR_IMPL_A64__RETAASPPC_only_miscbranch(imm16)


/* RETABSPPC  <label> (ffe0001f/5520001f) */
//#define IEM_INSTR_IMPL_A64__RETABSPPC_only_miscbranch(imm16)



/*
 *
 * Instruction Set & Groups: mortlach_addhv / mortlach_hvadd / sme / A64
 *
 */

/* ADDHA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.S (ffff001c/c0900000) */
//#define IEM_INSTR_IMPL_A64__addha_za_pp_z_32(ZAda, Zn, Pn, Pm)


/* ADDHA  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.D (ffff0018/c0d00000) */
//#define IEM_INSTR_IMPL_A64__addha_za_pp_z_64(ZAda, Zn, Pn, Pm)


/* ADDVA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.S (ffff001c/c0910000) */
//#define IEM_INSTR_IMPL_A64__addva_za_pp_z_32(ZAda, Zn, Pn, Pm)


/* ADDVA  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.D (ffff0018/c0d10000) */
//#define IEM_INSTR_IMPL_A64__addva_za_pp_z_64(ZAda, Zn, Pn, Pm)



/*
 *
 * Instruction Set & Groups: mortlach_b16b16_1in2ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* BFTMOPA  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, <Zm>.H, <Zk>[<index>] (ffe0e00e/81600008) */
//#define IEM_INSTR_IMPL_A64__bftmopa_za_zzzi_h2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_b16b16_prod / mortlach2_misc_prod / sme / A64
 *
 */

/* BFMOPA  <ZAda>.H, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001e/81a00008) */
//#define IEM_INSTR_IMPL_A64__bfmopa_za_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)


/* BFMOPS  <ZAda>.H, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001e/81a00018) */
//#define IEM_INSTR_IMPL_A64__bfmops_za_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_b16b16_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* BFMOP4A  <ZAda>.H, <Zn>.H, <Zm>.H (fff1fe3e/81200008) */
//#define IEM_INSTR_IMPL_A64__bfmop4a_za_zz_h1x1(ZAda, Zn, Zm)


/* BFMOP4S  <ZAda>.H, <Zn>.H, <Zm>.H (fff1fe3e/81200018) */
//#define IEM_INSTR_IMPL_A64__bfmop4s_za_zz_h1x1(ZAda, Zn, Zm)


/* BFMOP4A  <ZAda>.H, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3e/81300008) */
//#define IEM_INSTR_IMPL_A64__bfmop4a_za_zz_h1x2(ZAda, Zn, Zm)


/* BFMOP4S  <ZAda>.H, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3e/81300018) */
//#define IEM_INSTR_IMPL_A64__bfmop4s_za_zz_h1x2(ZAda, Zn, Zm)


/* BFMOP4A  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3e/81200208) */
//#define IEM_INSTR_IMPL_A64__bfmop4a_za_zz_h2x1(ZAda, Zn, Zm)


/* BFMOP4S  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3e/81200218) */
//#define IEM_INSTR_IMPL_A64__bfmop4s_za_zz_h2x1(ZAda, Zn, Zm)


/* BFMOP4A  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3e/81300208) */
//#define IEM_INSTR_IMPL_A64__bfmop4a_za_zz_h2x2(ZAda, Zn, Zm)


/* BFMOP4S  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3e/81300218) */
//#define IEM_INSTR_IMPL_A64__bfmop4s_za_zz_h2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_b16f32_2in4ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* BFTMOPA  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H, <Zk>[<index>] (ffe0e00c/81400000) */
//#define IEM_INSTR_IMPL_A64__bftmopa_za32_zzzi_h2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_b16f32_prod / mortlach_32bit_fp_prod / sme / A64
 *
 */

/* BFMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001c/81800000) */
//#define IEM_INSTR_IMPL_A64__bfmopa_za32_pp_zz(ZAda, Zn, Pn, Pm, Zm)


/* BFMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001c/81800010) */
//#define IEM_INSTR_IMPL_A64__bfmops_za32_pp_zz(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_b16f32_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* BFMOP4A  <ZAda>.S, <Zn>.H, <Zm>.H (fff1fe3c/81000000) */
//#define IEM_INSTR_IMPL_A64__bfmop4a_za32_zz_h1x1(ZAda, Zn, Zm)


/* BFMOP4S  <ZAda>.S, <Zn>.H, <Zm>.H (fff1fe3c/81000010) */
//#define IEM_INSTR_IMPL_A64__bfmop4s_za32_zz_h1x1(ZAda, Zn, Zm)


/* BFMOP4A  <ZAda>.S, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81100000) */
//#define IEM_INSTR_IMPL_A64__bfmop4a_za32_zz_h1x2(ZAda, Zn, Zm)


/* BFMOP4S  <ZAda>.S, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81100010) */
//#define IEM_INSTR_IMPL_A64__bfmop4s_za32_zz_h1x2(ZAda, Zn, Zm)


/* BFMOP4A  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3c/81000200) */
//#define IEM_INSTR_IMPL_A64__bfmop4a_za32_zz_h2x1(ZAda, Zn, Zm)


/* BFMOP4S  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3c/81000210) */
//#define IEM_INSTR_IMPL_A64__bfmop4s_za32_zz_h2x1(ZAda, Zn, Zm)


/* BFMOP4A  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81100200) */
//#define IEM_INSTR_IMPL_A64__bfmop4a_za32_zz_h2x2(ZAda, Zn, Zm)


/* BFMOP4S  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81100210) */
//#define IEM_INSTR_IMPL_A64__bfmop4s_za32_zz_h2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_bini32_prod / mortlach2_misc_prod / sme / A64
 *
 */

/* BMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.S, <Zm>.S (ffe0001c/80800008) */
//#define IEM_INSTR_IMPL_A64__bmopa_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* BMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.S, <Zm>.S (ffe0001c/80800018) */
//#define IEM_INSTR_IMPL_A64__bmops_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_contig_load / mortlach_mem / sme / A64
 *
 */

/* LD1B  { ZA0<HV>.B[<Ws>, <offs>] }, <Pg>/Z, [<Xn|SP>{, <Xm>}] (ffe00010/e0000000) */
//#define IEM_INSTR_IMPL_A64__ld1b_za_p_rrr(off4, Rn, Pg, Rs, V, Rm)


/* LD1H  { <ZAt><HV>.H[<Ws>, <offs>] }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #1}] (ffe00010/e0400000) */
//#define IEM_INSTR_IMPL_A64__ld1h_za_p_rrr(off3, ZAt, Rn, Pg, Rs, V, Rm)


/* LD1W  { <ZAt><HV>.S[<Ws>, <offs>] }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #2}] (ffe00010/e0800000) */
//#define IEM_INSTR_IMPL_A64__ld1w_za_p_rrr(off2, ZAt, Rn, Pg, Rs, V, Rm)


/* LD1D  { <ZAt><HV>.D[<Ws>, <offs>] }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #3}] (ffe00010/e0c00000) */
//#define IEM_INSTR_IMPL_A64__ld1d_za_p_rrr(o1, ZAt, Rn, Pg, Rs, V, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_contig_qload / mortlach_mem / sme / A64
 *
 */

/* LD1Q  { <ZAt><HV>.Q[<Ws>, <offs>] }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #4}] (ffe00010/e1c00000) */
//#define IEM_INSTR_IMPL_A64__ld1q_za_p_rrr(ZAt, Rn, Pg, Rs, V, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_contig_qstore / mortlach_mem / sme / A64
 *
 */

/* ST1Q  { <ZAt><HV>.Q[<Ws>, <offs>] }, <Pg>, [<Xn|SP>{, <Xm>, LSL #4}] (ffe00010/e1e00000) */
//#define IEM_INSTR_IMPL_A64__st1q_za_p_rrr(ZAt, Rn, Pg, Rs, V, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_contig_store / mortlach_mem / sme / A64
 *
 */

/* ST1B  { ZA0<HV>.B[<Ws>, <offs>] }, <Pg>, [<Xn|SP>{, <Xm>}] (ffe00010/e0200000) */
//#define IEM_INSTR_IMPL_A64__st1b_za_p_rrr(off4, Rn, Pg, Rs, V, Rm)


/* ST1H  { <ZAt><HV>.H[<Ws>, <offs>] }, <Pg>, [<Xn|SP>{, <Xm>, LSL #1}] (ffe00010/e0600000) */
//#define IEM_INSTR_IMPL_A64__st1h_za_p_rrr(off3, ZAt, Rn, Pg, Rs, V, Rm)


/* ST1W  { <ZAt><HV>.S[<Ws>, <offs>] }, <Pg>, [<Xn|SP>{, <Xm>, LSL #2}] (ffe00010/e0a00000) */
//#define IEM_INSTR_IMPL_A64__st1w_za_p_rrr(off2, ZAt, Rn, Pg, Rs, V, Rm)


/* ST1D  { <ZAt><HV>.D[<Ws>, <offs>] }, <Pg>, [<Xn|SP>{, <Xm>, LSL #3}] (ffe00010/e0e00000) */
//#define IEM_INSTR_IMPL_A64__st1d_za_p_rrr(o1, ZAt, Rn, Pg, Rs, V, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_ctxt_ldst / mortlach_mem / sme / A64
 *
 */

/* LDR  ZA[<Wv>, <offs>], [<Xn|SP>{, #<offs>, MUL VL}] (ffff9c10/e1000000) */
//#define IEM_INSTR_IMPL_A64__ldr_za_ri(off4, Rn, Rv)


/* STR  ZA[<Wv>, <offs>], [<Xn|SP>{, #<offs>, MUL VL}] (ffff9c10/e1200000) */
//#define IEM_INSTR_IMPL_A64__str_za_ri(off4, Rn, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_expand_1dst / mortlach_zt_expand_ctg / sme / A64
 *
 */

/* LUTI2  <Zd>.<T>, ZT0, <Zn>[<index>] (fffc0c00/c0cc0000) */
//#define IEM_INSTR_IMPL_A64__luti2_z_ztz(Zd, Zn, size, i4)


/* LUTI4  <Zd>.<T>, ZT0, <Zn>[<index>] (fffe0c00/c0ca0000) */
//#define IEM_INSTR_IMPL_A64__luti4_z_ztz(Zd, Zn, size, i3)



/*
 *
 * Instruction Set & Groups: mortlach_expand_2dst_ctg / mortlach_zt_expand_ctg / sme / A64
 *
 */

/* LUTI2  { <Zd1>.<T>-<Zd2>.<T> }, ZT0, <Zn>[<index>] (fffc4c01/c08c4000) */
//#define IEM_INSTR_IMPL_A64__luti2_mz2_ztz_1(Zd, Zn, size, i3)


/* LUTI4  { <Zd1>.<T>-<Zd2>.<T> }, ZT0, <Zn>[<index>] (fffe4c01/c08a4000) */
//#define IEM_INSTR_IMPL_A64__luti4_mz2_ztz_1(Zd, Zn, size, i2)



/*
 *
 * Instruction Set & Groups: mortlach_expand_2dst_nctg / mortlach_zt_expand_nctg / sme / A64
 *
 */

/* LUTI2  { <Zd1>.<T>, <Zd2>.<T> }, ZT0, <Zn>[<index>] (fffc4c08/c09c4000) */
//#define IEM_INSTR_IMPL_A64__luti2_mz2_ztz_8(Zd, D, Zn, size, i3)


/* LUTI4  { <Zd1>.<T>, <Zd2>.<T> }, ZT0, <Zn>[<index>] (fffe4c08/c09a4000) */
//#define IEM_INSTR_IMPL_A64__luti4_mz2_ztz_8(Zd, D, Zn, size, i2)



/*
 *
 * Instruction Set & Groups: mortlach_expand_4dst2src_ctg / mortlach_zt_expand_ctg / sme / A64
 *
 */

/* LUTI4  { <Zd1>.B-<Zd4>.B }, ZT0, { <Zn1>-<Zn2> } (ffffcc23/c08b0000) */
//#define IEM_INSTR_IMPL_A64__luti4_mz4_ztmz2_1(Zd, Zn, size)



/*
 *
 * Instruction Set & Groups: mortlach_expand_4dst2src_nctg / mortlach_zt_expand_nctg / sme / A64
 *
 */

/* LUTI4  { <Zd1>.B, <Zd2>.B, <Zd3>.B, <Zd4>.B }, ZT0, { <Zn1>-<Zn2> } (ffffcc2c/c09b0000) */
//#define IEM_INSTR_IMPL_A64__luti4_mz4_ztmz2_4(Zd, D, Zn, size)



/*
 *
 * Instruction Set & Groups: mortlach_expand_4dst_ctg / mortlach_zt_expand_ctg / sme / A64
 *
 */

/* LUTI2  { <Zd1>.<T>-<Zd4>.<T> }, ZT0, <Zn>[<index>] (fffccc03/c08c8000) */
//#define IEM_INSTR_IMPL_A64__luti2_mz4_ztz_1(Zd, Zn, size, i2)


/* LUTI4  { <Zd1>.<T>-<Zd4>.<T> }, ZT0, <Zn>[<index>] (fffecc03/c08a8000) */
//#define IEM_INSTR_IMPL_A64__luti4_mz4_ztz_1(Zd, Zn, size, i1)



/*
 *
 * Instruction Set & Groups: mortlach_expand_4dst_nctg / mortlach_zt_expand_nctg / sme / A64
 *
 */

/* LUTI2  { <Zd1>.<T>, <Zd2>.<T>, <Zd3>.<T>, <Zd4>.<T> }, ZT0, <Zn>[<index>] (fffccc0c/c09c8000) */
//#define IEM_INSTR_IMPL_A64__luti2_mz4_ztz_4(Zd, D, Zn, size, i2)


/* LUTI4  { <Zd1>.H, <Zd2>.H, <Zd3>.H, <Zd4>.H }, ZT0, <Zn>[<index>] (fffecc0c/c09a8000) */
//#define IEM_INSTR_IMPL_A64__luti4_mz4_ztz_4(Zd, D, Zn, size, i1)



/*
 *
 * Instruction Set & Groups: mortlach_extract_pred / mortlach_ext / sme / A64
 *
 */

/* MOVA  <Zd>.B, <Pg>/M, ZA0<HV>.B[<Ws>, <offs>] (ffff0200/c0020000) */
//#define IEM_INSTR_IMPL_A64__mova_z_p_rza_b(Zd, off4, Pg, Rs, V)


/* MOVA  <Zd>.H, <Pg>/M, <ZAn><HV>.H[<Ws>, <offs>] (ffff0200/c0420000) */
//#define IEM_INSTR_IMPL_A64__mova_z_p_rza_h(Zd, off3, ZAn, Pg, Rs, V)


/* MOVA  <Zd>.S, <Pg>/M, <ZAn><HV>.S[<Ws>, <offs>] (ffff0200/c0820000) */
//#define IEM_INSTR_IMPL_A64__mova_z_p_rza_w(Zd, off2, ZAn, Pg, Rs, V)


/* MOVA  <Zd>.D, <Pg>/M, <ZAn><HV>.D[<Ws>, <offs>] (ffff0200/c0c20000) */
//#define IEM_INSTR_IMPL_A64__mova_z_p_rza_d(Zd, o1, ZAn, Pg, Rs, V)


/* MOVA  <Zd>.Q, <Pg>/M, <ZAn><HV>.Q[<Ws>, <offs>] (ffff0200/c0c30000) */
//#define IEM_INSTR_IMPL_A64__mova_z_p_rza_q(Zd, ZAn, Pg, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_extract_zero / mortlach_ext / sme / A64
 *
 */

/* MOVAZ  <Zd>.B, ZA0<HV>.B[<Ws>, <offs>] (ffff1e00/c0020200) */
//#define IEM_INSTR_IMPL_A64__movaz_z_rza_b(Zd, off4, Rs, V)


/* MOVAZ  <Zd>.H, <ZAn><HV>.H[<Ws>, <offs>] (ffff1e00/c0420200) */
//#define IEM_INSTR_IMPL_A64__movaz_z_rza_h(Zd, off3, ZAn, Rs, V)


/* MOVAZ  <Zd>.S, <ZAn><HV>.S[<Ws>, <offs>] (ffff1e00/c0820200) */
//#define IEM_INSTR_IMPL_A64__movaz_z_rza_w(Zd, off2, ZAn, Rs, V)


/* MOVAZ  <Zd>.D, <ZAn><HV>.D[<Ws>, <offs>] (ffff1e00/c0c20200) */
//#define IEM_INSTR_IMPL_A64__movaz_z_rza_d(Zd, o1, ZAn, Rs, V)


/* MOVAZ  <Zd>.Q, <ZAn><HV>.Q[<Ws>, <offs>] (ffff1e00/c0c30200) */
//#define IEM_INSTR_IMPL_A64__movaz_z_rza_q(Zd, ZAn, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_extract_zt / mortlach_mov_zt / sme / A64
 *
 */

/* MOVT  <Xt>, ZT0[<offs>] (ffff8fe0/c04c03e0) */
//#define IEM_INSTR_IMPL_A64__movt_r_zt(Rt, off3)



/*
 *
 * Instruction Set & Groups: mortlach_f16f16_1in2ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* FTMOPA  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, <Zm>.H, <Zk>[<index>] (ffe0e00e/81400008) */
//#define IEM_INSTR_IMPL_A64__ftmopa_za_zzzi_h2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f16f16_prod / mortlach2_misc_prod / sme / A64
 *
 */

/* FMOPA  <ZAda>.H, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001e/81800008) */
//#define IEM_INSTR_IMPL_A64__fmopa_za_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)


/* FMOPS  <ZAda>.H, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001e/81800018) */
//#define IEM_INSTR_IMPL_A64__fmops_za_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f16f16_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* FMOP4A  <ZAda>.H, <Zn>.H, <Zm>.H (fff1fe3e/81000008) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_h1x1(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.H, <Zn>.H, <Zm>.H (fff1fe3e/81000018) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_h1x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.H, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3e/81100008) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_h1x2(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.H, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3e/81100018) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_h1x2(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3e/81000208) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_h2x1(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3e/81000218) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_h2x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3e/81100208) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_h2x2(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.H, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3e/81100218) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_h2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f16f32_2in4ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* FTMOPA  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H, <Zk>[<index>] (ffe0e00c/81600000) */
//#define IEM_INSTR_IMPL_A64__ftmopa_za32_zzzi_h2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f16f32_prod / mortlach_32bit_fp_prod / sme / A64
 *
 */

/* FMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001c/81a00000) */
//#define IEM_INSTR_IMPL_A64__fmopa_za32_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)


/* FMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001c/81a00010) */
//#define IEM_INSTR_IMPL_A64__fmops_za32_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f16f32_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* FMOP4A  <ZAda>.S, <Zn>.H, <Zm>.H (fff1fe3c/81200000) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za32_zz_h1x1(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.S, <Zn>.H, <Zm>.H (fff1fe3c/81200010) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za32_zz_h1x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81300000) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za32_zz_h1x2(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.S, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81300010) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za32_zz_h1x2(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3c/81200200) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za32_zz_h2x1(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3c/81200210) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za32_zz_h2x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81300200) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za32_zz_h2x2(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81300210) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za32_zz_h2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f32f32_1in2ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* FTMOPA  <ZAda>.S, { <Zn1>.S-<Zn2>.S }, <Zm>.S, <Zk>[<index>] (ffe0e00c/80400000) */
//#define IEM_INSTR_IMPL_A64__ftmopa_za_zzzi_s2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f32f32_prod / mortlach_32bit_fp_prod / sme / A64
 *
 */

/* FMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.S, <Zm>.S (ffe0001c/80800000) */
//#define IEM_INSTR_IMPL_A64__fmopa_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* FMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.S, <Zm>.S (ffe0001c/80800010) */
//#define IEM_INSTR_IMPL_A64__fmops_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f32f32_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* FMOP4A  <ZAda>.S, <Zn>.S, <Zm>.S (fff1fe3c/80000000) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_s1x1(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.S, <Zn>.S, <Zm>.S (fff1fe3c/80000010) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_s1x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, <Zn>.S, { <Zm1>.S-<Zm2>.S } (fff1fe3c/80100000) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_s1x2(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.S, <Zn>.S, { <Zm1>.S-<Zm2>.S } (fff1fe3c/80100010) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_s1x2(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, { <Zn1>.S-<Zn2>.S }, <Zm>.S (fff1fe3c/80000200) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_s2x1(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.S, { <Zn1>.S-<Zn2>.S }, <Zm>.S (fff1fe3c/80000210) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_s2x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, { <Zn1>.S-<Zn2>.S }, { <Zm1>.S-<Zm2>.S } (fff1fe3c/80100200) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_s2x2(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.S, { <Zn1>.S-<Zn2>.S }, { <Zm1>.S-<Zm2>.S } (fff1fe3c/80100210) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_s2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f64f64_prod / mortlach_64bit_prod / sme / A64
 *
 */

/* FMOPA  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.D, <Zm>.D (ffe00018/80c00000) */
//#define IEM_INSTR_IMPL_A64__fmopa_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)


/* FMOPS  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.D, <Zm>.D (ffe00018/80c00010) */
//#define IEM_INSTR_IMPL_A64__fmops_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f64f64_prod4 / mortlach2_64bit_prod4 / sme / A64
 *
 */

/* FMOP4A  <ZAda>.D, <Zn>.D, <Zm>.D (fff1fe38/80c00008) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_d1x1(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.D, <Zn>.D, <Zm>.D (fff1fe38/80c00018) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_d1x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.D, <Zn>.D, { <Zm1>.D-<Zm2>.D } (fff1fe38/80d00008) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_d1x2(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.D, <Zn>.D, { <Zm1>.D-<Zm2>.D } (fff1fe38/80d00018) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_d1x2(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.D, { <Zn1>.D-<Zn2>.D }, <Zm>.D (fff1fe38/80c00208) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_d2x1(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.D, { <Zn1>.D-<Zn2>.D }, <Zm>.D (fff1fe38/80c00218) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_d2x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.D, { <Zn1>.D-<Zn2>.D }, { <Zm1>.D-<Zm2>.D } (fff1fe38/80d00208) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za_zz_d2x2(ZAda, Zn, Zm)


/* FMOP4S  <ZAda>.D, { <Zn1>.D-<Zn2>.D }, { <Zm1>.D-<Zm2>.D } (fff1fe38/80d00218) */
//#define IEM_INSTR_IMPL_A64__fmop4s_za_zz_d2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f8f16_2in4ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* FTMOPA  <ZAda>.H, { <Zn1>.B-<Zn2>.B }, <Zm>.B, <Zk>[<index>] (ffe0e00e/80600008) */
//#define IEM_INSTR_IMPL_A64__ftmopa_za16_z8z8zi_b2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f8f16_prod / mortlach2_misc_prod / sme / A64
 *
 */

/* FMOPA  <ZAda>.H, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001e/80a00008) */
//#define IEM_INSTR_IMPL_A64__fmopa_za16_pp_z8z8_8(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f8f16_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* FMOP4A  <ZAda>.H, <Zn>.B, <Zm>.B (fff1fe3e/80200008) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za16_z8z8_b1x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.H, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3e/80300008) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za16_z8z8_b1x2(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.H, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3e/80200208) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za16_z8z8_b2x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.H, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3e/80300208) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za16_z8z8_b2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f8f32_2in4ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* FTMOPA  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B, <Zk>[<index>] (ffe0e00c/80600000) */
//#define IEM_INSTR_IMPL_A64__ftmopa_za32_z8z8zi_b2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f8f32_prod / mortlach_32bit_fp_prod / sme / A64
 *
 */

/* FMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/80a00000) */
//#define IEM_INSTR_IMPL_A64__fmopa_za32_pp_z8z8_8(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_f8f32_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* FMOP4A  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/80200000) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za32_z8z8_b1x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80300000) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za32_z8z8_b1x2(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/80200200) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za32_z8z8_b2x1(ZAda, Zn, Zm)


/* FMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80300200) */
//#define IEM_INSTR_IMPL_A64__fmop4a_za32_z8z8_b2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_i16i32_2in4ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* STMOPA  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H, <Zk>[<index>] (ffe0e00c/80408008) */
//#define IEM_INSTR_IMPL_A64__stmopa_za32_zzzi_h2x1(ZAda, i2, Zn, Zk, K, Zm)


/* UTMOPA  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H, <Zk>[<index>] (ffe0e00c/81408008) */
//#define IEM_INSTR_IMPL_A64__utmopa_za32_zzzi_h2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_i16i32_prod / mortlach_32bit_int_prod / sme / A64
 *
 */

/* SMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001c/a0800008) */
//#define IEM_INSTR_IMPL_A64__smopa_za32_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)


/* UMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001c/a1800008) */
//#define IEM_INSTR_IMPL_A64__umopa_za32_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)


/* SMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001c/a0800018) */
//#define IEM_INSTR_IMPL_A64__smops_za32_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)


/* UMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe0001c/a1800018) */
//#define IEM_INSTR_IMPL_A64__umops_za32_pp_zz_16(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_i16i32_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* SMOP4A  <ZAda>.S, <Zn>.H, <Zm>.H (fff1fe3c/80008008) */
//#define IEM_INSTR_IMPL_A64__smop4a_za32_zz_h1x1(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.S, <Zn>.H, <Zm>.H (fff1fe3c/81008008) */
//#define IEM_INSTR_IMPL_A64__umop4a_za32_zz_h1x1(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.S, <Zn>.H, <Zm>.H (fff1fe3c/80008018) */
//#define IEM_INSTR_IMPL_A64__smop4s_za32_zz_h1x1(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.S, <Zn>.H, <Zm>.H (fff1fe3c/81008018) */
//#define IEM_INSTR_IMPL_A64__umop4s_za32_zz_h1x1(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.S, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3c/80108008) */
//#define IEM_INSTR_IMPL_A64__smop4a_za32_zz_h1x2(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.S, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81108008) */
//#define IEM_INSTR_IMPL_A64__umop4a_za32_zz_h1x2(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.S, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3c/80108018) */
//#define IEM_INSTR_IMPL_A64__smop4s_za32_zz_h1x2(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.S, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81108018) */
//#define IEM_INSTR_IMPL_A64__umop4s_za32_zz_h1x2(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3c/80008208) */
//#define IEM_INSTR_IMPL_A64__smop4a_za32_zz_h2x1(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3c/81008208) */
//#define IEM_INSTR_IMPL_A64__umop4a_za32_zz_h2x1(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3c/80008218) */
//#define IEM_INSTR_IMPL_A64__smop4s_za32_zz_h2x1(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe3c/81008218) */
//#define IEM_INSTR_IMPL_A64__umop4s_za32_zz_h2x1(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3c/80108208) */
//#define IEM_INSTR_IMPL_A64__smop4a_za32_zz_h2x2(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81108208) */
//#define IEM_INSTR_IMPL_A64__umop4a_za32_zz_h2x2(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3c/80108218) */
//#define IEM_INSTR_IMPL_A64__smop4s_za32_zz_h2x2(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.S, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe3c/81108218) */
//#define IEM_INSTR_IMPL_A64__umop4s_za32_zz_h2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_i16i64_prod / mortlach_64bit_prod / sme / A64
 *
 */

/* SMOPA  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe00018/a0c00000) */
//#define IEM_INSTR_IMPL_A64__smopa_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)


/* SUMOPA  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe00018/a0e00000) */
//#define IEM_INSTR_IMPL_A64__sumopa_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)


/* USMOPA  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe00018/a1c00000) */
//#define IEM_INSTR_IMPL_A64__usmopa_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)


/* UMOPA  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe00018/a1e00000) */
//#define IEM_INSTR_IMPL_A64__umopa_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)


/* SMOPS  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe00018/a0c00010) */
//#define IEM_INSTR_IMPL_A64__smops_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)


/* SUMOPS  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe00018/a0e00010) */
//#define IEM_INSTR_IMPL_A64__sumops_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)


/* USMOPS  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe00018/a1c00010) */
//#define IEM_INSTR_IMPL_A64__usmops_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)


/* UMOPS  <ZAda>.D, <Pn>/M, <Pm>/M, <Zn>.H, <Zm>.H (ffe00018/a1e00010) */
//#define IEM_INSTR_IMPL_A64__umops_za_pp_zz_64(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_i16i64_prod4 / mortlach2_64bit_prod4 / sme / A64
 *
 */

/* SMOP4A  <ZAda>.D, <Zn>.H, <Zm>.H (fff1fe38/a0c00008) */
//#define IEM_INSTR_IMPL_A64__smop4a_za_zz_h1x1(ZAda, Zn, Zm)


/* SUMOP4A  <ZAda>.D, <Zn>.H, <Zm>.H (fff1fe38/a0e00008) */
//#define IEM_INSTR_IMPL_A64__sumop4a_za_zz_h1x1(ZAda, Zn, Zm)


/* USMOP4A  <ZAda>.D, <Zn>.H, <Zm>.H (fff1fe38/a1c00008) */
//#define IEM_INSTR_IMPL_A64__usmop4a_za_zz_h1x1(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.D, <Zn>.H, <Zm>.H (fff1fe38/a1e00008) */
//#define IEM_INSTR_IMPL_A64__umop4a_za_zz_h1x1(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.D, <Zn>.H, <Zm>.H (fff1fe38/a0c00018) */
//#define IEM_INSTR_IMPL_A64__smop4s_za_zz_h1x1(ZAda, Zn, Zm)


/* SUMOP4S  <ZAda>.D, <Zn>.H, <Zm>.H (fff1fe38/a0e00018) */
//#define IEM_INSTR_IMPL_A64__sumop4s_za_zz_h1x1(ZAda, Zn, Zm)


/* USMOP4S  <ZAda>.D, <Zn>.H, <Zm>.H (fff1fe38/a1c00018) */
//#define IEM_INSTR_IMPL_A64__usmop4s_za_zz_h1x1(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.D, <Zn>.H, <Zm>.H (fff1fe38/a1e00018) */
//#define IEM_INSTR_IMPL_A64__umop4s_za_zz_h1x1(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.D, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe38/a0d00008) */
//#define IEM_INSTR_IMPL_A64__smop4a_za_zz_h1x2(ZAda, Zn, Zm)


/* SUMOP4A  <ZAda>.D, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe38/a0f00008) */
//#define IEM_INSTR_IMPL_A64__sumop4a_za_zz_h1x2(ZAda, Zn, Zm)


/* USMOP4A  <ZAda>.D, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe38/a1d00008) */
//#define IEM_INSTR_IMPL_A64__usmop4a_za_zz_h1x2(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.D, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe38/a1f00008) */
//#define IEM_INSTR_IMPL_A64__umop4a_za_zz_h1x2(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.D, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe38/a0d00018) */
//#define IEM_INSTR_IMPL_A64__smop4s_za_zz_h1x2(ZAda, Zn, Zm)


/* SUMOP4S  <ZAda>.D, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe38/a0f00018) */
//#define IEM_INSTR_IMPL_A64__sumop4s_za_zz_h1x2(ZAda, Zn, Zm)


/* USMOP4S  <ZAda>.D, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe38/a1d00018) */
//#define IEM_INSTR_IMPL_A64__usmop4s_za_zz_h1x2(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.D, <Zn>.H, { <Zm1>.H-<Zm2>.H } (fff1fe38/a1f00018) */
//#define IEM_INSTR_IMPL_A64__umop4s_za_zz_h1x2(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe38/a0c00208) */
//#define IEM_INSTR_IMPL_A64__smop4a_za_zz_h2x1(ZAda, Zn, Zm)


/* SUMOP4A  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe38/a0e00208) */
//#define IEM_INSTR_IMPL_A64__sumop4a_za_zz_h2x1(ZAda, Zn, Zm)


/* USMOP4A  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe38/a1c00208) */
//#define IEM_INSTR_IMPL_A64__usmop4a_za_zz_h2x1(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe38/a1e00208) */
//#define IEM_INSTR_IMPL_A64__umop4a_za_zz_h2x1(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe38/a0c00218) */
//#define IEM_INSTR_IMPL_A64__smop4s_za_zz_h2x1(ZAda, Zn, Zm)


/* SUMOP4S  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe38/a0e00218) */
//#define IEM_INSTR_IMPL_A64__sumop4s_za_zz_h2x1(ZAda, Zn, Zm)


/* USMOP4S  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe38/a1c00218) */
//#define IEM_INSTR_IMPL_A64__usmop4s_za_zz_h2x1(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff1fe38/a1e00218) */
//#define IEM_INSTR_IMPL_A64__umop4s_za_zz_h2x1(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe38/a0d00208) */
//#define IEM_INSTR_IMPL_A64__smop4a_za_zz_h2x2(ZAda, Zn, Zm)


/* SUMOP4A  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe38/a0f00208) */
//#define IEM_INSTR_IMPL_A64__sumop4a_za_zz_h2x2(ZAda, Zn, Zm)


/* USMOP4A  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe38/a1d00208) */
//#define IEM_INSTR_IMPL_A64__usmop4a_za_zz_h2x2(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe38/a1f00208) */
//#define IEM_INSTR_IMPL_A64__umop4a_za_zz_h2x2(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe38/a0d00218) */
//#define IEM_INSTR_IMPL_A64__smop4s_za_zz_h2x2(ZAda, Zn, Zm)


/* SUMOP4S  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe38/a0f00218) */
//#define IEM_INSTR_IMPL_A64__sumop4s_za_zz_h2x2(ZAda, Zn, Zm)


/* USMOP4S  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe38/a1d00218) */
//#define IEM_INSTR_IMPL_A64__usmop4s_za_zz_h2x2(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.D, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (fff1fe38/a1f00218) */
//#define IEM_INSTR_IMPL_A64__umop4s_za_zz_h2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_i8i32_2in4ss_prod / mortlach2_ss_prod / sme / A64
 *
 */

/* STMOPA  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B, <Zk>[<index>] (ffe0e00c/80408000) */
//#define IEM_INSTR_IMPL_A64__stmopa_za_zzzi_b2x1(ZAda, i2, Zn, Zk, K, Zm)


/* SUTMOPA  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B, <Zk>[<index>] (ffe0e00c/80608000) */
//#define IEM_INSTR_IMPL_A64__sutmopa_za_zzzi_b2x1(ZAda, i2, Zn, Zk, K, Zm)


/* USTMOPA  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B, <Zk>[<index>] (ffe0e00c/81408000) */
//#define IEM_INSTR_IMPL_A64__ustmopa_za_zzzi_b2x1(ZAda, i2, Zn, Zk, K, Zm)


/* UTMOPA  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B, <Zk>[<index>] (ffe0e00c/81608000) */
//#define IEM_INSTR_IMPL_A64__utmopa_za_zzzi_b2x1(ZAda, i2, Zn, Zk, K, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_i8i32_prod / mortlach_32bit_int_prod / sme / A64
 *
 */

/* SMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/a0800000) */
//#define IEM_INSTR_IMPL_A64__smopa_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* SUMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/a0a00000) */
//#define IEM_INSTR_IMPL_A64__sumopa_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* USMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/a1800000) */
//#define IEM_INSTR_IMPL_A64__usmopa_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* UMOPA  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/a1a00000) */
//#define IEM_INSTR_IMPL_A64__umopa_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* SMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/a0800010) */
//#define IEM_INSTR_IMPL_A64__smops_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* SUMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/a0a00010) */
//#define IEM_INSTR_IMPL_A64__sumops_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* USMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/a1800010) */
//#define IEM_INSTR_IMPL_A64__usmops_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)


/* UMOPS  <ZAda>.S, <Pn>/M, <Pm>/M, <Zn>.B, <Zm>.B (ffe0001c/a1a00010) */
//#define IEM_INSTR_IMPL_A64__umops_za_pp_zz_32(ZAda, Zn, Pn, Pm, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_i8i32_prod4 / mortlach2_prod4 / sme / A64
 *
 */

/* SMOP4A  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/80008000) */
//#define IEM_INSTR_IMPL_A64__smop4a_za_zz_b1x1(ZAda, Zn, Zm)


/* SUMOP4A  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/80208000) */
//#define IEM_INSTR_IMPL_A64__sumop4a_za_zz_b1x1(ZAda, Zn, Zm)


/* USMOP4A  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/81008000) */
//#define IEM_INSTR_IMPL_A64__usmop4a_za_zz_b1x1(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/81208000) */
//#define IEM_INSTR_IMPL_A64__umop4a_za_zz_b1x1(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/80008010) */
//#define IEM_INSTR_IMPL_A64__smop4s_za_zz_b1x1(ZAda, Zn, Zm)


/* SUMOP4S  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/80208010) */
//#define IEM_INSTR_IMPL_A64__sumop4s_za_zz_b1x1(ZAda, Zn, Zm)


/* USMOP4S  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/81008010) */
//#define IEM_INSTR_IMPL_A64__usmop4s_za_zz_b1x1(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.S, <Zn>.B, <Zm>.B (fff1fe3c/81208010) */
//#define IEM_INSTR_IMPL_A64__umop4s_za_zz_b1x1(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80108000) */
//#define IEM_INSTR_IMPL_A64__smop4a_za_zz_b1x2(ZAda, Zn, Zm)


/* SUMOP4A  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80308000) */
//#define IEM_INSTR_IMPL_A64__sumop4a_za_zz_b1x2(ZAda, Zn, Zm)


/* USMOP4A  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/81108000) */
//#define IEM_INSTR_IMPL_A64__usmop4a_za_zz_b1x2(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/81308000) */
//#define IEM_INSTR_IMPL_A64__umop4a_za_zz_b1x2(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80108010) */
//#define IEM_INSTR_IMPL_A64__smop4s_za_zz_b1x2(ZAda, Zn, Zm)


/* SUMOP4S  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80308010) */
//#define IEM_INSTR_IMPL_A64__sumop4s_za_zz_b1x2(ZAda, Zn, Zm)


/* USMOP4S  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/81108010) */
//#define IEM_INSTR_IMPL_A64__usmop4s_za_zz_b1x2(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.S, <Zn>.B, { <Zm1>.B-<Zm2>.B } (fff1fe3c/81308010) */
//#define IEM_INSTR_IMPL_A64__umop4s_za_zz_b1x2(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/80008200) */
//#define IEM_INSTR_IMPL_A64__smop4a_za_zz_b2x1(ZAda, Zn, Zm)


/* SUMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/80208200) */
//#define IEM_INSTR_IMPL_A64__sumop4a_za_zz_b2x1(ZAda, Zn, Zm)


/* USMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/81008200) */
//#define IEM_INSTR_IMPL_A64__usmop4a_za_zz_b2x1(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/81208200) */
//#define IEM_INSTR_IMPL_A64__umop4a_za_zz_b2x1(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/80008210) */
//#define IEM_INSTR_IMPL_A64__smop4s_za_zz_b2x1(ZAda, Zn, Zm)


/* SUMOP4S  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/80208210) */
//#define IEM_INSTR_IMPL_A64__sumop4s_za_zz_b2x1(ZAda, Zn, Zm)


/* USMOP4S  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/81008210) */
//#define IEM_INSTR_IMPL_A64__usmop4s_za_zz_b2x1(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff1fe3c/81208210) */
//#define IEM_INSTR_IMPL_A64__umop4s_za_zz_b2x1(ZAda, Zn, Zm)


/* SMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80108200) */
//#define IEM_INSTR_IMPL_A64__smop4a_za_zz_b2x2(ZAda, Zn, Zm)


/* SUMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80308200) */
//#define IEM_INSTR_IMPL_A64__sumop4a_za_zz_b2x2(ZAda, Zn, Zm)


/* USMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/81108200) */
//#define IEM_INSTR_IMPL_A64__usmop4a_za_zz_b2x2(ZAda, Zn, Zm)


/* UMOP4A  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/81308200) */
//#define IEM_INSTR_IMPL_A64__umop4a_za_zz_b2x2(ZAda, Zn, Zm)


/* SMOP4S  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80108210) */
//#define IEM_INSTR_IMPL_A64__smop4s_za_zz_b2x2(ZAda, Zn, Zm)


/* SUMOP4S  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/80308210) */
//#define IEM_INSTR_IMPL_A64__sumop4s_za_zz_b2x2(ZAda, Zn, Zm)


/* USMOP4S  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/81108210) */
//#define IEM_INSTR_IMPL_A64__usmop4s_za_zz_b2x2(ZAda, Zn, Zm)


/* UMOP4S  <ZAda>.S, { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (fff1fe3c/81308210) */
//#define IEM_INSTR_IMPL_A64__umop4s_za_zz_b2x2(ZAda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_insert_pred / mortlach_ins / sme / A64
 *
 */

/* MOVA  ZA0<HV>.B[<Ws>, <offs>], <Pg>/M, <Zn>.B (ffff0010/c0000000) */
//#define IEM_INSTR_IMPL_A64__mova_za_p_rz_b(off4, Zn, Pg, Rs, V)


/* MOVA  <ZAd><HV>.H[<Ws>, <offs>], <Pg>/M, <Zn>.H (ffff0010/c0400000) */
//#define IEM_INSTR_IMPL_A64__mova_za_p_rz_h(off3, ZAd, Zn, Pg, Rs, V)


/* MOVA  <ZAd><HV>.S[<Ws>, <offs>], <Pg>/M, <Zn>.S (ffff0010/c0800000) */
//#define IEM_INSTR_IMPL_A64__mova_za_p_rz_w(off2, ZAd, Zn, Pg, Rs, V)


/* MOVA  <ZAd><HV>.D[<Ws>, <offs>], <Pg>/M, <Zn>.D (ffff0010/c0c00000) */
//#define IEM_INSTR_IMPL_A64__mova_za_p_rz_d(o1, ZAd, Zn, Pg, Rs, V)


/* MOVA  <ZAd><HV>.Q[<Ws>, <offs>], <Pg>/M, <Zn>.Q (ffff0010/c0c10000) */
//#define IEM_INSTR_IMPL_A64__mova_za_p_rz_q(ZAd, Zn, Pg, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_insert_zt / mortlach_mov_zt / sme / A64
 *
 */

/* MOVT  ZT0[<offs>], <Xt> (ffff8fe0/c04e03e0) */
//#define IEM_INSTR_IMPL_A64__movt_zt_r(Rt, off3)



/*
 *
 * Instruction Set & Groups: mortlach_move_to_zt / mortlach_mov_zt / sme / A64
 *
 */

/* MOVT  ZT0{[<offs>, MUL VL]}, <Zt> (ffffcfe0/c04f03e0) */
//#define IEM_INSTR_IMPL_A64__movt_zt_z(Zt, off2)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_fma_long_idx / mortlach_multi_indexed_1 / sme / A64
 *
 */

/* BFMLAL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H[<index>] (fff01018/c1801010) */
//#define IEM_INSTR_IMPL_A64__bfmlal_za_zzi_1(off3, Zn, i3l, Rv, i3h, Zm)


/* FMLAL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H[<index>] (fff01018/c1801000) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_zzi_1(off3, Zn, i3l, Rv, i3h, Zm)


/* BFMLSL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H[<index>] (fff01018/c1801018) */
//#define IEM_INSTR_IMPL_A64__bfmlsl_za_zzi_1(off3, Zn, i3l, Rv, i3h, Zm)


/* FMLSL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H[<index>] (fff01018/c1801008) */
//#define IEM_INSTR_IMPL_A64__fmlsl_za_zzi_1(off3, Zn, i3l, Rv, i3h, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_fp8_fma_long_idx / mortlach_multi_indexed_1 / sme / A64
 *
 */

/* FMLAL  ZA.H[<Wv>, <offs1>:<offs2>], <Zn>.B, <Zm>.B[<index>] (fff01010/c1c00000) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_z8z8i_1(off3, i4C, Zn, i4B, Rv, i4A, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_fp8_fma_long_long_idx / mortlach_multi_indexed_1 / sme / A64
 *
 */

/* FMLALL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B[<index>] (fff0001c/c1400000) */
//#define IEM_INSTR_IMPL_A64__fmlall_za32_z8z8i_1(off2, Zn, i4l, Rv, i4h, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_mla_long_idx / mortlach_multi_indexed_1 / sme / A64
 *
 */

/* SMLAL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H[<index>] (fff01018/c1c01000) */
//#define IEM_INSTR_IMPL_A64__smlal_za_zzi_1(off3, Zn, i3l, Rv, i3h, Zm)


/* SMLSL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H[<index>] (fff01018/c1c01008) */
//#define IEM_INSTR_IMPL_A64__smlsl_za_zzi_1(off3, Zn, i3l, Rv, i3h, Zm)


/* UMLAL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H[<index>] (fff01018/c1c01010) */
//#define IEM_INSTR_IMPL_A64__umlal_za_zzi_1(off3, Zn, i3l, Rv, i3h, Zm)


/* UMLSL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H[<index>] (fff01018/c1c01018) */
//#define IEM_INSTR_IMPL_A64__umlsl_za_zzi_1(off3, Zn, i3l, Rv, i3h, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_mla_long_long_idx_d / mortlach_multi_indexed_1 / sme / A64
 *
 */

/* SMLALL  ZA.D[<Wv>, <offs1>:<offs4>], <Zn>.H, <Zm>.H[<index>] (fff0101c/c1800000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzi_d(off2, Zn, i3l, Rv, i3h, Zm)


/* SMLSLL  ZA.D[<Wv>, <offs1>:<offs4>], <Zn>.H, <Zm>.H[<index>] (fff0101c/c1800008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzi_d(off2, Zn, i3l, Rv, i3h, Zm)


/* UMLALL  ZA.D[<Wv>, <offs1>:<offs4>], <Zn>.H, <Zm>.H[<index>] (fff0101c/c1800010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzi_d(off2, Zn, i3l, Rv, i3h, Zm)


/* UMLSLL  ZA.D[<Wv>, <offs1>:<offs4>], <Zn>.H, <Zm>.H[<index>] (fff0101c/c1800018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzi_d(off2, Zn, i3l, Rv, i3h, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_mla_long_long_idx_s / mortlach_multi_indexed_1 / sme / A64
 *
 */

/* SMLALL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B[<index>] (fff0001c/c1000000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzi_s(off2, Zn, i4l, Rv, i4h, Zm)


/* USMLALL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B[<index>] (fff0001c/c1000004) */
//#define IEM_INSTR_IMPL_A64__usmlall_za_zzi_s(off2, Zn, i4l, Rv, i4h, Zm)


/* SMLSLL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B[<index>] (fff0001c/c1000008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzi_s(off2, Zn, i4l, Rv, i4h, Zm)


/* UMLALL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B[<index>] (fff0001c/c1000010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzi_s(off2, Zn, i4l, Rv, i4h, Zm)


/* SUMLALL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B[<index>] (fff0001c/c1000014) */
//#define IEM_INSTR_IMPL_A64__sumlall_za_zzi_s(off2, Zn, i4l, Rv, i4h, Zm)


/* UMLSLL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B[<index>] (fff0001c/c1000018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzi_s(off2, Zn, i4l, Rv, i4h, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_zz_za_fma_long_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* BFMLAL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H (fff09c18/c1200c10) */
//#define IEM_INSTR_IMPL_A64__bfmlal_za_zzv_1(off3, Zn, Rv, Zm)


/* FMLAL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H (fff09c18/c1200c00) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_zzv_1(off3, Zn, Rv, Zm)


/* BFMLSL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H (fff09c18/c1200c18) */
//#define IEM_INSTR_IMPL_A64__bfmlsl_za_zzv_1(off3, Zn, Rv, Zm)


/* FMLSL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H (fff09c18/c1200c08) */
//#define IEM_INSTR_IMPL_A64__fmlsl_za_zzv_1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_zz_za_fp8_fma_long_long_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* FMLALL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B (fff09c1c/c1300400) */
//#define IEM_INSTR_IMPL_A64__fmlall_za32_z8z8v_1(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_zz_za_fp8_fma_long_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* FMLAL  ZA.H[<Wv>, <offs1>:<offs2>], <Zn>.B, <Zm>.B (fff09c18/c1300c00) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_z8z8v_1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_zz_za_mla_long_long_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* SMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>], <Zn>.<Tb>, <Zm>.<Tb> (ffb09c1c/c1200400) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzv_1(off2, Zn, Rv, Zm, sz)


/* USMLALL  ZA.S[<Wv>, <offs1>:<offs4>], <Zn>.B, <Zm>.B (fff09c1c/c1200404) */
//#define IEM_INSTR_IMPL_A64__usmlall_za_zzv_s(off2, Zn, Rv, Zm)


/* SMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>], <Zn>.<Tb>, <Zm>.<Tb> (ffb09c1c/c1200408) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzv_1(off2, Zn, Rv, Zm, sz)


/* UMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>], <Zn>.<Tb>, <Zm>.<Tb> (ffb09c1c/c1200410) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzv_1(off2, Zn, Rv, Zm, sz)


/* UMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>], <Zn>.<Tb>, <Zm>.<Tb> (ffb09c1c/c1200418) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzv_1(off2, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi1_zz_za_mla_long_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* SMLAL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H (fff09c18/c1600c00) */
//#define IEM_INSTR_IMPL_A64__smlal_za_zzv_1(off3, Zn, Rv, Zm)


/* SMLSL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H (fff09c18/c1600c08) */
//#define IEM_INSTR_IMPL_A64__smlsl_za_zzv_1(off3, Zn, Rv, Zm)


/* UMLAL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H (fff09c18/c1600c10) */
//#define IEM_INSTR_IMPL_A64__umlal_za_zzv_1(off3, Zn, Rv, Zm)


/* UMLSL  ZA.S[<Wv>, <offs1>:<offs2>], <Zn>.H, <Zm>.H (fff09c18/c1600c18) */
//#define IEM_INSTR_IMPL_A64__umlsl_za_zzv_1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_clamp_int / mortlach_multi_sve_3 / sme / A64
 *
 */

/* SCLAMP  { <Zd1>.<T>-<Zd2>.<T> }, <Zn>.<T>, <Zm>.<T> (ff20fc01/c120c400) */
//#define IEM_INSTR_IMPL_A64__sclamp_mz_zz_2(Zd, Zn, Zm, size)


/* UCLAMP  { <Zd1>.<T>-<Zd2>.<T> }, <Zn>.<T>, <Zm>.<T> (ff20fc01/c120c401) */
//#define IEM_INSTR_IMPL_A64__uclamp_mz_zz_2(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_cld_cldnt_si_ctg / mortlach_multi_mem_ctg / sme / A64
 *
 */

/* LD1B  { <Zt1>.B-<Zt2>.B }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0400000) */
//#define IEM_INSTR_IMPL_A64__ld1b_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* LDNT1B  { <Zt1>.B-<Zt2>.B }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0400001) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* LD1H  { <Zt1>.H-<Zt2>.H }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0402000) */
//#define IEM_INSTR_IMPL_A64__ld1h_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* LDNT1H  { <Zt1>.H-<Zt2>.H }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0402001) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* LD1W  { <Zt1>.S-<Zt2>.S }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0404000) */
//#define IEM_INSTR_IMPL_A64__ld1w_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* LDNT1W  { <Zt1>.S-<Zt2>.S }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0404001) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* LD1D  { <Zt1>.D-<Zt2>.D }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0406000) */
//#define IEM_INSTR_IMPL_A64__ld1d_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* LDNT1D  { <Zt1>.D-<Zt2>.D }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0406001) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_mz_p_bi_2(Zt, Rn, PNg, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_cld_cldnt_si_nctg / mortlach_multi_mem_nctg / sme / A64
 *
 */

/* LD1B  { <Zt1>.B, <Zt2>.B }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1400000) */
//#define IEM_INSTR_IMPL_A64__ld1b_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* LDNT1B  { <Zt1>.B, <Zt2>.B }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1400008) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* LD1H  { <Zt1>.H, <Zt2>.H }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1402000) */
//#define IEM_INSTR_IMPL_A64__ld1h_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* LDNT1H  { <Zt1>.H, <Zt2>.H }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1402008) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* LD1W  { <Zt1>.S, <Zt2>.S }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1404000) */
//#define IEM_INSTR_IMPL_A64__ld1w_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* LDNT1W  { <Zt1>.S, <Zt2>.S }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1404008) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* LD1D  { <Zt1>.D, <Zt2>.D }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1406000) */
//#define IEM_INSTR_IMPL_A64__ld1d_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* LDNT1D  { <Zt1>.D, <Zt2>.D }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1406008) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_cld_cldnt_ss_ctg / mortlach_multi_mem_ctg / sme / A64
 *
 */

/* LD1B  { <Zt1>.B-<Zt2>.B }, <PNg>/Z, [<Xn|SP>, <Xm>] (ffe0e001/a0000000) */
//#define IEM_INSTR_IMPL_A64__ld1b_mz_p_br_2(Zt, Rn, PNg, Rm)


/* LDNT1B  { <Zt1>.B-<Zt2>.B }, <PNg>/Z, [<Xn|SP>, <Xm>] (ffe0e001/a0000001) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_mz_p_br_2(Zt, Rn, PNg, Rm)


/* LD1H  { <Zt1>.H-<Zt2>.H }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e001/a0002000) */
//#define IEM_INSTR_IMPL_A64__ld1h_mz_p_br_2(Zt, Rn, PNg, Rm)


/* LDNT1H  { <Zt1>.H-<Zt2>.H }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e001/a0002001) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_mz_p_br_2(Zt, Rn, PNg, Rm)


/* LD1W  { <Zt1>.S-<Zt2>.S }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e001/a0004000) */
//#define IEM_INSTR_IMPL_A64__ld1w_mz_p_br_2(Zt, Rn, PNg, Rm)


/* LDNT1W  { <Zt1>.S-<Zt2>.S }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e001/a0004001) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_mz_p_br_2(Zt, Rn, PNg, Rm)


/* LD1D  { <Zt1>.D-<Zt2>.D }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e001/a0006000) */
//#define IEM_INSTR_IMPL_A64__ld1d_mz_p_br_2(Zt, Rn, PNg, Rm)


/* LDNT1D  { <Zt1>.D-<Zt2>.D }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e001/a0006001) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_mz_p_br_2(Zt, Rn, PNg, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_cld_cldnt_ss_nctg / mortlach_multi_mem_nctg / sme / A64
 *
 */

/* LD1B  { <Zt1>.B, <Zt2>.B }, <PNg>/Z, [<Xn|SP>, <Xm>] (ffe0e008/a1000000) */
//#define IEM_INSTR_IMPL_A64__ld1b_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* LDNT1B  { <Zt1>.B, <Zt2>.B }, <PNg>/Z, [<Xn|SP>, <Xm>] (ffe0e008/a1000008) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* LD1H  { <Zt1>.H, <Zt2>.H }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e008/a1002000) */
//#define IEM_INSTR_IMPL_A64__ld1h_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* LDNT1H  { <Zt1>.H, <Zt2>.H }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e008/a1002008) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* LD1W  { <Zt1>.S, <Zt2>.S }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e008/a1004000) */
//#define IEM_INSTR_IMPL_A64__ld1w_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* LDNT1W  { <Zt1>.S, <Zt2>.S }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e008/a1004008) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* LD1D  { <Zt1>.D, <Zt2>.D }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e008/a1006000) */
//#define IEM_INSTR_IMPL_A64__ld1d_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* LDNT1D  { <Zt1>.D, <Zt2>.D }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e008/a1006008) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_cst_cstnt_si_ctg / mortlach_multi_mem_ctg / sme / A64
 *
 */

/* ST1B  { <Zt1>.B-<Zt2>.B }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0600000) */
//#define IEM_INSTR_IMPL_A64__st1b_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* STNT1B  { <Zt1>.B-<Zt2>.B }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0600001) */
//#define IEM_INSTR_IMPL_A64__stnt1b_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* ST1H  { <Zt1>.H-<Zt2>.H }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0602000) */
//#define IEM_INSTR_IMPL_A64__st1h_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* STNT1H  { <Zt1>.H-<Zt2>.H }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0602001) */
//#define IEM_INSTR_IMPL_A64__stnt1h_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* ST1W  { <Zt1>.S-<Zt2>.S }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0604000) */
//#define IEM_INSTR_IMPL_A64__st1w_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* STNT1W  { <Zt1>.S-<Zt2>.S }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0604001) */
//#define IEM_INSTR_IMPL_A64__stnt1w_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* ST1D  { <Zt1>.D-<Zt2>.D }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0606000) */
//#define IEM_INSTR_IMPL_A64__st1d_mz_p_bi_2(Zt, Rn, PNg, imm4)


/* STNT1D  { <Zt1>.D-<Zt2>.D }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e001/a0606001) */
//#define IEM_INSTR_IMPL_A64__stnt1d_mz_p_bi_2(Zt, Rn, PNg, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_cst_cstnt_si_nctg / mortlach_multi_mem_nctg / sme / A64
 *
 */

/* ST1B  { <Zt1>.B, <Zt2>.B }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1600000) */
//#define IEM_INSTR_IMPL_A64__st1b_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* STNT1B  { <Zt1>.B, <Zt2>.B }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1600008) */
//#define IEM_INSTR_IMPL_A64__stnt1b_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* ST1H  { <Zt1>.H, <Zt2>.H }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1602000) */
//#define IEM_INSTR_IMPL_A64__st1h_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* STNT1H  { <Zt1>.H, <Zt2>.H }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1602008) */
//#define IEM_INSTR_IMPL_A64__stnt1h_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* ST1W  { <Zt1>.S, <Zt2>.S }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1604000) */
//#define IEM_INSTR_IMPL_A64__st1w_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* STNT1W  { <Zt1>.S, <Zt2>.S }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1604008) */
//#define IEM_INSTR_IMPL_A64__stnt1w_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* ST1D  { <Zt1>.D, <Zt2>.D }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1606000) */
//#define IEM_INSTR_IMPL_A64__st1d_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)


/* STNT1D  { <Zt1>.D, <Zt2>.D }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e008/a1606008) */
//#define IEM_INSTR_IMPL_A64__stnt1d_mzx_p_bi_2x8(Zt, T, Rn, PNg, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_cst_cstnt_ss_ctg / mortlach_multi_mem_ctg / sme / A64
 *
 */

/* ST1B  { <Zt1>.B-<Zt2>.B }, <PNg>, [<Xn|SP>, <Xm>] (ffe0e001/a0200000) */
//#define IEM_INSTR_IMPL_A64__st1b_mz_p_br_2(Zt, Rn, PNg, Rm)


/* STNT1B  { <Zt1>.B-<Zt2>.B }, <PNg>, [<Xn|SP>, <Xm>] (ffe0e001/a0200001) */
//#define IEM_INSTR_IMPL_A64__stnt1b_mz_p_br_2(Zt, Rn, PNg, Rm)


/* ST1H  { <Zt1>.H-<Zt2>.H }, <PNg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e001/a0202000) */
//#define IEM_INSTR_IMPL_A64__st1h_mz_p_br_2(Zt, Rn, PNg, Rm)


/* STNT1H  { <Zt1>.H-<Zt2>.H }, <PNg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e001/a0202001) */
//#define IEM_INSTR_IMPL_A64__stnt1h_mz_p_br_2(Zt, Rn, PNg, Rm)


/* ST1W  { <Zt1>.S-<Zt2>.S }, <PNg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e001/a0204000) */
//#define IEM_INSTR_IMPL_A64__st1w_mz_p_br_2(Zt, Rn, PNg, Rm)


/* STNT1W  { <Zt1>.S-<Zt2>.S }, <PNg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e001/a0204001) */
//#define IEM_INSTR_IMPL_A64__stnt1w_mz_p_br_2(Zt, Rn, PNg, Rm)


/* ST1D  { <Zt1>.D-<Zt2>.D }, <PNg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e001/a0206000) */
//#define IEM_INSTR_IMPL_A64__st1d_mz_p_br_2(Zt, Rn, PNg, Rm)


/* STNT1D  { <Zt1>.D-<Zt2>.D }, <PNg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e001/a0206001) */
//#define IEM_INSTR_IMPL_A64__stnt1d_mz_p_br_2(Zt, Rn, PNg, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_cst_cstnt_ss_nctg / mortlach_multi_mem_nctg / sme / A64
 *
 */

/* ST1B  { <Zt1>.B, <Zt2>.B }, <PNg>, [<Xn|SP>, <Xm>] (ffe0e008/a1200000) */
//#define IEM_INSTR_IMPL_A64__st1b_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* STNT1B  { <Zt1>.B, <Zt2>.B }, <PNg>, [<Xn|SP>, <Xm>] (ffe0e008/a1200008) */
//#define IEM_INSTR_IMPL_A64__stnt1b_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* ST1H  { <Zt1>.H, <Zt2>.H }, <PNg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e008/a1202000) */
//#define IEM_INSTR_IMPL_A64__st1h_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* STNT1H  { <Zt1>.H, <Zt2>.H }, <PNg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e008/a1202008) */
//#define IEM_INSTR_IMPL_A64__stnt1h_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* ST1W  { <Zt1>.S, <Zt2>.S }, <PNg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e008/a1204000) */
//#define IEM_INSTR_IMPL_A64__st1w_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* STNT1W  { <Zt1>.S, <Zt2>.S }, <PNg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e008/a1204008) */
//#define IEM_INSTR_IMPL_A64__stnt1w_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* ST1D  { <Zt1>.D, <Zt2>.D }, <PNg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e008/a1206000) */
//#define IEM_INSTR_IMPL_A64__st1d_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)


/* STNT1D  { <Zt1>.D, <Zt2>.D }, <PNg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e008/a1206008) */
//#define IEM_INSTR_IMPL_A64__stnt1d_mzx_p_br_2x8(Zt, T, Rn, PNg, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_extract_ctg / mortlach_ext / sme / A64
 *
 */

/* MOVA  { <Zd1>.B-<Zd2>.B }, ZA0<HV>.B[<Ws>, <offs1>:<offs2>] (ffff1f01/c0060000) */
//#define IEM_INSTR_IMPL_A64__mova_mz2_za_b1(Zd, off3, Rs, V)


/* MOVA  { <Zd1>.H-<Zd2>.H }, <ZAn><HV>.H[<Ws>, <offs1>:<offs2>] (ffff1f01/c0460000) */
//#define IEM_INSTR_IMPL_A64__mova_mz2_za_h1(Zd, off2, ZAn, Rs, V)


/* MOVA  { <Zd1>.S-<Zd2>.S }, <ZAn><HV>.S[<Ws>, <offs1>:<offs2>] (ffff1f01/c0860000) */
//#define IEM_INSTR_IMPL_A64__mova_mz2_za_w1(Zd, o1, ZAn, Rs, V)


/* MOVA  { <Zd1>.D-<Zd2>.D }, <ZAn><HV>.D[<Ws>, <offs1>:<offs2>] (ffff1f01/c0c60000) */
//#define IEM_INSTR_IMPL_A64__mova_mz2_za_d1(Zd, ZAn, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_extract_zero / mortlach_ext / sme / A64
 *
 */

/* MOVAZ  { <Zd1>.B-<Zd2>.B }, ZA0<HV>.B[<Ws>, <offs1>:<offs2>] (ffff1f01/c0060200) */
//#define IEM_INSTR_IMPL_A64__movaz_mz2_za_b1(Zd, off3, Rs, V)


/* MOVAZ  { <Zd1>.H-<Zd2>.H }, <ZAn><HV>.H[<Ws>, <offs1>:<offs2>] (ffff1f01/c0460200) */
//#define IEM_INSTR_IMPL_A64__movaz_mz2_za_h1(Zd, off2, ZAn, Rs, V)


/* MOVAZ  { <Zd1>.S-<Zd2>.S }, <ZAn><HV>.S[<Ws>, <offs1>:<offs2>] (ffff1f01/c0860200) */
//#define IEM_INSTR_IMPL_A64__movaz_mz2_za_w1(Zd, o1, ZAn, Rs, V)


/* MOVAZ  { <Zd1>.D-<Zd2>.D }, <ZAn><HV>.D[<Ws>, <offs1>:<offs2>] (ffff1f01/c0c60200) */
//#define IEM_INSTR_IMPL_A64__movaz_mz2_za_d1(Zd, ZAn, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fclamp / mortlach_multi_sve_3 / sme / A64
 *
 */

/* FCLAMP  { <Zd1>.<T>-<Zd2>.<T> }, <Zn>.<T>, <Zm>.<T> (ff20fc01/c120c000) */
//#define IEM_INSTR_IMPL_A64__fclamp_mz_zz_2(Zd, Zn, Zm, size)


/* BFCLAMP  { <Zd1>.H-<Zd2>.H }, <Zn>.H, <Zm>.H (ffe0fc01/c120c000) */
//#define IEM_INSTR_IMPL_A64__bfclamp_mz_zz_2(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fma_long_idx / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* BFMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1901010) */
//#define IEM_INSTR_IMPL_A64__bfmlal_za_zzi_2xi(off2, i3l, Zn, i3h, Rv, Zm)


/* FMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1901000) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_zzi_2xi(off2, i3l, Zn, i3h, Rv, Zm)


/* BFMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1901018) */
//#define IEM_INSTR_IMPL_A64__bfmlsl_za_zzi_2xi(off2, i3l, Zn, i3h, Rv, Zm)


/* FMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1901008) */
//#define IEM_INSTR_IMPL_A64__fmlsl_za_zzi_2xi(off2, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fmul_mm / mortlach_multi_sve_5a / sme / A64
 *
 */

/* FMUL  { <Zd1>.<T>-<Zd2>.<T> }, { <Zn1>.<T>-<Zn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21fc21/c120e400) */
//#define IEM_INSTR_IMPL_A64__fmul_mz_zzw_2x2(Zd, Zn, Zm, size)


/* BFMUL  { <Zd1>.H-<Zd2>.H }, { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe1fc21/c120e400) */
//#define IEM_INSTR_IMPL_A64__bfmul_mz_zzw_2x2(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fmul_sm / mortlach_multi_sve_5b / sme / A64
 *
 */

/* FMUL  { <Zd1>.<T>-<Zd2>.<T> }, { <Zn1>.<T>-<Zn2>.<T> }, <Zm>.<T> (ff21fc21/c120e800) */
//#define IEM_INSTR_IMPL_A64__fmul_mz_zzv_2x1(Zd, Zn, Zm, size)


/* BFMUL  { <Zd1>.H-<Zd2>.H }, { <Zn1>.H-<Zn2>.H }, <Zm>.H (ffe1fc21/c120e800) */
//#define IEM_INSTR_IMPL_A64__bfmul_mz_zzv_2x1(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fp8_fdot_idx / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* FDOT  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09030/c1d00020) */
//#define IEM_INSTR_IMPL_A64__fdot_za_z8z8i_2xi(off3, i3l, Zn, i3h, Rv, Zm)


/* FVDOT  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09030/c1d01020) */
//#define IEM_INSTR_IMPL_A64__fvdot_za_z8z8i_2xi(off3, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fp8_fma_long_idx / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* FMLAL  ZA.H[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09030/c1901030) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_z8z8i_2xi(off2, i4l, Zn, i4h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fp8_fma_long_long_idx / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* FMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1900020) */
//#define IEM_INSTR_IMPL_A64__fmlall_za32_z8z8i_2xi(o1, i4l, Zn, i4h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fp8_fvdot_idx_s / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* FVDOTB  ZA.S[<Wv>, <offs>, VGx4], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09830/c1d00800) */
//#define IEM_INSTR_IMPL_A64__fvdotb_za32_z8z8i_2xi(off3, i2l, Zn, i2h, Rv, Zm)


/* FVDOTT  ZA.S[<Wv>, <offs>, VGx4], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09830/c1d00810) */
//#define IEM_INSTR_IMPL_A64__fvdott_za32_z8z8i_2xi(off3, i2l, Zn, i2h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_fpint_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* FCVTZS  { <Zd1>.S-<Zd2>.S }, { <Zn1>.S-<Zn2>.S } (fffffc21/c121e000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_mz_z_2(Zd, Zn)


/* FCVTZU  { <Zd1>.S-<Zd2>.S }, { <Zn1>.S-<Zn2>.S } (fffffc21/c121e020) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_mz_z_2(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_frint / mortlach_multi_sve_4 / sme / A64
 *
 */

/* FRINTN  { <Zd1>.S-<Zd2>.S }, { <Zn1>.S-<Zn2>.S } (fffffc21/c1a8e000) */
//#define IEM_INSTR_IMPL_A64__frintn_mz_z_2(Zd, Zn)


/* FRINTP  { <Zd1>.S-<Zd2>.S }, { <Zn1>.S-<Zn2>.S } (fffffc21/c1a9e000) */
//#define IEM_INSTR_IMPL_A64__frintp_mz_z_2(Zd, Zn)


/* FRINTM  { <Zd1>.S-<Zd2>.S }, { <Zn1>.S-<Zn2>.S } (fffffc21/c1aae000) */
//#define IEM_INSTR_IMPL_A64__frintm_mz_z_2(Zd, Zn)


/* FRINTA  { <Zd1>.S-<Zd2>.S }, { <Zn1>.S-<Zn2>.S } (fffffc21/c1ace000) */
//#define IEM_INSTR_IMPL_A64__frinta_mz_z_2(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_insert_ctg / mortlach_ins / sme / A64
 *
 */

/* MOVA  ZA0<HV>.B[<Ws>, <offs1>:<offs2>], { <Zn1>.B-<Zn2>.B } (ffff1c38/c0040000) */
//#define IEM_INSTR_IMPL_A64__mova_za2_z_b1(off3, Zn, Rs, V)


/* MOVA  <ZAd><HV>.H[<Ws>, <offs1>:<offs2>], { <Zn1>.H-<Zn2>.H } (ffff1c38/c0440000) */
//#define IEM_INSTR_IMPL_A64__mova_za2_z_h1(off2, ZAd, Zn, Rs, V)


/* MOVA  <ZAd><HV>.S[<Ws>, <offs1>:<offs2>], { <Zn1>.S-<Zn2>.S } (ffff1c38/c0840000) */
//#define IEM_INSTR_IMPL_A64__mova_za2_z_w1(o1, ZAd, Zn, Rs, V)


/* MOVA  <ZAd><HV>.D[<Ws>, <offs1>:<offs2>], { <Zn1>.D-<Zn2>.D } (ffff1c38/c0c40000) */
//#define IEM_INSTR_IMPL_A64__mova_za2_z_d1(ZAd, Zn, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_intfp_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* SCVTF  { <Zd1>.S-<Zd2>.S }, { <Zn1>.S-<Zn2>.S } (fffffc21/c122e000) */
//#define IEM_INSTR_IMPL_A64__scvtf_mz_z_2(Zd, Zn)


/* UCVTF  { <Zd1>.S-<Zd2>.S }, { <Zn1>.S-<Zn2>.S } (fffffc21/c122e020) */
//#define IEM_INSTR_IMPL_A64__ucvtf_mz_z_2(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_mla_long_idx / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* SMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1d01000) */
//#define IEM_INSTR_IMPL_A64__smlal_za_zzi_2xi(off2, i3l, Zn, i3h, Rv, Zm)


/* SMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1d01008) */
//#define IEM_INSTR_IMPL_A64__smlsl_za_zzi_2xi(off2, i3l, Zn, i3h, Rv, Zm)


/* UMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1d01010) */
//#define IEM_INSTR_IMPL_A64__umlal_za_zzi_2xi(off2, i3l, Zn, i3h, Rv, Zm)


/* UMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1d01018) */
//#define IEM_INSTR_IMPL_A64__umlsl_za_zzi_2xi(off2, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_mla_long_long_idx_d / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* SMLALL  ZA.D[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09838/c1900000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzi_d2xi(o1, i3l, Zn, i3h, Rv, Zm)


/* SMLSLL  ZA.D[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09838/c1900008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzi_d2xi(o1, i3l, Zn, i3h, Rv, Zm)


/* UMLALL  ZA.D[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09838/c1900010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzi_d2xi(o1, i3l, Zn, i3h, Rv, Zm)


/* UMLSLL  ZA.D[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09838/c1900018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzi_d2xi(o1, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_mla_long_long_idx_s / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* SMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1100000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzi_s2xi(o1, i4l, Zn, i4h, Rv, Zm)


/* USMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1100020) */
//#define IEM_INSTR_IMPL_A64__usmlall_za_zzi_s2xi(o1, i4l, Zn, i4h, Rv, Zm)


/* SMLSLL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1100008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzi_s2xi(o1, i4l, Zn, i4h, Rv, Zm)


/* UMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1100010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzi_s2xi(o1, i4l, Zn, i4h, Rv, Zm)


/* SUMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1100030) */
//#define IEM_INSTR_IMPL_A64__sumlall_za_zzi_s2xi(o1, i4l, Zn, i4h, Rv, Zm)


/* UMLSLL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1100018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzi_s2xi(o1, i4l, Zn, i4h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_narrow_fp8_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* BFCVT  <Zd>.B, { <Zn1>.H-<Zn2>.H } (fffffc20/c164e000) */
//#define IEM_INSTR_IMPL_A64__bfcvt_z8_mz2(Zd, Zn)


/* FCVT  <Zd>.B, { <Zn1>.H-<Zn2>.H } (fffffc20/c124e000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z8_mz2(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_narrow_fp_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* BFCVT  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/c160e000) */
//#define IEM_INSTR_IMPL_A64__bfcvt_z_mz2(Zd, Zn)


/* FCVT  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/c120e000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_mz2(Zd, Zn)


/* BFCVTN  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/c160e020) */
//#define IEM_INSTR_IMPL_A64__bfcvtn_z_mz2(Zd, Zn)


/* FCVTN  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/c120e020) */
//#define IEM_INSTR_IMPL_A64__fcvtn_z_mz2(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_narrow_int_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* SQCVT  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/c123e000) */
//#define IEM_INSTR_IMPL_A64__sqcvt_z_mz2(Zd, Zn)


/* SQCVTU  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/c163e000) */
//#define IEM_INSTR_IMPL_A64__sqcvtu_z_mz2(Zd, Zn)


/* UQCVT  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/c123e020) */
//#define IEM_INSTR_IMPL_A64__uqcvt_z_mz2(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_qrshr / mortlach_multi_sve_3 / sme / A64
 *
 */

/* SQRSHR  <Zd>.H, { <Zn1>.S-<Zn2>.S }, #<const> (fff0fc20/c1e0d400) */
//#define IEM_INSTR_IMPL_A64__sqrshr_z_mz2(Zd, Zn, imm4)


/* SQRSHRU  <Zd>.H, { <Zn1>.S-<Zn2>.S }, #<const> (fff0fc20/c1f0d400) */
//#define IEM_INSTR_IMPL_A64__sqrshru_z_mz2(Zd, Zn, imm4)


/* UQRSHR  <Zd>.H, { <Zn1>.S-<Zn2>.S }, #<const> (fff0fc20/c1e0d420) */
//#define IEM_INSTR_IMPL_A64__uqrshr_z_mz2(Zd, Zn, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_select_int / mortlach_multi_sve_1 / sme / A64
 *
 */

/* SEL  { <Zd1>.<T>-<Zd2>.<T> }, <PNg>, { <Zn1>.<T>-<Zn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21e021/c1208000) */
//#define IEM_INSTR_IMPL_A64__sel_mz_p_zz_2(Zd, Zn, PNg, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_wide_fp8_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* F1CVT  { <Zd1>.H-<Zd2>.H }, <Zn>.B (fffffc01/c126e000) */
//#define IEM_INSTR_IMPL_A64__f1cvt_mz2_z8(Zd, Zn)


/* BF1CVT  { <Zd1>.H-<Zd2>.H }, <Zn>.B (fffffc01/c166e000) */
//#define IEM_INSTR_IMPL_A64__bf1cvt_mz2_z8(Zd, Zn)


/* F2CVT  { <Zd1>.H-<Zd2>.H }, <Zn>.B (fffffc01/c1a6e000) */
//#define IEM_INSTR_IMPL_A64__f2cvt_mz2_z8(Zd, Zn)


/* BF2CVT  { <Zd1>.H-<Zd2>.H }, <Zn>.B (fffffc01/c1e6e000) */
//#define IEM_INSTR_IMPL_A64__bf2cvt_mz2_z8(Zd, Zn)


/* F1CVTL  { <Zd1>.H-<Zd2>.H }, <Zn>.B (fffffc01/c126e001) */
//#define IEM_INSTR_IMPL_A64__f1cvtl_mz2_z8(Zd, Zn)


/* BF1CVTL  { <Zd1>.H-<Zd2>.H }, <Zn>.B (fffffc01/c166e001) */
//#define IEM_INSTR_IMPL_A64__bf1cvtl_mz2_z8(Zd, Zn)


/* F2CVTL  { <Zd1>.H-<Zd2>.H }, <Zn>.B (fffffc01/c1a6e001) */
//#define IEM_INSTR_IMPL_A64__f2cvtl_mz2_z8(Zd, Zn)


/* BF2CVTL  { <Zd1>.H-<Zd2>.H }, <Zn>.B (fffffc01/c1e6e001) */
//#define IEM_INSTR_IMPL_A64__bf2cvtl_mz2_z8(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_wide_fp_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* FCVT  { <Zd1>.S-<Zd2>.S }, <Zn>.H (fffffc01/c1a0e000) */
//#define IEM_INSTR_IMPL_A64__fcvt_mz2_z(Zd, Zn)


/* FCVTL  { <Zd1>.S-<Zd2>.S }, <Zn>.H (fffffc01/c1a0e001) */
//#define IEM_INSTR_IMPL_A64__fcvtl_mz2_z(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_wide_int / mortlach_multi_sve_4 / sme / A64
 *
 */

/* SUNPK  { <Zd1>.<T>-<Zd2>.<T> }, <Zn>.<Tb> (ff3ffc01/c125e000) */
//#define IEM_INSTR_IMPL_A64__sunpk_mz_z_2(Zd, Zn, size)


/* UUNPK  { <Zd1>.<T>-<Zd2>.<T> }, <Zn>.<Tb> (ff3ffc01/c125e001) */
//#define IEM_INSTR_IMPL_A64__uunpk_mz_z_2(Zd, Zn, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_add_sm / mortlach_multi_sve_2a / sme / A64
 *
 */

/* ADD  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a300) */
//#define IEM_INSTR_IMPL_A64__add_mz_zzv_2x1(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_fminmax_mm / mortlach_multi_sve_2c0 / sme / A64
 *
 */

/* FMAX  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b100) */
//#define IEM_INSTR_IMPL_A64__fmax_mz_zzw_2x2(Zdn, Zm, size)


/* BFMAX  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe1ffe1/c120b100) */
//#define IEM_INSTR_IMPL_A64__bfmax_mz_zzw_2x2(Zdn, Zm)


/* FMIN  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b101) */
//#define IEM_INSTR_IMPL_A64__fmin_mz_zzw_2x2(Zdn, Zm, size)


/* BFMIN  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe1ffe1/c120b101) */
//#define IEM_INSTR_IMPL_A64__bfmin_mz_zzw_2x2(Zdn, Zm)


/* FMAXNM  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b120) */
//#define IEM_INSTR_IMPL_A64__fmaxnm_mz_zzw_2x2(Zdn, Zm, size)


/* BFMAXNM  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe1ffe1/c120b120) */
//#define IEM_INSTR_IMPL_A64__bfmaxnm_mz_zzw_2x2(Zdn, Zm)


/* FMINNM  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b121) */
//#define IEM_INSTR_IMPL_A64__fminnm_mz_zzw_2x2(Zdn, Zm, size)


/* BFMINNM  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe1ffe1/c120b121) */
//#define IEM_INSTR_IMPL_A64__bfminnm_mz_zzw_2x2(Zdn, Zm)


/* FAMAX  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b140) */
//#define IEM_INSTR_IMPL_A64__famax_mz_zzw_2x2(Zdn, Zm, size)


/* FAMIN  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b141) */
//#define IEM_INSTR_IMPL_A64__famin_mz_zzw_2x2(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_fminmax_sm / mortlach_multi_sve_2a / sme / A64
 *
 */

/* FMAX  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a100) */
//#define IEM_INSTR_IMPL_A64__fmax_mz_zzv_2x1(Zdn, Zm, size)


/* BFMAX  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, <Zm>.H (fff0ffe1/c120a100) */
//#define IEM_INSTR_IMPL_A64__bfmax_mz_zzv_2x1(Zdn, Zm)


/* FMIN  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a101) */
//#define IEM_INSTR_IMPL_A64__fmin_mz_zzv_2x1(Zdn, Zm, size)


/* BFMIN  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, <Zm>.H (fff0ffe1/c120a101) */
//#define IEM_INSTR_IMPL_A64__bfmin_mz_zzv_2x1(Zdn, Zm)


/* FMAXNM  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a120) */
//#define IEM_INSTR_IMPL_A64__fmaxnm_mz_zzv_2x1(Zdn, Zm, size)


/* BFMAXNM  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, <Zm>.H (fff0ffe1/c120a120) */
//#define IEM_INSTR_IMPL_A64__bfmaxnm_mz_zzv_2x1(Zdn, Zm)


/* FMINNM  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a121) */
//#define IEM_INSTR_IMPL_A64__fminnm_mz_zzv_2x1(Zdn, Zm, size)


/* BFMINNM  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, <Zm>.H (fff0ffe1/c120a121) */
//#define IEM_INSTR_IMPL_A64__bfminnm_mz_zzv_2x1(Zdn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_fscale_mm / mortlach_multi_sve_2c0 / sme / A64
 *
 */

/* FSCALE  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b180) */
//#define IEM_INSTR_IMPL_A64__fscale_mz_zzw_2x2(Zdn, Zm, size)


/* BFSCALE  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe1ffe1/c120b180) */
//#define IEM_INSTR_IMPL_A64__bfscale_mz_zzw_2x2(Zdn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_fscale_sm / mortlach_multi_sve_2a / sme / A64
 *
 */

/* FSCALE  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a180) */
//#define IEM_INSTR_IMPL_A64__fscale_mz_zzv_2x1(Zdn, Zm, size)


/* BFSCALE  { <Zdn1>.H-<Zdn2>.H }, { <Zdn1>.H-<Zdn2>.H }, <Zm>.H (fff0ffe1/c120a180) */
//#define IEM_INSTR_IMPL_A64__bfscale_mz_zzv_2x1(Zdn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_long_zip / mortlach_multi_sve_3 / sme / A64
 *
 */

/* ZIP  { <Zd1>.Q-<Zd2>.Q }, <Zn>.Q, <Zm>.Q (ffe0fc01/c120d400) */
//#define IEM_INSTR_IMPL_A64__zip_mz_zz_2q(Zd, Zn, Zm)


/* UZP  { <Zd1>.Q-<Zd2>.Q }, <Zn>.Q, <Zm>.Q (ffe0fc01/c120d401) */
//#define IEM_INSTR_IMPL_A64__uzp_mz_zz_2q(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_minmax_mm / mortlach_multi_sve_2c0 / sme / A64
 *
 */

/* SMAX  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b000) */
//#define IEM_INSTR_IMPL_A64__smax_mz_zzw_2x2(Zdn, Zm, size)


/* SMIN  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b020) */
//#define IEM_INSTR_IMPL_A64__smin_mz_zzw_2x2(Zdn, Zm, size)


/* UMAX  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b001) */
//#define IEM_INSTR_IMPL_A64__umax_mz_zzw_2x2(Zdn, Zm, size)


/* UMIN  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b021) */
//#define IEM_INSTR_IMPL_A64__umin_mz_zzw_2x2(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_minmax_sm / mortlach_multi_sve_2a / sme / A64
 *
 */

/* SMAX  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a000) */
//#define IEM_INSTR_IMPL_A64__smax_mz_zzv_2x1(Zdn, Zm, size)


/* SMIN  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a020) */
//#define IEM_INSTR_IMPL_A64__smin_mz_zzv_2x1(Zdn, Zm, size)


/* UMAX  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a001) */
//#define IEM_INSTR_IMPL_A64__umax_mz_zzv_2x1(Zdn, Zm, size)


/* UMIN  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a021) */
//#define IEM_INSTR_IMPL_A64__umin_mz_zzv_2x1(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_shift_mm / mortlach_multi_sve_2c0 / sme / A64
 *
 */

/* SRSHL  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b220) */
//#define IEM_INSTR_IMPL_A64__srshl_mz_zzw_2x2(Zdn, Zm, size)


/* URSHL  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b221) */
//#define IEM_INSTR_IMPL_A64__urshl_mz_zzw_2x2(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_shift_sm / mortlach_multi_sve_2a / sme / A64
 *
 */

/* SRSHL  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a220) */
//#define IEM_INSTR_IMPL_A64__srshl_mz_zzv_2x1(Zdn, Zm, size)


/* URSHL  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a221) */
//#define IEM_INSTR_IMPL_A64__urshl_mz_zzv_2x1(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_sqdmulh_mm / mortlach_multi_sve_2c1 / sme / A64
 *
 */

/* SQDMULH  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ff21ffe1/c120b400) */
//#define IEM_INSTR_IMPL_A64__sqdmulh_mz_zzw_2x2(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_sqdmulh_sm / mortlach_multi_sve_2a / sme / A64
 *
 */

/* SQDMULH  { <Zdn1>.<T>-<Zdn2>.<T> }, { <Zdn1>.<T>-<Zdn2>.<T> }, <Zm>.<T> (ff30ffe1/c120a400) */
//#define IEM_INSTR_IMPL_A64__sqdmulh_mz_zzv_2x1(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_z_zip / mortlach_multi_sve_3 / sme / A64
 *
 */

/* ZIP  { <Zd1>.<T>-<Zd2>.<T> }, <Zn>.<T>, <Zm>.<T> (ff20fc01/c120d000) */
//#define IEM_INSTR_IMPL_A64__zip_mz_zz_2(Zd, Zn, Zm, size)


/* UZP  { <Zd1>.<T>-<Zd2>.<T> }, <Zn>.<T>, <Zm>.<T> (ff20fc01/c120d001) */
//#define IEM_INSTR_IMPL_A64__uzp_mz_zz_2(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_2way_dot_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* SDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c38/c1e01408) */
//#define IEM_INSTR_IMPL_A64__sdot_za32_zzw_2x2(off3, Zn, Rv, Zm)


/* UDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c38/c1e01418) */
//#define IEM_INSTR_IMPL_A64__udot_za32_zzw_2x2(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_2way_dot_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* SDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c18/c1601408) */
//#define IEM_INSTR_IMPL_A64__sdot_za32_zzv_2x1(off3, Zn, Rv, Zm)


/* UDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c18/c1601418) */
//#define IEM_INSTR_IMPL_A64__udot_za32_zzv_2x1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_4way_dot_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* SDOT  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, { <Zm1>.<Tb>-<Zm2>.<Tb> } (ffa19c38/c1a01400) */
//#define IEM_INSTR_IMPL_A64__sdot_za_zzw_2x2(off3, Zn, Rv, Zm, sz)


/* UDOT  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, { <Zm1>.<Tb>-<Zm2>.<Tb> } (ffa19c38/c1a01410) */
//#define IEM_INSTR_IMPL_A64__udot_za_zzw_2x2(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_4way_dot_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* SDOT  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, <Zm>.<Tb> (ffb09c18/c1201400) */
//#define IEM_INSTR_IMPL_A64__sdot_za_zzv_2x1(off3, Zn, Rv, Zm, sz)


/* UDOT  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, <Zm>.<Tb> (ffb09c18/c1201410) */
//#define IEM_INSTR_IMPL_A64__udot_za_zzv_2x1(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_f16_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* FADD  ZA.H[<Wv>, <offs>{, VGx2}], { <Zm1>.H-<Zm2>.H } (ffff9c38/c1a41c00) */
//#define IEM_INSTR_IMPL_A64__fadd_za_zw_2x2_16(off3, Zm, Rv)


/* BFADD  ZA.H[<Wv>, <offs>{, VGx2}], { <Zm1>.H-<Zm2>.H } (ffff9c38/c1e41c00) */
//#define IEM_INSTR_IMPL_A64__bfadd_za_zw_2x2_16(off3, Zm, Rv)


/* FSUB  ZA.H[<Wv>, <offs>{, VGx2}], { <Zm1>.H-<Zm2>.H } (ffff9c38/c1a41c08) */
//#define IEM_INSTR_IMPL_A64__fsub_za_zw_2x2_16(off3, Zm, Rv)


/* BFSUB  ZA.H[<Wv>, <offs>{, VGx2}], { <Zm1>.H-<Zm2>.H } (ffff9c38/c1e41c08) */
//#define IEM_INSTR_IMPL_A64__bfsub_za_zw_2x2_16(off3, Zm, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_float_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* FADD  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zm1>.<T>-<Zm2>.<T> } (ffbf9c38/c1a01c00) */
//#define IEM_INSTR_IMPL_A64__fadd_za_zw_2x2(off3, Zm, Rv, sz)


/* FSUB  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zm1>.<T>-<Zm2>.<T> } (ffbf9c38/c1a01c08) */
//#define IEM_INSTR_IMPL_A64__fsub_za_zw_2x2(off3, Zm, Rv, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_fpdot_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* FDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c38/c1a01000) */
//#define IEM_INSTR_IMPL_A64__fdot_za_zzw_2x2(off3, Zn, Rv, Zm)


/* BFDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c38/c1a01010) */
//#define IEM_INSTR_IMPL_A64__bfdot_za_zzw_2x2(off3, Zn, Rv, Zm)


/* FDOT  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (ffe19c38/c1a01020) */
//#define IEM_INSTR_IMPL_A64__fdot_za_z8z8w_2x2(off3, Zn, Rv, Zm)


/* FDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (ffe19c38/c1a01030) */
//#define IEM_INSTR_IMPL_A64__fdot_za32_z8z8w_2x2(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_fpdot_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* FDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c18/c1201000) */
//#define IEM_INSTR_IMPL_A64__fdot_za_zzv_2x1(off3, Zn, Rv, Zm)


/* BFDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c18/c1201010) */
//#define IEM_INSTR_IMPL_A64__bfdot_za_zzv_2x1(off3, Zn, Rv, Zm)


/* FDOT  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff09c18/c1201008) */
//#define IEM_INSTR_IMPL_A64__fdot_za_z8z8v_2x1(off3, Zn, Rv, Zm)


/* FDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff09c18/c1201018) */
//#define IEM_INSTR_IMPL_A64__fdot_za32_z8z8v_2x1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_int_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* ADD  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zm1>.<T>-<Zm2>.<T> } (ffbf9c38/c1a01c10) */
//#define IEM_INSTR_IMPL_A64__add_za_zw_2x2(off3, Zm, Rv, sz)


/* SUB  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zm1>.<T>-<Zm2>.<T> } (ffbf9c38/c1a01c18) */
//#define IEM_INSTR_IMPL_A64__sub_za_zw_2x2(off3, Zm, Rv, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_mixed_dot_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* USDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (ffe19c38/c1a01408) */
//#define IEM_INSTR_IMPL_A64__usdot_za_zzw_s2x2(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_z_za_mixed_dot_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* USDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff09c18/c1201408) */
//#define IEM_INSTR_IMPL_A64__usdot_za_zzv_s2x1(off3, Zn, Rv, Zm)


/* SUDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff09c18/c1201418) */
//#define IEM_INSTR_IMPL_A64__sudot_za_zzv_s2x1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_za_extract_ctg / mortlach_ext / sme / A64
 *
 */

/* MOVA  { <Zd1>.D-<Zd2>.D }, ZA.D[<Wv>, <offs>{, VGx2}] (ffff9f01/c0060800) */
//#define IEM_INSTR_IMPL_A64__mova_mz_za2_1(Zd, off3, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_za_extract_zero / mortlach_ext / sme / A64
 *
 */

/* MOVAZ  { <Zd1>.D-<Zd2>.D }, ZA.D[<Wv>, <offs>{, VGx2}] (ffff9f01/c0060a00) */
//#define IEM_INSTR_IMPL_A64__movaz_mz_za2_1(Zd, off3, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_za_insert_ctg / mortlach_ins / sme / A64
 *
 */

/* MOVA  ZA.D[<Wv>, <offs>{, VGx2}], { <Zn1>.D-<Zn2>.D } (ffff9c38/c0040800) */
//#define IEM_INSTR_IMPL_A64__mova_za_mz2_1(off3, Zn, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_f16_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* FMLA  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c38/c1a01008) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzw_2x2_16(off3, Zn, Rv, Zm)


/* BFMLA  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c38/c1e01008) */
//#define IEM_INSTR_IMPL_A64__bfmla_za_zzw_2x2_16(off3, Zn, Rv, Zm)


/* FMLS  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c38/c1a01018) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzw_2x2_16(off3, Zn, Rv, Zm)


/* BFMLS  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c38/c1e01018) */
//#define IEM_INSTR_IMPL_A64__bfmls_za_zzw_2x2_16(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_f16_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* FMLA  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c18/c1201c00) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzv_2x1_16(off3, Zn, Rv, Zm)


/* BFMLA  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c18/c1601c00) */
//#define IEM_INSTR_IMPL_A64__bfmla_za_zzv_2x1_16(off3, Zn, Rv, Zm)


/* FMLS  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c18/c1201c08) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzv_2x1_16(off3, Zn, Rv, Zm)


/* BFMLS  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c18/c1601c08) */
//#define IEM_INSTR_IMPL_A64__bfmls_za_zzv_2x1_16(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_float_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* FMLA  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<T>-<Zn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ffa19c38/c1a01800) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzw_2x2(off3, Zn, Rv, Zm, sz)


/* FMLS  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<T>-<Zn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ffa19c38/c1a01808) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzw_2x2(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_float_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* FMLA  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<T>-<Zn2>.<T> }, <Zm>.<T> (ffb09c18/c1201800) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzv_2x1(off3, Zn, Rv, Zm, sz)


/* FMLS  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<T>-<Zn2>.<T> }, <Zm>.<T> (ffb09c18/c1201808) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzv_2x1(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_fma_long_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* BFMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c3c/c1a00810) */
//#define IEM_INSTR_IMPL_A64__bfmlal_za_zzw_2x2(off2, Zn, Rv, Zm)


/* FMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c3c/c1a00800) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_zzw_2x2(off2, Zn, Rv, Zm)


/* BFMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c3c/c1a00818) */
//#define IEM_INSTR_IMPL_A64__bfmlsl_za_zzw_2x2(off2, Zn, Rv, Zm)


/* FMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c3c/c1a00808) */
//#define IEM_INSTR_IMPL_A64__fmlsl_za_zzw_2x2(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_fma_long_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* BFMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c1c/c1200810) */
//#define IEM_INSTR_IMPL_A64__bfmlal_za_zzv_2x1(off2, Zn, Rv, Zm)


/* FMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c1c/c1200800) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_zzv_2x1(off2, Zn, Rv, Zm)


/* FMLAL  ZA.H[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff09c1c/c1200804) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_z8z8v_2x1(off2, Zn, Rv, Zm)


/* BFMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c1c/c1200818) */
//#define IEM_INSTR_IMPL_A64__bfmlsl_za_zzv_2x1(off2, Zn, Rv, Zm)


/* FMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c1c/c1200808) */
//#define IEM_INSTR_IMPL_A64__fmlsl_za_zzv_2x1(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_fp8_fma_long_long_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* FMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (ffe19c3e/c1a00020) */
//#define IEM_INSTR_IMPL_A64__fmlall_za32_z8z8w_2x2(o1, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_fp8_fma_long_long_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* FMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff09c1e/c1200002) */
//#define IEM_INSTR_IMPL_A64__fmlall_za32_z8z8v_2x1(o1, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_fp8_fma_long_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* FMLAL  ZA.H[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (ffe19c3c/c1a00820) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_z8z8w_2x2(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_int_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* ADD  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<T>-<Zn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ffa19c38/c1a01810) */
//#define IEM_INSTR_IMPL_A64__add_za_zzw_2x2(off3, Zn, Rv, Zm, sz)


/* SUB  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<T>-<Zn2>.<T> }, { <Zm1>.<T>-<Zm2>.<T> } (ffa19c38/c1a01818) */
//#define IEM_INSTR_IMPL_A64__sub_za_zzw_2x2(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_int_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* ADD  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<T>-<Zn2>.<T> }, <Zm>.<T> (ffb09c18/c1201810) */
//#define IEM_INSTR_IMPL_A64__add_za_zzv_2x1(off3, Zn, Rv, Zm, sz)


/* SUB  ZA.<T>[<Wv>, <offs>{, VGx2}], { <Zn1>.<T>-<Zn2>.<T> }, <Zm>.<T> (ffb09c18/c1201818) */
//#define IEM_INSTR_IMPL_A64__sub_za_zzv_2x1(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_mla_long_long_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* SMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, { <Zm1>.<Tb>-<Zm2>.<Tb> } (ffa19c3e/c1a00000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzw_2x2(o1, Zn, Rv, Zm, sz)


/* USMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, { <Zm1>.B-<Zm2>.B } (ffe19c3e/c1a00004) */
//#define IEM_INSTR_IMPL_A64__usmlall_za_zzw_s2x2(o1, Zn, Rv, Zm)


/* SMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, { <Zm1>.<Tb>-<Zm2>.<Tb> } (ffa19c3e/c1a00008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzw_2x2(o1, Zn, Rv, Zm, sz)


/* UMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, { <Zm1>.<Tb>-<Zm2>.<Tb> } (ffa19c3e/c1a00010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzw_2x2(o1, Zn, Rv, Zm, sz)


/* UMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, { <Zm1>.<Tb>-<Zm2>.<Tb> } (ffa19c3e/c1a00018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzw_2x2(o1, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_mla_long_long_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* SMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, <Zm>.<Tb> (ffb09c1e/c1200000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzv_2x1(o1, Zn, Rv, Zm, sz)


/* USMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff09c1e/c1200004) */
//#define IEM_INSTR_IMPL_A64__usmlall_za_zzv_s2x1(o1, Zn, Rv, Zm)


/* SMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, <Zm>.<Tb> (ffb09c1e/c1200008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzv_2x1(o1, Zn, Rv, Zm, sz)


/* UMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, <Zm>.<Tb> (ffb09c1e/c1200010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzv_2x1(o1, Zn, Rv, Zm, sz)


/* SUMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B (fff09c1e/c1200014) */
//#define IEM_INSTR_IMPL_A64__sumlall_za_zzv_s2x1(o1, Zn, Rv, Zm)


/* UMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx2}], { <Zn1>.<Tb>-<Zn2>.<Tb> }, <Zm>.<Tb> (ffb09c1e/c1200018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzv_2x1(o1, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_mla_long_mm / mortlach_multi_array_2a / sme / A64
 *
 */

/* SMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c3c/c1e00800) */
//#define IEM_INSTR_IMPL_A64__smlal_za_zzw_2x2(off2, Zn, Rv, Zm)


/* SMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c3c/c1e00808) */
//#define IEM_INSTR_IMPL_A64__smlsl_za_zzw_2x2(off2, Zn, Rv, Zm)


/* UMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c3c/c1e00810) */
//#define IEM_INSTR_IMPL_A64__umlal_za_zzw_2x2(off2, Zn, Rv, Zm)


/* UMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, { <Zm1>.H-<Zm2>.H } (ffe19c3c/c1e00818) */
//#define IEM_INSTR_IMPL_A64__umlsl_za_zzw_2x2(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zz_za_mla_long_sm / mortlach_multi_array_1a / sme / A64
 *
 */

/* SMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c1c/c1600800) */
//#define IEM_INSTR_IMPL_A64__smlal_za_zzv_2x1(off2, Zn, Rv, Zm)


/* SMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c1c/c1600808) */
//#define IEM_INSTR_IMPL_A64__smlsl_za_zzv_2x1(off2, Zn, Rv, Zm)


/* UMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c1c/c1600810) */
//#define IEM_INSTR_IMPL_A64__umlal_za_zzv_2x1(off2, Zn, Rv, Zm)


/* UMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H (fff09c1c/c1600818) */
//#define IEM_INSTR_IMPL_A64__umlsl_za_zzv_2x1(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zza_idx_d / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* FMLA  ZA.D[<Wv>, <offs>{, VGx2}], { <Zn1>.D-<Zn2>.D }, <Zm>.D[<index>] (fff09838/c1d00000) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzi_d2xi(off3, Zn, i1, Rv, Zm)


/* SDOT  ZA.D[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09838/c1d00008) */
//#define IEM_INSTR_IMPL_A64__sdot_za_zzi_d2xi(off3, Zn, i1, Rv, Zm)


/* FMLS  ZA.D[<Wv>, <offs>{, VGx2}], { <Zn1>.D-<Zn2>.D }, <Zm>.D[<index>] (fff09838/c1d00010) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzi_d2xi(off3, Zn, i1, Rv, Zm)


/* UDOT  ZA.D[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09838/c1d00018) */
//#define IEM_INSTR_IMPL_A64__udot_za_zzi_d2xi(off3, Zn, i1, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zza_idx_h / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* FMLA  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09030/c1101000) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzi_h2xi(off3, i3l, Zn, i3h, Rv, Zm)


/* BFMLA  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09030/c1101020) */
//#define IEM_INSTR_IMPL_A64__bfmla_za_zzi_h2xi(off3, i3l, Zn, i3h, Rv, Zm)


/* FMLS  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09030/c1101010) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzi_h2xi(off3, i3l, Zn, i3h, Rv, Zm)


/* BFMLS  ZA.H[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09030/c1101030) */
//#define IEM_INSTR_IMPL_A64__bfmls_za_zzi_h2xi(off3, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi2_zza_idx_s / mortlach_multi_indexed_2 / sme / A64
 *
 */

/* FMLA  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.S-<Zn2>.S }, <Zm>.S[<index>] (fff09038/c1500000) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzi_s2xi(off3, Zn, i2, Rv, Zm)


/* FVDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1500008) */
//#define IEM_INSTR_IMPL_A64__fvdot_za_zzi_2xi(off3, Zn, i2, Rv, Zm)


/* BFVDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1500018) */
//#define IEM_INSTR_IMPL_A64__bfvdot_za_zzi_2xi(off3, Zn, i2, Rv, Zm)


/* SVDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1500020) */
//#define IEM_INSTR_IMPL_A64__svdot_za32_zzi_2xi(off3, Zn, i2, Rv, Zm)


/* FDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1500038) */
//#define IEM_INSTR_IMPL_A64__fdot_za32_z8z8i_2xi(off3, Zn, i2, Rv, Zm)


/* SDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1501000) */
//#define IEM_INSTR_IMPL_A64__sdot_za32_zzi_2xi(off3, Zn, i2, Rv, Zm)


/* FDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1501008) */
//#define IEM_INSTR_IMPL_A64__fdot_za_zzi_2xi(off3, Zn, i2, Rv, Zm)


/* BFDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1501018) */
//#define IEM_INSTR_IMPL_A64__bfdot_za_zzi_2xi(off3, Zn, i2, Rv, Zm)


/* SDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1501020) */
//#define IEM_INSTR_IMPL_A64__sdot_za_zzi_s2xi(off3, Zn, i2, Rv, Zm)


/* USDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1501028) */
//#define IEM_INSTR_IMPL_A64__usdot_za_zzi_s2xi(off3, Zn, i2, Rv, Zm)


/* FMLS  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.S-<Zn2>.S }, <Zm>.S[<index>] (fff09038/c1500010) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzi_s2xi(off3, Zn, i2, Rv, Zm)


/* UVDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1500030) */
//#define IEM_INSTR_IMPL_A64__uvdot_za32_zzi_2xi(off3, Zn, i2, Rv, Zm)


/* UDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.H-<Zn2>.H }, <Zm>.H[<index>] (fff09038/c1501010) */
//#define IEM_INSTR_IMPL_A64__udot_za32_zzi_2xi(off3, Zn, i2, Rv, Zm)


/* UDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1501030) */
//#define IEM_INSTR_IMPL_A64__udot_za_zzi_s2xi(off3, Zn, i2, Rv, Zm)


/* SUDOT  ZA.S[<Wv>, <offs>{, VGx2}], { <Zn1>.B-<Zn2>.B }, <Zm>.B[<index>] (fff09038/c1501038) */
//#define IEM_INSTR_IMPL_A64__sudot_za_zzi_s2xi(off3, Zn, i2, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_clamp_int / mortlach_multi_sve_3 / sme / A64
 *
 */

/* SCLAMP  { <Zd1>.<T>-<Zd4>.<T> }, <Zn>.<T>, <Zm>.<T> (ff20fc03/c120cc00) */
//#define IEM_INSTR_IMPL_A64__sclamp_mz_zz_4(Zd, Zn, Zm, size)


/* UCLAMP  { <Zd1>.<T>-<Zd4>.<T> }, <Zn>.<T>, <Zm>.<T> (ff20fc03/c120cc01) */
//#define IEM_INSTR_IMPL_A64__uclamp_mz_zz_4(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_cld_cldnt_si_ctg / mortlach_multi_mem_ctg / sme / A64
 *
 */

/* LD1B  { <Zt1>.B-<Zt4>.B }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a0408000) */
//#define IEM_INSTR_IMPL_A64__ld1b_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* LDNT1B  { <Zt1>.B-<Zt4>.B }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a0408001) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* LD1H  { <Zt1>.H-<Zt4>.H }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a040a000) */
//#define IEM_INSTR_IMPL_A64__ld1h_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* LDNT1H  { <Zt1>.H-<Zt4>.H }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a040a001) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* LD1W  { <Zt1>.S-<Zt4>.S }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a040c000) */
//#define IEM_INSTR_IMPL_A64__ld1w_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* LDNT1W  { <Zt1>.S-<Zt4>.S }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a040c001) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* LD1D  { <Zt1>.D-<Zt4>.D }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a040e000) */
//#define IEM_INSTR_IMPL_A64__ld1d_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* LDNT1D  { <Zt1>.D-<Zt4>.D }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a040e001) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_mz_p_bi_4(Zt, Rn, PNg, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_cld_cldnt_si_nctg / mortlach_multi_mem_nctg / sme / A64
 *
 */

/* LD1B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a1408000) */
//#define IEM_INSTR_IMPL_A64__ld1b_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* LDNT1B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a1408008) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* LD1H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a140a000) */
//#define IEM_INSTR_IMPL_A64__ld1h_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* LDNT1H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a140a008) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* LD1W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a140c000) */
//#define IEM_INSTR_IMPL_A64__ld1w_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* LDNT1W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a140c008) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* LD1D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a140e000) */
//#define IEM_INSTR_IMPL_A64__ld1d_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* LDNT1D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <PNg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a140e008) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_cld_cldnt_ss_ctg / mortlach_multi_mem_ctg / sme / A64
 *
 */

/* LD1B  { <Zt1>.B-<Zt4>.B }, <PNg>/Z, [<Xn|SP>, <Xm>] (ffe0e003/a0008000) */
//#define IEM_INSTR_IMPL_A64__ld1b_mz_p_br_4(Zt, Rn, PNg, Rm)


/* LDNT1B  { <Zt1>.B-<Zt4>.B }, <PNg>/Z, [<Xn|SP>, <Xm>] (ffe0e003/a0008001) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_mz_p_br_4(Zt, Rn, PNg, Rm)


/* LD1H  { <Zt1>.H-<Zt4>.H }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e003/a000a000) */
//#define IEM_INSTR_IMPL_A64__ld1h_mz_p_br_4(Zt, Rn, PNg, Rm)


/* LDNT1H  { <Zt1>.H-<Zt4>.H }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e003/a000a001) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_mz_p_br_4(Zt, Rn, PNg, Rm)


/* LD1W  { <Zt1>.S-<Zt4>.S }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e003/a000c000) */
//#define IEM_INSTR_IMPL_A64__ld1w_mz_p_br_4(Zt, Rn, PNg, Rm)


/* LDNT1W  { <Zt1>.S-<Zt4>.S }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e003/a000c001) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_mz_p_br_4(Zt, Rn, PNg, Rm)


/* LD1D  { <Zt1>.D-<Zt4>.D }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e003/a000e000) */
//#define IEM_INSTR_IMPL_A64__ld1d_mz_p_br_4(Zt, Rn, PNg, Rm)


/* LDNT1D  { <Zt1>.D-<Zt4>.D }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e003/a000e001) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_mz_p_br_4(Zt, Rn, PNg, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_cld_cldnt_ss_nctg / mortlach_multi_mem_nctg / sme / A64
 *
 */

/* LD1B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <PNg>/Z, [<Xn|SP>, <Xm>] (ffe0e00c/a1008000) */
//#define IEM_INSTR_IMPL_A64__ld1b_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* LDNT1B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <PNg>/Z, [<Xn|SP>, <Xm>] (ffe0e00c/a1008008) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* LD1H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e00c/a100a000) */
//#define IEM_INSTR_IMPL_A64__ld1h_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* LDNT1H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e00c/a100a008) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* LD1W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e00c/a100c000) */
//#define IEM_INSTR_IMPL_A64__ld1w_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* LDNT1W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e00c/a100c008) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* LD1D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e00c/a100e000) */
//#define IEM_INSTR_IMPL_A64__ld1d_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* LDNT1D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <PNg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e00c/a100e008) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_cst_cstnt_si_ctg / mortlach_multi_mem_ctg / sme / A64
 *
 */

/* ST1B  { <Zt1>.B-<Zt4>.B }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a0608000) */
//#define IEM_INSTR_IMPL_A64__st1b_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* STNT1B  { <Zt1>.B-<Zt4>.B }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a0608001) */
//#define IEM_INSTR_IMPL_A64__stnt1b_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* ST1H  { <Zt1>.H-<Zt4>.H }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a060a000) */
//#define IEM_INSTR_IMPL_A64__st1h_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* STNT1H  { <Zt1>.H-<Zt4>.H }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a060a001) */
//#define IEM_INSTR_IMPL_A64__stnt1h_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* ST1W  { <Zt1>.S-<Zt4>.S }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a060c000) */
//#define IEM_INSTR_IMPL_A64__st1w_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* STNT1W  { <Zt1>.S-<Zt4>.S }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a060c001) */
//#define IEM_INSTR_IMPL_A64__stnt1w_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* ST1D  { <Zt1>.D-<Zt4>.D }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a060e000) */
//#define IEM_INSTR_IMPL_A64__st1d_mz_p_bi_4(Zt, Rn, PNg, imm4)


/* STNT1D  { <Zt1>.D-<Zt4>.D }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e003/a060e001) */
//#define IEM_INSTR_IMPL_A64__stnt1d_mz_p_bi_4(Zt, Rn, PNg, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_cst_cstnt_si_nctg / mortlach_multi_mem_nctg / sme / A64
 *
 */

/* ST1B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a1608000) */
//#define IEM_INSTR_IMPL_A64__st1b_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* STNT1B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a1608008) */
//#define IEM_INSTR_IMPL_A64__stnt1b_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* ST1H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a160a000) */
//#define IEM_INSTR_IMPL_A64__st1h_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* STNT1H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a160a008) */
//#define IEM_INSTR_IMPL_A64__stnt1h_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* ST1W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a160c000) */
//#define IEM_INSTR_IMPL_A64__st1w_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* STNT1W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a160c008) */
//#define IEM_INSTR_IMPL_A64__stnt1w_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* ST1D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a160e000) */
//#define IEM_INSTR_IMPL_A64__st1d_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)


/* STNT1D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <PNg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e00c/a160e008) */
//#define IEM_INSTR_IMPL_A64__stnt1d_mzx_p_bi_4x4(Zt, T, Rn, PNg, imm4)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_cst_cstnt_ss_ctg / mortlach_multi_mem_ctg / sme / A64
 *
 */

/* ST1B  { <Zt1>.B-<Zt4>.B }, <PNg>, [<Xn|SP>, <Xm>] (ffe0e003/a0208000) */
//#define IEM_INSTR_IMPL_A64__st1b_mz_p_br_4(Zt, Rn, PNg, Rm)


/* STNT1B  { <Zt1>.B-<Zt4>.B }, <PNg>, [<Xn|SP>, <Xm>] (ffe0e003/a0208001) */
//#define IEM_INSTR_IMPL_A64__stnt1b_mz_p_br_4(Zt, Rn, PNg, Rm)


/* ST1H  { <Zt1>.H-<Zt4>.H }, <PNg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e003/a020a000) */
//#define IEM_INSTR_IMPL_A64__st1h_mz_p_br_4(Zt, Rn, PNg, Rm)


/* STNT1H  { <Zt1>.H-<Zt4>.H }, <PNg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e003/a020a001) */
//#define IEM_INSTR_IMPL_A64__stnt1h_mz_p_br_4(Zt, Rn, PNg, Rm)


/* ST1W  { <Zt1>.S-<Zt4>.S }, <PNg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e003/a020c000) */
//#define IEM_INSTR_IMPL_A64__st1w_mz_p_br_4(Zt, Rn, PNg, Rm)


/* STNT1W  { <Zt1>.S-<Zt4>.S }, <PNg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e003/a020c001) */
//#define IEM_INSTR_IMPL_A64__stnt1w_mz_p_br_4(Zt, Rn, PNg, Rm)


/* ST1D  { <Zt1>.D-<Zt4>.D }, <PNg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e003/a020e000) */
//#define IEM_INSTR_IMPL_A64__st1d_mz_p_br_4(Zt, Rn, PNg, Rm)


/* STNT1D  { <Zt1>.D-<Zt4>.D }, <PNg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e003/a020e001) */
//#define IEM_INSTR_IMPL_A64__stnt1d_mz_p_br_4(Zt, Rn, PNg, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_cst_cstnt_ss_nctg / mortlach_multi_mem_nctg / sme / A64
 *
 */

/* ST1B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <PNg>, [<Xn|SP>, <Xm>] (ffe0e00c/a1208000) */
//#define IEM_INSTR_IMPL_A64__st1b_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* STNT1B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <PNg>, [<Xn|SP>, <Xm>] (ffe0e00c/a1208008) */
//#define IEM_INSTR_IMPL_A64__stnt1b_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* ST1H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <PNg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e00c/a120a000) */
//#define IEM_INSTR_IMPL_A64__st1h_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* STNT1H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <PNg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e00c/a120a008) */
//#define IEM_INSTR_IMPL_A64__stnt1h_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* ST1W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <PNg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e00c/a120c000) */
//#define IEM_INSTR_IMPL_A64__st1w_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* STNT1W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <PNg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e00c/a120c008) */
//#define IEM_INSTR_IMPL_A64__stnt1w_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* ST1D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <PNg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e00c/a120e000) */
//#define IEM_INSTR_IMPL_A64__st1d_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)


/* STNT1D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <PNg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e00c/a120e008) */
//#define IEM_INSTR_IMPL_A64__stnt1d_mzx_p_br_4x4(Zt, T, Rn, PNg, Rm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_extract_ctg / mortlach_ext / sme / A64
 *
 */

/* MOVA  { <Zd1>.B-<Zd4>.B }, ZA0<HV>.B[<Ws>, <offs1>:<offs4>] (ffff1f83/c0060400) */
//#define IEM_INSTR_IMPL_A64__mova_mz4_za_b1(Zd, off2, Rs, V)


/* MOVA  { <Zd1>.H-<Zd4>.H }, <ZAn><HV>.H[<Ws>, <offs1>:<offs4>] (ffff1f83/c0460400) */
//#define IEM_INSTR_IMPL_A64__mova_mz4_za_h1(Zd, o1, ZAn, Rs, V)


/* MOVA  { <Zd1>.S-<Zd4>.S }, <ZAn><HV>.S[<Ws>, <offs1>:<offs4>] (ffff1f83/c0860400) */
//#define IEM_INSTR_IMPL_A64__mova_mz4_za_w1(Zd, ZAn, Rs, V)


/* MOVA  { <Zd1>.D-<Zd4>.D }, <ZAn><HV>.D[<Ws>, <offs1>:<offs4>] (ffff1f03/c0c60400) */
//#define IEM_INSTR_IMPL_A64__mova_mz4_za_d1(Zd, ZAn, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_extract_zero / mortlach_ext / sme / A64
 *
 */

/* MOVAZ  { <Zd1>.B-<Zd4>.B }, ZA0<HV>.B[<Ws>, <offs1>:<offs4>] (ffff1f83/c0060600) */
//#define IEM_INSTR_IMPL_A64__movaz_mz4_za_b1(Zd, off2, Rs, V)


/* MOVAZ  { <Zd1>.H-<Zd4>.H }, <ZAn><HV>.H[<Ws>, <offs1>:<offs4>] (ffff1f83/c0460600) */
//#define IEM_INSTR_IMPL_A64__movaz_mz4_za_h1(Zd, o1, ZAn, Rs, V)


/* MOVAZ  { <Zd1>.S-<Zd4>.S }, <ZAn><HV>.S[<Ws>, <offs1>:<offs4>] (ffff1f83/c0860600) */
//#define IEM_INSTR_IMPL_A64__movaz_mz4_za_w1(Zd, ZAn, Rs, V)


/* MOVAZ  { <Zd1>.D-<Zd4>.D }, <ZAn><HV>.D[<Ws>, <offs1>:<offs4>] (ffff1f03/c0c60600) */
//#define IEM_INSTR_IMPL_A64__movaz_mz4_za_d1(Zd, ZAn, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_fclamp / mortlach_multi_sve_3 / sme / A64
 *
 */

/* FCLAMP  { <Zd1>.<T>-<Zd4>.<T> }, <Zn>.<T>, <Zm>.<T> (ff20fc03/c120c800) */
//#define IEM_INSTR_IMPL_A64__fclamp_mz_zz_4(Zd, Zn, Zm, size)


/* BFCLAMP  { <Zd1>.H-<Zd4>.H }, <Zn>.H, <Zm>.H (ffe0fc03/c120c800) */
//#define IEM_INSTR_IMPL_A64__bfclamp_mz_zz_4(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_fma_long_idx / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* BFMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1909010) */
//#define IEM_INSTR_IMPL_A64__bfmlal_za_zzi_4xi(off2, i3l, Zn, i3h, Rv, Zm)


/* FMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1909000) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_zzi_4xi(off2, i3l, Zn, i3h, Rv, Zm)


/* BFMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1909018) */
//#define IEM_INSTR_IMPL_A64__bfmlsl_za_zzi_4xi(off2, i3l, Zn, i3h, Rv, Zm)


/* FMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1909008) */
//#define IEM_INSTR_IMPL_A64__fmlsl_za_zzi_4xi(off2, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_fmul_mm / mortlach_multi_sve_5a / sme / A64
 *
 */

/* FMUL  { <Zd1>.<T>-<Zd4>.<T> }, { <Zn1>.<T>-<Zn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23fc63/c121e400) */
//#define IEM_INSTR_IMPL_A64__fmul_mz_zzw_4x4(Zd, Zn, Zm, size)


/* BFMUL  { <Zd1>.H-<Zd4>.H }, { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe3fc63/c121e400) */
//#define IEM_INSTR_IMPL_A64__bfmul_mz_zzw_4x4(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_fmul_sm / mortlach_multi_sve_5b / sme / A64
 *
 */

/* FMUL  { <Zd1>.<T>-<Zd4>.<T> }, { <Zn1>.<T>-<Zn4>.<T> }, <Zm>.<T> (ff21fc63/c121e800) */
//#define IEM_INSTR_IMPL_A64__fmul_mz_zzv_4x1(Zd, Zn, Zm, size)


/* BFMUL  { <Zd1>.H-<Zd4>.H }, { <Zn1>.H-<Zn4>.H }, <Zm>.H (ffe1fc63/c121e800) */
//#define IEM_INSTR_IMPL_A64__bfmul_mz_zzv_4x1(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_fp8_fdot_idx_h / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* FDOT  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09070/c1109040) */
//#define IEM_INSTR_IMPL_A64__fdot_za_z8z8i_4xi(off3, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_fp8_fma_long_idx / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* FMLAL  ZA.H[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09070/c1909020) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_z8z8i_4xi(off2, i4l, Zn, i4h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_fp8_fma_long_long_idx / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* FMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1108040) */
//#define IEM_INSTR_IMPL_A64__fmlall_za32_z8z8i_4xi(o1, i4l, Zn, i4h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_fpint_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* FCVTZS  { <Zd1>.S-<Zd4>.S }, { <Zn1>.S-<Zn4>.S } (fffffc63/c131e000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_mz_z_4(Zd, Zn)


/* FCVTZU  { <Zd1>.S-<Zd4>.S }, { <Zn1>.S-<Zn4>.S } (fffffc63/c131e020) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_mz_z_4(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_frint / mortlach_multi_sve_4 / sme / A64
 *
 */

/* FRINTN  { <Zd1>.S-<Zd4>.S }, { <Zn1>.S-<Zn4>.S } (fffffc63/c1b8e000) */
//#define IEM_INSTR_IMPL_A64__frintn_mz_z_4(Zd, Zn)


/* FRINTP  { <Zd1>.S-<Zd4>.S }, { <Zn1>.S-<Zn4>.S } (fffffc63/c1b9e000) */
//#define IEM_INSTR_IMPL_A64__frintp_mz_z_4(Zd, Zn)


/* FRINTM  { <Zd1>.S-<Zd4>.S }, { <Zn1>.S-<Zn4>.S } (fffffc63/c1bae000) */
//#define IEM_INSTR_IMPL_A64__frintm_mz_z_4(Zd, Zn)


/* FRINTA  { <Zd1>.S-<Zd4>.S }, { <Zn1>.S-<Zn4>.S } (fffffc63/c1bce000) */
//#define IEM_INSTR_IMPL_A64__frinta_mz_z_4(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_insert_ctg / mortlach_ins / sme / A64
 *
 */

/* MOVA  ZA0<HV>.B[<Ws>, <offs1>:<offs4>], { <Zn1>.B-<Zn4>.B } (ffff1c7c/c0040400) */
//#define IEM_INSTR_IMPL_A64__mova_za4_z_b1(off2, Zn, Rs, V)


/* MOVA  <ZAd><HV>.H[<Ws>, <offs1>:<offs4>], { <Zn1>.H-<Zn4>.H } (ffff1c7c/c0440400) */
//#define IEM_INSTR_IMPL_A64__mova_za4_z_h1(o1, ZAd, Zn, Rs, V)


/* MOVA  <ZAd><HV>.S[<Ws>, <offs1>:<offs4>], { <Zn1>.S-<Zn4>.S } (ffff1c7c/c0840400) */
//#define IEM_INSTR_IMPL_A64__mova_za4_z_w1(ZAd, Zn, Rs, V)


/* MOVA  <ZAd><HV>.D[<Ws>, <offs1>:<offs4>], { <Zn1>.D-<Zn4>.D } (ffff1c78/c0c40400) */
//#define IEM_INSTR_IMPL_A64__mova_za4_z_d1(ZAd, Zn, Rs, V)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_intfp_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* SCVTF  { <Zd1>.S-<Zd4>.S }, { <Zn1>.S-<Zn4>.S } (fffffc63/c132e000) */
//#define IEM_INSTR_IMPL_A64__scvtf_mz_z_4(Zd, Zn)


/* UCVTF  { <Zd1>.S-<Zd4>.S }, { <Zn1>.S-<Zn4>.S } (fffffc63/c132e020) */
//#define IEM_INSTR_IMPL_A64__ucvtf_mz_z_4(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_mla_long_idx / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* SMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1d09000) */
//#define IEM_INSTR_IMPL_A64__smlal_za_zzi_4xi(off2, i3l, Zn, i3h, Rv, Zm)


/* SMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1d09008) */
//#define IEM_INSTR_IMPL_A64__smlsl_za_zzi_4xi(off2, i3l, Zn, i3h, Rv, Zm)


/* UMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1d09010) */
//#define IEM_INSTR_IMPL_A64__umlal_za_zzi_4xi(off2, i3l, Zn, i3h, Rv, Zm)


/* UMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1d09018) */
//#define IEM_INSTR_IMPL_A64__umlsl_za_zzi_4xi(off2, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_mla_long_long_idx_d / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* SMLALL  ZA.D[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09878/c1908000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzi_d4xi(o1, i3l, Zn, i3h, Rv, Zm)


/* SMLSLL  ZA.D[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09878/c1908008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzi_d4xi(o1, i3l, Zn, i3h, Rv, Zm)


/* UMLALL  ZA.D[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09878/c1908010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzi_d4xi(o1, i3l, Zn, i3h, Rv, Zm)


/* UMLSLL  ZA.D[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09878/c1908018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzi_d4xi(o1, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_mla_long_long_idx_s / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* SMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1108000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzi_s4xi(o1, i4l, Zn, i4h, Rv, Zm)


/* USMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1108020) */
//#define IEM_INSTR_IMPL_A64__usmlall_za_zzi_s4xi(o1, i4l, Zn, i4h, Rv, Zm)


/* SMLSLL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1108008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzi_s4xi(o1, i4l, Zn, i4h, Rv, Zm)


/* UMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1108010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzi_s4xi(o1, i4l, Zn, i4h, Rv, Zm)


/* SUMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1108030) */
//#define IEM_INSTR_IMPL_A64__sumlall_za_zzi_s4xi(o1, i4l, Zn, i4h, Rv, Zm)


/* UMLSLL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1108018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzi_s4xi(o1, i4l, Zn, i4h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_narrow_fp8_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* FCVT  <Zd>.B, { <Zn1>.S-<Zn4>.S } (fffffc60/c134e000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z8_mz4(Zd, Zn)


/* FCVTN  <Zd>.B, { <Zn1>.S-<Zn4>.S } (fffffc60/c134e020) */
//#define IEM_INSTR_IMPL_A64__fcvtn_z8_mz4(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_narrow_int_cvrt / mortlach_multi_sve_4 / sme / A64
 *
 */

/* SQCVT  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> } (ff7ffc60/c133e000) */
//#define IEM_INSTR_IMPL_A64__sqcvt_z_mz4(Zd, Zn, sz)


/* SQCVTU  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> } (ff7ffc60/c173e000) */
//#define IEM_INSTR_IMPL_A64__sqcvtu_z_mz4(Zd, Zn, sz)


/* SQCVTN  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> } (ff7ffc60/c133e040) */
//#define IEM_INSTR_IMPL_A64__sqcvtn_z_mz4(Zd, Zn, sz)


/* SQCVTUN  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> } (ff7ffc60/c173e040) */
//#define IEM_INSTR_IMPL_A64__sqcvtun_z_mz4(Zd, Zn, sz)


/* UQCVT  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> } (ff7ffc60/c133e020) */
//#define IEM_INSTR_IMPL_A64__uqcvt_z_mz4(Zd, Zn, sz)


/* UQCVTN  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> } (ff7ffc60/c133e060) */
//#define IEM_INSTR_IMPL_A64__uqcvtn_z_mz4(Zd, Zn, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_qrshr / mortlach_multi_sve_3 / sme / A64
 *
 */

/* SQRSHR  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> }, #<const> (ff20fc60/c120d800) */
//#define IEM_INSTR_IMPL_A64__sqrshr_z_mz4(Zd, Zn, imm5, tsize)


/* SQRSHRU  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> }, #<const> (ff20fc60/c120d840) */
//#define IEM_INSTR_IMPL_A64__sqrshru_z_mz4(Zd, Zn, imm5, tsize)


/* SQRSHRN  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> }, #<const> (ff20fc60/c120dc00) */
//#define IEM_INSTR_IMPL_A64__sqrshrn_z_mz4(Zd, Zn, imm5, tsize)


/* SQRSHRUN  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> }, #<const> (ff20fc60/c120dc40) */
//#define IEM_INSTR_IMPL_A64__sqrshrun_z_mz4(Zd, Zn, imm5, tsize)


/* UQRSHR  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> }, #<const> (ff20fc60/c120d820) */
//#define IEM_INSTR_IMPL_A64__uqrshr_z_mz4(Zd, Zn, imm5, tsize)


/* UQRSHRN  <Zd>.<T>, { <Zn1>.<Tb>-<Zn4>.<Tb> }, #<const> (ff20fc60/c120dc20) */
//#define IEM_INSTR_IMPL_A64__uqrshrn_z_mz4(Zd, Zn, imm5, tsize)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_select_int / mortlach_multi_sve_1 / sme / A64
 *
 */

/* SEL  { <Zd1>.<T>-<Zd4>.<T> }, <PNg>, { <Zn1>.<T>-<Zn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23e063/c1218000) */
//#define IEM_INSTR_IMPL_A64__sel_mz_p_zz_4(Zd, Zn, PNg, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_wide_int / mortlach_multi_sve_4 / sme / A64
 *
 */

/* SUNPK  { <Zd1>.<T>-<Zd4>.<T> }, { <Zn1>.<Tb>-<Zn2>.<Tb> } (ff3ffc23/c135e000) */
//#define IEM_INSTR_IMPL_A64__sunpk_mz_z_4(Zd, Zn, size)


/* UUNPK  { <Zd1>.<T>-<Zd4>.<T> }, { <Zn1>.<Tb>-<Zn2>.<Tb> } (ff3ffc23/c135e001) */
//#define IEM_INSTR_IMPL_A64__uunpk_mz_z_4(Zd, Zn, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_add_sm / mortlach_multi_sve_2b / sme / A64
 *
 */

/* ADD  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120ab00) */
//#define IEM_INSTR_IMPL_A64__add_mz_zzv_4x1(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_fminmax_mm / mortlach_multi_sve_2d0 / sme / A64
 *
 */

/* FMAX  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b900) */
//#define IEM_INSTR_IMPL_A64__fmax_mz_zzw_4x4(Zdn, Zm, size)


/* BFMAX  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe3ffe3/c120b900) */
//#define IEM_INSTR_IMPL_A64__bfmax_mz_zzw_4x4(Zdn, Zm)


/* FMIN  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b901) */
//#define IEM_INSTR_IMPL_A64__fmin_mz_zzw_4x4(Zdn, Zm, size)


/* BFMIN  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe3ffe3/c120b901) */
//#define IEM_INSTR_IMPL_A64__bfmin_mz_zzw_4x4(Zdn, Zm)


/* FMAXNM  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b920) */
//#define IEM_INSTR_IMPL_A64__fmaxnm_mz_zzw_4x4(Zdn, Zm, size)


/* BFMAXNM  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe3ffe3/c120b920) */
//#define IEM_INSTR_IMPL_A64__bfmaxnm_mz_zzw_4x4(Zdn, Zm)


/* FMINNM  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b921) */
//#define IEM_INSTR_IMPL_A64__fminnm_mz_zzw_4x4(Zdn, Zm, size)


/* BFMINNM  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe3ffe3/c120b921) */
//#define IEM_INSTR_IMPL_A64__bfminnm_mz_zzw_4x4(Zdn, Zm)


/* FAMAX  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b940) */
//#define IEM_INSTR_IMPL_A64__famax_mz_zzw_4x4(Zdn, Zm, size)


/* FAMIN  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b941) */
//#define IEM_INSTR_IMPL_A64__famin_mz_zzw_4x4(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_fminmax_sm / mortlach_multi_sve_2b / sme / A64
 *
 */

/* FMAX  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a900) */
//#define IEM_INSTR_IMPL_A64__fmax_mz_zzv_4x1(Zdn, Zm, size)


/* BFMAX  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, <Zm>.H (fff0ffe3/c120a900) */
//#define IEM_INSTR_IMPL_A64__bfmax_mz_zzv_4x1(Zdn, Zm)


/* FMIN  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a901) */
//#define IEM_INSTR_IMPL_A64__fmin_mz_zzv_4x1(Zdn, Zm, size)


/* BFMIN  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, <Zm>.H (fff0ffe3/c120a901) */
//#define IEM_INSTR_IMPL_A64__bfmin_mz_zzv_4x1(Zdn, Zm)


/* FMAXNM  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a920) */
//#define IEM_INSTR_IMPL_A64__fmaxnm_mz_zzv_4x1(Zdn, Zm, size)


/* BFMAXNM  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, <Zm>.H (fff0ffe3/c120a920) */
//#define IEM_INSTR_IMPL_A64__bfmaxnm_mz_zzv_4x1(Zdn, Zm)


/* FMINNM  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a921) */
//#define IEM_INSTR_IMPL_A64__fminnm_mz_zzv_4x1(Zdn, Zm, size)


/* BFMINNM  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, <Zm>.H (fff0ffe3/c120a921) */
//#define IEM_INSTR_IMPL_A64__bfminnm_mz_zzv_4x1(Zdn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_fscale_mm / mortlach_multi_sve_2d0 / sme / A64
 *
 */

/* FSCALE  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b980) */
//#define IEM_INSTR_IMPL_A64__fscale_mz_zzw_4x4(Zdn, Zm, size)


/* BFSCALE  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe3ffe3/c120b980) */
//#define IEM_INSTR_IMPL_A64__bfscale_mz_zzw_4x4(Zdn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_fscale_sm / mortlach_multi_sve_2b / sme / A64
 *
 */

/* FSCALE  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a980) */
//#define IEM_INSTR_IMPL_A64__fscale_mz_zzv_4x1(Zdn, Zm, size)


/* BFSCALE  { <Zdn1>.H-<Zdn4>.H }, { <Zdn1>.H-<Zdn4>.H }, <Zm>.H (fff0ffe3/c120a980) */
//#define IEM_INSTR_IMPL_A64__bfscale_mz_zzv_4x1(Zdn, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_long_zip / mortlach_multi_sve_4 / sme / A64
 *
 */

/* ZIP  { <Zd1>.Q-<Zd4>.Q }, { <Zn1>.Q-<Zn4>.Q } (fffffc63/c137e000) */
//#define IEM_INSTR_IMPL_A64__zip_mz_z_4q(Zd, Zn)


/* UZP  { <Zd1>.Q-<Zd4>.Q }, { <Zn1>.Q-<Zn4>.Q } (fffffc63/c137e002) */
//#define IEM_INSTR_IMPL_A64__uzp_mz_z_4q(Zd, Zn)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_minmax_mm / mortlach_multi_sve_2d0 / sme / A64
 *
 */

/* SMAX  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b800) */
//#define IEM_INSTR_IMPL_A64__smax_mz_zzw_4x4(Zdn, Zm, size)


/* SMIN  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b820) */
//#define IEM_INSTR_IMPL_A64__smin_mz_zzw_4x4(Zdn, Zm, size)


/* UMAX  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b801) */
//#define IEM_INSTR_IMPL_A64__umax_mz_zzw_4x4(Zdn, Zm, size)


/* UMIN  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120b821) */
//#define IEM_INSTR_IMPL_A64__umin_mz_zzw_4x4(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_minmax_sm / mortlach_multi_sve_2b / sme / A64
 *
 */

/* SMAX  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a800) */
//#define IEM_INSTR_IMPL_A64__smax_mz_zzv_4x1(Zdn, Zm, size)


/* SMIN  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a820) */
//#define IEM_INSTR_IMPL_A64__smin_mz_zzv_4x1(Zdn, Zm, size)


/* UMAX  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a801) */
//#define IEM_INSTR_IMPL_A64__umax_mz_zzv_4x1(Zdn, Zm, size)


/* UMIN  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120a821) */
//#define IEM_INSTR_IMPL_A64__umin_mz_zzv_4x1(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_shift_mm / mortlach_multi_sve_2d0 / sme / A64
 *
 */

/* SRSHL  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120ba20) */
//#define IEM_INSTR_IMPL_A64__srshl_mz_zzw_4x4(Zdn, Zm, size)


/* URSHL  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120ba21) */
//#define IEM_INSTR_IMPL_A64__urshl_mz_zzw_4x4(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_shift_sm / mortlach_multi_sve_2b / sme / A64
 *
 */

/* SRSHL  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120aa20) */
//#define IEM_INSTR_IMPL_A64__srshl_mz_zzv_4x1(Zdn, Zm, size)


/* URSHL  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120aa21) */
//#define IEM_INSTR_IMPL_A64__urshl_mz_zzv_4x1(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_sqdmulh_mm / mortlach_multi_sve_2d1 / sme / A64
 *
 */

/* SQDMULH  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ff23ffe3/c120bc00) */
//#define IEM_INSTR_IMPL_A64__sqdmulh_mz_zzw_4x4(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_sqdmulh_sm / mortlach_multi_sve_2b / sme / A64
 *
 */

/* SQDMULH  { <Zdn1>.<T>-<Zdn4>.<T> }, { <Zdn1>.<T>-<Zdn4>.<T> }, <Zm>.<T> (ff30ffe3/c120ac00) */
//#define IEM_INSTR_IMPL_A64__sqdmulh_mz_zzv_4x1(Zdn, Zm, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_z_zip / mortlach_multi_sve_4 / sme / A64
 *
 */

/* ZIP  { <Zd1>.<T>-<Zd4>.<T> }, { <Zn1>.<T>-<Zn4>.<T> } (ff3ffc63/c136e000) */
//#define IEM_INSTR_IMPL_A64__zip_mz_z_4(Zd, Zn, size)


/* UZP  { <Zd1>.<T>-<Zd4>.<T> }, { <Zn1>.<T>-<Zn4>.<T> } (ff3ffc63/c136e002) */
//#define IEM_INSTR_IMPL_A64__uzp_mz_z_4(Zd, Zn, size)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_2way_dot_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* SDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c78/c1e11408) */
//#define IEM_INSTR_IMPL_A64__sdot_za32_zzw_4x4(off3, Zn, Rv, Zm)


/* UDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c78/c1e11418) */
//#define IEM_INSTR_IMPL_A64__udot_za32_zzw_4x4(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_2way_dot_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* SDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c18/c1701408) */
//#define IEM_INSTR_IMPL_A64__sdot_za32_zzv_4x1(off3, Zn, Rv, Zm)


/* UDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c18/c1701418) */
//#define IEM_INSTR_IMPL_A64__udot_za32_zzv_4x1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_4way_dot_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* SDOT  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, { <Zm1>.<Tb>-<Zm4>.<Tb> } (ffa39c78/c1a11400) */
//#define IEM_INSTR_IMPL_A64__sdot_za_zzw_4x4(off3, Zn, Rv, Zm, sz)


/* UDOT  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, { <Zm1>.<Tb>-<Zm4>.<Tb> } (ffa39c78/c1a11410) */
//#define IEM_INSTR_IMPL_A64__udot_za_zzw_4x4(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_4way_dot_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* SDOT  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, <Zm>.<Tb> (ffb09c18/c1301400) */
//#define IEM_INSTR_IMPL_A64__sdot_za_zzv_4x1(off3, Zn, Rv, Zm, sz)


/* UDOT  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, <Zm>.<Tb> (ffb09c18/c1301410) */
//#define IEM_INSTR_IMPL_A64__udot_za_zzv_4x1(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_f16_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* FADD  ZA.H[<Wv>, <offs>{, VGx4}], { <Zm1>.H-<Zm4>.H } (ffff9c78/c1a51c00) */
//#define IEM_INSTR_IMPL_A64__fadd_za_zw_4x4_16(off3, Zm, Rv)


/* BFADD  ZA.H[<Wv>, <offs>{, VGx4}], { <Zm1>.H-<Zm4>.H } (ffff9c78/c1e51c00) */
//#define IEM_INSTR_IMPL_A64__bfadd_za_zw_4x4_16(off3, Zm, Rv)


/* FSUB  ZA.H[<Wv>, <offs>{, VGx4}], { <Zm1>.H-<Zm4>.H } (ffff9c78/c1a51c08) */
//#define IEM_INSTR_IMPL_A64__fsub_za_zw_4x4_16(off3, Zm, Rv)


/* BFSUB  ZA.H[<Wv>, <offs>{, VGx4}], { <Zm1>.H-<Zm4>.H } (ffff9c78/c1e51c08) */
//#define IEM_INSTR_IMPL_A64__bfsub_za_zw_4x4_16(off3, Zm, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_float_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* FADD  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zm1>.<T>-<Zm4>.<T> } (ffbf9c78/c1a11c00) */
//#define IEM_INSTR_IMPL_A64__fadd_za_zw_4x4(off3, Zm, Rv, sz)


/* FSUB  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zm1>.<T>-<Zm4>.<T> } (ffbf9c78/c1a11c08) */
//#define IEM_INSTR_IMPL_A64__fsub_za_zw_4x4(off3, Zm, Rv, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_fpdot_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* FDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c78/c1a11000) */
//#define IEM_INSTR_IMPL_A64__fdot_za_zzw_4x4(off3, Zn, Rv, Zm)


/* BFDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c78/c1a11010) */
//#define IEM_INSTR_IMPL_A64__bfdot_za_zzw_4x4(off3, Zn, Rv, Zm)


/* FDOT  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, { <Zm1>.B-<Zm4>.B } (ffe39c78/c1a11020) */
//#define IEM_INSTR_IMPL_A64__fdot_za_z8z8w_4x4(off3, Zn, Rv, Zm)


/* FDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, { <Zm1>.B-<Zm4>.B } (ffe39c78/c1a11030) */
//#define IEM_INSTR_IMPL_A64__fdot_za32_z8z8w_4x4(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_fpdot_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* FDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c18/c1301000) */
//#define IEM_INSTR_IMPL_A64__fdot_za_zzv_4x1(off3, Zn, Rv, Zm)


/* BFDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c18/c1301010) */
//#define IEM_INSTR_IMPL_A64__bfdot_za_zzv_4x1(off3, Zn, Rv, Zm)


/* FDOT  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B (fff09c18/c1301008) */
//#define IEM_INSTR_IMPL_A64__fdot_za_z8z8v_4x1(off3, Zn, Rv, Zm)


/* FDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B (fff09c18/c1301018) */
//#define IEM_INSTR_IMPL_A64__fdot_za32_z8z8v_4x1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_int_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* ADD  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zm1>.<T>-<Zm4>.<T> } (ffbf9c78/c1a11c10) */
//#define IEM_INSTR_IMPL_A64__add_za_zw_4x4(off3, Zm, Rv, sz)


/* SUB  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zm1>.<T>-<Zm4>.<T> } (ffbf9c78/c1a11c18) */
//#define IEM_INSTR_IMPL_A64__sub_za_zw_4x4(off3, Zm, Rv, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_mixed_dot_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* USDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, { <Zm1>.B-<Zm4>.B } (ffe39c78/c1a11408) */
//#define IEM_INSTR_IMPL_A64__usdot_za_zzw_s4x4(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_z_za_mixed_dot_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* USDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B (fff09c18/c1301408) */
//#define IEM_INSTR_IMPL_A64__usdot_za_zzv_s4x1(off3, Zn, Rv, Zm)


/* SUDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B (fff09c18/c1301418) */
//#define IEM_INSTR_IMPL_A64__sudot_za_zzv_s4x1(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_za_extract_ctg / mortlach_ext / sme / A64
 *
 */

/* MOVA  { <Zd1>.D-<Zd4>.D }, ZA.D[<Wv>, <offs>{, VGx4}] (ffff9f03/c0060c00) */
//#define IEM_INSTR_IMPL_A64__mova_mz_za4_1(Zd, off3, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_za_extract_zero / mortlach_ext / sme / A64
 *
 */

/* MOVAZ  { <Zd1>.D-<Zd4>.D }, ZA.D[<Wv>, <offs>{, VGx4}] (ffff9f03/c0060e00) */
//#define IEM_INSTR_IMPL_A64__movaz_mz_za4_1(Zd, off3, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_za_insert_ctg / mortlach_ins / sme / A64
 *
 */

/* MOVA  ZA.D[<Wv>, <offs>{, VGx4}], { <Zn1>.D-<Zn4>.D } (ffff9c78/c0040c00) */
//#define IEM_INSTR_IMPL_A64__mova_za_mz4_1(off3, Zn, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_f16_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* FMLA  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c78/c1a11008) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzw_4x4_16(off3, Zn, Rv, Zm)


/* BFMLA  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c78/c1e11008) */
//#define IEM_INSTR_IMPL_A64__bfmla_za_zzw_4x4_16(off3, Zn, Rv, Zm)


/* FMLS  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c78/c1a11018) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzw_4x4_16(off3, Zn, Rv, Zm)


/* BFMLS  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c78/c1e11018) */
//#define IEM_INSTR_IMPL_A64__bfmls_za_zzw_4x4_16(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_f16_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* FMLA  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c18/c1301c00) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzv_4x1_16(off3, Zn, Rv, Zm)


/* BFMLA  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c18/c1701c00) */
//#define IEM_INSTR_IMPL_A64__bfmla_za_zzv_4x1_16(off3, Zn, Rv, Zm)


/* FMLS  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c18/c1301c08) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzv_4x1_16(off3, Zn, Rv, Zm)


/* BFMLS  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c18/c1701c08) */
//#define IEM_INSTR_IMPL_A64__bfmls_za_zzv_4x1_16(off3, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_float_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* FMLA  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<T>-<Zn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ffa39c78/c1a11800) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzw_4x4(off3, Zn, Rv, Zm, sz)


/* FMLS  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<T>-<Zn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ffa39c78/c1a11808) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzw_4x4(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_float_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* FMLA  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<T>-<Zn4>.<T> }, <Zm>.<T> (ffb09c18/c1301800) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzv_4x1(off3, Zn, Rv, Zm, sz)


/* FMLS  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<T>-<Zn4>.<T> }, <Zm>.<T> (ffb09c18/c1301808) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzv_4x1(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_fma_long_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* BFMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c7c/c1a10810) */
//#define IEM_INSTR_IMPL_A64__bfmlal_za_zzw_4x4(off2, Zn, Rv, Zm)


/* FMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c7c/c1a10800) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_zzw_4x4(off2, Zn, Rv, Zm)


/* BFMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c7c/c1a10818) */
//#define IEM_INSTR_IMPL_A64__bfmlsl_za_zzw_4x4(off2, Zn, Rv, Zm)


/* FMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c7c/c1a10808) */
//#define IEM_INSTR_IMPL_A64__fmlsl_za_zzw_4x4(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_fma_long_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* BFMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c1c/c1300810) */
//#define IEM_INSTR_IMPL_A64__bfmlal_za_zzv_4x1(off2, Zn, Rv, Zm)


/* FMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c1c/c1300800) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_zzv_4x1(off2, Zn, Rv, Zm)


/* FMLAL  ZA.H[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B (fff09c1c/c1300804) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_z8z8v_4x1(off2, Zn, Rv, Zm)


/* BFMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c1c/c1300818) */
//#define IEM_INSTR_IMPL_A64__bfmlsl_za_zzv_4x1(off2, Zn, Rv, Zm)


/* FMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c1c/c1300808) */
//#define IEM_INSTR_IMPL_A64__fmlsl_za_zzv_4x1(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_fp8_fma_long_long_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* FMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, { <Zm1>.B-<Zm4>.B } (ffe39c7e/c1a10020) */
//#define IEM_INSTR_IMPL_A64__fmlall_za32_z8z8w_4x4(o1, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_fp8_fma_long_long_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* FMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B (fff09c1e/c1300002) */
//#define IEM_INSTR_IMPL_A64__fmlall_za32_z8z8v_4x1(o1, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_fp8_fma_long_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* FMLAL  ZA.H[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.B-<Zn4>.B }, { <Zm1>.B-<Zm4>.B } (ffe39c7c/c1a10820) */
//#define IEM_INSTR_IMPL_A64__fmlal_za_z8z8w_4x4(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_int_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* ADD  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<T>-<Zn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ffa39c78/c1a11810) */
//#define IEM_INSTR_IMPL_A64__add_za_zzw_4x4(off3, Zn, Rv, Zm, sz)


/* SUB  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<T>-<Zn4>.<T> }, { <Zm1>.<T>-<Zm4>.<T> } (ffa39c78/c1a11818) */
//#define IEM_INSTR_IMPL_A64__sub_za_zzw_4x4(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_int_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* ADD  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<T>-<Zn4>.<T> }, <Zm>.<T> (ffb09c18/c1301810) */
//#define IEM_INSTR_IMPL_A64__add_za_zzv_4x1(off3, Zn, Rv, Zm, sz)


/* SUB  ZA.<T>[<Wv>, <offs>{, VGx4}], { <Zn1>.<T>-<Zn4>.<T> }, <Zm>.<T> (ffb09c18/c1301818) */
//#define IEM_INSTR_IMPL_A64__sub_za_zzv_4x1(off3, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_mla_long_long_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* SMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, { <Zm1>.<Tb>-<Zm4>.<Tb> } (ffa39c7e/c1a10000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzw_4x4(o1, Zn, Rv, Zm, sz)


/* USMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, { <Zm1>.B-<Zm4>.B } (ffe39c7e/c1a10004) */
//#define IEM_INSTR_IMPL_A64__usmlall_za_zzw_s4x4(o1, Zn, Rv, Zm)


/* SMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, { <Zm1>.<Tb>-<Zm4>.<Tb> } (ffa39c7e/c1a10008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzw_4x4(o1, Zn, Rv, Zm, sz)


/* UMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, { <Zm1>.<Tb>-<Zm4>.<Tb> } (ffa39c7e/c1a10010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzw_4x4(o1, Zn, Rv, Zm, sz)


/* UMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, { <Zm1>.<Tb>-<Zm4>.<Tb> } (ffa39c7e/c1a10018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzw_4x4(o1, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_mla_long_long_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* SMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, <Zm>.<Tb> (ffb09c1e/c1300000) */
//#define IEM_INSTR_IMPL_A64__smlall_za_zzv_4x1(o1, Zn, Rv, Zm, sz)


/* USMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B (fff09c1e/c1300004) */
//#define IEM_INSTR_IMPL_A64__usmlall_za_zzv_s4x1(o1, Zn, Rv, Zm)


/* SMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, <Zm>.<Tb> (ffb09c1e/c1300008) */
//#define IEM_INSTR_IMPL_A64__smlsll_za_zzv_4x1(o1, Zn, Rv, Zm, sz)


/* UMLALL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, <Zm>.<Tb> (ffb09c1e/c1300010) */
//#define IEM_INSTR_IMPL_A64__umlall_za_zzv_4x1(o1, Zn, Rv, Zm, sz)


/* SUMLALL  ZA.S[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B (fff09c1e/c1300014) */
//#define IEM_INSTR_IMPL_A64__sumlall_za_zzv_s4x1(o1, Zn, Rv, Zm)


/* UMLSLL  ZA.<T>[<Wv>, <offs1>:<offs4>{, VGx4}], { <Zn1>.<Tb>-<Zn4>.<Tb> }, <Zm>.<Tb> (ffb09c1e/c1300018) */
//#define IEM_INSTR_IMPL_A64__umlsll_za_zzv_4x1(o1, Zn, Rv, Zm, sz)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_mla_long_mm / mortlach_multi_array_2b / sme / A64
 *
 */

/* SMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c7c/c1e10800) */
//#define IEM_INSTR_IMPL_A64__smlal_za_zzw_4x4(off2, Zn, Rv, Zm)


/* SMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c7c/c1e10808) */
//#define IEM_INSTR_IMPL_A64__smlsl_za_zzw_4x4(off2, Zn, Rv, Zm)


/* UMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c7c/c1e10810) */
//#define IEM_INSTR_IMPL_A64__umlal_za_zzw_4x4(off2, Zn, Rv, Zm)


/* UMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, { <Zm1>.H-<Zm4>.H } (ffe39c7c/c1e10818) */
//#define IEM_INSTR_IMPL_A64__umlsl_za_zzw_4x4(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zz_za_mla_long_sm / mortlach_multi_array_1b / sme / A64
 *
 */

/* SMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c1c/c1700800) */
//#define IEM_INSTR_IMPL_A64__smlal_za_zzv_4x1(off2, Zn, Rv, Zm)


/* SMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c1c/c1700808) */
//#define IEM_INSTR_IMPL_A64__smlsl_za_zzv_4x1(off2, Zn, Rv, Zm)


/* UMLAL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c1c/c1700810) */
//#define IEM_INSTR_IMPL_A64__umlal_za_zzv_4x1(off2, Zn, Rv, Zm)


/* UMLSL  ZA.S[<Wv>, <offs1>:<offs2>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H (fff09c1c/c1700818) */
//#define IEM_INSTR_IMPL_A64__umlsl_za_zzv_4x1(off2, Zn, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zza_idx_d / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* FMLA  ZA.D[<Wv>, <offs>{, VGx4}], { <Zn1>.D-<Zn4>.D }, <Zm>.D[<index>] (fff09878/c1d08000) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzi_d4xi(off3, Zn, i1, Rv, Zm)


/* SDOT  ZA.D[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09878/c1d08008) */
//#define IEM_INSTR_IMPL_A64__sdot_za_zzi_d4xi(off3, Zn, i1, Rv, Zm)


/* SVDOT  ZA.D[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09878/c1d08808) */
//#define IEM_INSTR_IMPL_A64__svdot_za_zzi_d4xi(off3, Zn, i1, Rv, Zm)


/* FMLS  ZA.D[<Wv>, <offs>{, VGx4}], { <Zn1>.D-<Zn4>.D }, <Zm>.D[<index>] (fff09878/c1d08010) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzi_d4xi(off3, Zn, i1, Rv, Zm)


/* UDOT  ZA.D[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09878/c1d08018) */
//#define IEM_INSTR_IMPL_A64__udot_za_zzi_d4xi(off3, Zn, i1, Rv, Zm)


/* UVDOT  ZA.D[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09878/c1d08818) */
//#define IEM_INSTR_IMPL_A64__uvdot_za_zzi_d4xi(off3, Zn, i1, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zza_idx_h / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* FMLA  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09070/c1109000) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzi_h4xi(off3, i3l, Zn, i3h, Rv, Zm)


/* BFMLA  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09070/c1109020) */
//#define IEM_INSTR_IMPL_A64__bfmla_za_zzi_h4xi(off3, i3l, Zn, i3h, Rv, Zm)


/* FMLS  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09070/c1109010) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzi_h4xi(off3, i3l, Zn, i3h, Rv, Zm)


/* BFMLS  ZA.H[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09070/c1109030) */
//#define IEM_INSTR_IMPL_A64__bfmls_za_zzi_h4xi(off3, i3l, Zn, i3h, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi4_zza_idx_s / mortlach_multi_indexed_3 / sme / A64
 *
 */

/* FMLA  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.S-<Zn4>.S }, <Zm>.S[<index>] (fff09078/c1508000) */
//#define IEM_INSTR_IMPL_A64__fmla_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* FDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1508008) */
//#define IEM_INSTR_IMPL_A64__fdot_za32_z8z8i_4xi(off3, Zn, i2, Rv, Zm)


/* SVDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1508020) */
//#define IEM_INSTR_IMPL_A64__svdot_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* USVDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1508028) */
//#define IEM_INSTR_IMPL_A64__usvdot_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* SDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1509000) */
//#define IEM_INSTR_IMPL_A64__sdot_za32_zzi_4xi(off3, Zn, i2, Rv, Zm)


/* FDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1509008) */
//#define IEM_INSTR_IMPL_A64__fdot_za_zzi_4xi(off3, Zn, i2, Rv, Zm)


/* BFDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1509018) */
//#define IEM_INSTR_IMPL_A64__bfdot_za_zzi_4xi(off3, Zn, i2, Rv, Zm)


/* SDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1509020) */
//#define IEM_INSTR_IMPL_A64__sdot_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* USDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1509028) */
//#define IEM_INSTR_IMPL_A64__usdot_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* FMLS  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.S-<Zn4>.S }, <Zm>.S[<index>] (fff09078/c1508010) */
//#define IEM_INSTR_IMPL_A64__fmls_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* UVDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1508030) */
//#define IEM_INSTR_IMPL_A64__uvdot_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* SUVDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1508038) */
//#define IEM_INSTR_IMPL_A64__suvdot_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* UDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.H-<Zn4>.H }, <Zm>.H[<index>] (fff09078/c1509010) */
//#define IEM_INSTR_IMPL_A64__udot_za32_zzi_4xi(off3, Zn, i2, Rv, Zm)


/* UDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1509030) */
//#define IEM_INSTR_IMPL_A64__udot_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)


/* SUDOT  ZA.S[<Wv>, <offs>{, VGx4}], { <Zn1>.B-<Zn4>.B }, <Zm>.B[<index>] (fff09078/c1509038) */
//#define IEM_INSTR_IMPL_A64__sudot_za_zzi_s4xi(off3, Zn, i2, Rv, Zm)



/*
 *
 * Instruction Set & Groups: mortlach_multi_zero / mortlach_multizero / sme / A64
 *
 */

/* ZERO  ZA.D[<Wv>, <offs>, VGx2] (ffff9ff8/c00c0000) */
//#define IEM_INSTR_IMPL_A64__zero_za1_ri_2(off3, Rv)


/* ZERO  ZA.D[<Wv>, <offs>, VGx4] (ffff9ff8/c00e0000) */
//#define IEM_INSTR_IMPL_A64__zero_za1_ri_4(off3, Rv)


/* ZERO  ZA.D[<Wv>, <offs1>:<offs2>] (ffff9ff8/c00c8000) */
//#define IEM_INSTR_IMPL_A64__zero_za2_ri_1(off3, Rv)


/* ZERO  ZA.D[<Wv>, <offs1>:<offs2>, VGx2] (ffff9ffc/c00d0000) */
//#define IEM_INSTR_IMPL_A64__zero_za2_ri_2(off2, Rv)


/* ZERO  ZA.D[<Wv>, <offs1>:<offs2>, VGx4] (ffff9ffc/c00d8000) */
//#define IEM_INSTR_IMPL_A64__zero_za2_ri_4(off2, Rv)


/* ZERO  ZA.D[<Wv>, <offs1>:<offs4>] (ffff9ffc/c00e8000) */
//#define IEM_INSTR_IMPL_A64__zero_za4_ri_1(off2, Rv)


/* ZERO  ZA.D[<Wv>, <offs1>:<offs4>, VGx2] (ffff9ffe/c00f0000) */
//#define IEM_INSTR_IMPL_A64__zero_za4_ri_2(o1, Rv)


/* ZERO  ZA.D[<Wv>, <offs1>:<offs4>, VGx4] (ffff9ffe/c00f8000) */
//#define IEM_INSTR_IMPL_A64__zero_za4_ri_4(o1, Rv)



/*
 *
 * Instruction Set & Groups: mortlach_zero_lvl2 / mortlach_zero / sme / A64
 *
 */

/* ZERO  { <mask> } (ffffff00/c0080000) */
//#define IEM_INSTR_IMPL_A64__zero_za_i(imm8)



/*
 *
 * Instruction Set & Groups: mortlach_zero_zt_lvl2 / mortlach_zero_zt / sme / A64
 *
 */

/* ZERO  { ZT0 } (ffffffff/c0480001) */
//#define IEM_INSTR_IMPL_A64__zero_zt_i()



/*
 *
 * Instruction Set & Groups: mortlach_zt_ldst / mortlach_mem / sme / A64
 *
 */

/* LDR  ZT0, [<Xn|SP>] (fffffc1f/e11f8000) */
//#define IEM_INSTR_IMPL_A64__ldr_zt_br(Rn)


/* STR  ZT0, [<Xn|SP>] (fffffc1f/e13f8000) */
//#define IEM_INSTR_IMPL_A64__str_zt_br(Rn)



/*
 *
 * Instruction Set & Groups: movewide / dpimm / A64
 *
 */

/* MOVN  <Wd>, #<imm>{, LSL #<shift>} (ffc00000/12800000) */
#define IEM_INSTR_IMPL_A64__MOVN_32_movewide(Rd, imm16, hw) \
    if (hw & 2) return iemDecodeA64_Invalid(pVCpu, uOpcode); /** @todo missing 32-bit MOVZ precond... */ \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_STORE_GREG_U32_CONST(Rd, hw & 1 ? ~(uint32_t)imm16 << 16 : ~(uint32_t)imm16); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* MOVZ  <Wd>, #<imm>{, LSL #<shift>} (ffc00000/52800000) */
#define IEM_INSTR_IMPL_A64__MOVZ_32_movewide(Rd, imm16, hw) \
    if (hw & 2) return iemDecodeA64_Invalid(pVCpu, uOpcode); /** @todo missing 32-bit MOVZ precond... */ \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_STORE_GREG_U32_CONST(Rd, hw & 1 ? (uint32_t)imm16 << 16 : (uint32_t)imm16); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* MOVK  <Wd>, #<imm>{, LSL #<shift>} (ffc00000/72800000) */
#define IEM_INSTR_IMPL_A64__MOVK_32_movewide(Rd, imm16, hw) \
    if (hw & 2) return iemDecodeA64_Invalid(pVCpu, uOpcode); /** @todo missing 32-bit MOVZ precond... */ \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint32_t, uTmp); \
    IEM_MC_FETCH_GREG_U32(uTmp, Rd); \
    IEM_MC_AND_LOCAL_U32(uTmp, hw & 1 ? UINT32_C(0x0000ffff)  : UINT32_C(0xffff0000)); \
    IEM_MC_OR_LOCAL_U32(uTmp,  hw & 1 ? (uint32_t)imm16 << 16 : (uint32_t)imm16); \
    IEM_MC_STORE_GREG_U32(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* MOVN  <Xd>, #<imm>{, LSL #<shift>} (ff800000/92800000) */
#define IEM_INSTR_IMPL_A64__MOVN_64_movewide(Rd, imm16, hw) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_STORE_GREG_U64_CONST(Rd, ~(uint64_t)imm16 << (hw * 16)); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* MOVZ  <Xd>, #<imm>{, LSL #<shift>} (ff800000/d2800000) */
#define IEM_INSTR_IMPL_A64__MOVZ_64_movewide(Rd, imm16, hw) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_STORE_GREG_U64_CONST(Rd, (uint64_t)imm16 << (hw * 16)); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()


/* MOVK  <Xd>, #<imm>{, LSL #<shift>} (ff800000/f2800000) */
#define IEM_INSTR_IMPL_A64__MOVK_64_movewide(Rd, imm16, hw) \
    IEM_MC_BEGIN(0, 0); \
    IEM_MC_LOCAL(uint64_t, uTmp); \
    IEM_MC_FETCH_GREG_U64(uTmp, Rd); \
    IEM_MC_AND_LOCAL_U64(uTmp, ~(UINT64_C(0xffff) << (hw * 16))); \
    IEM_MC_OR_LOCAL_U64(uTmp, (uint64_t)imm16 << (hw * 16)); \
    IEM_MC_STORE_GREG_U64(Rd, uTmp); \
    IEM_MC_ADVANCE_PC_AND_FINISH(); \
    IEM_MC_END()



/*
 *
 * Instruction Set & Groups: pcreladdr / dpimm / A64
 *
 */

/* ADR  <Xd>, <label> (9f000000/10000000) */
//#define IEM_INSTR_IMPL_A64__ADR_only_pcreladdr(Rd, immhi, immlo)


/* ADRP  <Xd>, <label> (9f000000/90000000) */
//#define IEM_INSTR_IMPL_A64__ADRP_only_pcreladdr(Rd, immhi, immlo)



/*
 *
 * Instruction Set & Groups: perm_undef / reserved / A64
 *
 */

/* UDF  #<imm> (ffff0000/00000000) */
//#define IEM_INSTR_IMPL_A64__UDF_only_perm_undef(imm16)



/*
 *
 * Instruction Set & Groups: pstate / control / A64
 *
 */

/* MSR  <pstatefield>, #<imm> (fff8f01f/d500401f) */
//#define IEM_INSTR_IMPL_A64__MSR_SI_pstate(op2, CRm, op1)


/* CFINV (ffffffff/d500401f) */
//#define IEM_INSTR_IMPL_A64__CFINV_M_pstate()


/* XAFLAG (ffffffff/d500403f) */
//#define IEM_INSTR_IMPL_A64__XAFLAG_M_pstate()


/* AXFLAG (ffffffff/d500405f) */
//#define IEM_INSTR_IMPL_A64__AXFLAG_M_pstate()



/*
 *
 * Instruction Set & Groups: rcwcomswap / ldst / A64
 *
 */

/* RCWCAS  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/19200800) */
//#define IEM_INSTR_IMPL_A64__RCWCAS_C64_rcwcomswap(Rt, Rn, Rs)


/* RCWCASL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/19600800) */
//#define IEM_INSTR_IMPL_A64__RCWCASL_C64_rcwcomswap(Rt, Rn, Rs)


/* RCWCASA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/19a00800) */
//#define IEM_INSTR_IMPL_A64__RCWCASA_C64_rcwcomswap(Rt, Rn, Rs)


/* RCWCASAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/19e00800) */
//#define IEM_INSTR_IMPL_A64__RCWCASAL_C64_rcwcomswap(Rt, Rn, Rs)


/* RCWSCAS  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59200800) */
//#define IEM_INSTR_IMPL_A64__RCWSCAS_C64_rcwcomswap(Rt, Rn, Rs)


/* RCWSCASL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59600800) */
//#define IEM_INSTR_IMPL_A64__RCWSCASL_C64_rcwcomswap(Rt, Rn, Rs)


/* RCWSCASA  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59a00800) */
//#define IEM_INSTR_IMPL_A64__RCWSCASA_C64_rcwcomswap(Rt, Rn, Rs)


/* RCWSCASAL  <Xs>, <Xt>, [<Xn|SP>] (ffe0fc00/59e00800) */
//#define IEM_INSTR_IMPL_A64__RCWSCASAL_C64_rcwcomswap(Rt, Rn, Rs)



/*
 *
 * Instruction Set & Groups: rcwcomswappr / ldst / A64
 *
 */

/* RCWCASP  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>] (ffe0fc00/19200c00) */
//#define IEM_INSTR_IMPL_A64__RCWCASP_C64_rcwcomswappr(Rt, Rn, Rs)


/* RCWCASPL  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>] (ffe0fc00/19600c00) */
//#define IEM_INSTR_IMPL_A64__RCWCASPL_C64_rcwcomswappr(Rt, Rn, Rs)


/* RCWCASPA  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>] (ffe0fc00/19a00c00) */
//#define IEM_INSTR_IMPL_A64__RCWCASPA_C64_rcwcomswappr(Rt, Rn, Rs)


/* RCWCASPAL  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>] (ffe0fc00/19e00c00) */
//#define IEM_INSTR_IMPL_A64__RCWCASPAL_C64_rcwcomswappr(Rt, Rn, Rs)


/* RCWSCASP  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>] (ffe0fc00/59200c00) */
//#define IEM_INSTR_IMPL_A64__RCWSCASP_C64_rcwcomswappr(Rt, Rn, Rs)


/* RCWSCASPL  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>] (ffe0fc00/59600c00) */
//#define IEM_INSTR_IMPL_A64__RCWSCASPL_C64_rcwcomswappr(Rt, Rn, Rs)


/* RCWSCASPA  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>] (ffe0fc00/59a00c00) */
//#define IEM_INSTR_IMPL_A64__RCWSCASPA_C64_rcwcomswappr(Rt, Rn, Rs)


/* RCWSCASPAL  <Xs>, <X(s+1)>, <Xt>, <X(t+1)>, [<Xn|SP>] (ffe0fc00/59e00c00) */
//#define IEM_INSTR_IMPL_A64__RCWSCASPAL_C64_rcwcomswappr(Rt, Rn, Rs)



/*
 *
 * Instruction Set & Groups: rmif / dpreg / A64
 *
 */

/* RMIF  <Xn>, #<shift>, #<mask> (ffe07c10/ba000400) */
//#define IEM_INSTR_IMPL_A64__RMIF_only_rmif(mask, Rn, imm6)



/*
 *
 * Instruction Set & Groups: setf / dpreg / A64
 *
 */

/* SETF8  <Wn> (fffffc1f/3a00080d) */
//#define IEM_INSTR_IMPL_A64__SETF8_only_setf(Rn)


/* SETF16  <Wn> (fffffc1f/3a00480d) */
//#define IEM_INSTR_IMPL_A64__SETF16_only_setf(Rn)



/*
 *
 * Instruction Set & Groups: sve_crypto_binary_const / sve_intx_crypto / sve / A64
 *
 */

/* SM4EKEY  <Zd>.S, <Zn>.S, <Zm>.S (ffe0fc00/4520f000) */
//#define IEM_INSTR_IMPL_A64__sm4ekey_z_zz(Zd, Zn, Zm)


/* RAX1  <Zd>.D, <Zn>.D, <Zm>.D (ffe0fc00/4520f400) */
//#define IEM_INSTR_IMPL_A64__rax1_z_zz(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_crypto_binary_dest / sve_intx_crypto / sve / A64
 *
 */

/* AESE  <Zdn>.B, <Zdn>.B, <Zm>.B (fffffc00/4522e000) */
//#define IEM_INSTR_IMPL_A64__aese_z_zz(Zdn, Zm)


/* AESD  <Zdn>.B, <Zdn>.B, <Zm>.B (fffffc00/4522e400) */
//#define IEM_INSTR_IMPL_A64__aesd_z_zz(Zdn, Zm)


/* SM4E  <Zdn>.S, <Zdn>.S, <Zm>.S (fffffc00/4523e000) */
//#define IEM_INSTR_IMPL_A64__sm4e_z_zz(Zdn, Zm)



/*
 *
 * Instruction Set & Groups: sve_crypto_binary_multi2 / sve_intx_crypto / sve / A64
 *
 */

/* AESE  { <Zdn1>.B-<Zdn2>.B }, { <Zdn1>.B-<Zdn2>.B }, <Zm>.Q[<index>] (ffe7fc01/4522e800) */
//#define IEM_INSTR_IMPL_A64__aese_mz_zzi_2x1(Zdn, Zm, i2)


/* AESD  { <Zdn1>.B-<Zdn2>.B }, { <Zdn1>.B-<Zdn2>.B }, <Zm>.Q[<index>] (ffe7fc01/4522ec00) */
//#define IEM_INSTR_IMPL_A64__aesd_mz_zzi_2x1(Zdn, Zm, i2)


/* AESEMC  { <Zdn1>.B-<Zdn2>.B }, { <Zdn1>.B-<Zdn2>.B }, <Zm>.Q[<index>] (ffe7fc01/4523e800) */
//#define IEM_INSTR_IMPL_A64__aesemc_mz_zzi_2x1(Zdn, Zm, i2)


/* AESDIMC  { <Zdn1>.B-<Zdn2>.B }, { <Zdn1>.B-<Zdn2>.B }, <Zm>.Q[<index>] (ffe7fc01/4523ec00) */
//#define IEM_INSTR_IMPL_A64__aesdimc_mz_zzi_2x1(Zdn, Zm, i2)



/*
 *
 * Instruction Set & Groups: sve_crypto_binary_multi4 / sve_intx_crypto / sve / A64
 *
 */

/* AESE  { <Zdn1>.B-<Zdn4>.B }, { <Zdn1>.B-<Zdn4>.B }, <Zm>.Q[<index>] (ffe7fc03/4526e800) */
//#define IEM_INSTR_IMPL_A64__aese_mz_zzi_4x1(Zdn, Zm, i2)


/* AESD  { <Zdn1>.B-<Zdn4>.B }, { <Zdn1>.B-<Zdn4>.B }, <Zm>.Q[<index>] (ffe7fc03/4526ec00) */
//#define IEM_INSTR_IMPL_A64__aesd_mz_zzi_4x1(Zdn, Zm, i2)


/* AESEMC  { <Zdn1>.B-<Zdn4>.B }, { <Zdn1>.B-<Zdn4>.B }, <Zm>.Q[<index>] (ffe7fc03/4527e800) */
//#define IEM_INSTR_IMPL_A64__aesemc_mz_zzi_4x1(Zdn, Zm, i2)


/* AESDIMC  { <Zdn1>.B-<Zdn4>.B }, { <Zdn1>.B-<Zdn4>.B }, <Zm>.Q[<index>] (ffe7fc03/4527ec00) */
//#define IEM_INSTR_IMPL_A64__aesdimc_mz_zzi_4x1(Zdn, Zm, i2)



/*
 *
 * Instruction Set & Groups: sve_crypto_pmlal_multi / sve_intx_crypto / sve / A64
 *
 */

/* PMLAL  { <Zda1>.Q-<Zda2>.Q }, <Zn>.D, <Zm>.D (ffe0fc01/4520fc00) */
//#define IEM_INSTR_IMPL_A64__pmlal_mz_zzzw_1x2(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_crypto_pmull_multi / sve_intx_crypto / sve / A64
 *
 */

/* PMULL  { <Zd1>.Q-<Zd2>.Q }, <Zn>.D, <Zm>.D (ffe0fc01/4520f800) */
//#define IEM_INSTR_IMPL_A64__pmull_mz_zzw_1x2(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_crypto_unary / sve_intx_crypto / sve / A64
 *
 */

/* AESMC  <Zdn>.B, <Zdn>.B (ffffffe0/4520e000) */
//#define IEM_INSTR_IMPL_A64__aesmc_z_z(Zdn)


/* AESIMC  <Zdn>.B, <Zdn>.B (ffffffe0/4520e400) */
//#define IEM_INSTR_IMPL_A64__aesimc_z_z(Zdn)



/*
 *
 * Instruction Set & Groups: sve_fp8_fcvt_narrow / sve_fp_unary_unpred / sve / A64
 *
 */

/* FCVTN  <Zd>.B, { <Zn1>.H-<Zn2>.H } (fffffc20/650a3000) */
//#define IEM_INSTR_IMPL_A64__fcvtn_z8_mz2_h2b(Zd, Zn)


/* FCVTNB  <Zd>.B, { <Zn1>.S-<Zn2>.S } (fffffc20/650a3400) */
//#define IEM_INSTR_IMPL_A64__fcvtnb_z8_mz2_s2b(Zd, Zn)


/* BFCVTN  <Zd>.B, { <Zn1>.H-<Zn2>.H } (fffffc20/650a3800) */
//#define IEM_INSTR_IMPL_A64__bfcvtn_z8_mz2_bf2b(Zd, Zn)


/* FCVTNT  <Zd>.B, { <Zn1>.S-<Zn2>.S } (fffffc20/650a3c00) */
//#define IEM_INSTR_IMPL_A64__fcvtnt_z8_mz2_s2b(Zd, Zn)



/*
 *
 * Instruction Set & Groups: sve_fp8_fcvt_wide / sve_fp_unary_unpred / sve / A64
 *
 */

/* F1CVT  <Zd>.H, <Zn>.B (fffffc00/65083000) */
//#define IEM_INSTR_IMPL_A64__f1cvt_z_z8_b2h(Zd, Zn)


/* F2CVT  <Zd>.H, <Zn>.B (fffffc00/65083400) */
//#define IEM_INSTR_IMPL_A64__f2cvt_z_z8_b2h(Zd, Zn)


/* BF1CVT  <Zd>.H, <Zn>.B (fffffc00/65083800) */
//#define IEM_INSTR_IMPL_A64__bf1cvt_z_z8_b2bf(Zd, Zn)


/* BF2CVT  <Zd>.H, <Zn>.B (fffffc00/65083c00) */
//#define IEM_INSTR_IMPL_A64__bf2cvt_z_z8_b2bf(Zd, Zn)


/* F1CVTLT  <Zd>.H, <Zn>.B (fffffc00/65093000) */
//#define IEM_INSTR_IMPL_A64__f1cvtlt_z_z8_b2h(Zd, Zn)


/* F2CVTLT  <Zd>.H, <Zn>.B (fffffc00/65093400) */
//#define IEM_INSTR_IMPL_A64__f2cvtlt_z_z8_b2h(Zd, Zn)


/* BF1CVTLT  <Zd>.H, <Zn>.B (fffffc00/65093800) */
//#define IEM_INSTR_IMPL_A64__bf1cvtlt_z_z8_b2bf(Zd, Zn)


/* BF2CVTLT  <Zd>.H, <Zn>.B (fffffc00/65093c00) */
//#define IEM_INSTR_IMPL_A64__bf2cvtlt_z_z8_b2bf(Zd, Zn)



/*
 *
 * Instruction Set & Groups: sve_fp8_fma_long / sve_fp8_fma_w / sve / A64
 *
 */

/* FMLALB  <Zda>.H, <Zn>.B, <Zm>.B (ffe0fc00/64a08800) */
//#define IEM_INSTR_IMPL_A64__fmlalb_z_z8z8z8(Zda, Zn, Zm)


/* FMLALT  <Zda>.H, <Zn>.B, <Zm>.B (ffe0fc00/64a09800) */
//#define IEM_INSTR_IMPL_A64__fmlalt_z_z8z8z8(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_fp8_fma_long_by_indexed_elem / sve_fp8_fma_w_by_indexed_elem / sve / A64
 *
 */

/* FMLALB  <Zda>.H, <Zn>.B, <Zm>.B[<imm>] (ffe0f000/64205000) */
//#define IEM_INSTR_IMPL_A64__fmlalb_z_z8z8z8i(Zda, Zn, i4l, Zm, i4h)


/* FMLALT  <Zda>.H, <Zn>.B, <Zm>.B[<imm>] (ffe0f000/64a05000) */
//#define IEM_INSTR_IMPL_A64__fmlalt_z_z8z8z8i(Zda, Zn, i4l, Zm, i4h)



/*
 *
 * Instruction Set & Groups: sve_fp8_fma_long_long / sve_fp8_fma_w / sve / A64
 *
 */

/* FMLALLBB  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/64208800) */
//#define IEM_INSTR_IMPL_A64__fmlallbb_z32_z8z8z8(Zda, Zn, Zm)


/* FMLALLBT  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/64209800) */
//#define IEM_INSTR_IMPL_A64__fmlallbt_z32_z8z8z8(Zda, Zn, Zm)


/* FMLALLTB  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/6420a800) */
//#define IEM_INSTR_IMPL_A64__fmlalltb_z32_z8z8z8(Zda, Zn, Zm)


/* FMLALLTT  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/6420b800) */
//#define IEM_INSTR_IMPL_A64__fmlalltt_z32_z8z8z8(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_fp8_fma_long_long_by_indexed_elem / sve_fp8_fma_ww_by_indexed_elem / sve / A64
 *
 */

/* FMLALLBB  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0f000/6420c000) */
//#define IEM_INSTR_IMPL_A64__fmlallbb_z32_z8z8z8i(Zda, Zn, i4l, Zm, i4h)


/* FMLALLBT  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0f000/6460c000) */
//#define IEM_INSTR_IMPL_A64__fmlallbt_z32_z8z8z8i(Zda, Zn, i4l, Zm, i4h)


/* FMLALLTB  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0f000/64a0c000) */
//#define IEM_INSTR_IMPL_A64__fmlalltb_z32_z8z8z8i(Zda, Zn, i4l, Zm, i4h)


/* FMLALLTT  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0f000/64e0c000) */
//#define IEM_INSTR_IMPL_A64__fmlalltt_z32_z8z8z8i(Zda, Zn, i4l, Zm, i4h)



/*
 *
 * Instruction Set & Groups: sve_fp8_fmmla_lvl2 / sve_fp8_fmmla / sve / A64
 *
 */

/* FMMLA  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/6420e000) */
//#define IEM_INSTR_IMPL_A64__fmmla_z32_zz8z8(Zda, Zn, Zm)


/* FMMLA  <Zda>.H, <Zn>.B, <Zm>.B (ffe0fc00/6460e000) */
//#define IEM_INSTR_IMPL_A64__fmmla_z16_zz8z8(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_i_p_zds / sve_fp_pred / sve / A64
 *
 */

/* FADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <const> (ff3fe3c0/65188000) */
//#define IEM_INSTR_IMPL_A64__fadd_z_p_zs(Zdn, i1, Pg, size)


/* FSUB  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <const> (ff3fe3c0/65198000) */
//#define IEM_INSTR_IMPL_A64__fsub_z_p_zs(Zdn, i1, Pg, size)


/* FMUL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <const> (ff3fe3c0/651a8000) */
//#define IEM_INSTR_IMPL_A64__fmul_z_p_zs(Zdn, i1, Pg, size)


/* FSUBR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <const> (ff3fe3c0/651b8000) */
//#define IEM_INSTR_IMPL_A64__fsubr_z_p_zs(Zdn, i1, Pg, size)


/* FMAXNM  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <const> (ff3fe3c0/651c8000) */
//#define IEM_INSTR_IMPL_A64__fmaxnm_z_p_zs(Zdn, i1, Pg, size)


/* FMINNM  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <const> (ff3fe3c0/651d8000) */
//#define IEM_INSTR_IMPL_A64__fminnm_z_p_zs(Zdn, i1, Pg, size)


/* FMAX  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <const> (ff3fe3c0/651e8000) */
//#define IEM_INSTR_IMPL_A64__fmax_z_p_zs(Zdn, i1, Pg, size)


/* FMIN  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <const> (ff3fe3c0/651f8000) */
//#define IEM_INSTR_IMPL_A64__fmin_z_p_zs(Zdn, i1, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_p_pd / sve_fp_cmpzero / sve / A64
 *
 */

/* FCMGE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #0.0 (ff3fe010/65102000) */
//#define IEM_INSTR_IMPL_A64__fcmge_p_p_z0(Pd, Zn, Pg, size)


/* FCMEQ  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #0.0 (ff3fe010/65122000) */
//#define IEM_INSTR_IMPL_A64__fcmeq_p_p_z0(Pd, Zn, Pg, size)


/* FCMGT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #0.0 (ff3fe010/65102010) */
//#define IEM_INSTR_IMPL_A64__fcmgt_p_p_z0(Pd, Zn, Pg, size)


/* FCMLT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #0.0 (ff3fe010/65112000) */
//#define IEM_INSTR_IMPL_A64__fcmlt_p_p_z0(Pd, Zn, Pg, size)


/* FCMNE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #0.0 (ff3fe010/65132000) */
//#define IEM_INSTR_IMPL_A64__fcmne_p_p_z0(Pd, Zn, Pg, size)


/* FCMLE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #0.0 (ff3fe010/65112010) */
//#define IEM_INSTR_IMPL_A64__fcmle_p_p_z0(Pd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_p_vd / sve_fp_slowreduce / sve / A64
 *
 */

/* FADDA  <V><dn>, <Pg>, <V><dn>, <Zm>.<T> (ff3fe000/65182000) */
//#define IEM_INSTR_IMPL_A64__fadda_v_p_z(Vdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_p_zd_a / sve_fp_unary / sve / A64
 *
 */

/* FRINTN  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/6500a000) */
//#define IEM_INSTR_IMPL_A64__frintn_z_p_z_m(Zd, Zn, Pg, size)


/* FRINTP  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/6501a000) */
//#define IEM_INSTR_IMPL_A64__frintp_z_p_z_m(Zd, Zn, Pg, size)


/* FRINTM  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/6502a000) */
//#define IEM_INSTR_IMPL_A64__frintm_z_p_z_m(Zd, Zn, Pg, size)


/* FRINTZ  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/6503a000) */
//#define IEM_INSTR_IMPL_A64__frintz_z_p_z_m(Zd, Zn, Pg, size)


/* FRINTA  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/6504a000) */
//#define IEM_INSTR_IMPL_A64__frinta_z_p_z_m(Zd, Zn, Pg, size)


/* FRINTX  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/6506a000) */
//#define IEM_INSTR_IMPL_A64__frintx_z_p_z_m(Zd, Zn, Pg, size)


/* FRINTI  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/6507a000) */
//#define IEM_INSTR_IMPL_A64__frinti_z_p_z_m(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_p_zd_b_0 / sve_fp_unary / sve / A64
 *
 */

/* FCVTX  <Zd>.S, <Pg>/M, <Zn>.D (ffffe000/650aa000) */
//#define IEM_INSTR_IMPL_A64__fcvtx_z_p_z_d2s(Zd, Zn, Pg)


/* FCVT  <Zd>.H, <Pg>/M, <Zn>.S (ffffe000/6588a000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_s2h(Zd, Zn, Pg)


/* FCVT  <Zd>.S, <Pg>/M, <Zn>.H (ffffe000/6589a000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_h2s(Zd, Zn, Pg)


/* BFCVT  <Zd>.H, <Pg>/M, <Zn>.S (ffffe000/658aa000) */
//#define IEM_INSTR_IMPL_A64__bfcvt_z_p_z_s2bf(Zd, Zn, Pg)


/* FCVT  <Zd>.H, <Pg>/M, <Zn>.D (ffffe000/65c8a000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_d2h(Zd, Zn, Pg)


/* FCVT  <Zd>.D, <Pg>/M, <Zn>.H (ffffe000/65c9a000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_h2d(Zd, Zn, Pg)


/* FCVT  <Zd>.S, <Pg>/M, <Zn>.D (ffffe000/65caa000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_d2s(Zd, Zn, Pg)


/* FCVT  <Zd>.D, <Pg>/M, <Zn>.S (ffffe000/65cba000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_s2d(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_p_zd_b_1 / sve_fp_unary / sve / A64
 *
 */

/* FRECPX  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/650ca000) */
//#define IEM_INSTR_IMPL_A64__frecpx_z_p_z_m(Zd, Zn, Pg, size)


/* FSQRT  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/650da000) */
//#define IEM_INSTR_IMPL_A64__fsqrt_z_p_z_m(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_p_zd_c / sve_fp_unary / sve / A64
 *
 */

/* FRINT32Z  <Zd>.<T>, <Pg>/M, <Zn>.<T> (fffde000/6510a000) */
//#define IEM_INSTR_IMPL_A64__frint32z_z_p_z_m(Zd, Zn, Pg, sz)


/* FRINT32X  <Zd>.<T>, <Pg>/M, <Zn>.<T> (fffde000/6511a000) */
//#define IEM_INSTR_IMPL_A64__frint32x_z_p_z_m(Zd, Zn, Pg, sz)


/* FRINT64Z  <Zd>.<T>, <Pg>/M, <Zn>.<T> (fffde000/6514a000) */
//#define IEM_INSTR_IMPL_A64__frint64z_z_p_z_m(Zd, Zn, Pg, sz)


/* FRINT64X  <Zd>.<T>, <Pg>/M, <Zn>.<T> (fffde000/6515a000) */
//#define IEM_INSTR_IMPL_A64__frint64x_z_p_z_m(Zd, Zn, Pg, sz)


/* SCVTF  <Zd>.S, <Pg>/M, <Zn>.S (ffffe000/6594a000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_w2s(Zd, Zn, Pg)


/* SCVTF  <Zd>.D, <Pg>/M, <Zn>.S (ffffe000/65d0a000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_w2d(Zd, Zn, Pg)


/* SCVTF  <Zd>.S, <Pg>/M, <Zn>.D (ffffe000/65d4a000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_x2s(Zd, Zn, Pg)


/* SCVTF  <Zd>.D, <Pg>/M, <Zn>.D (ffffe000/65d6a000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_x2d(Zd, Zn, Pg)


/* SCVTF  <Zd>.H, <Pg>/M, <Zn>.H (ffffe000/6552a000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_h2fp16(Zd, Zn, Pg)


/* SCVTF  <Zd>.H, <Pg>/M, <Zn>.S (ffffe000/6554a000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_w2fp16(Zd, Zn, Pg)


/* SCVTF  <Zd>.H, <Pg>/M, <Zn>.D (ffffe000/6556a000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_x2fp16(Zd, Zn, Pg)


/* UCVTF  <Zd>.S, <Pg>/M, <Zn>.S (ffffe000/6595a000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_w2s(Zd, Zn, Pg)


/* UCVTF  <Zd>.D, <Pg>/M, <Zn>.S (ffffe000/65d1a000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_w2d(Zd, Zn, Pg)


/* UCVTF  <Zd>.S, <Pg>/M, <Zn>.D (ffffe000/65d5a000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_x2s(Zd, Zn, Pg)


/* UCVTF  <Zd>.D, <Pg>/M, <Zn>.D (ffffe000/65d7a000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_x2d(Zd, Zn, Pg)


/* UCVTF  <Zd>.H, <Pg>/M, <Zn>.H (ffffe000/6553a000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_h2fp16(Zd, Zn, Pg)


/* UCVTF  <Zd>.H, <Pg>/M, <Zn>.S (ffffe000/6555a000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_w2fp16(Zd, Zn, Pg)


/* UCVTF  <Zd>.H, <Pg>/M, <Zn>.D (ffffe000/6557a000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_x2fp16(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_p_zd_d / sve_fp_unary / sve / A64
 *
 */

/* FLOGB  <Zd>.<T>, <Pg>/M, <Zn>.<T> (fff9e000/6518a000) */
//#define IEM_INSTR_IMPL_A64__flogb_z_p_z_m(Zd, Zn, Pg, size)


/* FCVTZS  <Zd>.S, <Pg>/M, <Zn>.S (ffffe000/659ca000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_s2w(Zd, Zn, Pg)


/* FCVTZS  <Zd>.S, <Pg>/M, <Zn>.D (ffffe000/65d8a000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_d2w(Zd, Zn, Pg)


/* FCVTZS  <Zd>.D, <Pg>/M, <Zn>.S (ffffe000/65dca000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_s2x(Zd, Zn, Pg)


/* FCVTZS  <Zd>.D, <Pg>/M, <Zn>.D (ffffe000/65dea000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_d2x(Zd, Zn, Pg)


/* FCVTZS  <Zd>.H, <Pg>/M, <Zn>.H (ffffe000/655aa000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_fp162h(Zd, Zn, Pg)


/* FCVTZS  <Zd>.S, <Pg>/M, <Zn>.H (ffffe000/655ca000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_fp162w(Zd, Zn, Pg)


/* FCVTZS  <Zd>.D, <Pg>/M, <Zn>.H (ffffe000/655ea000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_fp162x(Zd, Zn, Pg)


/* FCVTZU  <Zd>.S, <Pg>/M, <Zn>.S (ffffe000/659da000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_s2w(Zd, Zn, Pg)


/* FCVTZU  <Zd>.S, <Pg>/M, <Zn>.D (ffffe000/65d9a000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_d2w(Zd, Zn, Pg)


/* FCVTZU  <Zd>.D, <Pg>/M, <Zn>.S (ffffe000/65dda000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_s2x(Zd, Zn, Pg)


/* FCVTZU  <Zd>.D, <Pg>/M, <Zn>.D (ffffe000/65dfa000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_d2x(Zd, Zn, Pg)


/* FCVTZU  <Zd>.H, <Pg>/M, <Zn>.H (ffffe000/655ba000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_fp162h(Zd, Zn, Pg)


/* FCVTZU  <Zd>.S, <Pg>/M, <Zn>.H (ffffe000/655da000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_fp162w(Zd, Zn, Pg)


/* FCVTZU  <Zd>.D, <Pg>/M, <Zn>.H (ffffe000/655fa000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_fp162x(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_p_zds / sve_fp_pred / sve / A64
 *
 */

/* FADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65008000) */
//#define IEM_INSTR_IMPL_A64__fadd_z_p_zz(Zdn, Zm, Pg, size)


/* BFADD  <Zdn>.H, <Pg>/M, <Zdn>.H, <Zm>.H (ffffe000/65008000) */
//#define IEM_INSTR_IMPL_A64__bfadd_z_p_zz(Zdn, Zm, Pg)


/* FSUB  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65018000) */
//#define IEM_INSTR_IMPL_A64__fsub_z_p_zz(Zdn, Zm, Pg, size)


/* BFSUB  <Zdn>.H, <Pg>/M, <Zdn>.H, <Zm>.H (ffffe000/65018000) */
//#define IEM_INSTR_IMPL_A64__bfsub_z_p_zz(Zdn, Zm, Pg)


/* FMUL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65028000) */
//#define IEM_INSTR_IMPL_A64__fmul_z_p_zz(Zdn, Zm, Pg, size)


/* BFMUL  <Zdn>.H, <Pg>/M, <Zdn>.H, <Zm>.H (ffffe000/65028000) */
//#define IEM_INSTR_IMPL_A64__bfmul_z_p_zz(Zdn, Zm, Pg)


/* FSUBR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65038000) */
//#define IEM_INSTR_IMPL_A64__fsubr_z_p_zz(Zdn, Zm, Pg, size)


/* FMAXNM  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65048000) */
//#define IEM_INSTR_IMPL_A64__fmaxnm_z_p_zz(Zdn, Zm, Pg, size)


/* BFMAXNM  <Zdn>.H, <Pg>/M, <Zdn>.H, <Zm>.H (ffffe000/65048000) */
//#define IEM_INSTR_IMPL_A64__bfmaxnm_z_p_zz(Zdn, Zm, Pg)


/* FMINNM  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65058000) */
//#define IEM_INSTR_IMPL_A64__fminnm_z_p_zz(Zdn, Zm, Pg, size)


/* BFMINNM  <Zdn>.H, <Pg>/M, <Zdn>.H, <Zm>.H (ffffe000/65058000) */
//#define IEM_INSTR_IMPL_A64__bfminnm_z_p_zz(Zdn, Zm, Pg)


/* FMAX  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65068000) */
//#define IEM_INSTR_IMPL_A64__fmax_z_p_zz(Zdn, Zm, Pg, size)


/* BFMAX  <Zdn>.H, <Pg>/M, <Zdn>.H, <Zm>.H (ffffe000/65068000) */
//#define IEM_INSTR_IMPL_A64__bfmax_z_p_zz(Zdn, Zm, Pg)


/* FMIN  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65078000) */
//#define IEM_INSTR_IMPL_A64__fmin_z_p_zz(Zdn, Zm, Pg, size)


/* BFMIN  <Zdn>.H, <Pg>/M, <Zdn>.H, <Zm>.H (ffffe000/65078000) */
//#define IEM_INSTR_IMPL_A64__bfmin_z_p_zz(Zdn, Zm, Pg)


/* FABD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65088000) */
//#define IEM_INSTR_IMPL_A64__fabd_z_p_zz(Zdn, Zm, Pg, size)


/* FSCALE  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/65098000) */
//#define IEM_INSTR_IMPL_A64__fscale_z_p_zz(Zdn, Zm, Pg, size)


/* BFSCALE  <Zdn>.H, <Pg>/M, <Zdn>.H, <Zm>.H (ffffe000/65098000) */
//#define IEM_INSTR_IMPL_A64__bfscale_z_p_zz(Zdn, Zm, Pg)


/* FMULX  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/650a8000) */
//#define IEM_INSTR_IMPL_A64__fmulx_z_p_zz(Zdn, Zm, Pg, size)


/* FDIVR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/650c8000) */
//#define IEM_INSTR_IMPL_A64__fdivr_z_p_zz(Zdn, Zm, Pg, size)


/* FDIV  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/650d8000) */
//#define IEM_INSTR_IMPL_A64__fdiv_z_p_zz(Zdn, Zm, Pg, size)


/* FAMAX  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/650e8000) */
//#define IEM_INSTR_IMPL_A64__famax_z_p_zz(Zdn, Zm, Pg, size)


/* FAMIN  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/650f8000) */
//#define IEM_INSTR_IMPL_A64__famin_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_2op_u_zd / sve_fp_unary_unpred / sve / A64
 *
 */

/* FRECPE  <Zd>.<T>, <Zn>.<T> (ff3ffc00/650e3000) */
//#define IEM_INSTR_IMPL_A64__frecpe_z_z(Zd, Zn, size)


/* FRSQRTE  <Zd>.<T>, <Zn>.<T> (ff3ffc00/650f3000) */
//#define IEM_INSTR_IMPL_A64__frsqrte_z_z(Zd, Zn, size)



/*
 *
 * Instruction Set & Groups: sve_fp_3op_p_pd / sve_fp_cmpvev / sve / A64
 *
 */

/* FCMGE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/65004000) */
//#define IEM_INSTR_IMPL_A64__fcmge_p_p_zz(Pd, Zn, Pg, Zm, size)


/* FCMUO  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/6500c000) */
//#define IEM_INSTR_IMPL_A64__fcmuo_p_p_zz(Pd, Zn, Pg, Zm, size)


/* FACGE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/6500c010) */
//#define IEM_INSTR_IMPL_A64__facge_p_p_zz(Pd, Zn, Pg, Zm, size)


/* FACGT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/6500e010) */
//#define IEM_INSTR_IMPL_A64__facgt_p_p_zz(Pd, Zn, Pg, Zm, size)


/* FCMGT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/65004010) */
//#define IEM_INSTR_IMPL_A64__fcmgt_p_p_zz(Pd, Zn, Pg, Zm, size)


/* FCMEQ  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/65006000) */
//#define IEM_INSTR_IMPL_A64__fcmeq_p_p_zz(Pd, Zn, Pg, Zm, size)


/* FCMNE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/65006010) */
//#define IEM_INSTR_IMPL_A64__fcmne_p_p_zz(Pd, Zn, Pg, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_fp_3op_p_zds_a / sve_fp_fma / sve / A64
 *
 */

/* FMLA  <Zda>.<T>, <Pg>/M, <Zn>.<T>, <Zm>.<T> (ff20e000/65200000) */
//#define IEM_INSTR_IMPL_A64__fmla_z_p_zzz(Zda, Zn, Pg, Zm, size)


/* BFMLA  <Zda>.H, <Pg>/M, <Zn>.H, <Zm>.H (ffe0e000/65200000) */
//#define IEM_INSTR_IMPL_A64__bfmla_z_p_zzz(Zda, Zn, Pg, Zm)


/* FMLS  <Zda>.<T>, <Pg>/M, <Zn>.<T>, <Zm>.<T> (ff20e000/65202000) */
//#define IEM_INSTR_IMPL_A64__fmls_z_p_zzz(Zda, Zn, Pg, Zm, size)


/* BFMLS  <Zda>.H, <Pg>/M, <Zn>.H, <Zm>.H (ffe0e000/65202000) */
//#define IEM_INSTR_IMPL_A64__bfmls_z_p_zzz(Zda, Zn, Pg, Zm)


/* FNMLA  <Zda>.<T>, <Pg>/M, <Zn>.<T>, <Zm>.<T> (ff20e000/65204000) */
//#define IEM_INSTR_IMPL_A64__fnmla_z_p_zzz(Zda, Zn, Pg, Zm, size)


/* FNMLS  <Zda>.<T>, <Pg>/M, <Zn>.<T>, <Zm>.<T> (ff20e000/65206000) */
//#define IEM_INSTR_IMPL_A64__fnmls_z_p_zzz(Zda, Zn, Pg, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_fp_3op_p_zds_b / sve_fp_fma / sve / A64
 *
 */

/* FMAD  <Zdn>.<T>, <Pg>/M, <Zm>.<T>, <Za>.<T> (ff20e000/65208000) */
//#define IEM_INSTR_IMPL_A64__fmad_z_p_zzz(Zdn, Zm, Pg, Za, size)


/* FMSB  <Zdn>.<T>, <Pg>/M, <Zm>.<T>, <Za>.<T> (ff20e000/6520a000) */
//#define IEM_INSTR_IMPL_A64__fmsb_z_p_zzz(Zdn, Zm, Pg, Za, size)


/* FNMAD  <Zdn>.<T>, <Pg>/M, <Zm>.<T>, <Za>.<T> (ff20e000/6520c000) */
//#define IEM_INSTR_IMPL_A64__fnmad_z_p_zzz(Zdn, Zm, Pg, Za, size)


/* FNMSB  <Zdn>.<T>, <Pg>/M, <Zm>.<T>, <Za>.<T> (ff20e000/6520e000) */
//#define IEM_INSTR_IMPL_A64__fnmsb_z_p_zzz(Zdn, Zm, Pg, Za, size)



/*
 *
 * Instruction Set & Groups: sve_fp_3op_u_zd / sve_fp_unpred / sve / A64
 *
 */

/* FADD  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/65000000) */
//#define IEM_INSTR_IMPL_A64__fadd_z_zz(Zd, Zn, Zm, size)


/* BFADD  <Zd>.H, <Zn>.H, <Zm>.H (ffe0fc00/65000000) */
//#define IEM_INSTR_IMPL_A64__bfadd_z_zz(Zd, Zn, Zm)


/* FSUB  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/65000400) */
//#define IEM_INSTR_IMPL_A64__fsub_z_zz(Zd, Zn, Zm, size)


/* BFSUB  <Zd>.H, <Zn>.H, <Zm>.H (ffe0fc00/65000400) */
//#define IEM_INSTR_IMPL_A64__bfsub_z_zz(Zd, Zn, Zm)


/* FMUL  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/65000800) */
//#define IEM_INSTR_IMPL_A64__fmul_z_zz(Zd, Zn, Zm, size)


/* BFMUL  <Zd>.H, <Zn>.H, <Zm>.H (ffe0fc00/65000800) */
//#define IEM_INSTR_IMPL_A64__bfmul_z_zz(Zd, Zn, Zm)


/* FTSMUL  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/65000c00) */
//#define IEM_INSTR_IMPL_A64__ftsmul_z_zz(Zd, Zn, Zm, size)


/* FRECPS  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/65001800) */
//#define IEM_INSTR_IMPL_A64__frecps_z_zz(Zd, Zn, Zm, size)


/* FRSQRTS  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/65001c00) */
//#define IEM_INSTR_IMPL_A64__frsqrts_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_fp_clamp_lvl2 / sve_fp_clamp / sve / A64
 *
 */

/* FCLAMP  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/64202400) */
//#define IEM_INSTR_IMPL_A64__fclamp_z_zz(Zd, Zn, Zm, size)


/* BFCLAMP  <Zd>.H, <Zn>.H, <Zm>.H (ffe0fc00/64202400) */
//#define IEM_INSTR_IMPL_A64__bfclamp_z_zz(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_fp_fast_red / sve_fp_fastreduce / sve / A64
 *
 */

/* FADDV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/65002000) */
//#define IEM_INSTR_IMPL_A64__faddv_v_p_z(Vd, Zn, Pg, size)


/* FMAXNMV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/65042000) */
//#define IEM_INSTR_IMPL_A64__fmaxnmv_v_p_z(Vd, Zn, Pg, size)


/* FMINNMV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/65052000) */
//#define IEM_INSTR_IMPL_A64__fminnmv_v_p_z(Vd, Zn, Pg, size)


/* FMAXV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/65062000) */
//#define IEM_INSTR_IMPL_A64__fmaxv_v_p_z(Vd, Zn, Pg, size)


/* FMINV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/65072000) */
//#define IEM_INSTR_IMPL_A64__fminv_v_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_fast_redq / sve_fp_fastreduceq / sve / A64
 *
 */

/* FADDQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/6410a000) */
//#define IEM_INSTR_IMPL_A64__faddqv_z_p_z(Vd, Zn, Pg, size)


/* FMAXNMQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/6414a000) */
//#define IEM_INSTR_IMPL_A64__fmaxnmqv_z_p_z(Vd, Zn, Pg, size)


/* FMINNMQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/6415a000) */
//#define IEM_INSTR_IMPL_A64__fminnmqv_z_p_z(Vd, Zn, Pg, size)


/* FMAXQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/6416a000) */
//#define IEM_INSTR_IMPL_A64__fmaxqv_z_p_z(Vd, Zn, Pg, size)


/* FMINQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/6417a000) */
//#define IEM_INSTR_IMPL_A64__fminqv_z_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_fcadd_lvl2 / sve_fp_fcadd / sve / A64
 *
 */

/* FCADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T>, <const> (ff3ee000/64008000) */
//#define IEM_INSTR_IMPL_A64__fcadd_z_p_zz(Zdn, Zm, Pg, rot, size)



/*
 *
 * Instruction Set & Groups: sve_fp_fcmla_by_indexed_elem_lvl2 / sve_fp_fcmla_by_indexed_elem / sve / A64
 *
 */

/* FCMLA  <Zda>.H, <Zn>.H, <Zm>.H[<imm>], <const> (ffe0f000/64a01000) */
//#define IEM_INSTR_IMPL_A64__fcmla_z_zzzi_h(Zda, Zn, rot, Zm, i2)


/* FCMLA  <Zda>.S, <Zn>.S, <Zm>.S[<imm>], <const> (ffe0f000/64e01000) */
//#define IEM_INSTR_IMPL_A64__fcmla_z_zzzi_s(Zda, Zn, rot, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_fp_fcmla_lvl2 / sve_fp_fcmla / sve / A64
 *
 */

/* FCMLA  <Zda>.<T>, <Pg>/M, <Zn>.<T>, <Zm>.<T>, <const> (ff208000/64000000) */
//#define IEM_INSTR_IMPL_A64__fcmla_z_p_zzz(Zda, Zn, Pg, rot, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_fp_fcvt2_lvl2 / sve_fp_fcvt2 / sve / A64
 *
 */

/* FCVTXNT  <Zd>.S, <Pg>/M, <Zn>.D (ffffe000/640aa000) */
//#define IEM_INSTR_IMPL_A64__fcvtxnt_z_p_z_d2s(Zd, Zn, Pg)


/* FCVTNT  <Zd>.H, <Pg>/M, <Zn>.S (ffffe000/6488a000) */
//#define IEM_INSTR_IMPL_A64__fcvtnt_z_p_z_s2h(Zd, Zn, Pg)


/* FCVTLT  <Zd>.S, <Pg>/M, <Zn>.H (ffffe000/6489a000) */
//#define IEM_INSTR_IMPL_A64__fcvtlt_z_p_z_h2s(Zd, Zn, Pg)


/* BFCVTNT  <Zd>.H, <Pg>/M, <Zn>.S (ffffe000/648aa000) */
//#define IEM_INSTR_IMPL_A64__bfcvtnt_z_p_z_s2bf(Zd, Zn, Pg)


/* FCVTNT  <Zd>.S, <Pg>/M, <Zn>.D (ffffe000/64caa000) */
//#define IEM_INSTR_IMPL_A64__fcvtnt_z_p_z_d2s(Zd, Zn, Pg)


/* FCVTLT  <Zd>.D, <Pg>/M, <Zn>.S (ffffe000/64cba000) */
//#define IEM_INSTR_IMPL_A64__fcvtlt_z_p_z_s2d(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_fp_fcvt2z_lvl2 / sve_fp_fcvt2z / sve / A64
 *
 */

/* FCVTXNT  <Zd>.S, <Pg>/Z, <Zn>.D (ffffe000/6402a000) */
//#define IEM_INSTR_IMPL_A64__fcvtxnt_z_p_z_d2sz(Zd, Zn, Pg)


/* FCVTNT  <Zd>.H, <Pg>/Z, <Zn>.S (ffffe000/6480a000) */
//#define IEM_INSTR_IMPL_A64__fcvtnt_z_p_z_s2hz(Zd, Zn, Pg)


/* FCVTLT  <Zd>.S, <Pg>/Z, <Zn>.H (ffffe000/6481a000) */
//#define IEM_INSTR_IMPL_A64__fcvtlt_z_p_z_h2sz(Zd, Zn, Pg)


/* BFCVTNT  <Zd>.H, <Pg>/Z, <Zn>.S (ffffe000/6482a000) */
//#define IEM_INSTR_IMPL_A64__bfcvtnt_z_p_z_s2bfz(Zd, Zn, Pg)


/* FCVTNT  <Zd>.S, <Pg>/Z, <Zn>.D (ffffe000/64c2a000) */
//#define IEM_INSTR_IMPL_A64__fcvtnt_z_p_z_d2sz(Zd, Zn, Pg)


/* FCVTLT  <Zd>.D, <Pg>/Z, <Zn>.S (ffffe000/64c3a000) */
//#define IEM_INSTR_IMPL_A64__fcvtlt_z_p_z_s2dz(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_fp_fdot / sve_fp_fma_w / sve / A64
 *
 */

/* FDOT  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64208000) */
//#define IEM_INSTR_IMPL_A64__fdot_z_zzz(Zda, Zn, Zm)


/* BFDOT  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64608000) */
//#define IEM_INSTR_IMPL_A64__bfdot_z_zzz(Zda, Zn, Zm)


/* FDOT  <Zda>.H, <Zn>.B, <Zm>.B (ffe0fc00/64208400) */
//#define IEM_INSTR_IMPL_A64__fdot_z_zz8z8(Zda, Zn, Zm)


/* FDOT  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/64608400) */
//#define IEM_INSTR_IMPL_A64__fdot_z32_zz8z8(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_fp_fdot_by_indexed_elem / sve_fp_fma_w_by_indexed_elem / sve / A64
 *
 */

/* FDOT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0fc00/64204000) */
//#define IEM_INSTR_IMPL_A64__fdot_z_zzzi(Zda, Zn, Zm, i2)


/* BFDOT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0fc00/64604000) */
//#define IEM_INSTR_IMPL_A64__bfdot_z_zzzi(Zda, Zn, Zm, i2)


/* FDOT  <Zda>.H, <Zn>.B, <Zm>.B[<imm>] (ffe0f400/64204400) */
//#define IEM_INSTR_IMPL_A64__fdot_z_zz8z8i(Zda, Zn, i3l, Zm, i3h)


/* FDOT  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0fc00/64604400) */
//#define IEM_INSTR_IMPL_A64__fdot_z32_zz8z8i(Zda, Zn, Zm, i2)



/*
 *
 * Instruction Set & Groups: sve_fp_fma_by_indexed_elem_lvl2 / sve_fp_fma_by_indexed_elem / sve / A64
 *
 */

/* FMLA  <Zda>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/64200000) */
//#define IEM_INSTR_IMPL_A64__fmla_z_zzzi_h(Zda, Zn, Zm, i3l, i3h)


/* BFMLA  <Zda>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/64200800) */
//#define IEM_INSTR_IMPL_A64__bfmla_z_zzzi_h(Zda, Zn, Zm, i3l, i3h)


/* FMLA  <Zda>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/64a00000) */
//#define IEM_INSTR_IMPL_A64__fmla_z_zzzi_s(Zda, Zn, Zm, i2)


/* FMLA  <Zda>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/64e00000) */
//#define IEM_INSTR_IMPL_A64__fmla_z_zzzi_d(Zda, Zn, Zm, i1)


/* FMLS  <Zda>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/64200400) */
//#define IEM_INSTR_IMPL_A64__fmls_z_zzzi_h(Zda, Zn, Zm, i3l, i3h)


/* BFMLS  <Zda>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/64200c00) */
//#define IEM_INSTR_IMPL_A64__bfmls_z_zzzi_h(Zda, Zn, Zm, i3l, i3h)


/* FMLS  <Zda>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/64a00400) */
//#define IEM_INSTR_IMPL_A64__fmls_z_zzzi_s(Zda, Zn, Zm, i2)


/* FMLS  <Zda>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/64e00400) */
//#define IEM_INSTR_IMPL_A64__fmls_z_zzzi_d(Zda, Zn, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_fp_fma_long / sve_fp_fma_w / sve / A64
 *
 */

/* FMLALB  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64a08000) */
//#define IEM_INSTR_IMPL_A64__fmlalb_z_zzz(Zda, Zn, Zm)


/* BFMLALB  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64e08000) */
//#define IEM_INSTR_IMPL_A64__bfmlalb_z_zzz(Zda, Zn, Zm)


/* FMLSLB  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64a0a000) */
//#define IEM_INSTR_IMPL_A64__fmlslb_z_zzz(Zda, Zn, Zm)


/* BFMLSLB  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64e0a000) */
//#define IEM_INSTR_IMPL_A64__bfmlslb_z_zzz(Zda, Zn, Zm)


/* FMLALT  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64a08400) */
//#define IEM_INSTR_IMPL_A64__fmlalt_z_zzz(Zda, Zn, Zm)


/* BFMLALT  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64e08400) */
//#define IEM_INSTR_IMPL_A64__bfmlalt_z_zzz(Zda, Zn, Zm)


/* FMLSLT  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64a0a400) */
//#define IEM_INSTR_IMPL_A64__fmlslt_z_zzz(Zda, Zn, Zm)


/* BFMLSLT  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/64e0a400) */
//#define IEM_INSTR_IMPL_A64__bfmlslt_z_zzz(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_fp_fma_long_by_indexed_elem / sve_fp_fma_w_by_indexed_elem / sve / A64
 *
 */

/* FMLALB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/64a04000) */
//#define IEM_INSTR_IMPL_A64__fmlalb_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* BFMLALB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/64e04000) */
//#define IEM_INSTR_IMPL_A64__bfmlalb_z_zzzi(Zda, Zn, i3l, Zm, i3h)


/* FMLSLB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/64a06000) */
//#define IEM_INSTR_IMPL_A64__fmlslb_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* BFMLSLB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/64e06000) */
//#define IEM_INSTR_IMPL_A64__bfmlslb_z_zzzi(Zda, Zn, i3l, Zm, i3h)


/* FMLALT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/64a04400) */
//#define IEM_INSTR_IMPL_A64__fmlalt_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* BFMLALT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/64e04400) */
//#define IEM_INSTR_IMPL_A64__bfmlalt_z_zzzi(Zda, Zn, i3l, Zm, i3h)


/* FMLSLT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/64a06400) */
//#define IEM_INSTR_IMPL_A64__fmlslt_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* BFMLSLT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/64e06400) */
//#define IEM_INSTR_IMPL_A64__bfmlslt_z_zzzi(Zda, Zn, i3l, Zm, i3h)



/*
 *
 * Instruction Set & Groups: sve_fp_fmmla_lvl2 / sve_fp_fmmla / sve / A64
 *
 */

/* FMMLA  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/6420e400) */
//#define IEM_INSTR_IMPL_A64__fmmla_z32_zzz_h(Zda, Zn, Zm)


/* BFMMLA  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/6460e400) */
//#define IEM_INSTR_IMPL_A64__bfmmla_z_zzz(Zda, Zn, Zm)


/* FMMLA  <Zda>.S, <Zn>.S, <Zm>.S (ffe0fc00/64a0e400) */
//#define IEM_INSTR_IMPL_A64__fmmla_z_zzz_s(Zda, Zn, Zm)


/* FMMLA  <Zda>.D, <Zn>.D, <Zm>.D (ffe0fc00/64e0e400) */
//#define IEM_INSTR_IMPL_A64__fmmla_z_zzz_d(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_fp_fmul_by_indexed_elem_lvl2 / sve_fp_fmul_by_indexed_elem / sve / A64
 *
 */

/* FMUL  <Zd>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/64202000) */
//#define IEM_INSTR_IMPL_A64__fmul_z_zzi_h(Zd, Zn, Zm, i3l, i3h)


/* BFMUL  <Zd>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/64202800) */
//#define IEM_INSTR_IMPL_A64__bfmul_z_zzi_h(Zd, Zn, Zm, i3l, i3h)


/* FMUL  <Zd>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/64a02000) */
//#define IEM_INSTR_IMPL_A64__fmul_z_zzi_s(Zd, Zn, Zm, i2)


/* FMUL  <Zd>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/64e02000) */
//#define IEM_INSTR_IMPL_A64__fmul_z_zzi_d(Zd, Zn, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_fp_ftmad / sve_fp_pred / sve / A64
 *
 */

/* FTMAD  <Zdn>.<T>, <Zdn>.<T>, <Zm>.<T>, #<imm> (ff38fc00/65108000) */
//#define IEM_INSTR_IMPL_A64__ftmad_z_zzi(Zdn, Zm, imm3, size)



/*
 *
 * Instruction Set & Groups: sve_fp_pairwise_lvl2 / sve_fp_pairwise / sve / A64
 *
 */

/* FADDP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/64108000) */
//#define IEM_INSTR_IMPL_A64__faddp_z_p_zz(Zdn, Zm, Pg, size)


/* FMAXNMP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/64148000) */
//#define IEM_INSTR_IMPL_A64__fmaxnmp_z_p_zz(Zdn, Zm, Pg, size)


/* FMINNMP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/64158000) */
//#define IEM_INSTR_IMPL_A64__fminnmp_z_p_zz(Zdn, Zm, Pg, size)


/* FMAXP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/64168000) */
//#define IEM_INSTR_IMPL_A64__fmaxp_z_p_zz(Zdn, Zm, Pg, size)


/* FMINP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/64178000) */
//#define IEM_INSTR_IMPL_A64__fminp_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_z2op_p_zd_a / sve_fp_zeroing_unary / sve / A64
 *
 */

/* FRINTN  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/64188000) */
//#define IEM_INSTR_IMPL_A64__frintn_z_p_z_z(Zd, Zn, Pg, size)


/* FRINTP  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/6418a000) */
//#define IEM_INSTR_IMPL_A64__frintp_z_p_z_z(Zd, Zn, Pg, size)


/* FRINTM  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/6418c000) */
//#define IEM_INSTR_IMPL_A64__frintm_z_p_z_z(Zd, Zn, Pg, size)


/* FRINTZ  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/6418e000) */
//#define IEM_INSTR_IMPL_A64__frintz_z_p_z_z(Zd, Zn, Pg, size)


/* FRINTA  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/64198000) */
//#define IEM_INSTR_IMPL_A64__frinta_z_p_z_z(Zd, Zn, Pg, size)


/* FRINTX  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/6419c000) */
//#define IEM_INSTR_IMPL_A64__frintx_z_p_z_z(Zd, Zn, Pg, size)


/* FRINTI  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/6419e000) */
//#define IEM_INSTR_IMPL_A64__frinti_z_p_z_z(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_z2op_p_zd_b_0 / sve_fp_zeroing_unary / sve / A64
 *
 */

/* FCVTX  <Zd>.S, <Pg>/Z, <Zn>.D (ffffe000/641ac000) */
//#define IEM_INSTR_IMPL_A64__fcvtx_z_p_z_d2sz(Zd, Zn, Pg)


/* FCVT  <Zd>.H, <Pg>/Z, <Zn>.S (ffffe000/649a8000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_s2hz(Zd, Zn, Pg)


/* FCVT  <Zd>.S, <Pg>/Z, <Zn>.H (ffffe000/649aa000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_h2sz(Zd, Zn, Pg)


/* BFCVT  <Zd>.H, <Pg>/Z, <Zn>.S (ffffe000/649ac000) */
//#define IEM_INSTR_IMPL_A64__bfcvt_z_p_z_s2bfz(Zd, Zn, Pg)


/* FCVT  <Zd>.H, <Pg>/Z, <Zn>.D (ffffe000/64da8000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_d2hz(Zd, Zn, Pg)


/* FCVT  <Zd>.D, <Pg>/Z, <Zn>.H (ffffe000/64daa000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_h2dz(Zd, Zn, Pg)


/* FCVT  <Zd>.S, <Pg>/Z, <Zn>.D (ffffe000/64dac000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_d2sz(Zd, Zn, Pg)


/* FCVT  <Zd>.D, <Pg>/Z, <Zn>.S (ffffe000/64dae000) */
//#define IEM_INSTR_IMPL_A64__fcvt_z_p_z_s2dz(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_fp_z2op_p_zd_b_1 / sve_fp_zeroing_unary / sve / A64
 *
 */

/* FRECPX  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/641b8000) */
//#define IEM_INSTR_IMPL_A64__frecpx_z_p_z_z(Zd, Zn, Pg, size)


/* FSQRT  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/641ba000) */
//#define IEM_INSTR_IMPL_A64__fsqrt_z_p_z_z(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_fp_z2op_p_zd_c / sve_fp_zeroing_unary / sve / A64
 *
 */

/* FRINT32Z  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ffffa000/641c8000) */
//#define IEM_INSTR_IMPL_A64__frint32z_z_p_z_z(Zd, Zn, Pg, sz)


/* FRINT32X  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ffffa000/641ca000) */
//#define IEM_INSTR_IMPL_A64__frint32x_z_p_z_z(Zd, Zn, Pg, sz)


/* FRINT64Z  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ffffa000/641d8000) */
//#define IEM_INSTR_IMPL_A64__frint64z_z_p_z_z(Zd, Zn, Pg, sz)


/* FRINT64X  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ffffa000/641da000) */
//#define IEM_INSTR_IMPL_A64__frint64x_z_p_z_z(Zd, Zn, Pg, sz)


/* SCVTF  <Zd>.S, <Pg>/Z, <Zn>.S (ffffe000/649d8000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_w2sz(Zd, Zn, Pg)


/* SCVTF  <Zd>.D, <Pg>/Z, <Zn>.S (ffffe000/64dc8000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_w2dz(Zd, Zn, Pg)


/* SCVTF  <Zd>.S, <Pg>/Z, <Zn>.D (ffffe000/64dd8000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_x2sz(Zd, Zn, Pg)


/* SCVTF  <Zd>.D, <Pg>/Z, <Zn>.D (ffffe000/64ddc000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_x2dz(Zd, Zn, Pg)


/* SCVTF  <Zd>.H, <Pg>/Z, <Zn>.H (ffffe000/645cc000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_h2fp16z(Zd, Zn, Pg)


/* SCVTF  <Zd>.H, <Pg>/Z, <Zn>.S (ffffe000/645d8000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_w2fp16z(Zd, Zn, Pg)


/* SCVTF  <Zd>.H, <Pg>/Z, <Zn>.D (ffffe000/645dc000) */
//#define IEM_INSTR_IMPL_A64__scvtf_z_p_z_x2fp16z(Zd, Zn, Pg)


/* UCVTF  <Zd>.S, <Pg>/Z, <Zn>.S (ffffe000/649da000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_w2sz(Zd, Zn, Pg)


/* UCVTF  <Zd>.D, <Pg>/Z, <Zn>.S (ffffe000/64dca000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_w2dz(Zd, Zn, Pg)


/* UCVTF  <Zd>.S, <Pg>/Z, <Zn>.D (ffffe000/64dda000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_x2sz(Zd, Zn, Pg)


/* UCVTF  <Zd>.D, <Pg>/Z, <Zn>.D (ffffe000/64dde000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_x2dz(Zd, Zn, Pg)


/* UCVTF  <Zd>.H, <Pg>/Z, <Zn>.H (ffffe000/645ce000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_h2fp16z(Zd, Zn, Pg)


/* UCVTF  <Zd>.H, <Pg>/Z, <Zn>.S (ffffe000/645da000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_w2fp16z(Zd, Zn, Pg)


/* UCVTF  <Zd>.H, <Pg>/Z, <Zn>.D (ffffe000/645de000) */
//#define IEM_INSTR_IMPL_A64__ucvtf_z_p_z_x2fp16z(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_fp_z2op_p_zd_d / sve_fp_zeroing_unary / sve / A64
 *
 */

/* FLOGB  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ffff8000/641e8000) */
//#define IEM_INSTR_IMPL_A64__flogb_z_p_z_z(Zd, Zn, Pg, size)


/* FCVTZS  <Zd>.S, <Pg>/Z, <Zn>.S (ffffe000/649f8000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_s2wz(Zd, Zn, Pg)


/* FCVTZS  <Zd>.S, <Pg>/Z, <Zn>.D (ffffe000/64de8000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_d2wz(Zd, Zn, Pg)


/* FCVTZS  <Zd>.D, <Pg>/Z, <Zn>.S (ffffe000/64df8000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_s2xz(Zd, Zn, Pg)


/* FCVTZS  <Zd>.D, <Pg>/Z, <Zn>.D (ffffe000/64dfc000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_d2xz(Zd, Zn, Pg)


/* FCVTZS  <Zd>.H, <Pg>/Z, <Zn>.H (ffffe000/645ec000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_fp162hz(Zd, Zn, Pg)


/* FCVTZS  <Zd>.S, <Pg>/Z, <Zn>.H (ffffe000/645f8000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_fp162wz(Zd, Zn, Pg)


/* FCVTZS  <Zd>.D, <Pg>/Z, <Zn>.H (ffffe000/645fc000) */
//#define IEM_INSTR_IMPL_A64__fcvtzs_z_p_z_fp162xz(Zd, Zn, Pg)


/* FCVTZU  <Zd>.S, <Pg>/Z, <Zn>.S (ffffe000/649fa000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_s2wz(Zd, Zn, Pg)


/* FCVTZU  <Zd>.S, <Pg>/Z, <Zn>.D (ffffe000/64dea000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_d2wz(Zd, Zn, Pg)


/* FCVTZU  <Zd>.D, <Pg>/Z, <Zn>.S (ffffe000/64dfa000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_s2xz(Zd, Zn, Pg)


/* FCVTZU  <Zd>.D, <Pg>/Z, <Zn>.D (ffffe000/64dfe000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_d2xz(Zd, Zn, Pg)


/* FCVTZU  <Zd>.H, <Pg>/Z, <Zn>.H (ffffe000/645ee000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_fp162hz(Zd, Zn, Pg)


/* FCVTZU  <Zd>.S, <Pg>/Z, <Zn>.H (ffffe000/645fa000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_fp162wz(Zd, Zn, Pg)


/* FCVTZU  <Zd>.D, <Pg>/Z, <Zn>.H (ffffe000/645fe000) */
//#define IEM_INSTR_IMPL_A64__fcvtzu_z_p_z_fp162xz(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_int_arith_imm0 / sve_wideimm_unpred / sve / A64
 *
 */

/* ADD  <Zdn>.<T>, <Zdn>.<T>, #<imm>{, <shift>} (ff3fc000/2520c000) */
//#define IEM_INSTR_IMPL_A64__add_z_zi(Zdn, imm8, sh, size)


/* SUB  <Zdn>.<T>, <Zdn>.<T>, #<imm>{, <shift>} (ff3fc000/2521c000) */
//#define IEM_INSTR_IMPL_A64__sub_z_zi(Zdn, imm8, sh, size)


/* SUBR  <Zdn>.<T>, <Zdn>.<T>, #<imm>{, <shift>} (ff3fc000/2523c000) */
//#define IEM_INSTR_IMPL_A64__subr_z_zi(Zdn, imm8, sh, size)


/* SQADD  <Zdn>.<T>, <Zdn>.<T>, #<imm>{, <shift>} (ff3fc000/2524c000) */
//#define IEM_INSTR_IMPL_A64__sqadd_z_zi(Zdn, imm8, sh, size)


/* SQSUB  <Zdn>.<T>, <Zdn>.<T>, #<imm>{, <shift>} (ff3fc000/2526c000) */
//#define IEM_INSTR_IMPL_A64__sqsub_z_zi(Zdn, imm8, sh, size)


/* UQADD  <Zdn>.<T>, <Zdn>.<T>, #<imm>{, <shift>} (ff3fc000/2525c000) */
//#define IEM_INSTR_IMPL_A64__uqadd_z_zi(Zdn, imm8, sh, size)


/* UQSUB  <Zdn>.<T>, <Zdn>.<T>, #<imm>{, <shift>} (ff3fc000/2527c000) */
//#define IEM_INSTR_IMPL_A64__uqsub_z_zi(Zdn, imm8, sh, size)



/*
 *
 * Instruction Set & Groups: sve_int_arith_imm1 / sve_wideimm_unpred / sve / A64
 *
 */

/* SMAX  <Zdn>.<T>, <Zdn>.<T>, #<imm> (ff3fe000/2528c000) */
//#define IEM_INSTR_IMPL_A64__smax_z_zi(Zdn, imm8, size)


/* SMIN  <Zdn>.<T>, <Zdn>.<T>, #<imm> (ff3fe000/252ac000) */
//#define IEM_INSTR_IMPL_A64__smin_z_zi(Zdn, imm8, size)


/* UMAX  <Zdn>.<T>, <Zdn>.<T>, #<imm> (ff3fe000/2529c000) */
//#define IEM_INSTR_IMPL_A64__umax_z_zi(Zdn, imm8, size)


/* UMIN  <Zdn>.<T>, <Zdn>.<T>, #<imm> (ff3fe000/252bc000) */
//#define IEM_INSTR_IMPL_A64__umin_z_zi(Zdn, imm8, size)



/*
 *
 * Instruction Set & Groups: sve_int_arith_imm2 / sve_wideimm_unpred / sve / A64
 *
 */

/* MUL  <Zdn>.<T>, <Zdn>.<T>, #<imm> (ff3fe000/2530c000) */
//#define IEM_INSTR_IMPL_A64__mul_z_zi(Zdn, imm8, size)



/*
 *
 * Instruction Set & Groups: sve_int_arith_svl / sve_alloca / sve / A64
 *
 */

/* ADDSVL  <Xd|SP>, <Xn|SP>, #<imm> (ffe0f800/04205800) */
//#define IEM_INSTR_IMPL_A64__addsvl_r_ri(Rd, imm6, Rn)


/* ADDSPL  <Xd|SP>, <Xn|SP>, #<imm> (ffe0f800/04605800) */
//#define IEM_INSTR_IMPL_A64__addspl_r_ri(Rd, imm6, Rn)



/*
 *
 * Instruction Set & Groups: sve_int_arith_vl / sve_alloca / sve / A64
 *
 */

/* ADDVL  <Xd|SP>, <Xn|SP>, #<imm> (ffe0f800/04205000) */
//#define IEM_INSTR_IMPL_A64__addvl_r_ri(Rd, imm6, Rn)


/* ADDPL  <Xd|SP>, <Xn|SP>, #<imm> (ffe0f800/04605000) */
//#define IEM_INSTR_IMPL_A64__addpl_r_ri(Rd, imm6, Rn)



/*
 *
 * Instruction Set & Groups: sve_int_bin_cons_arit_0 / sve_int_unpred_arit / sve / A64
 *
 */

/* ADD  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04200000) */
//#define IEM_INSTR_IMPL_A64__add_z_zz(Zd, Zn, Zm, size)


/* SUB  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04200400) */
//#define IEM_INSTR_IMPL_A64__sub_z_zz(Zd, Zn, Zm, size)


/* ADDPT  <Zd>.D, <Zn>.D, <Zm>.D (ffe0fc00/04e00800) */
//#define IEM_INSTR_IMPL_A64__addpt_z_zz(Zd, Zn, Zm)


/* SUBPT  <Zd>.D, <Zn>.D, <Zm>.D (ffe0fc00/04e00c00) */
//#define IEM_INSTR_IMPL_A64__subpt_z_zz(Zd, Zn, Zm)


/* SQADD  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04201000) */
//#define IEM_INSTR_IMPL_A64__sqadd_z_zz(Zd, Zn, Zm, size)


/* SQSUB  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04201800) */
//#define IEM_INSTR_IMPL_A64__sqsub_z_zz(Zd, Zn, Zm, size)


/* UQADD  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04201400) */
//#define IEM_INSTR_IMPL_A64__uqadd_z_zz(Zd, Zn, Zm, size)


/* UQSUB  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04201c00) */
//#define IEM_INSTR_IMPL_A64__uqsub_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_cons_log / sve_int_unpred_logical / sve / A64
 *
 */

/* AND  <Zd>.D, <Zn>.D, <Zm>.D (ffe0fc00/04203000) */
//#define IEM_INSTR_IMPL_A64__and_z_zz(Zd, Zn, Zm)


/* ORR  <Zd>.D, <Zn>.D, <Zm>.D (ffe0fc00/04603000) */
//#define IEM_INSTR_IMPL_A64__orr_z_zz(Zd, Zn, Zm)


/* EOR  <Zd>.D, <Zn>.D, <Zm>.D (ffe0fc00/04a03000) */
//#define IEM_INSTR_IMPL_A64__eor_z_zz(Zd, Zn, Zm)


/* BIC  <Zd>.D, <Zn>.D, <Zm>.D (ffe0fc00/04e03000) */
//#define IEM_INSTR_IMPL_A64__bic_z_zz(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_int_bin_cons_misc_0_a / sve_int_adr / sve / A64
 *
 */

/* ADR  <Zd>.D, [<Zn>.D, <Zm>.D, SXTW<amount>] (ffe0f000/0420a000) */
//#define IEM_INSTR_IMPL_A64__adr_z_az_d_s32_scaled(Zd, Zn, msz, Zm)


/* ADR  <Zd>.D, [<Zn>.D, <Zm>.D, UXTW<amount>] (ffe0f000/0460a000) */
//#define IEM_INSTR_IMPL_A64__adr_z_az_d_u32_scaled(Zd, Zn, msz, Zm)


/* ADR  <Zd>.<T>, [<Zn>.<T>, <Zm>.<T>{, <mod> <amount>}] (ffa0f000/04a0a000) */
//#define IEM_INSTR_IMPL_A64__adr_z_az_sd_same_scaled(Zd, Zn, msz, Zm, sz)



/*
 *
 * Instruction Set & Groups: sve_int_bin_cons_misc_0_b / sve_int_unpred_misc / sve / A64
 *
 */

/* FTSSEL  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/0420b000) */
//#define IEM_INSTR_IMPL_A64__ftssel_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_cons_misc_0_c / sve_int_unpred_misc / sve / A64
 *
 */

/* FEXPA  <Zd>.<T>, <Zn>.<T> (ff3ffc00/0420b800) */
//#define IEM_INSTR_IMPL_A64__fexpa_z_z(Zd, Zn, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_cons_misc_0_d / sve_int_unpred_misc / sve / A64
 *
 */

/* MOVPRFX  <Zd>, <Zn> (fffffc00/0420bc00) */
//#define IEM_INSTR_IMPL_A64__movprfx_z_z(Zd, Zn)



/*
 *
 * Instruction Set & Groups: sve_int_bin_cons_shift_a / sve_int_unpred_shift / sve / A64
 *
 */

/* ASR  <Zd>.<T>, <Zn>.<T>, <Zm>.D (ff20fc00/04208000) */
//#define IEM_INSTR_IMPL_A64__asr_z_zw(Zd, Zn, Zm, size)


/* LSL  <Zd>.<T>, <Zn>.<T>, <Zm>.D (ff20fc00/04208c00) */
//#define IEM_INSTR_IMPL_A64__lsl_z_zw(Zd, Zn, Zm, size)


/* LSR  <Zd>.<T>, <Zn>.<T>, <Zm>.D (ff20fc00/04208400) */
//#define IEM_INSTR_IMPL_A64__lsr_z_zw(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_cons_shift_b / sve_int_unpred_shift / sve / A64
 *
 */

/* ASR  <Zd>.<T>, <Zn>.<T>, #<const> (ff20fc00/04209000) */
//#define IEM_INSTR_IMPL_A64__asr_z_zi(Zd, Zn, imm3, tszl, tszh)


/* LSL  <Zd>.<T>, <Zn>.<T>, #<const> (ff20fc00/04209c00) */
//#define IEM_INSTR_IMPL_A64__lsl_z_zi(Zd, Zn, imm3, tszl, tszh)


/* LSR  <Zd>.<T>, <Zn>.<T>, #<const> (ff20fc00/04209400) */
//#define IEM_INSTR_IMPL_A64__lsr_z_zi(Zd, Zn, imm3, tszl, tszh)



/*
 *
 * Instruction Set & Groups: sve_int_bin_pred_arit_0 / sve_int_pred_bin / sve / A64
 *
 */

/* ADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04000000) */
//#define IEM_INSTR_IMPL_A64__add_z_p_zz(Zdn, Zm, Pg, size)


/* SUB  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04010000) */
//#define IEM_INSTR_IMPL_A64__sub_z_p_zz(Zdn, Zm, Pg, size)


/* SUBR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04030000) */
//#define IEM_INSTR_IMPL_A64__subr_z_p_zz(Zdn, Zm, Pg, size)


/* ADDPT  <Zdn>.D, <Pg>/M, <Zdn>.D, <Zm>.D (ffffe000/04c40000) */
//#define IEM_INSTR_IMPL_A64__addpt_z_p_zz(Zdn, Zm, Pg)


/* SUBPT  <Zdn>.D, <Pg>/M, <Zdn>.D, <Zm>.D (ffffe000/04c50000) */
//#define IEM_INSTR_IMPL_A64__subpt_z_p_zz(Zdn, Zm, Pg)



/*
 *
 * Instruction Set & Groups: sve_int_bin_pred_arit_1 / sve_int_pred_bin / sve / A64
 *
 */

/* SMAX  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04080000) */
//#define IEM_INSTR_IMPL_A64__smax_z_p_zz(Zdn, Zm, Pg, size)


/* SMIN  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/040a0000) */
//#define IEM_INSTR_IMPL_A64__smin_z_p_zz(Zdn, Zm, Pg, size)


/* SABD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/040c0000) */
//#define IEM_INSTR_IMPL_A64__sabd_z_p_zz(Zdn, Zm, Pg, size)


/* UMAX  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04090000) */
//#define IEM_INSTR_IMPL_A64__umax_z_p_zz(Zdn, Zm, Pg, size)


/* UMIN  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/040b0000) */
//#define IEM_INSTR_IMPL_A64__umin_z_p_zz(Zdn, Zm, Pg, size)


/* UABD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/040d0000) */
//#define IEM_INSTR_IMPL_A64__uabd_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_pred_arit_2 / sve_int_pred_bin / sve / A64
 *
 */

/* MUL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04100000) */
//#define IEM_INSTR_IMPL_A64__mul_z_p_zz(Zdn, Zm, Pg, size)


/* SMULH  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04120000) */
//#define IEM_INSTR_IMPL_A64__smulh_z_p_zz(Zdn, Zm, Pg, size)


/* UMULH  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04130000) */
//#define IEM_INSTR_IMPL_A64__umulh_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_pred_div / sve_int_pred_bin / sve / A64
 *
 */

/* SDIV  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04140000) */
//#define IEM_INSTR_IMPL_A64__sdiv_z_p_zz(Zdn, Zm, Pg, size)


/* SDIVR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04160000) */
//#define IEM_INSTR_IMPL_A64__sdivr_z_p_zz(Zdn, Zm, Pg, size)


/* UDIV  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04150000) */
//#define IEM_INSTR_IMPL_A64__udiv_z_p_zz(Zdn, Zm, Pg, size)


/* UDIVR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04170000) */
//#define IEM_INSTR_IMPL_A64__udivr_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_pred_log / sve_int_pred_bin / sve / A64
 *
 */

/* ORR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04180000) */
//#define IEM_INSTR_IMPL_A64__orr_z_p_zz(Zdn, Zm, Pg, size)


/* EOR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04190000) */
//#define IEM_INSTR_IMPL_A64__eor_z_p_zz(Zdn, Zm, Pg, size)


/* AND  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/041a0000) */
//#define IEM_INSTR_IMPL_A64__and_z_p_zz(Zdn, Zm, Pg, size)


/* BIC  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/041b0000) */
//#define IEM_INSTR_IMPL_A64__bic_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_pred_shift_0 / sve_int_pred_shift / sve / A64
 *
 */

/* ASR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/04008000) */
//#define IEM_INSTR_IMPL_A64__asr_z_p_zi(Zdn, imm3, tszl, Pg, tszh)


/* LSL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/04038000) */
//#define IEM_INSTR_IMPL_A64__lsl_z_p_zi(Zdn, imm3, tszl, Pg, tszh)


/* ASRD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/04048000) */
//#define IEM_INSTR_IMPL_A64__asrd_z_p_zi(Zdn, imm3, tszl, Pg, tszh)


/* SQSHL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/04068000) */
//#define IEM_INSTR_IMPL_A64__sqshl_z_p_zi(Zdn, imm3, tszl, Pg, tszh)


/* SRSHR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/040c8000) */
//#define IEM_INSTR_IMPL_A64__srshr_z_p_zi(Zdn, imm3, tszl, Pg, tszh)


/* SQSHLU  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/040f8000) */
//#define IEM_INSTR_IMPL_A64__sqshlu_z_p_zi(Zdn, imm3, tszl, Pg, tszh)


/* LSR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/04018000) */
//#define IEM_INSTR_IMPL_A64__lsr_z_p_zi(Zdn, imm3, tszl, Pg, tszh)


/* UQSHL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/04078000) */
//#define IEM_INSTR_IMPL_A64__uqshl_z_p_zi(Zdn, imm3, tszl, Pg, tszh)


/* URSHR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, #<const> (ff3fe000/040d8000) */
//#define IEM_INSTR_IMPL_A64__urshr_z_p_zi(Zdn, imm3, tszl, Pg, tszh)



/*
 *
 * Instruction Set & Groups: sve_int_bin_pred_shift_1 / sve_int_pred_shift / sve / A64
 *
 */

/* ASR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04108000) */
//#define IEM_INSTR_IMPL_A64__asr_z_p_zz(Zdn, Zm, Pg, size)


/* LSL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04138000) */
//#define IEM_INSTR_IMPL_A64__lsl_z_p_zz(Zdn, Zm, Pg, size)


/* ASRR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04148000) */
//#define IEM_INSTR_IMPL_A64__asrr_z_p_zz(Zdn, Zm, Pg, size)


/* LSLR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04178000) */
//#define IEM_INSTR_IMPL_A64__lslr_z_p_zz(Zdn, Zm, Pg, size)


/* LSR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04118000) */
//#define IEM_INSTR_IMPL_A64__lsr_z_p_zz(Zdn, Zm, Pg, size)


/* LSRR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/04158000) */
//#define IEM_INSTR_IMPL_A64__lsrr_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_bin_pred_shift_2 / sve_int_pred_shift / sve / A64
 *
 */

/* ASR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.D (ff3fe000/04188000) */
//#define IEM_INSTR_IMPL_A64__asr_z_p_zw(Zdn, Zm, Pg, size)


/* LSL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.D (ff3fe000/041b8000) */
//#define IEM_INSTR_IMPL_A64__lsl_z_p_zw(Zdn, Zm, Pg, size)


/* LSR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.D (ff3fe000/04198000) */
//#define IEM_INSTR_IMPL_A64__lsr_z_p_zw(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_break / sve_pred_gen_c / sve / A64
 *
 */

/* BRKA  <Pd>.B, <Pg>/<ZM>, <Pn>.B (ffffc200/25104000) */
//#define IEM_INSTR_IMPL_A64__brka_p_p_p(Pd, M, Pn, Pg)


/* BRKAS  <Pd>.B, <Pg>/Z, <Pn>.B (ffffc210/25504000) */
//#define IEM_INSTR_IMPL_A64__brkas_p_p_p_z(Pd, Pn, Pg)


/* BRKB  <Pd>.B, <Pg>/<ZM>, <Pn>.B (ffffc200/25904000) */
//#define IEM_INSTR_IMPL_A64__brkb_p_p_p(Pd, M, Pn, Pg)


/* BRKBS  <Pd>.B, <Pg>/Z, <Pn>.B (ffffc210/25d04000) */
//#define IEM_INSTR_IMPL_A64__brkbs_p_p_p_z(Pd, Pn, Pg)



/*
 *
 * Instruction Set & Groups: sve_int_brkn / sve_pred_gen_c / sve / A64
 *
 */

/* BRKN  <Pdm>.B, <Pg>/Z, <Pn>.B, <Pdm>.B (ffffc210/25184000) */
//#define IEM_INSTR_IMPL_A64__brkn_p_p_pp(Pdm, Pn, Pg)


/* BRKNS  <Pdm>.B, <Pg>/Z, <Pn>.B, <Pdm>.B (ffffc210/25584000) */
//#define IEM_INSTR_IMPL_A64__brkns_p_p_pp(Pdm, Pn, Pg)



/*
 *
 * Instruction Set & Groups: sve_int_brkp / sve_pred_gen_b / sve / A64
 *
 */

/* BRKPA  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/2500c000) */
//#define IEM_INSTR_IMPL_A64__brkpa_p_p_pp(Pd, Pn, Pg, Pm)


/* BRKPAS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/2540c000) */
//#define IEM_INSTR_IMPL_A64__brkpas_p_p_pp(Pd, Pn, Pg, Pm)


/* BRKPB  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/2500c010) */
//#define IEM_INSTR_IMPL_A64__brkpb_p_p_pp(Pd, Pn, Pg, Pm)


/* BRKPBS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/2540c010) */
//#define IEM_INSTR_IMPL_A64__brkpbs_p_p_pp(Pd, Pn, Pg, Pm)



/*
 *
 * Instruction Set & Groups: sve_int_cmp_0 / sve_cmpvec / sve / A64
 *
 */

/* CMPHS  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/24000000) */
//#define IEM_INSTR_IMPL_A64__cmphs_p_p_zz(Pd, Zn, Pg, Zm, size)


/* CMPGE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/24008000) */
//#define IEM_INSTR_IMPL_A64__cmpge_p_p_zz(Pd, Zn, Pg, Zm, size)


/* CMPEQ  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/24002000) */
//#define IEM_INSTR_IMPL_A64__cmpeq_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPEQ  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/2400a000) */
//#define IEM_INSTR_IMPL_A64__cmpeq_p_p_zz(Pd, Zn, Pg, Zm, size)


/* CMPHI  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/24000010) */
//#define IEM_INSTR_IMPL_A64__cmphi_p_p_zz(Pd, Zn, Pg, Zm, size)


/* CMPGT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/24008010) */
//#define IEM_INSTR_IMPL_A64__cmpgt_p_p_zz(Pd, Zn, Pg, Zm, size)


/* CMPNE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/24002010) */
//#define IEM_INSTR_IMPL_A64__cmpne_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPNE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/2400a010) */
//#define IEM_INSTR_IMPL_A64__cmpne_p_p_zz(Pd, Zn, Pg, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_cmp_1 / sve_cmpvec / sve / A64
 *
 */

/* CMPGE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/24004000) */
//#define IEM_INSTR_IMPL_A64__cmpge_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPHS  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/2400c000) */
//#define IEM_INSTR_IMPL_A64__cmphs_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPGT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/24004010) */
//#define IEM_INSTR_IMPL_A64__cmpgt_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPHI  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/2400c010) */
//#define IEM_INSTR_IMPL_A64__cmphi_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPLT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/24006000) */
//#define IEM_INSTR_IMPL_A64__cmplt_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPLO  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/2400e000) */
//#define IEM_INSTR_IMPL_A64__cmplo_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPLE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/24006010) */
//#define IEM_INSTR_IMPL_A64__cmple_p_p_zw(Pd, Zn, Pg, Zm, size)


/* CMPLS  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.D (ff20e010/2400e010) */
//#define IEM_INSTR_IMPL_A64__cmpls_p_p_zw(Pd, Zn, Pg, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_count / sve_countelt / sve / A64
 *
 */

/* CNTB  <Xd>{, <pattern>{, MUL #<imm>}} (fff0fc00/0420e000) */
//#define IEM_INSTR_IMPL_A64__cntb_r_s(Rd, pattern, imm4)


/* CNTH  <Xd>{, <pattern>{, MUL #<imm>}} (fff0fc00/0460e000) */
//#define IEM_INSTR_IMPL_A64__cnth_r_s(Rd, pattern, imm4)


/* CNTW  <Xd>{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0e000) */
//#define IEM_INSTR_IMPL_A64__cntw_r_s(Rd, pattern, imm4)


/* CNTD  <Xd>{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0e000) */
//#define IEM_INSTR_IMPL_A64__cntd_r_s(Rd, pattern, imm4)



/*
 *
 * Instruction Set & Groups: sve_int_count_r / sve_pred_count_b / sve / A64
 *
 */

/* INCP  <Xdn>, <Pm>.<T> (ff3ffe00/252c8800) */
//#define IEM_INSTR_IMPL_A64__incp_r_p_r(Rdn, Pm, size)


/* DECP  <Xdn>, <Pm>.<T> (ff3ffe00/252d8800) */
//#define IEM_INSTR_IMPL_A64__decp_r_p_r(Rdn, Pm, size)



/*
 *
 * Instruction Set & Groups: sve_int_count_r_sat / sve_pred_count_b / sve / A64
 *
 */

/* SQINCP  <Xdn>, <Pm>.<T>, <Wdn> (ff3ffe00/25288800) */
//#define IEM_INSTR_IMPL_A64__sqincp_r_p_r_sx(Rdn, Pm, size)


/* UQINCP  <Wdn>, <Pm>.<T> (ff3ffe00/25298800) */
//#define IEM_INSTR_IMPL_A64__uqincp_r_p_r_uw(Rdn, Pm, size)


/* SQDECP  <Xdn>, <Pm>.<T>, <Wdn> (ff3ffe00/252a8800) */
//#define IEM_INSTR_IMPL_A64__sqdecp_r_p_r_sx(Rdn, Pm, size)


/* UQDECP  <Wdn>, <Pm>.<T> (ff3ffe00/252b8800) */
//#define IEM_INSTR_IMPL_A64__uqdecp_r_p_r_uw(Rdn, Pm, size)


/* SQINCP  <Xdn>, <Pm>.<T> (ff3ffe00/25288c00) */
//#define IEM_INSTR_IMPL_A64__sqincp_r_p_r_x(Rdn, Pm, size)


/* SQDECP  <Xdn>, <Pm>.<T> (ff3ffe00/252a8c00) */
//#define IEM_INSTR_IMPL_A64__sqdecp_r_p_r_x(Rdn, Pm, size)


/* UQINCP  <Xdn>, <Pm>.<T> (ff3ffe00/25298c00) */
//#define IEM_INSTR_IMPL_A64__uqincp_r_p_r_x(Rdn, Pm, size)


/* UQDECP  <Xdn>, <Pm>.<T> (ff3ffe00/252b8c00) */
//#define IEM_INSTR_IMPL_A64__uqdecp_r_p_r_x(Rdn, Pm, size)



/*
 *
 * Instruction Set & Groups: sve_int_count_v / sve_pred_count_b / sve / A64
 *
 */

/* INCP  <Zdn>.<T>, <Pm>.<T> (ff3ffe00/252c8000) */
//#define IEM_INSTR_IMPL_A64__incp_z_p_z(Zdn, Pm, size)


/* DECP  <Zdn>.<T>, <Pm>.<T> (ff3ffe00/252d8000) */
//#define IEM_INSTR_IMPL_A64__decp_z_p_z(Zdn, Pm, size)



/*
 *
 * Instruction Set & Groups: sve_int_count_v_sat / sve_pred_count_b / sve / A64
 *
 */

/* SQINCP  <Zdn>.<T>, <Pm>.<T> (ff3ffe00/25288000) */
//#define IEM_INSTR_IMPL_A64__sqincp_z_p_z(Zdn, Pm, size)


/* SQDECP  <Zdn>.<T>, <Pm>.<T> (ff3ffe00/252a8000) */
//#define IEM_INSTR_IMPL_A64__sqdecp_z_p_z(Zdn, Pm, size)


/* UQINCP  <Zdn>.<T>, <Pm>.<T> (ff3ffe00/25298000) */
//#define IEM_INSTR_IMPL_A64__uqincp_z_p_z(Zdn, Pm, size)


/* UQDECP  <Zdn>.<T>, <Pm>.<T> (ff3ffe00/252b8000) */
//#define IEM_INSTR_IMPL_A64__uqdecp_z_p_z(Zdn, Pm, size)



/*
 *
 * Instruction Set & Groups: sve_int_countvlv0 / sve_countelt / sve / A64
 *
 */

/* SQINCH  <Zdn>.H{, <pattern>{, MUL #<imm>}} (fff0fc00/0460c000) */
//#define IEM_INSTR_IMPL_A64__sqinch_z_zs(Zdn, pattern, imm4)


/* SQDECH  <Zdn>.H{, <pattern>{, MUL #<imm>}} (fff0fc00/0460c800) */
//#define IEM_INSTR_IMPL_A64__sqdech_z_zs(Zdn, pattern, imm4)


/* UQINCH  <Zdn>.H{, <pattern>{, MUL #<imm>}} (fff0fc00/0460c400) */
//#define IEM_INSTR_IMPL_A64__uqinch_z_zs(Zdn, pattern, imm4)


/* UQDECH  <Zdn>.H{, <pattern>{, MUL #<imm>}} (fff0fc00/0460cc00) */
//#define IEM_INSTR_IMPL_A64__uqdech_z_zs(Zdn, pattern, imm4)


/* SQINCW  <Zdn>.S{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0c000) */
//#define IEM_INSTR_IMPL_A64__sqincw_z_zs(Zdn, pattern, imm4)


/* SQDECW  <Zdn>.S{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0c800) */
//#define IEM_INSTR_IMPL_A64__sqdecw_z_zs(Zdn, pattern, imm4)


/* UQINCW  <Zdn>.S{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0c400) */
//#define IEM_INSTR_IMPL_A64__uqincw_z_zs(Zdn, pattern, imm4)


/* UQDECW  <Zdn>.S{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0cc00) */
//#define IEM_INSTR_IMPL_A64__uqdecw_z_zs(Zdn, pattern, imm4)


/* SQINCD  <Zdn>.D{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0c000) */
//#define IEM_INSTR_IMPL_A64__sqincd_z_zs(Zdn, pattern, imm4)


/* SQDECD  <Zdn>.D{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0c800) */
//#define IEM_INSTR_IMPL_A64__sqdecd_z_zs(Zdn, pattern, imm4)


/* UQINCD  <Zdn>.D{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0c400) */
//#define IEM_INSTR_IMPL_A64__uqincd_z_zs(Zdn, pattern, imm4)


/* UQDECD  <Zdn>.D{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0cc00) */
//#define IEM_INSTR_IMPL_A64__uqdecd_z_zs(Zdn, pattern, imm4)



/*
 *
 * Instruction Set & Groups: sve_int_countvlv1 / sve_countelt / sve / A64
 *
 */

/* INCH  <Zdn>.H{, <pattern>{, MUL #<imm>}} (fff0fc00/0470c000) */
//#define IEM_INSTR_IMPL_A64__inch_z_zs(Zdn, pattern, imm4)


/* DECH  <Zdn>.H{, <pattern>{, MUL #<imm>}} (fff0fc00/0470c400) */
//#define IEM_INSTR_IMPL_A64__dech_z_zs(Zdn, pattern, imm4)


/* INCW  <Zdn>.S{, <pattern>{, MUL #<imm>}} (fff0fc00/04b0c000) */
//#define IEM_INSTR_IMPL_A64__incw_z_zs(Zdn, pattern, imm4)


/* DECW  <Zdn>.S{, <pattern>{, MUL #<imm>}} (fff0fc00/04b0c400) */
//#define IEM_INSTR_IMPL_A64__decw_z_zs(Zdn, pattern, imm4)


/* INCD  <Zdn>.D{, <pattern>{, MUL #<imm>}} (fff0fc00/04f0c000) */
//#define IEM_INSTR_IMPL_A64__incd_z_zs(Zdn, pattern, imm4)


/* DECD  <Zdn>.D{, <pattern>{, MUL #<imm>}} (fff0fc00/04f0c400) */
//#define IEM_INSTR_IMPL_A64__decd_z_zs(Zdn, pattern, imm4)



/*
 *
 * Instruction Set & Groups: sve_int_cterm / sve_cmpgpr / sve / A64
 *
 */

/* CTERMEQ  <R><n>, <R><m> (ffa0fc1f/25a02000) */
//#define IEM_INSTR_IMPL_A64__ctermeq_rr(Rn, Rm, sz)


/* CTERMNE  <R><n>, <R><m> (ffa0fc1f/25a02010) */
//#define IEM_INSTR_IMPL_A64__ctermne_rr(Rn, Rm, sz)



/*
 *
 * Instruction Set & Groups: sve_int_ctr_to_mask / sve_while_pn / sve / A64
 *
 */

/* PEXT  <Pd>.<T>, <PNn>[<imm>] (ff3ffc10/25207010) */
//#define IEM_INSTR_IMPL_A64__pext_pn_rr(Pd, PNn, imm2, size)


/* PEXT  { <Pd1>.<T>, <Pd2>.<T> }, <PNn>[<imm>] (ff3ffe10/25207410) */
//#define IEM_INSTR_IMPL_A64__pext_pp_rr(Pd, PNn, i1, size)



/*
 *
 * Instruction Set & Groups: sve_int_dup_fpimm / sve_wideimm_unpred / sve / A64
 *
 */

/* FDUP  <Zd>.<T>, #<const> (ff3fe000/2539c000) */
//#define IEM_INSTR_IMPL_A64__fdup_z_i(Zd, imm8, size)



/*
 *
 * Instruction Set & Groups: sve_int_dup_fpimm_pred / sve_wideimm_pred / sve / A64
 *
 */

/* FCPY  <Zd>.<T>, <Pg>/M, #<const> (ff30e000/0510c000) */
//#define IEM_INSTR_IMPL_A64__fcpy_z_p_i(Zd, imm8, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_dup_imm / sve_wideimm_unpred / sve / A64
 *
 */

/* DUP  <Zd>.<T>, #<imm>{, <shift>} (ff3fc000/2538c000) */
//#define IEM_INSTR_IMPL_A64__dup_z_i(Zd, imm8, sh, size)



/*
 *
 * Instruction Set & Groups: sve_int_dup_imm_pred / sve_wideimm_pred / sve / A64
 *
 */

/* CPY  <Zd>.<T>, <Pg>/Z, #<imm>{, <shift>} (ff30c000/05100000) */
//#define IEM_INSTR_IMPL_A64__cpy_z_o_i(Zd, imm8, sh, Pg, size)


/* CPY  <Zd>.<T>, <Pg>/M, #<imm>{, <shift>} (ff30c000/05104000) */
//#define IEM_INSTR_IMPL_A64__cpy_z_p_i(Zd, imm8, sh, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_dup_mask_imm / sve_maskimm / sve / A64
 *
 */

/* DUPM  <Zd>.<T>, #<const> (fffc0000/05c00000) */
//#define IEM_INSTR_IMPL_A64__dupm_z_i(Zd, imm13)



/*
 *
 * Instruction Set & Groups: sve_int_index_ii / sve_index / sve / A64
 *
 */

/* INDEX  <Zd>.<T>, #<imm1>, #<imm2> (ff20fc00/04204000) */
//#define IEM_INSTR_IMPL_A64__index_z_ii(Zd, imm5, imm5b, size)



/*
 *
 * Instruction Set & Groups: sve_int_index_ir / sve_index / sve / A64
 *
 */

/* INDEX  <Zd>.<T>, #<imm>, <R><m> (ff20fc00/04204800) */
//#define IEM_INSTR_IMPL_A64__index_z_ir(Zd, imm5, Rm, size)



/*
 *
 * Instruction Set & Groups: sve_int_index_ri / sve_index / sve / A64
 *
 */

/* INDEX  <Zd>.<T>, <R><n>, #<imm> (ff20fc00/04204400) */
//#define IEM_INSTR_IMPL_A64__index_z_ri(Zd, Rn, imm5, size)



/*
 *
 * Instruction Set & Groups: sve_int_index_rr / sve_index / sve / A64
 *
 */

/* INDEX  <Zd>.<T>, <R><n>, <R><m> (ff20fc00/04204c00) */
//#define IEM_INSTR_IMPL_A64__index_z_rr(Zd, Rn, Rm, size)



/*
 *
 * Instruction Set & Groups: sve_int_log_imm / sve_maskimm / sve / A64
 *
 */

/* ORR  <Zdn>.<T>, <Zdn>.<T>, #<const> (fffc0000/05000000) */
//#define IEM_INSTR_IMPL_A64__orr_z_zi(Zdn, imm13)


/* EOR  <Zdn>.<T>, <Zdn>.<T>, #<const> (fffc0000/05400000) */
//#define IEM_INSTR_IMPL_A64__eor_z_zi(Zdn, imm13)


/* AND  <Zdn>.<T>, <Zdn>.<T>, #<const> (fffc0000/05800000) */
//#define IEM_INSTR_IMPL_A64__and_z_zi(Zdn, imm13)



/*
 *
 * Instruction Set & Groups: sve_int_mladdsub_vvv_pred / sve_int_muladd_pred / sve / A64
 *
 */

/* MAD  <Zdn>.<T>, <Pg>/M, <Zm>.<T>, <Za>.<T> (ff20e000/0400c000) */
//#define IEM_INSTR_IMPL_A64__mad_z_p_zzz(Zdn, Za, Pg, Zm, size)


/* MSB  <Zdn>.<T>, <Pg>/M, <Zm>.<T>, <Za>.<T> (ff20e000/0400e000) */
//#define IEM_INSTR_IMPL_A64__msb_z_p_zzz(Zdn, Za, Pg, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_mlas_vvv_pred / sve_int_muladd_pred / sve / A64
 *
 */

/* MLA  <Zda>.<T>, <Pg>/M, <Zn>.<T>, <Zm>.<T> (ff20e000/04004000) */
//#define IEM_INSTR_IMPL_A64__mla_z_p_zzz(Zda, Zn, Pg, Zm, size)


/* MLS  <Zda>.<T>, <Pg>/M, <Zn>.<T>, <Zm>.<T> (ff20e000/04006000) */
//#define IEM_INSTR_IMPL_A64__mls_z_p_zzz(Zda, Zn, Pg, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_mov_p2v / sve_perm_unpred_d / sve / A64
 *
 */

/* PMOV  <Zd>, <Pn>.B (fffffe00/052b3800) */
//#define IEM_INSTR_IMPL_A64__pmov_z_pi_b(Zd, Pn)


/* PMOV  <Zd>{[<imm>]}, <Pn>.H (fffdfe00/052d3800) */
//#define IEM_INSTR_IMPL_A64__pmov_z_pi_h(Zd, Pn, i1)


/* PMOV  <Zd>{[<imm>]}, <Pn>.S (fff9fe00/05693800) */
//#define IEM_INSTR_IMPL_A64__pmov_z_pi_s(Zd, Pn, i2)


/* PMOV  <Zd>{[<imm>]}, <Pn>.D (ffb9fe00/05a93800) */
//#define IEM_INSTR_IMPL_A64__pmov_z_pi_d(Zd, Pn, i3l, i3h)



/*
 *
 * Instruction Set & Groups: sve_int_mov_v2p / sve_perm_unpred_d / sve / A64
 *
 */

/* PMOV  <Pd>.B, <Zn> (fffffc10/052a3800) */
//#define IEM_INSTR_IMPL_A64__pmov_p_zi_b(Pd, Zn)


/* PMOV  <Pd>.H, <Zn>{[<imm>]} (fffdfc10/052c3800) */
//#define IEM_INSTR_IMPL_A64__pmov_p_zi_h(Pd, Zn, i1)


/* PMOV  <Pd>.S, <Zn>{[<imm>]} (fff9fc10/05683800) */
//#define IEM_INSTR_IMPL_A64__pmov_p_zi_s(Pd, Zn, i2)


/* PMOV  <Pd>.D, <Zn>{[<imm>]} (ffb9fc10/05a83800) */
//#define IEM_INSTR_IMPL_A64__pmov_p_zi_d(Pd, Zn, i3l, i3h)



/*
 *
 * Instruction Set & Groups: sve_int_movprfx_pred / sve_int_pred_red / sve / A64
 *
 */

/* MOVPRFX  <Zd>.<T>, <Pg>/<ZM>, <Zn>.<T> (ff3ee000/04102000) */
//#define IEM_INSTR_IMPL_A64__movprfx_z_p_z(Zd, Zn, Pg, M, size)



/*
 *
 * Instruction Set & Groups: sve_int_mul_b / sve_int_unpred_arit_b / sve / A64
 *
 */

/* MUL  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04206000) */
//#define IEM_INSTR_IMPL_A64__mul_z_zz(Zd, Zn, Zm, size)


/* PMUL  <Zd>.B, <Zn>.B, <Zm>.B (ffe0fc00/04206400) */
//#define IEM_INSTR_IMPL_A64__pmul_z_zz(Zd, Zn, Zm)


/* SMULH  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04206800) */
//#define IEM_INSTR_IMPL_A64__smulh_z_zz(Zd, Zn, Zm, size)


/* UMULH  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04206c00) */
//#define IEM_INSTR_IMPL_A64__umulh_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_pcount_pn / sve_pred_count_a / sve / A64
 *
 */

/* CNTP  <Xd>, <PNn>.<T>, <vl> (ff3ffa00/25208200) */
//#define IEM_INSTR_IMPL_A64__cntp_r_pn(Rd, PNn, vl, size)



/*
 *
 * Instruction Set & Groups: sve_int_pcount_pred / sve_pred_count_a / sve / A64
 *
 */

/* CNTP  <Xd>, <Pg>, <Pn>.<T> (ff3fc200/25208000) */
//#define IEM_INSTR_IMPL_A64__cntp_r_p_p(Rd, Pn, Pg, size)


/* FIRSTP  <Xd>, <Pg>, <Pn>.<T> (ff3fc200/25218000) */
//#define IEM_INSTR_IMPL_A64__firstp_r_p_p(Rd, Pn, Pg, size)


/* LASTP  <Xd>, <Pg>, <Pn>.<T> (ff3fc200/25228000) */
//#define IEM_INSTR_IMPL_A64__lastp_r_p_p(Rd, Pn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_bin_long_perm_zz / sve_perm_inter_long / sve / A64
 *
 */

/* ZIP1  <Zd>.Q, <Zn>.Q, <Zm>.Q (ffe0fc00/05a00000) */
//#define IEM_INSTR_IMPL_A64__zip1_z_zz_q(Zd, Zn, Zm)


/* UZP1  <Zd>.Q, <Zn>.Q, <Zm>.Q (ffe0fc00/05a00800) */
//#define IEM_INSTR_IMPL_A64__uzp1_z_zz_q(Zd, Zn, Zm)


/* TRN1  <Zd>.Q, <Zn>.Q, <Zm>.Q (ffe0fc00/05a01800) */
//#define IEM_INSTR_IMPL_A64__trn1_z_zz_q(Zd, Zn, Zm)


/* ZIP2  <Zd>.Q, <Zn>.Q, <Zm>.Q (ffe0fc00/05a00400) */
//#define IEM_INSTR_IMPL_A64__zip2_z_zz_q(Zd, Zn, Zm)


/* UZP2  <Zd>.Q, <Zn>.Q, <Zm>.Q (ffe0fc00/05a00c00) */
//#define IEM_INSTR_IMPL_A64__uzp2_z_zz_q(Zd, Zn, Zm)


/* TRN2  <Zd>.Q, <Zn>.Q, <Zm>.Q (ffe0fc00/05a01c00) */
//#define IEM_INSTR_IMPL_A64__trn2_z_zz_q(Zd, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_int_perm_bin_perm_pp / sve_perm_predicates / sve / A64
 *
 */

/* ZIP1  <Pd>.<T>, <Pn>.<T>, <Pm>.<T> (ff30fe10/05204000) */
//#define IEM_INSTR_IMPL_A64__zip1_p_pp(Pd, Pn, Pm, size)


/* UZP1  <Pd>.<T>, <Pn>.<T>, <Pm>.<T> (ff30fe10/05204800) */
//#define IEM_INSTR_IMPL_A64__uzp1_p_pp(Pd, Pn, Pm, size)


/* TRN1  <Pd>.<T>, <Pn>.<T>, <Pm>.<T> (ff30fe10/05205000) */
//#define IEM_INSTR_IMPL_A64__trn1_p_pp(Pd, Pn, Pm, size)


/* ZIP2  <Pd>.<T>, <Pn>.<T>, <Pm>.<T> (ff30fe10/05204400) */
//#define IEM_INSTR_IMPL_A64__zip2_p_pp(Pd, Pn, Pm, size)


/* UZP2  <Pd>.<T>, <Pn>.<T>, <Pm>.<T> (ff30fe10/05204c00) */
//#define IEM_INSTR_IMPL_A64__uzp2_p_pp(Pd, Pn, Pm, size)


/* TRN2  <Pd>.<T>, <Pn>.<T>, <Pm>.<T> (ff30fe10/05205400) */
//#define IEM_INSTR_IMPL_A64__trn2_p_pp(Pd, Pn, Pm, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_bin_perm_zz / sve_perm_inter / sve / A64
 *
 */

/* ZIP1  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/05206000) */
//#define IEM_INSTR_IMPL_A64__zip1_z_zz(Zd, Zn, Zm, size)


/* UZP1  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/05206800) */
//#define IEM_INSTR_IMPL_A64__uzp1_z_zz(Zd, Zn, Zm, size)


/* TRN1  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/05207000) */
//#define IEM_INSTR_IMPL_A64__trn1_z_zz(Zd, Zn, Zm, size)


/* ZIP2  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/05206400) */
//#define IEM_INSTR_IMPL_A64__zip2_z_zz(Zd, Zn, Zm, size)


/* UZP2  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/05206c00) */
//#define IEM_INSTR_IMPL_A64__uzp2_z_zz(Zd, Zn, Zm, size)


/* TRN2  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/05207400) */
//#define IEM_INSTR_IMPL_A64__trn2_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_binquads / sve_perm_quads_b / sve / A64
 *
 */

/* ZIPQ1  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4400e000) */
//#define IEM_INSTR_IMPL_A64__zipq1_z_zz(Zd, Zn, Zm, size)


/* UZPQ1  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4400e800) */
//#define IEM_INSTR_IMPL_A64__uzpq1_z_zz(Zd, Zn, Zm, size)


/* TBLQ  <Zd>.<T>, { <Zn>.<T> }, <Zm>.<T> (ff20fc00/4400f800) */
//#define IEM_INSTR_IMPL_A64__tblq_z_zz(Zd, Zn, Zm, size)


/* ZIPQ2  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4400e400) */
//#define IEM_INSTR_IMPL_A64__zipq2_z_zz(Zd, Zn, Zm, size)


/* UZPQ2  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4400ec00) */
//#define IEM_INSTR_IMPL_A64__uzpq2_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_clast_rz / sve_perm_pred / sve / A64
 *
 */

/* CLASTA  <R><dn>, <Pg>, <R><dn>, <Zm>.<T> (ff3fe000/0530a000) */
//#define IEM_INSTR_IMPL_A64__clasta_r_p_z(Rdn, Zm, Pg, size)


/* CLASTB  <R><dn>, <Pg>, <R><dn>, <Zm>.<T> (ff3fe000/0531a000) */
//#define IEM_INSTR_IMPL_A64__clastb_r_p_z(Rdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_clast_vz / sve_perm_pred / sve / A64
 *
 */

/* CLASTA  <V><dn>, <Pg>, <V><dn>, <Zm>.<T> (ff3fe000/052a8000) */
//#define IEM_INSTR_IMPL_A64__clasta_v_p_z(Vdn, Zm, Pg, size)


/* CLASTB  <V><dn>, <Pg>, <V><dn>, <Zm>.<T> (ff3fe000/052b8000) */
//#define IEM_INSTR_IMPL_A64__clastb_v_p_z(Vdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_clast_zz / sve_perm_pred / sve / A64
 *
 */

/* CLASTA  <Zdn>.<T>, <Pg>, <Zdn>.<T>, <Zm>.<T> (ff3fe000/05288000) */
//#define IEM_INSTR_IMPL_A64__clasta_z_p_zz(Zdn, Zm, Pg, size)


/* CLASTB  <Zdn>.<T>, <Pg>, <Zdn>.<T>, <Zm>.<T> (ff3fe000/05298000) */
//#define IEM_INSTR_IMPL_A64__clastb_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_compact / sve_perm_pred / sve / A64
 *
 */

/* COMPACT  <Zd>.<T>, <Pg>, <Zn>.<T> (ffbfe000/05218000) */
//#define IEM_INSTR_IMPL_A64__compact_z_p_z_s(Zd, Zn, Pg, sz)


/* COMPACT  <Zd>.<T>, <Pg>, <Zn>.<T> (ffbfe000/05a18000) */
//#define IEM_INSTR_IMPL_A64__compact_z_p_z(Zd, Zn, Pg, sz)



/*
 *
 * Instruction Set & Groups: sve_int_perm_cpy_r / sve_perm_pred / sve / A64
 *
 */

/* CPY  <Zd>.<T>, <Pg>/M, <R><n|SP> (ff3fe000/0528a000) */
//#define IEM_INSTR_IMPL_A64__cpy_z_p_r(Zd, Rn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_cpy_v / sve_perm_pred / sve / A64
 *
 */

/* CPY  <Zd>.<T>, <Pg>/M, <V><n> (ff3fe000/05208000) */
//#define IEM_INSTR_IMPL_A64__cpy_z_p_v(Zd, Vn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_dup_i / sve_perm_unpred_a / sve / A64
 *
 */

/* DUP  <Zd>.<T>, <Zn>.<T>[<imm>] (ff20fc00/05202000) */
//#define IEM_INSTR_IMPL_A64__dup_z_zi(Zd, Zn, tsz, imm2)



/*
 *
 * Instruction Set & Groups: sve_int_perm_dup_r / sve_perm_unpred_d / sve / A64
 *
 */

/* DUP  <Zd>.<T>, <R><n|SP> (ff3ffc00/05203800) */
//#define IEM_INSTR_IMPL_A64__dup_z_r(Zd, Rn, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_dupq_i / sve_perm_quads_a / sve / A64
 *
 */

/* DUPQ  <Zd>.<T>, <Zn>.<T>[<imm>] (ffe0fc00/05202400) */
//#define IEM_INSTR_IMPL_A64__dupq_z_zi(Zd, Zn, tsz, i1)



/*
 *
 * Instruction Set & Groups: sve_int_perm_expand / sve_perm_pred / sve / A64
 *
 */

/* EXPAND  <Zd>.<T>, <Pg>, <Zn>.<T> (ff3fe000/05318000) */
//#define IEM_INSTR_IMPL_A64__expand_z_p_z(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_extq / sve_perm_quads_a / sve / A64
 *
 */

/* EXTQ  <Zdn>.B, <Zdn>.B, <Zm>.B, #<imm> (fff0fc00/05602400) */
//#define IEM_INSTR_IMPL_A64__extq_z_zi_des(Zdn, Zm, imm4)



/*
 *
 * Instruction Set & Groups: sve_int_perm_extract_i / sve_perm_extract / sve / A64
 *
 */

/* EXT  <Zdn>.B, <Zdn>.B, <Zm>.B, #<imm> (ffe0e000/05200000) */
//#define IEM_INSTR_IMPL_A64__ext_z_zi_des(Zdn, Zm, imm8l, imm8h)



/*
 *
 * Instruction Set & Groups: sve_int_perm_insrs / sve_perm_unpred_d / sve / A64
 *
 */

/* INSR  <Zdn>.<T>, <R><m> (ff3ffc00/05243800) */
//#define IEM_INSTR_IMPL_A64__insr_z_r(Zdn, Rm, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_insrv / sve_perm_unpred_d / sve / A64
 *
 */

/* INSR  <Zdn>.<T>, <V><m> (ff3ffc00/05343800) */
//#define IEM_INSTR_IMPL_A64__insr_z_v(Zdn, Vm, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_last_r / sve_perm_pred / sve / A64
 *
 */

/* LASTA  <R><d>, <Pg>, <Zn>.<T> (ff3fe000/0520a000) */
//#define IEM_INSTR_IMPL_A64__lasta_r_p_z(Rd, Zn, Pg, size)


/* LASTB  <R><d>, <Pg>, <Zn>.<T> (ff3fe000/0521a000) */
//#define IEM_INSTR_IMPL_A64__lastb_r_p_z(Rd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_last_v / sve_perm_pred / sve / A64
 *
 */

/* LASTA  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/05228000) */
//#define IEM_INSTR_IMPL_A64__lasta_v_p_z(Vd, Zn, Pg, size)


/* LASTB  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/05238000) */
//#define IEM_INSTR_IMPL_A64__lastb_v_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_punpk / sve_perm_predicates / sve / A64
 *
 */

/* PUNPKLO  <Pd>.H, <Pn>.B (fffffe10/05304000) */
//#define IEM_INSTR_IMPL_A64__punpklo_p_p(Pd, Pn)


/* PUNPKHI  <Pd>.H, <Pn>.B (fffffe10/05314000) */
//#define IEM_INSTR_IMPL_A64__punpkhi_p_p(Pd, Pn)



/*
 *
 * Instruction Set & Groups: sve_int_perm_rev / sve_perm_pred / sve / A64
 *
 */

/* REVB  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/05248000) */
//#define IEM_INSTR_IMPL_A64__revb_z_z_m(Zd, Zn, Pg, size)


/* REVB  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0524a000) */
//#define IEM_INSTR_IMPL_A64__revb_z_z_z(Zd, Zn, Pg, size)


/* REVH  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/05258000) */
//#define IEM_INSTR_IMPL_A64__revh_z_z_m(Zd, Zn, Pg, size)


/* REVH  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0525a000) */
//#define IEM_INSTR_IMPL_A64__revh_z_z_z(Zd, Zn, Pg, size)


/* REVW  <Zd>.D, <Pg>/M, <Zn>.D (ff3fe000/05268000) */
//#define IEM_INSTR_IMPL_A64__revw_z_z_m(Zd, Zn, Pg, size)


/* REVW  <Zd>.D, <Pg>/Z, <Zn>.D (ff3fe000/0526a000) */
//#define IEM_INSTR_IMPL_A64__revw_z_z_z(Zd, Zn, Pg, size)


/* RBIT  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/05278000) */
//#define IEM_INSTR_IMPL_A64__rbit_z_p_z_m(Zd, Zn, Pg, size)


/* RBIT  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0527a000) */
//#define IEM_INSTR_IMPL_A64__rbit_z_p_z_z(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_revd / sve_perm_pred / sve / A64
 *
 */

/* REVD  <Zd>.Q, <Pg>/M, <Zn>.Q (ffffe000/052e8000) */
//#define IEM_INSTR_IMPL_A64__revd_z_p_z_m(Zd, Zn, Pg)


/* REVD  <Zd>.Q, <Pg>/Z, <Zn>.Q (ffffe000/052ea000) */
//#define IEM_INSTR_IMPL_A64__revd_z_p_z_z(Zd, Zn, Pg)



/*
 *
 * Instruction Set & Groups: sve_int_perm_reverse_p / sve_perm_predicates / sve / A64
 *
 */

/* REV  <Pd>.<T>, <Pn>.<T> (ff3ffe10/05344000) */
//#define IEM_INSTR_IMPL_A64__rev_p_p(Pd, Pn, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_reverse_z / sve_perm_unpred_d / sve / A64
 *
 */

/* REV  <Zd>.<T>, <Zn>.<T> (ff3ffc00/05383800) */
//#define IEM_INSTR_IMPL_A64__rev_z_z(Zd, Zn, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_splice / sve_perm_pred / sve / A64
 *
 */

/* SPLICE  <Zdn>.<T>, <Pv>, <Zdn>.<T>, <Zm>.<T> (ff3fe000/052c8000) */
//#define IEM_INSTR_IMPL_A64__splice_z_p_zz_des(Zdn, Zm, Pv, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_tbl / sve_perm_unpred_c / sve / A64
 *
 */

/* TBL  <Zd>.<T>, { <Zn>.<T> }, <Zm>.<T> (ff20fc00/05203000) */
//#define IEM_INSTR_IMPL_A64__tbl_z_zz_1(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_tbl_3src / sve_perm_unpred_b / sve / A64
 *
 */

/* TBL  <Zd>.<T>, { <Zn1>.<T>, <Zn2>.<T> }, <Zm>.<T> (ff20fc00/05202800) */
//#define IEM_INSTR_IMPL_A64__tbl_z_zz_2(Zd, Zn, Zm, size)


/* TBX  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/05202c00) */
//#define IEM_INSTR_IMPL_A64__tbx_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_tbxquads / sve_perm_quads_c / sve / A64
 *
 */

/* TBXQ  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/05203400) */
//#define IEM_INSTR_IMPL_A64__tbxq_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_perm_unpk / sve_perm_unpred_d / sve / A64
 *
 */

/* SUNPKLO  <Zd>.<T>, <Zn>.<Tb> (ff3ffc00/05303800) */
//#define IEM_INSTR_IMPL_A64__sunpklo_z_z(Zd, Zn, size)


/* SUNPKHI  <Zd>.<T>, <Zn>.<Tb> (ff3ffc00/05313800) */
//#define IEM_INSTR_IMPL_A64__sunpkhi_z_z(Zd, Zn, size)


/* UUNPKLO  <Zd>.<T>, <Zn>.<Tb> (ff3ffc00/05323800) */
//#define IEM_INSTR_IMPL_A64__uunpklo_z_z(Zd, Zn, size)


/* UUNPKHI  <Zd>.<T>, <Zn>.<Tb> (ff3ffc00/05333800) */
//#define IEM_INSTR_IMPL_A64__uunpkhi_z_z(Zd, Zn, size)



/*
 *
 * Instruction Set & Groups: sve_int_pfalse / sve_pred_gen_d / sve / A64
 *
 */

/* PFALSE  <Pd>.B (fffffff0/2518e400) */
//#define IEM_INSTR_IMPL_A64__pfalse_p(Pd)



/*
 *
 * Instruction Set & Groups: sve_int_pfirst / sve_pred_gen_d / sve / A64
 *
 */

/* PFIRST  <Pdn>.B, <Pg>, <Pdn>.B (fffffe10/2558c000) */
//#define IEM_INSTR_IMPL_A64__pfirst_p_p_p(Pdn, Pg)



/*
 *
 * Instruction Set & Groups: sve_int_pn_ptrue / sve_while_pn / sve / A64
 *
 */

/* PTRUE  <PNd>.<T> (ff3ffff8/25207810) */
//#define IEM_INSTR_IMPL_A64__ptrue_pn_i(PNd, size)



/*
 *
 * Instruction Set & Groups: sve_int_pnext / sve_pred_gen_d / sve / A64
 *
 */

/* PNEXT  <Pdn>.<T>, <Pv>, <Pdn>.<T> (ff3ffe10/2519c400) */
//#define IEM_INSTR_IMPL_A64__pnext_p_p_p(Pdn, Pv, size)



/*
 *
 * Instruction Set & Groups: sve_int_pred_dup / sve_pred_dup / sve / A64
 *
 */

/* PSEL  <Pd>, <Pn>, <Pm>.<T>[<Wv>, <imm>] (ff20c210/25204000) */
//#define IEM_INSTR_IMPL_A64__psel_p_ppi(Pd, Pm, Pn, Rv, tszl, tszh, i1)



/*
 *
 * Instruction Set & Groups: sve_int_pred_log / sve_pred_gen_a / sve / A64
 *
 */

/* AND  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25004000) */
//#define IEM_INSTR_IMPL_A64__and_p_p_pp_z(Pd, Pn, Pg, Pm)


/* BIC  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25004010) */
//#define IEM_INSTR_IMPL_A64__bic_p_p_pp_z(Pd, Pn, Pg, Pm)


/* ORR  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25804000) */
//#define IEM_INSTR_IMPL_A64__orr_p_p_pp_z(Pd, Pn, Pg, Pm)


/* ORN  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25804010) */
//#define IEM_INSTR_IMPL_A64__orn_p_p_pp_z(Pd, Pn, Pg, Pm)


/* EOR  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25004200) */
//#define IEM_INSTR_IMPL_A64__eor_p_p_pp_z(Pd, Pn, Pg, Pm)


/* SEL  <Pd>.B, <Pg>, <Pn>.B, <Pm>.B (fff0c210/25004210) */
//#define IEM_INSTR_IMPL_A64__sel_p_p_pp(Pd, Pn, Pg, Pm)


/* NOR  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25804200) */
//#define IEM_INSTR_IMPL_A64__nor_p_p_pp_z(Pd, Pn, Pg, Pm)


/* NAND  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25804210) */
//#define IEM_INSTR_IMPL_A64__nand_p_p_pp_z(Pd, Pn, Pg, Pm)


/* ANDS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25404000) */
//#define IEM_INSTR_IMPL_A64__ands_p_p_pp_z(Pd, Pn, Pg, Pm)


/* BICS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25404010) */
//#define IEM_INSTR_IMPL_A64__bics_p_p_pp_z(Pd, Pn, Pg, Pm)


/* ORRS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25c04000) */
//#define IEM_INSTR_IMPL_A64__orrs_p_p_pp_z(Pd, Pn, Pg, Pm)


/* ORNS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25c04010) */
//#define IEM_INSTR_IMPL_A64__orns_p_p_pp_z(Pd, Pn, Pg, Pm)


/* EORS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25404200) */
//#define IEM_INSTR_IMPL_A64__eors_p_p_pp_z(Pd, Pn, Pg, Pm)


/* NORS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25c04200) */
//#define IEM_INSTR_IMPL_A64__nors_p_p_pp_z(Pd, Pn, Pg, Pm)


/* NANDS  <Pd>.B, <Pg>/Z, <Pn>.B, <Pm>.B (fff0c210/25c04210) */
//#define IEM_INSTR_IMPL_A64__nands_p_p_pp_z(Pd, Pn, Pg, Pm)



/*
 *
 * Instruction Set & Groups: sve_int_pred_pattern_a / sve_countelt / sve / A64
 *
 */

/* INCB  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0430e000) */
//#define IEM_INSTR_IMPL_A64__incb_r_rs(Rdn, pattern, imm4)


/* DECB  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0430e400) */
//#define IEM_INSTR_IMPL_A64__decb_r_rs(Rdn, pattern, imm4)


/* INCH  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0470e000) */
//#define IEM_INSTR_IMPL_A64__inch_r_rs(Rdn, pattern, imm4)


/* DECH  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0470e400) */
//#define IEM_INSTR_IMPL_A64__dech_r_rs(Rdn, pattern, imm4)


/* INCW  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04b0e000) */
//#define IEM_INSTR_IMPL_A64__incw_r_rs(Rdn, pattern, imm4)


/* DECW  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04b0e400) */
//#define IEM_INSTR_IMPL_A64__decw_r_rs(Rdn, pattern, imm4)


/* INCD  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04f0e000) */
//#define IEM_INSTR_IMPL_A64__incd_r_rs(Rdn, pattern, imm4)


/* DECD  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04f0e400) */
//#define IEM_INSTR_IMPL_A64__decd_r_rs(Rdn, pattern, imm4)



/*
 *
 * Instruction Set & Groups: sve_int_pred_pattern_b / sve_countelt / sve / A64
 *
 */

/* SQINCB  <Xdn>, <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0420f000) */
//#define IEM_INSTR_IMPL_A64__sqincb_r_rs_sx(Rdn, pattern, imm4)


/* UQINCB  <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0420f400) */
//#define IEM_INSTR_IMPL_A64__uqincb_r_rs_uw(Rdn, pattern, imm4)


/* SQDECB  <Xdn>, <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0420f800) */
//#define IEM_INSTR_IMPL_A64__sqdecb_r_rs_sx(Rdn, pattern, imm4)


/* UQDECB  <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0420fc00) */
//#define IEM_INSTR_IMPL_A64__uqdecb_r_rs_uw(Rdn, pattern, imm4)


/* SQINCB  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0430f000) */
//#define IEM_INSTR_IMPL_A64__sqincb_r_rs_x(Rdn, pattern, imm4)


/* SQDECB  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0430f800) */
//#define IEM_INSTR_IMPL_A64__sqdecb_r_rs_x(Rdn, pattern, imm4)


/* SQINCH  <Xdn>, <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0460f000) */
//#define IEM_INSTR_IMPL_A64__sqinch_r_rs_sx(Rdn, pattern, imm4)


/* UQINCH  <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0460f400) */
//#define IEM_INSTR_IMPL_A64__uqinch_r_rs_uw(Rdn, pattern, imm4)


/* SQDECH  <Xdn>, <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0460f800) */
//#define IEM_INSTR_IMPL_A64__sqdech_r_rs_sx(Rdn, pattern, imm4)


/* UQDECH  <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0460fc00) */
//#define IEM_INSTR_IMPL_A64__uqdech_r_rs_uw(Rdn, pattern, imm4)


/* SQINCH  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0470f000) */
//#define IEM_INSTR_IMPL_A64__sqinch_r_rs_x(Rdn, pattern, imm4)


/* SQDECH  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0470f800) */
//#define IEM_INSTR_IMPL_A64__sqdech_r_rs_x(Rdn, pattern, imm4)


/* SQINCW  <Xdn>, <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0f000) */
//#define IEM_INSTR_IMPL_A64__sqincw_r_rs_sx(Rdn, pattern, imm4)


/* UQINCW  <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0f400) */
//#define IEM_INSTR_IMPL_A64__uqincw_r_rs_uw(Rdn, pattern, imm4)


/* SQDECW  <Xdn>, <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0f800) */
//#define IEM_INSTR_IMPL_A64__sqdecw_r_rs_sx(Rdn, pattern, imm4)


/* UQDECW  <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04a0fc00) */
//#define IEM_INSTR_IMPL_A64__uqdecw_r_rs_uw(Rdn, pattern, imm4)


/* SQINCW  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04b0f000) */
//#define IEM_INSTR_IMPL_A64__sqincw_r_rs_x(Rdn, pattern, imm4)


/* SQDECW  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04b0f800) */
//#define IEM_INSTR_IMPL_A64__sqdecw_r_rs_x(Rdn, pattern, imm4)


/* SQINCD  <Xdn>, <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0f000) */
//#define IEM_INSTR_IMPL_A64__sqincd_r_rs_sx(Rdn, pattern, imm4)


/* UQINCD  <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0f400) */
//#define IEM_INSTR_IMPL_A64__uqincd_r_rs_uw(Rdn, pattern, imm4)


/* SQDECD  <Xdn>, <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0f800) */
//#define IEM_INSTR_IMPL_A64__sqdecd_r_rs_sx(Rdn, pattern, imm4)


/* UQDECD  <Wdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04e0fc00) */
//#define IEM_INSTR_IMPL_A64__uqdecd_r_rs_uw(Rdn, pattern, imm4)


/* SQINCD  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04f0f000) */
//#define IEM_INSTR_IMPL_A64__sqincd_r_rs_x(Rdn, pattern, imm4)


/* SQDECD  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04f0f800) */
//#define IEM_INSTR_IMPL_A64__sqdecd_r_rs_x(Rdn, pattern, imm4)


/* UQINCB  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0430f400) */
//#define IEM_INSTR_IMPL_A64__uqincb_r_rs_x(Rdn, pattern, imm4)


/* UQDECB  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0430fc00) */
//#define IEM_INSTR_IMPL_A64__uqdecb_r_rs_x(Rdn, pattern, imm4)


/* UQINCH  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0470f400) */
//#define IEM_INSTR_IMPL_A64__uqinch_r_rs_x(Rdn, pattern, imm4)


/* UQDECH  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/0470fc00) */
//#define IEM_INSTR_IMPL_A64__uqdech_r_rs_x(Rdn, pattern, imm4)


/* UQINCW  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04b0f400) */
//#define IEM_INSTR_IMPL_A64__uqincw_r_rs_x(Rdn, pattern, imm4)


/* UQDECW  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04b0fc00) */
//#define IEM_INSTR_IMPL_A64__uqdecw_r_rs_x(Rdn, pattern, imm4)


/* UQINCD  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04f0f400) */
//#define IEM_INSTR_IMPL_A64__uqincd_r_rs_x(Rdn, pattern, imm4)


/* UQDECD  <Xdn>{, <pattern>{, MUL #<imm>}} (fff0fc00/04f0fc00) */
//#define IEM_INSTR_IMPL_A64__uqdecd_r_rs_x(Rdn, pattern, imm4)



/*
 *
 * Instruction Set & Groups: sve_int_ptest / sve_pred_gen_d / sve / A64
 *
 */

/* PTEST  <Pg>, <Pn>.B (ffffc21f/2550c000) */
//#define IEM_INSTR_IMPL_A64__ptest__p_p(Pn, Pg)



/*
 *
 * Instruction Set & Groups: sve_int_ptrue / sve_pred_gen_d / sve / A64
 *
 */

/* PTRUE  <Pd>.<T>{, <pattern>} (ff3ffc10/2518e000) */
//#define IEM_INSTR_IMPL_A64__ptrue_p_s(Pd, pattern, size)


/* PTRUES  <Pd>.<T>{, <pattern>} (ff3ffc10/2519e000) */
//#define IEM_INSTR_IMPL_A64__ptrues_p_s(Pd, pattern, size)



/*
 *
 * Instruction Set & Groups: sve_int_rdffr / sve_pred_gen_d / sve / A64
 *
 */

/* RDFFR  <Pd>.B, <Pg>/Z (fffffe10/2518f000) */
//#define IEM_INSTR_IMPL_A64__rdffr_p_p_f(Pd, Pg)


/* RDFFRS  <Pd>.B, <Pg>/Z (fffffe10/2558f000) */
//#define IEM_INSTR_IMPL_A64__rdffrs_p_p_f(Pd, Pg)



/*
 *
 * Instruction Set & Groups: sve_int_rdffr_2 / sve_pred_gen_d / sve / A64
 *
 */

/* RDFFR  <Pd>.B (fffffff0/2519f000) */
//#define IEM_INSTR_IMPL_A64__rdffr_p_f(Pd)



/*
 *
 * Instruction Set & Groups: sve_int_read_svl_a / sve_alloca / sve / A64
 *
 */

/* RDSVL  <Xd>, #<imm> (fffff800/04bf5800) */
//#define IEM_INSTR_IMPL_A64__rdsvl_r_i(Rd, imm6)



/*
 *
 * Instruction Set & Groups: sve_int_read_vl_a / sve_alloca / sve / A64
 *
 */

/* RDVL  <Xd>, #<imm> (fffff800/04bf5000) */
//#define IEM_INSTR_IMPL_A64__rdvl_r_i(Rd, imm6)



/*
 *
 * Instruction Set & Groups: sve_int_reduce_0 / sve_int_pred_red / sve / A64
 *
 */

/* SADDV  <Dd>, <Pg>, <Zn>.<T> (ff3fe000/04002000) */
//#define IEM_INSTR_IMPL_A64__saddv_r_p_z(Vd, Zn, Pg, size)


/* UADDV  <Dd>, <Pg>, <Zn>.<T> (ff3fe000/04012000) */
//#define IEM_INSTR_IMPL_A64__uaddv_r_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_reduce_0q / sve_int_pred_red / sve / A64
 *
 */

/* ADDQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/04052000) */
//#define IEM_INSTR_IMPL_A64__addqv_z_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_reduce_1 / sve_int_pred_red / sve / A64
 *
 */

/* SMAXV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/04082000) */
//#define IEM_INSTR_IMPL_A64__smaxv_r_p_z(Vd, Zn, Pg, size)


/* SMINV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/040a2000) */
//#define IEM_INSTR_IMPL_A64__sminv_r_p_z(Vd, Zn, Pg, size)


/* UMAXV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/04092000) */
//#define IEM_INSTR_IMPL_A64__umaxv_r_p_z(Vd, Zn, Pg, size)


/* UMINV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/040b2000) */
//#define IEM_INSTR_IMPL_A64__uminv_r_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_reduce_1q / sve_int_pred_red / sve / A64
 *
 */

/* SMAXQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/040c2000) */
//#define IEM_INSTR_IMPL_A64__smaxqv_z_p_z(Vd, Zn, Pg, size)


/* SMINQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/040e2000) */
//#define IEM_INSTR_IMPL_A64__sminqv_z_p_z(Vd, Zn, Pg, size)


/* UMAXQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/040d2000) */
//#define IEM_INSTR_IMPL_A64__umaxqv_z_p_z(Vd, Zn, Pg, size)


/* UMINQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/040f2000) */
//#define IEM_INSTR_IMPL_A64__uminqv_z_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_reduce_2 / sve_int_pred_red / sve / A64
 *
 */

/* ORV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/04182000) */
//#define IEM_INSTR_IMPL_A64__orv_r_p_z(Vd, Zn, Pg, size)


/* EORV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/04192000) */
//#define IEM_INSTR_IMPL_A64__eorv_r_p_z(Vd, Zn, Pg, size)


/* ANDV  <V><d>, <Pg>, <Zn>.<T> (ff3fe000/041a2000) */
//#define IEM_INSTR_IMPL_A64__andv_r_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_reduce_2q / sve_int_pred_red / sve / A64
 *
 */

/* ORQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/041c2000) */
//#define IEM_INSTR_IMPL_A64__orqv_z_p_z(Vd, Zn, Pg, size)


/* EORQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/041d2000) */
//#define IEM_INSTR_IMPL_A64__eorqv_z_p_z(Vd, Zn, Pg, size)


/* ANDQV  <Vd>.<T>, <Pg>, <Zn>.<Tb> (ff3fe000/041e2000) */
//#define IEM_INSTR_IMPL_A64__andqv_z_p_z(Vd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_rotate_imm / sve_int_unpred_logical / sve / A64
 *
 */

/* XAR  <Zdn>.<T>, <Zdn>.<T>, <Zm>.<T>, #<const> (ff20fc00/04203400) */
//#define IEM_INSTR_IMPL_A64__xar_z_zzi(Zdn, Zm, imm3, tszl, tszh)



/*
 *
 * Instruction Set & Groups: sve_int_scmp_vi / sve_cmpsimm / sve / A64
 *
 */

/* CMPGE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff20e010/25000000) */
//#define IEM_INSTR_IMPL_A64__cmpge_p_p_zi(Pd, Zn, Pg, imm5, size)


/* CMPEQ  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff20e010/25008000) */
//#define IEM_INSTR_IMPL_A64__cmpeq_p_p_zi(Pd, Zn, Pg, imm5, size)


/* CMPLT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff20e010/25002000) */
//#define IEM_INSTR_IMPL_A64__cmplt_p_p_zi(Pd, Zn, Pg, imm5, size)


/* CMPGT  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff20e010/25000010) */
//#define IEM_INSTR_IMPL_A64__cmpgt_p_p_zi(Pd, Zn, Pg, imm5, size)


/* CMPNE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff20e010/25008010) */
//#define IEM_INSTR_IMPL_A64__cmpne_p_p_zi(Pd, Zn, Pg, imm5, size)


/* CMPLE  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff20e010/25002010) */
//#define IEM_INSTR_IMPL_A64__cmple_p_p_zi(Pd, Zn, Pg, imm5, size)



/*
 *
 * Instruction Set & Groups: sve_int_sel_vvv / sve_int_select / sve / A64
 *
 */

/* SEL  <Zd>.<T>, <Pv>, <Zn>.<T>, <Zm>.<T> (ff20c000/0520c000) */
//#define IEM_INSTR_IMPL_A64__sel_z_p_zz(Zd, Zn, Pv, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_setffr / sve_pred_wrffr / sve / A64
 *
 */

/* SETFFR (ffffffff/252c9000) */
//#define IEM_INSTR_IMPL_A64__setffr_f()



/*
 *
 * Instruction Set & Groups: sve_int_sqdmulh / sve_int_unpred_arit_b / sve / A64
 *
 */

/* SQDMULH  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04207000) */
//#define IEM_INSTR_IMPL_A64__sqdmulh_z_zz(Zd, Zn, Zm, size)


/* SQRDMULH  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/04207400) */
//#define IEM_INSTR_IMPL_A64__sqrdmulh_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_int_tern_log / sve_int_unpred_logical / sve / A64
 *
 */

/* EOR3  <Zdn>.D, <Zdn>.D, <Zm>.D, <Zk>.D (ffe0fc00/04203800) */
//#define IEM_INSTR_IMPL_A64__eor3_z_zzz(Zdn, Zk, Zm)


/* BCAX  <Zdn>.D, <Zdn>.D, <Zm>.D, <Zk>.D (ffe0fc00/04603800) */
//#define IEM_INSTR_IMPL_A64__bcax_z_zzz(Zdn, Zk, Zm)


/* BSL  <Zdn>.D, <Zdn>.D, <Zm>.D, <Zk>.D (ffe0fc00/04203c00) */
//#define IEM_INSTR_IMPL_A64__bsl_z_zzz(Zdn, Zk, Zm)


/* BSL1N  <Zdn>.D, <Zdn>.D, <Zm>.D, <Zk>.D (ffe0fc00/04603c00) */
//#define IEM_INSTR_IMPL_A64__bsl1n_z_zzz(Zdn, Zk, Zm)


/* BSL2N  <Zdn>.D, <Zdn>.D, <Zm>.D, <Zk>.D (ffe0fc00/04a03c00) */
//#define IEM_INSTR_IMPL_A64__bsl2n_z_zzz(Zdn, Zk, Zm)


/* NBSL  <Zdn>.D, <Zdn>.D, <Zm>.D, <Zk>.D (ffe0fc00/04e03c00) */
//#define IEM_INSTR_IMPL_A64__nbsl_z_zzz(Zdn, Zk, Zm)



/*
 *
 * Instruction Set & Groups: sve_int_ucmp_vi / sve_cmpuimm / sve / A64
 *
 */

/* CMPHS  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff202010/24200000) */
//#define IEM_INSTR_IMPL_A64__cmphs_p_p_zi(Pd, Zn, Pg, imm7, size)


/* CMPHI  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff202010/24200010) */
//#define IEM_INSTR_IMPL_A64__cmphi_p_p_zi(Pd, Zn, Pg, imm7, size)


/* CMPLO  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff202010/24202000) */
//#define IEM_INSTR_IMPL_A64__cmplo_p_p_zi(Pd, Zn, Pg, imm7, size)


/* CMPLS  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, #<imm> (ff202010/24202010) */
//#define IEM_INSTR_IMPL_A64__cmpls_p_p_zi(Pd, Zn, Pg, imm7, size)



/*
 *
 * Instruction Set & Groups: sve_int_un_pred_arit_0 / sve_int_pred_un / sve / A64
 *
 */

/* ABS  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/0416a000) */
//#define IEM_INSTR_IMPL_A64__abs_z_p_z_m(Zd, Zn, Pg, size)


/* ABS  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0406a000) */
//#define IEM_INSTR_IMPL_A64__abs_z_p_z_z(Zd, Zn, Pg, size)


/* NEG  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/0417a000) */
//#define IEM_INSTR_IMPL_A64__neg_z_p_z_m(Zd, Zn, Pg, size)


/* NEG  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0407a000) */
//#define IEM_INSTR_IMPL_A64__neg_z_p_z_z(Zd, Zn, Pg, size)


/* SXTW  <Zd>.D, <Pg>/M, <Zn>.D (ff3fe000/0414a000) */
//#define IEM_INSTR_IMPL_A64__sxtw_z_p_z_m(Zd, Zn, Pg, size)


/* SXTW  <Zd>.D, <Pg>/Z, <Zn>.D (ff3fe000/0404a000) */
//#define IEM_INSTR_IMPL_A64__sxtw_z_p_z_z(Zd, Zn, Pg, size)


/* SXTH  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/0412a000) */
//#define IEM_INSTR_IMPL_A64__sxth_z_p_z_m(Zd, Zn, Pg, size)


/* SXTH  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0402a000) */
//#define IEM_INSTR_IMPL_A64__sxth_z_p_z_z(Zd, Zn, Pg, size)


/* SXTB  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/0410a000) */
//#define IEM_INSTR_IMPL_A64__sxtb_z_p_z_m(Zd, Zn, Pg, size)


/* SXTB  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0400a000) */
//#define IEM_INSTR_IMPL_A64__sxtb_z_p_z_z(Zd, Zn, Pg, size)


/* UXTW  <Zd>.D, <Pg>/M, <Zn>.D (ff3fe000/0415a000) */
//#define IEM_INSTR_IMPL_A64__uxtw_z_p_z_m(Zd, Zn, Pg, size)


/* UXTW  <Zd>.D, <Pg>/Z, <Zn>.D (ff3fe000/0405a000) */
//#define IEM_INSTR_IMPL_A64__uxtw_z_p_z_z(Zd, Zn, Pg, size)


/* UXTH  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/0413a000) */
//#define IEM_INSTR_IMPL_A64__uxth_z_p_z_m(Zd, Zn, Pg, size)


/* UXTH  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0403a000) */
//#define IEM_INSTR_IMPL_A64__uxth_z_p_z_z(Zd, Zn, Pg, size)


/* UXTB  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/0411a000) */
//#define IEM_INSTR_IMPL_A64__uxtb_z_p_z_m(Zd, Zn, Pg, size)


/* UXTB  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0401a000) */
//#define IEM_INSTR_IMPL_A64__uxtb_z_p_z_z(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_un_pred_arit_1 / sve_int_pred_un / sve / A64
 *
 */

/* CLS  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/0418a000) */
//#define IEM_INSTR_IMPL_A64__cls_z_p_z_m(Zd, Zn, Pg, size)


/* CLS  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0408a000) */
//#define IEM_INSTR_IMPL_A64__cls_z_p_z_z(Zd, Zn, Pg, size)


/* CLZ  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/0419a000) */
//#define IEM_INSTR_IMPL_A64__clz_z_p_z_m(Zd, Zn, Pg, size)


/* CLZ  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/0409a000) */
//#define IEM_INSTR_IMPL_A64__clz_z_p_z_z(Zd, Zn, Pg, size)


/* CNT  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/041aa000) */
//#define IEM_INSTR_IMPL_A64__cnt_z_p_z_m(Zd, Zn, Pg, size)


/* CNT  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/040aa000) */
//#define IEM_INSTR_IMPL_A64__cnt_z_p_z_z(Zd, Zn, Pg, size)


/* CNOT  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/041ba000) */
//#define IEM_INSTR_IMPL_A64__cnot_z_p_z_m(Zd, Zn, Pg, size)


/* CNOT  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/040ba000) */
//#define IEM_INSTR_IMPL_A64__cnot_z_p_z_z(Zd, Zn, Pg, size)


/* FABS  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/041ca000) */
//#define IEM_INSTR_IMPL_A64__fabs_z_p_z_m(Zd, Zn, Pg, size)


/* FABS  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/040ca000) */
//#define IEM_INSTR_IMPL_A64__fabs_z_p_z_z(Zd, Zn, Pg, size)


/* FNEG  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/041da000) */
//#define IEM_INSTR_IMPL_A64__fneg_z_p_z_m(Zd, Zn, Pg, size)


/* FNEG  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/040da000) */
//#define IEM_INSTR_IMPL_A64__fneg_z_p_z_z(Zd, Zn, Pg, size)


/* NOT  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/041ea000) */
//#define IEM_INSTR_IMPL_A64__not_z_p_z_m(Zd, Zn, Pg, size)


/* NOT  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/040ea000) */
//#define IEM_INSTR_IMPL_A64__not_z_p_z_z(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_int_while_rr / sve_cmpgpr / sve / A64
 *
 */

/* WHILEGE  <Pd>.<T>, <R><n>, <R><m> (ff20ec10/25200000) */
//#define IEM_INSTR_IMPL_A64__whilege_p_p_rr(Pd, Rn, sf, Rm, size)


/* WHILEHS  <Pd>.<T>, <R><n>, <R><m> (ff20ec10/25200800) */
//#define IEM_INSTR_IMPL_A64__whilehs_p_p_rr(Pd, Rn, sf, Rm, size)


/* WHILEGT  <Pd>.<T>, <R><n>, <R><m> (ff20ec10/25200010) */
//#define IEM_INSTR_IMPL_A64__whilegt_p_p_rr(Pd, Rn, sf, Rm, size)


/* WHILEHI  <Pd>.<T>, <R><n>, <R><m> (ff20ec10/25200810) */
//#define IEM_INSTR_IMPL_A64__whilehi_p_p_rr(Pd, Rn, sf, Rm, size)


/* WHILELT  <Pd>.<T>, <R><n>, <R><m> (ff20ec10/25200400) */
//#define IEM_INSTR_IMPL_A64__whilelt_p_p_rr(Pd, Rn, sf, Rm, size)


/* WHILELO  <Pd>.<T>, <R><n>, <R><m> (ff20ec10/25200c00) */
//#define IEM_INSTR_IMPL_A64__whilelo_p_p_rr(Pd, Rn, sf, Rm, size)


/* WHILELE  <Pd>.<T>, <R><n>, <R><m> (ff20ec10/25200410) */
//#define IEM_INSTR_IMPL_A64__whilele_p_p_rr(Pd, Rn, sf, Rm, size)


/* WHILELS  <Pd>.<T>, <R><n>, <R><m> (ff20ec10/25200c10) */
//#define IEM_INSTR_IMPL_A64__whilels_p_p_rr(Pd, Rn, sf, Rm, size)



/*
 *
 * Instruction Set & Groups: sve_int_while_rr_pair / sve_while_pn / sve / A64
 *
 */

/* WHILEGE  { <Pd1>.<T>, <Pd2>.<T> }, <Xn>, <Xm> (ff20fc11/25205010) */
//#define IEM_INSTR_IMPL_A64__whilege_pp_rr(Pd, Rn, Rm, size)


/* WHILEHS  { <Pd1>.<T>, <Pd2>.<T> }, <Xn>, <Xm> (ff20fc11/25205810) */
//#define IEM_INSTR_IMPL_A64__whilehs_pp_rr(Pd, Rn, Rm, size)


/* WHILEGT  { <Pd1>.<T>, <Pd2>.<T> }, <Xn>, <Xm> (ff20fc11/25205011) */
//#define IEM_INSTR_IMPL_A64__whilegt_pp_rr(Pd, Rn, Rm, size)


/* WHILEHI  { <Pd1>.<T>, <Pd2>.<T> }, <Xn>, <Xm> (ff20fc11/25205811) */
//#define IEM_INSTR_IMPL_A64__whilehi_pp_rr(Pd, Rn, Rm, size)


/* WHILELT  { <Pd1>.<T>, <Pd2>.<T> }, <Xn>, <Xm> (ff20fc11/25205410) */
//#define IEM_INSTR_IMPL_A64__whilelt_pp_rr(Pd, Rn, Rm, size)


/* WHILELO  { <Pd1>.<T>, <Pd2>.<T> }, <Xn>, <Xm> (ff20fc11/25205c10) */
//#define IEM_INSTR_IMPL_A64__whilelo_pp_rr(Pd, Rn, Rm, size)


/* WHILELE  { <Pd1>.<T>, <Pd2>.<T> }, <Xn>, <Xm> (ff20fc11/25205411) */
//#define IEM_INSTR_IMPL_A64__whilele_pp_rr(Pd, Rn, Rm, size)


/* WHILELS  { <Pd1>.<T>, <Pd2>.<T> }, <Xn>, <Xm> (ff20fc11/25205c11) */
//#define IEM_INSTR_IMPL_A64__whilels_pp_rr(Pd, Rn, Rm, size)



/*
 *
 * Instruction Set & Groups: sve_int_while_rr_pn / sve_while_pn / sve / A64
 *
 */

/* WHILEGE  <PNd>.<T>, <Xn>, <Xm>, <vl> (ff20dc18/25204010) */
//#define IEM_INSTR_IMPL_A64__whilege_pn_rr(PNd, Rn, vl, Rm, size)


/* WHILEHS  <PNd>.<T>, <Xn>, <Xm>, <vl> (ff20dc18/25204810) */
//#define IEM_INSTR_IMPL_A64__whilehs_pn_rr(PNd, Rn, vl, Rm, size)


/* WHILEGT  <PNd>.<T>, <Xn>, <Xm>, <vl> (ff20dc18/25204018) */
//#define IEM_INSTR_IMPL_A64__whilegt_pn_rr(PNd, Rn, vl, Rm, size)


/* WHILEHI  <PNd>.<T>, <Xn>, <Xm>, <vl> (ff20dc18/25204818) */
//#define IEM_INSTR_IMPL_A64__whilehi_pn_rr(PNd, Rn, vl, Rm, size)


/* WHILELT  <PNd>.<T>, <Xn>, <Xm>, <vl> (ff20dc18/25204410) */
//#define IEM_INSTR_IMPL_A64__whilelt_pn_rr(PNd, Rn, vl, Rm, size)


/* WHILELO  <PNd>.<T>, <Xn>, <Xm>, <vl> (ff20dc18/25204c10) */
//#define IEM_INSTR_IMPL_A64__whilelo_pn_rr(PNd, Rn, vl, Rm, size)


/* WHILELE  <PNd>.<T>, <Xn>, <Xm>, <vl> (ff20dc18/25204418) */
//#define IEM_INSTR_IMPL_A64__whilele_pn_rr(PNd, Rn, vl, Rm, size)


/* WHILELS  <PNd>.<T>, <Xn>, <Xm>, <vl> (ff20dc18/25204c18) */
//#define IEM_INSTR_IMPL_A64__whilels_pn_rr(PNd, Rn, vl, Rm, size)



/*
 *
 * Instruction Set & Groups: sve_int_whilenc / sve_cmpgpr / sve / A64
 *
 */

/* WHILEWR  <Pd>.<T>, <Xn>, <Xm> (ff20fc10/25203000) */
//#define IEM_INSTR_IMPL_A64__whilewr_p_rr(Pd, Rn, Rm, size)


/* WHILERW  <Pd>.<T>, <Xn>, <Xm> (ff20fc10/25203010) */
//#define IEM_INSTR_IMPL_A64__whilerw_p_rr(Pd, Rn, Rm, size)



/*
 *
 * Instruction Set & Groups: sve_int_wrffr / sve_pred_wrffr / sve / A64
 *
 */

/* WRFFR  <Pn>.B (fffffe1f/25289000) */
//#define IEM_INSTR_IMPL_A64__wrffr_f_p(Pn)



/*
 *
 * Instruction Set & Groups: sve_intx_aba / sve_intx_acc / sve / A64
 *
 */

/* SABA  <Zda>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4500f800) */
//#define IEM_INSTR_IMPL_A64__saba_z_zzz(Zda, Zn, Zm, size)


/* UABA  <Zda>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4500fc00) */
//#define IEM_INSTR_IMPL_A64__uaba_z_zzz(Zda, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_aba_long / sve_intx_acc / sve / A64
 *
 */

/* SABALB  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/4500c000) */
//#define IEM_INSTR_IMPL_A64__sabalb_z_zzz(Zda, Zn, Zm, size)


/* SABALT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/4500c400) */
//#define IEM_INSTR_IMPL_A64__sabalt_z_zzz(Zda, Zn, Zm, size)


/* UABALB  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/4500c800) */
//#define IEM_INSTR_IMPL_A64__uabalb_z_zzz(Zda, Zn, Zm, size)


/* UABALT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/4500cc00) */
//#define IEM_INSTR_IMPL_A64__uabalt_z_zzz(Zda, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_accumulate_long_pairs / sve_intx_predicated / sve / A64
 *
 */

/* SADALP  <Zda>.<T>, <Pg>/M, <Zn>.<Tb> (ff3fe000/4404a000) */
//#define IEM_INSTR_IMPL_A64__sadalp_z_p_z(Zda, Zn, Pg, size)


/* UADALP  <Zda>.<T>, <Pg>/M, <Zn>.<Tb> (ff3fe000/4405a000) */
//#define IEM_INSTR_IMPL_A64__uadalp_z_p_z(Zda, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_intx_adc_long / sve_intx_acc / sve / A64
 *
 */

/* ADCLB  <Zda>.<T>, <Zn>.<T>, <Zm>.<T> (ffa0fc00/4500d000) */
//#define IEM_INSTR_IMPL_A64__adclb_z_zzz(Zda, Zn, Zm, sz)


/* SBCLB  <Zda>.<T>, <Zn>.<T>, <Zm>.<T> (ffa0fc00/4580d000) */
//#define IEM_INSTR_IMPL_A64__sbclb_z_zzz(Zda, Zn, Zm, sz)


/* ADCLT  <Zda>.<T>, <Zn>.<T>, <Zm>.<T> (ffa0fc00/4500d400) */
//#define IEM_INSTR_IMPL_A64__adclt_z_zzz(Zda, Zn, Zm, sz)


/* SBCLT  <Zda>.<T>, <Zn>.<T>, <Zm>.<T> (ffa0fc00/4580d400) */
//#define IEM_INSTR_IMPL_A64__sbclt_z_zzz(Zda, Zn, Zm, sz)



/*
 *
 * Instruction Set & Groups: sve_intx_arith_binary_pairs / sve_intx_predicated / sve / A64
 *
 */

/* ADDP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/4411a000) */
//#define IEM_INSTR_IMPL_A64__addp_z_p_zz(Zdn, Zm, Pg, size)


/* SMAXP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/4414a000) */
//#define IEM_INSTR_IMPL_A64__smaxp_z_p_zz(Zdn, Zm, Pg, size)


/* SMINP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/4416a000) */
//#define IEM_INSTR_IMPL_A64__sminp_z_p_zz(Zdn, Zm, Pg, size)


/* UMAXP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/4415a000) */
//#define IEM_INSTR_IMPL_A64__umaxp_z_p_zz(Zdn, Zm, Pg, size)


/* UMINP  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/4417a000) */
//#define IEM_INSTR_IMPL_A64__uminp_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_intx_arith_narrow / sve_intx_narrowing / sve / A64
 *
 */

/* ADDHNB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45206000) */
//#define IEM_INSTR_IMPL_A64__addhnb_z_zz(Zd, Zn, Zm, size)


/* RADDHNB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45206800) */
//#define IEM_INSTR_IMPL_A64__raddhnb_z_zz(Zd, Zn, Zm, size)


/* SUBHNB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45207000) */
//#define IEM_INSTR_IMPL_A64__subhnb_z_zz(Zd, Zn, Zm, size)


/* RSUBHNB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45207800) */
//#define IEM_INSTR_IMPL_A64__rsubhnb_z_zz(Zd, Zn, Zm, size)


/* ADDHNT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45206400) */
//#define IEM_INSTR_IMPL_A64__addhnt_z_zz(Zd, Zn, Zm, size)


/* RADDHNT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45206c00) */
//#define IEM_INSTR_IMPL_A64__raddhnt_z_zz(Zd, Zn, Zm, size)


/* SUBHNT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45207400) */
//#define IEM_INSTR_IMPL_A64__subhnt_z_zz(Zd, Zn, Zm, size)


/* RSUBHNT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45207c00) */
//#define IEM_INSTR_IMPL_A64__rsubhnt_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_bin_pred_shift_sat_round / sve_intx_predicated / sve / A64
 *
 */

/* SRSHL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44028000) */
//#define IEM_INSTR_IMPL_A64__srshl_z_p_zz(Zdn, Zm, Pg, size)


/* SRSHLR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44068000) */
//#define IEM_INSTR_IMPL_A64__srshlr_z_p_zz(Zdn, Zm, Pg, size)


/* SQSHL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44088000) */
//#define IEM_INSTR_IMPL_A64__sqshl_z_p_zz(Zdn, Zm, Pg, size)


/* SQRSHL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/440a8000) */
//#define IEM_INSTR_IMPL_A64__sqrshl_z_p_zz(Zdn, Zm, Pg, size)


/* SQSHLR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/440c8000) */
//#define IEM_INSTR_IMPL_A64__sqshlr_z_p_zz(Zdn, Zm, Pg, size)


/* SQRSHLR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/440e8000) */
//#define IEM_INSTR_IMPL_A64__sqrshlr_z_p_zz(Zdn, Zm, Pg, size)


/* URSHL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44038000) */
//#define IEM_INSTR_IMPL_A64__urshl_z_p_zz(Zdn, Zm, Pg, size)


/* URSHLR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44078000) */
//#define IEM_INSTR_IMPL_A64__urshlr_z_p_zz(Zdn, Zm, Pg, size)


/* UQSHL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44098000) */
//#define IEM_INSTR_IMPL_A64__uqshl_z_p_zz(Zdn, Zm, Pg, size)


/* UQRSHL  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/440b8000) */
//#define IEM_INSTR_IMPL_A64__uqrshl_z_p_zz(Zdn, Zm, Pg, size)


/* UQSHLR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/440d8000) */
//#define IEM_INSTR_IMPL_A64__uqshlr_z_p_zz(Zdn, Zm, Pg, size)


/* UQRSHLR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/440f8000) */
//#define IEM_INSTR_IMPL_A64__uqrshlr_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_intx_cadd / sve_intx_acc / sve / A64
 *
 */

/* CADD  <Zdn>.<T>, <Zdn>.<T>, <Zm>.<T>, <const> (ff3ff800/4500d800) */
//#define IEM_INSTR_IMPL_A64__cadd_z_zz(Zdn, Zm, rot, size)


/* SQCADD  <Zdn>.<T>, <Zdn>.<T>, <Zm>.<T>, <const> (ff3ff800/4501d800) */
//#define IEM_INSTR_IMPL_A64__sqcadd_z_zz(Zdn, Zm, rot, size)



/*
 *
 * Instruction Set & Groups: sve_intx_cdot / sve_intx_muladd_unpred / sve / A64
 *
 */

/* CDOT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb>, <const> (ff20f000/44001000) */
//#define IEM_INSTR_IMPL_A64__cdot_z_zzz(Zda, Zn, rot, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_cdot_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* CDOT  <Zda>.S, <Zn>.B, <Zm>.B[<imm>], <const> (ffe0f000/44a04000) */
//#define IEM_INSTR_IMPL_A64__cdot_z_zzzi_s(Zda, Zn, rot, Zm, i2)


/* CDOT  <Zda>.D, <Zn>.H, <Zm>.H[<imm>], <const> (ffe0f000/44e04000) */
//#define IEM_INSTR_IMPL_A64__cdot_z_zzzi_d(Zda, Zn, rot, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_clamp_lvl2 / sve_intx_clamp / sve / A64
 *
 */

/* SCLAMP  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4400c000) */
//#define IEM_INSTR_IMPL_A64__sclamp_z_zz(Zd, Zn, Zm, size)


/* UCLAMP  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4400c400) */
//#define IEM_INSTR_IMPL_A64__uclamp_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_clong / sve_intx_constructive / sve / A64
 *
 */

/* SADDLBT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45008000) */
//#define IEM_INSTR_IMPL_A64__saddlbt_z_zz(Zd, Zn, Zm, size)


/* SSUBLBT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45008800) */
//#define IEM_INSTR_IMPL_A64__ssublbt_z_zz(Zd, Zn, Zm, size)


/* SSUBLTB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45008c00) */
//#define IEM_INSTR_IMPL_A64__ssubltb_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_cmla / sve_intx_muladd_unpred / sve / A64
 *
 */

/* CMLA  <Zda>.<T>, <Zn>.<T>, <Zm>.<T>, <const> (ff20f000/44002000) */
//#define IEM_INSTR_IMPL_A64__cmla_z_zzz(Zda, Zn, rot, Zm, size)


/* SQRDCMLAH  <Zda>.<T>, <Zn>.<T>, <Zm>.<T>, <const> (ff20f000/44003000) */
//#define IEM_INSTR_IMPL_A64__sqrdcmlah_z_zzz(Zda, Zn, rot, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_cmla_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* CMLA  <Zda>.H, <Zn>.H, <Zm>.H[<imm>], <const> (ffe0f000/44a06000) */
//#define IEM_INSTR_IMPL_A64__cmla_z_zzzi_h(Zda, Zn, rot, Zm, i2)


/* CMLA  <Zda>.S, <Zn>.S, <Zm>.S[<imm>], <const> (ffe0f000/44e06000) */
//#define IEM_INSTR_IMPL_A64__cmla_z_zzzi_s(Zda, Zn, rot, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_cons_arith_long / sve_intx_cons_widening / sve / A64
 *
 */

/* SADDLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45000000) */
//#define IEM_INSTR_IMPL_A64__saddlb_z_zz(Zd, Zn, Zm, size)


/* SSUBLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45001000) */
//#define IEM_INSTR_IMPL_A64__ssublb_z_zz(Zd, Zn, Zm, size)


/* SABDLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45003000) */
//#define IEM_INSTR_IMPL_A64__sabdlb_z_zz(Zd, Zn, Zm, size)


/* SADDLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45000400) */
//#define IEM_INSTR_IMPL_A64__saddlt_z_zz(Zd, Zn, Zm, size)


/* SSUBLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45001400) */
//#define IEM_INSTR_IMPL_A64__ssublt_z_zz(Zd, Zn, Zm, size)


/* SABDLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45003400) */
//#define IEM_INSTR_IMPL_A64__sabdlt_z_zz(Zd, Zn, Zm, size)


/* UADDLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45000800) */
//#define IEM_INSTR_IMPL_A64__uaddlb_z_zz(Zd, Zn, Zm, size)


/* USUBLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45001800) */
//#define IEM_INSTR_IMPL_A64__usublb_z_zz(Zd, Zn, Zm, size)


/* UABDLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45003800) */
//#define IEM_INSTR_IMPL_A64__uabdlb_z_zz(Zd, Zn, Zm, size)


/* UADDLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45000c00) */
//#define IEM_INSTR_IMPL_A64__uaddlt_z_zz(Zd, Zn, Zm, size)


/* USUBLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45001c00) */
//#define IEM_INSTR_IMPL_A64__usublt_z_zz(Zd, Zn, Zm, size)


/* UABDLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45003c00) */
//#define IEM_INSTR_IMPL_A64__uabdlt_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_cons_arith_wide / sve_intx_cons_widening / sve / A64
 *
 */

/* SADDWB  <Zd>.<T>, <Zn>.<T>, <Zm>.<Tb> (ff20fc00/45004000) */
//#define IEM_INSTR_IMPL_A64__saddwb_z_zz(Zd, Zn, Zm, size)


/* SSUBWB  <Zd>.<T>, <Zn>.<T>, <Zm>.<Tb> (ff20fc00/45005000) */
//#define IEM_INSTR_IMPL_A64__ssubwb_z_zz(Zd, Zn, Zm, size)


/* SADDWT  <Zd>.<T>, <Zn>.<T>, <Zm>.<Tb> (ff20fc00/45004400) */
//#define IEM_INSTR_IMPL_A64__saddwt_z_zz(Zd, Zn, Zm, size)


/* SSUBWT  <Zd>.<T>, <Zn>.<T>, <Zm>.<Tb> (ff20fc00/45005400) */
//#define IEM_INSTR_IMPL_A64__ssubwt_z_zz(Zd, Zn, Zm, size)


/* UADDWB  <Zd>.<T>, <Zn>.<T>, <Zm>.<Tb> (ff20fc00/45004800) */
//#define IEM_INSTR_IMPL_A64__uaddwb_z_zz(Zd, Zn, Zm, size)


/* USUBWB  <Zd>.<T>, <Zn>.<T>, <Zm>.<Tb> (ff20fc00/45005800) */
//#define IEM_INSTR_IMPL_A64__usubwb_z_zz(Zd, Zn, Zm, size)


/* UADDWT  <Zd>.<T>, <Zn>.<T>, <Zm>.<Tb> (ff20fc00/45004c00) */
//#define IEM_INSTR_IMPL_A64__uaddwt_z_zz(Zd, Zn, Zm, size)


/* USUBWT  <Zd>.<T>, <Zn>.<T>, <Zm>.<Tb> (ff20fc00/45005c00) */
//#define IEM_INSTR_IMPL_A64__usubwt_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_cons_mul_long / sve_intx_cons_widening / sve / A64
 *
 */

/* SQDMULLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45006000) */
//#define IEM_INSTR_IMPL_A64__sqdmullb_z_zz(Zd, Zn, Zm, size)


/* PMULLB  <Zd>.Q, <Zn>.D, <Zm>.D (ffe0fc00/45006800) */
//#define IEM_INSTR_IMPL_A64__pmullb_z_zz_q(Zd, Zn, Zm)


/* PMULLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45006800) */
//#define IEM_INSTR_IMPL_A64__pmullb_z_zz(Zd, Zn, Zm, size)


/* SMULLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45007000) */
//#define IEM_INSTR_IMPL_A64__smullb_z_zz(Zd, Zn, Zm, size)


/* SQDMULLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45006400) */
//#define IEM_INSTR_IMPL_A64__sqdmullt_z_zz(Zd, Zn, Zm, size)


/* PMULLT  <Zd>.Q, <Zn>.D, <Zm>.D (ffe0fc00/45006c00) */
//#define IEM_INSTR_IMPL_A64__pmullt_z_zz_q(Zd, Zn, Zm)


/* PMULLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45006c00) */
//#define IEM_INSTR_IMPL_A64__pmullt_z_zz(Zd, Zn, Zm, size)


/* SMULLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45007400) */
//#define IEM_INSTR_IMPL_A64__smullt_z_zz(Zd, Zn, Zm, size)


/* UMULLB  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45007800) */
//#define IEM_INSTR_IMPL_A64__umullb_z_zz(Zd, Zn, Zm, size)


/* UMULLT  <Zd>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/45007c00) */
//#define IEM_INSTR_IMPL_A64__umullt_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_dot / sve_intx_muladd_unpred / sve / A64
 *
 */

/* SDOT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ffa0fc00/44800000) */
//#define IEM_INSTR_IMPL_A64__sdot_z_zzz(Zda, Zn, Zm, size)


/* UDOT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ffa0fc00/44800400) */
//#define IEM_INSTR_IMPL_A64__udot_z_zzz(Zda, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_dot2_by_indexed_elem_lvl2 / sve_intx_dot2_by_indexed_elem / sve / A64
 *
 */

/* SDOT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0fc00/4480c800) */
//#define IEM_INSTR_IMPL_A64__sdot_z32_zzzi(Zda, Zn, Zm, i2)


/* UDOT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0fc00/4480cc00) */
//#define IEM_INSTR_IMPL_A64__udot_z32_zzzi(Zda, Zn, Zm, i2)



/*
 *
 * Instruction Set & Groups: sve_intx_dot2_lvl2 / sve_intx_dot2 / sve / A64
 *
 */

/* SDOT  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/4400c800) */
//#define IEM_INSTR_IMPL_A64__sdot_z32_zzz(Zda, Zn, Zm)


/* UDOT  <Zda>.S, <Zn>.H, <Zm>.H (ffe0fc00/4400cc00) */
//#define IEM_INSTR_IMPL_A64__udot_z32_zzz(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_intx_dot_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* SDOT  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0fc00/44a00000) */
//#define IEM_INSTR_IMPL_A64__sdot_z_zzzi_s(Zda, Zn, Zm, i2)


/* SDOT  <Zda>.D, <Zn>.H, <Zm>.H[<imm>] (ffe0fc00/44e00000) */
//#define IEM_INSTR_IMPL_A64__sdot_z_zzzi_d(Zda, Zn, Zm, i1)


/* UDOT  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0fc00/44a00400) */
//#define IEM_INSTR_IMPL_A64__udot_z_zzzi_s(Zda, Zn, Zm, i2)


/* UDOT  <Zda>.D, <Zn>.H, <Zm>.H[<imm>] (ffe0fc00/44e00400) */
//#define IEM_INSTR_IMPL_A64__udot_z_zzzi_d(Zda, Zn, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_eorx / sve_intx_constructive / sve / A64
 *
 */

/* EORBT  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/45009000) */
//#define IEM_INSTR_IMPL_A64__eorbt_z_zz(Zd, Zn, Zm, size)


/* EORTB  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/45009400) */
//#define IEM_INSTR_IMPL_A64__eortb_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_extract_narrow / sve_intx_narrowing / sve / A64
 *
 */

/* SQXTNB  <Zd>.<T>, <Zn>.<Tb> (ffa7fc00/45204000) */
//#define IEM_INSTR_IMPL_A64__sqxtnb_z_zz(Zd, Zn, tszl, tszh)


/* SQXTUNB  <Zd>.<T>, <Zn>.<Tb> (ffa7fc00/45205000) */
//#define IEM_INSTR_IMPL_A64__sqxtunb_z_zz(Zd, Zn, tszl, tszh)


/* SQXTNT  <Zd>.<T>, <Zn>.<Tb> (ffa7fc00/45204400) */
//#define IEM_INSTR_IMPL_A64__sqxtnt_z_zz(Zd, Zn, tszl, tszh)


/* SQXTUNT  <Zd>.<T>, <Zn>.<Tb> (ffa7fc00/45205400) */
//#define IEM_INSTR_IMPL_A64__sqxtunt_z_zz(Zd, Zn, tszl, tszh)


/* UQXTNB  <Zd>.<T>, <Zn>.<Tb> (ffa7fc00/45204800) */
//#define IEM_INSTR_IMPL_A64__uqxtnb_z_zz(Zd, Zn, tszl, tszh)


/* UQXTNT  <Zd>.<T>, <Zn>.<Tb> (ffa7fc00/45204c00) */
//#define IEM_INSTR_IMPL_A64__uqxtnt_z_zz(Zd, Zn, tszl, tszh)



/*
 *
 * Instruction Set & Groups: sve_intx_histcnt_lvl2 / sve_intx_histcnt / sve / A64
 *
 */

/* HISTCNT  <Zd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e000/4520c000) */
//#define IEM_INSTR_IMPL_A64__histcnt_z_p_zz(Zd, Zn, Pg, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_histseg / sve_intx_histseg_lut / sve / A64
 *
 */

/* HISTSEG  <Zd>.B, <Zn>.B, <Zm>.B (ff20fc00/4520a000) */
//#define IEM_INSTR_IMPL_A64__histseg_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_lut2_16 / sve_intx_histseg_lut / sve / A64
 *
 */

/* LUTI2  <Zd>.H, { <Zn>.H }, <Zm>[<index>] (ff20ec00/4520a800) */
//#define IEM_INSTR_IMPL_A64__luti2_z_zz_16(Zd, Zn, i3l, Zm, i3h)



/*
 *
 * Instruction Set & Groups: sve_intx_lut2_8 / sve_intx_histseg_lut / sve / A64
 *
 */

/* LUTI2  <Zd>.B, { <Zn>.B }, <Zm>[<index>] (ff20fc00/4520b000) */
//#define IEM_INSTR_IMPL_A64__luti2_z_zz_8(Zd, Zn, Zm, i2)



/*
 *
 * Instruction Set & Groups: sve_intx_lut4_16 / sve_intx_histseg_lut / sve / A64
 *
 */

/* LUTI4  <Zd>.H, { <Zn1>.H, <Zn2>.H }, <Zm>[<index>] (ff20fc00/4520b400) */
//#define IEM_INSTR_IMPL_A64__luti4_z_zz_2x16(Zd, Zn, Zm, i2)


/* LUTI4  <Zd>.H, { <Zn>.H }, <Zm>[<index>] (ff20fc00/4520bc00) */
//#define IEM_INSTR_IMPL_A64__luti4_z_zz_1x16(Zd, Zn, Zm, i2)



/*
 *
 * Instruction Set & Groups: sve_intx_lut4_8 / sve_intx_histseg_lut / sve / A64
 *
 */

/* LUTI4  <Zd>.B, { <Zn>.B }, <Zm>[<index>] (ff60fc00/4560a400) */
//#define IEM_INSTR_IMPL_A64__luti4_z_zz_8(Zd, Zn, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_match / sve_intx_string / sve / A64
 *
 */

/* MATCH  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/45208000) */
//#define IEM_INSTR_IMPL_A64__match_p_p_zz(Pd, Zn, Pg, Zm, size)


/* NMATCH  <Pd>.<T>, <Pg>/Z, <Zn>.<T>, <Zm>.<T> (ff20e010/45208010) */
//#define IEM_INSTR_IMPL_A64__nmatch_p_p_zz(Pd, Zn, Pg, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_mixed_dot / sve_intx_muladd_unpred / sve / A64
 *
 */

/* USDOT  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/44807800) */
//#define IEM_INSTR_IMPL_A64__usdot_z_zzz_s(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_intx_mixed_dot_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* USDOT  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0fc00/44a01800) */
//#define IEM_INSTR_IMPL_A64__usdot_z_zzzi_s(Zda, Zn, Zm, i2)


/* SUDOT  <Zda>.S, <Zn>.B, <Zm>.B[<imm>] (ffe0fc00/44a01c00) */
//#define IEM_INSTR_IMPL_A64__sudot_z_zzzi_s(Zda, Zn, Zm, i2)



/*
 *
 * Instruction Set & Groups: sve_intx_mla_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* MLA  <Zda>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/44200800) */
//#define IEM_INSTR_IMPL_A64__mla_z_zzzi_h(Zda, Zn, Zm, i3l, i3h)


/* MLA  <Zda>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/44a00800) */
//#define IEM_INSTR_IMPL_A64__mla_z_zzzi_s(Zda, Zn, Zm, i2)


/* MLA  <Zda>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/44e00800) */
//#define IEM_INSTR_IMPL_A64__mla_z_zzzi_d(Zda, Zn, Zm, i1)


/* MLS  <Zda>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/44200c00) */
//#define IEM_INSTR_IMPL_A64__mls_z_zzzi_h(Zda, Zn, Zm, i3l, i3h)


/* MLS  <Zda>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/44a00c00) */
//#define IEM_INSTR_IMPL_A64__mls_z_zzzi_s(Zda, Zn, Zm, i2)


/* MLS  <Zda>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/44e00c00) */
//#define IEM_INSTR_IMPL_A64__mls_z_zzzi_d(Zda, Zn, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_mla_long_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* SMLALB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a08000) */
//#define IEM_INSTR_IMPL_A64__smlalb_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* SMLALB  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e08000) */
//#define IEM_INSTR_IMPL_A64__smlalb_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* SMLSLB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0a000) */
//#define IEM_INSTR_IMPL_A64__smlslb_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* SMLSLB  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0a000) */
//#define IEM_INSTR_IMPL_A64__smlslb_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* SMLALT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a08400) */
//#define IEM_INSTR_IMPL_A64__smlalt_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* SMLALT  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e08400) */
//#define IEM_INSTR_IMPL_A64__smlalt_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* SMLSLT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0a400) */
//#define IEM_INSTR_IMPL_A64__smlslt_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* SMLSLT  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0a400) */
//#define IEM_INSTR_IMPL_A64__smlslt_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* UMLALB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a09000) */
//#define IEM_INSTR_IMPL_A64__umlalb_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* UMLALB  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e09000) */
//#define IEM_INSTR_IMPL_A64__umlalb_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* UMLSLB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0b000) */
//#define IEM_INSTR_IMPL_A64__umlslb_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* UMLSLB  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0b000) */
//#define IEM_INSTR_IMPL_A64__umlslb_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* UMLALT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a09400) */
//#define IEM_INSTR_IMPL_A64__umlalt_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* UMLALT  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e09400) */
//#define IEM_INSTR_IMPL_A64__umlalt_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* UMLSLT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0b400) */
//#define IEM_INSTR_IMPL_A64__umlslt_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* UMLSLT  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0b400) */
//#define IEM_INSTR_IMPL_A64__umlslt_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)



/*
 *
 * Instruction Set & Groups: sve_intx_mlal_long / sve_intx_muladd_unpred / sve / A64
 *
 */

/* SMLALB  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44004000) */
//#define IEM_INSTR_IMPL_A64__smlalb_z_zzz(Zda, Zn, Zm, size)


/* SMLSLB  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44005000) */
//#define IEM_INSTR_IMPL_A64__smlslb_z_zzz(Zda, Zn, Zm, size)


/* SMLALT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44004400) */
//#define IEM_INSTR_IMPL_A64__smlalt_z_zzz(Zda, Zn, Zm, size)


/* SMLSLT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44005400) */
//#define IEM_INSTR_IMPL_A64__smlslt_z_zzz(Zda, Zn, Zm, size)


/* UMLALB  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44004800) */
//#define IEM_INSTR_IMPL_A64__umlalb_z_zzz(Zda, Zn, Zm, size)


/* UMLSLB  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44005800) */
//#define IEM_INSTR_IMPL_A64__umlslb_z_zzz(Zda, Zn, Zm, size)


/* UMLALT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44004c00) */
//#define IEM_INSTR_IMPL_A64__umlalt_z_zzz(Zda, Zn, Zm, size)


/* UMLSLT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44005c00) */
//#define IEM_INSTR_IMPL_A64__umlslt_z_zzz(Zda, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_mmla / sve_intx_constructive / sve / A64
 *
 */

/* SMMLA  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/45009800) */
//#define IEM_INSTR_IMPL_A64__smmla_z_zzz(Zda, Zn, Zm)


/* USMMLA  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/45809800) */
//#define IEM_INSTR_IMPL_A64__usmmla_z_zzz(Zda, Zn, Zm)


/* UMMLA  <Zda>.S, <Zn>.B, <Zm>.B (ffe0fc00/45c09800) */
//#define IEM_INSTR_IMPL_A64__ummla_z_zzz(Zda, Zn, Zm)



/*
 *
 * Instruction Set & Groups: sve_intx_mul_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* MUL  <Zd>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/4420f800) */
//#define IEM_INSTR_IMPL_A64__mul_z_zzi_h(Zd, Zn, Zm, i3l, i3h)


/* MUL  <Zd>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/44a0f800) */
//#define IEM_INSTR_IMPL_A64__mul_z_zzi_s(Zd, Zn, Zm, i2)


/* MUL  <Zd>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/44e0f800) */
//#define IEM_INSTR_IMPL_A64__mul_z_zzi_d(Zd, Zn, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_mul_long_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* SMULLB  <Zd>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0c000) */
//#define IEM_INSTR_IMPL_A64__smullb_z_zzi_s(Zd, Zn, i3l, Zm, i3h)


/* SMULLB  <Zd>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0c000) */
//#define IEM_INSTR_IMPL_A64__smullb_z_zzi_d(Zd, Zn, i2l, Zm, i2h)


/* SMULLT  <Zd>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0c400) */
//#define IEM_INSTR_IMPL_A64__smullt_z_zzi_s(Zd, Zn, i3l, Zm, i3h)


/* SMULLT  <Zd>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0c400) */
//#define IEM_INSTR_IMPL_A64__smullt_z_zzi_d(Zd, Zn, i2l, Zm, i2h)


/* UMULLB  <Zd>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0d000) */
//#define IEM_INSTR_IMPL_A64__umullb_z_zzi_s(Zd, Zn, i3l, Zm, i3h)


/* UMULLB  <Zd>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0d000) */
//#define IEM_INSTR_IMPL_A64__umullb_z_zzi_d(Zd, Zn, i2l, Zm, i2h)


/* UMULLT  <Zd>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0d400) */
//#define IEM_INSTR_IMPL_A64__umullt_z_zzi_s(Zd, Zn, i3l, Zm, i3h)


/* UMULLT  <Zd>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0d400) */
//#define IEM_INSTR_IMPL_A64__umullt_z_zzi_d(Zd, Zn, i2l, Zm, i2h)



/*
 *
 * Instruction Set & Groups: sve_intx_multi_extract_narrow / sve_intx_narrowing / sve / A64
 *
 */

/* SQCVTN  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/45314000) */
//#define IEM_INSTR_IMPL_A64__sqcvtn_z_mz2(Zd, Zn)


/* SQCVTUN  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/45315000) */
//#define IEM_INSTR_IMPL_A64__sqcvtun_z_mz2(Zd, Zn)


/* UQCVTN  <Zd>.H, { <Zn1>.S-<Zn2>.S } (fffffc20/45314800) */
//#define IEM_INSTR_IMPL_A64__uqcvtn_z_mz2(Zd, Zn)



/*
 *
 * Instruction Set & Groups: sve_intx_multi_shift_narrow / sve_intx_narrowing / sve / A64
 *
 */

/* SQRSHRN  <Zd>.H, { <Zn1>.S-<Zn2>.S }, #<const> (fff0fc20/45b02800) */
//#define IEM_INSTR_IMPL_A64__sqrshrn_z_mz2(Zd, Zn, imm4)


/* SQRSHRUN  <Zd>.H, { <Zn1>.S-<Zn2>.S }, #<const> (fff0fc20/45b00800) */
//#define IEM_INSTR_IMPL_A64__sqrshrun_z_mz2(Zd, Zn, imm4)


/* UQRSHRN  <Zd>.H, { <Zn1>.S-<Zn2>.S }, #<const> (fff0fc20/45b03800) */
//#define IEM_INSTR_IMPL_A64__uqrshrn_z_mz2(Zd, Zn, imm4)



/*
 *
 * Instruction Set & Groups: sve_intx_perm_bit / sve_intx_constructive / sve / A64
 *
 */

/* BEXT  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4500b000) */
//#define IEM_INSTR_IMPL_A64__bext_z_zz(Zd, Zn, Zm, size)


/* BDEP  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4500b400) */
//#define IEM_INSTR_IMPL_A64__bdep_z_zz(Zd, Zn, Zm, size)


/* BGRP  <Zd>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/4500b800) */
//#define IEM_INSTR_IMPL_A64__bgrp_z_zz(Zd, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_perm_extract_i / sve_perm_extract / sve / A64
 *
 */

/* EXT  <Zd>.B, { <Zn1>.B, <Zn2>.B }, #<imm> (ffe0e000/05600000) */
//#define IEM_INSTR_IMPL_A64__ext_z_zi_con(Zd, Zn, imm8l, imm8h)



/*
 *
 * Instruction Set & Groups: sve_intx_perm_splice / sve_perm_pred / sve / A64
 *
 */

/* SPLICE  <Zd>.<T>, <Pv>, { <Zn1>.<T>, <Zn2>.<T> } (ff3fe000/052d8000) */
//#define IEM_INSTR_IMPL_A64__splice_z_p_zz_con(Zd, Zn, Pv, size)



/*
 *
 * Instruction Set & Groups: sve_intx_pred_arith_binary / sve_intx_predicated / sve / A64
 *
 */

/* SHADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44108000) */
//#define IEM_INSTR_IMPL_A64__shadd_z_p_zz(Zdn, Zm, Pg, size)


/* SHSUB  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44128000) */
//#define IEM_INSTR_IMPL_A64__shsub_z_p_zz(Zdn, Zm, Pg, size)


/* SRHADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44148000) */
//#define IEM_INSTR_IMPL_A64__srhadd_z_p_zz(Zdn, Zm, Pg, size)


/* SHSUBR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44168000) */
//#define IEM_INSTR_IMPL_A64__shsubr_z_p_zz(Zdn, Zm, Pg, size)


/* UHADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44118000) */
//#define IEM_INSTR_IMPL_A64__uhadd_z_p_zz(Zdn, Zm, Pg, size)


/* UHSUB  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44138000) */
//#define IEM_INSTR_IMPL_A64__uhsub_z_p_zz(Zdn, Zm, Pg, size)


/* URHADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44158000) */
//#define IEM_INSTR_IMPL_A64__urhadd_z_p_zz(Zdn, Zm, Pg, size)


/* UHSUBR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44178000) */
//#define IEM_INSTR_IMPL_A64__uhsubr_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_intx_pred_arith_binary_sat / sve_intx_predicated / sve / A64
 *
 */

/* SQADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44188000) */
//#define IEM_INSTR_IMPL_A64__sqadd_z_p_zz(Zdn, Zm, Pg, size)


/* SQSUB  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/441a8000) */
//#define IEM_INSTR_IMPL_A64__sqsub_z_p_zz(Zdn, Zm, Pg, size)


/* SUQADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/441c8000) */
//#define IEM_INSTR_IMPL_A64__suqadd_z_p_zz(Zdn, Zm, Pg, size)


/* USQADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/441d8000) */
//#define IEM_INSTR_IMPL_A64__usqadd_z_p_zz(Zdn, Zm, Pg, size)


/* SQSUBR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/441e8000) */
//#define IEM_INSTR_IMPL_A64__sqsubr_z_p_zz(Zdn, Zm, Pg, size)


/* UQADD  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/44198000) */
//#define IEM_INSTR_IMPL_A64__uqadd_z_p_zz(Zdn, Zm, Pg, size)


/* UQSUB  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/441b8000) */
//#define IEM_INSTR_IMPL_A64__uqsub_z_p_zz(Zdn, Zm, Pg, size)


/* UQSUBR  <Zdn>.<T>, <Pg>/M, <Zdn>.<T>, <Zm>.<T> (ff3fe000/441f8000) */
//#define IEM_INSTR_IMPL_A64__uqsubr_z_p_zz(Zdn, Zm, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_intx_pred_arith_unary / sve_intx_predicated / sve / A64
 *
 */

/* URECPE  <Zd>.S, <Pg>/M, <Zn>.S (ff3fe000/4400a000) */
//#define IEM_INSTR_IMPL_A64__urecpe_z_p_z_m(Zd, Zn, Pg, size)


/* URECPE  <Zd>.S, <Pg>/Z, <Zn>.S (ff3fe000/4402a000) */
//#define IEM_INSTR_IMPL_A64__urecpe_z_p_z_z(Zd, Zn, Pg, size)


/* URSQRTE  <Zd>.S, <Pg>/M, <Zn>.S (ff3fe000/4401a000) */
//#define IEM_INSTR_IMPL_A64__ursqrte_z_p_z_m(Zd, Zn, Pg, size)


/* URSQRTE  <Zd>.S, <Pg>/Z, <Zn>.S (ff3fe000/4403a000) */
//#define IEM_INSTR_IMPL_A64__ursqrte_z_p_z_z(Zd, Zn, Pg, size)


/* SQABS  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/4408a000) */
//#define IEM_INSTR_IMPL_A64__sqabs_z_p_z_m(Zd, Zn, Pg, size)


/* SQABS  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/440aa000) */
//#define IEM_INSTR_IMPL_A64__sqabs_z_p_z_z(Zd, Zn, Pg, size)


/* SQNEG  <Zd>.<T>, <Pg>/M, <Zn>.<T> (ff3fe000/4409a000) */
//#define IEM_INSTR_IMPL_A64__sqneg_z_p_z_m(Zd, Zn, Pg, size)


/* SQNEG  <Zd>.<T>, <Pg>/Z, <Zn>.<T> (ff3fe000/440ba000) */
//#define IEM_INSTR_IMPL_A64__sqneg_z_p_z_z(Zd, Zn, Pg, size)



/*
 *
 * Instruction Set & Groups: sve_intx_qdmla_long_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* SQDMLALB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a02000) */
//#define IEM_INSTR_IMPL_A64__sqdmlalb_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* SQDMLALB  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e02000) */
//#define IEM_INSTR_IMPL_A64__sqdmlalb_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* SQDMLSLB  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a03000) */
//#define IEM_INSTR_IMPL_A64__sqdmlslb_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* SQDMLSLB  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e03000) */
//#define IEM_INSTR_IMPL_A64__sqdmlslb_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* SQDMLALT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a02400) */
//#define IEM_INSTR_IMPL_A64__sqdmlalt_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* SQDMLALT  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e02400) */
//#define IEM_INSTR_IMPL_A64__sqdmlalt_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)


/* SQDMLSLT  <Zda>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a03400) */
//#define IEM_INSTR_IMPL_A64__sqdmlslt_z_zzzi_s(Zda, Zn, i3l, Zm, i3h)


/* SQDMLSLT  <Zda>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e03400) */
//#define IEM_INSTR_IMPL_A64__sqdmlslt_z_zzzi_d(Zda, Zn, i2l, Zm, i2h)



/*
 *
 * Instruction Set & Groups: sve_intx_qdmlal_long / sve_intx_muladd_unpred / sve / A64
 *
 */

/* SQDMLALB  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44006000) */
//#define IEM_INSTR_IMPL_A64__sqdmlalb_z_zzz(Zda, Zn, Zm, size)


/* SQDMLSLB  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44006800) */
//#define IEM_INSTR_IMPL_A64__sqdmlslb_z_zzz(Zda, Zn, Zm, size)


/* SQDMLALT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44006400) */
//#define IEM_INSTR_IMPL_A64__sqdmlalt_z_zzz(Zda, Zn, Zm, size)


/* SQDMLSLT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44006c00) */
//#define IEM_INSTR_IMPL_A64__sqdmlslt_z_zzz(Zda, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_qdmlalbt / sve_intx_muladd_unpred / sve / A64
 *
 */

/* SQDMLALBT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44000800) */
//#define IEM_INSTR_IMPL_A64__sqdmlalbt_z_zzz(Zda, Zn, Zm, size)


/* SQDMLSLBT  <Zda>.<T>, <Zn>.<Tb>, <Zm>.<Tb> (ff20fc00/44000c00) */
//#define IEM_INSTR_IMPL_A64__sqdmlslbt_z_zzz(Zda, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_qdmul_long_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* SQDMULLB  <Zd>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0e000) */
//#define IEM_INSTR_IMPL_A64__sqdmullb_z_zzi_s(Zd, Zn, i3l, Zm, i3h)


/* SQDMULLB  <Zd>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0e000) */
//#define IEM_INSTR_IMPL_A64__sqdmullb_z_zzi_d(Zd, Zn, i2l, Zm, i2h)


/* SQDMULLT  <Zd>.S, <Zn>.H, <Zm>.H[<imm>] (ffe0f400/44a0e400) */
//#define IEM_INSTR_IMPL_A64__sqdmullt_z_zzi_s(Zd, Zn, i3l, Zm, i3h)


/* SQDMULLT  <Zd>.D, <Zn>.S, <Zm>.S[<imm>] (ffe0f400/44e0e400) */
//#define IEM_INSTR_IMPL_A64__sqdmullt_z_zzi_d(Zd, Zn, i2l, Zm, i2h)



/*
 *
 * Instruction Set & Groups: sve_intx_qdmulh_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* SQDMULH  <Zd>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/4420f000) */
//#define IEM_INSTR_IMPL_A64__sqdmulh_z_zzi_h(Zd, Zn, Zm, i3l, i3h)


/* SQDMULH  <Zd>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/44a0f000) */
//#define IEM_INSTR_IMPL_A64__sqdmulh_z_zzi_s(Zd, Zn, Zm, i2)


/* SQDMULH  <Zd>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/44e0f000) */
//#define IEM_INSTR_IMPL_A64__sqdmulh_z_zzi_d(Zd, Zn, Zm, i1)


/* SQRDMULH  <Zd>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/4420f400) */
//#define IEM_INSTR_IMPL_A64__sqrdmulh_z_zzi_h(Zd, Zn, Zm, i3l, i3h)


/* SQRDMULH  <Zd>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/44a0f400) */
//#define IEM_INSTR_IMPL_A64__sqrdmulh_z_zzi_s(Zd, Zn, Zm, i2)


/* SQRDMULH  <Zd>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/44e0f400) */
//#define IEM_INSTR_IMPL_A64__sqrdmulh_z_zzi_d(Zd, Zn, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_qrdcmla_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* SQRDCMLAH  <Zda>.H, <Zn>.H, <Zm>.H[<imm>], <const> (ffe0f000/44a07000) */
//#define IEM_INSTR_IMPL_A64__sqrdcmlah_z_zzzi_h(Zda, Zn, rot, Zm, i2)


/* SQRDCMLAH  <Zda>.S, <Zn>.S, <Zm>.S[<imm>], <const> (ffe0f000/44e07000) */
//#define IEM_INSTR_IMPL_A64__sqrdcmlah_z_zzzi_s(Zda, Zn, rot, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_qrdmlah / sve_intx_muladd_unpred / sve / A64
 *
 */

/* SQRDMLAH  <Zda>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/44007000) */
//#define IEM_INSTR_IMPL_A64__sqrdmlah_z_zzz(Zda, Zn, Zm, size)


/* SQRDMLSH  <Zda>.<T>, <Zn>.<T>, <Zm>.<T> (ff20fc00/44007400) */
//#define IEM_INSTR_IMPL_A64__sqrdmlsh_z_zzz(Zda, Zn, Zm, size)



/*
 *
 * Instruction Set & Groups: sve_intx_qrdmlah_by_indexed_elem / sve_intx_by_indexed_elem / sve / A64
 *
 */

/* SQRDMLAH  <Zda>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/44201000) */
//#define IEM_INSTR_IMPL_A64__sqrdmlah_z_zzzi_h(Zda, Zn, Zm, i3l, i3h)


/* SQRDMLAH  <Zda>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/44a01000) */
//#define IEM_INSTR_IMPL_A64__sqrdmlah_z_zzzi_s(Zda, Zn, Zm, i2)


/* SQRDMLAH  <Zda>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/44e01000) */
//#define IEM_INSTR_IMPL_A64__sqrdmlah_z_zzzi_d(Zda, Zn, Zm, i1)


/* SQRDMLSH  <Zda>.H, <Zn>.H, <Zm>.H[<imm>] (ffa0fc00/44201400) */
//#define IEM_INSTR_IMPL_A64__sqrdmlsh_z_zzzi_h(Zda, Zn, Zm, i3l, i3h)


/* SQRDMLSH  <Zda>.S, <Zn>.S, <Zm>.S[<imm>] (ffe0fc00/44a01400) */
//#define IEM_INSTR_IMPL_A64__sqrdmlsh_z_zzzi_s(Zda, Zn, Zm, i2)


/* SQRDMLSH  <Zda>.D, <Zn>.D, <Zm>.D[<imm>] (ffe0fc00/44e01400) */
//#define IEM_INSTR_IMPL_A64__sqrdmlsh_z_zzzi_d(Zda, Zn, Zm, i1)



/*
 *
 * Instruction Set & Groups: sve_intx_shift_insert / sve_intx_acc / sve / A64
 *
 */

/* SRI  <Zd>.<T>, <Zn>.<T>, #<const> (ff20fc00/4500f000) */
//#define IEM_INSTR_IMPL_A64__sri_z_zzi(Zd, Zn, imm3, tszl, tszh)


/* SLI  <Zd>.<T>, <Zn>.<T>, #<const> (ff20fc00/4500f400) */
//#define IEM_INSTR_IMPL_A64__sli_z_zzi(Zd, Zn, imm3, tszl, tszh)



/*
 *
 * Instruction Set & Groups: sve_intx_shift_long / sve_intx_constructive / sve / A64
 *
 */

/* SSHLLB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/4500a000) */
//#define IEM_INSTR_IMPL_A64__sshllb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SSHLLT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/4500a400) */
//#define IEM_INSTR_IMPL_A64__sshllt_z_zi(Zd, Zn, imm3, tszl, tszh)


/* USHLLB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/4500a800) */
//#define IEM_INSTR_IMPL_A64__ushllb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* USHLLT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/4500ac00) */
//#define IEM_INSTR_IMPL_A64__ushllt_z_zi(Zd, Zn, imm3, tszl, tszh)



/*
 *
 * Instruction Set & Groups: sve_intx_shift_narrow / sve_intx_narrowing / sve / A64
 *
 */

/* SQSHRUNB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45200000) */
//#define IEM_INSTR_IMPL_A64__sqshrunb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SQRSHRUNB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45200800) */
//#define IEM_INSTR_IMPL_A64__sqrshrunb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SHRNB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45201000) */
//#define IEM_INSTR_IMPL_A64__shrnb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* RSHRNB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45201800) */
//#define IEM_INSTR_IMPL_A64__rshrnb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SQSHRNB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45202000) */
//#define IEM_INSTR_IMPL_A64__sqshrnb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SQRSHRNB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45202800) */
//#define IEM_INSTR_IMPL_A64__sqrshrnb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SQSHRUNT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45200400) */
//#define IEM_INSTR_IMPL_A64__sqshrunt_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SQRSHRUNT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45200c00) */
//#define IEM_INSTR_IMPL_A64__sqrshrunt_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SHRNT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45201400) */
//#define IEM_INSTR_IMPL_A64__shrnt_z_zi(Zd, Zn, imm3, tszl, tszh)


/* RSHRNT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45201c00) */
//#define IEM_INSTR_IMPL_A64__rshrnt_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SQSHRNT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45202400) */
//#define IEM_INSTR_IMPL_A64__sqshrnt_z_zi(Zd, Zn, imm3, tszl, tszh)


/* SQRSHRNT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45202c00) */
//#define IEM_INSTR_IMPL_A64__sqrshrnt_z_zi(Zd, Zn, imm3, tszl, tszh)


/* UQSHRNB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45203000) */
//#define IEM_INSTR_IMPL_A64__uqshrnb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* UQRSHRNB  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45203800) */
//#define IEM_INSTR_IMPL_A64__uqrshrnb_z_zi(Zd, Zn, imm3, tszl, tszh)


/* UQSHRNT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45203400) */
//#define IEM_INSTR_IMPL_A64__uqshrnt_z_zi(Zd, Zn, imm3, tszl, tszh)


/* UQRSHRNT  <Zd>.<T>, <Zn>.<Tb>, #<const> (ffa0fc00/45203c00) */
//#define IEM_INSTR_IMPL_A64__uqrshrnt_z_zi(Zd, Zn, imm3, tszl, tszh)



/*
 *
 * Instruction Set & Groups: sve_intx_sra / sve_intx_acc / sve / A64
 *
 */

/* SSRA  <Zda>.<T>, <Zn>.<T>, #<const> (ff20fc00/4500e000) */
//#define IEM_INSTR_IMPL_A64__ssra_z_zi(Zda, Zn, imm3, tszl, tszh)


/* SRSRA  <Zda>.<T>, <Zn>.<T>, #<const> (ff20fc00/4500e800) */
//#define IEM_INSTR_IMPL_A64__srsra_z_zi(Zda, Zn, imm3, tszl, tszh)


/* USRA  <Zda>.<T>, <Zn>.<T>, #<const> (ff20fc00/4500e400) */
//#define IEM_INSTR_IMPL_A64__usra_z_zi(Zda, Zn, imm3, tszl, tszh)


/* URSRA  <Zda>.<T>, <Zn>.<T>, #<const> (ff20fc00/4500ec00) */
//#define IEM_INSTR_IMPL_A64__ursra_z_zi(Zda, Zn, imm3, tszl, tszh)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_fill / sve_mem32 / sve / A64
 *
 */

/* LDR  <Zt>, [<Xn|SP>{, #<imm>, MUL VL}] (ffc0e000/85804000) */
//#define IEM_INSTR_IMPL_A64__ldr_z_bi(Zt, Rn, imm9l, imm9h)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_gld_sv_a / sve_mem32 / sve / A64
 *
 */

/* LD1SH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod> #1] (ffa0e000/84a00000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_bz_s_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LD1H  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod> #1] (ffa0e000/84a04000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bz_s_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1SH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod> #1] (ffa0e000/84a02000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_bz_s_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1H  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod> #1] (ffa0e000/84a06000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_bz_s_x32_scaled(Zt, Rn, Pg, Zm, xs)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_gld_sv_b / sve_mem32 / sve / A64
 *
 */

/* LD1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod> #2] (ffa0e000/85204000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bz_s_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod> #2] (ffa0e000/85206000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_bz_s_x32_scaled(Zt, Rn, Pg, Zm, xs)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_gld_vi / sve_mem32 / sve / A64
 *
 */

/* LD1SB  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/84208000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LD1SH  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/84a08000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LD1W  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/8520c000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LD1B  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/8420c000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LD1H  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/84a0c000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LDFF1SB  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/8420a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sb_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LDFF1SH  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/84a0a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LDFF1W  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/8520e000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LDFF1B  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/8420e000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_ai_s(Zt, Zn, Pg, imm5)


/* LDFF1H  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, #<imm>}] (ffe0e000/84a0e000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_ai_s(Zt, Zn, Pg, imm5)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_gld_vs / sve_mem32 / sve / A64
 *
 */

/* LD1SB  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/84000000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1SH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/84800000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/85004000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1B  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/84004000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1H  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/84804000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1SB  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/84002000) */
//#define IEM_INSTR_IMPL_A64__ldff1sb_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1SH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/84802000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/85006000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1B  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/84006000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1H  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e000/84806000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, Zm, xs)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_gldnt_vs / sve_mem32 / sve / A64
 *
 */

/* LDNT1SB  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, <Xm>}] (ffe0e000/84008000) */
//#define IEM_INSTR_IMPL_A64__ldnt1sb_z_p_ar_s_x32_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1SH  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, <Xm>}] (ffe0e000/84808000) */
//#define IEM_INSTR_IMPL_A64__ldnt1sh_z_p_ar_s_x32_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1W  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, <Xm>}] (ffe0e000/8500a000) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_z_p_ar_s_x32_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1B  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, <Xm>}] (ffe0e000/8400a000) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_z_p_ar_s_x32_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1H  { <Zt>.S }, <Pg>/Z, [<Zn>.S{, <Xm>}] (ffe0e000/8480a000) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_z_p_ar_s_x32_unscaled(Zt, Zn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_pfill / sve_mem32 / sve / A64
 *
 */

/* LDR  <Pt>, [<Xn|SP>{, #<imm>, MUL VL}] (ffc0e010/85800000) */
//#define IEM_INSTR_IMPL_A64__ldr_p_bi(Pt, Rn, imm9l, imm9h)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_prfm_sv / sve_mem32 / sve / A64
 *
 */

/* PRFB  <prfop>, <Pg>, [<Xn|SP>, <Zm>.S, <mod>] (ffa0e010/84200000) */
//#define IEM_INSTR_IMPL_A64__prfb_i_p_bz_s_x32_scaled(prfop, Rn, Pg, Zm, xs)


/* PRFH  <prfop>, <Pg>, [<Xn|SP>, <Zm>.S, <mod> #1] (ffa0e010/84202000) */
//#define IEM_INSTR_IMPL_A64__prfh_i_p_bz_s_x32_scaled(prfop, Rn, Pg, Zm, xs)


/* PRFW  <prfop>, <Pg>, [<Xn|SP>, <Zm>.S, <mod> #2] (ffa0e010/84204000) */
//#define IEM_INSTR_IMPL_A64__prfw_i_p_bz_s_x32_scaled(prfop, Rn, Pg, Zm, xs)


/* PRFD  <prfop>, <Pg>, [<Xn|SP>, <Zm>.S, <mod> #3] (ffa0e010/84206000) */
//#define IEM_INSTR_IMPL_A64__prfd_i_p_bz_s_x32_scaled(prfop, Rn, Pg, Zm, xs)



/*
 *
 * Instruction Set & Groups: sve_mem_32b_prfm_vi / sve_mem32 / sve / A64
 *
 */

/* PRFB  <prfop>, <Pg>, [<Zn>.S{, #<imm>}] (ffe0e010/8400e000) */
//#define IEM_INSTR_IMPL_A64__prfb_i_p_ai_s(prfop, Zn, Pg, imm5)


/* PRFH  <prfop>, <Pg>, [<Zn>.S{, #<imm>}] (ffe0e010/8480e000) */
//#define IEM_INSTR_IMPL_A64__prfh_i_p_ai_s(prfop, Zn, Pg, imm5)


/* PRFW  <prfop>, <Pg>, [<Zn>.S{, #<imm>}] (ffe0e010/8500e000) */
//#define IEM_INSTR_IMPL_A64__prfw_i_p_ai_s(prfop, Zn, Pg, imm5)


/* PRFD  <prfop>, <Pg>, [<Zn>.S{, #<imm>}] (ffe0e010/8580e000) */
//#define IEM_INSTR_IMPL_A64__prfd_i_p_ai_s(prfop, Zn, Pg, imm5)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_gld_sv / sve_mem64 / sve / A64
 *
 */

/* LD1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #1] (ffa0e000/c4a00000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LD1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #2] (ffa0e000/c5200000) */
//#define IEM_INSTR_IMPL_A64__ld1sw_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LD1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #3] (ffa0e000/c5a04000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LD1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #1] (ffa0e000/c4a04000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LD1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #2] (ffa0e000/c5204000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #1] (ffa0e000/c4a02000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #2] (ffa0e000/c5202000) */
//#define IEM_INSTR_IMPL_A64__ldff1sw_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #3] (ffa0e000/c5a06000) */
//#define IEM_INSTR_IMPL_A64__ldff1d_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #1] (ffa0e000/c4a06000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod> #2] (ffa0e000/c5206000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_bz_d_x32_scaled(Zt, Rn, Pg, Zm, xs)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_gld_sv2 / sve_mem64 / sve / A64
 *
 */

/* LD1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #1] (ffe0e000/c4e08000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LD1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #2] (ffe0e000/c5608000) */
//#define IEM_INSTR_IMPL_A64__ld1sw_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LD1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #3] (ffe0e000/c5e0c000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LD1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #1] (ffe0e000/c4e0c000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LD1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #2] (ffe0e000/c560c000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LDFF1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #1] (ffe0e000/c4e0a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LDFF1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #2] (ffe0e000/c560a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sw_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LDFF1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #3] (ffe0e000/c5e0e000) */
//#define IEM_INSTR_IMPL_A64__ldff1d_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LDFF1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #1] (ffe0e000/c4e0e000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* LDFF1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, LSL #2] (ffe0e000/c560e000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_gld_vi / sve_mem64 / sve / A64
 *
 */

/* LD1SB  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c4208000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LD1SH  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c4a08000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LD1SW  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c5208000) */
//#define IEM_INSTR_IMPL_A64__ld1sw_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LD1D  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c5a0c000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LD1B  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c420c000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LD1H  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c4a0c000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LD1W  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c520c000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LDFF1SB  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c420a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sb_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LDFF1SH  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c4a0a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LDFF1SW  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c520a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sw_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LDFF1D  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c5a0e000) */
//#define IEM_INSTR_IMPL_A64__ldff1d_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LDFF1B  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c420e000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LDFF1H  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c4a0e000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_ai_d(Zt, Zn, Pg, imm5)


/* LDFF1W  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, #<imm>}] (ffe0e000/c520e000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_ai_d(Zt, Zn, Pg, imm5)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_gld_vs / sve_mem64 / sve / A64
 *
 */

/* LD1SB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c4000000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c4800000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c5000000) */
//#define IEM_INSTR_IMPL_A64__ld1sw_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c5804000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1B  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c4004000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c4804000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LD1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c5004000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1SB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c4002000) */
//#define IEM_INSTR_IMPL_A64__ldff1sb_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c4802000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c5002000) */
//#define IEM_INSTR_IMPL_A64__ldff1sw_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c5806000) */
//#define IEM_INSTR_IMPL_A64__ldff1d_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1B  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c4006000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c4806000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)


/* LDFF1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e000/c5006000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, Zm, xs)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_gld_vs2 / sve_mem64 / sve / A64
 *
 */

/* LD1SB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c4408000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LD1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c4c08000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LD1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c5408000) */
//#define IEM_INSTR_IMPL_A64__ld1sw_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LD1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c5c0c000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LD1B  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c440c000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LD1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c4c0c000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LD1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c540c000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LDFF1SB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c440a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sb_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LDFF1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c4c0a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LDFF1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c540a000) */
//#define IEM_INSTR_IMPL_A64__ldff1sw_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LDFF1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c5c0e000) */
//#define IEM_INSTR_IMPL_A64__ldff1d_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LDFF1B  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c440e000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LDFF1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c4c0e000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* LDFF1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Zm>.D] (ffe0e000/c540e000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_gldnt_vs / sve_mem64 / sve / A64
 *
 */

/* LDNT1SB  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, <Xm>}] (ffe0e000/c4008000) */
//#define IEM_INSTR_IMPL_A64__ldnt1sb_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1SH  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, <Xm>}] (ffe0e000/c4808000) */
//#define IEM_INSTR_IMPL_A64__ldnt1sh_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1SW  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, <Xm>}] (ffe0e000/c5008000) */
//#define IEM_INSTR_IMPL_A64__ldnt1sw_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1D  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, <Xm>}] (ffe0e000/c580c000) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1B  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, <Xm>}] (ffe0e000/c400c000) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1H  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, <Xm>}] (ffe0e000/c480c000) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* LDNT1W  { <Zt>.D }, <Pg>/Z, [<Zn>.D{, <Xm>}] (ffe0e000/c500c000) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_gldq_vs / sve_mem64 / sve / A64
 *
 */

/* LD1Q  { <Zt>.Q }, <Pg>/Z, [<Zn>.D{, <Xm>}] (ffe0e000/c400a000) */
//#define IEM_INSTR_IMPL_A64__ld1q_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_prfm_sv / sve_mem64 / sve / A64
 *
 */

/* PRFB  <prfop>, <Pg>, [<Xn|SP>, <Zm>.D, <mod>] (ffa0e010/c4200000) */
//#define IEM_INSTR_IMPL_A64__prfb_i_p_bz_d_x32_scaled(prfop, Rn, Pg, Zm, xs)


/* PRFH  <prfop>, <Pg>, [<Xn|SP>, <Zm>.D, <mod> #1] (ffa0e010/c4202000) */
//#define IEM_INSTR_IMPL_A64__prfh_i_p_bz_d_x32_scaled(prfop, Rn, Pg, Zm, xs)


/* PRFW  <prfop>, <Pg>, [<Xn|SP>, <Zm>.D, <mod> #2] (ffa0e010/c4204000) */
//#define IEM_INSTR_IMPL_A64__prfw_i_p_bz_d_x32_scaled(prfop, Rn, Pg, Zm, xs)


/* PRFD  <prfop>, <Pg>, [<Xn|SP>, <Zm>.D, <mod> #3] (ffa0e010/c4206000) */
//#define IEM_INSTR_IMPL_A64__prfd_i_p_bz_d_x32_scaled(prfop, Rn, Pg, Zm, xs)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_prfm_sv2 / sve_mem64 / sve / A64
 *
 */

/* PRFB  <prfop>, <Pg>, [<Xn|SP>, <Zm>.D] (ffe0e010/c4608000) */
//#define IEM_INSTR_IMPL_A64__prfb_i_p_bz_d_64_scaled(prfop, Rn, Pg, Zm)


/* PRFH  <prfop>, <Pg>, [<Xn|SP>, <Zm>.D, LSL #1] (ffe0e010/c460a000) */
//#define IEM_INSTR_IMPL_A64__prfh_i_p_bz_d_64_scaled(prfop, Rn, Pg, Zm)


/* PRFW  <prfop>, <Pg>, [<Xn|SP>, <Zm>.D, LSL #2] (ffe0e010/c460c000) */
//#define IEM_INSTR_IMPL_A64__prfw_i_p_bz_d_64_scaled(prfop, Rn, Pg, Zm)


/* PRFD  <prfop>, <Pg>, [<Xn|SP>, <Zm>.D, LSL #3] (ffe0e010/c460e000) */
//#define IEM_INSTR_IMPL_A64__prfd_i_p_bz_d_64_scaled(prfop, Rn, Pg, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_64b_prfm_vi / sve_mem64 / sve / A64
 *
 */

/* PRFB  <prfop>, <Pg>, [<Zn>.D{, #<imm>}] (ffe0e010/c400e000) */
//#define IEM_INSTR_IMPL_A64__prfb_i_p_ai_d(prfop, Zn, Pg, imm5)


/* PRFH  <prfop>, <Pg>, [<Zn>.D{, #<imm>}] (ffe0e010/c480e000) */
//#define IEM_INSTR_IMPL_A64__prfh_i_p_ai_d(prfop, Zn, Pg, imm5)


/* PRFW  <prfop>, <Pg>, [<Zn>.D{, #<imm>}] (ffe0e010/c500e000) */
//#define IEM_INSTR_IMPL_A64__prfw_i_p_ai_d(prfop, Zn, Pg, imm5)


/* PRFD  <prfop>, <Pg>, [<Zn>.D{, #<imm>}] (ffe0e010/c580e000) */
//#define IEM_INSTR_IMPL_A64__prfd_i_p_ai_d(prfop, Zn, Pg, imm5)



/*
 *
 * Instruction Set & Groups: sve_mem_cld_si / sve_memcld / sve / A64
 *
 */

/* LD1B  { <Zt>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a400a000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_bi_u8(Zt, Rn, Pg, imm4)


/* LD1B  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a420a000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_bi_u16(Zt, Rn, Pg, imm4)


/* LD1B  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a440a000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_bi_u32(Zt, Rn, Pg, imm4)


/* LD1B  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a460a000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_bi_u64(Zt, Rn, Pg, imm4)


/* LD1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a480a000) */
//#define IEM_INSTR_IMPL_A64__ld1sw_z_p_bi_s64(Zt, Rn, Pg, imm4)


/* LD1H  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4a0a000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bi_u16(Zt, Rn, Pg, imm4)


/* LD1H  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4c0a000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bi_u32(Zt, Rn, Pg, imm4)


/* LD1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4e0a000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_bi_u64(Zt, Rn, Pg, imm4)


/* LD1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a500a000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_bi_s64(Zt, Rn, Pg, imm4)


/* LD1SH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a520a000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_bi_s32(Zt, Rn, Pg, imm4)


/* LD1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a540a000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bi_u32(Zt, Rn, Pg, imm4)


/* LD1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a560a000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bi_u64(Zt, Rn, Pg, imm4)


/* LD1SB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a580a000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_bi_s64(Zt, Rn, Pg, imm4)


/* LD1SB  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5a0a000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_bi_s32(Zt, Rn, Pg, imm4)


/* LD1SB  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5c0a000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_bi_s16(Zt, Rn, Pg, imm4)


/* LD1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5e0a000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_bi_u64(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_cld_si_q / sve_memcld / sve / A64
 *
 */

/* LD1W  { <Zt>.Q }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5102000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_bi_u128(Zt, Rn, Pg, imm4)


/* LD1D  { <Zt>.Q }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5902000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_bi_u128(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_cld_ss / sve_memcld / sve / A64
 *
 */

/* LD1B  { <Zt>.B }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a4004000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_br_u8(Zt, Rn, Pg, Rm)


/* LD1B  { <Zt>.H }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a4204000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_br_u16(Zt, Rn, Pg, Rm)


/* LD1B  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a4404000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_br_u32(Zt, Rn, Pg, Rm)


/* LD1B  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a4604000) */
//#define IEM_INSTR_IMPL_A64__ld1b_z_p_br_u64(Zt, Rn, Pg, Rm)


/* LD1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a4804000) */
//#define IEM_INSTR_IMPL_A64__ld1sw_z_p_br_s64(Zt, Rn, Pg, Rm)


/* LD1H  { <Zt>.H }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a4a04000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_br_u16(Zt, Rn, Pg, Rm)


/* LD1H  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a4c04000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_br_u32(Zt, Rn, Pg, Rm)


/* LD1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a4e04000) */
//#define IEM_INSTR_IMPL_A64__ld1h_z_p_br_u64(Zt, Rn, Pg, Rm)


/* LD1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a5004000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_br_s64(Zt, Rn, Pg, Rm)


/* LD1SH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a5204000) */
//#define IEM_INSTR_IMPL_A64__ld1sh_z_p_br_s32(Zt, Rn, Pg, Rm)


/* LD1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a5404000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_br_u32(Zt, Rn, Pg, Rm)


/* LD1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a5604000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_br_u64(Zt, Rn, Pg, Rm)


/* LD1SB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a5804000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_br_s64(Zt, Rn, Pg, Rm)


/* LD1SB  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a5a04000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_br_s32(Zt, Rn, Pg, Rm)


/* LD1SB  { <Zt>.H }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a5c04000) */
//#define IEM_INSTR_IMPL_A64__ld1sb_z_p_br_s16(Zt, Rn, Pg, Rm)


/* LD1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/a5e04000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_br_u64(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_cld_ss_q / sve_memcld / sve / A64
 *
 */

/* LD1W  { <Zt>.Q }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a5008000) */
//#define IEM_INSTR_IMPL_A64__ld1w_z_p_br_u128(Zt, Rn, Pg, Rm)


/* LD1D  { <Zt>.Q }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/a5808000) */
//#define IEM_INSTR_IMPL_A64__ld1d_z_p_br_u128(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_cldff_ss / sve_memcld / sve / A64
 *
 */

/* LDFF1B  { <Zt>.B }, <Pg>/Z, [<Xn|SP>{, <Xm>}] (ffe0e000/a4006000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_br_u8(Zt, Rn, Pg, Rm)


/* LDFF1B  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, <Xm>}] (ffe0e000/a4206000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_br_u16(Zt, Rn, Pg, Rm)


/* LDFF1B  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, <Xm>}] (ffe0e000/a4406000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_br_u32(Zt, Rn, Pg, Rm)


/* LDFF1B  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, <Xm>}] (ffe0e000/a4606000) */
//#define IEM_INSTR_IMPL_A64__ldff1b_z_p_br_u64(Zt, Rn, Pg, Rm)


/* LDFF1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #2}] (ffe0e000/a4806000) */
//#define IEM_INSTR_IMPL_A64__ldff1sw_z_p_br_s64(Zt, Rn, Pg, Rm)


/* LDFF1H  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #1}] (ffe0e000/a4a06000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_br_u16(Zt, Rn, Pg, Rm)


/* LDFF1H  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #1}] (ffe0e000/a4c06000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_br_u32(Zt, Rn, Pg, Rm)


/* LDFF1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #1}] (ffe0e000/a4e06000) */
//#define IEM_INSTR_IMPL_A64__ldff1h_z_p_br_u64(Zt, Rn, Pg, Rm)


/* LDFF1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #1}] (ffe0e000/a5006000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_br_s64(Zt, Rn, Pg, Rm)


/* LDFF1SH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #1}] (ffe0e000/a5206000) */
//#define IEM_INSTR_IMPL_A64__ldff1sh_z_p_br_s32(Zt, Rn, Pg, Rm)


/* LDFF1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #2}] (ffe0e000/a5406000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_br_u32(Zt, Rn, Pg, Rm)


/* LDFF1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #2}] (ffe0e000/a5606000) */
//#define IEM_INSTR_IMPL_A64__ldff1w_z_p_br_u64(Zt, Rn, Pg, Rm)


/* LDFF1SB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, <Xm>}] (ffe0e000/a5806000) */
//#define IEM_INSTR_IMPL_A64__ldff1sb_z_p_br_s64(Zt, Rn, Pg, Rm)


/* LDFF1SB  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, <Xm>}] (ffe0e000/a5a06000) */
//#define IEM_INSTR_IMPL_A64__ldff1sb_z_p_br_s32(Zt, Rn, Pg, Rm)


/* LDFF1SB  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, <Xm>}] (ffe0e000/a5c06000) */
//#define IEM_INSTR_IMPL_A64__ldff1sb_z_p_br_s16(Zt, Rn, Pg, Rm)


/* LDFF1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, <Xm>, LSL #3}] (ffe0e000/a5e06000) */
//#define IEM_INSTR_IMPL_A64__ldff1d_z_p_br_u64(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_cldnf_si / sve_memcld / sve / A64
 *
 */

/* LDNF1B  { <Zt>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a410a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1b_z_p_bi_u8(Zt, Rn, Pg, imm4)


/* LDNF1B  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a430a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1b_z_p_bi_u16(Zt, Rn, Pg, imm4)


/* LDNF1B  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a450a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1b_z_p_bi_u32(Zt, Rn, Pg, imm4)


/* LDNF1B  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a470a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1b_z_p_bi_u64(Zt, Rn, Pg, imm4)


/* LDNF1SW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a490a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1sw_z_p_bi_s64(Zt, Rn, Pg, imm4)


/* LDNF1H  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4b0a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1h_z_p_bi_u16(Zt, Rn, Pg, imm4)


/* LDNF1H  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4d0a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1h_z_p_bi_u32(Zt, Rn, Pg, imm4)


/* LDNF1H  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4f0a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1h_z_p_bi_u64(Zt, Rn, Pg, imm4)


/* LDNF1SH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a510a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1sh_z_p_bi_s64(Zt, Rn, Pg, imm4)


/* LDNF1SH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a530a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1sh_z_p_bi_s32(Zt, Rn, Pg, imm4)


/* LDNF1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a550a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1w_z_p_bi_u32(Zt, Rn, Pg, imm4)


/* LDNF1W  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a570a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1w_z_p_bi_u64(Zt, Rn, Pg, imm4)


/* LDNF1SB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a590a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1sb_z_p_bi_s64(Zt, Rn, Pg, imm4)


/* LDNF1SB  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5b0a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1sb_z_p_bi_s32(Zt, Rn, Pg, imm4)


/* LDNF1SB  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5d0a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1sb_z_p_bi_s16(Zt, Rn, Pg, imm4)


/* LDNF1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5f0a000) */
//#define IEM_INSTR_IMPL_A64__ldnf1d_z_p_bi_u64(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_cldnt_si / sve_memcld / sve / A64
 *
 */

/* LDNT1B  { <Zt>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a400e000) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LDNT1H  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a480e000) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LDNT1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a500e000) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LDNT1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a580e000) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_z_p_bi_contiguous(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_cldnt_ss / sve_memcld / sve / A64
 *
 */

/* LDNT1B  { <Zt>.B }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a400c000) */
//#define IEM_INSTR_IMPL_A64__ldnt1b_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LDNT1H  { <Zt>.H }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a480c000) */
//#define IEM_INSTR_IMPL_A64__ldnt1h_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LDNT1W  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a500c000) */
//#define IEM_INSTR_IMPL_A64__ldnt1w_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LDNT1D  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/a580c000) */
//#define IEM_INSTR_IMPL_A64__ldnt1d_z_p_br_contiguous(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_cst_si / sve_memst_si / sve / A64
 *
 */

/* ST1B  { <Zt>.<T> }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (ff90e000/e400e000) */
//#define IEM_INSTR_IMPL_A64__st1b_z_p_bi(Zt, Rn, Pg, imm4, size)


/* ST1H  { <Zt>.<T> }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (ff90e000/e480e000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_bi(Zt, Rn, Pg, imm4, size)


/* ST1W  { <Zt>.Q }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e500e000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_bi_u128(Zt, Rn, Pg, imm4)


/* ST1W  { <Zt>.<T> }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (ffd0e000/e540e000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_bi(Zt, Rn, Pg, imm4, sz)


/* ST1D  { <Zt>.Q }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e5c0e000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_bi_u128(Zt, Rn, Pg, imm4)


/* ST1D  { <Zt>.D }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e5e0e000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_bi(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_cst_ss / sve_memst_cs / sve / A64
 *
 */

/* ST1B  { <Zt>.<T> }, <Pg>, [<Xn|SP>, <Xm>] (ff80e000/e4004000) */
//#define IEM_INSTR_IMPL_A64__st1b_z_p_br(Zt, Rn, Pg, Rm, size)


/* ST1H  { <Zt>.<T> }, <Pg>, [<Xn|SP>, <Xm>, LSL #1] (ff80e000/e4804000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_br(Zt, Rn, Pg, Rm, size)


/* ST1W  { <Zt>.Q }, <Pg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/e5004000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_br_u128(Zt, Rn, Pg, Rm)


/* ST1W  { <Zt>.<T> }, <Pg>, [<Xn|SP>, <Xm>, LSL #2] (ffc0e000/e5404000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_br(Zt, Rn, Pg, Rm, sz)


/* ST1D  { <Zt>.Q }, <Pg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/e5c04000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_br_u128(Zt, Rn, Pg, Rm)


/* ST1D  { <Zt>.D }, <Pg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/e5e04000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_br(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_cstnt_si / sve_memst_si / sve / A64
 *
 */

/* STNT1B  { <Zt>.B }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e410e000) */
//#define IEM_INSTR_IMPL_A64__stnt1b_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* STNT1H  { <Zt>.H }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e490e000) */
//#define IEM_INSTR_IMPL_A64__stnt1h_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* STNT1W  { <Zt>.S }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e510e000) */
//#define IEM_INSTR_IMPL_A64__stnt1w_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* STNT1D  { <Zt>.D }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e590e000) */
//#define IEM_INSTR_IMPL_A64__stnt1d_z_p_bi_contiguous(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_cstnt_ss / sve_memcst_nt / sve / A64
 *
 */

/* STNT1B  { <Zt>.B }, <Pg>, [<Xn|SP>, <Xm>] (ffe0e000/e4006000) */
//#define IEM_INSTR_IMPL_A64__stnt1b_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* STNT1H  { <Zt>.H }, <Pg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/e4806000) */
//#define IEM_INSTR_IMPL_A64__stnt1h_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* STNT1W  { <Zt>.S }, <Pg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/e5006000) */
//#define IEM_INSTR_IMPL_A64__stnt1w_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* STNT1D  { <Zt>.D }, <Pg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/e5806000) */
//#define IEM_INSTR_IMPL_A64__stnt1d_z_p_br_contiguous(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_eld_si / sve_memcld / sve / A64
 *
 */

/* LD2B  { <Zt1>.B, <Zt2>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a420e000) */
//#define IEM_INSTR_IMPL_A64__ld2b_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD3B  { <Zt1>.B, <Zt2>.B, <Zt3>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a440e000) */
//#define IEM_INSTR_IMPL_A64__ld3b_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD4B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a460e000) */
//#define IEM_INSTR_IMPL_A64__ld4b_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD2H  { <Zt1>.H, <Zt2>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4a0e000) */
//#define IEM_INSTR_IMPL_A64__ld2h_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD3H  { <Zt1>.H, <Zt2>.H, <Zt3>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4c0e000) */
//#define IEM_INSTR_IMPL_A64__ld3h_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD4H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a4e0e000) */
//#define IEM_INSTR_IMPL_A64__ld4h_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD2W  { <Zt1>.S, <Zt2>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a520e000) */
//#define IEM_INSTR_IMPL_A64__ld2w_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD3W  { <Zt1>.S, <Zt2>.S, <Zt3>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a540e000) */
//#define IEM_INSTR_IMPL_A64__ld3w_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD4W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a560e000) */
//#define IEM_INSTR_IMPL_A64__ld4w_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD2D  { <Zt1>.D, <Zt2>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5a0e000) */
//#define IEM_INSTR_IMPL_A64__ld2d_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD3D  { <Zt1>.D, <Zt2>.D, <Zt3>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5c0e000) */
//#define IEM_INSTR_IMPL_A64__ld3d_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD4D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a5e0e000) */
//#define IEM_INSTR_IMPL_A64__ld4d_z_p_bi_contiguous(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_eld_ss / sve_memcld / sve / A64
 *
 */

/* LD2B  { <Zt1>.B, <Zt2>.B }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a420c000) */
//#define IEM_INSTR_IMPL_A64__ld2b_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD3B  { <Zt1>.B, <Zt2>.B, <Zt3>.B }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a440c000) */
//#define IEM_INSTR_IMPL_A64__ld3b_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD4B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a460c000) */
//#define IEM_INSTR_IMPL_A64__ld4b_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD2H  { <Zt1>.H, <Zt2>.H }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a4a0c000) */
//#define IEM_INSTR_IMPL_A64__ld2h_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD3H  { <Zt1>.H, <Zt2>.H, <Zt3>.H }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a4c0c000) */
//#define IEM_INSTR_IMPL_A64__ld3h_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD4H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a4e0c000) */
//#define IEM_INSTR_IMPL_A64__ld4h_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD2W  { <Zt1>.S, <Zt2>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a520c000) */
//#define IEM_INSTR_IMPL_A64__ld2w_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD3W  { <Zt1>.S, <Zt2>.S, <Zt3>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a540c000) */
//#define IEM_INSTR_IMPL_A64__ld3w_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD4W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a560c000) */
//#define IEM_INSTR_IMPL_A64__ld4w_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD2D  { <Zt1>.D, <Zt2>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/a5a0c000) */
//#define IEM_INSTR_IMPL_A64__ld2d_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD3D  { <Zt1>.D, <Zt2>.D, <Zt3>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/a5c0c000) */
//#define IEM_INSTR_IMPL_A64__ld3d_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD4D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/a5e0c000) */
//#define IEM_INSTR_IMPL_A64__ld4d_z_p_br_contiguous(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_eldq_si / sve_memcld / sve / A64
 *
 */

/* LD2Q  { <Zt1>.Q, <Zt2>.Q }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a490e000) */
//#define IEM_INSTR_IMPL_A64__ld2q_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD3Q  { <Zt1>.Q, <Zt2>.Q, <Zt3>.Q }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a510e000) */
//#define IEM_INSTR_IMPL_A64__ld3q_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* LD4Q  { <Zt1>.Q, <Zt2>.Q, <Zt3>.Q, <Zt4>.Q }, <Pg>/Z, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/a590e000) */
//#define IEM_INSTR_IMPL_A64__ld4q_z_p_bi_contiguous(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_eldq_ss / sve_memcld / sve / A64
 *
 */

/* LD2Q  { <Zt1>.Q, <Zt2>.Q }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #4] (ffe0e000/a4a08000) */
//#define IEM_INSTR_IMPL_A64__ld2q_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD3Q  { <Zt1>.Q, <Zt2>.Q, <Zt3>.Q }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #4] (ffe0e000/a5208000) */
//#define IEM_INSTR_IMPL_A64__ld3q_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD4Q  { <Zt1>.Q, <Zt2>.Q, <Zt3>.Q, <Zt4>.Q }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #4] (ffe0e000/a5a08000) */
//#define IEM_INSTR_IMPL_A64__ld4q_z_p_br_contiguous(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_est_si / sve_memst_si / sve / A64
 *
 */

/* ST2B  { <Zt1>.B, <Zt2>.B }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e430e000) */
//#define IEM_INSTR_IMPL_A64__st2b_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST3B  { <Zt1>.B, <Zt2>.B, <Zt3>.B }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e450e000) */
//#define IEM_INSTR_IMPL_A64__st3b_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST4B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e470e000) */
//#define IEM_INSTR_IMPL_A64__st4b_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST2H  { <Zt1>.H, <Zt2>.H }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e4b0e000) */
//#define IEM_INSTR_IMPL_A64__st2h_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST3H  { <Zt1>.H, <Zt2>.H, <Zt3>.H }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e4d0e000) */
//#define IEM_INSTR_IMPL_A64__st3h_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST4H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e4f0e000) */
//#define IEM_INSTR_IMPL_A64__st4h_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST2W  { <Zt1>.S, <Zt2>.S }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e530e000) */
//#define IEM_INSTR_IMPL_A64__st2w_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST3W  { <Zt1>.S, <Zt2>.S, <Zt3>.S }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e550e000) */
//#define IEM_INSTR_IMPL_A64__st3w_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST4W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e570e000) */
//#define IEM_INSTR_IMPL_A64__st4w_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST2D  { <Zt1>.D, <Zt2>.D }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e5b0e000) */
//#define IEM_INSTR_IMPL_A64__st2d_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST3D  { <Zt1>.D, <Zt2>.D, <Zt3>.D }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e5d0e000) */
//#define IEM_INSTR_IMPL_A64__st3d_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST4D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e5f0e000) */
//#define IEM_INSTR_IMPL_A64__st4d_z_p_bi_contiguous(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_est_ss / sve_memcst_nt / sve / A64
 *
 */

/* ST2B  { <Zt1>.B, <Zt2>.B }, <Pg>, [<Xn|SP>, <Xm>] (ffe0e000/e4206000) */
//#define IEM_INSTR_IMPL_A64__st2b_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST3B  { <Zt1>.B, <Zt2>.B, <Zt3>.B }, <Pg>, [<Xn|SP>, <Xm>] (ffe0e000/e4406000) */
//#define IEM_INSTR_IMPL_A64__st3b_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST4B  { <Zt1>.B, <Zt2>.B, <Zt3>.B, <Zt4>.B }, <Pg>, [<Xn|SP>, <Xm>] (ffe0e000/e4606000) */
//#define IEM_INSTR_IMPL_A64__st4b_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST2H  { <Zt1>.H, <Zt2>.H }, <Pg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/e4a06000) */
//#define IEM_INSTR_IMPL_A64__st2h_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST3H  { <Zt1>.H, <Zt2>.H, <Zt3>.H }, <Pg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/e4c06000) */
//#define IEM_INSTR_IMPL_A64__st3h_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST4H  { <Zt1>.H, <Zt2>.H, <Zt3>.H, <Zt4>.H }, <Pg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/e4e06000) */
//#define IEM_INSTR_IMPL_A64__st4h_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST2W  { <Zt1>.S, <Zt2>.S }, <Pg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/e5206000) */
//#define IEM_INSTR_IMPL_A64__st2w_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST3W  { <Zt1>.S, <Zt2>.S, <Zt3>.S }, <Pg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/e5406000) */
//#define IEM_INSTR_IMPL_A64__st3w_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST4W  { <Zt1>.S, <Zt2>.S, <Zt3>.S, <Zt4>.S }, <Pg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/e5606000) */
//#define IEM_INSTR_IMPL_A64__st4w_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST2D  { <Zt1>.D, <Zt2>.D }, <Pg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/e5a06000) */
//#define IEM_INSTR_IMPL_A64__st2d_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST3D  { <Zt1>.D, <Zt2>.D, <Zt3>.D }, <Pg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/e5c06000) */
//#define IEM_INSTR_IMPL_A64__st3d_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST4D  { <Zt1>.D, <Zt2>.D, <Zt3>.D, <Zt4>.D }, <Pg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/e5e06000) */
//#define IEM_INSTR_IMPL_A64__st4d_z_p_br_contiguous(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_estq_si / sve_memst_cs / sve / A64
 *
 */

/* ST2Q  { <Zt1>.Q, <Zt2>.Q }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e4400000) */
//#define IEM_INSTR_IMPL_A64__st2q_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST3Q  { <Zt1>.Q, <Zt2>.Q, <Zt3>.Q }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e4800000) */
//#define IEM_INSTR_IMPL_A64__st3q_z_p_bi_contiguous(Zt, Rn, Pg, imm4)


/* ST4Q  { <Zt1>.Q, <Zt2>.Q, <Zt3>.Q, <Zt4>.Q }, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (fff0e000/e4c00000) */
//#define IEM_INSTR_IMPL_A64__st4q_z_p_bi_contiguous(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_estq_ss / sve_memst_cs / sve / A64
 *
 */

/* ST2Q  { <Zt1>.Q, <Zt2>.Q }, <Pg>, [<Xn|SP>, <Xm>, LSL #4] (ffe0e000/e4600000) */
//#define IEM_INSTR_IMPL_A64__st2q_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST3Q  { <Zt1>.Q, <Zt2>.Q, <Zt3>.Q }, <Pg>, [<Xn|SP>, <Xm>, LSL #4] (ffe0e000/e4a00000) */
//#define IEM_INSTR_IMPL_A64__st3q_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* ST4Q  { <Zt1>.Q, <Zt2>.Q, <Zt3>.Q, <Zt4>.Q }, <Pg>, [<Xn|SP>, <Xm>, LSL #4] (ffe0e000/e4e00000) */
//#define IEM_INSTR_IMPL_A64__st4q_z_p_br_contiguous(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_ld_dup / sve_mem32 / sve / A64
 *
 */

/* LD1RB  { <Zt>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/84408000) */
//#define IEM_INSTR_IMPL_A64__ld1rb_z_p_bi_u8(Zt, Rn, Pg, imm6)


/* LD1RB  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/8440a000) */
//#define IEM_INSTR_IMPL_A64__ld1rb_z_p_bi_u16(Zt, Rn, Pg, imm6)


/* LD1RB  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/8440c000) */
//#define IEM_INSTR_IMPL_A64__ld1rb_z_p_bi_u32(Zt, Rn, Pg, imm6)


/* LD1RB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/8440e000) */
//#define IEM_INSTR_IMPL_A64__ld1rb_z_p_bi_u64(Zt, Rn, Pg, imm6)


/* LD1RSW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/84c08000) */
//#define IEM_INSTR_IMPL_A64__ld1rsw_z_p_bi_s64(Zt, Rn, Pg, imm6)


/* LD1RH  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/84c0a000) */
//#define IEM_INSTR_IMPL_A64__ld1rh_z_p_bi_u16(Zt, Rn, Pg, imm6)


/* LD1RH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/84c0c000) */
//#define IEM_INSTR_IMPL_A64__ld1rh_z_p_bi_u32(Zt, Rn, Pg, imm6)


/* LD1RH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/84c0e000) */
//#define IEM_INSTR_IMPL_A64__ld1rh_z_p_bi_u64(Zt, Rn, Pg, imm6)


/* LD1RSH  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/85408000) */
//#define IEM_INSTR_IMPL_A64__ld1rsh_z_p_bi_s64(Zt, Rn, Pg, imm6)


/* LD1RSH  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/8540a000) */
//#define IEM_INSTR_IMPL_A64__ld1rsh_z_p_bi_s32(Zt, Rn, Pg, imm6)


/* LD1RW  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/8540c000) */
//#define IEM_INSTR_IMPL_A64__ld1rw_z_p_bi_u32(Zt, Rn, Pg, imm6)


/* LD1RW  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/8540e000) */
//#define IEM_INSTR_IMPL_A64__ld1rw_z_p_bi_u64(Zt, Rn, Pg, imm6)


/* LD1RSB  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/85c08000) */
//#define IEM_INSTR_IMPL_A64__ld1rsb_z_p_bi_s64(Zt, Rn, Pg, imm6)


/* LD1RSB  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/85c0a000) */
//#define IEM_INSTR_IMPL_A64__ld1rsb_z_p_bi_s32(Zt, Rn, Pg, imm6)


/* LD1RSB  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/85c0c000) */
//#define IEM_INSTR_IMPL_A64__ld1rsb_z_p_bi_s16(Zt, Rn, Pg, imm6)


/* LD1RD  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (ffc0e000/85c0e000) */
//#define IEM_INSTR_IMPL_A64__ld1rd_z_p_bi_u64(Zt, Rn, Pg, imm6)



/*
 *
 * Instruction Set & Groups: sve_mem_ldqr_si / sve_memcld / sve / A64
 *
 */

/* LD1RQB  { <Zt>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (fff0e000/a4002000) */
//#define IEM_INSTR_IMPL_A64__ld1rqb_z_p_bi_u8(Zt, Rn, Pg, imm4)


/* LD1ROB  { <Zt>.B }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (fff0e000/a4202000) */
//#define IEM_INSTR_IMPL_A64__ld1rob_z_p_bi_u8(Zt, Rn, Pg, imm4)


/* LD1RQH  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (fff0e000/a4802000) */
//#define IEM_INSTR_IMPL_A64__ld1rqh_z_p_bi_u16(Zt, Rn, Pg, imm4)


/* LD1ROH  { <Zt>.H }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (fff0e000/a4a02000) */
//#define IEM_INSTR_IMPL_A64__ld1roh_z_p_bi_u16(Zt, Rn, Pg, imm4)


/* LD1RQW  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (fff0e000/a5002000) */
//#define IEM_INSTR_IMPL_A64__ld1rqw_z_p_bi_u32(Zt, Rn, Pg, imm4)


/* LD1ROW  { <Zt>.S }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (fff0e000/a5202000) */
//#define IEM_INSTR_IMPL_A64__ld1row_z_p_bi_u32(Zt, Rn, Pg, imm4)


/* LD1RQD  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (fff0e000/a5802000) */
//#define IEM_INSTR_IMPL_A64__ld1rqd_z_p_bi_u64(Zt, Rn, Pg, imm4)


/* LD1ROD  { <Zt>.D }, <Pg>/Z, [<Xn|SP>{, #<imm>}] (fff0e000/a5a02000) */
//#define IEM_INSTR_IMPL_A64__ld1rod_z_p_bi_u64(Zt, Rn, Pg, imm4)



/*
 *
 * Instruction Set & Groups: sve_mem_ldqr_ss / sve_memcld / sve / A64
 *
 */

/* LD1RQB  { <Zt>.B }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a4000000) */
//#define IEM_INSTR_IMPL_A64__ld1rqb_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD1ROB  { <Zt>.B }, <Pg>/Z, [<Xn|SP>, <Xm>] (ffe0e000/a4200000) */
//#define IEM_INSTR_IMPL_A64__ld1rob_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD1RQH  { <Zt>.H }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a4800000) */
//#define IEM_INSTR_IMPL_A64__ld1rqh_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD1ROH  { <Zt>.H }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #1] (ffe0e000/a4a00000) */
//#define IEM_INSTR_IMPL_A64__ld1roh_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD1RQW  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a5000000) */
//#define IEM_INSTR_IMPL_A64__ld1rqw_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD1ROW  { <Zt>.S }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #2] (ffe0e000/a5200000) */
//#define IEM_INSTR_IMPL_A64__ld1row_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD1RQD  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/a5800000) */
//#define IEM_INSTR_IMPL_A64__ld1rqd_z_p_br_contiguous(Zt, Rn, Pg, Rm)


/* LD1ROD  { <Zt>.D }, <Pg>/Z, [<Xn|SP>, <Xm>, LSL #3] (ffe0e000/a5a00000) */
//#define IEM_INSTR_IMPL_A64__ld1rod_z_p_br_contiguous(Zt, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_prfm_si / sve_mem32 / sve / A64
 *
 */

/* PRFB  <prfop>, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (ffc0e010/85c00000) */
//#define IEM_INSTR_IMPL_A64__prfb_i_p_bi_s(prfop, Rn, Pg, imm6)


/* PRFH  <prfop>, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (ffc0e010/85c02000) */
//#define IEM_INSTR_IMPL_A64__prfh_i_p_bi_s(prfop, Rn, Pg, imm6)


/* PRFW  <prfop>, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (ffc0e010/85c04000) */
//#define IEM_INSTR_IMPL_A64__prfw_i_p_bi_s(prfop, Rn, Pg, imm6)


/* PRFD  <prfop>, <Pg>, [<Xn|SP>{, #<imm>, MUL VL}] (ffc0e010/85c06000) */
//#define IEM_INSTR_IMPL_A64__prfd_i_p_bi_s(prfop, Rn, Pg, imm6)



/*
 *
 * Instruction Set & Groups: sve_mem_prfm_ss / sve_mem32 / sve / A64
 *
 */

/* PRFB  <prfop>, <Pg>, [<Xn|SP>, <Xm>] (ffe0e010/8400c000) */
//#define IEM_INSTR_IMPL_A64__prfb_i_p_br_s(prfop, Rn, Pg, Rm)


/* PRFH  <prfop>, <Pg>, [<Xn|SP>, <Xm>, LSL #1] (ffe0e010/8480c000) */
//#define IEM_INSTR_IMPL_A64__prfh_i_p_br_s(prfop, Rn, Pg, Rm)


/* PRFW  <prfop>, <Pg>, [<Xn|SP>, <Xm>, LSL #2] (ffe0e010/8500c000) */
//#define IEM_INSTR_IMPL_A64__prfw_i_p_br_s(prfop, Rn, Pg, Rm)


/* PRFD  <prfop>, <Pg>, [<Xn|SP>, <Xm>, LSL #3] (ffe0e010/8580c000) */
//#define IEM_INSTR_IMPL_A64__prfd_i_p_br_s(prfop, Rn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_pspill / sve_memst_cs / sve / A64
 *
 */

/* STR  <Pt>, [<Xn|SP>{, #<imm>, MUL VL}] (ffc0e010/e5800000) */
//#define IEM_INSTR_IMPL_A64__str_p_bi(Pt, Rn, imm9l, imm9h)



/*
 *
 * Instruction Set & Groups: sve_mem_spill / sve_memst_cs / sve / A64
 *
 */

/* STR  <Zt>, [<Xn|SP>{, #<imm>, MUL VL}] (ffc0e000/e5804000) */
//#define IEM_INSTR_IMPL_A64__str_z_bi(Zt, Rn, imm9l, imm9h)



/*
 *
 * Instruction Set & Groups: sve_mem_sst_sv2 / sve_memst_ss2 / sve / A64
 *
 */

/* ST1H  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, LSL #1] (ffe0e000/e4a0a000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* ST1W  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, LSL #2] (ffe0e000/e520a000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)


/* ST1D  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, LSL #3] (ffe0e000/e5a0a000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_bz_d_64_scaled(Zt, Rn, Pg, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_sst_sv_a / sve_memst_ss / sve / A64
 *
 */

/* ST1H  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, <mod> #1] (ffe0a000/e4a08000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_bz_d_x32_scaled(Zt, Rn, Pg, xs, Zm)


/* ST1W  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, <mod> #2] (ffe0a000/e5208000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_bz_d_x32_scaled(Zt, Rn, Pg, xs, Zm)


/* ST1D  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, <mod> #3] (ffe0a000/e5a08000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_bz_d_x32_scaled(Zt, Rn, Pg, xs, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_sst_sv_b / sve_memst_ss / sve / A64
 *
 */

/* ST1H  { <Zt>.S }, <Pg>, [<Xn|SP>, <Zm>.S, <mod> #1] (ffe0a000/e4e08000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_bz_s_x32_scaled(Zt, Rn, Pg, xs, Zm)


/* ST1W  { <Zt>.S }, <Pg>, [<Xn|SP>, <Zm>.S, <mod> #2] (ffe0a000/e5608000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_bz_s_x32_scaled(Zt, Rn, Pg, xs, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_sst_vi_a / sve_memst_ss2 / sve / A64
 *
 */

/* ST1B  { <Zt>.D }, <Pg>, [<Zn>.D{, #<imm>}] (ffe0e000/e440a000) */
//#define IEM_INSTR_IMPL_A64__st1b_z_p_ai_d(Zt, Zn, Pg, imm5)


/* ST1H  { <Zt>.D }, <Pg>, [<Zn>.D{, #<imm>}] (ffe0e000/e4c0a000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_ai_d(Zt, Zn, Pg, imm5)


/* ST1W  { <Zt>.D }, <Pg>, [<Zn>.D{, #<imm>}] (ffe0e000/e540a000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_ai_d(Zt, Zn, Pg, imm5)


/* ST1D  { <Zt>.D }, <Pg>, [<Zn>.D{, #<imm>}] (ffe0e000/e5c0a000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_ai_d(Zt, Zn, Pg, imm5)



/*
 *
 * Instruction Set & Groups: sve_mem_sst_vi_b / sve_memst_ss2 / sve / A64
 *
 */

/* ST1B  { <Zt>.S }, <Pg>, [<Zn>.S{, #<imm>}] (ffe0e000/e460a000) */
//#define IEM_INSTR_IMPL_A64__st1b_z_p_ai_s(Zt, Zn, Pg, imm5)


/* ST1H  { <Zt>.S }, <Pg>, [<Zn>.S{, #<imm>}] (ffe0e000/e4e0a000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_ai_s(Zt, Zn, Pg, imm5)


/* ST1W  { <Zt>.S }, <Pg>, [<Zn>.S{, #<imm>}] (ffe0e000/e560a000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_ai_s(Zt, Zn, Pg, imm5)



/*
 *
 * Instruction Set & Groups: sve_mem_sst_vs2 / sve_memst_ss2 / sve / A64
 *
 */

/* ST1B  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D] (ffe0e000/e400a000) */
//#define IEM_INSTR_IMPL_A64__st1b_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* ST1H  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D] (ffe0e000/e480a000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* ST1W  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D] (ffe0e000/e500a000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)


/* ST1D  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D] (ffe0e000/e580a000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_bz_d_64_unscaled(Zt, Rn, Pg, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_sst_vs_a / sve_memst_ss / sve / A64
 *
 */

/* ST1B  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, <mod>] (ffe0a000/e4008000) */
//#define IEM_INSTR_IMPL_A64__st1b_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, xs, Zm)


/* ST1H  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, <mod>] (ffe0a000/e4808000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, xs, Zm)


/* ST1W  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, <mod>] (ffe0a000/e5008000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, xs, Zm)


/* ST1D  { <Zt>.D }, <Pg>, [<Xn|SP>, <Zm>.D, <mod>] (ffe0a000/e5808000) */
//#define IEM_INSTR_IMPL_A64__st1d_z_p_bz_d_x32_unscaled(Zt, Rn, Pg, xs, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_sst_vs_b / sve_memst_ss / sve / A64
 *
 */

/* ST1B  { <Zt>.S }, <Pg>, [<Xn|SP>, <Zm>.S, <mod>] (ffe0a000/e4408000) */
//#define IEM_INSTR_IMPL_A64__st1b_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, xs, Zm)


/* ST1H  { <Zt>.S }, <Pg>, [<Xn|SP>, <Zm>.S, <mod>] (ffe0a000/e4c08000) */
//#define IEM_INSTR_IMPL_A64__st1h_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, xs, Zm)


/* ST1W  { <Zt>.S }, <Pg>, [<Xn|SP>, <Zm>.S, <mod>] (ffe0a000/e5408000) */
//#define IEM_INSTR_IMPL_A64__st1w_z_p_bz_s_x32_unscaled(Zt, Rn, Pg, xs, Zm)



/*
 *
 * Instruction Set & Groups: sve_mem_sstnt_32b_vs / sve_memsst_nt / sve / A64
 *
 */

/* STNT1B  { <Zt>.S }, <Pg>, [<Zn>.S{, <Xm>}] (ffe0e000/e4402000) */
//#define IEM_INSTR_IMPL_A64__stnt1b_z_p_ar_s_x32_unscaled(Zt, Zn, Pg, Rm)


/* STNT1H  { <Zt>.S }, <Pg>, [<Zn>.S{, <Xm>}] (ffe0e000/e4c02000) */
//#define IEM_INSTR_IMPL_A64__stnt1h_z_p_ar_s_x32_unscaled(Zt, Zn, Pg, Rm)


/* STNT1W  { <Zt>.S }, <Pg>, [<Zn>.S{, <Xm>}] (ffe0e000/e5402000) */
//#define IEM_INSTR_IMPL_A64__stnt1w_z_p_ar_s_x32_unscaled(Zt, Zn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_sstnt_64b_vs / sve_memsst_nt / sve / A64
 *
 */

/* STNT1B  { <Zt>.D }, <Pg>, [<Zn>.D{, <Xm>}] (ffe0e000/e4002000) */
//#define IEM_INSTR_IMPL_A64__stnt1b_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* STNT1H  { <Zt>.D }, <Pg>, [<Zn>.D{, <Xm>}] (ffe0e000/e4802000) */
//#define IEM_INSTR_IMPL_A64__stnt1h_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* STNT1W  { <Zt>.D }, <Pg>, [<Zn>.D{, <Xm>}] (ffe0e000/e5002000) */
//#define IEM_INSTR_IMPL_A64__stnt1w_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)


/* STNT1D  { <Zt>.D }, <Pg>, [<Zn>.D{, <Xm>}] (ffe0e000/e5802000) */
//#define IEM_INSTR_IMPL_A64__stnt1d_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_mem_sstq_64b_vs / sve_memsst_nt / sve / A64
 *
 */

/* ST1Q  { <Zt>.Q }, <Pg>, [<Zn>.D{, <Xm>}] (ffe0e000/e4202000) */
//#define IEM_INSTR_IMPL_A64__st1q_z_p_ar_d_64_unscaled(Zt, Zn, Pg, Rm)



/*
 *
 * Instruction Set & Groups: sve_ptr_muladd_unpred_lvl2 / sve_ptr_muladd_unpred / sve / A64
 *
 */

/* MLAPT  <Zda>.D, <Zn>.D, <Zm>.D (ffe0fc00/44c0d000) */
//#define IEM_INSTR_IMPL_A64__mlapt_z_zzz(Zda, Zn, Zm)


/* MADPT  <Zdn>.D, <Zm>.D, <Za>.D (ffe0fc00/44c0d800) */
//#define IEM_INSTR_IMPL_A64__madpt_z_zzz(Zdn, Za, Zm)



/*
 *
 * Instruction Set & Groups: syspairinstrs / control / A64
 *
 */

/* SYSP  #<op1>, <Cn>, <Cm>, #<op2>{, <Xt1>, <Xt2>} (fff80000/d5480000) */
//#define IEM_INSTR_IMPL_A64__SYSP_CR_syspairinstrs(Rt, op2, CRm, CRn, op1)



/*
 *
 * Instruction Set & Groups: systeminstrs / control / A64
 *
 */

/* SYS  #<op1>, <Cn>, <Cm>, #<op2>{, <Xt>} (fff80000/d5080000) */
//#define IEM_INSTR_IMPL_A64__SYS_CR_systeminstrs(Rt, op2, CRm, CRn, op1)


/* SYSL  <Xt>, #<op1>, <Cn>, <Cm>, #<op2> (fff80000/d5280000) */
//#define IEM_INSTR_IMPL_A64__SYSL_RC_systeminstrs(Rt, op2, CRm, CRn, op1)



/*
 *
 * Instruction Set & Groups: systeminstrswithreg / control / A64
 *
 */

/* WFET  <Xt> (ffffffe0/d5031000) */
//#define IEM_INSTR_IMPL_A64__WFET_only_systeminstrswithreg(Rd)


/* WFIT  <Xt> (ffffffe0/d5031020) */
//#define IEM_INSTR_IMPL_A64__WFIT_only_systeminstrswithreg(Rd)



/*
 *
 * Instruction Set & Groups: systemmove / control / A64
 *
 */

/* MSR  {<systemreg> | S<op0>_<op1>_<Cn>_<Cm>_<op2>}, <Xt> (fff00000/d5100000) */
#define IEM_INSTR_IMPL_A64__MSR_SR_systemmove(Rt, op2, CRm, CRn, op1, o0) \
    IEM_MC_CALL_CIMPL_2(IEM_CIMPL_F_MODE | IEM_CIMPL_F_CHECK_IRQ_BEFORE_AND_AFTER | IEM_CIMPL_F_XCPT, \
                        0 /** @todo any sysregs we may be shadowing... */, \
                        iemCImplA64_msr, ARMV8_AARCH64_SYSREG_ID_CREATE(2 | o0, op1, CRn, CRm, op2), Rt)

/* MRS  <Xt>, {<systemreg> | S<op0>_<op1>_<Cn>_<Cm>_<op2>} (fff00000/d5300000) */
#define IEM_INSTR_IMPL_A64__MRS_RS_systemmove(Rt, op2, CRm, CRn, op1, o0) \
    IEM_MC_CALL_CIMPL_2(IEM_CIMPL_F_CHECK_IRQ_BEFORE_AND_AFTER | IEM_CIMPL_F_XCPT, \
                        RT_BIT_64(kIemNativeGstReg_GprFirst + Rt), \
                        iemCImplA64_mrs, ARMV8_AARCH64_SYSREG_ID_CREATE(2 | o0, op1, CRn, CRm, op2), Rt)



/*
 *
 * Instruction Set & Groups: systemmovepr / control / A64
 *
 */

/* MSRR  {<systemreg> | S<op0>_<op1>_<Cn>_<Cm>_<op2>}, <Xt>, <Xt+1> (fff00000/d5500000) */
//#define IEM_INSTR_IMPL_A64__MSRR_SR_systemmovepr(Rt, op2, CRm, CRn, op1, o0)


/* MRRS  <Xt>, <Xt+1>, {<systemreg> | S<op0>_<op1>_<Cn>_<Cm>_<op2>} (fff00000/d5700000) */
//#define IEM_INSTR_IMPL_A64__MRRS_RS_systemmovepr(Rt, op2, CRm, CRn, op1, o0)



/*
 *
 * Instruction Set & Groups: systemresult / control / A64
 *
 */

/* TSTART  <Xt> (ffffffe0/d5233060) */
//#define IEM_INSTR_IMPL_A64__TSTART_BR_systemresult(Rt)


/* TTEST  <Xt> (ffffffe0/d5233160) */
//#define IEM_INSTR_IMPL_A64__TTEST_BR_systemresult(Rt)



/*
 *
 * Instruction Set & Groups: testbranch / control / A64
 *
 */

/* TBZ  <R><t>, #<imm>, <label> (7f000000/36000000) */
//#define IEM_INSTR_IMPL_A64__TBZ_only_testbranch(Rt, imm14, b40, b5)


/* TBNZ  <R><t>, #<imm>, <label> (7f000000/37000000) */
//#define IEM_INSTR_IMPL_A64__TBNZ_only_testbranch(Rt, imm14, b40, b5)
