"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSnapshotSearchWildcard = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSnapshotSearchWildcard = ({
  field,
  value,
  match,
  operator
}) => {
  // if the operator is NOT for exact match, convert to *value* wildcard that matches any substring
  value = operator === 'exact' ? value : `*${value}*`;

  // ES API new "-"("except") wildcard removes matching items from a list of already selected items
  // To find all items not containing the search value, use "*,-{searchValue}"
  // When searching for policy name, also add "_none" to find snapshots without a policy as well
  const excludingWildcard = field === 'policyName' ? `*,_none,-${value}` : `*,-${value}`;
  return match === 'must_not' ? excludingWildcard : value;
};
exports.getSnapshotSearchWildcard = getSnapshotSearchWildcard;