"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.signalsMigrationSOs = exports.signalsMigrationSOUpdateAttributes = exports.signalsMigrationSOCreateAttributes = exports.signalsMigrationSOAttributes = exports.signalsMigrationSO = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _utility_types = require("../../../../common/utility_types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const status = t.keyof({
  success: null,
  failure: null,
  pending: null
});
const signalsMigrationSOWriteAttributes = {
  destinationIndex: t.string,
  error: (0, _utility_types.unionWithNullType)(t.string),
  sourceIndex: t.string,
  status,
  taskId: t.string,
  version: _securitysolutionIoTsTypes.PositiveInteger
};
const signalsMigrationSOGeneratedAttributes = {
  created: _securitysolutionIoTsTypes.IsoDateString,
  createdBy: t.string,
  updated: _securitysolutionIoTsTypes.IsoDateString,
  updatedBy: t.string
};
const signalsMigrationSOError = {
  statusCode: t.number,
  error: t.string,
  message: t.string
};

/**
 The attributes necessary to create a Signals Migration Saved Object
 */
const signalsMigrationSOCreateAttributes = exports.signalsMigrationSOCreateAttributes = t.exact(t.type(signalsMigrationSOWriteAttributes));
/**
 The attributes necessary to update a Signals Migration Saved Object
 */
const signalsMigrationSOUpdateAttributes = exports.signalsMigrationSOUpdateAttributes = t.exact(t.partial(signalsMigrationSOWriteAttributes));
/**
 The attributes of our Signals Migration Saved Object
 */
const signalsMigrationSOAttributes = exports.signalsMigrationSOAttributes = t.exact(t.type({
  ...signalsMigrationSOWriteAttributes,
  ...signalsMigrationSOGeneratedAttributes
}));
const signalsMigrationSO = exports.signalsMigrationSO = t.intersection([t.type({
  id: t.string,
  attributes: signalsMigrationSOAttributes,
  type: t.string
}), t.partial({
  error: t.type(signalsMigrationSOError)
})]);
const signalsMigrationSOs = exports.signalsMigrationSOs = t.array(signalsMigrationSO);