"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IP_REPUTATION_LINKS_SETTING = exports.INTERNAL_RULE_ID_KEY = exports.INTERNAL_RULE_ALERT_ID_KEY = exports.INTERNAL_IMMUTABLE_KEY = exports.INTERNAL_IDENTIFIER = exports.INDICATOR_RULE_TYPE_ID = exports.HOST_ISOLATION_EXCEPTIONS_PATH = exports.HOSTS_PATH = exports.GLOBAL_HEADER_HEIGHT_WITH_GLOBAL_BANNER = exports.GLOBAL_HEADER_HEIGHT = exports.FULL_SCREEN_TOGGLED_CLASS_NAME = exports.FILTERS_GLOBAL_HEIGHT = exports.EXCEPTIONS_PATH = exports.EVENT_FILTERS_PATH = exports.EQL_RULE_TYPE_ID = exports.ENRICHMENT_DESTINATION_PATH = exports.ENDPOINT_METADATA_INDEX = exports.ENDPOINTS_PATH = exports.ENABLE_NEWS_FEED_SETTING = exports.ELASTIC_NAME = exports.DETECTION_ENGINE_URL = exports.DETECTION_ENGINE_TAGS_URL = exports.DETECTION_ENGINE_SIGNALS_URL = exports.DETECTION_ENGINE_SIGNALS_STATUS_URL = exports.DETECTION_ENGINE_SIGNALS_MIGRATION_URL = exports.DETECTION_ENGINE_SIGNALS_MIGRATION_STATUS_URL = exports.DETECTION_ENGINE_SIGNALS_FINALIZE_MIGRATION_URL = exports.DETECTION_ENGINE_RULES_URL = exports.DETECTION_ENGINE_RULES_STATUS_URL = exports.DETECTION_ENGINE_RULES_BULK_ACTION = exports.DETECTION_ENGINE_QUERY_SIGNALS_URL = exports.DETECTION_ENGINE_PRIVILEGES_URL = exports.DETECTION_ENGINE_PREPACKAGED_URL = exports.DETECTION_ENGINE_PREPACKAGED_RULES_STATUS_URL = exports.DETECTION_ENGINE_INDEX_URL = exports.DETECTIONS_PATH = exports.DEFAULT_TRANSFORMS_SETTING = exports.DEFAULT_TRANSFORMS = exports.DEFAULT_TO = exports.DEFAULT_TIME_RANGE = exports.DEFAULT_TIMEPICKER_QUICK_RANGES = exports.DEFAULT_THREAT_MATCH_QUERY = exports.DEFAULT_THREAT_INDEX_VALUE = exports.DEFAULT_THREAT_INDEX_KEY = exports.DEFAULT_SPACE_ID = exports.DEFAULT_SIGNALS_INDEX = exports.DEFAULT_SEARCH_AFTER_PAGE_SIZE = exports.DEFAULT_SCALE_DATE_FORMAT = exports.DEFAULT_RULE_REFRESH_INTERVAL_VALUE = exports.DEFAULT_RULE_REFRESH_INTERVAL_ON = exports.DEFAULT_RULE_REFRESH_IDLE_VALUE = exports.DEFAULT_RULE_NOTIFICATION_QUERY_SIZE = exports.DEFAULT_RULES_TABLE_REFRESH_SETTING = exports.DEFAULT_REFRESH_RATE_INTERVAL = exports.DEFAULT_NUMBER_FORMAT = exports.DEFAULT_MAX_TABLE_QUERY_SIZE = exports.DEFAULT_MAX_SIGNALS = exports.DEFAULT_LISTS_INDEX = exports.DEFAULT_ITEMS_INDEX = exports.DEFAULT_INTERVAL_VALUE = exports.DEFAULT_INTERVAL_TYPE = exports.DEFAULT_INTERVAL_PAUSE = exports.DEFAULT_INDICATOR_SOURCE_PATH = exports.DEFAULT_INDEX_PATTERN_EXPERIMENTAL = exports.DEFAULT_INDEX_PATTERN = exports.DEFAULT_INDEX_KEY = exports.DEFAULT_FROM = exports.DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT = exports.DEFAULT_DARK_MODE = exports.DEFAULT_BYTES_FORMAT = exports.DEFAULT_APP_TIME_RANGE = exports.DEFAULT_APP_REFRESH_INTERVAL = exports.DEFAULT_ANOMALY_SCORE = exports.DEFAULT_ALERTS_INDEX = exports.CASES_PATH = exports.CASES_FEATURE_ID = exports.APP_UEBA_PATH = exports.APP_TRUSTED_APPS_PATH = exports.APP_TIMELINES_PATH = exports.APP_RULES_PATH = exports.APP_PATH = exports.APP_OVERVIEW_PATH = exports.APP_NETWORK_PATH = exports.APP_NAME = exports.APP_MANAGEMENT_PATH = exports.APP_ID = exports.APP_ICON_SOLUTION = exports.APP_ICON = exports.APP_HOST_ISOLATION_EXCEPTIONS_PATH = exports.APP_HOSTS_PATH = exports.APP_EXCEPTIONS_PATH = exports.APP_EVENT_FILTERS_PATH = exports.APP_ENDPOINTS_PATH = exports.APP_CASES_PATH = exports.APP_ALERTS_PATH = exports.ALERTS_PATH = exports.ALERTS_AS_DATA_URL = exports.ALERTS_AS_DATA_FIND_URL = exports.ADD_DATA_PATH = void 0;
exports.showAllOthersBucket = exports.defaultTransformsSetting = exports.WARNING_TRANSFORM_STATES = exports.UPDATE_OR_CREATE_LEGACY_ACTIONS = exports.UNAUTHENTICATED_USER = exports.UEBA_PATH = exports.TRUSTED_APPS_PATH = exports.TRANSFORM_STATES = exports.TIMELINE_URL = exports.TIMELINE_RESOLVE_URL = exports.TIMELINE_PREPACKAGED_URL = exports.TIMELINE_IMPORT_URL = exports.TIMELINE_FAVORITE_URL = exports.TIMELINE_EXPORT_URL = exports.TIMELINE_DRAFT_URL = exports.TIMELINES_URL = exports.TIMELINES_PATH = exports.THRESHOLD_RULE_TYPE_ID = exports.SecurityPageName = exports.SIGNALS_INDEX_KEY = exports.SIGNALS_ID = exports.SERVER_APP_ID = exports.SECURITY_FEATURE_ID = exports.SCROLLING_DISABLED_CLASS_NAME = exports.RULES_PATH = exports.RISKY_HOSTS_INDEX_PREFIX = exports.QUERY_RULE_TYPE_ID = exports.PINNED_EVENT_URL = exports.OVERVIEW_PATH = exports.NO_ALERT_INDEX = exports.NOTIFICATION_THROTTLE_RULE = exports.NOTIFICATION_THROTTLE_NO_ACTIONS = exports.NOTIFICATION_SUPPORTED_ACTION_TYPES_IDS = exports.NOTE_URL = exports.NEWS_FEED_URL_SETTING_DEFAULT = exports.NEWS_FEED_URL_SETTING = exports.NETWORK_PATH = exports.ML_RULE_TYPE_ID = exports.ML_GROUP_IDS = exports.ML_GROUP_ID = exports.MINIMUM_ML_LICENSE = exports.METADATA_TRANSFORM_STATS_URL = exports.MANAGEMENT_PATH = exports.LEGACY_NOTIFICATIONS_ID = exports.LEGACY_ML_GROUP_ID = exports.IP_REPUTATION_LINKS_SETTING_DEFAULT = void 0;
var _common = require("../../cases/common");
var _constants = require("./endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APP_ID = exports.APP_ID = 'securitySolution';
const CASES_FEATURE_ID = exports.CASES_FEATURE_ID = 'securitySolutionCases';
const SERVER_APP_ID = exports.SERVER_APP_ID = 'siem';
const APP_NAME = exports.APP_NAME = 'Security';
const APP_ICON = exports.APP_ICON = 'securityAnalyticsApp';
const APP_ICON_SOLUTION = exports.APP_ICON_SOLUTION = 'logoSecurity';
const APP_PATH = exports.APP_PATH = `/app/security`;
const ADD_DATA_PATH = exports.ADD_DATA_PATH = `/app/integrations/browse/security`;
const DEFAULT_BYTES_FORMAT = exports.DEFAULT_BYTES_FORMAT = 'format:bytes:defaultPattern';
const DEFAULT_DATE_FORMAT = exports.DEFAULT_DATE_FORMAT = 'dateFormat';
const DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT_TZ = 'dateFormat:tz';
const DEFAULT_DARK_MODE = exports.DEFAULT_DARK_MODE = 'theme:darkMode';
const DEFAULT_INDEX_KEY = exports.DEFAULT_INDEX_KEY = 'securitySolution:defaultIndex';
const DEFAULT_NUMBER_FORMAT = exports.DEFAULT_NUMBER_FORMAT = 'format:number:defaultPattern';
const DEFAULT_TIME_RANGE = exports.DEFAULT_TIME_RANGE = 'timepicker:timeDefaults';
const DEFAULT_REFRESH_RATE_INTERVAL = exports.DEFAULT_REFRESH_RATE_INTERVAL = 'timepicker:refreshIntervalDefaults';
const DEFAULT_APP_TIME_RANGE = exports.DEFAULT_APP_TIME_RANGE = 'securitySolution:timeDefaults';
const DEFAULT_APP_REFRESH_INTERVAL = exports.DEFAULT_APP_REFRESH_INTERVAL = 'securitySolution:refreshIntervalDefaults';
const DEFAULT_ALERTS_INDEX = exports.DEFAULT_ALERTS_INDEX = '.alerts-security.alerts';
const DEFAULT_SIGNALS_INDEX = exports.DEFAULT_SIGNALS_INDEX = '.siem-signals';
const DEFAULT_LISTS_INDEX = exports.DEFAULT_LISTS_INDEX = '.lists';
const DEFAULT_ITEMS_INDEX = exports.DEFAULT_ITEMS_INDEX = '.items';
// The DEFAULT_MAX_SIGNALS value exists also in `x-pack/plugins/cases/common/constants.ts`
// If either changes, engineer should ensure both values are updated
const DEFAULT_MAX_SIGNALS = exports.DEFAULT_MAX_SIGNALS = 100;
const DEFAULT_SEARCH_AFTER_PAGE_SIZE = exports.DEFAULT_SEARCH_AFTER_PAGE_SIZE = 100;
const DEFAULT_ANOMALY_SCORE = exports.DEFAULT_ANOMALY_SCORE = 'securitySolution:defaultAnomalyScore';
const DEFAULT_MAX_TABLE_QUERY_SIZE = exports.DEFAULT_MAX_TABLE_QUERY_SIZE = 10000;
const DEFAULT_SCALE_DATE_FORMAT = exports.DEFAULT_SCALE_DATE_FORMAT = 'dateFormat:scaled';
const DEFAULT_FROM = exports.DEFAULT_FROM = 'now/d';
const DEFAULT_TO = exports.DEFAULT_TO = 'now/d';
const DEFAULT_INTERVAL_PAUSE = exports.DEFAULT_INTERVAL_PAUSE = true;
const DEFAULT_INTERVAL_TYPE = exports.DEFAULT_INTERVAL_TYPE = 'manual';
const DEFAULT_INTERVAL_VALUE = exports.DEFAULT_INTERVAL_VALUE = 300000; // ms
const DEFAULT_TIMEPICKER_QUICK_RANGES = exports.DEFAULT_TIMEPICKER_QUICK_RANGES = 'timepicker:quickRanges';
const DEFAULT_TRANSFORMS = exports.DEFAULT_TRANSFORMS = 'securitySolution:transforms';
const SCROLLING_DISABLED_CLASS_NAME = exports.SCROLLING_DISABLED_CLASS_NAME = 'scrolling-disabled';
const GLOBAL_HEADER_HEIGHT = exports.GLOBAL_HEADER_HEIGHT = 96; // px
const GLOBAL_HEADER_HEIGHT_WITH_GLOBAL_BANNER = exports.GLOBAL_HEADER_HEIGHT_WITH_GLOBAL_BANNER = 128; // px
const FILTERS_GLOBAL_HEIGHT = exports.FILTERS_GLOBAL_HEIGHT = 109; // px
const FULL_SCREEN_TOGGLED_CLASS_NAME = exports.FULL_SCREEN_TOGGLED_CLASS_NAME = 'fullScreenToggled';
const NO_ALERT_INDEX = exports.NO_ALERT_INDEX = 'no-alert-index-049FC71A-4C2C-446F-9901-37XMC5024C51';
const ENDPOINT_METADATA_INDEX = exports.ENDPOINT_METADATA_INDEX = 'metrics-endpoint.metadata-*';
const DEFAULT_RULE_REFRESH_INTERVAL_ON = exports.DEFAULT_RULE_REFRESH_INTERVAL_ON = true;
const DEFAULT_RULE_REFRESH_INTERVAL_VALUE = exports.DEFAULT_RULE_REFRESH_INTERVAL_VALUE = 60000; // ms
const DEFAULT_RULE_REFRESH_IDLE_VALUE = exports.DEFAULT_RULE_REFRESH_IDLE_VALUE = 2700000; // ms
const DEFAULT_RULE_NOTIFICATION_QUERY_SIZE = exports.DEFAULT_RULE_NOTIFICATION_QUERY_SIZE = 100;
const SECURITY_FEATURE_ID = exports.SECURITY_FEATURE_ID = 'Security';
const DEFAULT_SPACE_ID = exports.DEFAULT_SPACE_ID = 'default';

// Document path where threat indicator fields are expected. Fields are used
// to enrich signals, and are copied to threat.enrichments.
const DEFAULT_INDICATOR_SOURCE_PATH = exports.DEFAULT_INDICATOR_SOURCE_PATH = 'threatintel.indicator';
const ENRICHMENT_DESTINATION_PATH = exports.ENRICHMENT_DESTINATION_PATH = 'threat.enrichments';
const DEFAULT_THREAT_INDEX_KEY = exports.DEFAULT_THREAT_INDEX_KEY = 'securitySolution:defaultThreatIndex';
const DEFAULT_THREAT_INDEX_VALUE = exports.DEFAULT_THREAT_INDEX_VALUE = ['filebeat-*'];
const DEFAULT_THREAT_MATCH_QUERY = exports.DEFAULT_THREAT_MATCH_QUERY = '@timestamp >= "now-30d"';
let SecurityPageName = exports.SecurityPageName = /*#__PURE__*/function (SecurityPageName) {
  SecurityPageName["administration"] = "administration";
  SecurityPageName["alerts"] = "alerts";
  SecurityPageName["authentications"] = "authentications";
  SecurityPageName["case"] = "case";
  SecurityPageName["caseConfigure"] = "case-configure";
  SecurityPageName["caseCreate"] = "case-create";
  SecurityPageName["detections"] = "detections";
  SecurityPageName["endpoints"] = "endpoints";
  SecurityPageName["eventFilters"] = "event_filters";
  SecurityPageName["hostIsolationExceptions"] = "host_isolation_exceptions";
  SecurityPageName["events"] = "events";
  SecurityPageName["exceptions"] = "exceptions";
  SecurityPageName["explore"] = "explore";
  SecurityPageName["hosts"] = "hosts";
  SecurityPageName["hostsAnomalies"] = "hosts-anomalies";
  SecurityPageName["hostsExternalAlerts"] = "hosts-external_alerts";
  SecurityPageName["investigate"] = "investigate";
  SecurityPageName["network"] = "network";
  SecurityPageName["networkAnomalies"] = "network-anomalies";
  SecurityPageName["networkDns"] = "network-dns";
  SecurityPageName["networkExternalAlerts"] = "network-external_alerts";
  SecurityPageName["networkHttp"] = "network-http";
  SecurityPageName["networkTls"] = "network-tls";
  SecurityPageName["timelines"] = "timelines";
  SecurityPageName["timelinesTemplates"] = "timelines-templates";
  SecurityPageName["overview"] = "overview";
  SecurityPageName["policies"] = "policies";
  SecurityPageName["rules"] = "rules";
  SecurityPageName["trustedApps"] = "trusted_apps";
  SecurityPageName["ueba"] = "ueba";
  SecurityPageName["uncommonProcesses"] = "uncommon_processes";
  return SecurityPageName;
}({});
const TIMELINES_PATH = exports.TIMELINES_PATH = '/timelines';
const CASES_PATH = exports.CASES_PATH = '/cases';
const OVERVIEW_PATH = exports.OVERVIEW_PATH = '/overview';
const DETECTIONS_PATH = exports.DETECTIONS_PATH = '/detections';
const ALERTS_PATH = exports.ALERTS_PATH = '/alerts';
const RULES_PATH = exports.RULES_PATH = '/rules';
const EXCEPTIONS_PATH = exports.EXCEPTIONS_PATH = '/exceptions';
const HOSTS_PATH = exports.HOSTS_PATH = '/hosts';
const UEBA_PATH = exports.UEBA_PATH = '/ueba';
const NETWORK_PATH = exports.NETWORK_PATH = '/network';
const MANAGEMENT_PATH = exports.MANAGEMENT_PATH = '/administration';
const ENDPOINTS_PATH = exports.ENDPOINTS_PATH = `${MANAGEMENT_PATH}/endpoints`;
const TRUSTED_APPS_PATH = exports.TRUSTED_APPS_PATH = `${MANAGEMENT_PATH}/trusted_apps`;
const EVENT_FILTERS_PATH = exports.EVENT_FILTERS_PATH = `${MANAGEMENT_PATH}/event_filters`;
const HOST_ISOLATION_EXCEPTIONS_PATH = exports.HOST_ISOLATION_EXCEPTIONS_PATH = `${MANAGEMENT_PATH}/host_isolation_exceptions`;
const APP_OVERVIEW_PATH = exports.APP_OVERVIEW_PATH = `${APP_PATH}${OVERVIEW_PATH}`;
const APP_MANAGEMENT_PATH = exports.APP_MANAGEMENT_PATH = `${APP_PATH}${MANAGEMENT_PATH}`;
const APP_ALERTS_PATH = exports.APP_ALERTS_PATH = `${APP_PATH}${ALERTS_PATH}`;
const APP_RULES_PATH = exports.APP_RULES_PATH = `${APP_PATH}${RULES_PATH}`;
const APP_EXCEPTIONS_PATH = exports.APP_EXCEPTIONS_PATH = `${APP_PATH}${EXCEPTIONS_PATH}`;
const APP_HOSTS_PATH = exports.APP_HOSTS_PATH = `${APP_PATH}${HOSTS_PATH}`;
const APP_UEBA_PATH = exports.APP_UEBA_PATH = `${APP_PATH}${UEBA_PATH}`;
const APP_NETWORK_PATH = exports.APP_NETWORK_PATH = `${APP_PATH}${NETWORK_PATH}`;
const APP_TIMELINES_PATH = exports.APP_TIMELINES_PATH = `${APP_PATH}${TIMELINES_PATH}`;
const APP_CASES_PATH = exports.APP_CASES_PATH = `${APP_PATH}${CASES_PATH}`;
const APP_ENDPOINTS_PATH = exports.APP_ENDPOINTS_PATH = `${APP_PATH}${ENDPOINTS_PATH}`;
const APP_TRUSTED_APPS_PATH = exports.APP_TRUSTED_APPS_PATH = `${APP_PATH}${TRUSTED_APPS_PATH}`;
const APP_EVENT_FILTERS_PATH = exports.APP_EVENT_FILTERS_PATH = `${APP_PATH}${EVENT_FILTERS_PATH}`;
const APP_HOST_ISOLATION_EXCEPTIONS_PATH = exports.APP_HOST_ISOLATION_EXCEPTIONS_PATH = `${APP_PATH}${HOST_ISOLATION_EXCEPTIONS_PATH}`;

/** The comma-delimited list of Elasticsearch indices from which the SIEM app collects events */
const DEFAULT_INDEX_PATTERN = exports.DEFAULT_INDEX_PATTERN = ['apm-*-transaction*', 'traces-apm*', 'auditbeat-*', 'endgame-*', 'filebeat-*', 'logs-*', 'packetbeat-*', 'winlogbeat-*'];
const DEFAULT_INDEX_PATTERN_EXPERIMENTAL = exports.DEFAULT_INDEX_PATTERN_EXPERIMENTAL = [
// TODO: Steph/ueba TEMP for testing UEBA data
'ml_host_risk_score_*'];

/** This Kibana Advanced Setting enables the `Security news` feed widget */
const ENABLE_NEWS_FEED_SETTING = exports.ENABLE_NEWS_FEED_SETTING = 'securitySolution:enableNewsFeed';

/** This Kibana Advanced Setting sets the auto refresh interval for the detections all rules table */
const DEFAULT_RULES_TABLE_REFRESH_SETTING = exports.DEFAULT_RULES_TABLE_REFRESH_SETTING = 'securitySolution:rulesTableRefresh';

/** This Kibana Advanced Setting specifies the URL of the News feed widget */
const NEWS_FEED_URL_SETTING = exports.NEWS_FEED_URL_SETTING = 'securitySolution:newsFeedUrl';

/** The default value for News feed widget */
const NEWS_FEED_URL_SETTING_DEFAULT = exports.NEWS_FEED_URL_SETTING_DEFAULT = 'https://feeds.elastic.co/security-solution';

/** This Kibana Advanced Setting specifies the URLs of `IP Reputation Links`*/
const IP_REPUTATION_LINKS_SETTING = exports.IP_REPUTATION_LINKS_SETTING = 'securitySolution:ipReputationLinks';

/** The default value for `IP Reputation Links` */
const IP_REPUTATION_LINKS_SETTING_DEFAULT = exports.IP_REPUTATION_LINKS_SETTING_DEFAULT = `[
  { "name": "virustotal.com", "url_template": "https://www.virustotal.com/gui/search/{{ip}}" },
  { "name": "talosIntelligence.com", "url_template": "https://talosintelligence.com/reputation_center/lookup?search={{ip}}" }
]`;

/** The default settings for the transforms */
const defaultTransformsSetting = exports.defaultTransformsSetting = {
  enabled: false,
  auto_start: true,
  auto_create: true,
  query: {
    range: {
      '@timestamp': {
        gte: 'now-1d/d',
        format: 'strict_date_optional_time'
      }
    }
  },
  retention_policy: {
    time: {
      field: '@timestamp',
      max_age: '1w'
    }
  },
  max_page_search_size: 5000,
  settings: [{
    prefix: 'all',
    indices: ['auditbeat-*', 'endgame-*', 'filebeat-*', 'logs-*', 'packetbeat-*', 'winlogbeat-*'],
    data_sources: [['auditbeat-*', 'endgame-*', 'filebeat-*', 'logs-*', 'packetbeat-*', 'winlogbeat-*']]
  }]
};
const DEFAULT_TRANSFORMS_SETTING = exports.DEFAULT_TRANSFORMS_SETTING = JSON.stringify(defaultTransformsSetting, null, 2);

/**
 * Id for the signals alerting type
 */
const SIGNALS_ID = exports.SIGNALS_ID = `siem.signals`;

/**
 * IDs for RAC rule types
 */
const RULE_TYPE_PREFIX = `siem`;
const EQL_RULE_TYPE_ID = exports.EQL_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.eqlRule`;
const INDICATOR_RULE_TYPE_ID = exports.INDICATOR_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.indicatorRule`;
const ML_RULE_TYPE_ID = exports.ML_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.mlRule`;
const QUERY_RULE_TYPE_ID = exports.QUERY_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.queryRule`;
const THRESHOLD_RULE_TYPE_ID = exports.THRESHOLD_RULE_TYPE_ID = `${RULE_TYPE_PREFIX}.thresholdRule`;

/**
 * Id for the notifications alerting type
 * @deprecated Once we are confident all rules relying on side-car actions SO's have been migrated to SO references we should remove this function
 */
const LEGACY_NOTIFICATIONS_ID = exports.LEGACY_NOTIFICATIONS_ID = `siem.notifications`;

/**
 * Special internal structure for tags for signals. This is used
 * to filter out tags that have internal structures within them.
 */
const INTERNAL_IDENTIFIER = exports.INTERNAL_IDENTIFIER = '__internal';
const INTERNAL_RULE_ID_KEY = exports.INTERNAL_RULE_ID_KEY = `${INTERNAL_IDENTIFIER}_rule_id`;
const INTERNAL_RULE_ALERT_ID_KEY = exports.INTERNAL_RULE_ALERT_ID_KEY = `${INTERNAL_IDENTIFIER}_rule_alert_id`;
const INTERNAL_IMMUTABLE_KEY = exports.INTERNAL_IMMUTABLE_KEY = `${INTERNAL_IDENTIFIER}_immutable`;

/**
 * Internal actions route
 */
const UPDATE_OR_CREATE_LEGACY_ACTIONS = exports.UPDATE_OR_CREATE_LEGACY_ACTIONS = '/internal/api/detection/legacy/notifications';

/**
 * Detection engine routes
 */
const DETECTION_ENGINE_URL = exports.DETECTION_ENGINE_URL = '/api/detection_engine';
const DETECTION_ENGINE_RULES_URL = exports.DETECTION_ENGINE_RULES_URL = `${DETECTION_ENGINE_URL}/rules`;
const DETECTION_ENGINE_PREPACKAGED_URL = exports.DETECTION_ENGINE_PREPACKAGED_URL = `${DETECTION_ENGINE_RULES_URL}/prepackaged`;
const DETECTION_ENGINE_PRIVILEGES_URL = exports.DETECTION_ENGINE_PRIVILEGES_URL = `${DETECTION_ENGINE_URL}/privileges`;
const DETECTION_ENGINE_INDEX_URL = exports.DETECTION_ENGINE_INDEX_URL = `${DETECTION_ENGINE_URL}/index`;
const DETECTION_ENGINE_TAGS_URL = exports.DETECTION_ENGINE_TAGS_URL = `${DETECTION_ENGINE_URL}/tags`;
const DETECTION_ENGINE_RULES_STATUS_URL = exports.DETECTION_ENGINE_RULES_STATUS_URL = `${DETECTION_ENGINE_RULES_URL}/_find_statuses`;
const DETECTION_ENGINE_PREPACKAGED_RULES_STATUS_URL = exports.DETECTION_ENGINE_PREPACKAGED_RULES_STATUS_URL = `${DETECTION_ENGINE_RULES_URL}/prepackaged/_status`;
const DETECTION_ENGINE_RULES_BULK_ACTION = exports.DETECTION_ENGINE_RULES_BULK_ACTION = `${DETECTION_ENGINE_RULES_URL}/_bulk_action`;
const TIMELINE_RESOLVE_URL = exports.TIMELINE_RESOLVE_URL = '/api/timeline/resolve';
const TIMELINE_URL = exports.TIMELINE_URL = '/api/timeline';
const TIMELINES_URL = exports.TIMELINES_URL = '/api/timelines';
const TIMELINE_FAVORITE_URL = exports.TIMELINE_FAVORITE_URL = '/api/timeline/_favorite';
const TIMELINE_DRAFT_URL = exports.TIMELINE_DRAFT_URL = `${TIMELINE_URL}/_draft`;
const TIMELINE_EXPORT_URL = exports.TIMELINE_EXPORT_URL = `${TIMELINE_URL}/_export`;
const TIMELINE_IMPORT_URL = exports.TIMELINE_IMPORT_URL = `${TIMELINE_URL}/_import`;
const TIMELINE_PREPACKAGED_URL = exports.TIMELINE_PREPACKAGED_URL = `${TIMELINE_URL}/_prepackaged`;
const NOTE_URL = exports.NOTE_URL = '/api/note';
const PINNED_EVENT_URL = exports.PINNED_EVENT_URL = '/api/pinned_event';

/**
 * Default signals index key for kibana.dev.yml
 */
const SIGNALS_INDEX_KEY = exports.SIGNALS_INDEX_KEY = 'signalsIndex';
const DETECTION_ENGINE_SIGNALS_URL = exports.DETECTION_ENGINE_SIGNALS_URL = `${DETECTION_ENGINE_URL}/signals`;
const DETECTION_ENGINE_SIGNALS_STATUS_URL = exports.DETECTION_ENGINE_SIGNALS_STATUS_URL = `${DETECTION_ENGINE_SIGNALS_URL}/status`;
const DETECTION_ENGINE_QUERY_SIGNALS_URL = exports.DETECTION_ENGINE_QUERY_SIGNALS_URL = `${DETECTION_ENGINE_SIGNALS_URL}/search`;
const DETECTION_ENGINE_SIGNALS_MIGRATION_URL = exports.DETECTION_ENGINE_SIGNALS_MIGRATION_URL = `${DETECTION_ENGINE_SIGNALS_URL}/migration`;
const DETECTION_ENGINE_SIGNALS_MIGRATION_STATUS_URL = exports.DETECTION_ENGINE_SIGNALS_MIGRATION_STATUS_URL = `${DETECTION_ENGINE_SIGNALS_URL}/migration_status`;
const DETECTION_ENGINE_SIGNALS_FINALIZE_MIGRATION_URL = exports.DETECTION_ENGINE_SIGNALS_FINALIZE_MIGRATION_URL = `${DETECTION_ENGINE_SIGNALS_URL}/finalize_migration`;
const ALERTS_AS_DATA_URL = exports.ALERTS_AS_DATA_URL = '/internal/rac/alerts';
const ALERTS_AS_DATA_FIND_URL = exports.ALERTS_AS_DATA_FIND_URL = `${ALERTS_AS_DATA_URL}/find`;

/**
 * Common naming convention for an unauthenticated user
 */
const UNAUTHENTICATED_USER = exports.UNAUTHENTICATED_USER = 'Unauthenticated';

/*
  Licensing requirements
 */
const MINIMUM_ML_LICENSE = exports.MINIMUM_ML_LICENSE = 'platinum';

/*
  Machine Learning constants
 */
const ML_GROUP_ID = exports.ML_GROUP_ID = 'security';
const LEGACY_ML_GROUP_ID = exports.LEGACY_ML_GROUP_ID = 'siem';
const ML_GROUP_IDS = exports.ML_GROUP_IDS = [ML_GROUP_ID, LEGACY_ML_GROUP_ID];

/*
  Rule notifications options
*/
const NOTIFICATION_SUPPORTED_ACTION_TYPES_IDS = exports.NOTIFICATION_SUPPORTED_ACTION_TYPES_IDS = ['.email', '.index', '.jira', '.pagerduty', '.resilient', '.servicenow', '.servicenow-sir', '.servicenow-itom', '.slack', '.swimlane', '.teams', '.webhook'];
if (_common.ENABLE_CASE_CONNECTOR) {
  NOTIFICATION_SUPPORTED_ACTION_TYPES_IDS.push('.case');
}
const NOTIFICATION_THROTTLE_NO_ACTIONS = exports.NOTIFICATION_THROTTLE_NO_ACTIONS = 'no_actions';
const NOTIFICATION_THROTTLE_RULE = exports.NOTIFICATION_THROTTLE_RULE = 'rule';
const showAllOthersBucket = exports.showAllOthersBucket = ['destination.ip', 'event.action', 'event.category', 'event.dataset', 'event.module', 'signal.rule.threat.tactic.name', 'source.ip', 'destination.ip', 'user.name'];

/**
 * Used for transforms for metrics_entities. If the security_solutions pulls in
 * the metrics_entities plugin, then it should pull this constant from there rather
 * than use it from here.
 */
const ELASTIC_NAME = exports.ELASTIC_NAME = 'estc';
const METADATA_TRANSFORM_STATS_URL = exports.METADATA_TRANSFORM_STATS_URL = `/api/transform/transforms/${_constants.METADATA_TRANSFORMS_PATTERN}/_stats`;
const RISKY_HOSTS_INDEX_PREFIX = exports.RISKY_HOSTS_INDEX_PREFIX = 'ml_host_risk_score_latest_';
const TRANSFORM_STATES = exports.TRANSFORM_STATES = {
  ABORTING: 'aborting',
  FAILED: 'failed',
  INDEXING: 'indexing',
  STARTED: 'started',
  STOPPED: 'stopped',
  STOPPING: 'stopping',
  WAITING: 'waiting'
};
const WARNING_TRANSFORM_STATES = exports.WARNING_TRANSFORM_STATES = new Set([TRANSFORM_STATES.ABORTING, TRANSFORM_STATES.FAILED, TRANSFORM_STATES.STOPPED, TRANSFORM_STATES.STOPPING]);