"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSort = getSort;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This file was copied from src/plugins/discover/public/application/apps/main/components/doc_table/lib/get_sort.ts
 */

function isSortable(fieldName, indexPattern) {
  const field = indexPattern.getFieldByName(fieldName);
  return !!(field && field.sortable);
}
function isLegacySort(sort) {
  return sort.length === 2 && typeof sort[0] === 'string' && (sort[1] === 'desc' || sort[1] === 'asc');
}
function createSortObject(sortPair, indexPattern) {
  if (Array.isArray(sortPair) && sortPair.length === 2 && isSortable(String(sortPair[0]), indexPattern)) {
    const [field, direction] = sortPair;
    return {
      [field]: direction
    };
  } else if ((0, _lodash.isPlainObject)(sortPair) && isSortable(Object.keys(sortPair)[0], indexPattern)) {
    return sortPair;
  }
}

/**
 * Take a sorting array and make it into an object
 * @param {array} sort two dimensional array [[fieldToSort, directionToSort]]
 *  or an array of objects [{fieldToSort: directionToSort}]
 * @param {object} indexPattern used for determining default sort
 * @returns Array<{object}> an array of sort objects
 */
function getSort(sort, indexPattern) {
  if (Array.isArray(sort)) {
    if (isLegacySort(sort)) {
      // To stay compatible with legacy sort, which just supported a single sort field
      return [{
        [sort[0]]: sort[1]
      }];
    }
    return sort.map(sortPair => createSortObject(sortPair, indexPattern)).filter(sortPairObj => typeof sortPairObj === 'object');
  }
  return [];
}