"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.download = download;
var _axios = _interopRequireDefault(require("axios"));
var _crypto = require("crypto");
var _promises = require("fs/promises");
var _fs = require("fs");
var _path = require("path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Download a url and calculate it's checksum
 */
async function download(url, path, logger) {
  logger.info(`Downloading ${url} to ${path}`);
  const hash = (0, _crypto.createHash)('sha256');
  await (0, _promises.mkdir)((0, _path.dirname)(path), {
    recursive: true
  });
  const handle = await (0, _promises.open)(path, 'w');
  try {
    const resp = await _axios.default.request({
      url,
      method: 'GET',
      responseType: 'stream'
    });
    resp.data.on('data', chunk => {
      (0, _fs.writeSync)(handle.fd, chunk);
      hash.update(chunk);
    });
    await new Promise((resolve, reject) => {
      resp.data.on('error', err => {
        logger.error(err);
        reject(err);
      }).on('end', () => {
        logger.info(`Downloaded ${url}`);
        resolve();
      });
    });
  } catch (err) {
    throw new Error(`Unable to download ${url}: ${err}`);
  } finally {
    await handle.close();
  }
  return hash.digest('hex');
}