"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntryCursorRT = exports.logEntryBeforeCursorRT = exports.logEntryAroundCursorRT = exports.logEntryAfterCursorRT = exports.getLogEntryCursorFromHit = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _runtime_types = require("../runtime_types");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logEntryCursorRT = exports.logEntryCursorRT = rt.type({
  time: rt.number,
  tiebreaker: rt.number
});
const logEntryBeforeCursorRT = exports.logEntryBeforeCursorRT = rt.type({
  before: rt.union([logEntryCursorRT, rt.literal('last')])
});
const logEntryAfterCursorRT = exports.logEntryAfterCursorRT = rt.type({
  after: rt.union([logEntryCursorRT, rt.literal('first')])
});
const logEntryAroundCursorRT = exports.logEntryAroundCursorRT = rt.type({
  center: logEntryCursorRT
});
const getLogEntryCursorFromHit = hit => (0, _runtime_types.decodeOrThrow)(logEntryCursorRT)({
  time: hit.sort[0],
  tiebreaker: hit.sort[1]
});
exports.getLogEntryCursorFromHit = getLogEntryCursorFromHit;