"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogEntryCategoriesSuccessReponsePayloadRT = exports.getLogEntryCategoriesResponsePayloadRT = exports.getLogEntryCategoriesRequestPayloadRT = exports.LOG_ANALYSIS_GET_LOG_ENTRY_CATEGORIES_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _shared = require("../../shared");
var _log_analysis = require("../../../log_analysis");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_ANALYSIS_GET_LOG_ENTRY_CATEGORIES_PATH = exports.LOG_ANALYSIS_GET_LOG_ENTRY_CATEGORIES_PATH = '/api/infra/log_analysis/results/log_entry_categories';

/**
 * request
 */

const logEntryCategoriesHistogramParametersRT = rt.type({
  id: rt.string,
  timeRange: _shared.timeRangeRT,
  bucketCount: rt.number
});
const getLogEntryCategoriesRequestPayloadRT = exports.getLogEntryCategoriesRequestPayloadRT = rt.type({
  data: rt.intersection([rt.type({
    // the number of categories to fetch
    categoryCount: rt.number,
    // the id of the source configuration
    sourceId: rt.string,
    // the time range to fetch the categories from
    timeRange: _shared.timeRangeRT,
    // a list of histograms to create
    histograms: rt.array(logEntryCategoriesHistogramParametersRT),
    // the criteria to the categories by
    sort: _log_analysis.categoriesSortRT
  }), rt.partial({
    // the datasets to filter for (optional, unfiltered if not present)
    datasets: rt.array(rt.string)
  })])
});
/**
 * response
 */

const getLogEntryCategoriesSuccessReponsePayloadRT = exports.getLogEntryCategoriesSuccessReponsePayloadRT = rt.intersection([rt.type({
  data: rt.type({
    categories: rt.array(_log_analysis.logEntryCategoryRT)
  })
}), rt.partial({
  timing: _shared.routeTimingMetadataRT
})]);
const getLogEntryCategoriesResponsePayloadRT = exports.getLogEntryCategoriesResponsePayloadRT = rt.union([getLogEntryCategoriesSuccessReponsePayloadRT, _shared.badRequestErrorRT, _shared.forbiddenErrorRT]);