"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricsK8sAnomaliesSuccessReponsePayloadRT = exports.getMetricsK8sAnomaliesRequestPayloadRT = exports.INFA_ML_GET_METRICS_K8S_ANOMALIES_PATH = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _shared = require("../../shared");
var _common = require("./common");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFA_ML_GET_METRICS_K8S_ANOMALIES_PATH = exports.INFA_ML_GET_METRICS_K8S_ANOMALIES_PATH = '/api/infra/infra_ml/results/metrics_k8s_anomalies';
const metricsK8sAnomalyCommonFieldsRT = rt.intersection([rt.type({
  id: rt.string,
  anomalyScore: rt.number,
  typical: rt.number,
  actual: rt.number,
  type: _common.anomalyTypeRT,
  influencers: rt.array(rt.string),
  duration: rt.number,
  startTime: rt.number,
  jobId: rt.string
}), rt.partial({
  partitionFieldName: rt.string,
  partitionFieldValue: rt.string
})]);
const metricsK8sAnomalyRT = metricsK8sAnomalyCommonFieldsRT;
const getMetricsK8sAnomaliesSuccessReponsePayloadRT = exports.getMetricsK8sAnomaliesSuccessReponsePayloadRT = rt.intersection([rt.type({
  data: rt.intersection([rt.type({
    anomalies: rt.array(metricsK8sAnomalyRT),
    // Signifies there are more entries backwards or forwards. If this was a request
    // for a previous page, there are more previous pages, if this was a request for a next page,
    // there are more next pages.
    hasMoreEntries: rt.boolean
  }), rt.partial({
    paginationCursors: rt.type({
      // The cursor to use to fetch the previous page
      previousPageCursor: _common.paginationCursorRT,
      // The cursor to use to fetch the next page
      nextPageCursor: _common.paginationCursorRT
    })
  })])
}), rt.partial({
  timing: _shared.routeTimingMetadataRT
})]);
const getMetricsK8sAnomaliesRequestPayloadRT = exports.getMetricsK8sAnomaliesRequestPayloadRT = rt.type({
  data: rt.intersection([rt.type({
    // the ID of the source configuration
    sourceId: rt.string,
    anomalyThreshold: rt.number,
    // the time range to fetch the log entry anomalies from
    timeRange: _shared.timeRangeRT
  }), rt.partial({
    query: rt.string,
    metric: _common.metricRT,
    // Pagination properties
    pagination: _common.paginationRT,
    // Sort properties
    sort: _common.sortRT
  })])
});