"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceMapsRouteRepository = exports.sourceMapRt = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var t = _interopRequireWildcard(require("io-ts"));
var _json_rt = require("@kbn/io-ts-utils/json_rt");
var _source_maps = require("../lib/fleet/source_maps");
var _get_internal_saved_objects_client = require("../lib/helpers/get_internal_saved_objects_client");
var _create_apm_server_route = require("./create_apm_server_route");
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
var _string_from_buffer_rt = require("../utils/string_from_buffer_rt");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourceMapRt = exports.sourceMapRt = t.intersection([t.type({
  version: t.number,
  sources: t.array(t.string),
  mappings: t.string
}), t.partial({
  names: t.array(t.string),
  file: t.string,
  sourceRoot: t.string,
  sourcesContent: t.array(t.string)
})]);
const listSourceMapRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /api/apm/sourcemaps',
  options: {
    tags: ['access:apm']
  },
  handler: async ({
    plugins
  }) => {
    try {
      var _plugins$fleet;
      const fleetPluginStart = await ((_plugins$fleet = plugins.fleet) === null || _plugins$fleet === void 0 ? void 0 : _plugins$fleet.start());
      if (fleetPluginStart) {
        const artifacts = await (0, _source_maps.listArtifacts)({
          fleetPluginStart
        });
        return {
          artifacts
        };
      }
    } catch (e) {
      throw _boom.default.internal('Something went wrong while fetching artifacts source maps', e);
    }
  }
});
const uploadSourceMapRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /api/apm/sourcemaps',
  options: {
    tags: ['access:apm', 'access:apm_write'],
    body: {
      accepts: ['multipart/form-data']
    }
  },
  params: t.type({
    body: t.type({
      service_name: t.string,
      service_version: t.string,
      bundle_filepath: t.string,
      sourcemap: t.union([t.string, _string_from_buffer_rt.stringFromBufferRt]).pipe(_json_rt.jsonRt).pipe(sourceMapRt)
    })
  }),
  handler: async ({
    params,
    plugins,
    core
  }) => {
    var _plugins$fleet2;
    const {
      service_name: serviceName,
      service_version: serviceVersion,
      bundle_filepath: bundleFilepath,
      sourcemap: sourceMap
    } = params.body;
    const cleanedBundleFilepath = (0, _source_maps.getCleanedBundleFilePath)(bundleFilepath);
    const fleetPluginStart = await ((_plugins$fleet2 = plugins.fleet) === null || _plugins$fleet2 === void 0 ? void 0 : _plugins$fleet2.start());
    const coreStart = await core.start();
    const esClient = coreStart.elasticsearch.client.asInternalUser;
    const savedObjectsClient = await (0, _get_internal_saved_objects_client.getInternalSavedObjectsClient)(core.setup);
    try {
      if (fleetPluginStart) {
        const artifact = await (0, _source_maps.createApmArtifact)({
          fleetPluginStart,
          apmArtifactBody: {
            serviceName,
            serviceVersion,
            bundleFilepath: cleanedBundleFilepath,
            sourceMap
          }
        });
        await (0, _source_maps.updateSourceMapsOnFleetPolicies)({
          core,
          fleetPluginStart,
          savedObjectsClient: savedObjectsClient,
          elasticsearchClient: esClient
        });
        return artifact;
      }
    } catch (e) {
      throw _boom.default.internal('Something went wrong while creating a new source map', e);
    }
  }
});
const deleteSourceMapRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'DELETE /api/apm/sourcemaps/{id}',
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  params: t.type({
    path: t.type({
      id: t.string
    })
  }),
  handler: async ({
    params,
    plugins,
    core
  }) => {
    var _plugins$fleet3;
    const fleetPluginStart = await ((_plugins$fleet3 = plugins.fleet) === null || _plugins$fleet3 === void 0 ? void 0 : _plugins$fleet3.start());
    const {
      id
    } = params.path;
    const coreStart = await core.start();
    const esClient = coreStart.elasticsearch.client.asInternalUser;
    const savedObjectsClient = await (0, _get_internal_saved_objects_client.getInternalSavedObjectsClient)(core.setup);
    try {
      if (fleetPluginStart) {
        await (0, _source_maps.deleteApmArtifact)({
          id,
          fleetPluginStart
        });
        await (0, _source_maps.updateSourceMapsOnFleetPolicies)({
          core,
          fleetPluginStart,
          savedObjectsClient: savedObjectsClient,
          elasticsearchClient: esClient
        });
      }
    } catch (e) {
      throw _boom.default.internal(`Something went wrong while deleting source map. id: ${id}`, e);
    }
  }
});
const sourceMapsRouteRepository = exports.sourceMapsRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(listSourceMapRoute).add(uploadSourceMapRoute).add(deleteSourceMapRoute);