"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_apm_server_route = require("./create_apm_server_route");
var _get_distribution = require("../lib/errors/distribution/get_distribution");
var _get_error_group_sample = require("../lib/errors/get_error_group_sample");
var _get_error_groups = require("../lib/errors/get_error_groups");
var _setup_request = require("../lib/helpers/setup_request");
var _default_api_types = require("./default_api_types");
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.partial({
      sortField: t.string,
      sortDirection: t.union([t.literal('asc'), t.literal('desc')])
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      sortField,
      sortDirection,
      start,
      end
    } = params.query;
    const errorGroups = await (0, _get_error_groups.getErrorGroups)({
      environment,
      kuery,
      serviceName,
      sortField,
      sortDirection,
      setup,
      start,
      end
    });
    return {
      errorGroups
    };
  }
});
const errorGroupsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors/{groupId}',
  params: t.type({
    path: t.type({
      serviceName: t.string,
      groupId: t.string
    }),
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      serviceName,
      groupId
    } = params.path;
    const {
      environment,
      kuery,
      start,
      end
    } = params.query;
    return (0, _get_error_group_sample.getErrorGroupSample)({
      environment,
      groupId,
      kuery,
      serviceName,
      setup,
      start,
      end
    });
  }
});
const errorDistributionRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/services/{serviceName}/errors/distribution',
  params: t.type({
    path: t.type({
      serviceName: t.string
    }),
    query: t.intersection([t.partial({
      groupId: t.string
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.comparisonRangeRt])
  }),
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      params
    } = resources;
    const {
      serviceName
    } = params.path;
    const {
      environment,
      kuery,
      groupId,
      start,
      end,
      comparisonStart,
      comparisonEnd
    } = params.query;
    return (0, _get_distribution.getErrorDistribution)({
      environment,
      kuery,
      serviceName,
      groupId,
      setup,
      start,
      end,
      comparisonStart,
      comparisonEnd
    });
  }
});
const errorsRouteRepository = exports.errorsRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(errorsRoute).add(errorGroupsRoute).add(errorDistributionRoute);