"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICENOW_SIR = exports.SERVICENOW_ITSM = exports.SERVICENOW_ITOM = exports.SERVICENOW = exports.ALLOWED_HOSTS_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SERVICENOW = exports.SERVICENOW = _i18n.i18n.translate('xpack.actions.builtin.serviceNowTitle', {
  defaultMessage: 'ServiceNow'
});
const SERVICENOW_ITSM = exports.SERVICENOW_ITSM = _i18n.i18n.translate('xpack.actions.builtin.serviceNowITSMTitle', {
  defaultMessage: 'ServiceNow ITSM'
});
const SERVICENOW_SIR = exports.SERVICENOW_SIR = _i18n.i18n.translate('xpack.actions.builtin.serviceNowSIRTitle', {
  defaultMessage: 'ServiceNow SecOps'
});
const SERVICENOW_ITOM = exports.SERVICENOW_ITOM = _i18n.i18n.translate('xpack.actions.builtin.serviceNowITOMTitle', {
  defaultMessage: 'ServiceNow ITOM'
});
const ALLOWED_HOSTS_ERROR = message => _i18n.i18n.translate('xpack.actions.builtin.configuration.apiAllowedHostsError', {
  defaultMessage: 'error configuring connector action: {message}',
  values: {
    message
  }
});
exports.ALLOWED_HOSTS_ERROR = ALLOWED_HOSTS_ERROR;