"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForReindexTask = void 0;
var TaskEither = _interopRequireWildcard(require("fp-ts/lib/TaskEither"));
var Option = _interopRequireWildcard(require("fp-ts/lib/Option"));
var _function = require("fp-ts/lib/function");
var _wait_for_task = require("./wait_for_task");
var _es_errors = require("./es_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const waitForReindexTask = exports.waitForReindexTask = (0, _function.flow)(_wait_for_task.waitForTask, TaskEither.chain(res => {
  if (Option.isSome(res.error)) {
    if (res.error.value.type === 'index_not_found_exception') {
      return TaskEither.left({
        type: 'index_not_found_exception',
        index: res.error.value.index
      });
    } else {
      throw new Error('Reindex failed with the following error:\n' + JSON.stringify(res.error));
    }
  } else if (Option.isSome(res.failures)) {
    const failureCauses = res.failures.value.map(failure => failure.cause);
    if (failureCauses.every(_es_errors.isWriteBlockException)) {
      return TaskEither.left({
        type: 'target_index_had_write_block'
      });
    } else if (failureCauses.every(_es_errors.isIncompatibleMappingException)) {
      return TaskEither.left({
        type: 'incompatible_mapping_exception'
      });
    } else {
      throw new Error('Reindex failed with the following failures:\n' + JSON.stringify(res.failures.value));
    }
  } else {
    return TaskEither.right('reindex_succeeded');
  }
}));