"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilters = void 0;
var _get_general_filters = require("../get_general_filters");
var _get_saved_object_types = require("../get_saved_object_types");
var _get_trusted_apps_filter = require("../get_trusted_apps_filter");
var _get_event_filters_filter = require("../get_event_filters_filter");
var _get_host_isolation_exceptions_filter = require("../get_host_isolation_exceptions_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getFilters = ({
  filters,
  namespaceTypes,
  showTrustedApps,
  showEventFilters,
  showHostIsolationExceptions
}) => {
  const namespaces = (0, _get_saved_object_types.getSavedObjectTypes)({
    namespaceType: namespaceTypes
  });
  const generalFilters = (0, _get_general_filters.getGeneralFilters)(filters, namespaces);
  const trustedAppsFilter = (0, _get_trusted_apps_filter.getTrustedAppsFilter)(showTrustedApps, namespaces);
  const eventFiltersFilter = (0, _get_event_filters_filter.getEventFiltersFilter)(showEventFilters, namespaces);
  const hostIsolationExceptionsFilter = (0, _get_host_isolation_exceptions_filter.getHostIsolationExceptionsFilter)(showHostIsolationExceptions, namespaces);
  return [generalFilters, trustedAppsFilter, eventFiltersFilter, hostIsolationExceptionsFilter].filter(filter => filter.trim() !== '').join(' AND ');
};
exports.getFilters = getFilters;