"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_EXCEPTION_LIST_SIZE = exports.LIST_URL = exports.LIST_PRIVILEGES_URL = exports.LIST_ITEM_URL = exports.LIST_INDEX = exports.EXCEPTION_LIST_URL = exports.EXCEPTION_LIST_NAMESPACE_AGNOSTIC = exports.EXCEPTION_LIST_NAMESPACE = exports.EXCEPTION_LIST_ITEM_URL = exports.ENDPOINT_TRUSTED_APPS_LIST_NAME = exports.ENDPOINT_TRUSTED_APPS_LIST_ID = exports.ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = exports.ENDPOINT_LIST_URL = exports.ENDPOINT_LIST_NAME = exports.ENDPOINT_LIST_ITEM_URL = exports.ENDPOINT_LIST_ID = exports.ENDPOINT_LIST_DESCRIPTION = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = exports.ENDPOINT_EVENT_FILTERS_LIST_NAME = exports.ENDPOINT_EVENT_FILTERS_LIST_ID = exports.ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Value list routes
 */
const LIST_URL = exports.LIST_URL = '/api/lists';
const LIST_INDEX = exports.LIST_INDEX = `${LIST_URL}/index`;
const LIST_ITEM_URL = exports.LIST_ITEM_URL = `${LIST_URL}/items`;
const LIST_PRIVILEGES_URL = exports.LIST_PRIVILEGES_URL = `${LIST_URL}/privileges`;

/**
 * Exception list routes
 */
const EXCEPTION_LIST_URL = exports.EXCEPTION_LIST_URL = '/api/exception_lists';
const EXCEPTION_LIST_ITEM_URL = exports.EXCEPTION_LIST_ITEM_URL = '/api/exception_lists/items';

/**
 * Exception list spaces
 */
const EXCEPTION_LIST_NAMESPACE_AGNOSTIC = exports.EXCEPTION_LIST_NAMESPACE_AGNOSTIC = 'exception-list-agnostic';
const EXCEPTION_LIST_NAMESPACE = exports.EXCEPTION_LIST_NAMESPACE = 'exception-list';

/**
 * Specific routes for the single global space agnostic endpoint list
 */
const ENDPOINT_LIST_URL = exports.ENDPOINT_LIST_URL = '/api/endpoint_list';

/**
 * Specific routes for the single global space agnostic endpoint list. These are convenience
 * routes where they are going to try and create the global space agnostic endpoint list if it
 * does not exist yet or if it was deleted at some point and re-create it before adding items to
 * the list
 */
const ENDPOINT_LIST_ITEM_URL = exports.ENDPOINT_LIST_ITEM_URL = '/api/endpoint_list/items';

/**
 * This ID is used for _both_ the Saved Object ID and for the list_id
 * for the single global space agnostic endpoint list
 */
const ENDPOINT_LIST_ID = exports.ENDPOINT_LIST_ID = 'endpoint_list';

/** The name of the single global space agnostic endpoint list */
const ENDPOINT_LIST_NAME = exports.ENDPOINT_LIST_NAME = 'Endpoint Security Exception List';

/** The description of the single global space agnostic endpoint list */
const ENDPOINT_LIST_DESCRIPTION = exports.ENDPOINT_LIST_DESCRIPTION = 'Endpoint Security Exception List';
const MAX_EXCEPTION_LIST_SIZE = exports.MAX_EXCEPTION_LIST_SIZE = 10000;

/** ID of trusted apps agnostic list */
const ENDPOINT_TRUSTED_APPS_LIST_ID = exports.ENDPOINT_TRUSTED_APPS_LIST_ID = 'endpoint_trusted_apps';

/** Name of trusted apps agnostic list */
const ENDPOINT_TRUSTED_APPS_LIST_NAME = exports.ENDPOINT_TRUSTED_APPS_LIST_NAME = 'Endpoint Security Trusted Apps List';

/** Description of trusted apps agnostic list */
const ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = exports.ENDPOINT_TRUSTED_APPS_LIST_DESCRIPTION = 'Endpoint Security Trusted Apps List';

/** ID of event filters agnostic list */
const ENDPOINT_EVENT_FILTERS_LIST_ID = exports.ENDPOINT_EVENT_FILTERS_LIST_ID = 'endpoint_event_filters';

/** Name of event filters agnostic list */
const ENDPOINT_EVENT_FILTERS_LIST_NAME = exports.ENDPOINT_EVENT_FILTERS_LIST_NAME = 'Endpoint Security Event Filters List';

/** Description of event filters agnostic list */
const ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = exports.ENDPOINT_EVENT_FILTERS_LIST_DESCRIPTION = 'Endpoint Security Event Filters List';
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_ID = 'endpoint_host_isolation_exceptions';
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_NAME = 'Endpoint Security Host isolation exceptions List';
const ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = exports.ENDPOINT_HOST_ISOLATION_EXCEPTIONS_LIST_DESCRIPTION = 'Endpoint Security Host isolation exceptions List';