/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
/**
 * Types the OnlyFalseAllowed as:
 *   - If null or undefined, then a default false will be set
 *   - If true is sent in then this will return an error
 *   - If false is sent in then this will allow it only false
 */
export var OnlyFalseAllowed = new t.Type('DefaultBooleanTrue', t["boolean"].is, function (input, context) {
  if (input == null) {
    return t.success(false);
  } else {
    if (typeof input === 'boolean' && input === false) {
      return t.success(false);
    } else {
      return t.failure(input, context);
    }
  }
}, t.identity);