/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
export var NonEmptyArray = function NonEmptyArray(codec) {
  var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "NonEmptyArray<".concat(codec.name, ">");
  var arrType = t.array(codec);
  return new t.Type(name, arrType.is, function (input, context) {
    if (Array.isArray(input) && input.length === 0) {
      return t.failure(input, context);
    } else {
      return arrType.validate(input, context);
    }
  }, t.identity);
};