/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { version } from '@kbn/securitysolution-io-ts-types';
import { osTypeArrayOrUndefined } from '../../common/os_type';
import { tags } from '../../common/tags';
import { description } from '../../common/description';
import { name } from '../../common/name';
import { _version } from '../../common/underscore_version';
import { exceptionListType } from '../../common/exception_list';
import { id } from '../../common/id';
import { list_id } from '../../common/list_id';
import { meta } from '../../common/meta';
import { namespace_type } from '../../common/namespace_type';
export var updateExceptionListSchema = t.intersection([t.exact(t.type({
  description: description,
  name: name,
  type: exceptionListType
})), t.exact(t.partial({
  _version: _version,
  // defaults to undefined if not set during decode
  id: id,
  // defaults to undefined if not set during decode
  list_id: list_id,
  // defaults to undefined if not set during decode
  meta: meta,
  // defaults to undefined if not set during decode
  namespace_type: namespace_type,
  // defaults to 'single' if not set during decode
  os_types: osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: tags,
  // defaults to empty array if not set during decode
  version: version // defaults to undefined if not set during decode
}))]);

// This type is used after a decode since the arrays turn into defaults of empty arrays.