/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { DefaultVersionNumber } from '@kbn/securitysolution-io-ts-types';
import { name } from '../../common/name';
import { description } from '../../common/description';
import { type } from '../../common/type';
import { deserializer } from '../../common/deserializer';
import { id } from '../../common/id';
import { meta } from '../../common/meta';
import { serializer } from '../../common/serializer';
export var createListSchema = t.intersection([t.exact(t.type({
  description: description,
  name: name,
  type: type
})), t.exact(t.partial({
  deserializer: deserializer,
  // defaults to undefined if not set during decode
  id: id,
  // defaults to undefined if not set during decode
  meta: meta,
  // defaults to undefined if not set during decode
  serializer: serializer,
  // defaults to undefined if not set during decode
  version: DefaultVersionNumber // defaults to a numerical 1 if not set during decode
}))]);