/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
export var exceptionListType = t.keyof({
  detection: null,
  endpoint: null,
  endpoint_events: null,
  endpoint_host_isolation_exceptions: null
});
export var exceptionListTypeOrUndefined = t.union([exceptionListType, t.undefined]);
export var ExceptionListTypeEnum = /*#__PURE__*/function (ExceptionListTypeEnum) {
  ExceptionListTypeEnum["DETECTION"] = "detection";
  ExceptionListTypeEnum["ENDPOINT"] = "endpoint";
  ExceptionListTypeEnum["ENDPOINT_EVENTS"] = "endpoint_events";
  ExceptionListTypeEnum["ENDPOINT_HOST_ISOLATION_EXCEPTIONS"] = "endpoint_host_isolation_exceptions";
  return ExceptionListTypeEnum;
}({});