import _defineProperty from "@babel/runtime/helpers/defineProperty";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { FILTERS } from './types';
import { getPhraseScript } from './phrase_filter';
/**
 * @param filter
 * @returns `true` if a filter is a `PhrasesFilter`
 *
 * @public
 */
export var isPhrasesFilter = function isPhrasesFilter(filter) {
  var _filter$meta;
  return (filter === null || filter === void 0 ? void 0 : (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.type) === FILTERS.PHRASES;
};

/** @internal */
export var getPhrasesFilterField = function getPhrasesFilterField(filter) {
  // Phrases is a newer filter type that has always been created via a constructor that ensures
  // `meta.key` is set to the field name
  return filter.meta.key;
};

/**
 * Creates a filter where the given field matches one or more of the given values
 * params should be an array of values
 * @param field
 * @param params
 * @param indexPattern
 * @returns
 *
 * @public
 */
export var buildPhrasesFilter = function buildPhrasesFilter(field, params, indexPattern) {
  var index = indexPattern.id;
  var type = FILTERS.PHRASES;
  var key = field.name;
  var should;
  if (field.scripted) {
    should = params.map(function (v) {
      return {
        script: getPhraseScript(field, v)
      };
    });
  } else {
    should = params.map(function (v) {
      return {
        match_phrase: _defineProperty({}, field.name, v)
      };
    });
  }
  return {
    meta: {
      index: index,
      type: type,
      key: key,
      params: params
    },
    query: {
      bool: {
        should: should,
        minimum_should_match: 1
      }
    }
  };
};