/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { fromKueryExpression, toElasticsearchQuery, nodeTypes } from '../kuery';
/** @internal */
export function buildQueryFromKuery(indexPattern) {
  var queries = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var allowLeadingWildcards = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var dateFormatTZ = arguments.length > 3 ? arguments[3] : undefined;
  var filtersInMustClause = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
  var queryASTs = queries.map(function (query) {
    return fromKueryExpression(query.query, {
      allowLeadingWildcards: allowLeadingWildcards
    });
  });
  return buildQuery(indexPattern, queryASTs, {
    dateFormatTZ: dateFormatTZ,
    filtersInMustClause: filtersInMustClause
  });
}
function buildQuery(indexPattern, queryASTs) {
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var compoundQueryAST = nodeTypes["function"].buildNode('and', queryASTs);
  var kueryQuery = toElasticsearchQuery(compoundQueryAST, indexPattern, config);
  return Object.assign({
    must: [],
    filter: [],
    should: [],
    must_not: []
  }, kueryQuery.bool);
}