"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LiteralType = void 0;
var _internals = require("../internals");
var _type = require("./type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class LiteralType extends _type.Type {
  constructor(value) {
    super(_internals.internals.any().valid(value));
  }
  handleError(type, {
    value,
    valids: [expectedValue]
  }) {
    switch (type) {
      case 'any.required':
      case 'any.only':
        return `expected value to equal [${expectedValue}]`;
    }
  }
}
exports.LiteralType = LiteralType;