"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigurationFilePaths = void 0;
var _path = require("path");
var _utils = require("@kbn/utils");
var _read_argv = require("./read_argv");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// deep import to avoid loading the whole package

/**
 * Return the configuration files that needs to be loaded.
 *
 * This mimics the behavior of the `src/cli/serve/serve.js` cli script by reading
 * `-c` and `--config` options from process.argv, and fallbacks to `@kbn/utils`'s `getConfigPath()`
 */
const getConfigurationFilePaths = argv => {
  const rawPaths = (0, _read_argv.getArgValues)(argv, ['-c', '--config']);
  if (rawPaths.length) {
    return rawPaths.map(path => (0, _path.resolve)(process.cwd(), path));
  }
  const configPath = (0, _utils.getConfigPath)();

  // Pick up settings from dev.yml as well
  return [configPath, configPath.replace('kibana.yml', 'kibana.dev.yml')];
};
exports.getConfigurationFilePaths = getConfigurationFilePaths;