"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowHeightUtils = exports.AUTO_HEIGHT = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _predicate = require("../../services/predicate");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var cellPaddingsToClassMap = {
  s: 'euiDataGridRowCell--paddingSmall',
  m: '',
  l: 'euiDataGridRowCell--paddingLarge'
};
var fontSizesToClassMap = {
  s: 'euiDataGridRowCell--fontSizeSmall',
  m: '',
  l: 'euiDataGridRowCell--fontSizeLarge'
};

function getNumberFromPx(style) {
  return style ? parseInt(style.replace('px', ''), 10) : 0;
}

var AUTO_HEIGHT = 'auto';
exports.AUTO_HEIGHT = AUTO_HEIGHT;
var DEFAULT_HEIGHT = 32; // So that we use lineCount options we should know exactly row height which allow to show defined line count.
// For this we should know paddings and line height. Because of this we should compute styles for cell with grid styles

var RowHeightUtils = /*#__PURE__*/function () {
  function RowHeightUtils() {
    var _this = this;

    (0, _classCallCheck2.default)(this, RowHeightUtils);
    (0, _defineProperty2.default)(this, "styles", {
      paddingTop: 0,
      paddingBottom: 0,
      lineHeight: 1
    });
    (0, _defineProperty2.default)(this, "fakeCell", document.createElement('div'));
    (0, _defineProperty2.default)(this, "heightsCache", new Map());
    (0, _defineProperty2.default)(this, "timerId", void 0);
    (0, _defineProperty2.default)(this, "grid", void 0);
    (0, _defineProperty2.default)(this, "lastUpdatedRow", Infinity);
    (0, _defineProperty2.default)(this, "getStylesForCell", function (rowHeightsOptions, rowIndex) {
      if (_this.isAutoHeight(rowIndex, rowHeightsOptions)) {
        return {};
      }

      var initialHeight = rowHeightsOptions.rowHeights && rowHeightsOptions.rowHeights[rowIndex];

      if (!initialHeight) {
        initialHeight = rowHeightsOptions.defaultHeight;
      }

      if ((0, _predicate.isObject)(initialHeight) && initialHeight.lineCount) {
        return {
          WebkitLineClamp: initialHeight.lineCount,
          display: '-webkit-box',
          WebkitBoxOrient: 'vertical',
          height: '100%',
          overflow: 'hidden'
        };
      }

      return {
        height: '100%',
        overflow: 'hidden'
      };
    });
  }

  (0, _createClass2.default)(RowHeightUtils, [{
    key: "setRowHeight",
    value: function setRowHeight(rowIndex, colId) {
      var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : DEFAULT_HEIGHT;
      var visibleRowIndex = arguments.length > 3 ? arguments[3] : undefined;
      var rowHeights = this.heightsCache.get(rowIndex) || new Map();
      var adaptedHeight = Math.ceil(height + this.styles.paddingTop + this.styles.paddingBottom);

      if (rowHeights.get(colId) === adaptedHeight) {
        return;
      }

      rowHeights.set(colId, adaptedHeight);
      this.heightsCache.set(rowIndex, rowHeights);
      this.resetRow(visibleRowIndex);
    }
  }, {
    key: "pruneHiddenColumnHeights",
    value: function pruneHiddenColumnHeights(visibleColumns) {
      var visibleColumnIds = new Set(visibleColumns.map(function (_ref) {
        var id = _ref.id;
        return id;
      }));
      var didModify = false;
      this.heightsCache.forEach(function (rowHeights) {
        var existingColumnIds = Array.from(rowHeights.keys());
        existingColumnIds.forEach(function (existingColumnId) {
          if (visibleColumnIds.has(existingColumnId) === false) {
            didModify = true;
            rowHeights.delete(existingColumnId);
          }
        });
      });

      if (didModify) {
        this.resetRow(0);
      }
    }
  }, {
    key: "resetRow",
    value: function resetRow(visibleRowIndex) {
      var _this2 = this;

      // save the first row index of batch, reassigning it only
      // if this visible row index less than lastUpdatedRow
      this.lastUpdatedRow = Math.min(this.lastUpdatedRow, visibleRowIndex);
      clearTimeout(this.timerId);
      this.timerId = setTimeout(function () {
        return _this2.resetGrid();
      }, 0);
    }
  }, {
    key: "getRowHeight",
    value: function getRowHeight(rowIndex) {
      var rowHeights = this.heightsCache.get(rowIndex);
      if (rowHeights == null) return 0;
      var rowHeightValues = Array.from(rowHeights.values());

      if (rowHeightValues.length) {
        return Math.max.apply(Math, (0, _toConsumableArray2.default)(rowHeightValues));
      }

      return 0;
    }
  }, {
    key: "resetGrid",
    value: function resetGrid() {
      var _this$grid;

      (_this$grid = this.grid) === null || _this$grid === void 0 ? void 0 : _this$grid.resetAfterRowIndex(this.lastUpdatedRow);
      this.lastUpdatedRow = Infinity;
    }
  }, {
    key: "setGrid",
    value: function setGrid(grid) {
      this.grid = grid;
    }
  }, {
    key: "isAutoHeight",
    value: function isAutoHeight(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro;

      if ((rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : (_rowHeightsOptions$ro = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro === void 0 ? void 0 : _rowHeightsOptions$ro[rowIndex]) != null) {
        if (rowHeightsOptions.rowHeights[rowIndex] === AUTO_HEIGHT) {
          return true;
        }
      } else if ((rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight) === AUTO_HEIGHT) {
        return true;
      }

      return false;
    }
  }, {
    key: "isDefinedHeight",
    value: function isDefinedHeight(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro2;

      if (((_rowHeightsOptions$ro2 = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro2 === void 0 ? void 0 : _rowHeightsOptions$ro2[rowIndex]) || rowHeightsOptions.defaultHeight) {
        return true;
      }

      return false;
    }
  }, {
    key: "computeStylesForGridCell",
    value: function computeStylesForGridCell(gridStyles, lineHeight) {
      this.fakeCell.className = "\n      euiDataGridRowCell\n      ".concat(cellPaddingsToClassMap[gridStyles.cellPadding], "\n      ").concat(fontSizesToClassMap[gridStyles.fontSize], "\n    "); // @ts-ignore it is valid to set `lineHeight` to undefined

      this.fakeCell.style.lineHeight = lineHeight;
      document.body.appendChild(this.fakeCell);
      var allStyles = getComputedStyle(this.fakeCell);
      this.styles = {
        paddingTop: getNumberFromPx(allStyles.paddingTop),
        paddingBottom: getNumberFromPx(allStyles.paddingBottom),
        lineHeight: getNumberFromPx(allStyles.lineHeight)
      };
      document.body.removeChild(this.fakeCell);
    }
  }, {
    key: "getComputedCellStyles",
    value: function getComputedCellStyles() {
      return this.styles;
    }
  }, {
    key: "calculateHeightForLineCount",
    value: function calculateHeightForLineCount(lineCount) {
      return Math.ceil(lineCount * this.styles.lineHeight + this.styles.paddingTop + this.styles.paddingBottom);
    }
  }, {
    key: "getCalculatedHeight",
    value: function getCalculatedHeight(heightOption, defaultHeight, rowIndex) {
      if ((0, _predicate.isObject)(heightOption)) {
        if (heightOption.lineCount) {
          return this.calculateHeightForLineCount(heightOption.lineCount);
        }

        if (heightOption.height) {
          return Math.max(heightOption.height, defaultHeight);
        }
      }

      if (heightOption && (0, _predicate.isNumber)(heightOption)) {
        return Math.max(heightOption, defaultHeight);
      }

      if (heightOption === AUTO_HEIGHT && rowIndex) {
        return this.getRowHeight(rowIndex);
      }

      return defaultHeight;
    }
  }]);
  return RowHeightUtils;
}();

exports.RowHeightUtils = RowHeightUtils;