function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

import { ORIGIN } from './origin';
import { toAbsoluteUrl } from './utils';
export var AbstractEmsService = /*#__PURE__*/function () {
  function AbstractEmsService(config, emsClient, proxyPath) {
    var _this = this;
    _classCallCheck(this, AbstractEmsService);
    _defineProperty(this, "_emsClient", void 0);
    _defineProperty(this, "_config", void 0);
    _defineProperty(this, "_proxyPath", void 0);
    /**
     * Checks if url is absolute. If not, prepend the basePath.
     */
    _defineProperty(this, "_getAbsoluteUrl", function (url) {
      if (/^https?:\/\//.test(url)) {
        return url;
      } else {
        return toAbsoluteUrl(_this.getApiUrl(), url);
      }
    });
    this._config = config;
    this._emsClient = emsClient;
    this._proxyPath = proxyPath;
  }
  return _createClass(AbstractEmsService, [{
    key: "getAttributions",
    value: function getAttributions() {
      var _this2 = this;
      return this._config.attribution.map(function (attribution) {
        var url = _this2._emsClient.getValueInLanguage(attribution.url);
        var label = _this2._emsClient.getValueInLanguage(attribution.label);
        return {
          url: url,
          label: label
        };
      });
    }
  }, {
    key: "getMarkdownAttribution",
    value: function getMarkdownAttribution() {
      var _this3 = this;
      var attributions = this._config.attribution.map(function (attribution) {
        var url = _this3._emsClient.getValueInLanguage(attribution.url);
        var label = _this3._emsClient.getValueInLanguage(attribution.label);
        return "[".concat(label, "](").concat(url, ")");
      });
      return attributions.join('|');
    }
  }, {
    key: "getOrigin",
    value: function getOrigin() {
      return ORIGIN.EMS;
    }
  }]);
}();