"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.geometries = void 0;
var __1 = require("../../..");
var constants_1 = require("../../../../specs/constants");
var create_selector_1 = require("../../../../state/create_selector");
var utils_1 = require("../../../../state/utils");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var scenegraph_1 = require("./scenegraph");
var getSpecs = function (state) { return state.specs; };
var getParentDimensions = function (state) { return state.parentDimensions; };
exports.geometries = (0, create_selector_1.createCustomCachedSelector)([getSpecs, getParentDimensions], function (specs, parentDimensions) {
    var wordcloudSpecs = (0, utils_1.getSpecsFromStore)(specs, __1.ChartType.Wordcloud, constants_1.SpecType.Series);
    return wordcloudSpecs.length === 1 ? (0, scenegraph_1.render)(wordcloudSpecs[0], parentDimensions) : (0, viewmodel_types_1.nullShapeViewModel)();
});
//# sourceMappingURL=geometries.js.map