// Code generated by sdkgen. DO NOT EDIT.

// nolint
package iam

import (
	"context"

	"google.golang.org/grpc"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// RefreshTokenServiceClient is a iam.RefreshTokenServiceClient with
// lazy GRPC connection initialization.
type RefreshTokenServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// List implements iam.RefreshTokenServiceClient
func (c *RefreshTokenServiceClient) List(ctx context.Context, in *iam.ListRefreshTokensRequest, opts ...grpc.CallOption) (*iam.ListRefreshTokensResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return iam.NewRefreshTokenServiceClient(conn).List(ctx, in, opts...)
}

type RefreshTokenIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RefreshTokenServiceClient
	request *iam.ListRefreshTokensRequest

	items []*iam.RefreshToken
}

func (c *RefreshTokenServiceClient) RefreshTokenIterator(ctx context.Context, req *iam.ListRefreshTokensRequest, opts ...grpc.CallOption) *RefreshTokenIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RefreshTokenIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RefreshTokenIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.RefreshTokens
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RefreshTokenIterator) Take(size int64) ([]*iam.RefreshToken, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*iam.RefreshToken

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RefreshTokenIterator) TakeAll() ([]*iam.RefreshToken, error) {
	return it.Take(0)
}

func (it *RefreshTokenIterator) Value() *iam.RefreshToken {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RefreshTokenIterator) Error() error {
	return it.err
}

// Revoke implements iam.RefreshTokenServiceClient
func (c *RefreshTokenServiceClient) Revoke(ctx context.Context, in *iam.RevokeRefreshTokenRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return iam.NewRefreshTokenServiceClient(conn).Revoke(ctx, in, opts...)
}
